/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import java.math.BigDecimal;

@GwtIncompatible(value="No javascript support for strictfp.")
strictfp class Real
extends Number {
    private static final long serialVersionUID = 1L;
    private static final double SPLITTER;
    private final double[] values;

    public static Real add(double a, double b) {
        double x = a + b;
        double error = Real.twoSumError(a, b, x);
        return new Real(error, x);
    }

    public static Real sub(double a, double b) {
        double x = a - b;
        double error = Real.twoDiffError(a, b, x);
        return new Real(error, x);
    }

    public static Real mul(double a, double b) {
        double x = a * b;
        double bhi = Real.splitHigh(b);
        double blo = Real.splitLow(b, bhi);
        double error = Real.twoProductError(a, bhi, blo, x);
        return new Real(error, x);
    }

    public Real(double value) {
        this.values = new double[]{value};
    }

    private Real(double ... values) {
        this.values = values;
    }

    public Real add(Real that) {
        return Real.add(this, that, false);
    }

    public Real sub(Real that) {
        return Real.add(this, that, true);
    }

    private static Real add(Real a, Real b, boolean negateB) {
        double error;
        double newSum;
        double smaller;
        double bSign = negateB ? -1.0 : 1.0;
        double[] result = new double[a.values.length + b.values.length];
        int aIndex = 0;
        int bIndex = 0;
        double sum = Real.smallerMagnitude(a.values[aIndex], b.values[bIndex]) ? a.values[aIndex++] : bSign * b.values[bIndex++];
        int resultIndex = 0;
        if (aIndex < a.values.length && bIndex < b.values.length) {
            smaller = Real.smallerMagnitude(a.values[aIndex], b.values[bIndex]) ? a.values[aIndex++] : bSign * b.values[bIndex++];
            newSum = smaller + sum;
            error = Real.fastTwoSumError(smaller, sum, newSum);
            sum = newSum;
            if (error != 0.0) {
                result[resultIndex++] = error;
            }
            while (aIndex < a.values.length && bIndex < b.values.length) {
                smaller = Real.smallerMagnitude(a.values[aIndex], b.values[bIndex]) ? a.values[aIndex++] : bSign * b.values[bIndex++];
                newSum = sum + smaller;
                error = Real.twoSumError(sum, smaller, newSum);
                sum = newSum;
                if (error == 0.0) continue;
                result[resultIndex++] = error;
            }
        }
        while (aIndex < a.values.length) {
            smaller = a.values[aIndex++];
            newSum = sum + smaller;
            error = Real.twoSumError(sum, smaller, newSum);
            sum = newSum;
            if (error == 0.0) continue;
            result[resultIndex++] = error;
        }
        while (bIndex < b.values.length) {
            smaller = bSign * b.values[bIndex++];
            newSum = sum + smaller;
            error = Real.twoSumError(sum, smaller, newSum);
            sum = newSum;
            if (error == 0.0) continue;
            result[resultIndex++] = error;
        }
        if (sum != 0.0 || resultIndex == 0) {
            result[resultIndex++] = sum;
        }
        if (result.length > resultIndex) {
            result = Real.copyOf(result, resultIndex);
        }
        return new Real(result);
    }

    private static boolean smallerMagnitude(double a, double b) {
        return b > a == b > -a;
    }

    public Real mul(double scale) {
        double[] result = new double[this.values.length * 2];
        double scaleHigh = Real.splitHigh(scale);
        double scaleLow = Real.splitLow(scale, scaleHigh);
        double quotient = this.values[0] * scale;
        double error = Real.twoProductError(this.values[0], scaleHigh, scaleLow, quotient);
        int resultIndex = 0;
        if (error != 0.0) {
            result[resultIndex++] = error;
        }
        for (int i = 1; i < this.values.length; ++i) {
            double sum;
            double term = this.values[i] * scale;
            double termError = Real.twoProductError(this.values[i], scaleHigh, scaleLow, term);
            error = Real.twoSumError(quotient, termError, sum = quotient + termError);
            if (error != 0.0) {
                result[resultIndex++] = error;
            }
            if ((error = Real.fastTwoSumError(term, sum, quotient = term + sum)) == 0.0) continue;
            result[resultIndex++] = error;
        }
        if (quotient != 0.0 || resultIndex == 0) {
            result[resultIndex++] = quotient;
        }
        if (result.length > resultIndex) {
            result = Real.copyOf(result, resultIndex);
        }
        return new Real(result);
    }

    public Real negate() {
        double[] copy = new double[this.values.length];
        for (int i = this.values.length - 1; i >= 0; --i) {
            copy[i] = -this.values[i];
        }
        return new Real(copy);
    }

    public int signum() {
        double msb = this.values[this.values.length - 1];
        if (msb > 0.0) {
            return 1;
        }
        if (msb < 0.0) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return Double.toString(this.doubleValue());
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    @Override
    public long longValue() {
        return Math.round(this.doubleValue());
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public double doubleValue() {
        double sum = 0.0;
        for (double value : this.values) {
            sum += value;
        }
        return sum;
    }

    public BigDecimal bigValue() {
        BigDecimal sum = new BigDecimal(this.values[0]);
        for (int i = 1; i < this.values.length; ++i) {
            sum = sum.add(new BigDecimal(this.values[i]));
        }
        return sum.stripTrailingZeros();
    }

    private static double[] copyOf(double[] array, int newLength) {
        double[] result = new double[newLength];
        for (int i = 0; i < newLength; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    private static double fastTwoSumError(double a, double b, double x) {
        return b - (x - a);
    }

    private static double twoSumError(double a, double b, double x) {
        double error = x - a;
        return a - (x - error) + (b - error);
    }

    private static double twoDiffError(double a, double b, double x) {
        double error = a - x;
        return a - (x + error) + (error - b);
    }

    private static double splitHigh(double a) {
        double c = SPLITTER * a;
        return c - (c - a);
    }

    private static double splitLow(double a, double ahi) {
        return a - ahi;
    }

    private static double twoProductError(double a, double bhi, double blo, double x) {
        double ahi = Real.splitHigh(a);
        double alo = Real.splitLow(a, ahi);
        double err1 = x - ahi * bhi;
        double err2 = err1 - alo * bhi;
        double err3 = err2 - ahi * blo;
        return alo * blo - err3;
    }

    static {
        double epsilon = 1.0;
        while (1.0 + (epsilon *= 0.5) != 1.0) {
        }
        int mantissaBits = (int)Math.round(-Math.log(epsilon) / Math.log(2.0));
        SPLITTER = (1 << (mantissaBits + 1) / 2) + 1;
    }
}

