/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty9;

import com.google.appengine.api.users.User;
import com.google.appengine.api.users.UserService;
import com.google.appengine.api.users.UserServiceFactory;
import com.google.appengine.repackaged.com.google.common.flogger.GoogleLogger;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashSet;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.URIUtil;

public class AppEngineAuthentication {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/apphosting/runtime/jetty9/AppEngineAuthentication");
    private static final String AUTH_URL_PREFIX = "/_ah/";
    private static final String AUTH_METHOD = "Google Login";
    private static final String REALM_NAME = "Google App Engine";
    private static final String SKIP_ADMIN_CHECK_ATTR = "com.google.apphosting.internal.SkipAdminCheck";
    private static final String USER_ROLE = "*";
    private static final String ADMIN_ROLE = "admin";

    public static void configureSecurityHandler(ConstraintSecurityHandler handler) {
        AppEngineLoginService loginService = new AppEngineLoginService();
        AppEngineAuthenticator authenticator = new AppEngineAuthenticator();
        DefaultIdentityService identityService = new DefaultIdentityService();
        handler.setRoles(new HashSet<String>(Arrays.asList(USER_ROLE, ADMIN_ROLE)));
        handler.setLoginService((LoginService)loginService);
        handler.setAuthenticator((Authenticator)authenticator);
        handler.setIdentityService((IdentityService)identityService);
        authenticator.setConfiguration((Authenticator.AuthConfiguration)handler);
    }

    private static String getFullURL(HttpServletRequest request) {
        StringBuffer buffer = request.getRequestURL();
        if (request.getQueryString() != null) {
            buffer.append('?');
            buffer.append(request.getQueryString());
        }
        return buffer.toString();
    }

    public static class AppEngineUserIdentity
    implements UserIdentity {
        private final AppEnginePrincipal userPrincipal;

        public AppEngineUserIdentity(AppEnginePrincipal userPrincipal) {
            this.userPrincipal = userPrincipal;
        }

        public Subject getSubject() {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withInjectedLogSite("com/google/apphosting/runtime/jetty9/AppEngineAuthentication$AppEngineUserIdentity", "getSubject", 381, "AppEngineAuthentication.java")).log("getSubject() throwing UnsupportedOperationException.");
            throw new UnsupportedOperationException();
        }

        public Principal getUserPrincipal() {
            return this.userPrincipal;
        }

        public boolean isUserInRole(String role, UserIdentity.Scope unusedScope) {
            UserService userService = UserServiceFactory.getUserService();
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/apphosting/runtime/jetty9/AppEngineAuthentication$AppEngineUserIdentity", "isUserInRole", 393, "AppEngineAuthentication.java")).log("Checking if principal %s is in role %s", (Object)this.userPrincipal, (Object)role);
            if (this.userPrincipal == null) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withInjectedLogSite("com/google/apphosting/runtime/jetty9/AppEngineAuthentication$AppEngineUserIdentity", "isUserInRole", 395, "AppEngineAuthentication.java")).log("isUserInRole() called with null principal.");
                return false;
            }
            if (AppEngineAuthentication.USER_ROLE.equals(role)) {
                return true;
            }
            if (AppEngineAuthentication.ADMIN_ROLE.equals(role)) {
                User user = this.userPrincipal.getUser();
                if (user.equals((Object)userService.getCurrentUser())) {
                    return userService.isUserAdmin();
                }
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withInjectedLogSite("com/google/apphosting/runtime/jetty9/AppEngineAuthentication$AppEngineUserIdentity", "isUserInRole", 411, "AppEngineAuthentication.java")).log("Cannot tell if non-logged-in user %s is an admin.", user);
                return false;
            }
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/apphosting/runtime/jetty9/AppEngineAuthentication$AppEngineUserIdentity", "isUserInRole", 415, "AppEngineAuthentication.java")).log("Unknown role: %s.", role);
            return false;
        }

        public String toString() {
            String string = AppEngineUserIdentity.class.getSimpleName();
            String string2 = String.valueOf(this.userPrincipal);
            return new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("('").append(string2).append("')").toString();
        }
    }

    public static class AppEnginePrincipal
    implements Principal {
        private final User user;

        public AppEnginePrincipal(User user) {
            this.user = user;
        }

        public User getUser() {
            return this.user;
        }

        @Override
        public String getName() {
            if (this.user.getFederatedIdentity() != null && this.user.getFederatedIdentity().length() > 0) {
                return this.user.getFederatedIdentity();
            }
            return this.user.getEmail();
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof AppEnginePrincipal) {
                return this.user.equals((Object)((AppEnginePrincipal)other).user);
            }
            return false;
        }

        @Override
        public String toString() {
            return this.user.toString();
        }

        @Override
        public int hashCode() {
            return this.user.hashCode();
        }
    }

    private static class AppEngineLoginService
    implements LoginService {
        private IdentityService identityService;

        private AppEngineLoginService() {
        }

        public String getName() {
            return AppEngineAuthentication.REALM_NAME;
        }

        public UserIdentity login(String unusedUsername, Object unusedCredentials, ServletRequest unusedRequest) {
            AppEngineUserIdentity appEngineUserIdentity = this.loadUser();
            return appEngineUserIdentity;
        }

        private AppEngineUserIdentity loadUser() {
            UserService userService = UserServiceFactory.getUserService();
            User engineUser = userService.getCurrentUser();
            if (engineUser == null) {
                return null;
            }
            return new AppEngineUserIdentity(new AppEnginePrincipal(engineUser));
        }

        public IdentityService getIdentityService() {
            return this.identityService;
        }

        public void logout(UserIdentity user) {
            if (user != null) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/apphosting/runtime/jetty9/AppEngineAuthentication$AppEngineLoginService", "logout", 296, "AppEngineAuthentication.java")).log("Ignoring logout call for: %s", user);
            }
        }

        public void setIdentityService(IdentityService identityService) {
            this.identityService = identityService;
        }

        public boolean validate(UserIdentity user) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withInjectedLogSite("com/google/apphosting/runtime/jetty9/AppEngineAuthentication$AppEngineLoginService", "validate", 314, "AppEngineAuthentication.java")).log("validate(%s) throwing UnsupportedOperationException.", user);
            throw new UnsupportedOperationException();
        }
    }

    private static class AppEngineAuthenticator
    extends LoginAuthenticator {
        private AppEngineAuthenticator() {
        }

        private static boolean isLoginOrErrorPage(String uri) {
            return uri.startsWith(AppEngineAuthentication.AUTH_URL_PREFIX);
        }

        public String getAuthMethod() {
            return AppEngineAuthentication.AUTH_METHOD;
        }

        public Authentication validateRequest(ServletRequest servletRequest, ServletResponse servletResponse, boolean mandatory) throws ServerAuthException {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            if (!mandatory) {
                return new DeferredAuthentication((LoginAuthenticator)this);
            }
            String uri = URIUtil.addPaths((String)request.getServletPath(), (String)request.getPathInfo());
            if (uri == null) {
                uri = "/";
            }
            if (AppEngineAuthenticator.isLoginOrErrorPage(uri) && !DeferredAuthentication.isDeferred((HttpServletResponse)response)) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/apphosting/runtime/jetty9/AppEngineAuthentication$AppEngineAuthenticator", "validateRequest", 158, "AppEngineAuthentication.java")).log("Got %s, returning DeferredAuthentication to imply authentication is in progress.", uri);
                return new DeferredAuthentication((LoginAuthenticator)this);
            }
            if (request.getAttribute(AppEngineAuthentication.SKIP_ADMIN_CHECK_ATTR) != null) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/apphosting/runtime/jetty9/AppEngineAuthentication$AppEngineAuthenticator", "validateRequest", 165, "AppEngineAuthentication.java")).log("Returning DeferredAuthentication because of SkipAdminCheck.");
                return new DeferredAuthentication((LoginAuthenticator)this);
            }
            if (response == null) {
                throw new ServerAuthException("validateRequest called with null response!!!");
            }
            try {
                UserService userService = UserServiceFactory.getUserService();
                if (userService.isUserLoggedIn()) {
                    UserIdentity user = this._loginService.login(null, null, null);
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/apphosting/runtime/jetty9/AppEngineAuthentication$AppEngineAuthenticator", "validateRequest", 180, "AppEngineAuthentication.java")).log("authenticate() returning new principal for %s", user);
                    if (user != null) {
                        return new UserAuthentication(this.getAuthMethod(), user);
                    }
                }
                if (DeferredAuthentication.isDeferred((HttpServletResponse)response)) {
                    return Authentication.UNAUTHENTICATED;
                }
                try {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/apphosting/runtime/jetty9/AppEngineAuthentication$AppEngineAuthenticator", "validateRequest", 191, "AppEngineAuthentication.java")).log("Got %s but no one was logged in, redirecting.", request.getRequestURI());
                    String url = userService.createLoginURL(AppEngineAuthentication.getFullURL(request));
                    response.sendRedirect(url);
                    return Authentication.SEND_CONTINUE;
                }
                catch (ApiProxy.ApiProxyException ex) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(ex)).withInjectedLogSite("com/google/apphosting/runtime/jetty9/AppEngineAuthentication$AppEngineAuthenticator", "validateRequest", 199, "AppEngineAuthentication.java")).log("Could not get login URL:");
                    response.sendError(403);
                    return Authentication.SEND_FAILURE;
                }
            }
            catch (IOException ex) {
                throw new ServerAuthException((Throwable)ex);
            }
        }

        protected HttpSession renewSession(HttpServletRequest request, HttpServletResponse response) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/apphosting/runtime/jetty9/AppEngineAuthentication$AppEngineAuthenticator", "renewSession", 213, "AppEngineAuthentication.java")).log("renewSession throwing an UnsupportedOperationException");
            throw new UnsupportedOperationException();
        }

        public boolean secureResponse(ServletRequest servletRequest, ServletResponse servletResponse, boolean isAuthMandatory, Authentication.User user) {
            return true;
        }
    }
}

