/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty94;

import com.google.appengine.repackaged.com.google.common.time.TimeSource;
import com.google.apphosting.runtime.MemcacheSessionStore;
import com.google.apphosting.runtime.SessionData;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.server.session.SessionContext;
import org.eclipse.jetty.server.session.SessionDataMap;
import org.eclipse.jetty.util.component.AbstractLifeCycle;

class MemcacheSessionDataMap
extends AbstractLifeCycle
implements SessionDataMap {
    private SessionContext context;
    private MemcacheSessionStore memcacheSessionStore;

    MemcacheSessionDataMap() {
    }

    public void doStart() throws Exception {
        this.memcacheSessionStore = new MemcacheSessionStore();
    }

    public void initialize(SessionContext context) throws Exception {
        this.context = context;
    }

    public org.eclipse.jetty.server.session.SessionData load(String id) throws Exception {
        AtomicReference reference = new AtomicReference();
        AtomicReference exception = new AtomicReference();
        this.context.run(() -> {
            try {
                reference.set(this.memcacheSessionStore.getSession(id));
            }
            catch (Exception e) {
                exception.set(e);
            }
        });
        if (exception.get() != null) {
            throw (Exception)exception.get();
        }
        SessionData runtimeSession = (SessionData)reference.get();
        if (runtimeSession != null) {
            return this.appEngineToJettySessionData(id, runtimeSession);
        }
        return null;
    }

    public void store(String id, org.eclipse.jetty.server.session.SessionData data) throws Exception {
        AtomicReference exception = new AtomicReference();
        this.context.run(() -> {
            try {
                this.memcacheSessionStore.saveSession(id, this.jettySessionDataToAppEngine(data));
            }
            catch (Exception e) {
                exception.set(e);
            }
        });
        if (exception.get() != null) {
            throw (Exception)exception.get();
        }
    }

    public boolean delete(String id) throws Exception {
        this.context.run(() -> this.memcacheSessionStore.deleteSession(id));
        return true;
    }

    org.eclipse.jetty.server.session.SessionData appEngineToJettySessionData(String id, SessionData runtimeSession) {
        long now = TimeSource.system().now().toEpochMilli();
        long maxInactiveMs = 1000L * (long)this.context.getSessionHandler().getMaxInactiveInterval();
        org.eclipse.jetty.server.session.SessionData jettySession = new org.eclipse.jetty.server.session.SessionData(id, this.context.getCanonicalContextPath(), this.context.getVhost(), now, now, now, maxInactiveMs);
        jettySession.setExpiry(runtimeSession.getExpirationTime());
        jettySession.putAllAttributes(runtimeSession.getValueMap());
        return jettySession;
    }

    SessionData jettySessionDataToAppEngine(org.eclipse.jetty.server.session.SessionData session) {
        SessionData runtimeSession = new SessionData();
        runtimeSession.setExpirationTime(session.getExpiry());
        runtimeSession.setValueMap(session.getAllAttributes());
        return runtimeSession;
    }
}

