/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.labs.datastore.overlay;

import com.google.appengine.api.datastore.AsyncDatastoreService;
import com.google.appengine.api.datastore.DatastoreAttributes;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Index;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyRange;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionOptions;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

final class TransactionLinkedAsyncDatastoreServiceImpl
implements AsyncDatastoreService {
    private final AsyncDatastoreService datastore;
    private final Transaction txn;

    public TransactionLinkedAsyncDatastoreServiceImpl(AsyncDatastoreService datastore, Transaction txn) {
        this.datastore = datastore;
        this.txn = txn;
    }

    public Future<Entity> get(Key key) {
        Preconditions.checkNotNull(key);
        return this.datastore.get(this.txn, key);
    }

    public Future<Entity> get(Transaction txn, Key key) {
        throw new UnsupportedOperationException("if you want to pass a txn explicitly, don't use this class");
    }

    public Future<Map<Key, Entity>> get(Iterable<Key> keys) {
        Preconditions.checkNotNull(keys);
        return this.datastore.get(this.txn, keys);
    }

    public Future<Map<Key, Entity>> get(Transaction txn, Iterable<Key> keys) {
        throw new UnsupportedOperationException("if you want to pass a txn explicitly, don't use this class");
    }

    public Future<Key> put(Entity entity) {
        Preconditions.checkNotNull(entity);
        return this.datastore.put(this.txn, entity);
    }

    public Future<Key> put(Transaction txn, Entity entity) {
        throw new UnsupportedOperationException("if you want to pass a txn explicitly, don't use this class");
    }

    public Future<List<Key>> put(Iterable<Entity> entities) {
        Preconditions.checkNotNull(entities);
        return this.datastore.put(this.txn, entities);
    }

    public Future<List<Key>> put(Transaction txn, Iterable<Entity> entities) {
        throw new UnsupportedOperationException("if you want to pass a txn explicitly, don't use this class");
    }

    public Future<Void> delete(Key ... keys) {
        return this.datastore.delete(this.txn, keys);
    }

    public Future<Void> delete(Transaction txn, Key ... keys) {
        throw new UnsupportedOperationException("if you want to pass a txn explicitly, don't use this class");
    }

    public Future<Void> delete(Iterable<Key> keys) {
        Preconditions.checkNotNull(keys);
        return this.datastore.delete(this.txn, keys);
    }

    public Future<Void> delete(Transaction txn, Iterable<Key> keys) {
        throw new UnsupportedOperationException("if you want to pass a txn explicitly, don't use this class");
    }

    public Future<Transaction> beginTransaction() {
        return this.datastore.beginTransaction();
    }

    public Future<Transaction> beginTransaction(TransactionOptions options) {
        Preconditions.checkNotNull(options);
        return this.datastore.beginTransaction(options);
    }

    public Future<KeyRange> allocateIds(String kind, long num) {
        Preconditions.checkNotNull(kind);
        return this.datastore.allocateIds(kind, num);
    }

    public Future<KeyRange> allocateIds(Key parent, String kind, long num) {
        Preconditions.checkNotNull(parent);
        Preconditions.checkNotNull(kind);
        return this.datastore.allocateIds(parent, kind, num);
    }

    public Future<DatastoreAttributes> getDatastoreAttributes() {
        return this.datastore.getDatastoreAttributes();
    }

    public Future<Map<Index, Index.IndexState>> getIndexes() {
        return this.datastore.getIndexes();
    }

    public PreparedQuery prepare(Query query) {
        Preconditions.checkNotNull(query);
        return this.datastore.prepare(this.txn, query);
    }

    public PreparedQuery prepare(Transaction txn, Query query) {
        throw new UnsupportedOperationException("if you want to pass a txn explicitly, don't use this class");
    }

    public Transaction getCurrentTransaction() {
        return this.datastore.getCurrentTransaction();
    }

    public Transaction getCurrentTransaction(Transaction returnedIfNoTxn) {
        return this.datastore.getCurrentTransaction(returnedIfNoTxn);
    }

    public Collection<Transaction> getActiveTransactions() {
        return this.datastore.getActiveTransactions();
    }
}

