/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus.query;

import com.google.appengine.datanucleus.DatastoreManager;
import com.google.appengine.datanucleus.MetaDataUtils;
import com.google.appengine.datanucleus.query.DatastoreQuery;
import com.google.appengine.datanucleus.query.QueryData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusFatalUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.query.evaluator.JPQLEvaluator;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.Extent;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.store.query.AbstractJPQLQuery;
import org.datanucleus.store.query.AbstractJavaQuery;
import org.datanucleus.store.query.AbstractQueryResult;
import org.datanucleus.store.query.CandidateIdsQueryResult;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryInvalidParametersException;
import org.datanucleus.util.NucleusLogger;

public class JPQLQuery
extends AbstractJPQLQuery {
    private final DatastoreQuery datastoreQuery = new DatastoreQuery((AbstractJavaQuery)this);

    public JPQLQuery(StoreManager storeMgr, ExecutionContext ec) {
        this(storeMgr, ec, (JPQLQuery)null);
    }

    public JPQLQuery(StoreManager storeMgr, ExecutionContext ec, JPQLQuery q) {
        super(storeMgr, ec, (AbstractJPQLQuery)q);
    }

    public JPQLQuery(StoreManager storeMgr, ExecutionContext ec, String query) {
        super(storeMgr, ec, query);
    }

    protected boolean evaluateInMemory() {
        if (this.candidateCollection != null || this.candidateExtent != null) {
            if (this.compilation != null && this.compilation.getSubqueryAliases() != null) {
                NucleusLogger.QUERY.warn((Object)"In-memory evaluator doesn't currently handle subqueries completely so evaluating in datastore");
                return false;
            }
            Object val = this.getExtension("datanucleus.query.evaluateInMemory");
            if (val == null) {
                return true;
            }
            return Boolean.valueOf((String)val);
        }
        return super.evaluateInMemory();
    }

    protected Object performExecute(Map parameters) {
        List cachedResults;
        if (this.type == 1) {
            throw new NucleusFatalUserException("Bulk Update statements are not supported.");
        }
        long startTime = System.currentTimeMillis();
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021046", (Object)"JPQL", (Object)this.getSingleStringQuery(), null));
        }
        if (this.type == 1) {
            throw new NucleusException("JPQL Bulk UPDATE is not yet supported");
        }
        if (this.candidateCollection == null && this.candidateExtent == null && this.type == 0 && this.resultClass == null && this.result == null && (cachedResults = this.getQueryManager().getDatastoreQueryResult((Query)this, parameters)) != null) {
            return new CandidateIdsQueryResult((Query)this, cachedResults);
        }
        Object results = null;
        if (this.evaluateInMemory()) {
            ArrayList candidates = null;
            if (this.candidateCollection != null) {
                candidates = new ArrayList(this.candidateCollection);
            } else if (this.candidateExtent != null) {
                candidates = new ArrayList();
                Iterator iter = this.candidateExtent.iterator();
                while (iter.hasNext()) {
                    candidates.add(iter.next());
                }
            } else {
                Extent ext = this.getStoreManager().getExtent(this.ec, this.candidateClass, this.subclasses);
                candidates = new ArrayList();
                Iterator iter = ext.iterator();
                while (iter.hasNext()) {
                    candidates.add(iter.next());
                }
            }
            JPQLEvaluator resultMapper = new JPQLEvaluator((Query)this, candidates, this.compilation, parameters, this.ec.getClassLoaderResolver());
            results = resultMapper.execute(true, true, true, true, true);
        } else {
            boolean resultInMemory;
            boolean inmemoryWhenUnsupported = this.getEvaluateInMemoryWhenUnsupported();
            QueryData qd = this.datastoreQuery.compile(this.compilation, parameters, inmemoryWhenUnsupported);
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)("Query compiled as : " + qd.getDatastoreQueryAsString()));
            }
            results = this.datastoreQuery.performExecute(qd);
            boolean filterInMemory = false;
            boolean orderInMemory = false;
            boolean bl = resultInMemory = this.result != null || this.grouping != null || this.having != null || this.resultClass != null;
            if (inmemoryWhenUnsupported) {
                boolean bl2 = filterInMemory = !this.datastoreQuery.isFilterComplete();
                if (this.ordering != null) {
                    if (filterInMemory) {
                        orderInMemory = true;
                    } else if (!this.datastoreQuery.isOrderComplete()) {
                        orderInMemory = true;
                    }
                }
            }
            if (filterInMemory || resultInMemory || orderInMemory) {
                JPQLEvaluator resultMapper = new JPQLEvaluator((Query)this, (Collection)((List)results), this.compilation, parameters, this.ec.getClassLoaderResolver());
                results = resultMapper.execute(filterInMemory, orderInMemory, resultInMemory, this.resultClass != null, false);
            }
            if (results instanceof AbstractQueryResult) {
                final AbstractQueryResult qr = (AbstractQueryResult)results;
                final ManagedConnection mconn = this.getStoreManager().getConnection(this.ec);
                ManagedConnectionResourceListener listener = new ManagedConnectionResourceListener(){

                    public void managedConnectionPreClose() {
                        qr.disconnect();
                    }

                    public void managedConnectionPostClose() {
                    }

                    public void resourcePostClose() {
                        mconn.removeListener((ManagedConnectionResourceListener)this);
                    }

                    public void transactionFlushed() {
                    }

                    public void transactionPreClose() {
                        qr.disconnect();
                    }
                };
                mconn.addListener(listener);
                qr.addConnectionListener(listener);
            }
        }
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021074", (Object)"JPQL", (Object)("" + (System.currentTimeMillis() - startTime))));
        }
        return results;
    }

    boolean getEvaluateInMemoryWhenUnsupported() {
        boolean inmemory = this.storeMgr.getBooleanProperty("datanucleus.appengine.query.inMemoryWhenUnsupported");
        return this.getBooleanExtensionProperty("gae.inmemory-when-unsupported", inmemory);
    }

    DatastoreQuery getDatastoreQuery() {
        return this.datastoreQuery;
    }

    protected boolean supportsTimeout() {
        return true;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    protected void checkParameterTypesAgainstCompilation(Map parameterValues) {
    }

    protected void applyImplicitParameterValueToCompilation(String name, Object value) {
        try {
            super.applyImplicitParameterValueToCompilation(name, value);
        }
        catch (QueryInvalidParametersException queryInvalidParametersException) {
            // empty catch block
        }
    }

    public void setSubclasses(boolean subclasses) {
        if (subclasses) {
            DatastoreManager storeMgr = (DatastoreManager)this.ec.getStoreManager();
            ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
            AbstractClassMetaData acmd = storeMgr.getMetaDataManager().getMetaDataForClass(this.getCandidateClass(), clr);
            if (!MetaDataUtils.isNewOrSuperclassTableInheritanceStrategy(acmd)) {
                throw new NucleusFatalUserException("The App Engine datastore only supports queries that return subclass entities with the SINGLE_TABLE interitance mapping strategy.");
            }
        }
        super.setSubclasses(subclasses);
    }
}

