/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.StringTokenizer;
import org.datanucleus.enhancer.RuntimeEnhancer;
import org.datanucleus.util.StringUtils;

public class DataNucleusClassFileTransformer
implements ClassFileTransformer {
    protected RuntimeEnhancer enhancer = new RuntimeEnhancer();
    protected String arguments;

    public DataNucleusClassFileTransformer() {
    }

    public DataNucleusClassFileTransformer(String arguments) {
        this.arguments = arguments;
    }

    public static void premain(String agentArguments, Instrumentation instrumentation) {
        instrumentation.addTransformer(new DataNucleusClassFileTransformer(agentArguments));
    }

    public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        String name = StringUtils.replaceAll((String)className, (String)"/", (String)".");
        if (name.startsWith("java.")) {
            return null;
        }
        if (name.startsWith("javax.")) {
            return null;
        }
        if (name.startsWith("org.datanucleus.") && !name.startsWith("org.datanucleus.samples") && !name.startsWith("org.datanucleus.test")) {
            return null;
        }
        if (this.arguments != null) {
            StringTokenizer tokeniser = new StringTokenizer(this.arguments, ",");
            while (tokeniser.hasMoreTokens()) {
                String token = tokeniser.nextToken();
                if (!name.startsWith(token)) continue;
                return this.enhancer.enhance(name, classfileBuffer, loader);
            }
            return null;
        }
        return this.enhancer.enhance(name, classfileBuffer, loader);
    }
}

