/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.seqno;

import com.carrotsearch.hppc.ObjectLongMap;
import java.util.Set;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.seqno.GlobalCheckpointTracker;
import org.elasticsearch.index.seqno.LocalCheckpointTracker;
import org.elasticsearch.index.seqno.SeqNoStats;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ReplicationGroup;
import org.elasticsearch.index.shard.ShardId;

public class SequenceNumbersService
extends AbstractIndexShardComponent {
    private final LocalCheckpointTracker localCheckpointTracker;
    private final GlobalCheckpointTracker globalCheckpointTracker;

    public SequenceNumbersService(ShardId shardId, String allocationId, IndexSettings indexSettings, long maxSeqNo, long localCheckpoint, long globalCheckpoint) {
        super(shardId, indexSettings);
        this.localCheckpointTracker = new LocalCheckpointTracker(maxSeqNo, localCheckpoint);
        this.globalCheckpointTracker = new GlobalCheckpointTracker(shardId, allocationId, indexSettings, globalCheckpoint);
    }

    public final long generateSeqNo() {
        return this.localCheckpointTracker.generateSeqNo();
    }

    public long getMaxSeqNo() {
        return this.localCheckpointTracker.getMaxSeqNo();
    }

    public void waitForOpsToComplete(long seqNo) throws InterruptedException {
        this.localCheckpointTracker.waitForOpsToComplete(seqNo);
    }

    public void markSeqNoAsCompleted(long seqNo) {
        this.localCheckpointTracker.markSeqNoAsCompleted(seqNo);
    }

    public void resetLocalCheckpoint(long localCheckpoint) {
        this.localCheckpointTracker.resetCheckpoint(localCheckpoint);
    }

    public SeqNoStats stats() {
        return this.localCheckpointTracker.getStats(this.getGlobalCheckpoint());
    }

    public void updateLocalCheckpointForShard(String allocationId, long checkpoint) {
        this.globalCheckpointTracker.updateLocalCheckpoint(allocationId, checkpoint);
    }

    public void updateGlobalCheckpointForShard(String allocationId, long globalCheckpoint) {
        this.globalCheckpointTracker.updateGlobalCheckpointForShard(allocationId, globalCheckpoint);
    }

    public ObjectLongMap<String> getInSyncGlobalCheckpoints() {
        return this.globalCheckpointTracker.getInSyncGlobalCheckpoints();
    }

    public void initiateTracking(String allocationId) {
        this.globalCheckpointTracker.initiateTracking(allocationId);
    }

    public void markAllocationIdAsInSync(String allocationId, long localCheckpoint) throws InterruptedException {
        this.globalCheckpointTracker.markAllocationIdAsInSync(allocationId, localCheckpoint);
    }

    public long getLocalCheckpoint() {
        return this.localCheckpointTracker.getCheckpoint();
    }

    public ReplicationGroup getReplicationGroup() {
        return this.globalCheckpointTracker.getReplicationGroup();
    }

    public long getGlobalCheckpoint() {
        return this.globalCheckpointTracker.getGlobalCheckpoint();
    }

    public void updateGlobalCheckpointOnReplica(long globalCheckpoint, String reason) {
        this.globalCheckpointTracker.updateGlobalCheckpointOnReplica(globalCheckpoint, reason);
    }

    public synchronized long getTrackedLocalCheckpointForShard(String allocationId) {
        return this.globalCheckpointTracker.getTrackedLocalCheckpointForShard(allocationId).getLocalCheckpoint();
    }

    public void activatePrimaryMode(long localCheckpoint) {
        this.globalCheckpointTracker.activatePrimaryMode(localCheckpoint);
    }

    public void updateAllocationIdsFromMaster(long applyingClusterStateVersion, Set<String> inSyncAllocationIds, IndexShardRoutingTable routingTable, Set<String> pre60AllocationIds) {
        this.globalCheckpointTracker.updateFromMaster(applyingClusterStateVersion, inSyncAllocationIds, routingTable, pre60AllocationIds);
    }

    public void activateWithPrimaryContext(GlobalCheckpointTracker.PrimaryContext primaryContext) {
        this.globalCheckpointTracker.activateWithPrimaryContext(primaryContext);
    }

    public boolean pendingInSync() {
        return this.globalCheckpointTracker.pendingInSync();
    }

    public GlobalCheckpointTracker.PrimaryContext startRelocationHandoff() {
        return this.globalCheckpointTracker.startRelocationHandoff();
    }

    public void completeRelocationHandoff() {
        this.globalCheckpointTracker.completeRelocationHandoff();
    }

    public void abortRelocationHandoff() {
        this.globalCheckpointTracker.abortRelocationHandoff();
    }
}

