/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.codes;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.FragmentKey;
import com.github.mustachejava.Iteration;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.TemplateContext;
import com.github.mustachejava.TemplateFunction;
import com.github.mustachejava.codes.DefaultCode;
import com.github.mustachejava.util.InternalArrayList;
import com.github.mustachejava.util.LatchedWriter;
import com.github.mustachejava.util.Node;
import com.github.mustachejava.util.NodeValue;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public class IterableCode
extends DefaultCode
implements Iteration {
    private final ExecutorService les;

    public IterableCode(TemplateContext tc, DefaultMustacheFactory df, Mustache mustache, String variable, String type) {
        super(tc, df, mustache, variable, type);
        this.les = df.getExecutorService();
    }

    public IterableCode(TemplateContext tc, DefaultMustacheFactory df, Mustache mustache, String variable) {
        this(tc, df, mustache, variable, "#");
    }

    @Override
    public Writer execute(Writer writer, List<Object> scopes) {
        Object resolved = this.get(scopes);
        writer = this.handle(writer, resolved, scopes);
        this.appendText(writer);
        return writer;
    }

    protected Writer handle(Writer writer, Object resolved, List<Object> scopes) {
        if (resolved != null) {
            writer = resolved instanceof Function ? this.handleFunction(writer, (Function)resolved, scopes) : (resolved instanceof Callable ? this.handleCallable(writer, (Callable)resolved, scopes) : this.execute(writer, resolved, scopes));
        }
        return writer;
    }

    protected Writer handleCallable(Writer writer, Callable callable, List<Object> scopes) {
        if (this.les == null) {
            try {
                writer = this.execute(writer, callable.call(), scopes);
            }
            catch (Exception e) {
                throw new MustacheException(e);
            }
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            throw new MustacheException("Failed to flush writer", e);
        }
        Writer originalWriter = writer;
        LatchedWriter latchedWriter = new LatchedWriter(writer);
        writer = latchedWriter;
        InternalArrayList<Object> newScopes = new InternalArrayList<Object>(scopes);
        this.les.execute(() -> {
            try {
                Object call = callable.call();
                Writer subWriter = this.handle(originalWriter, call, newScopes);
                if (subWriter instanceof LatchedWriter) {
                    ((LatchedWriter)subWriter).await();
                }
                latchedWriter.done();
            }
            catch (Throwable e) {
                latchedWriter.failed(e);
            }
        });
        return writer;
    }

    protected Writer handleFunction(Writer writer, Function function, List<Object> scopes) {
        StringWriter sw = new StringWriter();
        this.runIdentity(sw);
        if (function instanceof TemplateFunction) {
            Object newtemplate = function.apply(sw.toString());
            if (newtemplate != null) {
                String templateText = newtemplate.toString();
                writer = this.writeTemplate(writer, templateText, scopes);
            }
        } else {
            try {
                StringWriter capture = new StringWriter();
                this.writeTemplate(capture, sw.toString(), scopes).close();
                Object apply = function.apply(capture.toString());
                if (apply != null) {
                    writer.write(apply.toString());
                }
            }
            catch (IOException e) {
                throw new MustacheException("Failed to write function result", e);
            }
        }
        return writer;
    }

    protected Writer writeTemplate(Writer writer, String templateText, List<Object> scopes) {
        return this.df.getFragment(new FragmentKey(this.tc, templateText)).execute(writer, scopes);
    }

    protected Writer execute(Writer writer, Object resolve, List<Object> scopes) {
        return this.oh.iterate(this, writer, resolve, scopes);
    }

    @Override
    public Writer next(Writer writer, Object next, List<Object> scopes) {
        boolean added = this.addScope(scopes, next);
        writer = this.run(writer, scopes);
        if (added) {
            scopes.remove(scopes.size() - 1);
        }
        return writer;
    }

    @Override
    public Node invert(Node node, String text, AtomicInteger position) {
        Node invert;
        int start = position.get();
        ArrayList<Node> nodes = new ArrayList<Node>();
        while ((invert = this.mustache.invert(new Node(), text, position)) != null) {
            nodes.add(invert);
        }
        node.put(this.name, NodeValue.list(nodes));
        return this.matchAppended(node, text, position, start);
    }
}

