/*
 * Decompiled with CFR 0.152.
 */
package com.bfo.json;

import com.bfo.json.Json;
import java.util.Collection;

public class JsonWriteOptions {
    private String floatformat = "%.4s";
    private String doubleformat = "%.8s";
    private boolean pretty;
    private boolean allownan;
    private boolean sorted;
    private boolean nfc;
    private Filter filter;

    public JsonWriteOptions setFloatFormat(String format) {
        this.floatformat = format;
        return this;
    }

    public JsonWriteOptions setDoubleFormat(String format) {
        this.doubleformat = format;
        return this;
    }

    public JsonWriteOptions setAllowNaN(boolean nan) {
        this.allownan = nan;
        return this;
    }

    public JsonWriteOptions setPretty(boolean pretty) {
        this.pretty = pretty;
        return this;
    }

    public JsonWriteOptions setSorted(boolean sorted) {
        this.sorted = sorted;
        return this;
    }

    public JsonWriteOptions setNFC(boolean nfc) {
        this.nfc = nfc;
        return this;
    }

    public boolean isNFC() {
        return this.nfc;
    }

    public boolean isPretty() {
        return this.pretty;
    }

    public JsonWriteOptions setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public String floatFormat() {
        return this.floatformat;
    }

    public String doubleFormat() {
        return this.doubleformat;
    }

    public boolean isAllowNaN() {
        return this.allownan;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public static Filter createNodeSetFilter(final Collection<Json> set, final boolean include) {
        return new Filter(){
            int depth;
            int okdepth;

            @Override
            public void initialize(Json context) {
                this.depth = 0;
                this.okdepth = Integer.MAX_VALUE;
            }

            @Override
            public Json enter(String key, Json child) {
                ++this.depth;
                if (this.depth > this.okdepth) {
                    return child;
                }
                if (set.contains(child) == include) {
                    this.okdepth = this.depth;
                    return child;
                }
                return null;
            }

            @Override
            public void exit(String key, Json child) {
                if (this.depth-- == this.okdepth) {
                    this.okdepth = Integer.MAX_VALUE;
                }
            }
        };
    }

    public static interface Filter {
        public void initialize(Json var1);

        public Json enter(String var1, Json var2);

        public void exit(String var1, Json var2);
    }
}

