/*!
 * jQuery JavaScript Library v1.8.2
 * http://jquery.com/
 *
 * Includes Sizzle.js
 * http://sizzlejs.com/
 *
 * Copyright 2012 jQuery Foundation and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: Thu Sep 20 2012 21:13:05 GMT-0400 (Eastern Daylight Time)
 */
(function( window, undefined ) {
var
	// A central reference to the root jQuery(document)
	rootjQuery,

	// The deferred used on DOM ready
	readyList,

	// Use the correct document accordingly with window argument (sandbox)
	document = window.document,
	location = window.location,
	navigator = window.navigator,

	// Map over jQuery in case of overwrite
	_jQuery = window.jQuery,

	// Map over the $ in case of overwrite
	_$ = window.$,

	// Save a reference to some core methods
	core_push = Array.prototype.push,
	core_slice = Array.prototype.slice,
	core_indexOf = Array.prototype.indexOf,
	core_toString = Object.prototype.toString,
	core_hasOwn = Object.prototype.hasOwnProperty,
	core_trim = String.prototype.trim,

	// Define a local copy of jQuery
	jQuery = function( selector, context ) {
		// The jQuery object is actually just the init constructor 'enhanced'
		return new jQuery.fn.init( selector, context, rootjQuery );
	},

	// Used for matching numbers
	core_pnum = /[\-+]?(?:\d*\.|)\d+(?:[eE][\-+]?\d+|)/.source,

	// Used for detecting and trimming whitespace
	core_rnotwhite = /\S/,
	core_rspace = /\s+/,

	// Make sure we trim BOM and NBSP (here's looking at you, Safari 5.0 and IE)
	rtrim = /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,

	// A simple way to check for HTML strings
	// Prioritize #id over <tag> to avoid XSS via location.hash (#9521)
	rquickExpr = /^(?:[^#<]*(<[\w\W]+>)[^>]*$|#([\w\-]*)$)/,

	// Match a standalone tag
	rsingleTag = /^<(\w+)\s*\/?>(?:<\/\1>|)$/,

	// JSON RegExp
	rvalidchars = /^[\],:{}\s]*$/,
	rvalidbraces = /(?:^|:|,)(?:\s*\[)+/g,
	rvalidescape = /\\(?:["\\\/bfnrt]|u[\da-fA-F]{4})/g,
	rvalidtokens = /"[^"\\\r\n]*"|true|false|null|-?(?:\d\d*\.|)\d+(?:[eE][\-+]?\d+|)/g,

	// Matches dashed string for camelizing
	rmsPrefix = /^-ms-/,
	rdashAlpha = /-([\da-z])/gi,

	// Used by jQuery.camelCase as callback to replace()
	fcamelCase = function( all, letter ) {
		return ( letter + "" ).toUpperCase();
	},

	// The ready event handler and self cleanup method
	DOMContentLoaded = function() {
		if ( document.addEventListener ) {
			document.removeEventListener( "DOMContentLoaded", DOMContentLoaded, false );
			jQuery.ready();
		} else if ( document.readyState === "complete" ) {
			// we're here because readyState === "complete" in oldIE
			// which is good enough for us to call the dom ready!
			document.detachEvent( "onreadystatechange", DOMContentLoaded );
			jQuery.ready();
		}
	},

	// [[Class]] -> type pairs
	class2type = {};

jQuery.fn = jQuery.prototype = {
	constructor: jQuery,
	init: function( selector, context, rootjQuery ) {
		var match, elem, ret, doc;

		// Handle $(""), $(null), $(undefined), $(false)
		if ( !selector ) {
			return this;
		}

		// Handle $(DOMElement)
		if ( selector.nodeType ) {
			this.context = this[0] = selector;
			this.length = 1;
			return this;
		}

		// Handle HTML strings
		if ( typeof selector === "string" ) {
			if ( selector.charAt(0) === "<" && selector.charAt( selector.length - 1 ) === ">" && selector.length >= 3 ) {
				// Assume that strings that start and end with <> are HTML and skip the regex check
				match = [ null, selector, null ];

			} else {
				match = rquickExpr.exec( selector );
			}

			// Match html or make sure no context is specified for #id
			if ( match && (match[1] || !context) ) {

				// HANDLE: $(html) -> $(array)
				if ( match[1] ) {
					context = context instanceof jQuery ? context[0] : context;
					doc = ( context && context.nodeType ? context.ownerDocument || context : document );

					// scripts is true for back-compat
					selector = jQuery.parseHTML( match[1], doc, true );
					if ( rsingleTag.test( match[1] ) && jQuery.isPlainObject( context ) ) {
						this.attr.call( selector, context, true );
					}

					return jQuery.merge( this, selector );

				// HANDLE: $(#id)
				} else {
					elem = document.getElementById( match[2] );

					// Check parentNode to catch when Blackberry 4.6 returns
					// nodes that are no longer in the document #6963
					if ( elem && elem.parentNode ) {
						// Handle the case where IE and Opera return items
						// by name instead of ID
						if ( elem.id !== match[2] ) {
							return rootjQuery.find( selector );
						}

						// Otherwise, we inject the element directly into the jQuery object
						this.length = 1;
						this[0] = elem;
					}

					this.context = document;
					this.selector = selector;
					return this;
				}

			// HANDLE: $(expr, $(...))
			} else if ( !context || context.jquery ) {
				return ( context || rootjQuery ).find( selector );

			// HANDLE: $(expr, context)
			// (which is just equivalent to: $(context).find(expr)
			} else {
				return this.constructor( context ).find( selector );
			}

		// HANDLE: $(function)
		// Shortcut for document ready
		} else if ( jQuery.isFunction( selector ) ) {
			return rootjQuery.ready( selector );
		}

		if ( selector.selector !== undefined ) {
			this.selector = selector.selector;
			this.context = selector.context;
		}

		return jQuery.makeArray( selector, this );
	},

	// Start with an empty selector
	selector: "",

	// The current version of jQuery being used
	jquery: "1.8.2",

	// The default length of a jQuery object is 0
	length: 0,

	// The number of elements contained in the matched element set
	size: function() {
		return this.length;
	},

	toArray: function() {
		return core_slice.call( this );
	},

	// Get the Nth element in the matched element set OR
	// Get the whole matched element set as a clean array
	get: function( num ) {
		return num == null ?

			// Return a 'clean' array
			this.toArray() :

			// Return just the object
			( num < 0 ? this[ this.length + num ] : this[ num ] );
	},

	// Take an array of elements and push it onto the stack
	// (returning the new matched element set)
	pushStack: function( elems, name, selector ) {

		// Build a new jQuery matched element set
		var ret = jQuery.merge( this.constructor(), elems );

		// Add the old object onto the stack (as a reference)
		ret.prevObject = this;

		ret.context = this.context;

		if ( name === "find" ) {
			ret.selector = this.selector + ( this.selector ? " " : "" ) + selector;
		} else if ( name ) {
			ret.selector = this.selector + "." + name + "(" + selector + ")";
		}

		// Return the newly-formed element set
		return ret;
	},

	// Execute a callback for every element in the matched set.
	// (You can seed the arguments with an array of args, but this is
	// only used internally.)
	each: function( callback, args ) {
		return jQuery.each( this, callback, args );
	},

	ready: function( fn ) {
		// Add the callback
		jQuery.ready.promise().done( fn );

		return this;
	},

	eq: function( i ) {
		i = +i;
		return i === -1 ?
			this.slice( i ) :
			this.slice( i, i + 1 );
	},

	first: function() {
		return this.eq( 0 );
	},

	last: function() {
		return this.eq( -1 );
	},

	slice: function() {
		return this.pushStack( core_slice.apply( this, arguments ),
			"slice", core_slice.call(arguments).join(",") );
	},

	map: function( callback ) {
		return this.pushStack( jQuery.map(this, function( elem, i ) {
			return callback.call( elem, i, elem );
		}));
	},

	end: function() {
		return this.prevObject || this.constructor(null);
	},

	// For internal use only.
	// Behaves like an Array's method, not like a jQuery method.
	push: core_push,
	sort: [].sort,
	splice: [].splice
};

// Give the init function the jQuery prototype for later instantiation
jQuery.fn.init.prototype = jQuery.fn;

jQuery.extend = jQuery.fn.extend = function() {
	var options, name, src, copy, copyIsArray, clone,
		target = arguments[0] || {},
		i = 1,
		length = arguments.length,
		deep = false;

	// Handle a deep copy situation
	if ( typeof target === "boolean" ) {
		deep = target;
		target = arguments[1] || {};
		// skip the boolean and the target
		i = 2;
	}

	// Handle case when target is a string or something (possible in deep copy)
	if ( typeof target !== "object" && !jQuery.isFunction(target) ) {
		target = {};
	}

	// extend jQuery itself if only one argument is passed
	if ( length === i ) {
		target = this;
		--i;
	}

	for ( ; i < length; i++ ) {
		// Only deal with non-null/undefined values
		if ( (options = arguments[ i ]) != null ) {
			// Extend the base object
			for ( name in options ) {
				src = target[ name ];
				copy = options[ name ];

				// Prevent never-ending loop
				if ( target === copy ) {
					continue;
				}

				// Recurse if we're merging plain objects or arrays
				if ( deep && copy && ( jQuery.isPlainObject(copy) || (copyIsArray = jQuery.isArray(copy)) ) ) {
					if ( copyIsArray ) {
						copyIsArray = false;
						clone = src && jQuery.isArray(src) ? src : [];

					} else {
						clone = src && jQuery.isPlainObject(src) ? src : {};
					}

					// Never move original objects, clone them
					target[ name ] = jQuery.extend( deep, clone, copy );

				// Don't bring in undefined values
				} else if ( copy !== undefined ) {
					target[ name ] = copy;
				}
			}
		}
	}

	// Return the modified object
	return target;
};

jQuery.extend({
	noConflict: function( deep ) {
		if ( window.$ === jQuery ) {
			window.$ = _$;
		}

		if ( deep && window.jQuery === jQuery ) {
			window.jQuery = _jQuery;
		}

		return jQuery;
	},

	// Is the DOM ready to be used? Set to true once it occurs.
	isReady: false,

	// A counter to track how many items to wait for before
	// the ready event fires. See #6781
	readyWait: 1,

	// Hold (or release) the ready event
	holdReady: function( hold ) {
		if ( hold ) {
			jQuery.readyWait++;
		} else {
			jQuery.ready( true );
		}
	},

	// Handle when the DOM is ready
	ready: function( wait ) {

		// Abort if there are pending holds or we're already ready
		if ( wait === true ? --jQuery.readyWait : jQuery.isReady ) {
			return;
		}

		// Make sure body exists, at least, in case IE gets a little overzealous (ticket #5443).
		if ( !document.body ) {
			return setTimeout( jQuery.ready, 1 );
		}

		// Remember that the DOM is ready
		jQuery.isReady = true;

		// If a normal DOM Ready event fired, decrement, and wait if need be
		if ( wait !== true && --jQuery.readyWait > 0 ) {
			return;
		}

		// If there are functions bound, to execute
		readyList.resolveWith( document, [ jQuery ] );

		// Trigger any bound ready events
		if ( jQuery.fn.trigger ) {
			jQuery( document ).trigger("ready").off("ready");
		}
	},

	// See test/unit/core.js for details concerning isFunction.
	// Since version 1.3, DOM methods and functions like alert
	// aren't supported. They return false on IE (#2968).
	isFunction: function( obj ) {
		return jQuery.type(obj) === "function";
	},

	isArray: Array.isArray || function( obj ) {
		return jQuery.type(obj) === "array";
	},

	isWindow: function( obj ) {
		return obj != null && obj == obj.window;
	},

	isNumeric: function( obj ) {
		return !isNaN( parseFloat(obj) ) && isFinite( obj );
	},

	type: function( obj ) {
		return obj == null ?
			String( obj ) :
			class2type[ core_toString.call(obj) ] || "object";
	},

	isPlainObject: function( obj ) {
		// Must be an Object.
		// Because of IE, we also have to check the presence of the constructor property.
		// Make sure that DOM nodes and window objects don't pass through, as well
		if ( !obj || jQuery.type(obj) !== "object" || obj.nodeType || jQuery.isWindow( obj ) ) {
			return false;
		}

		try {
			// Not own constructor property must be Object
			if ( obj.constructor &&
				!core_hasOwn.call(obj, "constructor") &&
				!core_hasOwn.call(obj.constructor.prototype, "isPrototypeOf") ) {
				return false;
			}
		} catch ( e ) {
			// IE8,9 Will throw exceptions on certain host objects #9897
			return false;
		}

		// Own properties are enumerated firstly, so to speed up,
		// if last one is own, then all properties are own.

		var key;
		for ( key in obj ) {}

		return key === undefined || core_hasOwn.call( obj, key );
	},

	isEmptyObject: function( obj ) {
		var name;
		for ( name in obj ) {
			return false;
		}
		return true;
	},

	error: function( msg ) {
		throw new Error( msg );
	},

	// data: string of html
	// context (optional): If specified, the fragment will be created in this context, defaults to document
	// scripts (optional): If true, will include scripts passed in the html string
	parseHTML: function( data, context, scripts ) {
		var parsed;
		if ( !data || typeof data !== "string" ) {
			return null;
		}
		if ( typeof context === "boolean" ) {
			scripts = context;
			context = 0;
		}
		context = context || document;

		// Single tag
		if ( (parsed = rsingleTag.exec( data )) ) {
			return [ context.createElement( parsed[1] ) ];
		}

		parsed = jQuery.buildFragment( [ data ], context, scripts ? null : [] );
		return jQuery.merge( [],
			(parsed.cacheable ? jQuery.clone( parsed.fragment ) : parsed.fragment).childNodes );
	},

	parseJSON: function( data ) {
		if ( !data || typeof data !== "string") {
			return null;
		}

		// Make sure leading/trailing whitespace is removed (IE can't handle it)
		data = jQuery.trim( data );

		// Attempt to parse using the native JSON parser first
		if ( window.JSON && window.JSON.parse ) {
			return window.JSON.parse( data );
		}

		// Make sure the incoming data is actual JSON
		// Logic borrowed from http://json.org/json2.js
		if ( rvalidchars.test( data.replace( rvalidescape, "@" )
			.replace( rvalidtokens, "]" )
			.replace( rvalidbraces, "")) ) {

			return ( new Function( "return " + data ) )();

		}
		jQuery.error( "Invalid JSON: " + data );
	},

	// Cross-browser xml parsing
	parseXML: function( data ) {
		var xml, tmp;
		if ( !data || typeof data !== "string" ) {
			return null;
		}
		try {
			if ( window.DOMParser ) { // Standard
				tmp = new DOMParser();
				xml = tmp.parseFromString( data , "text/xml" );
			} else { // IE
				xml = new ActiveXObject( "Microsoft.XMLDOM" );
				xml.async = "false";
				xml.loadXML( data );
			}
		} catch( e ) {
			xml = undefined;
		}
		if ( !xml || !xml.documentElement || xml.getElementsByTagName( "parsererror" ).length ) {
			jQuery.error( "Invalid XML: " + data );
		}
		return xml;
	},

	noop: function() {},

	// Evaluates a script in a global context
	// Workarounds based on findings by Jim Driscoll
	// http://weblogs.java.net/blog/driscoll/archive/2009/09/08/eval-javascript-global-context
	globalEval: function( data ) {
		if ( data && core_rnotwhite.test( data ) ) {
			// We use execScript on Internet Explorer
			// We use an anonymous function so that context is window
			// rather than jQuery in Firefox
			( window.execScript || function( data ) {
				window[ "eval" ].call( window, data );
			} )( data );
		}
	},

	// Convert dashed to camelCase; used by the css and data modules
	// Microsoft forgot to hump their vendor prefix (#9572)
	camelCase: function( string ) {
		return string.replace( rmsPrefix, "ms-" ).replace( rdashAlpha, fcamelCase );
	},

	nodeName: function( elem, name ) {
		return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();
	},

	// args is for internal usage only
	each: function( obj, callback, args ) {
		var name,
			i = 0,
			length = obj.length,
			isObj = length === undefined || jQuery.isFunction( obj );

		if ( args ) {
			if ( isObj ) {
				for ( name in obj ) {
					if ( callback.apply( obj[ name ], args ) === false ) {
						break;
					}
				}
			} else {
				for ( ; i < length; ) {
					if ( callback.apply( obj[ i++ ], args ) === false ) {
						break;
					}
				}
			}

		// A special, fast, case for the most common use of each
		} else {
			if ( isObj ) {
				for ( name in obj ) {
					if ( callback.call( obj[ name ], name, obj[ name ] ) === false ) {
						break;
					}
				}
			} else {
				for ( ; i < length; ) {
					if ( callback.call( obj[ i ], i, obj[ i++ ] ) === false ) {
						break;
					}
				}
			}
		}

		return obj;
	},

	// Use native String.trim function wherever possible
	trim: core_trim && !core_trim.call("\uFEFF\xA0") ?
		function( text ) {
			return text == null ?
				"" :
				core_trim.call( text );
		} :

		// Otherwise use our own trimming functionality
		function( text ) {
			return text == null ?
				"" :
				( text + "" ).replace( rtrim, "" );
		},

	// results is for internal usage only
	makeArray: function( arr, results ) {
		var type,
			ret = results || [];

		if ( arr != null ) {
			// The window, strings (and functions) also have 'length'
			// Tweaked logic slightly to handle Blackberry 4.7 RegExp issues #6930
			type = jQuery.type( arr );

			if ( arr.length == null || type === "string" || type === "function" || type === "regexp" || jQuery.isWindow( arr ) ) {
				core_push.call( ret, arr );
			} else {
				jQuery.merge( ret, arr );
			}
		}

		return ret;
	},

	inArray: function( elem, arr, i ) {
		var len;

		if ( arr ) {
			if ( core_indexOf ) {
				return core_indexOf.call( arr, elem, i );
			}

			len = arr.length;
			i = i ? i < 0 ? Math.max( 0, len + i ) : i : 0;

			for ( ; i < len; i++ ) {
				// Skip accessing in sparse arrays
				if ( i in arr && arr[ i ] === elem ) {
					return i;
				}
			}
		}

		return -1;
	},

	merge: function( first, second ) {
		var l = second.length,
			i = first.length,
			j = 0;

		if ( typeof l === "number" ) {
			for ( ; j < l; j++ ) {
				first[ i++ ] = second[ j ];
			}

		} else {
			while ( second[j] !== undefined ) {
				first[ i++ ] = second[ j++ ];
			}
		}

		first.length = i;

		return first;
	},

	grep: function( elems, callback, inv ) {
		var retVal,
			ret = [],
			i = 0,
			length = elems.length;
		inv = !!inv;

		// Go through the array, only saving the items
		// that pass the validator function
		for ( ; i < length; i++ ) {
			retVal = !!callback( elems[ i ], i );
			if ( inv !== retVal ) {
				ret.push( elems[ i ] );
			}
		}

		return ret;
	},

	// arg is for internal usage only
	map: function( elems, callback, arg ) {
		var value, key,
			ret = [],
			i = 0,
			length = elems.length,
			// jquery objects are treated as arrays
			isArray = elems instanceof jQuery || length !== undefined && typeof length === "number" && ( ( length > 0 && elems[ 0 ] && elems[ length -1 ] ) || length === 0 || jQuery.isArray( elems ) ) ;

		// Go through the array, translating each of the items to their
		if ( isArray ) {
			for ( ; i < length; i++ ) {
				value = callback( elems[ i ], i, arg );

				if ( value != null ) {
					ret[ ret.length ] = value;
				}
			}

		// Go through every key on the object,
		} else {
			for ( key in elems ) {
				value = callback( elems[ key ], key, arg );

				if ( value != null ) {
					ret[ ret.length ] = value;
				}
			}
		}

		// Flatten any nested arrays
		return ret.concat.apply( [], ret );
	},

	// A global GUID counter for objects
	guid: 1,

	// Bind a function to a context, optionally partially applying any
	// arguments.
	proxy: function( fn, context ) {
		var tmp, args, proxy;

		if ( typeof context === "string" ) {
			tmp = fn[ context ];
			context = fn;
			fn = tmp;
		}

		// Quick check to determine if target is callable, in the spec
		// this throws a TypeError, but we will just return undefined.
		if ( !jQuery.isFunction( fn ) ) {
			return undefined;
		}

		// Simulated bind
		args = core_slice.call( arguments, 2 );
		proxy = function() {
			return fn.apply( context, args.concat( core_slice.call( arguments ) ) );
		};

		// Set the guid of unique handler to the same of original handler, so it can be removed
		proxy.guid = fn.guid = fn.guid || jQuery.guid++;

		return proxy;
	},

	// Multifunctional method to get and set values of a collection
	// The value/s can optionally be executed if it's a function
	access: function( elems, fn, key, value, chainable, emptyGet, pass ) {
		var exec,
			bulk = key == null,
			i = 0,
			length = elems.length;

		// Sets many values
		if ( key && typeof key === "object" ) {
			for ( i in key ) {
				jQuery.access( elems, fn, i, key[i], 1, emptyGet, value );
			}
			chainable = 1;

		// Sets one value
		} else if ( value !== undefined ) {
			// Optionally, function values get executed if exec is true
			exec = pass === undefined && jQuery.isFunction( value );

			if ( bulk ) {
				// Bulk operations only iterate when executing function values
				if ( exec ) {
					exec = fn;
					fn = function( elem, key, value ) {
						return exec.call( jQuery( elem ), value );
					};

				// Otherwise they run against the entire set
				} else {
					fn.call( elems, value );
					fn = null;
				}
			}

			if ( fn ) {
				for (; i < length; i++ ) {
					fn( elems[i], key, exec ? value.call( elems[i], i, fn( elems[i], key ) ) : value, pass );
				}
			}

			chainable = 1;
		}

		return chainable ?
			elems :

			// Gets
			bulk ?
				fn.call( elems ) :
				length ? fn( elems[0], key ) : emptyGet;
	},

	now: function() {
		return ( new Date() ).getTime();
	}
});

jQuery.ready.promise = function( obj ) {
	if ( !readyList ) {

		readyList = jQuery.Deferred();

		// Catch cases where $(document).ready() is called after the browser event has already occurred.
		// we once tried to use readyState "interactive" here, but it caused issues like the one
		// discovered by ChrisS here: http://bugs.jquery.com/ticket/12282#comment:15
		if ( document.readyState === "complete" ) {
			// Handle it asynchronously to allow scripts the opportunity to delay ready
			setTimeout( jQuery.ready, 1 );

		// Standards-based browsers support DOMContentLoaded
		} else if ( document.addEventListener ) {
			// Use the handy event callback
			document.addEventListener( "DOMContentLoaded", DOMContentLoaded, false );

			// A fallback to window.onload, that will always work
			window.addEventListener( "load", jQuery.ready, false );

		// If IE event model is used
		} else {
			// Ensure firing before onload, maybe late but safe also for iframes
			document.attachEvent( "onreadystatechange", DOMContentLoaded );

			// A fallback to window.onload, that will always work
			window.attachEvent( "onload", jQuery.ready );

			// If IE and not a frame
			// continually check to see if the document is ready
			var top = false;

			try {
				top = window.frameElement == null && document.documentElement;
			} catch(e) {}

			if ( top && top.doScroll ) {
				(function doScrollCheck() {
					if ( !jQuery.isReady ) {

						try {
							// Use the trick by Diego Perini
							// http://javascript.nwbox.com/IEContentLoaded/
							top.doScroll("left");
						} catch(e) {
							return setTimeout( doScrollCheck, 50 );
						}

						// and execute any waiting functions
						jQuery.ready();
					}
				})();
			}
		}
	}
	return readyList.promise( obj );
};

// Populate the class2type map
jQuery.each("Boolean Number String Function Array Date RegExp Object".split(" "), function(i, name) {
	class2type[ "[object " + name + "]" ] = name.toLowerCase();
});

// All jQuery objects should point back to these
rootjQuery = jQuery(document);
// String to Object options format cache
var optionsCache = {};

// Convert String-formatted options into Object-formatted ones and store in cache
function createOptions( options ) {
	var object = optionsCache[ options ] = {};
	jQuery.each( options.split( core_rspace ), function( _, flag ) {
		object[ flag ] = true;
	});
	return object;
}

/*
 * Create a callback list using the following parameters:
 *
 *	options: an optional list of space-separated options that will change how
 *			the callback list behaves or a more traditional option object
 *
 * By default a callback list will act like an event callback list and can be
 * "fired" multiple times.
 *
 * Possible options:
 *
 *	once:			will ensure the callback list can only be fired once (like a Deferred)
 *
 *	memory:			will keep track of previous values and will call any callback added
 *					after the list has been fired right away with the latest "memorized"
 *					values (like a Deferred)
 *
 *	unique:			will ensure a callback can only be added once (no duplicate in the list)
 *
 *	stopOnFalse:	interrupt callings when a callback returns false
 *
 */
jQuery.Callbacks = function( options ) {

	// Convert options from String-formatted to Object-formatted if needed
	// (we check in cache first)
	options = typeof options === "string" ?
		( optionsCache[ options ] || createOptions( options ) ) :
		jQuery.extend( {}, options );

	var // Last fire value (for non-forgettable lists)
		memory,
		// Flag to know if list was already fired
		fired,
		// Flag to know if list is currently firing
		firing,
		// First callback to fire (used internally by add and fireWith)
		firingStart,
		// End of the loop when firing
		firingLength,
		// Index of currently firing callback (modified by remove if needed)
		firingIndex,
		// Actual callback list
		list = [],
		// Stack of fire calls for repeatable lists
		stack = !options.once && [],
		// Fire callbacks
		fire = function( data ) {
			memory = options.memory && data;
			fired = true;
			firingIndex = firingStart || 0;
			firingStart = 0;
			firingLength = list.length;
			firing = true;
			for ( ; list && firingIndex < firingLength; firingIndex++ ) {
				if ( list[ firingIndex ].apply( data[ 0 ], data[ 1 ] ) === false && options.stopOnFalse ) {
					memory = false; // To prevent further calls using add
					break;
				}
			}
			firing = false;
			if ( list ) {
				if ( stack ) {
					if ( stack.length ) {
						fire( stack.shift() );
					}
				} else if ( memory ) {
					list = [];
				} else {
					self.disable();
				}
			}
		},
		// Actual Callbacks object
		self = {
			// Add a callback or a collection of callbacks to the list
			add: function() {
				if ( list ) {
					// First, we save the current length
					var start = list.length;
					(function add( args ) {
						jQuery.each( args, function( _, arg ) {
							var type = jQuery.type( arg );
							if ( type === "function" && ( !options.unique || !self.has( arg ) ) ) {
								list.push( arg );
							} else if ( arg && arg.length && type !== "string" ) {
								// Inspect recursively
								add( arg );
							}
						});
					})( arguments );
					// Do we need to add the callbacks to the
					// current firing batch?
					if ( firing ) {
						firingLength = list.length;
					// With memory, if we're not firing then
					// we should call right away
					} else if ( memory ) {
						firingStart = start;
						fire( memory );
					}
				}
				return this;
			},
			// Remove a callback from the list
			remove: function() {
				if ( list ) {
					jQuery.each( arguments, function( _, arg ) {
						var index;
						while( ( index = jQuery.inArray( arg, list, index ) ) > -1 ) {
							list.splice( index, 1 );
							// Handle firing indexes
							if ( firing ) {
								if ( index <= firingLength ) {
									firingLength--;
								}
								if ( index <= firingIndex ) {
									firingIndex--;
								}
							}
						}
					});
				}
				return this;
			},
			// Control if a given callback is in the list
			has: function( fn ) {
				return jQuery.inArray( fn, list ) > -1;
			},
			// Remove all callbacks from the list
			empty: function() {
				list = [];
				return this;
			},
			// Have the list do nothing anymore
			disable: function() {
				list = stack = memory = undefined;
				return this;
			},
			// Is it disabled?
			disabled: function() {
				return !list;
			},
			// Lock the list in its current state
			lock: function() {
				stack = undefined;
				if ( !memory ) {
					self.disable();
				}
				return this;
			},
			// Is it locked?
			locked: function() {
				return !stack;
			},
			// Call all callbacks with the given context and arguments
			fireWith: function( context, args ) {
				args = args || [];
				args = [ context, args.slice ? args.slice() : args ];
				if ( list && ( !fired || stack ) ) {
					if ( firing ) {
						stack.push( args );
					} else {
						fire( args );
					}
				}
				return this;
			},
			// Call all the callbacks with the given arguments
			fire: function() {
				self.fireWith( this, arguments );
				return this;
			},
			// To know if the callbacks have already been called at least once
			fired: function() {
				return !!fired;
			}
		};

	return self;
};
jQuery.extend({

	Deferred: function( func ) {
		var tuples = [
				// action, add listener, listener list, final state
				[ "resolve", "done", jQuery.Callbacks("once memory"), "resolved" ],
				[ "reject", "fail", jQuery.Callbacks("once memory"), "rejected" ],
				[ "notify", "progress", jQuery.Callbacks("memory") ]
			],
			state = "pending",
			promise = {
				state: function() {
					return state;
				},
				always: function() {
					deferred.done( arguments ).fail( arguments );
					return this;
				},
				then: function( /* fnDone, fnFail, fnProgress */ ) {
					var fns = arguments;
					return jQuery.Deferred(function( newDefer ) {
						jQuery.each( tuples, function( i, tuple ) {
							var action = tuple[ 0 ],
								fn = fns[ i ];
							// deferred[ done | fail | progress ] for forwarding actions to newDefer
							deferred[ tuple[1] ]( jQuery.isFunction( fn ) ?
								function() {
									var returned = fn.apply( this, arguments );
									if ( returned && jQuery.isFunction( returned.promise ) ) {
										returned.promise()
											.done( newDefer.resolve )
											.fail( newDefer.reject )
											.progress( newDefer.notify );
									} else {
										newDefer[ action + "With" ]( this === deferred ? newDefer : this, [ returned ] );
									}
								} :
								newDefer[ action ]
							);
						});
						fns = null;
					}).promise();
				},
				// Get a promise for this deferred
				// If obj is provided, the promise aspect is added to the object
				promise: function( obj ) {
					return obj != null ? jQuery.extend( obj, promise ) : promise;
				}
			},
			deferred = {};

		// Keep pipe for back-compat
		promise.pipe = promise.then;

		// Add list-specific methods
		jQuery.each( tuples, function( i, tuple ) {
			var list = tuple[ 2 ],
				stateString = tuple[ 3 ];

			// promise[ done | fail | progress ] = list.add
			promise[ tuple[1] ] = list.add;

			// Handle state
			if ( stateString ) {
				list.add(function() {
					// state = [ resolved | rejected ]
					state = stateString;

				// [ reject_list | resolve_list ].disable; progress_list.lock
				}, tuples[ i ^ 1 ][ 2 ].disable, tuples[ 2 ][ 2 ].lock );
			}

			// deferred[ resolve | reject | notify ] = list.fire
			deferred[ tuple[0] ] = list.fire;
			deferred[ tuple[0] + "With" ] = list.fireWith;
		});

		// Make the deferred a promise
		promise.promise( deferred );

		// Call given func if any
		if ( func ) {
			func.call( deferred, deferred );
		}

		// All done!
		return deferred;
	},

	// Deferred helper
	when: function( subordinate /* , ..., subordinateN */ ) {
		var i = 0,
			resolveValues = core_slice.call( arguments ),
			length = resolveValues.length,

			// the count of uncompleted subordinates
			remaining = length !== 1 || ( subordinate && jQuery.isFunction( subordinate.promise ) ) ? length : 0,

			// the master Deferred. If resolveValues consist of only a single Deferred, just use that.
			deferred = remaining === 1 ? subordinate : jQuery.Deferred(),

			// Update function for both resolve and progress values
			updateFunc = function( i, contexts, values ) {
				return function( value ) {
					contexts[ i ] = this;
					values[ i ] = arguments.length > 1 ? core_slice.call( arguments ) : value;
					if( values === progressValues ) {
						deferred.notifyWith( contexts, values );
					} else if ( !( --remaining ) ) {
						deferred.resolveWith( contexts, values );
					}
				};
			},

			progressValues, progressContexts, resolveContexts;

		// add listeners to Deferred subordinates; treat others as resolved
		if ( length > 1 ) {
			progressValues = new Array( length );
			progressContexts = new Array( length );
			resolveContexts = new Array( length );
			for ( ; i < length; i++ ) {
				if ( resolveValues[ i ] && jQuery.isFunction( resolveValues[ i ].promise ) ) {
					resolveValues[ i ].promise()
						.done( updateFunc( i, resolveContexts, resolveValues ) )
						.fail( deferred.reject )
						.progress( updateFunc( i, progressContexts, progressValues ) );
				} else {
					--remaining;
				}
			}
		}

		// if we're not waiting on anything, resolve the master
		if ( !remaining ) {
			deferred.resolveWith( resolveContexts, resolveValues );
		}

		return deferred.promise();
	}
});
jQuery.support = (function() {

	var support,
		all,
		a,
		select,
		opt,
		input,
		fragment,
		eventName,
		i,
		isSupported,
		clickFn,
		div = document.createElement("div");

	// Preliminary tests
	div.setAttribute( "className", "t" );
	div.innerHTML = "  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>";

	all = div.getElementsByTagName("*");
	a = div.getElementsByTagName("a")[ 0 ];
	a.style.cssText = "top:1px;float:left;opacity:.5";

	// Can't get basic test support
	if ( !all || !all.length ) {
		return {};
	}

	// First batch of supports tests
	select = document.createElement("select");
	opt = select.appendChild( document.createElement("option") );
	input = div.getElementsByTagName("input")[ 0 ];

	support = {
		// IE strips leading whitespace when .innerHTML is used
		leadingWhitespace: ( div.firstChild.nodeType === 3 ),

		// Make sure that tbody elements aren't automatically inserted
		// IE will insert them into empty tables
		tbody: !div.getElementsByTagName("tbody").length,

		// Make sure that link elements get serialized correctly by innerHTML
		// This requires a wrapper element in IE
		htmlSerialize: !!div.getElementsByTagName("link").length,

		// Get the style information from getAttribute
		// (IE uses .cssText instead)
		style: /top/.test( a.getAttribute("style") ),

		// Make sure that URLs aren't manipulated
		// (IE normalizes it by default)
		hrefNormalized: ( a.getAttribute("href") === "/a" ),

		// Make sure that element opacity exists
		// (IE uses filter instead)
		// Use a regex to work around a WebKit issue. See #5145
		opacity: /^0.5/.test( a.style.opacity ),

		// Verify style float existence
		// (IE uses styleFloat instead of cssFloat)
		cssFloat: !!a.style.cssFloat,

		// Make sure that if no value is specified for a checkbox
		// that it defaults to "on".
		// (WebKit defaults to "" instead)
		checkOn: ( input.value === "on" ),

		// Make sure that a selected-by-default option has a working selected property.
		// (WebKit defaults to false instead of true, IE too, if it's in an optgroup)
		optSelected: opt.selected,

		// Test setAttribute on camelCase class. If it works, we need attrFixes when doing get/setAttribute (ie6/7)
		getSetAttribute: div.className !== "t",

		// Tests for enctype support on a form(#6743)
		enctype: !!document.createElement("form").enctype,

		// Makes sure cloning an html5 element does not cause problems
		// Where outerHTML is undefined, this still works
		html5Clone: document.createElement("nav").cloneNode( true ).outerHTML !== "<:nav></:nav>",

		// jQuery.support.boxModel DEPRECATED in 1.8 since we don't support Quirks Mode
		boxModel: ( document.compatMode === "CSS1Compat" ),

		// Will be defined later
		submitBubbles: true,
		changeBubbles: true,
		focusinBubbles: false,
		deleteExpando: true,
		noCloneEvent: true,
		inlineBlockNeedsLayout: false,
		shrinkWrapBlocks: false,
		reliableMarginRight: true,
		boxSizingReliable: true,
		pixelPosition: false
	};

	// Make sure checked status is properly cloned
	input.checked = true;
	support.noCloneChecked = input.cloneNode( true ).checked;

	// Make sure that the options inside disabled selects aren't marked as disabled
	// (WebKit marks them as disabled)
	select.disabled = true;
	support.optDisabled = !opt.disabled;

	// Test to see if it's possible to delete an expando from an element
	// Fails in Internet Explorer
	try {
		delete div.test;
	} catch( e ) {
		support.deleteExpando = false;
	}

	if ( !div.addEventListener && div.attachEvent && div.fireEvent ) {
		div.attachEvent( "onclick", clickFn = function() {
			// Cloning a node shouldn't copy over any
			// bound event handlers (IE does this)
			support.noCloneEvent = false;
		});
		div.cloneNode( true ).fireEvent("onclick");
		div.detachEvent( "onclick", clickFn );
	}

	// Check if a radio maintains its value
	// after being appended to the DOM
	input = document.createElement("input");
	input.value = "t";
	input.setAttribute( "type", "radio" );
	support.radioValue = input.value === "t";

	input.setAttribute( "checked", "checked" );

	// #11217 - WebKit loses check when the name is after the checked attribute
	input.setAttribute( "name", "t" );

	div.appendChild( input );
	fragment = document.createDocumentFragment();
	fragment.appendChild( div.lastChild );

	// WebKit doesn't clone checked state correctly in fragments
	support.checkClone = fragment.cloneNode( true ).cloneNode( true ).lastChild.checked;

	// Check if a disconnected checkbox will retain its checked
	// value of true after appended to the DOM (IE6/7)
	support.appendChecked = input.checked;

	fragment.removeChild( input );
	fragment.appendChild( div );

	// Technique from Juriy Zaytsev
	// http://perfectionkills.com/detecting-event-support-without-browser-sniffing/
	// We only care about the case where non-standard event systems
	// are used, namely in IE. Short-circuiting here helps us to
	// avoid an eval call (in setAttribute) which can cause CSP
	// to go haywire. See: https://developer.mozilla.org/en/Security/CSP
	if ( div.attachEvent ) {
		for ( i in {
			submit: true,
			change: true,
			focusin: true
		}) {
			eventName = "on" + i;
			isSupported = ( eventName in div );
			if ( !isSupported ) {
				div.setAttribute( eventName, "return;" );
				isSupported = ( typeof div[ eventName ] === "function" );
			}
			support[ i + "Bubbles" ] = isSupported;
		}
	}

	// Run tests that need a body at doc ready
	jQuery(function() {
		var container, div, tds, marginDiv,
			divReset = "padding:0;margin:0;border:0;display:block;overflow:hidden;",
			body = document.getElementsByTagName("body")[0];

		if ( !body ) {
			// Return for frameset docs that don't have a body
			return;
		}

		container = document.createElement("div");
		container.style.cssText = "visibility:hidden;border:0;width:0;height:0;position:static;top:0;margin-top:1px";
		body.insertBefore( container, body.firstChild );

		// Construct the test element
		div = document.createElement("div");
		container.appendChild( div );

		// Check if table cells still have offsetWidth/Height when they are set
		// to display:none and there are still other visible table cells in a
		// table row; if so, offsetWidth/Height are not reliable for use when
		// determining if an element has been hidden directly using
		// display:none (it is still safe to use offsets if a parent element is
		// hidden; don safety goggles and see bug #4512 for more information).
		// (only IE 8 fails this test)
		div.innerHTML = "<table><tr><td></td><td>t</td></tr></table>";
		tds = div.getElementsByTagName("td");
		tds[ 0 ].style.cssText = "padding:0;margin:0;border:0;display:none";
		isSupported = ( tds[ 0 ].offsetHeight === 0 );

		tds[ 0 ].style.display = "";
		tds[ 1 ].style.display = "none";

		// Check if empty table cells still have offsetWidth/Height
		// (IE <= 8 fail this test)
		support.reliableHiddenOffsets = isSupported && ( tds[ 0 ].offsetHeight === 0 );

		// Check box-sizing and margin behavior
		div.innerHTML = "";
		div.style.cssText = "box-sizing:border-box;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;padding:1px;border:1px;display:block;width:4px;margin-top:1%;position:absolute;top:1%;";
		support.boxSizing = ( div.offsetWidth === 4 );
		support.doesNotIncludeMarginInBodyOffset = ( body.offsetTop !== 1 );

		// NOTE: To any future maintainer, we've window.getComputedStyle
		// because jsdom on node.js will break without it.
		if ( window.getComputedStyle ) {
			support.pixelPosition = ( window.getComputedStyle( div, null ) || {} ).top !== "1%";
			support.boxSizingReliable = ( window.getComputedStyle( div, null ) || { width: "4px" } ).width === "4px";

			// Check if div with explicit width and no margin-right incorrectly
			// gets computed margin-right based on width of container. For more
			// info see bug #3333
			// Fails in WebKit before Feb 2011 nightlies
			// WebKit Bug 13343 - getComputedStyle returns wrong value for margin-right
			marginDiv = document.createElement("div");
			marginDiv.style.cssText = div.style.cssText = divReset;
			marginDiv.style.marginRight = marginDiv.style.width = "0";
			div.style.width = "1px";
			div.appendChild( marginDiv );
			support.reliableMarginRight =
				!parseFloat( ( window.getComputedStyle( marginDiv, null ) || {} ).marginRight );
		}

		if ( typeof div.style.zoom !== "undefined" ) {
			// Check if natively block-level elements act like inline-block
			// elements when setting their display to 'inline' and giving
			// them layout
			// (IE < 8 does this)
			div.innerHTML = "";
			div.style.cssText = divReset + "width:1px;padding:1px;display:inline;zoom:1";
			support.inlineBlockNeedsLayout = ( div.offsetWidth === 3 );

			// Check if elements with layout shrink-wrap their children
			// (IE 6 does this)
			div.style.display = "block";
			div.style.overflow = "visible";
			div.innerHTML = "<div></div>";
			div.firstChild.style.width = "5px";
			support.shrinkWrapBlocks = ( div.offsetWidth !== 3 );

			container.style.zoom = 1;
		}

		// Null elements to avoid leaks in IE
		body.removeChild( container );
		container = div = tds = marginDiv = null;
	});

	// Null elements to avoid leaks in IE
	fragment.removeChild( div );
	all = a = select = opt = input = fragment = div = null;

	return support;
})();
var rbrace = /(?:\{[\s\S]*\}|\[[\s\S]*\])$/,
	rmultiDash = /([A-Z])/g;

jQuery.extend({
	cache: {},

	deletedIds: [],

	// Remove at next major release (1.9/2.0)
	uuid: 0,

	// Unique for each copy of jQuery on the page
	// Non-digits removed to match rinlinejQuery
	expando: "jQuery" + ( jQuery.fn.jquery + Math.random() ).replace( /\D/g, "" ),

	// The following elements throw uncatchable exceptions if you
	// attempt to add expando properties to them.
	noData: {
		"embed": true,
		// Ban all objects except for Flash (which handle expandos)
		"object": "clsid:D27CDB6E-AE6D-11cf-96B8-444553540000",
		"applet": true
	},

	hasData: function( elem ) {
		elem = elem.nodeType ? jQuery.cache[ elem[jQuery.expando] ] : elem[ jQuery.expando ];
		return !!elem && !isEmptyDataObject( elem );
	},

	data: function( elem, name, data, pvt /* Internal Use Only */ ) {
		if ( !jQuery.acceptData( elem ) ) {
			return;
		}

		var thisCache, ret,
			internalKey = jQuery.expando,
			getByName = typeof name === "string",

			// We have to handle DOM nodes and JS objects differently because IE6-7
			// can't GC object references properly across the DOM-JS boundary
			isNode = elem.nodeType,

			// Only DOM nodes need the global jQuery cache; JS object data is
			// attached directly to the object so GC can occur automatically
			cache = isNode ? jQuery.cache : elem,

			// Only defining an ID for JS objects if its cache already exists allows
			// the code to shortcut on the same path as a DOM node with no cache
			id = isNode ? elem[ internalKey ] : elem[ internalKey ] && internalKey;

		// Avoid doing any more work than we need to when trying to get data on an
		// object that has no data at all
		if ( (!id || !cache[id] || (!pvt && !cache[id].data)) && getByName && data === undefined ) {
			return;
		}

		if ( !id ) {
			// Only DOM nodes need a new unique ID for each element since their data
			// ends up in the global cache
			if ( isNode ) {
				elem[ internalKey ] = id = jQuery.deletedIds.pop() || jQuery.guid++;
			} else {
				id = internalKey;
			}
		}

		if ( !cache[ id ] ) {
			cache[ id ] = {};

			// Avoids exposing jQuery metadata on plain JS objects when the object
			// is serialized using JSON.stringify
			if ( !isNode ) {
				cache[ id ].toJSON = jQuery.noop;
			}
		}

		// An object can be passed to jQuery.data instead of a key/value pair; this gets
		// shallow copied over onto the existing cache
		if ( typeof name === "object" || typeof name === "function" ) {
			if ( pvt ) {
				cache[ id ] = jQuery.extend( cache[ id ], name );
			} else {
				cache[ id ].data = jQuery.extend( cache[ id ].data, name );
			}
		}

		thisCache = cache[ id ];

		// jQuery data() is stored in a separate object inside the object's internal data
		// cache in order to avoid key collisions between internal data and user-defined
		// data.
		if ( !pvt ) {
			if ( !thisCache.data ) {
				thisCache.data = {};
			}

			thisCache = thisCache.data;
		}

		if ( data !== undefined ) {
			thisCache[ jQuery.camelCase( name ) ] = data;
		}

		// Check for both converted-to-camel and non-converted data property names
		// If a data property was specified
		if ( getByName ) {

			// First Try to find as-is property data
			ret = thisCache[ name ];

			// Test for null|undefined property data
			if ( ret == null ) {

				// Try to find the camelCased property
				ret = thisCache[ jQuery.camelCase( name ) ];
			}
		} else {
			ret = thisCache;
		}

		return ret;
	},

	removeData: function( elem, name, pvt /* Internal Use Only */ ) {
		if ( !jQuery.acceptData( elem ) ) {
			return;
		}

		var thisCache, i, l,

			isNode = elem.nodeType,

			// See jQuery.data for more information
			cache = isNode ? jQuery.cache : elem,
			id = isNode ? elem[ jQuery.expando ] : jQuery.expando;

		// If there is already no cache entry for this object, there is no
		// purpose in continuing
		if ( !cache[ id ] ) {
			return;
		}

		if ( name ) {

			thisCache = pvt ? cache[ id ] : cache[ id ].data;

			if ( thisCache ) {

				// Support array or space separated string names for data keys
				if ( !jQuery.isArray( name ) ) {

					// try the string as a key before any manipulation
					if ( name in thisCache ) {
						name = [ name ];
					} else {

						// split the camel cased version by spaces unless a key with the spaces exists
						name = jQuery.camelCase( name );
						if ( name in thisCache ) {
							name = [ name ];
						} else {
							name = name.split(" ");
						}
					}
				}

				for ( i = 0, l = name.length; i < l; i++ ) {
					delete thisCache[ name[i] ];
				}

				// If there is no data left in the cache, we want to continue
				// and let the cache object itself get destroyed
				if ( !( pvt ? isEmptyDataObject : jQuery.isEmptyObject )( thisCache ) ) {
					return;
				}
			}
		}

		// See jQuery.data for more information
		if ( !pvt ) {
			delete cache[ id ].data;

			// Don't destroy the parent cache unless the internal data object
			// had been the only thing left in it
			if ( !isEmptyDataObject( cache[ id ] ) ) {
				return;
			}
		}

		// Destroy the cache
		if ( isNode ) {
			jQuery.cleanData( [ elem ], true );

		// Use delete when supported for expandos or `cache` is not a window per isWindow (#10080)
		} else if ( jQuery.support.deleteExpando || cache != cache.window ) {
			delete cache[ id ];

		// When all else fails, null
		} else {
			cache[ id ] = null;
		}
	},

	// For internal use only.
	_data: function( elem, name, data ) {
		return jQuery.data( elem, name, data, true );
	},

	// A method for determining if a DOM node can handle the data expando
	acceptData: function( elem ) {
		var noData = elem.nodeName && jQuery.noData[ elem.nodeName.toLowerCase() ];

		// nodes accept data unless otherwise specified; rejection can be conditional
		return !noData || noData !== true && elem.getAttribute("classid") === noData;
	}
});

jQuery.fn.extend({
	data: function( key, value ) {
		var parts, part, attr, name, l,
			elem = this[0],
			i = 0,
			data = null;

		// Gets all values
		if ( key === undefined ) {
			if ( this.length ) {
				data = jQuery.data( elem );

				if ( elem.nodeType === 1 && !jQuery._data( elem, "parsedAttrs" ) ) {
					attr = elem.attributes;
					for ( l = attr.length; i < l; i++ ) {
						name = attr[i].name;

						if ( !name.indexOf( "data-" ) ) {
							name = jQuery.camelCase( name.substring(5) );

							dataAttr( elem, name, data[ name ] );
						}
					}
					jQuery._data( elem, "parsedAttrs", true );
				}
			}

			return data;
		}

		// Sets multiple values
		if ( typeof key === "object" ) {
			return this.each(function() {
				jQuery.data( this, key );
			});
		}

		parts = key.split( ".", 2 );
		parts[1] = parts[1] ? "." + parts[1] : "";
		part = parts[1] + "!";

		return jQuery.access( this, function( value ) {

			if ( value === undefined ) {
				data = this.triggerHandler( "getData" + part, [ parts[0] ] );

				// Try to fetch any internally stored data first
				if ( data === undefined && elem ) {
					data = jQuery.data( elem, key );
					data = dataAttr( elem, key, data );
				}

				return data === undefined && parts[1] ?
					this.data( parts[0] ) :
					data;
			}

			parts[1] = value;
			this.each(function() {
				var self = jQuery( this );

				self.triggerHandler( "setData" + part, parts );
				jQuery.data( this, key, value );
				self.triggerHandler( "changeData" + part, parts );
			});
		}, null, value, arguments.length > 1, null, false );
	},

	removeData: function( key ) {
		return this.each(function() {
			jQuery.removeData( this, key );
		});
	}
});

function dataAttr( elem, key, data ) {
	// If nothing was found internally, try to fetch any
	// data from the HTML5 data-* attribute
	if ( data === undefined && elem.nodeType === 1 ) {

		var name = "data-" + key.replace( rmultiDash, "-$1" ).toLowerCase();

		data = elem.getAttribute( name );

		if ( typeof data === "string" ) {
			try {
				data = data === "true" ? true :
				data === "false" ? false :
				data === "null" ? null :
				// Only convert to a number if it doesn't change the string
				+data + "" === data ? +data :
				rbrace.test( data ) ? jQuery.parseJSON( data ) :
					data;
			} catch( e ) {}

			// Make sure we set the data so it isn't changed later
			jQuery.data( elem, key, data );

		} else {
			data = undefined;
		}
	}

	return data;
}

// checks a cache object for emptiness
function isEmptyDataObject( obj ) {
	var name;
	for ( name in obj ) {

		// if the public data object is empty, the private is still empty
		if ( name === "data" && jQuery.isEmptyObject( obj[name] ) ) {
			continue;
		}
		if ( name !== "toJSON" ) {
			return false;
		}
	}

	return true;
}
jQuery.extend({
	queue: function( elem, type, data ) {
		var queue;

		if ( elem ) {
			type = ( type || "fx" ) + "queue";
			queue = jQuery._data( elem, type );

			// Speed up dequeue by getting out quickly if this is just a lookup
			if ( data ) {
				if ( !queue || jQuery.isArray(data) ) {
					queue = jQuery._data( elem, type, jQuery.makeArray(data) );
				} else {
					queue.push( data );
				}
			}
			return queue || [];
		}
	},

	dequeue: function( elem, type ) {
		type = type || "fx";

		var queue = jQuery.queue( elem, type ),
			startLength = queue.length,
			fn = queue.shift(),
			hooks = jQuery._queueHooks( elem, type ),
			next = function() {
				jQuery.dequeue( elem, type );
			};

		// If the fx queue is dequeued, always remove the progress sentinel
		if ( fn === "inprogress" ) {
			fn = queue.shift();
			startLength--;
		}

		if ( fn ) {

			// Add a progress sentinel to prevent the fx queue from being
			// automatically dequeued
			if ( type === "fx" ) {
				queue.unshift( "inprogress" );
			}

			// clear up the last queue stop function
			delete hooks.stop;
			fn.call( elem, next, hooks );
		}

		if ( !startLength && hooks ) {
			hooks.empty.fire();
		}
	},

	// not intended for public consumption - generates a queueHooks object, or returns the current one
	_queueHooks: function( elem, type ) {
		var key = type + "queueHooks";
		return jQuery._data( elem, key ) || jQuery._data( elem, key, {
			empty: jQuery.Callbacks("once memory").add(function() {
				jQuery.removeData( elem, type + "queue", true );
				jQuery.removeData( elem, key, true );
			})
		});
	}
});

jQuery.fn.extend({
	queue: function( type, data ) {
		var setter = 2;

		if ( typeof type !== "string" ) {
			data = type;
			type = "fx";
			setter--;
		}

		if ( arguments.length < setter ) {
			return jQuery.queue( this[0], type );
		}

		return data === undefined ?
			this :
			this.each(function() {
				var queue = jQuery.queue( this, type, data );

				// ensure a hooks for this queue
				jQuery._queueHooks( this, type );

				if ( type === "fx" && queue[0] !== "inprogress" ) {
					jQuery.dequeue( this, type );
				}
			});
	},
	dequeue: function( type ) {
		return this.each(function() {
			jQuery.dequeue( this, type );
		});
	},
	// Based off of the plugin by Clint Helfers, with permission.
	// http://blindsignals.com/index.php/2009/07/jquery-delay/
	delay: function( time, type ) {
		time = jQuery.fx ? jQuery.fx.speeds[ time ] || time : time;
		type = type || "fx";

		return this.queue( type, function( next, hooks ) {
			var timeout = setTimeout( next, time );
			hooks.stop = function() {
				clearTimeout( timeout );
			};
		});
	},
	clearQueue: function( type ) {
		return this.queue( type || "fx", [] );
	},
	// Get a promise resolved when queues of a certain type
	// are emptied (fx is the type by default)
	promise: function( type, obj ) {
		var tmp,
			count = 1,
			defer = jQuery.Deferred(),
			elements = this,
			i = this.length,
			resolve = function() {
				if ( !( --count ) ) {
					defer.resolveWith( elements, [ elements ] );
				}
			};

		if ( typeof type !== "string" ) {
			obj = type;
			type = undefined;
		}
		type = type || "fx";

		while( i-- ) {
			tmp = jQuery._data( elements[ i ], type + "queueHooks" );
			if ( tmp && tmp.empty ) {
				count++;
				tmp.empty.add( resolve );
			}
		}
		resolve();
		return defer.promise( obj );
	}
});
var nodeHook, boolHook, fixSpecified,
	rclass = /[\t\r\n]/g,
	rreturn = /\r/g,
	rtype = /^(?:button|input)$/i,
	rfocusable = /^(?:button|input|object|select|textarea)$/i,
	rclickable = /^a(?:rea|)$/i,
	rboolean = /^(?:autofocus|autoplay|async|checked|controls|defer|disabled|hidden|loop|multiple|open|readonly|required|scoped|selected)$/i,
	getSetAttribute = jQuery.support.getSetAttribute;

jQuery.fn.extend({
	attr: function( name, value ) {
		return jQuery.access( this, jQuery.attr, name, value, arguments.length > 1 );
	},

	removeAttr: function( name ) {
		return this.each(function() {
			jQuery.removeAttr( this, name );
		});
	},

	prop: function( name, value ) {
		return jQuery.access( this, jQuery.prop, name, value, arguments.length > 1 );
	},

	removeProp: function( name ) {
		name = jQuery.propFix[ name ] || name;
		return this.each(function() {
			// try/catch handles cases where IE balks (such as removing a property on window)
			try {
				this[ name ] = undefined;
				delete this[ name ];
			} catch( e ) {}
		});
	},

	addClass: function( value ) {
		var classNames, i, l, elem,
			setClass, c, cl;

		if ( jQuery.isFunction( value ) ) {
			return this.each(function( j ) {
				jQuery( this ).addClass( value.call(this, j, this.className) );
			});
		}

		if ( value && typeof value === "string" ) {
			classNames = value.split( core_rspace );

			for ( i = 0, l = this.length; i < l; i++ ) {
				elem = this[ i ];

				if ( elem.nodeType === 1 ) {
					if ( !elem.className && classNames.length === 1 ) {
						elem.className = value;

					} else {
						setClass = " " + elem.className + " ";

						for ( c = 0, cl = classNames.length; c < cl; c++ ) {
							if ( setClass.indexOf( " " + classNames[ c ] + " " ) < 0 ) {
								setClass += classNames[ c ] + " ";
							}
						}
						elem.className = jQuery.trim( setClass );
					}
				}
			}
		}

		return this;
	},

	removeClass: function( value ) {
		var removes, className, elem, c, cl, i, l;

		if ( jQuery.isFunction( value ) ) {
			return this.each(function( j ) {
				jQuery( this ).removeClass( value.call(this, j, this.className) );
			});
		}
		if ( (value && typeof value === "string") || value === undefined ) {
			removes = ( value || "" ).split( core_rspace );

			for ( i = 0, l = this.length; i < l; i++ ) {
				elem = this[ i ];
				if ( elem.nodeType === 1 && elem.className ) {

					className = (" " + elem.className + " ").replace( rclass, " " );

					// loop over each item in the removal list
					for ( c = 0, cl = removes.length; c < cl; c++ ) {
						// Remove until there is nothing to remove,
						while ( className.indexOf(" " + removes[ c ] + " ") >= 0 ) {
							className = className.replace( " " + removes[ c ] + " " , " " );
						}
					}
					elem.className = value ? jQuery.trim( className ) : "";
				}
			}
		}

		return this;
	},

	toggleClass: function( value, stateVal ) {
		var type = typeof value,
			isBool = typeof stateVal === "boolean";

		if ( jQuery.isFunction( value ) ) {
			return this.each(function( i ) {
				jQuery( this ).toggleClass( value.call(this, i, this.className, stateVal), stateVal );
			});
		}

		return this.each(function() {
			if ( type === "string" ) {
				// toggle individual class names
				var className,
					i = 0,
					self = jQuery( this ),
					state = stateVal,
					classNames = value.split( core_rspace );

				while ( (className = classNames[ i++ ]) ) {
					// check each className given, space separated list
					state = isBool ? state : !self.hasClass( className );
					self[ state ? "addClass" : "removeClass" ]( className );
				}

			} else if ( type === "undefined" || type === "boolean" ) {
				if ( this.className ) {
					// store className if set
					jQuery._data( this, "__className__", this.className );
				}

				// toggle whole className
				this.className = this.className || value === false ? "" : jQuery._data( this, "__className__" ) || "";
			}
		});
	},

	hasClass: function( selector ) {
		var className = " " + selector + " ",
			i = 0,
			l = this.length;
		for ( ; i < l; i++ ) {
			if ( this[i].nodeType === 1 && (" " + this[i].className + " ").replace(rclass, " ").indexOf( className ) >= 0 ) {
				return true;
			}
		}

		return false;
	},

	val: function( value ) {
		var hooks, ret, isFunction,
			elem = this[0];

		if ( !arguments.length ) {
			if ( elem ) {
				hooks = jQuery.valHooks[ elem.type ] || jQuery.valHooks[ elem.nodeName.toLowerCase() ];

				if ( hooks && "get" in hooks && (ret = hooks.get( elem, "value" )) !== undefined ) {
					return ret;
				}

				ret = elem.value;

				return typeof ret === "string" ?
					// handle most common string cases
					ret.replace(rreturn, "") :
					// handle cases where value is null/undef or number
					ret == null ? "" : ret;
			}

			return;
		}

		isFunction = jQuery.isFunction( value );

		return this.each(function( i ) {
			var val,
				self = jQuery(this);

			if ( this.nodeType !== 1 ) {
				return;
			}

			if ( isFunction ) {
				val = value.call( this, i, self.val() );
			} else {
				val = value;
			}

			// Treat null/undefined as ""; convert numbers to string
			if ( val == null ) {
				val = "";
			} else if ( typeof val === "number" ) {
				val += "";
			} else if ( jQuery.isArray( val ) ) {
				val = jQuery.map(val, function ( value ) {
					return value == null ? "" : value + "";
				});
			}

			hooks = jQuery.valHooks[ this.type ] || jQuery.valHooks[ this.nodeName.toLowerCase() ];

			// If set returns undefined, fall back to normal setting
			if ( !hooks || !("set" in hooks) || hooks.set( this, val, "value" ) === undefined ) {
				this.value = val;
			}
		});
	}
});

jQuery.extend({
	valHooks: {
		option: {
			get: function( elem ) {
				// attributes.value is undefined in Blackberry 4.7 but
				// uses .value. See #6932
				var val = elem.attributes.value;
				return !val || val.specified ? elem.value : elem.text;
			}
		},
		select: {
			get: function( elem ) {
				var value, i, max, option,
					index = elem.selectedIndex,
					values = [],
					options = elem.options,
					one = elem.type === "select-one";

				// Nothing was selected
				if ( index < 0 ) {
					return null;
				}

				// Loop through all the selected options
				i = one ? index : 0;
				max = one ? index + 1 : options.length;
				for ( ; i < max; i++ ) {
					option = options[ i ];

					// Don't return options that are disabled or in a disabled optgroup
					if ( option.selected && (jQuery.support.optDisabled ? !option.disabled : option.getAttribute("disabled") === null) &&
							(!option.parentNode.disabled || !jQuery.nodeName( option.parentNode, "optgroup" )) ) {

						// Get the specific value for the option
						value = jQuery( option ).val();

						// We don't need an array for one selects
						if ( one ) {
							return value;
						}

						// Multi-Selects return an array
						values.push( value );
					}
				}

				// Fixes Bug #2551 -- select.val() broken in IE after form.reset()
				if ( one && !values.length && options.length ) {
					return jQuery( options[ index ] ).val();
				}

				return values;
			},

			set: function( elem, value ) {
				var values = jQuery.makeArray( value );

				jQuery(elem).find("option").each(function() {
					this.selected = jQuery.inArray( jQuery(this).val(), values ) >= 0;
				});

				if ( !values.length ) {
					elem.selectedIndex = -1;
				}
				return values;
			}
		}
	},

	// Unused in 1.8, left in so attrFn-stabbers won't die; remove in 1.9
	attrFn: {},

	attr: function( elem, name, value, pass ) {
		var ret, hooks, notxml,
			nType = elem.nodeType;

		// don't get/set attributes on text, comment and attribute nodes
		if ( !elem || nType === 3 || nType === 8 || nType === 2 ) {
			return;
		}

		if ( pass && jQuery.isFunction( jQuery.fn[ name ] ) ) {
			return jQuery( elem )[ name ]( value );
		}

		// Fallback to prop when attributes are not supported
		if ( typeof elem.getAttribute === "undefined" ) {
			return jQuery.prop( elem, name, value );
		}

		notxml = nType !== 1 || !jQuery.isXMLDoc( elem );

		// All attributes are lowercase
		// Grab necessary hook if one is defined
		if ( notxml ) {
			name = name.toLowerCase();
			hooks = jQuery.attrHooks[ name ] || ( rboolean.test( name ) ? boolHook : nodeHook );
		}

		if ( value !== undefined ) {

			if ( value === null ) {
				jQuery.removeAttr( elem, name );
				return;

			} else if ( hooks && "set" in hooks && notxml && (ret = hooks.set( elem, value, name )) !== undefined ) {
				return ret;

			} else {
				elem.setAttribute( name, value + "" );
				return value;
			}

		} else if ( hooks && "get" in hooks && notxml && (ret = hooks.get( elem, name )) !== null ) {
			return ret;

		} else {

			ret = elem.getAttribute( name );

			// Non-existent attributes return null, we normalize to undefined
			return ret === null ?
				undefined :
				ret;
		}
	},

	removeAttr: function( elem, value ) {
		var propName, attrNames, name, isBool,
			i = 0;

		if ( value && elem.nodeType === 1 ) {

			attrNames = value.split( core_rspace );

			for ( ; i < attrNames.length; i++ ) {
				name = attrNames[ i ];

				if ( name ) {
					propName = jQuery.propFix[ name ] || name;
					isBool = rboolean.test( name );

					// See #9699 for explanation of this approach (setting first, then removal)
					// Do not do this for boolean attributes (see #10870)
					if ( !isBool ) {
						jQuery.attr( elem, name, "" );
					}
					elem.removeAttribute( getSetAttribute ? name : propName );

					// Set corresponding property to false for boolean attributes
					if ( isBool && propName in elem ) {
						elem[ propName ] = false;
					}
				}
			}
		}
	},

	attrHooks: {
		type: {
			set: function( elem, value ) {
				// We can't allow the type property to be changed (since it causes problems in IE)
				if ( rtype.test( elem.nodeName ) && elem.parentNode ) {
					jQuery.error( "type property can't be changed" );
				} else if ( !jQuery.support.radioValue && value === "radio" && jQuery.nodeName(elem, "input") ) {
					// Setting the type on a radio button after the value resets the value in IE6-9
					// Reset value to it's default in case type is set after value
					// This is for element creation
					var val = elem.value;
					elem.setAttribute( "type", value );
					if ( val ) {
						elem.value = val;
					}
					return value;
				}
			}
		},
		// Use the value property for back compat
		// Use the nodeHook for button elements in IE6/7 (#1954)
		value: {
			get: function( elem, name ) {
				if ( nodeHook && jQuery.nodeName( elem, "button" ) ) {
					return nodeHook.get( elem, name );
				}
				return name in elem ?
					elem.value :
					null;
			},
			set: function( elem, value, name ) {
				if ( nodeHook && jQuery.nodeName( elem, "button" ) ) {
					return nodeHook.set( elem, value, name );
				}
				// Does not return so that setAttribute is also used
				elem.value = value;
			}
		}
	},

	propFix: {
		tabindex: "tabIndex",
		readonly: "readOnly",
		"for": "htmlFor",
		"class": "className",
		maxlength: "maxLength",
		cellspacing: "cellSpacing",
		cellpadding: "cellPadding",
		rowspan: "rowSpan",
		colspan: "colSpan",
		usemap: "useMap",
		frameborder: "frameBorder",
		contenteditable: "contentEditable"
	},

	prop: function( elem, name, value ) {
		var ret, hooks, notxml,
			nType = elem.nodeType;

		// don't get/set properties on text, comment and attribute nodes
		if ( !elem || nType === 3 || nType === 8 || nType === 2 ) {
			return;
		}

		notxml = nType !== 1 || !jQuery.isXMLDoc( elem );

		if ( notxml ) {
			// Fix name and attach hooks
			name = jQuery.propFix[ name ] || name;
			hooks = jQuery.propHooks[ name ];
		}

		if ( value !== undefined ) {
			if ( hooks && "set" in hooks && (ret = hooks.set( elem, value, name )) !== undefined ) {
				return ret;

			} else {
				return ( elem[ name ] = value );
			}

		} else {
			if ( hooks && "get" in hooks && (ret = hooks.get( elem, name )) !== null ) {
				return ret;

			} else {
				return elem[ name ];
			}
		}
	},

	propHooks: {
		tabIndex: {
			get: function( elem ) {
				// elem.tabIndex doesn't always return the correct value when it hasn't been explicitly set
				// http://fluidproject.org/blog/2008/01/09/getting-setting-and-removing-tabindex-values-with-javascript/
				var attributeNode = elem.getAttributeNode("tabindex");

				return attributeNode && attributeNode.specified ?
					parseInt( attributeNode.value, 10 ) :
					rfocusable.test( elem.nodeName ) || rclickable.test( elem.nodeName ) && elem.href ?
						0 :
						undefined;
			}
		}
	}
});

// Hook for boolean attributes
boolHook = {
	get: function( elem, name ) {
		// Align boolean attributes with corresponding properties
		// Fall back to attribute presence where some booleans are not supported
		var attrNode,
			property = jQuery.prop( elem, name );
		return property === true || typeof property !== "boolean" && ( attrNode = elem.getAttributeNode(name) ) && attrNode.nodeValue !== false ?
			name.toLowerCase() :
			undefined;
	},
	set: function( elem, value, name ) {
		var propName;
		if ( value === false ) {
			// Remove boolean attributes when set to false
			jQuery.removeAttr( elem, name );
		} else {
			// value is true since we know at this point it's type boolean and not false
			// Set boolean attributes to the same name and set the DOM property
			propName = jQuery.propFix[ name ] || name;
			if ( propName in elem ) {
				// Only set the IDL specifically if it already exists on the element
				elem[ propName ] = true;
			}

			elem.setAttribute( name, name.toLowerCase() );
		}
		return name;
	}
};

// IE6/7 do not support getting/setting some attributes with get/setAttribute
if ( !getSetAttribute ) {

	fixSpecified = {
		name: true,
		id: true,
		coords: true
	};

	// Use this for any attribute in IE6/7
	// This fixes almost every IE6/7 issue
	nodeHook = jQuery.valHooks.button = {
		get: function( elem, name ) {
			var ret;
			ret = elem.getAttributeNode( name );
			return ret && ( fixSpecified[ name ] ? ret.value !== "" : ret.specified ) ?
				ret.value :
				undefined;
		},
		set: function( elem, value, name ) {
			// Set the existing or create a new attribute node
			var ret = elem.getAttributeNode( name );
			if ( !ret ) {
				ret = document.createAttribute( name );
				elem.setAttributeNode( ret );
			}
			return ( ret.value = value + "" );
		}
	};

	// Set width and height to auto instead of 0 on empty string( Bug #8150 )
	// This is for removals
	jQuery.each([ "width", "height" ], function( i, name ) {
		jQuery.attrHooks[ name ] = jQuery.extend( jQuery.attrHooks[ name ], {
			set: function( elem, value ) {
				if ( value === "" ) {
					elem.setAttribute( name, "auto" );
					return value;
				}
			}
		});
	});

	// Set contenteditable to false on removals(#10429)
	// Setting to empty string throws an error as an invalid value
	jQuery.attrHooks.contenteditable = {
		get: nodeHook.get,
		set: function( elem, value, name ) {
			if ( value === "" ) {
				value = "false";
			}
			nodeHook.set( elem, value, name );
		}
	};
}


// Some attributes require a special call on IE
if ( !jQuery.support.hrefNormalized ) {
	jQuery.each([ "href", "src", "width", "height" ], function( i, name ) {
		jQuery.attrHooks[ name ] = jQuery.extend( jQuery.attrHooks[ name ], {
			get: function( elem ) {
				var ret = elem.getAttribute( name, 2 );
				return ret === null ? undefined : ret;
			}
		});
	});
}

if ( !jQuery.support.style ) {
	jQuery.attrHooks.style = {
		get: function( elem ) {
			// Return undefined in the case of empty string
			// Normalize to lowercase since IE uppercases css property names
			return elem.style.cssText.toLowerCase() || undefined;
		},
		set: function( elem, value ) {
			return ( elem.style.cssText = value + "" );
		}
	};
}

// Safari mis-reports the default selected property of an option
// Accessing the parent's selectedIndex property fixes it
if ( !jQuery.support.optSelected ) {
	jQuery.propHooks.selected = jQuery.extend( jQuery.propHooks.selected, {
		get: function( elem ) {
			var parent = elem.parentNode;

			if ( parent ) {
				parent.selectedIndex;

				// Make sure that it also works with optgroups, see #5701
				if ( parent.parentNode ) {
					parent.parentNode.selectedIndex;
				}
			}
			return null;
		}
	});
}

// IE6/7 call enctype encoding
if ( !jQuery.support.enctype ) {
	jQuery.propFix.enctype = "encoding";
}

// Radios and checkboxes getter/setter
if ( !jQuery.support.checkOn ) {
	jQuery.each([ "radio", "checkbox" ], function() {
		jQuery.valHooks[ this ] = {
			get: function( elem ) {
				// Handle the case where in Webkit "" is returned instead of "on" if a value isn't specified
				return elem.getAttribute("value") === null ? "on" : elem.value;
			}
		};
	});
}
jQuery.each([ "radio", "checkbox" ], function() {
	jQuery.valHooks[ this ] = jQuery.extend( jQuery.valHooks[ this ], {
		set: function( elem, value ) {
			if ( jQuery.isArray( value ) ) {
				return ( elem.checked = jQuery.inArray( jQuery(elem).val(), value ) >= 0 );
			}
		}
	});
});
var rformElems = /^(?:textarea|input|select)$/i,
	rtypenamespace = /^([^\.]*|)(?:\.(.+)|)$/,
	rhoverHack = /(?:^|\s)hover(\.\S+|)\b/,
	rkeyEvent = /^key/,
	rmouseEvent = /^(?:mouse|contextmenu)|click/,
	rfocusMorph = /^(?:focusinfocus|focusoutblur)$/,
	hoverHack = function( events ) {
		return jQuery.event.special.hover ? events : events.replace( rhoverHack, "mouseenter$1 mouseleave$1" );
	};

/*
 * Helper functions for managing events -- not part of the public interface.
 * Props to Dean Edwards' addEvent library for many of the ideas.
 */
jQuery.event = {

	add: function( elem, types, handler, data, selector ) {

		var elemData, eventHandle, events,
			t, tns, type, namespaces, handleObj,
			handleObjIn, handlers, special;

		// Don't attach events to noData or text/comment nodes (allow plain objects tho)
		if ( elem.nodeType === 3 || elem.nodeType === 8 || !types || !handler || !(elemData = jQuery._data( elem )) ) {
			return;
		}

		// Caller can pass in an object of custom data in lieu of the handler
		if ( handler.handler ) {
			handleObjIn = handler;
			handler = handleObjIn.handler;
			selector = handleObjIn.selector;
		}

		// Make sure that the handler has a unique ID, used to find/remove it later
		if ( !handler.guid ) {
			handler.guid = jQuery.guid++;
		}

		// Init the element's event structure and main handler, if this is the first
		events = elemData.events;
		if ( !events ) {
			elemData.events = events = {};
		}
		eventHandle = elemData.handle;
		if ( !eventHandle ) {
			elemData.handle = eventHandle = function( e ) {
				// Discard the second event of a jQuery.event.trigger() and
				// when an event is called after a page has unloaded
				return typeof jQuery !== "undefined" && (!e || jQuery.event.triggered !== e.type) ?
					jQuery.event.dispatch.apply( eventHandle.elem, arguments ) :
					undefined;
			};
			// Add elem as a property of the handle fn to prevent a memory leak with IE non-native events
			eventHandle.elem = elem;
		}

		// Handle multiple events separated by a space
		// jQuery(...).bind("mouseover mouseout", fn);
		types = jQuery.trim( hoverHack(types) ).split( " " );
		for ( t = 0; t < types.length; t++ ) {

			tns = rtypenamespace.exec( types[t] ) || [];
			type = tns[1];
			namespaces = ( tns[2] || "" ).split( "." ).sort();

			// If event changes its type, use the special event handlers for the changed type
			special = jQuery.event.special[ type ] || {};

			// If selector defined, determine special event api type, otherwise given type
			type = ( selector ? special.delegateType : special.bindType ) || type;

			// Update special based on newly reset type
			special = jQuery.event.special[ type ] || {};

			// handleObj is passed to all event handlers
			handleObj = jQuery.extend({
				type: type,
				origType: tns[1],
				data: data,
				handler: handler,
				guid: handler.guid,
				selector: selector,
				needsContext: selector && jQuery.expr.match.needsContext.test( selector ),
				namespace: namespaces.join(".")
			}, handleObjIn );

			// Init the event handler queue if we're the first
			handlers = events[ type ];
			if ( !handlers ) {
				handlers = events[ type ] = [];
				handlers.delegateCount = 0;

				// Only use addEventListener/attachEvent if the special events handler returns false
				if ( !special.setup || special.setup.call( elem, data, namespaces, eventHandle ) === false ) {
					// Bind the global event handler to the element
					if ( elem.addEventListener ) {
						elem.addEventListener( type, eventHandle, false );

					} else if ( elem.attachEvent ) {
						elem.attachEvent( "on" + type, eventHandle );
					}
				}
			}

			if ( special.add ) {
				special.add.call( elem, handleObj );

				if ( !handleObj.handler.guid ) {
					handleObj.handler.guid = handler.guid;
				}
			}

			// Add to the element's handler list, delegates in front
			if ( selector ) {
				handlers.splice( handlers.delegateCount++, 0, handleObj );
			} else {
				handlers.push( handleObj );
			}

			// Keep track of which events have ever been used, for event optimization
			jQuery.event.global[ type ] = true;
		}

		// Nullify elem to prevent memory leaks in IE
		elem = null;
	},

	global: {},

	// Detach an event or set of events from an element
	remove: function( elem, types, handler, selector, mappedTypes ) {

		var t, tns, type, origType, namespaces, origCount,
			j, events, special, eventType, handleObj,
			elemData = jQuery.hasData( elem ) && jQuery._data( elem );

		if ( !elemData || !(events = elemData.events) ) {
			return;
		}

		// Once for each type.namespace in types; type may be omitted
		types = jQuery.trim( hoverHack( types || "" ) ).split(" ");
		for ( t = 0; t < types.length; t++ ) {
			tns = rtypenamespace.exec( types[t] ) || [];
			type = origType = tns[1];
			namespaces = tns[2];

			// Unbind all events (on this namespace, if provided) for the element
			if ( !type ) {
				for ( type in events ) {
					jQuery.event.remove( elem, type + types[ t ], handler, selector, true );
				}
				continue;
			}

			special = jQuery.event.special[ type ] || {};
			type = ( selector? special.delegateType : special.bindType ) || type;
			eventType = events[ type ] || [];
			origCount = eventType.length;
			namespaces = namespaces ? new RegExp("(^|\\.)" + namespaces.split(".").sort().join("\\.(?:.*\\.|)") + "(\\.|$)") : null;

			// Remove matching events
			for ( j = 0; j < eventType.length; j++ ) {
				handleObj = eventType[ j ];

				if ( ( mappedTypes || origType === handleObj.origType ) &&
					 ( !handler || handler.guid === handleObj.guid ) &&
					 ( !namespaces || namespaces.test( handleObj.namespace ) ) &&
					 ( !selector || selector === handleObj.selector || selector === "**" && handleObj.selector ) ) {
					eventType.splice( j--, 1 );

					if ( handleObj.selector ) {
						eventType.delegateCount--;
					}
					if ( special.remove ) {
						special.remove.call( elem, handleObj );
					}
				}
			}

			// Remove generic event handler if we removed something and no more handlers exist
			// (avoids potential for endless recursion during removal of special event handlers)
			if ( eventType.length === 0 && origCount !== eventType.length ) {
				if ( !special.teardown || special.teardown.call( elem, namespaces, elemData.handle ) === false ) {
					jQuery.removeEvent( elem, type, elemData.handle );
				}

				delete events[ type ];
			}
		}

		// Remove the expando if it's no longer used
		if ( jQuery.isEmptyObject( events ) ) {
			delete elemData.handle;

			// removeData also checks for emptiness and clears the expando if empty
			// so use it instead of delete
			jQuery.removeData( elem, "events", true );
		}
	},

	// Events that are safe to short-circuit if no handlers are attached.
	// Native DOM events should not be added, they may have inline handlers.
	customEvent: {
		"getData": true,
		"setData": true,
		"changeData": true
	},

	trigger: function( event, data, elem, onlyHandlers ) {
		// Don't do events on text and comment nodes
		if ( elem && (elem.nodeType === 3 || elem.nodeType === 8) ) {
			return;
		}

		// Event object or event type
		var cache, exclusive, i, cur, old, ontype, special, handle, eventPath, bubbleType,
			type = event.type || event,
			namespaces = [];

		// focus/blur morphs to focusin/out; ensure we're not firing them right now
		if ( rfocusMorph.test( type + jQuery.event.triggered ) ) {
			return;
		}

		if ( type.indexOf( "!" ) >= 0 ) {
			// Exclusive events trigger only for the exact event (no namespaces)
			type = type.slice(0, -1);
			exclusive = true;
		}

		if ( type.indexOf( "." ) >= 0 ) {
			// Namespaced trigger; create a regexp to match event type in handle()
			namespaces = type.split(".");
			type = namespaces.shift();
			namespaces.sort();
		}

		if ( (!elem || jQuery.event.customEvent[ type ]) && !jQuery.event.global[ type ] ) {
			// No jQuery handlers for this event type, and it can't have inline handlers
			return;
		}

		// Caller can pass in an Event, Object, or just an event type string
		event = typeof event === "object" ?
			// jQuery.Event object
			event[ jQuery.expando ] ? event :
			// Object literal
			new jQuery.Event( type, event ) :
			// Just the event type (string)
			new jQuery.Event( type );

		event.type = type;
		event.isTrigger = true;
		event.exclusive = exclusive;
		event.namespace = namespaces.join( "." );
		event.namespace_re = event.namespace? new RegExp("(^|\\.)" + namespaces.join("\\.(?:.*\\.|)") + "(\\.|$)") : null;
		ontype = type.indexOf( ":" ) < 0 ? "on" + type : "";

		// Handle a global trigger
		if ( !elem ) {

			// TODO: Stop taunting the data cache; remove global events and always attach to document
			cache = jQuery.cache;
			for ( i in cache ) {
				if ( cache[ i ].events && cache[ i ].events[ type ] ) {
					jQuery.event.trigger( event, data, cache[ i ].handle.elem, true );
				}
			}
			return;
		}

		// Clean up the event in case it is being reused
		event.result = undefined;
		if ( !event.target ) {
			event.target = elem;
		}

		// Clone any incoming data and prepend the event, creating the handler arg list
		data = data != null ? jQuery.makeArray( data ) : [];
		data.unshift( event );

		// Allow special events to draw outside the lines
		special = jQuery.event.special[ type ] || {};
		if ( special.trigger && special.trigger.apply( elem, data ) === false ) {
			return;
		}

		// Determine event propagation path in advance, per W3C events spec (#9951)
		// Bubble up to document, then to window; watch for a global ownerDocument var (#9724)
		eventPath = [[ elem, special.bindType || type ]];
		if ( !onlyHandlers && !special.noBubble && !jQuery.isWindow( elem ) ) {

			bubbleType = special.delegateType || type;
			cur = rfocusMorph.test( bubbleType + type ) ? elem : elem.parentNode;
			for ( old = elem; cur; cur = cur.parentNode ) {
				eventPath.push([ cur, bubbleType ]);
				old = cur;
			}

			// Only add window if we got to document (e.g., not plain obj or detached DOM)
			if ( old === (elem.ownerDocument || document) ) {
				eventPath.push([ old.defaultView || old.parentWindow || window, bubbleType ]);
			}
		}

		// Fire handlers on the event path
		for ( i = 0; i < eventPath.length && !event.isPropagationStopped(); i++ ) {

			cur = eventPath[i][0];
			event.type = eventPath[i][1];

			handle = ( jQuery._data( cur, "events" ) || {} )[ event.type ] && jQuery._data( cur, "handle" );
			if ( handle ) {
				handle.apply( cur, data );
			}
			// Note that this is a bare JS function and not a jQuery handler
			handle = ontype && cur[ ontype ];
			if ( handle && jQuery.acceptData( cur ) && handle.apply && handle.apply( cur, data ) === false ) {
				event.preventDefault();
			}
		}
		event.type = type;

		// If nobody prevented the default action, do it now
		if ( !onlyHandlers && !event.isDefaultPrevented() ) {

			if ( (!special._default || special._default.apply( elem.ownerDocument, data ) === false) &&
				!(type === "click" && jQuery.nodeName( elem, "a" )) && jQuery.acceptData( elem ) ) {

				// Call a native DOM method on the target with the same name name as the event.
				// Can't use an .isFunction() check here because IE6/7 fails that test.
				// Don't do default actions on window, that's where global variables be (#6170)
				// IE<9 dies on focus/blur to hidden element (#1486)
				if ( ontype && elem[ type ] && ((type !== "focus" && type !== "blur") || event.target.offsetWidth !== 0) && !jQuery.isWindow( elem ) ) {

					// Don't re-trigger an onFOO event when we call its FOO() method
					old = elem[ ontype ];

					if ( old ) {
						elem[ ontype ] = null;
					}

					// Prevent re-triggering of the same event, since we already bubbled it above
					jQuery.event.triggered = type;
					elem[ type ]();
					jQuery.event.triggered = undefined;

					if ( old ) {
						elem[ ontype ] = old;
					}
				}
			}
		}

		return event.result;
	},

	dispatch: function( event ) {

		// Make a writable jQuery.Event from the native event object
		event = jQuery.event.fix( event || window.event );

		var i, j, cur, ret, selMatch, matched, matches, handleObj, sel, related,
			handlers = ( (jQuery._data( this, "events" ) || {} )[ event.type ] || []),
			delegateCount = handlers.delegateCount,
			args = core_slice.call( arguments ),
			run_all = !event.exclusive && !event.namespace,
			special = jQuery.event.special[ event.type ] || {},
			handlerQueue = [];

		// Use the fix-ed jQuery.Event rather than the (read-only) native event
		args[0] = event;
		event.delegateTarget = this;

		// Call the preDispatch hook for the mapped type, and let it bail if desired
		if ( special.preDispatch && special.preDispatch.call( this, event ) === false ) {
			return;
		}

		// Determine handlers that should run if there are delegated events
		// Avoid non-left-click bubbling in Firefox (#3861)
		if ( delegateCount && !(event.button && event.type === "click") ) {

			for ( cur = event.target; cur != this; cur = cur.parentNode || this ) {

				// Don't process clicks (ONLY) on disabled elements (#6911, #8165, #11382, #11764)
				if ( cur.disabled !== true || event.type !== "click" ) {
					selMatch = {};
					matches = [];
					for ( i = 0; i < delegateCount; i++ ) {
						handleObj = handlers[ i ];
						sel = handleObj.selector;

						if ( selMatch[ sel ] === undefined ) {
							selMatch[ sel ] = handleObj.needsContext ?
								jQuery( sel, this ).index( cur ) >= 0 :
								jQuery.find( sel, this, null, [ cur ] ).length;
						}
						if ( selMatch[ sel ] ) {
							matches.push( handleObj );
						}
					}
					if ( matches.length ) {
						handlerQueue.push({ elem: cur, matches: matches });
					}
				}
			}
		}

		// Add the remaining (directly-bound) handlers
		if ( handlers.length > delegateCount ) {
			handlerQueue.push({ elem: this, matches: handlers.slice( delegateCount ) });
		}

		// Run delegates first; they may want to stop propagation beneath us
		for ( i = 0; i < handlerQueue.length && !event.isPropagationStopped(); i++ ) {
			matched = handlerQueue[ i ];
			event.currentTarget = matched.elem;

			for ( j = 0; j < matched.matches.length && !event.isImmediatePropagationStopped(); j++ ) {
				handleObj = matched.matches[ j ];

				// Triggered event must either 1) be non-exclusive and have no namespace, or
				// 2) have namespace(s) a subset or equal to those in the bound event (both can have no namespace).
				if ( run_all || (!event.namespace && !handleObj.namespace) || event.namespace_re && event.namespace_re.test( handleObj.namespace ) ) {

					event.data = handleObj.data;
					event.handleObj = handleObj;

					ret = ( (jQuery.event.special[ handleObj.origType ] || {}).handle || handleObj.handler )
							.apply( matched.elem, args );

					if ( ret !== undefined ) {
						event.result = ret;
						if ( ret === false ) {
							event.preventDefault();
							event.stopPropagation();
						}
					}
				}
			}
		}

		// Call the postDispatch hook for the mapped type
		if ( special.postDispatch ) {
			special.postDispatch.call( this, event );
		}

		return event.result;
	},

	// Includes some event props shared by KeyEvent and MouseEvent
	// *** attrChange attrName relatedNode srcElement  are not normalized, non-W3C, deprecated, will be removed in 1.8 ***
	props: "attrChange attrName relatedNode srcElement altKey bubbles cancelable ctrlKey currentTarget eventPhase metaKey relatedTarget shiftKey target timeStamp view which".split(" "),

	fixHooks: {},

	keyHooks: {
		props: "char charCode key keyCode".split(" "),
		filter: function( event, original ) {

			// Add which for key events
			if ( event.which == null ) {
				event.which = original.charCode != null ? original.charCode : original.keyCode;
			}

			return event;
		}
	},

	mouseHooks: {
		props: "button buttons clientX clientY fromElement offsetX offsetY pageX pageY screenX screenY toElement".split(" "),
		filter: function( event, original ) {
			var eventDoc, doc, body,
				button = original.button,
				fromElement = original.fromElement;

			// Calculate pageX/Y if missing and clientX/Y available
			if ( event.pageX == null && original.clientX != null ) {
				eventDoc = event.target.ownerDocument || document;
				doc = eventDoc.documentElement;
				body = eventDoc.body;

				event.pageX = original.clientX + ( doc && doc.scrollLeft || body && body.scrollLeft || 0 ) - ( doc && doc.clientLeft || body && body.clientLeft || 0 );
				event.pageY = original.clientY + ( doc && doc.scrollTop  || body && body.scrollTop  || 0 ) - ( doc && doc.clientTop  || body && body.clientTop  || 0 );
			}

			// Add relatedTarget, if necessary
			if ( !event.relatedTarget && fromElement ) {
				event.relatedTarget = fromElement === event.target ? original.toElement : fromElement;
			}

			// Add which for click: 1 === left; 2 === middle; 3 === right
			// Note: button is not normalized, so don't use it
			if ( !event.which && button !== undefined ) {
				event.which = ( button & 1 ? 1 : ( button & 2 ? 3 : ( button & 4 ? 2 : 0 ) ) );
			}

			return event;
		}
	},

	fix: function( event ) {
		if ( event[ jQuery.expando ] ) {
			return event;
		}

		// Create a writable copy of the event object and normalize some properties
		var i, prop,
			originalEvent = event,
			fixHook = jQuery.event.fixHooks[ event.type ] || {},
			copy = fixHook.props ? this.props.concat( fixHook.props ) : this.props;

		event = jQuery.Event( originalEvent );

		for ( i = copy.length; i; ) {
			prop = copy[ --i ];
			event[ prop ] = originalEvent[ prop ];
		}

		// Fix target property, if necessary (#1925, IE 6/7/8 & Safari2)
		if ( !event.target ) {
			event.target = originalEvent.srcElement || document;
		}

		// Target should not be a text node (#504, Safari)
		if ( event.target.nodeType === 3 ) {
			event.target = event.target.parentNode;
		}

		// For mouse/key events, metaKey==false if it's undefined (#3368, #11328; IE6/7/8)
		event.metaKey = !!event.metaKey;

		return fixHook.filter? fixHook.filter( event, originalEvent ) : event;
	},

	special: {
		load: {
			// Prevent triggered image.load events from bubbling to window.load
			noBubble: true
		},

		focus: {
			delegateType: "focusin"
		},
		blur: {
			delegateType: "focusout"
		},

		beforeunload: {
			setup: function( data, namespaces, eventHandle ) {
				// We only want to do this special case on windows
				if ( jQuery.isWindow( this ) ) {
					this.onbeforeunload = eventHandle;
				}
			},

			teardown: function( namespaces, eventHandle ) {
				if ( this.onbeforeunload === eventHandle ) {
					this.onbeforeunload = null;
				}
			}
		}
	},

	simulate: function( type, elem, event, bubble ) {
		// Piggyback on a donor event to simulate a different one.
		// Fake originalEvent to avoid donor's stopPropagation, but if the
		// simulated event prevents default then we do the same on the donor.
		var e = jQuery.extend(
			new jQuery.Event(),
			event,
			{ type: type,
				isSimulated: true,
				originalEvent: {}
			}
		);
		if ( bubble ) {
			jQuery.event.trigger( e, null, elem );
		} else {
			jQuery.event.dispatch.call( elem, e );
		}
		if ( e.isDefaultPrevented() ) {
			event.preventDefault();
		}
	}
};

// Some plugins are using, but it's undocumented/deprecated and will be removed.
// The 1.7 special event interface should provide all the hooks needed now.
jQuery.event.handle = jQuery.event.dispatch;

jQuery.removeEvent = document.removeEventListener ?
	function( elem, type, handle ) {
		if ( elem.removeEventListener ) {
			elem.removeEventListener( type, handle, false );
		}
	} :
	function( elem, type, handle ) {
		var name = "on" + type;

		if ( elem.detachEvent ) {

			// #8545, #7054, preventing memory leaks for custom events in IE6-8 –
			// detachEvent needed property on element, by name of that event, to properly expose it to GC
			if ( typeof elem[ name ] === "undefined" ) {
				elem[ name ] = null;
			}

			elem.detachEvent( name, handle );
		}
	};

jQuery.Event = function( src, props ) {
	// Allow instantiation without the 'new' keyword
	if ( !(this instanceof jQuery.Event) ) {
		return new jQuery.Event( src, props );
	}

	// Event object
	if ( src && src.type ) {
		this.originalEvent = src;
		this.type = src.type;

		// Events bubbling up the document may have been marked as prevented
		// by a handler lower down the tree; reflect the correct value.
		this.isDefaultPrevented = ( src.defaultPrevented || src.returnValue === false ||
			src.getPreventDefault && src.getPreventDefault() ) ? returnTrue : returnFalse;

	// Event type
	} else {
		this.type = src;
	}

	// Put explicitly provided properties onto the event object
	if ( props ) {
		jQuery.extend( this, props );
	}

	// Create a timestamp if incoming event doesn't have one
	this.timeStamp = src && src.timeStamp || jQuery.now();

	// Mark it as fixed
	this[ jQuery.expando ] = true;
};

function returnFalse() {
	return false;
}
function returnTrue() {
	return true;
}

// jQuery.Event is based on DOM3 Events as specified by the ECMAScript Language Binding
// http://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331/ecma-script-binding.html
jQuery.Event.prototype = {
	preventDefault: function() {
		this.isDefaultPrevented = returnTrue;

		var e = this.originalEvent;
		if ( !e ) {
			return;
		}

		// if preventDefault exists run it on the original event
		if ( e.preventDefault ) {
			e.preventDefault();

		// otherwise set the returnValue property of the original event to false (IE)
		} else {
			e.returnValue = false;
		}
	},
	stopPropagation: function() {
		this.isPropagationStopped = returnTrue;

		var e = this.originalEvent;
		if ( !e ) {
			return;
		}
		// if stopPropagation exists run it on the original event
		if ( e.stopPropagation ) {
			e.stopPropagation();
		}
		// otherwise set the cancelBubble property of the original event to true (IE)
		e.cancelBubble = true;
	},
	stopImmediatePropagation: function() {
		this.isImmediatePropagationStopped = returnTrue;
		this.stopPropagation();
	},
	isDefaultPrevented: returnFalse,
	isPropagationStopped: returnFalse,
	isImmediatePropagationStopped: returnFalse
};

// Create mouseenter/leave events using mouseover/out and event-time checks
jQuery.each({
	mouseenter: "mouseover",
	mouseleave: "mouseout"
}, function( orig, fix ) {
	jQuery.event.special[ orig ] = {
		delegateType: fix,
		bindType: fix,

		handle: function( event ) {
			var ret,
				target = this,
				related = event.relatedTarget,
				handleObj = event.handleObj,
				selector = handleObj.selector;

			// For mousenter/leave call the handler if related is outside the target.
			// NB: No relatedTarget if the mouse left/entered the browser window
			if ( !related || (related !== target && !jQuery.contains( target, related )) ) {
				event.type = handleObj.origType;
				ret = handleObj.handler.apply( this, arguments );
				event.type = fix;
			}
			return ret;
		}
	};
});

// IE submit delegation
if ( !jQuery.support.submitBubbles ) {

	jQuery.event.special.submit = {
		setup: function() {
			// Only need this for delegated form submit events
			if ( jQuery.nodeName( this, "form" ) ) {
				return false;
			}

			// Lazy-add a submit handler when a descendant form may potentially be submitted
			jQuery.event.add( this, "click._submit keypress._submit", function( e ) {
				// Node name check avoids a VML-related crash in IE (#9807)
				var elem = e.target,
					form = jQuery.nodeName( elem, "input" ) || jQuery.nodeName( elem, "button" ) ? elem.form : undefined;
				if ( form && !jQuery._data( form, "_submit_attached" ) ) {
					jQuery.event.add( form, "submit._submit", function( event ) {
						event._submit_bubble = true;
					});
					jQuery._data( form, "_submit_attached", true );
				}
			});
			// return undefined since we don't need an event listener
		},

		postDispatch: function( event ) {
			// If form was submitted by the user, bubble the event up the tree
			if ( event._submit_bubble ) {
				delete event._submit_bubble;
				if ( this.parentNode && !event.isTrigger ) {
					jQuery.event.simulate( "submit", this.parentNode, event, true );
				}
			}
		},

		teardown: function() {
			// Only need this for delegated form submit events
			if ( jQuery.nodeName( this, "form" ) ) {
				return false;
			}

			// Remove delegated handlers; cleanData eventually reaps submit handlers attached above
			jQuery.event.remove( this, "._submit" );
		}
	};
}

// IE change delegation and checkbox/radio fix
if ( !jQuery.support.changeBubbles ) {

	jQuery.event.special.change = {

		setup: function() {

			if ( rformElems.test( this.nodeName ) ) {
				// IE doesn't fire change on a check/radio until blur; trigger it on click
				// after a propertychange. Eat the blur-change in special.change.handle.
				// This still fires onchange a second time for check/radio after blur.
				if ( this.type === "checkbox" || this.type === "radio" ) {
					jQuery.event.add( this, "propertychange._change", function( event ) {
						if ( event.originalEvent.propertyName === "checked" ) {
							this._just_changed = true;
						}
					});
					jQuery.event.add( this, "click._change", function( event ) {
						if ( this._just_changed && !event.isTrigger ) {
							this._just_changed = false;
						}
						// Allow triggered, simulated change events (#11500)
						jQuery.event.simulate( "change", this, event, true );
					});
				}
				return false;
			}
			// Delegated event; lazy-add a change handler on descendant inputs
			jQuery.event.add( this, "beforeactivate._change", function( e ) {
				var elem = e.target;

				if ( rformElems.test( elem.nodeName ) && !jQuery._data( elem, "_change_attached" ) ) {
					jQuery.event.add( elem, "change._change", function( event ) {
						if ( this.parentNode && !event.isSimulated && !event.isTrigger ) {
							jQuery.event.simulate( "change", this.parentNode, event, true );
						}
					});
					jQuery._data( elem, "_change_attached", true );
				}
			});
		},

		handle: function( event ) {
			var elem = event.target;

			// Swallow native change events from checkbox/radio, we already triggered them above
			if ( this !== elem || event.isSimulated || event.isTrigger || (elem.type !== "radio" && elem.type !== "checkbox") ) {
				return event.handleObj.handler.apply( this, arguments );
			}
		},

		teardown: function() {
			jQuery.event.remove( this, "._change" );

			return !rformElems.test( this.nodeName );
		}
	};
}

// Create "bubbling" focus and blur events
if ( !jQuery.support.focusinBubbles ) {
	jQuery.each({ focus: "focusin", blur: "focusout" }, function( orig, fix ) {

		// Attach a single capturing handler while someone wants focusin/focusout
		var attaches = 0,
			handler = function( event ) {
				jQuery.event.simulate( fix, event.target, jQuery.event.fix( event ), true );
			};

		jQuery.event.special[ fix ] = {
			setup: function() {
				if ( attaches++ === 0 ) {
					document.addEventListener( orig, handler, true );
				}
			},
			teardown: function() {
				if ( --attaches === 0 ) {
					document.removeEventListener( orig, handler, true );
				}
			}
		};
	});
}

jQuery.fn.extend({

	on: function( types, selector, data, fn, /*INTERNAL*/ one ) {
		var origFn, type;

		// Types can be a map of types/handlers
		if ( typeof types === "object" ) {
			// ( types-Object, selector, data )
			if ( typeof selector !== "string" ) { // && selector != null
				// ( types-Object, data )
				data = data || selector;
				selector = undefined;
			}
			for ( type in types ) {
				this.on( type, selector, data, types[ type ], one );
			}
			return this;
		}

		if ( data == null && fn == null ) {
			// ( types, fn )
			fn = selector;
			data = selector = undefined;
		} else if ( fn == null ) {
			if ( typeof selector === "string" ) {
				// ( types, selector, fn )
				fn = data;
				data = undefined;
			} else {
				// ( types, data, fn )
				fn = data;
				data = selector;
				selector = undefined;
			}
		}
		if ( fn === false ) {
			fn = returnFalse;
		} else if ( !fn ) {
			return this;
		}

		if ( one === 1 ) {
			origFn = fn;
			fn = function( event ) {
				// Can use an empty set, since event contains the info
				jQuery().off( event );
				return origFn.apply( this, arguments );
			};
			// Use same guid so caller can remove using origFn
			fn.guid = origFn.guid || ( origFn.guid = jQuery.guid++ );
		}
		return this.each( function() {
			jQuery.event.add( this, types, fn, data, selector );
		});
	},
	one: function( types, selector, data, fn ) {
		return this.on( types, selector, data, fn, 1 );
	},
	off: function( types, selector, fn ) {
		var handleObj, type;
		if ( types && types.preventDefault && types.handleObj ) {
			// ( event )  dispatched jQuery.Event
			handleObj = types.handleObj;
			jQuery( types.delegateTarget ).off(
				handleObj.namespace ? handleObj.origType + "." + handleObj.namespace : handleObj.origType,
				handleObj.selector,
				handleObj.handler
			);
			return this;
		}
		if ( typeof types === "object" ) {
			// ( types-object [, selector] )
			for ( type in types ) {
				this.off( type, selector, types[ type ] );
			}
			return this;
		}
		if ( selector === false || typeof selector === "function" ) {
			// ( types [, fn] )
			fn = selector;
			selector = undefined;
		}
		if ( fn === false ) {
			fn = returnFalse;
		}
		return this.each(function() {
			jQuery.event.remove( this, types, fn, selector );
		});
	},

	bind: function( types, data, fn ) {
		return this.on( types, null, data, fn );
	},
	unbind: function( types, fn ) {
		return this.off( types, null, fn );
	},

	live: function( types, data, fn ) {
		jQuery( this.context ).on( types, this.selector, data, fn );
		return this;
	},
	die: function( types, fn ) {
		jQuery( this.context ).off( types, this.selector || "**", fn );
		return this;
	},

	delegate: function( selector, types, data, fn ) {
		return this.on( types, selector, data, fn );
	},
	undelegate: function( selector, types, fn ) {
		// ( namespace ) or ( selector, types [, fn] )
		return arguments.length === 1 ? this.off( selector, "**" ) : this.off( types, selector || "**", fn );
	},

	trigger: function( type, data ) {
		return this.each(function() {
			jQuery.event.trigger( type, data, this );
		});
	},
	triggerHandler: function( type, data ) {
		if ( this[0] ) {
			return jQuery.event.trigger( type, data, this[0], true );
		}
	},

	toggle: function( fn ) {
		// Save reference to arguments for access in closure
		var args = arguments,
			guid = fn.guid || jQuery.guid++,
			i = 0,
			toggler = function( event ) {
				// Figure out which function to execute
				var lastToggle = ( jQuery._data( this, "lastToggle" + fn.guid ) || 0 ) % i;
				jQuery._data( this, "lastToggle" + fn.guid, lastToggle + 1 );

				// Make sure that clicks stop
				event.preventDefault();

				// and execute the function
				return args[ lastToggle ].apply( this, arguments ) || false;
			};

		// link all the functions, so any of them can unbind this click handler
		toggler.guid = guid;
		while ( i < args.length ) {
			args[ i++ ].guid = guid;
		}

		return this.click( toggler );
	},

	hover: function( fnOver, fnOut ) {
		return this.mouseenter( fnOver ).mouseleave( fnOut || fnOver );
	}
});

jQuery.each( ("blur focus focusin focusout load resize scroll unload click dblclick " +
	"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave " +
	"change select submit keydown keypress keyup error contextmenu").split(" "), function( i, name ) {

	// Handle event binding
	jQuery.fn[ name ] = function( data, fn ) {
		if ( fn == null ) {
			fn = data;
			data = null;
		}

		return arguments.length > 0 ?
			this.on( name, null, data, fn ) :
			this.trigger( name );
	};

	if ( rkeyEvent.test( name ) ) {
		jQuery.event.fixHooks[ name ] = jQuery.event.keyHooks;
	}

	if ( rmouseEvent.test( name ) ) {
		jQuery.event.fixHooks[ name ] = jQuery.event.mouseHooks;
	}
});
/*!
 * Sizzle CSS Selector Engine
 * Copyright 2012 jQuery Foundation and other contributors
 * Released under the MIT license
 * http://sizzlejs.com/
 */
(function( window, undefined ) {

var cachedruns,
	assertGetIdNotName,
	Expr,
	getText,
	isXML,
	contains,
	compile,
	sortOrder,
	hasDuplicate,
	outermostContext,

	baseHasDuplicate = true,
	strundefined = "undefined",

	expando = ( "sizcache" + Math.random() ).replace( ".", "" ),

	Token = String,
	document = window.document,
	docElem = document.documentElement,
	dirruns = 0,
	done = 0,
	pop = [].pop,
	push = [].push,
	slice = [].slice,
	// Use a stripped-down indexOf if a native one is unavailable
	indexOf = [].indexOf || function( elem ) {
		var i = 0,
			len = this.length;
		for ( ; i < len; i++ ) {
			if ( this[i] === elem ) {
				return i;
			}
		}
		return -1;
	},

	// Augment a function for special use by Sizzle
	markFunction = function( fn, value ) {
		fn[ expando ] = value == null || value;
		return fn;
	},

	createCache = function() {
		var cache = {},
			keys = [];

		return markFunction(function( key, value ) {
			// Only keep the most recent entries
			if ( keys.push( key ) > Expr.cacheLength ) {
				delete cache[ keys.shift() ];
			}

			return (cache[ key ] = value);
		}, cache );
	},

	classCache = createCache(),
	tokenCache = createCache(),
	compilerCache = createCache(),

	// Regex

	// Whitespace characters http://www.w3.org/TR/css3-selectors/#whitespace
	whitespace = "[\\x20\\t\\r\\n\\f]",
	// http://www.w3.org/TR/css3-syntax/#characters
	characterEncoding = "(?:\\\\.|[-\\w]|[^\\x00-\\xa0])+",

	// Loosely modeled on CSS identifier characters
	// An unquoted value should be a CSS identifier (http://www.w3.org/TR/css3-selectors/#attribute-selectors)
	// Proper syntax: http://www.w3.org/TR/CSS21/syndata.html#value-def-identifier
	identifier = characterEncoding.replace( "w", "w#" ),

	// Acceptable operators http://www.w3.org/TR/selectors/#attribute-selectors
	operators = "([*^$|!~]?=)",
	attributes = "\\[" + whitespace + "*(" + characterEncoding + ")" + whitespace +
		"*(?:" + operators + whitespace + "*(?:(['\"])((?:\\\\.|[^\\\\])*?)\\3|(" + identifier + ")|)|)" + whitespace + "*\\]",

	// Prefer arguments not in parens/brackets,
	//   then attribute selectors and non-pseudos (denoted by :),
	//   then anything else
	// These preferences are here to reduce the number of selectors
	//   needing tokenize in the PSEUDO preFilter
	pseudos = ":(" + characterEncoding + ")(?:\\((?:(['\"])((?:\\\\.|[^\\\\])*?)\\2|([^()[\\]]*|(?:(?:" + attributes + ")|[^:]|\\\\.)*|.*))\\)|)",

	// For matchExpr.POS and matchExpr.needsContext
	pos = ":(even|odd|eq|gt|lt|nth|first|last)(?:\\(" + whitespace +
		"*((?:-\\d)?\\d*)" + whitespace + "*\\)|)(?=[^-]|$)",

	// Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter
	rtrim = new RegExp( "^" + whitespace + "+|((?:^|[^\\\\])(?:\\\\.)*)" + whitespace + "+$", "g" ),

	rcomma = new RegExp( "^" + whitespace + "*," + whitespace + "*" ),
	rcombinators = new RegExp( "^" + whitespace + "*([\\x20\\t\\r\\n\\f>+~])" + whitespace + "*" ),
	rpseudo = new RegExp( pseudos ),

	// Easily-parseable/retrievable ID or TAG or CLASS selectors
	rquickExpr = /^(?:#([\w\-]+)|(\w+)|\.([\w\-]+))$/,

	rnot = /^:not/,
	rsibling = /[\x20\t\r\n\f]*[+~]/,
	rendsWithNot = /:not\($/,

	rheader = /h\d/i,
	rinputs = /input|select|textarea|button/i,

	rbackslash = /\\(?!\\)/g,

	matchExpr = {
		"ID": new RegExp( "^#(" + characterEncoding + ")" ),
		"CLASS": new RegExp( "^\\.(" + characterEncoding + ")" ),
		"NAME": new RegExp( "^\\[name=['\"]?(" + characterEncoding + ")['\"]?\\]" ),
		"TAG": new RegExp( "^(" + characterEncoding.replace( "w", "w*" ) + ")" ),
		"ATTR": new RegExp( "^" + attributes ),
		"PSEUDO": new RegExp( "^" + pseudos ),
		"POS": new RegExp( pos, "i" ),
		"CHILD": new RegExp( "^:(only|nth|first|last)-child(?:\\(" + whitespace +
			"*(even|odd|(([+-]|)(\\d*)n|)" + whitespace + "*(?:([+-]|)" + whitespace +
			"*(\\d+)|))" + whitespace + "*\\)|)", "i" ),
		// For use in libraries implementing .is()
		"needsContext": new RegExp( "^" + whitespace + "*[>+~]|" + pos, "i" )
	},

	// Support

	// Used for testing something on an element
	assert = function( fn ) {
		var div = document.createElement("div");

		try {
			return fn( div );
		} catch (e) {
			return false;
		} finally {
			// release memory in IE
			div = null;
		}
	},

	// Check if getElementsByTagName("*") returns only elements
	assertTagNameNoComments = assert(function( div ) {
		div.appendChild( document.createComment("") );
		return !div.getElementsByTagName("*").length;
	}),

	// Check if getAttribute returns normalized href attributes
	assertHrefNotNormalized = assert(function( div ) {
		div.innerHTML = "<a href='#'></a>";
		return div.firstChild && typeof div.firstChild.getAttribute !== strundefined &&
			div.firstChild.getAttribute("href") === "#";
	}),

	// Check if attributes should be retrieved by attribute nodes
	assertAttributes = assert(function( div ) {
		div.innerHTML = "<select></select>";
		var type = typeof div.lastChild.getAttribute("multiple");
		// IE8 returns a string for some attributes even when not present
		return type !== "boolean" && type !== "string";
	}),

	// Check if getElementsByClassName can be trusted
	assertUsableClassName = assert(function( div ) {
		// Opera can't find a second classname (in 9.6)
		div.innerHTML = "<div class='hidden e'></div><div class='hidden'></div>";
		if ( !div.getElementsByClassName || !div.getElementsByClassName("e").length ) {
			return false;
		}

		// Safari 3.2 caches class attributes and doesn't catch changes
		div.lastChild.className = "e";
		return div.getElementsByClassName("e").length === 2;
	}),

	// Check if getElementById returns elements by name
	// Check if getElementsByName privileges form controls or returns elements by ID
	assertUsableName = assert(function( div ) {
		// Inject content
		div.id = expando + 0;
		div.innerHTML = "<a name='" + expando + "'></a><div name='" + expando + "'></div>";
		docElem.insertBefore( div, docElem.firstChild );

		// Test
		var pass = document.getElementsByName &&
			// buggy browsers will return fewer than the correct 2
			document.getElementsByName( expando ).length === 2 +
			// buggy browsers will return more than the correct 0
			document.getElementsByName( expando + 0 ).length;
		assertGetIdNotName = !document.getElementById( expando );

		// Cleanup
		docElem.removeChild( div );

		return pass;
	});

// If slice is not available, provide a backup
try {
	slice.call( docElem.childNodes, 0 )[0].nodeType;
} catch ( e ) {
	slice = function( i ) {
		var elem,
			results = [];
		for ( ; (elem = this[i]); i++ ) {
			results.push( elem );
		}
		return results;
	};
}

function Sizzle( selector, context, results, seed ) {
	results = results || [];
	context = context || document;
	var match, elem, xml, m,
		nodeType = context.nodeType;

	if ( !selector || typeof selector !== "string" ) {
		return results;
	}

	if ( nodeType !== 1 && nodeType !== 9 ) {
		return [];
	}

	xml = isXML( context );

	if ( !xml && !seed ) {
		if ( (match = rquickExpr.exec( selector )) ) {
			// Speed-up: Sizzle("#ID")
			if ( (m = match[1]) ) {
				if ( nodeType === 9 ) {
					elem = context.getElementById( m );
					// Check parentNode to catch when Blackberry 4.6 returns
					// nodes that are no longer in the document #6963
					if ( elem && elem.parentNode ) {
						// Handle the case where IE, Opera, and Webkit return items
						// by name instead of ID
						if ( elem.id === m ) {
							results.push( elem );
							return results;
						}
					} else {
						return results;
					}
				} else {
					// Context is not a document
					if ( context.ownerDocument && (elem = context.ownerDocument.getElementById( m )) &&
						contains( context, elem ) && elem.id === m ) {
						results.push( elem );
						return results;
					}
				}

			// Speed-up: Sizzle("TAG")
			} else if ( match[2] ) {
				push.apply( results, slice.call(context.getElementsByTagName( selector ), 0) );
				return results;

			// Speed-up: Sizzle(".CLASS")
			} else if ( (m = match[3]) && assertUsableClassName && context.getElementsByClassName ) {
				push.apply( results, slice.call(context.getElementsByClassName( m ), 0) );
				return results;
			}
		}
	}

	// All others
	return select( selector.replace( rtrim, "$1" ), context, results, seed, xml );
}

Sizzle.matches = function( expr, elements ) {
	return Sizzle( expr, null, null, elements );
};

Sizzle.matchesSelector = function( elem, expr ) {
	return Sizzle( expr, null, null, [ elem ] ).length > 0;
};

// Returns a function to use in pseudos for input types
function createInputPseudo( type ) {
	return function( elem ) {
		var name = elem.nodeName.toLowerCase();
		return name === "input" && elem.type === type;
	};
}

// Returns a function to use in pseudos for buttons
function createButtonPseudo( type ) {
	return function( elem ) {
		var name = elem.nodeName.toLowerCase();
		return (name === "input" || name === "button") && elem.type === type;
	};
}

// Returns a function to use in pseudos for positionals
function createPositionalPseudo( fn ) {
	return markFunction(function( argument ) {
		argument = +argument;
		return markFunction(function( seed, matches ) {
			var j,
				matchIndexes = fn( [], seed.length, argument ),
				i = matchIndexes.length;

			// Match elements found at the specified indexes
			while ( i-- ) {
				if ( seed[ (j = matchIndexes[i]) ] ) {
					seed[j] = !(matches[j] = seed[j]);
				}
			}
		});
	});
}

/**
 * Utility function for retrieving the text value of an array of DOM nodes
 * @param {Array|Element} elem
 */
getText = Sizzle.getText = function( elem ) {
	var node,
		ret = "",
		i = 0,
		nodeType = elem.nodeType;

	if ( nodeType ) {
		if ( nodeType === 1 || nodeType === 9 || nodeType === 11 ) {
			// Use textContent for elements
			// innerText usage removed for consistency of new lines (see #11153)
			if ( typeof elem.textContent === "string" ) {
				return elem.textContent;
			} else {
				// Traverse its children
				for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {
					ret += getText( elem );
				}
			}
		} else if ( nodeType === 3 || nodeType === 4 ) {
			return elem.nodeValue;
		}
		// Do not include comment or processing instruction nodes
	} else {

		// If no nodeType, this is expected to be an array
		for ( ; (node = elem[i]); i++ ) {
			// Do not traverse comment nodes
			ret += getText( node );
		}
	}
	return ret;
};

isXML = Sizzle.isXML = function( elem ) {
	// documentElement is verified for cases where it doesn't yet exist
	// (such as loading iframes in IE - #4833)
	var documentElement = elem && (elem.ownerDocument || elem).documentElement;
	return documentElement ? documentElement.nodeName !== "HTML" : false;
};

// Element contains another
contains = Sizzle.contains = docElem.contains ?
	function( a, b ) {
		var adown = a.nodeType === 9 ? a.documentElement : a,
			bup = b && b.parentNode;
		return a === bup || !!( bup && bup.nodeType === 1 && adown.contains && adown.contains(bup) );
	} :
	docElem.compareDocumentPosition ?
	function( a, b ) {
		return b && !!( a.compareDocumentPosition( b ) & 16 );
	} :
	function( a, b ) {
		while ( (b = b.parentNode) ) {
			if ( b === a ) {
				return true;
			}
		}
		return false;
	};

Sizzle.attr = function( elem, name ) {
	var val,
		xml = isXML( elem );

	if ( !xml ) {
		name = name.toLowerCase();
	}
	if ( (val = Expr.attrHandle[ name ]) ) {
		return val( elem );
	}
	if ( xml || assertAttributes ) {
		return elem.getAttribute( name );
	}
	val = elem.getAttributeNode( name );
	return val ?
		typeof elem[ name ] === "boolean" ?
			elem[ name ] ? name : null :
			val.specified ? val.value : null :
		null;
};

Expr = Sizzle.selectors = {

	// Can be adjusted by the user
	cacheLength: 50,

	createPseudo: markFunction,

	match: matchExpr,

	// IE6/7 return a modified href
	attrHandle: assertHrefNotNormalized ?
		{} :
		{
			"href": function( elem ) {
				return elem.getAttribute( "href", 2 );
			},
			"type": function( elem ) {
				return elem.getAttribute("type");
			}
		},

	find: {
		"ID": assertGetIdNotName ?
			function( id, context, xml ) {
				if ( typeof context.getElementById !== strundefined && !xml ) {
					var m = context.getElementById( id );
					// Check parentNode to catch when Blackberry 4.6 returns
					// nodes that are no longer in the document #6963
					return m && m.parentNode ? [m] : [];
				}
			} :
			function( id, context, xml ) {
				if ( typeof context.getElementById !== strundefined && !xml ) {
					var m = context.getElementById( id );

					return m ?
						m.id === id || typeof m.getAttributeNode !== strundefined && m.getAttributeNode("id").value === id ?
							[m] :
							undefined :
						[];
				}
			},

		"TAG": assertTagNameNoComments ?
			function( tag, context ) {
				if ( typeof context.getElementsByTagName !== strundefined ) {
					return context.getElementsByTagName( tag );
				}
			} :
			function( tag, context ) {
				var results = context.getElementsByTagName( tag );

				// Filter out possible comments
				if ( tag === "*" ) {
					var elem,
						tmp = [],
						i = 0;

					for ( ; (elem = results[i]); i++ ) {
						if ( elem.nodeType === 1 ) {
							tmp.push( elem );
						}
					}

					return tmp;
				}
				return results;
			},

		"NAME": assertUsableName && function( tag, context ) {
			if ( typeof context.getElementsByName !== strundefined ) {
				return context.getElementsByName( name );
			}
		},

		"CLASS": assertUsableClassName && function( className, context, xml ) {
			if ( typeof context.getElementsByClassName !== strundefined && !xml ) {
				return context.getElementsByClassName( className );
			}
		}
	},

	relative: {
		">": { dir: "parentNode", first: true },
		" ": { dir: "parentNode" },
		"+": { dir: "previousSibling", first: true },
		"~": { dir: "previousSibling" }
	},

	preFilter: {
		"ATTR": function( match ) {
			match[1] = match[1].replace( rbackslash, "" );

			// Move the given value to match[3] whether quoted or unquoted
			match[3] = ( match[4] || match[5] || "" ).replace( rbackslash, "" );

			if ( match[2] === "~=" ) {
				match[3] = " " + match[3] + " ";
			}

			return match.slice( 0, 4 );
		},

		"CHILD": function( match ) {
			/* matches from matchExpr["CHILD"]
				1 type (only|nth|...)
				2 argument (even|odd|\d*|\d*n([+-]\d+)?|...)
				3 xn-component of xn+y argument ([+-]?\d*n|)
				4 sign of xn-component
				5 x of xn-component
				6 sign of y-component
				7 y of y-component
			*/
			match[1] = match[1].toLowerCase();

			if ( match[1] === "nth" ) {
				// nth-child requires argument
				if ( !match[2] ) {
					Sizzle.error( match[0] );
				}

				// numeric x and y parameters for Expr.filter.CHILD
				// remember that false/true cast respectively to 0/1
				match[3] = +( match[3] ? match[4] + (match[5] || 1) : 2 * ( match[2] === "even" || match[2] === "odd" ) );
				match[4] = +( ( match[6] + match[7] ) || match[2] === "odd" );

			// other types prohibit arguments
			} else if ( match[2] ) {
				Sizzle.error( match[0] );
			}

			return match;
		},

		"PSEUDO": function( match ) {
			var unquoted, excess;
			if ( matchExpr["CHILD"].test( match[0] ) ) {
				return null;
			}

			if ( match[3] ) {
				match[2] = match[3];
			} else if ( (unquoted = match[4]) ) {
				// Only check arguments that contain a pseudo
				if ( rpseudo.test(unquoted) &&
					// Get excess from tokenize (recursively)
					(excess = tokenize( unquoted, true )) &&
					// advance to the next closing parenthesis
					(excess = unquoted.indexOf( ")", unquoted.length - excess ) - unquoted.length) ) {

					// excess is a negative index
					unquoted = unquoted.slice( 0, excess );
					match[0] = match[0].slice( 0, excess );
				}
				match[2] = unquoted;
			}

			// Return only captures needed by the pseudo filter method (type and argument)
			return match.slice( 0, 3 );
		}
	},

	filter: {
		"ID": assertGetIdNotName ?
			function( id ) {
				id = id.replace( rbackslash, "" );
				return function( elem ) {
					return elem.getAttribute("id") === id;
				};
			} :
			function( id ) {
				id = id.replace( rbackslash, "" );
				return function( elem ) {
					var node = typeof elem.getAttributeNode !== strundefined && elem.getAttributeNode("id");
					return node && node.value === id;
				};
			},

		"TAG": function( nodeName ) {
			if ( nodeName === "*" ) {
				return function() { return true; };
			}
			nodeName = nodeName.replace( rbackslash, "" ).toLowerCase();

			return function( elem ) {
				return elem.nodeName && elem.nodeName.toLowerCase() === nodeName;
			};
		},

		"CLASS": function( className ) {
			var pattern = classCache[ expando ][ className ];
			if ( !pattern ) {
				pattern = classCache( className, new RegExp("(^|" + whitespace + ")" + className + "(" + whitespace + "|$)") );
			}
			return function( elem ) {
				return pattern.test( elem.className || (typeof elem.getAttribute !== strundefined && elem.getAttribute("class")) || "" );
			};
		},

		"ATTR": function( name, operator, check ) {
			return function( elem, context ) {
				var result = Sizzle.attr( elem, name );

				if ( result == null ) {
					return operator === "!=";
				}
				if ( !operator ) {
					return true;
				}

				result += "";

				return operator === "=" ? result === check :
					operator === "!=" ? result !== check :
					operator === "^=" ? check && result.indexOf( check ) === 0 :
					operator === "*=" ? check && result.indexOf( check ) > -1 :
					operator === "$=" ? check && result.substr( result.length - check.length ) === check :
					operator === "~=" ? ( " " + result + " " ).indexOf( check ) > -1 :
					operator === "|=" ? result === check || result.substr( 0, check.length + 1 ) === check + "-" :
					false;
			};
		},

		"CHILD": function( type, argument, first, last ) {

			if ( type === "nth" ) {
				return function( elem ) {
					var node, diff,
						parent = elem.parentNode;

					if ( first === 1 && last === 0 ) {
						return true;
					}

					if ( parent ) {
						diff = 0;
						for ( node = parent.firstChild; node; node = node.nextSibling ) {
							if ( node.nodeType === 1 ) {
								diff++;
								if ( elem === node ) {
									break;
								}
							}
						}
					}

					// Incorporate the offset (or cast to NaN), then check against cycle size
					diff -= last;
					return diff === first || ( diff % first === 0 && diff / first >= 0 );
				};
			}

			return function( elem ) {
				var node = elem;

				switch ( type ) {
					case "only":
					case "first":
						while ( (node = node.previousSibling) ) {
							if ( node.nodeType === 1 ) {
								return false;
							}
						}

						if ( type === "first" ) {
							return true;
						}

						node = elem;

						/* falls through */
					case "last":
						while ( (node = node.nextSibling) ) {
							if ( node.nodeType === 1 ) {
								return false;
							}
						}

						return true;
				}
			};
		},

		"PSEUDO": function( pseudo, argument ) {
			// pseudo-class names are case-insensitive
			// http://www.w3.org/TR/selectors/#pseudo-classes
			// Prioritize by case sensitivity in case custom pseudos are added with uppercase letters
			// Remember that setFilters inherits from pseudos
			var args,
				fn = Expr.pseudos[ pseudo ] || Expr.setFilters[ pseudo.toLowerCase() ] ||
					Sizzle.error( "unsupported pseudo: " + pseudo );

			// The user may use createPseudo to indicate that
			// arguments are needed to create the filter function
			// just as Sizzle does
			if ( fn[ expando ] ) {
				return fn( argument );
			}

			// But maintain support for old signatures
			if ( fn.length > 1 ) {
				args = [ pseudo, pseudo, "", argument ];
				return Expr.setFilters.hasOwnProperty( pseudo.toLowerCase() ) ?
					markFunction(function( seed, matches ) {
						var idx,
							matched = fn( seed, argument ),
							i = matched.length;
						while ( i-- ) {
							idx = indexOf.call( seed, matched[i] );
							seed[ idx ] = !( matches[ idx ] = matched[i] );
						}
					}) :
					function( elem ) {
						return fn( elem, 0, args );
					};
			}

			return fn;
		}
	},

	pseudos: {
		"not": markFunction(function( selector ) {
			// Trim the selector passed to compile
			// to avoid treating leading and trailing
			// spaces as combinators
			var input = [],
				results = [],
				matcher = compile( selector.replace( rtrim, "$1" ) );

			return matcher[ expando ] ?
				markFunction(function( seed, matches, context, xml ) {
					var elem,
						unmatched = matcher( seed, null, xml, [] ),
						i = seed.length;

					// Match elements unmatched by `matcher`
					while ( i-- ) {
						if ( (elem = unmatched[i]) ) {
							seed[i] = !(matches[i] = elem);
						}
					}
				}) :
				function( elem, context, xml ) {
					input[0] = elem;
					matcher( input, null, xml, results );
					return !results.pop();
				};
		}),

		"has": markFunction(function( selector ) {
			return function( elem ) {
				return Sizzle( selector, elem ).length > 0;
			};
		}),

		"contains": markFunction(function( text ) {
			return function( elem ) {
				return ( elem.textContent || elem.innerText || getText( elem ) ).indexOf( text ) > -1;
			};
		}),

		"enabled": function( elem ) {
			return elem.disabled === false;
		},

		"disabled": function( elem ) {
			return elem.disabled === true;
		},

		"checked": function( elem ) {
			// In CSS3, :checked should return both checked and selected elements
			// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
			var nodeName = elem.nodeName.toLowerCase();
			return (nodeName === "input" && !!elem.checked) || (nodeName === "option" && !!elem.selected);
		},

		"selected": function( elem ) {
			// Accessing this property makes selected-by-default
			// options in Safari work properly
			if ( elem.parentNode ) {
				elem.parentNode.selectedIndex;
			}

			return elem.selected === true;
		},

		"parent": function( elem ) {
			return !Expr.pseudos["empty"]( elem );
		},

		"empty": function( elem ) {
			// http://www.w3.org/TR/selectors/#empty-pseudo
			// :empty is only affected by element nodes and content nodes(including text(3), cdata(4)),
			//   not comment, processing instructions, or others
			// Thanks to Diego Perini for the nodeName shortcut
			//   Greater than "@" means alpha characters (specifically not starting with "#" or "?")
			var nodeType;
			elem = elem.firstChild;
			while ( elem ) {
				if ( elem.nodeName > "@" || (nodeType = elem.nodeType) === 3 || nodeType === 4 ) {
					return false;
				}
				elem = elem.nextSibling;
			}
			return true;
		},

		"header": function( elem ) {
			return rheader.test( elem.nodeName );
		},

		"text": function( elem ) {
			var type, attr;
			// IE6 and 7 will map elem.type to 'text' for new HTML5 types (search, etc)
			// use getAttribute instead to test this case
			return elem.nodeName.toLowerCase() === "input" &&
				(type = elem.type) === "text" &&
				( (attr = elem.getAttribute("type")) == null || attr.toLowerCase() === type );
		},

		// Input types
		"radio": createInputPseudo("radio"),
		"checkbox": createInputPseudo("checkbox"),
		"file": createInputPseudo("file"),
		"password": createInputPseudo("password"),
		"image": createInputPseudo("image"),

		"submit": createButtonPseudo("submit"),
		"reset": createButtonPseudo("reset"),

		"button": function( elem ) {
			var name = elem.nodeName.toLowerCase();
			return name === "input" && elem.type === "button" || name === "button";
		},

		"input": function( elem ) {
			return rinputs.test( elem.nodeName );
		},

		"focus": function( elem ) {
			var doc = elem.ownerDocument;
			return elem === doc.activeElement && (!doc.hasFocus || doc.hasFocus()) && !!(elem.type || elem.href);
		},

		"active": function( elem ) {
			return elem === elem.ownerDocument.activeElement;
		},

		// Positional types
		"first": createPositionalPseudo(function( matchIndexes, length, argument ) {
			return [ 0 ];
		}),

		"last": createPositionalPseudo(function( matchIndexes, length, argument ) {
			return [ length - 1 ];
		}),

		"eq": createPositionalPseudo(function( matchIndexes, length, argument ) {
			return [ argument < 0 ? argument + length : argument ];
		}),

		"even": createPositionalPseudo(function( matchIndexes, length, argument ) {
			for ( var i = 0; i < length; i += 2 ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		}),

		"odd": createPositionalPseudo(function( matchIndexes, length, argument ) {
			for ( var i = 1; i < length; i += 2 ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		}),

		"lt": createPositionalPseudo(function( matchIndexes, length, argument ) {
			for ( var i = argument < 0 ? argument + length : argument; --i >= 0; ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		}),

		"gt": createPositionalPseudo(function( matchIndexes, length, argument ) {
			for ( var i = argument < 0 ? argument + length : argument; ++i < length; ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		})
	}
};

function siblingCheck( a, b, ret ) {
	if ( a === b ) {
		return ret;
	}

	var cur = a.nextSibling;

	while ( cur ) {
		if ( cur === b ) {
			return -1;
		}

		cur = cur.nextSibling;
	}

	return 1;
}

sortOrder = docElem.compareDocumentPosition ?
	function( a, b ) {
		if ( a === b ) {
			hasDuplicate = true;
			return 0;
		}

		return ( !a.compareDocumentPosition || !b.compareDocumentPosition ?
			a.compareDocumentPosition :
			a.compareDocumentPosition(b) & 4
		) ? -1 : 1;
	} :
	function( a, b ) {
		// The nodes are identical, we can exit early
		if ( a === b ) {
			hasDuplicate = true;
			return 0;

		// Fallback to using sourceIndex (in IE) if it's available on both nodes
		} else if ( a.sourceIndex && b.sourceIndex ) {
			return a.sourceIndex - b.sourceIndex;
		}

		var al, bl,
			ap = [],
			bp = [],
			aup = a.parentNode,
			bup = b.parentNode,
			cur = aup;

		// If the nodes are siblings (or identical) we can do a quick check
		if ( aup === bup ) {
			return siblingCheck( a, b );

		// If no parents were found then the nodes are disconnected
		} else if ( !aup ) {
			return -1;

		} else if ( !bup ) {
			return 1;
		}

		// Otherwise they're somewhere else in the tree so we need
		// to build up a full list of the parentNodes for comparison
		while ( cur ) {
			ap.unshift( cur );
			cur = cur.parentNode;
		}

		cur = bup;

		while ( cur ) {
			bp.unshift( cur );
			cur = cur.parentNode;
		}

		al = ap.length;
		bl = bp.length;

		// Start walking down the tree looking for a discrepancy
		for ( var i = 0; i < al && i < bl; i++ ) {
			if ( ap[i] !== bp[i] ) {
				return siblingCheck( ap[i], bp[i] );
			}
		}

		// We ended someplace up the tree so do a sibling check
		return i === al ?
			siblingCheck( a, bp[i], -1 ) :
			siblingCheck( ap[i], b, 1 );
	};

// Always assume the presence of duplicates if sort doesn't
// pass them to our comparison function (as in Google Chrome).
[0, 0].sort( sortOrder );
baseHasDuplicate = !hasDuplicate;

// Document sorting and removing duplicates
Sizzle.uniqueSort = function( results ) {
	var elem,
		i = 1;

	hasDuplicate = baseHasDuplicate;
	results.sort( sortOrder );

	if ( hasDuplicate ) {
		for ( ; (elem = results[i]); i++ ) {
			if ( elem === results[ i - 1 ] ) {
				results.splice( i--, 1 );
			}
		}
	}

	return results;
};

Sizzle.error = function( msg ) {
	throw new Error( "Syntax error, unrecognized expression: " + msg );
};

function tokenize( selector, parseOnly ) {
	var matched, match, tokens, type, soFar, groups, preFilters,
		cached = tokenCache[ expando ][ selector ];

	if ( cached ) {
		return parseOnly ? 0 : cached.slice( 0 );
	}

	soFar = selector;
	groups = [];
	preFilters = Expr.preFilter;

	while ( soFar ) {

		// Comma and first run
		if ( !matched || (match = rcomma.exec( soFar )) ) {
			if ( match ) {
				soFar = soFar.slice( match[0].length );
			}
			groups.push( tokens = [] );
		}

		matched = false;

		// Combinators
		if ( (match = rcombinators.exec( soFar )) ) {
			tokens.push( matched = new Token( match.shift() ) );
			soFar = soFar.slice( matched.length );

			// Cast descendant combinators to space
			matched.type = match[0].replace( rtrim, " " );
		}

		// Filters
		for ( type in Expr.filter ) {
			if ( (match = matchExpr[ type ].exec( soFar )) && (!preFilters[ type ] ||
				// The last two arguments here are (context, xml) for backCompat
				(match = preFilters[ type ]( match, document, true ))) ) {

				tokens.push( matched = new Token( match.shift() ) );
				soFar = soFar.slice( matched.length );
				matched.type = type;
				matched.matches = match;
			}
		}

		if ( !matched ) {
			break;
		}
	}

	// Return the length of the invalid excess
	// if we're just parsing
	// Otherwise, throw an error or return tokens
	return parseOnly ?
		soFar.length :
		soFar ?
			Sizzle.error( selector ) :
			// Cache the tokens
			tokenCache( selector, groups ).slice( 0 );
}

function addCombinator( matcher, combinator, base ) {
	var dir = combinator.dir,
		checkNonElements = base && combinator.dir === "parentNode",
		doneName = done++;

	return combinator.first ?
		// Check against closest ancestor/preceding element
		function( elem, context, xml ) {
			while ( (elem = elem[ dir ]) ) {
				if ( checkNonElements || elem.nodeType === 1  ) {
					return matcher( elem, context, xml );
				}
			}
		} :

		// Check against all ancestor/preceding elements
		function( elem, context, xml ) {
			// We can't set arbitrary data on XML nodes, so they don't benefit from dir caching
			if ( !xml ) {
				var cache,
					dirkey = dirruns + " " + doneName + " ",
					cachedkey = dirkey + cachedruns;
				while ( (elem = elem[ dir ]) ) {
					if ( checkNonElements || elem.nodeType === 1 ) {
						if ( (cache = elem[ expando ]) === cachedkey ) {
							return elem.sizset;
						} else if ( typeof cache === "string" && cache.indexOf(dirkey) === 0 ) {
							if ( elem.sizset ) {
								return elem;
							}
						} else {
							elem[ expando ] = cachedkey;
							if ( matcher( elem, context, xml ) ) {
								elem.sizset = true;
								return elem;
							}
							elem.sizset = false;
						}
					}
				}
			} else {
				while ( (elem = elem[ dir ]) ) {
					if ( checkNonElements || elem.nodeType === 1 ) {
						if ( matcher( elem, context, xml ) ) {
							return elem;
						}
					}
				}
			}
		};
}

function elementMatcher( matchers ) {
	return matchers.length > 1 ?
		function( elem, context, xml ) {
			var i = matchers.length;
			while ( i-- ) {
				if ( !matchers[i]( elem, context, xml ) ) {
					return false;
				}
			}
			return true;
		} :
		matchers[0];
}

function condense( unmatched, map, filter, context, xml ) {
	var elem,
		newUnmatched = [],
		i = 0,
		len = unmatched.length,
		mapped = map != null;

	for ( ; i < len; i++ ) {
		if ( (elem = unmatched[i]) ) {
			if ( !filter || filter( elem, context, xml ) ) {
				newUnmatched.push( elem );
				if ( mapped ) {
					map.push( i );
				}
			}
		}
	}

	return newUnmatched;
}

function setMatcher( preFilter, selector, matcher, postFilter, postFinder, postSelector ) {
	if ( postFilter && !postFilter[ expando ] ) {
		postFilter = setMatcher( postFilter );
	}
	if ( postFinder && !postFinder[ expando ] ) {
		postFinder = setMatcher( postFinder, postSelector );
	}
	return markFunction(function( seed, results, context, xml ) {
		// Positional selectors apply to seed elements, so it is invalid to follow them with relative ones
		if ( seed && postFinder ) {
			return;
		}

		var i, elem, postFilterIn,
			preMap = [],
			postMap = [],
			preexisting = results.length,

			// Get initial elements from seed or context
			elems = seed || multipleContexts( selector || "*", context.nodeType ? [ context ] : context, [], seed ),

			// Prefilter to get matcher input, preserving a map for seed-results synchronization
			matcherIn = preFilter && ( seed || !selector ) ?
				condense( elems, preMap, preFilter, context, xml ) :
				elems,

			matcherOut = matcher ?
				// If we have a postFinder, or filtered seed, or non-seed postFilter or preexisting results,
				postFinder || ( seed ? preFilter : preexisting || postFilter ) ?

					// ...intermediate processing is necessary
					[] :

					// ...otherwise use results directly
					results :
				matcherIn;

		// Find primary matches
		if ( matcher ) {
			matcher( matcherIn, matcherOut, context, xml );
		}

		// Apply postFilter
		if ( postFilter ) {
			postFilterIn = condense( matcherOut, postMap );
			postFilter( postFilterIn, [], context, xml );

			// Un-match failing elements by moving them back to matcherIn
			i = postFilterIn.length;
			while ( i-- ) {
				if ( (elem = postFilterIn[i]) ) {
					matcherOut[ postMap[i] ] = !(matcherIn[ postMap[i] ] = elem);
				}
			}
		}

		// Keep seed and results synchronized
		if ( seed ) {
			// Ignore postFinder because it can't coexist with seed
			i = preFilter && matcherOut.length;
			while ( i-- ) {
				if ( (elem = matcherOut[i]) ) {
					seed[ preMap[i] ] = !(results[ preMap[i] ] = elem);
				}
			}
		} else {
			matcherOut = condense(
				matcherOut === results ?
					matcherOut.splice( preexisting, matcherOut.length ) :
					matcherOut
			);
			if ( postFinder ) {
				postFinder( null, results, matcherOut, xml );
			} else {
				push.apply( results, matcherOut );
			}
		}
	});
}

function matcherFromTokens( tokens ) {
	var checkContext, matcher, j,
		len = tokens.length,
		leadingRelative = Expr.relative[ tokens[0].type ],
		implicitRelative = leadingRelative || Expr.relative[" "],
		i = leadingRelative ? 1 : 0,

		// The foundational matcher ensures that elements are reachable from top-level context(s)
		matchContext = addCombinator( function( elem ) {
			return elem === checkContext;
		}, implicitRelative, true ),
		matchAnyContext = addCombinator( function( elem ) {
			return indexOf.call( checkContext, elem ) > -1;
		}, implicitRelative, true ),
		matchers = [ function( elem, context, xml ) {
			return ( !leadingRelative && ( xml || context !== outermostContext ) ) || (
				(checkContext = context).nodeType ?
					matchContext( elem, context, xml ) :
					matchAnyContext( elem, context, xml ) );
		} ];

	for ( ; i < len; i++ ) {
		if ( (matcher = Expr.relative[ tokens[i].type ]) ) {
			matchers = [ addCombinator( elementMatcher( matchers ), matcher ) ];
		} else {
			// The concatenated values are (context, xml) for backCompat
			matcher = Expr.filter[ tokens[i].type ].apply( null, tokens[i].matches );

			// Return special upon seeing a positional matcher
			if ( matcher[ expando ] ) {
				// Find the next relative operator (if any) for proper handling
				j = ++i;
				for ( ; j < len; j++ ) {
					if ( Expr.relative[ tokens[j].type ] ) {
						break;
					}
				}
				return setMatcher(
					i > 1 && elementMatcher( matchers ),
					i > 1 && tokens.slice( 0, i - 1 ).join("").replace( rtrim, "$1" ),
					matcher,
					i < j && matcherFromTokens( tokens.slice( i, j ) ),
					j < len && matcherFromTokens( (tokens = tokens.slice( j )) ),
					j < len && tokens.join("")
				);
			}
			matchers.push( matcher );
		}
	}

	return elementMatcher( matchers );
}

function matcherFromGroupMatchers( elementMatchers, setMatchers ) {
	var bySet = setMatchers.length > 0,
		byElement = elementMatchers.length > 0,
		superMatcher = function( seed, context, xml, results, expandContext ) {
			var elem, j, matcher,
				setMatched = [],
				matchedCount = 0,
				i = "0",
				unmatched = seed && [],
				outermost = expandContext != null,
				contextBackup = outermostContext,
				// We must always have either seed elements or context
				elems = seed || byElement && Expr.find["TAG"]( "*", expandContext && context.parentNode || context ),
				// Nested matchers should use non-integer dirruns
				dirrunsUnique = (dirruns += contextBackup == null ? 1 : Math.E);

			if ( outermost ) {
				outermostContext = context !== document && context;
				cachedruns = superMatcher.el;
			}

			// Add elements passing elementMatchers directly to results
			for ( ; (elem = elems[i]) != null; i++ ) {
				if ( byElement && elem ) {
					for ( j = 0; (matcher = elementMatchers[j]); j++ ) {
						if ( matcher( elem, context, xml ) ) {
							results.push( elem );
							break;
						}
					}
					if ( outermost ) {
						dirruns = dirrunsUnique;
						cachedruns = ++superMatcher.el;
					}
				}

				// Track unmatched elements for set filters
				if ( bySet ) {
					// They will have gone through all possible matchers
					if ( (elem = !matcher && elem) ) {
						matchedCount--;
					}

					// Lengthen the array for every element, matched or not
					if ( seed ) {
						unmatched.push( elem );
					}
				}
			}

			// Apply set filters to unmatched elements
			matchedCount += i;
			if ( bySet && i !== matchedCount ) {
				for ( j = 0; (matcher = setMatchers[j]); j++ ) {
					matcher( unmatched, setMatched, context, xml );
				}

				if ( seed ) {
					// Reintegrate element matches to eliminate the need for sorting
					if ( matchedCount > 0 ) {
						while ( i-- ) {
							if ( !(unmatched[i] || setMatched[i]) ) {
								setMatched[i] = pop.call( results );
							}
						}
					}

					// Discard index placeholder values to get only actual matches
					setMatched = condense( setMatched );
				}

				// Add matches to results
				push.apply( results, setMatched );

				// Seedless set matches succeeding multiple successful matchers stipulate sorting
				if ( outermost && !seed && setMatched.length > 0 &&
					( matchedCount + setMatchers.length ) > 1 ) {

					Sizzle.uniqueSort( results );
				}
			}

			// Override manipulation of globals by nested matchers
			if ( outermost ) {
				dirruns = dirrunsUnique;
				outermostContext = contextBackup;
			}

			return unmatched;
		};

	superMatcher.el = 0;
	return bySet ?
		markFunction( superMatcher ) :
		superMatcher;
}

compile = Sizzle.compile = function( selector, group /* Internal Use Only */ ) {
	var i,
		setMatchers = [],
		elementMatchers = [],
		cached = compilerCache[ expando ][ selector ];

	if ( !cached ) {
		// Generate a function of recursive functions that can be used to check each element
		if ( !group ) {
			group = tokenize( selector );
		}
		i = group.length;
		while ( i-- ) {
			cached = matcherFromTokens( group[i] );
			if ( cached[ expando ] ) {
				setMatchers.push( cached );
			} else {
				elementMatchers.push( cached );
			}
		}

		// Cache the compiled function
		cached = compilerCache( selector, matcherFromGroupMatchers( elementMatchers, setMatchers ) );
	}
	return cached;
};

function multipleContexts( selector, contexts, results, seed ) {
	var i = 0,
		len = contexts.length;
	for ( ; i < len; i++ ) {
		Sizzle( selector, contexts[i], results, seed );
	}
	return results;
}

function select( selector, context, results, seed, xml ) {
	var i, tokens, token, type, find,
		match = tokenize( selector ),
		j = match.length;

	if ( !seed ) {
		// Try to minimize operations if there is only one group
		if ( match.length === 1 ) {

			// Take a shortcut and set the context if the root selector is an ID
			tokens = match[0] = match[0].slice( 0 );
			if ( tokens.length > 2 && (token = tokens[0]).type === "ID" &&
					context.nodeType === 9 && !xml &&
					Expr.relative[ tokens[1].type ] ) {

				context = Expr.find["ID"]( token.matches[0].replace( rbackslash, "" ), context, xml )[0];
				if ( !context ) {
					return results;
				}

				selector = selector.slice( tokens.shift().length );
			}

			// Fetch a seed set for right-to-left matching
			for ( i = matchExpr["POS"].test( selector ) ? -1 : tokens.length - 1; i >= 0; i-- ) {
				token = tokens[i];

				// Abort if we hit a combinator
				if ( Expr.relative[ (type = token.type) ] ) {
					break;
				}
				if ( (find = Expr.find[ type ]) ) {
					// Search, expanding context for leading sibling combinators
					if ( (seed = find(
						token.matches[0].replace( rbackslash, "" ),
						rsibling.test( tokens[0].type ) && context.parentNode || context,
						xml
					)) ) {

						// If seed is empty or no tokens remain, we can return early
						tokens.splice( i, 1 );
						selector = seed.length && tokens.join("");
						if ( !selector ) {
							push.apply( results, slice.call( seed, 0 ) );
							return results;
						}

						break;
					}
				}
			}
		}
	}

	// Compile and execute a filtering function
	// Provide `match` to avoid retokenization if we modified the selector above
	compile( selector, match )(
		seed,
		context,
		xml,
		results,
		rsibling.test( selector )
	);
	return results;
}

if ( document.querySelectorAll ) {
	(function() {
		var disconnectedMatch,
			oldSelect = select,
			rescape = /'|\\/g,
			rattributeQuotes = /\=[\x20\t\r\n\f]*([^'"\]]*)[\x20\t\r\n\f]*\]/g,

			// qSa(:focus) reports false when true (Chrome 21),
			// A support test would require too much code (would include document ready)
			rbuggyQSA = [":focus"],

			// matchesSelector(:focus) reports false when true (Chrome 21),
			// matchesSelector(:active) reports false when true (IE9/Opera 11.5)
			// A support test would require too much code (would include document ready)
			// just skip matchesSelector for :active
			rbuggyMatches = [ ":active", ":focus" ],
			matches = docElem.matchesSelector ||
				docElem.mozMatchesSelector ||
				docElem.webkitMatchesSelector ||
				docElem.oMatchesSelector ||
				docElem.msMatchesSelector;

		// Build QSA regex
		// Regex strategy adopted from Diego Perini
		assert(function( div ) {
			// Select is set to empty string on purpose
			// This is to test IE's treatment of not explictly
			// setting a boolean content attribute,
			// since its presence should be enough
			// http://bugs.jquery.com/ticket/12359
			div.innerHTML = "<select><option selected=''></option></select>";

			// IE8 - Some boolean attributes are not treated correctly
			if ( !div.querySelectorAll("[selected]").length ) {
				rbuggyQSA.push( "\\[" + whitespace + "*(?:checked|disabled|ismap|multiple|readonly|selected|value)" );
			}

			// Webkit/Opera - :checked should return selected option elements
			// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
			// IE8 throws error here (do not put tests after this one)
			if ( !div.querySelectorAll(":checked").length ) {
				rbuggyQSA.push(":checked");
			}
		});

		assert(function( div ) {

			// Opera 10-12/IE9 - ^= $= *= and empty values
			// Should not select anything
			div.innerHTML = "<p test=''></p>";
			if ( div.querySelectorAll("[test^='']").length ) {
				rbuggyQSA.push( "[*^$]=" + whitespace + "*(?:\"\"|'')" );
			}

			// FF 3.5 - :enabled/:disabled and hidden elements (hidden elements are still enabled)
			// IE8 throws error here (do not put tests after this one)
			div.innerHTML = "<input type='hidden'/>";
			if ( !div.querySelectorAll(":enabled").length ) {
				rbuggyQSA.push(":enabled", ":disabled");
			}
		});

		// rbuggyQSA always contains :focus, so no need for a length check
		rbuggyQSA = /* rbuggyQSA.length && */ new RegExp( rbuggyQSA.join("|") );

		select = function( selector, context, results, seed, xml ) {
			// Only use querySelectorAll when not filtering,
			// when this is not xml,
			// and when no QSA bugs apply
			if ( !seed && !xml && (!rbuggyQSA || !rbuggyQSA.test( selector )) ) {
				var groups, i,
					old = true,
					nid = expando,
					newContext = context,
					newSelector = context.nodeType === 9 && selector;

				// qSA works strangely on Element-rooted queries
				// We can work around this by specifying an extra ID on the root
				// and working up from there (Thanks to Andrew Dupont for the technique)
				// IE 8 doesn't work on object elements
				if ( context.nodeType === 1 && context.nodeName.toLowerCase() !== "object" ) {
					groups = tokenize( selector );

					if ( (old = context.getAttribute("id")) ) {
						nid = old.replace( rescape, "\\$&" );
					} else {
						context.setAttribute( "id", nid );
					}
					nid = "[id='" + nid + "'] ";

					i = groups.length;
					while ( i-- ) {
						groups[i] = nid + groups[i].join("");
					}
					newContext = rsibling.test( selector ) && context.parentNode || context;
					newSelector = groups.join(",");
				}

				if ( newSelector ) {
					try {
						push.apply( results, slice.call( newContext.querySelectorAll(
							newSelector
						), 0 ) );
						return results;
					} catch(qsaError) {
					} finally {
						if ( !old ) {
							context.removeAttribute("id");
						}
					}
				}
			}

			return oldSelect( selector, context, results, seed, xml );
		};

		if ( matches ) {
			assert(function( div ) {
				// Check to see if it's possible to do matchesSelector
				// on a disconnected node (IE 9)
				disconnectedMatch = matches.call( div, "div" );

				// This should fail with an exception
				// Gecko does not error, returns false instead
				try {
					matches.call( div, "[test!='']:sizzle" );
					rbuggyMatches.push( "!=", pseudos );
				} catch ( e ) {}
			});

			// rbuggyMatches always contains :active and :focus, so no need for a length check
			rbuggyMatches = /* rbuggyMatches.length && */ new RegExp( rbuggyMatches.join("|") );

			Sizzle.matchesSelector = function( elem, expr ) {
				// Make sure that attribute selectors are quoted
				expr = expr.replace( rattributeQuotes, "='$1']" );

				// rbuggyMatches always contains :active, so no need for an existence check
				if ( !isXML( elem ) && !rbuggyMatches.test( expr ) && (!rbuggyQSA || !rbuggyQSA.test( expr )) ) {
					try {
						var ret = matches.call( elem, expr );

						// IE 9's matchesSelector returns false on disconnected nodes
						if ( ret || disconnectedMatch ||
								// As well, disconnected nodes are said to be in a document
								// fragment in IE 9
								elem.document && elem.document.nodeType !== 11 ) {
							return ret;
						}
					} catch(e) {}
				}

				return Sizzle( expr, null, null, [ elem ] ).length > 0;
			};
		}
	})();
}

// Deprecated
Expr.pseudos["nth"] = Expr.pseudos["eq"];

// Back-compat
function setFilters() {}
Expr.filters = setFilters.prototype = Expr.pseudos;
Expr.setFilters = new setFilters();

// Override sizzle attribute retrieval
Sizzle.attr = jQuery.attr;
jQuery.find = Sizzle;
jQuery.expr = Sizzle.selectors;
jQuery.expr[":"] = jQuery.expr.pseudos;
jQuery.unique = Sizzle.uniqueSort;
jQuery.text = Sizzle.getText;
jQuery.isXMLDoc = Sizzle.isXML;
jQuery.contains = Sizzle.contains;


})( window );
var runtil = /Until$/,
	rparentsprev = /^(?:parents|prev(?:Until|All))/,
	isSimple = /^.[^:#\[\.,]*$/,
	rneedsContext = jQuery.expr.match.needsContext,
	// methods guaranteed to produce a unique set when starting from a unique set
	guaranteedUnique = {
		children: true,
		contents: true,
		next: true,
		prev: true
	};

jQuery.fn.extend({
	find: function( selector ) {
		var i, l, length, n, r, ret,
			self = this;

		if ( typeof selector !== "string" ) {
			return jQuery( selector ).filter(function() {
				for ( i = 0, l = self.length; i < l; i++ ) {
					if ( jQuery.contains( self[ i ], this ) ) {
						return true;
					}
				}
			});
		}

		ret = this.pushStack( "", "find", selector );

		for ( i = 0, l = this.length; i < l; i++ ) {
			length = ret.length;
			jQuery.find( selector, this[i], ret );

			if ( i > 0 ) {
				// Make sure that the results are unique
				for ( n = length; n < ret.length; n++ ) {
					for ( r = 0; r < length; r++ ) {
						if ( ret[r] === ret[n] ) {
							ret.splice(n--, 1);
							break;
						}
					}
				}
			}
		}

		return ret;
	},

	has: function( target ) {
		var i,
			targets = jQuery( target, this ),
			len = targets.length;

		return this.filter(function() {
			for ( i = 0; i < len; i++ ) {
				if ( jQuery.contains( this, targets[i] ) ) {
					return true;
				}
			}
		});
	},

	not: function( selector ) {
		return this.pushStack( winnow(this, selector, false), "not", selector);
	},

	filter: function( selector ) {
		return this.pushStack( winnow(this, selector, true), "filter", selector );
	},

	is: function( selector ) {
		return !!selector && (
			typeof selector === "string" ?
				// If this is a positional/relative selector, check membership in the returned set
				// so $("p:first").is("p:last") won't return true for a doc with two "p".
				rneedsContext.test( selector ) ?
					jQuery( selector, this.context ).index( this[0] ) >= 0 :
					jQuery.filter( selector, this ).length > 0 :
				this.filter( selector ).length > 0 );
	},

	closest: function( selectors, context ) {
		var cur,
			i = 0,
			l = this.length,
			ret = [],
			pos = rneedsContext.test( selectors ) || typeof selectors !== "string" ?
				jQuery( selectors, context || this.context ) :
				0;

		for ( ; i < l; i++ ) {
			cur = this[i];

			while ( cur && cur.ownerDocument && cur !== context && cur.nodeType !== 11 ) {
				if ( pos ? pos.index(cur) > -1 : jQuery.find.matchesSelector(cur, selectors) ) {
					ret.push( cur );
					break;
				}
				cur = cur.parentNode;
			}
		}

		ret = ret.length > 1 ? jQuery.unique( ret ) : ret;

		return this.pushStack( ret, "closest", selectors );
	},

	// Determine the position of an element within
	// the matched set of elements
	index: function( elem ) {

		// No argument, return index in parent
		if ( !elem ) {
			return ( this[0] && this[0].parentNode ) ? this.prevAll().length : -1;
		}

		// index in selector
		if ( typeof elem === "string" ) {
			return jQuery.inArray( this[0], jQuery( elem ) );
		}

		// Locate the position of the desired element
		return jQuery.inArray(
			// If it receives a jQuery object, the first element is used
			elem.jquery ? elem[0] : elem, this );
	},

	add: function( selector, context ) {
		var set = typeof selector === "string" ?
				jQuery( selector, context ) :
				jQuery.makeArray( selector && selector.nodeType ? [ selector ] : selector ),
			all = jQuery.merge( this.get(), set );

		return this.pushStack( isDisconnected( set[0] ) || isDisconnected( all[0] ) ?
			all :
			jQuery.unique( all ) );
	},

	addBack: function( selector ) {
		return this.add( selector == null ?
			this.prevObject : this.prevObject.filter(selector)
		);
	}
});

jQuery.fn.andSelf = jQuery.fn.addBack;

// A painfully simple check to see if an element is disconnected
// from a document (should be improved, where feasible).
function isDisconnected( node ) {
	return !node || !node.parentNode || node.parentNode.nodeType === 11;
}

function sibling( cur, dir ) {
	do {
		cur = cur[ dir ];
	} while ( cur && cur.nodeType !== 1 );

	return cur;
}

jQuery.each({
	parent: function( elem ) {
		var parent = elem.parentNode;
		return parent && parent.nodeType !== 11 ? parent : null;
	},
	parents: function( elem ) {
		return jQuery.dir( elem, "parentNode" );
	},
	parentsUntil: function( elem, i, until ) {
		return jQuery.dir( elem, "parentNode", until );
	},
	next: function( elem ) {
		return sibling( elem, "nextSibling" );
	},
	prev: function( elem ) {
		return sibling( elem, "previousSibling" );
	},
	nextAll: function( elem ) {
		return jQuery.dir( elem, "nextSibling" );
	},
	prevAll: function( elem ) {
		return jQuery.dir( elem, "previousSibling" );
	},
	nextUntil: function( elem, i, until ) {
		return jQuery.dir( elem, "nextSibling", until );
	},
	prevUntil: function( elem, i, until ) {
		return jQuery.dir( elem, "previousSibling", until );
	},
	siblings: function( elem ) {
		return jQuery.sibling( ( elem.parentNode || {} ).firstChild, elem );
	},
	children: function( elem ) {
		return jQuery.sibling( elem.firstChild );
	},
	contents: function( elem ) {
		return jQuery.nodeName( elem, "iframe" ) ?
			elem.contentDocument || elem.contentWindow.document :
			jQuery.merge( [], elem.childNodes );
	}
}, function( name, fn ) {
	jQuery.fn[ name ] = function( until, selector ) {
		var ret = jQuery.map( this, fn, until );

		if ( !runtil.test( name ) ) {
			selector = until;
		}

		if ( selector && typeof selector === "string" ) {
			ret = jQuery.filter( selector, ret );
		}

		ret = this.length > 1 && !guaranteedUnique[ name ] ? jQuery.unique( ret ) : ret;

		if ( this.length > 1 && rparentsprev.test( name ) ) {
			ret = ret.reverse();
		}

		return this.pushStack( ret, name, core_slice.call( arguments ).join(",") );
	};
});

jQuery.extend({
	filter: function( expr, elems, not ) {
		if ( not ) {
			expr = ":not(" + expr + ")";
		}

		return elems.length === 1 ?
			jQuery.find.matchesSelector(elems[0], expr) ? [ elems[0] ] : [] :
			jQuery.find.matches(expr, elems);
	},

	dir: function( elem, dir, until ) {
		var matched = [],
			cur = elem[ dir ];

		while ( cur && cur.nodeType !== 9 && (until === undefined || cur.nodeType !== 1 || !jQuery( cur ).is( until )) ) {
			if ( cur.nodeType === 1 ) {
				matched.push( cur );
			}
			cur = cur[dir];
		}
		return matched;
	},

	sibling: function( n, elem ) {
		var r = [];

		for ( ; n; n = n.nextSibling ) {
			if ( n.nodeType === 1 && n !== elem ) {
				r.push( n );
			}
		}

		return r;
	}
});

// Implement the identical functionality for filter and not
function winnow( elements, qualifier, keep ) {

	// Can't pass null or undefined to indexOf in Firefox 4
	// Set to 0 to skip string check
	qualifier = qualifier || 0;

	if ( jQuery.isFunction( qualifier ) ) {
		return jQuery.grep(elements, function( elem, i ) {
			var retVal = !!qualifier.call( elem, i, elem );
			return retVal === keep;
		});

	} else if ( qualifier.nodeType ) {
		return jQuery.grep(elements, function( elem, i ) {
			return ( elem === qualifier ) === keep;
		});

	} else if ( typeof qualifier === "string" ) {
		var filtered = jQuery.grep(elements, function( elem ) {
			return elem.nodeType === 1;
		});

		if ( isSimple.test( qualifier ) ) {
			return jQuery.filter(qualifier, filtered, !keep);
		} else {
			qualifier = jQuery.filter( qualifier, filtered );
		}
	}

	return jQuery.grep(elements, function( elem, i ) {
		return ( jQuery.inArray( elem, qualifier ) >= 0 ) === keep;
	});
}
function createSafeFragment( document ) {
	var list = nodeNames.split( "|" ),
	safeFrag = document.createDocumentFragment();

	if ( safeFrag.createElement ) {
		while ( list.length ) {
			safeFrag.createElement(
				list.pop()
			);
		}
	}
	return safeFrag;
}

var nodeNames = "abbr|article|aside|audio|bdi|canvas|data|datalist|details|figcaption|figure|footer|" +
		"header|hgroup|mark|meter|nav|output|progress|section|summary|time|video",
	rinlinejQuery = / jQuery\d+="(?:null|\d+)"/g,
	rleadingWhitespace = /^\s+/,
	rxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/gi,
	rtagName = /<([\w:]+)/,
	rtbody = /<tbody/i,
	rhtml = /<|&#?\w+;/,
	rnoInnerhtml = /<(?:script|style|link)/i,
	rnocache = /<(?:script|object|embed|option|style)/i,
	rnoshimcache = new RegExp("<(?:" + nodeNames + ")[\\s/>]", "i"),
	rcheckableType = /^(?:checkbox|radio)$/,
	// checked="checked" or checked
	rchecked = /checked\s*(?:[^=]|=\s*.checked.)/i,
	rscriptType = /\/(java|ecma)script/i,
	rcleanScript = /^\s*<!(?:\[CDATA\[|\-\-)|[\]\-]{2}>\s*$/g,
	wrapMap = {
		option: [ 1, "<select multiple='multiple'>", "</select>" ],
		legend: [ 1, "<fieldset>", "</fieldset>" ],
		thead: [ 1, "<table>", "</table>" ],
		tr: [ 2, "<table><tbody>", "</tbody></table>" ],
		td: [ 3, "<table><tbody><tr>", "</tr></tbody></table>" ],
		col: [ 2, "<table><tbody></tbody><colgroup>", "</colgroup></table>" ],
		area: [ 1, "<map>", "</map>" ],
		_default: [ 0, "", "" ]
	},
	safeFragment = createSafeFragment( document ),
	fragmentDiv = safeFragment.appendChild( document.createElement("div") );

wrapMap.optgroup = wrapMap.option;
wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;
wrapMap.th = wrapMap.td;

// IE6-8 can't serialize link, script, style, or any html5 (NoScope) tags,
// unless wrapped in a div with non-breaking characters in front of it.
if ( !jQuery.support.htmlSerialize ) {
	wrapMap._default = [ 1, "X<div>", "</div>" ];
}

jQuery.fn.extend({
	text: function( value ) {
		return jQuery.access( this, function( value ) {
			return value === undefined ?
				jQuery.text( this ) :
				this.empty().append( ( this[0] && this[0].ownerDocument || document ).createTextNode( value ) );
		}, null, value, arguments.length );
	},

	wrapAll: function( html ) {
		if ( jQuery.isFunction( html ) ) {
			return this.each(function(i) {
				jQuery(this).wrapAll( html.call(this, i) );
			});
		}

		if ( this[0] ) {
			// The elements to wrap the target around
			var wrap = jQuery( html, this[0].ownerDocument ).eq(0).clone(true);

			if ( this[0].parentNode ) {
				wrap.insertBefore( this[0] );
			}

			wrap.map(function() {
				var elem = this;

				while ( elem.firstChild && elem.firstChild.nodeType === 1 ) {
					elem = elem.firstChild;
				}

				return elem;
			}).append( this );
		}

		return this;
	},

	wrapInner: function( html ) {
		if ( jQuery.isFunction( html ) ) {
			return this.each(function(i) {
				jQuery(this).wrapInner( html.call(this, i) );
			});
		}

		return this.each(function() {
			var self = jQuery( this ),
				contents = self.contents();

			if ( contents.length ) {
				contents.wrapAll( html );

			} else {
				self.append( html );
			}
		});
	},

	wrap: function( html ) {
		var isFunction = jQuery.isFunction( html );

		return this.each(function(i) {
			jQuery( this ).wrapAll( isFunction ? html.call(this, i) : html );
		});
	},

	unwrap: function() {
		return this.parent().each(function() {
			if ( !jQuery.nodeName( this, "body" ) ) {
				jQuery( this ).replaceWith( this.childNodes );
			}
		}).end();
	},

	append: function() {
		return this.domManip(arguments, true, function( elem ) {
			if ( this.nodeType === 1 || this.nodeType === 11 ) {
				this.appendChild( elem );
			}
		});
	},

	prepend: function() {
		return this.domManip(arguments, true, function( elem ) {
			if ( this.nodeType === 1 || this.nodeType === 11 ) {
				this.insertBefore( elem, this.firstChild );
			}
		});
	},

	before: function() {
		if ( !isDisconnected( this[0] ) ) {
			return this.domManip(arguments, false, function( elem ) {
				this.parentNode.insertBefore( elem, this );
			});
		}

		if ( arguments.length ) {
			var set = jQuery.clean( arguments );
			return this.pushStack( jQuery.merge( set, this ), "before", this.selector );
		}
	},

	after: function() {
		if ( !isDisconnected( this[0] ) ) {
			return this.domManip(arguments, false, function( elem ) {
				this.parentNode.insertBefore( elem, this.nextSibling );
			});
		}

		if ( arguments.length ) {
			var set = jQuery.clean( arguments );
			return this.pushStack( jQuery.merge( this, set ), "after", this.selector );
		}
	},

	// keepData is for internal use only--do not document
	remove: function( selector, keepData ) {
		var elem,
			i = 0;

		for ( ; (elem = this[i]) != null; i++ ) {
			if ( !selector || jQuery.filter( selector, [ elem ] ).length ) {
				if ( !keepData && elem.nodeType === 1 ) {
					jQuery.cleanData( elem.getElementsByTagName("*") );
					jQuery.cleanData( [ elem ] );
				}

				if ( elem.parentNode ) {
					elem.parentNode.removeChild( elem );
				}
			}
		}

		return this;
	},

	empty: function() {
		var elem,
			i = 0;

		for ( ; (elem = this[i]) != null; i++ ) {
			// Remove element nodes and prevent memory leaks
			if ( elem.nodeType === 1 ) {
				jQuery.cleanData( elem.getElementsByTagName("*") );
			}

			// Remove any remaining nodes
			while ( elem.firstChild ) {
				elem.removeChild( elem.firstChild );
			}
		}

		return this;
	},

	clone: function( dataAndEvents, deepDataAndEvents ) {
		dataAndEvents = dataAndEvents == null ? false : dataAndEvents;
		deepDataAndEvents = deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;

		return this.map( function () {
			return jQuery.clone( this, dataAndEvents, deepDataAndEvents );
		});
	},

	html: function( value ) {
		return jQuery.access( this, function( value ) {
			var elem = this[0] || {},
				i = 0,
				l = this.length;

			if ( value === undefined ) {
				return elem.nodeType === 1 ?
					elem.innerHTML.replace( rinlinejQuery, "" ) :
					undefined;
			}

			// See if we can take a shortcut and just use innerHTML
			if ( typeof value === "string" && !rnoInnerhtml.test( value ) &&
				( jQuery.support.htmlSerialize || !rnoshimcache.test( value )  ) &&
				( jQuery.support.leadingWhitespace || !rleadingWhitespace.test( value ) ) &&
				!wrapMap[ ( rtagName.exec( value ) || ["", ""] )[1].toLowerCase() ] ) {

				value = value.replace( rxhtmlTag, "<$1></$2>" );

				try {
					for (; i < l; i++ ) {
						// Remove element nodes and prevent memory leaks
						elem = this[i] || {};
						if ( elem.nodeType === 1 ) {
							jQuery.cleanData( elem.getElementsByTagName( "*" ) );
							elem.innerHTML = value;
						}
					}

					elem = 0;

				// If using innerHTML throws an exception, use the fallback method
				} catch(e) {}
			}

			if ( elem ) {
				this.empty().append( value );
			}
		}, null, value, arguments.length );
	},

	replaceWith: function( value ) {
		if ( !isDisconnected( this[0] ) ) {
			// Make sure that the elements are removed from the DOM before they are inserted
			// this can help fix replacing a parent with child elements
			if ( jQuery.isFunction( value ) ) {
				return this.each(function(i) {
					var self = jQuery(this), old = self.html();
					self.replaceWith( value.call( this, i, old ) );
				});
			}

			if ( typeof value !== "string" ) {
				value = jQuery( value ).detach();
			}

			return this.each(function() {
				var next = this.nextSibling,
					parent = this.parentNode;

				jQuery( this ).remove();

				if ( next ) {
					jQuery(next).before( value );
				} else {
					jQuery(parent).append( value );
				}
			});
		}

		return this.length ?
			this.pushStack( jQuery(jQuery.isFunction(value) ? value() : value), "replaceWith", value ) :
			this;
	},

	detach: function( selector ) {
		return this.remove( selector, true );
	},

	domManip: function( args, table, callback ) {

		// Flatten any nested arrays
		args = [].concat.apply( [], args );

		var results, first, fragment, iNoClone,
			i = 0,
			value = args[0],
			scripts = [],
			l = this.length;

		// We can't cloneNode fragments that contain checked, in WebKit
		if ( !jQuery.support.checkClone && l > 1 && typeof value === "string" && rchecked.test( value ) ) {
			return this.each(function() {
				jQuery(this).domManip( args, table, callback );
			});
		}

		if ( jQuery.isFunction(value) ) {
			return this.each(function(i) {
				var self = jQuery(this);
				args[0] = value.call( this, i, table ? self.html() : undefined );
				self.domManip( args, table, callback );
			});
		}

		if ( this[0] ) {
			results = jQuery.buildFragment( args, this, scripts );
			fragment = results.fragment;
			first = fragment.firstChild;

			if ( fragment.childNodes.length === 1 ) {
				fragment = first;
			}

			if ( first ) {
				table = table && jQuery.nodeName( first, "tr" );

				// Use the original fragment for the last item instead of the first because it can end up
				// being emptied incorrectly in certain situations (#8070).
				// Fragments from the fragment cache must always be cloned and never used in place.
				for ( iNoClone = results.cacheable || l - 1; i < l; i++ ) {
					callback.call(
						table && jQuery.nodeName( this[i], "table" ) ?
							findOrAppend( this[i], "tbody" ) :
							this[i],
						i === iNoClone ?
							fragment :
							jQuery.clone( fragment, true, true )
					);
				}
			}

			// Fix #11809: Avoid leaking memory
			fragment = first = null;

			if ( scripts.length ) {
				jQuery.each( scripts, function( i, elem ) {
					if ( elem.src ) {
						if ( jQuery.ajax ) {
							jQuery.ajax({
								url: elem.src,
								type: "GET",
								dataType: "script",
								async: false,
								global: false,
								"throws": true
							});
						} else {
							jQuery.error("no ajax");
						}
					} else {
						jQuery.globalEval( ( elem.text || elem.textContent || elem.innerHTML || "" ).replace( rcleanScript, "" ) );
					}

					if ( elem.parentNode ) {
						elem.parentNode.removeChild( elem );
					}
				});
			}
		}

		return this;
	}
});

function findOrAppend( elem, tag ) {
	return elem.getElementsByTagName( tag )[0] || elem.appendChild( elem.ownerDocument.createElement( tag ) );
}

function cloneCopyEvent( src, dest ) {

	if ( dest.nodeType !== 1 || !jQuery.hasData( src ) ) {
		return;
	}

	var type, i, l,
		oldData = jQuery._data( src ),
		curData = jQuery._data( dest, oldData ),
		events = oldData.events;

	if ( events ) {
		delete curData.handle;
		curData.events = {};

		for ( type in events ) {
			for ( i = 0, l = events[ type ].length; i < l; i++ ) {
				jQuery.event.add( dest, type, events[ type ][ i ] );
			}
		}
	}

	// make the cloned public data object a copy from the original
	if ( curData.data ) {
		curData.data = jQuery.extend( {}, curData.data );
	}
}

function cloneFixAttributes( src, dest ) {
	var nodeName;

	// We do not need to do anything for non-Elements
	if ( dest.nodeType !== 1 ) {
		return;
	}

	// clearAttributes removes the attributes, which we don't want,
	// but also removes the attachEvent events, which we *do* want
	if ( dest.clearAttributes ) {
		dest.clearAttributes();
	}

	// mergeAttributes, in contrast, only merges back on the
	// original attributes, not the events
	if ( dest.mergeAttributes ) {
		dest.mergeAttributes( src );
	}

	nodeName = dest.nodeName.toLowerCase();

	if ( nodeName === "object" ) {
		// IE6-10 improperly clones children of object elements using classid.
		// IE10 throws NoModificationAllowedError if parent is null, #12132.
		if ( dest.parentNode ) {
			dest.outerHTML = src.outerHTML;
		}

		// This path appears unavoidable for IE9. When cloning an object
		// element in IE9, the outerHTML strategy above is not sufficient.
		// If the src has innerHTML and the destination does not,
		// copy the src.innerHTML into the dest.innerHTML. #10324
		if ( jQuery.support.html5Clone && (src.innerHTML && !jQuery.trim(dest.innerHTML)) ) {
			dest.innerHTML = src.innerHTML;
		}

	} else if ( nodeName === "input" && rcheckableType.test( src.type ) ) {
		// IE6-8 fails to persist the checked state of a cloned checkbox
		// or radio button. Worse, IE6-7 fail to give the cloned element
		// a checked appearance if the defaultChecked value isn't also set

		dest.defaultChecked = dest.checked = src.checked;

		// IE6-7 get confused and end up setting the value of a cloned
		// checkbox/radio button to an empty string instead of "on"
		if ( dest.value !== src.value ) {
			dest.value = src.value;
		}

	// IE6-8 fails to return the selected option to the default selected
	// state when cloning options
	} else if ( nodeName === "option" ) {
		dest.selected = src.defaultSelected;

	// IE6-8 fails to set the defaultValue to the correct value when
	// cloning other types of input fields
	} else if ( nodeName === "input" || nodeName === "textarea" ) {
		dest.defaultValue = src.defaultValue;

	// IE blanks contents when cloning scripts
	} else if ( nodeName === "script" && dest.text !== src.text ) {
		dest.text = src.text;
	}

	// Event data gets referenced instead of copied if the expando
	// gets copied too
	dest.removeAttribute( jQuery.expando );
}

jQuery.buildFragment = function( args, context, scripts ) {
	var fragment, cacheable, cachehit,
		first = args[ 0 ];

	// Set context from what may come in as undefined or a jQuery collection or a node
	// Updated to fix #12266 where accessing context[0] could throw an exception in IE9/10 &
	// also doubles as fix for #8950 where plain objects caused createDocumentFragment exception
	context = context || document;
	context = !context.nodeType && context[0] || context;
	context = context.ownerDocument || context;

	// Only cache "small" (1/2 KB) HTML strings that are associated with the main document
	// Cloning options loses the selected state, so don't cache them
	// IE 6 doesn't like it when you put <object> or <embed> elements in a fragment
	// Also, WebKit does not clone 'checked' attributes on cloneNode, so don't cache
	// Lastly, IE6,7,8 will not correctly reuse cached fragments that were created from unknown elems #10501
	if ( args.length === 1 && typeof first === "string" && first.length < 512 && context === document &&
		first.charAt(0) === "<" && !rnocache.test( first ) &&
		(jQuery.support.checkClone || !rchecked.test( first )) &&
		(jQuery.support.html5Clone || !rnoshimcache.test( first )) ) {

		// Mark cacheable and look for a hit
		cacheable = true;
		fragment = jQuery.fragments[ first ];
		cachehit = fragment !== undefined;
	}

	if ( !fragment ) {
		fragment = context.createDocumentFragment();
		jQuery.clean( args, context, fragment, scripts );

		// Update the cache, but only store false
		// unless this is a second parsing of the same content
		if ( cacheable ) {
			jQuery.fragments[ first ] = cachehit && fragment;
		}
	}

	return { fragment: fragment, cacheable: cacheable };
};

jQuery.fragments = {};

jQuery.each({
	appendTo: "append",
	prependTo: "prepend",
	insertBefore: "before",
	insertAfter: "after",
	replaceAll: "replaceWith"
}, function( name, original ) {
	jQuery.fn[ name ] = function( selector ) {
		var elems,
			i = 0,
			ret = [],
			insert = jQuery( selector ),
			l = insert.length,
			parent = this.length === 1 && this[0].parentNode;

		if ( (parent == null || parent && parent.nodeType === 11 && parent.childNodes.length === 1) && l === 1 ) {
			insert[ original ]( this[0] );
			return this;
		} else {
			for ( ; i < l; i++ ) {
				elems = ( i > 0 ? this.clone(true) : this ).get();
				jQuery( insert[i] )[ original ]( elems );
				ret = ret.concat( elems );
			}

			return this.pushStack( ret, name, insert.selector );
		}
	};
});

function getAll( elem ) {
	if ( typeof elem.getElementsByTagName !== "undefined" ) {
		return elem.getElementsByTagName( "*" );

	} else if ( typeof elem.querySelectorAll !== "undefined" ) {
		return elem.querySelectorAll( "*" );

	} else {
		return [];
	}
}

// Used in clean, fixes the defaultChecked property
function fixDefaultChecked( elem ) {
	if ( rcheckableType.test( elem.type ) ) {
		elem.defaultChecked = elem.checked;
	}
}

jQuery.extend({
	clone: function( elem, dataAndEvents, deepDataAndEvents ) {
		var srcElements,
			destElements,
			i,
			clone;

		if ( jQuery.support.html5Clone || jQuery.isXMLDoc(elem) || !rnoshimcache.test( "<" + elem.nodeName + ">" ) ) {
			clone = elem.cloneNode( true );

		// IE<=8 does not properly clone detached, unknown element nodes
		} else {
			fragmentDiv.innerHTML = elem.outerHTML;
			fragmentDiv.removeChild( clone = fragmentDiv.firstChild );
		}

		if ( (!jQuery.support.noCloneEvent || !jQuery.support.noCloneChecked) &&
				(elem.nodeType === 1 || elem.nodeType === 11) && !jQuery.isXMLDoc(elem) ) {
			// IE copies events bound via attachEvent when using cloneNode.
			// Calling detachEvent on the clone will also remove the events
			// from the original. In order to get around this, we use some
			// proprietary methods to clear the events. Thanks to MooTools
			// guys for this hotness.

			cloneFixAttributes( elem, clone );

			// Using Sizzle here is crazy slow, so we use getElementsByTagName instead
			srcElements = getAll( elem );
			destElements = getAll( clone );

			// Weird iteration because IE will replace the length property
			// with an element if you are cloning the body and one of the
			// elements on the page has a name or id of "length"
			for ( i = 0; srcElements[i]; ++i ) {
				// Ensure that the destination node is not null; Fixes #9587
				if ( destElements[i] ) {
					cloneFixAttributes( srcElements[i], destElements[i] );
				}
			}
		}

		// Copy the events from the original to the clone
		if ( dataAndEvents ) {
			cloneCopyEvent( elem, clone );

			if ( deepDataAndEvents ) {
				srcElements = getAll( elem );
				destElements = getAll( clone );

				for ( i = 0; srcElements[i]; ++i ) {
					cloneCopyEvent( srcElements[i], destElements[i] );
				}
			}
		}

		srcElements = destElements = null;

		// Return the cloned set
		return clone;
	},

	clean: function( elems, context, fragment, scripts ) {
		var i, j, elem, tag, wrap, depth, div, hasBody, tbody, len, handleScript, jsTags,
			safe = context === document && safeFragment,
			ret = [];

		// Ensure that context is a document
		if ( !context || typeof context.createDocumentFragment === "undefined" ) {
			context = document;
		}

		// Use the already-created safe fragment if context permits
		for ( i = 0; (elem = elems[i]) != null; i++ ) {
			if ( typeof elem === "number" ) {
				elem += "";
			}

			if ( !elem ) {
				continue;
			}

			// Convert html string into DOM nodes
			if ( typeof elem === "string" ) {
				if ( !rhtml.test( elem ) ) {
					elem = context.createTextNode( elem );
				} else {
					// Ensure a safe container in which to render the html
					safe = safe || createSafeFragment( context );
					div = context.createElement("div");
					safe.appendChild( div );

					// Fix "XHTML"-style tags in all browsers
					elem = elem.replace(rxhtmlTag, "<$1></$2>");

					// Go to html and back, then peel off extra wrappers
					tag = ( rtagName.exec( elem ) || ["", ""] )[1].toLowerCase();
					wrap = wrapMap[ tag ] || wrapMap._default;
					depth = wrap[0];
					div.innerHTML = wrap[1] + elem + wrap[2];

					// Move to the right depth
					while ( depth-- ) {
						div = div.lastChild;
					}

					// Remove IE's autoinserted <tbody> from table fragments
					if ( !jQuery.support.tbody ) {

						// String was a <table>, *may* have spurious <tbody>
						hasBody = rtbody.test(elem);
							tbody = tag === "table" && !hasBody ?
								div.firstChild && div.firstChild.childNodes :

								// String was a bare <thead> or <tfoot>
								wrap[1] === "<table>" && !hasBody ?
									div.childNodes :
									[];

						for ( j = tbody.length - 1; j >= 0 ; --j ) {
							if ( jQuery.nodeName( tbody[ j ], "tbody" ) && !tbody[ j ].childNodes.length ) {
								tbody[ j ].parentNode.removeChild( tbody[ j ] );
							}
						}
					}

					// IE completely kills leading whitespace when innerHTML is used
					if ( !jQuery.support.leadingWhitespace && rleadingWhitespace.test( elem ) ) {
						div.insertBefore( context.createTextNode( rleadingWhitespace.exec(elem)[0] ), div.firstChild );
					}

					elem = div.childNodes;

					// Take out of fragment container (we need a fresh div each time)
					div.parentNode.removeChild( div );
				}
			}

			if ( elem.nodeType ) {
				ret.push( elem );
			} else {
				jQuery.merge( ret, elem );
			}
		}

		// Fix #11356: Clear elements from safeFragment
		if ( div ) {
			elem = div = safe = null;
		}

		// Reset defaultChecked for any radios and checkboxes
		// about to be appended to the DOM in IE 6/7 (#8060)
		if ( !jQuery.support.appendChecked ) {
			for ( i = 0; (elem = ret[i]) != null; i++ ) {
				if ( jQuery.nodeName( elem, "input" ) ) {
					fixDefaultChecked( elem );
				} else if ( typeof elem.getElementsByTagName !== "undefined" ) {
					jQuery.grep( elem.getElementsByTagName("input"), fixDefaultChecked );
				}
			}
		}

		// Append elements to a provided document fragment
		if ( fragment ) {
			// Special handling of each script element
			handleScript = function( elem ) {
				// Check if we consider it executable
				if ( !elem.type || rscriptType.test( elem.type ) ) {
					// Detach the script and store it in the scripts array (if provided) or the fragment
					// Return truthy to indicate that it has been handled
					return scripts ?
						scripts.push( elem.parentNode ? elem.parentNode.removeChild( elem ) : elem ) :
						fragment.appendChild( elem );
				}
			};

			for ( i = 0; (elem = ret[i]) != null; i++ ) {
				// Check if we're done after handling an executable script
				if ( !( jQuery.nodeName( elem, "script" ) && handleScript( elem ) ) ) {
					// Append to fragment and handle embedded scripts
					fragment.appendChild( elem );
					if ( typeof elem.getElementsByTagName !== "undefined" ) {
						// handleScript alters the DOM, so use jQuery.merge to ensure snapshot iteration
						jsTags = jQuery.grep( jQuery.merge( [], elem.getElementsByTagName("script") ), handleScript );

						// Splice the scripts into ret after their former ancestor and advance our index beyond them
						ret.splice.apply( ret, [i + 1, 0].concat( jsTags ) );
						i += jsTags.length;
					}
				}
			}
		}

		return ret;
	},

	cleanData: function( elems, /* internal */ acceptData ) {
		var data, id, elem, type,
			i = 0,
			internalKey = jQuery.expando,
			cache = jQuery.cache,
			deleteExpando = jQuery.support.deleteExpando,
			special = jQuery.event.special;

		for ( ; (elem = elems[i]) != null; i++ ) {

			if ( acceptData || jQuery.acceptData( elem ) ) {

				id = elem[ internalKey ];
				data = id && cache[ id ];

				if ( data ) {
					if ( data.events ) {
						for ( type in data.events ) {
							if ( special[ type ] ) {
								jQuery.event.remove( elem, type );

							// This is a shortcut to avoid jQuery.event.remove's overhead
							} else {
								jQuery.removeEvent( elem, type, data.handle );
							}
						}
					}

					// Remove cache only if it was not already removed by jQuery.event.remove
					if ( cache[ id ] ) {

						delete cache[ id ];

						// IE does not allow us to delete expando properties from nodes,
						// nor does it have a removeAttribute function on Document nodes;
						// we must handle all of these cases
						if ( deleteExpando ) {
							delete elem[ internalKey ];

						} else if ( elem.removeAttribute ) {
							elem.removeAttribute( internalKey );

						} else {
							elem[ internalKey ] = null;
						}

						jQuery.deletedIds.push( id );
					}
				}
			}
		}
	}
});
// Limit scope pollution from any deprecated API
(function() {

var matched, browser;

// Use of jQuery.browser is frowned upon.
// More details: http://api.jquery.com/jQuery.browser
// jQuery.uaMatch maintained for back-compat
jQuery.uaMatch = function( ua ) {
	ua = ua.toLowerCase();

	var match = /(chrome)[ \/]([\w.]+)/.exec( ua ) ||
		/(webkit)[ \/]([\w.]+)/.exec( ua ) ||
		/(opera)(?:.*version|)[ \/]([\w.]+)/.exec( ua ) ||
		/(msie) ([\w.]+)/.exec( ua ) ||
		ua.indexOf("compatible") < 0 && /(mozilla)(?:.*? rv:([\w.]+)|)/.exec( ua ) ||
		[];

	return {
		browser: match[ 1 ] || "",
		version: match[ 2 ] || "0"
	};
};

matched = jQuery.uaMatch( navigator.userAgent );
browser = {};

if ( matched.browser ) {
	browser[ matched.browser ] = true;
	browser.version = matched.version;
}

// Chrome is Webkit, but Webkit is also Safari.
if ( browser.chrome ) {
	browser.webkit = true;
} else if ( browser.webkit ) {
	browser.safari = true;
}

jQuery.browser = browser;

jQuery.sub = function() {
	function jQuerySub( selector, context ) {
		return new jQuerySub.fn.init( selector, context );
	}
	jQuery.extend( true, jQuerySub, this );
	jQuerySub.superclass = this;
	jQuerySub.fn = jQuerySub.prototype = this();
	jQuerySub.fn.constructor = jQuerySub;
	jQuerySub.sub = this.sub;
	jQuerySub.fn.init = function init( selector, context ) {
		if ( context && context instanceof jQuery && !(context instanceof jQuerySub) ) {
			context = jQuerySub( context );
		}

		return jQuery.fn.init.call( this, selector, context, rootjQuerySub );
	};
	jQuerySub.fn.init.prototype = jQuerySub.fn;
	var rootjQuerySub = jQuerySub(document);
	return jQuerySub;
};

})();
var curCSS, iframe, iframeDoc,
	ralpha = /alpha\([^)]*\)/i,
	ropacity = /opacity=([^)]*)/,
	rposition = /^(top|right|bottom|left)$/,
	// swappable if display is none or starts with table except "table", "table-cell", or "table-caption"
	// see here for display values: https://developer.mozilla.org/en-US/docs/CSS/display
	rdisplayswap = /^(none|table(?!-c[ea]).+)/,
	rmargin = /^margin/,
	rnumsplit = new RegExp( "^(" + core_pnum + ")(.*)$", "i" ),
	rnumnonpx = new RegExp( "^(" + core_pnum + ")(?!px)[a-z%]+$", "i" ),
	rrelNum = new RegExp( "^([-+])=(" + core_pnum + ")", "i" ),
	elemdisplay = {},

	cssShow = { position: "absolute", visibility: "hidden", display: "block" },
	cssNormalTransform = {
		letterSpacing: 0,
		fontWeight: 400
	},

	cssExpand = [ "Top", "Right", "Bottom", "Left" ],
	cssPrefixes = [ "Webkit", "O", "Moz", "ms" ],

	eventsToggle = jQuery.fn.toggle;

// return a css property mapped to a potentially vendor prefixed property
function vendorPropName( style, name ) {

	// shortcut for names that are not vendor prefixed
	if ( name in style ) {
		return name;
	}

	// check for vendor prefixed names
	var capName = name.charAt(0).toUpperCase() + name.slice(1),
		origName = name,
		i = cssPrefixes.length;

	while ( i-- ) {
		name = cssPrefixes[ i ] + capName;
		if ( name in style ) {
			return name;
		}
	}

	return origName;
}

function isHidden( elem, el ) {
	elem = el || elem;
	return jQuery.css( elem, "display" ) === "none" || !jQuery.contains( elem.ownerDocument, elem );
}

function showHide( elements, show ) {
	var elem, display,
		values = [],
		index = 0,
		length = elements.length;

	for ( ; index < length; index++ ) {
		elem = elements[ index ];
		if ( !elem.style ) {
			continue;
		}
		values[ index ] = jQuery._data( elem, "olddisplay" );
		if ( show ) {
			// Reset the inline display of this element to learn if it is
			// being hidden by cascaded rules or not
			if ( !values[ index ] && elem.style.display === "none" ) {
				elem.style.display = "";
			}

			// Set elements which have been overridden with display: none
			// in a stylesheet to whatever the default browser style is
			// for such an element
			if ( elem.style.display === "" && isHidden( elem ) ) {
				values[ index ] = jQuery._data( elem, "olddisplay", css_defaultDisplay(elem.nodeName) );
			}
		} else {
			display = curCSS( elem, "display" );

			if ( !values[ index ] && display !== "none" ) {
				jQuery._data( elem, "olddisplay", display );
			}
		}
	}

	// Set the display of most of the elements in a second loop
	// to avoid the constant reflow
	for ( index = 0; index < length; index++ ) {
		elem = elements[ index ];
		if ( !elem.style ) {
			continue;
		}
		if ( !show || elem.style.display === "none" || elem.style.display === "" ) {
			elem.style.display = show ? values[ index ] || "" : "none";
		}
	}

	return elements;
}

jQuery.fn.extend({
	css: function( name, value ) {
		return jQuery.access( this, function( elem, name, value ) {
			return value !== undefined ?
				jQuery.style( elem, name, value ) :
				jQuery.css( elem, name );
		}, name, value, arguments.length > 1 );
	},
	show: function() {
		return showHide( this, true );
	},
	hide: function() {
		return showHide( this );
	},
	toggle: function( state, fn2 ) {
		var bool = typeof state === "boolean";

		if ( jQuery.isFunction( state ) && jQuery.isFunction( fn2 ) ) {
			return eventsToggle.apply( this, arguments );
		}

		return this.each(function() {
			if ( bool ? state : isHidden( this ) ) {
				jQuery( this ).show();
			} else {
				jQuery( this ).hide();
			}
		});
	}
});

jQuery.extend({
	// Add in style property hooks for overriding the default
	// behavior of getting and setting a style property
	cssHooks: {
		opacity: {
			get: function( elem, computed ) {
				if ( computed ) {
					// We should always get a number back from opacity
					var ret = curCSS( elem, "opacity" );
					return ret === "" ? "1" : ret;

				}
			}
		}
	},

	// Exclude the following css properties to add px
	cssNumber: {
		"fillOpacity": true,
		"fontWeight": true,
		"lineHeight": true,
		"opacity": true,
		"orphans": true,
		"widows": true,
		"zIndex": true,
		"zoom": true
	},

	// Add in properties whose names you wish to fix before
	// setting or getting the value
	cssProps: {
		// normalize float css property
		"float": jQuery.support.cssFloat ? "cssFloat" : "styleFloat"
	},

	// Get and set the style property on a DOM Node
	style: function( elem, name, value, extra ) {
		// Don't set styles on text and comment nodes
		if ( !elem || elem.nodeType === 3 || elem.nodeType === 8 || !elem.style ) {
			return;
		}

		// Make sure that we're working with the right name
		var ret, type, hooks,
			origName = jQuery.camelCase( name ),
			style = elem.style;

		name = jQuery.cssProps[ origName ] || ( jQuery.cssProps[ origName ] = vendorPropName( style, origName ) );

		// gets hook for the prefixed version
		// followed by the unprefixed version
		hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];

		// Check if we're setting a value
		if ( value !== undefined ) {
			type = typeof value;

			// convert relative number strings (+= or -=) to relative numbers. #7345
			if ( type === "string" && (ret = rrelNum.exec( value )) ) {
				value = ( ret[1] + 1 ) * ret[2] + parseFloat( jQuery.css( elem, name ) );
				// Fixes bug #9237
				type = "number";
			}

			// Make sure that NaN and null values aren't set. See: #7116
			if ( value == null || type === "number" && isNaN( value ) ) {
				return;
			}

			// If a number was passed in, add 'px' to the (except for certain CSS properties)
			if ( type === "number" && !jQuery.cssNumber[ origName ] ) {
				value += "px";
			}

			// If a hook was provided, use that value, otherwise just set the specified value
			if ( !hooks || !("set" in hooks) || (value = hooks.set( elem, value, extra )) !== undefined ) {
				// Wrapped to prevent IE from throwing errors when 'invalid' values are provided
				// Fixes bug #5509
				try {
					style[ name ] = value;
				} catch(e) {}
			}

		} else {
			// If a hook was provided get the non-computed value from there
			if ( hooks && "get" in hooks && (ret = hooks.get( elem, false, extra )) !== undefined ) {
				return ret;
			}

			// Otherwise just get the value from the style object
			return style[ name ];
		}
	},

	css: function( elem, name, numeric, extra ) {
		var val, num, hooks,
			origName = jQuery.camelCase( name );

		// Make sure that we're working with the right name
		name = jQuery.cssProps[ origName ] || ( jQuery.cssProps[ origName ] = vendorPropName( elem.style, origName ) );

		// gets hook for the prefixed version
		// followed by the unprefixed version
		hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];

		// If a hook was provided get the computed value from there
		if ( hooks && "get" in hooks ) {
			val = hooks.get( elem, true, extra );
		}

		// Otherwise, if a way to get the computed value exists, use that
		if ( val === undefined ) {
			val = curCSS( elem, name );
		}

		//convert "normal" to computed value
		if ( val === "normal" && name in cssNormalTransform ) {
			val = cssNormalTransform[ name ];
		}

		// Return, converting to number if forced or a qualifier was provided and val looks numeric
		if ( numeric || extra !== undefined ) {
			num = parseFloat( val );
			return numeric || jQuery.isNumeric( num ) ? num || 0 : val;
		}
		return val;
	},

	// A method for quickly swapping in/out CSS properties to get correct calculations
	swap: function( elem, options, callback ) {
		var ret, name,
			old = {};

		// Remember the old values, and insert the new ones
		for ( name in options ) {
			old[ name ] = elem.style[ name ];
			elem.style[ name ] = options[ name ];
		}

		ret = callback.call( elem );

		// Revert the old values
		for ( name in options ) {
			elem.style[ name ] = old[ name ];
		}

		return ret;
	}
});

// NOTE: To any future maintainer, we've window.getComputedStyle
// because jsdom on node.js will break without it.
if ( window.getComputedStyle ) {
	curCSS = function( elem, name ) {
		var ret, width, minWidth, maxWidth,
			computed = window.getComputedStyle( elem, null ),
			style = elem.style;

		if ( computed ) {

			ret = computed[ name ];
			if ( ret === "" && !jQuery.contains( elem.ownerDocument, elem ) ) {
				ret = jQuery.style( elem, name );
			}

			// A tribute to the "awesome hack by Dean Edwards"
			// Chrome < 17 and Safari 5.0 uses "computed value" instead of "used value" for margin-right
			// Safari 5.1.7 (at least) returns percentage for a larger set of values, but width seems to be reliably pixels
			// this is against the CSSOM draft spec: http://dev.w3.org/csswg/cssom/#resolved-values
			if ( rnumnonpx.test( ret ) && rmargin.test( name ) ) {
				width = style.width;
				minWidth = style.minWidth;
				maxWidth = style.maxWidth;

				style.minWidth = style.maxWidth = style.width = ret;
				ret = computed.width;

				style.width = width;
				style.minWidth = minWidth;
				style.maxWidth = maxWidth;
			}
		}

		return ret;
	};
} else if ( document.documentElement.currentStyle ) {
	curCSS = function( elem, name ) {
		var left, rsLeft,
			ret = elem.currentStyle && elem.currentStyle[ name ],
			style = elem.style;

		// Avoid setting ret to empty string here
		// so we don't default to auto
		if ( ret == null && style && style[ name ] ) {
			ret = style[ name ];
		}

		// From the awesome hack by Dean Edwards
		// http://erik.eae.net/archives/2007/07/27/18.54.15/#comment-102291

		// If we're not dealing with a regular pixel number
		// but a number that has a weird ending, we need to convert it to pixels
		// but not position css attributes, as those are proportional to the parent element instead
		// and we can't measure the parent instead because it might trigger a "stacking dolls" problem
		if ( rnumnonpx.test( ret ) && !rposition.test( name ) ) {

			// Remember the original values
			left = style.left;
			rsLeft = elem.runtimeStyle && elem.runtimeStyle.left;

			// Put in the new values to get a computed value out
			if ( rsLeft ) {
				elem.runtimeStyle.left = elem.currentStyle.left;
			}
			style.left = name === "fontSize" ? "1em" : ret;
			ret = style.pixelLeft + "px";

			// Revert the changed values
			style.left = left;
			if ( rsLeft ) {
				elem.runtimeStyle.left = rsLeft;
			}
		}

		return ret === "" ? "auto" : ret;
	};
}

function setPositiveNumber( elem, value, subtract ) {
	var matches = rnumsplit.exec( value );
	return matches ?
			Math.max( 0, matches[ 1 ] - ( subtract || 0 ) ) + ( matches[ 2 ] || "px" ) :
			value;
}

function augmentWidthOrHeight( elem, name, extra, isBorderBox ) {
	var i = extra === ( isBorderBox ? "border" : "content" ) ?
		// If we already have the right measurement, avoid augmentation
		4 :
		// Otherwise initialize for horizontal or vertical properties
		name === "width" ? 1 : 0,

		val = 0;

	for ( ; i < 4; i += 2 ) {
		// both box models exclude margin, so add it if we want it
		if ( extra === "margin" ) {
			// we use jQuery.css instead of curCSS here
			// because of the reliableMarginRight CSS hook!
			val += jQuery.css( elem, extra + cssExpand[ i ], true );
		}

		// From this point on we use curCSS for maximum performance (relevant in animations)
		if ( isBorderBox ) {
			// border-box includes padding, so remove it if we want content
			if ( extra === "content" ) {
				val -= parseFloat( curCSS( elem, "padding" + cssExpand[ i ] ) ) || 0;
			}

			// at this point, extra isn't border nor margin, so remove border
			if ( extra !== "margin" ) {
				val -= parseFloat( curCSS( elem, "border" + cssExpand[ i ] + "Width" ) ) || 0;
			}
		} else {
			// at this point, extra isn't content, so add padding
			val += parseFloat( curCSS( elem, "padding" + cssExpand[ i ] ) ) || 0;

			// at this point, extra isn't content nor padding, so add border
			if ( extra !== "padding" ) {
				val += parseFloat( curCSS( elem, "border" + cssExpand[ i ] + "Width" ) ) || 0;
			}
		}
	}

	return val;
}

function getWidthOrHeight( elem, name, extra ) {

	// Start with offset property, which is equivalent to the border-box value
	var val = name === "width" ? elem.offsetWidth : elem.offsetHeight,
		valueIsBorderBox = true,
		isBorderBox = jQuery.support.boxSizing && jQuery.css( elem, "boxSizing" ) === "border-box";

	// some non-html elements return undefined for offsetWidth, so check for null/undefined
	// svg - https://bugzilla.mozilla.org/show_bug.cgi?id=649285
	// MathML - https://bugzilla.mozilla.org/show_bug.cgi?id=491668
	if ( val <= 0 || val == null ) {
		// Fall back to computed then uncomputed css if necessary
		val = curCSS( elem, name );
		if ( val < 0 || val == null ) {
			val = elem.style[ name ];
		}

		// Computed unit is not pixels. Stop here and return.
		if ( rnumnonpx.test(val) ) {
			return val;
		}

		// we need the check for style in case a browser which returns unreliable values
		// for getComputedStyle silently falls back to the reliable elem.style
		valueIsBorderBox = isBorderBox && ( jQuery.support.boxSizingReliable || val === elem.style[ name ] );

		// Normalize "", auto, and prepare for extra
		val = parseFloat( val ) || 0;
	}

	// use the active box-sizing model to add/subtract irrelevant styles
	return ( val +
		augmentWidthOrHeight(
			elem,
			name,
			extra || ( isBorderBox ? "border" : "content" ),
			valueIsBorderBox
		)
	) + "px";
}


// Try to determine the default display value of an element
function css_defaultDisplay( nodeName ) {
	if ( elemdisplay[ nodeName ] ) {
		return elemdisplay[ nodeName ];
	}

	var elem = jQuery( "<" + nodeName + ">" ).appendTo( document.body ),
		display = elem.css("display");
	elem.remove();

	// If the simple way fails,
	// get element's real default display by attaching it to a temp iframe
	if ( display === "none" || display === "" ) {
		// Use the already-created iframe if possible
		iframe = document.body.appendChild(
			iframe || jQuery.extend( document.createElement("iframe"), {
				frameBorder: 0,
				width: 0,
				height: 0
			})
		);

		// Create a cacheable copy of the iframe document on first call.
		// IE and Opera will allow us to reuse the iframeDoc without re-writing the fake HTML
		// document to it; WebKit & Firefox won't allow reusing the iframe document.
		if ( !iframeDoc || !iframe.createElement ) {
			iframeDoc = ( iframe.contentWindow || iframe.contentDocument ).document;
			iframeDoc.write("<!doctype html><html><body>");
			iframeDoc.close();
		}

		elem = iframeDoc.body.appendChild( iframeDoc.createElement(nodeName) );

		display = curCSS( elem, "display" );
		document.body.removeChild( iframe );
	}

	// Store the correct default display
	elemdisplay[ nodeName ] = display;

	return display;
}

jQuery.each([ "height", "width" ], function( i, name ) {
	jQuery.cssHooks[ name ] = {
		get: function( elem, computed, extra ) {
			if ( computed ) {
				// certain elements can have dimension info if we invisibly show them
				// however, it must have a current display style that would benefit from this
				if ( elem.offsetWidth === 0 && rdisplayswap.test( curCSS( elem, "display" ) ) ) {
					return jQuery.swap( elem, cssShow, function() {
						return getWidthOrHeight( elem, name, extra );
					});
				} else {
					return getWidthOrHeight( elem, name, extra );
				}
			}
		},

		set: function( elem, value, extra ) {
			return setPositiveNumber( elem, value, extra ?
				augmentWidthOrHeight(
					elem,
					name,
					extra,
					jQuery.support.boxSizing && jQuery.css( elem, "boxSizing" ) === "border-box"
				) : 0
			);
		}
	};
});

if ( !jQuery.support.opacity ) {
	jQuery.cssHooks.opacity = {
		get: function( elem, computed ) {
			// IE uses filters for opacity
			return ropacity.test( (computed && elem.currentStyle ? elem.currentStyle.filter : elem.style.filter) || "" ) ?
				( 0.01 * parseFloat( RegExp.$1 ) ) + "" :
				computed ? "1" : "";
		},

		set: function( elem, value ) {
			var style = elem.style,
				currentStyle = elem.currentStyle,
				opacity = jQuery.isNumeric( value ) ? "alpha(opacity=" + value * 100 + ")" : "",
				filter = currentStyle && currentStyle.filter || style.filter || "";

			// IE has trouble with opacity if it does not have layout
			// Force it by setting the zoom level
			style.zoom = 1;

			// if setting opacity to 1, and no other filters exist - attempt to remove filter attribute #6652
			if ( value >= 1 && jQuery.trim( filter.replace( ralpha, "" ) ) === "" &&
				style.removeAttribute ) {

				// Setting style.filter to null, "" & " " still leave "filter:" in the cssText
				// if "filter:" is present at all, clearType is disabled, we want to avoid this
				// style.removeAttribute is IE Only, but so apparently is this code path...
				style.removeAttribute( "filter" );

				// if there there is no filter style applied in a css rule, we are done
				if ( currentStyle && !currentStyle.filter ) {
					return;
				}
			}

			// otherwise, set new filter values
			style.filter = ralpha.test( filter ) ?
				filter.replace( ralpha, opacity ) :
				filter + " " + opacity;
		}
	};
}

// These hooks cannot be added until DOM ready because the support test
// for it is not run until after DOM ready
jQuery(function() {
	if ( !jQuery.support.reliableMarginRight ) {
		jQuery.cssHooks.marginRight = {
			get: function( elem, computed ) {
				// WebKit Bug 13343 - getComputedStyle returns wrong value for margin-right
				// Work around by temporarily setting element display to inline-block
				return jQuery.swap( elem, { "display": "inline-block" }, function() {
					if ( computed ) {
						return curCSS( elem, "marginRight" );
					}
				});
			}
		};
	}

	// Webkit bug: https://bugs.webkit.org/show_bug.cgi?id=29084
	// getComputedStyle returns percent when specified for top/left/bottom/right
	// rather than make the css module depend on the offset module, we just check for it here
	if ( !jQuery.support.pixelPosition && jQuery.fn.position ) {
		jQuery.each( [ "top", "left" ], function( i, prop ) {
			jQuery.cssHooks[ prop ] = {
				get: function( elem, computed ) {
					if ( computed ) {
						var ret = curCSS( elem, prop );
						// if curCSS returns percentage, fallback to offset
						return rnumnonpx.test( ret ) ? jQuery( elem ).position()[ prop ] + "px" : ret;
					}
				}
			};
		});
	}

});

if ( jQuery.expr && jQuery.expr.filters ) {
	jQuery.expr.filters.hidden = function( elem ) {
		return ( elem.offsetWidth === 0 && elem.offsetHeight === 0 ) || (!jQuery.support.reliableHiddenOffsets && ((elem.style && elem.style.display) || curCSS( elem, "display" )) === "none");
	};

	jQuery.expr.filters.visible = function( elem ) {
		return !jQuery.expr.filters.hidden( elem );
	};
}

// These hooks are used by animate to expand properties
jQuery.each({
	margin: "",
	padding: "",
	border: "Width"
}, function( prefix, suffix ) {
	jQuery.cssHooks[ prefix + suffix ] = {
		expand: function( value ) {
			var i,

				// assumes a single number if not a string
				parts = typeof value === "string" ? value.split(" ") : [ value ],
				expanded = {};

			for ( i = 0; i < 4; i++ ) {
				expanded[ prefix + cssExpand[ i ] + suffix ] =
					parts[ i ] || parts[ i - 2 ] || parts[ 0 ];
			}

			return expanded;
		}
	};

	if ( !rmargin.test( prefix ) ) {
		jQuery.cssHooks[ prefix + suffix ].set = setPositiveNumber;
	}
});
var r20 = /%20/g,
	rbracket = /\[\]$/,
	rCRLF = /\r?\n/g,
	rinput = /^(?:color|date|datetime|datetime-local|email|hidden|month|number|password|range|search|tel|text|time|url|week)$/i,
	rselectTextarea = /^(?:select|textarea)/i;

jQuery.fn.extend({
	serialize: function() {
		return jQuery.param( this.serializeArray() );
	},
	serializeArray: function() {
		return this.map(function(){
			return this.elements ? jQuery.makeArray( this.elements ) : this;
		})
		.filter(function(){
			return this.name && !this.disabled &&
				( this.checked || rselectTextarea.test( this.nodeName ) ||
					rinput.test( this.type ) );
		})
		.map(function( i, elem ){
			var val = jQuery( this ).val();

			return val == null ?
				null :
				jQuery.isArray( val ) ?
					jQuery.map( val, function( val, i ){
						return { name: elem.name, value: val.replace( rCRLF, "\r\n" ) };
					}) :
					{ name: elem.name, value: val.replace( rCRLF, "\r\n" ) };
		}).get();
	}
});

//Serialize an array of form elements or a set of
//key/values into a query string
jQuery.param = function( a, traditional ) {
	var prefix,
		s = [],
		add = function( key, value ) {
			// If value is a function, invoke it and return its value
			value = jQuery.isFunction( value ) ? value() : ( value == null ? "" : value );
			s[ s.length ] = encodeURIComponent( key ) + "=" + encodeURIComponent( value );
		};

	// Set traditional to true for jQuery <= 1.3.2 behavior.
	if ( traditional === undefined ) {
		traditional = jQuery.ajaxSettings && jQuery.ajaxSettings.traditional;
	}

	// If an array was passed in, assume that it is an array of form elements.
	if ( jQuery.isArray( a ) || ( a.jquery && !jQuery.isPlainObject( a ) ) ) {
		// Serialize the form elements
		jQuery.each( a, function() {
			add( this.name, this.value );
		});

	} else {
		// If traditional, encode the "old" way (the way 1.3.2 or older
		// did it), otherwise encode params recursively.
		for ( prefix in a ) {
			buildParams( prefix, a[ prefix ], traditional, add );
		}
	}

	// Return the resulting serialization
	return s.join( "&" ).replace( r20, "+" );
};

function buildParams( prefix, obj, traditional, add ) {
	var name;

	if ( jQuery.isArray( obj ) ) {
		// Serialize array item.
		jQuery.each( obj, function( i, v ) {
			if ( traditional || rbracket.test( prefix ) ) {
				// Treat each array item as a scalar.
				add( prefix, v );

			} else {
				// If array item is non-scalar (array or object), encode its
				// numeric index to resolve deserialization ambiguity issues.
				// Note that rack (as of 1.0.0) can't currently deserialize
				// nested arrays properly, and attempting to do so may cause
				// a server error. Possible fixes are to modify rack's
				// deserialization algorithm or to provide an option or flag
				// to force array serialization to be shallow.
				buildParams( prefix + "[" + ( typeof v === "object" ? i : "" ) + "]", v, traditional, add );
			}
		});

	} else if ( !traditional && jQuery.type( obj ) === "object" ) {
		// Serialize object item.
		for ( name in obj ) {
			buildParams( prefix + "[" + name + "]", obj[ name ], traditional, add );
		}

	} else {
		// Serialize scalar item.
		add( prefix, obj );
	}
}
var
	// Document location
	ajaxLocParts,
	ajaxLocation,

	rhash = /#.*$/,
	rheaders = /^(.*?):[ \t]*([^\r\n]*)\r?$/mg, // IE leaves an \r character at EOL
	// #7653, #8125, #8152: local protocol detection
	rlocalProtocol = /^(?:about|app|app\-storage|.+\-extension|file|res|widget):$/,
	rnoContent = /^(?:GET|HEAD)$/,
	rprotocol = /^\/\//,
	rquery = /\?/,
	rscript = /<script\b[^<]*(?:(?!<\/script>)<[^<]*)*<\/script>/gi,
	rts = /([?&])_=[^&]*/,
	rurl = /^([\w\+\.\-]+:)(?:\/\/([^\/?#:]*)(?::(\d+)|)|)/,

	// Keep a copy of the old load method
	_load = jQuery.fn.load,

	/* Prefilters
	 * 1) They are useful to introduce custom dataTypes (see ajax/jsonp.js for an example)
	 * 2) These are called:
	 *    - BEFORE asking for a transport
	 *    - AFTER param serialization (s.data is a string if s.processData is true)
	 * 3) key is the dataType
	 * 4) the catchall symbol "*" can be used
	 * 5) execution will start with transport dataType and THEN continue down to "*" if needed
	 */
	prefilters = {},

	/* Transports bindings
	 * 1) key is the dataType
	 * 2) the catchall symbol "*" can be used
	 * 3) selection will start with transport dataType and THEN go to "*" if needed
	 */
	transports = {},

	// Avoid comment-prolog char sequence (#10098); must appease lint and evade compression
	allTypes = ["*/"] + ["*"];

// #8138, IE may throw an exception when accessing
// a field from window.location if document.domain has been set
try {
	ajaxLocation = location.href;
} catch( e ) {
	// Use the href attribute of an A element
	// since IE will modify it given document.location
	ajaxLocation = document.createElement( "a" );
	ajaxLocation.href = "";
	ajaxLocation = ajaxLocation.href;
}

// Segment location into parts
ajaxLocParts = rurl.exec( ajaxLocation.toLowerCase() ) || [];

// Base "constructor" for jQuery.ajaxPrefilter and jQuery.ajaxTransport
function addToPrefiltersOrTransports( structure ) {

	// dataTypeExpression is optional and defaults to "*"
	return function( dataTypeExpression, func ) {

		if ( typeof dataTypeExpression !== "string" ) {
			func = dataTypeExpression;
			dataTypeExpression = "*";
		}

		var dataType, list, placeBefore,
			dataTypes = dataTypeExpression.toLowerCase().split( core_rspace ),
			i = 0,
			length = dataTypes.length;

		if ( jQuery.isFunction( func ) ) {
			// For each dataType in the dataTypeExpression
			for ( ; i < length; i++ ) {
				dataType = dataTypes[ i ];
				// We control if we're asked to add before
				// any existing element
				placeBefore = /^\+/.test( dataType );
				if ( placeBefore ) {
					dataType = dataType.substr( 1 ) || "*";
				}
				list = structure[ dataType ] = structure[ dataType ] || [];
				// then we add to the structure accordingly
				list[ placeBefore ? "unshift" : "push" ]( func );
			}
		}
	};
}

// Base inspection function for prefilters and transports
function inspectPrefiltersOrTransports( structure, options, originalOptions, jqXHR,
		dataType /* internal */, inspected /* internal */ ) {

	dataType = dataType || options.dataTypes[ 0 ];
	inspected = inspected || {};

	inspected[ dataType ] = true;

	var selection,
		list = structure[ dataType ],
		i = 0,
		length = list ? list.length : 0,
		executeOnly = ( structure === prefilters );

	for ( ; i < length && ( executeOnly || !selection ); i++ ) {
		selection = list[ i ]( options, originalOptions, jqXHR );
		// If we got redirected to another dataType
		// we try there if executing only and not done already
		if ( typeof selection === "string" ) {
			if ( !executeOnly || inspected[ selection ] ) {
				selection = undefined;
			} else {
				options.dataTypes.unshift( selection );
				selection = inspectPrefiltersOrTransports(
						structure, options, originalOptions, jqXHR, selection, inspected );
			}
		}
	}
	// If we're only executing or nothing was selected
	// we try the catchall dataType if not done already
	if ( ( executeOnly || !selection ) && !inspected[ "*" ] ) {
		selection = inspectPrefiltersOrTransports(
				structure, options, originalOptions, jqXHR, "*", inspected );
	}
	// unnecessary when only executing (prefilters)
	// but it'll be ignored by the caller in that case
	return selection;
}

// A special extend for ajax options
// that takes "flat" options (not to be deep extended)
// Fixes #9887
function ajaxExtend( target, src ) {
	var key, deep,
		flatOptions = jQuery.ajaxSettings.flatOptions || {};
	for ( key in src ) {
		if ( src[ key ] !== undefined ) {
			( flatOptions[ key ] ? target : ( deep || ( deep = {} ) ) )[ key ] = src[ key ];
		}
	}
	if ( deep ) {
		jQuery.extend( true, target, deep );
	}
}

jQuery.fn.load = function( url, params, callback ) {
	if ( typeof url !== "string" && _load ) {
		return _load.apply( this, arguments );
	}

	// Don't do a request if no elements are being requested
	if ( !this.length ) {
		return this;
	}

	var selector, type, response,
		self = this,
		off = url.indexOf(" ");

	if ( off >= 0 ) {
		selector = url.slice( off, url.length );
		url = url.slice( 0, off );
	}

	// If it's a function
	if ( jQuery.isFunction( params ) ) {

		// We assume that it's the callback
		callback = params;
		params = undefined;

	// Otherwise, build a param string
	} else if ( params && typeof params === "object" ) {
		type = "POST";
	}

	// Request the remote document
	jQuery.ajax({
		url: url,

		// if "type" variable is undefined, then "GET" method will be used
		type: type,
		dataType: "html",
		data: params,
		complete: function( jqXHR, status ) {
			if ( callback ) {
				self.each( callback, response || [ jqXHR.responseText, status, jqXHR ] );
			}
		}
	}).done(function( responseText ) {

		// Save response for use in complete callback
		response = arguments;

		// See if a selector was specified
		self.html( selector ?

			// Create a dummy div to hold the results
			jQuery("<div>")

				// inject the contents of the document in, removing the scripts
				// to avoid any 'Permission Denied' errors in IE
				.append( responseText.replace( rscript, "" ) )

				// Locate the specified elements
				.find( selector ) :

			// If not, just inject the full result
			responseText );

	});

	return this;
};

// Attach a bunch of functions for handling common AJAX events
jQuery.each( "ajaxStart ajaxStop ajaxComplete ajaxError ajaxSuccess ajaxSend".split( " " ), function( i, o ){
	jQuery.fn[ o ] = function( f ){
		return this.on( o, f );
	};
});

jQuery.each( [ "get", "post" ], function( i, method ) {
	jQuery[ method ] = function( url, data, callback, type ) {
		// shift arguments if data argument was omitted
		if ( jQuery.isFunction( data ) ) {
			type = type || callback;
			callback = data;
			data = undefined;
		}

		return jQuery.ajax({
			type: method,
			url: url,
			data: data,
			success: callback,
			dataType: type
		});
	};
});

jQuery.extend({

	getScript: function( url, callback ) {
		return jQuery.get( url, undefined, callback, "script" );
	},

	getJSON: function( url, data, callback ) {
		return jQuery.get( url, data, callback, "json" );
	},

	// Creates a full fledged settings object into target
	// with both ajaxSettings and settings fields.
	// If target is omitted, writes into ajaxSettings.
	ajaxSetup: function( target, settings ) {
		if ( settings ) {
			// Building a settings object
			ajaxExtend( target, jQuery.ajaxSettings );
		} else {
			// Extending ajaxSettings
			settings = target;
			target = jQuery.ajaxSettings;
		}
		ajaxExtend( target, settings );
		return target;
	},

	ajaxSettings: {
		url: ajaxLocation,
		isLocal: rlocalProtocol.test( ajaxLocParts[ 1 ] ),
		global: true,
		type: "GET",
		contentType: "application/x-www-form-urlencoded; charset=UTF-8",
		processData: true,
		async: true,
		/*
		timeout: 0,
		data: null,
		dataType: null,
		username: null,
		password: null,
		cache: null,
		throws: false,
		traditional: false,
		headers: {},
		*/

		accepts: {
			xml: "application/xml, text/xml",
			html: "text/html",
			text: "text/plain",
			json: "application/json, text/javascript",
			"*": allTypes
		},

		contents: {
			xml: /xml/,
			html: /html/,
			json: /json/
		},

		responseFields: {
			xml: "responseXML",
			text: "responseText"
		},

		// List of data converters
		// 1) key format is "source_type destination_type" (a single space in-between)
		// 2) the catchall symbol "*" can be used for source_type
		converters: {

			// Convert anything to text
			"* text": window.String,

			// Text to html (true = no transformation)
			"text html": true,

			// Evaluate text as a json expression
			"text json": jQuery.parseJSON,

			// Parse text as xml
			"text xml": jQuery.parseXML
		},

		// For options that shouldn't be deep extended:
		// you can add your own custom options here if
		// and when you create one that shouldn't be
		// deep extended (see ajaxExtend)
		flatOptions: {
			context: true,
			url: true
		}
	},

	ajaxPrefilter: addToPrefiltersOrTransports( prefilters ),
	ajaxTransport: addToPrefiltersOrTransports( transports ),

	// Main method
	ajax: function( url, options ) {

		// If url is an object, simulate pre-1.5 signature
		if ( typeof url === "object" ) {
			options = url;
			url = undefined;
		}

		// Force options to be an object
		options = options || {};

		var // ifModified key
			ifModifiedKey,
			// Response headers
			responseHeadersString,
			responseHeaders,
			// transport
			transport,
			// timeout handle
			timeoutTimer,
			// Cross-domain detection vars
			parts,
			// To know if global events are to be dispatched
			fireGlobals,
			// Loop variable
			i,
			// Create the final options object
			s = jQuery.ajaxSetup( {}, options ),
			// Callbacks context
			callbackContext = s.context || s,
			// Context for global events
			// It's the callbackContext if one was provided in the options
			// and if it's a DOM node or a jQuery collection
			globalEventContext = callbackContext !== s &&
				( callbackContext.nodeType || callbackContext instanceof jQuery ) ?
						jQuery( callbackContext ) : jQuery.event,
			// Deferreds
			deferred = jQuery.Deferred(),
			completeDeferred = jQuery.Callbacks( "once memory" ),
			// Status-dependent callbacks
			statusCode = s.statusCode || {},
			// Headers (they are sent all at once)
			requestHeaders = {},
			requestHeadersNames = {},
			// The jqXHR state
			state = 0,
			// Default abort message
			strAbort = "canceled",
			// Fake xhr
			jqXHR = {

				readyState: 0,

				// Caches the header
				setRequestHeader: function( name, value ) {
					if ( !state ) {
						var lname = name.toLowerCase();
						name = requestHeadersNames[ lname ] = requestHeadersNames[ lname ] || name;
						requestHeaders[ name ] = value;
					}
					return this;
				},

				// Raw string
				getAllResponseHeaders: function() {
					return state === 2 ? responseHeadersString : null;
				},

				// Builds headers hashtable if needed
				getResponseHeader: function( key ) {
					var match;
					if ( state === 2 ) {
						if ( !responseHeaders ) {
							responseHeaders = {};
							while( ( match = rheaders.exec( responseHeadersString ) ) ) {
								responseHeaders[ match[1].toLowerCase() ] = match[ 2 ];
							}
						}
						match = responseHeaders[ key.toLowerCase() ];
					}
					return match === undefined ? null : match;
				},

				// Overrides response content-type header
				overrideMimeType: function( type ) {
					if ( !state ) {
						s.mimeType = type;
					}
					return this;
				},

				// Cancel the request
				abort: function( statusText ) {
					statusText = statusText || strAbort;
					if ( transport ) {
						transport.abort( statusText );
					}
					done( 0, statusText );
					return this;
				}
			};

		// Callback for when everything is done
		// It is defined here because jslint complains if it is declared
		// at the end of the function (which would be more logical and readable)
		function done( status, nativeStatusText, responses, headers ) {
			var isSuccess, success, error, response, modified,
				statusText = nativeStatusText;

			// Called once
			if ( state === 2 ) {
				return;
			}

			// State is "done" now
			state = 2;

			// Clear timeout if it exists
			if ( timeoutTimer ) {
				clearTimeout( timeoutTimer );
			}

			// Dereference transport for early garbage collection
			// (no matter how long the jqXHR object will be used)
			transport = undefined;

			// Cache response headers
			responseHeadersString = headers || "";

			// Set readyState
			jqXHR.readyState = status > 0 ? 4 : 0;

			// Get response data
			if ( responses ) {
				response = ajaxHandleResponses( s, jqXHR, responses );
			}

			// If successful, handle type chaining
			if ( status >= 200 && status < 300 || status === 304 ) {

				// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
				if ( s.ifModified ) {

					modified = jqXHR.getResponseHeader("Last-Modified");
					if ( modified ) {
						jQuery.lastModified[ ifModifiedKey ] = modified;
					}
					modified = jqXHR.getResponseHeader("Etag");
					if ( modified ) {
						jQuery.etag[ ifModifiedKey ] = modified;
					}
				}

				// If not modified
				if ( status === 304 ) {

					statusText = "notmodified";
					isSuccess = true;

				// If we have data
				} else {

					isSuccess = ajaxConvert( s, response );
					statusText = isSuccess.state;
					success = isSuccess.data;
					error = isSuccess.error;
					isSuccess = !error;
				}
			} else {
				// We extract error from statusText
				// then normalize statusText and status for non-aborts
				error = statusText;
				if ( !statusText || status ) {
					statusText = "error";
					if ( status < 0 ) {
						status = 0;
					}
				}
			}

			// Set data for the fake xhr object
			jqXHR.status = status;
			jqXHR.statusText = ( nativeStatusText || statusText ) + "";

			// Success/Error
			if ( isSuccess ) {
				deferred.resolveWith( callbackContext, [ success, statusText, jqXHR ] );
			} else {
				deferred.rejectWith( callbackContext, [ jqXHR, statusText, error ] );
			}

			// Status-dependent callbacks
			jqXHR.statusCode( statusCode );
			statusCode = undefined;

			if ( fireGlobals ) {
				globalEventContext.trigger( "ajax" + ( isSuccess ? "Success" : "Error" ),
						[ jqXHR, s, isSuccess ? success : error ] );
			}

			// Complete
			completeDeferred.fireWith( callbackContext, [ jqXHR, statusText ] );

			if ( fireGlobals ) {
				globalEventContext.trigger( "ajaxComplete", [ jqXHR, s ] );
				// Handle the global AJAX counter
				if ( !( --jQuery.active ) ) {
					jQuery.event.trigger( "ajaxStop" );
				}
			}
		}

		// Attach deferreds
		deferred.promise( jqXHR );
		jqXHR.success = jqXHR.done;
		jqXHR.error = jqXHR.fail;
		jqXHR.complete = completeDeferred.add;

		// Status-dependent callbacks
		jqXHR.statusCode = function( map ) {
			if ( map ) {
				var tmp;
				if ( state < 2 ) {
					for ( tmp in map ) {
						statusCode[ tmp ] = [ statusCode[tmp], map[tmp] ];
					}
				} else {
					tmp = map[ jqXHR.status ];
					jqXHR.always( tmp );
				}
			}
			return this;
		};

		// Remove hash character (#7531: and string promotion)
		// Add protocol if not provided (#5866: IE7 issue with protocol-less urls)
		// We also use the url parameter if available
		s.url = ( ( url || s.url ) + "" ).replace( rhash, "" ).replace( rprotocol, ajaxLocParts[ 1 ] + "//" );

		// Extract dataTypes list
		s.dataTypes = jQuery.trim( s.dataType || "*" ).toLowerCase().split( core_rspace );

		// A cross-domain request is in order when we have a protocol:host:port mismatch
		if ( s.crossDomain == null ) {
			parts = rurl.exec( s.url.toLowerCase() ) || false;
			s.crossDomain = parts && ( parts.join(":") + ( parts[ 3 ] ? "" : parts[ 1 ] === "http:" ? 80 : 443 ) ) !==
				( ajaxLocParts.join(":") + ( ajaxLocParts[ 3 ] ? "" : ajaxLocParts[ 1 ] === "http:" ? 80 : 443 ) );
		}

		// Convert data if not already a string
		if ( s.data && s.processData && typeof s.data !== "string" ) {
			s.data = jQuery.param( s.data, s.traditional );
		}

		// Apply prefilters
		inspectPrefiltersOrTransports( prefilters, s, options, jqXHR );

		// If request was aborted inside a prefilter, stop there
		if ( state === 2 ) {
			return jqXHR;
		}

		// We can fire global events as of now if asked to
		fireGlobals = s.global;

		// Uppercase the type
		s.type = s.type.toUpperCase();

		// Determine if request has content
		s.hasContent = !rnoContent.test( s.type );

		// Watch for a new set of requests
		if ( fireGlobals && jQuery.active++ === 0 ) {
			jQuery.event.trigger( "ajaxStart" );
		}

		// More options handling for requests with no content
		if ( !s.hasContent ) {

			// If data is available, append data to url
			if ( s.data ) {
				s.url += ( rquery.test( s.url ) ? "&" : "?" ) + s.data;
				// #9682: remove data so that it's not used in an eventual retry
				delete s.data;
			}

			// Get ifModifiedKey before adding the anti-cache parameter
			ifModifiedKey = s.url;

			// Add anti-cache in url if needed
			if ( s.cache === false ) {

				var ts = jQuery.now(),
					// try replacing _= if it is there
					ret = s.url.replace( rts, "$1_=" + ts );

				// if nothing was replaced, add timestamp to the end
				s.url = ret + ( ( ret === s.url ) ? ( rquery.test( s.url ) ? "&" : "?" ) + "_=" + ts : "" );
			}
		}

		// Set the correct header, if data is being sent
		if ( s.data && s.hasContent && s.contentType !== false || options.contentType ) {
			jqXHR.setRequestHeader( "Content-Type", s.contentType );
		}

		// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
		if ( s.ifModified ) {
			ifModifiedKey = ifModifiedKey || s.url;
			if ( jQuery.lastModified[ ifModifiedKey ] ) {
				jqXHR.setRequestHeader( "If-Modified-Since", jQuery.lastModified[ ifModifiedKey ] );
			}
			if ( jQuery.etag[ ifModifiedKey ] ) {
				jqXHR.setRequestHeader( "If-None-Match", jQuery.etag[ ifModifiedKey ] );
			}
		}

		// Set the Accepts header for the server, depending on the dataType
		jqXHR.setRequestHeader(
			"Accept",
			s.dataTypes[ 0 ] && s.accepts[ s.dataTypes[0] ] ?
				s.accepts[ s.dataTypes[0] ] + ( s.dataTypes[ 0 ] !== "*" ? ", " + allTypes + "; q=0.01" : "" ) :
				s.accepts[ "*" ]
		);

		// Check for headers option
		for ( i in s.headers ) {
			jqXHR.setRequestHeader( i, s.headers[ i ] );
		}

		// Allow custom headers/mimetypes and early abort
		if ( s.beforeSend && ( s.beforeSend.call( callbackContext, jqXHR, s ) === false || state === 2 ) ) {
				// Abort if not done already and return
				return jqXHR.abort();

		}

		// aborting is no longer a cancellation
		strAbort = "abort";

		// Install callbacks on deferreds
		for ( i in { success: 1, error: 1, complete: 1 } ) {
			jqXHR[ i ]( s[ i ] );
		}

		// Get transport
		transport = inspectPrefiltersOrTransports( transports, s, options, jqXHR );

		// If no transport, we auto-abort
		if ( !transport ) {
			done( -1, "No Transport" );
		} else {
			jqXHR.readyState = 1;
			// Send global event
			if ( fireGlobals ) {
				globalEventContext.trigger( "ajaxSend", [ jqXHR, s ] );
			}
			// Timeout
			if ( s.async && s.timeout > 0 ) {
				timeoutTimer = setTimeout( function(){
					jqXHR.abort( "timeout" );
				}, s.timeout );
			}

			try {
				state = 1;
				transport.send( requestHeaders, done );
			} catch (e) {
				// Propagate exception as error if not done
				if ( state < 2 ) {
					done( -1, e );
				// Simply rethrow otherwise
				} else {
					throw e;
				}
			}
		}

		return jqXHR;
	},

	// Counter for holding the number of active queries
	active: 0,

	// Last-Modified header cache for next request
	lastModified: {},
	etag: {}

});

/* Handles responses to an ajax request:
 * - sets all responseXXX fields accordingly
 * - finds the right dataType (mediates between content-type and expected dataType)
 * - returns the corresponding response
 */
function ajaxHandleResponses( s, jqXHR, responses ) {

	var ct, type, finalDataType, firstDataType,
		contents = s.contents,
		dataTypes = s.dataTypes,
		responseFields = s.responseFields;

	// Fill responseXXX fields
	for ( type in responseFields ) {
		if ( type in responses ) {
			jqXHR[ responseFields[type] ] = responses[ type ];
		}
	}

	// Remove auto dataType and get content-type in the process
	while( dataTypes[ 0 ] === "*" ) {
		dataTypes.shift();
		if ( ct === undefined ) {
			ct = s.mimeType || jqXHR.getResponseHeader( "content-type" );
		}
	}

	// Check if we're dealing with a known content-type
	if ( ct ) {
		for ( type in contents ) {
			if ( contents[ type ] && contents[ type ].test( ct ) ) {
				dataTypes.unshift( type );
				break;
			}
		}
	}

	// Check to see if we have a response for the expected dataType
	if ( dataTypes[ 0 ] in responses ) {
		finalDataType = dataTypes[ 0 ];
	} else {
		// Try convertible dataTypes
		for ( type in responses ) {
			if ( !dataTypes[ 0 ] || s.converters[ type + " " + dataTypes[0] ] ) {
				finalDataType = type;
				break;
			}
			if ( !firstDataType ) {
				firstDataType = type;
			}
		}
		// Or just use first one
		finalDataType = finalDataType || firstDataType;
	}

	// If we found a dataType
	// We add the dataType to the list if needed
	// and return the corresponding response
	if ( finalDataType ) {
		if ( finalDataType !== dataTypes[ 0 ] ) {
			dataTypes.unshift( finalDataType );
		}
		return responses[ finalDataType ];
	}
}

// Chain conversions given the request and the original response
function ajaxConvert( s, response ) {

	var conv, conv2, current, tmp,
		// Work with a copy of dataTypes in case we need to modify it for conversion
		dataTypes = s.dataTypes.slice(),
		prev = dataTypes[ 0 ],
		converters = {},
		i = 0;

	// Apply the dataFilter if provided
	if ( s.dataFilter ) {
		response = s.dataFilter( response, s.dataType );
	}

	// Create converters map with lowercased keys
	if ( dataTypes[ 1 ] ) {
		for ( conv in s.converters ) {
			converters[ conv.toLowerCase() ] = s.converters[ conv ];
		}
	}

	// Convert to each sequential dataType, tolerating list modification
	for ( ; (current = dataTypes[++i]); ) {

		// There's only work to do if current dataType is non-auto
		if ( current !== "*" ) {

			// Convert response if prev dataType is non-auto and differs from current
			if ( prev !== "*" && prev !== current ) {

				// Seek a direct converter
				conv = converters[ prev + " " + current ] || converters[ "* " + current ];

				// If none found, seek a pair
				if ( !conv ) {
					for ( conv2 in converters ) {

						// If conv2 outputs current
						tmp = conv2.split(" ");
						if ( tmp[ 1 ] === current ) {

							// If prev can be converted to accepted input
							conv = converters[ prev + " " + tmp[ 0 ] ] ||
								converters[ "* " + tmp[ 0 ] ];
							if ( conv ) {
								// Condense equivalence converters
								if ( conv === true ) {
									conv = converters[ conv2 ];

								// Otherwise, insert the intermediate dataType
								} else if ( converters[ conv2 ] !== true ) {
									current = tmp[ 0 ];
									dataTypes.splice( i--, 0, current );
								}

								break;
							}
						}
					}
				}

				// Apply converter (if not an equivalence)
				if ( conv !== true ) {

					// Unless errors are allowed to bubble, catch and return them
					if ( conv && s["throws"] ) {
						response = conv( response );
					} else {
						try {
							response = conv( response );
						} catch ( e ) {
							return { state: "parsererror", error: conv ? e : "No conversion from " + prev + " to " + current };
						}
					}
				}
			}

			// Update prev for next iteration
			prev = current;
		}
	}

	return { state: "success", data: response };
}
var oldCallbacks = [],
	rquestion = /\?/,
	rjsonp = /(=)\?(?=&|$)|\?\?/,
	nonce = jQuery.now();

// Default jsonp settings
jQuery.ajaxSetup({
	jsonp: "callback",
	jsonpCallback: function() {
		var callback = oldCallbacks.pop() || ( jQuery.expando + "_" + ( nonce++ ) );
		this[ callback ] = true;
		return callback;
	}
});

// Detect, normalize options and install callbacks for jsonp requests
jQuery.ajaxPrefilter( "json jsonp", function( s, originalSettings, jqXHR ) {

	var callbackName, overwritten, responseContainer,
		data = s.data,
		url = s.url,
		hasCallback = s.jsonp !== false,
		replaceInUrl = hasCallback && rjsonp.test( url ),
		replaceInData = hasCallback && !replaceInUrl && typeof data === "string" &&
			!( s.contentType || "" ).indexOf("application/x-www-form-urlencoded") &&
			rjsonp.test( data );

	// Handle iff the expected data type is "jsonp" or we have a parameter to set
	if ( s.dataTypes[ 0 ] === "jsonp" || replaceInUrl || replaceInData ) {

		// Get callback name, remembering preexisting value associated with it
		callbackName = s.jsonpCallback = jQuery.isFunction( s.jsonpCallback ) ?
			s.jsonpCallback() :
			s.jsonpCallback;
		overwritten = window[ callbackName ];

		// Insert callback into url or form data
		if ( replaceInUrl ) {
			s.url = url.replace( rjsonp, "$1" + callbackName );
		} else if ( replaceInData ) {
			s.data = data.replace( rjsonp, "$1" + callbackName );
		} else if ( hasCallback ) {
			s.url += ( rquestion.test( url ) ? "&" : "?" ) + s.jsonp + "=" + callbackName;
		}

		// Use data converter to retrieve json after script execution
		s.converters["script json"] = function() {
			if ( !responseContainer ) {
				jQuery.error( callbackName + " was not called" );
			}
			return responseContainer[ 0 ];
		};

		// force json dataType
		s.dataTypes[ 0 ] = "json";

		// Install callback
		window[ callbackName ] = function() {
			responseContainer = arguments;
		};

		// Clean-up function (fires after converters)
		jqXHR.always(function() {
			// Restore preexisting value
			window[ callbackName ] = overwritten;

			// Save back as free
			if ( s[ callbackName ] ) {
				// make sure that re-using the options doesn't screw things around
				s.jsonpCallback = originalSettings.jsonpCallback;

				// save the callback name for future use
				oldCallbacks.push( callbackName );
			}

			// Call if it was a function and we have a response
			if ( responseContainer && jQuery.isFunction( overwritten ) ) {
				overwritten( responseContainer[ 0 ] );
			}

			responseContainer = overwritten = undefined;
		});

		// Delegate to script
		return "script";
	}
});
// Install script dataType
jQuery.ajaxSetup({
	accepts: {
		script: "text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"
	},
	contents: {
		script: /javascript|ecmascript/
	},
	converters: {
		"text script": function( text ) {
			jQuery.globalEval( text );
			return text;
		}
	}
});

// Handle cache's special case and global
jQuery.ajaxPrefilter( "script", function( s ) {
	if ( s.cache === undefined ) {
		s.cache = false;
	}
	if ( s.crossDomain ) {
		s.type = "GET";
		s.global = false;
	}
});

// Bind script tag hack transport
jQuery.ajaxTransport( "script", function(s) {

	// This transport only deals with cross domain requests
	if ( s.crossDomain ) {

		var script,
			head = document.head || document.getElementsByTagName( "head" )[0] || document.documentElement;

		return {

			send: function( _, callback ) {

				script = document.createElement( "script" );

				script.async = "async";

				if ( s.scriptCharset ) {
					script.charset = s.scriptCharset;
				}

				script.src = s.url;

				// Attach handlers for all browsers
				script.onload = script.onreadystatechange = function( _, isAbort ) {

					if ( isAbort || !script.readyState || /loaded|complete/.test( script.readyState ) ) {

						// Handle memory leak in IE
						script.onload = script.onreadystatechange = null;

						// Remove the script
						if ( head && script.parentNode ) {
							head.removeChild( script );
						}

						// Dereference the script
						script = undefined;

						// Callback if not abort
						if ( !isAbort ) {
							callback( 200, "success" );
						}
					}
				};
				// Use insertBefore instead of appendChild  to circumvent an IE6 bug.
				// This arises when a base node is used (#2709 and #4378).
				head.insertBefore( script, head.firstChild );
			},

			abort: function() {
				if ( script ) {
					script.onload( 0, 1 );
				}
			}
		};
	}
});
var xhrCallbacks,
	// #5280: Internet Explorer will keep connections alive if we don't abort on unload
	xhrOnUnloadAbort = window.ActiveXObject ? function() {
		// Abort all pending requests
		for ( var key in xhrCallbacks ) {
			xhrCallbacks[ key ]( 0, 1 );
		}
	} : false,
	xhrId = 0;

// Functions to create xhrs
function createStandardXHR() {
	try {
		return new window.XMLHttpRequest();
	} catch( e ) {}
}

function createActiveXHR() {
	try {
		return new window.ActiveXObject( "Microsoft.XMLHTTP" );
	} catch( e ) {}
}

// Create the request object
// (This is still attached to ajaxSettings for backward compatibility)
jQuery.ajaxSettings.xhr = window.ActiveXObject ?
	/* Microsoft failed to properly
	 * implement the XMLHttpRequest in IE7 (can't request local files),
	 * so we use the ActiveXObject when it is available
	 * Additionally XMLHttpRequest can be disabled in IE7/IE8 so
	 * we need a fallback.
	 */
	function() {
		return !this.isLocal && createStandardXHR() || createActiveXHR();
	} :
	// For all other browsers, use the standard XMLHttpRequest object
	createStandardXHR;

// Determine support properties
(function( xhr ) {
	jQuery.extend( jQuery.support, {
		ajax: !!xhr,
		cors: !!xhr && ( "withCredentials" in xhr )
	});
})( jQuery.ajaxSettings.xhr() );

// Create transport if the browser can provide an xhr
if ( jQuery.support.ajax ) {

	jQuery.ajaxTransport(function( s ) {
		// Cross domain only allowed if supported through XMLHttpRequest
		if ( !s.crossDomain || jQuery.support.cors ) {

			var callback;

			return {
				send: function( headers, complete ) {

					// Get a new xhr
					var handle, i,
						xhr = s.xhr();

					// Open the socket
					// Passing null username, generates a login popup on Opera (#2865)
					if ( s.username ) {
						xhr.open( s.type, s.url, s.async, s.username, s.password );
					} else {
						xhr.open( s.type, s.url, s.async );
					}

					// Apply custom fields if provided
					if ( s.xhrFields ) {
						for ( i in s.xhrFields ) {
							xhr[ i ] = s.xhrFields[ i ];
						}
					}

					// Override mime type if needed
					if ( s.mimeType && xhr.overrideMimeType ) {
						xhr.overrideMimeType( s.mimeType );
					}

					// X-Requested-With header
					// For cross-domain requests, seeing as conditions for a preflight are
					// akin to a jigsaw puzzle, we simply never set it to be sure.
					// (it can always be set on a per-request basis or even using ajaxSetup)
					// For same-domain requests, won't change header if already provided.
					if ( !s.crossDomain && !headers["X-Requested-With"] ) {
						headers[ "X-Requested-With" ] = "XMLHttpRequest";
					}

					// Need an extra try/catch for cross domain requests in Firefox 3
					try {
						for ( i in headers ) {
							xhr.setRequestHeader( i, headers[ i ] );
						}
					} catch( _ ) {}

					// Do send the request
					// This may raise an exception which is actually
					// handled in jQuery.ajax (so no try/catch here)
					xhr.send( ( s.hasContent && s.data ) || null );

					// Listener
					callback = function( _, isAbort ) {

						var status,
							statusText,
							responseHeaders,
							responses,
							xml;

						// Firefox throws exceptions when accessing properties
						// of an xhr when a network error occurred
						// http://helpful.knobs-dials.com/index.php/Component_returned_failure_code:_0x80040111_(NS_ERROR_NOT_AVAILABLE)
						try {

							// Was never called and is aborted or complete
							if ( callback && ( isAbort || xhr.readyState === 4 ) ) {

								// Only called once
								callback = undefined;

								// Do not keep as active anymore
								if ( handle ) {
									xhr.onreadystatechange = jQuery.noop;
									if ( xhrOnUnloadAbort ) {
										delete xhrCallbacks[ handle ];
									}
								}

								// If it's an abort
								if ( isAbort ) {
									// Abort it manually if needed
									if ( xhr.readyState !== 4 ) {
										xhr.abort();
									}
								} else {
									status = xhr.status;
									responseHeaders = xhr.getAllResponseHeaders();
									responses = {};
									xml = xhr.responseXML;

									// Construct response list
									if ( xml && xml.documentElement /* #4958 */ ) {
										responses.xml = xml;
									}

									// When requesting binary data, IE6-9 will throw an exception
									// on any attempt to access responseText (#11426)
									try {
										responses.text = xhr.responseText;
									} catch( _ ) {
									}

									// Firefox throws an exception when accessing
									// statusText for faulty cross-domain requests
									try {
										statusText = xhr.statusText;
									} catch( e ) {
										// We normalize with Webkit giving an empty statusText
										statusText = "";
									}

									// Filter status for non standard behaviors

									// If the request is local and we have data: assume a success
									// (success with no data won't get notified, that's the best we
									// can do given current implementations)
									if ( !status && s.isLocal && !s.crossDomain ) {
										status = responses.text ? 200 : 404;
									// IE - #1450: sometimes returns 1223 when it should be 204
									} else if ( status === 1223 ) {
										status = 204;
									}
								}
							}
						} catch( firefoxAccessException ) {
							if ( !isAbort ) {
								complete( -1, firefoxAccessException );
							}
						}

						// Call complete if needed
						if ( responses ) {
							complete( status, statusText, responses, responseHeaders );
						}
					};

					if ( !s.async ) {
						// if we're in sync mode we fire the callback
						callback();
					} else if ( xhr.readyState === 4 ) {
						// (IE6 & IE7) if it's in cache and has been
						// retrieved directly we need to fire the callback
						setTimeout( callback, 0 );
					} else {
						handle = ++xhrId;
						if ( xhrOnUnloadAbort ) {
							// Create the active xhrs callbacks list if needed
							// and attach the unload handler
							if ( !xhrCallbacks ) {
								xhrCallbacks = {};
								jQuery( window ).unload( xhrOnUnloadAbort );
							}
							// Add to list of active xhrs callbacks
							xhrCallbacks[ handle ] = callback;
						}
						xhr.onreadystatechange = callback;
					}
				},

				abort: function() {
					if ( callback ) {
						callback(0,1);
					}
				}
			};
		}
	});
}
var fxNow, timerId,
	rfxtypes = /^(?:toggle|show|hide)$/,
	rfxnum = new RegExp( "^(?:([-+])=|)(" + core_pnum + ")([a-z%]*)$", "i" ),
	rrun = /queueHooks$/,
	animationPrefilters = [ defaultPrefilter ],
	tweeners = {
		"*": [function( prop, value ) {
			var end, unit,
				tween = this.createTween( prop, value ),
				parts = rfxnum.exec( value ),
				target = tween.cur(),
				start = +target || 0,
				scale = 1,
				maxIterations = 20;

			if ( parts ) {
				end = +parts[2];
				unit = parts[3] || ( jQuery.cssNumber[ prop ] ? "" : "px" );

				// We need to compute starting value
				if ( unit !== "px" && start ) {
					// Iteratively approximate from a nonzero starting point
					// Prefer the current property, because this process will be trivial if it uses the same units
					// Fallback to end or a simple constant
					start = jQuery.css( tween.elem, prop, true ) || end || 1;

					do {
						// If previous iteration zeroed out, double until we get *something*
						// Use a string for doubling factor so we don't accidentally see scale as unchanged below
						scale = scale || ".5";

						// Adjust and apply
						start = start / scale;
						jQuery.style( tween.elem, prop, start + unit );

					// Update scale, tolerating zero or NaN from tween.cur()
					// And breaking the loop if scale is unchanged or perfect, or if we've just had enough
					} while ( scale !== (scale = tween.cur() / target) && scale !== 1 && --maxIterations );
				}

				tween.unit = unit;
				tween.start = start;
				// If a +=/-= token was provided, we're doing a relative animation
				tween.end = parts[1] ? start + ( parts[1] + 1 ) * end : end;
			}
			return tween;
		}]
	};

// Animations created synchronously will run synchronously
function createFxNow() {
	setTimeout(function() {
		fxNow = undefined;
	}, 0 );
	return ( fxNow = jQuery.now() );
}

function createTweens( animation, props ) {
	jQuery.each( props, function( prop, value ) {
		var collection = ( tweeners[ prop ] || [] ).concat( tweeners[ "*" ] ),
			index = 0,
			length = collection.length;
		for ( ; index < length; index++ ) {
			if ( collection[ index ].call( animation, prop, value ) ) {

				// we're done with this property
				return;
			}
		}
	});
}

function Animation( elem, properties, options ) {
	var result,
		index = 0,
		tweenerIndex = 0,
		length = animationPrefilters.length,
		deferred = jQuery.Deferred().always( function() {
			// don't match elem in the :animated selector
			delete tick.elem;
		}),
		tick = function() {
			var currentTime = fxNow || createFxNow(),
				remaining = Math.max( 0, animation.startTime + animation.duration - currentTime ),
				percent = 1 - ( remaining / animation.duration || 0 ),
				index = 0,
				length = animation.tweens.length;

			for ( ; index < length ; index++ ) {
				animation.tweens[ index ].run( percent );
			}

			deferred.notifyWith( elem, [ animation, percent, remaining ]);

			if ( percent < 1 && length ) {
				return remaining;
			} else {
				deferred.resolveWith( elem, [ animation ] );
				return false;
			}
		},
		animation = deferred.promise({
			elem: elem,
			props: jQuery.extend( {}, properties ),
			opts: jQuery.extend( true, { specialEasing: {} }, options ),
			originalProperties: properties,
			originalOptions: options,
			startTime: fxNow || createFxNow(),
			duration: options.duration,
			tweens: [],
			createTween: function( prop, end, easing ) {
				var tween = jQuery.Tween( elem, animation.opts, prop, end,
						animation.opts.specialEasing[ prop ] || animation.opts.easing );
				animation.tweens.push( tween );
				return tween;
			},
			stop: function( gotoEnd ) {
				var index = 0,
					// if we are going to the end, we want to run all the tweens
					// otherwise we skip this part
					length = gotoEnd ? animation.tweens.length : 0;

				for ( ; index < length ; index++ ) {
					animation.tweens[ index ].run( 1 );
				}

				// resolve when we played the last frame
				// otherwise, reject
				if ( gotoEnd ) {
					deferred.resolveWith( elem, [ animation, gotoEnd ] );
				} else {
					deferred.rejectWith( elem, [ animation, gotoEnd ] );
				}
				return this;
			}
		}),
		props = animation.props;

	propFilter( props, animation.opts.specialEasing );

	for ( ; index < length ; index++ ) {
		result = animationPrefilters[ index ].call( animation, elem, props, animation.opts );
		if ( result ) {
			return result;
		}
	}

	createTweens( animation, props );

	if ( jQuery.isFunction( animation.opts.start ) ) {
		animation.opts.start.call( elem, animation );
	}

	jQuery.fx.timer(
		jQuery.extend( tick, {
			anim: animation,
			queue: animation.opts.queue,
			elem: elem
		})
	);

	// attach callbacks from options
	return animation.progress( animation.opts.progress )
		.done( animation.opts.done, animation.opts.complete )
		.fail( animation.opts.fail )
		.always( animation.opts.always );
}

function propFilter( props, specialEasing ) {
	var index, name, easing, value, hooks;

	// camelCase, specialEasing and expand cssHook pass
	for ( index in props ) {
		name = jQuery.camelCase( index );
		easing = specialEasing[ name ];
		value = props[ index ];
		if ( jQuery.isArray( value ) ) {
			easing = value[ 1 ];
			value = props[ index ] = value[ 0 ];
		}

		if ( index !== name ) {
			props[ name ] = value;
			delete props[ index ];
		}

		hooks = jQuery.cssHooks[ name ];
		if ( hooks && "expand" in hooks ) {
			value = hooks.expand( value );
			delete props[ name ];

			// not quite $.extend, this wont overwrite keys already present.
			// also - reusing 'index' from above because we have the correct "name"
			for ( index in value ) {
				if ( !( index in props ) ) {
					props[ index ] = value[ index ];
					specialEasing[ index ] = easing;
				}
			}
		} else {
			specialEasing[ name ] = easing;
		}
	}
}

jQuery.Animation = jQuery.extend( Animation, {

	tweener: function( props, callback ) {
		if ( jQuery.isFunction( props ) ) {
			callback = props;
			props = [ "*" ];
		} else {
			props = props.split(" ");
		}

		var prop,
			index = 0,
			length = props.length;

		for ( ; index < length ; index++ ) {
			prop = props[ index ];
			tweeners[ prop ] = tweeners[ prop ] || [];
			tweeners[ prop ].unshift( callback );
		}
	},

	prefilter: function( callback, prepend ) {
		if ( prepend ) {
			animationPrefilters.unshift( callback );
		} else {
			animationPrefilters.push( callback );
		}
	}
});

function defaultPrefilter( elem, props, opts ) {
	var index, prop, value, length, dataShow, tween, hooks, oldfire,
		anim = this,
		style = elem.style,
		orig = {},
		handled = [],
		hidden = elem.nodeType && isHidden( elem );

	// handle queue: false promises
	if ( !opts.queue ) {
		hooks = jQuery._queueHooks( elem, "fx" );
		if ( hooks.unqueued == null ) {
			hooks.unqueued = 0;
			oldfire = hooks.empty.fire;
			hooks.empty.fire = function() {
				if ( !hooks.unqueued ) {
					oldfire();
				}
			};
		}
		hooks.unqueued++;

		anim.always(function() {
			// doing this makes sure that the complete handler will be called
			// before this completes
			anim.always(function() {
				hooks.unqueued--;
				if ( !jQuery.queue( elem, "fx" ).length ) {
					hooks.empty.fire();
				}
			});
		});
	}

	// height/width overflow pass
	if ( elem.nodeType === 1 && ( "height" in props || "width" in props ) ) {
		// Make sure that nothing sneaks out
		// Record all 3 overflow attributes because IE does not
		// change the overflow attribute when overflowX and
		// overflowY are set to the same value
		opts.overflow = [ style.overflow, style.overflowX, style.overflowY ];

		// Set display property to inline-block for height/width
		// animations on inline elements that are having width/height animated
		if ( jQuery.css( elem, "display" ) === "inline" &&
				jQuery.css( elem, "float" ) === "none" ) {

			// inline-level elements accept inline-block;
			// block-level elements need to be inline with layout
			if ( !jQuery.support.inlineBlockNeedsLayout || css_defaultDisplay( elem.nodeName ) === "inline" ) {
				style.display = "inline-block";

			} else {
				style.zoom = 1;
			}
		}
	}

	if ( opts.overflow ) {
		style.overflow = "hidden";
		if ( !jQuery.support.shrinkWrapBlocks ) {
			anim.done(function() {
				style.overflow = opts.overflow[ 0 ];
				style.overflowX = opts.overflow[ 1 ];
				style.overflowY = opts.overflow[ 2 ];
			});
		}
	}


	// show/hide pass
	for ( index in props ) {
		value = props[ index ];
		if ( rfxtypes.exec( value ) ) {
			delete props[ index ];
			if ( value === ( hidden ? "hide" : "show" ) ) {
				continue;
			}
			handled.push( index );
		}
	}

	length = handled.length;
	if ( length ) {
		dataShow = jQuery._data( elem, "fxshow" ) || jQuery._data( elem, "fxshow", {} );
		if ( hidden ) {
			jQuery( elem ).show();
		} else {
			anim.done(function() {
				jQuery( elem ).hide();
			});
		}
		anim.done(function() {
			var prop;
			jQuery.removeData( elem, "fxshow", true );
			for ( prop in orig ) {
				jQuery.style( elem, prop, orig[ prop ] );
			}
		});
		for ( index = 0 ; index < length ; index++ ) {
			prop = handled[ index ];
			tween = anim.createTween( prop, hidden ? dataShow[ prop ] : 0 );
			orig[ prop ] = dataShow[ prop ] || jQuery.style( elem, prop );

			if ( !( prop in dataShow ) ) {
				dataShow[ prop ] = tween.start;
				if ( hidden ) {
					tween.end = tween.start;
					tween.start = prop === "width" || prop === "height" ? 1 : 0;
				}
			}
		}
	}
}

function Tween( elem, options, prop, end, easing ) {
	return new Tween.prototype.init( elem, options, prop, end, easing );
}
jQuery.Tween = Tween;

Tween.prototype = {
	constructor: Tween,
	init: function( elem, options, prop, end, easing, unit ) {
		this.elem = elem;
		this.prop = prop;
		this.easing = easing || "swing";
		this.options = options;
		this.start = this.now = this.cur();
		this.end = end;
		this.unit = unit || ( jQuery.cssNumber[ prop ] ? "" : "px" );
	},
	cur: function() {
		var hooks = Tween.propHooks[ this.prop ];

		return hooks && hooks.get ?
			hooks.get( this ) :
			Tween.propHooks._default.get( this );
	},
	run: function( percent ) {
		var eased,
			hooks = Tween.propHooks[ this.prop ];

		if ( this.options.duration ) {
			this.pos = eased = jQuery.easing[ this.easing ](
				percent, this.options.duration * percent, 0, 1, this.options.duration
			);
		} else {
			this.pos = eased = percent;
		}
		this.now = ( this.end - this.start ) * eased + this.start;

		if ( this.options.step ) {
			this.options.step.call( this.elem, this.now, this );
		}

		if ( hooks && hooks.set ) {
			hooks.set( this );
		} else {
			Tween.propHooks._default.set( this );
		}
		return this;
	}
};

Tween.prototype.init.prototype = Tween.prototype;

Tween.propHooks = {
	_default: {
		get: function( tween ) {
			var result;

			if ( tween.elem[ tween.prop ] != null &&
				(!tween.elem.style || tween.elem.style[ tween.prop ] == null) ) {
				return tween.elem[ tween.prop ];
			}

			// passing any value as a 4th parameter to .css will automatically
			// attempt a parseFloat and fallback to a string if the parse fails
			// so, simple values such as "10px" are parsed to Float.
			// complex values such as "rotate(1rad)" are returned as is.
			result = jQuery.css( tween.elem, tween.prop, false, "" );
			// Empty strings, null, undefined and "auto" are converted to 0.
			return !result || result === "auto" ? 0 : result;
		},
		set: function( tween ) {
			// use step hook for back compat - use cssHook if its there - use .style if its
			// available and use plain properties where available
			if ( jQuery.fx.step[ tween.prop ] ) {
				jQuery.fx.step[ tween.prop ]( tween );
			} else if ( tween.elem.style && ( tween.elem.style[ jQuery.cssProps[ tween.prop ] ] != null || jQuery.cssHooks[ tween.prop ] ) ) {
				jQuery.style( tween.elem, tween.prop, tween.now + tween.unit );
			} else {
				tween.elem[ tween.prop ] = tween.now;
			}
		}
	}
};

// Remove in 2.0 - this supports IE8's panic based approach
// to setting things on disconnected nodes

Tween.propHooks.scrollTop = Tween.propHooks.scrollLeft = {
	set: function( tween ) {
		if ( tween.elem.nodeType && tween.elem.parentNode ) {
			tween.elem[ tween.prop ] = tween.now;
		}
	}
};

jQuery.each([ "toggle", "show", "hide" ], function( i, name ) {
	var cssFn = jQuery.fn[ name ];
	jQuery.fn[ name ] = function( speed, easing, callback ) {
		return speed == null || typeof speed === "boolean" ||
			// special check for .toggle( handler, handler, ... )
			( !i && jQuery.isFunction( speed ) && jQuery.isFunction( easing ) ) ?
			cssFn.apply( this, arguments ) :
			this.animate( genFx( name, true ), speed, easing, callback );
	};
});

jQuery.fn.extend({
	fadeTo: function( speed, to, easing, callback ) {

		// show any hidden elements after setting opacity to 0
		return this.filter( isHidden ).css( "opacity", 0 ).show()

			// animate to the value specified
			.end().animate({ opacity: to }, speed, easing, callback );
	},
	animate: function( prop, speed, easing, callback ) {
		var empty = jQuery.isEmptyObject( prop ),
			optall = jQuery.speed( speed, easing, callback ),
			doAnimation = function() {
				// Operate on a copy of prop so per-property easing won't be lost
				var anim = Animation( this, jQuery.extend( {}, prop ), optall );

				// Empty animations resolve immediately
				if ( empty ) {
					anim.stop( true );
				}
			};

		return empty || optall.queue === false ?
			this.each( doAnimation ) :
			this.queue( optall.queue, doAnimation );
	},
	stop: function( type, clearQueue, gotoEnd ) {
		var stopQueue = function( hooks ) {
			var stop = hooks.stop;
			delete hooks.stop;
			stop( gotoEnd );
		};

		if ( typeof type !== "string" ) {
			gotoEnd = clearQueue;
			clearQueue = type;
			type = undefined;
		}
		if ( clearQueue && type !== false ) {
			this.queue( type || "fx", [] );
		}

		return this.each(function() {
			var dequeue = true,
				index = type != null && type + "queueHooks",
				timers = jQuery.timers,
				data = jQuery._data( this );

			if ( index ) {
				if ( data[ index ] && data[ index ].stop ) {
					stopQueue( data[ index ] );
				}
			} else {
				for ( index in data ) {
					if ( data[ index ] && data[ index ].stop && rrun.test( index ) ) {
						stopQueue( data[ index ] );
					}
				}
			}

			for ( index = timers.length; index--; ) {
				if ( timers[ index ].elem === this && (type == null || timers[ index ].queue === type) ) {
					timers[ index ].anim.stop( gotoEnd );
					dequeue = false;
					timers.splice( index, 1 );
				}
			}

			// start the next in the queue if the last step wasn't forced
			// timers currently will call their complete callbacks, which will dequeue
			// but only if they were gotoEnd
			if ( dequeue || !gotoEnd ) {
				jQuery.dequeue( this, type );
			}
		});
	}
});

// Generate parameters to create a standard animation
function genFx( type, includeWidth ) {
	var which,
		attrs = { height: type },
		i = 0;

	// if we include width, step value is 1 to do all cssExpand values,
	// if we don't include width, step value is 2 to skip over Left and Right
	includeWidth = includeWidth? 1 : 0;
	for( ; i < 4 ; i += 2 - includeWidth ) {
		which = cssExpand[ i ];
		attrs[ "margin" + which ] = attrs[ "padding" + which ] = type;
	}

	if ( includeWidth ) {
		attrs.opacity = attrs.width = type;
	}

	return attrs;
}

// Generate shortcuts for custom animations
jQuery.each({
	slideDown: genFx("show"),
	slideUp: genFx("hide"),
	slideToggle: genFx("toggle"),
	fadeIn: { opacity: "show" },
	fadeOut: { opacity: "hide" },
	fadeToggle: { opacity: "toggle" }
}, function( name, props ) {
	jQuery.fn[ name ] = function( speed, easing, callback ) {
		return this.animate( props, speed, easing, callback );
	};
});

jQuery.speed = function( speed, easing, fn ) {
	var opt = speed && typeof speed === "object" ? jQuery.extend( {}, speed ) : {
		complete: fn || !fn && easing ||
			jQuery.isFunction( speed ) && speed,
		duration: speed,
		easing: fn && easing || easing && !jQuery.isFunction( easing ) && easing
	};

	opt.duration = jQuery.fx.off ? 0 : typeof opt.duration === "number" ? opt.duration :
		opt.duration in jQuery.fx.speeds ? jQuery.fx.speeds[ opt.duration ] : jQuery.fx.speeds._default;

	// normalize opt.queue - true/undefined/null -> "fx"
	if ( opt.queue == null || opt.queue === true ) {
		opt.queue = "fx";
	}

	// Queueing
	opt.old = opt.complete;

	opt.complete = function() {
		if ( jQuery.isFunction( opt.old ) ) {
			opt.old.call( this );
		}

		if ( opt.queue ) {
			jQuery.dequeue( this, opt.queue );
		}
	};

	return opt;
};

jQuery.easing = {
	linear: function( p ) {
		return p;
	},
	swing: function( p ) {
		return 0.5 - Math.cos( p*Math.PI ) / 2;
	}
};

jQuery.timers = [];
jQuery.fx = Tween.prototype.init;
jQuery.fx.tick = function() {
	var timer,
		timers = jQuery.timers,
		i = 0;

	for ( ; i < timers.length; i++ ) {
		timer = timers[ i ];
		// Checks the timer has not already been removed
		if ( !timer() && timers[ i ] === timer ) {
			timers.splice( i--, 1 );
		}
	}

	if ( !timers.length ) {
		jQuery.fx.stop();
	}
};

jQuery.fx.timer = function( timer ) {
	if ( timer() && jQuery.timers.push( timer ) && !timerId ) {
		timerId = setInterval( jQuery.fx.tick, jQuery.fx.interval );
	}
};

jQuery.fx.interval = 13;

jQuery.fx.stop = function() {
	clearInterval( timerId );
	timerId = null;
};

jQuery.fx.speeds = {
	slow: 600,
	fast: 200,
	// Default speed
	_default: 400
};

// Back Compat <1.8 extension point
jQuery.fx.step = {};

if ( jQuery.expr && jQuery.expr.filters ) {
	jQuery.expr.filters.animated = function( elem ) {
		return jQuery.grep(jQuery.timers, function( fn ) {
			return elem === fn.elem;
		}).length;
	};
}
var rroot = /^(?:body|html)$/i;

jQuery.fn.offset = function( options ) {
	if ( arguments.length ) {
		return options === undefined ?
			this :
			this.each(function( i ) {
				jQuery.offset.setOffset( this, options, i );
			});
	}

	var docElem, body, win, clientTop, clientLeft, scrollTop, scrollLeft,
		box = { top: 0, left: 0 },
		elem = this[ 0 ],
		doc = elem && elem.ownerDocument;

	if ( !doc ) {
		return;
	}

	if ( (body = doc.body) === elem ) {
		return jQuery.offset.bodyOffset( elem );
	}

	docElem = doc.documentElement;

	// Make sure it's not a disconnected DOM node
	if ( !jQuery.contains( docElem, elem ) ) {
		return box;
	}

	// If we don't have gBCR, just use 0,0 rather than error
	// BlackBerry 5, iOS 3 (original iPhone)
	if ( typeof elem.getBoundingClientRect !== "undefined" ) {
		box = elem.getBoundingClientRect();
	}
	win = getWindow( doc );
	clientTop  = docElem.clientTop  || body.clientTop  || 0;
	clientLeft = docElem.clientLeft || body.clientLeft || 0;
	scrollTop  = win.pageYOffset || docElem.scrollTop;
	scrollLeft = win.pageXOffset || docElem.scrollLeft;
	return {
		top: box.top  + scrollTop  - clientTop,
		left: box.left + scrollLeft - clientLeft
	};
};

jQuery.offset = {

	bodyOffset: function( body ) {
		var top = body.offsetTop,
			left = body.offsetLeft;

		if ( jQuery.support.doesNotIncludeMarginInBodyOffset ) {
			top  += parseFloat( jQuery.css(body, "marginTop") ) || 0;
			left += parseFloat( jQuery.css(body, "marginLeft") ) || 0;
		}

		return { top: top, left: left };
	},

	setOffset: function( elem, options, i ) {
		var position = jQuery.css( elem, "position" );

		// set position first, in-case top/left are set even on static elem
		if ( position === "static" ) {
			elem.style.position = "relative";
		}

		var curElem = jQuery( elem ),
			curOffset = curElem.offset(),
			curCSSTop = jQuery.css( elem, "top" ),
			curCSSLeft = jQuery.css( elem, "left" ),
			calculatePosition = ( position === "absolute" || position === "fixed" ) && jQuery.inArray("auto", [curCSSTop, curCSSLeft]) > -1,
			props = {}, curPosition = {}, curTop, curLeft;

		// need to be able to calculate position if either top or left is auto and position is either absolute or fixed
		if ( calculatePosition ) {
			curPosition = curElem.position();
			curTop = curPosition.top;
			curLeft = curPosition.left;
		} else {
			curTop = parseFloat( curCSSTop ) || 0;
			curLeft = parseFloat( curCSSLeft ) || 0;
		}

		if ( jQuery.isFunction( options ) ) {
			options = options.call( elem, i, curOffset );
		}

		if ( options.top != null ) {
			props.top = ( options.top - curOffset.top ) + curTop;
		}
		if ( options.left != null ) {
			props.left = ( options.left - curOffset.left ) + curLeft;
		}

		if ( "using" in options ) {
			options.using.call( elem, props );
		} else {
			curElem.css( props );
		}
	}
};


jQuery.fn.extend({

	position: function() {
		if ( !this[0] ) {
			return;
		}

		var elem = this[0],

		// Get *real* offsetParent
		offsetParent = this.offsetParent(),

		// Get correct offsets
		offset       = this.offset(),
		parentOffset = rroot.test(offsetParent[0].nodeName) ? { top: 0, left: 0 } : offsetParent.offset();

		// Subtract element margins
		// note: when an element has margin: auto the offsetLeft and marginLeft
		// are the same in Safari causing offset.left to incorrectly be 0
		offset.top  -= parseFloat( jQuery.css(elem, "marginTop") ) || 0;
		offset.left -= parseFloat( jQuery.css(elem, "marginLeft") ) || 0;

		// Add offsetParent borders
		parentOffset.top  += parseFloat( jQuery.css(offsetParent[0], "borderTopWidth") ) || 0;
		parentOffset.left += parseFloat( jQuery.css(offsetParent[0], "borderLeftWidth") ) || 0;

		// Subtract the two offsets
		return {
			top:  offset.top  - parentOffset.top,
			left: offset.left - parentOffset.left
		};
	},

	offsetParent: function() {
		return this.map(function() {
			var offsetParent = this.offsetParent || document.body;
			while ( offsetParent && (!rroot.test(offsetParent.nodeName) && jQuery.css(offsetParent, "position") === "static") ) {
				offsetParent = offsetParent.offsetParent;
			}
			return offsetParent || document.body;
		});
	}
});


// Create scrollLeft and scrollTop methods
jQuery.each( {scrollLeft: "pageXOffset", scrollTop: "pageYOffset"}, function( method, prop ) {
	var top = /Y/.test( prop );

	jQuery.fn[ method ] = function( val ) {
		return jQuery.access( this, function( elem, method, val ) {
			var win = getWindow( elem );

			if ( val === undefined ) {
				return win ? (prop in win) ? win[ prop ] :
					win.document.documentElement[ method ] :
					elem[ method ];
			}

			if ( win ) {
				win.scrollTo(
					!top ? val : jQuery( win ).scrollLeft(),
					 top ? val : jQuery( win ).scrollTop()
				);

			} else {
				elem[ method ] = val;
			}
		}, method, val, arguments.length, null );
	};
});

function getWindow( elem ) {
	return jQuery.isWindow( elem ) ?
		elem :
		elem.nodeType === 9 ?
			elem.defaultView || elem.parentWindow :
			false;
}
// Create innerHeight, innerWidth, height, width, outerHeight and outerWidth methods
jQuery.each( { Height: "height", Width: "width" }, function( name, type ) {
	jQuery.each( { padding: "inner" + name, content: type, "": "outer" + name }, function( defaultExtra, funcName ) {
		// margin is only for outerHeight, outerWidth
		jQuery.fn[ funcName ] = function( margin, value ) {
			var chainable = arguments.length && ( defaultExtra || typeof margin !== "boolean" ),
				extra = defaultExtra || ( margin === true || value === true ? "margin" : "border" );

			return jQuery.access( this, function( elem, type, value ) {
				var doc;

				if ( jQuery.isWindow( elem ) ) {
					// As of 5/8/2012 this will yield incorrect results for Mobile Safari, but there
					// isn't a whole lot we can do. See pull request at this URL for discussion:
					// https://github.com/jquery/jquery/pull/764
					return elem.document.documentElement[ "client" + name ];
				}

				// Get document width or height
				if ( elem.nodeType === 9 ) {
					doc = elem.documentElement;

					// Either scroll[Width/Height] or offset[Width/Height] or client[Width/Height], whichever is greatest
					// unfortunately, this causes bug #3838 in IE6/8 only, but there is currently no good, small way to fix it.
					return Math.max(
						elem.body[ "scroll" + name ], doc[ "scroll" + name ],
						elem.body[ "offset" + name ], doc[ "offset" + name ],
						doc[ "client" + name ]
					);
				}

				return value === undefined ?
					// Get width or height on the element, requesting but not forcing parseFloat
					jQuery.css( elem, type, value, extra ) :

					// Set width or height on the element
					jQuery.style( elem, type, value, extra );
			}, type, chainable ? margin : undefined, chainable, null );
		};
	});
});
// Expose jQuery to the global object
window.jQuery = window.$ = jQuery;

// Expose jQuery as an AMD module, but only for AMD loaders that
// understand the issues with loading multiple versions of jQuery
// in a page that all might call define(). The loader will indicate
// they have special allowances for multiple jQuery versions by
// specifying define.amd.jQuery = true. Register as a named module,
// since jQuery can be concatenated with other files that may use define,
// but not use a proper concatenation script that understands anonymous
// AMD modules. A named AMD is safest and most robust way to register.
// Lowercase jquery is used because AMD module names are derived from
// file names, and jQuery is normally delivered in a lowercase file name.
// Do this after creating the global so that if an AMD module wants to call
// noConflict to hide this version of jQuery, it will work.
if ( typeof define === "function" && define.amd && define.amd.jQuery ) {
	define( "jquery", [], function () { return jQuery; } );
}

})( window );
if(!window['googleLT_']){window['googleLT_']=(new Date()).getTime();}if (!window['google']) {
window['google'] = {};
}
if (!window['google']['loader']) {
window['google']['loader'] = {};
google.loader.ServiceBase = 'http://www.google.com/uds';
google.loader.GoogleApisBase = 'http://ajax.googleapis.com/ajax';
google.loader.ApiKey = 'notsupplied';
google.loader.KeyVerified = true;
google.loader.LoadFailure = false;
google.loader.Secure = false;
google.loader.GoogleLocale = 'www.google.com';
google.loader.ClientLocation = null;
google.loader.AdditionalParams = '';
(function() {var d=encodeURIComponent,g=window,h=document;function l(a,b){return a.load=b}var m="replace",n="charAt",q="getTime",r="setTimeout",u="push",v="indexOf",w="ServiceBase",x="name",y="length",z="prototype",A="loader",B="substring",C="join",D="toLowerCase";function E(a){return a in F?F[a]:F[a]=-1!=navigator.userAgent[D]()[v](a)}var F={};function G(a,b){var c=function(){};c.prototype=b[z];a.U=b[z];a.prototype=new c}
function H(a,b,c){var e=Array[z].slice.call(arguments,2)||[];return function(){return a.apply(b,e.concat(Array[z].slice.call(arguments)))}}function I(a){a=Error(a);a.toString=function(){return this.message};return a}function J(a,b){for(var c=a.split(/\./),e=g,f=0;f<c[y]-1;f++)e[c[f]]||(e[c[f]]={}),e=e[c[f]];e[c[c[y]-1]]=b}function K(a,b,c){a[b]=c}if(!L)var L=J;if(!M)var M=K;google[A].t={};L("google.loader.callbacks",google[A].t);var N={},O={};google[A].eval={};L("google.loader.eval",google[A].eval);
l(google,function(a,b,c){function e(a){var b=a.split(".");if(2<b[y])throw I("Module: '"+a+"' not found!");"undefined"!=typeof b[1]&&(f=b[0],c.packages=c.packages||[],c.packages[u](b[1]))}var f=a;c=c||{};if(a instanceof Array||a&&"object"==typeof a&&"function"==typeof a[C]&&"function"==typeof a.reverse)for(var k=0;k<a[y];k++)e(a[k]);else e(a);if(a=N[":"+f]){c&&!c.language&&c.locale&&(c.language=c.locale);c&&"string"==typeof c.callback&&(k=c.callback,k.match(/^[[\]A-Za-z0-9._]+$/)&&(k=g.eval(k),c.callback=
k));if((k=c&&null!=c.callback)&&!a.s(b))throw I("Module: '"+f+"' must be loaded before DOM onLoad!");k?a.m(b,c)?g[r](c.callback,0):a.load(b,c):a.m(b,c)||a.load(b,c)}else throw I("Module: '"+f+"' not found!");});L("google.load",google.load);
google.T=function(a,b){b?(0==P[y]&&(Q(g,"load",R),!E("msie")&&!E("safari")&&!E("konqueror")&&E("mozilla")||g.opera?g.addEventListener("DOMContentLoaded",R,!1):E("msie")?h.write("<script defer onreadystatechange='google.loader.domReady()' src=//:>\x3c/script>"):(E("safari")||E("konqueror"))&&g[r](aa,10)),P[u](a)):Q(g,"load",a)};L("google.setOnLoadCallback",google.T);
function Q(a,b,c){if(a.addEventListener)a.addEventListener(b,c,!1);else if(a.attachEvent)a.attachEvent("on"+b,c);else{var e=a["on"+b];a["on"+b]=null!=e?ba([c,e]):c}}function ba(a){return function(){for(var b=0;b<a[y];b++)a[b]()}}var P=[];google[A].N=function(){var a=g.event.srcElement;"complete"==a.readyState&&(a.onreadystatechange=null,a.parentNode.removeChild(a),R())};L("google.loader.domReady",google[A].N);var ca={loaded:!0,complete:!0};function aa(){ca[h.readyState]?R():0<P[y]&&g[r](aa,10)}
function R(){for(var a=0;a<P[y];a++)P[a]();P.length=0}google[A].d=function(a,b,c){if(c){var e;"script"==a?(e=h.createElement("script"),e.type="text/javascript",e.src=b):"css"==a&&(e=h.createElement("link"),e.type="text/css",e.href=b,e.rel="stylesheet");(a=h.getElementsByTagName("head")[0])||(a=h.body.parentNode.appendChild(h.createElement("head")));a.appendChild(e)}else"script"==a?h.write('<script src="'+b+'" type="text/javascript">\x3c/script>'):"css"==a&&h.write('<link href="'+b+'" type="text/css" rel="stylesheet"></link>')};
L("google.loader.writeLoadTag",google[A].d);google[A].Q=function(a){O=a};L("google.loader.rfm",google[A].Q);google[A].S=function(a){for(var b in a)"string"==typeof b&&b&&":"==b[n](0)&&!N[b]&&(N[b]=new T(b[B](1),a[b]))};L("google.loader.rpl",google[A].S);google[A].R=function(a){if((a=a.specs)&&a[y])for(var b=0;b<a[y];++b){var c=a[b];"string"==typeof c?N[":"+c]=new U(c):(c=new V(c[x],c.baseSpec,c.customSpecs),N[":"+c[x]]=c)}};L("google.loader.rm",google[A].R);google[A].loaded=function(a){N[":"+a.module].k(a)};
L("google.loader.loaded",google[A].loaded);google[A].M=function(){return"qid="+((new Date)[q]().toString(16)+Math.floor(1E7*Math.random()).toString(16))};L("google.loader.createGuidArg_",google[A].M);J("google_exportSymbol",J);J("google_exportProperty",K);google[A].a={};L("google.loader.themes",google[A].a);google[A].a.B="//www.google.com/cse/style/look/bubblegum.css";M(google[A].a,"BUBBLEGUM",google[A].a.B);google[A].a.D="//www.google.com/cse/style/look/greensky.css";M(google[A].a,"GREENSKY",google[A].a.D);
google[A].a.C="//www.google.com/cse/style/look/espresso.css";M(google[A].a,"ESPRESSO",google[A].a.C);google[A].a.G="//www.google.com/cse/style/look/shiny.css";M(google[A].a,"SHINY",google[A].a.G);google[A].a.F="//www.google.com/cse/style/look/minimalist.css";M(google[A].a,"MINIMALIST",google[A].a.F);google[A].a.H="//www.google.com/cse/style/look/v2/default.css";M(google[A].a,"V2_DEFAULT",google[A].a.H);function U(a){this.b=a;this.q=[];this.p={};this.i={};this.e={};this.l=!0;this.c=-1}
U[z].g=function(a,b){var c="";void 0!=b&&(void 0!=b.language&&(c+="&hl="+d(b.language)),void 0!=b.nocss&&(c+="&output="+d("nocss="+b.nocss)),void 0!=b.nooldnames&&(c+="&nooldnames="+d(b.nooldnames)),void 0!=b.packages&&(c+="&packages="+d(b.packages)),null!=b.callback&&(c+="&async=2"),void 0!=b.style&&(c+="&style="+d(b.style)),void 0!=b.noexp&&(c+="&noexp=true"),void 0!=b.other_params&&(c+="&"+b.other_params));if(!this.l){google[this.b]&&google[this.b].JSHash&&(c+="&sig="+d(google[this.b].JSHash));
var e=[],f;for(f in this.p)":"==f[n](0)&&e[u](f[B](1));for(f in this.i)":"==f[n](0)&&this.i[f]&&e[u](f[B](1));c+="&have="+d(e[C](","))}return google[A][w]+"/?file="+this.b+"&v="+a+google[A].AdditionalParams+c};U[z].v=function(a){var b=null;a&&(b=a.packages);var c=null;if(b)if("string"==typeof b)c=[a.packages];else if(b[y])for(c=[],a=0;a<b[y];a++)"string"==typeof b[a]&&c[u](b[a][m](/^\s*|\s*$/,"")[D]());c||(c=["default"]);b=[];for(a=0;a<c[y];a++)this.p[":"+c[a]]||b[u](c[a]);return b};
l(U[z],function(a,b){var c=this.v(b),e=b&&null!=b.callback;if(e)var f=new W(b.callback);for(var k=[],p=c[y]-1;0<=p;p--){var t=c[p];e&&f.I(t);if(this.i[":"+t])c.splice(p,1),e&&this.e[":"+t][u](f);else k[u](t)}if(c[y]){b&&b.packages&&(b.packages=c.sort()[C](","));for(p=0;p<k[y];p++)t=k[p],this.e[":"+t]=[],e&&this.e[":"+t][u](f);if(b||null==O[":"+this.b]||null==O[":"+this.b].versions[":"+a]||google[A].AdditionalParams||!this.l)b&&b.autoloaded||google[A].d("script",this.g(a,b),e);else{c=O[":"+this.b];
google[this.b]=google[this.b]||{};for(var S in c.properties)S&&":"==S[n](0)&&(google[this.b][S[B](1)]=c.properties[S]);google[A].d("script",google[A][w]+c.path+c.js,e);c.css&&google[A].d("css",google[A][w]+c.path+c.css,e)}this.l&&(this.l=!1,this.c=(new Date)[q](),1!=this.c%100&&(this.c=-1));for(p=0;p<k[y];p++)t=k[p],this.i[":"+t]=!0}});
U[z].k=function(a){-1!=this.c&&(da("al_"+this.b,"jl."+((new Date)[q]()-this.c),!0),this.c=-1);this.q=this.q.concat(a.components);google[A][this.b]||(google[A][this.b]={});google[A][this.b].packages=this.q.slice(0);for(var b=0;b<a.components[y];b++){this.p[":"+a.components[b]]=!0;this.i[":"+a.components[b]]=!1;var c=this.e[":"+a.components[b]];if(c){for(var e=0;e<c[y];e++)c[e].L(a.components[b]);delete this.e[":"+a.components[b]]}}};U[z].m=function(a,b){return 0==this.v(b)[y]};U[z].s=function(){return!0};
function W(a){this.K=a;this.n={};this.r=0}W[z].I=function(a){this.r++;this.n[":"+a]=!0};W[z].L=function(a){this.n[":"+a]&&(this.n[":"+a]=!1,this.r--,0==this.r&&g[r](this.K,0))};function V(a,b,c){this.name=a;this.J=b;this.o=c;this.u=this.h=!1;this.j=[];google[A].t[this[x]]=H(this.k,this)}G(V,U);l(V[z],function(a,b){var c=b&&null!=b.callback;c?(this.j[u](b.callback),b.callback="google.loader.callbacks."+this[x]):this.h=!0;b&&b.autoloaded||google[A].d("script",this.g(a,b),c)});V[z].m=function(a,b){return b&&null!=b.callback?this.u:this.h};V[z].k=function(){this.u=!0;for(var a=0;a<this.j[y];a++)g[r](this.j[a],0);this.j=[]};
var X=function(a,b){return a.string?d(a.string)+"="+d(b):a.regex?b[m](/(^.*$)/,a.regex):""};V[z].g=function(a,b){return this.O(this.w(a),a,b)};
V[z].O=function(a,b,c){var e="";a.key&&(e+="&"+X(a.key,google[A].ApiKey));a.version&&(e+="&"+X(a.version,b));b=google[A].Secure&&a.ssl?a.ssl:a.uri;if(null!=c)for(var f in c)a.params[f]?e+="&"+X(a.params[f],c[f]):"other_params"==f?e+="&"+c[f]:"base_domain"==f&&(b="http://"+c[f]+a.uri[B](a.uri[v]("/",7)));google[this[x]]={};-1==b[v]("?")&&e&&(e="?"+e[B](1));return b+e};V[z].s=function(a){return this.w(a).deferred};V[z].w=function(a){if(this.o)for(var b=0;b<this.o[y];++b){var c=this.o[b];if((new RegExp(c.pattern)).test(a))return c}return this.J};function T(a,b){this.b=a;this.f=b;this.h=!1}G(T,U);l(T[z],function(a,b){this.h=!0;google[A].d("script",this.g(a,b),!1)});T[z].m=function(){return this.h};T[z].k=function(){};T[z].g=function(a,b){if(!this.f.versions[":"+a]){if(this.f.aliases){var c=this.f.aliases[":"+a];c&&(a=c)}if(!this.f.versions[":"+a])throw I("Module: '"+this.b+"' with version '"+a+"' not found!");}return google[A].GoogleApisBase+"/libs/"+this.b+"/"+a+"/"+this.f.versions[":"+a][b&&b.uncompressed?"uncompressed":"compressed"]};
T[z].s=function(){return!1};var ea=!1,Y=[],fa=(new Date)[q](),ha=function(){ea||(Q(g,"unload",ga),ea=!0)},ia=function(a,b){ha();if(!(google[A].Secure||google[A].Options&&!1!==google[A].Options.csi)){for(var c=0;c<a[y];c++)a[c]=d(a[c][D]()[m](/[^a-z0-9_.]+/g,"_"));for(c=0;c<b[y];c++)b[c]=d(b[c][D]()[m](/[^a-z0-9_.]+/g,"_"));g[r](H(Z,null,"//gg.google.com/csi?s=uds&v=2&action="+a[C](",")+"&it="+b[C](",")),1E4)}},da=function(a,b,c){c?ia([a],[b]):(ha(),Y[u]("r"+Y[y]+"="+d(a+(b?"|"+b:""))),g[r](ga,5<Y[y]?0:15E3))},ga=function(){if(Y[y]){var a=
google[A][w];0==a[v]("http:")&&(a=a[m](/^http:/,"https:"));Z(a+"/stats?"+Y[C]("&")+"&nc="+(new Date)[q]()+"_"+((new Date)[q]()-fa));Y.length=0}},Z=function(a){var b=new Image,c=Z.P++;Z.A[c]=b;b.onload=b.onerror=function(){delete Z.A[c]};b.src=a;b=null};Z.A={};Z.P=0;J("google.loader.recordCsiStat",ia);J("google.loader.recordStat",da);J("google.loader.createImageForLogging",Z);

}) ();google.loader.rm({"specs":[{"name":"books","baseSpec":{"uri":"http://books.google.com/books/api.js","ssl":"https://encrypted.google.com/books/api.js","key":{"string":"key"},"version":{"string":"v"},"deferred":true,"params":{"callback":{"string":"callback"},"language":{"string":"hl"}}}},"feeds",{"name":"friendconnect","baseSpec":{"uri":"http://www.google.com/friendconnect/script/friendconnect.js","ssl":"https://www.google.com/friendconnect/script/friendconnect.js","key":{"string":"key"},"version":{"string":"v"},"deferred":false,"params":{}}},"spreadsheets","identitytoolkit","gdata","ima","visualization",{"name":"sharing","baseSpec":{"uri":"http://www.google.com/s2/sharing/js","ssl":null,"key":{"string":"key"},"version":{"string":"v"},"deferred":false,"params":{"language":{"string":"hl"}}}},{"name":"maps","baseSpec":{"uri":"http://maps.google.com/maps?file\u003dgoogleapi","ssl":"https://maps-api-ssl.google.com/maps?file\u003dgoogleapi","key":{"string":"key"},"version":{"string":"v"},"deferred":true,"params":{"callback":{"regex":"callback\u003d$1\u0026async\u003d2"},"language":{"string":"hl"}}},"customSpecs":[{"uri":"http://maps.googleapis.com/maps/api/js","ssl":"https://maps.googleapis.com/maps/api/js","version":{"string":"v"},"deferred":true,"params":{"callback":{"string":"callback"},"language":{"string":"hl"}},"pattern":"^(3|3..*)$"}]},"search","annotations_v2","payments","wave","orkut",{"name":"annotations","baseSpec":{"uri":"http://www.google.com/reviews/scripts/annotations_bootstrap.js","ssl":null,"key":{"string":"key"},"version":{"string":"v"},"deferred":true,"params":{"callback":{"string":"callback"},"language":{"string":"hl"},"country":{"string":"gl"}}}},"language","earth","picker","ads","elements"]});
google.loader.rfm({":search":{"versions":{":1":"1",":1.0":"1"},"path":"/api/search/1.0/cb6ef4de1f03dde8c26c6d526f8a1f35/","js":"default+en.I.js","css":"default+en.css","properties":{":JSHash":"cb6ef4de1f03dde8c26c6d526f8a1f35",":NoOldNames":false,":Version":"1.0"}},":language":{"versions":{":1":"1",":1.0":"1"},"path":"/api/language/1.0/ab842e4cebe93c5ab08b2d3db3b8dc59/","js":"default+en.I.js","properties":{":JSHash":"ab842e4cebe93c5ab08b2d3db3b8dc59",":Version":"1.0"}},":feeds":{"versions":{":1":"1",":1.0":"1"},"path":"/api/feeds/1.0/482f2817cdf8982edf2e5669f9e3a627/","js":"default+en.I.js","css":"default+en.css","properties":{":JSHash":"482f2817cdf8982edf2e5669f9e3a627",":Version":"1.0"}},":spreadsheets":{"versions":{":0":"1",":0.4":"1"},"path":"/api/spreadsheets/0.4/87ff7219e9f8a8164006cbf28d5e911a/","js":"default.I.js","properties":{":JSHash":"87ff7219e9f8a8164006cbf28d5e911a",":Version":"0.4"}},":ima":{"versions":{":3":"1",":3.0":"1"},"path":"/api/ima/3.0/28a914332232c9a8ac0ae8da68b1006e/","js":"default.I.js","properties":{":JSHash":"28a914332232c9a8ac0ae8da68b1006e",":Version":"3.0"}},":wave":{"versions":{":1":"1",":1.0":"1"},"path":"/api/wave/1.0/3b6f7573ff78da6602dda5e09c9025bf/","js":"default.I.js","properties":{":JSHash":"3b6f7573ff78da6602dda5e09c9025bf",":Version":"1.0"}},":earth":{"versions":{":1":"1",":1.0":"1"},"path":"/api/earth/1.0/db22e5693e0a8de1f62f3536f5a8d7d3/","js":"default.I.js","properties":{":JSHash":"db22e5693e0a8de1f62f3536f5a8d7d3",":Version":"1.0"}},":annotations":{"versions":{":1":"1",":1.0":"1"},"path":"/api/annotations/1.0/ee29f1a32c343fea662c6e1b58ec6d0d/","js":"default+en.I.js","properties":{":JSHash":"ee29f1a32c343fea662c6e1b58ec6d0d",":Version":"1.0"}},":picker":{"versions":{":1":"1",":1.0":"1"},"path":"/api/picker/1.0/1c635e91b9d0c082c660a42091913907/","js":"default.I.js","css":"default.css","properties":{":JSHash":"1c635e91b9d0c082c660a42091913907",":Version":"1.0"}}});
google.loader.rpl({":scriptaculous":{"versions":{":1.8.3":{"uncompressed":"scriptaculous.js","compressed":"scriptaculous.js"},":1.9.0":{"uncompressed":"scriptaculous.js","compressed":"scriptaculous.js"},":1.8.2":{"uncompressed":"scriptaculous.js","compressed":"scriptaculous.js"},":1.8.1":{"uncompressed":"scriptaculous.js","compressed":"scriptaculous.js"}},"aliases":{":1.8":"1.8.3",":1":"1.9.0",":1.9":"1.9.0"}},":yui":{"versions":{":2.6.0":{"uncompressed":"build/yuiloader/yuiloader.js","compressed":"build/yuiloader/yuiloader-min.js"},":2.9.0":{"uncompressed":"build/yuiloader/yuiloader.js","compressed":"build/yuiloader/yuiloader-min.js"},":2.7.0":{"uncompressed":"build/yuiloader/yuiloader.js","compressed":"build/yuiloader/yuiloader-min.js"},":2.8.0r4":{"uncompressed":"build/yuiloader/yuiloader.js","compressed":"build/yuiloader/yuiloader-min.js"},":2.8.2r1":{"uncompressed":"build/yuiloader/yuiloader.js","compressed":"build/yuiloader/yuiloader-min.js"},":2.8.1":{"uncompressed":"build/yuiloader/yuiloader.js","compressed":"build/yuiloader/yuiloader-min.js"},":3.3.0":{"uncompressed":"build/yui/yui.js","compressed":"build/yui/yui-min.js"}},"aliases":{":3":"3.3.0",":2":"2.9.0",":2.7":"2.7.0",":2.8.2":"2.8.2r1",":2.6":"2.6.0",":2.9":"2.9.0",":2.8":"2.8.2r1",":2.8.0":"2.8.0r4",":3.3":"3.3.0"}},":swfobject":{"versions":{":2.1":{"uncompressed":"swfobject_src.js","compressed":"swfobject.js"},":2.2":{"uncompressed":"swfobject_src.js","compressed":"swfobject.js"}},"aliases":{":2":"2.2"}},":ext-core":{"versions":{":3.1.0":{"uncompressed":"ext-core-debug.js","compressed":"ext-core.js"},":3.0.0":{"uncompressed":"ext-core-debug.js","compressed":"ext-core.js"}},"aliases":{":3":"3.1.0",":3.0":"3.0.0",":3.1":"3.1.0"}},":webfont":{"versions":{":1.0.28":{"uncompressed":"webfont_debug.js","compressed":"webfont.js"},":1.0.27":{"uncompressed":"webfont_debug.js","compressed":"webfont.js"},":1.0.29":{"uncompressed":"webfont_debug.js","compressed":"webfont.js"},":1.0.12":{"uncompressed":"webfont_debug.js","compressed":"webfont.js"},":1.0.13":{"uncompressed":"webfont_debug.js","compressed":"webfont.js"},":1.0.14":{"uncompressed":"webfont_debug.js","compressed":"webfont.js"},":1.0.15":{"uncompressed":"webfont_debug.js","compressed":"webfont.js"},":1.0.10":{"uncompressed":"webfont_debug.js","compressed":"webfont.js"},":1.0.11":{"uncompressed":"webfont_debug.js","compressed":"webfont.js"},":1.0.2":{"uncompressed":"webfont_debug.js","compressed":"webfont.js"},":1.0.1":{"uncompressed":"webfont_debug.js","compressed":"webfont.js"},":1.0.0":{"uncompressed":"webfont_debug.js","compressed":"webfont.js"},":1.0.6":{"uncompressed":"webfont_debug.js","compressed":"webfont.js"},":1.0.19":{"uncompressed":"webfont_debug.js","compressed":"webfont.js"},":1.0.5":{"uncompressed":"webfont_debug.js","compressed":"webfont.js"},":1.0.18":{"uncompressed":"webfont_debug.js","compressed":"webfont.js"},":1.0.4":{"uncompressed":"webfont_debug.js","compressed":"webfont.js"},":1.0.17":{"uncompressed":"webfont_debug.js","compressed":"webfont.js"},":1.0.16":{"uncompressed":"webfont_debug.js","compressed":"webfont.js"},":1.0.3":{"uncompressed":"webfont_debug.js","compressed":"webfont.js"},":1.0.9":{"uncompressed":"webfont_debug.js","compressed":"webfont.js"},":1.0.21":{"uncompressed":"webfont_debug.js","compressed":"webfont.js"},":1.0.22":{"uncompressed":"webfont_debug.js","compressed":"webfont.js"},":1.0.25":{"uncompressed":"webfont_debug.js","compressed":"webfont.js"},":1.0.26":{"uncompressed":"webfont_debug.js","compressed":"webfont.js"},":1.0.23":{"uncompressed":"webfont_debug.js","compressed":"webfont.js"},":1.0.24":{"uncompressed":"webfont_debug.js","compressed":"webfont.js"}},"aliases":{":1":"1.0.29",":1.0":"1.0.29"}},":mootools":{"versions":{":1.3.1":{"uncompressed":"mootools.js","compressed":"mootools-yui-compressed.js"},":1.1.1":{"uncompressed":"mootools.js","compressed":"mootools-yui-compressed.js"},":1.3.0":{"uncompressed":"mootools.js","compressed":"mootools-yui-compressed.js"},":1.3.2":{"uncompressed":"mootools.js","compressed":"mootools-yui-compressed.js"},":1.1.2":{"uncompressed":"mootools.js","compressed":"mootools-yui-compressed.js"},":1.2.3":{"uncompressed":"mootools.js","compressed":"mootools-yui-compressed.js"},":1.2.4":{"uncompressed":"mootools.js","compressed":"mootools-yui-compressed.js"},":1.2.1":{"uncompressed":"mootools.js","compressed":"mootools-yui-compressed.js"},":1.2.2":{"uncompressed":"mootools.js","compressed":"mootools-yui-compressed.js"},":1.2.5":{"uncompressed":"mootools.js","compressed":"mootools-yui-compressed.js"},":1.4.0":{"uncompressed":"mootools.js","compressed":"mootools-yui-compressed.js"},":1.4.1":{"uncompressed":"mootools.js","compressed":"mootools-yui-compressed.js"},":1.4.2":{"uncompressed":"mootools.js","compressed":"mootools-yui-compressed.js"}},"aliases":{":1":"1.1.2",":1.11":"1.1.1",":1.4":"1.4.2",":1.3":"1.3.2",":1.2":"1.2.5",":1.1":"1.1.2"}},":jqueryui":{"versions":{":1.6.0":{"uncompressed":"jquery-ui.js","compressed":"jquery-ui.min.js"},":1.8.0":{"uncompressed":"jquery-ui.js","compressed":"jquery-ui.min.js"},":1.8.2":{"uncompressed":"jquery-ui.js","compressed":"jquery-ui.min.js"},":1.8.1":{"uncompressed":"jquery-ui.js","compressed":"jquery-ui.min.js"},":1.8.9":{"uncompressed":"jquery-ui.js","compressed":"jquery-ui.min.js"},":1.8.15":{"uncompressed":"jquery-ui.js","compressed":"jquery-ui.min.js"},":1.8.14":{"uncompressed":"jquery-ui.js","compressed":"jquery-ui.min.js"},":1.8.7":{"uncompressed":"jquery-ui.js","compressed":"jquery-ui.min.js"},":1.8.13":{"uncompressed":"jquery-ui.js","compressed":"jquery-ui.min.js"},":1.8.8":{"uncompressed":"jquery-ui.js","compressed":"jquery-ui.min.js"},":1.8.12":{"uncompressed":"jquery-ui.js","compressed":"jquery-ui.min.js"},":1.7.2":{"uncompressed":"jquery-ui.js","compressed":"jquery-ui.min.js"},":1.8.5":{"uncompressed":"jquery-ui.js","compressed":"jquery-ui.min.js"},":1.8.11":{"uncompressed":"jquery-ui.js","compressed":"jquery-ui.min.js"},":1.7.3":{"uncompressed":"jquery-ui.js","compressed":"jquery-ui.min.js"},":1.8.10":{"uncompressed":"jquery-ui.js","compressed":"jquery-ui.min.js"},":1.8.6":{"uncompressed":"jquery-ui.js","compressed":"jquery-ui.min.js"},":1.7.0":{"uncompressed":"jquery-ui.js","compressed":"jquery-ui.min.js"},":1.7.1":{"uncompressed":"jquery-ui.js","compressed":"jquery-ui.min.js"},":1.8.4":{"uncompressed":"jquery-ui.js","compressed":"jquery-ui.min.js"},":1.5.3":{"uncompressed":"jquery-ui.js","compressed":"jquery-ui.min.js"},":1.5.2":{"uncompressed":"jquery-ui.js","compressed":"jquery-ui.min.js"},":1.8.17":{"uncompressed":"jquery-ui.js","compressed":"jquery-ui.min.js"},":1.8.16":{"uncompressed":"jquery-ui.js","compressed":"jquery-ui.min.js"}},"aliases":{":1.8":"1.8.17",":1.7":"1.7.3",":1.6":"1.6.0",":1":"1.8.17",":1.5":"1.5.3",":1.8.3":"1.8.4"}},":chrome-frame":{"versions":{":1.0.2":{"uncompressed":"CFInstall.js","compressed":"CFInstall.min.js"},":1.0.1":{"uncompressed":"CFInstall.js","compressed":"CFInstall.min.js"},":1.0.0":{"uncompressed":"CFInstall.js","compressed":"CFInstall.min.js"}},"aliases":{":1":"1.0.2",":1.0":"1.0.2"}},":dojo":{"versions":{":1.3.1":{"uncompressed":"dojo/dojo.xd.js.uncompressed.js","compressed":"dojo/dojo.xd.js"},":1.6.1":{"uncompressed":"dojo/dojo.xd.js.uncompressed.js","compressed":"dojo/dojo.xd.js"},":1.3.0":{"uncompressed":"dojo/dojo.xd.js.uncompressed.js","compressed":"dojo/dojo.xd.js"},":1.1.1":{"uncompressed":"dojo/dojo.xd.js.uncompressed.js","compressed":"dojo/dojo.xd.js"},":1.3.2":{"uncompressed":"dojo/dojo.xd.js.uncompressed.js","compressed":"dojo/dojo.xd.js"},":1.6.0":{"uncompressed":"dojo/dojo.xd.js.uncompressed.js","compressed":"dojo/dojo.xd.js"},":1.2.3":{"uncompressed":"dojo/dojo.xd.js.uncompressed.js","compressed":"dojo/dojo.xd.js"},":1.7.2":{"uncompressed":"dojo/dojo.js.uncompressed.js","compressed":"dojo/dojo.js"},":1.7.0":{"uncompressed":"dojo/dojo.js.uncompressed.js","compressed":"dojo/dojo.js"},":1.7.1":{"uncompressed":"dojo/dojo.js.uncompressed.js","compressed":"dojo/dojo.js"},":1.4.3":{"uncompressed":"dojo/dojo.xd.js.uncompressed.js","compressed":"dojo/dojo.xd.js"},":1.5.1":{"uncompressed":"dojo/dojo.xd.js.uncompressed.js","compressed":"dojo/dojo.xd.js"},":1.5.0":{"uncompressed":"dojo/dojo.xd.js.uncompressed.js","compressed":"dojo/dojo.xd.js"},":1.2.0":{"uncompressed":"dojo/dojo.xd.js.uncompressed.js","compressed":"dojo/dojo.xd.js"},":1.4.0":{"uncompressed":"dojo/dojo.xd.js.uncompressed.js","compressed":"dojo/dojo.xd.js"},":1.4.1":{"uncompressed":"dojo/dojo.xd.js.uncompressed.js","compressed":"dojo/dojo.xd.js"}},"aliases":{":1.7":"1.7.2",":1":"1.6.1",":1.6":"1.6.1",":1.5":"1.5.1",":1.4":"1.4.3",":1.3":"1.3.2",":1.2":"1.2.3",":1.1":"1.1.1"}},":prototype":{"versions":{":1.7.0.0":{"uncompressed":"prototype.js","compressed":"prototype.js"},":1.6.0.2":{"uncompressed":"prototype.js","compressed":"prototype.js"},":1.6.1.0":{"uncompressed":"prototype.js","compressed":"prototype.js"},":1.6.0.3":{"uncompressed":"prototype.js","compressed":"prototype.js"}},"aliases":{":1.7":"1.7.0.0",":1.6.1":"1.6.1.0",":1":"1.7.0.0",":1.6":"1.6.1.0",":1.7.0":"1.7.0.0",":1.6.0":"1.6.0.3"}},":jquery":{"versions":{":1.6.2":{"uncompressed":"jquery.js","compressed":"jquery.min.js"},":1.3.1":{"uncompressed":"jquery.js","compressed":"jquery.min.js"},":1.6.1":{"uncompressed":"jquery.js","compressed":"jquery.min.js"},":1.3.0":{"uncompressed":"jquery.js","compressed":"jquery.min.js"},":1.6.4":{"uncompressed":"jquery.js","compressed":"jquery.min.js"},":1.6.3":{"uncompressed":"jquery.js","compressed":"jquery.min.js"},":1.3.2":{"uncompressed":"jquery.js","compressed":"jquery.min.js"},":1.6.0":{"uncompressed":"jquery.js","compressed":"jquery.min.js"},":1.2.3":{"uncompressed":"jquery.js","compressed":"jquery.min.js"},":1.7.0":{"uncompressed":"jquery.js","compressed":"jquery.min.js"},":1.7.1":{"uncompressed":"jquery.js","compressed":"jquery.min.js"},":1.2.6":{"uncompressed":"jquery.js","compressed":"jquery.min.js"},":1.4.3":{"uncompressed":"jquery.js","compressed":"jquery.min.js"},":1.4.4":{"uncompressed":"jquery.js","compressed":"jquery.min.js"},":1.5.1":{"uncompressed":"jquery.js","compressed":"jquery.min.js"},":1.5.0":{"uncompressed":"jquery.js","compressed":"jquery.min.js"},":1.4.0":{"uncompressed":"jquery.js","compressed":"jquery.min.js"},":1.5.2":{"uncompressed":"jquery.js","compressed":"jquery.min.js"},":1.4.1":{"uncompressed":"jquery.js","compressed":"jquery.min.js"},":1.4.2":{"uncompressed":"jquery.js","compressed":"jquery.min.js"}},"aliases":{":1.7":"1.7.1",":1.6":"1.6.4",":1":"1.7.1",":1.5":"1.5.2",":1.4":"1.4.4",":1.3":"1.3.2",":1.2":"1.2.6"}}});
}
(function() {
var aa=encodeURIComponent,ba=window,ca=Object,da=Infinity,ea=document,fa=isNaN,h=Math,ga=Array,ha=Number,ia=NaN,m=Error,ja=parseInt,ka=parseFloat,la=isFinite,ma=decodeURIComponent;function na(a,b){return a.width=b}function oa(a,b){return a.expand=b}function pa(a,b){return a.data=b}function qa(a,b){return a.ceil=b}function ra(a,b){return a.floor=b}function ta(a,b){return a.format=b}function ua(a,b){return a.remove=b}function va(a,b){return a.clear=b}function wa(a,b){return a.getColumnIndex=b}
function xa(a,b){return a.stroke=b}function ya(a,b){return a.getTime=b}function za(a,b){return a.fill=b}function Aa(a,b){return a.toString=b}function Ba(a,b){return a.position=b}function Ca(a,b){return a.toJSON=b}function Da(a,b){return a.next=b}function Ea(a,b){return a.constructor=b}function Fa(a,b){return a.fontSize=b}function Ga(a,b){return a.message=b}function Ia(a,b){return a.clone=b}function Ja(a,b){return a.start=b}function La(a,b){return a.init=b}function Ma(a,b){return a.bottom=b}
function Na(a,b){return a.scale=b}function Oa(a,b){return a.rows=b}function Pa(a,b){return a.contains=b}function Qa(a,b){return a.display=b}function Sa(a,b){return a.label=b}function Ta(a,b){return a.height=b}function Ua(a,b){return a.right=b}function Va(a,b){return a.isEmpty=b}function Wa(a,b){return a.round=b}function Xa(a,b){return a.innerHTML=b}function Ya(a,b){return a.color=b}function Za(a,b){return a.getProperty=b}function $a(a,b){return a.left=b}function ab(a,b){return a.equals=b}
function bb(a,b){return a.cssText=b}function cb(a,b){return a.getHeight=b}function db(a,b){return a.type=b}function eb(a,b){return a.tabIndex=b}function fb(a,b){return a.translate=b}function gb(a,b){return a.name=b}function hb(a,b){return a.getValue=b}function ib(a,b){return a.strokeWidth=b}function jb(a,b){return a.parse=b}function kb(a,b){return a.visibility=b}function lb(a,b){return a.bold=b}function mb(a,b){return a.length=b}function nb(a,b){return a.getProperties=b}
function ob(a,b){return a.prototype=b}function pb(a,b){return a.className=b}function qb(a,b){return a.opacity=b}function rb(a,b){return a.sort=b}
var q="appendChild",sb="filter",tb="properties",ub="activeElement",vb="getBoundingClientRect",wb="shift",xb="exec",r="width",yb="collapse",zb="pattern",Ab="replace",Bb="toFixed",Cb="ceil",Eb="floor",Fb="content",Gb="offsetWidth",Hb="concat",Ib="charAt",Jb="createTextNode",Kb="getDate",Lb="insertBefore",Mb="interval",Nb="targetTouches",Ob="trim",Pb="match",Qb="getUTCFullYear",Rb="format",Sb="cols",Tb="remove",Ub="querySelector",Vb="createElement",Wb="scrollHeight",Yb="firstChild",Zb="forEach",$b="clientLeft",
v="setAttribute",ac="clientTop",bc="clear",cc="childNodes",dc="getColumnIndex",ec="stroke",fc="bind",gc="getHours",hc="names",ic="nextSibling",jc="getTime",kc="getElementsByTagName",lc="documentElement",mc="substr",nc="fill",oc="previousSibling",pc="strokeOpacity",qc="toString",rc="gradient",sc="propertyIsEnumerable",tc="position",uc="compare",vc="getDay",wc="sourceIndex",xc="index",yc="next",zc="split",Ac="offsetParent",Bc="constructor",Cc="userAgent",Dc="stack",Fc="location",Gc="fontSize",Hc="hasOwnProperty",
w="style",Ic="ownerDocument",Jc="clone",Kc="search",Lc="lastChild",Mc="getUTCMonth",Nc="getYear",Oc="scrollWidth",y="start",Pc="random",Qc="setProperty",Rc="getFullYear",Sc="init",Tc="scrollLeft",Uc="bottom",Vc="href",Wc="setTime",Xc="rows",Yc="contains",Zc="apply",$c="tagName",ad="removeAttribute",bd="getMinutes",cd="display",dd="label",ed="offsetTop",z="height",fd="offsetHeight",gd="getStyle",hd="Range",id="execScript",jd="nodeValue",kd="right",B="push",ld="isEmpty",md="valueOf",nd="stringify",
od="test",pd="text",D="round",qd="slice",rd="nodeType",td="load",ud="getElementById",vd="innerHTML",wd="value",xd="item",yd="JSON",zd="indexOf",F="color",Ad="compareDocumentPosition",Bd="getProperty",Cd="nodeName",Dd="createRange",G="left",Ed="getElementsByClassName",Fd="setMonth",Gd="fromCharCode",Hd="setFullYear",Id="atan2",Jd="children",Kd="sqrt",Ld="Format",H="type",Md="defaultView",Nd="name",I="getValue",Od="strokeWidth",Pd="parse",Qd="clientX",Rd="clientY",Td="setDate",Ud="scrollTop",Vd="getMonth",
Wd="innerText",Xd="bold",J="length",Yd="fillOpacity",$d="getProperties",K="prototype",ae="className",be="clientWidth",ce="document",de="getSeconds",ee="getUTCDate",fe="opacity",ge="getMilliseconds",he="visualization",ie="disabled",je="offsetLeft",ke="body",le="removeChild",L="call",me="some",ne="lastIndexOf",oe="getAttribute",pe="querySelectorAll",qe="setUTCMonth",re="clientHeight",se="charCodeAt",te="compatMode",ue="sort",ve="currentStyle",we="substring",xe="getBackgroundColor",ye="documentMode",
ze="every",Ae="getUTCMinutes",Be="getUTCHours",Ce="parentNode",De="toUpperCase",Ee="splice",Fe="join",Ge="unshift",He="toLowerCase",Ie="getTimezoneOffset",M="",aaa="\x00",Je="\n",baa="\x0B",Ke=" ",Le=" and ",caa=" does not match type ",daa=' name="',eaa=' type="',Me='"',Ne='" />',Oe="#",faa="#$1$1$2$2$3$3",Pe="#000000",Qe="#808080",Re="#fff",Se="#ffffff",Te="$",Ue="$1",Ve="%",We="&",Xe="&#0;",Ye="&#39;",Ze="&amp;",gaa="&client=google-gviz",$e="&gt;",af="&lt;",bf="&quot;",cf="'",haa="''",df="(",iaa=
"(^",ef=")",jaa=")([a-z])",ff="*",hf="+",jf=",",kf=", ",lf="-",mf=".",nf="...",of=".SSS",kaa='.png" height="12" width="',laa="//ajax.googleapis.com/ajax",maa="/static/modules/gviz/",naa="/util/bar_",oaa="/util/format.css",pf="0",qf="0.5",rf="0.6",paa="00",sf="000",qaa="0000000000000000",tf="1",raa="1.0",uf="10",vf="3",wf="9",xf=":",yf=":ss",zf=";",Af="<",saa="</",taa="</span>\u00a0",Bf="<br>",uaa='<img style="padding: 0" src="',vaa='<span style="padding: 0; float: left; white-space: nowrap;">',Df=
"=",Ef='="',Ff=">",Gf="?",waa="@",Hf="A",xaa="APPLET",yaa="AREA",zaa="BASE",If="BR",Jf="BUTTON",Aaa="COL",Baa="COMMAND",Kf="CSS1Compat",Caa="Can't combine significant digits and minimum fraction digits",Lf="Column ",Daa="Const{",Mf="Container is not defined",Nf="DAY",Eaa="Date(",Of="December",Pf="E",Faa="EMBED",Gaa="Etc/GMT",Rf="F",Haa="FRAME",Sf="February",Iaa="G",Jaa="GMT",Kaa="H",Tf="HH:mm",Laa="HOUR",Uf="HR",Maa="IFRAME",Naa="IMG",Vf="INPUT",Oaa="ISINDEX",Paa="JavaScript",Qaa="K",Raa="KEYGEN",
Wf="L",Saa="LINK",Xf="M",Taa="META",Yf="MILLISECOND",Uaa="MINUTE",Zf="MMM d",$f="MONTH",ag="MSIE",Vaa="Moz",Waa="MozOpacity",bg="N",Xaa="NOFRAMES",Yaa="NOSCRIPT",cg="November",dg="O",Zaa="OBJECT",$aa="PARAM",eg="Q",aba="Q yyyy",fg="QUARTER",bba="Row ",gg="S",hg="SCRIPT",cba="SECOND",ig="SELECT",jg="SOURCE",dba="STYLE",eba="SVG",kg="Saturday",lg="September",fba="Style",mg="T",gba="TABLE",ng="TBODY",og="TD",pg="TEXTAREA",qg="TL",tg="TR",hba="TRACK",ug="Thursday",iba="Too many percent/permill",vg="Trident",
jba="Type mismatch. Value ",kba="UTC",lba="Uneven number of arguments",wg="W",mba="WBR",nba="WEEK",oba="Webkit",xg="Wednesday",pba="Width",yg="YEAR",zg="Z",qba="[",rba="[object Array]",sba="[object Function]",tba="[object Window]",uba="\\",vba="\\$1",Ag="\\\\",Bg="\\s",wba="\\u",xba="\\x08",Cg="]",yba="]+",zba="___clazz$",Aba="_bar_format_old_value",Dg="_default_",Eg="a",Bba="a String",Fg="absolute",Gg="action",Cba="alpha(opacity=",Dba="amp",Eba="an Array",Hg="area",Ig="aria-",Lg="array",Mg="auto",
Ng="b",Og="background-color:",Fba="bar.groupWidth",Pg="body",Qg="boolean",Gba="borderBottom",Hba="borderBottomWidth",Iba="borderLeft",Jba="borderLeftWidth",Kba="borderRight",Lba="borderRightWidth",Mba="borderTop",Nba="borderTopWidth",Rg="both",Sg="br",Tg="c",Oba="call",Pba="charteditor",Qba="class",Rba="className",Sba="clearMinutes",Tba="color:",Ug="column",Uba="columnFilters[",Vba="compare",Vg="d",Wg="data",Wba="data-",Xg="date",$g="datetime",Xba="decimalSymbol",Yba="desc",ah="direction",bh="display",
ch="div",Zba="document",dh="en",eh="f",fh="false",gh="filter",hh="fixed",ih="focus",$ba="for",aca="formatType",bca="fractionDigits",jh="full",kh="function",lh="g",cca="google-visualization-formatters-arrow-dr",dca="google-visualization-formatters-arrow-empty",eca="google-visualization-formatters-arrow-ug",fca="google.charts.",gca="google.loader.GoogleApisBase",hca="google.maps.DirectionsService",ica="google.visualization.",jca="google.visualization.ModulePath",kca="google.visualization.NumberFormat",
lca="google.visualization.Version",mca="groupingSymbol",nca="gt",mh="h",nh="h:mm a",oh="head",rh="height",oca="hex",sh="hidden",th="horizontal",uh="href",vh="html",wh="https",xh="iframe",yh="img",zh="inline",pca="innerText",Ah="input",Bh="k",Ch="left",Dh="link",Eh="long",qca="lt",Fh="m",Gh="maps",Hh="maxValue",Kh="medium",rca="meta",Lh="minValue",sca="ms",tca="named",uca="native code",vca="negativeColor",wca="negativeParens",xca="new ",O="none",Mh="null",Nh="number",Oh="o",Ph="object",Qh="on",Rh=
"opacity",yca="outerHTML",Sh="overflow",zca="paddingBottom",Aca="paddingLeft",Bca="paddingRight",Cca="paddingTop",Th="pattern",Dca="pixelHeight",Eca="pixelLeft",Fca="pixelWidth",Uh="position",Vh="prefix",P="px",Gca="quot",Wh="r",Xh="relative",Yh="rgb",Zh="role",$h="rtl",ai="s",Hca="scaleFactor",bi="script",ci="selection",Ica="sensor=false",di="short",ei="single",fi="solid",Jca="sortColumns",Kca="sortColumns[",Lca="sourceIndex",Mca="splice",gi="src",hi="static",ii="string",ji="style",Nca="stylesheet",
ki="suffix",Oca="tabIndex",Pca="tabindex",Qca="text/css",li="text/javascript",Rca="textContent",Sca="the wrong type of data",mi="time",Tca="timeZone",ni="timeofday",Uca="track",oi="transparent",pi="true",qi="type",Vca="type_error:Const",Wca="type_error:SafeHtml",Xca="type_error:SafeStyle",Yca="type_error:SafeUrl",Zca="type_error:TrustedResourceUrl",ri="unselectable",si="v",ti="value",$ca="valueType",ada="var ",bda="var _et_ = 1;",ui="vertical",vi="visible",cda="visualization",wi="w",xi="white",yi=
"width",zi="y",Ai="z",dda="zClosurez",eda="zoomButtonsOrder",Bi="{",sda="{0}",tda="{1}",uda="|[",Ci="}",Di="\u00a0",vda="\u00a4",wda="\u2030",R,Ei=Ei||{},Fi=this;function Gi(a){return void 0!==a}function Hi(a,b,c){a=a[zc](mf);c=c||Fi;a[0]in c||!c[id]||c[id](ada+a[0]);for(var d;a[J]&&(d=a[wb]());)!a[J]&&Gi(b)?c[d]=b:c=c[d]?c[d]:c[d]={}}function Ii(a,b){for(var c=a[zc](mf),d=b||Fi,e;e=c[wb]();)if(null!=d[e])d=d[e];else return null;return d}function Ji(){}
function Ki(a){a.ac=function(){return a.fga?a.fga:a.fga=new a}}function Li(a){var b=typeof a;if(b==Ph)if(a){if(a instanceof ga)return Lg;if(a instanceof ca)return b;var c=ca[K][qc][L](a);if(c==tba)return Ph;if(c==rba||typeof a[J]==Nh&&"undefined"!=typeof a[Ee]&&"undefined"!=typeof a[sc]&&!a[sc](Mca))return Lg;if(c==sba||"undefined"!=typeof a[L]&&"undefined"!=typeof a[sc]&&!a[sc](Oba))return kh}else return Mh;else if(b==kh&&"undefined"==typeof a[L])return Ph;return b}
function Mi(a){return null===a}function Ni(a){return null!=a}function Oi(a){return Li(a)==Lg}function Pi(a){var b=Li(a);return b==Lg||b==Ph&&typeof a[J]==Nh}function Qi(a){return Ri(a)&&typeof a[Rc]==kh}function Si(a){return typeof a==ii}function Ti(a){return typeof a==Qg}function Ui(a){return typeof a==Nh}function Vi(a){return Li(a)==kh}function Ri(a){var b=typeof a;return b==Ph&&null!=a||b==kh}function Wi(a){return a[xda]||(a[xda]=++yda)}var xda="closure_uid_"+(1E9*h[Pc]()>>>0),yda=0;
function zda(a,b,c){return a[L][Zc](a[fc],arguments)}function Ada(a,b,c){if(!a)throw m();if(2<arguments[J]){var d=ga[K][qd][L](arguments,2);return function(){var c=ga[K][qd][L](arguments);ga[K][Ge][Zc](c,d);return a[Zc](b,c)}}return function(){return a[Zc](b,arguments)}}function U(a,b,c){U=Function[K][fc]&&-1!=Function[K][fc][qc]()[zd](uca)?zda:Ada;return U[Zc](null,arguments)}
function Yi(a,b){var c=ga[K][qd][L](arguments,1);return function(){var b=c[qd]();b[B][Zc](b,arguments);return a[Zc](this,b)}}var Zi=Date.now||function(){return+new Date};function Bda(a){if(Fi[id])Fi[id](a,Paa);else if(Fi.eval)if(null==$i&&(Fi.eval(bda),"undefined"!=typeof Fi._et_?(delete Fi._et_,$i=!0):$i=!1),$i)Fi.eval(a);else{var b=Fi[ce],c=b[Vb](bi);db(c,li);c.defer=!1;c[q](b[Jb](a));b[ke][q](c);b[ke][le](c)}else throw m("goog.globalEval not available");}var $i=null;
function W(a,b){function c(){}ob(c,b[K]);a.e=b[K];ob(a,new c);Ea(a[K],a);a.he=function(a,c,f){for(var g=ga(arguments[J]-2),k=2;k<arguments[J];k++)g[k-2]=arguments[k];return b[K][c][Zc](a,g)}};var google=google||ba.google||{};function aj(a){if(m.captureStackTrace)m.captureStackTrace(this,aj);else{var b=m()[Dc];b&&(this.stack=b)}a&&Ga(this,String(a))}W(aj,m);gb(aj[K],"CustomError");var Cda;function bj(a,b){return 0==a[ne](b,0)}function Dda(a){var b=a[J]-1;return 0<=b&&a[zd](Ve,b)==b}function cj(a){return/^[\s\xa0]*$/[od](a)}function dj(a){return!/[^0-9]/[od](a)}function Eda(a){return a[Ab](/[\t\r\n ]+/g,Ke)[Ab](/^[\t\r\n ]+|[\t\r\n ]+$/g,M)}var ej=String[K][Ob]?function(a){return a[Ob]()}:function(a){return a[Ab](/^[\s\xa0]+|[\s\xa0]+$/g,M)};
function fj(a,b){if(b)a=a[Ab](Fda,Ze)[Ab](Gda,af)[Ab](Hda,$e)[Ab](Ida,bf)[Ab](Jda,Ye)[Ab](Kda,Xe);else{if(!Lda[od](a))return a;-1!=a[zd](We)&&(a=a[Ab](Fda,Ze));-1!=a[zd](Af)&&(a=a[Ab](Gda,af));-1!=a[zd](Ff)&&(a=a[Ab](Hda,$e));-1!=a[zd](Me)&&(a=a[Ab](Ida,bf));-1!=a[zd](cf)&&(a=a[Ab](Jda,Ye));-1!=a[zd](aaa)&&(a=a[Ab](Kda,Xe))}return a}var Fda=/&/g,Gda=/</g,Hda=/>/g,Ida=/"/g,Jda=/'/g,Kda=/\x00/g,Lda=/[\x00&<>"']/;function Mda(a){return gj(a,We)?Zba in Fi?Nda(a):Oda(a):a}
function Nda(a){var b={"&amp;":We,"&lt;":Af,"&gt;":Ff,"&quot;":Me},c;c=Fi[ce][Vb](ch);return a[Ab](Pda,function(a,e){var f=b[a];if(f)return f;if(e[Ib](0)==Oe){var g=ha(pf+e[mc](1));fa(g)||(f=String[Gd](g))}f||(Xa(c,a+Ke),f=c[Yb][jd][qd](0,-1));return b[a]=f})}function Oda(a){return a[Ab](/&([^;]+);/g,function(a,c){switch(c){case Dba:return We;case qca:return Af;case nca:return Ff;case Gca:return Me;default:if(c[Ib](0)==Oe){var d=ha(pf+c[mc](1));if(!fa(d))return String[Gd](d)}return a}})}var Pda=/&([^;\s<&]+);?/g;
function hj(a,b){a[J]>b&&(a=a[we](0,b-3)+nf);return a}function gj(a,b){return-1!=a[zd](b)}function ij(a,b){return ga(b+1)[Fe](a)}function jj(a,b){var c=Gi(void 0)?a[Bb](void 0):String(a),d=c[zd](mf);-1==d&&(d=c[J]);return ij(pf,h.max(0,b-d))+c}function kj(a){return null==a?M:String(a)}function Qda(a){return ga[K][Fe][L](arguments,M)}
function lj(a,b){for(var c=0,d=ej(String(a))[zc](mf),e=ej(String(b))[zc](mf),f=h.max(d[J],e[J]),g=0;0==c&&g<f;g++){var k=d[g]||M,l=e[g]||M,n=/(\d*)(\D*)/g,p=/(\d*)(\D*)/g;do{var t=n[xb](k)||[M,M,M],u=p[xb](l)||[M,M,M];if(0==t[0][J]&&0==u[0][J])break;c=mj(0==t[1][J]?0:ja(t[1],10),0==u[1][J]?0:ja(u[1],10))||mj(0==t[2][J],0==u[2][J])||mj(t[2],u[2])}while(0==c)}return c}function mj(a,b){return a<b?-1:a>b?1:0}function nj(a){for(var b=0,c=0;c<a[J];++c)b=31*b+a[se](c),b%=4294967296;return b}
var Rda=2147483648*h[Pc]()|0;function oj(a){var b=ha(a);return 0==b&&cj(a)?ia:b}function pj(a){return String(a)[Ab](/\-([a-z])/g,function(a,c){return c[De]()})}function Sda(a){var b=Si(void 0)?"undefined"[Ab](/([-()\[\]{}+?*.$\^|,:#<!\\])/g,vba)[Ab](/\x08/g,xba):Bg;return a[Ab](new RegExp(iaa+(b?uda+b+yba:M)+jaa,lh),function(a,b,e){return b+e[De]()})};function qj(a){return a[a[J]-1]}
var rj=ga[K],sj=rj[zd]?function(a,b,c){return rj[zd][L](a,b,c)}:function(a,b,c){c=null==c?0:0>c?h.max(0,a[J]+c):c;if(Si(a))return Si(b)&&1==b[J]?a[zd](b,c):-1;for(;c<a[J];c++)if(c in a&&a[c]===b)return c;return-1},Tda=rj[ne]?function(a,b,c){return rj[ne][L](a,b,null==c?a[J]-1:c)}:function(a,b,c){c=null==c?a[J]-1:c;0>c&&(c=h.max(0,a[J]+c));if(Si(a))return Si(b)&&1==b[J]?a[ne](b,c):-1;for(;0<=c;c--)if(c in a&&a[c]===b)return c;return-1},X=rj[Zb]?function(a,b,c){rj[Zb][L](a,b,c)}:function(a,b,c){for(var d=
a[J],e=Si(a)?a[zc](M):a,f=0;f<d;f++)f in e&&b[L](c,e[f],f,a)};function uj(a,b,c){for(var d=a[J],e=Si(a)?a[zc](M):a,d=d-1;0<=d;--d)d in e&&b[L](c,e[d],d,a)}
var vj=rj[sb]?function(a,b,c){return rj[sb][L](a,b,c)}:function(a,b,c){for(var d=a[J],e=[],f=0,g=Si(a)?a[zc](M):a,k=0;k<d;k++)if(k in g){var l=g[k];b[L](c,l,k,a)&&(e[f++]=l)}return e},wj=rj.map?function(a,b,c){return rj.map[L](a,b,c)}:function(a,b,c){for(var d=a[J],e=ga(d),f=Si(a)?a[zc](M):a,g=0;g<d;g++)g in f&&(e[g]=b[L](c,f[g],g,a));return e},xj=rj.reduce?function(a,b,c,d){d&&(b=U(b,d));return rj.reduce[L](a,b,c)}:function(a,b,c,d){var e=c;X(a,function(c,g){e=b[L](d,e,c,g,a)});return e},yj=rj[me]?
function(a,b,c){return rj[me][L](a,b,c)}:function(a,b,c){for(var d=a[J],e=Si(a)?a[zc](M):a,f=0;f<d;f++)if(f in e&&b[L](c,e[f],f,a))return!0;return!1},zj=rj[ze]?function(a,b,c){return rj[ze][L](a,b,c)}:function(a,b,c){for(var d=a[J],e=Si(a)?a[zc](M):a,f=0;f<d;f++)if(f in e&&!b[L](c,e[f],f,a))return!1;return!0};function Uda(a,b){var c=0;X(a,function(a,e,f){b[L](void 0,a,e,f)&&++c},void 0);return c}function Aj(a,b,c){b=Bj(a,b,c);return 0>b?null:Si(a)?a[Ib](b):a[b]}
function Bj(a,b,c){for(var d=a[J],e=Si(a)?a[zc](M):a,f=0;f<d;f++)if(f in e&&b[L](c,e[f],f,a))return f;return-1}function Cj(a,b){var c;t:{var d=a[J];c=Si(a)?a[zc](M):a;for(--d;0<=d;d--)if(d in c&&b[L](void 0,c[d],d,a)){c=d;break t}c=-1}return 0>c?null:Si(a)?a[Ib](c):a[c]}function Dj(a,b){return 0<=sj(a,b)}function Ej(a){return 0==a[J]}function Fj(a){if(!Oi(a))for(var b=a[J]-1;0<=b;b--)delete a[b];mb(a,0)}function Gj(a,b,c){Hj(a,c,0,b)}
function Ij(a,b){var c=sj(a,b),d;(d=0<=c)&&rj[Ee][L](a,c,1);return d}function Kj(a){return rj[Hb][Zc](rj,arguments)}function Lj(a){var b=a[J];if(0<b){for(var c=ga(b),d=0;d<b;d++)c[d]=a[d];return c}return[]}function Mj(a,b){for(var c=1;c<arguments[J];c++){var d=arguments[c];if(Pi(d)){var e=a[J]||0,f=d[J]||0;mb(a,e+f);for(var g=0;g<f;g++)a[e+g]=d[g]}else a[B](d)}}function Hj(a,b,c,d){return rj[Ee][Zc](a,Nj(arguments,1))}function Nj(a,b,c){return 2>=arguments[J]?rj[qd][L](a,b):rj[qd][L](a,b,c)}
function Vda(a){for(var b={},c=0,d=0;d<a[J];){var e=a[d++],f=Ri(e)?Oh+Wi(e):(typeof e)[Ib](0)+e;ca[K][Hc][L](b,f)||(b[f]=!0,a[c++]=e)}mb(a,c)}function Oj(a,b,c){return Wda(a,c||Pj,!1,b)}function Xda(a,b,c){return Wda(a,b,!0,void 0,c)}function Wda(a,b,c,d,e){for(var f=0,g=a[J],k;f<g;){var l=f+g>>1,n;n=c?b[L](e,a[l],l,a):b(d,a[l]);0<n?f=l+1:(g=l,k=!n)}return k?f:~f}function Qj(a,b){a[ue](b||Pj)}
function Rj(a,b){for(var c=0;c<a[J];c++)a[c]={index:c,value:a[c]};var d=b||Pj;Qj(a,function(a,b){return d(a[wd],b[wd])||a[xc]-b[xc]});for(c=0;c<a[J];c++)a[c]=a[c][wd]}function Yda(a,b){var c=Pj;Qj(a,function(a,e){return c(b(a),b(e))})}function Zda(a){Yda(a,function(a){return a.x})}function Sj(a,b){if(!Pi(a)||!Pi(b)||a[J]!=b[J])return!1;for(var c=a[J],d=$da,e=0;e<c;e++)if(!d(a[e],b[e]))return!1;return!0}function Pj(a,b){return a>b?1:a<b?-1:0}function $da(a,b){return a===b}
function aea(a,b){for(var c={},d=0;d<a[J];d++){var e=a[d],f=b[L](void 0,e,d,a);Gi(f)&&(c[f]||(c[f]=[]))[B](e)}return c}function Wj(a){var b=[];if(0>1*(a-0))return[];for(var c=0;c<a;c+=1)b[B](c);return b}function Xj(a,b){for(var c=[],d=0;d<b;d++)c[d]=a;return c}function bea(a){for(var b=[],c=0;c<arguments[J];c++){var d=arguments[c];if(Oi(d))for(var e=0;e<d[J];e+=8192)for(var f=Nj(d,e,e+8192),f=bea[Zc](null,f),g=0;g<f[J];g++)b[B](f[g]);else b[B](d)}return b}
function Yj(a){if(!arguments[J])return[];for(var b=[],c=0;;c++){for(var d=[],e=0;e<arguments[J];e++){var f=arguments[e];if(c>=f[J])return b;d[B](f[c])}b[B](d)}};function Zj(a,b,c){for(var d in a)b[L](c,a[d],d,a)}function ak(a,b,c){var d={},e;for(e in a)d[e]=b[L](c,a[e],e,a);return d}function bk(a,b){for(var c in a)if(b[L](void 0,a[c],c,a))return!0;return!1}function ck(a,b,c){for(var d in a)if(!b[L](c,a[d],d,a))return!1;return!0}function cea(a){var b=0,c;for(c in a)b++;return b}function dk(a){for(var b in a)return a[b]}function ek(a){var b=[],c=0,d;for(d in a)b[c++]=a[d];return b}function fk(a){var b=[],c=0,d;for(d in a)b[c++]=d;return b}
function gk(a,b){for(var c in a)if(a[c]==b)return!0;return!1}function hk(a){for(var b in a)return!1;return!0}function ik(a,b){b in a&&delete a[b]}function jk(a,b,c){if(b in a)throw m('The object already contains the key "'+b+Me);a[b]=c}function kk(a,b,c){return b in a?a[b]:c}function lk(a,b,c){return b in a?a[b]:a[b]=c}function dea(a,b){for(var c in a)if(!(c in b)||a[c]!==b[c])return!1;for(c in b)if(!(c in a))return!1;return!0}function mk(a){var b={},c;for(c in a)b[c]=a[c];return b}
function nk(a){var b=Li(a);if(b==Ph||b==Lg){if(a[Jc])return a[Jc]();var b=b==Lg?[]:{},c;for(c in a)b[c]=nk(a[c]);return b}return a}function ok(a){var b={},c;for(c in a)b[a[c]]=c;return b}var eea="constructor hasOwnProperty isPrototypeOf propertyIsEnumerable toLocaleString toString valueOf".split(" ");function pk(a,b){for(var c,d,e=1;e<arguments[J];e++){d=arguments[e];for(c in d)a[c]=d[c];for(var f=0;f<eea[J];f++)c=eea[f],ca[K][Hc][L](d,c)&&(a[c]=d[c])}}
function fea(a){var b=arguments[J];if(1==b&&Oi(arguments[0]))return fea[Zc](null,arguments[0]);if(b%2)throw m(lba);for(var c={},d=0;d<b;d+=2)c[arguments[d]]=arguments[d+1];return c}function qk(a){var b=arguments[J];if(1==b&&Oi(arguments[0]))return qk[Zc](null,arguments[0]);for(var c={},d=0;d<b;d++)c[arguments[d]]=!0;return c};var gea=qk([Hg,"base",Sg,"col","command","embed","hr",yh,Ah,"keygen",Dh,rca,"param","source",Uca,"wbr"]);var hea=/<[^>]*>|&[^;]+;/g;function rk(a,b){return b?a[Ab](hea,M):a}var iea=/[A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02b8\u0300-\u0590\u0800-\u1fff\u200e\u2c00-\ufb1c\ufe00-\ufe6f\ufefd-\uffff]/,jea=/^[^A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02b8\u0300-\u0590\u0800-\u1fff\u200e\u2c00-\ufb1c\ufe00-\ufe6f\ufefd-\uffff]*[\u0591-\u07ff\u200f\ufb1d-\ufdff\ufe70-\ufefc]/,kea=/^http:\/\/.*/,lea=/^(ar|ckb|dv|he|iw|fa|nqo|ps|sd|ug|ur|yi|.*[-_](Arab|Hebr|Thaa|Nkoo|Tfng))(?!.*[-_](Latn|Cyrl)($|-|_))($|-|_)/i;
function sk(){return lea[od](tk(Pba)||dh)}var mea=/\s+/,nea=/\d/;function oea(a,b){for(var c=0,d=0,e=!1,f=rk(a,b)[zc](mea),g=0;g<f[J];g++){var k=f[g];jea[od](rk(k,void 0))?(c++,d++):kea[od](k)?e=!0:iea[od](rk(k,void 0))?d++:nea[od](k)&&(e=!0)}return 0==d?e?1:0:.4<c/d?-1:1};function uk(){this.H5=M;this.awa=pea}uk[K].iF=!0;uk[K].hF=function(){return this.H5};Aa(uk[K],function(){return Daa+this.H5+Ci});function qea(a){return a instanceof uk&&a[Bc]===uk&&a.awa===pea?a.H5:Vca}var pea={};function vk(){this.K4=M;this.Lua=rea}vk[K].iF=!0;var rea={};vk[K].hF=function(){return this.K4};function sea(a){var b=new vk;b.K4=a;return b}var tea=sea(M),uea=/^[-.%_!# a-zA-Z0-9]+$/;function xk(){this.gF=M;this.Mua=vea}xk[K].iF=!0;xk[K].hF=function(){return this.gF};xk[K].h5=!0;xk[K].ow=function(){return 1};var vea={};function yk(){this.aga=M;this.Nua=wea}yk[K].iF=!0;yk[K].hF=function(){return this.aga};yk[K].h5=!0;yk[K].ow=function(){return 1};var wea={};function zk(){this.gF=M;this.Mva=xea;this.Fga=null}zk[K].h5=!0;zk[K].ow=function(){return this.Fga};zk[K].iF=!0;zk[K].hF=function(){return this.gF};function Ak(a){return a instanceof zk&&a[Bc]===zk&&a.Mva===xea?a.gF:Wca}function Bk(a){if(a instanceof zk)return a;var b=null;a.h5&&(b=a.ow());return Ck(fj(a.iF?a.hF():String(a)),b)}function yea(a){if(a instanceof zk)return a;a=Bk(a);var b;b=Ak(a)[Ab](/(\r\n|\r|\n)/g,Bf);return Ck(b,a.ow())}
var zea=/^[a-zA-Z0-9-]+$/,Aea=qk(Gg,"cite",Wg,"formaction",uh,"manifest","poster",gi),Bea=qk("embed",xh,Dh,Ph,bi,ji,"template");
function Dk(a,b,c){if(!zea[od](a))throw m("Invalid tag name <"+a+">.");if(a[He]()in Bea)throw m("Tag name <"+a+"> is not allowed for SafeHtml.");var d=null,e=Af+a;if(b)for(var f in b){if(!zea[od](f))throw m('Invalid attribute name "'+f+'".');var g=b[f];if(null!=g){var k,l=a;k=f;if(g instanceof uk)g=qea(g);else if(k[He]()==ji){if(!Ri(g))throw m('The "style" attribute requires goog.html.SafeStyle or map of style properties, '+typeof g+" given: "+g);if(!(g instanceof vk)){var l=M,n=void 0;for(n in g){if(!/^[-_a-zA-Z0-9]+$/[od](n))throw m("Name allows only [-_a-zA-Z0-9], got: "+
n);var p=g[n];null!=p&&(p instanceof uk?p=qea(p):uea[od](p)||(p=dda),l+=n+xf+p+zf)}g=l?sea(l):tea}l=void 0;l=g instanceof vk&&g[Bc]===vk&&g.Lua===rea?g.K4:Xca;g=l}else{if(/^on/i[od](k))throw m('Attribute "'+k+'" requires goog.string.Const value, "'+g+'" given.');if(k[He]()in Aea)if(g instanceof yk)g=g instanceof yk&&g[Bc]===yk&&g.Nua===wea?g.aga:Zca;else if(g instanceof xk)g=g instanceof xk&&g[Bc]===xk&&g.Mua===vea?g.gF:Yca;else throw m('Attribute "'+k+'" on tag "'+l+'" requires goog.html.SafeUrl or goog.string.Const value, "'+
g+'" given.');}g.iF&&(g=g.hF());k=k+Ef+fj(String(g))+Me;e+=Ke+k}}Gi(c)?Oi(c)||(c=[c]):c=[];!0===gea[a[He]()]?e+=Ff:(d=Ek(c),e+=Ff+Ak(d)+saa+a+Ff,d=d.ow());(a=b&&b.dir)&&(d=/^(ltr|rtl|auto)$/i[od](a)?0:null);return Ck(e,d)}function Ek(a){function b(a){Oi(a)?X(a,b):(a=Bk(a),d+=Ak(a),a=a.ow(),0==c?c=a:0!=a&&c!=a&&(c=null))}var c=0,d=M;X(arguments,b);return Ck(d,c)}var xea={};function Ck(a,b){var c=new zk;c.gF=a;c.Fga=b;return c}var Hk=Ck(M,0);function Ik(a){return function(){return a}}var Cea=Ik(!0),Jk=Ik(null);function Kk(a){return a}function Dea(a){var b;b=b||0;return function(){return a[Zc](this,ga[K][qd][L](arguments,0,b))}}function Eea(){return function(){return!Mi[Zc](this,arguments)}};function Lk(a,b,c){return h.min(h.max(a,b),c)}function Mk(a,b){var c=a%b;return 0>c*b?c+b:c}function Nk(a,b,c){return a+c*(b-a)}function Ok(a){return a*h.PI/180}function Pk(a,b){return b*h.cos(Ok(a))}function Qk(a,b){return b*h.sin(Ok(a))}function Rk(a,b,c,d){return Mk(180*h[Id](d-b,c-a)/h.PI,360)}function Sk(a){return 0==a?0:0>a?-1:1}function Tk(a){return xj(arguments,function(a,c){return a+c},0)}function Uk(a){return Tk[Zc](null,arguments)/arguments[J]}function Vk(a){return la(a)&&0==a%1}
function Wk(a){return la(a)&&!fa(a)};var Xk="StopIteration"in Fi?Fi.StopIteration:m("StopIteration");function Yk(){}Da(Yk[K],function(){throw Xk;});Yk[K].pt=function(){return this};function Zk(a){if(a instanceof Yk)return a;if(typeof a.pt==kh)return a.pt(!1);if(Pi(a)){var b=0,c=new Yk;Da(c,function(){for(;;){if(b>=a[J])throw Xk;if(b in a)return a[b++];b++}});return c}throw m("Not implemented");}
function $k(a,b,c){if(Pi(a))try{X(a,b,c)}catch(d){if(d!==Xk)throw d;}else{a=Zk(a);try{for(;;)b[L](c,a[yc](),void 0,a)}catch(e){if(e!==Xk)throw e;}}}function al(a,b,c){var d=0,e=a,f=c||1;1<arguments[J]&&(d=a,e=b);if(0==f)throw m("Range step argument must not be zero");var g=new Yk;Da(g,function(){if(0<f&&d>=e||0>f&&d<=e)throw Xk;var a=d;d+=f;return a});return g}function Fea(a,b,c){var d=Zk(a);a=new Yk;Da(a,function(){var a=d[yc]();return b[L](c,a,void 0,d)});return a}
function Gea(a){return Hea(arguments)}function Hea(a){var b=Zk(a);a=new Yk;var c=null;Da(a,function(){for(;;){if(null==c){var a=b[yc]();c=Zk(a)}try{return c[yc]()}catch(e){if(e!==Xk)throw e;c=null}}});return a}function Iea(a){if(Pi(a))return Lj(a);a=Zk(a);var b=[];$k(a,function(a){b[B](a)});return b}function Jea(a){try{return Zk(a)[yc]()}catch(b){if(b!=Xk)throw b;return null}};function bl(a,b){this.cb={};this.me=[];this.iz=this.Rb=0;var c=arguments[J];if(1<c){if(c%2)throw m(lba);for(var d=0;d<c;d+=2)this.set(arguments[d],arguments[d+1])}else a&&this.Zy(a)}R=bl[K];R.Vb=function(){return this.Rb};R.Qa=function(){cl(this);for(var a=[],b=0;b<this.me[J];b++)a[B](this.cb[this.me[b]]);return a};R.Ok=function(){cl(this);return this.me[Hb]()};R.$e=function(a){return dl(this.cb,a)};R.PU=function(a){for(var b=0;b<this.me[J];b++){var c=this.me[b];if(dl(this.cb,c)&&this.cb[c]==a)return!0}return!1};
ab(R,function(a,b){if(this===a)return!0;if(this.Rb!=a.Vb())return!1;var c=b||Kea;cl(this);for(var d,e=0;d=this.me[e];e++)if(!c(this.get(d),a.get(d)))return!1;return!0});function Kea(a,b){return a===b}Va(R,function(){return 0==this.Rb});va(R,function(){this.cb={};mb(this.me,0);this.iz=this.Rb=0});ua(R,function(a){return dl(this.cb,a)?(delete this.cb[a],this.Rb--,this.iz++,this.me[J]>2*this.Rb&&cl(this),!0):!1});
function cl(a){if(a.Rb!=a.me[J]){for(var b=0,c=0;b<a.me[J];){var d=a.me[b];dl(a.cb,d)&&(a.me[c++]=d);b++}mb(a.me,c)}if(a.Rb!=a.me[J]){for(var e={},c=b=0;b<a.me[J];)d=a.me[b],dl(e,d)||(a.me[c++]=d,e[d]=1),b++;mb(a.me,c)}}R.get=function(a,b){return dl(this.cb,a)?this.cb[a]:b};R.set=function(a,b){dl(this.cb,a)||(this.Rb++,this.me[B](a),this.iz++);this.cb[a]=b};R.Zy=function(a){var b;a instanceof bl?(b=a.Ok(),a=a.Qa()):(b=fk(a),a=ek(a));for(var c=0;c<b[J];c++)this.set(b[c],a[c])};
R.forEach=function(a,b){for(var c=this.Ok(),d=0;d<c[J];d++){var e=c[d],f=this.get(e);a[L](b,f,e,this)}};Ia(R,function(){return new bl(this)});R.transpose=function(){for(var a=new bl,b=0;b<this.me[J];b++){var c=this.me[b];a.set(this.cb[c],c)}return a};R.pt=function(a){cl(this);var b=0,c=this.me,d=this.cb,e=this.iz,f=this,g=new Yk;Da(g,function(){for(;;){if(e!=f.iz)throw m("The map has changed since the iterator was created");if(b>=c[J])throw Xk;var g=c[b++];return a?g:d[g]}});return g};
function dl(a,b){return ca[K][Hc][L](a,b)};function Lea(a){return typeof a.Vb==kh?a.Vb():Pi(a)||Si(a)?a[J]:cea(a)}function el(a){if(typeof a.Qa==kh)return a.Qa();if(Si(a))return a[zc](M);if(Pi(a)){for(var b=[],c=a[J],d=0;d<c;d++)b[B](a[d]);return b}return ek(a)}function fl(a){if(typeof a.Ok==kh)return a.Ok();if(typeof a.Qa!=kh){if(Pi(a)||Si(a)){var b=[];a=a[J];for(var c=0;c<a;c++)b[B](c);return b}return fk(a)}}
function gl(a,b,c){if(typeof a[Zb]==kh)a[Zb](b,c);else if(Pi(a)||Si(a))X(a,b,c);else for(var d=fl(a),e=el(a),f=e[J],g=0;g<f;g++)b[L](c,e[g],d&&d[g],a)}function Mea(a,b,c){if(typeof a[sb]==kh)return a[sb](b,c);if(Pi(a)||Si(a))return vj(a,b,c);var d,e=fl(a),f=el(a),g=f[J];if(e){d={};for(var k=0;k<g;k++)b[L](c,f[k],e[k],a)&&(d[e[k]]=f[k])}else for(d=[],k=0;k<g;k++)b[L](c,f[k],void 0,a)&&d[B](f[k]);return d}
function Nea(a,b,c){if(typeof a.map==kh)return a.map(b,c);if(Pi(a)||Si(a))return wj(a,b,c);var d,e=fl(a),f=el(a),g=f[J];if(e){d={};for(var k=0;k<g;k++)d[e[k]]=b[L](c,f[k],e[k],a)}else for(d=[],k=0;k<g;k++)d[k]=b[L](c,f[k],void 0,a);return d}function Oea(a,b,c){if(typeof a[ze]==kh)return a[ze](b,c);if(Pi(a)||Si(a))return zj(a,b,c);for(var d=fl(a),e=el(a),f=e[J],g=0;g<f;g++)if(!b[L](c,e[g],d&&d[g],a))return!1;return!0};function hl(a){this.cb=new bl;a&&this.Zy(a)}function il(a){var b=typeof a;return b==Ph&&a||b==kh?Oh+Wi(a):b[mc](0,1)+a}R=hl[K];R.Vb=function(){return this.cb.Vb()};R.add=function(a){this.cb.set(il(a),a)};R.Zy=function(a){a=el(a);for(var b=a[J],c=0;c<b;c++)this.add(a[c])};R.nc=function(a){a=el(a);for(var b=a[J],c=0;c<b;c++)this[Tb](a[c])};ua(R,function(a){return this.cb[Tb](il(a))});va(R,function(){this.cb[bc]()});Va(R,function(){return this.cb[ld]()});Pa(R,function(a){return this.cb.$e(il(a))});
R.lA=function(a){var b=new hl;a=el(a);for(var c=0;c<a[J];c++){var d=a[c];this[Yc](d)&&b.add(d)}return b};R.qm=function(a){var b=this[Jc]();b.nc(a);return b};R.Qa=function(){return this.cb.Qa()};Ia(R,function(){return new hl(this)});ab(R,function(a){return this.Vb()==Lea(a)&&this.oV(a)});R.oV=function(a){var b=Lea(a);if(this.Vb()>b)return!1;!(a instanceof hl)&&5<b&&(a=new hl(a));return Oea(this,function(b){var d=a;return typeof d[Yc]==kh?d[Yc](b):typeof d.PU==kh?d.PU(b):Pi(d)||Si(d)?Dj(d,b):gk(d,b)})};
R.pt=function(){return this.cb.pt(!1)};var ll;t:{var Pea=Fi.navigator;if(Pea){var Qea=Pea[Cc];if(Qea){ll=Qea;break t}}ll=M}function ml(a){return gj(ll,a)};var nl=ml("Opera")||ml("OPR"),ol=ml(vg)||ml(ag),pl=ml("Gecko")&&!gj(ll[He](),"webkit")&&!(ml(vg)||ml(ag)),ql=gj(ll[He](),"webkit"),Rea=ql&&ml("Mobile"),rl=ml("Macintosh"),sl=ml("Windows"),Sea=ml("Linux")||ml("CrOS"),Tea=Fi.navigator||null;Tea&&gj(Tea.appVersion||M,"X11");ml("Android");!ml("iPhone")||ml("iPod")||ml("iPad");ml("iPad");function Uea(){var a=Fi[ce];return a?a[ye]:void 0}
var tl=function(){var a=M,b;if(nl&&Fi.opera)return a=Fi.opera.version,Vi(a)?a():a;pl?b=/rv\:([^\);]+)(\)|;)/:ol?b=/\b(?:MSIE|rv)[: ]([^\);]+)(\)|;)/:ql&&(b=/WebKit\/(\S+)/);b&&(a=(a=b[xb](ll))?a[1]:M);return ol&&(b=Uea(),b>ka(a))?String(b):a}(),Vea={};function ul(a){return Vea[a]||(Vea[a]=0<=lj(tl,a))}function vl(a){return ol&&Wea>=a}var Xea=Fi[ce],Wea=Xea&&ol?Uea()||(Xea[te]==Kf?ja(tl,10):5):void 0;function wl(a,b){Xa(a,Ak(b))};function xl(a,b){this.x=Gi(a)?a:0;this.y=Gi(b)?b:0}R=xl[K];Ia(R,function(){return new xl(this.x,this.y)});function yl(a,b){return a==b?!0:a&&b?a.x==b.x&&a.y==b.y:!1}function zl(a,b){var c=a.x-b.x,d=a.y-b.y;return h[Kd](c*c+d*d)}function Al(a,b){return new xl(a.x-b.x,a.y-b.y)}function Bl(a,b){return new xl(a.x+b.x,a.y+b.y)}qa(R,function(){this.x=h[Cb](this.x);this.y=h[Cb](this.y);return this});ra(R,function(){this.x=h[Eb](this.x);this.y=h[Eb](this.y);return this});
Wa(R,function(){this.x=h[D](this.x);this.y=h[D](this.y);return this});fb(R,function(a,b){a instanceof xl?(this.x+=a.x,this.y+=a.y):(this.x+=a,Ui(b)&&(this.y+=b));return this});Na(R,function(a,b){var c=Ui(b)?b:a;this.x*=a;this.y*=c;return this});function Cl(a,b){na(this,a);Ta(this,b)}function Dl(a,b){return a==b?!0:a&&b?a[r]==b[r]&&a[z]==b[z]:!1}R=Cl[K];Ia(R,function(){return new Cl(this[r],this[z])});function El(a){return h.min(a[r],a[z])}R.area=function(){return this[r]*this[z]};Va(R,function(){return!this.area()});qa(R,function(){na(this,h[Cb](this[r]));Ta(this,h[Cb](this[z]));return this});ra(R,function(){na(this,h[Eb](this[r]));Ta(this,h[Eb](this[z]));return this});Wa(R,function(){na(this,h[D](this[r]));Ta(this,h[D](this[z]));return this});
Na(R,function(a,b){var c=Ui(b)?b:a;na(this,this[r]*a);Ta(this,this[z]*c);return this});var Yea=!ol||vl(9),Zea=!pl&&!ol||ol&&vl(9)||pl&&ul("1.9.1"),$ea=ol&&!ul(wf),afa=ol||nl||ql;function Fl(a){return a?new Gl(Hl(a)):Cda||(Cda=new Gl)}function Il(a){return Si(a)?ea[ud](a):a}function Jl(a,b,c){return Kl(ea,a,b,c)}function Ll(a,b){var c=b||ea;return c[pe]&&c[Ub]?c[pe](mf+a):Kl(ea,ff,a,b)}function Ml(a,b){var c=b||ea,d=null;return(d=c[pe]&&c[Ub]?c[Ub](mf+a):Kl(ea,ff,a,b)[0])||null}
function Kl(a,b,c,d){a=d||a;b=b&&b!=ff?b[De]():M;if(a[pe]&&a[Ub]&&(b||c))return a[pe](b+(c?mf+c:M));if(c&&a[Ed]){a=a[Ed](c);if(b){d={};for(var e=0,f=0,g;g=a[f];f++)b==g[Cd]&&(d[e++]=g);mb(d,e);return d}return a}a=a[kc](b||ff);if(c){d={};for(f=e=0;g=a[f];f++)b=g[ae],typeof b[zc]==kh&&Dj(b[zc](/\s+/),c)&&(d[e++]=g);mb(d,e);return d}return a}function Nl(a,b){Zj(b,function(b,d){d==ji?bb(a[w],b):d==Qba?pb(a,b):d==$ba?a.htmlFor=b:d in bfa?a[v](bfa[d],b):bj(d,Ig)||bj(d,Wba)?a[v](d,b):a[d]=b})}
var bfa={cellpadding:"cellPadding",cellspacing:"cellSpacing",colspan:"colSpan",frameborder:"frameBorder",height:rh,maxlength:"maxLength",role:Zh,rowspan:"rowSpan",type:qi,usemap:"useMap",valign:"vAlign",width:yi};function Ol(a){a=a[ce];a=a[te]==Kf?a[lc]:a[ke];return new Cl(a[be],a[re])}function cfa(a){return ql||a[te]!=Kf?a[ke]||a[lc]:a[lc]}function Pl(a){return a?a.parentWindow||a[Md]:ba}function Ql(a,b,c){return dfa(ea,arguments)}
function dfa(a,b){var c=b[0],d=b[1];if(!Yea&&d&&(d[Nd]||d[H])){c=[Af,c];d[Nd]&&c[B](daa,fj(d[Nd]),Me);if(d[H]){c[B](eaa,fj(d[H]),Me);var e={};pk(e,d);delete e[H];d=e}c[B](Ff);c=c[Fe](M)}c=a[Vb](c);d&&(Si(d)?pb(c,d):Oi(d)?pb(c,d[Fe](Ke)):Nl(c,d));2<b[J]&&efa(a,c,b,2);return c}function efa(a,b,c,d){function e(c){c&&b[q](Si(c)?a[Jb](c):c)}for(;d<c[J];d++){var f=c[d];Pi(f)&&!Rl(f)?X(ffa(f)?Lj(f):f,e):e(f)}}function Sl(a){return ea[Vb](a)}
function Tl(a,b){var c=a[Vb](ch);ol?(Xa(c,Bf+b),c[le](c[Yb])):Xa(c,b);if(1==c[cc][J])c=c[le](c[Yb]);else{for(var d=a.createDocumentFragment();c[Yb];)d[q](c[Yb]);c=d}return c}function Wl(a){if(1!=a[rd])return!1;switch(a[$c]){case xaa:case yaa:case zaa:case If:case Aaa:case Baa:case Faa:case Haa:case Uf:case Naa:case Vf:case Maa:case Oaa:case Raa:case Saa:case Xaa:case Yaa:case Taa:case Zaa:case $aa:case hg:case jg:case dba:case hba:case mba:return!1}return!0}function gfa(a,b){a[q](b)}
function Xl(a,b){efa(Hl(a),a,arguments,1)}function Yl(a){for(var b;b=a[Yb];)a[le](b)}function Zl(a,b){b[Ce]&&b[Ce][Lb](a,b)}function $l(a,b){b[Ce]&&b[Ce][Lb](a,b[ic])}function am(a){return a&&a[Ce]?a[Ce][le](a):null}function bm(a){return Zea&&void 0!=a[Jd]?a[Jd]:vj(a[cc],function(a){return 1==a[rd]})}function cm(a){return void 0!=a.firstElementChild?a.firstElementChild:dm(a[Yb],!0)}function em(a){return void 0!=a.nextElementSibling?a.nextElementSibling:dm(a[ic],!0)}
function dm(a,b){for(;a&&1!=a[rd];)a=b?a[ic]:a[oc];return a}function Rl(a){return Ri(a)&&0<a[rd]}function fm(a){return Ri(a)&&1==a[rd]}function gm(a){var b;if(afa&&!(ol&&ul(wf)&&!ul(uf)&&Fi.SVGElement&&a instanceof Fi.SVGElement)&&(b=a.parentElement))return b;b=a[Ce];return fm(b)?b:null}function hm(a,b){if(a[Yc]&&1==b[rd])return a==b||a[Yc](b);if("undefined"!=typeof a[Ad])return a==b||Boolean(a[Ad](b)&16);for(;b&&a!=b;)b=b[Ce];return b==a}
function hfa(a,b){if(a==b)return 0;if(a[Ad])return a[Ad](b)&2?1:-1;if(ol&&!vl(9)){if(9==a[rd])return-1;if(9==b[rd])return 1}if(Lca in a||a[Ce]&&Lca in a[Ce]){var c=1==a[rd],d=1==b[rd];if(c&&d)return a[wc]-b[wc];var e=a[Ce],f=b[Ce];return e==f?ifa(a,b):!c&&hm(e,b)?-1*jfa(a,b):!d&&hm(f,a)?jfa(b,a):(c?a[wc]:e[wc])-(d?b[wc]:f[wc])}d=Hl(a);c=d[Dd]();c.selectNode(a);c[yb](!0);d=d[Dd]();d.selectNode(b);d[yb](!0);return c.compareBoundaryPoints(Fi[hd].START_TO_END,d)}
function jfa(a,b){var c=a[Ce];if(c==b)return-1;for(var d=b;d[Ce]!=c;)d=d[Ce];return ifa(d,a)}function ifa(a,b){for(var c=b;c=c[oc];)if(c==a)return-1;return 1}function Hl(a){return 9==a[rd]?a:a[Ic]||a[ce]}function im(a,b){if(Rca in a)a.textContent=b;else if(3==a[rd])pa(a,b);else if(a[Yb]&&3==a[Yb][rd]){for(;a[Lc]!=a[Yb];)a[le](a[Lc]);pa(a[Yb],b)}else{Yl(a);var c=Hl(a);a[q](c[Jb](String(b)))}}function kfa(a){if(yca in a)return a.outerHTML;var b=Hl(a)[Vb](ch);b[q](a.cloneNode(!0));return b[vd]}
function lfa(a,b){var c=[];return jm(a,b,c,!0)?c[0]:void 0}function mfa(a,b){var c=[];jm(a,b,c,!1);return c}function jm(a,b,c,d){if(null!=a)for(a=a[Yb];a;){if(b(a)&&(c[B](a),d)||jm(a,b,c,d))return!0;a=a[ic]}return!1}var nfa={SCRIPT:1,STYLE:1,HEAD:1,IFRAME:1,OBJECT:1},ofa={IMG:Ke,BR:Je};function km(a){return pfa(a)&&qfa(a)}function lm(a,b){b?eb(a,0):(eb(a,-1),a[ad](Oca))}function pfa(a){a=a.getAttributeNode(Pca);return null!=a&&a.specified}function qfa(a){a=a.tabIndex;return Ui(a)&&0<=a&&32768>a}
function mm(a){if($ea&&pca in a)a=a[Wd][Ab](/(\r\n|\r|\n)/g,Je);else{var b=[];nm(a,b,!0);a=b[Fe](M)}a=a[Ab](/ \xAD /g,Ke)[Ab](/\xAD/g,M);a=a[Ab](/\u200B/g,M);$ea||(a=a[Ab](/ +/g,Ke));a!=Ke&&(a=a[Ab](/^\s*/,M));return a}function om(a){var b=[];nm(a,b,!1);return b[Fe](M)}function nm(a,b,c){if(!(a[Cd]in nfa))if(3==a[rd])c?b[B](String(a[jd])[Ab](/(\r\n|\r|\n)/g,M)):b[B](a[jd]);else if(a[Cd]in ofa)b[B](ofa[a[Cd]]);else for(a=a[Yb];a;)nm(a,b,c),a=a[ic]}
function ffa(a){if(a&&typeof a[J]==Nh){if(Ri(a))return typeof a[xd]==kh||typeof a[xd]==ii;if(Vi(a))return typeof a[xd]==kh}return!1}function rfa(a){return pm(a,function(a){return a[Cd]==eba&&!0},!0,void 0)}function pm(a,b,c,d){c||(a=a[Ce]);c=null==d;for(var e=0;a&&(c||e<=d);){if(b(a))return a;a=a[Ce];e++}return null}function qm(a){try{return a&&a[ub]}catch(b){}return null}function Gl(a){this.Ze=a||Fi[ce]||ea}R=Gl[K];R.pa=Fl;R.oc=function(){return this.Ze};
R.a=function(a){return Si(a)?this.Ze[ud](a):a};function rm(a,b,c,d){return Kl(a.Ze,b,c,d)}R.nu=function(a,b){return Ml(a,b||this.Ze)};R.h9=function(a,b){return Ml(a,b||this.Ze)};R.Bw=Nl;R.m=function(a,b,c){return dfa(this.Ze,arguments)};R.createElement=function(a){return this.Ze[Vb](a)};R.createTextNode=function(a){return this.Ze[Jb](String(a))};
R.hha=function(a,b,c){var d=this.Ze;c=!!c;for(var e=d[Vb](gba),f=e[q](d[Vb](ng)),g=0;g<a;g++){for(var k=d[Vb](tg),l=0;l<b;l++){var n=d[Vb](og);c&&im(n,Di);k[q](n)}f[q](k)}return e};function sm(a){return a.Ze[te]==Kf}R.lC=function(){var a=this.Ze;return a.parentWindow||a[Md]};function tm(a){var b=a.Ze;a=cfa(b);b=b.parentWindow||b[Md];return ol&&ul(uf)&&b.pageYOffset!=a[Ud]?new xl(a[Tc],a[Ud]):new xl(b.pageXOffset||a[Tc],b.pageYOffset||a[Ud])}R.aG=function(a){return qm(a||this.Ze)};R.appendChild=gfa;
R.append=Xl;R.Oc=Yl;R.R_=Zl;R.eka=$l;R.removeNode=am;R.Vf=bm;R.Cba=cm;function sfa(a){return void 0!=a.lastElementChild?a.lastElementChild:dm(a[Lc],!1)}R.XM=Rl;R.Yma=fm;Pa(R,hm);R.mra=im;R.Kr=function(a){var b;(b=a[$c]==Hf||a[$c]==Vf||a[$c]==pg||a[$c]==ig||a[$c]==Jf?!a[ie]&&(!pfa(a)||qfa(a)):km(a))&&ol?(a=Vi(a[vb])?a[vb]():{height:a[fd],width:a[Gb]},a=null!=a&&0<a[z]&&0<a[r]):a=b;return a};function um(a,b,c,d){this.top=a;Ua(this,b);Ma(this,c);$a(this,d)}R=um[K];R.lb=function(){return this[kd]-this[G]};cb(R,function(){return this[Uc]-this.top});Ia(R,function(){return new um(this.top,this[kd],this[Uc],this[G])});Pa(R,function(a){return this&&a?a instanceof um?a[G]>=this[G]&&a[kd]<=this[kd]&&a.top>=this.top&&a[Uc]<=this[Uc]:a.x>=this[G]&&a.x<=this[kd]&&a.y>=this.top&&a.y<=this[Uc]:!1});
oa(R,function(a,b,c,d){Ri(a)?(this.top-=a.top,Ua(this,this[kd]+a[kd]),Ma(this,this[Uc]+a[Uc]),$a(this,this[G]-a[G])):(this.top-=a,Ua(this,this[kd]+b),Ma(this,this[Uc]+c),$a(this,this[G]-d));return this});function vm(a,b){$a(a,h.min(a[G],b[G]));a.top=h.min(a.top,b.top);Ua(a,h.max(a[kd],b[kd]));Ma(a,h.max(a[Uc],b[Uc]))}function wm(a,b){return a[G]<=b[kd]&&b[G]<=a[kd]&&a.top<=b[Uc]&&b.top<=a[Uc]}
qa(R,function(){this.top=h[Cb](this.top);Ua(this,h[Cb](this[kd]));Ma(this,h[Cb](this[Uc]));$a(this,h[Cb](this[G]));return this});ra(R,function(){this.top=h[Eb](this.top);Ua(this,h[Eb](this[kd]));Ma(this,h[Eb](this[Uc]));$a(this,h[Eb](this[G]));return this});Wa(R,function(){this.top=h[D](this.top);Ua(this,h[D](this[kd]));Ma(this,h[D](this[Uc]));$a(this,h[D](this[G]));return this});
fb(R,function(a,b){a instanceof xl?($a(this,this[G]+a.x),Ua(this,this[kd]+a.x),this.top+=a.y,Ma(this,this[Uc]+a.y)):($a(this,this[G]+a),Ua(this,this[kd]+a),Ui(b)&&(this.top+=b,Ma(this,this[Uc]+b)));return this});Na(R,function(a,b){var c=Ui(b)?b:a;$a(this,this[G]*a);Ua(this,this[kd]*a);this.top*=c;Ma(this,this[Uc]*c);return this});function xm(a,b,c,d){$a(this,a);this.top=b;na(this,c);Ta(this,d)}R=xm[K];Ia(R,function(){return new xm(this[G],this.top,this[r],this[z])});function ym(a){return new um(a.top,a[G]+a[r],a.top+a[z],a[G])}function zm(a){return new xm(a[G],a.top,a[kd]-a[G],a[Uc]-a.top)}function Am(a,b){return a==b?!0:a&&b?a[G]==b[G]&&a[r]==b[r]&&a.top==b.top&&a[z]==b[z]:!1}
R.lA=function(a){var b=h.max(this[G],a[G]),c=h.min(this[G]+this[r],a[G]+a[r]);if(b<=c){var d=h.max(this.top,a.top);a=h.min(this.top+this[z],a.top+a[z]);if(d<=a)return $a(this,b),this.top=d,na(this,c-b),Ta(this,a-d),!0}return!1};function tfa(a,b){var c=h.max(a[G],b[G]),d=h.min(a[G]+a[r],b[G]+b[r]);if(c<=d){var e=h.max(a.top,b.top),f=h.min(a.top+a[z],b.top+b[z]);if(e<=f)return new xm(c,e,d-c,f-e)}return null}
R.qm=function(a){var b=tfa(this,a);if(b&&b[z]&&b[r]){var b=[],c=this.top,d=this[z],e=this[G]+this[r],f=this.top+this[z],g=a[G]+a[r],k=a.top+a[z];a.top>this.top&&(b[B](new xm(this[G],this.top,this[r],a.top-this.top)),c=a.top,d-=a.top-this.top);k<f&&(b[B](new xm(this[G],k,this[r],f-k)),d=k-c);a[G]>this[G]&&b[B](new xm(this[G],c,a[G]-this[G],d));g<e&&b[B](new xm(g,c,e-g,d));a=b}else a=[this[Jc]()];return a};
Pa(R,function(a){return a instanceof xm?this[G]<=a[G]&&this[G]+this[r]>=a[G]+a[r]&&this.top<=a.top&&this.top+this[z]>=a.top+a[z]:a.x>=this[G]&&a.x<=this[G]+this[r]&&a.y>=this.top&&a.y<=this.top+this[z]});function ufa(a,b){var c=b.x<a[G]?a[G]-b.x:h.max(b.x-(a[G]+a[r]),0),d=b.y<a.top?a.top-b.y:h.max(b.y-(a.top+a[z]),0);return c*c+d*d}R.distance=function(a){return h[Kd](ufa(this,a))};R.Tb=function(){return new Cl(this[r],this[z])};
R.getCenter=function(){return new xl(this[G]+this[r]/2,this.top+this[z]/2)};qa(R,function(){$a(this,h[Cb](this[G]));this.top=h[Cb](this.top);na(this,h[Cb](this[r]));Ta(this,h[Cb](this[z]));return this});ra(R,function(){$a(this,h[Eb](this[G]));this.top=h[Eb](this.top);na(this,h[Eb](this[r]));Ta(this,h[Eb](this[z]));return this});Wa(R,function(){$a(this,h[D](this[G]));this.top=h[D](this.top);na(this,h[D](this[r]));Ta(this,h[D](this[z]));return this});
fb(R,function(a,b){a instanceof xl?($a(this,this[G]+a.x),this.top+=a.y):($a(this,this[G]+a),Ui(b)&&(this.top+=b));return this});Na(R,function(a,b){var c=Ui(b)?b:a;$a(this,this[G]*a);na(this,this[r]*a);this.top*=c;Ta(this,this[z]*c);return this});function Bm(a,b,c){if(Si(b))(b=Cm(a,b))&&(a[w][b]=c);else for(var d in b){c=a;var e=b[d],f=Cm(c,d);f&&(c[w][f]=e)}}var vfa={};function Cm(a,b){var c=vfa[b];if(!c){var d=pj(b),c=d;void 0===a[w][d]&&(d=(ql?oba:pl?Vaa:ol?sca:nl?dg:null)+Sda(d),void 0!==a[w][d]&&(c=d));vfa[b]=c}return c}function wfa(a,b){var c=a[w][pj(b)];return"undefined"!==typeof c?c:a[w][Cm(a,b)]||M}
function Fm(a,b){var c=Hl(a);return c[Md]&&c[Md].getComputedStyle&&(c=c[Md].getComputedStyle(a,null))?c[b]||c.getPropertyValue(b)||M:M}function Gm(a,b){return Fm(a,b)||(a[ve]?a[ve][b]:null)||a[w]&&a[w][b]}function Hm(a){return Gm(a,Uh)}function Im(a,b,c){var d;b instanceof xl?(d=b.x,b=b.y):(d=b,b=c);$a(a[w],Jm(d,!1));a[w].top=Jm(b,!1)}function Km(a){return new xl(a[je],a[ed])}function Lm(a){a=a?Hl(a):ea;return!ol||vl(9)||sm(Fl(a))?a[lc]:a[ke]}
function Mm(a){var b;try{b=a[vb]()}catch(c){return{left:0,top:0,right:0,bottom:0}}ol&&a[Ic][ke]&&(a=a[Ic],$a(b,b[G]-(a[lc][$b]+a[ke][$b])),b.top-=a[lc][ac]+a[ke][ac]);return b}function xfa(a){if(ol&&!vl(8))return a[Ac];var b=Hl(a),c=Gm(a,Uh),d=c==hh||c==Fg;for(a=a[Ce];a&&a!=b;a=a[Ce])if(c=Gm(a,Uh),d=d&&c==hi&&a!=b[lc]&&a!=b[ke],!d&&(a[Oc]>a[be]||a[Wb]>a[re]||c==hh||c==Fg||c==Xh))return a;return null}
function Nm(a){for(var b=new um(0,da,da,0),c=Fl(a),d=c.oc()[ke],e=c.oc()[lc],f=cfa(c.Ze);a=xfa(a);)if(!(ol&&0==a[be]||ql&&0==a[re]&&a==d)&&a!=d&&a!=e&&Gm(a,Sh)!=vi){var g=Om(a),k=new xl(a[$b],a[ac]);g.x+=k.x;g.y+=k.y;b.top=h.max(b.top,g.y);Ua(b,h.min(b[kd],g.x+a[be]));Ma(b,h.min(b[Uc],g.y+a[re]));$a(b,h.max(b[G],g.x))}d=f[Tc];f=f[Ud];$a(b,h.max(b[G],d));b.top=h.max(b.top,f);c=c.lC();c=Ol(c||ba);Ua(b,h.min(b[kd],d+c[r]));Ma(b,h.min(b[Uc],f+c[z]));return 0<=b.top&&0<=b[G]&&b[Uc]>b.top&&b[kd]>b[G]?b:
null}function Om(a){var b=Hl(a);Gm(a,Uh);var c=new xl(0,0),d=Lm(b);if(a==d)return c;a=Mm(a);b=tm(Fl(b));c.x=a[G]+b.x;c.y=a.top+b.y;return c}function Pm(a,b){var c=Qm(a),d=Qm(b);return new xl(c.x-d.x,c.y-d.y)}function yfa(a){a=Mm(a);return new xl(a[G],a.top)}function Qm(a){if(1==a[rd])return yfa(a);var b=Vi(a.wua),c=a;a[Nb]&&a[Nb][J]?c=a[Nb][0]:b&&a.Aa[Nb]&&a.Aa[Nb][J]&&(c=a.Aa[Nb][0]);return new xl(c[Qd],c[Rd])}
function Rm(a,b,c){if(b instanceof Cl)c=b[z],b=b[r];else if(void 0==c)throw m("missing height argument");Sm(a,b);Ta(a[w],Jm(c,!0))}function Jm(a,b){typeof a==Nh&&(a=(b?h[D](a):a)+P);return a}function Sm(a,b){na(a[w],Jm(b,!0))}function Tm(a){return Um(a)}function Um(a){var b=zfa;if(Gm(a,bh)!=O)return b(a);var c=a[w],d=c[cd],e=c.visibility,f=c[tc];kb(c,sh);Ba(c,Fg);Qa(c,zh);a=b(a);Qa(c,d);Ba(c,f);kb(c,e);return a}
function zfa(a){var b=a[Gb],c=a[fd],d=ql&&!b&&!c;return Gi(b)&&!d||!a[vb]?new Cl(b,c):(a=Mm(a),new Cl(a[kd]-a[G],a[Uc]-a.top))}function Vm(a){var b=Om(a);a=Um(a);return new xm(b.x,b.y,a[r],a[z])}function Afa(a,b){var c=a[w];Rh in c?qb(c,b):Waa in c?c.MozOpacity=b:gh in c&&(c.filter=b===M?M:Cba+100*b+ef)}function Wm(a,b){Qa(a[w],b?M:O)}
function Xm(a){var b=Fl(void 0),c=null,c=b.oc();if(ol&&c.createStyleSheet)b=c=c.createStyleSheet(),ol&&Gi(b.cssText)?bb(b,a):Xa(b,a);else{var d=rm(b,oh)[0];d||(c=rm(b,Pg)[0],d=b.m(oh),c[Ce][Lb](d,c));var e=c=b.m(ji);ol&&Gi(e.cssText)?bb(e,a):Xa(e,a);b[q](d,c)}return c}function Ym(a){return $h==Gm(a,ah)}var Zm=pl?"MozUserSelect":ql?"WebkitUserSelect":null;
function $m(a,b,c){c=c?null:a[kc](ff);if(Zm){if(b=b?O:M,a[w][Zm]=b,c){a=0;for(var d;d=c[a];a++)d[w][Zm]=b}}else if(ol||nl)if(b=b?Qh:M,a[v](ri,b),c)for(a=0;d=c[a];a++)d[v](ri,b)}function an(a){var b=Hl(a),c=ol&&a[ve];if(c&&sm(Fl(b))&&c[r]!=Mg&&c[z]!=Mg&&!c.boxSizing)return b=bn(a,c[r],yi,Fca),a=bn(a,c[z],rh,Dca),new Cl(b,a);c=new Cl(a[Gb],a[fd]);b=cn(a);a=dn(a);return new Cl(c[r]-a[G]-b[G]-b[kd]-a[kd],c[z]-a.top-b.top-b[Uc]-a[Uc])}
function bn(a,b,c,d){if(/^\d+px?$/[od](b))return ja(b,10);var e=a[w][c],f=a.runtimeStyle[c];a.runtimeStyle[c]=a[ve][c];a[w][c]=b;b=a[w][d];a[w][c]=e;a.runtimeStyle[c]=f;return b}function en(a,b){var c=a[ve]?a[ve][b]:null;return c?bn(a,c,Ch,Eca):0}function cn(a){if(ol){var b=en(a,Aca),c=en(a,Bca),d=en(a,Cca);a=en(a,zca);return new um(d,c,a,b)}b=Fm(a,Aca);c=Fm(a,Bca);d=Fm(a,Cca);a=Fm(a,zca);return new um(ka(d),ka(c),ka(a),ka(b))}var Bfa={thin:2,medium:4,thick:6};
function fn(a,b){if((a[ve]?a[ve][b+fba]:null)==O)return 0;var c=a[ve]?a[ve][b+pba]:null;return c in Bfa?Bfa[c]:bn(a,c,Ch,Eca)}function dn(a){if(ol&&!vl(9)){var b=fn(a,Iba),c=fn(a,Kba),d=fn(a,Mba);a=fn(a,Gba);return new um(d,c,a,b)}b=Fm(a,Jba);c=Fm(a,Lba);d=Fm(a,Nba);a=Fm(a,Hba);return new um(ka(d),ka(c),ka(a),ka(b))}function gn(a){var b={};X(a[zc](/\s*;\s*/),function(a){a=a[zc](/\s*:\s*/);2==a[J]&&(b[pj(a[0][He]())]=a[1])});return b};var Cfa=/^(?:([^:/?#.]+):)?(?:\/\/(?:([^/?#]*)@)?([^/#?]*?)(?::([0-9]+))?(?=[/#?]|$))?([^?#]+)?(?:\?([^#]*))?(?:#(.*))?$/;function hn(a){if(jn){jn=!1;var b=Fi[Fc];if(b){var c=b[Vc];if(c&&(c=kn(ln(3,c)))&&c!=b.hostname)throw jn=!0,m();}}return a[Pb](Cfa)}var jn=ql;function kn(a){return a?decodeURI(a):a}function ln(a,b){return hn(b)[a]||null}
function Dfa(a,b){for(var c=a[zc](We),d=0;d<c[J];d++){var e=c[d][zd](Df),f=null,g=null;0<=e?(f=c[d][we](0,e),g=c[d][we](e+1)):f=c[d];b(f,g?ma(g[Ab](/\+/g,Ke)):M)}}function mn(a,b,c,d){for(var e=c[J];0<=(b=a[zd](c,b))&&b<d;){var f=a[se](b-1);if(38==f||63==f)if(f=a[se](b+e),!f||61==f||38==f||35==f)return b;b+=e+1}return-1}var nn=/#|$/;function on(a,b){var c=a[Kc](nn),d=mn(a,0,b,c);if(0>d)return null;var e=a[zd](We,d);if(0>e||e>c)e=c;d+=b[J]+1;return ma(a[mc](d,e-d)[Ab](/\+/g,Ke))}var Efa=/[?&]($|#)/;
function pn(a,b){for(var c=a[Kc](nn),d=0,e,f=[];0<=(e=mn(a,d,b,c));)f[B](a[we](d,e)),d=h.min(a[zd](We,e)+1||c,c);f[B](a[mc](d));return f[Fe](M)[Ab](Efa,Ue)}function qn(a,b,c){a=[pn(a,b),We,b];null!=c&&a[B](Df,aa(String(c)));a[1]&&(c=a[0],b=c[zd](Oe),0<=b&&(a[B](c[mc](b)),a[0]=c=c[mc](0,b)),b=c[zd](Gf),0>b?a[1]=Gf:b==c[J]-1&&(a[1]=void 0));return a[Fe](M)};var rn={aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:Pe,blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkgrey:"#a9a9a9",
darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkslategrey:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dimgrey:"#696969",dodgerblue:"#1e90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",
gold:"#ffd700",goldenrod:"#daa520",gray:Qe,green:"#008000",greenyellow:"#adff2f",grey:Qe,honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgray:"#d3d3d3",lightgreen:"#90ee90",lightgrey:"#d3d3d3",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",
lightslategray:"#778899",lightslategrey:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370db",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",
navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#db7093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",red:"#ff0000",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",
silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",slategrey:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:Se,whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32"};function sn(a){var b={};a=String(a);var c=a[Ib](0)==Oe?a:Oe+a;if(tn[od](c))return b.sc=un(c),db(b,oca),b;c=Ffa(a);if(c[J])return b.sc=vn(c),db(b,Yh),b;if(rn&&(c=rn[a[He]()]))return b.sc=c,db(b,tca),b;throw m(a+" is not a valid color string");}function wn(a){return!!(tn[od](a[Ib](0)==Oe?a:Oe+a)||Ffa(a)[J]||rn&&rn[a[He]()])}var Gfa=/#(.)(.)(.)/;function un(a){if(!tn[od](a))throw m(cf+a+"' is not a valid hex color");4==a[J]&&(a=a[Ab](Gfa,faa));return a[He]()}
function xn(a){a=un(a);return[ja(a[mc](1,2),16),ja(a[mc](3,2),16),ja(a[mc](5,2),16)]}function yn(a,b,c){a=ha(a);b=ha(b);c=ha(c);if(fa(a)||0>a||255<a||fa(b)||0>b||255<b||fa(c)||0>c||255<c)throw m('"('+a+jf+b+jf+c+'") is not a valid RGB color');a=zn(a[qc](16));b=zn(b[qc](16));c=zn(c[qc](16));return Oe+a+b+c}function vn(a){return yn(a[0],a[1],a[2])}
function Hfa(a,b,c){a/=255;b/=255;c/=255;var d=h.max(a,b,c),e=h.min(a,b,c),f=0,g=0,k=.5*(d+e);d!=e&&(d==a?f=60*(b-c)/(d-e):d==b?f=60*(c-a)/(d-e)+120:d==c&&(f=60*(a-b)/(d-e)+240),g=0<k&&.5>=k?(d-e)/(2*k):(d-e)/(2-2*k));return[h[D](f+360)%360,g,k]}function An(a,b,c){0>c?c+=1:1<c&&--c;return 1>6*c?a+6*(b-a)*c:1>2*c?b:2>3*c?a+(b-a)*(2/3-c)*6:a}
function Ifa(a,b,c){var d=0,e=0,f=0;a/=360;if(0==b)d=e=f=255*c;else var g=f=0,g=.5>c?c*(1+b):c+b-b*c,f=2*c-g,d=255*An(f,g,a+1/3),e=255*An(f,g,a),f=255*An(f,g,a-1/3);return[h[D](d),h[D](e),h[D](f)]}var tn=/^#(?:[0-9a-f]{3}){1,2}$/i,Jfa=/^(?:rgb)?\((0|[1-9]\d{0,2}),\s?(0|[1-9]\d{0,2}),\s?(0|[1-9]\d{0,2})\)$/i;function Ffa(a){var b=a[Pb](Jfa);if(b){a=ha(b[1]);var c=ha(b[2]),b=ha(b[3]);if(0<=a&&255>=a&&0<=c&&255>=c&&0<=b&&255>=b)return[a,c,b]}return[]}function zn(a){return 1==a[J]?pf+a:a}
function Bn(a,b,c){c=Lk(c,0,1);return[h[D](c*a[0]+(1-c)*b[0]),h[D](c*a[1]+(1-c)*b[1]),h[D](c*a[2]+(1-c)*b[2])]}function Cn(a,b){return Bn([0,0,0],a,b)}function Dn(a,b){return Bn([255,255,255],a,b)}function En(a,b){for(var c=[],d=0;d<b[J];d++)c[B]({color:b[d],zh:Kfa(b[d],a)+Lfa(b[d],a)});c[ue](function(a,b){return b.zh-a.zh});return c[0][F]}function Kfa(a,b){return h.abs(h[D]((299*a[0]+587*a[1]+114*a[2])/1E3)-h[D]((299*b[0]+587*b[1]+114*b[2])/1E3))}
function Lfa(a,b){return h.abs(a[0]-b[0])+h.abs(a[1]-b[1])+h.abs(a[2]-b[2])};function Fn(a){a=String(a);if(/^\s*$/[od](a)?0:/^[\],:{}\s\u2028\u2029]*$/[od](a[Ab](/\\["\\\/bfnrtu]/g,waa)[Ab](/"[^"\\\n\r\u2028\u2029\x00-\x08\x0a-\x1f]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,Cg)[Ab](/(?:^|:|,)(?:[\s\u2028\u2029]*\[)+/g,M)))try{return eval(df+a+ef)}catch(b){}throw m("Invalid JSON string: "+a);}function Mfa(a){return eval(df+a+ef)}function Gn(a,b){return(new Nfa(b)).qg(a)}function Nfa(a){this.JV=a}Nfa[K].qg=function(a){var b=[];Hn(this,a,b);return b[Fe](M)};
function Hn(a,b,c){switch(typeof b){case ii:Ofa(b,c);break;case Nh:c[B](la(b)&&!fa(b)?b:Mh);break;case Qg:c[B](b);break;case "undefined":c[B](Mh);break;case Ph:if(null==b){c[B](Mh);break}if(Oi(b)){var d=b[J];c[B](qba);for(var e=M,f=0;f<d;f++)c[B](e),e=b[f],Hn(a,a.JV?a.JV[L](b,String(f),e):e,c),e=jf;c[B](Cg);break}c[B](Bi);d=M;for(f in b)ca[K][Hc][L](b,f)&&(e=b[f],typeof e!=kh&&(c[B](d),Ofa(f,c),c[B](xf),Hn(a,a.JV?a.JV[L](b,f,e):e,c),d=jf));c[B](Ci);break;case kh:break;default:throw m("Unknown type: "+
typeof b);}}var In={'"':'\\"',"\\":Ag,"/":"\\/","\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t","\x0B":"\\u000b"},Pfa=/\uffff/[od]("\uffff")?/[\\\"\x00-\x1f\x7f-\uffff]/g:/[\\\"\x00-\x1f\x7f-\xff]/g;function Ofa(a,b){b[B](Me,a[Ab](Pfa,function(a){if(a in In)return In[a];var b=a[se](0),e=wba;16>b?e+=sf:256>b?e+=paa:4096>b&&(e+=pf);return In[a]=e+b[qc](16)}),Me)};var Jn=Fi[yd]&&Fi[yd][Pd]||Fn,Kn=Fi[yd]&&Fi[yd][nd]||Gn;function Ln(a){return Gn(Mn(a,Nn))}function On(a){Fn(a);return Qfa(a)}function Qfa(a){a=Xn(a);return eval(df+a+ef)}function Mn(a,b){a=b(a);var c=Li(a);if(c==Ph||c==Lg){var c=c==Lg?[]:{},d;for(d in a)if(!gj(d,zba)&&a[Hc](d)){var e=Mn(a[d],b);Gi(e)&&(c[d]=e)}}else c=a;return c}function Xn(a){return a[Ab](/"(Date\([\d,\s]*\))"/g,function(a,c){return xca+c})}
function Nn(a){Qi(a)&&(a=0!==a[ge]()?[a[Rc](),a[Vd](),a[Kb](),a[gc](),a[bd](),a[de](),a[ge]()]:0!==a[de]()||0!==a[bd]()||0!==a[gc]()?[a[Rc](),a[Vd](),a[Kb](),a[gc](),a[bd](),a[de]()]:[a[Rc](),a[Vd](),a[Kb]()],a=Eaa+a[Fe](kf)+ef);return a};function Yn(a,b){Ja(this,a<b?a:b);this.end=a<b?b:a}Ia(Yn[K],function(){return new Yn(this[y],this.end)});Yn[K].getLength=function(){return this.end-this[y]};function Zn(a,b){Ja(a,h.min(a[y],b));a.end=h.max(a.end,b)}function $n(a,b){return h.max(a[y],b[y])<=h.min(a.end,b.end)}function ao(a,b){return a[y]<=b&&a.end>=b};function bo(a,b){a&&(a.logicalname=b)}function Rfa(a){return(a=pm(a,function(a){return null!=a.logicalname},!0))?a.logicalname:Dg};function co(a){return a==O||a==M||a==oi?O:sn(a).sc}function eo(a){if(a==O)return O;a=xn(a);a=h[D]((a[0]+a[1]+a[2])/3);return yn(a,a,a)}function Sfa(a){a=mk(a);null==a[Xd]&&lb(a,!0);return a}function Tfa(a,b){var c=a.m(b[Nd],b[tb]);a.Bw(c,{style:b[w]});if(null!=b[Fb]){var d=Oi(b[Fb])?b[Fb]:[b[Fb]];X(d,function(b){if(Si(b))a[q](c,a[Jb](b));else b=Si(b[Fb])&&b.Goa?Tl(a.Ze,b[Fb]):Tfa(a,b),a[q](c,b)})}null!=b.id&&bo(c,b.id);return c};function fo(a,b){a=a||{};if(2==arguments[J]){var c=arguments[1],d;for(d in c)if(Oi(c[d]))a[d]=Lj(c[d]);else if(typeof a[d]===Ph&&null!=a[d])a[d]=fo(a[d],c[d]);else if(typeof c[d]===Ph&&null!=c[d])a[d]=fo({},c[d]);else if(null==a[d]||null!=c[d])a[d]=c[d]}else if(2<arguments[J])for(c=1,d=arguments[J];c<d;c++)a=fo(a,arguments[c]);return a}function go(a,b,c){return a&&a!=O?b&&b!=O?vn(Bn(xn(a),xn(b),c)):a:b}
function ho(a,b){if(null==b)return a;var c=new Yn(b,b);return a?new Yn(h.min(a[y],c[y]),h.max(a.end,c.end)):c}function Ufa(a,b,c){var d=null!=b?b:a&&null!=c&&c<a[y]?c:a?a[y]:null;a=null!=c?c:a&&null!=b&&b>a.end?b:a?a.end:null;return null!=d&&null!=a?new Yn(d,a):null}function io(a){if(0==a[J])return null;for(var b=a[0][Jc](),c=1;c<a[J];c++)vm(b,a[c]);return b}
function jo(a,b){var c=Oj(a,b);if(0<=c)return b;c=-(c+1);if(0==c)return a[0];if(c==a[J])return qj(a);var d=a[c-1],c=a[c];return h.abs(b-d)<=h.abs(b-c)?d:c};function ko(a,b,c){this.wd=a;this.Wk=co(b);this.Xy=co(null!=c?c:Se)}R=ko[K];R.getStyle=function(){return this.wd};R.ge=function(){return this.Wk};R.getBackgroundColor=function(){return this.Xy};Ia(R,function(){return new ko(this.wd,this.Wk,this.Xy)});R.VH=function(){return new ko(this.wd,eo(this.Wk),eo(this.Xy))};function lo(a){a=a||{};this.uD=O;null!=a[nc]&&this.Ne(a[nc]);this.Oe=1;null!=a[Yd]&&this.Eg(a[Yd]);this.pe=O;null!=a[ec]&&this.ld(a[ec]);this.Lb=1;null!=a[Od]&&this.mk(a[Od]);this.pi=1;null!=a[pc]&&mo(this,a[pc]);this.wl=fi;null!=a.wR&&(this.wl=a.wR);this.mJ=null!=a.Hi?a.Hi:null;this.nJ=null!=a.Ii?a.Ii:null;this.Jg=null;a[rc]&&(this.Jg=mk(a[rc]),this.Jg.kg=co(this.Jg.kg),this.Jg.Nf=co(this.Jg.Nf));this.ud=null;a[zb]&&(this.ud=a[zb]);this.faa=null}R=lo[K];
nb(R,function(){return{fill:this.fb(),fillOpacity:this.Oe,stroke:this.pe,strokeWidth:this.Lb,strokeOpacity:this.pi,wR:this.wl,Hi:this.mJ,Ii:this.nJ,gradient:nk(this.Jg),pattern:nk(this.ud)}});
Ca(R,function(){var a=this.Jg||null;a&&(a={color1:a.kg,color2:a.Nf,opacity1:a.or,opacity2:a.pr,x1:a.x1,y1:a.y1,x2:a.Fb,y2:a.Kb,useObjectBoundingBoxUnits:a.nr,sharpTransition:a.vF});var b=this.ud||null;b&&(b={style:b[gd](),color:b.ge(),bgcolor:b[xe]()});return Kn({fill:this.fb(),fillOpacity:this.Oe,stroke:this.pe,strokeWidth:this.Lb,strokeOpacity:this.pi,strokeDashStyle:this.wl,rx:this.mJ,ry:this.nJ,gradient:a,pattern:b})});Ia(R,function(){return new lo(this[$d]())});
R.VH=function(){var a=this[Jc]();a.Ne(eo(this.uD));a.ld(eo(this.pe));if(this.Jg){var b=mk(this.Jg);b.kg=eo(this.Jg.kg);b.Nf=eo(this.Jg.Nf);a.gradient=b}this.ud&&(b=this.ud.VH(),a.ud=b);return a};function Vfa(a){return null==a||a==O}R.Ne=function(a){this.uD=co(a)};R.fb=function(){return this.uD};R.Eg=function(a){this.Oe=Lk(a,0,1)};R.ld=function(a,b){this.pe=co(a);null!=b&&this.mk(b)};R.bea=function(){return this.pe};R.mk=function(a){this.Lb=a};function no(a){return oo(a)?a.Lb:0}
function mo(a,b){a.pi=Lk(b,0,1)}R.getShadow=function(){return this.faa};function po(a){return 0<a.Oe&&(!Vfa(a.uD)||null!=a.Jg||null!=a.ud)}function oo(a){return 0<a.Lb&&0<a.pi&&!Vfa(a.pe)}function qo(a){return po(a)&&1<=a.Oe}var ro=new lo({fillOpacity:0,fill:xi,strokeOpacity:0,stroke:xi});function so(a,b){return new lo({stroke:O,fill:a,fillOpacity:null!=b?b:1})}function to(a,b,c,d){return new lo({stroke:a,strokeWidth:b,strokeOpacity:null!=d?d:1,fill:null!=c&&c?Re:O})}
function Wfa(a,b){var c;if(a===b)c=!0;else if(null==a||null==b)c=!1;else{if(c=a.uD==b.uD&&a.Oe==b.Oe&&a.pe==b.pe&&a.Lb==b.Lb&&a.pi==b.pi&&a.wl==b.wl&&a.mJ==b.mJ&&a.nJ==b.nJ){c=a[rc];var d=b[rc];c=c===d?!0:null==c||null==d?!1:c.kg==d.kg&&c.Nf==d.Nf&&c.x1==d.x1&&c.y1==d.y1&&c.Fb==d.Fb&&c.Kb==d.Kb&&c.nr===d.nr}c&&(c=a.ud,d=b.ud,c=c===d?!0:null==c||null==d?!1:c.Xy==d.Xy&&c.Wk==d.Wk&&c.wd==d.wd)}return c};var uo,vo="Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec".split(" "),Xfa=["Sunday","Monday","Tuesday",xg,ug,"Friday",kg];
uo={ERAS:["BC","AD"],ERANAMES:["Before Christ","Anno Domini"],NARROWMONTHS:["J",Rf,Xf,Hf,Xf,"J","J",Hf,gg,dg,bg,"D"],STANDALONENARROWMONTHS:["J",Rf,Xf,Hf,Xf,"J","J",Hf,gg,dg,bg,"D"],MONTHS:["January",Sf,"March","April","May","June","July","August",lg,"October",cg,Of],STANDALONEMONTHS:["January",Sf,"March","April","May","June","July","August",lg,"October",cg,Of],SHORTMONTHS:"Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec".split(" "),STANDALONESHORTMONTHS:"Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec".split(" "),
WEEKDAYS:["Sunday","Monday","Tuesday",xg,ug,"Friday",kg],STANDALONEWEEKDAYS:["Sunday","Monday","Tuesday",xg,ug,"Friday",kg],SHORTWEEKDAYS:"Sun Mon Tue Wed Thu Fri Sat".split(" "),STANDALONESHORTWEEKDAYS:"Sun Mon Tue Wed Thu Fri Sat".split(" "),NARROWWEEKDAYS:[gg,Xf,mg,wg,mg,Rf,gg],STANDALONENARROWWEEKDAYS:[gg,Xf,mg,wg,mg,Rf,gg],SHORTQUARTERS:["Q1","Q2","Q3","Q4"],QUARTERS:["1st quarter","2nd quarter","3rd quarter","4th quarter"],AMPMS:["AM","PM"],DATEFORMATS:["EEEE, MMMM d, y","MMMM d, y","MMM d, y",
"M/d/yy"],TIMEFORMATS:["h:mm:ss a zzzz","h:mm:ss a z","h:mm:ss a",nh],DATETIMEFORMATS:["{1} 'at' {0}","{1} 'at' {0}","{1}, {0}","{1}, {0}"],FIRSTDAYOFWEEK:6,WEEKENDRANGE:[5,6],FIRSTWEEKCUTOFFDAY:5};function wo(a,b){switch(b){case 1:return 0!=a%4||0==a%100&&0!=a%400?28:29;case 5:case 8:case 10:case 3:return 30}return 31}function Yfa(a,b){var c=b||new Date(Zi());return a[Rc]()==c[Rc]()}function xo(a,b,c){Ui(a)?(this.vb=Zfa(a,b||0,c||1),yo(this,c||1)):Ri(a)?(this.vb=Zfa(a[Rc](),a[Vd](),a[Kb]()),yo(this,a[Kb]())):(this.vb=new Date(Zi()),this.vb.setHours(0),this.vb.setMinutes(0),this.vb.setSeconds(0),this.vb.setMilliseconds(0))}
function Zfa(a,b,c){b=new Date(a,b,c);0<=a&&100>a&&b[Hd](b[Rc]()-1900);return b}R=xo[K];R.Qfa=uo.FIRSTDAYOFWEEK;R.Rfa=uo.FIRSTWEEKCUTOFFDAY;Ia(R,function(){var a=new xo(this.vb);a.Qfa=this.Qfa;a.Rfa=this.Rfa;return a});R.getFullYear=function(){return this.vb[Rc]()};R.getYear=function(){return this[Rc]()};R.getMonth=function(){return this.vb[Vd]()};R.getDate=function(){return this.vb[Kb]()};ya(R,function(){return this.vb[jc]()});R.getDay=function(){return this.vb[vc]()};R.getUTCFullYear=function(){return this.vb[Qb]()};
R.getUTCMonth=function(){return this.vb[Mc]()};R.getUTCDate=function(){return this.vb[ee]()};R.getUTCHours=function(){return this.vb[Be]()};R.getUTCMinutes=function(){return this.vb[Ae]()};R.getTimezoneOffset=function(){return this.vb[Ie]()};R.set=function(a){this.vb=new Date(a[Rc](),a[Vd](),a[Kb]())};R.setFullYear=function(a){this.vb[Hd](a)};R.setMonth=function(a){this.vb[Fd](a)};R.setDate=function(a){this.vb[Td](a)};R.setTime=function(a){this.vb[Wc](a)};R.setUTCFullYear=function(a){this.vb.setUTCFullYear(a)};
R.setUTCMonth=function(a){this.vb[qe](a)};R.setUTCDate=function(a){this.vb.setUTCDate(a)};R.add=function(a){if(a.years||a.months){var b=this[Vd]()+a.months+12*a.years,c=this[Nc]()+h[Eb](b/12),b=b%12;0>b&&(b+=12);var d=h.min(wo(c,b),this[Kb]());this[Td](1);this[Hd](c);this[Fd](b);this[Td](d)}a.days&&(a=new Date((new Date(this[Nc](),this[Vd](),this[Kb](),12))[jc]()+864E5*a.days),this[Td](1),this[Hd](a[Rc]()),this[Fd](a[Vd]()),this[Td](a[Kb]()),yo(this,a[Kb]()))};
R.bya=function(){return[this[Rc](),jj(this[Vd]()+1,2),jj(this[Kb](),2)][Fe](M)+M};ab(R,function(a){return!(!a||this[Nc]()!=a[Nc]()||this[Vd]()!=a[Vd]()||this[Kb]()!=a[Kb]())});Aa(R,function(){return this.bya()});function yo(a,b){a[Kb]()!=b&&a.vb.setUTCHours(a.vb[Be]()+(a[Kb]()<b?1:-1))}R.valueOf=function(){return this.vb[md]()};function zo(a,b){return a[jc]()-b[jc]()};function Ao(a,b){var c=b||$fa;return function(){var b=this||Fi,b=b.closure_memoize_cache_||(b.closure_memoize_cache_={}),e=c(Wi(a),arguments);return b[Hc](e)?b[e]:b[e]=a[Zc](this,arguments)}}function $fa(a,b){for(var c=[a],d=b[J]-1;0<=d;--d)c[B](typeof b[d],b[d]);return c[Fe](baa)};function Bo(a,b){if(null==a&&null==b)return a===b;if(a===b)return!0;var c=Li(a),d=Li(b);if(c!=d)return!1;var d=Qi(a),e=Qi(b);if(d!=e)return!1;switch(c){case Ph:if(d&&e)return 0==zo(a,b);for(var f in a)if(a[Hc](f)&&(!b[Hc](f)||!Bo(a[f],b[f])))return!1;for(var g in b)if(b[Hc](g)&&!a[Hc](g))return!1;return!0;case Lg:if(a[J]!=b[J])return!1;for(c=0;c<a[J];++c)if(!Bo(a[c],b[c]))return!1;return!0;case kh:return!0;case ii:case Nh:case Qg:return!1;default:throw m("Error while comparing "+a+Le+b+": unexpected type of obj1 "+
c);}}function Co(a){if(Qi(a)){var b=new Date;b[Wc](a[md]());return b}var c=Li(a);if(c==Ph||c==Lg){if(a[Jc])return a[Jc]();c=c==Lg?[]:{};for(b in a)c[b]=Co(a[b]);return c}return a}function aga(a,b){function c(a,e,f){for(var g in a)a[Hc](g)&&(typeof a[g]===Ph?c(a[g],e,f):b[L](void 0,a[g],g,a)&&f[B](a[g]));return f}return c(a,Ao(b),[])};function Do(a,b){this.Hh=a||[{}];this.xga=b||null}Do[K].view=function(a){a=Eo(this,a);return new Do(this.Hh,a)};function Eo(a,b){return null!=a.xga?bga(a.xga,b):b}function bga(a,b){var c=Si(a)?[a]:a,d=Si(b)?[b]:b;if(0===c[J])return d;if(0===d[J])return c;var e=[];X(c,function(a){X(d,function(b){e[B](a+mf+b)})});return 1===e[J]?e[0]:e}function Fo(a,b,c){Gj(a.Hh,c,b)}function cga(a){var b=Gh,b=Eo(a,b),c=new hl;X(a.Hh,function(a){a=dga(a,b);Ri(a)&&c.Zy(fk(a))});return Iea(c)}
function ega(a,b){for(var c in b)Ri(b[c])&&a[c]?ega(a[c],b[c]):a[c]=b[c]}function fga(a,b){Zj(b,function(b,d){Ri(b)&&!Oi(b)?(a[d]=a[d]||{},fga(a[d],b)):null!=b&&(a[d]=b)})}function Go(a){var b={};uj(a.Hh,function(a){fga(b,a)});return b}function dga(a,b,c){if(Si(b))return Ho(a,b,c);for(var d=0;d<b[J];++d){var e=Ho(a,b[d],c);if(null!=e)return e}return null}
function Ho(a,b,c){t:{b=b[zc](mf);a=a||Fi;for(var d=0;d<b[J];d++){var e=b[d];if(null!=a[e])a=a[e];else{b=null;break t}}b=a}return null!=b&&Vi(c)?c(b):b}Do[K].Q=function(a,b,c){var d=null;a=Eo(this,a);for(var e=0;e<this.Hh[J];e++)if(d=dga(this.Hh[e],a,c),null!=d)return d;d=b;return Gi(d)?d:null};function Io(a,b,c,d){c=null!=c?mk(c):{};b=Eo(a,b);for(var e=a.Hh[J]-1;0<=e;e--){var f=c,g=a.Hh[e],k=b,l=d;Si(k)&&(k=[k]);for(var n=k[J]-1;0<=n;--n){var p=Ho(g,k[n],l)||{};pk(f,p)}}return c}
function Jo(a,b,c){c=null!=c?mk(c):{};Si(b)&&(b=[b]);b=Eo(a,b);for(var d=a.Hh[J]-1;0<=d;d--)for(var e=b[J]-1;0<=e;--e){var f=Ho(a.Hh[d],b[e])||{};fo(c,f)}return c}function Ko(a){if(null==a)return null;if(typeof a==Qg)return a;a=String(a);return a==tf||a[He]()==pi?!0:a==pf||a[He]()==fh?!1:null}function Lo(a,b,c){a=Mo(a,b);if(null!=a)return a;Gi(c)||(c=!1);return c}function Mo(a,b){return a.Q(b,null,Ko)}
function No(a){if(null==a)return null;if(typeof a==Nh)return a;a=oj(String(a));return fa(a)?null:a}function Oo(a){return null!=a?Oi(a)?wj(a,No):null:null}function gga(a){if(null==a)return null;if(Ui(a))return a;a=ha(a);return fa(a)?null:a}function Po(a,b,c){a=Qo(a,b);if(null!=a)return a;Gi(c)||(c=0);return c}function hga(a,b,c){a=a.Q(b,null,gga);if(null!=a)return a;Gi(c)||(c=0);return c}function Qo(a,b){return a.Q(b,null,No)}function Ro(a){a=No(a);return null!=a&&0<=a?a:null}
function So(a,b,c){a=a.Q(b,null,Ro);if(null!=a)return a;Gi(c)||(c=0);return c}function To(a){a=Ro(a);return null!=a?Lk(a,0,1):null}function Uo(a,b,c){a=a.Q(b,null,To);if(null!=a)return a;Gi(c)||(c=0);return c}function Vo(a){return null!=a?String(a):null}function Wo(a,b,c){Gi(c)||(c=M);return a.Q(b,c,Vo)}function Xo(a,b){return a.Q(b,null,Vo)}function Yo(a,b){var c=Vo(a);if(!c)return null;if(Dj(b||[],c))return c;try{return co(c)}catch(d){return null}}function Zo(a,b,c){return a.Q(b,c,Yo)}
function $o(a,b,c,d){return a.Q(b,d,function(a){return Yo(a,c)})}function ap(a,b){return a.Q(b,null,Yo)}function iga(a){var b;a=a.Q(eda,null,bp);if(null!=a)return a;Gi(b)||(b=[]);return b}function bp(a){return null!=a?Oi(a)?wj(a,String):null:null}function dp(a,b){var c=Vo(b);return gk(a,c)?c:null}function ep(a,b,c,d){return a.Q(b,d,U(dp,null,c))}function fp(a,b,c){return a.Q(b,null,U(dp,null,c))}function gp(a,b,c){Gi(c)||(c=null);return a.Q(b,c)}
function hp(a,b,c){c=c?c[$d]():null;a=Io(a,b,c,function(a){Ri(a)||(a={fill:a});var b={},c=Yo(a[nc]);null!=c&&za(b,c);c=To(a[Yd]);null!=c&&(b.fillOpacity=c);c=Yo(a[ec]);null!=c&&xa(b,c);c=Ro(a[Od]);null!=c&&ib(b,c);c=To(a[pc]);null!=c&&(b.strokeOpacity=c);c=Oo(a.strokeDashStyle);null!=c&&Oi(c)&&(b.wR=c);c=No(a.rx);null!=c&&(b.Hi=c);c=No(a.ry);null!=c&&(b.Ii=c);(a=a[rc])&&null!=a.color1&&null!=a.color2&&null!=a.x1&&null!=a.y1&&null!=a.x2&&null!=a.y2&&(c={},c.kg=Yo(a.color1),c.Nf=Yo(a.color2),c.or=To(a.opacity1),
c.pr=To(a.opacity2),c.x1=a.x1,c.y1=a.y1,c.Fb=a.x2,c.Kb=a.y2,c.nr=Ko(a.useObjectBoundingBoxUnits),b.gradient=c);return b});a=new lo(a);po(a)||(a.Ne(ro.fb()),a.Eg(ro.Oe));oo(a)||(a.ld(ro.pe),mo(a,ro.pi));return a}
function mp(a,b){var c={},d=Yo(a[F],b);null!=d&&Ya(c,d);d=To(a[fe]);null!=d&&qb(c,d);d=Yo(a.auraColor,b);null!=d&&(c.lc=d);if(d=Ro(a.auraWidth))c.Tya=d;if(d=Vo(a.fontName))c.$a=d;(d=Ro(a[Gc]))&&Fa(c,d);d=Ko(a[Xd]);null!=d&&lb(c,d);d=Ko(a.italic);null!=d&&(c.Tc=d);d=Ko(a.underline);null!=d&&(c.Re=d);return c}function np(a,b,c){return Io(a,b,c,function(a){return mp(a)})}function jga(a,b,c,d){return Io(a,b,d,function(a){return mp(a,c)})}
function kga(a,b){var c=Io(a,b,void 0);return{format:c[Rb],interval:c[Mb]}}function lga(a,b){var c=null,d=No(b);if(null!=d)c=d;else if(d=Vo(b),null!=d&&Dda(d)){var c=d[J]-1,e=d;0<=c&&c<d[J]&&(e=d[mc](0,c)+d[mc](c+1,d[J]-c-1));c=a*oj(e)/100}null!=c&&(c=Lk(c,0,a));return c}function mga(a,b){var c,d=op(a,Fba,b);if(null!=d)return d;Gi(c)||(c=0);return c}function op(a,b,c){return a.Q(b,null,U(lga,null,c))}
var nga={PAa:"multiple",mBa:ei},pp={NONE:O,Kwa:ih,Swa:ci,qz:Rg},oga={NONE:O,Kwa:ih,Swa:ci,qz:Rg},pga={BV:th,DV:ui,qz:Rg};function qga(){this.In=!1;this.u5=[]}Ki(qga);function rga(a,b,c){var d=c.callback;c.callback=function(){var b=d[Zc](this,arguments);0<a.u5[J]?(a.u5[wb]()(),a.In=!0):a.In=!1;return b};b=U(google[td],Fi.google,cda,b,c);if(a.In)a.u5[B](b);else a.In=!0,b()};function qp(a,b,c){return b.Q(yi,null,Ro)||an(a)[r]||c||400}function rp(a,b,c){return b.Q(rh,null,Ro)||an(a)[z]||c||200}function sp(a,b,c,d){return b&&(b=b[r],Si(b)&&dj(b)&&(b=ja(b,10)),typeof b==Nh&&30<=b&&(!d||b<=d))||a&&(b=a[be],30<=b&&(!d||b<=d))?b:c||400}function tp(a,b,c,d,e){return b&&(b=b[z],Si(b)&&dj(b)&&(b=ja(b,10)),typeof b==Nh&&b>=(e||30)&&(!d||b<=d))||a&&(b=a[re],b>=(e||30)&&(!d||b<=d))?b:c||200}function sga(a){var b=tga,c=a&&a.colors;c&&0!=c[J]||(c=(a=a&&a[F])?[a]:b);return c}
function up(){var a=Ii(jca);if(null!=a)return a;a=Ii(gca);null!=a||(a=laa);var b=Ii(lca);null!=b||(b=raa);return a+maa+b}function uga(){if(0==ea[kc](oh)[J]){var a=ea[kc](vh)[0],b=ea[kc](Pg)[0],c=ea[Vb](oh);a[Lb](c,b)}return ea[kc](oh)[0]}function vp(a){a=up()+a;for(var b=ea[kc](Saa),c=0;c<b[J];c++)if(b[c]&&b[c][oe](uh)&&b[c][oe](uh)===a)return;b=ea[Vb](Dh);b.href=a;b.rel=Nca;db(b,Qca);uga()[q](b)}var wp=[];
function vga(a){function b(){if(wga()){var a=wp;wp=[];X(a,function(a){a()})}else throw m("Error: cannot load Maps API.");}wga()?a():(wp[B](a),1==wp[J]&&(a=Ica,xga()&&(a+=gaa),google[td](Gh,vf,{callback:b,other_params:a})))}function xga(){var a=Fi[Fc][Vc];if(!cj(kj(a))){if(ln(1,a)!=wh)return!1;a=kn(ln(3,a));if(!cj(kj(a))){var b=/^ajax\.googleapis\.com$/[od](a);return/\.google\.com$/[od](a)||b}}return!1}function wga(){return!!Ii(hca)}
function tk(a){var b=null,c=Fi.google;(c=c&&c[he]&&c[he].Locale)&&c.packages&&c.packages[a]&&(b=c.locale);return b}function xp(a,b){var c=Li(a);b=(31*b+nj(c))%67108864;switch(c){case Ph:if(a[Bc]==Date)b=(31*b+nj(Xg))%67108864,b=xp(a[jc](),b);else{c=fk(a);Qj(c);var c=qk(c),d;for(d in c)b=xp(a[d],xp(d,b))}break;case Lg:for(d=0;d<a[J];d++)b=xp(a[d],xp(String(d),b));break;default:b=(31*b+nj(String(a)))%67108864}return b}function yp(a){if(!Rl(a))throw m(Mf);return a}
function zp(a){a=Aj(wj([ica+a,fca+a,a],function(a){return Ii(a)}),Vi);return null!=a?a:null};function Ap(a){this.b=a||{};vp(oaa)}ta(Ap[K],function(a,b){if(a.G(b)==Nh)for(var c=this.b.base||0,d=0;d<a.O();d++){var e=a[I](d,b),f=null,f=e<c?cca:e>c?eca:dca;a[Qc](d,b,Rba,f)}});var yga={zza:Qg,RAa:Nh,uBa:ii,Gwa:Xg,CBa:ni,Hwa:$g};var zga={KAa:Yf,fBa:cba,LAa:Uaa,hAa:Laa,Wza:Nf,NBa:nba,NAa:$f,bBa:fg,RBa:yg};function Bp(a){switch(a){case Yf:return 1;case cba:return 1E3;case Uaa:return 6E4;case Laa:return 36E5;case Nf:return 864E5;case nba:return 6048E5;case $f:return 2629746E3;case fg:return 7889238E3;case yg:return 31556952E3}return 0};function Cp(){}function Dp(a){if(typeof a==Nh){var b=new Cp;b.Aga=a;var c;c=a;if(0==c)c=Gaa;else{var d=[Gaa,0>c?lf:hf];c=h.abs(c);d[B](h[Eb](c/60)%100);c%=60;0!=c&&d[B](xf,jj(c,2));c=d[Fe](M)}b.Bga=c;0==a?a=kba:(c=[kba,0>a?hf:lf],a=h.abs(a),c[B](h[Eb](a/60)%100),a%=60,0!=a&&c[B](xf,a),a=c[Fe](M));b.p5=[a,a];b.pE=[];return b}b=new Cp;b.Bga=a.id;b.Aga=-a.std_offset;b.p5=a[hc];b.pE=a.transitions;return b}R=Cp[K];
R.getDaylightAdjustment=function(a){a=Date.UTC(a[Qb](),a[Mc](),a[ee](),a[Be](),a[Ae]())/36E5;for(var b=0;b<this.pE[J]&&a>=this.pE[b];)b+=2;return 0==b?0:this.pE[b-1]};R.getGMTString=function(a){a=this.getOffset(a);var b=[Jaa];b[B](0>=a?hf:lf);a=h.abs(a);b[B](jj(h[Eb](a/60)%100,2),xf,jj(a%60,2));return b[Fe](M)};R.getLongName=function(a){return this.p5[this.isDaylightTime(a)?3:1]};R.getOffset=function(a){return this.Aga-this.getDaylightAdjustment(a)};
R.getRFCTimeZoneString=function(a){a=-this.getOffset(a);var b=[0>a?lf:hf];a=h.abs(a);b[B](jj(h[Eb](a/60)%100,2),jj(a%60,2));return b[Fe](M)};R.getShortName=function(a){return this.p5[this.isDaylightTime(a)?2:0]};R.getTimeZoneId=function(){return this.Bga};R.isDaylightTime=function(a){return 0<this.getDaylightAdjustment(a)};function Ep(a,b){this.pV=[];this.vf=b||uo;typeof a==Nh?this.bU(a):this.tt(a)}var Aga=[/^\'(?:[^\']|\'\')*\'/,/^(?:G+|y+|M+|k+|S+|E+|a+|h+|K+|H+|c+|L+|Q+|d+|m+|s+|v+|w+|z+|Z+)/,/^[^\'GyMkSEahKHcLQdmsvwzZ]+/];Ep[K].tt=function(a){for(;a;)for(var b=0;b<Aga[J];++b){var c=a[Pb](Aga[b]);if(c){c=c[0];a=a[we](c[J]);0==b&&(c==haa?c=cf:(c=c[we](1,c[J]-1),c=c[Ab](/\'\'/,cf)));this.pV[B]({text:c,type:b});break}}};
ta(Ep[K],function(a,b){if(!a)throw m("The date to format must be non-null.");var c=b?6E4*(a[Ie]()-b.getOffset(a)):0,d=c?new Date(a[jc]()+c):a,e=d;b&&d[Ie]()!=a[Ie]()&&(c+=0<c?-864E5:864E5,e=new Date(a[jc]()+c));for(var c=[],f=0;f<this.pV[J];++f){var g=this.pV[f][pd];1==this.pV[f][H]?c[B](Bga(this,g,a,d,e,b)):c[B](g)}return c[Fe](M)});
Ep[K].bU=function(a){var b;if(4>a)b=this.vf.DATEFORMATS[a];else if(8>a)b=this.vf.TIMEFORMATS[a-4];else if(12>a)b=this.vf.DATETIMEFORMATS[a-8],b=b[Ab](tda,this.vf.DATEFORMATS[a-8]),b=b[Ab](sda,this.vf.TIMEFORMATS[a-8]);else{this.bU(10);return}this.tt(b)};function Fp(a,b){var c;c=String(b);var d=a.vf||uo;if(void 0!==d.mva){for(var e=[],f=0;f<c[J];f++){var g=c[se](f);e[B](48<=g&&57>=g?String[Gd](d.mva+g-48):c[Ib](f))}c=e[Fe](M)}return c}
function Gp(a){if(!(a[gc]&&a[de]&&a[bd]))throw m("The date to format has no time (probably a goog.date.Date). Use Date or goog.date.DateTime, or use a pattern without time fields.");}
function Bga(a,b,c,d,e,f){var g=b[J];switch(b[Ib](0)){case Iaa:return c=0<d[Rc]()?1:0,4<=g?a.vf.ERANAMES[c]:a.vf.ERAS[c];case zi:return c=d[Rc](),0>c&&(c=-c),2==g&&(c%=100),Fp(a,jj(c,g));case Xf:t:switch(c=d[Vd](),g){case 5:a=a.vf.NARROWMONTHS[c];break t;case 4:a=a.vf.MONTHS[c];break t;case 3:a=a.vf.SHORTMONTHS[c];break t;default:a=Fp(a,jj(c+1,g))}return a;case Bh:return Gp(e),Fp(a,jj(e[gc]()||24,g));case gg:return c=e[jc]()%1E3/1E3,Fp(a,c[Bb](h.min(3,g))[mc](2)+(3<g?jj(0,g-3):M));case Pf:return c=
d[vc](),4<=g?a.vf.WEEKDAYS[c]:a.vf.SHORTWEEKDAYS[c];case Eg:return Gp(e),g=e[gc](),a.vf.AMPMS[12<=g&&24>g?1:0];case mh:return Gp(e),Fp(a,jj(e[gc]()%12||12,g));case Qaa:return Gp(e),Fp(a,jj(e[gc]()%12,g));case Kaa:return Gp(e),Fp(a,jj(e[gc](),g));case Tg:t:switch(c=d[vc](),g){case 5:a=a.vf.STANDALONENARROWWEEKDAYS[c];break t;case 4:a=a.vf.STANDALONEWEEKDAYS[c];break t;case 3:a=a.vf.STANDALONESHORTWEEKDAYS[c];break t;default:a=Fp(a,jj(c,1))}return a;case Wf:t:switch(c=d[Vd](),g){case 5:a=a.vf.STANDALONENARROWMONTHS[c];
break t;case 4:a=a.vf.STANDALONEMONTHS[c];break t;case 3:a=a.vf.STANDALONESHORTMONTHS[c];break t;default:a=Fp(a,jj(c+1,g))}return a;case eg:return c=h[Eb](d[Vd]()/3),4>g?a.vf.SHORTQUARTERS[c]:a.vf.QUARTERS[c];case Vg:return Fp(a,jj(d[Kb](),g));case Fh:return Gp(e),Fp(a,jj(e[bd](),g));case ai:return Gp(e),Fp(a,jj(e[de](),g));case si:return a=f||Dp(c[Ie]()),a.getTimeZoneId();case wi:return c=new Date(e[Rc](),e[Vd](),e[Kb]()),b=a.vf.FIRSTDAYOFWEEK||0,c=c[md]()+864E5*(((a.vf.FIRSTWEEKCUTOFFDAY||3)-b+
7)%7-((c[vc]()+6)%7-b+7)%7),c=h[Eb](h[D]((c-(new Date((new Date(c))[Rc](),0,1))[md]())/864E5)/7)+1,Fp(a,jj(c,g));case Ai:return a=f||Dp(c[Ie]()),4>g?a.getShortName(c):a.getLongName(c);case zg:return b=f||Dp(c[Ie]()),4>g?b.getRFCTimeZoneString(c):Fp(a,b.getGMTString(c));default:return M}};var Cga={YEAR_FULL:zi,YEAR_FULL_WITH_ERA:"y G",YEAR_MONTH_ABBR:"MMM y",YEAR_MONTH_FULL:"MMMM y",MONTH_DAY_ABBR:Zf,MONTH_DAY_FULL:"MMMM dd",MONTH_DAY_SHORT:"M/d",MONTH_DAY_MEDIUM:"MMMM d",MONTH_DAY_YEAR_MEDIUM:"MMM d, y",WEEKDAY_MONTH_DAY_MEDIUM:"EEE, MMM d",WEEKDAY_MONTH_DAY_YEAR_MEDIUM:"EEE, MMM d, y",DAY_ABBR:Vg},Hp=Cga,Hp=Cga;var Dga={Vva:{1E3:{other:"0K"},1E4:{other:"00K"},1E5:{other:"000K"},1E6:{other:"0M"},1E7:{other:"00M"},1E8:{other:"000M"},1E9:{other:"0B"},1E10:{other:"00B"},1E11:{other:"000B"},1E12:{other:"0T"},1E13:{other:"00T"},1E14:{other:"000T"}},Uva:{1E3:{other:"0 thousand"},1E4:{other:"00 thousand"},1E5:{other:"000 thousand"},1E6:{other:"0 million"},1E7:{other:"00 million"},1E8:{other:"000 million"},1E9:{other:"0 billion"},1E10:{other:"00 billion"},1E11:{other:"000 billion"},1E12:{other:"0 trillion"},1E13:{other:"00 trillion"},
1E14:{other:"000 trillion"}}},Ip=Dga,Ip=Dga;function Ega(a){var b=Jp.Ewa,c=[pf];a=Kp[a][0]&7;if(0<a){c[B](mf);for(var d=0;d<a;d++)c[B](pf)}return b[Ab](/0.00/g,c[Fe](M))}
var Kp={AED:[2,"dh","\u062f.\u0625.","DH"],ALL:[0,"Lek","Lek"],AUD:[2,Te,"AU$"],BDT:[2,"\u09f3","Tk"],BGN:[2,"lev","lev"],BRL:[2,"R$","R$"],CAD:[2,Te,"C$"],CDF:[2,"FrCD","CDF"],CHF:[2,"CHF","CHF"],CLP:[0,Te,"CL$"],CNY:[2,"\u00a5","RMB\u00a5"],COP:[0,Te,"COL$"],CRC:[0,"\u20a1","CR\u20a1"],CZK:[50,"K\u010d","K\u010d"],DKK:[18,"kr","kr"],DOP:[2,Te,"RD$"],EGP:[2,"\u00a3","LE"],ETB:[2,"Birr","Birr"],EUR:[2,"\u20ac","\u20ac"],GBP:[2,"\u00a3","GB\u00a3"],HKD:[2,Te,"HK$"],HRK:[2,"kn","kn"],HUF:[0,"Ft","Ft"],
IDR:[0,"Rp","Rp"],ILS:[2,"\u20aa","IL\u20aa"],INR:[2,"\u20b9","Rs"],IRR:[0,"Rial","IRR"],ISK:[0,"kr","kr"],JMD:[2,Te,"JA$"],JPY:[0,"\u00a5","JP\u00a5"],KRW:[0,"\u20a9","KR\u20a9"],LKR:[2,"Rs","SLRs"],LTL:[2,"Lt","Lt"],LVL:[2,"Ls","Ls"],MNT:[0,"\u20ae","MN\u20ae"],MXN:[2,Te,"Mex$"],MYR:[2,"RM","RM"],NOK:[50,"kr","NOkr"],PAB:[2,"B/.","B/."],PEN:[2,"S/.","S/."],PHP:[2,"\u20b1","Php"],PKR:[0,"Rs","PKRs."],PLN:[50,"z\u0142","z\u0142"],RON:[2,"RON","RON"],RSD:[0,"din","RSD"],RUB:[50,"\u0440\u0443\u0431.",
"\u0440\u0443\u0431."],SAR:[2,"Rial","Rial"],SEK:[2,"kr","kr"],SGD:[2,Te,"S$"],THB:[2,"\u0e3f","THB"],TRY:[2,qg,"YTL"],TWD:[2,"NT$","NT$"],TZS:[0,"TSh","TSh"],UAH:[2,"\u20b4","UAH"],USD:[2,Te,"US$"],UYU:[2,Te,"$U"],VND:[0,"\u20ab","VN\u20ab"],YER:[0,"Rial","Rial"],ZAR:[2,"R","ZAR"]};var Fga={DECIMAL_SEP:mf,GROUP_SEP:jf,XL:Ve,y4:pf,tva:hf,sva:lf,ufa:Pf,mfa:wda,h4:"\u221e",Qta:"NaN",DECIMAL_PATTERN:"#,##0.###",ova:"#E0",e5:"#,##0%",Ewa:"\u00a4#,##0.00",ssa:"USD"},Jp=Fga,Jp=Fga;function Lp(a,b,c){this.oL=b||Jp.ssa;this.Bra=c||0;this.FT=40;this.$o=1;this.Bz=0;this.uz=3;this.OT=this.ot=0;this.aea=this.sda=!1;this.WK=this.pz=M;this.Uv=lf;this.nE=M;this.rj=1;this.Z2=3;this.JT=this.rda=!1;this.jL=0;this.Vda=null;typeof a==Nh?this.bU(a):this.tt(a)}var Mp=!1;R=Lp[K];R.setMinimumFractionDigits=function(a){if(0<this.Bz&&0<a)throw m(Caa);this.ot=a;return this};R.setMaximumFractionDigits=function(a){this.uz=a;return this};
R.setSignificantDigits=function(a){if(0<this.ot&&0<=a)throw m(Caa);this.Bz=a;return this};
R.tt=function(a){this.ud=a[Ab](/ /g,Di);var b=[0];this.pz=Np(this,a,b);for(var c=b[0],d=-1,e=0,f=0,g=0,k=-1,l=a[J],n=!0;b[0]<l&&n;b[0]++)switch(a[Ib](b[0])){case Oe:0<f?g++:e++;0<=k&&0>d&&k++;break;case pf:if(0<g)throw m('Unexpected "0" in pattern "'+a+Me);f++;0<=k&&0>d&&k++;break;case jf:k=0;break;case mf:if(0<=d)throw m('Multiple decimal separators in pattern "'+a+Me);d=e+f+g;break;case Pf:if(this.JT)throw m('Multiple exponential symbols in pattern "'+a+Me);this.JT=!0;this.OT=0;b[0]+1<l&&a[Ib](b[0]+
1)==hf&&(b[0]++,this.sda=!0);for(;b[0]+1<l&&a[Ib](b[0]+1)==pf;)b[0]++,this.OT++;if(1>e+f||1>this.OT)throw m('Malformed exponential pattern "'+a+Me);n=!1;break;default:b[0]--,n=!1}0==f&&0<e&&0<=d&&(f=d,0==f&&f++,g=e-f,e=f-1,f=1);if(0>d&&0<g||0<=d&&(d<e||d>e+f)||0==k)throw m('Malformed pattern "'+a+Me);g=e+f+g;this.uz=0<=d?g-d:0;0<=d&&(this.ot=e+f-d,0>this.ot&&(this.ot=0));this.$o=(0<=d?d:g)-e;this.JT&&(this.FT=e+this.$o,0==this.uz&&0==this.$o&&(this.$o=1));this.Z2=h.max(0,k);this.rda=0==d||d==g;c=
b[0]-c;this.WK=Np(this,a,b);b[0]<a[J]&&a[Ib](b[0])==zf?(b[0]++,this.Uv=Np(this,a,b),b[0]+=c,this.nE=Np(this,a,b)):(this.Uv=this.pz+this.Uv,this.nE+=this.WK)};R.bU=function(a){switch(a){case 1:this.tt(Jp.DECIMAL_PATTERN);break;case 2:this.tt(Jp.ova);break;case 3:this.tt(Jp.e5);break;case 4:this.tt(Ega(this.oL));break;case 5:Gga(this,1);break;case 6:Gga(this,2);break;default:throw m("Unsupported pattern type.");}};
function Gga(a,b){a.jL=b;a.tt(Jp.DECIMAL_PATTERN);a.setMinimumFractionDigits(0);a.setMaximumFractionDigits(2);a.setSignificantDigits(2)}
jb(R,function(a,b){var c=b||[0];if(0!=this.jL)throw m("Parsing of compact numbers is unimplemented");var d=ia;a=a[Ab](/ /g,Di);var e=a[zd](this.pz,c[0])==c[0],f=a[zd](this.Uv,c[0])==c[0];e&&f&&(this.pz[J]>this.Uv[J]?f=!1:this.pz[J]<this.Uv[J]&&(e=!1));e?c[0]+=this.pz[J]:f&&(c[0]+=this.Uv[J]);if(a[zd](Jp.h4,c[0])==c[0])c[0]+=Jp.h4[J],d=da;else{var d=a,g=!1,k=!1,l=!1,n=1,p=Jp.DECIMAL_SEP,t=Jp.GROUP_SEP,u=Jp.ufa;if(0!=this.jL)throw m("Parsing of compact style numbers is not implemented");for(var x=M;c[0]<
d[J];c[0]++){var A=d[Ib](c[0]),C=Hga(A);if(0<=C&&9>=C)x+=C,l=!0;else if(A==p[Ib](0)){if(g||k)break;x+=mf;g=!0}else if(A==t[Ib](0)&&(Di!=t[Ib](0)||c[0]+1<d[J]&&0<=Hga(d[Ib](c[0]+1)))){if(g||k)break}else if(A==u[Ib](0)){if(k)break;x+=Pf;k=!0}else if(A==hf||A==lf)x+=A;else if(A==Jp.XL[Ib](0)){if(1!=n)break;n=100;if(l){c[0]++;break}}else if(A==Jp.mfa[Ib](0)){if(1!=n)break;n=1E3;if(l){c[0]++;break}}else break}d=ka(x)/n}if(e){if(a[zd](this.WK,c[0])!=c[0])return ia;c[0]+=this.WK[J]}else if(f){if(a[zd](this.nE,
c[0])!=c[0])return ia;c[0]+=this.nE[J]}return f?-d:d});
ta(R,function(a){if(fa(a))return Jp.Qta;var b=[],c;var d=null===this.Vda?a:this.Vda,e=a;0==this.jL?c=Op:(d=h.abs(d),e=h.abs(e),c=Iga(this,1>=d?0:Pp(d)).divisorBase,e/=h.pow(10,c),Qp(this,e),d/=h.pow(10,c),d=Qp(this,d),c=Iga(this,c+Pp(d.qea)));a/=h.pow(10,c.divisorBase);b[B](c.prefix);d=0>a||0==a&&0>1/a;b[B](d?this.Uv:this.pz);if(la(a))if(a=a*(d?-1:1)*this.rj,this.JT)if(0==a)Rp(this,a,this.$o,b),Jga(this,0,b);else{e=h.log(a)/h.log(10);e=h[Eb](e+2E-15);a/=h.pow(10,e);var f=this.$o;if(1<this.FT&&this.FT>
this.$o){for(;0!=e%this.FT;)a*=10,e--;f=1}else 1>this.$o?(e++,a/=10):(e-=this.$o-1,a*=h.pow(10,this.$o-1));Rp(this,a,f,b);Jga(this,e,b)}else Rp(this,a,this.$o,b);else b[B](Jp.h4);b[B](d?this.nE:this.WK);b[B](c.suffix);return b[Fe](M)});function Qp(a,b){var c=h.pow(10,a.uz),d=0>=a.Bz?h[D](b*c):h[D](Kga(b*c,a.Bz,a.uz)),e;la(d)?(e=h[Eb](d/c),c=h[Eb](d-e*c)):(e=b,c=0);return{qea:e,Jua:c}}
function Rp(a,b,c,d){if(a.ot>a.uz)throw m("Min value must be less than max value");b=Qp(a,b);var e=h.pow(10,a.uz),f=b.qea,g=b.Jua,k=0==f?0:Pp(f)+1,l=0<a.ot||0<g||a.aea&&k<a.Bz;b=a.ot;l&&(b=a.aea&&0<a.Bz?a.Bz-k:a.ot);for(var n=M,k=f;1E20<k;)n=pf+n,k=h[D](k/10);var n=k+n,p=Jp.DECIMAL_SEP,t=Jp.GROUP_SEP,k=Mp?48:Jp.y4[se](0),u=n[J];if(0<f||0<c){for(f=u;f<c;f++)d[B](String[Gd](k));for(f=0;f<u;f++)d[B](String[Gd](k+1*n[Ib](f))),1<u-f&&0<a.Z2&&1==(u-f)%a.Z2&&d[B](t)}else l||d[B](String[Gd](k));(a.rda||l)&&
d[B](p);a=M+(g+e);for(c=a[J];a[Ib](c-1)==pf&&c>b+1;)c--;for(f=1;f<c;f++)d[B](String[Gd](k+1*a[Ib](f)))}function Jga(a,b,c){c[B](Jp.ufa);0>b?(b=-b,c[B](Jp.sva)):a.sda&&c[B](Jp.tva);b=M+b;for(var d=Mp?pf:Jp.y4,e=b[J];e<a.OT;e++)c[B](d);c[B](b)}function Hga(a){a=a[se](0);if(48<=a&&58>a)return a-48;var b=Jp.y4[se](0);return b<=a&&a<b+10?a-b:-1}
function Np(a,b,c){for(var d=M,e=!1,f=b[J];c[0]<f;c[0]++){var g=b[Ib](c[0]);if(g==cf)c[0]+1<f&&b[Ib](c[0]+1)==cf?(c[0]++,d+=cf):e=!e;else if(e)d+=g;else switch(g){case Oe:case pf:case jf:case mf:case zf:return d;case vda:if(c[0]+1<f&&b[Ib](c[0]+1)==vda)c[0]++,d+=a.oL;else switch(a.Bra){case 0:d+=Kp[a.oL][1];break;case 2:var g=a.oL,k=Kp[g],d=d+(g==k[1]?g:g+Ke+k[1]);break;case 1:d+=Kp[a.oL][2]}break;case Ve:if(1!=a.rj)throw m(iba);a.rj=100;d+=Jp.XL;break;case wda:if(1!=a.rj)throw m(iba);a.rj=1E3;d+=
Jp.mfa;break;default:d+=g}}return d}var Op={prefix:M,suffix:M,divisorBase:0};function Iga(a,b){var c=1==a.jL?Ip.Vva:Ip.Uva;if(3>b)return Op;b=h.min(14,b);c=c[h.pow(10,b)];if(!c)return Op;c=c.other;return c&&c!=pf?(c=/([^0]*)(0+)(.*)/[xb](c))?{prefix:c[1],suffix:c[3],divisorBase:b-(c[2][J]-1)}:Op:Op}function Pp(a){for(var b=0;1<=(a/=10);)b++;return b}function Kga(a,b,c){if(!a)return a;b=b-Pp(a)-1;if(b<-c)return c=h.pow(10,c),h[D](a/c)*c;c=h.pow(10,b);return h[D](a*c)/c};ta(Ep[K],Ep[K][Rb]);Ep.Format={FULL_DATE:0,LONG_DATE:1,MEDIUM_DATE:2,SHORT_DATE:3,FULL_TIME:4,LONG_TIME:5,MEDIUM_TIME:6,SHORT_TIME:7,FULL_DATETIME:8,LONG_DATETIME:9,MEDIUM_DATETIME:10,SHORT_DATETIME:11};var Sp=Hp;Lp.Format={Iwa:1,Rwa:2,XL:3,Dwa:4,Cwa:5,Bwa:6};ta(Lp[K],Lp[K][Rb]);Lp.setEnforceAsciiDigits=function(a){Mp=a};Lp.isEnforceAsciiDigits=function(){return Mp};var Tp=Jp;Cp.createTimeZone=Dp;function Up(){this.pn=null}wa(Up[K],function(a){if(Ui(a)){var b=this.L();return 0>a&&a>=b?-1:a}if(!this.pn){this.pn={};for(var b=this.L(),c=0;c<b;c++){var d=this.Ee(c);null==d||d===M||d in this.pn||(this.pn[d]=c)}for(c=0;c<b;c++)d=this.La(c),null==d||d===M||d in this.pn||(this.pn[d]=c)}a=this.pn[a];return null==a?-1:a});Up[K].getStringValue=function(a,b){var c=this.G(b);if(c!==ii)throw m(Lf+b+" must be of type string; was "+c);return this[I](a,b)};
function Lga(a,b,c){var d=a.G(c);if(d!==Xg&&d!==$g)throw m(Lf+c+" must be of type date or datetime; was "+d);return a[I](b,c)};function Vp(){}Vp[K].Sc=function(a){return this.EV(a)};function Wp(a){this[Sc](a)}W(Wp,Vp);La(Wp[K],function(a){a=new Do([a||{},{formatType:di,valueType:$g}]);this.ud=a.Q(Th);this.gd=null;this.gra=fp(a,aca,Mga);this.$qa=fp(a,$ca,Nga);this.fra=Lo(a,Sba,!1);this.Ida=null;a=Qo(a,Tca);null!=a&&(this.Ida=Cp.createTimeZone(60*-a))});var Xp=Ep[Ld],Mga={bAa:jh,yAa:Eh,EAa:Kh,SHORT:di},Nga={Gwa:Xg,Hwa:$g,ABa:mi};
function Oga(a,b){switch(a){case Xg:switch(b){case jh:return Ep[Ld].FULL_DATE;case Eh:return Ep[Ld].LONG_DATE;case Kh:return Ep[Ld].MEDIUM_DATE;case di:return Ep[Ld].SHORT_DATE}case $g:switch(b){case jh:return Ep[Ld].FULL_DATETIME;case Eh:return Ep[Ld].LONG_DATETIME;case Kh:return Ep[Ld].MEDIUM_DATETIME;case di:return Ep[Ld].SHORT_DATETIME}case mi:switch(b){case jh:return Ep[Ld].FULL_TIME;case Eh:return Ep[Ld].LONG_TIME;case Kh:return Ep[Ld].MEDIUM_TIME;case di:return Ep[Ld].SHORT_TIME}default:return Ep[Ld].FULL_DATETIME}}
Wp[K].ml=function(a){switch(a){case yg:a=Sp.YEAR_FULL;break;case fg:a=aba;break;case $f:a=Sp.YEAR_MONTH_ABBR;break;case Nf:a=Ep[Ld].SHORT_DATE;break;default:a=Ep[Ld].SHORT_DATETIME}this[Sc]({pattern:a,timeZone:0})};ta(Wp[K],function(a,b){var c=dp(Nga,a.G(b));if(c==Xg||c==$g)for(var c=this.AP(c),d=a.O(),e=0;e<d;e++){var f=a[I](e,b),f=Pga(this,c,f);a.qy(e,b,f)}});Wp[K].EV=function(a){this.gd||(this.gd=this.AP(this.$qa));return Pga(this,this.gd,a)};
Wp[K].AP=function(a){var b=this.ud;null!=b||(b=Oga(a,this.gra));return new Ep(b)};function Pga(a,b,c){if(null===c)return M;var d=a.Ida;null==d&&(d=Cp.createTimeZone(c[Ie]()));c=new Date(c[jc]());a.fra&&c.setMinutes(0);return b[Rb](c,d)};function Yp(a){var b=new Do([a||{},{decimalSymbol:Qga,groupingSymbol:Rga,fractionDigits:2,negativeParens:!1,prefix:M,suffix:M,scaleFactor:1}]);this.Lz=So(b,bca);a&&Ui(a.fractionDigits)&&fa(a.fractionDigits)&&(this.Lz=ia);this.oua=Wo(b,Xba);this.v4=Wo(b,mca);this.zfa=Wo(b,Vh);this.Bfa=Wo(b,ki);this.gca=ap(b,vca);this.yfa=Lo(b,wca);(this.ud=Xo(b,Th))&&this.ud[He]()in Sga&&(this.ud=Sga[this.ud[He]()]);this.RI=Po(b,Hca);if(0>=this.RI)throw m("Scale factor must be a positive number.");}W(Yp,Vp);
var Sga={decimal:Lp[Ld].Iwa,scientific:Lp[Ld].Rwa,percent:Lp[Ld].XL,currency:Lp[Ld].Dwa,"short":Lp[Ld].Cwa,"long":Lp[Ld].Bwa},Tga=!1,Qga=Tp.DECIMAL_SEP,Rga=Tp.GROUP_SEP,Zp=Tp.DECIMAL_PATTERN;ta(Yp[K],function(a,b){if(a.G(b)==Nh)for(var c=0;c<a.O();c++){var d=a[I](c,b);if(null!=d){var e=this.Sc(d);a.qy(c,b,e);!cj(kj(this.gca))&&0>d&&a[Qc](c,b,ji,Tba+this.gca+zf)}}});
Yp[K].EV=function(a){var b=null,b=a/this.RI;if(null===this.ud){if(fa(this.Lz))return String(a);this.yfa&&(b=h.abs(b));var c=b;0==this.Lz&&(c=h[D](c));b=[];0>c&&(c=-c,b[B](lf));var d=h.pow(10,this.Lz),e=h[D](c*d),c=String(h[Eb](e/d)),d=String(e%d);if(3<c[J]&&this.v4)for(e=c[J]%3,0<e&&(b[B](c[we](0,e),this.v4),c=c[we](e));3<c[J];)b[B](c[we](0,3),this.v4),c=c[we](3);b[B](c);0<this.Lz&&(b[B](this.oua),d[J]<this.Lz&&(d=qaa+d),b[B](d[we](d[J]-this.Lz)));b=b[Fe](M);b=this.zfa+b+this.Bfa;this.yfa&&0>a&&(b=
df+b+ef)}else c=new Lp(this.ud),a=Lp.isEnforceAsciiDigits(),Lp.setEnforceAsciiDigits(!Tga),b=c[Rb](b),b=this.zfa+b+this.Bfa,Lp.setEnforceAsciiDigits(a);return b};function $p(a){if(!a)throw m("Data table is not defined.");if(!Vi(a.fz)){var b=Sca;Oi(a)?b=Eba:Si(a)&&(b=Bba);throw m("You called the draw() method with "+b+" rather than a DataTable or DataView");}}function Uga(a){return null==a?null:Vi(a.fz)?a:Oi(a)?Vga(a):new aq(a)}
function Wga(a){var b={};if(Li(a)!=Ph||Qi(a))b.v=null!=a?a:null;else{b.v="undefined"==typeof a.v?null:a.v;if(null!=a.f)if(typeof a.f===ii)b.f=a.f;else throw m("Formatted value ('f'), if specified, must be a string.");if(null!=a.p)if(typeof a.p===Ph)b.p=a.p;else throw m("Properties ('p'), if specified, must be an object.");}return b}
function Xga(a,b,c){if(typeof b==Ph&&Ug in b){if(Yba in b&&typeof b.desc!=Qg)throw m('Property "desc" in '+c+" must be boolean.");if(Vba in b&&!Vi(b[uc]))throw m('Property "compare" in '+c+" must be a function.");}else throw m(c+' must be an object with a "column" property.');bq(a,b.column)}
function Yga(a,b,c){function d(d,e){for(var f=0;f<c[J];f++){var g=c[f],k=g.column,l=b(d,k),C=b(e,k),k=g[uc]?null===l?null===C?0:-1:null===C?1:g[uc](l,C):cq(a.G(k),l,C);if(0!=k)return k*(g.desc?-1:1)}return 0}if(Vi(c))d=c;else if(Ui(c)||Si(c)){bq(a,c);var e=a[dc](c);c=[{column:e}]}else if(Ri(c))if(Pi(c)){if(1>c[J])throw m("sortColumns is an empty array. Must have at least one element.");for(var f={},g=[],k=0;k<c[J];k++){var l=c[k];if(Ui(l)||Si(l))bq(a,l),e=a[dc](l),l={column:e};else if(Ri(l))e=l.column,
Xga(a,l,Kca+k+Cg);else throw m("sortColumns is an array, but not composed of only objects or numbers.");if(e in f)throw m("Column index "+e+" is duplicated in sortColumns.");f[e]=!0;g[B](l)}c=g}else Xga(a,c,Jca),c=[c];return d}function dq(a,b){var c=a.O();if(0<c){if(h[Eb](b)!==b||0>b||b>=c)throw m("Invalid row index "+b+". Should be in the range [0-"+(c-1)+"].");}else throw m("Table has no rows.");}
function bq(a,b){a[dc](b);if(Ui(b))eq(a,b);else if(-1===a[dc](b))throw m('Invalid column id "'+b+Me);}function eq(a,b){var c=a.L();if(0<c){if(h[Eb](b)!==b||0>b||b>=c)throw m("Invalid column index "+b+". Should be an integer in the range [0-"+(c-1)+"].");}else throw m("Table has no columns.");}function fq(a,b,c){a=a.G(b);if(!Zga(c,a))throw m(jba+c+caa+a+" in column index "+b);}
function Zga(a,b){if(null==a)return!0;var c=typeof a;switch(b){case Nh:if(c==Nh)return!0;break;case ii:if(c==ii)return!0;break;case Qg:if(c==Qg)return!0;break;case Xg:case $g:if(Qi(a))return!0;break;case ni:if(Pi(a)&&0<a[J]&&8>a[J]){for(var c=!0,d=0;d<a[J];d++){var e=a[d];if(typeof e!=Nh||e!=h[Eb](e)){c=!1;break}}if(0>a[0]||0>a[1]||59<a[1]||0>a[2]||59<a[2])c=!1;4==a[J]&&(0>a[3]||999<a[3])&&(c=!1);if(c)return!0}}return!1}
function cq(a,b,c){if(null==b)return null==c?0:-1;if(null==c)return 1;switch(a){case ni:for(a=0;3>a;a++){if(b[a]<c[a])return-1;if(c[a]<b[a])return 1}b=4>b[J]?0:b[3];c=4>c[J]?0:c[3];return b<c?-1:c<b?1:0;default:return b<c?-1:c<b?1:0}}function $ga(a,b){bq(a,b);var c=a[dc](b),d=a.G(c),e=null,f=null,g,k,l=a.O();for(g=0;g<l;g++)if(k=a[I](g,c),null!=k){f=e=k;break}if(null==e)return{min:null,max:null};for(g++;g<l;g++)k=a[I](g,c),null!=k&&(0>cq(d,k,e)?e=k:0>cq(d,f,k)&&(f=k));return{min:e,max:f}}
function aha(a,b){for(var c=Yga(a,function(b,c){return a[I](b,c)},b),d=[],e=a.O(),f=0;f<e;f++)d[B](f);Rj(d,c);return d}function bha(a,b){bq(a,b);var c=a[dc](b),d=a.O();if(0==d)return[];for(var e=[],f=0;f<d;++f)e[B](a[I](f,c));var g=a.G(c);Rj(e,function(a,b){return cq(g,a,b)});c=e[0];d=[];d[B](c);for(f=1;f<e[J];f++){var k=e[f];0!=cq(g,k,c)&&d[B](k);c=k}return d}
function cha(a,b,c){if(Vi(b))return b(a,c);for(var d=0;d<b[J];d++){var e=b[d],f=e.column,g=a[I](c,f),k=a.G(f);if(ti in e){if(0!==cq(k,g,e[wd]))return!1}else if(null!=e.minValue||null!=e.maxValue)if(null==g||null!=e.minValue&&0>cq(k,g,e.minValue)||null!=e.maxValue&&0<cq(k,g,e.maxValue))return!1;if(Vi(e[od])&&!e[od](g,c,f,a))return!1}return!0}
function dha(a,b){if(!Vi(b)){if(!Pi(b)||0==b[J])throw m("columnFilters must be a non-empty array");for(var c={},d=0;d<b[J];d++){if(typeof b[d]!=Ph||!(Ug in b[d])){if(!(ti in b[d]||Lh in b[d]||Hh in b[d]))throw m(Uba+d+'] must have properties "column" and "value", "minValue"or "maxValue"');if(ti in b[d]&&(Lh in b[d]||Hh in b[d]))throw m(Uba+d+'] must specify either "value" or range properties ("minValue" and/or "maxValue"');}var e=b[d].column;bq(a,e);var f=a[dc](e);if(f in c)throw m(Lf+e+" is duplicate in columnFilters.");
fq(a,f,b[d][wd]);c[f]=!0}}c=[];d=a.O();for(e=0;e<d;e++)cha(a,b,e)&&c[B](e);return c}function gq(a,b){var c,d;switch(b){case ni:c=new Date(1970,0,1,a[0],a[1],a[2],a[3]||0);d=Tf;if(a[2]||a[3])d+=yf;a[3]&&(d+=of);d=new Wp({pattern:d});c=d.Sc(c);break;case Xg:d=new Wp({formatType:Kh,valueType:Xg});c=d.Sc(a);break;case $g:d=new Wp({formatType:Kh,valueType:$g});c=d.Sc(a);break;case Nh:d=new Yp({fractionDigits:ia});c=d.Sc(a);break;default:c=null!=a?String(a):M}return c}
function eha(a,b){var c={};if(!Oi(a))throw m("Not an array");if(0<a[J]){var d=!b,e=a[0],f,g;if(d){if(!Oi(e))throw m("First row is not an array.");f=wj(e,function(a){if(Si(a))return{label:a};if(Ri(a))return mk(a);throw m("Unknown header type: "+a);})}else for(f=[],g=0,Oi(e)?g=e[J]:Ri(e)&&(Tg in e)&&Oi(e.c)&&(g=e.c[J]),e=0;e<g;e++)f[B]({type:void 0});c.cols=f;Oa(c,[]);g=f[J];for(var k=ga(f[J]),d=d?Nj(a,1):a,e=0;e<d[J];e++){var l=d[e];if(Oi(l))l={c:l};else if(!(Ri(l)&&Tg in l))throw m("Invalid row type for row "+
e);if(l.c[J]!==f[J])throw m(bba+e+" has "+l.c[J]+" columns, but must have "+f[J]);l.c=Lj(l.c);c[Xc][B](l);for(var n=0;n<g;n++){var p=ii,p=l.c[n];Ri(p)&&(si in p||eh in p)?p=p.v:l.c[n]={v:p};if(null==f[n][H]&&(null==k[n]||k[n]===Xg)&&null!=p){if(Si(p))p=ii;else if(Ui(p))p=Nh;else if(Oi(p))p=ni;else if(Ti(p))p=Qg;else if(Qi(p))p=new Date(p),p=0!==p[gc]()+p[bd]()+p[de]()+p[ge]()?$g:Xg;else throw m("Unknown type of value in "+e+jf+n);k[n]=p}}}X(c[Sb],function(a,b){null!=a[H]||db(a,k[b]||ii)})}return c}
function Vga(a,b){return new aq(eha(a,b))}function fha(a,b,c,d){for(var e=null,f=a.O();(d?0<=b:b<f)&&null===e;)e=a[I](b,c),b+=d?-1:1;return e};var gha={LBa:qf,MBa:rf};function aq(a,b){this.pn=null;this.iz=b===qf?qf:rf;if(!Vi(this.fz))throw m('You called google.visualization.DataTable() without the "new" keyword');a?(Si(a)?a=On(a):hha(a),this.If=[],this.Lf=[],this.ar=a.p||null,null!=a[Sb]&&X(a[Sb],U(function(a){this.Tf(a)},this)),null!=a[Xc]&&(this.Lf=a[Xc])):(this.If=[],this.Lf=[],this.ar=null);this.Cc=[]}W(aq,Up);
function hha(a){var b=a[Sb]||[];a=a[Xc]||[];for(var c=b[J],d=0;d<c;d++){var e=b[d][H];if(e==Xg||e==$g)for(var e=a[J],f=0;f<e;f++){var g=a[f].c[d];if(g){var k=g.v;if(Qi(k))return;Si(k)&&(g=Ln(g),g=On(g),a[f].c[d]=g)}}}}R=aq[K];R.If=null;R.iz=null;R.Lf=null;R.ar=null;R.Cc=null;R.O=function(){return this.Lf[J]};R.L=function(){return this.If[J]};R.Ee=function(a){eq(this,a);return this.If[a].id||M};R.La=function(a){eq(this,a);return String(this.If[a][dd]||M)};R.zv=function(a){eq(this,a);return this.If[a][zb]};
R.fu=function(a){a=this.gj(a,Zh);return a=Si(a)?a:M};R.G=function(a){eq(this,a);return this.If[a][H]};hb(R,function(a,b){dq(this,a);eq(this,b);var c=this.Ss(a,b),d=null;c&&(d=c.v,d=Gi(d)?d:null);return d});R.Ss=function(a,b){return this.Lf[a].c[b]};R.Ca=function(a,b){dq(this,a);eq(this,b);var c=this.Ss(a,b),d=M;if(c)if(null!=c.f)d=c.f;else{this.Cc[a]=this.Cc[a]||[];var e=this.Cc[a],c=e[b]||{};e[b]=c;Gi(c.ef)?d=c.ef:(e=this[I](a,b),null===e||(d=gq(e,this.G(b))),c.ef=d)}return d};
Za(R,function(a,b,c){dq(this,a);eq(this,b);return(a=(a=this.Ss(a,b))&&a.p)&&c in a?a[c]:null});nb(R,function(a,b){dq(this,a);eq(this,b);var c=this.Ss(a,b);c||(c={v:null},this.Lf[a].c[b]=c);c.p||(c.p={});return c.p});R.fz=function(){return this.ar};R.rU=function(a){var b=this.ar;return b&&a in b?b[a]:null};R.Yxa=function(a){this.ar=a};R.Zxa=function(a,b){this.ar||(this.ar={});this.ar[a]=b};R.Fa=function(a,b,c){this.cc(a,b,c,void 0,void 0)};R.qy=function(a,b,c){this.cc(a,b,void 0,c,void 0)};
R.Bw=function(a,b,c){this.cc(a,b,void 0,void 0,c)};R.setProperty=function(a,b,c,d){this[$d](a,b)[c]=d};R.cc=function(a,b,c,d,e){dq(this,a);eq(this,b);var f=this.Cc[a];f&&f[b]&&(f[b]={});f=this.Ss(a,b);f||(f={},this.Lf[a].c[b]=f);"undefined"!=typeof c&&(this.G(b)==Nh&&Si(c)&&!fa(c)?f.v=ha(c):(fq(this,b,c),f.v=c));"undefined"!=typeof d&&(f.f=d);Gi(e)&&(f.p=Ri(e)?e:{})};R.Xxa=function(a,b){dq(this,a);this.Lf[a].p=b};R.Baa=function(a,b,c){this.pL(a)[b]=c};
R.$r=function(a,b){dq(this,a);var c=this.Lf[a];return(c=c&&c.p)&&b in c?c[b]:null};R.pL=function(a){dq(this,a);a=this.Lf[a];a.p||(a.p={});return a.p};R.Kxa=function(a,b){eq(this,a);Sa(this.If[a],b)};R.ada=function(a,b){eq(this,a);this.If[a].p=b};R.bx=function(a,b,c){this.Ur(a)[b]=c};R.gj=function(a,b){eq(this,a);var c=this.If[a];return(c=c&&c.p)&&b in c?c[b]:null};R.Ur=function(a){eq(this,a);a=this.If[a];a.p||(a.p={});return a.p};
R.tga=function(a,b,c,d){a!==this.If[J]&&(this.Cc=[],eq(this,a));Ri(b)||(b={id:d||M,label:c||M,pattern:M,type:b});c=b[H];if(!gk(yga,c))throw m("Invalid type, "+c+', for column "'+(b[dd]||b.id||a)+'".');if(c=b.role)d=b.p||{},null==d.role&&(d.role=c,b.p=d);this.If[Ee](a,0,b);this.pn=null;for(b=0;b<this.Lf[J];b++)this.Lf[b].c[Ee](a,0,{v:null})};R.Tf=function(a,b,c){this.tga(this.If[J],a,b,c);return this.If[J]-1};function iha(a,b,c){c=Wga(c);fq(a,b,c.v);return c}
R.v1=function(a,b){a!==this.Lf[J]&&(this.Cc=[],dq(this,a));var c;if(Oi(b))c=b;else if(typeof b==Nh){if(b!=h[Eb](b)||0>b)throw m("Invalid value for numOrArray: "+b+". If numOrArray is a number it should be a nonnegative integer.");c=Xj(null,b)}else throw m("Invalid value for numOrArray. Should be a number or an array of arrays of cells.");for(var d=[],e=0;e<c[J];e++){var f=c[e],g=[];if(null===f)for(f=0;f<this.If[J];f++)g[B]({v:null});else if(Oi(f)){if(f[J]!=this.If[J])throw m("Row given with size different than "+
this.If[J]+" (the number of columns in the table).");for(var k=0;k<f[J];k++)g[B](iha(this,k,f[k]))}else throw m("Every row given must be either null or an array.");f={};f.c=g;d[B](f);1E4==d[J]&&(g=d,Yi(Hj,this.Lf,a,0)[Zc](null,g),a+=d[J],d=[])}c=d;Yi(Hj,this.Lf,a,0)[Zc](null,c);return a+d[J]-1};R.$t=function(a){if(typeof a==Nh||Oi(a))return this.v1(this.Lf[J],a);throw m("Argument given to addRows must be either a number or an array");};
R.Vr=function(a){if(Oi(a))return this.$t([a]);if(null!=a)throw m("If argument is given to addRow, it must be an array, or null");return this.$t(1)};R.pq=function(a){return $ga(this,a)};R.Ap=function(a){return aha(this,a)};rb(R,function(a){this.Cc=[];a=Yga(this,function(a,c){var d=a.c[c];return d?d.v:null},a);Rj(this.Lf,a)});R.pU=function(a){eq(this,a);return a};R.kU=function(a){dq(this,a);return a};Ia(R,function(){return new aq(this.vo())});
R.vo=function(){var a={cols:this.If,rows:this.Lf};this.ar&&(a.p=this.ar);return Mn(a,Nn)};Ca(R,function(){return Kn(this.vo())});R.FU=function(a){return bha(this,a)};R.hD=function(a){return dha(this,a)};R.uha=function(a,b){0>=b||(this.Cc=[],dq(this,a),a+b>this.Lf[J]&&(b=this.Lf[J]-a),this.Lf[Ee](a,b))};R.ey=function(a){this.uha(a,1)};
R.tha=function(a,b){if(!(0>=b)){this.Cc=[];eq(this,a);a+b>this.If[J]&&(b=this.If[J]-a);this.If[Ee](a,b);this.pn=null;for(var c=0;c<this.Lf[J];c++)this.Lf[c].c[Ee](a,b)}};R.fV=function(a){this.tha(a,1)};function hq(a){this.b=a||{};iq||(iq=up()+naa)}var iq=null,jha={red:Wh,blue:Ng,green:lh};function jq(a,b,c){0<b&&c[B](uaa,iq,a,kaa,b,Ne)}
ta(hq[K],function(a,b){if(a.G(b)==Nh){var c=this.b,d=c.min,e=c.max,f=null;if(null==d||null==e)f=a.pq(b),null==e&&(e=f.max),null==d&&(d=h.min(0,f.min));d>=e&&(f=f||a.pq(b),e=f.max,d=f.min);d==e&&(0==d?e=1:0<d?d=0:e=0);var f=e-d,g=c.base||0,g=h.max(d,h.min(e,g)),k=c[r]||100,l=c.showValue;null==l&&(l=!0);for(var n=h[D]((g-d)/f*k),p=k-n,t=0;t<a.O();t++){var u=a[I](t,b),x=[],u=h.max(d,h.min(e,u)),A=h[Cb]((u-d)/f*k);x[B](vaa);jq(ai,1,x);var C=kha(c.colorPositive,Ng),E=kha(c.colorNegative,Wh),Q=c.drawZeroLine?
1:0;0<n?u<g?(jq(wi,A,x),jq(E,n-A,x),0<Q&&jq(Ai,Q,x),jq(wi,p,x)):(jq(wi,n,x),0<Q&&jq(Ai,Q,x),jq(C,A-n,x),jq(wi,k-A,x)):(jq(C,A,x),jq(wi,k-A,x));jq(ai,1,x);u=a[Bd](t,b,Aba);null==u&&(u=a.Ca(t,b),a[Qc](t,b,Aba,u));l&&(x[B](Di),x[B](u));x[B](taa);a.qy(t,b,x[Fe](M))}}});function kha(a,b){a=(a||M)[He]();return jha[a]||b};function kq(a,b,c,d){Qi(a)&&(a=a[jc]());Qi(b)&&(b=b[jc]());Oi(a)&&(a=lq(a));Oi(b)&&(b=lq(b));this.UN=a;this.WN=b;this.Wk=c;this.Xy=d}Pa(kq[K],function(a){var b=this.UN,c=this.WN;if(null==a)return null==b&&null==c;Qi(a)?a=a[jc]():Oi(a)&&(a=lq(a));return(null==b||a>=b)&&(null==c||a<c)});kq[K].ge=function(){return this.Wk};kq[K].getBackgroundColor=function(){return this.Xy};function nq(a,b,c,d,e){kq[L](this,a,b,c,M);this.E4=b-a;0>=this.E4&&(this.E4=1);this.Hua=xn(sn(d).sc);this.Iua=xn(sn(e).sc)}
W(nq,kq);nq[K].getBackgroundColor=function(a){if(!Ui(a))return M;a=Bn(this.Hua,this.Iua,1-(a-this.UN)/this.E4);return yn(a[0],a[1],a[2])};function oq(){this.hT=[]}oq[K].addRange=function(a,b,c,d){this.hT[B](new kq(a,b,c,d))};oq[K].exa=function(a,b,c,d,e){this.hT[B](new nq(a,b,c,d,e))};
ta(oq[K],function(a,b){var c=a.G(b);if(c==Nh||c==ii||c==Xg||c==$g||c==ni)for(c=0;c<a.O();c++){for(var d=a[I](c,b),e=M,f=0;f<this.hT[J];f++){var g=this.hT[f];if(g[Yc](d)){f=g.ge();d=g[xe](d);f&&(e+=Tba+f+zf);d&&(e+=Og+d+zf);break}}a[Qc](c,b,ji,e)}});function lq(a){return 36E5*a[0]+6E4*a[1]+1E3*a[2]+(4==a[J]?a[3]:0)};function pq(a){this.ud=a||M}function lha(a,b,c,d,e,f,g){return 0<f&&g[f-1]==uba?d:b.Ca(a,c[ja(e,10)])}ta(pq[K],function(a,b,c,d){var e=b[0];null!=c&&Li(c)==Nh&&(e=c);c=d||null;for(d=0;d<a.O();d++){var f=this.ud[Ab](/{(\d+)}/g,Yi(lha,d,a,b)),f=f[Ab](/\\(.)/g,Ue);c?a[Qc](d,e,c,f):a.qy(d,e,f)}});Hi(kca,Yp,void 0);ta(Yp[K],Yp[K][Rb]);Yp[K].formatValue=Yp[K].Sc;Hi("google.visualization.NumberFormat.useNativeCharactersIfAvailable",function(a){Tga=a},void 0);Hi("google.visualization.NumberFormat.DECIMAL_SEP",Qga,void 0);Hi("google.visualization.NumberFormat.GROUP_SEP",Rga,void 0);Hi("google.visualization.NumberFormat.DECIMAL_PATTERN",Zp,void 0);Hi("google.visualization.ColorFormat",oq,void 0);ta(oq[K],oq[K][Rb]);oq[K].addRange=oq[K].addRange;oq[K].addGradientRange=oq[K].exa;
Hi("google.visualization.BarFormat",hq,void 0);ta(hq[K],hq[K][Rb]);Hi("google.visualization.ArrowFormat",Ap,void 0);ta(Ap[K],Ap[K][Rb]);Hi("google.visualization.PatternFormat",pq,void 0);ta(pq[K],pq[K][Rb]);Hi("google.visualization.DateFormat",Wp,void 0);ta(Wp[K],Wp[K][Rb]);Wp[K].formatValue=Wp[K].Sc;Hi(kca,Yp,void 0);ta(Yp[K],Yp[K][Rb]);Hi("google.visualization.TableColorFormat",oq,void 0);Hi("google.visualization.TableBarFormat",hq,void 0);ta(hq[K],hq[K][Rb]);
Hi("google.visualization.TableArrowFormat",Ap,void 0);ta(Ap[K],Ap[K][Rb]);Hi("google.visualization.TablePatternFormat",pq,void 0);ta(pq[K],pq[K][Rb]);Hi("google.visualization.TableDateFormat",Wp,void 0);;window.google&&window.google.loader&&window.google.loader.eval&&window.google.loader.eval.visualization&&(window.google.loader.eval.visualization=function(){eval(arguments[0])});



function qq(a,b){return a.onload=b}function vq(a,b){return a.properties=b}function wq(a,b){return a.dispatchEvent=b}function xq(a,b){return a.setPath=b}function yq(a,b){return a.screenX=b}function zq(a,b){return a.screenY=b}function Aq(a,b){return a.send=b}function Bq(a,b){return a.getName=b}function Cq(a,b){return a.keyCode=b}function Dq(a,b){return a.handleEvent=b}function Eq(a,b){return a.setSelection=b}function Fq(a,b){return a.bind=b}function Gq(a,b){return a.altKey=b}
function Hq(a,b){return a.table=b}function Iq(a,b){return a.index=b}function Jq(a,b){return a.setOptions=b}function Kq(a,b){return a.getOption=b}function Lq(a,b){return a.state=b}function Mq(a,b){return a.options=b}function Nq(a,b){return a.getState=b}function Oq(a,b){return a.getContainer=b}function Pq(a,b){return a.getType=b}function Qq(a,b){return a.onreadystatechange=b}function Rq(a,b){return a.cancel=b}function Sq(a,b){return a.metaKey=b}function Tq(a,b){return a.currentTarget=b}
function Uq(a,b){return a.clientX=b}function Vq(a,b){return a.clientY=b}function Wq(a,b){return a.stop=b}function Xq(a,b){return a.title=b}function Yq(a,b){return a.abort=b}function Zq(a,b){return a.getSelection=b}function $q(a,b){return a.visualization=b}function ar(a,b){return a.target=b}function br(a,b){return a.draw=b}function cr(a,b){return a.onclick=b}
var dr="origin",er="relatedTarget",fr="clearTimeout",gr="reverse",Y="data",hr="preventDefault",ir="dispatchEvent",jr="setPath",kr="write",lr="MAX_VALUE",mr="send",nr="getName",or="charCode",pr="keyCode",qr="LatLng",rr="handleEvent",sr="setSelection",tr="source",ur="bounds",vr="contentWindow",wr="altKey",xr="create",yr="table",zr="groups",Ar="toJSON",Br="LatLngBounds",Cr="getStringValue",Dr="setTimeout",Er="stopPropagation",Fr="setOptions",Gr="message",Hr="close",Ir="setImmediate",Jr="maps",Kr="getOption",
Lr="state",Nr="options",Or="protocol",Pr="enabled",Qr="getState",Rr="removeNode",Sr="getContainer",Tr="getType",Ur="offsetX",Vr="offsetY",Wr="gadgets",Xr="open",$r="cancel",as="RequestParameters",bs="button",cs="defineProperties",ds="metaKey",es="currentTarget",fs="readyState",gs="equals",ps="addEventListener",qs="stop",rs="abort",ss="getSelection",ts="ctrlKey",us="scope",vs="then",ws="getPath",xs="view",ys="target",zs="resolve",As="draw",Bs="shiftKey",mha="\n\x3c/script>",nha="\r",oha=" [",pha=" at line ",
qha=" does not fit either the Control or Visualization specification.",rha=" does not fit the Control specification while handling 'ready' event.",sha=" does not fit the Control specification.",Cs=" must be of type '",tha='""',uha='">\n',vha="%$1",wha="%22",xha="%27",yha="&requireauth=1&",Ds="'.",Es="..",zha="./",Fs=".format",Gs="/",Aha="/.",Bha="//",Cha="/chart.html",Dha="/chart.js",Eha="/gviz/tq",Hs="/tq",Is="528",Js="8",Fha=":\n",Gha=";sig:",Hha=";type:",Ks="<CRLF>",Iha="<EMPTY>",Ls="<EOF>",Ms=
"<EOR>",Jha='<script type="text/javascript" src="',Ns="AnnotatedTimeLine",Os="AreaChart",Ps="AreaChart-stacked",Qs="BarChart",Rs="BubbleChart",Ss="CandlestickChart",Kha="Cannot bind a control to itself.",Ts="ColumnChart",Us="ComboChart",Lha="Content-Type",Mha="Custom response handler must be a function.",Nha="Dashboard",Oha="GET",Vs="Gauge",Ws="GeoChart",Xs="Histogram",Ys="ImageRadarChart",Zs="ImageSparkLine",Pha="Incompatible data table: ",Qha="Invalid DataView column type.",$s="Invalid data table format: column #",
Rha="Invalid data table format: must have 3 columns.",Sha="Invalid data table format: must have at least 2 columns.",at="LineChart",Tha="MSXML2.XMLHTTP",Uha="MSXML2.XMLHTTP.3.0",Vha="MSXML2.XMLHTTP.6.0",bt="Map",Wha="Microsoft.XMLHTTP",ct="MotionChart",Xha="Name",Yha="One or more participants failed to draw()",dt="OrgChart",et="POST",ft="PieChart",Zha="Promise cannot resolve to itself",$ha="Request timed out",gt="ScatterChart",ht="SteppedAreaChart",it="Table",aia="The requested control and participant cannot be bound together, as this would introduce a dependency cycle",
bia="Timed out after ",jt="Timeline",kt="TreeMap",cia="Type",lt="WordTree",dia="\\c",mt="^",eia="_table_query_refresh_interval",fia="_table_query_url",gia="abort",nt="addTrendLine",ot="address",pt="annotatedtimeline",hia="application/x-www-form-urlencoded;charset=utf-8",qt="bar",rt="block",iia="callImmediate",st="cancel",tt="cell",ut="chart",vt="click",wt="complete",jia="content-type",kia="control",xt="controls",yt="corechart",lia="dashboard",zt="datatable",mia="date|datetime",nia="detailed_message",
oia="display: none; padding-top: 2px",At="domain",Bt="domainAxis",pia="draw",Ct="drawing",qia="emptyString",Dt="error",ria="file:",Et="focusin",Ft="focusout",sia="gadgets.io.makeRequest",tia="gadgets.io.makeRequest failed",Gt="gauge",Ht="geochart",uia="google.maps.Geocoder",via="google.visualization.LoadArgs",wia="google.visualization.Query",xia="google.visualization.events.addListener",yia="google.visualization.events.addOneTimeListener",zia="google.visualization.events.removeAllListeners",Aia="google.visualization.events.removeListener",
Bia="google.visualization.events.trigger",It="hasLabelsColumn",Cia="hl",Jt="http",Dia="http%",Eia="http://dummy.com",Fia="https%",Gia="identity",Kt="imagesparkline",Hia="invalid_query",Lt="json",Mt="keypress",Nt="latlng",Ot="linktable",Pt="makeRequest",Iia="make_request_failed",Qt="map",Rt="markers",Jia="message",Kia="modifier",St="motionchart",Tt="mousedown",Ut="mouseout",Vt="mouseover",Lia="ms, aborting",Mia="nodetable",Nia="not_modified",Oia="onreadystatechange",Pia="options",Wt="orgchart",Qia=
"padding: 2px",Xt="pending",Ria="percent",Sia="position: absolute; top: 0; left: 0; z-index: 1;",Tia="pub",Yt="ready",Uia="readystatechange",Via="reason",Wia="refresh",Zt="regioncode",$t="regions",Xia="reqId:",au="right",bu="row",cu="select",Yia="series.1.lineWidth",Zia="series.1.pointSize",$ia="series.1.visibleInLegend",aja="sig:",du="span",eu="statechange",bja="stringify",cja="success",fu="table",dja="targetAxes.0",eja="targetAxes.1",gu="targetAxis",hu="text",iu="tick",vu="timeline",fja="timeline.taskMajor",
gja="timeout",wu="tooltip",hja="tqrt",xu="treemap",yu="ui",ija="ui.type",zu="uichange",jja="user_not_authenticated",Au="vAxis",Bu="warning",kja="window.event",lja="withCredentials",Cu="xhr",Du="xhrpost",mja="zx",Eu="|",nja="\u00d7";function Fu(a){this.hra=oja(a);this.p3=a.status;this.Wv=[];this.Xv=[];this.Xv=a.warnings||[];this.Wv=a.errors||[];pja(this.Xv);pja(this.Wv);this.p3!=Dt&&(this.U2=a.sig,this.q=new aq(a[yr],this.hra))}
function pja(a){for(var b=0;b<a[J];b++){var c=a[b].detailed_message;if(c){var d=a[b],c=c?c[Pb](qja)&&!c[Pb](rja)?c:c[Ab](/&/g,Ze)[Ab](/</g,af)[Ab](/>/g,$e)[Ab](/\"/g,bf):M;d.detailed_message=c}}}var qja=/^[^<]*(<a(( )+target=('_blank')?("_blank")?)?( )+(href=('[^']*')?("[^"]*")?)>[^<]*<\/a>[^<]*)*$/,rja=/javascript((s)?( )?)*:/;function oja(a){a=a.version||rf;return gk(gha,a)?a:rf}R=Fu[K];R.U2=null;R.q=null;R.kj=function(){return this.p3==Dt};R.n4=function(){return this.p3==Bu};
function sja(a){for(var b=0;b<a.Wv[J];b++)if(a.Wv[b].reason==Nia)return!0;for(b=0;b<a.Xv[J];b++)if(a.Xv[b].reason==Nia)return!0;return!1}R.Ta=function(){return this.q};function Gu(a,b){return a.kj()&&a.Wv&&a.Wv[0]&&a.Wv[0][b]?a.Wv[0][b]:a.n4()&&a.Xv&&a.Xv[0]&&a.Xv[0][b]?a.Xv[0][b]:null}R.sfa=function(){var a=Gu(this,Via);return null!=a&&a!=M?[a]:[]};R.iK=function(){return Gu(this,Jia)||M};R.K3=function(){return Gu(this,nia)||M};var Hu={K5:"google-visualization-errors"};Hu.fda=Hu.K5+lf;Hu.qfa=Hu.K5+xf;Hu.y5=Hu.K5+"-all-";Hu.k2=Hu.qfa+" container is null";Hu.zqa="background-color: #c00000; color: white; padding: 2px;";Hu.Bqa="background-color: #fff4c2; color: black; white-space: nowrap; padding: 2px; border: 1px solid black;";Hu.Cqa="font: normal 0.8em arial,sans-serif; margin-bottom: 5px;";Hu.Aqa="font-size: 1.1em; color: #0000cc; font-weight: bold; cursor: pointer; padding-left: 10px; color: black;text-align: right; vertical-align: top;";
Hu.dda=0;
Hu.Kd=function(a,b,c,d){if(!Hu.HG(a))throw m(Hu.k2+". message: "+b);c=Hu.Fqa(b,c,d);var e=c.errorMessage;b=c.detailedMessage;c=c[Nr];var f=null!=c.showInTooltip?!!c.showInTooltip:!0,g=(c[H]==Bu?Bu:Dt)==Dt?Hu.zqa:Hu.Bqa,g=g+(c[w]?c[w]:M),k=!!c.removable;d=Fl();var e=d.m(du,{style:g},d[Jb](e)),g=Hu.fda+Hu.dda++,l=d.m(ch,{id:g,style:Hu.Cqa},e);b&&(f?Xq(e,b):(f=ea[Vb](du),Xa(f,b),d[q](l,d.m(ch,{style:Qia},f))));k&&(b=d.m(du,{style:Hu.Aqa},d[Jb](nja)),cr(b,Yi(Hu.I2,l)),d[q](e,b));Hu.Dqa(a,l);c.removeDuplicates&&
Hu.Hqa(a,l);return g};Hu.nc=function(a){if(!Hu.HG(a))throw m(Hu.k2);if(a=Hu.o5(a,!1))Qa(a[w],O),Yl(a)};Hu.ND=function(a,b){if(!Hu.HG(a))throw m(Hu.k2);if(!b)throw m(Hu.qfa+" response is null");if(!b.kj()&&!b.n4())return null;var c=b.sfa(),d=!0;b.kj()&&(d=!(Dj(c,jja)||Dj(c,Hia)));var c=b.iK(),e=b.K3(),d={showInTooltip:d};db(d,b.kj()?Dt:Bu);d.removeDuplicates=!0;return Hu.Kd(a,c,e,d)};Hu.Hxa=function(a){a=ea[ud](a);return Hu.D5(a)?(Hu.I2(a),!0):!1};
Oq(Hu,function(a){a=ea[ud](a);return Hu.D5(a)?a[Ce][Ce]:null});Hu.iU=function(a,b){return function(){try{a[Zc](null,arguments)}catch(c){Vi(b)?b(c):Hu.Kd(b,c[Gr])}}};Hu.I2=function(a){var b=a[Ce];am(a);0==b[cc][J]&&Qa(b[w],O)};Hu.D5=function(a){return Rl(a)&&a.id&&bj(a.id,Hu.fda)&&(a=a[Ce])&&a.id&&bj(a.id,Hu.y5)&&a[Ce]?!0:!1};
Hu.Fqa=function(a,b,c){var d=null!=a&&a?a:Dt,e=M,f={},g=arguments[J];2==g?b&&Li(b)==Ph?f=b:e=null!=b?b:e:3==g&&(e=null!=b?b:e,f=c||{});d=ej(d);e=ej(e);return{errorMessage:d,detailedMessage:e,options:f}};Hu.HG=function(a){return null!=a&&Rl(a)};Hu.o5=function(a,b){for(var c=a[cc],d=null,e=Fl(),f=0;f<c[J];f++)if(c[f].id&&bj(c[f].id,Hu.y5)){d=c[f];e[Rr](d);break}!d&&b&&(d=Hu.y5+Hu.dda++,d=Ql(ch,{id:d,style:oia},null));d&&((c=a[Yb])?e.R_(d,c):e[q](a,d));return d};
Hu.Dqa=function(a,b){var c=Hu.o5(a,!0);Qa(c[w],rt);c[q](b)};Hu.gwa=function(a,b){var c=Hu.o5(a,!0);X(c&&c[cc],function(a){Hu.D5(a)&&b(a)})};Hu.Hqa=function(a,b){var c=/id="?google-visualization-errors-[0-9]*"?/,d=kfa(b),d=d[Ab](c,M),e=[];Hu.gwa(a,function(a){if(a!=b){var g=kfa(a),g=g[Ab](c,M);g==d&&e[B](a)}});X(e,Hu.I2)};function Iu(a){var b;if(0==ea[kc](oh)[J]){b=ea[kc](vh)[0];var c=ea[kc](Pg)[0],d=ea[Vb](oh);b[Lb](d,c)}b=ea[kc](oh)[0];c=ea[Vb](bi);db(c,li);c.src=a;b[q](c)}function tja(a){return function(b){Hu.nc(a);var c=b.kj();c&&Hu.ND(a,b);return!c}};function Ju(){this.yh=this.yh;this.Wz=this.Wz}Ju[K].yh=!1;Ju[K].Yg=function(){return this.yh};Ju[K].$=function(){this.yh||(this.yh=!0,this.D())};function Ku(a,b){var c=Yi(Lu,b);if(a.yh)c[L](void 0);else a.Wz||(a.Wz=[]),a.Wz[B](Gi(void 0)?U(c,void 0):c)}Ju[K].D=function(){if(this.Wz)for(;this.Wz[J];)this.Wz[wb]()()};function Lu(a){a&&typeof a.$==kh&&a.$()}function uja(a){for(var b=0,c=arguments[J];b<c;++b){var d=arguments[b];Pi(d)?uja[Zc](null,d):Lu(d)}};function Mu(a,b){db(this,a);ar(this,b);Tq(this,this[ys]);this.defaultPrevented=this.Xz=!1;this.sea=!0}Mu[K].stopPropagation=function(){this.Xz=!0};Mu[K].preventDefault=function(){this.defaultPrevented=!0;this.sea=!1};function Nu(a){a[hr]()};function Ou(a){Ou[Ke](a);return a}Ou[Ke]=Ji;var vja=!ol||vl(9),wja=!ol||vl(9),xja=ol&&!ul(wf);!ql||ul(Is);pl&&ul("1.9b")||ol&&ul(Js)||nl&&ul("9.5")||ql&&ul(Is);pl&&!ul(Js)||ol&&ul(wf);var yja=ol?Et:"DOMFocusIn",zja=ol?Ft:"DOMFocusOut";function Pu(a,b){Mu[L](this,a?a[H]:M);ar(this,null);Tq(this,null);this.relatedTarget=null;this.offsetY=this.offsetX=0;Uq(this,0);Vq(this,0);yq(this,0);zq(this,0);this.button=0;Cq(this,0);this.charCode=0;this.ctrlKey=!1;Gq(this,!1);this.shiftKey=!1;Sq(this,!1);Lq(this,null);this.I3=!1;this.Aa=null;a&&this[Sc](a,b)}W(Pu,Mu);var Aja=[1,4,2];R=Pu[K];
La(R,function(a,b){this.Aa=a;var c=db(this,a[H]);ar(this,a[ys]||a.srcElement);Tq(this,b);var d=a[er];if(d){if(pl){var e;t:{try{Ou(d[Cd]);e=!0;break t}catch(f){}e=!1}e||(d=null)}}else c==Vt?d=a.fromElement:c==Ut&&(d=a.toElement);this.relatedTarget=d;if(ca[cs])ca[cs](this,{offsetX:{configurable:!0,enumerable:!0,get:this.ofa,set:this.gua},offsetY:{configurable:!0,enumerable:!0,get:this.pfa,set:this.hua}});else this.offsetX=this.ofa(),this.offsetY=this.pfa();Uq(this,void 0!==a[Qd]?a[Qd]:a.pageX);Vq(this,
void 0!==a[Rd]?a[Rd]:a.pageY);yq(this,a.screenX||0);zq(this,a.screenY||0);this.button=a[bs];Cq(this,a[pr]||0);this.charCode=a[or]||(c==Mt?a[pr]:0);this.ctrlKey=a[ts];Gq(this,a[wr]);this.shiftKey=a[Bs];Sq(this,a[ds]);this.I3=rl?a[ds]:a[ts];Lq(this,a[Lr]);a.defaultPrevented&&this[hr]()});function Qu(a,b){return vja?a.Aa[bs]==b:a[H]==vt?0==b:!!(a.Aa[bs]&Aja[b])}function Ru(a){return Qu(a,0)&&!(ql&&rl&&a[ts])}
R.stopPropagation=function(){Pu.e[Er][L](this);this.Aa[Er]?this.Aa[Er]():this.Aa.cancelBubble=!0};R.preventDefault=function(){Pu.e[hr][L](this);var a=this.Aa;if(a[hr])a[hr]();else if(a.returnValue=!1,xja)try{(a[ts]||112<=a[pr]&&123>=a[pr])&&Cq(a,-1)}catch(b){}};R.wua=function(){return this.Aa};R.ofa=function(){return ql||void 0!==this.Aa[Ur]?this.Aa[Ur]:this.Aa.layerX};R.gua=function(a){ca[cs](this,{offsetX:{writable:!0,enumerable:!0,configurable:!0,value:a}})};
R.pfa=function(){return ql||void 0!==this.Aa[Vr]?this.Aa[Vr]:this.Aa.layerY};R.hua=function(a){ca[cs](this,{offsetY:{writable:!0,enumerable:!0,configurable:!0,value:a}})};var Su="closure_listenable_"+(1E6*h[Pc]()|0);function Tu(a){return!(!a||!a[Su])}var Bja=0;function Cja(a,b,c,d,e){this.ap=a;this.EU=null;this.src=b;db(this,c);this.ME=!!d;this.Ka=e;this.key=++Bja;this.FE=this.zU=!1}function Uu(a){a.FE=!0;a.ap=null;a.EU=null;a.src=null;a.Ka=null};function Vu(a){this.src=a;this.wh={};this.dM=0}R=Vu[K];R.add=function(a,b,c,d,e){var f=a[qc]();a=this.wh[f];a||(a=this.wh[f]=[],this.dM++);var g=Wu(a,b,d,e);-1<g?(b=a[g],c||(b.zU=!1)):(b=new Cja(b,this.src,f,!!d,e),b.zU=c,a[B](b));return b};ua(R,function(a,b,c,d){a=a[qc]();if(!(a in this.wh))return!1;var e=this.wh[a];b=Wu(e,b,c,d);return-1<b?(Uu(e[b]),rj[Ee][L](e,b,1),0==e[J]&&(delete this.wh[a],this.dM--),!0):!1});
function Xu(a,b){var c=b[H];if(!(c in a.wh))return!1;var d=Ij(a.wh[c],b);d&&(Uu(b),0==a.wh[c][J]&&(delete a.wh[c],a.dM--));return d}R.nc=function(a){a=a&&a[qc]();var b=0,c;for(c in this.wh)if(!a||c==a){for(var d=this.wh[c],e=0;e<d[J];e++)++b,Uu(d[e]);delete this.wh[c];this.dM--}return b};R.SU=function(a,b){var c=this.wh[a[qc]()],d=[];if(c)for(var e=0;e<c[J];++e){var f=c[e];f.ME==b&&d[B](f)}return d};R.FL=function(a,b,c,d){a=this.wh[a[qc]()];var e=-1;a&&(e=Wu(a,b,c,d));return-1<e?a[e]:null};
R.tV=function(a,b){var c=Gi(a),d=c?a[qc]():M,e=Gi(b);return bk(this.wh,function(a){for(var g=0;g<a[J];++g)if(!(c&&a[g][H]!=d||e&&a[g].ME!=b))return!0;return!1})};function Wu(a,b,c,d){for(var e=0;e<a[J];++e){var f=a[e];if(!f.FE&&f.ap==b&&f.ME==!!c&&f.Ka==d)return e}return-1};var Yu="closure_lm_"+(1E6*h[Pc]()|0),Zu={},Dja=0;function $u(a,b,c,d,e){if(Oi(b)){for(var f=0;f<b[J];f++)$u(a,b[f],c,d,e);return null}c=av(c);return Tu(a)?a.k(b,c,d,e):Eja(a,b,c,!1,d,e)}function Eja(a,b,c,d,e,f){if(!b)throw m("Invalid event type");var g=!!e,k=bv(a);k||(a[Yu]=k=new Vu(a));c=k.add(b,c,d,e,f);if(c.EU)return c;d=Fja();c.EU=d;d.src=a;d.ap=c;a[ps]?a[ps](b[qc](),d,g):a.attachEvent(Gja(b[qc]()),d);Dja++;return c}
function Fja(){var a=Hja,b=wja?function(c){return a[L](b.src,b.ap,c)}:function(c){c=a[L](b.src,b.ap,c);if(!c)return c};return b}function cv(a,b,c,d,e){if(Oi(b)){for(var f=0;f<b[J];f++)cv(a,b[f],c,d,e);return null}c=av(c);return Tu(a)?a.dD(b,c,d,e):Eja(a,b,c,!0,d,e)}function dv(a,b,c,d,e){if(Oi(b))for(var f=0;f<b[J];f++)dv(a,b[f],c,d,e);else c=av(c),Tu(a)?a.hb(b,c,d,e):a&&(a=bv(a))&&(b=a.FL(b,c,!!d,e))&&ev(b)}
function ev(a){if(Ui(a)||!a||a.FE)return!1;var b=a.src;if(Tu(b))return Xu(b.fm,a);var c=a[H],d=a.EU;b.removeEventListener?b.removeEventListener(c,d,a.ME):b.detachEvent&&b.detachEvent(Gja(c),d);Dja--;(c=bv(b))?(Xu(c,a),0==c.dM&&(c.src=null,b[Yu]=null)):Uu(a);return!0}function fv(a){if(!a)return 0;if(Tu(a))return a.fm?a.fm.nc(void 0):0;a=bv(a);if(!a)return 0;var b=0,c;for(c in a.wh)for(var d=a.wh[c][Hb](),e=0;e<d[J];++e)ev(d[e])&&++b;return b}
function Ija(a){if(Tu(a))return a.tV(Tt,!1);a=bv(a);return!!a&&a.tV(Tt,!1)}function Gja(a){return a in Zu?Zu[a]:Zu[a]=Qh+a}function Jja(a,b,c,d){var e=!0;if(a=bv(a))if(b=a.wh[b[qc]()])for(b=b[Hb](),a=0;a<b[J];a++){var f=b[a];f&&f.ME==c&&!f.FE&&(f=Kja(f,d),e=e&&!1!==f)}return e}function Kja(a,b){var c=a.ap,d=a.Ka||a.src;a.zU&&ev(a);return c[L](d,b)}
function Hja(a,b){if(a.FE)return!0;if(!wja){var c=b||Ii(kja),d=new Pu(c,this),e=!0;if(!(0>c[pr]||void 0!=c.returnValue)){t:{var f=!1;if(0==c[pr])try{Cq(c,-1);break t}catch(g){f=!0}if(f||void 0==c.returnValue)c.returnValue=!0}c=[];for(f=d[es];f;f=f[Ce])c[B](f);for(var f=a[H],k=c[J]-1;!d.Xz&&0<=k;k--){Tq(d,c[k]);var l=Jja(c[k],f,!0,d),e=e&&l}for(k=0;!d.Xz&&k<c[J];k++)Tq(d,c[k]),l=Jja(c[k],f,!1,d),e=e&&l}return e}return Kja(a,new Pu(b,this))}function bv(a){a=a[Yu];return a instanceof Vu?a:null}
var gv="__closure_events_fn_"+(1E9*h[Pc]()>>>0);function av(a){if(Vi(a))return a;a[gv]||(a[gv]=function(b){return a[rr](b)});return a[gv]};function hv(){Ju[L](this);this.fm=new Vu(this);this.Yua=this;this.k1=null}W(hv,Ju);hv[K][Su]=!0;R=hv[K];R.vV=function(){return this.k1};R.tB=function(a){this.k1=a};R.addEventListener=function(a,b,c,d){$u(this,a,b,c,d)};R.removeEventListener=function(a,b,c,d){dv(this,a,b,c,d)};
wq(R,function(a){var b,c=this.vV();if(c)for(b=[];c;c=c.vV())b[B](c);var c=this.Yua,d=a[H]||a;if(Si(a))a=new Mu(a,c);else if(a instanceof Mu)ar(a,a[ys]||c);else{var e=a;a=new Mu(d,c);pk(a,e)}var e=!0,f;if(b)for(var g=b[J]-1;!a.Xz&&0<=g;g--)f=Tq(a,b[g]),e=iv(f,d,!0,a)&&e;a.Xz||(f=Tq(a,c),e=iv(f,d,!0,a)&&e,a.Xz||(e=iv(f,d,!1,a)&&e));if(b)for(g=0;!a.Xz&&g<b[J];g++)f=Tq(a,b[g]),e=iv(f,d,!1,a)&&e;return e});R.D=function(){hv.e.D[L](this);this.fm&&this.fm.nc(void 0);this.k1=null};
R.k=function(a,b,c,d){return this.fm.add(String(a),b,!1,c,d)};R.dD=function(a,b,c,d){return this.fm.add(String(a),b,!0,c,d)};R.hb=function(a,b,c,d){return this.fm[Tb](String(a),b,c,d)};function iv(a,b,c,d){b=a.fm.wh[String(b)];if(!b)return!0;b=b[Hb]();for(var e=!0,f=0;f<b[J];++f){var g=b[f];if(g&&!g.FE&&g.ME==c){var k=g.ap,l=g.Ka||g.src;g.zU&&Xu(a.fm,g);e=!1!==k[L](l,d)&&e}}return e&&0!=d.sea}R.SU=function(a,b){return this.fm.SU(String(a),b)};
R.FL=function(a,b,c,d){return this.fm.FL(String(a),b,c,d)};R.tV=function(a,b){return this.fm.tV(Gi(a)?String(a):void 0,b)};function Lja(a){Fi[Dr](function(){throw a;},0)}var jv;
function Mja(){var a=Fi.MessageChannel;"undefined"===typeof a&&"undefined"!==typeof ba&&ba.postMessage&&ba[ps]&&(a=function(){var a=ea[Vb](xh);Qa(a[w],O);a.src=M;ea[lc][q](a);var b=a[vr],a=b[ce];a[Xr]();a[kr](M);a[Hr]();var c=iia+h[Pc](),d=b[Fc][Or]==ria?ff:b[Fc][Or]+Bha+b[Fc].host,a=U(function(a){if((d==ff||a[dr]==d)&&a[Y]==c)this.port1.onmessage()},this);b[ps](Jia,a,!1);this.port1={};this.port2={postMessage:function(){b.postMessage(c,d)}}});if("undefined"!==typeof a&&!ml(vg)&&!ml(ag)){var b=new a,
c={},d=c;b.port1.onmessage=function(){if(Gi(c[yc])){c=c[yc];var a=c.gha;c.gha=null;a()}};return function(a){Da(d,{gha:a});d=d[yc];b.port2.postMessage(0)}}return"undefined"!==typeof ea&&Oia in ea[Vb](bi)?function(a){var b=ea[Vb](bi);Qq(b,function(){Qq(b,null);b[Ce][le](b);b=null;a();a=null});ea[lc][q](b)}:function(a){Fi[Dr](a,0)}};function kv(a,b){lv||Nja();mv||(lv(),mv=!0);nv[B](new Oja(a,b))}var lv;function Nja(){if(Fi.Promise&&Fi.Promise[zs]){var a=Fi.Promise[zs]();lv=function(){a[vs](Pja)}}else lv=function(){var a=Pja;if(!Vi(Fi[Ir])||Fi.Window&&Fi.Window[K][Ir]==Fi[Ir])jv||(jv=Mja()),jv(a);else Fi[Ir](a)}}var mv=!1,nv=[];function Pja(){for(;nv[J];){var a=nv;nv=[];for(var b=0;b<a[J];b++){var c=a[b];try{c.lxa[L](c[us])}catch(d){Lja(d)}}}mv=!1}function Oja(a,b){this.lxa=a;this.scope=b};function Qja(a){a[K].then=a[K][vs];a[K].$goog_Thenable=!0}function Rja(a){if(!a)return!1;try{return!!a.$goog_Thenable}catch(b){return!1}};function ov(a,b){this.o=0;this.ht=void 0;this.En=this.Xd=null;this.sT=this.R2=!1;try{var c=this;a[L](b,function(a){pv(c,2,a)},function(a){pv(c,3,a)})}catch(d){pv(this,3,d)}}function Sja(){var a,b,c=new ov(function(c,e){a=c;b=e});return new Tja(c,a,b)}ov[K].then=function(a,b,c){return Uja(this,Vi(a)?a:null,Vi(b)?b:null,c)};Qja(ov);Rq(ov[K],function(a){0==this.o&&kv(function(){var b=new qv(a);Vja(this,b)},this)});
function Vja(a,b){if(0==a.o)if(a.Xd){var c=a.Xd;if(c.En){for(var d=0,e=-1,f=0,g;g=c.En[f];f++)if(g=g.cL)if(d++,g==a&&(e=f),0<=e&&1<d)break;0<=e&&(0==c.o&&1==d?Vja(c,b):(d=c.En[Ee](e,1)[0],Wja(c,d,3,b)))}}else pv(a,3,b)}function Xja(a,b){a.En&&a.En[J]||2!=a.o&&3!=a.o||Yja(a);a.En||(a.En=[]);a.En[B](b)}
function Uja(a,b,c,d){var e={cL:null,Vfa:null,Wfa:null};e.cL=new ov(function(a,g){e.Vfa=b?function(c){try{var e=b[L](d,c);a(e)}catch(n){g(n)}}:a;e.Wfa=c?function(b){try{var e=c[L](d,b);!Gi(e)&&b instanceof qv?g(b):a(e)}catch(n){g(n)}}:g});e.cL.Xd=a;Xja(a,e);return e.cL}ov[K].Qda=function(a){this.o=0;pv(this,2,a)};ov[K].Rda=function(a){this.o=0;pv(this,3,a)};
function pv(a,b,c){if(0==a.o){if(a==c)b=3,c=new TypeError(Zha);else{if(Rja(c)){a.o=1;c[vs](a.Qda,a.Rda,a);return}if(Ri(c))try{var d=c[vs];if(Vi(d)){Zja(a,c,d);return}}catch(e){b=3,c=e}}a.ht=c;a.o=b;Yja(a);3!=b||c instanceof qv||$ja(a,c)}}function Zja(a,b,c){function d(b){f||(f=!0,a.Rda(b))}function e(b){f||(f=!0,a.Qda(b))}a.o=1;var f=!1;try{c[L](b,e,d)}catch(g){d(g)}}function Yja(a){a.R2||(a.R2=!0,kv(a.fwa,a))}
ov[K].fwa=function(){for(;this.En&&this.En[J];){var a=this.En;this.En=[];for(var b=0;b<a[J];b++)Wja(this,a[b],this.o,this.ht)}this.R2=!1};function Wja(a,b,c,d){if(2==c)b.Vfa(d);else{if(b.cL)for(;a&&a.sT;a=a.Xd)a.sT=!1;b.Wfa(d)}}function $ja(a,b){a.sT=!0;kv(function(){a.sT&&aka[L](null,b)})}var aka=Lja;function qv(a){aj[L](this,a)}W(qv,aj);gb(qv[K],st);function Tja(a,b,c){this.zG=a;this.resolve=b;this.reject=c};function rv(a,b){hv[L](this);this.bw=a||1;this.OD=b||Fi;this.x4=U(this.r4,this);this.cF=Zi()}W(rv,hv);R=rv[K];R.enabled=!1;R.dd=null;R.r4=function(){if(this[Pr]){var a=Zi()-this.cF;0<a&&a<.8*this.bw?this.dd=this.OD[Dr](this.x4,this.bw-a):(this.dd&&(this.OD[fr](this.dd),this.dd=null),this[ir](iu),this[Pr]&&(this.dd=this.OD[Dr](this.x4,this.bw),this.cF=Zi()))}};Ja(R,function(){this.enabled=!0;this.dd||(this.dd=this.OD[Dr](this.x4,this.bw),this.cF=Zi())});
Wq(R,function(){this.enabled=!1;this.dd&&(this.OD[fr](this.dd),this.dd=null)});R.D=function(){rv.e.D[L](this);this[qs]();delete this.OD};function sv(a,b,c){if(Vi(a))c&&(a=U(a,c));else if(a&&typeof a[rr]==kh)a=U(a[rr],a);else throw m("Invalid listener argument");return 2147483647<b?-1:Fi[Dr](a,b||0)}function tv(a){Fi[fr](a)};function uv(){}uv[K].fha=null;uv[K].Pc=function(){var a;(a=this.fha)||(a={},bka(this)&&(a[0]=!0,a[1]=!0),a=this.fha=a);return a};var vv;function cka(){}W(cka,uv);function dka(a){return(a=bka(a))?new ActiveXObject(a):new XMLHttpRequest}function bka(a){if(!a.nha&&"undefined"==typeof XMLHttpRequest&&"undefined"!=typeof ActiveXObject){for(var b=[Vha,Uha,Tha,Wha],c=0;c<b[J];c++){var d=b[c];try{return new ActiveXObject(d),a.nha=d}catch(e){}}throw m("Could not create ActiveXObject. ActiveX might be disabled, or MSXML might not be installed");}return a.nha}vv=new cka;function wv(a){hv[L](this);this.headers=new bl;this.VT=a||null;this.vv=!1;this.QT=this.Gd=null;this.sz=this.f3=M;this.Jy=this.P2=this.uT=this.b3=!1;this.UT=0;this.RT=null;this.vda=M;this.a3=this.Raa=!1}W(wv,hv);var eka=/^https?$/i,fka=[et,"PUT"],gka=[];R=wv[K];R.zpa=function(){this.$();Ij(gka,this)};
Aq(R,function(a,b,c,d){if(this.Gd)throw m("[goog.net.XhrIo] Object is active with another request="+this.f3+"; newUri="+a);b=b?b[De]():Oha;this.f3=a;this.sz=M;this.b3=!1;this.vv=!0;this.Gd=this.VT?dka(this.VT):dka(vv);this.QT=this.VT?this.VT.Pc():vv.Pc();Qq(this.Gd,U(this.Hda,this));try{this.P2=!0,this.Gd[Xr](b,String(a),!0),this.P2=!1}catch(e){this.et(5,e);return}a=c||M;var f=this.headers[Jc]();d&&gl(d,function(a,b){f.set(b,a)});d=Aj(f.Ok(),hka);c=Fi.FormData&&a instanceof Fi.FormData;!Dj(fka,b)||
d||c||f.set(Lha,hia);f[Zb](function(a,b){this.Gd.setRequestHeader(b,a)},this);this.vda&&(this.Gd.responseType=this.vda);lja in this.Gd&&(this.Gd.withCredentials=this.Raa);try{ika(this),0<this.UT&&((this.a3=jka(this.Gd))?(this.Gd.timeout=this.UT,this.Gd.ontimeout=U(this.kf,this)):this.RT=sv(this.kf,this.UT,this)),this.uT=!0,this.Gd[mr](a),this.uT=!1}catch(g){this.et(5,g)}});function jka(a){return ol&&ul(9)&&Ui(a.timeout)&&Gi(a.ontimeout)}function hka(a){return jia==a[He]()}
R.kf=function(){"undefined"!=typeof Ei&&this.Gd&&(this.sz=bia+this.UT+Lia,this[ir](gja),this[rs](8))};R.et=function(a,b){this.vv=!1;this.Gd&&(this.Jy=!0,this.Gd[rs](),this.Jy=!1);this.sz=b;kka(this);xv(this)};function kka(a){a.b3||(a.b3=!0,a[ir](wt),a[ir](Dt))}Yq(R,function(){this.Gd&&this.vv&&(this.vv=!1,this.Jy=!0,this.Gd[rs](),this.Jy=!1,this[ir](wt),this[ir](gia),xv(this))});R.D=function(){this.Gd&&(this.vv&&(this.vv=!1,this.Jy=!0,this.Gd[rs](),this.Jy=!1),xv(this,!0));wv.e.D[L](this)};
R.Hda=function(){this.yh||(this.P2||this.uT||this.Jy?lka(this):this.Vua())};R.Vua=function(){lka(this)};function lka(a){if(a.vv&&"undefined"!=typeof Ei&&(!a.QT[1]||4!=yv(a)||2!=a.getStatus()))if(a.uT&&4==yv(a))sv(a.Hda,0,a);else if(a[ir](Uia),4==yv(a)){a.vv=!1;try{if(mka(a))a[ir](wt),a[ir](cja);else{var b;try{b=2<yv(a)?a.Gd.statusText:M}catch(c){b=M}a.sz=b+oha+a.getStatus()+Cg;kka(a)}}finally{xv(a)}}}
function xv(a,b){if(a.Gd){ika(a);var c=a.Gd,d=a.QT[0]?Ji:null;a.Gd=null;a.QT=null;b||a[ir](Yt);try{Qq(c,d)}catch(e){}}}function ika(a){a.Gd&&a.a3&&(a.Gd.ontimeout=null);Ui(a.RT)&&(tv(a.RT),a.RT=null)}R.Uk=function(){return!!this.Gd};function mka(a){var b=a.getStatus(),c;t:switch(b){case 200:case 201:case 202:case 204:case 206:case 304:case 1223:c=!0;break t;default:c=!1}if(!c){if(b=0===b)a=ln(1,String(a.f3)),!a&&self[Fc]&&(a=self[Fc][Or],a=a[mc](0,a[J]-1)),b=!eka[od](a?a[He]():M);c=b}return c}
function yv(a){return a.Gd?a.Gd[fs]:0}R.getStatus=function(){try{return 2<yv(this)?this.Gd.status:-1}catch(a){return-1}};function nka(a){return Si(a.sz)?a.sz:String(a.sz)};function zv(a,b){var c;if(a instanceof zv)this.Nn=Gi(b)?b:a.Nn,Av(this,a.Ul),c=a.Iz,Bv(this),this.Iz=c,Cv(this,a.dw),Dv(this,a.fw),this[jr](a[ws]()),Ev(this,a.lj[Jc]()),c=a.Hz,Bv(this),this.Hz=c;else if(a&&(c=hn(String(a)))){this.Nn=!!b;Av(this,c[1]||M,!0);var d=c[2]||M;Bv(this);this.Iz=Fv(d);Cv(this,c[3]||M,!0);Dv(this,c[4]);this[jr](c[5]||M,!0);Ev(this,c[6]||M,!0);c=c[7]||M;Bv(this);this.Hz=Fv(c)}else this.Nn=!!b,this.lj=new Gv(null,0,this.Nn)}R=zv[K];R.Ul=M;R.Iz=M;R.dw=M;R.fw=null;R.cl=M;
R.Hz=M;R.Cxa=!1;R.Nn=!1;Aa(R,function(){var a=[],b=this.Ul;b&&a[B](Hv(b,oka,!0),xf);if(b=this.dw){a[B](Bha);var c=this.Iz;c&&a[B](Hv(c,oka,!0),waa);a[B](aa(String(b))[Ab](/%25([0-9a-fA-F]{2})/g,vha));b=this.fw;null!=b&&a[B](xf,String(b))}if(b=this[ws]())this.dw&&b[Ib](0)!=Gs&&a[B](Gs),a[B](Hv(b,b[Ib](0)==Gs?pka:qka,!0));(b=this.lj[qc]())&&a[B](Gf,b);(b=this.Hz)&&a[B](Oe,Hv(b,rka));return a[Fe](M)});
R.resolve=function(a){var b=this[Jc](),c=!!a.Ul;c?Av(b,a.Ul):c=!!a.Iz;if(c){var d=a.Iz;Bv(b);b.Iz=d}else c=!!a.dw;c?Cv(b,a.dw):c=null!=a.fw;d=a[ws]();if(c)Dv(b,a.fw);else if(c=!!a.cl){if(d[Ib](0)!=Gs)if(this.dw&&!this.cl)d=Gs+d;else{var e=b[ws]()[ne](Gs);-1!=e&&(d=b[ws]()[mc](0,e+1)+d)}e=d;if(e==Es||e==mf)d=M;else if(gj(e,zha)||gj(e,Aha)){for(var d=bj(e,Gs),e=e[zc](Gs),f=[],g=0;g<e[J];){var k=e[g++];k==mf?d&&g==e[J]&&f[B](M):k==Es?((1<f[J]||1==f[J]&&f[0]!=M)&&f.pop(),d&&g==e[J]&&f[B](M)):(f[B](k),
d=!0)}d=f[Fe](Gs)}else d=e}c?b[jr](d):c=a.lj[qc]()!==M;c?Ev(b,Fv(a.lj[qc]())):c=!!a.Hz;c&&(a=a.Hz,Bv(b),b.Hz=a);return b};Ia(R,function(){return new zv(this)});function Av(a,b,c){Bv(a);a.Ul=c?Fv(b,!0):b;a.Ul&&(a.Ul=a.Ul[Ab](/:$/,M))}function Cv(a,b,c){Bv(a);a.dw=c?Fv(b,!0):b}function Dv(a,b){Bv(a);if(b){b=ha(b);if(fa(b)||0>b)throw m("Bad port number "+b);a.fw=b}else a.fw=null}R.getPath=function(){return this.cl};xq(R,function(a,b){Bv(this);this.cl=b?Fv(a,!0):a;return this});
function Ev(a,b,c){Bv(a);b instanceof Gv?(a.lj=b,a.lj.Y4(a.Nn)):(c||(b=Hv(b,ska)),a.lj=new Gv(b,0,a.Nn));return a}R.Gk=function(a,b){return Ev(this,a,b)};R.zo=function(){return this.lj[qc]()};R.Xc=function(a,b){Bv(this);this.lj.set(a,b);return this};function tka(a,b,c){Bv(a);Oi(c)||(c=[String(c)]);a.lj.setValues(b,c)}function Iv(a,b){return a.lj.get(b)}R.R4=function(a){Bv(this);this.lj[Tb](a);return this};function Bv(a){if(a.Cxa)throw m("Tried to modify a read-only Uri");}
R.Y4=function(a){this.Nn=a;this.lj&&this.lj.Y4(a);return this};function uka(a){return a instanceof zv?a[Jc]():new zv(a,void 0)}function Fv(a,b){return a?b?decodeURI(a):ma(a):M}function Hv(a,b,c){return Si(a)?(a=encodeURI(a)[Ab](b,vka),c&&(a=a[Ab](/%25([0-9a-fA-F]{2})/g,vha)),a):null}function vka(a){a=a[se](0);return Ve+(a>>4&15)[qc](16)+(a&15)[qc](16)}var oka=/[#\/\?@]/g,qka=/[\#\?:]/g,pka=/[\#\?]/g,ska=/[\#\?@]/g,rka=/#/g;function Gv(a,b,c){this.om=a||null;this.Nn=!!c}
function Jv(a){a.ig||(a.ig=new bl,a.Rb=0,a.om&&Dfa(a.om,function(b,c){a.add(ma(b[Ab](/\+/g,Ke)),c)}))}R=Gv[K];R.ig=null;R.Rb=null;R.Vb=function(){Jv(this);return this.Rb};R.add=function(a,b){Jv(this);this.om=null;a=Kv(this,a);var c=this.ig.get(a);c||this.ig.set(a,c=[]);c[B](b);this.Rb++;return this};ua(R,function(a){Jv(this);a=Kv(this,a);return this.ig.$e(a)?(this.om=null,this.Rb-=this.ig.get(a)[J],this.ig[Tb](a)):!1});va(R,function(){this.ig=this.om=null;this.Rb=0});
Va(R,function(){Jv(this);return 0==this.Rb});R.$e=function(a){Jv(this);a=Kv(this,a);return this.ig.$e(a)};R.PU=function(a){var b=this.Qa();return Dj(b,a)};R.Ok=function(){Jv(this);for(var a=this.ig.Qa(),b=this.ig.Ok(),c=[],d=0;d<b[J];d++)for(var e=a[d],f=0;f<e[J];f++)c[B](b[d]);return c};R.Qa=function(a){Jv(this);var b=[];if(Si(a))this.$e(a)&&(b=Kj(b,this.ig.get(Kv(this,a))));else{a=this.ig.Qa();for(var c=0;c<a[J];c++)b=Kj(b,a[c])}return b};
R.set=function(a,b){Jv(this);this.om=null;a=Kv(this,a);this.$e(a)&&(this.Rb-=this.ig.get(a)[J]);this.ig.set(a,[b]);this.Rb++;return this};R.get=function(a,b){var c=a?this.Qa(a):[];return 0<c[J]?String(c[0]):b};R.setValues=function(a,b){this[Tb](a);0<b[J]&&(this.om=null,this.ig.set(Kv(this,a),Lj(b)),this.Rb+=b[J])};
Aa(R,function(){if(this.om)return this.om;if(!this.ig)return M;for(var a=[],b=this.ig.Ok(),c=0;c<b[J];c++)for(var d=b[c],e=aa(String(d)),d=this.Qa(d),f=0;f<d[J];f++){var g=e;d[f]!==M&&(g+=Df+aa(String(d[f])));a[B](g)}return this.om=a[Fe](We)});Ia(R,function(){var a=new Gv;a.om=this.om;this.ig&&(a.ig=this.ig[Jc](),a.Rb=this.Rb);return a});function Kv(a,b){var c=String(b);a.Nn&&(c=c[He]());return c}
R.Y4=function(a){a&&!this.Nn&&(Jv(this),this.om=null,this.ig[Zb](function(a,c){var d=c[He]();c!=d&&(this[Tb](c),this.setValues(d,a))},this));this.Nn=a};R.extend=function(a){for(var b=0;b<arguments[J];b++)gl(arguments[b],function(a,b){this.add(b,a)},this)};var wka=/\/spreadsheet/,xka=/\/(ccc|tq|pub)$/,yka=/^spreadsheets?[0-9]?\.google\.com$/,zka=/^docs\.google\.com*$/,Aka=/^(trix|spreadsheets|docs|webdrive)(-[a-z]+)?\.(corp|sandbox)\.google\.com/,Bka=/^(\w*\.){1,2}corp\.google\.com$/,Cka=/\/spreadsheets(\/d\/[^/]+)?/,Dka=/\/(edit|gviz\/tq|)$/,Eka=/^docs\.google\.com*$/,Fka=/^docs\.sandbox\.google\.com*$/,Gka=/^(\w*\.){1,2}corp\.google\.com$/,Hka=/^\/a\/([\w-]+\.)+\w+/,Lv=/^(\/a\/([\w-]+\.)+\w+)?/,Ika=/^[a-z]+\d+\:[a-z]+\d+$/i,Jka=/^[a-z]+\d+$/i;
function Mv(a){var b=kn(ln(3,a)),c=yka[od](b),d=Aka[od](b),e=Bka[od](b),b=zka[od](b),f=kn(ln(5,a)),g=new RegExp(Lv[tr]+xka[tr]),f=(a=(new RegExp(Lv[tr]+wka[tr]+xka[tr]))[od](f))||g[od](f);return b&&a||(d||e||c)&&f}function Kka(a){var b=kn(ln(3,a)),c=Fka[od](b),d=Gka[od](b),b=Eka[od](b);a=kn(ln(5,a));a=(new RegExp(Lv[tr]+Cka[tr]+Dka[tr]))[od](a);return(b||c||d)&&a}
function Lka(a){if(!Jka[od](a))return null;a=a[De]();for(var b,c=M,d=0;d<a[J];d++){var e=a[se](d);if(65>e||90<e){c=a[we](0,d);b=a[we](d);break}}a=0;d=1;for(e=c[J]-1;0<=e;e--)a+=d*(c[se](e)-64),d*=26;c=a;b=ja(b,10);return fa(b)||0>=b||0>c?null:new xl(c,b)};var Mka={firstLineIsHeader:!1};function Nv(a,b,c,d){b=b[zc](/\r?\n/)[c];Ga(this,a+pha+(c+1)+Fha+b);Ga(this,this[Gr]+(Je+ij(Ke,-1==d?b[J]:d)+mt))}W(Nv,m);Hi("vis.csv.ParseError",Nv,void 0);gb(Nv[K],"ParseError");function Ov(a){this.b=a||{};Zj(Mka,function(a,c){lk(this.b,c,a)},this)}Hi("vis.csv.Parser",Ov,void 0);
jb(Ov[K],function(a){function b(a){a==Ks&&(l--,n=p);t=a}function c(){p=n;if(null!=t){var b=t;b==Ks&&(l++,n=0);t=null;return b}if(k>=g)return Ls;b=a[Ib](k++);n++;var c=!1;b==Je?c=!0:b==nha&&(k<g&&a[Ib](k)==Je&&k++,c=!0);return c?(l++,n=0,Ks):b}function d(){var d=k,e=u;u=!1;var f=c();if(f==Iha)return Ms;if(f==Ls||f==Ks)return e?(b(Iha),M):Ms;if(f==Me){d=k;e=null;for(f=c();f!=Ls;f=c())if(f==Me)if(e=k-1,f=c(),f==Me)e=null;else{if(f==jf||f==Ls||f==Ks){f==Ks&&b(f);break}throw new Nv('Unexpected character "'+
f+'" after quote mark',a,l,n-1);}if(null==e)throw new Nv("Unexpected end of text after open quote",a,l,n);return a[we](d,e)[Ab](/""/g,Me)}for(;f!=Ls&&f!=jf&&f!=Ks;f=c())if(f==Me)throw new Nv("Unexpected quote mark",a,l,n-1);f==jf&&(u=!0);f!=Ls&&f!=Ks||b(f);return a[we](d,f==Ls?k:k-1)[Ab](/[\r\n]+/g,M)}function e(){if(k>=g)return Ls;for(var a=[],b=d();b!=Ms;b=d())a[B](b);return a}var f=this.b.firstLineIsHeader,g=a[J],k=0,l=0,n=0,p=0,t=null,u=!1,x=[],A=[],C=null;f&&(x=e(),C=x[J]);for(var E=e();E!=Ls;E=
e()){null==C&&(C=E[J]);if(E[J]!=C)throw new Nv("Record has "+E[J]+" field"+(1==E[J]?M:ai)+", but expected "+C,a,l-1,-1);if(f){for(var Q={},N=0;N<E[J];N++)Q[x[N]]=E[N];A[B](Q)}else A[B](E)}return A});jb(Ov[K],Ov[K][Pd]);function Nka(a,b,c){this.vra=new Ov;this.rT=null!=c?c:!1;this.tra=a;for(a=0;a<b[J];a++)if(c=b[a],!Oka[c])throw m("Unsupported type: "+c);this.wra=b;this.bc=[]}var Oka={number:function(a){var b=ka(a);if(fa(b))throw m("Not a number "+a);return b},string:function(a){return a},"boolean":function(a){return a[He]()===pi},date:function(a){return new Date(a)},datetime:function(a){return new Date(a)},timeofday:function(a){return a[zc](jf)}};function Pv(a,b){var c=b||{};this.fba=Gi(c.csvColumns);this.Iqa=c.csvColumns;this.rT=!!c.csvHasHeader;this.Y1=c.sendMethod||Mg;this.mpa=!!c.xhrWithCredentials;if(!gk(Pka,this.Y1))throw m("Send method not supported: "+this.Y1);this.Vba=c.makeRequestParams_||{};if(Kka(a)){var d=a,c=new zv(d);433==c.fw&&Dv(c,null);var e=c[ws](),e=e[Ab](/\/edit$/,Eha);c[jr](e);e=kn(ln(3,d));d=!Mi(ha(ln(4,d))||null);d=Gka[od](e)&&d;Av(c,d?Jt:wh);a=c[qc]()}else if(Mv(a)){e=a;c=new zv(e);433==c.fw&&Dv(c,null);d=c[ws]();
d=d[Ab](/\/ccc$/,Hs);/\/pub$/[od](d)&&(d=d[Ab](/\/pub$/,Hs),c.Xc(Tia,tf));c[jr](d);var d=kn(ln(3,e)),e=null!=(ha(ln(4,e))||null),f=Aka[od](d),d=Bka[od](d)&&!f&&e;Av(c,d?Jt:wh);a=c[qc]()}d=a;c=Mv(d);d=kn(ln(5,d));d=Hka[od](d);(c=c&&d)||(d=a,c=Kka(d),d=kn(ln(5,d)),d=Hka[od](d),c=c&&d);this.lpa=c;this.kpa=a;this.X1=Qka++;Qv[B](this)}var Pka={PBa:Cu,QBa:Du,eBa:"scriptInjection",AAa:Pt,Zga:Mg},Rka=new bl({"X-DataSource-Auth":Eg}),Qka=0,Rv={};Pv[K].Sga=30;var Qv=[],Sv=Fi[Wr];
function Ska(){for(var a=0;a<Qv[J];a++){var b=Qv[a];b.L4&&b.Cu()}}function Tka(a,b){var c=a[zd](Oe);-1!=c&&(a=a[we](0,c));var d=a[zd](Gf),e=c=M,f=[];-1==d?c=a:(c=a[we](0,d),e=a[we](d+1),f=e[zc](We));d=[];for(e=0;e<f[J];e++){var g=f[e][zc](Df),k={};gb(k,g[0]);k.V5=f[e];d[B](k)}for(var l in b){f=b[l];g=!1;for(e=0;e<d[J];e++)if(d[e][Nd]==l){d[e].V5=l+Df+aa(f);g=!0;break}g||(e={},gb(e,l),e.V5=l+Df+aa(f),d[B](e))}l=c;if(0<d[J]){l+=Gf;c=[];for(e=0;e<d[J];e++)c[B](d[e].V5);l+=c[Fe](We)}return l}R=Pv[K];
R.Bpa=function(a,b){if(mka(b[ys])){var c;var d=b[ys];try{c=d.Gd?d.Gd.responseText:M}catch(e){c=M}c=ej(c);if(this.fba){var f=new Nka(c,this.Iqa,this.rT),d=f.vra[Pd](f.tra);c=new aq;if(d&&0<d[J]){for(var g=[],k=f.wra,l=0,n=k[J];l<n;l++)g[B]({type:k[l],label:[]});if(f.rT)for(k=0,n=g[J];k<n;k++)g[k][dd][B](d[0][k]);k=0;for(n=g[J];k<n;k++)l=g[k],c.Tf(l[H],l[dd][Fe](Ke));f.bc=g;g=f.bc;n=f=f.rT?1:0;for(k=d[J];n<k;n++){c.Vr();for(var l=0,p=g[J];l<p;l++)c.cc(n-f,l,Oka[g[l][H]](d[n][l]))}}d={};Hq(d,c[Ar]());
d.version=oja(d);d.reqId=a;Tv(d)}else c[Pb](/^({.*})$/)?(c=Qfa(c),Tv(c)):Bda(Xn(c))}else if(this.Iv)Uv(this,wia,nka(b[ys]));else throw m("google.visualization.Query: "+nka(b[ys]));};function Tv(a){var b=a.reqId,c=Rv[b];if(c)Rv[b]=null,c.bF(a);else throw m("Missing query for request id: "+b);}R.Iv=null;R.nV=null;R.AV=null;R.Nj=null;R.f2=null;R.YD=null;R.L4=!0;R.Ml=0;R.oK=null;R.Uk=!1;R.Ln=function(a){if(typeof a!=Nh||0>a)throw m("Refresh interval must be a non-negative number");this.Ml=a;Vv(this)};
function Wv(a){a.AV&&(ba[fr](a.AV),a.AV=null)}function Uv(a,b,c,d){a.bF({version:rf,status:Dt,errors:[{reason:b,message:c,detailed_message:d}]})}
R.Cu=function(){var a;a=this.kpa;var b={};this.Nj&&(b.tq=String(this.Nj));var c=Xia+String(this.X1),d=this.oK;d&&(c+=Gha+d);this.f2&&(c+=Hha+this.f2);b.tqx=c;if(this.YD){var c=[],e;for(e in this.YD)c[B](e+xf+this.YD[e]);b.tqh=c[Fe](zf)}a=Tka(a,b);this.Ml&&(a=new zv(a),ql&&(Bv(a),a.Xc(mja,h[Eb](2147483648*h[Pc]())[qc](36)+h.abs(h[Eb](2147483648*h[Pc]())^Zi())[qc](36))),a=a[qc]());e={};Rv[String(this.X1)]=this;c=this.Y1;b=Oha;c==Du&&(c=Cu,b=et);c==Mg&&(c={},/[?&]alt=gviz(&[^&]*)*$/[od](a)?e=Pt:(d=on(a,
hja)||Mg,d=d[zc](xf),e=d[0],e!==Cu&&e!==Du||!Dj(d,lja)||(c.xhrWithCredentials=!0),gk(Pka,e)||(e=Mg)),e={sendMethod:e,options:c},c=e.sendMethod,e=e[Nr]);if(c==Pt)if(Ii(sia))b=this.Vba,null==b[Sv.io[as].CONTENT_TYPE]&&(b[Sv.io[as].CONTENT_TYPE]=Sv.io.ContentType.TEXT),null==b[Sv.io[as].AUTHORIZATION]&&(b[Sv.io[as].AUTHORIZATION]=Sv.io.AuthorizationType.SIGNED),null==b.OAUTH_ENABLE_PRIVATE_NETWORK&&(b.OAUTH_ENABLE_PRIVATE_NETWORK=!0),null==b.OAUTH_ADD_EMAIL&&(b.OAUTH_ADD_EMAIL=!0),Sv.io.makeRequest(a,
U(this.Apa,this),b),Xv(this);else throw m("gadgets.io.makeRequest is not defined.");else{if(!(d=c==Cu)){if(c=c==Mg)d=Fi[Fc][Vc],c=(new zv(d))[zs](new zv(a))[qc](),d=hn(d),c=hn(c),c=d[3]==c[3]&&d[1]==c[1]&&d[4]==c[4];d=c}if(d){c=void 0;d=a;b==et&&(a=a[zc](Gf),1<=a[J]&&(d=a[0]),2<=a[J]&&(c=a[1]));a=d;d=U(Yi(this.Bpa,this.X1),this);e=this.mpa||!!e.xhrWithCredentials;var f=new wv;gka[B](f);d&&f.k(wt,d);f.dD(Yt,f.zpa);e&&(f.Raa=e);f[mr](a,b,c,Rka)}else{if(this.fba)throw m("CSV files on other domains are not supported. Please use sendMethod: 'xhr' or 'auto' and serve your .csv file from the same domain as this page.");
b=ea[kc](Pg)[0];e=null===this.oK;this.lpa&&e?(e=ea[Vb](yh),Uka(this,e,a),b[q](e)):(Xv(this),Iu(a),Vv(this))}}};function Uka(a,b,c){b.onerror=function(){Xv(a);Iu(c);Vv(a)};qq(b,function(){Xv(a);Iu(c);Vv(a)});Qa(b[w],O);var d=c+yha+(new Date)[jc]();b.src=d}R.Apa=function(a){if(null!=a&&a[Y])Bda(Xn(a[Y]));else{var b=M;a&&a.errors&&(b=a.errors[Fe](Ke));Uv(this,Iia,tia,b)}};function Xv(a){Wv(a);a.AV=ba[Dr](function(){Uv(a,gja,$ha)},1E3*a.Sga)}function Vka(a){a.nV&&(ba[fr](a.nV),a.nV=null)}
function Vv(a){Vka(a);0!=a.Ml&&a.L4&&a.Uk&&(a.nV=ba[Dr](function(){a.Cu()},1E3*a.Ml))}Aq(R,function(a){this.Uk=!0;this.Iv=a;this.Cu()});R.makeRequest=function(a,b){this.Uk=!0;this.Iv=a;this.dza=Pt;this.Vba=b||{};this.Cu()};Yq(R,function(){this.Uk=!1;Wv(this);Vka(this)});R.bF=function(a){Wv(this);a=new Fu(a);if(!sja(a)){this.oK=a.kj()?null:a.U2;var b=this.Iv;b[L](b,a)}};R.setTimeout=function(a){if(typeof a!=Nh||fa(a)||0>=a)throw m("Timeout must be a positive number");this.Sga=a};
R.Wxa=function(a){if(typeof a!=Qg)throw m("Refreshable must be a boolean");return this.L4=a};R.Gk=function(a){if(typeof a!=ii)throw m("queryString must be a string");this.Nj=a};R.Sxa=function(a){this.f2=a;null!=a&&this.Tga(qi,a)};R.Tga=function(a,b){a=a[Ab](/\\/g,Ag);b=b[Ab](/\\/g,Ag);a=a[Ab](/:/g,dia);b=b[Ab](/:/g,dia);a=a[Ab](/;/g,Bg);b=b[Ab](/;/g,Bg);this.YD||(this.YD={});this.YD[a]=b};function Yv(){Wka||(Wka=!0,Fi.IDIModule&&Fi.IDIModule.registerListener(Ska,{pollingInterval:100}),Fi[Wr]&&(Xka(),this.Qga()));var a=Jl(Pg)[0];this.hwa=tja(a)}var Wka=!1;Yv[K].Wga=200;function Zv(){return!!Fi[Wr]&&!!Fi[Wr].rpc}Yv[K].Qga=function(){if(Zv()){var a=Fi[Wr];Vi(a.rpc.register)&&a.rpc.register(Wia,Ska)}else 0<this.Wga&&(this.Wga--,ba[Dr](U(this.Qga,this),100))};
Yv[K].jxa=function(a){var b=a.getString(fia),c=b[He]();if(0==c[zd](Dia)||0==c[zd](Fia))b=ma(b);b=new Pv(b);a=a.getInt(eia);b.Ln(a);return b};Yv[K].cya=function(a){return this.hwa(a)};function Xka(){if(Zv()){var a=Fi[Wr];try{a.rpc.getRelayUrl(Es)||a.rpc.setRelayUrl(Es,Eia)}catch(b){Vi(a.rpc.setRelayUrl)&&a.rpc.setRelayUrl(Es,Eia)}}}Fi[Wr]&&!Zv()&&Iu("//www-opensocial.googleusercontent.com/gadgets/rpc/rpc.v.js");Xka();var bw=Fi.__gvizguard__?Ii(xia):function(a,b,c){a=$v(a);b=$u(a,b,Yka(c));return new aw(b)},cw=Fi.__gvizguard__?Ii(yia):function(a,b,c){a=$v(a);b=cv(a,b,Yka(c));return new aw(b)},ew=Fi.__gvizguard__?Ii(Bia):function(a,b,c){$v(a)[ir](new dw(b,c))},fw=Fi.__gvizguard__?Ii(Aia):function(a){return(a=a&&Vi(a.getKey)&&a.getKey())?ev(a):!1},gw=Fi.__gvizguard__?Ii(zia):function(a){var b=$v(a),b=fv(b);Lu(a.__eventTarget);a.__eventTarget=void 0;return b};
function $v(a){var b=a.__eventTarget;null==b&&(b=new hv,a.__eventTarget=b);return a=b}function Yka(a){return function(b){b&&b.Sva?a(b.Rs):a()}}function aw(a){this.Dxa=a}aw[K].getKey=function(){return this.Dxa};function dw(a,b){Mu[L](this,a);this.Rs=b}W(dw,Mu);dw[K].Sva=function(){return this.Rs};function hw(a){this.pn=null;this.q=a;var b=[];a=a.L();for(var c=0;c<a;c++)b[B](c);this.bc=b;this.Ps=!0;this.Os=null;this.I1=[];this.G1=!0}W(hw,Up);R=hw[K];R.Ta=function(){return this.q};function iw(a){a.G1=!0;a.pn=null}function Zka(a){for(var b=[],c=a.q.O(),d=0;d<c;d++)b[B](d);a.Os=b;iw(a)}
R.pp=function(a){for(var b=this.q,c=fk($ka),d=0;d<a[J];d++){var e=a[d];if(Ui(e)||Si(e))bq(b,e);else if(Ri(e)){var f=e.sourceColumn,e=e.calc;if(Si(e)){if(!c||c&&!Dj(c,e))throw m('Unknown function "'+e+Me);null!=f&&bq(b,f)}}else throw m("Invalid column input, expected either a number, string, or an object.");}b=this.q;for(c=0;c<a[J];c++)if(d=a[c],Si(d))a[c]=this[dc](d);else if(Ri(d)){a[c]=d=nk(d);if(f=d.role)e=d[tb]||{},e.role=f,vq(d,e);f=d.sourceColumn;Si(f)&&(f=d.sourceColumn=this[dc](f));Ui(f)&&
(eq(b,f),d.calc=d.calc||Gia,db(d,d[H]||b.G(f)))}this.bc=a;iw(this)};
function ala(a,b,c){if(Oi(b)){if(Gi(c))throw m("If the first parameter is an array, no second parameter is expected");for(var d=0;d<b[J];d++)dq(a.q,b[d]);return Lj(b)}if(Li(b)==Nh){if(!Li(c)==Nh)throw m("If first parameter is a number, second parameter must be specified and be a number.");if(b>c)throw m("The first parameter (min) must be smaller than or equal to the second parameter (max).");dq(a.q,b);dq(a.q,c);a=[];for(d=b;d<=c;d++)a[B](d);return a}throw m("First parameter must be a number or an array.");
}R.bn=function(a,b){this.Os=ala(this,a,b);this.Ps=!1;iw(this)};R.Gba=function(){return nk(this.bc)};R.Cfa=function(){if(this.Ps){for(var a=[],b=this.q.O(),c=0;c<b;c++)a[B](c);return a}return Lj(this.Os)};R.zxa=function(a){this.pp(vj(this.bc,function(b){return!Dj(a,b)}));iw(this)};R.Axa=function(a,b){var c=ala(this,a,b);this.Ps&&(Zka(this),this.Ps=!1);this.bn(vj(this.Os,function(a){return!Dj(c,a)}));iw(this)};
R.Hfa=function(a){for(var b=0;b<this.bc[J];b++){var c=this.bc[b];if(c==a||Ri(c)&&c.sourceColumn==a)return b}return-1};R.d1=function(a){return this.Ps?0>a||a>=this.q.O()?-1:a:sj(this.Os,a)};R.pH=function(a){eq(this,a);a=this.bc[a];return Ui(a)?a:Ri(a)&&Ui(a.sourceColumn)?a.sourceColumn:-1};R.pU=function(a){a=this.pH(a);return-1==a?a:a=this.q.pU(a)};R.ym=function(a){dq(this,a);return this.Ps?a:this.Os[a]};R.kU=function(a){a=this.ym(a);return a=this.q.kU(a)};
R.O=function(){return this.Ps?this.q.O():this.Os[J]};R.L=function(){return this.bc[J]};R.Ee=function(a){eq(this,a);a=this.bc[a];return Ui(a)?this.q.Ee(a):a.id||M};R.La=function(a){eq(this,a);a=this.bc[a];return Ui(a)?this.q.La(a):a[dd]||M};R.zv=function(a){eq(this,a);a=this.bc[a];return Ui(a)?this.q.zv(a):null};R.fu=function(a){a=this.gj(a,Zh);return a=Si(a)?a:M};R.G=function(a){eq(this,a);a=this.bc[a];return Ui(a)?this.q.G(a):a[H]};
R.Ss=function(a,b){eq(this,b);var c=this.bc[b],d=null,e=this.ym(a);if(Ri(c)){if(this.G1){for(c=0;c<this.bc[J];c++)Ri(this.bc[c])&&(this.I1[c]=[]);this.G1=!1}c=this.I1[b][e];if(!Gi(c)){var c=null,d=this.bc[b],f=d.calc;Si(f)?(f=$ka[f],c=f(this.q,e,d)):Vi(f)&&(c=f[L](null,this.q,e));c=Wga(c);d=d[H];f=c.v;if(cj(kj(d)))throw m('"type" must be specified');if(!Zga(f,d))throw m(jba+f+caa+d);this.I1[b][e]=c}d=c;d.p=Ri(d.p)?d.p:{}}else if(Ui(c))d={v:this.q[I](e,c)};else throw m("Invalid column definition: "+
d);return d};hb(R,function(a,b){return this.Ss(a,b).v});R.Ca=function(a,b){var c=this.Ss(a,b);if(null==c.f){var d=this.bc[b];if(Ri(d))d=this.G(b),c.f=null!=c.v?gq(c.v,d):M;else if(Ui(d)){var e=this.ym(a);c.f=this.q.Ca(e,d)}}return c.f};Za(R,function(a,b,c){a=this[$d](a,b)[c];return Gi(a)?a:null});nb(R,function(a,b){var c=this.Ss(a,b);if(!c.p){var c=this.ym(a),d=this.pH(b);return this.q[$d](c,d)}return c.p});
R.gj=function(a,b){eq(this,a);var c=this.bc[a];return Ui(c)?this.q.gj(c,b):this.Ur(a)[b]||null};R.Ur=function(a){eq(this,a);a=this.bc[a];return Ui(a)?this.q.Ur(a):a[tb]||{}};R.rU=function(a){return this.q.rU(a)};R.fz=function(){return this.q.fz()};R.$r=function(a,b){var c=this.ym(a);return this.q.$r(c,b)};R.pL=function(a){dq(this,a);a=this.ym(a);return this.q.pL(a)};R.pq=function(a){return $ga(this,a)};R.FU=function(a){return bha(this,a)};R.Ap=function(a){return aha(this,a)};
R.hD=function(a){return dha(this,a)};R.Px=function(){var a=this.q;Vi(a.Px)&&(a=a.Px());var a=a.vo(),b=this.L(),c=this.O(),d,e,f,g=[],k=[];for(d=0;d<b;d++){f=this.bc[d];if(Ri(f))e=mk(f),delete e.calc,delete e.sourceColumn;else if(Ui(f))e=a[Sb][f];else throw m(Qha);g[B](e)}for(e=0;e<c;e++){var l=a[Xc][this.Ps?e:this.Os[e]],n=[];for(d=0;d<b;d++){f=this.bc[d];if(Ri(f))f={v:this[I](e,d)};else if(Ui(f))f=l.c[this.bc[d]];else throw m(Qha);n[B](f)}l.c=n;k[B](l)}a.cols=g;Oa(a,k);return a=new aq(a)};
R.vo=function(){for(var a={},b=[],c=0;c<this.bc[J];c++){var d=this.bc[c];Ri(d)&&!Si(d.calc)||b[B](d)}Ej(b)||(a.columns=b);this.Ps||Oa(a,Lj(this.Os));return a};Ca(R,function(){return Ln(this.vo())});function jw(a,b){Si(b)&&(b=On(b));var c=new hw(a),d=b.columns,e=b[Xc];null!=d&&c.pp(d);null!=e&&c.bn(e);return c}
var $ka={emptyString:function(){return M},error:function(a,b,c){var d=c.sourceColumn,e=c.magnitude;if(!Ui(d)||!Ui(e))return null;a=a[I](b,d);return Ui(a)?c.errorType==Ria?a+e/100*a:a+e:null},stringify:function(a,b,c){c=c.sourceColumn;return Ui(c)?a.Ca(b,c):M},fillFromTop:function(a,b,c){c=c.sourceColumn;return Ui(c)?fha(a,b,c,!0):null},fillFromBottom:function(a,b,c){c=c.sourceColumn;return Ui(c)?fha(a,b,c,!1):null},identity:function(a,b,c){c=c.sourceColumn;return Ui(c)?a[I](b,c):null}};function kw(a,b,c){this.tQ=a;this.A=b;this.tL=null;c&&(a=Hm(b),a!=M&&a!=hi||Bm(b,Uh,Xh),this.tL=Ql(ch,{style:Sia}))}function bla(a){return a.tL?(a.tL[Ce]!=a.A&&a.A[q](a.tL),a.tL):a.A}kw[K].Kd=function(a){cla(this,a,Dt)};function lw(a,b){cla(a,b,Bu)}function cla(a,b,c){var d=bla(a);c={removable:!0,type:c};b={id:Hu.Kd(d,b,null,c),message:b,detailedMessage:M,options:c};ew(a.tQ,Dt,b)}kw[K].nc=function(){var a=bla(this);Hu.nc(a)};function mw(a,b,c){try{b[L](c)}catch(d){a.Kd(d[Gr])}};function dla(a){this.fd=a;this.tU=!1}dla[K].Aua=function(a,b){return U(function(){if(!this.tU){var c=arguments;mw(this.fd,function(){a[Zc](b,c)})}},this)};function nw(a){Ju[L](this);this.ea=yp(a);this.Iq=new kw(this,this.ea);this.cw=null;this.Ek=Sja()}W(nw,Ju);Oq(nw[K],function(){return this.ea});function ela(a,b){a.Ek.reject=b}br(nw[K],function(a,b,c){mw(this.Iq,U(function(){this.Zf(a,b,c)},this))});nw[K].Zf=function(a,b,c){$p(a);this.Ek&&this.Ek.zG[$r]();this.Ek=Sja();this.cw&&(this.cw.tU=!0);this.cw=new dla(this.Iq);var d=U(this.cw.Aua,this.cw);this.hl(d,a,b,c)};
nw[K].ic=function(){this.cw&&(this.cw.tU=!0,this.cw=null);this.Ek&&this.Ek.zG&&(this.Ek.zG[$r](),this.Ek=null);this.Ag()};function ow(a,b,c,d){this.Nj=a;this.tQ=b;this.b=c||{};this.A=d;this.fd=null;d&&(this.fd=this.L0=tja(d));if(!(b&&pia in b)||typeof b[As]!=kh)throw m("Visualization must have a draw method.");}R=ow[K];R.L0=null;R.RE=null;R.kL=null;R.q=null;Jq(R,function(a){this.b=a||{}});br(R,function(){this.q&&this.tQ[As](this.q,this.b)});R.Nxa=function(a){var b=this.A;this.fd=a?a:b?this.fd=this.L0:null};
R.rE=function(){if(!this.fd)throw m("If no container was supplied, a custom error handler must be supplied instead.");var a=this;this.Nj[mr](function(b){var c=a.RE;c&&c(b);a.bF(b);(c=a.kL)&&c(b)})};R.bF=function(a){var b=this.fd;b(a)&&(this.q=a.Ta(),this.tQ[As](this.q,this.b))};R.xU=function(a){if(null!=a){if(typeof a!=kh)throw m(Mha);this.RE=a}};R.wU=function(a){if(null!=a){if(typeof a!=kh)throw m("Custom post response handler must be a function.");this.kL=a}};Yq(R,function(){this.Nj[rs]()});function pw(a,b){this.ff=b;this.Sua=a}Aq(pw[K],function(a){this.Iv=a;this.Cu()});pw[K].Cu=function(){var a;a=this.ff;var b={},c,d=this.oK;d&&(c=aja+d);c&&(b.tqx=c,a=Tka(a,b));this.Sua[L](this,U(this.bF,this),a)};pw[K].bF=function(a){a=new Fu(a);if(!sja(a)){this.oK=a.kj()?null:a.U2;var b=this.Iv;b[L](b,a)}};function qw(){this.um=[];this.Mn=[]}function fla(a){Ej(a.um)&&(a.um=a.Mn,a.um[gr](),a.Mn=[])}function rw(a){fla(a);return a.um.pop()}R=qw[K];R.Co=function(){fla(this);return qj(this.um)};R.Vb=function(){return this.um[J]+this.Mn[J]};Va(R,function(){return Ej(this.um)&&Ej(this.Mn)});va(R,function(){this.um=[];this.Mn=[]});Pa(R,function(a){return Dj(this.um,a)||Dj(this.Mn,a)});ua(R,function(a){var b=Tda(this.um,a);if(0>b)return Ij(this.Mn,a);rj[Ee][L](this.um,b,1);return!0});
R.Qa=function(){for(var a=[],b=this.um[J]-1;0<=b;--b)a[B](this.um[b]);for(var c=this.Mn[J],b=0;b<c;++b)a[B](this.Mn[b]);return a};function sw(){if(!Ii(uia))throw m("your page is missing the google maps API");this.ZE=new google[Jr].Geocoder;this.Cc={};this.Cc[Gn({address:M})]={response:[],status:google[Jr].GeocoderStatus.ZERO_RESULTS};this.In=new hl;this.Sv=new bl;this.mE=new qw}Ki(sw);function tw(a,b,c){this.xt=a||[];this.cM=0;this.Vs=b;this.oT=!1;this.eV=new bl;this.rua=c||this.xt[J]}Rq(tw[K],function(){this.oT=!0});
tw[K].finish=function(a,b){var c=Gn(a);this.eV.$e(c)||this.eV.set(c,b);c=[];if(!this.oT){for(var d=this.xt[J],e=this.cM;e<d;e++){var f=Gn(this.xt[e]);if(!this.eV.$e(f))break;f=this.eV.get(f);null!=f&&(f=f.response);c[B](f)}c[J]<this.rua&&this.cM+c[J]<d||(this.cM+=c[J],this.Vs(c),this.cM>=this.xt[J]&&this[$r]())}};function uw(){this.xt=[];this.ZE=null}uw[K].add=function(a){this.xt[B](a)};
uw[K].create=function(a,b,c){if(null!=this.ZE){var d=new tw(a,b,c);this.add(d);this.ZE.geocode(d)}else vga(U(function(){null==this.ZE&&(this.ZE=sw.ac());this[xr](a,b,c)},this))};Rq(uw[K],function(){X(this.xt,function(a){a[$r]()});this.xt=[]});sw[K].geocode=function(a){X(a.xt,U(function(b){var c=Gn(b);c in this.Cc?a.finish(b,this.Cc[c]):(this.Sv.$e(c)||(this.mE.Mn[B](b),this.Sv.set(c,[])),this.Sv.get(c)[B](a))},this));this.Lea()};
sw[K].Lea=function(){if(0!==this.mE.Vb()||0!==this.In.Vb()){var a=0<this.In.Vb()?Jn(this.In.Qa()[0]):this.mE.Co(),b=Gn(a);if(b in this.Cc){var c=this.Sv.get(b),c=this.Cc[b];rw(this.mE);this.hU(a,c.response,c.status);this.Sv[Tb](b)}else 0===this.In.Vb()&&0<this.mE.Vb()?(rw(this.mE),c=this.Sv.get(b),zj(c,function(a){return a.oT})?this.hU(a,null,null):(this.In.add(b),gla(this,a,U(this.hU,this,a)))):0<this.In.Vb()&&gla(this,a,U(this.hU,this,a))}};
function gla(a,b,c){if(Ri(b)&&(b=nk(b),b[ur])){var d=b[ur];b.bounds=new google[Jr][Br](new google[Jr][qr](d.lo.lat,d.lo.lng),new google[Jr][qr](d.hi.lat,d.hi.lng))}a.ZE.geocode(b,c)}function hla(a,b,c){var d=Gn(b),e=a.Sv.get(d);null!=e&&X(e,function(a){a.oT||a.finish(b,c)});a.In[Tb](d);a.Sv[Tb](d)}
sw[K].hU=function(a,b,c){var d=0;if(c==google[Jr].GeocoderStatus.OVER_QUERY_LIMIT)d=520;else if(c==google[Jr].GeocoderStatus.OK){var e=Gn(a);b={response:b,status:c};this.Cc[e]=b;hla(this,a,b)}else hla(this,a,{response:null,status:c});this.tU=!1;sv(U(this.Lea,this),d,this)};function vw(){}function ww(a){if(!(Ri(a)&&Vi(a.L)&&Vi(a.O)))throw m("Invalid data table.");}R=vw[K];R.ik=function(a){return this.Ob(a)?2:0};R.Za=function(a,b,c){return a.L()>b&&c==a.G(b)};function ila(a,b,c,d){for(var e=0;e<d[J];e++)if(a.Za(b,c,d[e]))return!0;return!1}R.indexOf=function(a,b){for(var c=0;c<a.L();c++)if(a.G(c)==b)return c;return-1};function xw(a,b,c){for(var d=0;d<b[J];++d){var e=b[d];if(e>=a.L()||a.G(e)!=c[d])return!1}return!0}
function yw(a,b,c){return a.Za(b,c,Nh)?zw(b,c,function(a){return 0<=a}):!1}function zw(a,b,c){for(var d=h.min(a.O(),20),e=0;e<d;e++){var f=a[I](e,b);if(null!=f&&!c(f))return!1}return!0}R.ira=function(a){return ao(new Yn(-90,90),a)&&!Vk(a)};R.jra=function(a){return ao(new Yn(-180,180),a)&&!Vk(a)};function jla(a){for(var b=a.FU(0),c=h.min(a.O(),20),d=0,e=0;e<c;e++){var f=a[I](e,1);f&&!Dj(b,f)||d++}return.6<d/c};function Aw(){}W(Aw,vw);Aw[K].Ob=function(a){try{this.hd(a)}catch(b){return!1}return!0};Aw[K].hd=function(a){ww(a);var b=a.L();if(2>b)throw m(Sha);for(var c=!0,d=[],e=0;e<b;e++){var f=a.fu(e);cj(f)&&(c?(f=At,c=!1):f=Wg);d[B](f)}if(d[0]!==At)throw m("Invalid data format: first column must be domain.");a=kla(d);return{pg:a.pg,Vl:wj(a[zr],function(a){return{ih:a.Db,pg:a.pg,g:wj(a[zr],function(a){return{vl:a.Db,pg:a.pg}})}})}};
function kla(a){for(var b=[At,Wg],c={groups:[],pg:{}},d=[c],e=-1,f=0;f<a[J];f++){var g=a[f],k=sj(b,g),l=null;0<=k&&(l={Db:f,kl:g,groups:[],pg:{}});if(0<=k&&k<e){e-=k;for(g=0;g<=e;g++)d.pop();e=k;k=d[d[J]-1];d[B](l);k[zr][B](l)}else 0<=e&&g===b[e]?(d.pop(),k=d[d[J]-1],d[B](l),k[zr][B](l)):e+1<b[J]&&g===b[e+1]?(k=d[d[J]-1],e++,d[B](l),k[zr][B](l)):(k=d[d[J]-1],g in k.pg||(k.pg[g]=[]),k.pg[g][B](f))}return c};function Bw(){}W(Bw,vw);Bw[K].Ob=function(a){ww(a);var b=a.L();if(2>b)return!1;var c=a.G(0);if(c!=Xg&&c!=$g||a.G(1)!=Nh)return!1;for(var c=0,d=1;d<b;d++){var e=a.G(d);if(e==Nh)c=0;else if(e==ii){if(c++,2<c)return!1}else return!1}return!0};Bw[K].ik=function(a){if(!this.Ob(a))return 0;var b=!1,c=0<this[zd](a,ii),b=a.O(),d=a.Ap(0);if(50<b)b=!0;else{for(var e=ha[lr],f=ha.MIN_VALUE,g=1;g<b;g++)var k=h.abs(a[I](d[g-1],0)-a[I](d[g],0)),e=0<k&&k<e?k:e,f=k>f?k:f;b=0!=e&&50<f/e?!0:!1}return c&&b?3:c||b?2:1};function Cw(a){this.sca=!!(a||{}).Vga}W(Cw,vw);Cw[K].Ob=function(a){ww(a);var b=0,c=a.L();if(1>c)return!1;if(!this.Za(a,0,Nh)&&(b++,this.sca))for(;b<c&&this.Za(a,b,ii);)b++;for(var d=null;b<c;){var e=a.G(b);if(e==Nh)d={};else if(this.sca&&e==ii){if(!d)return!1}else if(e==Qg){if(!d||d.px)return!1;d.px=b}else return!1;b++}return null!==d};function Dw(a){this.cR=a&&a.Rd||!1;Cw[L](this,a)}W(Dw,Cw);Dw[K].Ob=function(a){ww(a);if(!Dw.e.Ob[L](this,a))return!1;var b=a.L();if(this.cR)for(var c=1;c<b;c++)if(this.Za(a,c,Nh)&&!yw(this,a,c))return!1;return!0};Dw[K].ik=function(a){for(var b=a.L(),c=a.O(),d=0,e=!1,f=0;f<b;f++)this.Za(a,f,Nh)&&(d++,yw(this,a,f)||(e=!0));return this.Ob(a)?1==c||e||this.Za(a,0,ii)?1:2<d&&this.cR?3:1!=d||this.cR?1:2:0};function Ew(){}W(Ew,vw);Ew[K].Ob=function(a){ww(a);var b=a.L();return 3>b||5<b||!this.Za(a,0,ii)||!this.Za(a,1,Nh)||!this.Za(a,2,Nh)||3<b&&!this.Za(a,3,ii)||4<b&&!this.Za(a,4,Nh)?!1:!0};Ew[K].ik=function(a){if(this.Ob(a)){var b;if(this.Za(a,3,ii)){b={};for(var c=0,d=h.min(a.O(),20),e=0;e<d;e++){var f=a[I](e,3);b[f]||c++;b[f]=!0}b=10>c}else b=!1;a=b?3:this.Za(a,3,ii)?1:2}else a=0;return a};function Fw(){}W(Fw,vw);Fw[K].Ob=function(a){try{this.hd(a)}catch(b){return!1}return!0};Fw[K].hd=function(a){ww(a);var b=a.L();if(2!==b&&3!==b)throw m("Invalid data table format: must have 2 or 3 columns.");var c=1,d=2;2===b&&(c--,d--);this.Jb(a,0,ii);this.Jb(a,c,ii);this.Jb(a,d,Nh);return{Nu:c,pna:0,WC:d}};Fw[K].Jb=function(a,b,c){if(!this.Za(a,b,c))throw m($s+b+Cs+c+Ds);};function Mw(a){this.zn=a;this.jaa=new bl}Iq(Mw[K],function(){return this.zn});function Nw(){}W(Nw,vw);Nw[K].Ob=function(a){try{this.hd(a)}catch(b){return!1}return!0};Nw[K].hd=function(a){ww(a);for(var b=[],c=a.L(),d=0;d<c;++d){var e=a.fu(d);if(e===M)b[B](new Mw(d));else{if(1>b[J])throw m("At least 1 data column must come before any role column.");qj(b).jaa.set(e,d)}}if(2!=b[J])throw m("Invalid data table format: must have 2 data columns.");c=b[0];b=b[1];this.Jb(a,c[xc](),mia);this.Jb(a,b[xc](),Nh);return{E_:c,WC:b}};
Nw[K].Jb=function(a,b,c){if(!yj(c[zc](Eu),function(c){return this.Za(a,b,c)},this))throw m($s+b+Cs+c+Ds);};function Ow(){}W(Ow,vw);Ow[K].Ob=function(a){ww(a);var b=a.L();if(5>b||6<b||!(this.Za(a,0,ii)&&this.Za(a,1,Nh)&&this.Za(a,2,Nh)&&this.Za(a,3,Nh)&&this.Za(a,4,Nh))||6==b&&!this.Za(a,5,ii))return!1;for(var b=h.min(a.O(),20),c=0;c<b;c++){var d=a[I](c,1),e=a[I](c,2),f=a[I](c,3),g=a[I](c,4);if(d!=h.min(d,e,f,g)||g!=h.max(d,e,f,g))return!1}return!0};Ow[K].ik=function(a){return this.Ob(a)?3:0};function Pw(){Cw[L](this)}W(Pw,Cw);Pw[K].ik=function(a){var b=this.Za(a,0,Nh),c=a.L();b||c--;return this.Ob(a)?2>c?1:2:0};function Qw(){this.et=null}W(Qw,vw);Qw[K].Ob=function(a){return!!lla(this,a)};Qw[K].hd=function(a){a=lla(this,a);if(null!=a)return a;throw m(this.et);};function lla(a,b){var c=new Mw(0),d=new Mw(1),e=new Mw(2),f=new Mw(3),g=new Mw(4),k=new Mw(5),l=new Mw(6);return a.Jb(b,c[xc](),ii)&&a.Jb(b,d[xc](),ii)&&a.Jb(b,e[xc](),Xg)&&a.Jb(b,f[xc](),Xg)&&a.Jb(b,g[xc](),Nh)&&a.Jb(b,k[xc](),Nh)&&a.Jb(b,l[xc](),ii)?{Zta:c,Nu:d,QH:e,OH:f,Xta:g,$ta:k,Vta:l}:null}
Qw[K].Jb=function(a,b,c){return this.Za(a,b,c)?!0:(this.et=$s+b+Cs+c+Ds,!1)};function Rw(){}W(Rw,vw);Rw[K].Ob=function(a){ww(a);var b;b=a.L();if(1>b||2<b)b=!1;else{var c=!0;2==b&&(c=c&&this.Za(a,0,ii));b=c=c&&yw(this,a,b-1)}if(!b)if(b=a.L(),c=a.O(),0==b||1!=c)b=!1;else{for(var c=!0,d=0;d<b;d++)if(!this.Za(a,d,Nh)){c=!1;break}b=c}return b};Rw[K].ik=function(a){return this.Ob(a)?1<a.O()?2:3:0};function Sw(){}W(Sw,vw);var mla={dBa:$t,CAa:Rt,TEXT:hu,Zga:Mg};Sw[K].Ob=function(a){var b=a.L();if(1>b||2<b)return!1;var c=this.Za(a,0,ii);2==b&&(c=c&&this.Za(a,1,Nh));return c};Sw[K].ik=function(a){return this.Ob(a)?1:0};
Sw[K].hd=function(a,b,c){try{b=b||Mg;var d=0,e,f=-1,g=-1,k=-1,l=-1;if(xw(a,[d,d+1],[Nh,Nh])){e=Nt;k=d;l=d+1;d+=2;if(b===$t)throw m("displayMode must be set to Markers when using lat/long addresses.");b===Mg&&(b=Rt)}else if(xw(a,[d],[ii])){switch(b){case Mg:e=Zt;b=$t;f=d;break;case $t:e=Zt;f=d;break;case Rt:case hu:e=ot;g=d;break;default:throw m("Unknown displayMode: "+b);}d+=1}else throw m("Unknown address type.");var n=null;xw(a,[d],[ii])&&wu!=a.gj(d,Zh)&&(n=d++);var p=null,t=null;xw(a,[d],[Nh])&&
(p=d++,xw(a,[d],[Nh])&&(t=d++));var u=null;xw(a,[d],[ii])&&wu==a.gj(d,Zh)&&(u=d++);e!=Zt&&null!=p&&null==t&&(t=p);if(a.L()!=d)throw m("Table contains more columns than expected (Expecting "+d+" columns)");return{I_:e,f6:b,$I:f,aJ:g,FC:k,GC:l,uJ:n,Lu:p,BC:t,s0:u}}catch(x){return c&&c.Kd(Pha+x),null}};function Tw(){}W(Tw,vw);Tw[K].Ob=function(a){try{this.hd(a)}catch(b){return!1}return!0};Tw[K].hd=function(a){ww(a);if(5!=a.L())throw m("Invalid data table format: must have 5 columns.");this.Jb(a,0,Nh);this.Jb(a,1,Nh);this.Jb(a,2,Nh);this.Jb(a,3,Nh);this.Jb(a,4,ii);return{bla:0,cla:1,ala:2,Zka:3,$ka:4}};Tw[K].Jb=function(a,b,c){if(!this.Za(a,b,c))throw m($s+b+Cs+c+Ds);};function Uw(a){Cw[L](this,a)}W(Uw,Cw);Uw[K].Ob=function(a){ww(a);if(!Uw.e.Ob[L](this,a))return!1;var b=a.L();if(this.cR)for(var c=1;c<b;c++)if(this.Za(a,c,Nh)&&!yw(this,a,c))return!1;return!0};Uw[K].ik=function(a){for(var b=a.L(),c=a.O(),d=0,e=0,f=0;f<b;f++)this.Za(a,f,Nh)?d++:this.Za(a,f,Xg)&&e++;return this.Ob(a)?10>c?1:2>d&&0==e?3:2:0};function Vw(){}W(Vw,vw);Vw[K].Ob=function(a){return nla(this,a)||ola(this,a)};Vw[K].ik=function(a){var b=nla(this,a);a=ola(this,a);return b||a?a?1:3:0};function nla(a,b){ww(b);var c=b.L();if(2>c||3<c)return!1;var d=a.Za(b,0,Nh),d=d&&a.Za(b,1,Nh);3==c&&(d=d&&a.Za(b,2,ii));if(c=d)a.Za(b,0,Nh)&&a.Za(b,1,Nh)?(c=U(a.ira,a),d=U(a.jra,a),c=zw(b,0,c)&&zw(b,1,d)):c=!1;return c}function ola(a,b){ww(b);var c=b.L();return 1>c||2<c||!a.Za(b,0,ii)||2==c&&!a.Za(b,1,ii)?!1:!0};function Ww(){}W(Ww,vw);Ww[K].Ob=function(a){ww(a);var b=a.L();if(3>b||a.G(0)!=ii)return!1;var c=a.G(1);if(c!=Nh&&c!=Xg&&c!=ii||c==ii&&!pla(a)&&!qla(a)||c==Nh&&!zw(a,1,function(a){return Vk(a)}))return!1;for(c=2;c<b;c++){var d=a.G(c);if(d!=Nh&&d!=ii)return!1}return!0};Ww[K].ik=function(a){return this.Ob(a)?this.Za(a,1,Nh)&&!rla(a)?1:3:0};function rla(a){return zw(a,1,function(a){return 1900<a&&2100>a})}
function pla(a){return zw(a,1,function(a){return 7!=a[J]||fa(a[we](0,3))||a[Ib](4)!=wg||fa(a[we](6,7))?!1:!0})}function qla(a){return zw(a,1,function(a){return 6!=a[J]||fa(a[we](0,3))||a[Ib](4)!=eg||fa(a[Ib](5))?!1:!0})};function Xw(){}W(Xw,vw);Xw[K].Ob=function(a){ww(a);var b=a.L();if(2>b||3<b)return!1;var c=this.Za(a,0,ii)&&this.Za(a,1,ii);3==b&&(c=c&&this.Za(a,2,ii));return c&&jla(a)};Xw[K].ik=function(a){return this.Ob(a)?3:0};function Yw(){}W(Yw,vw);Yw[K].Ob=function(a){ww(a);var b=a.L();if(1>b||2<b)return!1;var c=this.Za(a,b-1,Nh);return c=c&&yw(this,a,b-1)};Yw[K].ik=function(a){if(this.Ob(a))if(1==a.O())a=1;else{var b;if(!(b=!this.Za(a,0,ii)||25<a.O())){for(var c=b=0;c<a.O();c++)b+=a[I](c,1);b=!(97<b&&103>b||.97<b&&1.03>b)}a=b?2:3}else a=0;return a};function Zw(){}W(Zw,vw);Zw[K].Ob=function(a){ww(a);var b=a.L();if(0==b)return!1;for(var c=this.Za(a,0,ii)?1:0,d=b>c;c<b;c++)if(!this.Za(a,c,Nh)){d=!1;break}return d};function $w(){}W($w,vw);$w[K].Ob=function(a){try{this.hd(a)}catch(b){return!1}return!0};
$w[K].hd=function(a){if(Oi(a)){var b=a[0];a=a[1];var c=b.L();if(3!==c)throw m("Invalid linkTable format: must have 3 columns.");this.Jb(Ot,b,0,Nh);this.Jb(Ot,b,1,Nh);this.Jb(Ot,b,2,Nh);c=a.L();if(1!==c&&2!==c)throw m("Invalid nodeTable format: must have 1 or 2 columns.");this.Jb(Mia,a,0,ii);2===c&&this.Jb(Mia,a,1,ii);for(var d=[],e=[],f=0,g=b.O();f<g;++f){var k=b[I](f,0),l=b[I](f,1),n=b[I](f,2);e[B]({source:k,target:l,value:n})}f=0;for(g=a.O();f<g;++f)d[B]({name:a[I](f,0),mb:2===c?a[I](f,1):M});return{links:e,
nodes:d}}ww(a);if(3!==a.L())throw m(Rha);this.Jb(zt,a,0,ii);this.Jb(zt,a,1,ii);this.Jb(zt,a,2,Nh);b=new bl;c=[];d=[];e=0;for(f=a.O();e<f;++e)g=a[Cr](e,0),k=a[Cr](e,1),g=sla(b,c,g),k=sla(b,c,k),l=a[I](e,2),d[B]({source:g,target:k,value:l});return{links:d,nodes:c}};function sla(a,b,c){if(a.$e(c))return a.get(c);a.set(c,b[J]);b[B]({name:c,mb:M});return b[J]-1}$w[K].Jb=function(a,b,c,d){if(!this.Za(b,c,d))throw m("Invalid format in "+a+": column #"+c+Cs+d+Ds);};function ax(){}W(ax,vw);ax[K].Ob=function(a){ww(a);var b=a.L();if(2>b||this.Za(a,0,Qg)||this.Za(a,0,ii))return!1;for(var c=1,d=0,e=0;c<b;){var f=a.G(c);if(f==Nh)d++,e=0;else if(f==Qg){if(e++,0==d||1<e)return!1}else return!1;c++}return 0<d};function bx(){}W(bx,vw);bx[K].Ob=function(a){ww(a);for(var b=!0,c=a.L(),d=0;d<c;d++)if(!this.Za(a,d,Nh)){b=!1;break}return b};bx[K].ik=function(a){return this.Ob(a)?2>a.L()?1:2:0};function cx(){}W(cx,vw);cx[K].Ob=function(a){try{this.hd(a)}catch(b){return!1}return!0};cx[K].hd=function(a){ww(a);var b=a.L();if(1>b)throw m("Invalid data table format: must have at least 1 column.");this.Jb(a,0,Xg);for(var c=[],d=1;d<b;d++)this.Jb(a,d,Nh),c[B](d);return{E_:0,dna:c}};cx[K].Jb=function(a,b,c){if(!this.Za(a,b,c))throw m($s+b+Cs+c+Ds);};function dx(){}W(dx,vw);dx[K].Ob=function(a){try{this.hd(a)}catch(b){return!1}return!0};dx[K].hd=function(a){ww(a);if(3!=a.L())throw m(Rha);this.Jb(a,0,ii);this.Jb(a,1,Nh);this.Jb(a,2,ii);return{Nu:0,Una:2,WC:1}};dx[K].Jb=function(a,b,c){if(!this.Za(a,b,c))throw m($s+b+Cs+c+Ds);};function ex(){}W(ex,vw);ex[K].Ob=function(){return!0};function fx(){}W(fx,vw);fx[K].Ob=function(a){try{this.hd(a)}catch(b){return!1}return!0};fx[K].hd=function(a){ww(a);a=a.L();if(2>a)throw m(Sha);return{numColumns:a}};function gx(a){this.b=a||new Do([])}W(gx,vw);var tla=[Xg,Nh,$g];gx[K].Ob=function(a){try{this.hd(a)}catch(b){return!1}return!0};
gx[K].hd=function(a){ww(a);for(var b=[],c=a.L(),d=0;d<c;++d){var e=a.fu(d);if(e===M)b[B]({index:d,pg:{}});else{if(1>b[J])throw m("At least 1 data column must come before any role columns");qj(b).pg[e]=d}}c=b[J];if(3!==c&&4!==c)throw m("Invalid data table format: must have 3 or 4 data columns.");d=4==c;this.Jb(a,b[0][xc],ii);d&&this.Jb(a,b[1][xc],ii);this.Jb(a,b[d?2:1][xc],tla);this.Jb(a,b[d?3:2][xc],tla);return 4===c?(a=!Lo(this.b,fja,!0),{Nu:b[a?1:0],fC:b[a?0:1],QH:b[2],OH:b[3]}):{Nu:b[0],fC:null,
QH:b[1],OH:b[2]}};gx[K].Jb=function(a,b,c){Oi(c)||(c=[c]);if(!ila(this,a,b,c))throw m($s+b+Cs+c+Ds);};function hx(){}W(hx,vw);hx[K].Ob=function(a){try{this.hd(a)}catch(b){return!1}return!0};hx[K].hd=function(a){ww(a);if(2>a.L())throw m("Invalid data table format: must have 2 columns.");this.Jb(a,0,Xg);this.Jb(a,1,Nh);return{Iya:0,Jya:1}};hx[K].Jb=function(a,b,c){Oi(c)||(c=[c]);if(!ila(this,a,b,c))throw m($s+b+Cs+c+Ds);};function ix(){}W(ix,vw);ix[K].Ob=function(a){ww(a);var b=a.L();if(2>b||4<b)return!1;var c=this.Za(a,0,ii)&&this.Za(a,1,ii);2<b&&(c=c&&yw(this,a,2))&&3<b&&(c=c&&this.Za(a,3,Nh));return c&&jla(a)};ix[K].ik=function(a){return this.Ob(a)?3:0};function jx(a){this.jl=Oi(a)?a:ek(ula)}jx[K].rX=function(a){var b=[];Zj(this.jl,function(c){var d=vla[c],e=d&&d[Rb];e&&(e=e.ik(a),0!=e&&b[B]({type:c,Nfa:e,Ae:d.Ae}))});wla(b);return wj(b,function(a){return a[H]})};function wla(a){Rj(a,function(a,c){var d=a.Nfa-c.Nfa;0==d&&(d=a.Ae-c.Ae);return-d})}
var ula={pza:Ns,rwa:Os,vza:Qs,Gza:Rs,Iza:Ss,Qza:Ts,vwa:Us,cAa:Vs,dAa:Ws,Mwa:Xs,iAa:Ys,jAa:Zs,OAa:ct,Nwa:at,YAa:ft,BAa:bt,SAa:dt,Qwa:gt,qBa:Ps,sBa:ht,d8:it,BBa:jt,DBa:kt,Zwa:lt},vla={AnnotatedTimeLine:{format:new Bw,Ae:3},AreaChart:{format:new Dw({Vga:!0}),Ae:2},BarChart:{format:new Cw,Ae:2},BubbleChart:{format:new Ew,Ae:2},CandlestickChart:{format:new Ow,Ae:2},ColumnChart:{format:new Cw,Ae:2},ComboChart:{format:new Pw,Ae:2},Gauge:{format:new Rw,Ae:1},GeoChart:{format:new Sw,Ae:3},Histogram:{format:new Uw,
Ae:3},LineChart:{format:new Cw({Vga:!0}),Ae:2},ImageRadarChart:{format:new Zw,Ae:1},ImageSparkLine:{format:new bx,Ae:1},Map:{format:new Vw,Ae:2},MotionChart:{format:new Ww,Ae:3},OrgChart:{format:new Xw,Ae:2},PieChart:{format:new Yw,Ae:2},ScatterChart:{format:new ax,Ae:2},"AreaChart-stacked":{format:new Dw({Rd:!0}),Ae:2},SteppedAreaChart:{format:new Dw,Ae:2},Table:{format:new ex,Ae:0},Timeline:{format:new gx,Ae:2},TreeMap:{format:new ix,Ae:2},WordTree:{format:new Sw,Ae:2}};Hi("google.visualization.ChartSelection",jx,void 0);jx[K].calculateChartTypes=jx[K].rX;var xla={"google.charts.Bar":qt,AnnotatedTimeLine:pt,AnnotationChart:"annotationchart",AreaChart:yt,BarChart:yt,BubbleChart:yt,CandlestickChart:yt,ColumnChart:yt,ComboChart:yt,Gauge:Gt,GeoChart:Ht,GeoMap:"geomap",Histogram:yt,ImageAreaChart:"imageareachart",ImageBarChart:"imagebarchart",ImageCandlestickChart:"imagechart",ImageChart:"imagechart",ImageLineChart:"imagelinechart",ImagePieChart:"imagepiechart",ImageSparkLine:Kt,IntensityMap:"intensitymap",LineChart:yt,Map:Qt,MotionChart:St,OrgChart:Wt,
PieChart:yt,RangeSelector:yt,ScatterChart:yt,SparklineChart:yt,SteppedAreaChart:yt,Table:fu,Timeline:vu,TreeMap:xu,StringFilter:xt,DateRangeFilter:xt,NumberRangeFilter:xt,CategoryFilter:xt,ChartRangeFilter:xt,NumberRangeSetter:xt,ColumnSelector:xt,Dashboard:xt};function kx(a,b){var c=a.useFormatFromData;Ti(c)&&!c||!cj(kj(a[Rb]))||(b=vj(b,function(a){return!cj(kj(a))}),Vda(b),1==b[J]&&(c=yla(b[0]),ta(a,c)))}function yla(a){cj(kj(a))||(a=a[Ab](/\d/g,pf),a=a[Ab](/#{10,}/,ij(Oe,10)));return a};function zla(a){var b=Ala(a),c=new hw(a);c.pp([0,1,{type:Nh,calc:function(c,e){var f=lx(a,e);return null!=f?b.mL*f.x+b.Csa:null}}]);return c}function Ala(a){var b;b=a.O();for(var c=new xl,d=0;d<b;d++){var e=lx(a,d);null!=e&&(c.x+=e.x,c.y+=e.y)}b=new xl(c.x/b,c.y/b);for(e=d=c=0;e<a.O();e++){var f=lx(a,e);null!=f&&(f=new xl(f.x-b.x,f.y-b.y),c+=f.x*f.y,d+=f.x*f.x)}a={};a.mL=c/d||1;a.Csa=b.y-a.mL*b.x;return a}function lx(a,b){var c=a[I](b,0),d=a[I](b,1);return null==c||null==d?null:new xl(c,d)};function Bla(a){var b=a[Tr](),c=a.Ta();a=a.Pc();var d;t:if(d=a.useFormatFromData,Ti(d)&&!d)d=!1;else{d=[Au,gu,dja,eja,Bt];for(var e=0;e<d[J];e++)if(Ii(d[e]+Fs,a)){d=!1;break t}d=!0}if(d)if(b==Rs)3>c.L()||(b=c.zv(1),d=a.hAxis||{},kx(d,[b]),a.hAxis=d,c=c.zv(2),b=a.vAxes||{},d=b[0]||{},kx(d,[c]),b[0]=d,a.vAxes=b);else{d=a.vAxes||[{},{}];for(var e=a.hAxis||{},f=d[0]||{},g=d[1]||{},k=[],l=[],n=c&&c.L()||0,p=0;p<n;p++)if(c.G(p)==Nh){var t=c.zv(p),u;u=p;0==u?u=null:(u--,u=((a.series||{})[u]||{}).targetAxisIndex||
0);switch(u){case 0:k[B](t);break;case 1:l[B](t)}}b==Qs?kx(e,k):(kx(f,k),kx(g,l));0<n&&c.G(0)!=ii&&(b=b==Qs?f:e,t=c.zv(0),kx(b,[t]));d[0]=f;d[1]=g;a.vAxes=d;a.hAxis=e}}function Cla(a){if(a[Kr](nt)){var b=a.Ta();a[Tr]()==gt&&2==b.L()&&(b=zla(b),a.Gg(b),a.M(Yia,2),a.M(Zia,0),a.M($ia,!1));a.M(nt,null)}}function Dla(a){var b=a.Ta(),c=a.Ck;if(Oi(c))for(var d=0;d<c[J];d++)b=jw(b,c[d]);else null!=c&&(b=jw(b,c));a.DD(null);a.Gg(b)}
function Ela(a){var b=a[Tr]();if((xla[b]||null)==yt&&b!=gt){var b=a.Ta(),c=a[Kr](It);if(null!=c){for(var d=[{calc:c?bja:qia,sourceColumn:0,type:ii}],e=b.L(),c=c?1:0;c<e;c++)d[B](c);b=new hw(b);b.pp(d);a.M(It,null);a.Gg(b)}}};function mx(a,b){Ju[L](this);var c=b||{};Si(c)&&(c=On(c));this.A=c.container||null;this.Mx=c.containerId||null;this.xI=null;this.YO=a;this.Ng=c[a+cia]||null;this.gi=c[a+Xha]||null;this.iC=null;$q(this,null);this.kP=null;this.ff=c.dataSourceUrl||null;this.q=null;this.Gg(c.dataTable);this.b=c[Nr]||{};this.o=c[Lr]||{};var d=c.packages;this.jP=Gi(d)?d:null;this.Nj=c.query||null;this.Ml=c.refreshInterval||null;this.Ck=c[xs]||null;this.wG=null;this.y8=[Dla,Ela,Bla,Cla];this.k9=c.isDefaultVisualization||
!Gi(c.isDefaultVisualization)}W(mx,Ju);R=mx[K];R.eea=null;R.qV=null;R.D=function(){this[bc]();mx.e.D[L](this)};va(R,function(){nx(this)});
br(R,function(a){a&&this.Afa(a);a=this[Sr]();try{if(null==this[Tr]())throw m("The "+this.YO+" type is not defined.");if(zp(this[Tr]()))this.vfa(a);else{var b=U(this.vfa,this,a),b=Hu.iU(b,U(this.Wq,this,a)),c=this.jP;if(null==c){var d=this[Tr](),d=d[Ab](ica,M),c=xla[d]||null;if(null==c)throw m("Invalid visualization type: "+d);}Si(c)&&(c=[c]);var c={packages:c,callback:b},e=Ii(lca);null===e&&(e=raa);c=c?c:{callback:Ji};c.callback=c.callback||Ji;var f,d=null,g=Ii(via);g&&0<=mn(g,0,Cia,g[Kc](nn))&&(d=
on(g,Cia));(f=d)&&!c.language&&(c.language=f);rga(qga.ac(),e,c)}}catch(k){this.Wq(a,k)}});Ia(R,function(){var a=this.vo(),a=new this[Bc](a);a.wG=this.wG;return a});Ca(R,function(){var a=Fla(this,this.Ta());a.container=void 0;return Ln(a)});R.vo=function(){return Fla(this,this.eea||this.Ta())};
function Fla(a,b){var c=a.jP,d=void 0;null===b||(d=Vi(b.Px)?b.Px().vo():b.vo());c={container:a.A||void 0,containerId:a.Mx||void 0,dataSourceUrl:a.ff||void 0,dataTable:d,options:a.Pc()||void 0,state:a[Qr]()||void 0,packages:null===c?void 0:c,refreshInterval:a.Ml||void 0,query:a.zo()||void 0,view:a.Ck||void 0,isDefaultVisualization:a.Nca()};c[a.YO+cia]=a[Tr]()||void 0;c[a.YO+Xha]=a[nr]()||void 0;a.Mca(c);return c}R.Mca=function(){};R.GV=function(){return this.ff};R.Ta=function(){return this.q};
Pq(R,function(){return this.Ng});Bq(R,function(){return this.gi});R.T5=function(){return this[he]};Oq(R,function(){var a;if(!(a=this.A))t:{if(!this.xI){a=this.Mx;if(null==a){a=null;break t}var b=Il(a);if(!Rl(b))throw m("The container #"+a+" is null or not defined.");this.xI=b}a=this.xI}return a});R.FV=function(){return this.Mx};R.zo=function(){return this.Nj};R.HV=function(){return this.Ml};Kq(R,function(a,b){return ox(this.b,a,b)});
function ox(a,b,c){a=-1==b[zd](mf)?a[b]:Ii(b,a);c=Gi(c)?c:null;return null!=a?a:c}R.Pc=function(){return this.b};Nq(R,function(){return this.o});R.Nca=function(){return this.k9};R.Oi=function(a){this.ff=a};R.Oxa=function(a){this.wG=a};R.txa=function(){return this.wG};R.Gg=function(a){this.q=Uga(a)};R.Pv=function(a){this.Ng=a};R.po=function(a){this.gi=a};R.Afa=function(a){this.xI=this.Mx=this.A=null;Si(a)?this.Mx=a:this.A=a};R.KV=function(a){this.xI=this.A=null;this.Mx=a};
R.Gk=function(a){this.Nj=a};R.Ln=function(a){this.Ml=a};R.M=function(a,b){Gla(this.b,a,b)};function Gla(a,b,c){null==c?Mi(ox(a,b))||(c=b[zc](mf),1<c[J]&&(b=c.pop(),a=ox(a,c[Fe](mf))),delete a[b]):Hi(b,c,a)}Jq(R,function(a){this.b=a||{}});R.setProperty=function(a,b){var c=a[zc](mf);if(0<c[J]){var d=c[wb]();if(d=Hla[d])if(0===c[J])d.set[Zc](this,b);else d=d.get[Zc](this),Gla(d,c[Fe](mf),b)}};R.ed=function(a){this.o=a||{}};R.fK=function(a){this.jP=a};R.DD=function(a){this.Ck=a};
R.$xa=function(a){a!=this[he]&&(this.kP=a)};R.y7=function(a){this.k9=a};R.zT=function(){return new this[Bc](this.vo())};R.IV=function(){return this.Ck};R.Q5=function(){return this.jP};R.Wq=function(a,b){var c=b&&b[Gr]||Dt,d=Hu.Kd(a,c);ew(this,Dt,{id:d,message:c})};
R.qS=function(a,b){var c=zp(this[Tr]());if(!c)throw m("Invalid "+this.YO+" type: "+this[Tr]());this.kP&&(nx(this),$q(this,this.kP),this.kP=null);var d;if(d=this[he]&&this[he][Bc]==c)d=(d=this[he])&&Vi(d[Sr])?d[Sr]()==a:!1;d?c=this[he]:(nx(this),c=new c(a));this.iC&&this.iC!=c&&Vi(this.iC.ic)&&this.iC.ic();this.iC=c;Ila(this,c);this.eea=b;d=Co(this.Pc());d=new px({chartType:this[Tr](),dataTable:b,options:d,view:this.Ck});for(var e=0;e<this.y8[J];e++)this.y8[e](d);c[As](d.Ta(),d.Pc(),this[Qr]())};
R.Gxa=function(a){Oi(this.Ck)?this.Ck[B](a):this.Ck=null===this.Ck?[a]:[this.Ck,a]};R.sta=function(a,b){if(b.kj()){var c=b.iK(),d=b.K3(),e=Hu.ND(a,b);ew(this,Dt,{id:e,message:c,detailedMessage:d})}else this.qS(a,b.Ta())};function Ila(a,b){Jla(a);var c=[];X([Yt,cu,Dt,eu],function(d){var e=bw(b,d,function(c){d==Yt&&(a.iC=null,$q(a,b));d!=Yt&&d!=eu||!Vi(b[Qr])||a.ed(b[Qr][L](b));ew(a,d,c)});c[B](e)});a.qV=c}
R.vfa=function(a){var b=this.Ta();if(b)this.qS(a,b);else if(null!=this.ff)b=U(this.sta,this,a),b=Hu.iU(b,U(this.Wq,this,a)),this.mT(b,!0);else throw m("Cannot draw chart: no data specified.");};R.mT=function(a,b){var c=Ti(b)?b:!1,d=new Pv(this.ff||M),e=this.Ml;e&&c&&d.Ln(e);(c=this.zo())&&d.Gk(c);d[mr](a)};function nx(a){a[he]&&Vi(a[he].ic)&&a[he].ic();Jla(a);Lu(a[he]);$q(a,null)}function Jla(a){Oi(a.qV)&&(X(a.qV,function(a){fw(a)}),a.qV=null)}
var Hla={name:{get:mx[K][nr],set:mx[K].po},type:{get:mx[K][Tr],set:mx[K].Pv},container:{get:mx[K][Sr],set:mx[K].Afa},containerId:{get:mx[K].FV,set:mx[K].KV},options:{get:mx[K].Pc,set:mx[K][Fr]},state:{get:mx[K][Qr],set:mx[K].ed},dataSourceUrl:{get:mx[K].GV,set:mx[K].Oi},dataTable:{get:mx[K].Ta,set:mx[K].Gg},refreshInterval:{get:mx[K].HV,set:mx[K].Ln},query:{get:mx[K].zo,set:mx[K].Gk},view:{get:mx[K].IV,set:mx[K].DD}};function px(a){mx[L](this,ut,a)}W(px,mx);R=px[K];R.fe=mx[K].T5;R.zO=mx[K].$xa;
R.Ld=mx[K].Pv;R.Xa=mx[K][Tr];R.b_=mx[K].po;R.a_=mx[K][nr];function qx(a){mx[L](this,kia,a)}W(qx,mx);R=qx[K];R.WT=mx[K].T5;R.Mxa=mx[K].Pv;R.sxa=mx[K][Tr];R.Lxa=mx[K].po;R.rxa=mx[K][nr];function rx(){this.tc=new hl;this.dl=new hl;this.Ci=new hl}R=rx[K];va(R,function(){this.tc=new hl;this.dl=new hl;this.Ci=new hl});Ia(R,function(){var a=new rx;a.tc=new hl(this.tc.Qa());a.dl=new hl(this.dl.Qa());a.Ci=new hl(this.Ci.Qa());return a});ab(R,function(a){return this.tc[gs](a.tc)&&this.dl[gs](a.dl)&&this.Ci[gs](a.Ci)});function sx(a,b){var c=[];$k(b==bu?a.tc:a.dl,function(a){c[B](ja(a,10))});return c}function tx(a){return sx(a,bu)}
function ux(a){var b=[];$k(a.Ci,function(a){a=a[zc](jf);b[B]({row:ja(a[0],10),column:ja(a[1],10)})});return b}Zq(R,function(){for(var a=[],b=tx(this),c=sx(this,Ug),d=ux(this),e=0;e<b[J];e++){var f={};f.row=b[e];f.column=null;a[B](f)}for(e=0;e<c[J];e++)f={row:null},f.column=c[e],a[B](f);for(e=0;e<d[J];e++)f={},f.row=d[e].row,f.column=d[e].column,a[B](f);return a});function vx(a,b){return a.tc[Yc](String(b))}function wx(a,b){return a.dl[Yc](String(b))}
function xx(a,b,c){if(b==bu?vx(a,c[0]):b==Ug?wx(a,c[0]):a.Ci[Yc](String(c[0]+jf+c[1])))return!1;b==bu?a.tc.add(String(c[0])):b==Ug?a.dl.add(String(c[0])):a.Ci.add(String(c[0]+jf+c[1]));return!0}R.Vr=function(a){return xx(this,bu,[a])};R.Tf=function(a){return xx(this,Ug,[a])};function yx(a,b,c){var d=vx(a,b);c&&a[bc]();d?a.ey(b):a.Vr(b)}function zx(a,b,c){var d=wx(a,b);c&&a[bc]();d?a.fV(b):a.Tf(b)}function Ax(a,b,c,d){var e=a.Ci[Yc](String(b+jf+c));d&&a[bc]();e?a.C4(b,c):xx(a,tt,[b,c])}
R.ey=function(a){if(!vx(this,a))return!1;this.tc[Tb](String(a));return!0};R.fV=function(a){if(!wx(this,a))return!1;this.dl[Tb](String(a));return!0};R.C4=function(a,b){if(!this.Ci[Yc](String(a+jf+b)))return!1;this.Ci[Tb](String(a+jf+b));return!0};
Eq(R,function(a){var b=new hl,c=new hl,d=new hl;a||(a=[]);for(var e=0;e<a[J];e++){var f=a[e];null!=f.row&&null!=f.column?d.add(String(f.row+jf+f.column)):null!=f.row?b.add(String(f.row)):null!=f.column&&c.add(String(f.column))}var g=b.qm(this.tc),k=c.qm(this.dl),l=d.qm(this.Ci);a=this.tc.qm(b);e=this.dl.qm(c);f=this.Ci.qm(d);this.tc=b;this.dl=c;this.Ci=d;b=new rx;b.tc=g;b.dl=k;b.Ci=l;c=new rx;c.tc=a;c.dl=e;c.Ci=f;return new Kla(b,c)});function Kla(a,b){this.cC=a;this.dC=b};function Bx(a){Ju[L](this);this.Bd=a;this.me={}}W(Bx,Ju);var Lla=[];R=Bx[K];R.k=function(a,b,c,d){return Cx(this,a,b,c,d)};function Dx(a,b,c,d,e){Cx(a,b,c,d,!1,e)}function Cx(a,b,c,d,e,f){Oi(c)||(c&&(Lla[0]=c[qc]()),c=Lla);for(var g=0;g<c[J];g++){var k=$u(b,c[g],d||a[rr],e||!1,f||a.Bd||a);if(!k)break;a.me[k.key]=k}return a}R.dD=function(a,b,c,d){return Mla(this,a,b,c,d)};
function Mla(a,b,c,d,e,f){if(Oi(c))for(var g=0;g<c[J];g++)Mla(a,b,c[g],d,e,f);else{b=cv(b,c,d||a[rr],e,f||a.Bd||a);if(!b)return a;a.me[b.key]=b}return a}R.hb=function(a,b,c,d,e){if(Oi(b))for(var f=0;f<b[J];f++)this.hb(a,b[f],c,d,e);else c=c||this[rr],e=e||this.Bd||this,c=av(c),d=!!d,b=Tu(a)?a.FL(b,c,d,e):a?(a=bv(a))?a.FL(b,c,d,e):null:null,b&&(ev(b),delete this.me[b.key]);return this};R.nc=function(){Zj(this.me,ev);this.me={}};R.D=function(){Bx.e.D[L](this);this.nc()};
Dq(R,function(){throw m("EventHandler.handleEvent not implemented");});function Ex(a){Ju[L](this);this.A=a;this.H=new Bx(this)}W(Ex,Ju);R=Ex[K];R.D=function(){this[bc]();Ex.e.D[L](this)};va(R,function(){this.H.nc();Lu(this.H);Yl(this.A)});Oq(R,function(){return this.A});R.addEventListener=function(a,b,c,d,e){e?Cx(this.H,a,b,c,d,e):this.H.k(a,b,c,d)};br(R,function(){});Nq(R,function(){return{}});function Fx(a){nw[L](this,a);this.iha=[]}W(Fx,nw);R=Fx[K];R.D=function(){this[bc]();Fx.e.D[L](this)};va(R,function(){this.Ag()});R.Ag=function(){this.qJ&&(fw(this.qJ),Lu(this.qJ),this.qJ=null);Lu(this.Mc);this.Mc=null;Yl(this.ea)};R.wa=null;R.eB=null;R.b=null;R.Mc=null;R.qJ=null;R.x_=null;R.o=null;R.qv=null;R.Ta=function(){return this.wa};R.Pc=function(){return this.b};R.mh=function(){return{}};R.Pl=function(a,b){return gp(b,yu,{})};R.Gs=function(){return M};R.Uea=function(a){this.iha=a};R.aS=function(){return this.iha};
R.Eq=function(){};Nq(R,function(){return this.o?On(Ln(this.o)):null});br(R,function(a,b,c){$p(a);this.wa=a;this.eB=b||{};this.x_=c||{};mw(this.Iq,this.wB,this)});
R.wB=function(){if(this.wa){this.o=this.x_||{};if(!Ri(this.o))throw m("Control state must be an object.");this.qv=this.qv||this.o;this.b=new Do([this.eB,this.mh()||{}]);this.Eq(this.wa,this.b,this.o);if(!this.Mc){var a=Wo(this.b,ija,this.Gs());this.Mc=(a=zp(a))?new a(this.ea):null;if(!this.Mc)throw m("Invalid Ui instance.");this.qJ=bw(this.Mc,zu,U(this.oma,this))}this.Mc[As](this.o,this.Pl(this.wa,this.b));this.o=this.Mc[Qr]();ew(this,Yt,null)}};R.oma=function(a){this.o=this.Mc[Qr]();ew(this,eu,a)};
R.Gt=function(){mw(this.Iq,this.Pva,this)};R.Pva=function(){this.qv&&(this.x_=this.qv,this.wB())};function Gx(){this.qh=new bl;this.wt=new bl;this.Tv=new bl}function Nla(a,b,c){Ola(a,b,c)||(a.qh.set(Hx(b),b),a.qh.set(Hx(c),c),Pla(b,c,a.wt),Pla(c,b,a.Tv))}R=Gx[K];va(R,function(){this.qh[bc]();this.wt[bc]();this.Tv[bc]()});Va(R,function(){return this.qh[ld]()});R.cU=function(){try{return Qla(this),!0}catch(a){return!1}};R.Vb=function(){return this.qh.Vb()};R.Qa=function(){return this.qh.Qa()};Pa(R,function(a){return this.qh.$e(Hx(a))});
function Ola(a,b,c){b=Hx(b);return a.wt.$e(b)&&a.wt.get(b)[Yc](Hx(c))}function Ix(a,b){if(!a[Yc](b))return null;var c=a.Tv.get(Hx(b));return c?Nea(c,function(a){return this.qh.get(a)},a):null}R.Vf=function(a){return this[Yc](a)?(a=this.wt.get(Hx(a)))?Nea(a,function(a){return this.qh.get(a)},this):null:null};function Jx(a){if(a.qh[ld]())return[];var b=[];gl(a.wt,function(a,d){this.Tv.$e(d)||b[B](this.qh.get(d))},a);if(0==b[J])throw m("Invalid state: DAG has not root node(s).");return b}
function Qla(a){for(var b=Rla(a.Tv),c=[],d=wj(Jx(a),function(a){return Hx(a)},a);0<d[J];){for(var e=[],f=0;f<d[J];f++){var g=d[f];c[B](a.qh.get(g));var k=a.wt.get(g);k&&gl(k,function(a){b.get(a)[Tb](g);b.get(a)[ld]()&&(b[Tb](a),e[B](a))})}d=e}if(c[J]!=a.qh.Vb())throw m("cycle detected");}Ia(R,function(){return this[ld]()?new Gx:Gx[K].sU[Zc](this,Jx(this))});R.sU=function(a){var b=new Gx;if(0==arguments[J])return b;for(var c=0;c<arguments[J];c++)Sla(this,arguments[c],b);return b};
function Sla(a,b,c){var d=a.Vf(b);d&&gl(d,function(a){Nla(c,b,a);Sla(this,a,c)},a)}function Hx(a){var b=typeof a;return b==Ph&&a||b==kh?Oh+Wi(a):b[mc](0,1)+a}function Pla(a,b,c){var d=c.get(Hx(a));d||(d=new hl,c.set(Hx(a),d));d.add(Hx(b))}function Tla(a,b,c){var d=c.get(Hx(a));d[Tb](Hx(b));d[ld]()&&c[Tb](Hx(a))}function Ula(a,b){return!a.wt.$e(Hx(b))&&!a.Tv.$e(Hx(b))}function Rla(a){var b=new bl;gl(a,function(a,d){b.set(d,a[Jc]())});return b};function Kx(a){Ju[L](this);this.uh=new Gx;this.Je=new rx;this.D2={};this.kE={};this.FK=null;this.vE=[];this.fd=new kw(this,a);this.Gn=null}W(Kx,Ju);R=Kx[K];Zq(R,function(){return this.Je[ss]()});R.D=function(){this[bc]();Kx.e.D[L](this)};va(R,function(){X(this.vE,function(a){fw(a)});this.vE=[];this.Gn=null;this.uh[bc]()});R.Wq=function(a){this.fd.Kd(a)};
Fq(R,function(a,b){if(Vla(a))if(Wla(b)){var c=Wi(a);if(Wi(b)==c)this.Wq(Kha);else{c=[];this.uh[Yc](a)||c[B](a);this.uh[Yc](b)||c[B](b);Nla(this.uh,a,b);var d;this.uh.cU()?d=!0:(this.Wq(aia),d=!1);if(d)for(d=0;d<c[J];d++){var e=c[d];this.vE[B](bw(e,eu,U(this.Nta,this,e)));this.vE[B](bw(e,Yt,U(this.Lta,this,e)));this.vE[B](bw(e,Dt,U(this.Kta,this,e)));e.getChart&&this.vE[B](bw(e,cu,U(this.Mta,this,e)))}else c=this.uh,Ola(c,a,b)&&(Tla(a,b,c.wt),Tla(b,a,c.Tv),Ula(c,a)&&c.qh[Tb](Hx(a)),Ula(c,b)&&c.qh[Tb](Hx(b)))}}else this.Wq(b+
qha);else this.Wq(a+sha)});br(R,function(a){if(a&&!this.uh[ld]()){this.FK=Uga(a);this.Gn=new Lx(this);a=Jx(this.uh);for(var b=0;b<a[J];b++)a[b].Gg(this.FK);this.Gn[y](a)}});function Wla(a){return Ri(a)&&Vi(a[As])&&Vi(a.setDataTable)}function Vla(a){return Wla(a)&&Vi(a.getControl)}R.Nta=function(a){this.Gn=this.Gn||new Lx(this);Xla(this.Gn,a)};
R.Lta=function(a){var b;if(b=Vla(a)){b=a.WT();var c;if(c=Ri(b)){if(Vi(b.applyOperator))t:{b=this.uh;c=b.sU(a);for(var d=c.Qa(),e=0;e<d[J];e++){var f=d[e];if(f!=a&&Ix(c,f)[J]!=Ix(b,f)[J]){b=!1;break t}}b=!0}else b=Vi(b[Zc]);c=b}b=!c}b?this.Wq(a+rha):(this.Gn=this.Gn||new Lx(this),Xla(this.Gn,a))};function Yla(a,b){var c=b.row,d=b.column;if(null!=c||null!=d)null==c?a.Je.fV(d):null==d?a.Je.ey(c):a.Je.C4(c,d)}
R.Mta=function(a){var b=Wi(a),c=a.getChart()[ss]();this.D2[b]||(this.D2[b]=new rx);var c=vj(wj(c,function(b){for(var c=a.Ta();c!==this.FK;){b={row:null==b.row?null:c.getTableRowIndex(b.row),column:null==b.column?null:c.getTableColumnIndex(b.column)};0>b.row&&(b.row=null);0>b.column&&(b.column=null);if(null==b.row&&null==b.column)return null;c=c.Ta()}return b},this),Ni),d=this.D2[b][sr](c),c=d.cC[ss](),d=d.dC[ss]();X(c,function(a){var c=a.row+jf+a.column;this.kE[c]||(this.kE[c]=new hl);this.kE[c].add(b);
c=a.row;a=a.column;if(null!=c||null!=a)null==c?this.Je.Tf(a):null==a?this.Je.Vr(c):xx(this.Je,tt,[c,a])},this);X(d,function(a){var c=a.row+jf+a.column;this.kE[c]?(this.kE[c][Tb](b),0===this.kE[c].Vb()&&Yla(this,a)):Yla(this,a)},this)};R.Kta=function(a){this.Gn&&this.Gn.handleError(a)};function Zla(a,b){b?ew(a,Yt,null):a.Wq(Yha);a.Gn=null}
function $la(a,b){if(1==b[J])return b[0];for(var c=b[0],d=Nj(b,1),e=new hl(ama(a,d[0])),f=1;f<d[J]&&(e=e.lA(ama(a,d[f])),!e[ld]());f++);for(var f=[],g=0;g<c.O();g++)e[Yc](bma(a,c,g))&&f[B](g);e=new hl(cma(a,d[0]));for(g=1;g<d[J]&&(e=e.lA(cma(a,d[g])),!e[ld]());g++);d=[];for(g=0;g<c.L();g++)e[Yc](dma(a,c,g))&&d[B](g);c=new hw(c);c.bn(f);c.pp(d);return c}function ama(a,b){for(var c=[],d=0;d<b.O();d++){var e=bma(a,b,d);null!=e&&c[B](e)}return c}
function bma(a,b,c){for(;b!==a.FK;)c=b.ym(c),b=b.Ta();return c}function cma(a,b){for(var c=[],d=0;d<b.L();d++){var e=dma(a,b,d);null!=e&&c[B](e)}return c}function dma(a,b,c){for(;b!==a.FK&&-1!==c;)c=b.pH(c),b=b.Ta();-1==c&&(c=null);return c}function Lx(a){this.Gq=a;this.uh=a.uh[Jc]();this.Zq={};a=this.uh.Qa();for(var b=0;b<a[J];b++)this.Zq[Wi(a[b])]=Yt}Ja(Lx[K],function(a){Lx[K].Pfa[Zc](this,a);for(var b=0;b<a[J];b++)this.Zf(a[b])});
function Xla(a,b){if(a.uh[Yc](b)){switch(a.Zq[Wi(b)]){case Xt:break;case Dt:break;case Ct:a.Zq[Wi(b)]=Yt;ema(a,b);break;case Yt:a.Pfa(b);ema(a,b);break;default:Wi(b)}fma(a)}}Lx[K].handleError=function(a){if(this.uh[Yc](a)){switch(this.Zq[Wi(a)]){case Xt:case Yt:case Dt:break;case Ct:this.Zq[Wi(a)]=Dt;a=this.uh.sU(a).Qa();for(var b=1;b<a[J];b++)this.Zq[Wi(a[b])]=Dt;break;default:Wi(a)}fma(this)}};
function fma(a){var b=0;ck(a.Zq,function(a){if(a==Dt)b++;else if(a!=Yt)return!1;return!0},a)&&Zla(a.Gq,0==b)}Lx[K].Pfa=function(a){for(var b=Gx[K].sU[Zc](this.uh,arguments),c=b.Qa(),d=0;d<c[J];d++){var e=b,f=c[d];if(!e[Yc](f)||e.Tv.$e(Hx(f)))this.Zq[Wi(c[d])]=Xt}};Lx[K].Zf=function(a){this.Zq[Wi(a)]=Ct;var b=Hu.iU(function(){a[As]()},U(this.handleError,this,a));sv(b)};
function ema(a,b){var c=a.uh.Vf(b);if(c){var d=b.WT();d.Uea&&d.Uea(c);for(d=0;d<c[J];d++){var e=c[d],f;t:{f=a;var g=Ix(f.uh,e);if(g)for(var k=0;k<g[J];k++)if(f.Zq[Wi(g[k])]!=Yt){f=!1;break t}f=!0}f&&(f=gma(a,e),e.Gg(f),a.Zf(e))}}}function gma(a,b){var c=wj(Ix(a.uh,b),function(a){a=a.WT();if(Vi(a[Zc]))return a[Zc][L](a)});return $la(a.Gq,c)};function Mx(a){Ju[L](this);this.A=a;this.Gq=new Kx(a);Lu(this.A0);this.A0=bw(this.Gq,Yt,U(this.Xda,this,Yt));Lu(this.z0);this.z0=bw(this.Gq,Dt,U(this.Xda,this,Dt))}W(Mx,Ju);R=Mx[K];R.D=function(){this[bc]();Lu(this.A0);Lu(this.z0);Lu(this.Gq);Mx.e.D[L](this)};va(R,function(){fw(this.A0);fw(this.z0);this.Gq[bc]()});Fq(R,function(a,b){Oi(a)||(a=[a]);Oi(b)||(b=[b]);for(var c=0;c<a[J];c++)for(var d=0;d<b[J];d++)this.Gq[fc](a[c],b[d]);return this});br(R,function(a){this.Gq[As](a)});Oq(R,function(){return this.A});
Zq(R,function(){return this.Gq[ss]()});R.Xda=function(a,b){ew(this,a,b||null)};function Nx(a){mx[L](this,lia,a);a=a||{};Si(a)&&(a=On(a));this.Xq=a.wrappers||null;this.eE=a.bindings||null;this.Pv(a.dashboardType||Nha);Ox(this)}W(Nx,mx);R=Nx[K];R.qS=function(a,b){function c(a){return f[a]}Lu(this[he]);a=yp(a);for(var d=new Mx(a),e=this.eE||[],f=this.Xq,g=e[J],k=0;k<g;k++){var l=wj(e[k].controls,c),n=wj(e[k].participants,c);d[fc](l,n)}$q(this,d);Nx.e.qS[L](this,a,b)};R.Mca=function(a){a.wrappers=this.Xq?wj(this.Xq,function(a){return a[Ar]()}):void 0;a.bindings=this.eE||void 0};
R.aya=function(a){this.Xq=a||null;Ox(this)};R.yxa=function(){return this.Xq};R.Jxa=function(a){this.eE=a||null;Ox(this)};R.nxa=function(){return this.eE};R.uxa=mx[K].T5;R.Qxa=mx[K].po;R.vxa=mx[K][nr];function Ox(a){var b=a.Xq;if(null!==b&&!Oi(b)){var c=[];Zj(b,function(a,b){Vi(a[Ar])||(a=Px(a));a.po(b);c[B](a)},a);b=c}var d=a.eE;Qx(b)&&Qx(d)||(a.Xq=wj(b,a.d2,a),a.eE=wj(d,a.Wua,a))}R.d2=function(a){Vi(a[Ar])||(a=Px(a));a.Gg(null);a.Oi(null);return a};
R.Wua=function(a){var b=a.controls,c=a.participants;if(Qx(b)||Qx(c))throw m("invalid binding: "+a);b=wj(b,this.jha,this);c=wj(c,this.jha,this);return{controls:b,participants:c}};R.jha=function(a){var b=a,c=/^{.*}$/;if(Ri(a)||Si(a)&&c[od](a))return Vi(b[Ar])||(b=Px(b)),this.Xq[B](b),this.Xq[J]-1;a=hma(this);a=cj(kj(b))?-1:sj(a,b);if(-1==a)throw m("Invalid wrapper name: "+b);return a};function hma(a){return wj(a.Xq,function(a){return a[nr]()})}function Qx(a){return Oi(a)?Ej(a):!0};function Rx(a,b){Px(a)[As](b)}function Px(a){a=a||{};Si(a)&&(a=On(a));return a.controlType?new qx(a):a.dashboardType?new Nx(a):new px(a)};function Sx(a,b,c){var d=b.G(c),e=b.Ee(c),f=b.La(c),d=a.Tf(d,f,e);a.ada(d,b.Ur(c))}function Tx(a){for(var b=0,c=0;c<a[J];c++)b+=a[c];return b}function ima(a){return a[J]}function jma(a){return Tx(a)/a[J]}
function Ux(a,b,c){function d(a,b,c,d){return b[L](null,c[I](d,a))}var e=[],f=[];X(b,function(b){if(Ui(b))e[B](b);else if(Li(b)==Ph){var c=b.column,c=a[dc](c);Kia in b&&f[B]([c,{calc:Yi(d,c,b.modifier),type:b[H],label:b[dd],id:b.id}]);e[B](c)}});if(!Ej(f)){for(var g=new hw(a),k=g.Gba(),l=a.O(),n=0;n<l;n++)X(f,function(a){k[a[0]]=a[1]});g.pp(k);a=g}var p=new aq,t=[];X(e,function(c,d){var e=a.G(c),f=b[d][dd]||a.La(c),g=null!=b[d].id?b[d].id:a.Ee(c);p.Tf(e,f,g);t[B](e)});c=c||[];X(c,function(b){var c=
a[dc](b.column),d=b[dd]||a.La(c),c=null!=b.id?b.id:a.Ee(c);p.Tf(b[H],d,c)});var u=[];X(e,function(a){u[B]({column:a})});for(var x=a.Ap(u),A=[],C=0;C<c[J];C++)A[B]([]);for(C=0;C<x[J];C++){X(c,function(b,c){A[c][B](a[I](x[C],a[dc](b.column)))});g=!1;if(C<x[J]-1)for(g=!0,l=0;l<e[J];l++){var n=a[I](x[C],e[l]),E=a[I](x[C+1],e[l]);if(0!=cq(t[l],n,E)){g=!1;break}}if(!g){var Q=p.Vr();X(e,function(b,c){p.Fa(Q,c,a[I](x[C],b))});var N=b[J];X(c,function(a,b){var c=a.aggregation[L](null,A[b]);p.Fa(Q,N+b,c)});
for(g=0;g<c[J];g++)A[g]=[]}}return p};Hi("google.visualization.drawChart",Rx,void 0);Hi("google.visualization.drawFromUrl",function(a,b){var c=new zv(b||ea[Fc][Vc]),d=Iv(c,Lt),e;null!=d?e=d:(e={},X(c.lj.Ok(),function(a){var b=Iv(c,a);try{null!=b&&(b=On(b))}catch(d){}e[a]=b}),Mq(e,nk(e)));Rx(e,a)},void 0);
Hi("google.visualization.createUrl",function(a,b){Si(a)&&(a=On(a));var c=[],d,e;for(e in a)if(e==Pia){var f=a[e],g;for(g in f)d=f[g],Si(d)||(d=Ln(d)),c[B](g+Df+aa(String(d)))}else d=a[e],Si(d)||(d=Vi(d[Ar])?d[Ar]():Ln(d)),c[B](e+Df+aa(String(d)));d=up()+Cha;d=d[Ab](/^https?:/,M);c=(b||d)+Gf+c[Fe](We);c=c[Ab](/'/g,xha);return c=c[Ab](/"/g,wha)},void 0);
Hi("google.visualization.createSnippet",function(a){var b=up()+Dha,b=b[Ab](/^https?:/,M),b=Jha+b+uha;a=Px(a)[Ar]();a=a[Ab](/</g,af);a=a[Ab](/>/g,$e);return b=b+a+mha},void 0);Hi("google.visualization.createWrapper",Px,void 0);Hi("google.visualization.ChartWrapper",px,void 0);va(px[K],px[K][bc]);br(px[K],px[K][As]);Ia(px[K],px[K][Jc]);Ca(px[K],px[K][Ar]);px[K].getSnapshot=px[K].zT;px[K].getDataSourceUrl=px[K].GV;px[K].getDataTable=px[K].Ta;px[K].getChartName=px[K].a_;px[K].getChartType=px[K].Xa;
px[K].getChart=px[K].fe;px[K].getContainerId=px[K].FV;px[K].getPackages=px[K].Q5;px[K].getQuery=px[K].zo;px[K].getRefreshInterval=px[K].HV;px[K].getView=px[K].IV;Kq(px[K],px[K][Kr]);px[K].getOptions=px[K].Pc;Nq(px[K],px[K][Qr]);px[K].getCustomRequestHandler=px[K].txa;px[K].isDefaultVisualization=px[K].Nca;px[K].pushView=px[K].Gxa;px[K].sendQuery=px[K].mT;px[K].setDataSourceUrl=px[K].Oi;px[K].setDataTable=px[K].Gg;px[K].setChart=px[K].zO;px[K].setChartName=px[K].b_;px[K].setChartType=px[K].Ld;
px[K].setContainerId=px[K].KV;px[K].setIsDefaultVisualization=px[K].y7;px[K].setPackages=px[K].fK;px[K].setQuery=px[K].Gk;px[K].setRefreshInterval=px[K].Ln;px[K].setView=px[K].DD;px[K].setOption=px[K].M;Jq(px[K],px[K][Fr]);px[K].setState=px[K].ed;px[K].setCustomRequestHandler=px[K].Oxa;Hi("google.visualization.ControlWrapper",qx,void 0);va(qx[K],qx[K][bc]);br(qx[K],qx[K][As]);Ca(qx[K],qx[K][Ar]);qx[K].getSnapshot=qx[K].zT;qx[K].getDataSourceUrl=qx[K].GV;qx[K].getDataTable=qx[K].Ta;
qx[K].getControlName=qx[K].rxa;qx[K].getControlType=qx[K].sxa;qx[K].getControl=qx[K].WT;qx[K].getContainerId=qx[K].FV;qx[K].getPackages=qx[K].Q5;qx[K].getQuery=qx[K].zo;qx[K].getRefreshInterval=qx[K].HV;qx[K].getView=qx[K].IV;Kq(qx[K],qx[K][Kr]);qx[K].getOptions=qx[K].Pc;Nq(qx[K],qx[K][Qr]);qx[K].sendQuery=qx[K].mT;qx[K].setDataSourceUrl=qx[K].Oi;qx[K].setDataTable=qx[K].Gg;qx[K].setControlName=qx[K].Lxa;qx[K].setControlType=qx[K].Mxa;qx[K].setContainerId=qx[K].KV;qx[K].setPackages=qx[K].fK;
qx[K].setQuery=qx[K].Gk;qx[K].setRefreshInterval=qx[K].Ln;qx[K].setView=qx[K].DD;qx[K].setOption=qx[K].M;Jq(qx[K],qx[K][Fr]);qx[K].setState=qx[K].ed;Hi("google.visualization.DashboardWrapper",Nx,void 0);va(Nx[K],Nx[K][bc]);br(Nx[K],Nx[K][As]);Ca(Nx[K],Nx[K][Ar]);Nx[K].getBindings=Nx[K].nxa;Nx[K].getDataSourceUrl=Nx[K].GV;Nx[K].getDataTable=Nx[K].Ta;Nx[K].getDashboard=Nx[K].uxa;Nx[K].getDashboardName=Nx[K].vxa;Nx[K].getContainerId=Nx[K].FV;Nx[K].getPackages=Nx[K].Q5;Nx[K].getQuery=Nx[K].zo;
Nx[K].getRefreshInterval=Nx[K].HV;Nx[K].getView=Nx[K].IV;Nx[K].getWrappers=Nx[K].yxa;Nx[K].setBindings=Nx[K].Jxa;Nx[K].setDataSourceUrl=Nx[K].Oi;Nx[K].setDataTable=Nx[K].Gg;Nx[K].setDashboardName=Nx[K].Qxa;Nx[K].setContainerId=Nx[K].KV;Nx[K].setPackages=Nx[K].fK;Nx[K].setQuery=Nx[K].Gk;Nx[K].setRefreshInterval=Nx[K].Ln;Nx[K].setView=Nx[K].DD;Nx[K].getSnapshot=Nx[K].zT;Nx[K].setWrappers=Nx[K].aya;Hi("google.visualization.data.avg",jma,void 0);Hi("google.visualization.data.count",ima,void 0);Hi("google.visualization.data.group",Ux,void 0);
Hi("google.visualization.data.join",function(a,b,c,d,e,f){d=wj(d,function(c){var d=a[dc](c[0]);c=b[dc](c[1]);return[d,c]});e=wj(e,U(a[dc],a));f=wj(f,U(b[dc],b));var g=c==Ch||c==jh,k=c==au||c==jh,l=new aq,n=[];X(d,function(c){var d=a.G(c[0]),e=b.G(c[1]);if(d!=e)throw m("Key types do not match:"+d+kf+e);Sx(l,a,c[0]);n[B](d)});var p=[],t=[];X(d,function(a){p[B]({column:a[0]});t[B]({column:a[1]})});var u=a.Ap(p),x=b.Ap(t);X(e,function(b){Sx(l,a,b)});X(f,function(a){Sx(l,b,a)});for(var A=!1,C=0,E=0,Q=
0;C<u[J]||E<x[J];){var N=0,S=[];if(E>=x[J])if(g)S[0]=u[C],N=-1;else break;else if(C>=u[J])if(k)S[1]=x[E],N=1;else break;else{S[0]=u[C];S[1]=x[E];for(var T=0;T<d[J];T++){var N=a[I](S[0],d[T][0]),V=b[I](S[1],d[T][1]),N=cq(n[T],N,V);if(0!=N)break}}if(A&&0!=N)A=!1,E++;else{if(-1==N&&g||1==N&&k||0==N){l.Vr();var sa,Ha;-1==N&&g||0==N&&c!=au?(sa=a,Ha=0):(sa=b,Ha=1);X(d,function(a,b){c==jh?l.Fa(Q,b,sa[I](S[Ha],a[Ha])):l.cc(Q,b,sa[I](S[Ha],a[Ha]),sa.Ca(S[Ha],a[Ha]),sa[$d](S[Ha],a[Ha]))});if(-1==N&&g||0==N){var Ka=
d[J];X(e,function(b,c){l.cc(Q,c+Ka,a[I](S[0],b),a.Ca(S[0],b),a[$d](S[0],b))})}if(1==N&&k||0==N)Ka=e[J]+d[J],X(f,function(a,c){l.cc(Q,c+Ka,b[I](S[1],a),b.Ca(S[1],a),b[$d](S[1],a))});Q++}1==N?E++:C++;0==N&&(A=!0)}}return l},void 0);Hi("google.visualization.data.max",function(a){if(0==a[J])return null;for(var b=a[0],c=1;c<a[J];c++){var d=a[c];null!=d&&d>b&&(b=d)}return b},void 0);
Hi("google.visualization.data.min",function(a){if(0==a[J])return null;for(var b=a[0],c=1;c<a[J];c++){var d=a[c];null!=d&&d<b&&(b=d)}return b},void 0);Hi("google.visualization.data.month",function(a){return a[Vd]()+1},void 0);Hi("google.visualization.data.sum",Tx,void 0);Hi("__gvizguard__",!0,void 0);Hi(wia,Pv,void 0);Pv[K].makeRequest=Pv[K].makeRequest;Pv[K].setRefreshInterval=Pv[K].Ln;Pv[K].setQuery=Pv[K].Gk;Aq(Pv[K],Pv[K][mr]);Pv[K].setRefreshable=Pv[K].Wxa;Pv[K].setTimeout=Pv[K][Dr];Pv[K].setHandlerType=Pv[K].Sxa;Pv[K].setHandlerParameter=Pv[K].Tga;Pv.setResponse=Tv;Yq(Pv[K],Pv[K][rs]);Hi("google.visualization.CustomQuery",pw,void 0);Aq(pw[K],pw[K][mr]);Hi("google.visualization.QueryResponse",Fu,void 0);Fu[K].getDataTable=Fu[K].Ta;Fu[K].isError=Fu[K].kj;
Fu[K].hasWarning=Fu[K].n4;Fu[K].getReasons=Fu[K].sfa;Fu[K].getMessage=Fu[K].iK;Fu[K].getDetailedMessage=Fu[K].K3;Hi("google.visualization.DataTable",aq,void 0);aq[K].addColumn=aq[K].Tf;aq[K].addRow=aq[K].Vr;aq[K].addRows=aq[K].$t;Ia(aq[K],aq[K][Jc]);aq[K].getColumnId=aq[K].Ee;wa(aq[K],aq[K][dc]);aq[K].getColumnLabel=aq[K].La;aq[K].getColumnPattern=aq[K].zv;aq[K].getColumnProperty=aq[K].gj;aq[K].getColumnProperties=aq[K].Ur;aq[K].getColumnRange=aq[K].pq;aq[K].getColumnRole=aq[K].fu;
aq[K].getColumnType=aq[K].G;aq[K].getDistinctValues=aq[K].FU;aq[K].getFilteredRows=aq[K].hD;aq[K].getFormattedValue=aq[K].Ca;aq[K].getNumberOfColumns=aq[K].L;aq[K].getNumberOfRows=aq[K].O;nb(aq[K],aq[K][$d]);Za(aq[K],aq[K][Bd]);aq[K].getRowProperty=aq[K].$r;aq[K].getRowProperties=aq[K].pL;aq[K].getSortedRows=aq[K].Ap;aq[K].getTableProperty=aq[K].rU;aq[K].getTableProperties=aq[K].fz;aq[K].getUnderlyingTableColumnIndex=aq[K].pU;aq[K].getUnderlyingTableRowIndex=aq[K].kU;hb(aq[K],aq[K][I]);
aq[K].insertColumn=aq[K].tga;aq[K].insertRows=aq[K].v1;aq[K].removeColumn=aq[K].fV;aq[K].removeColumns=aq[K].tha;aq[K].removeRow=aq[K].ey;aq[K].removeRows=aq[K].uha;aq[K].setCell=aq[K].cc;aq[K].setColumnLabel=aq[K].Kxa;aq[K].setColumnProperties=aq[K].ada;aq[K].setColumnProperty=aq[K].bx;aq[K].setFormattedValue=aq[K].qy;aq[K].setProperties=aq[K].Bw;aq[K].setProperty=aq[K][Qc];aq[K].setRowProperties=aq[K].Xxa;aq[K].setRowProperty=aq[K].Baa;aq[K].setTableProperties=aq[K].Yxa;aq[K].setTableProperty=aq[K].Zxa;
aq[K].setValue=aq[K].Fa;rb(aq[K],aq[K][ue]);Ca(aq[K],aq[K][Ar]);Hi("google.visualization.DataView",hw,void 0);hw.fromJSON=jw;hw[K].getColumnId=hw[K].Ee;wa(hw[K],hw[K][dc]);hw[K].getColumnLabel=hw[K].La;hw[K].getColumnPattern=hw[K].zv;hw[K].getColumnProperty=hw[K].gj;hw[K].getColumnProperty=hw[K].gj;hw[K].getColumnProperties=hw[K].Ur;hw[K].getColumnRange=hw[K].pq;hw[K].getColumnRole=hw[K].fu;hw[K].getColumnType=hw[K].G;hw[K].getDistinctValues=hw[K].FU;hw[K].getFilteredRows=hw[K].hD;
hw[K].getFormattedValue=hw[K].Ca;hw[K].getNumberOfColumns=hw[K].L;hw[K].getNumberOfRows=hw[K].O;nb(hw[K],hw[K][$d]);Za(hw[K],hw[K][Bd]);hw[K].getRowProperty=hw[K].$r;hw[K].getRowProperties=hw[K].pL;hw[K].getSortedRows=hw[K].Ap;hw[K].getTableColumnIndex=hw[K].pH;hw[K].getUnderlyingTableColumnIndex=hw[K].pU;hw[K].getTableRowIndex=hw[K].ym;hw[K].getUnderlyingTableRowIndex=hw[K].kU;hw[K].getTableProperty=hw[K].rU;hw[K].getTableProperties=hw[K].fz;hb(hw[K],hw[K][I]);hw[K].getViewColumnIndex=hw[K].Hfa;
hw[K].getViewColumns=hw[K].Gba;hw[K].getViewRowIndex=hw[K].d1;hw[K].getViewRows=hw[K].Cfa;hw[K].hideColumns=hw[K].zxa;hw[K].hideRows=hw[K].Axa;hw[K].setColumns=hw[K].pp;hw[K].setRows=hw[K].bn;hw[K].toDataTable=hw[K].Px;Ca(hw[K],hw[K][Ar]);Hi("google.visualization.errors",Hu,void 0);Hu.addError=Hu.Kd;Hu.removeAll=Hu.nc;Hu.removeError=Hu.Hxa;Hu.addErrorFromQueryResponse=Hu.ND;Oq(Hu,Hu[Sr]);Hu.createProtectedCallback=Hu.iU;Hi(xia,bw,void 0);Hi(yia,cw,void 0);Hi(Bia,ew,void 0);Hi(Aia,fw,void 0);
Hi(zia,gw,void 0);Hi("google.visualization.QueryWrapper",ow,void 0);Jq(ow[K],ow[K][Fr]);br(ow[K],ow[K][As]);ow[K].setCustomErrorHandler=ow[K].Nxa;ow[K].sendAndDraw=ow[K].rE;ow[K].setCustomPostResponseHandler=ow[K].wU;ow[K].setCustomResponseHandler=ow[K].xU;Yq(ow[K],ow[K][rs]);Hi("google.visualization.arrayToDataTable",Vga,void 0);Hi("google.visualization.datautils.compareValues",cq,void 0);
Hi("google.visualization.dataTableToCsv",function(a){for(var b=M,c=0;c<a.O();c++){for(var d=0;d<a.L();d++){0<d&&(b+=jf);var e=a.Ca(c,d),e=e[Ab](/"/g,tha),f=-1!=e[zd](jf),g=-1!=e[zd](Je),k=-1!=e[zd](Me);if(f||g||k)e=Me+e+Me;b+=e}b+=Je}return b},void 0);Hi("google.visualization.GadgetHelper",Yv,void 0);Yv[K].createQueryFromPrefs=Yv[K].jxa;Yv[K].validateResponse=Yv[K].cya;;window.google&&window.google.loader&&window.google.loader.eval&&window.google.loader.eval.visualization&&(window.google.loader.eval.visualization=function(){eval(arguments[0])});



var Vx=unescape,Wx=escape,Xx=setTimeout,Yx=navigator;function Zx(a,b){return a.origin=b}function $x(a,b){return a.direction=b}function ay(a,b){return a.filled=b}function by(a,b){return a.weight=b}function cy(a,b){return a.collapse=b}function dy(a,b){return a.content=b}function ey(a,b){return a.layout=b}function fy(a,b){return a.selected=b}function gy(a,b){return a.stroked=b}function hy(a,b){return a.fillcolor=b}function iy(a,b){return a.select=b}function jy(a,b){return a.values=b}
function ky(a,b){return a.setRadius=b}function ly(a,b){return a.depth=b}function my(a,b){return a.refresh=b}function ny(a,b){return a.items=b}function oy(a,b){return a.whiteSpace=b}function py(a,b){return a.animation=b}function qy(a,b){return a.strokeweight=b}function ry(a,b){return a.fillStyle=b}function sy(a,b){return a.setVisible=b}function ty(a,b){return a.marginWidth=b}function uy(a,b){return a.cursor=b}function vy(a,b){return a.deltaY=b}function wy(a,b){return a.deltaX=b}
function xy(a,b){return a.size=b}function yy(a,b){return a.setVisibleChartRange=b}function zy(a,b){return a.coordorigin=b}function Ay(a,b){return a.style=b}function By(a,b){return a.close=b}function Cy(a,b){return a.ticks=b}function Dy(a,b){return a.getPosition=b}function Ey(a,b){return a.isEnabled=b}function Fy(a,b){return a.range=b}function Gy(a,b){return a.marginHeight=b}function Hy(a,b){return a.coordinates=b}function Iy(a,b){return a.action=b}function Jy(a,b){return a.reset=b}
function Ky(a,b){return a.startTime=b}function Ly(a,b){return a.node=b}function My(a,b){return a.lineWidth=b}function Ny(a,b){return a.frameBorder=b}function Oy(a,b){return a.text=b}function Py(a,b){return a.annotations=b}function Qy(a,b){return a.createCaption=b}function Ry(a,b){return a.fontFamily=b}function Sy(a,b){return a.value=b}function Ty(a,b){return a.move=b}function Uy(a,b){return a.strokeStyle=b}function Vy(a,b){return a.backgroundColor=b}function Wy(a,b){return a.domain=b}
function Xy(a,b){return a.strokecolor=b}function Yy(a,b){return a.radius=b}function $y(a,b){return a.children=b}function cz(a,b){return a.scrolling=b}function dz(a,b){return a.orientation=b}function ez(a,b){return a.setContent=b}function fz(a,b){return a.getContent=b}function gz(a,b){return a.visible=b}function hz(a,b){return a.fontWeight=b}function iz(a,b){return a.scrollTop=b}function jz(a,b){return a.endTime=b}function kz(a,b){return a.getColors=b}function lz(a,b){return a.labels=b}
function mz(a,b){return a.rect=b}function nz(a,b){return a.disabled=b}function oz(a,b){return a.textAlign=b}function pz(a,b){return a.background=b}function qz(a,b){return a.fontStyle=b}function rz(a,b){return a.getId=b}function sz(a,b){return a.anchor=b}function tz(a,b){return a.line=b}function uz(a,b){return a.coords=b}function vz(a,b){return a.coordsize=b}function wz(a,b){return a.setPosition=b}function xz(a,b){return a.element=b}function yz(a,b){return a.update=b}
function zz(a,b){return a.transform=b}function Az(a,b){return a.debug=b}
var Bz="order",Cz="direction",Dz="shape",Ez="fillColor",Fz="getParent",Gz="center",Hz="classList",Iz="expand",Jz="selection",Kz="inRange",Lz="extend",Mz="layout",$z="selected",aA="collapsed",bA="geometry",cA="setEnd",dA="strokeColor",eA="registerElement",fA="first",gA="definition",hA="fillText",iA="focus",jA="select",kA="values",lA="padding",mA="elements",nA="setStyle",oA="moveTo",pA="resolution",qA="depth",rA="getBounds",sA="datum",tA="offset",uA="items",vA="duplicate",wA="time",xA="caption",yA=
"setVisible",zA="cursor",AA="html",BA="views",CA="deltaY",DA="deltaX",EA="size",FA="MapTypeId",GA="createElementNS",HA="setVisibleChartRange",IA="handle",JA="from",KA="save",LA="count",MA="nodes",NA="inverse",OA="rotate",PA="moveToElementText",QA="addListener",RA="ticks",SA="parent",TA="dataType",UA="getPosition",VA="isEnabled",WA="range",XA="cells",YA="multiple",ZA="fireEvent",$A="coordinates",aB="paths",bB="scale",cB="restore",dB="action",eB="startTime",fB="fillRect",gB="attributes",hB="node",iB=
"compact",jB="lineWidth",kB="closePath",lB="Text",mB="isCollapsed",nB="margin",oB="page",pB="lineTo",qB="icon",rB="replaceChild",sB="annotations",tB="getCenter",uB="createCaption",vB="blur",wB="region",xB="Rect",yB="move",zB="getOpacity",AB="backgroundColor",BB="domain",CB="current",DB="updateOptions",EB="rowIndex",FB="hasAttribute",GB="elementType",HB="radius",IB="beginPath",JB="getHeight",KB="play",LB="path",MB="detach",NB="getContext",OB="translate",PB="LN10",QB="orientation",RB="setContent",SB=
"getContent",TB="visible",UB="keys",VB="setActive",WB="strokeRect",XB="frames",YB="window",ZB="setStart",$B="property",aC="getColors",bC="title",cC="labels",dC="duration",eC="rect",fC="textAlign",gC="alpha",hC="Circle",iC="background",jC="entries",kC="getId",lC="anchor",mC="moveEnd",nC="line",oC="coords",pC="adoptText",qC="featureId",rC="compareEndPoints",sC="addColorStop",tC="setPosition",uC="element",vC="contentDocument",wC="axis",xC="update",yC="areas",zC="append",AC="transform",BC="debug",CC=
"event",kma="\u2717",lma="\u2714",mma="\u2026",nma="\u2014",oma="\u00b0",pma="\u00ad",DC="{}",qma="zoomLevel",rma="zoomAroundSelection",EC="zSoyz",sma="zOrder",tma="yyyy",FC="y2",GC="y1",uma="xiRedirectUrl",HC="x2",IC="x1",JC="x",KC="world",LC="wordtree",vma="width:100px;height:100px;overflow:scroll;position:absolute;visibility:hidden;",wma="width: 700px; height: 500px;",MC="width: ",NC="visibleInLegend",OC="viewWindowMode",xma="viewWindow.numericMin",yma="viewWindow.numericMax",PC="viewWindow.min",
QC="viewWindow.max",RC="viewBox",zma="vgridline",SC="version",Ama="vaxis",Bma="var _loaded = false;",Cma="valuetext",Dma="valuenow",Ema="valuemin",Fma="valuemax",Gma="valueFormatter",Hma="value-and-percentage",TC="valign",Ima="vAxis#",Jma="vAxes.",UC="vAxes",Kma="v:textpath",Lma="v:stroke",VC="v:shape",Mma="v:rect",WC="v:path",XC="v:oval",Nma="v:group",YC="v:fill",ZC="v-text-align",$C="userSpaceOnUse",Oma="useMapTypeControl",Pma="useLargeControl",Qma="useExpressInstall",aD="urn:schemas-microsoft-com:vml",
bD="url(#",Rma="url(",Sma="uritoolong",Tma="up",Uma="unsorted",Vma="unselect",cD="unhighlight",dD="underline",Wma="uncheck",Xma="unbound",eD="ul",Yma="tspan",Zma="trigger",$ma="triangle",ana="trendlines.",bna="transparentIE6",cna="translate(",dna="transition",fD="transform",gD="tr",ena="tqx",hD="touchstart",fna="touchmove",gna="touchend",hna="touchcancel",ina="top_right",iD="top_left",jD="top-space",jna="top-level",kD="top",kna="tooltipTrigger",lna="tooltipTextStyle",mna="tooltipTextColor",nna="tooltipText",
ona="tooltipHoverOut",pna="tooltipHoverIn",qna="tooltipFontSize",lD="tooltip.trigger",rna="tooltip.textStyle",sna="tooltip.text",tna="tooltip.showTitle",una="tooltip.showEmpty",vna="tooltip.showDisputedText",wna="tooltip.showColorCode",xna="tooltip.pivot.y",yna="tooltip.pivot.x",zna="tooltip.isHtml",Ana="tooltip.ignoreBounds",Bna="tooltip-shapes",mD="toggle_display",Cna="to",nD="titleY",Dna="titleX",oD="titleTextStyle",Ena="titlePosition",pD="titleFontSize",Fna="titleColor",qD="title",Gna="timeGranularity",
Hna="ticks.pixelsPerTick",rD="ticks",Ina="ticklines",Jna="tickScoringWeights",Kna="thickness",sD="thead",tD="th",uD="textpathok",Lna="textpath",vD="textStyle",Mna="textPosition",Nna="textFontSize",Ona="textColor",Pna="text-decoration",wD="text-anchor",xD="td",yD="tbody",zD="targetAxisIndex",Qna="targetAxes.",Rna="targetAxes",AD="t",BD="swf",CD="svg",DD="subtitle",Sna="submit",Tna="subcontinents",GD="strokeWidth",Una="strokeOpacity",HD="strokeColor",ID="stroke.width",JD="stroke.opacity",KD="stroke.color",
LD="stroke-width",MD="stroke-opacity",Vna="stroke-linecap",Wna="stroke-dasharray",ND="stroke",OD="stop-color:",Xna="stop-color",PD="stop",Yna="sticks",QD="steppedareabar",RD="steppedArea",SD="step",Zna="stemLength",$na="stemColor",aoa="stdDeviation",boa="state",TD="start",UD="star",coa="stageShape",doa="stacked",VD="stack",WD="square",eoa="sparkline",foa="sortBubblesBySize",goa="sort-descending",hoa="sort-ascending",XD="sort",ioa="snapToData",YD="smoothingFactor",joa="slope",ZD="slider",koa="slices.",
loa="sliceVisibilityThreshold",$D="slice",moa="slantedTextAngle",noa="slantedText",ooa="skew",poa="sizeAxis.scaleType",qoa="sizeAxis.minValue",roa="sizeAxis.minSize",soa="sizeAxis.maxValue",toa="sizeAxis.maxSize",uoa="sizeAxis.logScale",voa="sideScreenColor",woa="side",aE="showTooltips",bE="showTip",xoa="showTextEveryMode",yoa="showTextEvery",zoa="showSidePanel",Aoa="showScale",Boa="showRemoveSeriesButton",Coa="showR2",cE="showLine",Doa="showGeocodeWarnings",Eoa="showChartButtons",dE="show",Foa="shouldHighlightSelection",
Goa="shouldHighlightHover",Hoa="shortdash",Ioa="shortBarWidth",Joa="shapes/text",eE="shapes/shapes",Koa="shapes/rect-util",Loa="shapes/rect",Moa="shapes/path",Noa="shapes/line",Ooa="shapes/group",Poa="shapes/ellipse",Qoa="shapes/circle",Roa="shapes/abstract_shape",fE="shape",gE="shadow.yoffset",hE="shadow.yOffset",iE="shadow.y-offset",yE="shadow.xoffset",zE="shadow.xOffset",AE="shadow.x-offset",BE="shadow.radius",CE="shadow.opacity",Soa="setsize",DE="set",Toa="seriesType",Uoa="series.0.enableInteractivity",
EE="series.",Voa="series-color-light",FE="series-color-dark",GE="series-color",HE="series",Woa="serieHoverOut",Xoa="serieHoverIn",Yoa="serieClick",Zoa="serie",IE="separator",JE="selectionMode",KE="selectedRows",LE="selected",$oa="selectLightenAmount",apa="secondarydiagonalstripes",bpa="scrollToZoom",ME="scroll",NE="screen",OE="scatter",PE="scaleType",cpa="scale(",QE="sans-serif",dpa="s ",RE="ry",SE="rx",TE="rowspan",UE="rows",VE="rowlabels",epa="rowColor",fpa="row-resize",gpa="rotate(%ddeg)",WE="rotate(",
XE="rotate",YE="rightclick",hpa="rightClickToReset",ZE="right-space",$E="rgba(0,0,0,0)",ipa="rgba(",jpa="rgb(",aF="reverseCategories",kpa="reverseAxis",lpa="reverse",mpa="resume",bF="resolution",cF="resize",npa="reset",opa="repeat",ppa="renderers/svg/text",qpa="renderers/svg/svg-util",rpa="renderers/svg/svg",spa="renderers/svg/shapes",tpa="renderers/svg/rect",upa="renderers/svg/path-util",vpa="renderers/svg/path",wpa="renderers/svg/line",xpa="renderers/svg/group",ypa="renderers/svg/ellipse",zpa="renderers/svg/circle",
Apa="renderers/mobile/text",Bpa="renderers/mobile/shapes",Cpa="renderers/mobile/rect",Dpa="renderers/mobile/path",Epa="renderers/mobile/mobile-util",Fpa="renderers/mobile/mobile",Gpa="renderers/mobile/line",Hpa="renderers/mobile/group",Ipa="renderers/mobile/ellipse",Jpa="renderers/mobile/circle",Kpa="renderers/canvas/text",Lpa="renderers/canvas/shapes",Mpa="renderers/canvas/rect",Npa="renderers/canvas/path",Opa="renderers/canvas/line",Ppa="renderers/canvas/ellipse",Qpa="renderers/canvas/circle",Rpa=
"renderers/canvas/canvas",dF="renderers/abstract/abstractrenderer",Spa="renderers",Tpa="removeseriebutton",Upa="removeserie",Vpa="removeShape",Wpa="removeSerieButtonHoverOut",Xpa="removeSerieButtonHoverIn",Ypa="removeSerieButtonClick",Zpa="removeSerieButton",eF="remove",$pa="regionClick",fF="region",gF="redraw",hF="redirectUrl",aqa="red",bqa="rect(",iF="rect",jF="rangechange",cqa="rangeChangeEventFiringRate",dqa="range.min",eqa="range.max",kF="range",fqa="rablshadow",gqa="rablgradient",hqa="rablclip",
iqa="rabl-use-parent",jqa="rabl",kqa="quadtree",lqa="px;position: absolute;top:0;left:0;",mqa="px;overflow-x:",lF="px;",nqa="px,",oqa="px ",pqa="purple",qqa="pt",mF="provinces",rqa="propertychange",sqa="projection",nF="primarydiagonalstripes",tqa="previous",uqa="prev",oF="pretty",vqa="pressed",wqa="preserveAspectRatio",xqa="pre",yqa="position:relative;overflow:hidden",zqa="position:absolute;left:-10000px;top:auto;width:1px;height:1px;overflow:hidden",Aqa="position:absolute;display:none;",Bqa="position: relative;",
Cqa="position: absolute; top: 0; left: 0; overflow: hidden;",Dqa="position: absolute; top: -5000px;",Eqa="posinset",Fqa="polynomial",pF="polygon",qF="pointsensitivityarea",rF="points",sF="pointer",tF="pointSize",Gqa="pointShape",Hqa="point.visible",Iqa="point.size",Jqa="point.shape",Kqa="point.",uF="point",vF="playAnimation",wF="play",Lqa="placeholder",Mqa="pixelsPerLabel",Nqa="pinchToZoom",xF="piecewiseLinear",Oqa="pieStartAngle",Pqa="pieSliceTextStyle",yF="pieSliceText",zF="pieSliceBorderColor",
Qqa="pieResidueSliceLabel",Rqa="pieResidueSliceColor",AF="pieHole",BF="pie",Sqa="phase",CF="percentage",Tqa="pc",Uqa="patternUnits",Vqa="pathinterval",DF="path",Wqa="paste",EF="paging-controls",FF="page",Xqa="padding.top",Yqa="padding.right",Zqa="padding.left",$qa="padding.bottom",ara="padding",bra="package",cra="p3",GF="p",HF="owns",dra="overlaybox",era="overflowX",fra="overflow:hidden;position:relative;width:",gra="overflow:auto;position:absolute;top:0;width:100px;height:100px",hra="oval",IF="outside",
ira="outTextPosition",jra="out:html;",kra="out:csv;",JF="out",KF="orientation",LF="option",lra="optimizeQuality",MF="open",NF="opaque",mra="opacity2",nra="opacity 1s linear",ora="onunload",pra="onmouseup",OF="onmouseover",PF="onmouseout",QF="onmousemove",qra="onmousedown",RF="old-data",SF="ok",TF="offset",UF="off",rra="ocean",sra="objectBoundingBox",VF="nowrap",tra="notime",WF="normal",ura="nodeType",XF="no",vra="next",YF="natural",ZF="name",$F="move_offscreen",aG="move",bG="mousewheel",cG="mouseup",
dG="mousemove",eG="mouseleave",fG="mouseenter",gG="month",wra="modal-dialog",xra="mobile",hG="mixed",iG="mirrorLog",yra="minorGridlines.units.",zra="minorGridlines.count",jG="minorGridlines.color",Ara="minorAxisTextColor",Bra="minTextSpacing",Cra="minRangeSize",Dra="minColorValue",kG="minColor",lG="min-width",Era="min-height",mG="min",nG="middle",oG="midColor",pG="metros",qG="mercator",Fra="menuitemradio",Gra="menuitemcheckbox",Hra="menuitem",Ira="menu",rG="maximized",Jra="maxTextLines",sG="maxDepth",
Kra="maxColorValue",tG="maxColor",Lra="maxAlternation",uG="max-width",vG="max-lines",Mra="max-height",wG="max",Nra="matrix(",xG="math",Ora="markerOpacity",Pra="markerMove",yG="markerHover",zG="markerClick",Qra="marker.style.stroke.width",Rra="marker.style.stroke.color",Sra="marker.style.stroke",AG="marker",Tra="margin.top",Ura="margin.right",Vra="margin.left",BG="margin.bottom",CG="margin",Wra="mapfiles/%s.js",DG="mapType",Xra="mapLoaded",Yra="majorAxisTextColor",EG="magnifyingGlassTriangle",FG="magnifyingGlassBorder",
Zra="magnifyingGlass.zoomFactor",$ra="magnifyingGlass.enable",GG="ltr",asa="low",bsa="losecapture",csa="logScaleX",HG="logScale",IG="log",dsa="loaded",esa="load",fsa="listbox",JG="links",KG="linearGradient",LG="linear",MG="lineWidth",gsa="lineWeight",hsa="lineSpacing",isa="lineSize",jsa="lineDashStyle",ksa="lineColor",NG="line.",lsa="line-spacing",OG="line",PG="li",QG="letter",RG="legendscrollbutton",SG="legendentry",TG="legendTextStyle",msa="legendTextColor",nsa="legendScrollButtonClick",osa="legendScrollButton",
psa="legendFontSize",qsa="legendEntryHoverOut",rsa="legendEntryHoverIn",ssa="legendEntryClick",tsa="legendEntry",UG="legend.textStyle",usa="legend.style.title",vsa="legend.style.text",wsa="legend.style.subtitle",xsa="legend.style.spacing",ysa="legend.style.selected.title",zsa="legend.style.selected.subtitle",Asa="legend.style.selected.icon",Bsa="legend.style.margin",Csa="legend.style.icon",Dsa="legend.style.focused.title",Esa="legend.style.focused.subtitle",Fsa="legend.style.focused.icon",Gsa="legend.style.container",
Hsa="legend.showPageIndex",Isa="legend.scrollArrows.orientation",Jsa="legend.scrollArrows.inactiveColor",Ksa="legend.scrollArrows.activeColor",VG="legend.position",Lsa="legend.pagingTextStyle",Msa="legend.orientation",Nsa="legend.numberFormat",Osa="legend.newLegend",Psa="legend.maxLines",Qsa="legend.labeledValueText",Rsa="legend.iconWidthScaleFactor",Ssa="legend.bar.length",WG="legend.alignment",XG="legend",Tsa="leave",YG="layer",ZG="last-frozen-cell",$G="labelledby",aH="labeled",bH="labelInLegend",
cH="label",dH="l",eH="keyup",fH="keydown",gH="key",Usa="keepAspectRatio",Vsa="kavrayskiy-vii",Wsa="jscode",Xsa="javascript:void(0)",Ysa='javascript:""',Zsa="italic ",hH="italic",iH="isStacked",$sa="isRtl",ata="isDiff",jH="is3D",bta="intervals.",cta="interval.",kH="interval",lH="interpolateNulls",dta="interactivityModel",mH="inside",nH="inherit",eta="infobackground",fta="info/mapList.js",gta="info/boundingBoxes.js",hta="inTextPosition",oH="inAndOut",pH="in",ita="image/svg+xml",jta="image/png",kta=
"image",lta="igoogle",mta="identifier",qH="id",nta="icon",rH="i",sH="hybrid",tH="https:",uH="http://www.w3.org/2000/svg",ota="http://www.w3.org/1999/xlink",pta="http://www.google.com/ig/adde?moduleurl=",qta="http:",rta="htmlcode",sta="hsl",vH="hoverOut",wH="hoverIn",tta="hoverDarkenAmount",uta="hover",vta="histogramElementIndexes",wta="histogramBuckets",xta="histogramBucketItems",yta="histogram.sortBucketItems",zta="histogram.minNumBuckets",Ata="histogram.maxNumBuckets",Bta="histogram.lastBucketPercentile",
xH="histogram.hideBucketItems",Cta="histogram.bucketSize",yH="histogram",zH="highlight",Dta="highContrast",AH="high",BH="hide",Eta="hgridline",Fta="height: 8px; width: 8px",CH="height:",Gta="heading",DH="headerHeight",EH="headerColor",FH="header",Hta="haxis",GH="haspopup",HH="halign",Ita="hAxis#",IH="hAxis",Jta="hAxes.",Kta="hAxes",JH="group",Lta="gridlines.units.",Mta="gridlines.unitThreshold",Nta="gridlines.newTimeline",Ota="gridlines.minorTextOpacity",Pta="gridlines.minorGridlineOpacity",Qta="gridlines.minWeakLineDistance",
Rta="gridlines.minStrongToWeakLineDistance",Sta="gridlines.minStrongLineDistance",Tta="gridlines.minNotchDistance",Uta="gridlines.minMinorTextDistance",Vta="gridlines.minMajorTextDistance",KH="gridlines.count",LH="gridlines.color",Wta="gridlines.allowMinor",MH="gridlines",NH="gridlineColor",Xta="gridline",OH="grid",Yta="green",Zta="gradientUnits",PH="gradient",$ta="google_visualization_geochart_mapList",aua="google_visualization_geochart_boundingBoxes",bua="google_visualization_geochart_",cua="google.visualization.ScatterChart",
dua="google.visualization.PieChart",eua="google.visualization.LineChart",fua="google.visualization.ColumnChart",gua="google.visualization.BarChart",hua="google.visualization.AreaChart",iua="google-visualization-tooltip-square",jua="google-visualization-tooltip-separator",kua="google-visualization-tooltip-item-list",lua="google-visualization-tooltip-item",mua="google-visualization-tooltip-action-list",nua="google-visualization-tooltip-action",QH="google-visualization-tooltip",oua="google-visualization-toolbar-small-dialog",
pua="google-visualization-toolbar-html-code-explanation",qua="google-visualization-toolbar-big-dialog",rua="google-visualization-table-loadtest",sua="google-visualization-table content",tua="google-visualization-hidden",uua="goog_",RH="getcontext",SH="get",vua="geocodingContext",wua="g_vml_\\:*{behavior:url(#default#VML)}",xua="g_vml_:",yua="g_vml_",zua="function CHART_loaded() {",TH="frozen-table",UH="frozen-header",Aua="from",Bua="formatter.useMagnitudes",Cua="formatter.unit",Dua="formatter.numSignificantDigits",
Eua="formatter.numDecimals",VH="formatOptions.suffix",WH="formatOptions.scaleFactor",XH="formatOptions.prefix",Fua="formatOptions",YH="format",ZH="forceIFrame",Gua="fontWeight",$H="fontSize",aI="fontName",bI="fontFamily",cI="fontColor",Hua="font.weight",Iua="font.size",Jua="font.family",dI="font-weight",eI="font-style",Kua="font-size",Lua="font-family:",Mua="font-family",Nua="focusedMarker",Oua="focusedFeature",fI="focusTarget",Pua='flashvars="',Qua="fixedRangeSize",Rua="firstVisibleText",gI="finishAnimation",
hI="finish",iI="fillOpacity",jI="fillColor",kI="fill.opacity",lI="fill.color",mI="fill-opacity",nI="fill",oI="fgrid",pI="featureMove",qI="featureHover",rI="featureClick",sI="feature",Sua="feOffset",tI="feMergeNode",Tua="feMerge",Uua="feGaussianBlur",Vua="feFuncA",Wua="feComponentTransfer",Xua="explorer.zoomDelta",Yua="explorer.maxZoomOut",Zua="explorer.maxZoomIn",$ua="explorer.keepInBounds",ava="explorer.axis.",bva="explorer.axis",uI="explorer.actions",vI="explorer",wI="explicit",cva="expanded",xI=
"event",yI="enter",zI="end",dva="enableScrollWheel",eva="enableRegionInteractivity",AI="enableInteractivity",BI="enable",fva="empty",CI="ellipse",gva="elaborated.rowId",hva="elaborated.origin.y",iva="elaborated.origin.x",jva="elaborated.isDisputed",kva="elaborated",lva="easing",mva="ease-out",nva="ease-in",ova="earlycancel",DI="e",EI="dy",FI="dx",pva="drop",qva="drawText",rva="drawShape",sva="drawRect",tva="drawLine",uva="drawEllipse",vva="drawCircle",wva="dragstart",xva="dragend",yva="dragToZoom",
zva="dragToPan",GI="drag",Ava="down",Bva="domainAxes.",Cva="domainAxes",Dva="domain.",HI="doExpressInstall",II="dive",Eva="disputed",Fva="displayZoomButtons",Gva="displayTinySlicesInLegend",JI="displayRangeSelector",Hva="displayMode",Iva="displayLegendValues",Jva="displayLegendDots",Kva="displayDateBarSeparator",Lva="displayAnnotations",Mva="display:table;position:absolute;padding:0;margin:0;border:0",Nva="display:table-cell;padding: 0;margin: 0;border: 0",Ova="discrete",Pva="disabled",KI="disable",
Qva="diff.oldData.tooltip.prefix",LI="diff.oldData.opacity",Rva="diff.oldData.inCenter",Sva="diff.oldData.color",Tva="diff.newData.widthFactor",Uva="diff.newData.tooltip.prefix",MI="diff.newData.opacity",Vva="diff.innerCircle.radiusFactor",Wva="diff.innerCircle.borderFactor",Xva="diamond",NI="dialogselect",Yva="detectflash",Zva="destroy",$va="degree",OI="defs",awa="defaultColor",PI="default",bwa="debug",cwa="deactivate",QI="dblclick",dwa="days",ewa="datumHoverOut",fwa="datumHoverIn",gwa="datumClick",
RI="datum",SI="dateFormat",hwa="datalessRegionColor",TI="dataOpacity",UI="data-value",VI="dash",WI="cy",XI="cx",iwa="cut",YI="curveType",ZI="curve",jwa="cursor:default;-webkit-user-select:none;-moz-osx-font-smoothing:grayscale;",kwa="current",lwa="csv",mwa="crosshair.trigger",nwa="crosshair.selected.orientation",owa="crosshair.selected.opacity",pwa="crosshair.selected.color",qwa="crosshair.orientation",rwa="crosshair.opacity",swa="crosshair.focused.orientation",twa="crosshair.focused.opacity",uwa=
"crosshair.focused.color",vwa="crosshair.color",wwa="createText",xwa="createRect",ywa="createPathInternal",zwa="createGroupInternal",Awa="createElipse",Bwa="createCircle",Cwa="createCanvasInternal",Dwa="country",Ewa="countries_en",$I="countries",aJ="corners.topright.ry",bJ="corners.topright.rx",cJ="corners.topleft.ry",dJ="corners.topleft.rx",eJ="corners.ry",fJ="corners.rx",gJ="corners.bottomright.ry",hJ="corners.bottomright.rx",iJ="corners.bottomleft.ry",jJ="corners.bottomleft.rx",Fwa="corners.",
Gwa="continents",kJ="contextmenu",Hwa="contextTicks",Iwa="connectSteps",Jwa="columns",lJ="colspan",mJ="colors",Kwa="colorbar",nJ="colorBar",Lwa="colorAxis.values must not contain nulls",Mwa="colorAxis.values",Nwa="colorAxis.two-sided-colors",Owa="colorAxis.one-sided-colors",Pwa="colorAxis.minValue",Qwa="colorAxis.maxValue",Rwa="colorAxis.legend.textStyle",Swa="colorAxis.legend.position",Twa="colorAxis.legend.numberFormat",Uwa="colorAxis.colors",Vwa="color2",oJ="color",Wwa="collapse",pJ="col-resize",
qJ="closedPhase",rJ="close",Xwa="clone",sJ="clipped",Ywa="clipPath",Zwa="clip.y",$wa="clip.x",axa="clip.width",bxa="clip.height",tJ="clip-path",cxa="clear-float",dxa="clear",uJ="classdef",NJ="circle",exa="chxt",fxa="chxl",gxa="chtt",OJ="cht",PJ="chs",hxa="chld",ixa="chl",jxa="chf",QJ="checked",RJ="checkbox",kxa="check",lxa="chdl",mxa="chd",SJ="chco",TJ="chartarea",UJ="chartType",nxa="chartScroll",oxa="chartRightClick",pxa="chartPinchStart",qxa="chartPinchEnd",rxa="chartPinch",sxa="chartOptions",txa=
"chartMouseUp",uxa="chartMouseMove",vxa="chartMouseDown",wxa="chartHoverOut",xxa="chartHoverIn",yxa="chartDragStart",zxa="chartDragEnd",Axa="chartDrag",Bxa="chartDblClick",Cxa="chartClick",VJ="chartArea.width",WJ="chartArea.top",XJ="chartArea.left",YJ="chartArea.height",ZJ="chartArea.backgroundColor",$J="chartArea",Dxa="chart.title",Exa="chart.subtitle",Fxa="chart.style.titleSpacing",Gxa="chart.style.title",aK="chart.style.text",Hxa="chart.style.subtitleSpacing",Ixa="chart.style.subtitle",Jxa="chart.style.chartArea",
Kxa="chart.style.background",Lxa="chart-shapes",Mxa="chart-layout",Nxa="chart-gridlines",Oxa="chart-chrome",bK="character",cK="change",Pxa="centerSelectionAroundData",dK="center",Qxa="cccccc",eK="categorysensitivityarea",fK="categorypoint",Rxa="categoryHoverOut",Sxa="categoryHoverIn",Txa="categoryClick",gK="category",hK="canvas",iK="candlesticks",Uxa="candlestick.risingColor",Vxa="candlestick.hollowIsRising",Wxa="candlestick.fallingColor",jK="candlestick",Xxa="can't stage a shape that's already staged.",
Yxa="can't stage a shape that's already drawn.",Zxa="callback",kK="bvs",lK="bvg",mK="button",nK="bubbles",$xa="bubble.textStyle",aya="bubble.stroke",bya="bubble.opacity",cya="bubble.highContrast",oK="bubble",dya="boxes",eya="boxWidth",fya="boxStyle",pK="box",qK="bounds",gya="bound",rK="bottom_left",sK="bottom-vert",tK="bottom-space",uK="bottom",hya="border:0;vertical-align:bottom;",iya="border.top",jya="border.right",kya="border.left",lya="border.bottom",vK="border-box",wK="border",mya="bold ",xK=
"bold",yK="blur",zK="blue",nya="blendingMode",AK="black",BK="bhs",CK="bhg",oya="bg",pya="bfbfbf",DK="below",qya="begin",EK="beforeshow",FK="beforehide",GK="beforedrag",HK="baselineColor",IK="baseline",JK="bars",rya="barWidth",sya="bar.",KK="backgroundColor.fill",LK="backgroundColor",tya="background-color",MK="background",uya="axistick",vya="axisTitlesPosition",wya="axisLabelFormatter",xya="axisBackgroundColor",NK="axis",yya="axes.target.all",zya="axes.target.",Aya="axes.domain.all",Bya="axes.domain.",
Cya="axes.all",OK="axes.",Dya="attachToStart",Eya="attachToEnd",PK="async",QK="arial",RK="aria-label",SK="aria-hidden",Fya="aria-activedescendant",TK="areaOpacity",Gya="area.",UK="arc",Hya="antialiased",VK="annotationtext",WK="annotations.textStyle",Iya="annotations.style",Jya="annotations.stemLength",Kya="annotations.stemColor",Lya="annotations.highContrast",Mya="annotations.domain.textStyle",Nya="annotations.domain.style",Oya="annotations.domain.stemLength",Pya="annotations.domain.stemColor",Qya=
"annotations.domain.boxStyle",Rya="annotations.datum.textStyle",Sya="annotations.datum.style",Tya="annotations.datum.stemLength",Uya="annotations.datum.stemColor",Vya="annotations.datum.highContrast",Wya="annotations.datum.boxStyle",Xya="annotations.datum.alwaysOutside",Yya="annotations.boxStyle",Zya="annotations.alwaysOutside",$ya="annotationHoverOut",aza="annotationHoverIn",bza="annotationClick",cza="annotation.",XK="annotation",dza="animationframefinish",eza="animationfinish",fza="animationEasing",
gza="animation.startup",hza="animation.maxFramesPerSecond",iza="animation.easing",YK="animation.duration",ZK="animation",jza="animate",kza="angle",lza="alwaysOutside",$K="always",mza="allowContainerBoundaryTextCufoff",aL="allValuesSuffix",nza="aggregationTarget",oza="aftershow",pza="afterhide",qza="ae",rza="additions text",sza="addPathMove",tza="addPathLine",uza="addPathCurve",vza="addPathClose",wza="addPathArc",bL="add",cL="activedescendant",xza="activate",yza="actionsMenuEntryHoverOut",zza="actionsMenuEntryHoverIn",
Aza="actionsMenuEntryClick",Bza="actionsMenuEntry",Cza="actionsMenu.textStyle",Dza="actionsMenu.disabledTextStyle",dL="above",Eza="charts-slider-thumb-dragging",Fza="charts-slider-dragging",Gza="charts-slider-disabled",Hza="charts-serverchart-image",Iza="charts-select",Jza="charts-option-selected",eL="charts-option",Kza="charts-modalpopup",fL="charts-menuseparator",Lza="charts-menuitem-mnemonic-separator",
Mza="charts-menuitem-accel",Nza="charts-menuitem",Oza="charts-menuheader",Pza="charts-menu-button",gL="charts-menu",Qza="charts-link-button",hL="charts-inline-block ",iL="charts-inline-block",Rza="charts-flat-button",Sza="charts-custom-button",Tza="charts-control",Uza="charts-container",Vza="charts-checkbox",Wza="charts-button",
Xza="_trendline",jL="_selectedLabels",kL="_focusedLabels",Yza="_discrete",Zza="_callbacks_.",$za="__td-colSpan",aAa="__internal_",bAa="__DISPUTED__All",cAa="__DISPUTED__",dAa="__",eAa="_ABSTRACT_RENDERER_ID_",lL="_",fAa="Your browser does not support charts",gAa="Y",mL="X",hAa="Windows CE",iAa="WebFont",jAa="WA",kAa="Verification object ",nL="Value",lAa="Unknown granularity.",mAa="Unexpected domain column (column #",nAa="Unable to set parent component",oAa="UTF-8",oL="US-",pL="US",pAa="UL",qAa="UK",
rAa="Trillion",sAa="Trendline ",qL="To",tAa="Timeout reached for loading script ",uAa="Theme should be a theme name or an options object.",vAa="The visualization is not ready yet.",wAa="The columns type does not match the supported data format. See documentation for supported formats.",rL="Text",sL="TOOLTIP",xAa="StartToStart",yAa="StartToEnd",zAa="Start and end points must be 2D",tL="Start",AAa="SourceGraphic",BAa="SourceAlpha",CAa="ShockwaveFlash.ShockwaveFlash.7",DAa="ShockwaveFlash.ShockwaveFlash.6",
EAa="ShockwaveFlash.ShockwaveFlash.",FAa="ShockwaveFlash.ShockwaveFlash",GAa="Shockwave Flash",HAa="Shape exists and is not a staged shape.",IAa="Shape does not exist in this group.",JAa="Scroll",KAa="Script ",uL="Scatter",vL="SUBTYPE",LAa="SUBREGIONS",MAa="SU",wL="Roboto2:medium",xL="Roboto2",NAa="RightClick",OAa="Requested map does not exist.",PAa="Rect",yL="ROW_INDEX",zL="ROW",QAa="REGIONS",RAa="Quadrillion",SAa="Publish to web page",TAa="Previous: ",UAa="Previous data",VAa="PlugIn",AL="Pie",WAa=
"Path",XAa="PROVINCES",YAa="Other",ZAa="Only one data column with role 'tooltip' per series is allowed",$Aa="One or more fonts could not be loaded",aBa="OK",BL="OBJECT_INDEX",bBa="No datatable provided.",CL="No data",cBa="MouseUp",dBa="MouseDown",eBa="Million",DL="MMMM dd, yyyy",EL="MMM",fBa="METROS",FL="Lines",GL="Line",gBa="Last domain does not have enough data columns (missing ",hBa="LLL",HL="LI",iBa="LAYER",jBa="Jsloader error (code #",kBa="Javascript code",lBa="Items",mBa="Invalid orientation.",
nBa="HoverOut",oBa="HoverIn",pBa="HTML",qBa="HH:mm:ss.SSS",rBa="HH:mm:ss",sBa="HH:mm MMMM dd, yyyy",tBa="HEAD",uBa="Group",vBa="Google_Visualization",wBa="Google Visualization",xBa="Geocoding failed for all data points",yBa="GViz is Great.",IL="GVIZARC",zBa="First column must contain date, or date and time.",ABa="First column must be a domain column",BBa='Failed geocoding "',CBa="Export data as HTML",DBa="Export data as CSV",EBa="Error while loading script ",FBa="EndToEnd",JL="End",GBa="Ellipse",
HBa="Each values column may be followed by one or two annotation columns. column number ",IBa="Drawing_Frame_",JBa="DblClick",KL="Data table is not defined",KBa="Data must contain at least two columns.",LBa="Data has no columns.",MBa="DOMMouseScroll",LL="DOMAIN_INDEX",ML="DIV",NBa="Current: ",OBa="Copy-Paste this code to an HTML page",NL="Component already rendered",OL="Columns",PBa="Color",QBa="Close",RBa="Click to expand annotations",SBa="Click",TBa="Circle",UBa="Chart options",VBa="Cancel",PL=
"COUNTRIES",QL="COM",WBa="COLUMN_INDEX",RL="COLUMN",SL="CELL",TL="C",XBa="Billion",UL="Bars",YBa="BODY",VL="BACKGROUND",ZBa="B",$Ba="Attempted to remove shape that doesn't have a context.",WL="Arial",XL="Area",aCa="All domains must be of the same data type",bCa="All data columns of the same series must be of the same data type",cCa="Add to iGoogle",dCa="ActiveX",eCa="AbstractStatsModel",YL="AT",fCa="A tabular representation of the data in the chart.",gCa="A chart.",ZL="A ",$L="<style> v\\:* { behavior:url(#default#VML);}</style>",
hCa='<span style="color:',iCa='<script type="text/javascript">',jCa='<param name="movie" value="',kCa='<param name="flashvars" value="',lCa='<param name="',mCa='<object id="',nCa='<iframe style="',oCa='<html>\n <head>\n  <title>Google Visualization API</title>\n  <script type="text/javascript" src="http://www.google.com/jsapi">\x3c/script>\n  <script type="text/javascript">\n   google.load(\'visualization\', \'1\', {packages: [\'',pCa='<html xmlns="http://www.w3.org/1999/xhtml"',qCa='<html xmlns:v="urn:schemas-microsoft-com:vml">',
aM="<head>",rCa='<embed type="application/x-shockwave-flash" src="',sCa='<div id="renderers"></div>',tCa='<div id="chartArea"></div>',bM='<div id="',uCa="<default>",vCa='<body marginwidth="0" marginheight="0"',wCa='<?xml version="1.0"?>',xCa="</strong>",cM="</span>",yCa="\x3c/script>",zCa="</p>",ACa="</object>",dM="</li>",eM="</html>",fM="</head>",gM="</div>",hM="</body>",iM="</a>",BCa="< ",CCa=";width:",DCa=";text-decoration:",ECa=";stop-opacity:",FCa=";overflow-y:",GCa=";margin:0;font-style:",HCa=
";height:",ICa=";font-weight:",JCa=";color:",KCa=":|",jM=":mm",LCa=":m",kM=": ",MCa="9e9e9e",lM="900",NCa="90%",OCa="9.0",PCa="808080",mM="800",nM="700",oM="7",QCa="65%",pM="636363",qM="600",rM="6",RCa="533.17.9",SCa="532.0",TCa="531",UCa="525",sM="500",VCa="50%",WCa="5.5",XCa="49.99%",YCa="420+",tM="400",uM="4",ZCa="300%",$Ca="300",vM="2d",aDa="200px",bDa="200",wM="2",cDa="1px solid infotext",xM="1px",yM="1e12",zM="15px",dDa="12pt Times New Roman",AM="100%",BM="100",eDa="10.0",fDa="1/",gDa="1.8",
hDa="0.###E0",CM="0%",iDa="0 0 4 4",DM="0 0",EM="/core/tooltip.css",jDa="/core/patterns/",kDa="/>",lDa="//chart.googleapis.com/chart",mDa=".visibleInLegend",nDa=".type",oDa=".top",pDa=".title",qDa=".textStyle",rDa=".subtitle",sDa=".style",tDa=".ry",uDa=".rx",vDa=".right",wDa=".offset",xDa=".left",yDa=".lbl",zDa=".js",ADa=".inLegend",BDa=".hole",CDa=".gradient.y2",DDa=".gradient.y1",EDa=".gradient.x2",FDa=".gradient.x1",GDa=".gradient.to",HDa=".gradient.from",IDa=".gif",JDa=".enableInteractivity",
KDa=".discrete",LDa=".color",MDa=".bottom",NDa=".axis",ODa=".annotations.",PDa=".all",FM="./text",GM="./svg-util",HM="./shapes",IM="./rect",QDa="./path-util",JM="./path",KM="./mobile-util",LM="./line",MM="./group",NM="./ellipse",OM="./circle",PM="./abstract_shape",RDa="../../shapes/shapes",SDa="../../shapes/rect-util",TDa="-webkit-user-select:none;",UDa="-webkit",VDa="-vertical",WDa="-undetermined",XDa="-unchecked",YDa="-transition",ZDa="-title-text",$Da="-title-draggable",aEa="-title-close",bEa=
"-title",cEa="-selected",dEa="-rtl",QM="-outer-box",eEa="-open",fEa="-o",RM="-nonstrict",gEa="-ms",hEa="-moz",iEa="-mag",SM="-inner-box",jEa="-hover",kEa="-horizontal",lEa="-highlight",mEa="-focused",TM="-dropdown",UM="-disabled",VM="-default",WM="-content",nEa="-collapse-right",oEa="-collapse-left",pEa="-checked",qEa="-checkbox",XM="-caption",rEa="-buttons",sEa="-bg",tEa="-active",uEa="-1000px",vEa="-10000px",wEa="-100%",xEa="--",yEa=",0,",zEa=") translate(",AEa='(\n       document.getElementById(\'visualization\')).\n        draw(response.getDataTable(), null);\n      });\n   }\n\n   google.setOnLoadCallback(drawVisualization);\n  \x3c/script>\n </head>\n <body>\n  <div id="visualization" style="width: 500px; height: 500px;"></div>\n </body>\n</html>',
BEa="']});\n\n   function drawVisualization() {\n    new google.visualization.Query('",CEa="').send(\n     function(response) {\n      new ",DEa="&up__table_query_url=",EEa="&up_",FEa="&nbsp;",GEa="%s://www.gstatic.com/charts/%s/%s/",HEa="%s's administration (under dispute)",IEa="%s",JEa="$version",KEa="$1 ",LEa="#fff0db",MEa="#ffd1c9",NEa="#ffbc46",YM="#f00",OEa="#eeeeee",PEa="#eeeeac",QEa="#eeee5b",ZM="#eee",$M="#e0e0e0",REa="#default#VML",SEa="#dea19b",aN="#dc3912",TEa="#d6b9db",UEa="#d2feb0",
VEa="#ce9839",lFa="#cdc785",bN="#cccccc",cN="#ccc",mFa="#c991ff",nFa="#b7b7b7",oFa="#aea971",pFa="#ad7d79",qFa="#a992ad",rFa="#a2c488",dN="#FFFFFF",eN="#FF9900",fN="#EFE6DC",sFa="#DDD",gN="#DC3912",hN="#CCCCCC",tFa="#9e9e9e",uFa="#9bbdde",iN="#999999",jN="#999",kN="#994499",vFa="#8080ff",wFa="#7f9a6b",xFa="#7993ad",lN="#757575",mN="#666666",nN="#666",yFa="#636363",oN="#444444",pN="#3399CC",qN="#333333",zFa="#333",rN="#222222",sN="#109618",tN="#0f0",uN="#00f",AFa="#000020",vN="#000",BFa="#.###",wN=
'"></div>',xN='">',CFa='". Axis does not exist.',DFa='" width="',yN='" value="',EFa='" style="',FFa='" src="http://www.google.com/ig/ifr?url=',GFa='" name="',HFa='" height="',IFa='" classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" width="',zN='" ',JFa=' xmlns:xlink="http://www.w3.org/1999/xlink">',KFa=' xmlns:svg="http://www.w3.org/2000/svg"',LFa=" was not defined.",AN=" to ",MFa=' onload="CHART_loaded()"',NFa=" loaded, but verification object ",BN=' id="',OFa=" does not have a domain column.",
PFa=" already defined.",QFa=" _loaded = true;",RFa=" [+]",SFa=" = ",CN=" 0 0 1 ",TFa=" 0 ",UFa=" / ",VFa=" - Flash Player Installation",DN=" - ",WFa=" + ",XFa=" * ",YFa=" (count)",EN=" (",ZFa="\n yyyy",$Fa="\n a",aGa="\n M/d";function FN(){}FN[K].lf=function(){};function bGa(a){var b=a[je],c=a[Ac];c||Hm(a)!=hh||(c=Hl(a)[lc]);if(!c)return b;if(pl)var d=dn(c),b=b+d[G];else vl(8)&&!vl(9)&&(d=dn(c),b-=d[G]);return Ym(c)?c[be]-(b+a[Gb]):b};function GN(a,b,c,d,e,f,g,k,l){var n=HN(c),p=Vm(a),t=Nm(a);t&&p.lA(zm(t));var t=Fl(a),u=Fl(c);if(t.oc()!=u.oc()){var x=t.oc()[ke],u=u.lC(),A=new xl(0,0),C=Pl(Hl(x)),E=x;do{var Q=C==u?Om(E):yfa(E);A.x+=Q.x;A.y+=Q.y}while(C&&C!=u&&C!=C[SA]&&(E=C.frameElement)&&(C=C[SA]));x=Al(A,Om(x));!ol||vl(9)||sm(t)||(x=Al(x,tm(t)));$a(p,p[G]+x.x);p.top+=x.y}a=IN(a,b);p=new xl(a&2?p[G]+p[r]:p[G],a&1?p.top+p[z]:p.top);p=Al(p,n);e&&(p.x+=(a&2?-1:1)*e.x,p.y+=(a&1?-1:1)*e.y);var N;if(g)if(l)N=l;else if(N=Nm(c))N.top-=
n.y,Ua(N,N[kd]-n.x),Ma(N,N[Uc]-n.y),$a(N,N[G]-n.x);return JN(p,c,d,f,N,g,k)}function HN(a){var b;if(a=a[Ac]){var c=a[$c]==pBa||a[$c]==YBa;c&&Hm(a)==hi||(b=Om(a),c||(c=(c=Ym(a))&&pl?-a[Tc]:!c||ol&&ul(Js)||Gm(a,era)==vi?a[Tc]:a[Oc]-a[be]-a[Tc],b=Al(b,new xl(c,a[Ud]))))}return b||new xl}
function JN(a,b,c,d,e,f,g){a=a[Jc]();var k=IN(b,c);c=Um(b);g=g?g[Jc]():c[Jc]();a=a[Jc]();g=g[Jc]();var l=0;if(d||0!=k)k&2?a.x-=g[r]+(d?d[kd]:0):d&&(a.x+=d[G]),k&1?a.y-=g[z]+(d?d[Uc]:0):d&&(a.y+=d.top);f&&(e?(d=a,k=g,l=0,65==(f&65)&&(d.x<e[G]||d.x>=e[kd])&&(f&=-2),132==(f&132)&&(d.y<e.top||d.y>=e[Uc])&&(f&=-5),d.x<e[G]&&f&1&&(d.x=e[G],l|=1),d.x<e[G]&&d.x+k[r]>e[kd]&&f&16&&(na(k,h.max(k[r]-(d.x+k[r]-e[kd]),0)),l|=4),d.x+k[r]>e[kd]&&f&1&&(d.x=h.max(e[kd]-k[r],e[G]),l|=1),f&2&&(l=l|(d.x<e[G]?16:0)|(d.x+
k[r]>e[kd]?32:0)),d.y<e.top&&f&4&&(d.y=e.top,l|=2),d.y<=e.top&&d.y+k[z]<e[Uc]&&f&32&&(Ta(k,h.max(k[z]-(e.top-d.y),0)),d.y=e.top,l|=8),d.y>=e.top&&d.y+k[z]>e[Uc]&&f&32&&(Ta(k,h.max(k[z]-(d.y+k[z]-e[Uc]),0)),l|=8),d.y+k[z]>e[Uc]&&f&4&&(d.y=h.max(e[Uc]-k[z],e.top),l|=2),f&8&&(l=l|(d.y<e.top?64:0)|(d.y+k[z]>e[Uc]?128:0)),e=l):e=256,l=e);f=new xm(0,0,0,0);$a(f,a.x);f.top=a.y;na(f,g[r]);Ta(f,g[z]);e=l;if(e&496)return e;Im(b,new xl(f[G],f.top));g=f.Tb();Dl(c,g)||(c=g,g=Hl(b),f=sm(Fl(g)),!ol||ul(uf)||f&&
ul(Js)?(b=b[w],pl?b.MozBoxSizing=vK:ql?b.WebkitBoxSizing=vK:b.boxSizing=vK,na(b,h.max(c[r],0)+P),Ta(b,h.max(c[z],0)+P)):(g=b[w],f?(f=cn(b),b=dn(b),g.pixelWidth=c[r]-b[G]-f[G]-f[kd]-b[kd],g.pixelHeight=c[z]-b.top-f.top-f[Uc]-b[Uc]):(g.pixelWidth=c[r],g.pixelHeight=c[z])));return e}function IN(a,b){return(b&4&&Ym(a)?b^2:b)&-5};function KN(a,b,c){xz(this,a);this.sJ=b;this.$va=c}W(KN,FN);KN[K].lf=function(a,b,c){GN(this[uC],this.sJ,a,b,void 0,c,this.$va)};function LN(a,b){this.Z=a instanceof xl?a:new xl(a,b)}W(LN,FN);LN[K].lf=function(a,b,c,d){GN(Lm(a),0,a,b,this.Z,c,null,d)};function MN(a,b,c,d){KN[L](this,a,b);this.AQ=c?5:0;this.w5=d||void 0}W(MN,KN);MN[K].Ama=function(){return this.AQ};MN[K].lf=function(a,b,c,d){var e=GN(this[uC],this.sJ,a,b,null,c,10,d,this.w5);if(e&496){var f=NN(e,this.sJ);b=NN(e,b);e=GN(this[uC],f,a,b,null,c,10,d,this.w5);e&496&&(f=NN(e,f),b=NN(e,b),GN(this[uC],f,a,b,null,c,this.AQ,d,this.w5))}};function NN(a,b){a&48&&(b^=2);a&192&&(b^=1);return b};function ON(a,b){this.Z=a instanceof xl?a:new xl(a,b)}W(ON,FN);ON[K].lf=function(a,b,c,d){var e;e=Hl(a);var f=e[ke];e=e[lc];e=new xl(f[Tc]||e[Tc],f[Ud]||e[Ud]);f=this.Z.x+e.x;e=this.Z.y+e.y;var g=HN(a),f=f-g.x;e-=g.y;JN(new xl(f,e),a,b,c,null,null,d)};function cGa(a){if(a[wr]&&!a[ts]||a[ds]||112<=a[pr]&&123>=a[pr])return!1;switch(a[pr]){case 18:case 20:case 93:case 17:case 40:case 35:case 27:case 36:case 45:case 37:case 224:case 91:case 144:case 12:case 34:case 33:case 19:case 255:case 44:case 39:case 145:case 16:case 38:case 224:case 92:return!1;case 0:return!pl;default:return 166>a[pr]||183<a[pr]}}
function dGa(a,b,c,d,e){if(!(ol||ql&&ul(UCa)))return!0;if(rl&&e)return PN(a);if(e&&!d)return!1;Ui(b)&&(b=QN(b));if(!c&&(17==b||18==b||rl&&91==b))return!1;if(ql&&d&&c)switch(a){case 220:case 219:case 221:case 192:case 186:case 189:case 187:case 188:case 190:case 191:case 192:case 222:return!1}if(ol&&d&&b==a)return!1;switch(a){case 13:return!0;case 27:return!ql}return PN(a)}
function PN(a){if(48<=a&&57>=a||96<=a&&106>=a||65<=a&&90>=a||ql&&0==a)return!0;switch(a){case 32:case 63:case 107:case 109:case 110:case 111:case 186:case 59:case 189:case 187:case 61:case 188:case 190:case 191:case 192:case 222:case 219:case 220:case 221:return!0;default:return!1}}function QN(a){if(pl)a=eGa(a);else if(rl&&ql)t:switch(a){case 93:a=91;break t}return a}
function eGa(a){switch(a){case 61:return 187;case 59:return 186;case 173:return 189;case 224:return 91;case 0:return 224;default:return a}};function RN(a,b){hv[L](this);this.Bd=new Bx(this);this.$w(a||null);b&&this.Pv(b)}W(RN,hv);R=RN[K];R.n=null;R.nba=!0;R.aaa=null;R.Kda=null;R.xD=!1;R.Vqa=!1;R.T0=-1;R.aoa=!1;R.ora=!0;R.Ng=mD;Pq(R,function(){return this.Ng});R.Pv=function(a){this.Ng=a};R.a=function(){return this.n};R.$w=function(a){fGa(this);this.n=a};R.nO=function(a){fGa(this);this.nba=a};R.vP=function(a,b){this.qC=a;this.YC=b};R.Jc=function(){return this.Bd};
function fGa(a){if(a.xD)throw m("Can not change this state of the popup while showing.");}R.W=function(){return this.xD};sy(R,function(a){this.qC&&this.qC[qs]();this.YC&&this.YC[qs]();a?this.O3():this.XD()});R.lf=Ji;
R.O3=function(){if(!this.xD&&this.JZ()){if(!this.n)throw m("Caller must call setElement before trying to show the popup");this.lf();var a=Hl(this.n);this.aoa&&this.Bd.k(a,fH,this.boa,!0);if(this.nba)if(this.Bd.k(a,Tt,this.pba,!0),ol){var b;try{b=a[ub]}catch(c){}for(;b&&b[Cd]==Maa;){try{var d=b[vC]||b[vr][ce]}catch(e){break}a=d;b=a[ub]}this.Bd.k(a,Tt,this.pba,!0);this.Bd.k(a,cwa,this.oba)}else this.Bd.k(a,yK,this.oba);this.Ng==mD?(kb(this.n[w],vi),Wm(this.n,!0)):this.Ng==$F&&this.lf();this.xD=!0;this.T0=
Zi();this.qC?(cv(this.qC,zI,this.qba,!1,this),this.qC[KB]()):this.qba()}};R.XD=function(a){if(!this.xD||!this[ir]({type:FK,target:a}))return!1;this.Bd&&this.Bd.nc();this.xD=!1;Zi();this.YC?(cv(this.YC,zI,Yi(this.ifa,a),!1,this),this.YC[KB]()):this.ifa(a);return!0};R.ifa=function(a){this.Ng==mD?this.Vqa?sv(this.zda,0,this):this.zda():this.Ng==$F&&(this.n[w].top=vEa);this.d0(a)};R.zda=function(){kb(this.n[w],sh);Wm(this.n,!1)};R.JZ=function(){return this[ir](EK)};R.qba=function(){this[ir](dE)};
R.d0=function(a){this[ir]({type:BH,target:a})};R.pba=function(a){a=a[ys];hm(this.n,a)||gGa(this,a)||this.Kda&&!hm(this.Kda,a)||150>Zi()-this.T0||this.XD(a)};R.boa=function(a){27==a[pr]&&this.XD(a[ys])&&(a[hr](),a[Er]())};R.oba=function(a){if(this.ora){var b=Hl(this.n);if("undefined"!=typeof ea[ub]){if(a=b[ub],!a||hm(this.n,a)||a[$c]==YBa)return}else if(a[ys]!=b)return;150>Zi()-this.T0||this.XD()}};function gGa(a,b){return yj(a.aaa||[],function(a){return b===a||hm(a,b)})}
R.D=function(){RN.e.D[L](this);this.Bd.$();Lu(this.qC);Lu(this.YC);delete this.n;delete this.Bd;delete this.aaa};function SN(a,b){this.K$=4;this.ya=b||void 0;RN[L](this,a)}W(SN,RN);Dy(SN[K],function(){return this.ya||null});wz(SN[K],function(a){this.ya=a||void 0;this.W()&&this.lf()});SN[K].lf=function(){if(this.ya){var a=!this.W()&&this[Tr]()!=$F,b=this.a();a&&(kb(b[w],sh),Wm(b,!0));this.ya.lf(b,this.K$,this.uya);a&&Wm(b,!1)}};function TN(a,b,c){this.U=c||(a?Fl(Il(a)):Fl());SN[L](this,this.U.m(ch,{style:Aqa}));this.xb=new xl(1,1);this.Ra=new hl;a&&this.xA(a);null!=b&&this.ds(b)}W(TN,SN);var UN=[];R=TN[K];R.dg=null;pb(R,"charts-tooltip");R.DP=500;R.gaa=0;R.pa=function(){return this.U};R.xA=function(a){a=Il(a);this.Ra.add(a);$u(a,Vt,this.Sr,!1,this);$u(a,Ut,this.$U,!1,this);$u(a,dG,this.gfa,!1,this);$u(a,ih,this.Vu,!1,this);$u(a,yK,this.$U,!1,this)};
R.detach=function(a){if(a)a=Il(a),hGa(this,a),this.Ra[Tb](a);else{for(var b=this.Ra.Qa(),c=0;a=b[c];c++)hGa(this,a);this.Ra[bc]()}};function hGa(a,b){dv(b,Vt,a.Sr,!1,a);dv(b,Ut,a.$U,!1,a);dv(b,dG,a.gfa,!1,a);dv(b,ih,a.Vu,!1,a);dv(b,yK,a.$U,!1,a)}R.ds=function(a){im(this.a(),a)};R.G2=function(a){var b=this.a();b&&wl(b,a)};R.$w=function(a){var b=this.a();b&&am(b);TN.e.$w[L](this,a);a&&(b=this.U.oc()[ke],b[Lb](a,b[Lc]))};R.Zv=function(){return mm(this.a())};R.M8=function(){return this.a()[vd]};
Nq(R,function(){return this.Vv?this.W()?4:1:this.IJ?3:this.W()?2:0});R.JZ=function(){if(!RN[K].JZ[L](this))return!1;if(this[lC])for(var a,b=0;a=UN[b];b++)hm(a.a(),this[lC])||a[yA](!1);Dj(UN,this)||UN[B](this);a=this.a();pb(a,this[ae]);VN(this);$u(a,Vt,this.Eba,!1,this);$u(a,Ut,this.Dba,!1,this);WN(this);return!0};
R.d0=function(){Ij(UN,this);for(var a=this.a(),b,c=0;b=UN[c];c++)b[lC]&&hm(a,b[lC])&&b[yA](!1);this.Fba&&XN(this.Fba);dv(a,Vt,this.Eba,!1,this);dv(a,Ut,this.Dba,!1,this);sz(this,void 0);0==this[Qr]()&&(this.TQ=!1);RN[K].d0[L](this)};R.Sfa=function(a,b){this[lC]==a&&this.Ra[Yc](this[lC])&&(this.TQ||!this.Hya?(this[yA](!1),this.W()||(sz(this,a),this[tC](b||this.uQ(0)),this[yA](!0))):sz(this,void 0));this.Vv=void 0};R.YL=function(){return this.Ra};R.aG=function(){return this.dg};
R.Tva=function(a){this.IJ=void 0;a==this[lC]&&(null!=this.dg&&(this.dg==this.a()||this.Ra[Yc](this.dg))||this.Taa&&this.Taa.dg||this[yA](!1))};function iGa(a,b){var c=tm(a.U);a.xb.x=b[Qd]+c.x;a.xb.y=b[Rd]+c.y}R.Sr=function(a){var b=YN(this,a[ys]);this.dg=b;VN(this);b!=this[lC]&&(sz(this,b),this.Vv||(this.Vv=sv(U(this.Sfa,this,b,void 0),this.DP)),jGa(this),iGa(this,a))};function YN(a,b){try{for(;b&&!a.Ra[Yc](b);)b=b[Ce];return b}catch(c){return null}}R.gfa=function(a){iGa(this,a);this.TQ=!0};
R.Vu=function(a){this.dg=a=YN(this,a[ys]);this.TQ=!0;if(this[lC]!=a){sz(this,a);var b=this.uQ(1);VN(this);this.Vv||(this.Vv=sv(U(this.Sfa,this,a,b),this.DP));jGa(this)}};R.uQ=function(a){return 0==a?(a=this.xb[Jc](),new ZN(a)):new $N(this.dg)};function jGa(a){if(a[lC])for(var b,c=0;b=UN[c];c++)hm(b.a(),a[lC])&&(b.Taa=a,a.Fba=b)}R.$U=function(a){var b=YN(this,a[ys]),c=YN(this,a[er]);b!=c&&(b==this.dg&&(this.dg=null),WN(this),this.TQ=!1,!this.W()||a[er]&&hm(this.a(),a[er])?sz(this,void 0):XN(this))};
R.Eba=function(){var a=this.a();this.dg!=a&&(VN(this),this.dg=a)};R.Dba=function(a){var b=this.a();this.dg!=b||a[er]&&hm(b,a[er])||(this.dg=null,XN(this))};function WN(a){a.Vv&&(tv(a.Vv),a.Vv=void 0)}function XN(a){2==a[Qr]()&&(a.IJ=sv(U(a.Tva,a,a[lC]),a.gaa))}function VN(a){a.IJ&&(tv(a.IJ),a.IJ=void 0)}R.D=function(){this[yA](!1);WN(this);this[MB]();this.a()&&am(this.a());this.dg=null;delete this.U;TN.e.D[L](this)};function ZN(a,b){LN[L](this,a,b)}W(ZN,LN);
ZN[K].lf=function(a,b,c){b=Lm(a);b=Nm(b);c=c?new um(c.top+10,c[kd],c[Uc],c[G]+10):new um(10,0,0,10);JN(this.Z,a,4,c,b,9)&496&&JN(this.Z,a,4,c,b,5)};function $N(a){KN[L](this,a,3)}W($N,KN);$N[K].lf=function(a,b,c){var d=new xl(10,0);GN(this[uC],this.sJ,a,b,d,c,9)&496&&GN(this[uC],2,a,1,d,c,5)};function aO(a){var b=null,c=null;Vi(a)?b=a:c=a;this.rra=b;this.n=c;this.jU=null}aO[K].qo=function(a){this.jU=a;this.n&&bo(this.n,a)};aO[K].sv=function(){return this.n?Rfa(this.n):this.jU};aO[K].a=function(){this.n||(this.n=this.rra(),null===this.jU||bo(this.n,this.jU));return this.n};function bO(){this.md=[]}R=bO[K];R.Vj=function(a){this.md[B](a)};Ty(R,function(a,b){this.Vj(cO(a,b))});R.ha=function(a,b){this.Vj({type:OG,data:{x:a,y:b}})};R.Qp=function(a,b,c,d,e,f){this.Vj({type:ZI,data:{x1:a,y1:b,Fb:c,Kb:d,x:e,y:f}})};R.zf=function(a,b,c,d,e,f,g){this.Vj({type:UK,data:{HC:a,IC:b,Hi:c,Ii:d,tx:e,Xr:f,ica:g}})};
function dO(a,b,c){if(0!=b[J])if(0==a.md[J]?a[yB](b[0].x,b[0].y):a.ha(b[0].x,b[0].y),c)for(var d=1;d<b[J];++d)a.Qp(c[d-1][1].x,c[d-1][1].y,c[d][0].x,c[d][0].y,b[d].x,b[d].y);else for(d=1;d<b[J];++d)a.ha(b[d].x,b[d].y)}By(R,function(){this.Vj({type:rJ,data:null})});function cO(a,b){return{type:aG,data:{x:a,y:b}}}function eO(a,b){var c=new bO;0<a[J]&&(dO(c,a),b||c[Hr]());return c};var kGa={Uwa:TD,CENTER:dK,Jwa:zI};function fO(a,b,c){switch(c){case TD:c=a;a+=b;break;case zI:c=a-b;break;case dK:c=a-b/2;a+=b/2;break;default:c=a=ia}return{start:c,end:a}}function gO(a,b,c,d){d&&(c=c===TD?zI:c===zI?TD:c);switch(c){case zI:return b;case dK:return Uk(a,b);default:return a}};function hO(a,b){Ju[L](this);this.ea=a;this.PD=b;this.Kt=null;this.bf=Ao(U(function(a,b,e){return this.WD(a,b,e)},this),function(a,b){var e=[a,b[0]];Zj(b[1],function(a,b){e[B](a);e[B](b)});e[B](+b[2]);return e[Fe](lL)});this.hw=null}W(hO,Ju);
function iO(){Fi.__googleVisualizationAbstractRendererElementsCount__=Fi.__googleVisualizationAbstractRendererElementsCount__||0;var a=eAa+Fi.__googleVisualizationAbstractRendererElementsCount__[qc]();Fi.__googleVisualizationAbstractRendererElementsCount__++;return a}R=hO[K];na(R,0);Ta(R,0);R.xm=function(a,b){var c=this.OR(a,b);c.qo(Dg);return this.Kt=c};R.deleteContents=function(a){this.P5(a)};R.flush=function(){};va(R,function(){this.Ag()});R.Ag=function(){this.Kt=null};
R.D=function(){this.Ag();hO.e.D[L](this)};Oq(R,function(){return this.ea});R.qo=function(a,b){a&&(a[Bc]==aO?a.qo(b):bo(a,b))};R.sv=function(a){return Rfa(a)};R.appendChild=function(a,b){if(b){var c;if(b[Bc]==aO){if(!b.n)return;c=b.a()}else c=b;a.a()[q](c)}};R.replaceChild=function(a,b,c){a.a()[rB](b,c)};R.Oc=function(a){if(a.n){var b=a.a();this.Fu.Oc(b);a.a()}};R.Ba=function(a){a=null!=a?a:!1;var b=new aO(U(this.l1,this));a||b.a();return b};R.nB=function(){};R.vG=function(){return null};
function jO(a,b,c,d,e,f){var g=new bO;g[yB](b,c);g.ha(d,e);return a.zc(g,f)}R.zc=function(a,b){for(var c=[],d=0;d<a.md[J];d++){var e=c,f=a.md[d];switch(f[H]){case aG:f=f[Y];this.nd(e,f.x,f.y);break;case OG:f=f[Y];this.xa(e,f.x,f.y);break;case ZI:f=f[Y];this.Gr(e,f.x1,f.y1,f.Fb,f.Kb,f.x,f.y);break;case UK:f=f[Y];this.cn(e,f.HC,f.IC,f.Hi,f.Ii,f.tx,f.Xr,f.ica);break;case rJ:this.Ri(e)}}return this.g2(c,b)};R.ce=function(a,b,c,d,e){a=this.kx(a,b,c,d);this[q](e,a);return a};
R.zj=function(a,b,c,d,e,f){a=this.O5(a,b,c,d,e);this[q](f,a);return a};R.eb=function(a,b,c,d,e,f){a=this.nl(a,b,c,d,e);this[q](f,a);return a};R.DF=function(a,b,c,d,e,f){a=jO(this,a,b,c,d,e);this[q](f,a);return a};R.ta=function(a,b,c){a=this.zc(a,b);this[q](c,a);return a};R.Jd=function(a,b,c,d,e,f,g,k,l){a=this.wx(a,b,c,d,e,f,g,l);this[q](k,a);return a};R.Ji=function(a,b,c,d,e,f,g,k,l,n){a=this.sM(a,b,c,d,e,f,g,k,n);this[q](l,a);return a};
function lGa(a,b,c,d,e,f,g,k,l,n){b=a.jt(b,c,d,e,f,g,k,l,void 0);a[q](n,b)}R.sl=function(a,b){return this.bf(a,b)[r]};R.eD=function(){return!1};R.KM=function(){};R.pK=Jk;function mGa(a){return pm(a,function(a){return a.referencepoint},!0)}function kO(a){var b=mGa(a[ys]);return Pm(a,b)};function lO(a,b){hO[L](this,a,b);this.Fu=Fl(a);this.fQ=this.Fu.oc();this.Cr=[];this.H=new Bx}W(lO,hO);function nGa(a,b,c,d){b=new TN(b);var e=a.Fu.m(ch);c=c[zc](Je);e[q](a.Fu[Jb](c[0]));for(var f=1;f<c[J];++f)e[q](a.Fu.m(Sg)),e[q](a.Fu[Jb](c[f]));Bm(e,d);b.a()[q](e);b.DP=100;b.gaa=100;a.Cr[B](b)}R=lO[K];R.Wf=function(a){this.Fu[Rr](a);fv(a)};va(R,function(){this.H.nc();Lu(this.H);this.H=new Bx;lO.e[bc][L](this)});
R.Ag=function(){lO.e.Ag[L](this);X(this.Cr,function(a){Lu(a)});Fj(this.Cr);this.Fu.Oc(this.ea);this.H.nc();Lu(this.H)};R.Al=function(a){var b=mGa(a);return b?(b=Pm(a,b),a=Um(a),new um(b.y,b.x+a[r],b.y+a[z],b.x)):null};R.fc=function(a,b,c){a[Bc]==aO&&(a=a.a());this.H.k(a,b,c)};R.replaceChild=function(a,b,c){lO.e[rB][L](this,a,b,c);fv(c)};function mO(a,b,c,d){this.x0=a;this.y0=b;this.x1=c;this.y1=d}Ia(mO[K],function(){return new mO(this.x0,this.y0,this.x1,this.y1)});ab(mO[K],function(a){return this.x0==a.x0&&this.y0==a.y0&&this.x1==a.x1&&this.y1==a.y1});function oGa(a){var b=a.x1-a.x0;a=a.y1-a.y0;return h[Kd](b*b+a*a)}function nO(a,b){return new xl(Nk(a.x0,a.x1,b),Nk(a.y0,a.y1,b))};function oO(a,b){this.x=a;this.y=b}W(oO,xl);R=oO[K];Ia(R,function(){return new oO(this.x,this.y)});R.pha=function(){return h[Kd](this.x*this.x+this.y*this.y)};Na(R,xl[K][bB]);R.add=function(a){this.x+=a.x;this.y+=a.y;return this};R.E5=function(a){this.x-=a.x;this.y-=a.y;return this};R.rotate=function(a){var b=h.cos(a);a=h.sin(a);var c=this.y*b+this.x*a;this.x=this.x*b-this.y*a;this.y=c;return this};ab(R,function(a){return this==a||!!a&&this.x==a.x&&this.y==a.y});
function pO(a,b){return new oO(a.x+b.x,a.y+b.y)}function qO(a,b){return new oO(a.x-b.x,a.y-b.y)};function rO(a,b){lO[L](this,a,b);this.na=null;var c=Fl(b)[Vb](hK);this.PD[q](c);this.Jda=c[NB](vM);this.Hn=this.ja=this.fU=null}W(rO,lO);function sO(a){a.Mea||(a.na[IB](),a.Hn=new um(da,-da,-da,da),a.Mea=!0)}function tO(a,b,c){a.Hn&&($a(a.Hn,h.min(a.Hn[G],b)),a.Hn.top=h.min(a.Hn.top,c),Ua(a.Hn,h.max(a.Hn[kd],b)),Ma(a.Hn,h.max(a.Hn[Uc],c)))}R=rO[K];R.OR=function(a,b){var c=Fl(this.ea)[Vb](hK);c[v](yi,a);c[v](rh,b);this.ja=new Cl(a,b);this.ea[q](c);this.na=c[NB](vM);return new aO(c)};
R.P5=function(){var a=this.Kt.a();this.na.clearRect(0,0,a[r],a[z])};function uO(a){return Fl(a.ea)[Vb](fva)}function vO(a,b){if(a==O)return $E;b==O&&(b=1);return ipa+xn(sn(a).sc)+jf+b+ef}function wO(a,b){"undefined"!==typeof a.setLineDash?a.setLineDash(b):a.TBa=b}function xO(a,b,c,d,e){var f=/^(\d+(\.\d*)?)\%$/;typeof b===ii&&f[od](b)?(b=ka(f[xb](b)[1])/100,c&&null!=e?b=d?e[z]*b+e.top:e[r]*b+e[G]:null!=a.ja&&(b=d?a.ja[z]*b:a.ja[r]*b)):b=+b;return b}
R.si=function(a,b){Uy(this.na,vO(a.pe,a.pi));ry(this.na,vO(a.fb(),a.Oe));var c=a.wl;null!=c&&c==VI?wO(this.na,[8,2]):Oi(c)?wO(this.na,c):wO(this.na,[]);var d=a.ud,c=a.Jg;if(null!=d){var e;switch(d[gd]()){case nF:c=this.fQ[Vb](hK),c[v](yi,4),c[v](rh,4),e=c[NB](vM),ry(e,d[xe]()),e[fB](0,0,4,4),Uy(e,d.ge()),e[IB](),My(e,2),e.lineCap=WD,e[oA](2,0),e[pB](4,2),e[oA](0,2),e[pB](2,4),e[ec](),e=c}ry(this.na,this.na.createPattern(e,opa))}else if(null!=c){var f=c.nr||!1,d=xO(this,c.x1,f,!1,b);e=xO(this,c.y1,
f,!0,b);var g=xO(this,c.Fb,f,!1,b),f=xO(this,c.Kb,f,!0,b),d=this.na.createLinearGradient(d,e,g,f);d[sC](0,c.kg);d[sC](1,c.Nf);ry(this.na,d)}My(this.na,a.Lb)};function pGa(a,b){b.lc&&b.lc!=O?(Uy(a,b.lc),My(a,3)):Uy(a,$E);ry(a,vO(b[F],b[fe]?b[fe]:1));wO(a,[]);var c=M;b.Tc&&(c=Zsa);b[Xd]&&(c+=mya);c+=b[Gc]+oqa+b.$a;a.font=c}R.kx=function(a,b,c,d){this.na[IB]();this.si(d,new xm(a-c,b-c,2*c,2*c));this.na.arc(a,b,c,0,2*h.PI);this.na[kB]();this.na[nc]();this.na[ec]();return uO(this)};
R.O5=function(a,b,c,d,e){this.na[KA]();this.si(e,new xm(a-c,b-d,2*c,2*d));this.na[OB](a,b);c>d?(this.na[bB](1,d/c),a=c):(this.na[bB](c/d,1),a=d);this.na.arc(0,0,a,0,2*h.PI,!1);this.na[nc]();this.na[ec]();this.na[cB]();return uO(this)};R.nl=function(a,b,c,d,e){this.si(e,new xm(a,b,c,d));this.na[fB](a,b,c,d);this.na[WB](a,b,c,d);return uO(this)};R.c1=function(){return uO(this)};R.g2=function(a,b){this.si(b,zm(this.Hn));this.na[nc]();this.na[ec]();this.Mea=!1;this.Hn=null;return uO(this)};
R.wx=function(a,b,c,d,e,f,g){return this.jt(a,b,c,d,0,e,f,g)};R.sM=function(a,b,c,d,e,f,g,k){var l=gO(b,d,f),n=gO(c,e,f),p=oGa(new mO(b,c,d,e));return this.jt(a,l,n,p,Rk(b,c,d,e),f,g,k)};
R.jt=function(a,b,c,d,e,f,g,k){pGa(this.na,k);this.na[KA]();e=Ok(e);d=b*h.sin(-e)+c*h.cos(-e);b=b*h.cos(-e)-c*h.sin(-e);this.na[OA](e);g==TD?d+=4*k[Gc]/5:g==dK?d+=k[Gc]/3:g==zI&&(d-=k[Gc]/5);f!=TD&&(f==dK?b-=this.WD(a,k)[r]/2:f==zI&&(b-=this.WD(a,k)[r]));this.na.strokeText(a,b,d);this.na[hA](a,b,d);k.Re&&(this.na[IB](),e=k[Gc]/15,d+=e+1,1>e&&(e=1),My(this.na,e),this.na[oA](b,d),this.na[pB](this.na.measureText(a)[r]+b,d),Uy(this.na,this.na.fillStyle),this.na[ec]());this.na[cB]();return uO(this)};
R.l1=function(){return uO(this)};R.nB=function(a){if(null===a)return uO(this);this.fU=a;this.na[KA]();this.na[IB]();ry(this.na,$E);this.na[eC](a[G],a.top,a[r],a[z]);this.na.clip();return uO(this)};R.vG=function(){var a=this.fU;this.fU&&(this.fU=null,this.na[cB]());return a};R.cG=function(){return uO(this)};R.nd=function(a,b,c){sO(this);this.na[oA](b,c);tO(this,b,c)};R.xa=function(a,b,c){sO(this);this.na[pB](b,c);tO(this,b,c)};
R.Gr=function(a,b,c,d,e,f,g){sO(this);this.na.bezierCurveTo(b,c,d,e,f,g);tO(this,b,c);tO(this,d,e);tO(this,f,g)};R.Ri=function(){sO(this);this.na[kB]()};R.cn=function(a,b,c,d,e,f,g,k){sO(this);f=Ok(f-90);g=Ok(g-90);a=h.max(d,e);this.na[KA]();this.na[OB](b,c);this.na[bB](d/a,e/a);this.na.arc(0,0,a,f,g,!k);this.na[cB]()};R.Nm=function(){};R.xg=function(){};R.Yj=function(){};R.TS=function(){};R.VS=function(){};R.ld=function(){};
R.WD=function(a,b){pGa(this.Jda,b);return new Cl(this.Jda.measureText(a)[r],b[Gc])};R.i3=function(){return uO(this)};R.nj=function(){};var yO;function zO(a,b){b?a[v](Zh,b):a[ad](Zh)}function AO(a,b,c){Oi(c)&&(c=c[Fe](Ke));var d=Ig+b;if(c===M||void 0==c)yO||(yO={atomic:!1,autocomplete:O,dropeffect:O,haspopup:!1,live:UF,multiline:!1,multiselectable:!1,orientation:ui,readonly:!1,relevant:rza,required:!1,sort:O,busy:!1,disabled:!1,hidden:!1,invalid:fh}),c=yO,b in c?a[v](d,c[b]):a[ad](d);else a[v](d,c)}function BO(a,b){var c=a[oe](Ig+b);return null==c||void 0==c?M:String(c)}function CO(a){return BO(a,cH)}function DO(a,b){AO(a,cH,b)};function EO(a){Ju[L](this);this.A=a;this.H=new Bx}W(EO,Ju);R=EO[K];Oq(R,function(){return this.A});va(R,function(){this.rH();this.H=new Bx});R.rH=function(){Yl(this.A);this.H.nc();Lu(this.H)};R.D=function(){this.rH();EO.e.D[L](this)};R.fc=function(a,b,c){this.H.k(a,b,c)};function FO(a,b){var c=ga[K][qd][L](arguments),d=c[wb]();if("undefined"==typeof d)throw m("[goog.string.format] Template required");return d[Ab](/%([0\-\ \+]*)(\d+)?(\.(\d+))?([%sfdiu])/g,function(a,b,d,k,l,n,p,t){if(n==Ve)return Ve;var u=c[wb]();if("undefined"==typeof u)throw m("[goog.string.format] Not enough arguments");arguments[0]=u;return GO[n][Zc](null,arguments)})}
var GO={s:function(a,b,c){return fa(c)||c==M||a[J]>=c?a:a=-1<b[zd](lf,0)?a+ij(Ke,c-a[J]):ij(Ke,c-a[J])+a},f:function(a,b,c,d,e){d=a[qc]();fa(e)||e==M||(d=a[Bb](e));var f;f=0>a?lf:0<=b[zd](hf)?hf:0<=b[zd](Ke)?Ke:M;0<=a&&(d=f+d);if(fa(c)||d[J]>=c)return d;d=fa(e)?h.abs(a)[qc]():h.abs(a)[Bb](e);a=c-d[J]-f[J];0<=b[zd](lf,0)?d=f+d+ij(Ke,a):(b=0<=b[zd](pf,0)?pf:Ke,d=f+ij(b,a)+d);return d},d:function(a,b,c,d,e,f,g,k){return GO.f(ja(a,10),b,c,d,0,f,g,k)}};GO.i=GO.d;GO.u=GO.d;function HO(a,b){lO[L](this,a,b);this.Rp=null;this.eR={};this.k0={};this.WD(yBa,{fontSize:8,$a:WL,bold:!1,Tc:!1})}W(HO,lO);function qGa(a,b){a.Rp=a.Ya(OI);a.Rp[v](qH,OI);a.eR={};a.k0={};a.Zaa={};b[q](a.Rp)}R=HO[K];R.OR=function(a,b){na(this,a);Ta(this,b);var c=this.Ya(CD);c[v](yi,a);c[v](rh,b);c[w].overflow=sh;c[v](RK,gCa);this.ea[q](c);qGa(this,c);return new aO(c)};
R.Al=function(a){if(a instanceof Fi.SVGElement&&a[$c][He]()!==DF&&a[$c][He]()!==CD){var b=a.getBBox();return b.y|b.x|b[z]|b[r]?new um(b.y,b.x+b[r],b.y+b[z],b.x):HO.e.Al[L](this,a)}return HO.e.Al[L](this,a)};R.P5=function(){for(var a=this.Kt.a(),b=a[cc],c=b[J];1<c;)a[le](b[0]),c--;qGa(this,a)};R.Tqa=function(){return this.ea[vd]};Wa(R,function(a){return h[D](100*a)/100});R.kx=function(a,b,c,d){var e=this.Ya(NJ);e[v](XI,a);e[v](WI,b);e[v](Wh,c);this.nj(e,d);return e};
R.O5=function(a,b,c,d,e){var f=this.Ya(CI);f[v](XI,a);f[v](WI,b);f[v](SE,c);f[v](RE,d);this.nj(f,e);return f};R.nl=function(a,b,c,d,e){var f=this.Ya(iF);f[v](JC,a);f[v](zi,b);f[v](yi,c);f[v](rh,d);this.nj(f,e);return f};R.c1=function(a,b,c,d,e,f,g){b=CH+c+mqa+(f?ME:sh)+FCa+(g?ME:sh)+CCa+b+lqa;d=this.OR(d,e);if(Pi(a))for(e=0,c=a[J];e<c;e++)this[q](d,a[e]);else this[q](d,a);a=Ql(ch,{style:b},d.a());this.ea[q](a);return{append:[],events:[d.a()]}};
R.g2=function(a,b){var c=this.Ya(DF);0<a[J]&&c[v](Vg,a[Fe](M));this.nj(c,b);return c};R.wx=function(a,b,c,d,e,f,g,k){return this.jt(a,b,c,d,0,e,f,g,k)};R.sM=function(a,b,c,d,e,f,g,k,l){var n=gO(b,d,f,l),p=gO(c,e,f,l),t=oGa(new mO(b,c,d,e));return this.jt(a,n,p,t,Rk(b,c,d,e),f,g,k,l)};
R.jt=function(a,b,c,d,e,f,g,k,l){var n=Gi(k[fe])?k[fe]:1,p=new lo({fill:k[F],fillOpacity:n});if(k[F]&&k[F]!=O&&k.lc&&k.lc!=O){var n=new lo({fill:k[F],fillOpacity:n,stroke:k.lc,strokeOpacity:n,strokeWidth:3}),t=this.Ba();this.YJ(a,b,c,d,e,f,g,k,n,t,l)[v](SK,pi);this.YJ(a,b,c,d,e,f,g,k,p,t,l);return t.a()}return this.XJ(a,b,c,d,e,f,g,k,p,l)};
R.XJ=function(a,b,c,d,e,f,g,k,l,n){d=this.Ya(hu);g=fO(0,k[Gc],g);g=gO(g[y],g.end,zI);g-=.15*k[Gc];g=new oO(0,g);g[OA](Ok(e));c=new oO(b,c);c.add(g);b=c.x;c=c.y;d[q](this.fQ[Jb](a));switch(f){case TD:d[v](wD,TD);break;case dK:d[v](wD,nG);break;case zI:d[v](wD,zI)}d[v](JC,b);d[v](zi,c);d[v](Mua,k.$a);d[v](Kua,k[Gc]||0);k[Xd]&&d[v](dI,xK);k.Tc&&d[v](eI,hH);k.Re&&d[v](Pna,dD);n&&d[v](ah,$h);0!=e&&d[v](fD,WE+e+Ke+b+Ke+c+ef);this.nj(d,l);return d};
R.YJ=function(a,b,c,d,e,f,g,k,l,n,p){a=this.XJ(a,b,c,d,e,f,g,k,l,p);this[q](n,a);return a};R.l1=function(){return this.Ya(lh)};R.cG=function(a,b,c){var d=iO(),e=this.Ya(Ywa);c?(c=this.Ya(CI),c[v](XI,b[G]+b[r]/2),c[v](WI,b.top+b[z]/2),c[v](SE,b[r]/2),c[v](RE,b[z]/2)):(c=this.Ya(iF),c[v](JC,b[G]),c[v](zi,b.top),c[v](yi,b[r]),c[v](rh,b[z]));e[q](c);e[v](qH,d);this.Rp[q](e);a=a.a();b=M;pl&&(b=ba[Fc][Vc][zc](Oe)[0]);a[v](tJ,Rma+b+Oe+d+ef);return a};R.nd=function(a,b,c){a[B](Xf+b+jf+c)};
R.xa=function(a,b,c){a[B](Wf+b+jf+c)};R.Gr=function(a,b,c,d,e,f,g){a[B](TL+b+jf+c+jf+d+jf+e+jf+f+jf+g)};R.Ri=function(a){a[B](zg)};R.cn=function(a,b,c,d,e,f,g,k){if(0<d&&0<e){var l;l=Mk(g,360)-Mk(f,360);180<l?l-=360:-180>=l&&(l=360+l);var n=2*h.PI*h.min(d,e);.1>h.abs(l/360*n)&&(l=(.1/n*360-h.abs(l))*Sk(l)/2,f-=l,g+=l)}f=Mk(f,360);g=Mk(g,360);var n=Pk(g-90,d),p=Qk(g-90,e);l=k?g-f:f-g;0>l&&(l+=360);a[B](Hf+d+jf+e+yEa+(180<l?1:0)+jf+(k?1:0)+jf+(b+n)+jf+(c+p))};
R.Nm=function(a,b,c){a[v](fD,cna+b+kf+c+ef)};R.xg=function(a,b){a[v](yi,b)};R.Yj=function(a,b){a[v](rh,b)};R.TS=function(a,b){a[v](JC,b)};R.VS=function(a,b){a[v](zi,b)};R.ld=function(a,b,c){a[v](LD,c);b&&a[v](ND,b)};
R.WD=function(a,b,c){var d=this.PD;pa(d[Yb],a);a=d[w];Ry(a,b.$a);Fa(a,b[Gc]+P);hz(a,b[Xd]?xK:M);qz(a,b.Tc?hH:M);Qa(a,rt);null!=c&&(b=FO(gpa,c),zz(a,b),a.transformOrigin=DM,a.WebkitTransform=b,a.WebkitTransformOrigin=DM,a.MozTransform=b,a.MozTransformOrigin=DM,a.Xya=b,a.Yya=DM,a.msTransform=b,a.Zya=DM);b=d[be];d=d[re];Qa(a,O);return new Cl(b,d)};
R.i3=function(){if(null!=this.hw)return this.hw;var a=Sl(ch);bb(a[w],gra);var b=Sl(ch);Rm(b,aDa,aDa);a[q](b);ea[ke][q](a);b=a[Gb]-a[be];am(a);return this.hw=b};R.Ya=function(a){return this.fQ[GA](uH,a)};
R.nj=function(a,b){oo(b)?(a[v](ND,b.pe),a[v](LD,b.Lb),oo(b)&&1<=b.pi?a[ad](MD):a[v](MD,b.pi),b.wl!=fi?a[v](Wna,rGa(b.wl,b.Lb)):a[ad](Wna)):(a[v](ND,O),a[v](LD,0));qo(b)?a[ad](mI):a[v](mI,b.Oe);var c=b.mJ;Ui(c)&&a[v](SE,c);c=b.nJ;Ui(c)&&a[v](RE,c);var d=b.Jg;if(d){var e=xp(d,1)[qc](),c=this.k0[e];if(!c){c=iO();this.k0[e]=c;var e=this.Ya(KG),f=d.x1,g=d.Fb,k=d.y1,l=d.Kb,n=d.kg,p=d.Nf,t=1;if(0===d.or||d.or)t=d.or;var u=1;if(0===d.pr||d.pr)u=d.pr;var x=d.nr?sra:$C;e[v](qH,c);e[v](IC,f);e[v](GC,k);e[v](HC,
g);e[v](FC,l);e[v](Zta,x);f=OD+n+ECa+t;p=OD+p+ECa+u;u=this.Ya(PD);u[v](TF,CM);u[v](ji,f);e[q](u);d.vF&&(d=this.Ya(PD),d[v](TF,XCa),d[v](ji,f),e[q](d),d=this.Ya(PD),d[v](TF,VCa),d[v](ji,p),e[q](d));d=this.Ya(PD);d[v](TF,AM);d[v](ji,p);e[q](d);this.Rp[q](e)}a[v](nI,bD+c+ef)}else if(null!=b.ud){e=b.ud;c=e[gd]()+lL+e.ge()+lL+e[xe]();if(!(c in this.eR)){d=null;switch(e[gd]()){case nF:d=this.Ya(Th);d[v](Uqa,$C);d[v](JC,pf);d[v](zi,pf);d[v](yi,uM);d[v](rh,uM);d[v](RC,iDa);p=this.Ya(iF);p[v](JC,pf);p[v](zi,
pf);p[v](yi,uM);p[v](rh,uM);p[v](nI,e[xe]());d[q](p);p=this.Ya(lh);p[v](ND,e.ge());p[v](Vna,WD);e=this.Ya(OG);e[v](IC,wM);e[v](GC,pf);e[v](HC,uM);e[v](FC,wM);e[v](LD,wM);p[q](e);e=this.Ya(OG);e[v](IC,pf);e[v](GC,wM);e[v](HC,wM);e[v](FC,uM);e[v](LD,wM);p[q](e);d[q](p);break;case apa:d=this.Ya(Th),d[v](Uqa,$C),d[v](JC,pf),d[v](zi,pf),d[v](yi,rM),d[v](rh,rM),d[v](RC,iDa),p=this.Ya(iF),p[v](JC,pf),p[v](zi,pf),p[v](yi,uM),p[v](rh,uM),p[v](nI,e[xe]()),d[q](p),p=this.Ya(lh),p[v](ND,e.ge()),p[v](Vna,WD),
e=this.Ya(OG),e[v](IC,wM),e[v](GC,pf),e[v](HC,pf),e[v](FC,wM),e[v](LD,wM),p[q](e),e=this.Ya(OG),e[v](IC,uM),e[v](GC,wM),e[v](HC,wM),e[v](FC,uM),e[v](LD,wM),p[q](e),d[q](p)}e=iO();d[v](qH,e);this.Rp[q](d);this.eR[c]=e}c=this.eR[c];a[v](nI,bD+c+ef)}else a[v](nI,b.fb());null!=b.faa&&(d=b.getShadow(),e=xp(d,1)[qc](),c=this.Zaa[e],c||(c=iO(),this.Zaa[e]=c,e=this.Ya(gh),e[v](qH,c),p=this.Ya(Uua),p[v](pH,BAa),p[v](aoa,d[HB]),e[q](p),p=this.Ya(Sua),p[v](FI,d.Aya||0),p[v](EI,d.Bya||0),e[q](p),null!=d[fe]&&
(p=this.Ya(Wua),u=this.Ya(Vua),u[v](qi,LG),u[v](joa,d[fe]),p[q](u),e[q](p)),d=this.Ya(Tua),p=this.Ya(tI),d[q](p),p=this.Ya(tI),p[v](pH,AAa),d[q](p),e[q](d),this.Rp[q](e)),a[v](gh,bD+c+ef))};function rGa(a,b){if(Oi(a))return a[Fe](jf);switch(a){case fi:return pf;case VI:return String(4*b)+jf+String(b);default:return rGa(fi,b)}}R.pK=function(){var a=Ql(ch,{"aria-label":fCa,style:zqa});this.ea[q](a);this.ea[v](RK,gCa);return a};function IO(a,b){lO[L](this,a,b);this.Bv=null}W(IO,lO);R=IO[K];R.OR=function(a,b){na(this,a);Ta(this,b);var c=this.ie(ch);this.Uj(c,-5E4,-5E4,this[r]+1E5,this[z]+1E5);this.ea[q](c);var d=this.Ba(),e=d.a();zy(e,DM);vz(e,a+Ke+b);e[w].top=5E4;$a(e[w],5E4);c[q](e);return d};R.P5=function(){for(var a=this.Kt.a(),b=a[cc],c=b[J];1<c;)a[le](b[0]),c--};Wa(R,function(a){return h[D](a)});R.kx=function(a,b,c,d){var e=this.ie(XC),f=2*c;this.Uj(e,a-c,b-c,f,f);this.nj(e,d,!1);return e};
R.O5=function(a,b,c,d,e){var f=this.ie(XC);this.Uj(f,a-c,b-d,2*c,2*d);this.nj(f,e,!1);return f};R.nl=function(a,b,c,d,e){var f=this.ie(Mma),g=qo(e)&&1<=d&&1<=c&&null==e.Jg;this.nj(f,e,g);if(oo(e)||g)c=h.max(c-1,0),d=h.max(d-1,0);this.Uj(f,a,b,c,d);return f};R.c1=function(a,b,c,d,e,f,g){b=Ql(ch,{style:CH+c+mqa+(f?ME:sh)+FCa+(g?ME:sh)+CCa+b+lF});b=new aO(b);if(Pi(a))for(c=0,d=a[J];c<d;c++)this[q](b,a[c]);else this[q](b,a);return{append:[b.a()],events:[]}};
R.g2=function(a,b){for(var c=this.ie(VC),d=this.ie(WC);0<a[J]&&bj(qj(a),Xf);)a=Nj(a,0,a[J]-1);d[v](si,a[Fe](M));this.Uj(c,0,0,this[r],this[z]);c[q](d);this.nj(c,b,!1);return c};R.wx=function(a,b,c,d,e,f,g){b=fO(b,d,e);c=fO(c,g[Gc],f);f=dK;c=gO(c[y],c.end,f);return this.sM(a,b[y],c,b.end,c,e,f,g)};
R.sM=function(a,b,c,d,e,f,g,k){var l=new lo({fill:k[F]});if(k[F]&&k[F]!=O&&k.lc&&k.lc!=O){var n=new lo({fill:k[F],stroke:k.lc,strokeWidth:2}),p=this.Ba();this.YJ(a,b,c,d,e,f,g,k,n,p);this.YJ(a,b,c,d,e,f,g,k,l,p);return p.a()}return this.XJ(a,b,c,d,e,f,g,k,l)};R.jt=function(a,b,c,d,e,f,g,k){e=Ok(e);d=fO(b,d,f);b=new oO(b,c);var l=new oO(d[y],c),l=l[Jc]().E5(b)[OA](e).add(b);c=new oO(d.end,c);c=c[Jc]().E5(b)[OA](e).add(b);return this.sM(a,l.x,l.y,c.x,c.y,f,g,k)};
R.XJ=function(a,b,c,d,e,f,g,k,l){var n=this.ie(VC);this.Uj(n,0,0,this[r],this[z]);g!=dK&&(g=fO(0,k[Gc],g),g=gO(g[y],g.end,dK),g=new oO(0,g),g[OA](Ok(Rk(b,c,d,e))),c=new oO(b,c),e=new oO(d,e),c.add(g),e.add(g),b=c.x,c=c.y,d=e.x,e=e.y);b=h[D](b);c=h[D](c);d=h[D](d);e=h[D](e);g=this.ie(WC);g[v](si,Xf+b+jf+c+Wf+d+jf+e+Pf);g[v](uD,pi);b=this.ie(Kma);b[v](Qh,pi);d=b[w];Fa(d,k[Gc]||M);Ry(d,k.$a||M);switch(f){case TD:d[v](ZC,Ch);break;case dK:d[v](ZC,dK);break;case zI:d[v](ZC,au)}k[Xd]&&hz(d,xK);k.Tc&&qz(d,
hH);b[v](ii,a);n[q](g);n[q](b);this.nj(n,l,!1);return n};R.YJ=function(a,b,c,d,e,f,g,k,l,n){a=this.XJ(a,b,c,d,e,f,g,k,l);this[q](n,a);return a};R.l1=function(){var a=this.ie(Nma);this.Uj(a,0,0,this[r],this[z]);return a};R.cG=function(a,b){var c=this.ie(ch),d=[this.Zb(5E4+b.top),this.Zb(5E4+b[G]+b[r]),this.Zb(5E4+b.top+b[z]),this.Zb(5E4+b[G])];c[w].clip=bqa+d[Fe](kf)+ef;this.Uj(c,0,0,this[r]+1E5,this[z]+1E5);a.a();d=new aO(c);this[q](d,a);this.eb(1,1,1,1,new lo({fill:xi}),d);return c};
R.nd=function(a,b,c){a[B](Xf+h[D](b)+jf+h[D](c))};R.xa=function(a,b,c){a[B](Wf+h[D](b)+jf+h[D](c))};R.Gr=function(a,b,c,d,e,f,g){a[B](TL+h[D](b)+jf+h[D](c)+jf+h[D](d)+jf+h[D](e)+jf+h[D](f)+jf+h[D](g))};R.Ri=function(a){a[B](mL)};
R.cn=function(a,b,c,d,e,f,g,k){f=Mk(f,360);g=Mk(g,360);var l=h[D](Pk(f-90,d)),n=h[D](Qk(f-90,e)),p=h[D](Pk(g-90,d)),t=h[D](Qk(g-90,e));d=h[D](d);e=h[D](e);b=h[D](b);c=h[D](c);l===p&&n===t&&(k&&180>Mk(g-f,360)||!k&&180>Mk(f-g,360))||a[B]((k?jAa:YL)+(b-d)+jf+(c-e)+jf+(b+d)+jf+(c+e)+jf+(b+l)+jf+(c+n)+jf+(b+p)+jf+(c+t))};R.Nm=function(a,b,c){a[w].top=this.Zb(c);$a(a[w],this.Zb(b))};R.xg=function(a,b){na(a[w],this.Zb(b))};R.Yj=function(a,b){Ta(a[w],this.Zb(b))};R.TS=function(a,b){$a(a[w],this.Zb(b))};
R.VS=function(a,b){a[w].top=this.Zb(b)};R.ld=function(a,b,c){0==c?gy(a,!1):(gy(a,!0),b&&Xy(a,b),qy(a,c))};R.WD=function(a,b){var c=this.PD;pa(c[Yb],a);var d=c[w];Ry(d,b.$a);Fa(d,this.Zb(b[Gc]||0));hz(d,b[Xd]?xK:M);qz(d,b.Tc?hH:M);Qa(d,rt);var e=c[be],c=c[re];Qa(d,O);b[Xd]&&(e*=1.1);b.Tc&&(e*=.9);return new Cl(e,c)};R.i3=function(){if(null!=this.hw)return this.hw;var a=Ql(ch,{style:vma});this.PD[q](a);Qa(this.PD[w],rt);this.hw=a[Gb]-a[be];Qa(this.PD[w],O);am(a);return this.hw};
R.Zb=function(a){return h[D](a)+P};R.ie=function(a){return this.fQ[Vb](a)};
R.nj=function(a,b,c){for(var d=a[Jd],e=0;e<d[J];e++)a[Jd][e][$c]!=nI&&a[Jd][e][$c]!=ND||a[le](d[e]);c=null!=c?c:!0;if(oo(b)){if(gy(a,!0),qy(a,b.Lb),Xy(a,b.pe),c=!(oo(b)&&1<=b.pi),d=b.wl!=fi,c||d)e=this.ie(Lma),c&&qb(e,String(h[D](100*b.pi))+Ve),d&&(e.dashstyle=sGa(b.wl)),a[q](e)}else c&&qo(b)?(gy(a,!0),qy(a,1),Xy(a,b.fb())):gy(a,!1);Gi(a.filled)&&ay(a,!0);c=b.Jg;if(null!=c){b=this.ie(YC);b[v](oJ,c.kg);b[v](Vwa,c.Nf);b[v](Rh,c.or||1);b[v](mra,c.pr||1);var d=c.x1,e=c.y1,f=c.Fb;c=c.Kb;typeof d==ii&&
(d=ja(d,10));typeof e==ii&&(e=ja(e,10));typeof f==ii&&(f=ja(f,10));typeof c==ii&&(c=ja(c,10));c=Rk(d,e,f,c);c=Mk(270-c,360);b[v](kza,c);b[v](qi,PH);a[q](b)}else b.ud?(c=b.ud,b=this.ie(YC),b[v](qi,Th),b[v](oJ,c.ge()),b[v](Vwa,c[xe]()),c=up()+jDa+c[gd]()+IDa,b[v](gi,c),a[q](b)):b.fb()==O?ay(a,!1):qo(b)?hy(a,b.fb()):(c=this.ie(YC),qb(c,String(h[D](100*b.Oe))+Ve),Ya(c,b.fb()),a[q](c))};R.Uj=function(a,b,c,d,e){a=a[w];Ba(a,Fg);$a(a,this.Zb(b));a.top=this.Zb(c);na(a,this.Zb(d));Ta(a,this.Zb(e))};R.eD=function(){return!0};
function sGa(a){if(Oi(a))return a[Fe](Ke);switch(a){case fi:return fi;case VI:return Hoa;default:return sGa(fi)}};function JO(a,b,c,d){Ju[L](this);if(!(ol?0<=lj(tl,WCa):pl?0<=lj(tl,gDa):nl?0<=lj(tl,OCa):ql&&0<=lj(tl,YCa)))throw m("Graphics is not supported");for(var e=h[Eb](1E5*h[Pc]());ba[XB][IBa+e];)e++;this.Dk=IBa+e;(a=this.LJ=a)&&(a.referencepoint=!0);Xa(this.LJ,M);this.Jk=Fl(this.LJ);this.ea=this.Jk[Vb](ch);Ba(this.ea[w],Xh);this.Jk[q](this.LJ,this.ea);this.Rk=b;this.f0=this.bm=null;this.Ds=!1;this.fR=[];this.uk=null;this.Wqa=(b=ol?null!=ea[ye]?9>ea[ye]:!ul(wf):!1)?IO:HO;if(this.YQ=b||d)d=this.Jk[Vb](xh),
gb(d,this.Dk),d.id=this.Dk,na(d,this.Rk[r][qc]()),Ta(d,this.Rk[z][qc]()),Ny(d,0),cz(d,XF),Gy(d,0),ty(d,0),d.allowTransparency=pi,b||db(d,ita),this.Jk[q](this.ea,d),d=d[vC]||d[vr][ce],d[Xr](),a=[],b?(a[B](qCa),a[B](aM),a[B]($L)):(a[B](wCa),a[B](pCa),a[B](KFa),a[B](JFa),a[B](aM)),a[B](iCa),a[B](Bma),a[B](zua),a[B](QFa),a[B](Ci),a[B](yCa),a[B](fM),a[B](vCa),a[B](MFa),a[B](Ff),a[B](sCa),a[B](hM),a[B](eM),d[kr](a[Fe](Je)),d[Hr]();tGa(this,c)}W(JO,Ju);
function tGa(a,b){var c=U(a.owa,a),d=U(a.pwa,a);KO(c,d,b)}R=JO[K];R.pwa=function(){if(this.YQ){var a;a=(a=this.Jk.a(this.Dk))?a[vC]||a[vr][ce]:null;var b=this.bm=a[ud](Spa);b&&(b.referencepoint=!0);this.f0=LO(a[ke],this.Rk)}else this.bm=this.Jk[Vb](ch),Bm(this.bm,Uh,Xh),Rm(this.bm,this.Rk),this.bm.dir=GG,this.ea[q](this.bm),this.f0=LO(this.ea,this.Rk);this.Ds=!0};
function LO(a,b){var c=Fl(a),d=c[Vb](ch),e=d[w];Qa(e,O);Ba(e,Fg);e.top=b[z]+10+P;$a(e,b[r]+10+P);oy(e,VF);AO(d,sh,!0);d[v](SK,!0);e=c.oc();c[q](d,e[Jb](Ke));c[q](a,d);return d}R.owa=function(){if(!this.YQ)return!0;var a;return(a=(a=this.Jk.a(this.Dk))?a[vr]||Pl(a[vC]||a[vr][ce]):null)&&a._loaded};R.Wa=function(a){if(!this.Ds)return null;for(a=null!=a?a:0;this.fR[J]<=a;){var b=Fl(this.bm)[Vb](ch);Bm(b,Uh,Fg);Im(b,0,0);Rm(b,AM,AM);this.bm[q](b);b=new this.Wqa(b,this.f0);Ku(this,b);this.fR[B](b)}return this.fR[a]};
R.Mw=function(){if(!this.Ds)return null;if(!this.uk){var a;a=this.Jk[Vb](ch);this.uk=new EO(a);this.Jk[q](this.ea,this.uk[Sr]())}return this.uk};R.$n=function(a,b){KO(U(function(){return null!=this.bm},this),a,b)};yz(R,function(a,b){if(!Dl(this.Rk,a))if(this.Rk=a,this.YQ){var c=this.Jk.a(this.Dk);c&&(na(c,this.Rk[r][qc]()),Ta(c,this.Rk[z][qc]()))}else this.Ds&&Rm(this.bm,this.Rk);this.Ds||tGa(this,b)});function KO(a,b,c,d){a[L]()?b[L]():uGa(a,b,c,d)}
function uGa(a,b,c,d){var e=null!=d?d:10;ba[Dr](c(function(){KO(a,b,c,e)}),e)}R.D=function(){try{this.Jk.Oc(this.LJ),Lu(this.uk),X(this.fR,function(a){Lu(a)})}catch(a){}JO.e.D[L](this)};function MO(){this.md=[]}R=MO[K];R.Vj=function(a,b){this.md[B]({brush:a,S_:b})};Ty(R,function(a,b){this.Vj(null,cO(a,b))});R.ha=function(a,b,c){this.Vj(a,{type:OG,data:{x:b,y:c}})};R.Qp=function(a,b,c,d,e,f,g){this.Vj(a,{type:ZI,data:{x1:b,y1:c,Fb:d,Kb:e,x:f,y:g}})};R.zf=function(a,b,c,d,e,f,g,k){this.Vj(a,{type:UK,data:{HC:b,IC:c,Hi:d,Ii:e,tx:f,Xr:g,ica:k}})};By(R,function(a){var b=this.md[0].S_[Y];this.ha(a,b.x,b.y)});
function vGa(a){switch(a[H]){case aG:case OG:case ZI:return a=a[Y],new xl(a.x,a.y);case UK:a=a[Y];var b=Mk(a.Xr,360);return new xl(a.HC+Pk(b-90,a.Hi),a.IC+Qk(b-90,a.Ii));default:return new xl(0,0)}}
R.zc=function(a){for(var b=[],c=null,d=0;d<this.md[J];d++){var e=this.md[d],f=e.S_;if(f[H]==aG)c=vGa(f);else{t:{for(var e=e.brush,g=0;g<b[J];g++){var k=b[g];if(Wfa(e,k.brush)){e=k;break t}}k={brush:e,md:new bO,cf:null};b[B](k);e=k}yl(e.cf,c)||e.md[yB](c.x,c.y);e.md.Vj(f);c=e.cf=vGa(f)}}if(Ej(b))a=null;else if(1==b[J])a=a.zc(b[0].md,b[0].brush);else{c=a.Ba();for(d=0;d<b[J];d++)f=b[d],f=a.zc(f.md,f.brush),a[q](c,f);a=c.a()}return a};
function wGa(a){for(var b=new bO,c=0;c<a.md[J];c++)b.Vj(a.md[c].S_);return b};function xGa(a,b){var c=new bO,d=a.md;if(0==d[J]||1==d[J])return c;for(var e=[null],f=0;f<d[J];f++){var g=d[f];g[Y]&&e[B](new xl(g[Y].x,g[Y].y))}e[B](null);var g=d[d[J]-1][H]==rJ,f=e[1][Jc](),k=e[2][Jc](),l=e[e[J]-3][Jc](),n=e[e[J]-2][Jc]();g?(e[0]=n,e[e[J]-1]=f):yl(f,n)?(e[0]=l,e[e[J]-1]=k):(e[0]=nO(new mO(f.x,f.y,k.x,k.y),-1),e[e[J]-1]=nO(new mO(n.x,n.y,l.x,l.y),-1));for(var k=0>b,p=null,t=null,n=null,l=e[J]-2,f=0;f<=l;f++)if(!yl(e[f],e[f+1])){var u;u=e[f];var x=e[f+1],A,C=(x.y-u.y)/(x.x-u.x);A=
la(C)?{am:C,ep:u.y-C*u.x}:{am:da,ep:u.x};C=A.am;A=A.ep;if(C==da)u={am:da,ep:0>x.y-u.y?A+b:A-b};else{var E=b*h[Kd](1+C*C);u={am:C,ep:0<x.x-u.x?A+E:A-E}}p?(x=NO(p,u),Ri(x)?(C=NO(OO(t,e[f]),p),A=NO(OO(e[f],t),p),C=ao(new Yn(C.x,A.x),x.x)&&ao(new Yn(C.y,A.y),x.y)):C=x==da,p=C&&x!=da?x:NO(OO(e[f],t),p),c.Vj(yGa(n,p)),C||(n=NO(OO(e[f],e[f+1]),u),c.zf(e[f].x,e[f].y,h.abs(b),h.abs(b),180-180*h[Id](p.x-e[f].x,p.y-e[f].y)/h.PI,180-180*h[Id](n.x-e[f].x,n.y-e[f].y)/h.PI,k)),p=u,t=e[f],n=d[f]):(p=u,t=e[f],n=cO(d[f][Y].x,
d[f][Y].y))}g&&c[Hr]();return c}function yGa(a,b){var c=nk(a);switch(a[H]){case aG:case OG:c[Y].x=b.x;c[Y].y=b.y;break;case ZI:c[Y].x=b.x;c[Y].y=b.y;var d=b.x-a[Y].x,e=b.y-a[Y].y;c[Y].x1+=d;c[Y].y1+=e;c[Y].Fb+=d;c[Y].Kb+=e}return c}function OO(a,b){var c=(a.x-b.x)/(b.y-a.y),d;la(c)?d=a.y-c*a.x:(c=da,d=a.x);return{am:c,ep:d}}
function NO(a,b){var c=a.am,d=a.ep,e=b.am,f=b.ep;la(c)||(c=da);la(e)||(e=da);if(c==e||1E-5>=h.abs(c-e))return d==f||1E-5>=h.abs(d-f)?da:null;if(c==da)return new xl(d,e*d+f);if(e==da)return new xl(f,c*f+d);var g=e-c;return new xl(-(f-d)/g,(d*e-c*f)/g)};var PO=function(){function a(a,b){if(-1===b[zd](mf))return b;var c=a[zc](Gs);c.pop();var d=b[zc](Gs),l=d.pop();if(d[0]===mf)d[Ee][Zc](d,[0,1][Hb](c));else{for(var n=0,p=d[J];n<p;n++)if(d[n]===Es)c.pop(),d[Ee](n,1),n--;else break;d=c[Hb](d)}d[B](l);return d[Fe](Gs)}function b(b,c,g){for(var k=[],l=0,n=c[J];l<n;l++)k[B](d[a(b,c[l])]);d[b]=g[Zc](this,k)}var c,d={};b(uJ,[],function(){function a(){}function b(c){ob(a,c);return new a}function c(a){return function(){throw'abstract method "'+a+'" not implemented.';
}}function d(a,b){this.gX(a);this.AB[a][B](b);return this}function l(a,b){this.gX(a);for(var c=this.AB[a],d=null,e=0,f=c[J];e<f;e++)if(c[e]===b){d=e;break}return null!=d?(c[Ee](d,1),!0):!1}function n(a,b){this.gX(a);for(var c=this.AB[a],d=[],e=0,f=c[J];e<f;e++)d[B](c[e]);for(e=0;e<f;e++)d[e][Zc](this,b);return 0<f}function p(a){if(!this.AB[Hc](a))throw'event type "'+a+'" unknown.';}var t={};t.Xp=ca[xr]||b;t.Hia=c;t.Cia=function(a){for(var b=[vva,uva,tva,sva,rva,qva,Vpa,coa,dxa],d,e=0,f=b[J];e<f;e++)d=
b[e],a[K][d]=c(d)};t.kX=function(a){a[K].k=d;a[K].hb=l;a[K].fireEvent=n;a[K].gX=p};return t});b(Roa,[uJ],function(a){function b(a){this.AB={add:[],click:[],getcontext:[],mousemove:[],mouseenter:[],mouseleave:[],box:[],redraw:[],remove:[],playAnimation:[],finishAnimation:[]};this.Cj=this.wa=null;this.wd={};this.ZG=[];this.bO=[];this.Iia=d[fc](this);if(null!=a)for(var e in a)c[L](this,e,a[e])}function c(a,b){b instanceof ca&&(b=b[qc]());if(this.wd[a]===b)return!1;this.wd[a]=b;this.Rm=null;return!0}
function d(){if(!this.fX){for(var a=0,b=this.bO[J];a<b;a++)this.Jia(this.bO[a]);this.bO=[]}}pa(b[K],function(a){return void 0!==a?(this.wa=a,this):this.wa});Ay(b[K],function(a,b){return void 0!==b?(c[L](this,a,b)&&this[ZA](gF,[this,a]),this):a?this.wd[a]:this.wd});b[K].styles=function(a){for(var b in a)a[Hc](b)&&this[w](b,a[b]);return this};b[K].getContext=function(){this.Cj||this[ZA](RH,[this]);return this.Cj};b[K].Al=function(){if(!(null!=this.Rm||this.yB()&&null!=this.Rm||this[ZA](pK,[this])&&
null!=this.Rm))throw"cannot determine bounding box until inserted into a scene.";return this.Rm};b[K].yB=function(){return!1};b[K].Jia=function(a){if(this.fX)this.bO[B](a);else a=this.ZG[zd](a),-1<a&&this.ZG[Ee](a,1),0===this.ZG[J]&&this.hb(gI,this.Iia)};Ia(b[K],a.Hia(Xwa));a.kX(b);return b});b(dF,[uJ,Roa],function(a){function b(a,c,d){this.N=c;this.ra=d;this.AB={add:[],click:[],mousemove:[],mouseenter:[],mouseleave:[],redraw:[],remove:[]}}a.kX(b);a.Cia(b);return b});b(Ooa,[PM,uJ],function(a,b){function c(b,
d){a[L](this,d);this.Cf=[];if(b)throw"prepopulating a group is unimplemented.";this.Nr=l[fc](this);this.Jl=n[fc](this);this.Yp=p[fc](this);this.Or=t[fc](this)}function d(a){if(a[NB]())throw"cannot add a shape to a group that already has a context.";this.Cf[B](a);a.k(gF,this.Nr);a.k(vt,this.Jl);a.k(dG,this.Jl);a.k(fG,this.Jl);a.k(eG,this.Jl);a.k(RH,this.Yp);a.k(eF,this.Or);this[ZA](bL,[a,!1]);return this}function l(){}function n(a){this[ZA](a[H],[a])}function p(a){a.Cj=this;return!0}function t(a){var b=
this.Cf[zd](a);if(0>b)throw IAa;a.hb(gF,this.Nr);a.hb(vt,this.Jl);a.hb(dG,this.Jl);a.hb(fG,this.Jl);a.hb(eG,this.Jl);a.hb(RH,this.Yp);a.hb(eF,this.Or);a.Cj=null;this.Cf[Ee](b,1);return!0}function u(a){if(0>this.Cf[zd](a))throw IAa;a[ZA](eF,[a]);return this}ob(c,b.Xp(a[K]));Ea(c[K],c);c.Md=uBa;c[K].Hk=d;c[K].add=d;va(c[K],function(){for(var a=0,b=this.Cf[J];a<b;a++)this.Cf[a].hb(gF,this.Nr),this[ZA](eF,[this.Cf[a]]);this.Cf=[];this[ZA](gF,[this]);return this});Pa(c[K],function(a){return 0<=this.Cf[zd](a)});
c[K].YG=u;ua(c[K],u);c[K].$G=function(){return this.Cf};return c});b(Qoa,[PM,uJ],function(a,b){function c(b,d,f,g){g=g||{};g.r=null==b?g.r:b;g.x=null==d?g.x:d;g.y=null==f?g.y:f;a[L](this,g)}ob(c,b.Xp(a[K]));Ea(c[K],c);c.Md=TBa;c[K].yB=function(){var a=this[w](Wh),b=this[w](JC),c=this[w](zi);this.Rm={x:b-a,y:c-a,width:2*a,height:2*a};return!0};return c});b(Poa,[PM,uJ],function(a,b){function c(b,d,f,g,t){t=t||{};t.rx=null==b?t.rx:b;t.ry=null==d?t.ry:d;t.x=null==f?t.x:f;t.y=null==g?t.y:g;a[L](this,t)}
ob(c,b.Xp(a[K]));Ea(c[K],c);c.Md=GBa;c[K].yB=function(){var a=this[w](SE),b=this[w](RE),c=this[w](JC),d=this[w](zi);this.Rm={x:c-a,y:d-b,width:2*a,height:2*b};return!0};return c});b(Noa,[PM,uJ],function(a,b){function c(b,d,f,g,t){t=t||{};t.x1=null==b?t.x1:b;t.y1=null==d?t.y1:d;t.x2=null==f?t.x2:f;t.y2=null==g?t.y2:g;a[L](this,t)}ob(c,b.Xp(a[K]));Ea(c[K],c);c.Md=GL;c[K].yB=function(){var a=this[w](IC),b=this[w](GC),c=this[w](HC),d=this[w](FC);this.Rm={x:h.min(a,c),y:h.min(b,d),width:h.abs(c-a),height:h.abs(d-
b)};return!0};return c});b(xG,[],function(){function a(b,c){var d=b%c;return 0>d*c?d+c:d}function b(c,d,f){c=a(c,360);d=a(d,360);d<c&&(d+=360);f=a(f,360);f<c&&(f+=360);return f<=d}return{$N:a,eya:function(c,d,l,n,p,t,u){p=a(p,360);t=a(t,360);var x=p/180*h.PI,A=p/180*h.PI,C=c+l*h.cos(x),x=d+n*h.sin(x),E=c+l*h.cos(A),A=d+n*h.sin(A);u||(u=p,p=t,t=u);u=b(p,t,0)?c+l:h.max(C,E);var Q=b(p,t,90)?d+n:h.max(x,A);c=b(p,t,180)?c-l:h.min(C,E);d=b(p,t,270)?d-n:h.min(x,A);return{x1:c,y1:d,Fb:u,Kb:Q}},fya:function(a,
b,c,d){function e(p){var x=1-p,A=x*x,C=p*p,E=A*x,A=3*p*A,x=3*x*C;p*=C;f[B](a.x*E+b.x*A+c.x*x+d.x*p);u[B](a.y*E+b.y*A+c.y*x+d.y*p)}var f=[a.x,d.x],u=[a.y,d.y],x=2*a.x-4*b.x+2*c.x,A=b.x-a.x,C=-a.x+3*b.x+d.x-3*c.x,E=(-x+h[Kd](x*x-4*A*C))/(2*C),x=(-x-h[Kd](x*x-4*A*C))/(2*C);h.abs(E)>yM&&(E=.5);h.abs(x)>yM&&(x=.5);0<E&&1>E&&e(E);0<x&&1>x&&e(x);x=2*a.y-4*b.y+2*c.y;A=b.y-a.y;C=-a.y+3*b.y+d.y-3*c.y;E=(-x+h[Kd](x*x-4*A*C))/(2*C);x=(-x-h[Kd](x*x-4*A*C))/(2*C);h.abs(E)>yM&&(E=.5);h.abs(x)>yM&&(x=.5);0<E&&1>
E&&e(E);0<x&&1>x&&e(x);E={x1:h.min[Zc](h,f),y1:h.min[Zc](h,u),Fb:h.max[Zc](h,f),Kb:h.max[Zc](h,u)};na(E,E.Fb-E.x1);Ta(E,E.Kb-E.y1);return E}}});b(Moa,[PM,uJ,xG],function(a,b,c){function d(b){a[L](this,b);this.Rm={x1:null,y1:null,Fb:null,Kb:null,width:0,height:0};this.yu=[]}ob(d,b.Xp(a[K]));Ea(d[K],d);d.Md=WAa;d[K].yB=function(){return!1};Ty(d[K],function(a,b){this.yu[B]([Xf,a,b]);return this});tz(d[K],function(a,b){this.yu[B]([Wf,a,b]);return this});d[K].arc=function(a,b,d,e,f,k,A){f=c.$N(f,360);
k=c.$N(k,360);this.yu[B]([IL,a,b,d,e,f,k,ha(A)]);return this};By(d[K],function(){this.yu[B]([zg]);return this});return d});b(Loa,[PM,uJ],function(a,b){function c(b,d,f,g,t){t=t||{};t.x=null==b?t.x:b;t.y=null==d?t.y:d;na(t,null==f?t[r]:f);Ta(t,null==g?t[z]:g);a[L](this,t)}ob(c,b.Xp(a[K]));Ea(c[K],c);c.Md=PAa;c[K].yB=function(){this.Rm={x:this[w](JC),y:this[w](zi),width:this[w](yi),height:this[w](rh)};return!0};Ia(c[K],function(){return new c(this[w](JC),this[w](zi),this[w](yi),this[w](rh),this[w]())});
return c});b(Joa,[PM,uJ],function(a,b){function c(b,d,f,g){g=g||{};g.x=null==b?g.x:b;g.y=null==d?g.y:d;Oy(g,null==f?g[pd]:f);a[L](this,g)}ob(c,b.Xp(a[K]));Ea(c[K],c);c.Md=rL;return c});b(eE,[MM,OM,NM,LM,JM,IM,FM],function(a,b,c,d,l,n,p){return{IM:a,Circle:b,gx:c,Wp:d,Pw:l,Rect:n,Text:p}});b(qpa,[],function(){function a(b){for(var c=0,d=arguments[J];c<d;c++)if(null!=arguments[c])return arguments[c]}function b(c,d,f){t(c,d,f,!1);d=a(d[w](lI),d[w](jI),d[w](nI));typeof d!==ii&&typeof d!==Nh||c[v](nI,
d)}function c(b,d){var f=a(d[w](kI),d[w](iI),d[w](mI));typeof f!==ii&&typeof f!==Nh||b[v](mI,f)}function d(b,c,f){t(b,c,f,!0);c=a(c[w](KD),c[w](HD),c[w](ND));typeof c!==ii&&typeof c!==Nh||b[v](ND,c)}function l(b,c){var d=a(c[w](JD),c[w](Una),c[w](MD));typeof d!==ii&&typeof d!==Nh||b[v](MD,d)}function n(b,c){var d=a(c[w](ID),c[w](GD),c[w](LD));typeof d!==ii&&typeof d!==Nh||b[v](LD,d)}function p(a,b){var c=b[w](Rh);typeof c!==ii&&typeof c!==Nh||a[v](Rh,c)}function t(a,b,c,d){var e=d?ND:nI,f=b[w](e+
HDa),g=b[w](e+GDa);d=a[oe](e);if(f&&g){var k=b[w](e+FDa)||CM,l=b[w](e+DDa)||CM,n=b[w](e+EDa)||AM,p=b[w](e+CDa)||CM,e=[f,g,k,l,n,p][Fe](),t=b.Kl;if(b=t?S[e]:N[e])u=b[oe](qH);else{b=ea[GA](uH,KG);var u=gqa+(t?V++:T++);b[v](qH,u);b[v](IC,k);b[v](GC,l);b[v](HC,n);b[v](FC,p);k=ea[GA](uH,PD);k[v](Xna,f);k[v](TF,CM);f=ea[GA](uH,PD);f[v](Xna,g);f[v](TF,AM);b[q](k);b[q](f);for(t?S[e]=b:N[e]=b;c[Cd]!==CD;)c=c[Ce];c=c[Ub](OI)||c;c[Lb](b,c[Yb])}c=bD+u+ef;d!==c&&a[v](nI,c)}else d&&d[mc](0,5)===bD&&a[ad](e)}function u(a,
b,c){var d=b[w](BE)||0,e=b[w](CE)||0;if(d||e){var f=b[w](zE)||b[w](AE)||b[w](yE)||0,g=b[w](hE)||b[w](iE)||b[w](gE)||0,k=[d,e,f,g][Fe](),l=b.Kl,n=l?Ha[k]:sa[k];if(n)b=n[oe](qH);else{n=ea[GA](uH,gh);n[v](JC,wEa);n[v](zi,wEa);n[v](yi,ZCa);n[v](rh,ZCa);b=fqa+(l?Ra++:Ka++);n[v](qH,b);var p=ea[GA](uH,Uua);p[v](pH,BAa);p[v](aoa,d);d=ea[GA](uH,Sua);d[v](FI,f);d[v](EI,g);if(null!=e){var t=ea[GA](uH,Wua),u=ea[GA](uH,Vua);u[v](qi,LG);u[v](joa,e)}var f=ea[GA](uH,Tua),g=ea[GA](uH,tI),x=ea[GA](uH,tI);x[v](pH,AAa);
n[q](p);n[q](d);null!=e&&(t[q](u),n[q](t));f[q](g);f[q](x);n[q](f);for(l?Ha[k]=n:sa[k]=n;c[Cd]!==CD;)c=c[Ce];c=c[Ub](OI)||c;c[Lb](n,c[Yb])}c=a[oe](gh);b=bD+b+ef;c!==b&&a[v](gh,b)}else a[FB](gh)&&a[ad](gh)}var x={"fill.color":b,fillColor:b,fill:b,"fill.gradient.from":b,"fill.gradient.to":b,"fill.gradient.x1":b,"fill.gradient.y1":b,"fill.gradient.x2":b,"fill.gradient.y2":b,"fill.opacity":c,fillOpacity:c,"fill-opacity":c,height:function(a,b){var c=b[w](rh);a[v](rh,c)},opacity:p,"stroke.color":d,strokeColor:d,
stroke:d,"stroke.gradient.from":d,"stroke.gradient.to":d,"stroke.gradient.x1":d,"stroke.gradient.y1":d,"stroke.gradient.x2":d,"stroke.gradient.y2":d,"stroke.opacity":l,strokeOpacity:l,"stroke-opacity":l,"stroke.width":n,strokeWidth:n,"stroke-width":n,width:function(a,b){var c=b[w](yi);a[v](yi,c)},x:function(a,b){var c=b[w](JC);a[v](JC,c)},y:function(a,b){var c=b[w](zi);a[v](zi,c)}},A={},C={},E=0,Q=0,N={},S={},T=0,V=0,sa={},Ha={},Ka=0,Ra=0;return{W6:u,hx:function(a,e,t){p(a,e);b(a,e,t);c(a,e);d(a,
e,t);l(a,e);n(a,e);u(a,e,t);var x=e[w](axa),N=e[w](bxa);if(x&&N){var S=e[w]($wa)||0,T=e[w](Zwa)||0,sa=[S,T,x,N][Fe](),V=e.Kl;if(e=V?C[sa]:A[sa])Ha=e[oe](qH);else{e=ea[GA](uH,Ywa);var Ha=hqa+(V?Q++:E++);e[v](qH,Ha);var Ka=ea[GA](uH,iF);Ka[v](JC,S);Ka[v](zi,T);Ka[v](yi,x);Ka[v](rh,N);e[q](Ka);for(V?C[sa]=e:A[sa]=e;t[Cd]!==CD;)t=t[Ce];t=t[Ub](OI)||t;t[Lb](e,t[Yb])}a[v](tJ,bD+Ha+ef)}else a[FB](tJ)&&a[ad](tJ)},xB:function(a,b,c,d,e){e=e||{};return(b=e[b]||x[b])?(b(a,c,d),!0):!1},Eia:function(){for(var a in sa)if(sa[Hc](a)){var b=
sa[a],c=b[Ce];null!=c&&c[le](b);delete sa[a]}Ka=0;sa={};for(var d in N)sa[Hc](d)&&(a=N[d],b=a[Ce],null!=b&&b[le](a),delete N[d]);T=0;N={};for(var e in A)A[Hc](e)&&(d=A[e],a=d[Ce],null!=a&&a[le](d),delete A[e]);E=0;A={}}}});b(zpa,[GM],function(a){function b(a,c){var d=c[w](JC);a[v](XI,d)}function c(a,b){var d=b[w](zi);a[v](WI,d)}function d(a,b){var c=b[w](Wh);a[v](Wh,c)}var l={},n={r:d,x:b,y:c};br(l,function(l,n,u){u=u||ea[GA](uH,NJ);b(u,l);c(u,l);d(u,l);a.hx(u,l,n);n&&u[Ce]!==n&&n[q](u);return u});
l.Mg=function(b,c,d,f){if(!a.xB(f,c,b,d,n))switch(c){case BE:case CE:case zE:case AE:case yE:case hE:case iE:case gE:a.W6(f,b,d);break;default:throw'unknown property on circle "'+c+'".';}};return l});b(ypa,[GM],function(a){return{draw:function(b,c,d){d=d||ea[GA](uH,CI);var l=b[w](JC);d[v](XI,l);l=b[w](zi);d[v](WI,l);l=b[w](SE);d[v](SE,l);l=b[w](RE);d[v](RE,l);a.hx(d,b,c);c&&d[Ce]!==c&&c[q](d);return d},Mg:function(b,c,d,l){a.xB(l,c,b,d)}}});b(wpa,[GM],function(a){function b(a,c){var d=c[w](IC);a[v](IC,
d)}function c(a,b){var d=b[w](GC);a[v](GC,d)}function d(a,b){var c=b[w](HC);a[v](HC,c)}function l(a,b){var c=b[w](FC);a[v](FC,c)}var n={},p={x1:b,x2:d,y1:c,y2:l};br(n,function(n,p,x){x=x||ea[GA](uH,OG);b(x,n);d(x,n);c(x,n);l(x,n);a.hx(x,n,p);p&&x[Ce]!==p&&p[q](x);return x});n.Mg=function(b,c,d,f){a.xB(f,c,b,d,p)};return n});b(upa,[xG,GM],function(a,b){function c(b){b=b.yu;for(var d=[],f=0,g=b[J];f<g;f++){var t=b[f];if(t[0]===IL){var u=t,x=+u[1],A=+u[2],t=+u[3],C=+u[4],E=a.$N(+u[5],360),Q=a.$N(+u[6],
360),u=!!+u[7];270===E&&0===Q?t=ZL+t+Ke+C+CN+(t+x)+Ke+A:180===E&&270===Q?t=ZL+t+Ke+C+CN+x+Ke+(A-C):0===E&&90===Q?t=ZL+t+Ke+C+CN+x+Ke+(A+C):90===E&&180===Q?t=ZL+t+Ke+C+CN+(x-t)+Ke+A:(x+=h.cos(Q/180*h.PI)*t,A+=h.sin(Q/180*h.PI)*C,E=u?Q-E:E-Q,0>E&&(E+=360),t=ZL+t+Ke+C+TFa+ha(180<E)+Ke+ha(u)+Ke+x+Ke+A)}else t=t[Fe](Ke);d[B](t)}return d[Fe](Ke)}return{X6:function(a,d,e){var p=e||ea[GA](uH,DF);e||p[v](Vg,c(d));b.hx(p,d,a);return p},Fia:c}});b(vpa,[QDa,GM],function(a,b){return{draw:function(b,c,d){b=a.X6(c,
b,d);c&&b[Ce]!==c&&c[q](b);return b},Mg:function(a,c,d,e){b.xB(e,c,a,d)}}});b(Koa,[JM],function(a){return{Y6:function(a){var b=a[w](dJ)||0,c=a[w](cJ)||0,d=a[w](bJ)||0,e=a[w](aJ)||0,p=a[w](jJ)||0,t=a[w](iJ)||0,u=a[w](hJ)||0;a=a[w](gJ)||0;return b||c||d||e||p||t||u||a},hX:function(b){var c=b[w](fJ)||0,d=b[w](eJ)||0,l=b[w](dJ)||c,n=b[w](cJ)||d,p=b[w](bJ)||c,t=b[w](aJ)||d,u=b[w](jJ)||c,x=b[w](iJ)||d,c=b[w](hJ)||c,d=b[w](gJ)||d,A=b[w](yi),C=b[w](rh),E=b[w](JC),Q=b[w](zi),E=0<=A?E:E+A,Q=0<=C?Q:Q+C,A=h.abs(A),
C=h.abs(C);if(l+p>A)var N=A/(l+p),l=l*N,n=n*N,p=p*N,t=t*N;u+c>A&&(N=A/(u+c),u*=N,x*=N,c*=N,d*=N);n+x>C&&(N=C/(n+x),l*=N,n*=N,u*=N,x*=N);t+d>C&&(N=C/(t+d),p*=N,t*=N,c*=N,d*=N);return(new a(b[w]()))[yB](E+A-p,Q).arc(E+A-p,Q+t,p,t,270,0,!0)[nC](E+A,Q+C-d).arc(E+A-c,Q+C-d,c,d,0,90,!0)[nC](E+u,Q+C).arc(E+u,Q+C-x,u,x,90,180,!0)[nC](E,Q+n).arc(E+l,Q+n,l,n,180,270,!0)[Hr]()}}});b(tpa,[SDa,QDa,GM],function(a,b,c){return{draw:function(d,l,n){var p=d[w](fJ),t=d[w](eJ),u=d[w](yi),x=d[w](rh),A=d[w](JC),C=d[w](zi),
A=0<=u?A:A+u,C=0<=x?C:C+x,u=h.abs(u),x=h.abs(x);typeof p===Nh&&typeof t===Nh||!a.Y6(d)?(n=n||ea[GA](uH,iF),n[v](JC,A),n[v](zi,C),n[v](yi,u),n[v](rh,x),null!=p&&typeof p===Nh&&n[v](SE,p),null!=t&&typeof t===Nh&&n[v](RE,t),c.hx(n,d,l)):(d=a.hX(d),n=b.X6(l,d,n));l&&n[Ce]!==l&&l[q](n);return n},Mg:function(d,l,n,p){if(!c.xB(p,l,d,n))switch(l){case fJ:case eJ:case dJ:case cJ:case bJ:case aJ:case jJ:case iJ:case hJ:case gJ:p[$c][He]()===DF?(d=a.hX(d),d=b.Fia(d),p[v](Vg,d)):l===fJ?p[v](SE,d[w](fJ)):l===
eJ&&p[v](RE,d[w](eJ));break;case BE:case CE:case zE:case AE:case yE:case hE:case iE:case gE:c.W6(p,d,n);break;default:throw'unknown property on rect "'+l+'".';}}}});b(ppa,[GM,RDa],function(a){function b(a,c){var d=c[w](Jua)||c[w](bI)||c[w](aI);Ry(a[w],typeof d===ii?d:M)}function c(a,b){var d=b[w](Iua)||b[w]($H);Fa(a[w],typeof d===Nh?d+P:typeof d===ii?d:M)}function d(a,b){var c=b[w](Hua)||b[w](Gua);hz(a[w],typeof c===ii||typeof c===Nh?c:M)}function l(a,b){!0===b[w](hH)?qz(a[w],hH):qz(a[w],M)}function n(a,
b){!0===b[w](dD)?a[w].textDecoration=dD:a[w].textDecoration=M}function p(p,t,u){var E=p[w](hsa)||p[w](lsa)||0,Q=p[w](hu);typeof Q===ii&&(Q=Q[zc](Je));var N=p[w](zi),S=!0;1===Q[J]&&(Q=Q[0],S=!1);var T=S?M:Q,V=p[w](JC);u=u&&u[$c]===hu?u:ea[GA](uH,hu);u.textContent=T;u[v](iqa,pi);u[v](JC,null==V?p[w](JC):V);u[v](zi,null==N?p[w](zi):N);u[v](ji,jwa);u[w].webkitFontSmoothing=Hya;a.hx(u,p,t);l(u,p);n(u,p);b(u,p);c(u,p);d(u,p);N=u;t&&N[Ce]!==t&&t[q](N);t=[];if(S)for(T=0,u=Q[J];T<u;T++){V=ea[GA](uH,Yma);V.textContent=
Q[T];V[v](JC,p[w](JC));V[v](zi,p[w](zi));var sa=N.getBBox()[z];0<T&&(sa+=E);V[v](EI,sa+P);N[q](V);t[B](V)}E=S?t:[N];Q=h.max(0,h.min(1,p[w](HH)||0));if(fa(Q)||!la(Q))Q=0;t=p[w](TC);if(typeof t===Nh){if(t=h.max(0,h.min(1,t)),fa(t)||!la(t))t=0}else t=IK;T=N.getBBox();u=p[w](zi)-T.y;V=E[E[J]-1][$c][He]()===Yma?E[E[J]-1][vb]().top-N[vb]().top:E[E[J]-1].getBBox().y-T.y;S=p[w](zi);if(typeof t===Nh)S=S+u-T[z]*t;else if(t===IK)S=S+u-V;else throw"Unrecognized valign value: "+t;N[v](zi,S);t=0;for(T=E[J];t<T;t++)u=
E[t],u[v](FI,-u.getComputedTextLength()*Q+P),u[v](zi,S);E=p[w](XE);null!=E&&0!=E&&N[v](fD,WE+E+Ke+p[w](JC)+Ke+p[w](zi)+ef);return N}var t={},u={"font.family":b,fontFamily:b,fontName:b,"font.size":c,fontSize:c,"font.weight":d,fontWeight:d,italic:l,underline:n};br(t,p);t.Mg=function(b,c,d,f){if(!a.xB(f,c,b,d,u))if(c===hu||c===HH||c===TC){for(;f&&f[Yb];)f[le](f[Yb]);b=p(b,d,f);if(f!==b)throw"error redrawing text";}else throw'error redrawing text element with changed property "'+c+'".';};return t});b(xpa,
[OM,NM,LM,JM,IM,FM,GM],function(a,b,c,d,l,n,p){function t(a,b,c){c=c||ea[GA](uH,lh);p.hx(c,a,b);b&&c[Ce]!==b&&b[q](c);return c}a={};br(a,t);a.Mg=function(a,b,c){b=t(a,b,c);c!==b&&a[NB]()[ZA](bL,[a,b,!1]);a=a.Cf[qd]();a[gr]();return a};return a});b(spa,[eE,MM,OM,NM,LM,JM,IM,FM],function(a,b,c,d,l,n,p,t){var u={};u[a.IM.Md]=b;u[a[hC].Md]=c;u[a.gx.Md]=d;u[a.Wp.Md]=l;u[a.Pw.Md]=n;u[a[xB].Md]=p;u[a[lB].Md]=t;return u});b(rpa,[dF,uJ,eE,HM,GM],function(a,b,c,d,l){function n(b,c,d){a[L](this,b,c,d);var f=
this.svg=ea[GA](uH,CD);f[v](yi,c);f[v](rh,d);T[L]({svg:b});f[q](ea[GA](uH,OI));b[q](f);this.Yp=E[fc](this);this.jx=Q[fc](this);this.Nr=C[fc](this);this.Or=x[fc](this);this.DB=t[fc](this);this.Jl=A[fc](this);this.bH=N[fc](this);f[ps](vt,this.Jl);f[ps](dG,this.Jl);f[ps](Vt,this.Jl);f[ps](Ut,this.Jl);this.kh=[];this.elements=[]}function p(a,b,c){var d=this.kh[zd](a);if(0<=d){if(null!=this[mA][d]||!a.Kl)throw HAa;a.Kl=!1;this[mA][d]=b}else this.kh[B](a),this[mA][B](b);a[Bc].Md===rL&&a.k(pK,this.jx);a.k(gF,
this.Nr);a.k(bL,this.DB);a.k(vF,this.bH);a.k(eF,this.Or);c&&a.k(RH,this.Yp);return a}function t(a,b){var c=b?this.svg:S[L](this,a[NB]()),c=d[a[Bc].Md][As](a,c);p[L](this,a,c,!!b);u[L](this,a,c);return a}function u(a,b){if(a.$G)for(var c=a.Cf,e=0,f=c[J];e<f;e++){var g=c[e],l=d[g[Bc].Md][As](g,b);p[L](this,g,l,!1);u[L](this,g,l)}}function x(a){var b=this.kh[zd](a);if(0>b)return!1;if(a.$G){for(var b=a.Cf,c=0,d=b[J];c<d;c++)a[ZA](eF,[b[c]]);b=this.kh[zd](a)}a.Kl||this[mA][b][Ce][le](this[mA][b]);this.kh[Ee](b,
1);this[mA][Ee](b,1);a.hb(pK,this.jx);a.hb(gF,this.Nr);a.hb(eF,this.Or);a.hb(RH,this.Yp);a.hb(bL,this.DB);a.hb(vF,this.bH);a.Cj=null;return!0}function A(a){for(var b=a[ys];null!=b[oe](iqa);)b=b[Ce];var c=this[mA][zd](a[ys]);if(0<=c){var b=a[Ur],d=a[Vr];a=a[H];a===Vt?a=fG:a===Ut&&(a=eG);c=this.kh[c];c[ZA](a,[{point:{x:b,y:d},type:a,target:c}])}}function C(a,b){var c=a[NB]()||this,e=S[L](this,a),c=S[L](this,c);d[a[Bc].Md].Mg(a,b,c,e)}function E(a){a.Cj=this}function Q(a){if(a[Bc].Md!==WAa){if(a.Kl){var b;
if(!this.a7){b=this.a7=ea[Vb](ch);Ba(b[w],Fg);b[w].top=uEa;$a(b[w],uEa);oy(b[w],VF);var c=ea[GA](uH,CD);b[q](c);ea[ke][q](b)}b=this.a7;Qa(b[w],rt);c=d[a[Bc].Md][As](a,b[Yb])}else c=S[L](this,a);var e=c.getBBox();a.Rm={width:e[r],height:e[z],x:e.x,y:e.y};a.Kl&&(Qa(b[w],O),c[Ce][le](c))}}function N(a){function b(k){c||(c=k);a.ZG[Zb](function(b,l){if(!f[l])if(e[l]||(e[l]=b.Gia(b.UN,b.WN,b.Ak,c),d[l]=c+b.Ak),k>=d[l])a[w](b.b7,b.WN),g--,f[l]=!0,b[ZA](gI,[a,b]);else a[w](b.b7,e[l](k))});g?this.nX=n.c7[L](V,
b):(this.nX=void 0,a.fX=!1,a[ZA](gI,[a]))}var c,d=[],e=[],f=[];a.fX=!0;var g=a.ZG[J];this.nX=n.c7[L](V,b)}function S(a){if(a===this)return this.svg;a=this.kh[zd](a);return 0>a?null:this[mA][a]}function T(){for(var a=this.svg,b;a[Yb];)a[Yb][$c]===OI&&(b=!0),a[le](a[Yb]);b&&a[q](ea[GA](uH,OI));this.kh=[];this.elements=[];l.Eia();n.Dia[L](V,this.nX)}var V=function(){return this}();n.c7=V.requestAnimationFrame||V.mozRequestAnimationFrame||V.webkitRequestAnimationFrame||V.msRequestAnimationFrame||function(a){V[Dr]((function(){return a[L](this,
Date.now())},1E3/60))};n.Dia=V.cancelRequestAnimationFrame||V.cancelAnimationFrame||V.mozCancelRequestAnimationFrame||V.mozCancelAnimationFrame||V.webkitCancelRequestAnimationFrame||V.webkitCancelAnimationFrame||V.msCancelRequestAnimationFrame||V.msCancelAnimationFrame||V[fr];ob(n,b.Xp(a[K]));Ea(n[K],n);n[K].Hk=function(a){return S[L](this,a)||a[NB]()?(a[ZA](gF,[a]),a):t[L](this,a,!0)};n[K].ce=function(a,b,d,e){a=new c[hC](a,b,d,e);return this.Hk(a)};n[K].zj=function(a,b,d,e,f){a=new c.gx(a,b,d,e,
f);return this.Hk(a)};n[K].eb=function(a,b,d,e,f){a=new c[xB](a,b,d,e,f);return this.Hk(a)};n[K].DF=function(a,b,d,e,f){a=new c.Wp(a,b,d,e,f);return this.Hk(a)};n[K].Jd=function(a,b,d,e){d=new c[lB](a,b,d,e);return this.Hk(d)};n[K].YG=function(a){if(null==a[NB]())throw $Ba;return a[ZA](eF,[a])};n[K].d7=function(a){if(a.Kl)throw m(Xxa);if(-1!==this.kh[zd](a))throw m(Yxa);a.Kl=!0;this.kh[B](a);this[mA][B](null);a.k(pK,this.jx);a.k(gF,this.Nr);a.k(eF,this.Or);a.k(RH,this.Yp);a.k(bL,this.DB);a.k(vF,this.bH);
return a};va(n[K],T);n[K].KM=function(){};return n});b(kqa,[],function(){function a(b,c){if(!b||b.x1>=b.Fb||b.y1>=b.Kb)throw"Error constructing QuadTree: invalid bounds given.";this.ZN=c||0;this.bounds=b;this.nodes=ga(4);this.CB=!1;ny(this,[])}function b(a,c){if(this.CB){var d=this.iX(c);b[L](this[MA][d],a,c)}a[B][Zc](a,this[uA]);return a}ob(a,{insert:function(a){var b=a.Al();if(this.CB){var c=this.iX(b),c=this[MA][c],d=c[ur];b.x1>=d.x1&&b.Fb<=d.Fb&&b.y1>=d.y1&&b.Kb<=d.Kb?c.insert(a):this[uA][B](a)}else if(this[uA][B](a),
4>this.ZN&&4<this[uA][J]){this[zc]();a=0;for(b=this[uA][J];a<b;a++)this.insert(this[uA][a]);ny(this,this[uA][J]>b?this[uA][Ee](b,this[uA][J]-b):[])}},clear:function(){ny(this,[]);if(this.CB){for(var a=0,b=this[MA][J];a<b;a++)this[MA][a][bc]();delete this[MA];this.nodes=ga(4);this.CB=!1}},query:function(a){return b[L](this,[],a)},iX:function(a){var b=!(a.y1>(this[ur].y1+this[ur].Kb)/2),c=0;a.x1>(this[ur].x1+this[ur].Fb)/2?c=b?1:2:b||(c=3);return c},split:function(){var b=(this[ur].Fb-this[ur].x1)/
2,c=(this[ur].Kb-this[ur].y1)/2,d=this[ur].x1,f=this[ur].y1,p=this.ZN+1;this[MA][0]=new a({x1:d,y1:f,Fb:d+b,Kb:f+c},p);this[MA][1]=new a({x1:d+b,y1:f,Fb:d+b+b,Kb:f+c},p);this[MA][2]=new a({x1:d+b,y1:f+c,Fb:d+b+b,Kb:f+c+c},p);this[MA][3]=new a({x1:d,y1:f+c,Fb:d+b,Kb:f+c+c},p);this.CB=!0},remove:function(a){var b=this[uA][zd](a);return 0<=b?(this[uA][Ee](b,1),!0):this.CB?!this[MA][ze](function(b){return!b[Tb](a)}):!1}});return a});b(Qpa,[],function(){return{draw:function(a,b){b[IB]();b.arc(a.x,a.y,
a.uu,0,2*h.PI,!1);b[kB]();b[nc]()},zB:function(a,b){var c=a.x-b.x,d=a.y-b.y;return h[Kd](c*c+d*d)<=a.uu}}});b(Ppa,[],function(){return{draw:function(a,b){b[KA]();b[IB]();b[OB](a.x-a.Hi,a.y-a.Ii);b[bB](a.Hi,a.Ii);b.arc(1,1,1,0,2*h.PI,!1);ry(b,YM);b[nc]();b[cB]()},zB:function(a,b){var c=(b.x-a.x)/a.Hi,d=(b.y-a.y)/a.Ii;return 1>=c*c+d*d}}});b(Opa,[],function(){return{draw:function(a,b){b[KA]();b[IB]();b[oA](a.x1,a.y1);b[pB](a.Fb,a.Kb);b[kB]();Uy(b,pqa);b[ec]();b[cB]()},zB:function(a,b){var c=(a.y1-a.Kb)/
(a.x1-a.Fb);return.5>h.abs(c*b.x+(a.y1-c*a.x1)-b.y)}}});b(Npa,[],function(){function a(b,c){c[IB]();for(var d=b.yu,e=0,n=d[J];e<n;e++){var p=d[e][zc](Ke);switch(p[0]){case Xf:c[oA](p[1],p[2]);break;case Wf:c[pB](p[1],p[2]);break;case TL:c.bezierCurveTo(p[1],p[2],p[3],p[4],p[5],p[6]);break;case zg:c[kB]();return;default:throw'unknown path command "'+d[e]+'".';}}}return{draw:function(b,c){c[KA]();a(b,c);ry(c,uN);c[nc]();c[cB]()},zB:function(b,c){var d=ea[Vb](hK)[NB](vM);a(b,d);return d.isPointInPath(c.x,
c.y)||d.gya(c.x,c.y)}}});b(Mpa,[],function(){return{draw:function(a,b){b[KA]();b[IB]();b[eC](a.x,a.y,a[r],a[z]);ry(b,tN);b[nc]();b[cB]()},zB:function(a,b){return b.x>a.x&&b.x<a.x+a[r]&&b.y>a.y&&b.y<a.y+a[z]}}});b(Kpa,[],function(){return{draw:function(a,b){b.font=dDa;b[hA](a.Fe,a.x,a.y)},zB:function(a,b){var c=a.Al();return b.x>c.x&&b.x<c.x+c[r]&&b.y>c.y&&b.y<c.y+c[z]}}});b(Lpa,[OM,NM,LM,JM,IM,FM],function(a,b,c,d,l,n){return{Circle:a,gx:b,Wp:c,Pw:d,Rect:l,Text:n}});b(Rpa,[kqa,dF,uJ,eE,HM],function(a,
b,c,d,l){function n(c,d,g){b[L](this,c,d,g);var k=this.canvas=ea[Vb](hK);k[v](yi,d);k[v](rh,g);k[v](ji,TDa);c[q](k);this.ix=k[NB](vM);this.lX=new a({x1:0,y1:0,Fb:d,Kb:g});this.all=[];c[ps](vt,t[fc](this))}function p(a){this.all[B](a);a.k(pK,u[fc](this));this.lX.insert(a);return a}function t(a){var b={x:a[Ur],y:a[Vr]};a=[];for(var c=this.lX.query({x1:b.x,y1:b.y,Fb:b.x,Kb:b.y}),d=0,e=c[J];d<e;d++){var f=c[d];l[f[Bc][Nd]].zB(f,b)&&a[B](f)}if(a[J]){b=-1;c=a[0];d=0;for(e=a[J];d<e;d++)f=this.all[zd](a[d]),
f>b&&(b=f,c=a[d]);c[ZA](vt)}}function u(a){a[Bc][Nd]===rL&&(a.Rm={width:this.ix.measureText(a.Fe)[r],height:12,x:a.x,y:a.y})}ob(n,c.Xp(b[K]));Ea(n[K],n);n[K].Hk=function(a){l[a[Bc][Nd]][As](a,this.ix);return p[L](this,a)};n[K].ce=function(a,b,c){a=new d[hC](a,b,c);l[hC][As](a,this.ix);return p[L](this,a)};n[K].zj=function(a,b,c,e){a=new d.gx(a,b,c,e);l.gx[As](a,this.ix);return p[L](this,a)};n[K].eb=function(a,b,c,e){a=new d[xB](a,b,c,e);l[xB][As](a,this.ix);return p[L](this,a)};n[K].DF=function(a,
b,c,e){a=new d.Wp(a,b,c,e);l.Wp[As](a,this.ix);return p[L](this,a)};n[K].YG=function(a){var b=this.all[zd](a);if(0>b)return!1;this.lX[Tb](a);this.all[Ee](b,1);na(this.canvas,this.canvas[r]);a=0;for(b=this.all[J];a<b;a++){var c=this.all[a];c&&l[c[Bc][Nd]][As](c,this.ix)}return!0};return n});b(Hpa,[],function(){return{draw:function(a,b){return b(zwa)}}});b(Epa,[],function(){return{aH:function(a){a={fill:M+(a[w](lI)||a[w](jI)||a[w](nI)||Pe),fillOpacity:ka(a[w](kI)||a[w](iI)||a[w](mI)||1),stroke:M+(a[w](KD)||
a[w](HD)||a[w](ND)||dN),strokeWidth:ka(a[w](ID)||a[w](GD)||a[w](LD)||0),strokeOpacity:ka(a[w](JD)||a[w](Una)||a[w](MD)||1),strokeDashStyle:fi,rx:0,ry:0,gradient:null,pattern:null};a[nc]===AK?za(a,Pe):a[nc]===xi&&za(a,dN);a[ec]===AK?xa(a,Pe):a[ec]===xi&&xa(a,dN);return JSON[nd](a)},Z6:function(a){a={fontName:a[w](Jua)||a[w](bI)||a[w](aI),fontSize:a[w](Iua)||a[w]($H)||10,color:a[w](nI)||a[w](jI)||a[w](lI)||Pe,auraColor:a[w](ND)||a[w](HD)||a[w](KD),bold:!(!a[w](Hua)&&!a[w](Gua)),italic:!!a[w](hH),underline:!!a[w](dD)};
return JSON[nd](a)}}});b(Jpa,[KM],function(a){return{draw:function(b,c){return c(Bwa,b[w](JC),b[w](zi),b[w](Wh),a.aH(b))}}});b(Ipa,[KM],function(a){return{draw:function(b,c){return c(Awa,b[w](JC),b[w](zi),b[w](SE),b[w](RE),a.aH(b))}}});b(Gpa,[KM],function(a){return{draw:function(b,c){var d=[];c(sza,d,b[w](IC),b[w](GC));c(tza,d,b[w](HC),b[w](FC));c(vza,d);return c(ywa,d,a.aH(b))}}});b(Dpa,[KM],function(a){return{draw:function(b,c){for(var d=[],l=b.yu,n=0,p=l[J];n<p;n++){var t=l[n][zc](Ke);switch(t[0]){case Wf:c(tza,
d,ka(t[1]),ka(t[2]));break;case TL:c(uza,d,ka(t[1]),ka(t[2]),ka(t[3]),ka(t[4]),ka(t[5]),ka(t[6]));break;case IL:var u=ka(t[5]),x=ka(t[6]),u=u+90,x=x+90;u>x&&360===u&&(u=0);360===x&&x--;c(wza,d,ka(t[1]),ka(t[2]),ka(t[3]),ka(t[4]),u,x,!!ka(t[7]));break;case Xf:c(sza,d,ka(t[1]),ka(t[2]));break;case zg:c(vza,d);break;default:throw'unknown path command: "'+t[0]+'".';}}return c(ywa,d,a.aH(b))}}});b(Cpa,[KM,SDa,JM],function(a,b,c){return{draw:function(d,l){var n=ka(d[w](JC)),p=ka(d[w](zi)),t=ka(d[w](yi)),
u=ka(d[w](rh));0>t&&(t*=-1,n-=t);0>u&&(u*=-1,p-=u);b.Y6(d)||d[w](fJ)||d[w](eJ)?(n=b.hX(d),n=c[As](n,l)):n=l(xwa,n,p,t,u,a.aH(d));return n}}});b(Apa,[KM],function(a){return{draw:function(b,c){var d=h.max(0,h.min(1,b[w](HH)||0));if(fa(d)||!la(d))d=0;var d=1===d?zI:0===d?TD:dK,l=b[w](TC);if(typeof l===Nh){if(l=h.max(0,h.min(1,l)),fa(l)||!la(l))l=0}else l=IK;l=l===IK||0===l?TD:1===l?zI:dK;return c(wwa,b[w](hu),b[w](JC),b[w](zi),0,d,l,a.Z6(b))}}});b(Bpa,[eE,MM,OM,NM,LM,JM,IM,FM],function(a,b,c,d,l,n,p,
t){var u={};u[a.IM.Md]=b;u[a[hC].Md]=c;u[a.gx.Md]=d;u[a.Wp.Md]=l;u[a.Pw.Md]=n;u[a[xB].Md]=p;u[a[lB].Md]=t;return u});b(Fpa,[dF,uJ,eE,HM,KM],function(a,b,c,d,l){function n(a,b,c){this.oX=Q.constructor_Native();this.aO=[];this.kh=[];this.EB=[];this.mX=p[fc](this);this.mX(Cwa,b,c);this.Yp=A[fc](this);this.jx=E[fc](this);this.Or=C[fc](this);this.DB=u[fc](this)}function p(){var a=this.oX+lL+this.aO[J],b=ga[K][qd][L](arguments,0);this.aO[B]([a][Hb](b));return a}function t(a,b,c){var d=this.kh[zd](a);if(0<=
d){if(null!=this.EB[d]||!a.Kl)throw HAa;a.Kl=!1;this.EB[d]=b}else this.kh[B](a),this.EB[B](b);a[Bc].Md===rL&&a.k(pK,this.jx);a.k(gF,this.Nr);a.k(bL,this.DB);a.k(vF,this.bH);a.k(eF,this.Or);c&&a.k(RH,this.Yp);return a}function u(a,b){var c=d[a[Bc].Md][As](a,this.mX);t[L](this,a,c,!!b);x[L](this,a);return a}function x(a){if(a.$G){a=a.Cf;for(var b=0,c=a[J];b<c;b++){var e=a[b],f=d[e[Bc].Md][As](e,this.mX);t[L](this,e,f,!1);x[L](this,e)}}}function A(a){a.Cj=this}function C(a){var b=this.kh[zd](a);if(0>
b)return!1;if(a.$G){for(var b=a.Cf,c=0,d=b[J];c<d;c++)a[ZA](eF,[b[c]]);b=this.kh[zd](a)}this.kh[Ee](b,1);this.EB[Ee](b,1);a.hb(pK,this.jx);a.hb(gF,this.Nr);a.hb(eF,this.Or);a.hb(RH,this.Yp);a.hb(bL,this.DB);a.hb(vF,this.bH);a.Cj=null;return!0}function E(a){if(a[Bc].Md===rL){var b=JSON[Pd](Q.getTextSizeInternal_Native(this.oX,a[w](hu),l.Z6(a)));a.Rm={width:b[r],height:b[z],x:a[w](JC),y:a[w](zi)}}}var Q=function(){return this}();ob(n,b.Xp(a[K]));Ea(n[K],n);n[K].Hk=function(a){var b=this.kh[zd](a);if(0>
b?0:this.EB[b])throw"Shape already drawn.";return u[L](this,a,!0)};n[K].d7=function(a){if(a.Kl)throw m(Xxa);if(-1!==this.kh[zd](a))throw m(Yxa);a.Kl=!0;this.kh[B](a);this.EB[B](null);a.k(pK,this.jx);a.k(RH,this.Yp);return a};n[K].YG=function(a){if(null==a[NB]())throw $Ba;return a[ZA](eF,[a])};n[K].ce=function(a,b,d,e){a=new c[hC](a,b,d,e);return this.Hk(a)};n[K].zj=function(a,b,d,e,f){a=new c.gx(a,b,d,e,f);return this.Hk(a)};n[K].eb=function(a,b,d,e,f){a=new c[xB](a,b,d,e,f);return this.Hk(a)};n[K].DF=
function(a,b,d,e,f){a=new c.Wp(a,b,d,e,f);return this.Hk(a)};n[K].Jd=function(a,b,d,e){d=new c[lB](a,b,d,e);return this.Hk(d)};n[K].KM=function(){Q.flushRenderer_Native(this.oX,JSON[nd](this.aO));this.aO=[]};va(n[K],function(){});return n});b(ZK,[uJ],function(a){function b(a,d,e,f,t){this.b7=a;this.UN=d;this.WN=e;this.Ak=f;this.Gia=t||c;this.AB={finishAnimation:[]}}function c(a,b,d,e){var f=(b-a)/d,g=f*-e+a;return function(a){return f*a+g}}a.kX(b);return b});b(jqa,[rpa,Rpa,Fpa,eE,ZK],function(a,b,
d,k,l){function n(c,l,n,C){var E;n===CD?E=a:n===hK?E=b:n===xra&&(E=d);t.J=E;t.yc=k;t.H6=p;return new E(C,c,l)}function p(a){return function(b,c){var d=new k[lB](0,0,b,c);a.d7(d);var e=d.Al();a.YG(d);delete e.x;delete e.y;return e}}var t=c=function(a,b,c,d,e){var f=function(){return this}(),g,k=!1,l=!1;e&&e.fonts&&f.WebFont?WebFont[td]({google:{families:e.fonts},active:function(){l=!0;g&&g(n(a,b,c,d))},fontinactive:function(){throw m("one or more fonts could not be loaded.");}}):k=!0;return{then:function(e){if(!l&&
!k)g=e;else if(k||l)f[Dr](e[fc](f,n(a,b,c,d)),0)}}};t.yc=k;t.Animation=l});return c}();function QO(a,b,c,d){this.ea=a;this.Rk=new Cl(0,0);this.hL=d||null;this[xC](b,c)}W(QO,JO);R=QO[K];R.Wa=function(){return this.Ax};R.Mw=function(){return{}};R.$n=function(a,b){QO.e.$n[L](this,a,b)};yz(R,function(a){if(!Dl(this.Rk,a)){this.Rk=a[Jc]();var b=this;this.bm=null;this.Xo&&this.Xo[bc]();(new PO(a[r]||0,a[z]||0,CD,this.ea,this.hL?{fonts:this.hL}:void 0))[vs](function(a){b.Ax=a;b.Ax.bf=PO.mc=Ao(PO.H6(b.Ax),function(a,b){var c=[a,b[0]];c[B](Kn(b[1]));return c[Fe](lL)});b.bm={}})}});R.D=function(){};function RO(a,b,c,d,e){this.ug=!!b;a&&this[tC](a,d);ly(this,void 0!=e?e:this.al||0);this.ug&&ly(this,-1*this[qA]);this.jV=!c}W(RO,Yk);R=RO[K];Ly(R,null);R.al=0;R.l4=!1;wz(R,function(a,b,c){Ly(this,a);a&&(this.al=Ui(b)?b:1!=this[hB][rd]?0:this.ug?-1:1);Ui(c)&&ly(this,c)});R.DS=function(a){Ly(this,a[hB]);this.al=a.al;ly(this,a[qA]);this.ug=a.ug;this.jV=a.jV};Ia(R,function(){return new RO(this[hB],this.ug,!this.jV,this.al,this[qA])});
Da(R,function(){var a;if(this.l4){if(!this[hB]||this.jV&&0==this[qA])throw Xk;a=this[hB];var b=this.ug?-1:1;if(this.al==b){var c=this.ug?a[Lc]:a[Yb];c?this[tC](c):this[tC](a,-1*b)}else(c=this.ug?a[oc]:a[ic])?this[tC](c):this[tC](a[Ce],-1*b);ly(this,this[qA]+this.al*(this.ug?-1:1))}else this.l4=!0;a=this[hB];if(!this[hB])throw Xk;return a});ab(R,function(a){return a[hB]==this[hB]&&(!this[hB]||a.al==this.al)});
R.splice=function(a){var b=this[hB],c=this.ug?1:-1;this.al==c&&(this.al=-1*c,ly(this,this[qA]+this.al*(this.ug?-1:1)));this.ug=!this.ug;RO[K][yc][L](this);this.ug=!this.ug;for(var c=Pi(arguments[0])?arguments[0]:arguments,d=c[J]-1;0<=d;d--)$l(c[d],b);am(b)};function SO(){}SO[K].rea=function(){return!1};SO[K].oc=function(){return Hl(ol?this[Sr]():this.pj())};SO[K].lC=function(){return Pl(this.oc())};SO[K].containsNode=function(a,b){return this.TE(zGa(a),b)};function AGa(a,b){RO[L](this,a,b,!0)}W(AGa,RO);function TO(a,b,c,d,e){var f;a&&(this.ae=a,this.$d=b,this.Fd=c,this.Zd=d,1==a[rd]&&a[$c]!=If&&(a=a[cc],(b=a[b])?(this.ae=b,this.$d=0):(a[J]&&(this.ae=qj(a)),f=!0)),1==c[rd]&&((this.Fd=c[cc][d])?this.Zd=0:this.Fd=c));RO[L](this,e?this.Fd:this.ae,e,!0);if(f)try{this[yc]()}catch(g){if(g!=Xk)throw g;}}W(TO,AGa);R=TO[K];R.ae=null;R.Fd=null;R.$d=0;R.Zd=0;R.pj=function(){return this.ae};R.gm=function(){return this.Fd};R.xqa=function(){return this.l4&&this[hB]==this.Fd&&(!this.Zd||1!=this.al)};
Da(R,function(){if(this.xqa())throw Xk;return TO.e[yc][L](this)});R.DS=function(a){this.ae=a.ae;this.Fd=a.Fd;this.$d=a.$d;this.Zd=a.Zd;this.Lo=a.Lo;TO.e.DS[L](this,a)};Ia(R,function(){var a=new TO(this.ae,this.$d,this.Fd,this.Zd,this.Lo);a.DS(this);return a});function UO(){}UO[K].TE=function(a,b){var c=b&&!a[mB](),d=a.Oa;try{return c?0<=this.wn(d,0,1)&&0>=this.wn(d,1,0):0<=this.wn(d,0,0)&&0>=this.wn(d,1,1)}catch(e){if(!ol)throw e;return!1}};UO[K].containsNode=function(a,b){return this.TE(VO(a),b)};UO[K].pt=function(){return new TO(this.pj(),this.un(),this.gm(),this.Qo())};function WO(a){this.Oa=a}W(WO,UO);function XO(a){var b=Hl(a)[Dd]();if(3==a[rd])b[ZB](a,0),b[cA](a,a[J]);else if(YO(a)){for(var c,d=a;(c=d[Yb])&&YO(c);)d=c;b[ZB](d,0);for(d=a;(c=d[Lc])&&YO(c);)d=c;b[cA](d,1==d[rd]?d[cc][J]:d[J])}else c=a[Ce],a=sj(c[cc],a),b[ZB](c,a),b[cA](c,a+1);return b}function ZO(a,b,c,d){var e=Hl(a)[Dd]();e[ZB](a,b);e[cA](c,d);return e}R=WO[K];Ia(R,function(){return new this[Bc](this.Oa.cloneRange())});Oq(R,function(){return this.Oa.commonAncestorContainer});R.pj=function(){return this.Oa.startContainer};
R.un=function(){return this.Oa.startOffset};R.gm=function(){return this.Oa.endContainer};R.Qo=function(){return this.Oa.endOffset};R.wn=function(a,b,c){return this.Oa.compareBoundaryPoints(1==c?1==b?Fi[hd].START_TO_START:Fi[hd].START_TO_END:1==b?Fi[hd].END_TO_START:Fi[hd].END_TO_END,a)};R.isCollapsed=function(){return this.Oa[aA]};R.Zv=function(){return this.Oa[qc]()};iy(R,function(a){var b=Pl(Hl(this.pj()));this.KK(b[ss](),a)});R.KK=function(a){a.removeAllRanges();a.addRange(this.Oa)};cy(R,function(a){this.Oa[yb](a)});function $O(a){this.Oa=a}W($O,WO);$O[K].KK=function(a,b){if(!b||this[mB]())$O.e.KK[L](this,a,b);else a[yb](this.gm(),this.Qo()),a[Lz](this.pj(),this.un())};function aP(a,b){this.Oa=a;this.Zj=b}W(aP,UO);function bP(a){var b=Hl(a)[ke].createTextRange();if(1==a[rd])b[PA](a),YO(a)&&!a[cc][J]&&b[yb](!1);else{for(var c=0,d=a;d=d[oc];){var e=d[rd];if(3==e)c+=d[J];else if(1==e){b[PA](d);break}}d||b[PA](a[Ce]);b[yb](!d);c&&b[yB](bK,c);b[mC](bK,a[J])}return b}R=aP[K];R.rt=null;R.ae=null;R.Fd=null;R.$d=-1;R.Zd=-1;Ia(R,function(){var a=new aP(this.Oa[vA](),this.Zj);a.rt=this.rt;a.ae=this.ae;a.Fd=this.Fd;return a});
Oq(R,function(){if(!this.rt){var a=this.Oa[pd],b=this.Oa[vA](),c=a[Ab](/ +$/,M);(c=a[J]-c[J])&&b[mC](bK,-c);c=b.parentElement();b=b.htmlText[Ab](/(\r\n|\r|\n)+/g,Ke)[J];if(this[mB]()&&0<b)return this.rt=c;for(;b>c.outerHTML[Ab](/(\r\n|\r|\n)+/g,Ke)[J];)c=c[Ce];for(;1==c[cc][J]&&c[Wd]==BGa(c[Yb])&&YO(c[Yb]);)c=c[Yb];0==a[J]&&(c=CGa(this,c));this.rt=c}return this.rt});
function CGa(a,b){for(var c=b[cc],d=0,e=c[J];d<e;d++){var f=c[d];if(YO(f)){var g=bP(f),k=g.htmlText!=f.outerHTML;if(a[mB]()&&k?0<=a.wn(g,1,1)&&0>=a.wn(g,1,0):a.Oa[Kz](g))return CGa(a,f)}}return b}R.pj=function(){this.ae||(this.ae=cP(this,1),this[mB]()&&(this.Fd=this.ae));return this.ae};R.un=function(){0>this.$d&&(this.$d=this.WE(1),this[mB]()&&(this.Zd=this.$d));return this.$d};R.gm=function(){if(this[mB]())return this.pj();this.Fd||(this.Fd=cP(this,0));return this.Fd};
R.Qo=function(){if(this[mB]())return this.un();0>this.Zd&&(this.Zd=this.WE(0),this[mB]()&&(this.$d=this.Zd));return this.Zd};R.wn=function(a,b,c){return this.Oa[rC]((1==b?tL:JL)+qL+(1==c?tL:JL),a)};
function cP(a,b,c){c=c||a[Sr]();if(!c||!c[Yb])return c;for(var d=1==b,e=0,f=c[cc][J];e<f;e++){var g=d?e:f-e-1,k=c[cc][g],l;try{l=VO(k)}catch(n){continue}var p=l.Oa;if(a[mB]())if(!YO(k)){if(0==a.wn(p,1,1)){a.$d=a.Zd=g;break}}else{if(l.TE(a))return cP(a,b,k)}else{if(a.TE(l)){if(!YO(k)){d?a.$d=g:a.Zd=g+1;break}return cP(a,b,k)}if(0>a.wn(p,1,0)&&0<a.wn(p,0,1))return cP(a,b,k)}}return c}
R.WE=function(a,b){var c=1==a,d=b||(c?this.pj():this.gm());if(1==d[rd]){for(var d=d[cc],e=d[J],f=c?1:-1,g=c?0:e-1;0<=g&&g<e;g+=f){var k=d[g];if(!YO(k)&&0==this.Oa[rC]((1==a?tL:JL)+qL+(1==a?tL:JL),VO(k).Oa))return c?g:g+1}return-1==g?0:g}e=this.Oa[vA]();f=bP(d);e.setEndPoint(c?FBa:xAa,f);e=e[pd][J];return c?d[J]-e:e};function BGa(a){return 3==a[rd]?a[jd]:a[Wd]}R.isCollapsed=function(){return 0==this.Oa[rC](yAa,this.Oa)};R.Zv=function(){return this.Oa[pd]};iy(R,function(){this.Oa[jA]()});
cy(R,function(a){this.Oa[yb](a);a?(this.Fd=this.ae,this.Zd=this.$d):(this.ae=this.Fd,this.$d=this.Zd)});function dP(a){this.Oa=a}W(dP,WO);dP[K].KK=function(a){a[yb](this.pj(),this.un());this.gm()==this.pj()&&this.Qo()==this.un()||a[Lz](this.gm(),this.Qo());0==a.rangeCount&&a.addRange(this.Oa)};function eP(a){this.Oa=a}W(eP,WO);eP[K].wn=function(a,b,c){return ul(Is)?eP.e.wn[L](this,a,b,c):this.Oa.compareBoundaryPoints(1==c?1==b?Fi[hd].START_TO_START:Fi[hd].END_TO_START:1==b?Fi[hd].START_TO_END:Fi[hd].END_TO_END,a)};eP[K].KK=function(a,b){a.removeAllRanges();b?a.setBaseAndExtent(this.gm(),this.Qo(),this.pj(),this.un()):a.setBaseAndExtent(this.pj(),this.un(),this.gm(),this.Qo())};function VO(a){if(ol&&!vl(9)){var b=new aP(bP(a),Hl(a));if(YO(a)){for(var c,d=a;(c=d[Yb])&&YO(c);)d=c;b.ae=d;b.$d=0;for(d=a;(c=d[Lc])&&YO(c);)d=c;b.Fd=d;b.Zd=1==d[rd]?d[cc][J]:d[J];b.rt=a}else b.ae=b.Fd=b.rt=a[Ce],b.$d=sj(b.rt[cc],a),b.Zd=b.$d+1;a=b}else a=ql?new eP(XO(a)):pl?new $O(XO(a)):nl?new dP(XO(a)):new WO(XO(a));return a}function YO(a){return Wl(a)||3==a[rd]};function fP(){}W(fP,SO);R=fP[K];R.Yv=null;R.ae=null;R.$d=null;R.Fd=null;R.Zd=null;R.Lo=!1;Ia(R,function(){var a=new fP;a.Yv=this.Yv&&this.Yv[Jc]();a.ae=this.ae;a.$d=this.$d;a.Fd=this.Fd;a.Zd=this.Zd;a.Lo=this.Lo;return a});Pq(R,function(){return hu});
function gP(a){var b;if(!(b=a.Yv)){b=a.pj();var c=a.un(),d=a.gm(),e=a.Qo();if(ol&&!vl(9)){var f=b,g=c,k=d,l=e,n=!1;1==f[rd]&&(g=f[cc][g],n=!g,f=g||f[Lc]||f,g=0);var p=bP(f);g&&p[yB](bK,g);if(f==k&&g==l)p[yb](!0);else n&&p[yb](!1),n=!1,1==k[rd]&&(k=(g=k[cc][l])||k[Lc]||k,l=0,n=!g),f=bP(k),f[yb](!n),l&&f[mC](bK,l),p.setEndPoint(FBa,f);l=new aP(p,Hl(b));l.ae=b;l.$d=c;l.Fd=d;l.Zd=e;b=l}else b=ql?new eP(ZO(b,c,d,e)):pl?new $O(ZO(b,c,d,e)):nl?new dP(ZO(b,c,d,e)):new WO(ZO(b,c,d,e));b=a.Yv=b}return b}
Oq(R,function(){return gP(this)[Sr]()});R.pj=function(){return this.ae||(this.ae=gP(this).pj())};R.un=function(){return null!=this.$d?this.$d:this.$d=gP(this).un()};R.gm=function(){return this.Fd||(this.Fd=gP(this).gm())};R.Qo=function(){return null!=this.Zd?this.Zd:this.Zd=gP(this).Qo()};R.rea=function(){return this.Lo};R.TE=function(a,b){var c=a[Tr]();return c==hu?gP(this).TE(gP(a),b):c==kia?(c=a.YL(),(b?yj:zj)(c,function(a){return this.containsNode(a,b)},this)):!1};R.isCollapsed=function(){return gP(this)[mB]()};
R.Zv=function(){return gP(this).Zv()};R.pt=function(){return new TO(this.pj(),this.un(),this.gm(),this.Qo())};iy(R,function(){gP(this)[jA](this.Lo)});cy(R,function(a){a=this.rea()?!a:a;this.Yv&&this.Yv[yb](a);a?(this.Fd=this.ae,this.Zd=this.$d):(this.ae=this.Fd,this.$d=this.Zd);this.Lo=!1});function zGa(a){a=VO(a);var b=new fP;b.Yv=a;b.Lo=!1;return b}function DGa(a,b,c,d){if(a==c)return d<b;var e;if(1==a[rd]&&b)if(e=a[cc][b])a=e,b=0;else if(hm(a,c))return!0;if(1==c[rd]&&d)if(e=c[cc][d])c=e,d=0;else if(hm(c,a))return!1;return 0<(hfa(a,c)||b-d)};function hP(){}Ki(hP);hP[K].Fxa=0;function iP(a){return xf+(a.Fxa++)[qc](36)};function jP(a){hv[L](this);this.U=a||Fl();this.Nq=EGa;this.hc=null;this.Mb=!1;this.n=null;this.$u=void 0;this.ko=this.qd=this.Xd=this.El=null;this.z8=!1}W(jP,hv);jP[K].Uua=hP.ac();var EGa=null;function FGa(a,b){switch(a){case 1:return b?KI:BI;case 2:return b?zH:cD;case 4:return b?xza:cwa;case 8:return b?cu:Vma;case 16:return b?kxa:Wma;case 32:return b?ih:yK;case 64:return b?MF:rJ}throw m("Invalid component state");}R=jP[K];rz(R,function(){return this.hc||(this.hc=iP(this.Uua))});
R.ux=function(a){this.Xd&&this.Xd.ko&&(ik(this.Xd.ko,this.hc),jk(this.Xd.ko,a,this));this.hc=a};R.a=function(){return this.n};R.nu=function(a){return this.n?this.U.nu(a,this.n):null};R.h9=function(a){return this.nu(a)};R.Jc=function(){this.$u||(this.$u=new Bx(this));return this.$u};function kP(a,b){if(a==b)throw m(nAa);if(b&&a.Xd&&a.hc&&a.Xd.YB(a.hc)&&a.Xd!=b)throw m(nAa);a.Xd=b;jP.e.tB[L](a,b)}R.getParent=function(){return this.Xd};
R.tB=function(a){if(this.Xd&&this.Xd!=a)throw m("Method not supported");jP.e.tB[L](this,a)};R.pa=function(){return this.U};R.m=function(){this.n=this.U[Vb](ch)};R.C=function(a){this.iA(a)};R.iA=function(a,b){if(this.Mb)throw m(NL);this.n||this.m();a?a[Lb](this.n,b||null):this.U.oc()[ke][q](this.n);this.Xd&&!this.Xd.Mb||this.Nb()};
R.Va=function(a){if(this.Mb)throw m(NL);if(a&&this.Wh(a)){this.z8=!0;var b=Hl(a);this.U&&this.U.oc()==b||(this.U=Fl(a));this.Hf(a);this.Nb()}else throw m("Invalid element to decorate");};R.Wh=function(){return!0};R.Hf=function(a){this.n=a};R.Nb=function(){this.Mb=!0;lP(this,function(a){!a.Mb&&a.a()&&a.Nb()})};R.Ff=function(){lP(this,function(a){a.Mb&&a.Ff()});this.$u&&this.$u.nc();this.Mb=!1};
R.D=function(){this.Mb&&this.Ff();this.$u&&(this.$u.$(),delete this.$u);lP(this,function(a){a.$()});!this.z8&&this.n&&am(this.n);this.Xd=this.El=this.n=this.ko=this.qd=null;jP.e.D[L](this)};function mP(a){return a.El}R.va=function(a,b){this.ED(a,this.Uf(),b)};
R.ED=function(a,b,c){if(a.Mb&&(c||!this.Mb))throw m(NL);if(0>b||b>this.Uf())throw m("Child component index out of bounds");this.ko&&this.qd||(this.ko={},this.qd=[]);if(a[Fz]()==this){var d=a[kC]();this.ko[d]=a;Ij(this.qd,a)}else jk(this.ko,a[kC](),a);kP(a,this);Gj(this.qd,a,b);a.Mb&&this.Mb&&a[Fz]()==this?(c=this.gb(),b=c[cc][b]||null,b!=a.a()&&c[Lb](a.a(),b)):c?(this.n||this.m(),b=this.Qf(b+1),a.iA(this.gb(),b?b.n:null)):this.Mb&&!a.Mb&&a.n&&a.n[Ce]&&1==a.n[Ce][rd]&&a.Nb()};R.gb=function(){return this.n};
R.$i=function(){null==this.Nq&&(this.Nq=Ym(this.Mb?this.n:this.U.oc()[ke]));return this.Nq};R.Jw=function(a){if(this.Mb)throw m(NL);this.Nq=a};R.Uf=function(){return this.qd?this.qd[J]:0};R.YB=function(a){return this.ko&&a?kk(this.ko,a)||null:null};R.Qf=function(a){return this.qd?this.qd[a]||null:null};function lP(a,b,c){a.qd&&X(a.qd,b,c)}function nP(a,b){return a.qd&&b?sj(a.qd,b):-1}
R.removeChild=function(a,b){if(a){var c=Si(a)?a:a[kC]();a=this.YB(c);c&&a&&(ik(this.ko,c),Ij(this.qd,a),b&&(a.Ff(),a.n&&am(a.n)),kP(a,null))}if(!a)throw m("Child is not in parent component");return a};function GGa(a,b){return a[le](a.Qf(0),b)}R.Oc=function(a){for(var b=[];this.qd&&0!=this.qd[J];)b[B](GGa(this,a));return b};function oP(a){if(a[Hz])return a[Hz];a=a[ae];return Si(a)&&a[Pb](/\S+/g)||[]}function HGa(a,b){pb(a,b)}function pP(a,b){return a[Hz]?a[Hz][Yc](b):Dj(oP(a),b)}function qP(a,b){a[Hz]?a[Hz].add(b):pP(a,b)||pb(a,a[ae]+(0<a[ae][J]?Ke+b:b))}function rP(a,b){if(a[Hz])X(b,function(b){qP(a,b)});else{var c={};X(oP(a),function(a){c[a]=!0});X(b,function(a){c[a]=!0});pb(a,M);for(var d in c)pb(a,a[ae]+(0<a[ae][J]?Ke+d:d))}}
function sP(a,b){if(a[Hz])a[Hz][Tb](b);else pP(a,b)&&pb(a,vj(oP(a),function(a){return a!=b})[Fe](Ke))}function tP(a,b){a[Hz]?X(b,function(b){sP(a,b)}):pb(a,vj(oP(a),function(a){return!Dj(b,a)})[Fe](Ke))}function uP(a,b,c){c?qP(a,b):sP(a,b)};function vP(a,b,c){hv[L](this);ar(this,a);this.handle=b||a;this.E3=c||new xm(ia,ia,ia,ia);this.Ze=Hl(a);this.H=new Bx(this);Ku(this,this.H);$u(this[IA],[hD,Tt],this.xaa,!1,this)}W(vP,hv);var wP=ol||pl&&ul("1.9.3");R=vP[K];Uq(R,0);Vq(R,0);yq(R,0);zq(R,0);R.dv=0;R.rl=0;wy(R,0);vy(R,0);R.sg=!0;R.Fq=!1;R.uba=0;R.oP=0;R.woa=!1;R.Iy=!1;R.Pu=function(a){this.Iy=a};R.Jc=function(){return this.H};function xP(a,b){a.E3=b||new xm(ia,ia,ia,ia)}R.Na=function(a){this.sg=a};
R.D=function(){vP.e.D[L](this);dv(this[IA],[hD,Tt],this.xaa,!1,this);this.H.nc();wP&&this.Ze.releaseCapture();ar(this,null);this.handle=null};R.JI=function(){Gi(this.Nq)||(this.Nq=Ym(this[ys]));return this.Nq};
R.xaa=function(a){var b=a[H]==Tt;if(!this.sg||this.Fq||b&&!Ru(a))this[ir](ova);else{yP(a);if(0==this.uba)if(this[ir](new zP(TD,this,a[Qd],a[Rd],a)))this.Fq=!0,a[hr]();else return;else a[hr]();var b=this.Ze,c=b[lc],d=!wP;this.H.k(b,[fna,dG],this.hN,d);this.H.k(b,[gna,cG],this.iS,d);wP?(c.setCapture(!1),this.H.k(c,bsa,this.iS)):this.H.k(Pl(b),yK,this.iS);ol&&this.woa&&this.H.k(b,wva,Nu);this.yoa&&this.H.k(this.yoa,ME,this.xoa,d);Uq(this,this.dv=a[Qd]);Vq(this,this.rl=a[Rd]);yq(this,a.screenX);zq(this,
a.screenY);wy(this,this.Iy?bGa(this[ys]):this[ys][je]);vy(this,this[ys][ed]);this.h1=tm(Fl(this.Ze));this.oP=Zi()}};R.iS=function(a){this.H.nc();wP&&this.Ze.releaseCapture();if(this.Fq){yP(a);this.Fq=!1;var b=IGa(this,this[DA]),c=JGa(this,this[CA]);this[ir](new zP(zI,this,a[Qd],a[Rd],a,b,c))}else this[ir](ova)};function yP(a){var b=a[H];b==hD||b==fna?a[Sc](a.Aa[Nb][0],a[es]):b!=gna&&b!=hna||a[Sc](a.Aa.changedTouches[0],a[es])}
R.hN=function(a){if(this.sg){yP(a);var b=(this.Iy&&this.JI()?-1:1)*(a[Qd]-this[Qd]),c=a[Rd]-this[Rd];Uq(this,a[Qd]);Vq(this,a[Rd]);yq(this,a.screenX);zq(this,a.screenY);if(!this.Fq){var d=this.dv-this[Qd],e=this.rl-this[Rd];if(d*d+e*e>this.uba)if(this[ir](new zP(TD,this,a[Qd],a[Rd],a)))this.Fq=!0;else{this.yh||this.iS(a);return}}c=KGa(this,b,c);b=c.x;c=c.y;this.Fq&&this[ir](new zP(GK,this,a[Qd],a[Rd],a,b,c))&&(LGa(this,a,b,c),a[hr]())}};
function KGa(a,b,c){var d=tm(Fl(a.Ze));b+=d.x-a.h1.x;c+=d.y-a.h1.y;a.h1=d;wy(a,a[DA]+b);vy(a,a[CA]+c);b=IGa(a,a[DA]);a=JGa(a,a[CA]);return new xl(b,a)}R.xoa=function(a){var b=KGa(this,0,0);Uq(a,this[Qd]);Vq(a,this[Rd]);LGa(this,a,b.x,b.y)};function LGa(a,b,c,d){a.Wx(c,d);a[ir](new zP(GI,a,b[Qd],b[Rd],b,c,d))}function IGa(a,b){var c=a.E3,d=fa(c[G])?null:c[G],c=fa(c[r])?0:c[r];return h.min(null!=d?d+c:da,h.max(null!=d?d:-da,b))}
function JGa(a,b){var c=a.E3,d=fa(c.top)?null:c.top,c=fa(c[z])?0:c[z];return h.min(null!=d?d+c:da,h.max(null!=d?d:-da,b))}R.Wx=function(a,b){this.Iy&&this.JI()?Ua(this[ys][w],a+P):$a(this[ys][w],a+P);this[ys][w].top=b+P};function zP(a,b,c,d,e,f,g){Mu[L](this,a);Uq(this,c);Vq(this,d);this.Cna=e;$a(this,Gi(f)?f:b[DA]);this.top=Gi(g)?g:b[CA];this.l0=b}W(zP,Mu);function AP(a){hv[L](this);this.n=a;a=ol?Ft:yK;this.xna=$u(this.n,ol?Et:ih,this,!ol);this.yna=$u(this.n,a,this,!ol)}W(AP,hv);Dq(AP[K],function(a){var b=new Pu(a.Aa);db(b,a[H]==Et||a[H]==ih?Et:Ft);this[ir](b)});AP[K].D=function(){AP.e.D[L](this);ev(this.xna);ev(this.yna);delete this.n};function BP(a,b){jP[L](this,b);this.Voa=!!a;this.tC=null}W(BP,jP);R=BP[K];R.lY=null;R.ub=!1;R.Il=null;R.dj=null;R.so=null;R.S0=!1;R.fa=function(){return Kza};R.uC=function(){return this.Il};R.m=function(){BP.e.m[L](this);var a=this.a(),b=ej(this.fa())[zc](Ke);rP(a,b);lm(a,!0);Wm(a,!1);MGa(this);NGa(this)};function MGa(a){if(a.Voa&&!a.dj){var b;b=a.pa().m(xh,{frameborder:0,style:hya,src:Ysa});a.dj=b;pb(a.dj,a.fa()+sEa);Wm(a.dj,!1);Afa(a.dj,0)}a.Il||(a.Il=a.pa().m(ch,a.fa()+sEa),Wm(a.Il,!1))}
function NGa(a){a.so||(a.so=a.pa()[Vb](du),Wm(a.so,!1),lm(a.so,!0),Ba(a.so[w],Fg))}R.gba=function(){this.S0=!1};R.Wh=function(a){return!!a&&a[$c]==ML};R.Hf=function(a){BP.e.Hf[L](this,a);a=ej(this.fa())[zc](Ke);rP(this.a(),a);MGa(this);NGa(this);Wm(this.a(),!1)};R.Nb=function(){this.dj&&Zl(this.dj,this.a());Zl(this.Il,this.a());BP.e.Nb[L](this);$l(this.so,this.a());this.lY=new AP(this.pa().oc());this.Jc().k(this.lY,Et,this.$ja);CP(this,!1)};
R.Ff=function(){this.W()&&this[yA](!1);Lu(this.lY);BP.e.Ff[L](this);am(this.dj);am(this.Il);am(this.so)};sy(R,function(a){a!=this.ub&&(this.Ux&&this.Ux[qs](),this.AC&&this.AC[qs](),this.Dx&&this.Dx[qs](),this.gC&&this.gC[qs](),this.Mb&&CP(this,a),a?this.O3():this.XD())});function CP(a,b){if(b){a.bE||(a.bE=[]);for(var c=a.pa(),c=c.Vf(c.oc()[ke]),d=0;d<c[J];d++){var e=c[d];e==a.n||BO(e,sh)||(AO(e,sh,!0),a.bE[B](e))}}else if(a.bE){for(d=0;d<a.bE[J];d++)a.bE[d][ad](SK);a.bE=null}}
R.vP=function(a,b,c,d){this.Ux=a;this.Dx=b;this.AC=c;this.gC=d};R.O3=function(){if(this[ir](EK)){try{this.tC=this.pa().oc()[ub]}catch(a){}this.oZ();this.lf();this.Jc().k(this.pa().lC(),cF,this.oZ);OGa(this,!0);this[iA]();this.ub=!0;this.Ux&&this.AC?(cv(this.Ux,zI,this.OQ,!1,this),this.AC[KB](),this.Ux[KB]()):this.OQ()}};
R.XD=function(){if(this[ir](FK)){this.Jc().hb(this.pa().lC(),cF,this.oZ);this.ub=!1;this.Dx&&this.gC?(cv(this.Dx,zI,this.qP,!1,this),this.gC[KB](),this.Dx[KB]()):this.qP();t:{try{var a=this.pa(),b=a.oc()[ke],c=a.oc()[ub]||b;if(!this.tC||this.tC==b){this.tC=null;break t}(c==b||a[Yc](this.a(),c))&&this.tC[iA]()}catch(d){}this.tC=null}}};function OGa(a,b){a.dj&&Wm(a.dj,b);a.Il&&Wm(a.Il,b);Wm(a.a(),b);Wm(a.so,b)}R.OQ=function(){this[ir](dE)};R.qP=function(){OGa(this,!1);this[ir](BH)};R.W=function(){return this.ub};
R.focus=function(){this.wga()};R.oZ=function(){this.dj&&Wm(this.dj,!1);this.Il&&Wm(this.Il,!1);var a=this.pa().oc(),b=Ol(Pl(a)||ba||ba),c=h.max(b[r],h.max(a[ke][Oc],a[lc][Oc])),a=h.max(b[z],h.max(a[ke][Wb],a[lc][Wb]));this.dj&&(Wm(this.dj,!0),Rm(this.dj,c,a));this.Il&&(Wm(this.Il,!0),Rm(this.Il,c,a))};
R.lf=function(){var a=this.pa().oc(),b=Pl(a)||ba;if(Hm(this.a())==hh)var c=a=0;else c=tm(this.pa()),a=c.x,c=c.y;var d=Tm(this.a()),b=Ol(b||ba),a=h.max(a+b[r]/2-d[r]/2,0),c=h.max(c+b[z]/2-d[z]/2,0);Im(this.a(),a,c);Im(this.so,a,c)};R.$ja=function(a){this.S0?this.gba():a[ys]==this.so&&sv(this.wga,0,this)};R.wga=function(){try{ol&&this.pa().oc()[ke][iA](),this.a()[iA]()}catch(a){}};R.D=function(){Lu(this.Ux);this.Ux=null;Lu(this.Dx);this.Dx=null;Lu(this.AC);this.AC=null;Lu(this.gC);this.gC=null;BP.e.D[L](this)};function DP(a,b,c){BP[L](this,b,c);this.Ij=a||wra;this.ji=(new EP).oj(FP,!0).oj(GP,!1,!0)}W(DP,BP);R=DP[K];R.Zna=!0;R.UF=!0;R.FF=!0;R.V8=!0;R.XN=.5;R.Rf=M;R.ng=null;R.Tj=null;R.oJ=!1;R.Fk=null;R.Wi=null;R.YN=null;R.Qi=null;R.Ik=null;R.Ch=null;R.uM="dialog";R.fa=function(){return this.Ij};R.setTitle=function(a){this.Rf=a;this.Wi&&im(this.Wi,a)};R.getTitle=function(){return this.Rf};ez(R,function(a){this.ng=a=Ck(a,null);this.Ik&&wl(this.Ik,a)});fz(R,function(){return null!=this.ng?Ak(this.ng):M});
R.Tt=function(){return this.uM};R.C5=function(a){this.uM=a};function HP(a){a.a()||a.C()}R.gb=function(){HP(this);return this.Ik};function PGa(a){HP(a);return a.a()}R.uC=function(){HP(this);return DP.e.uC[L](this)};function IP(a,b){a.XN=b;if(a.a()){var c=a.uC();c&&Afa(c,a.XN)}}function JP(a,b){a.FF=b;if(a.Mb){var c=a.pa(),d=a.uC(),e=a.dj;b?(e&&c.R_(e,a.a()),c.R_(d,a.a())):(c[Rr](e),c[Rr](d))}a.W()&&CP(a,b)}R.getDraggable=function(){return this.V8};
function QGa(a,b){var c=ej(a.Ij+$Da)[zc](Ke);a.a()&&(b?rP(a.Fk,c):tP(a.Fk,c));if(b&&!a.Tj){var d;d=new vP(a.a(),a.Fk);a.Tj=d;rP(a.Fk,c);$u(a.Tj,TD,a.W_,!1,a)}else!b&&a.Tj&&(a.Tj.$(),a.Tj=null)}
R.m=function(){DP.e.m[L](this);var a=this.a(),b=this.pa();this.Fk=b.m(ch,this.Ij+bEa,this.Wi=b.m(du,{className:this.Ij+ZDa,id:this[kC]()},this.Rf),this.Qi=b.m(du,this.Ij+aEa));Xl(a,this.Fk,this.Ik=b.m(ch,this.Ij+WM),this.Ch=b.m(ch,this.Ij+rEa));zO(this.Wi,Gta);zO(this.Qi,mK);lm(this.Qi,!0);DO(this.Qi,QBa);this.YN=this.Wi.id;zO(a,this.Tt());AO(a,$G,this.YN||M);this.ng&&wl(this.Ik,this.ng);Wm(this.Qi,this.UF);this.ji&&(a=this.ji,a.n=this.Ch,a.C());Wm(this.Ch,!!this.ji);IP(this,this.XN)};
R.Hf=function(a){DP.e.Hf[L](this,a);a=this.a();var b=this.Ij+WM;this.Ik=Jl(null,b,a)[0];this.Ik||(this.Ik=this.pa().m(ch,b),this.ng&&wl(this.Ik,this.ng),a[q](this.Ik));var b=this.Ij+bEa,c=this.Ij+ZDa,d=this.Ij+aEa;(this.Fk=Jl(null,b,a)[0])?(this.Wi=Jl(null,c,this.Fk)[0],this.Qi=Jl(null,d,this.Fk)[0]):(this.Fk=this.pa().m(ch,b),a[Lb](this.Fk,this.Ik));this.Wi?(this.Rf=mm(this.Wi),this.Wi.id||(this.Wi.id=this[kC]())):(this.Wi=Ql(du,{className:c,id:this[kC]()}),this.Fk[q](this.Wi));this.YN=this.Wi.id;
AO(a,$G,this.YN||M);this.Qi||(this.Qi=this.pa().m(du,d),this.Fk[q](this.Qi));Wm(this.Qi,this.UF);b=this.Ij+rEa;(this.Ch=Jl(null,b,a)[0])?(this.ji=new EP(this.pa()),this.ji.Va(this.Ch)):(this.Ch=this.pa().m(ch,b),a[q](this.Ch),this.ji&&(a=this.ji,a.n=this.Ch,a.C()),Wm(this.Ch,!!this.ji));IP(this,this.XN)};
R.Nb=function(){DP.e.Nb[L](this);this.Jc().k(this.a(),fH,this.W8).k(this.a(),Mt,this.W8);this.Jc().k(this.Ch,vt,this.Hka);QGa(this,this.V8);this.Jc().k(this.Qi,vt,this.Ika);var a=this.a();zO(a,this.Tt());this.Wi.id!==M&&AO(a,$G,this.Wi.id);this.FF||JP(this,!1)};R.Ff=function(){this.W()&&this[yA](!1);QGa(this,!1);DP.e.Ff[L](this)};sy(R,function(a){a!=this.W()&&(this.Mb||this.C(),DP.e[yA][L](this,a))});R.OQ=function(){DP.e.OQ[L](this);this[ir](oza)};
R.qP=function(){DP.e.qP[L](this);this[ir](pza);this.oJ&&this.$()};R.W_=function(){var a=this.pa().oc(),b=Ol(Pl(a)||ba||ba),c=h.max(a[ke][Oc],b[r]),a=h.max(a[ke][Wb],b[z]),d=Tm(this.a());Hm(this.a())==hh?xP(this.Tj,new xm(0,0,h.max(0,b[r]-d[r]),h.max(0,b[z]-d[z]))):xP(this.Tj,new xm(0,0,c-d[r],a-d[z]))};R.Ika=function(){KP(this)};function KP(a){if(a.UF){var b=a.ji,c=b&&b.O0;if(c)b=b.get(c),a[ir](new LP(c,b))&&a[yA](!1);else a[yA](!1)}}R.dW=function(a){this.oJ=a};
R.D=function(){this.Ch=this.Qi=null;DP.e.D[L](this)};R.Hka=function(a){t:{for(a=a[ys];null!=a&&a!=this.Ch;){if(a[$c]==Jf)break t;a=a[Ce]}a=null}if(a&&!a[ie]){a=a[Nd];var b=this.ji.get(a);this[ir](new LP(a,b))&&this[yA](!1)}};
R.W8=function(a){var b=!1,c=!1,d=this.ji,e=a[ys];if(a[H]==fH)if(this.Zna&&27==a[pr]){var f=d&&d.O0,e=e[$c]==ig&&!e[ie];f&&!e?(c=!0,b=d.get(f),b=this[ir](new LP(f,b))):e||(b=!0)}else{if(9==a[pr]&&a[Bs]&&e==this.a()){this.S0=!0;try{this.so[iA]()}catch(g){}sv(this.gba,0,this)}}else if(13==a[pr]){if(e[$c]==Jf&&!e[ie])f=e[Nd];else if(e==this.Qi)KP(this);else if(d){var k=d.$Z,l=k&&MP(d,k),e=(e[$c]==pg||e[$c]==ig||e[$c]==Hf)&&!e[ie];!l||l[ie]||e||(f=k)}f&&d&&(c=!0,b=this[ir](new LP(f,String(d.get(f)))))}else e==
this.Qi&&32==a[pr]&&KP(this);if(b||c)a[Er](),a[hr]();b&&this[yA](!1)};function LP(a,b){db(this,NI);this.key=a;this.caption=b}W(LP,Mu);function EP(a){this.U=a||Fl();bl[L](this)}W(EP,bl);R=EP[K];R.Ij="charts-buttonset";R.$Z=null;R.n=null;R.O0=null;R.set=function(a,b,c,d){bl[K].set[L](this,a,b);c&&(this.$Z=a);d&&(this.O0=a);return this};R.oj=function(a,b,c){return this.set(a.key,a[xA],b,c)};
R.C=function(){if(this.n){wl(this.n,Hk);var a=Fl(this.n);this[Zb](function(b,c){var d=a.m(mK,{name:c},b);c==this.$Z&&pb(d,this.Ij+VM);this.n[q](d)},this)}};R.Va=function(a){if(a&&1==a[rd]){this.n=a;a=this.n[kc](mK);for(var b=0,c,d,e;c=a[b];b++)if(d=c[Nd]||c.id,e=mm(c)||c[wd],d){var f=0==b;this.set(d,e,f,c[Nd]==st);f&&qP(c,this.Ij+VM)}}};R.a=function(){return this.n};R.pa=function(){return this.U};function MP(a,b){for(var c=a.n[kc](Jf),d=0,e;e=c[d];d++)if(e[Nd]==b||e.id==b)return e;return null}
var FP={key:SF,caption:aBa},GP={key:st,caption:VBa},RGa={key:"yes",caption:"Yes"},SGa={key:XF,caption:"No"},TGa={key:"save",caption:"Save"},UGa={key:"continue",caption:"Continue"};"undefined"!=typeof ea&&((new EP).oj(FP,!0,!0),(new EP).oj(FP,!0).oj(GP,!1,!0),(new EP).oj(RGa,!0).oj(SGa,!1,!0),(new EP).oj(RGa).oj(SGa,!0).oj(GP,!1,!0),(new EP).oj(UGa).oj(TGa).oj(GP,!0,!0));function NP(a,b){hv[L](this);a&&this.xA(a,b)}W(NP,hv);R=NP[K];R.n=null;R.xT=null;R.T2=null;R.yT=null;R.lm=-1;R.Mv=-1;R.q4=!1;
var VGa={3:13,12:144,63232:38,63233:40,63234:37,63235:39,63236:112,63237:113,63238:114,63239:115,63240:116,63241:117,63242:118,63243:119,63244:120,63245:121,63246:122,63247:123,63248:44,63272:46,63273:36,63275:35,63276:33,63277:34,63289:144,63302:45},WGa={Up:38,Down:40,Left:37,Right:39,Enter:13,F1:112,F2:113,F3:114,F4:115,F5:116,F6:117,F7:118,F8:119,F9:120,F10:121,F11:122,F12:123,"U+007F":46,Home:36,End:35,PageUp:33,PageDown:34,Insert:45},XGa=ol||ql&&ul(UCa),YGa=rl&&pl;R=NP[K];
R.Vm=function(a){ql&&(17==this.lm&&!a[ts]||18==this.lm&&!a[wr]||rl&&91==this.lm&&!a[ds])&&(this.Mv=this.lm=-1);-1==this.lm&&(a[ts]&&17!=a[pr]?this.lm=17:a[wr]&&18!=a[pr]?this.lm=18:a[ds]&&91!=a[pr]&&(this.lm=91));if(XGa&&!dGa(a[pr],this.lm,a[Bs],a[ts],a[wr]))this[rr](a);else this.Mv=QN(a[pr]),YGa&&(this.q4=a[wr])};R.Uqa=function(a){this.Mv=this.lm=-1;this.q4=a[wr]};
Dq(R,function(a){var b=a.Aa,c,d,e=b[wr];ol&&a[H]==Mt?(c=this.Mv,d=13!=c&&27!=c?b[pr]:0):ql&&a[H]==Mt?(c=this.Mv,d=0<=b[or]&&63232>b[or]&&PN(c)?b[or]:0):nl?(c=this.Mv,d=PN(c)?b[pr]:0):(c=b[pr]||this.Mv,d=b[or]||0,YGa&&(e=this.q4),rl&&63==d&&224==c&&(c=191));var f=c=QN(c),g=b.keyIdentifier;c?63232<=c&&c in VGa?f=VGa[c]:25==c&&a[Bs]&&(f=9):g&&g in WGa&&(f=WGa[g]);a=f==this.lm;this.lm=f;b=new ZGa(f,d,a,b);Gq(b,e);this[ir](b)});R.a=function(){return this.n};
R.xA=function(a,b){this.yT&&this[MB]();this.n=a;this.xT=$u(this.n,Mt,this,b);this.T2=$u(this.n,fH,this.Vm,b,this);this.yT=$u(this.n,eH,this.Uqa,b,this)};R.detach=function(){this.xT&&(ev(this.xT),ev(this.T2),ev(this.yT),this.yT=this.T2=this.xT=null);this.n=null;this.Mv=this.lm=-1};R.D=function(){NP.e.D[L](this);this[MB]()};function ZGa(a,b,c,d){Pu[L](this,d);db(this,gH);Cq(this,a);this.charCode=b;this.repeat=c}W(ZGa,Pu);function OP(){}var PP;Ki(OP);function $Ga(a){var b=new QP;b.fa=function(){return a};return b}var aHa={button:vqa,checkbox:QJ,menuitem:LE,menuitemcheckbox:QJ,menuitemradio:QJ,radio:QJ,tab:LE,treeitem:LE};R=OP[K];R.$k=function(){};R.m=function(a){return a.pa().m(ch,this.cm(a)[Fe](Ke),a[SB]())};R.gb=function(a){return a};R.qs=function(a,b,c){if(a=a.a?a.a():a){var d=[b];ol&&!ul(oM)&&(d=RP(oP(a),b),d[B](b));(c?rP:tP)(a,d)}};R.Wh=function(){return!0};
R.Va=function(a,b){b.id&&a.ux(b.id);var c=this.gb(b);c&&c[Yb]?a.sB(c[Yb][ic]?Lj(c[cc]):c[Yb]):a.sB(null);var d=0,e=this.fa(),f=this.fa(),g=!1,k=!1,l=!1,n=Lj(oP(b));X(n,function(a){g||a!=e?k||a!=f?d|=this.vR(a):k=!0:(g=!0,f==e&&(k=!0));1==this.vR(a)&&km(c)&&lm(c,!1)},this);a.o=d;g||(n[B](e),f==e&&(k=!0));k||n[B](f);var p=a.xo;p&&n[B][Zc](n,p);if(ol&&!ul(oM)){var t=RP(n);0<t[J]&&(n[B][Zc](n,t),l=!0)}g&&k&&!p&&!l||HGa(b,n[Fe](Ke));return b};
R.Pp=function(a){a.$i()&&this.Jw(a.a(),!0);a[VA]()&&this.wp(a,a.W())};function SP(a,b,c){if(a=c||a.$k())c=b[oe](Zh)||null,a!=c&&zO(b,a)}function bHa(a,b,c){var d=b.C8;null!=d&&a.o_(c,d);b.W()||AO(c,sh,!b.W());b[VA]()||a.qq(c,1,!b[VA]());TP(b,8)&&a.qq(c,8,b.bS());TP(b,16)&&a.qq(c,16,b.Fm());TP(b,64)&&a.qq(c,64,UP(b,64))}R.o_=function(a,b){DO(a,b)};R.LH=function(a,b){$m(a,!b,!ol&&!nl)};R.Jw=function(a,b){this.qs(a,this.fa()+dEa,b)};R.Kr=function(a){var b;return TP(a,32)&&(b=a.Lg())?km(b):!1};
R.wp=function(a,b){var c;if(TP(a,32)&&(c=a.Lg())){if(!b&&UP(a,32)){try{c[vB]()}catch(d){}UP(a,32)&&a.Lx(null)}km(c)!=b&&lm(c,b)}};sy(R,function(a,b){Wm(a,b);a&&AO(a,sh,!b)});R.ed=function(a,b,c){var d=a.a();if(d){var e=this.OI(b);e&&this.qs(a,e,c);this.qq(d,b,c)}};R.qq=function(a,b,c){PP||(PP={1:Pva,8:LE,16:QJ,64:cva});b=PP[b];var d=a[oe](Zh)||null;d&&(d=aHa[d]||b,b=b==QJ||b==LE?d:b);b&&AO(a,b,c)};
ez(R,function(a,b){var c=this.gb(a);if(c&&(Yl(c),b))if(Si(b))im(c,b);else{var d=function(a){if(a){var b=Hl(c);c[q](Si(a)?b[Jb](a):a)}};Oi(b)?X(b,d):!Pi(b)||ura in b?d(b):X(Lj(b),d)}});R.Lg=function(a){return a.a()};R.fa=function(){return Tza};R.cm=function(a){var b=this.fa(),c=[b],d=this.fa();d!=b&&c[B](d);b=a[Qr]();for(d=[];b;){var e=b&-b;d[B](this.OI(e));b&=~e}c[B][Zc](c,d);(a=a.xo)&&c[B][Zc](c,a);ol&&!ul(oM)&&c[B][Zc](c,RP(c));return c};
function RP(a,b){var c=[];b&&(a=a[Hb]([b]));X([],function(d){!zj(d,Yi(Dj,a))||b&&!Dj(d,b)||c[B](d[Fe](lL))});return c}R.OI=function(a){this.TU||cHa(this);return this.TU[a]};R.vR=function(a){this.Rga||(this.TU||cHa(this),this.Rga=ok(this.TU));a=ja(this.Rga[a],10);return fa(a)?0:a};function cHa(a){var b=a.fa();gj(b[Ab](/\xa0|\s/g,Ke),Ke);a.TU={1:b+UM,2:b+jEa,4:b+tEa,8:b+cEa,16:b+pEa,32:b+mEa,64:b+eEa}};function VP(a,b){if(!a)throw m("Invalid class name "+a);if(!Vi(b))throw m("Invalid decorator function "+b);WP[a]=b}function dHa(a){var b;a=oP(a);for(var c=0,d=a[J];c<d;c++)if(b=a[c],b=b in WP?WP[b]():null)return b;return null}var eHa={},WP={};function fHa(a){var b=dHa(a);b&&b.Va(a);return b};function XP(a,b,c){jP[L](this,c);if(!b){b=this[Bc];for(var d;b;){d=Wi(b);if(d=eHa[d])break;b=b.e?b.e[Bc]:null}b=d?Vi(d.ac)?d.ac():new d:null}this.j=b;this.sB(Gi(a)?a:null);this.C8=null}W(XP,jP);R=XP[K];R.ng=null;R.o=0;R.lI=39;R.Fs=255;R.Ys=0;R.ub=!0;R.xo=null;R.RN=!0;R.wO=!1;R.uM=null;function YP(a,b){a.Mb&&b!=a.RN&&gHa(a,b);a.RN=b}R.Lg=function(){return this.j.Lg(this)};R.wP=function(){return this.Gf||(this.Gf=new NP)};R.Wa=function(){return this.j};
R.Cca=function(a){if(this.Mb)throw m(NL);this.a()&&(this.n=null);this.j=a};R.Xn=function(a){a&&(this.xo?Dj(this.xo,a)||this.xo[B](a):this.xo=[a],this.j.qs(this,a,!0))};R.qs=function(a,b){b?this.Xn(a):a&&this.xo&&Ij(this.xo,a)&&(0==this.xo[J]&&(this.xo=null),this.j.qs(this,a,!1))};R.m=function(){var a=this.j.m(this);this.n=a;SP(this.j,a,this.Tt());this.wO||this.j.LH(a,!1);this.W()||this.j[yA](a,!1)};R.Tt=function(){return this.uM};R.C5=function(a){this.uM=a};
R.o_=function(a){this.C8=a;var b=this.a();b&&this.j.o_(b,a)};R.gb=function(){return this.j.gb(this.a())};R.Wh=function(a){return this.j.Wh(a)};R.Hf=function(a){this.n=a=this.j.Va(this,a);SP(this.j,a,this.Tt());this.wO||this.j.LH(a,!1);this.ub=a[w][cd]!=O};R.Nb=function(){XP.e.Nb[L](this);bHa(this.j,this,this.n);this.j.Pp(this);if(this.lI&-2&&(this.RN&&gHa(this,!0),TP(this,32))){var a=this.Lg();if(a){var b=this.wP();b.xA(a);this.Jc().k(b,gH,this.yk).k(a,ih,this.Vu).k(a,yK,this.Lx)}}};
function gHa(a,b){var c=a.Jc(),d=a.a();b?(c.k(d,Vt,a.Sr).k(d,Tt,a.Ye).k(d,cG,a.eq).k(d,Ut,a.tO),a.eJ!=Ji&&c.k(d,kJ,a.eJ),ol&&c.k(d,QI,a.t$)):(c.hb(d,Vt,a.Sr).hb(d,Tt,a.Ye).hb(d,cG,a.eq).hb(d,Ut,a.tO),a.eJ!=Ji&&c.hb(d,kJ,a.eJ),ol&&c.hb(d,QI,a.t$))}R.Ff=function(){XP.e.Ff[L](this);this.Gf&&this.Gf[MB]();this.W()&&this[VA]()&&this.j.wp(this,!1)};R.D=function(){XP.e.D[L](this);this.Gf&&(this.Gf.$(),delete this.Gf);delete this.j;this.xo=this.ng=null};fz(R,function(){return this.ng});
ez(R,function(a){this.j[RB](this.a(),a);this.sB(a)});R.sB=function(a){this.ng=a};R.Hl=function(){var a=this[SB]();if(!a)return M;a=Si(a)?a:Oi(a)?wj(a,om)[Fe](M):mm(a);return Eda(a)};R.Jw=function(a){XP.e.Jw[L](this,a);var b=this.a();b&&this.j.Jw(b,a)};R.LH=function(a){this.wO=a;var b=this.a();b&&this.j.LH(b,a)};R.W=function(){return this.ub};sy(R,function(a,b){if(b||this.ub!=a&&this[ir](a?dE:BH)){var c=this.a();c&&this.j[yA](c,a);this[VA]()&&this.j.wp(this,a);this.ub=a;return!0}return!1});
Ey(R,function(){return!UP(this,1)});R.Na=function(a){var b=this[Fz]();b&&typeof b[VA]==kh&&!b[VA]()||!ZP(this,1,!a)||(a||(this[VB](!1),this.Jj(!1)),this.W()&&this.j.wp(this,a),this.ed(1,!a,!0))};R.Jj=function(a){ZP(this,2,a)&&this.ed(2,a)};R.Uk=function(){return UP(this,4)};R.setActive=function(a){ZP(this,4,a)&&this.ed(4,a)};R.bS=function(){return UP(this,8)};R.ro=function(a){ZP(this,8,a)&&this.ed(8,a)};R.Fm=function(){return UP(this,16)};R.di=function(a){ZP(this,16,a)&&this.ed(16,a)};
R.lE=function(a){ZP(this,32,a)&&this.ed(32,a)};R.xd=function(a){ZP(this,64,a)&&this.ed(64,a)};Nq(R,function(){return this.o});function UP(a,b){return!!(a.o&b)}R.ed=function(a,b,c){c||1!=a?TP(this,a)&&b!=UP(this,a)&&(this.j.ed(this,a,b),this.o=b?this.o|a:this.o&~a):this.Na(!b)};function TP(a,b){return!!(a.lI&b)}R.bg=function(a,b){if(this.Mb&&UP(this,a)&&!b)throw m(NL);!b&&UP(this,a)&&this.ed(a,!1);this.lI=b?this.lI|a:this.lI&~a};function $P(a,b){return!!(a.Fs&b)&&TP(a,b)}
function ZP(a,b,c){return TP(a,b)&&UP(a,b)!=c&&(!(a.Ys&b)||a[ir](FGa(b,c)))&&!a.yh}R.Sr=function(a){!hHa(a,this.a())&&this[ir](yI)&&this[VA]()&&$P(this,2)&&this.Jj(!0)};R.tO=function(a){!hHa(a,this.a())&&this[ir](Tsa)&&($P(this,4)&&this[VB](!1),$P(this,2)&&this.Jj(!1))};R.eJ=Ji;function hHa(a,b){return!!a[er]&&hm(b,a[er])}R.Ye=function(a){this[VA]()&&($P(this,2)&&this.Jj(!0),Ru(a)&&($P(this,4)&&this[VB](!0),this.j.Kr(this)&&this.Lg()[iA]()));!this.wO&&Ru(a)&&a[hr]()};
R.eq=function(a){this[VA]()&&($P(this,2)&&this.Jj(!0),this.Uk()&&this.ij(a)&&$P(this,4)&&this[VB](!1))};R.t$=function(a){this[VA]()&&this.ij(a)};R.ij=function(a){$P(this,16)&&this.di(!this.Fm());$P(this,8)&&this.ro(!0);$P(this,64)&&this.xd(!UP(this,64));var b=new Mu(Gg,this);a&&(Gq(b,a[wr]),b.ctrlKey=a[ts],Sq(b,a[ds]),b.shiftKey=a[Bs],b.I3=a.I3);return this[ir](b)};R.Vu=function(){$P(this,32)&&this.lE(!0)};R.Lx=function(){$P(this,4)&&this[VB](!1);$P(this,32)&&this.lE(!1)};
R.yk=function(a){return this.W()&&this[VA]()&&this.$j(a)?(a[hr](),a[Er](),!0):!1};R.$j=function(a){return 13==a[pr]&&this.ij(a)};if(!Vi(XP))throw m("Invalid component class "+XP);if(!Vi(OP))throw m("Invalid renderer class "+OP);var iHa=Wi(XP);eHa[iHa]=OP;VP(Tza,function(){return new XP(null)});function aQ(){this.dfa=[]}W(aQ,OP);Ki(aQ);function bQ(a,b){var c=a.dfa[b];if(!c){switch(b){case 0:c=a.fa()+lEa;break;case 1:c=a.fa()+qEa;break;case 2:c=a.fa()+WM}a.dfa[b]=c}return c}R=aQ[K];R.$k=function(){return Hra};R.m=function(a){var b=a.pa().m(ch,this.cm(a)[Fe](Ke),jHa(this,a[SB](),a.pa()));cQ(this,a,b,TP(a,8)||TP(a,16));return b};R.gb=function(a){return a&&a[Yb]};
R.Va=function(a,b){var c=cm(b),d=bQ(this,2);c&&pP(c,d)||b[q](jHa(this,b[cc],a.pa()));pP(b,eL)&&(a.UP(!0),this.UP(a,b,!0));return aQ.e.Va[L](this,a,b)};ez(R,function(a,b){var c=this.gb(a),d=dQ(this,a)?c[Yb]:null;aQ.e[RB][L](this,a,b);d&&!dQ(this,a)&&c[Lb](d,c[Yb]||null)});function jHa(a,b,c){a=bQ(a,2);return c.m(ch,a,b)}R.n_=function(a,b,c){a&&b&&cQ(this,a,b,c)};R.UP=function(a,b,c){a&&b&&cQ(this,a,b,c)};
function dQ(a,b){var c=a.gb(b);if(c){var c=c[Yb],d=bQ(a,1);return!!c&&fm(c)&&pP(c,d)}return!1}function cQ(a,b,c,d){SP(a,c,b.Tt());bHa(a,b,c);if(d!=dQ(a,c))if(uP(c,eL,d),c=a.gb(c),d)a=bQ(a,1),c[Lb](b.pa().m(ch,a),c[Yb]||null);else c[le](c[Yb])}R.OI=function(a){switch(a){case 2:return bQ(this,0);case 16:case 8:return Jza;default:return aQ.e.OI[L](this,a)}};R.vR=function(a){var b=bQ(this,0);switch(a){case Jza:return 16;case b:return 2;default:return aQ.e.vR[L](this,a)}};R.fa=function(){return Nza};function eQ(a,b,c,d){XP[L](this,a,d||aQ.ac(),c);this.Fa(b)}W(eQ,XP);R=eQ[K];hb(R,function(){var a=this.El;return null!=a?a:this.Hl()});R.Fa=function(a){this.El=a};R.bg=function(a,b){eQ.e.bg[L](this,a,b);switch(a){case 8:this.Fm()&&!b&&this.di(!1);var c=this.a();c&&this.Wa().n_(this,c,b);break;case 16:(c=this.a())&&this.Wa().UP(this,c,b)}};R.n_=function(a){this.bg(8,a)};R.UP=function(a){this.bg(16,a)};
R.Hl=function(){var a=this[SB]();return Oi(a)?(a=wj(a,function(a){return fm(a)&&(pP(a,Mza)||pP(a,Lza))?M:om(a)})[Fe](M),Eda(a)):eQ.e.Hl[L](this)};R.eq=function(a){var b=this[Fz]();if(b){var c=b.uca;b.uca=null;if(c&&Ui(a[Qd])&&yl(c,new xl(a[Qd],a[Rd])))return}eQ.e.eq[L](this,a)};R.$j=function(a){return a[pr]==this.Bca&&this.ij(a)?!0:eQ.e.$j[L](this,a)};R.Opa=function(){return this.Bca};VP(Nza,function(){return new eQ(null)});eQ[K].Tt=function(){return TP(this,16)?Gra:TP(this,8)?Fra:eQ.e.Tt[L](this)};
eQ[K].getParent=function(){return XP[K][Fz][L](this)};eQ[K].vV=function(){return XP[K].vV[L](this)};function fQ(a,b,c,d){MN[L](this,a,b,c||d);if(c||d)this.AQ=65|(d?32:132)}W(fQ,MN);var gQ,hQ;hQ=gQ=!1;var iQ=ll;iQ&&(-1!=iQ[zd]("Firefox")||-1!=iQ[zd]("Camino")||(-1!=iQ[zd]("iPad")?hQ=!0:-1!=iQ[zd]("iPhone")||-1!=iQ[zd]("iPod")?gQ=!0:-1!=iQ[zd]("Chrome")||-1!=iQ[zd]("Android")||iQ[zd]("Safari")));var kHa=gQ,lHa=hQ;function jQ(){}W(jQ,OP);Ki(jQ);R=jQ[K];R.$k=function(){return mK};R.qq=function(a,b,c){switch(b){case 8:case 16:AO(a,vqa,c);break;default:case 64:case 1:jQ.e.qq[L](this,a,b,c)}};R.m=function(a){var b=jQ.e.m[L](this,a);this.Yi(b,a.fn());var c=a[I]();c&&this.Fa(b,c);TP(a,16)&&this.qq(b,16,a.Fm());return b};R.Va=function(a,b){b=jQ.e.Va[L](this,a,b);var c=this[I](b);a.vd=c;a.sC(this.fn(b));TP(a,16)&&this.qq(b,16,a.Fm());return b};hb(R,Ji);R.Fa=Ji;R.fn=function(a){return a[bC]};
R.Yi=function(a,b){a&&(b?Xq(a,b):a[ad](qD))};R.Iu=function(a,b){var c=a.$i(),d=this.fa()+oEa,e=this.fa()+nEa;a.qs(c?e:d,!!(b&1));a.qs(c?d:e,!!(b&2))};R.fa=function(){return Wza};function kQ(){}W(kQ,jQ);Ki(kQ);R=kQ[K];R.$k=function(){};R.m=function(a){YP(a,!1);a.Fs&=-256;a.bg(32,!1);return a.pa().m(mK,{"class":this.cm(a)[Fe](Ke),disabled:!a[VA](),title:a.fn()||M,value:a[I]()||M},a.Hl()||M)};R.Wh=function(a){return a[$c]==Jf||a[$c]==Vf&&(a[H]==mK||a[H]==Sna||a[H]==npa)};R.Va=function(a,b){YP(a,!1);a.Fs&=-256;a.bg(32,!1);if(b[ie]){var c=this.OI(1);qP(b,c)}return kQ.e.Va[L](this,a,b)};R.Pp=function(a){a.Jc().k(a.a(),vt,a.ij)};R.LH=Ji;R.Jw=Ji;R.Kr=function(a){return a[VA]()};
R.wp=Ji;R.ed=function(a,b,c){kQ.e.ed[L](this,a,b,c);(a=a.a())&&1==b&&nz(a,c)};hb(R,function(a){return a[wd]});R.Fa=function(a,b){a&&Sy(a,b)};R.qq=Ji;function lQ(a,b,c){XP[L](this,a,b||kQ.ac(),c)}W(lQ,XP);R=lQ[K];hb(R,function(){return this.vd});R.Fa=function(a){this.vd=a;this.Wa().Fa(this.a(),a)};R.fn=function(){return this.la};R.Yi=function(a){this.la=a;this.Wa().Yi(this.a(),a)};R.sC=function(a){this.la=a};R.Iu=function(a){this.Wa().Iu(this,a)};R.D=function(){lQ.e.D[L](this);delete this.vd;delete this.la};R.Nb=function(){lQ.e.Nb[L](this);if(TP(this,32)){var a=this.Lg();a&&this.Jc().k(a,eH,this.$j)}};
R.$j=function(a){return 13==a[pr]&&a[H]==gH||32==a[pr]&&a[H]==eH?this.ij(a):32==a[pr]};VP(Wza,function(){return new lQ(null)});function nQ(a){this.zV=a}Ki(nQ);R=nQ[K];R.$k=function(){return this.zV};function oQ(a,b){a&&eb(a,b?0:-1)}R.m=function(a){return a.pa().m(ch,this.cm(a)[Fe](Ke))};R.gb=function(a){return a};R.Wh=function(a){return a[$c]==ML};R.Va=function(a,b){b.id&&a.ux(b.id);var c=this.fa(),d=!1,e=oP(b);e&&X(e,function(b){b==c?d=!0:b&&this.z1(a,b,c)},this);d||qP(b,c);mHa(this,a,this.gb(b));return b};R.z1=function(a,b,c){b==c+UM?a.Na(!1):b==c+kEa?a.YI(th):b==c+VDa&&a.YI(ui)};
function mHa(a,b,c){if(c)for(var d=c[Yb],e;d&&d[Ce]==c;){e=d[ic];if(1==d[rd]){var f=a.r0(d);f&&(f.n=d,b[VA]()||f.Na(!1),b.va(f),f.Va(d))}else d[jd]&&ej(d[jd])!=M||c[le](d);d=e}}R.r0=function(a){return dHa(a)};R.Pp=function(a){a=a.a();$m(a,!0,pl);ol&&(a.hideFocus=!0);var b=this.$k();b&&zO(a,b)};R.Lg=function(a){return a.a()};R.fa=function(){return Uza};R.cm=function(a){var b=this.fa(),c=a.bj()==th,c=[b,c?b+kEa:b+VDa];a[VA]()||c[B](b+UM);return c};function pQ(a,b,c){jP[L](this,c);this.j=b||nQ.ac();this.kb=a||ui}W(pQ,jP);R=pQ[K];R.RZ=null;R.Gf=null;R.j=null;R.kb=null;R.ub=!0;R.sg=!0;R.X3=!0;R.Yd=-1;R.lh=null;R.xp=!1;R.Xoa=!1;R.Ena=!0;R.as=null;R.Lg=function(){return this.RZ||this.j.Lg(this)};R.wP=function(){return this.Gf||(this.Gf=new NP(this.Lg()))};R.Wa=function(){return this.j};R.Cca=function(a){if(this.a())throw m(NL);this.j=a};R.m=function(){this.n=this.j.m(this)};R.gb=function(){return this.j.gb(this.a())};R.Wh=function(a){return this.j.Wh(a)};
R.Hf=function(a){this.n=this.j.Va(this,a);a[w][cd]==O&&(this.ub=!1)};R.Nb=function(){pQ.e.Nb[L](this);lP(this,function(a){a.Mb&&nHa(this,a)},this);var a=this.a();this.j.Pp(this);this[yA](this.ub,!0);this.Jc().k(this,yI,this.HX).k(this,zH,this.kH).k(this,cD,this.AX).k(this,MF,this.$ia).k(this,rJ,this.zX).k(a,Tt,this.Ye).k(Hl(a),cG,this.Zia).k(a,[Tt,cG,Vt,Ut,kJ],this.Yia);this.Kr()&&oHa(this,!0)};
function oHa(a,b){var c=a.Jc(),d=a.Lg();b?c.k(d,ih,a.Vu).k(d,yK,a.Lx).k(a.wP(),gH,a.yk):c.hb(d,ih,a.Vu).hb(d,yK,a.Lx).hb(a.wP(),gH,a.yk)}R.Ff=function(){this.$f(-1);this.lh&&this.lh.xd(!1);this.xp=!1;pQ.e.Ff[L](this)};R.D=function(){pQ.e.D[L](this);this.Gf&&(this.Gf.$(),this.Gf=null);this.j=this.lh=this.as=this.RZ=null};R.HX=function(){return!0};
R.kH=function(a){var b=nP(this,a[ys]);if(-1<b&&b!=this.Yd){var c=qQ(this);c&&c.Jj(!1);this.Yd=b;c=qQ(this);this.xp&&c[VB](!0);this.Ena&&this.lh&&c!=this.lh&&(TP(c,64)?c.xd(!0):this.lh.xd(!1))}b=this.a();null!=a[ys].a()&&AO(b,cL,a[ys].a().id)};R.AX=function(a){a[ys]==qQ(this)&&(this.Yd=-1);this.a()[ad](Fya)};R.$ia=function(a){(a=a[ys])&&a!=this.lh&&a[Fz]()==this&&(this.lh&&this.lh.xd(!1),this.lh=a)};R.zX=function(a){a[ys]==this.lh&&(this.lh=null)};
R.Ye=function(a){this.sg&&(this.xp=!0);var b=this.Lg();b&&km(b)?b[iA]():a[hr]()};R.Zia=function(){this.xp=!1};R.Yia=function(a){var b;t:{b=a[ys];if(this.as)for(var c=this.a();b&&b!==c;){var d=b.id;if(d in this.as){b=this.as[d];break t}b=b[Ce]}b=null}if(b)switch(a[H]){case Tt:b.Ye(a);break;case cG:b.eq(a);break;case Vt:b.Sr(a);break;case Ut:b.tO(a);break;case kJ:b.eJ(a)}};R.Vu=function(){};R.Lx=function(){this.$f(-1);this.xp=!1;this.lh&&this.lh.xd(!1)};
R.yk=function(a){return this[VA]()&&this.W()&&(0!=this.Uf()||this.RZ)&&this.$j(a)?(a[hr](),a[Er](),!0):!1};
R.$j=function(a){var b=qQ(this);if(b&&typeof b.yk==kh&&b.yk(a)||this.lh&&this.lh!=b&&typeof this.lh.yk==kh&&this.lh.yk(a))return!0;if(a[Bs]||a[ts]||a[ds]||a[wr])return!1;switch(a[pr]){case 27:if(this.Kr())this.Lg()[vB]();else return!1;break;case 36:pHa(this);break;case 35:qHa(this);break;case 38:if(this.kb==ui)rQ(this);else return!1;break;case 37:if(this.kb==th)this.$i()?sQ(this):rQ(this);else return!1;break;case 40:if(this.kb==ui)sQ(this);else return!1;break;case 39:if(this.kb==th)this.$i()?rQ(this):
sQ(this);else return!1;break;default:return!1}return!0};function nHa(a,b){var c=b.a(),c=c.id||(c.id=b[kC]());a.as||(a.as={});a.as[c]=b}R.va=function(a,b){pQ.e.va[L](this,a,b)};R.ED=function(a,b,c){a.Ys|=2;a.Ys|=64;!this.Kr()&&this.Xoa||a.bg(32,!1);YP(a,!1);var d=a[Fz]()==this?nP(this,a):-1;pQ.e.ED[L](this,a,b,c);a.Mb&&this.Mb&&nHa(this,a);a=d;-1==a&&(a=this.Uf());a==this.Yd?this.Yd=h.min(this.Uf()-1,b):a>this.Yd&&b<=this.Yd?this.Yd++:a<this.Yd&&b>this.Yd&&this.Yd--};
R.removeChild=function(a,b){if(a=Si(a)?this.YB(a):a){var c=nP(this,a);-1!=c&&(c==this.Yd?(a.Jj(!1),this.Yd=-1):c<this.Yd&&this.Yd--);(c=a.a())&&c.id&&this.as&&ik(this.as,c.id)}a=pQ.e[le][L](this,a,b);YP(a,!0);return a};R.bj=function(){return this.kb};R.YI=function(a){if(this.a())throw m(NL);this.kb=a};R.W=function(){return this.ub};sy(R,function(a,b){if(b||this.ub!=a&&this[ir](a?dE:BH)){this.ub=a;var c=this.a();c&&(Wm(c,a),this.Kr()&&oQ(this.Lg(),this.sg&&this.ub),b||this[ir](this.ub?oza:pza));return!0}return!1});
Ey(R,function(){return this.sg});R.Na=function(a){this.sg!=a&&this[ir](a?BI:KI)&&(a?(this.sg=!0,lP(this,function(a){a.$da?delete a.$da:a.Na(!0)})):(lP(this,function(a){a[VA]()?a.Na(!1):a.$da=!0}),this.xp=this.sg=!1),this.Kr()&&oQ(this.Lg(),a&&this.ub))};R.Kr=function(){return this.X3};R.wp=function(a){a!=this.X3&&this.Mb&&oHa(this,a);this.X3=a;this.sg&&this.ub&&oQ(this.Lg(),a)};R.$f=function(a){(a=this.Qf(a))?a.Jj(!0):-1<this.Yd&&qQ(this).Jj(!1)};R.Jj=function(a){this.$f(nP(this,a))};
function qQ(a){return a.Qf(a.Yd)}function pHa(a){tQ(a,function(a,c){return(a+1)%c},a.Uf()-1)}function qHa(a){tQ(a,function(a,c){a--;return 0>a?c-1:a},0)}function sQ(a){tQ(a,function(a,c){return(a+1)%c},a.Yd)}function rQ(a){tQ(a,function(a,c){a--;return 0>a?c-1:a},a.Yd)}function tQ(a,b,c){c=0>c?nP(a,a.lh):c;var d=a.Uf();c=b[L](a,c,d);for(var e=0;e<=d;){var f=a.Qf(c);if(f&&a.Dfa(f)){a.h2(c);break}e++;c=b[L](a,c,d)}}R.Dfa=function(a){return a.W()&&a[VA]()&&TP(a,2)};R.h2=function(a){this.$f(a)};function uQ(){}W(uQ,OP);Ki(uQ);uQ[K].fa=function(){return Oza};function vQ(a,b,c){XP[L](this,a,c||uQ.ac(),b);this.bg(1,!1);this.bg(2,!1);this.bg(4,!1);this.bg(32,!1);this.o=1}W(vQ,XP);VP(Oza,function(){return new vQ(null)});function wQ(){}W(wQ,OP);Ki(wQ);wQ[K].m=function(a){return a.pa().m(ch,this.fa())};wQ[K].Va=function(a,b){b.id&&a.ux(b.id);if(b[$c]==Uf){var c=b;b=this.m(a);Zl(b,c);am(c)}else qP(b,this.fa());return b};ez(wQ[K],function(){});wQ[K].fa=function(){return fL};function xQ(a,b){XP[L](this,null,a||wQ.ac(),b);this.bg(1,!1);this.bg(2,!1);this.bg(4,!1);this.bg(32,!1);this.o=1}W(xQ,XP);xQ[K].Nb=function(){xQ.e.Nb[L](this);var a=this.a();zO(a,IE)};VP(fL,function(){return new xQ});function yQ(a){this.zV=a||Ira}W(yQ,nQ);Ki(yQ);R=yQ[K];R.Wh=function(a){return a[$c]==pAa||yQ.e.Wh[L](this,a)};R.r0=function(a){return a[$c]==Uf?new xQ:yQ.e.r0[L](this,a)};R.iy=function(a,b){return hm(a.a(),b)};R.fa=function(){return gL};R.Pp=function(a){yQ.e.Pp[L](this,a);a=a.a();AO(a,GH,pi)};VP(fL,function(){return new xQ});function zQ(a,b){pQ[L](this,ui,b||yQ.ac(),a);this.wp(!1)}W(zQ,pQ);R=zQ[K];R.zQ=!0;R.zca=!1;R.fa=function(){return this.Wa().fa()};R.iy=function(a){if(this.Wa().iy(this,a))return!0;for(var b=0,c=this.Uf();b<c;b++){var d=this.Qf(b);if(typeof d.iy==kh&&d.iy(a))return!0}return!1};R.qk=function(a){this.va(a,!0)};R.az=function(a,b){this.ED(a,b,!0)};R.zd=function(a){return this.Qf(a)};R.Jh=function(){return this.Uf()};R.EH=function(){var a=[];lP(this,function(b){a[B](b)});return a};
wz(R,function(a,b){var c=this.W();c||Wm(this.a(),!0);var d=this.a(),e=a,f=b,g=Om(d);e instanceof xl&&(f=e.y,e=e.x);Im(d,d[je]+(e-g.x),d[ed]+(f-g.y));c||Wm(this.a(),!1)});Dy(R,function(){return this.W()?Om(this.a()):null});sy(R,function(a,b,c){(b=zQ.e[yA][L](this,a,b))&&a&&this.Mb&&this.zQ&&this.Lg()[iA]();this.uca=a&&c&&Ui(c[Qd])?new xl(c[Qd],c[Rd]):null;return b});R.HX=function(a){this.zQ&&this.Lg()[iA]();return zQ.e.HX[L](this,a)};R.Dfa=function(a){return(this.zca||a[VA]())&&a.W()&&TP(a,2)};
R.Hf=function(a){for(var b=this.Wa(),c=rm(this.pa(),ch,b.fa()+WM,a),d=c[J],e=0;e<d;e++)mHa(b,this,c[e]);zQ.e.Hf[L](this,a)};R.$j=function(a){var b=zQ.e.$j[L](this,a);b||lP(this,function(c){!b&&c.Opa&&c.Bca==a[pr]&&(this[VA]()&&this.Jj(c),b=c.yk(a))},this);return b};
R.$f=function(a){zQ.e.$f[L](this,a);if(a=this.Qf(a)){var b=a.a();a=this.a();var c,d=Om(b);c=Om(a);var e=dn(a),f=d.x-c.x-e[G],d=d.y-c.y-e.top,g=a[be]-b[Gb],b=a[re]-b[fd],k=a[Tc],l=a[Ud];if(a==ea[ke]||a==ea[lc])k=c.x+e[G],l=c.y+e.top,ol&&!vl(10)&&(k+=e[G],l+=e.top);k+=h.min(f,h.max(f-g,0));l+=h.min(d,h.max(d-b,0));c=new xl(k,l);a.scrollLeft=c.x;iz(a,c.y)}};function AQ(){}W(AQ,jQ);Ki(AQ);R=AQ[K];R.m=function(a){var b={"class":hL+this.cm(a)[Fe](Ke)},b=a.pa().m(ch,b,this.JQ(a[SB](),a.pa()));this.Yi(b,a.fn());return b};R.$k=function(){return mK};R.gb=function(a){return a&&a[Yb]&&a[Yb][Yb]};R.JQ=function(a,b){return b.m(ch,hL+(this.fa()+QM),b.m(ch,hL+(this.fa()+SM),a))};R.Wh=function(a){return a[$c]==ML};
R.Va=function(a,b){rHa(b,!0);rHa(b,!1);var c;t:{c=a.pa().Cba(b);var d=this.fa()+QM;if(c&&pP(c,d)&&(c=a.pa().Cba(c),d=this.fa()+SM,c&&pP(c,d))){c=!0;break t}c=!1}c||b[q](this.JQ(b[cc],a.pa()));rP(b,[iL,this.fa()]);return AQ.e.Va[L](this,a,b)};R.fa=function(){return Sza};function rHa(a,b){if(a)for(var c=b?a[Yb]:a[Lc],d;c&&c[Ce]==a;){d=b?c[ic]:c[oc];if(3==c[rd]){var e=c[jd];if(ej(e)==M)a[le](c);else{c.nodeValue=b?e[Ab](/^[\s\xa0]+/,M):e[Ab](/[\s\xa0]+$/,M);break}}else break;c=d}};function BQ(){}W(BQ,AQ);Ki(BQ);R=BQ[K];R.gb=function(a){return BQ.e.gb[L](this,a&&a[Yb])};R.Va=function(a,b){var c=Jl(ff,gL,b)[0];if(c){Wm(c,!1);Hl(c)[ke][q](c);var d=new zQ;d.Va(c);a.zs(d)}return BQ.e.Va[L](this,a,b)};R.JQ=function(a,b){return BQ.e.JQ[L](this,[this[uB](a,b),this.xQ(b)],b)};Qy(R,function(a,b){return CQ(a,this.fa(),b)});function CQ(a,b,c){return c.m(ch,hL+(b+XM),a)}R.xQ=function(a){return a.m(ch,hL+(this.fa()+TM),Di)};R.fa=function(){return Pza};function DQ(a,b,c,d,e){lQ[L](this,a,c||BQ.ac(),d);this.bg(64,!0);this.eQ=new fQ(null,5);b&&this.zs(b);this.Dla=null;this.dd=new rv(500);!kHa&&!lHa||ul(RCa)||(this.YA=!0);this.Rpa=e||yQ.ac()}W(DQ,lQ);R=DQ[K];R.YA=!1;R.uia=!1;R.via=!1;R.Nb=function(){DQ.e.Nb[L](this);sHa(this,!0);this.aa&&EQ(this,this.aa,!0);AO(this.n,GH,!!this.aa)};R.Ff=function(){DQ.e.Ff[L](this);sHa(this,!1);if(this.aa){this.xd(!1);this.aa.Ff();EQ(this,this.aa,!1);var a=this.aa.a();a&&am(a)}};
R.D=function(){DQ.e.D[L](this);this.aa&&(this.aa.$(),delete this.aa);delete this.Bja;this.dd.$()};R.Ye=function(a){DQ.e.Ye[L](this,a);this.Uk()&&(this.xd(!UP(this,64),a),this.aa&&(this.aa.xp=UP(this,64)))};R.eq=function(a){DQ.e.eq[L](this,a);this.aa&&!this.Uk()&&(this.aa.xp=!1)};R.ij=function(){this[VB](!1);return!0};R.ria=function(a){this.aa&&this.aa.W()&&!this.iy(a[ys])&&this.xd(!1)};R.iy=function(a){return a&&hm(this.a(),a)||this.aa&&this.aa.iy(a)||!1};
R.$j=function(a){if(32==a[pr]){if(a[hr](),a[H]!=eH)return!0}else if(a[H]!=gH)return!1;if(this.aa&&this.aa.W()){var b=13==a[pr]||32==a[pr],c=this.aa.yk(a);return 27==a[pr]||b?(this.xd(!1),!0):c}return 40==a[pr]||38==a[pr]||32==a[pr]||13==a[pr]?(this.xd(!0,a),!0):!1};R.zy=function(){this.xd(!1)};R.sia=function(){this.Uk()||this.xd(!1)};R.Lx=function(a){this.YA||this.xd(!1);DQ.e.Lx[L](this,a)};R.sq=function(){this.aa||this.zs(new zQ(this.pa(),this.Rpa));return this.aa||null};
R.zs=function(a){var b=this.aa;if(a!=b&&(b&&(this.xd(!1),this.Mb&&EQ(this,b,!1),delete this.aa),this.Mb&&AO(this.n,GH,!!a),a)){this.aa=a;kP(a,this);a[yA](!1);var c=this.YA;(a.zQ=c)&&a.wp(!0);this.Mb&&EQ(this,a,!0)}return b};R.qk=function(a){this.sq().va(a,!0)};R.az=function(a,b){this.sq().ED(a,b,!0)};R.zd=function(a){return this.aa?this.aa.Qf(a):null};R.Jh=function(){return this.aa?this.aa.Uf():0};sy(R,function(a,b){var c=DQ.e[yA][L](this,a,b);c&&!this.W()&&this.xd(!1);return c});
R.Na=function(a){DQ.e.Na[L](this,a);this[VA]()||this.xd(!1)};R.eda=function(){this.xd(!0)};R.vw=function(){this.xd(!1)};
R.xd=function(a,b){DQ.e.xd[L](this,a);if(this.aa&&UP(this,64)==a){if(a){if(!this.aa.Mb)if(this.uia){var c=em(this.a());c?this.aa.iA(c[Ce],c):this.aa.C(this.a()[Ce])}else this.aa.C();this.R6=Nm(this.a());this.Q6=Vm(this.a());this.dN();c=!!b&&(13==b[pr]||32==b[pr]);b&&(40==b[pr]||38==b[pr])||c&&this.via?pHa(this.aa):this.aa.$f(-1)}else{this[VB](!1);this.aa.xp=!1;if(c=this.a())AO(c,cL,M),AO(c,HF,M);null!=this.iN&&(this.iN=void 0,(c=this.aa.a())&&Rm(c,M,M))}this.aa[yA](a,!1,b);if(!this.yh){var c=this.Jc(),
d=a?c.k:c.hb;d[L](c,this.pa().oc(),Tt,this.ria,!0);this.YA&&d[L](c,this.aa,yK,this.sia);d[L](c,this.dd,iu,this.tia);a?this.dd[y]():this.dd[qs]()}}this.aa&&this.aa.a()&&this.aa.n[ad](SK)};R.dN=function(){if(this.aa.Mb){var a=this.Bja||this.a(),b=this.eQ;xz(this.eQ,a);a=this.aa.a();this.aa.W()||(kb(a[w],sh),Wm(a,!0));!this.iN&&this.eQ.Ama&&this.eQ.AQ&32&&(this.iN=Um(a));b.lf(a,b.sJ^1,this.Dla,this.iN);this.aa.W()||(Wm(a,!1),kb(a[w],vi))}};
R.tia=function(){var a=Vm(this.a()),b=Nm(this.a()),c;(c=!Am(this.Q6,a))||(c=this.R6,c=!(c==b||c&&b&&c.top==b.top&&c[kd]==b[kd]&&c[Uc]==b[Uc]&&c[G]==b[G]));c&&(this.Q6=a,this.R6=b,this.dN())};function EQ(a,b,c){var d=a.Jc();c=c?d.k:d.hb;c[L](d,b,Gg,a.zy);c[L](d,b,rJ,a.zX);c[L](d,b,zH,a.kH);c[L](d,b,cD,a.AX)}function sHa(a,b){var c=a.Jc();(b?c.k:c.hb)[L](c,a.a(),fH,a.Bma)}R.kH=function(a){(a=a[ys].a())&&tHa(this,a)};R.Bma=function(a){TP(this,32)&&this.Lg()&&this.aa&&this.aa.W()&&a[Er]()};
R.AX=function(){if(!qQ(this.aa)){var a=this.a();AO(a,cL,M);AO(a,HF,M)}};R.zX=function(a){if(UP(this,64)&&a[ys]instanceof eQ){a=a[ys];var b=a.a();a.W()&&UP(a,2)&&null!=b&&tHa(this,b)}};function tHa(a,b){var c=a.a(),d=BO(b,cL),d=Hl(b)[ud](d)||b;if(!d.id){var e=hP.ac();d.id=iP(e)}e=M;d&&(e=d.id);AO(c,cL,e);AO(c,HF,d.id)}VP(Pza,function(){return new DQ(null)});function FQ(a){hv[L](this);this.Qs=[];uHa(this,a)}W(FQ,hv);R=FQ[K];R.Uy=null;R.qQ=null;R.Jh=function(){return this.Qs[J]};R.zd=function(a){return this.Qs[a]||null};function uHa(a,b){b&&(X(b,function(a){this.lD(a,!1)},a),Mj(a.Qs,b))}R.qk=function(a){this.az(a,this.Jh())};R.az=function(a,b){a&&(this.lD(a,!1),Gj(this.Qs,a,b))};R.Xe=function(){return this.Uy};R.EH=function(){return Lj(this.Qs)};R.Sk=function(a){a!=this.Uy&&(this.lD(this.Uy,!1),this.Uy=a,this.lD(a,!0));this[ir](cu)};
R.Op=function(){var a=this.Uy;return a?sj(this.Qs,a):-1};R.Dl=function(a){this.Sk(this.zd(a))};va(R,function(){Fj(this.Qs);this.Uy=null});R.D=function(){FQ.e.D[L](this);delete this.Qs;this.Uy=null};R.lD=function(a,b){a&&(typeof this.qQ==kh?this.qQ(a,b):typeof a.ro==kh&&a.ro(b))};function GQ(a,b,c,d,e){DQ[L](this,a,b,c,d,e||new yQ(fsa));this.pO=this[SB]();this.Y_=null;this.C5(fsa)}W(GQ,DQ);R=GQ[K];R.qa=null;R.Nb=function(){GQ.e.Nb[L](this);HQ(this);vHa(this)};R.Hf=function(a){GQ.e.Hf[L](this,a);(a=this.Hl())?(this.pO=a,HQ(this)):this.Xe()||this.Dl(0)};R.D=function(){GQ.e.D[L](this);this.qa&&(this.qa.$(),this.qa=null);this.pO=null};R.zy=function(a){this.Sk(a[ys]);GQ.e.zy[L](this,a);a[Er]();this[ir](Gg)};R.o0=function(){var a=this.Xe();GQ.e.Fa[L](this,a&&a[I]());HQ(this)};
R.zs=function(a){var b=GQ.e.zs[L](this,a);a!=b&&(this.qa&&this.qa[bc](),a&&(this.qa?lP(a,function(a){IQ(a);this.qa.qk(a)},this):JQ(this,a)));return b};R.qk=function(a){IQ(a);GQ.e.qk[L](this,a);this.qa?this.qa.qk(a):JQ(this,this.sq());KQ(this)};R.az=function(a,b){IQ(a);GQ.e.az[L](this,a,b);this.qa?this.qa.az(a,b):JQ(this,this.sq())};R.Sk=function(a){if(this.qa){var b=this.Xe();this.qa.Sk(a);a!=b&&this[ir](cK)}};R.Dl=function(a){this.qa&&this.Sk(this.qa.zd(a))};
R.Fa=function(a){if(null!=a&&this.qa)for(var b=0,c;c=this.qa.zd(b);b++)if(c&&typeof c[I]==kh&&c[I]()==a){this.Sk(c);return}this.Sk(null)};hb(R,function(){var a=this.Xe();return a?a[I]():null});R.Xe=function(){return this.qa?this.qa.Xe():null};R.Op=function(){return this.qa?this.qa.Op():-1};function JQ(a,b){a.qa=new FQ;b&&lP(b,function(a){IQ(a);this.qa.qk(a)},a);vHa(a)}function vHa(a){a.qa&&a.Jc().k(a.qa,cu,a.o0)}
function HQ(a){var b=a.Xe();a[RB](b?b.Hl():a.pO);var c=a.Wa().gb(a.a());c&&a.pa().Yma(c)&&(null==a.Y_&&(a.Y_=CO(c)),b=b?b.a():null,DO(c,b?CO(b):a.Y_),KQ(a))}function KQ(a){var b=a.Wa();if(b&&(b=b.gb(a.a()))){var c=a.n;b.id||(b.id=iP(hP.ac()));zO(b,LF);AO(c,cL,b.id);a.qa&&(c=a.qa.EH(),c=Uda(c,function(a){return a instanceof eQ}),AO(b,Soa,c),AO(b,Eqa,1+a.qa.Op()))}}function IQ(a){a.C5(a instanceof eQ?LF:IE)}R.xd=function(a,b){GQ.e.xd[L](this,a,b);UP(this,64)?this.sq().$f(this.Op()):KQ(this)};
VP(Iza,function(){return new GQ(null)});function LQ(a,b){this.U=Fl();this.A=a;this.yca=[];this.Zf(b)}LQ[K].cD=null;
function wHa(a,b){var c=Fl(),d,e,f=null;switch(a){case 2:d=new DP(oua);f=kF+d[kC]();e=c.m(ch,null,c.m(ch,{"class":pua},OBa),c.m(Sg,null),c.m(xqa,null,c.m(ch,{id:f},b[Gr])));break;case 3:d=new DP(qua);e=c.m(ch,null,c.m(ch,{"class":pua},OBa),c.m(Sg,null));var g=c.m(ch,null,c.m(xqa,null,b[Gr]));c[q](e,g)}d[RB](e[vd]);c=d;HP(c);Xa(c.Wi,wBa);c=d;HP(c);Xa(c.Ch,M);d[yA](!0);if(f){d=c=Il(f);f=0;e=1;g=new fP;g.Lo=DGa(d,f,c,e);if(fm(d)&&!Wl(d)){var k=d[Ce],f=sj(k[cc],d);d=k}fm(c)&&!Wl(c)&&(k=c[Ce],e=sj(k[cc],
c),c=k);g.Lo?(g.ae=c,g.$d=e,g.Fd=d,g.Zd=f):(g.ae=d,g.$d=f,g.Fd=c,g.Zd=e);g[jA]()}}
LQ[K].Zf=function(a){a=a||[];var b=this.A,c=this.U;c.Oc(b);if(!b)throw m(Mf);var d=c.m(du,null),e=[c.m(du,null,UBa)];this.cD=new GQ(e);if(a)for(e=0;e<a[J];e++){var f=null,f=a[e],g=f.datasource,k=f.gadget,l=f.userprefs,n=f[he],p=f[bra],t=f[w]||wma;switch(f[H]){case lwa:f=MQ(this,e,Yi(function(a){ba[Xr]((new zv(a)).Xc(ena,kra),vBa)},g),DBa);break;case rta:f=MQ(this,e,Yi(function(a,b){wHa(2,{message:nCa+t+FFa+aa(a)+DEa+aa(b)+xHa(l)+Ne})},k,g),SAa);break;case Wsa:f=MQ(this,e,Yi(function(a,b,c){wHa(3,
{message:oCa+aa(b)+BEa+a+CEa+aa(c)+AEa})},g,p,n),kBa);break;case vh:f=MQ(this,e,Yi(function(a){ba[Xr]((new zv(a)).Xc(ena,jra),vBa)},g),CBa);break;case lta:f=MQ(this,e,Yi(function(a,b,c){ba[Xr](pta+aa(a)+DEa+aa(b)+xHa(c))},k,g,l),cCa);break;default:throw m("No such toolbar component as: "+f.toSource());}f&&this.cD.qk(f)}$u(this.cD,Gg,U(this.Lma,this));this.cD.C(d);c[q](b,d)};LQ[K].Lma=function(){var a=this.cD.Op();this.yca[a]();this.cD.Dl(-1)};function MQ(a,b,c,d){d=new eQ(d);a.yca[b]=c;return d}
function xHa(a){if(!a)return M;var b=M,c;for(c in a)b+=EEa+c+Df+aa(a[c]);return b};function QP(){}W(QP,OP);Ki(QP);QP[K].m=function(a){var b=a.pa().m(du,this.cm(a)[Fe](Ke));yHa(this,b,a.mq);return b};QP[K].Va=function(a,b){b=QP.e.Va[L](this,a,b);var c=oP(b),d=!1;Dj(c,NQ(this,null))?d=null:Dj(c,NQ(this,!0))?d=!0:Dj(c,NQ(this,!1))&&(d=!1);a.mq=d;AO(b,QJ,null==d?hG:1==d?pi:fh);return b};QP[K].$k=function(){return RJ};function yHa(a,b,c){if(b){var d=NQ(a,c);pP(b,d)||(Zj(zHa,function(a){a=NQ(this,a);uP(b,a,a==d)},a),AO(b,QJ,null==c?hG:1==c?pi:fh))}}QP[K].fa=function(){return Vza};
function NQ(a,b){var c=a.fa();if(1==b)return c+pEa;if(0==b)return c+XDa;if(null==b)return c+WDa;throw m("Invalid checkbox state: "+b);};function OQ(a,b,c){c=c||QP.ac();XP[L](this,null,c,b);this.mq=Gi(a)?a:!1}W(OQ,XP);var zHa={Nza:!0,HBa:!1,IBa:null};R=OQ[K];R.Hb=null;R.Fm=function(){return 1==this.mq};R.di=function(a){a!=this.mq&&(this.mq=a,yHa(this.Wa(),this.a(),this.mq))};R.Em=function(a){this.Mb?(this.Ff(),this.Hb=a,this.Nb()):this.Hb=a};R.toggle=function(){this.di(this.mq?!1:!0)};
R.Nb=function(){OQ.e.Nb[L](this);if(this.RN){var a=this.Jc();this.Hb&&a.k(this.Hb,vt,this.nY).k(this.Hb,Vt,this.Sr).k(this.Hb,Ut,this.tO).k(this.Hb,Tt,this.Ye).k(this.Hb,cG,this.eq);a.k(this.a(),vt,this.nY)}a=this.n;this.Hb&&a!=this.Hb&&cj(CO(a))&&(this.Hb.id||(this.Hb.id=this[kC]()+yDa),AO(a,$G,this.Hb.id))};R.Na=function(a){OQ.e.Na[L](this,a);(a=this.a())&&eb(a,this[VA]()?0:-1)};R.nY=function(a){a[Er]();var b=this.mq?Wma:kxa;this[VA]()&&!a[ys][Vc]&&this[ir](b)&&(a[hr](),this.toggle(),this[ir](cK))};
R.$j=function(a){32==a[pr]&&(this.ij(a),this.nY(a));return!1};VP(Vza,function(){return new OQ});function PQ(a,b){hv[L](this);this.n=a;var c=fm(this.n)?this.n:this.n?this.n[ke]:null;this.wqa=!!c&&Ym(c);this.Iaa=$u(this.n,pl?MBa:bG,this,b)}W(PQ,hv);
Dq(PQ[K],function(a){var b=0,c=0,d=0;a=a.Aa;if(a[H]==bG){c=1;if(ol||ql&&(sl||ul(SCa)))c=40;d=QQ(-a.wheelDelta,c);Gi(a.wheelDeltaX)?(b=QQ(-a.wheelDeltaX,c),c=QQ(-a.wheelDeltaY,c)):c=d}else d=a.detail,100<d?d=3:-100>d&&(d=-3),Gi(a[wC])&&a[wC]===a.HORIZONTAL_AXIS?b=d:c=d;Ui(this.wfa)&&(b=Lk(b,-this.wfa,this.wfa));Ui(this.xfa)&&(c=Lk(c,-this.xfa,this.xfa));this.wqa&&(b=-b);b=new AHa(d,a,b,c);this[ir](b)});function QQ(a,b){return ql&&(rl||Sea)&&0!=a%b?a:a/b}
PQ[K].D=function(){PQ.e.D[L](this);ev(this.Iaa);this.Iaa=null};function AHa(a,b,c,d){Pu[L](this,b);db(this,bG);this.detail=a;wy(this,c);vy(this,d)}W(AHa,Pu);function RQ(){hv[L](this);this.o=0;Ky(this,null);jz(this,null)}W(RQ,hv);RQ[K].ov=function(){return 1==this.o};RQ[K].AJ=function(){this.mj(qya)};RQ[K].yy=function(){this.mj(zI)};RQ[K].mj=function(a){this[ir](a)};function SQ(){RQ[L](this);this.Is=[]}W(SQ,RQ);SQ[K].add=function(a){Dj(this.Is,a)||(this.Is[B](a),$u(a,hI,this.Gga,!1,this))};ua(SQ[K],function(a){Ij(this.Is,a)&&dv(a,hI,this.Gga,!1,this)});SQ[K].D=function(){X(this.Is,function(a){a.$()});mb(this.Is,0);SQ.e.D[L](this)};function TQ(){SQ[L](this);this.Y2=0}W(TQ,SQ);
TQ[K].play=function(a){if(0==this.Is[J])return!1;if(a||0==this.o)this.Y2=0,this.AJ();else if(this.ov())return!1;this.mj(wF);-1==this.o&&this.mj(mpa);var b=-1==this.o&&!a;Ky(this,Zi());jz(this,null);this.o=1;X(this.Is,function(c){b&&-1!=c.o||c[KB](a)});return!0};Wq(TQ[K],function(a){X(this.Is,function(b){0==b.o||b[qs](a)});this.o=0;jz(this,Zi());this.mj(PD);this.yy()});TQ[K].Gga=function(){this.Y2++;this.Y2==this.Is[J]&&(jz(this,Zi()),this.o=0,this.mj(hI),this.yy())};function UQ(a,b,c){Ju[L](this);this.As=a;this.bw=b||0;this.Bd=c;this.Vs=U(this.JL,this)}W(UQ,Ju);R=UQ[K];R.hc=0;R.D=function(){UQ.e.D[L](this);this[qs]();delete this.As;delete this.Bd};Ja(R,function(a){this[qs]();this.hc=sv(this.Vs,Gi(a)?a:this.bw)});Wq(R,function(){this.Uk()&&tv(this.hc);this.hc=0});R.OU=function(){this[qs]();this.JL()};R.Uk=function(){return 0!=this.hc};R.JL=function(){this.hc=0;this.As&&this.As[L](this.Bd)};var VQ={},WQ=null;function XQ(a){a=Wi(a);delete VQ[a];hk(VQ)&&WQ&&WQ[qs]()}function BHa(){WQ||(WQ=new UQ(function(){CHa()},20));var a=WQ;a.Uk()||a[y]()}function CHa(){var a=Zi();Zj(VQ,function(b){DHa(b,a)});hk(VQ)||BHa()};function YQ(a,b,c,d){RQ[L](this);if(!Oi(a)||!Oi(b))throw m("Start and end parameters must be arrays");if(a[J]!=b[J])throw m("Start and end points must be the same length");this.cj=a;this.Mr=b;this.duration=c;this.Tfa=d;uz(this,[]);this.Iy=!1;this.Dn=0}W(YQ,RQ);R=YQ[K];R.Pu=function(a){this.Iy=a};
R.play=function(a){if(a||0==this.o)this.Dn=0,uz(this,this.cj);else if(this.ov())return!1;XQ(this);a=Zi();Ky(this,a);-1==this.o&&Ky(this,this[eB]-this[dC]*this.Dn);jz(this,this[eB]+this[dC]);this.Dn||this.AJ();this.mj(wF);-1==this.o&&this.mj(mpa);this.o=1;var b=Wi(this);b in VQ||(VQ[b]=this);BHa();DHa(this,a);return!0};Wq(R,function(a){XQ(this);this.o=0;a&&(this.Dn=1);EHa(this,this.Dn);this.mj(PD);this.yy()});R.D=function(){0==this.o||this[qs](!1);this.mj(Zva);YQ.e.D[L](this)};
function DHa(a,b){a.Dn=(b-a[eB])/(a.endTime-a[eB]);1<=a.Dn&&(a.Dn=1);EHa(a,a.Dn);1==a.Dn?(a.o=0,XQ(a),a.mj(hI),a.yy()):a.ov()&&a.e1()}function EHa(a,b){Vi(a.Tfa)&&(b=a.Tfa(b));uz(a,ga(a.cj[J]));for(var c=0;c<a.cj[J];c++)a[oC][c]=(a.Mr[c]-a.cj[c])*b+a.cj[c]}R.e1=function(){this.mj(jza)};R.mj=function(a){this[ir](new FHa(a,this))};function FHa(a,b){Mu[L](this,a);uz(this,b[oC]);this.x=b[oC][0];this.y=b[oC][1];this.z=b[oC][2];this.duration=b[dC];this.Dn=b.Dn;Lq(this,b.o)}W(FHa,Mu);function ZQ(a,b,c,d,e){YQ[L](this,b,c,d,e);xz(this,a)}W(ZQ,YQ);R=ZQ[K];R.lz=Ji;R.$i=function(){Gi(this.Nq)||(this.Nq=Ym(this[uC]));return this.Nq};R.e1=function(){this.lz();ZQ.e.e1[L](this)};R.yy=function(){this.lz();ZQ.e.yy[L](this)};R.AJ=function(){this.lz();ZQ.e.AJ[L](this)};function $Q(a,b,c,d,e){if(2!=b[J]||2!=c[J])throw m(zAa);ZQ[Zc](this,arguments)}W($Q,ZQ);$Q[K].lz=function(){var a=this.Iy&&this.$i()?au:Ch;this[uC][w][a]=h[D](this[oC][0])+P;this[uC][w].top=h[D](this[oC][1])+P};
function aR(a,b,c,d,e){if(2!=b[J]||2!=c[J])throw m(zAa);ZQ[Zc](this,arguments)}W(aR,ZQ);aR[K].lz=function(){na(this[uC][w],h[D](this[oC][0])+P);Ta(this[uC][w],h[D](this[oC][1])+P)};function bR(a,b,c,d,e){ZQ[L](this,a,[b],[c],d,e)}W(bR,ZQ);bR[K].lz=function(){na(this[uC][w],h[D](this[oC][0])+P)};function cR(a,b,c,d,e){ZQ[L](this,a,[b],[c],d,e)}W(cR,ZQ);cR[K].lz=function(){Ta(this[uC][w],h[D](this[oC][0])+P)};function dR(){hv[L](this)}W(dR,hv);R=dR[K];R.vd=0;R.cp=0;R.Kn=100;R.nm=0;R.qj=1;R.bl=!1;R.dz=!1;R.Fa=function(a){a=eR(this,a);this.vd!=a&&(this.vd=a+this.nm>this.Kn?this.Kn-this.nm:a<this.cp?this.cp:a,this.bl||this.dz||this[ir](cK))};hb(R,function(){return eR(this,this.vd)});R.KT=function(a){a=eR(this,a);this.nm!=a&&(this.nm=0>a?0:this.vd+a>this.Kn?this.Kn-this.vd:a,this.bl||this.dz||this[ir](cK))};R.Sl=function(){var a=this.nm;return null==this.qj?a:h[D](a/this.qj)*this.qj};
R.Ot=function(a){if(this.cp!=a){var b=this.bl;this.bl=!0;this.cp=a;a+this.nm>this.Kn&&(this.nm=this.Kn-this.cp);a>this.vd&&this.Fa(a);a>this.Kn&&(this.nm=0,this.tr(a),this.Fa(a));(this.bl=b)||this.dz||this[ir](cK)}};R.nf=function(){return eR(this,this.cp)};R.tr=function(a){a=eR(this,a);if(this.Kn!=a){var b=this.bl;this.bl=!0;this.Kn=a;a<this.vd+this.nm&&this.Fa(a-this.nm);a<this.cp&&(this.nm=0,this.Ot(a),this.Fa(this.Kn));a<this.cp+this.nm&&(this.nm=this.Kn-this.cp);(this.bl=b)||this.dz||this[ir](cK)}};
R.mf=function(){return eR(this,this.Kn)};R.aK=function(){return this.qj};R.iT=function(a){this.qj!=a&&(this.qj=a,a=this.bl,this.bl=!0,this.tr(this.mf()),this.KT(this.Sl()),this.Fa(this[I]()),(this.bl=a)||this.dz||this[ir](cK))};function eR(a,b){return null==a.qj?b:a.cp+h[D]((b-a.cp)/a.qj)*a.qj};function lR(a,b){jP[L](this,a);this.Iba=null;this.Me=new dR;this.Tna=b||Jk;$u(this.Me,cK,this.Tda,!1,this)}W(lR,jP);R=lR[K];R.kb=th;R.gS=!1;R.Hla=!1;R.xn=10;R.vT=0;R.l$=!0;R.oP=0;R.Fla=1E3;R.sg=!0;R.Nl=!1;R.m=function(){lR.e.m[L](this);var a=this.pa().m(ch,this.fa(this.kb));this.Hf(a)};R.Hf=function(a){lR.e.Hf[L](this,a);qP(a,this.fa(this.kb));this.Ela();a=this.a();zO(a,ZD);GHa(this)};
R.Nb=function(){lR.e.Nb[L](this);this.Gl=new vP(this.Ad);this.Zp=new vP(this.Vi);this.Gl.Pu(this.Nl);this.Zp.Pu(this.Nl);this.Gl.Wx=this.Zp.Wx=Ji;this.Gf=new NP(this.a());HHa(this,!0);eb(this.a(),0);mR(this)};
function HHa(a,b){b?(a.Jc().k(a.Gl,GK,a.nQ).k(a.Zp,GK,a.nQ).k(a.Gl,[TD,zI],a.ev).k(a.Zp,[TD,zI],a.ev).k(a.Gf,gH,a.Vm).k(a.a(),vt,a.oQ).k(a.a(),Tt,a.oQ),a.l$&&IHa(a,!0)):(a.Jc().hb(a.Gl,GK,a.nQ).hb(a.Zp,GK,a.nQ).hb(a.Gl,[TD,zI],a.ev).hb(a.Zp,[TD,zI],a.ev).hb(a.Gf,gH,a.Vm).hb(a.a(),vt,a.oQ).hb(a.a(),Tt,a.oQ),a.l$&&IHa(a,!1))}R.Ff=function(){lR.e.Ff[L](this);uja(this.Gl,this.Zp,this.Gf,this.Am)};
R.nQ=function(a){var b=a.l0==this.Gl?this.Ad:this.Vi,c;this.kb==ui?(c=this.a()[re]-b[fd],c=(c-a.top)/c*(this.mf()-this.nf())+this.nf()):(c=this.a()[be]-b[Gb],c=a[G]/c*(this.mf()-this.nf())+this.nf());c=a.l0==this.Gl?h.min(h.max(c,this.nf()),this[I]()+this.Sl()):h.min(h.max(c,this[I]()),this.mf());nR(this,b,c)};R.ev=function(a){var b=a[H]==TD;uP(this.a(),Fza,b);uP(a[ys][IA],Eza,b);a=a.l0==this.Gl;b?(this[ir](DI),this[ir](a?Eg:Tg)):(this[ir](eh),this[ir](a?Ng:Vg))};
R.Vm=function(a){var b=!0;switch(a[pr]){case 36:zR(this,this.nf());break;case 35:zR(this,this.mf());break;case 33:AR(this,this.xn);break;case 34:AR(this,-this.xn);break;case 37:var c=this.Nl&&this.$i()?1:-1;AR(this,a[Bs]?c*this.xn:c*this.gz);break;case 40:AR(this,a[Bs]?-this.xn:-this.gz);break;case 39:c=this.Nl&&this.$i()?-1:1;AR(this,a[Bs]?c*this.xn:c*this.gz);break;case 38:AR(this,a[Bs]?this.xn:this.gz);break;default:b=!1}b&&a[hr]()};
R.oQ=function(a){this.a()[iA]&&this.a()[iA]();var b=a[ys];hm(this.Ad,b)||hm(this.Vi,b)||(b=a[H]==vt,b&&Zi()<this.oP+this.Fla||(b||(this.oP=Zi()),this.Hla?zR(this,JHa(this,a)):(this.YZ(a),this.hn=KHa(this,JHa(this,a)),this.d$=this.kb==ui?this.Jx<this.hn[ed]:this.Jx>BR(this,this.hn)+this.hn[Gb],a=Hl(this.a()),this.Jc().k(a,cG,this.VZ,!0).k(this.a(),dG,this.YZ),this.Au||(this.Au=new rv(200),this.Jc().k(this.Au,iu,this.h$)),this.h$(),this.Au[y]())))};
R.M$=function(a){AR(this,(0<a.detail?-1:1)*this.gz);a[hr]()};R.h$=function(){var a;if(this.kb==ui){var b=this.Jx,c=this.hn[ed];this.d$?b<c&&(a=CR(this,this.hn)+this.xn):b>c+this.hn[fd]&&(a=CR(this,this.hn)-this.xn)}else b=this.Jx,c=BR(this,this.hn),this.d$?b>c+this.hn[Gb]&&(a=CR(this,this.hn)+this.xn):b<c&&(a=CR(this,this.hn)-this.xn);Gi(a)&&nR(this,this.hn,a)};R.VZ=function(){this.Au&&this.Au[qs]();var a=Hl(this.a());this.Jc().hb(a,cG,this.VZ,!0).hb(this.a(),dG,this.YZ)};
function DR(a,b){var c=Pm(b,a.a());return a.kb==ui?c.y:a.Nl&&a.$i()?a.a()[be]-c.x:c.x}R.YZ=function(a){this.Jx=DR(this,a)};function JHa(a,b){var c=a.nf(),d=a.mf();if(a.kb==ui){var e=a.Ad[fd],f=a.a()[re]-e,e=DR(a,b)-e/2;return(d-c)*(f-e)/f+c}e=a.Ad[Gb];f=a.a()[be]-e;e=DR(a,b)-e/2;return(d-c)*e/f+c}function CR(a,b){if(b==a.Ad)return a.Me[I]();if(b==a.Vi)return a.Me[I]()+a.Me.Sl();throw m("Illegal thumb element. Neither minThumb nor maxThumb");}
function AR(a,b){h.abs(b)<a.aK()&&(b=Sk(b)*a.aK());var c=CR(a,a.Ad)+b,d=CR(a,a.Vi)+b,c=Lk(c,a.nf(),a.mf()-a.vT),d=Lk(d,a.nf()+a.vT,a.mf());ER(a,c,d-c)}function nR(a,b,c){var d=eR(a.Me,c);c=b==a.Ad?d:a.Me[I]();b=b==a.Vi?d:a.Me[I]()+a.Me.Sl();c>=a.nf()&&b>=c+a.vT&&a.mf()>=b&&ER(a,c,b-c)}function ER(a,b,c){a.nf()<=b&&b<=a.mf()-c&&a.vT<=c&&c<=a.mf()-b&&(b!=a[I]()||c!=a.Sl())&&(a.Me.dz=!0,a.Me.KT(0),a.Me.Fa(b),a.Me.KT(c),a.Me.dz=!1,a.Tda())}R.nf=function(){return this.Me.nf()};R.Ot=function(a){this.Me.Ot(a)};
R.mf=function(){return this.Me.mf()};R.tr=function(a){this.Me.tr(a)};function KHa(a,b){return b<=a.Me[I]()+a.Me.Sl()/2?a.Ad:a.Vi}R.Tda=function(){mR(this);GHa(this);this[ir](cK)};
function mR(a){if(a.Ad&&!a.gS){var b=FR(a,CR(a,a.Ad)),c=FR(a,CR(a,a.Vi));if(a.kb==ui)a.Ad[w].top=b.y+P,a.Vi[w].top=c.y+P,a.vg&&(b=GR(c.y,b.y,a.Ad[fd]),a.vg[w].top=b[tA]+P,Ta(a.vg[w],b[EA]+P));else{var d=a.Nl&&a.$i()?au:Ch;a.Ad[w][d]=b.x+P;a.Vi[w][d]=c.x+P;a.vg&&(b=GR(b.x,c.x,a.Ad[Gb]),a.vg[w][d]=b[tA]+P,na(a.vg[w],b[EA]+P))}}}function GR(a,b,c){var d=h[Cb](c/2);return{offset:a+d,size:h.max(b-a+c-2*d,0)}}
function FR(a,b){var c=new xl;if(a.Ad){var d=a.nf(),e=a.mf(),d=b==d&&d==e?0:(b-d)/(e-d);a.kb==ui?(e=a.Ad[fd],e=a.a()[re]-e,d=h[D](d*e),c.x=BR(a,a.Ad),c.y=e-d):(e=a.a()[be]-a.Ad[Gb],d=h[D](d*e),c.x=d,c.y=a.Ad[ed])}return c}
function zR(a,b){b=Lk(b,a.nf(),a.mf());a.gS&&a.zP[qs](!0);var c=new TQ,d,e=KHa(a,b),f=a[I](),g=a.Sl(),k=CR(a,e),l=FR(a,k);d=a.aK();h.abs(b-k)<d&&(b=Lk(k+(b>k?d:-d),a.nf(),a.mf()));nR(a,e,b);k=FR(a,CR(a,e));d=a.kb==ui?[BR(a,e),k.y]:[k.x,e[ed]];l=new $Q(e,[l.x,l.y],d,100);l.Pu(a.Nl);c.add(l);a.vg&&LHa(a,e,f,g,k,c);a.Iba&&(e=a.Iba.Cya(f,b,100),X(e,function(a){c.add(a)}));a.zP=c;a.Jc().k(c,zI,a.Koa);a.gS=!0;c[KB](!1)}
function LHa(a,b,c,d,e,f){var g=FR(a,c),k=FR(a,c+d);c=g;d=k;b==a.Ad?c=e:d=e;a.kb==ui?(b=GR(k.y,g.y,a.Ad[fd]),g=GR(d.y,c.y,a.Ad[fd]),e=new $Q(a.vg,[BR(a,a.vg),b[tA]],[BR(a,a.vg),g[tA]],100),b=new cR(a.vg,b[EA],g[EA],100)):(b=GR(g.x,k.x,a.Ad[Gb]),g=GR(c.x,d.x,a.Ad[Gb]),e=new $Q(a.vg,[b[tA],a.vg[ed]],[g[tA],a.vg[ed]],100),b=new bR(a.vg,b[EA],g[EA],100));e.Pu(a.Nl);b.Pu(a.Nl);f.add(e);f.add(b)}R.Koa=function(){this.gS=!1};
R.YI=function(a){if(this.kb!=a){var b=this.fa(this.kb),c=this.fa(a);this.kb=a;this.a()&&(a=this.a(),pP(a,b)&&(sP(a,b),qP(a,c)),b=this.Nl&&this.$i()?au:Ch,this.Ad[w][b]=this.Ad[w].top=M,this.Vi[w][b]=this.Vi[w].top=M,this.vg&&(this.vg[w][b]=this.vg[w].top=M,na(this.vg[w],Ta(this.vg[w],M))),mR(this))}};R.bj=function(){return this.kb};
R.D=function(){lR.e.D[L](this);this.Au&&this.Au.$();delete this.Au;this.zP&&this.zP.$();delete this.zP;delete this.Ad;delete this.Vi;this.vg&&delete this.vg;this.Me.$();delete this.Me;this.Gf&&(this.Gf.$(),delete this.Gf);this.Am&&(this.Am.$(),delete this.Am);this.Gl&&(this.Gl.$(),delete this.Gl);this.Zp&&(this.Zp.$(),delete this.Zp)};R.gz=1;R.aK=function(){return this.Me.aK()};R.iT=function(a){this.Me.iT(a)};hb(R,function(){return this.Me[I]()});R.Fa=function(a){nR(this,this.Ad,a)};R.Sl=function(){return this.Me.Sl()};
R.KT=function(a){nR(this,this.Vi,this.Me[I]()+a)};sy(R,function(a){Wm(this.a(),a);a&&mR(this)});function GHa(a){var b=a.a();b&&(AO(b,Ema,a.nf()),AO(b,Fma,a.mf()),AO(b,Dma,a[I]()),AO(b,Cma,a.Tna(a[I]())||M))}function IHa(a,b){b?(a.Am||(a.Am=new PQ(a.a())),a.Jc().k(a.Am,bG,a.M$)):a.Jc().hb(a.Am,bG,a.M$)}R.Na=function(a){this.sg!=a&&this[ir](a?BI:KI)&&(this.sg=a,HHa(this,a),a||this.VZ(),uP(this.a(),Gza,!a))};Ey(R,function(){return this.sg});function BR(a,b){return a.Nl?bGa(b):b[je]};Hi("google.visualization.drawToolbar",function(a,b){new LQ(a,b)},void 0);function MHa(a,b){Oi(b)||(b=[b]);var c=wj(b,function(a){return Si(a)?a:a[$B]+Ke+a[dC]+dpa+a.timing+Ke+a.delay+ai});NHa(a,c[Fe](jf))}var OHa=function(a){var b=!1,c;return function(){b||(c=a(),b=!0);return c}}(function(){if(ol)return ul(eDa);var a=ea[Vb](ch),b=ql?UDa:pl?hEa:ol?gEa:nl?fEa:null,c={transition:nra};b&&(c[b+YDa]=nra);wl(a,Dk(ch,{style:c}));return wfa(a[Yb],dna)!=M});function NHa(a,b){Bm(a,dna,b)};function HR(a,b,c,d,e){RQ[L](this);this.n=a;this.Ak=b;this.Loa=c;this.Qba=d;this.pE=Oi(e)?e:[e]}W(HR,RQ);R=HR[K];R.play=function(){if(this.ov())return!1;this.AJ();this.mj(wF);Ky(this,Zi());this.o=1;if(OHa())return Bm(this.n,this.Loa),this.$l=sv(this.Yoa,void 0,this),!0;this.t1(!1);return!1};R.Yoa=function(){Um(this.n);MHa(this.n,this.pE);Bm(this.n,this.Qba);this.$l=sv(U(this.t1,this,!1),1E3*this.Ak)};Wq(R,function(){this.ov()&&this.t1(!0)});
R.t1=function(a){NHa(this.n,M);tv(this.$l);Bm(this.n,this.Qba);jz(this,Zi());this.o=0;a?this.mj(PD):this.mj(hI);this.yy()};R.D=function(){this[qs]();HR.e.D[L](this)};function IR(a,b,c,d,e){return new HR(a,b,{opacity:d},{opacity:e},{property:Rh,duration:b,timing:c,delay:0})}function JR(a,b){return IR(a,b,mva,0,1)}function KR(a,b){return IR(a,b,nva,1,0)};function LR(a,b,c){lQ[L](this,a,b||AQ.ac(),c)}W(LR,lQ);VP(Sza,function(){return new LR(null)});function MR(a,b,c,d){this.MH=a;this.QU=b;this.M4=c;this.Eja=d}MR[K].oha=!1;MR[K].ro=function(a){this.oha=a};MR[K].bS=function(){return this.oha};function PHa(a,b){this.ah=a;var c=a.O(),d=c;b[oB]&&b[oB]!=KI&&(d=ja(b.pageSize,10)||10);this.oz=d;this.JG=0<c?h[Cb](c/this.oz):1;this.rsa=null!=b.firstRowNumber?b.firstRowNumber:1;this.Sqa=!b[ue]||b[ue]==BI}R=PHa[K];R.ah=null;R.oo=0;R.fF=null;R.Yw=-1;R.oB=!1;R.A5=null;function NR(a,b){0<=b&&b<a.JG&&(a.oo=b)}function QHa(a){for(var b=OR(a),c=[],d={},e=b[y];e<=b.end;e++){var f=PR(a,e);d[f.MH]=f.M4;c[B](f)}a.A5=d;return c}R.GS=function(){return{column:this.Yw,ascending:!this.oB,sortedIndexes:this.fF}};
function QR(a){return PR(a,OR(a)[y])}function RHa(a,b){a.A5||QHa(a);var c=a.A5[b];return null!=c?c:-1}function OR(a){var b=a.oz*a.oo,c=b+a.oz-1,c=h.min(a.ah.O()-1,c);return new Yn(b,c)}function PR(a,b){var c=a.fF,d=a.rsa,e=OR(a)[y];return new MR(c?c[b]:b,b,b-e,b+d)}function SHa(a){if(a.Sqa&&-1!=a.Yw){var b=a.ah.Ap([{column:a.Yw,desc:a.oB}]),c=a.ah.Cfa(),d=wj(b,function(a){return c[a]},a);a.ah.bn(d);a.fF=a.fF?wj(b,function(a){return this.fF[a]},a):b}else a.fF=null};function RR(a){nw[L](this,a);this.U=Fl();this.tc=new rx;this.Lm={}}W(RR,nw);
var THa={d8:"google-visualization-table-table",JN:"google-visualization-table-tr-head",tG:"google-visualization-table-tr-even",yN:"google-visualization-table-tr-odd",pu:"google-visualization-table-tr-sel",gy:"google-visualization-table-tr-over",RX:"google-visualization-table-th gradient",zBa:"google-visualization-table-th-webkit gradient",LW:"google-visualization-table-td",lja:"google-visualization-table-td-number",kja:"google-visualization-table-td-center",jja:"google-visualization-table-td-bool",
c8:"google-visualization-table-seq",oBa:"google-visualization-table-sorthdr",Wia:"google-visualization-table-sortind",dla:"google-visualization-table-div-page",Gja:"google-visualization-table-page-numbers",Fja:"page-number gradient"},UHa={JN:"headerRow",tG:"tableRow",yN:"oddTableRow",pu:"selectedTableRow",gy:"hoverTableRow",RX:"headerCell",LW:"tableCell",c8:"rowNumberCell"},VHa=up()+"/table/arrow_left.gif",WHa=up()+"/table/arrow_right.gif";R=RR[K];R.v$=!0;R.$P=null;R.up=null;R.XI=null;R.q=null;
R.ah=null;R.b=null;R.Ge=null;R.uG=null;R.uZ=null;R.tZ=null;R.VM=-1;R.bN=!1;R.JB=null;R.oH=null;R.nH=null;R.BX=0;R.H=null;
R.hl=function(a,b,c){a=c||{};if(!b)throw m(KL);this.tc[bc]();this.q=b;this.ah=new hw(this.q);this.b=a;this.bN=0<this.ah.O();this.Ge=new PHa(this.ah,this.b);this.bN&&(a.startPage&&NR(this.Ge,a.startPage),a[ue]!=KI&&null!=a.sortColumn&&(c=a.sortAscending,b=this.Ge,c=!(null!=c?c:1),b.Yw=a.sortColumn,b.oB=c,SHa(b)),this.XI=QR(this.Ge));this.BX=a.scrollLeftStartPosition||0;a=a.frozenColumns;a=null!=a?a:-1;-1>a&&(a=-1);this.VM=a;a=this.up=mk(THa);if(b=this.b.cssClassNames){b.headerCell&&(a.JN+=RM);if(b.tableCell||
b.rowNumberCell)a.tG+=RM,a.yN+=RM,a.pu+=RM,a.gy+=RM;for(var d in UHa)(c=b[UHa[d]])&&(a[d]=c)}d=!0;this.v$&&(d=XHa(this),this.v$=!1);this.Br();d?(am(this.$P),this.bu()):this.s$(0)};R.bu=function(){ew(this,Yt,null)};R.GS=function(){return this.Ge?this.Ge.GS():null};
R.Br=function(a){var b=this.b,c=[],d=this.U;a||(this.rH(),this.l9=an(this.ea));this.uG=null;this.H||(this.H=new Bx);var e=this.VM,f=-1<e;a=b[r]||(f?AM:M);var g=b[z]||(0<this.l9[z]?AM:M),k=this.Lm[Fb];k||(k=d.m(ch,{"class":sua,style:Bqa}),dy(this.Lm,k),d[q](this.ea,k));Bm(k,{visibility:sh,"max-height":AM});var l=this.JB=SR(this,jna,k,{Mia:!0,nya:e}),n=this.uZ=rm(d,fu,null,l)[0],p=rm(d,gD,null,rm(d,sD,null,n)[0])[0];Bm(l,{overflow:Mg,"max-width":AM,"max-height":AM});a&&(a=YHa(a||nH),Bm(k,{width:a}));
g&&(g=YHa(g||nH),Bm(k,{height:g}));var t=this.BX,u=0;b.keepScrollPosition&&this.JB&&(t=this.JB[Tc],u=this.JB[Ud]);var x=b[z]||M,x=x&&-1===x[qc]()[zd](Ve),A=this.bN&&1<this.Ge.JG,C=b.pagingButtonsConfiguration;(A=null!=C&&C!=Mg||A)&&b[oB]&&b[oB]!=KI&&(C=this.Lm[EF],C||(C=d.m(ch,this.up.dla),this.Lm[EF]=C,d=d.m(ch),Bm(d,{clear:Rg,width:AM}),this.Lm[cxa]=d),Yl(C),Bm(l,{height:void 0}),d=k[fd],ZHa(this,k),d-=C[fd],0<d&&(0<this.l9[z]||x)&&Bm(l,{height:d+P}));!b.rtlTable||A||a||g||$x(this.uZ[w],$h);g=n[be];
(x=l[re]<l[Wb])?(d=SR(this,FH,k,{Kia:!0,qX:!0}),c[B]({wZ:d,type:FH})):(d=this.Lm.header)&&Bm(d,bh,O);a&&l[be]>n[be]&&(Bm(n,yi,l[be]+P),g=n[be]);f&&(n=SR(this,TH,k,{Lia:!0,dO:!0}),this.tZ=n[Yb],c[B]({wZ:n,type:TH}),x?(n=SR(this,UH,k,{qX:!0,dO:!0}),c[B]({wZ:n,type:UH})):(n=this.Lm[UH])&&Bm(n,bh,O));n=0;f&&(b=e+(b.showRowNumber?1:0),e=p[cc],0<b&&e[J]>b&&(n=2+Km(e[b]).x,n=h.min(n,k[Gb])));for(b=0;b<c[J];b++)switch(e=c[b].wZ,f=e[Yb],a&&Bm(f,{width:g+P}),c[b][H]){case FH:Bm(e,{height:p[re]+P,width:l[be]+
P});break;case TH:Bm(e,{width:n+P,height:l[re]+P});break;case UH:Bm(e,{height:p[re]+P,width:n+P})}iz(l,u);l.scrollLeft=t;Bm(k,{visibility:M})};
function SR(a,b,c,d){for(var e=a.U,f=a.b,g=a.up,k=a.JB,l=a.ah,n=[],p=0;p<l.L();p++)n[B](l.G(p));for(var p=[],t=0;t<l.L();t++){var u=g.LW;switch(l.G(t)){case Qg:u+=Ke+g.jja;break;case Nh:u+=Ke+g.lja;break;case Xg:case $g:case ni:u+=Ke+g.kja}p[B](u)}l=!1;g=null;(t=a.Lm[b])?(l=!0,Bm(t,bh,M),g=rm(e,fu,null,t)[0],b=rm(e,gD,null,rm(e,sD,null,g)[0])[0],$Ha(a,b)):(t=Cqa,d.Mia&&(t=Bqa),t=a.U.m(ch,{style:t,name:b,"class":b}),a.Lm[b]=t,b=$Ha(a,null));var u=a.VM+(f.showRowNumber?1:0),x=b[cc];if(0<u&&x[J]>u&&
(qP(x[u-1],ZG),d.dO))for(var A=u;A<x[J];A++)TR(x[A]);u=d.dO?u:null;if(l)return aIa(a,g,b,f,p,n,u),t;g=aIa(a,null,b,f,p,n,u);(d.dO||d.qX)&&bIa(g);d.qX&&(f=rm(e,yD,null,g)[0],TR(f));e[q](t,g);e[q](c,t);d.Kia&&a.H.k(k,ME,Yi(cIa,k,t));d.Lia&&a.H.k(k,ME,Yi(dIa,k,t));return t}
function aIa(a,b,c,d,e,f,g){var k=a.ah,l=a.q,n=a.U,p=a.up;if(b)c=rm(n,yD,null,b)[0],Yl(c);else{b=n.m(fu,{"class":p.d8,cellspacing:pf});var t=n.m(sD);n[q](b,t);n[q](t,c);c=n.m(yD);n[q](b,c)}t=new Yp({fractionDigits:0,pattern:Oe});null==a.uG&&(a.uG=a.bN?QHa(a.Ge):[]);for(var u=a.uG,x=a.VM,A=!0,C=d.alternatingRowStyle,C=null!=C?C:!0,E=0;E<u[J];E++){var Q=u[E],N=Q.MH,S=l.$r(N,epa),T=[];C?T[B](A?p.tG:p.yN):T[B](p.tG);A=!A;vx(a.tc,N)&&(T[B](p.pu),Q.ro(!0));N=n.m(gD,{"class":T[Fe](Ke)});S&&Vy(N[w],S);a.H.k(N,
Tt,U(a.bX,a,Q));a.H.k(N,Vt,U(a.dX,a,Q));a.H.k(N,Ut,U(a.cX,a,Q));n[q](c,N);if(d.showRowNumber){var V=n.m(xD,{"class":p.LW+Ke+p.c8});n[q](N,V);n[q](V,n[Jb](t.Sc(Q.Eja)));0===x&&qP(V,ZG)}S=0;for(T=k.L();S<T;){var sa=Q.MH,V={};V[Qba]=l[Bd](sa,S,Rba)||e[S];var Ha=l[Bd](sa,S,$za);(Ha=Ha&&h.min(Ha,T-S))&&1<Ha?V.colSpan=Ha:Ha=1;V=n.m(xD,V);n[q](N,V);var Ka=l[I](sa,S),Ra=l.Ca(sa,S);null==Ka?Ra=cj(kj(Ra))?Di:Ra:f[S]==Qg&&(Ra=Ka?lma:kma);if(d.allowHtml)Xa(V,Ra),(sa=l[Bd](sa,S,ji))&&bb(V[w],sa);else n[q](V,n[Jb](Ra));
S===x-1&&qP(V,ZG);null!=g&&S>=g&&TR(V);S+=Ha}}return b}
function $Ha(a,b){var c=a.ah,d=a.b||{},e=a.up,f=d[ue]!=KI&&0<c.O(),g=U(function(a){a=a[cc];for(var b=[Uma,goa,hoa],c=this.Ge.Yw,d=0;d<a[J];d++){var e=a[d],g=e[xc];tP(e,b);f&&qP(e,b[c!==g?0:this.Ge.oB?1:2])}},a);if(b)return g(b),b;var k=a.U,l=c.L(),n=k.m(gD,{"class":e.JN}),p;d.showRowNumber&&0<c.L()&&(p=k.m(tD,{"class":e.RX}),k[q](n,p),Xa(p,FEa));for(var t=0;t<l;t++){p=k.m(tD,{"class":e.RX,index:t});k[q](n,p);var u=c.La(t);d.allowHtml?Xa(p,u):k[q](p,k[Jb](u));f&&k[q](p,k.m(du,{"class":e.Wia}));a.H.k(p,
vt,U(a.Xia,a,t),!0)}g(n);return n}
function ZHa(a,b){var c=a.b,d=a.U,e=a.up,f=null!=c.pagingSymbols?c.pagingSymbols:{},g=f.prev,f=f[yc],c=!!c.allowHtml,g=g?c?Tl(d.Ze,g):g:d.m(yh,{src:VHa,alt:tqa,style:Fta}),f=f?c?Tl(d.Ze,f):f:d.m(yh,{src:WHa,alt:vra,style:Fta});Lu(a.oH);Lu(a.nH);g=a.oH=new LR(g);f=a.nH=new LR(f);g.Iu(2);f.Iu(1);a.H.k(g,Gg,U(a.b8,a,!1));a.H.k(f,Gg,U(a.b8,a,!0));eIa(a);c=a.Lm[EF];d[q](b,c);d[q](b,a.Lm[cxa]);g.C(c);f.C(c);var k=d.m(ch,{"class":e.Gja});d[q](c,k);var l=U(function(a,b){var c=e.Fja;b&&(c+=Ke+b);c=d.m(Eg,
{href:Xsa,"class":c});Xa(c,String(a+1));this.H.k(c,vt,U(this.Y7,this,a));d[q](k,c)},a),g=a.Ge.JG,f=a.Ge.oo;X(fIa(0,f-1),function(a){l(a)});l(f,kwa);X(fIa(f+1,g-1),function(a){l(a)})}function fIa(a,b){var c=[];if(a+10>b)for(var d=a;d<=b;d++)c[B](d);else{d=a;c[B](d);var e=b;c[B](e);for(var f=10;d<e;)d=f*h[Cb]((d+2)/f)-1,d<e&&c[B](d),e=f*h[Eb](e/f)-1,d<e&&c[B](e),f*=10;Qj(c)}return c}R.b8=function(a){var b=this.Ge.JG,c=this.Ge.oo;a=a?h.min(b,c+1):h.max(0,c-1);this.Y7(a)};
R.Y7=function(a){this.b[oB]==BI&&(NR(this.Ge,a),gIa(this),this.Br(!0));eIa(this);ew(this,FF,{page:a})};function eIa(a){var b=a.b.pagingButtonsConfiguration||Mg,c=a.Ge.oo,d=a.nH,e=a.oH;d.Na(!0);e.Na(!0);switch(b){case uqa:d.Na(!1);break;case vra:e.Na(!1);break;case Rg:break;default:0==c&&e.Na(!1),c==a.Ge.JG-1&&d.Na(!1)}}function cIa(a,b){b.scrollLeft=a[Tc]}function dIa(a,b){iz(b,a[Ud])}
function XHa(a){var b=a.$P;if(!b){var c=a.ea,b=Ql(ch,{style:Dqa,"class":rua},ea[Jb](Di));c[q](b);a.$P=b}return cn(b)[G]==rM}R.s$=function(a){if(10>a)if(XHa(this))this[As](this.ah,this.b);else{var b=200*a;a++;Xx(U(this.s$,this,a),b)}else am(this.$P),this.bu()};Zq(R,function(){return this.tc[ss]()});
Eq(R,function(a){if(this.q){var b=this.tc[sr](a);a=this.uG;this.XI=QR(this.Ge);for(var c=UR(this),d=VR(this),e,f,g=this.up,k=tx(b.dC),l=0;l<k[J];l++)f=k[l],f=RHa(this.Ge,f),-1!=f&&(e=a[f],e.ro(!1),(e=c[f])&&sP(e,g.pu),(f=d&&d[f])&&sP(f,g.pu));b=tx(b.cC);for(l=0;l<b[J];l++)f=b[l],f=RHa(this.Ge,f),-1!=f&&(e=a[f],e.ro(!0),(e=c[f])&&qP(e,g.pu),(f=d&&d[f])&&qP(f,g.pu))}});
R.bX=function(a,b){var c,d=this.XI,e=a.MH;c=rl?b[ds]:b[ts];if(b[Bs]){b[hr]();var f=h.min(a.QU,d.QU),e=h.max(a.QU,d.QU);c=c?this.tc[ss]():[];for(var g=this.Ge,k=[];f<=e;f++){var l=PR(g,f);k[B](l)}for(e=0;e<k[J];e++)c[B]({row:k[e].MH})}else if(c)if(b[hr](),c=this.tc[ss](),vx(this.tc,e))k=new rx,k[sr](c),k.ey(e),c=k[ss]();else c[B]({row:e});else c=vx(this.tc,e)?null:[{row:e}];this[sr](c);this.XI=b[Bs]?d:a;ew(this,cu,{})};
R.dX=function(a){var b=UR(this),c=this.up;a=a.M4;(b=b[a])&&qP(b,c.gy);(b=(b=VR(this))&&b[a])&&qP(b,c.gy)};R.cX=function(a){var b=UR(this);a=a.M4;var c=this.up;(b=b[a])&&sP(b,c.gy);(b=(b=VR(this))&&b[a])&&sP(b,c.gy)};function UR(a){return rm(a.U,yD,null,a.uZ)[0][cc]}function VR(a){return a.tZ?rm(a.U,yD,null,a.tZ)[0][cc]:null}
R.Xia=function(a){var b=this.Ge,c=!b.oB,c=b.Yw==a?!c:!0;this.b[ue]!=xI?(b.Yw=a,b.oB=!c,SHa(b),NR(this.Ge,0),this.XI=QR(this.Ge),gIa(this),this.Br(!0),ew(this,XD,this.Ge.GS())):ew(this,XD,{column:a,ascending:c,sortedIndexes:null})};function gIa(a){var b=a.JB;b&&(a.BX=b[Tc])}R.rH=function(){Lu(this.H);this.H=null;this.U.Oc(this.ea);Lu(this.oH);this.oH=null;Lu(this.nH);this.nH=null;this.Lm={}};R.ic=function(){this.rH();this.tc[bc]();this.Ge=null};
function YHa(a){if(cj(kj(a)))return a;var b=a;dj(a)&&String(a)!==pf&&(b+=P);return b}function TR(a){qP(a,tua);bIa(a)}function bIa(a){qP(a,ol&&7>tl?bna:oi)};function hIa(){var a=[0,10,1,2,1,18,95,33,13,1,594,112,275,7,263,45,1,1,1,2,1,2,1,1,56,5,11,11,48,21,16,1,101,7,1,1,6,2,2,1,4,33,1,1,1,30,27,91,11,58,9,34,4,1,9,1,3,1,5,43,3,136,31,1,17,37,1,1,1,1,3,8,4,1,2,1,7,8,2,2,21,8,1,2,17,39,1,1,1,2,6,6,1,9,5,4,2,2,12,2,15,2,1,17,39,2,3,12,4,8,6,17,2,3,14,1,17,39,1,1,3,8,4,1,20,2,29,1,2,17,39,1,1,2,1,6,6,9,6,4,2,2,13,1,16,1,18,41,1,1,1,12,1,9,1,41,3,17,37,4,3,5,7,8,3,2,8,2,30,2,17,39,1,1,1,1,2,1,3,1,5,1,8,9,1,3,2,30,2,17,38,3,1,2,5,7,1,9,1,10,2,30,2,22,48,
5,1,2,6,7,19,2,13,46,2,1,1,1,6,1,12,8,50,46,2,1,1,1,9,11,6,14,2,58,2,27,1,1,1,1,1,4,2,49,14,1,4,1,1,2,5,48,9,1,57,33,12,4,1,6,1,2,2,2,1,16,2,4,2,2,4,3,1,3,2,7,3,4,13,1,1,1,2,6,1,1,14,1,98,96,72,88,349,3,931,15,2,1,14,15,2,1,14,15,2,15,15,14,35,17,2,1,7,8,1,2,9,1,1,9,1,45,3,155,1,87,31,3,4,2,9,1,6,3,20,19,29,44,9,3,2,1,69,23,2,3,4,45,6,2,1,1,1,8,1,1,1,2,8,6,13,128,4,1,14,33,1,1,5,1,1,5,1,1,1,7,31,9,12,2,1,7,23,1,4,2,2,2,2,2,11,3,2,36,2,1,1,2,3,1,1,3,2,12,36,8,8,2,2,21,3,128,3,1,13,1,7,4,1,4,2,1,203,
64,523,1,2,2,24,7,49,16,96,33,3070,3,141,1,96,32,554,6,105,2,30164,4,1,10,33,1,80,2,272,1,3,1,4,1,23,2,2,1,24,30,4,4,3,8,1,1,13,2,16,34,16,1,27,18,24,24,4,8,2,23,11,1,1,12,32,3,1,5,3,3,36,1,2,4,2,1,3,1,69,35,6,2,2,2,2,12,1,8,1,1,18,16,1,3,6,1,5,48,1,1,3,2,2,5,2,1,1,32,9,1,2,2,5,1,1,201,14,2,1,1,9,8,2,1,2,1,2,1,1,1,18,11184,27,49,1028,1024,6942,1,737,16,16,7,216,1,158,2,89,3,513,1,2051,15,40,7,1,1472,1,1,1,53,14,1,57,2,1,45,3,4,2,1,1,2,1,66,3,36,5,1,6,2,75,2,1,48,3,9,1,1,1258,1,1,1,2,6,1,1,22681,62,
4,25042,1,1,3,3,1,5,8,8,2,7,30,4,148,3,8097,26,790017,255],b=[1,13,1,12,1,0,1,0,1,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,1,0,2,0,2,0,2,0,2,1,0,2,0,2,0,2,0,1,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,4,0,5,2,4,2,0,4,2,4,6,4,0,2,5,0,2,0,5,2,4,0,5,2,0,2,4,2,4,6,0,2,5,0,2,0,5,0,2,4,0,5,2,4,2,6,2,5,0,2,0,2,4,0,5,2,0,4,2,4,6,0,2,0,2,4,0,5,2,0,2,4,2,4,6,2,5,0,2,0,5,0,2,0,5,2,4,2,4,6,0,2,0,4,0,5,0,2,4,2,6,2,5,0,2,0,4,0,5,2,0,4,2,4,2,4,2,4,2,6,2,5,0,2,0,4,0,5,0,2,4,2,4,6,0,2,0,2,0,4,0,5,6,2,4,2,4,2,4,0,5,0,2,0,4,2,6,
0,2,0,5,0,2,0,4,2,0,2,0,5,0,2,0,2,0,2,0,2,0,4,5,2,4,2,6,0,2,0,2,0,2,0,5,0,2,4,2,0,6,4,2,5,0,5,0,4,2,5,2,5,0,5,0,5,2,5,2,0,4,2,0,2,5,0,2,0,7,8,9,0,2,0,5,2,6,0,5,2,6,0,5,2,0,5,2,5,0,2,4,2,4,2,4,2,6,2,0,2,0,2,0,2,0,5,2,4,2,4,2,4,2,0,5,0,5,0,4,0,4,0,5,2,4,0,5,0,5,4,2,4,2,6,0,2,0,2,4,2,0,2,4,0,5,2,4,2,4,2,4,2,4,6,5,0,2,0,2,4,0,5,4,2,4,2,6,4,5,0,5,0,5,0,2,4,2,4,2,4,2,6,0,5,4,2,4,2,0,5,0,2,0,2,4,2,0,2,0,4,2,0,2,0,1,2,1,0,1,0,1,0,2,0,2,0,6,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,6,5,2,5,4,2,4,0,5,0,5,0,5,0,5,0,
4,0,5,4,6,0,2,0,5,0,2,0,5,2,4,6,0,7,2,4,0,5,0,5,2,4,2,4,2,4,6,0,5,2,4,2,4,2,0,2,0,2,4,0,5,0,5,0,5,0,5,2,0,2,0,2,0,2,0,2,0,5,4,2,4,0,4,6,0,5,0,5,0,5,0,4,2,4,2,4,0,4,6,0,11,8,9,0,2,0,2,0,2,0,2,0,1,0,2,0,1,0,2,0,2,0,2,6,0,4,2,4,0,2,6,0,2,4,0,4,2,4,6,2,0,1,0,2,0,2,4,2,6,0,2,4,0,4,2,4,6,0,2,4,2,4,2,6,2,0,4,2,0,2,4,2,0,4,2,1,2,0,2,0,2,0,2,0,14,0,1,2];this.sha=null;if(a[J]!=b[J])return null;this.sha=a;for(var c=1;c<a[J];c++)null==a[c]?a[c]=a[c-1]+1:a[c]+=a[c-1];jy(this,b)};var WR=null;function iIa(a){if(44032<=a&&55203>=a)return 16==a%28?10:11;WR||(WR=new hIa);for(var b=WR,c=b.sha,d=0,e=c[J];8<e-d;){var f=e+d>>1;c[f]<=a?d=f:e=f}for(;d<e&&!(a<c[d]);++d);a=d-1;return 0>a?null:b[kA][a]};h.pow(1024,-3);h.pow(1024,-2);h.pow(1024,2);h.pow(1024,3);h.pow(1024,4);h.pow(1024,5);ol&&ul(8);function jIa(a){this.bwa=typeof a==Nh?0<a?1:0>a?-1:null:null==a?null:a?-1:1}jIa[K].cwa=oea;var XR={},kIa={},YR={};function ZR(){throw m("Do not instantiate directly");}ZR[K].eM=null;fz(ZR[K],function(){return this[Fb]});Aa(ZR[K],function(){return this[Fb]});function $R(a,b,c,d){Xa(a,aS(b(c||bS,void 0,d)))}function cS(a,b,c,d){d=(d||Fl())[Vb](ML);a=aS(a(b||bS,void 0,c));Xa(d,a);return 1==d[cc][J]&&(a=d[Yb],1==a[rd])?a:d}function aS(a){if(!Ri(a))return String(a);if(a instanceof ZR){if(a.Et===XR)return a[SB]();if(a.Et===YR)return fj(a[SB]())}return EC}var bS={};function lIa(a){if(null!=a)switch(a.eM){case 1:return 1;case -1:return-1;case 0:return 0}return null}function dS(){ZR[L](this)}W(dS,ZR);dS[K].Et=XR;function Z(a){return null!=a&&a.Et===XR?a:a instanceof zk?eS(Ak(a),a.ow()):eS(fj(String(String(a))),lIa(a))}function fS(a,b){dy(this,String(a));this.eM=null!=b?b:null}W(fS,ZR);fS[K].Et=YR;var eS=function(a){function b(a){dy(this,a)}ob(b,a[K]);return function(a,d){var e=new b(String(a));void 0!==d&&(e.eM=d);return e}}(dS);
function gS(a,b){var c=new Gl(void 0)||Fl(),d=aS(a(b||bS,void 0,void 0));return Tl(c.Ze,d)}function hS(a,b){function c(){}ob(c,a);var d=new c,e;for(e in b)d[e]=b[e];return d}var iS=function(a){function b(a){dy(this,a)}ob(b,a[K]);return function(a,d){var e=String(a);if(!e)return M;e=new b(e);void 0!==d&&(e.eM=d);return e}}(dS);function jS(a){null!=a&&a.Et===XR?(a=a[SB](),a=String(a)[Ab](mIa,M)[Ab](nIa,af),a=String(a)[Ab](oIa,pIa)):a=fj(String(a));return a}
function kS(a){null!=a&&a.Et===kIa?a=a[SB]()[Ab](/([^"'\s])$/,KEa):(a=String(a),a=qIa[od](a)?a:EC);return a}function lS(a){return null!=a&&a.Et===YR?(a[SB](),EC):a}var rIa={"\x00":Xe,"\t":"&#9;","\n":"&#10;","\x0B":"&#11;","\f":"&#12;","\r":"&#13;"," ":"&#32;",'"':bf,"&":Ze,"'":Ye,"-":"&#45;","/":"&#47;","<":af,"=":"&#61;",">":$e,"`":"&#96;","\u0085":"&#133;","\u00a0":"&#160;","\u2028":"&#8232;","\u2029":"&#8233;"};function pIa(a){return rIa[a]}
var oIa=/[\x00\x22\x27\x3c\x3e]/g,qIa=/^(?!style|on|action|archive|background|cite|classid|codebase|data|dsync|href|longdesc|src|usemap)(?:[a-z0-9_$:-]*)$/i,mIa=/<(?:!|\/?([a-zA-Z][a-zA-Z0-9:\-]*))(?:[^>'"]|"[^"]*"|'[^']*')*>/g,nIa=/</g;function mS(a,b){if(a instanceof mS)this.Hd=a.LD();else{var c;if(c=Pi(a))t:{for(var d=c=0;d<a[J];d++){if(!Pi(a[d])||0<c&&a[d][J]!=c){c=!1;break t}for(var e=0;e<a[d][J];e++)if(!Ui(a[d][e])){c=!1;break t}0==c&&(c=a[d][J])}c=0!=c}if(c)this.Hd=Lj(a);else if(a instanceof Cl)this.Hd=sIa(a[z],a[r]);else if(Ui(a)&&Ui(b)&&0<a&&0<b)this.Hd=sIa(a,b);else throw m("Invalid argument(s) for Matrix contructor");}this.ja=new Cl(this.Hd[0][J],this.Hd[J])}
function nS(a,b,c){for(var d=0;d<a.Tb()[z];d++)for(var e=0;e<a.Tb()[r];e++)b[L](c,a.Hd[d][e],d,e,a)}function oS(a,b){var c=new mS(a.Tb());nS(a,function(d,e,f){c.Hd[e][f]=b[L](void 0,d,e,f,a)});return c}function sIa(a,b){for(var c=[],d=0;d<a;d++){c[d]=[];for(var e=0;e<b;e++)c[d][e]=0}return c}R=mS[K];R.add=function(a){if(!Dl(this.ja,a.Tb()))throw m("Matrix summation is only supported on arrays of equal size");return oS(this,function(b,c,d){return b+a.Hd[c][d]})};
function tIa(a,b){if(a.ja[z]!=b.Tb()[z])throw m("The given matrix has height "+b.ja[z]+", but  needs to have height "+a.ja[z]+mf);var c=new mS(a.ja[z],a.ja[r]+b.ja[r]);nS(a,function(a,b,f){c.Hd[b][f]=a});nS(b,function(a,b,f){c.Hd[b][this.ja[r]+f]=a},a);return c}ab(R,function(a,b){if(this.ja[r]!=a.ja[r]||this.ja[z]!=a.ja[z])return!1;for(var c=b||0,d=0;d<this.ja[z];d++)for(var e=0;e<this.ja[r];e++)if(!(h.abs(this.Hd[d][e]-a.Hd[d][e])<=(c||1E-6)))return!1;return!0});
R.xpa=function(){if(this.ja[r]!=this.ja[z])throw m("An inverse can only be taken on a square matrix.");if(1==this.Tb()[r]){var a=pS(this,0,0);return 0==a?null:new mS([[1/a]])}for(var a=this.ja[z],b=[],c=0;c<a;c++){b[c]=[];for(var d=0;d<a;d++)b[c][d]=c==d?1:0}a=new mS(b);b=uIa(tIa(this,a));return vIa(b,0,a.ja[r]-1,a.ja[z]-1)[gs](a)?vIa(b,a.ja[r]):null};
function uIa(a){for(var b=new mS(a),c=0,d=0;d<b.ja[z]&&!(c>=b.ja[r]);d++){for(var e=d;0==b.Hd[e][c];)if(e++,e==b.ja[z]&&(e=d,c++,c==b.ja[r]))return b;var f=a,g=d,k=f.Hd[e];f.Hd[e]=f.Hd[g];f.Hd[g]=k;e=b.Hd[d][c];for(f=c;f<b.ja[r];f++)b.Hd[d][f]/=e;for(e=0;e<b.ja[z];e++)if(e!=d)for(g=b.Hd[e][c],f=c;f<b.ja[r];f++)b.Hd[e][f]-=g*b.Hd[d][f];c++}return b}R.Tb=function(){return this.ja};function qS(a){var b=new mS(a.ja[r],a.ja[z]);nS(a,function(a,d,e){b.Hd[e][d]=a});return b}
function pS(a,b,c){return 0<=b&&b<a.ja[z]&&0<=c&&c<a.ja[r]?a.Hd[b][c]:null}R.multiply=function(a){if(a instanceof mS){if(this.ja[r]!=a.Tb()[z])throw m("Invalid matrices for multiplication. Second matrix should have the same number of rows as the first has columns.");return wIa(this,a)}if(Ui(a))return xIa(this,a);throw m("A matrix can only be multiplied by a number or another matrix.");};
R.E5=function(a){if(!Dl(this.ja,a.Tb()))throw m("Matrix subtraction is only supported on arrays of equal size.");return oS(this,function(b,c,d){return b-a.Hd[c][d]})};R.LD=function(){return this.Hd};function vIa(a,b,c,d){var e=new mS((c?c:a.ja[z]-1)-0+1,(d?d:a.ja[r]-1)-b+1);nS(e,function(a,c,d){e.Hd[c][d]=this.Hd[0+c][b+d]},a);return e}
function wIa(a,b){var c=new mS(a.ja[z],b.Tb()[r]);nS(c,function(a,e,f){for(var g=a=0;g<this.ja[r];g++)a+=pS(this,e,g)*pS(b,g,f);if(!(0<=e&&e<c.ja[z]&&0<=f&&f<c.ja[r]))throw m("Index out of bounds when setting matrix value, ("+e+jf+f+") in size ("+c.ja[z]+jf+c.ja[r]+ef);c.Hd[e][f]=a},a);return c}function xIa(a,b){return oS(a,function(a){return a*b})};function yIa(a){return a}function rS(a){if(void 0===a)return yIa;if(typeof a==kh)return a;if(typeof a==ii)return function(b){return b[a]};throw"Bad type for verbal.evaluator: "+a;}function sS(a,b){var c=a[qd](0);Qj(c,b);return c}function tS(a,b){var c=rS(b);return xj(a,function(a,b){return a+c(b)},0)}function uS(a,b){return tS(a,b)/a[J]}function zIa(a){var b=sS(a);return[0,.25,.5,.75,1].map(function(a){a*=b[J]-1;return(b[h[Eb](a)]+b[h[Cb](a)])/2})}function vS(a,b){return h[Kd](wS(a,b))}
function wS(a,b){var c=rS(b),d=uS(a,function(a){a=c(a);return a*a}),e=uS(a,c);return h.max(d-e*e,0)}function AIa(a){var b=uS(a);return uS(a.map(function(a){return h.pow(a-b,3)}))/h.pow(wS(a),1.5)}function xS(a,b){var c=rS(b),d=null;X(a,function(a){a=c(a);d>=a||(d=a)});return d}function yS(a,b){var c=rS(b);return c(zS(a,function(a){return-c(a)}))}function zS(a,b){var c=rS(b),d,e;X(a,function(a){var b=c(a);d>=b||(d=b,e=a)});return e}
function AS(a,b){var c=rS(b);return zS(a,function(a){return-c(a)})}var BIa=1/h[Kd](2*h.PI);function CIa(a,b,c){if(0>c)throw"Bad normal distribution: sigma = "+c+mf;if(0==c)return a==b?da:0;a=(a-b)/c;return BIa*h.exp(-.5*a*a)/c}
function BS(a,b,c){b=b||0;c=c||1;if(0==c)return a>=b?1:0;if(0!=b||1!=c)return BS((a-b)/c);if(0<a)return 1-BS(-a);var d=h.abs(a);a=h.exp(-d*d/2);c=[.65,4,3,2,1];if(37<d)return 0;if(7.07106781186547<=d){var e=1;c[Zb](function(a){e=d+a/e});return a/e/2.506628274631}var f=0,g=0;[.0352624965998911,.700383064443688,6.37396220353165,33.912866078383,112.079291497871,221.213596169931,220.206867912376][Zb](function(a){f=f*d+a});[.0883883476483184,1.75566716318264,16.064177579207,86.7807322029461,296.564248779674,
637.333633378831,793.826512519948,440.413735824752][Zb](function(a){g=g*d+a});return a*f/g}function CS(a){var b={};a[Zb](function(a){b[a]=kk(b,a,0)+1});return b}function DS(a){return(new hl(a)).Qa()}function DIa(a){var b=CS(a),c=xS(ek(b));return fk(b)[sb](function(a){return b[a]==c}).map(function(b){return typeof a[0]==Nh?+b:b})}function ES(a){this.ca=a||{};this.Vg=this.uf=0;gb(this,eCa)}function FS(a,b){Zj(b,function(a,b){lk(this.ca,b,a)},a)};var EIa=h.log(10),GS={100:"#c6dafc",500:"#5e97f6",800:"#2a56c6"},HS={100:"#f4c7c3",500:"#db4437",900:"#a52714"},IS={100:"#fce8b2",600:"#f2a600",700:"#f09300",800:"#ee8100"},JS={100:"#b7e1cd",500:"#0f9d58",700:"#0b8043"},KS={100:"#e1bee7",400:"#ab47bc",800:"#6a1b9a"},LS={100:"#b2ebf2",600:"#00acc1",800:"#00838f"},MS={100:"#ffccbc",400:"#ff7043",700:"#e64a19"},NS={100:"#f0f4c3",800:"#9e9d24",900:"#827717"},OS={100:"#c5cae9",400:"#5c6bc0",600:"#3949ab"},PS={100:"#f8bbd0",200:"#f48fb1",300:"#f06292",
500:"#e91e63",700:"#c2185b",900:"#880e4f"},QS={100:"#b2dfdb",700:"#00796b",900:"#004d40"};function RS(a){return a[Fe](Oe)}var FIa=["minorgridline",Xta,Hg,QD,qt,Vqa,IK,kH,OG,jK,oK,XK,qF,uF,qD,uya,"axistitle",eK,VK,XG,RG,SG,Kwa,wu,Gg];function SS(a,b,c,d){return{html:GIa(a),iga:!1,jga:d,anchor:c,hga:b,JC:20,margin:5}}function GIa(a){if(0==a[jC][J])return{name:ch,content:[],properties:{className:QH}};var b=Bj(a[jC],function(a){return a[H]==IE}),c;-1==b?c=HIa(a[jC]):(c=HIa(Nj(a[jC],0,b)),a=IIa(Nj(a[jC],b+1)),c=Kj(c,{name:ch,properties:{className:jua}},a));return{name:ch,content:c,properties:{className:QH}}}
function HIa(a){return{name:eD,properties:{className:kua},content:wj(a,function(a){return{name:PG,content:JIa(a[Y]),properties:{className:lua}}})}}function IIa(a){return{name:eD,properties:{className:mua},content:wj(a,function(a){return{name:PG,id:RS([Gg,a[Y].id]),content:JIa(a[Y]),properties:{className:nua}}})}}
function JIa(a){return wj(a[uA],function(a,c){switch(a[H]){case hu:var d=a[Y][w],e=qN;try{e=sn(d[F]).sc}catch(f){}return{name:du,style:Lua+d.$a+JCa+e+GCa+(d.Tc?hH:O)+DCa+(d.Re?dD:O)+ICa+(d[Xd]?xK:O)+zf,Goa:!!a[AA],content:(0==c?M:Ke)+a[Y][pd]};case WD:return{name:ch,style:Og+(a[Y].brush&&a[Y].brush.fb())+zf,properties:{className:iua}}}})};function TS(a,b,c,d,e,f,g,k,l){var n={items:[]};null!=e&&(e=so(e,f),n[uA][B]({type:WD,data:{size:b[Gc]/2,brush:e}}));null!=g&&n[uA][B](US(g,b));if(null!=c&&c!==M){if(null==d)throw m("Line title is specified without a text style.");c=US(c+xf,d);n[uA][B](c)}c=US(a,b,k);n[uA][B](c);null!=l&&(n.id=l,pz(n,{brush:ro}));return{type:OG,data:n}}function KIa(){return{type:IE,data:{brush:to(ZM,1)}}}function US(a,b,c){a={type:hu,data:{text:a,style:b}};c&&(a.html=!0);return a}
function VS(a,b,c,d,e,f,g,k,l){if(k)return SS(a,e,d,f);for(var n=k=0;n<a[jC][J];n++){var p=a[jC][n];if(p[H]==OG)for(var p=p[Y],t=0;t<p[uA][J];t++){var u=p[uA][t];u[H]==hu&&(k=h.max(k,u[Y][w][Gc]))}}0==k&&(k=g||0);var x;g=k;for(t=n=p=0;t<a[jC][J];t++)switch(u=a[jC][t],u[H]){case OG:u=LIa(u[Y],b);n+=u[z]+(0<t?u.$v:0);p=h.max(p,u[r]);break;case IE:n+=1.5*g+u[Y].brush.Lb}p=h.max(p,2*g);p=h[D](p+2*g/1.618);g=h[D](n+2*g/1.618);x=new Cl(p,g);var n=Sk(d.x-f.x),p=Sk(d.y-f.y),A=null,A=c?new xl(d.x+n*k,d.y+
p*(k+x[z]/2)):new xl(d.x+n*x[r]/2,d.y+p*x[z]/2),t=A.x-x[r]/2,u=t+x[r],C=A.y-x[z]/2,E=C+x[z];g={};c&&(c=new xl(A.x,Nk(d.y,A.y,k/(k+x[z]/2))),A=new xl(Nk(A.x,d.x,-1),c.y),c.x=h[D](c.x),c.y=h[D](c.y),A.x=h[D](A.x),A.y=h[D](A.y),g.dk=1==n*p?[c,d,A]:[A,d,c]);g.ka=new um(h[D](C),h[D](u),h[D](E),h[D](t));d=e[G]+5;c=e[kd]-5;if(!(g.ka[G]>=d&&g.ka[kd]<=c)){n=nk(g);p=n.ka[G];$a(n.ka,Nk(f.x,n.ka[kd],-1));Ua(n.ka,Nk(f.x,p,-1));if(p=n.dk)t=p[0],p[0]=p[2],p[2]=t,p[0].x=Nk(f.x,p[0].x,-1),p[1].x=Nk(f.x,p[1].x,-1),
p[2].x=Nk(f.x,p[2].x,-1);n.ka[G]>=d&&n.ka[kd]<=c?(g.ka=n.ka,g.dk=n.dk):(g.dk&&(p=new Yn(d+4,c-4),t=new Yn(n.dk[0].x,n.dk[2].x),u=new Yn(g.dk[0].x,g.dk[2].x),!(p[y]<=u[y]&&p.end>=u.end)&&p[y]<=t[y]&&p.end>=t.end&&(g.ka=n.ka,g.dk=n.dk)),g.ka[kd]>c&&($a(g.ka,g.ka[G]-(g.ka[kd]-c)),Ua(g.ka,c)),g.ka[G]<d&&(Ua(g.ka,g.ka[kd]+(d-g.ka[G])),$a(g.ka,d)))}d=e.top+5;e=e[Uc]-5;if(!(g.ka.top>=d&&g.ka[Uc]<=e)){c=nk(g);n=c.ka.top;c.ka.top=Nk(f.y,c.ka[Uc],-1);Ma(c.ka,Nk(f.y,n,-1));if(n=c.dk)p=n[0],n[0]=n[2],n[2]=p,
n[0].y=Nk(f.y,n[0].y,-1),n[1].y=Nk(f.y,n[1].y,-1),n[2].y=Nk(f.y,n[2].y,-1);c.ka.top>=d&&c.ka[Uc]<=e?(g.ka=c.ka,g.dk=c.dk):(g.ka[Uc]>e&&(g.ka.top-=g.ka[Uc]-e,Ma(g.ka,e)),g.ka.top<d&&(Ma(g.ka,g.ka[Uc]+(d-g.ka.top)),g.ka.top=d),delete g.dk)}f=k;e={};k=f/1.618;k=new um(g.ka.top+k,g.ka[kd]-k,g.ka[Uc]-k,g.ka[G]+k);d=[];var Q=k.top,n=a[jC][J],N=!1;for(c=0;c<n;c++)if(a[jC][c].UK){N=!0;break}var S=[],p=[];for(c=0;c<n;c++)if(x=a[jC][c],x[H]===OG){var T=x[Y],t=[];p[B](t);E=0;for(A=T[uA][J];E<A;E++){var V=MIa(T[uA][E],
b);t[B](V);x.UK&&(E>S[J]-1?S[B](V[r]):S[E]=h.max(S[E],V[r]))}}t=[];u=[];C=0;if(N)for(c=0;c<n;c++)if(x=a[jC][c],x[H]==OG){N=[];u[B](N);var sa=0;if(x.UK)for(T=x[Y],E=0,A=T[uA][J];E<A;E++)V=p[C][E],x=S[E]-V[r],N[B](x),sa+=x;t[B](sa);C++}for(c=C=0;c<n;c++){x=a[jC][c];S={Ah:x,data:{}};switch(x[H]){case OG:T=x[Y];N=S[Y];sa=LIa(T,b);x.UK&&na(sa,sa[r]+t[C]);0<c&&(Q+=sa.$v);T[iC]&&pz(N,{ka:new um(Q-sa.$v/2,g.ka[kd],Q+sa[z]+sa.$v,g.ka[G])});for(var Ha=[],Ka=k[G],E=0,A=T[uA][J];E<A;E++){T={};V=p[C][E];x.UK&&
na(V,V[r]+u[C][E]);0<E&&(Ka+=V.eU);var Ra=Q+(sa[z]-V[z])/2;T.ka=new um(h[D](Ra),h[D](Ka+V[r]),h[D](Ra+V[z]),h[D](Ka));l&&(Ra=k[kd]-(T.ka[G]-k[G])-T.ka[G]-V[r],$a(T.ka,T.ka[G]+Ra),Ua(T.ka,T.ka[kd]+Ra));Ha[B](T);Ka+=V[r]}ny(N,Ha);Q+=sa[z];C++;break;case IE:E=x[Y],A=Q+f+E.brush.Lb/2,tz(S[Y],new mO(g.ka[G],A,g.ka[kd],A)),Q+=1.5*f+E.brush.Lb/2}d[B](S)}e.entries=d;e.Qaa=!!l;return{outline:g,PJ:e}}
function LIa(a,b){for(var c=0,d=0,e=0,f=0;f<a[uA][J];f++)var g=MIa(a[uA][f],b),c=c+(g[r]+(0<f?g.eU:0)),d=h.max(d,g[z]),e=h.max(e,g[z]/2+g.$v);return{width:c,height:d,$v:e-d/2}}function MIa(a,b){switch(a[H]){case hu:var c=a[Y][w];return{width:b?b(String(a[Y][pd]),c)[r]:0,height:c[Gc],$v:c[Gc]/3.236,eU:c[Gc]/3.236};case WD:var d=c=a[Y][EA];return{width:c,height:c,$v:d,eU:d};default:return d=c=a[Y][EA],{width:c,height:c,$v:d,eU:d}}};function WS(a){Ju[L](this);this.Vs=a;this.ct=da;this.cF=0;a=new rv(15);Ku(this,a);$u(a,iu,U(this.r4,this));this.dd=a}W(WS,Ju);function XS(a,b){var c=a.ct;a.ct=h.min(a.ct,b);Wk(a.ct)?Wk(c)||a.dd[y]():a.dd[qs]()}WS[K].r4=function(){var a=Zi();this.ct-=a-this.cF;this.cF=a;0>=this.ct&&(this.Vs(),this.ct=da,this.dd[qs]())};function NIa(){this.el=this.Fe=null}R=NIa[K];R.adoptText=function(a){this.Fe=a};R.first=function(){return this.el=0};R.current=function(){return this.el||0};Da(R,function(a){a=this.Co(a);return null==a?a:this.el=a});function YS(a,b){b.lastIndex=a.el;var c=b[xb](a.Fe);return!c||0>c[xc]?a.Fe[J]:c[xc]+c[0][J]}
R.Co=function(a){if(0===a)a=YS(this,/(\r\n|\n|\r)/g);else if(1===a)a=YS(this,/([`~!@#$%^&*()_+\-=\[\]\\{}|;\':",\.\/<>?]|[ \t\u2009\u200b]+)/g);else if(2===a)a=YS(this,/[\u00ad]/g);else if(3===a)t:{a=this.el+1;for(var b=this.Fe[J];a<b;a++){var c=this.Fe[se](a),d=iIa(this.Fe[se](a-1)),c=iIa(c);if(12==d&&13==c?0:1==d||12==d||13==d||1==c||12==c||13==c||(7!=d||7!=c&&8!=c&&10!=c&&11!=c)&&(10!=d&&8!=d||8!=c&&9!=c)&&(11!=d&&9!=d||9!=c)&&2!=c&&6!=c&&(6!=d||5!=c))break t}a=this.Fe[J]}else a=this.Fe[J];return a};function ZS(){this.Ft={}}ZS[K].add=function(a,b,c,d){null==b?this.Ft[a]=d?{Qz:d,Ie:c}:c:(a in this.Ft||(this.Ft[a]={}),this.Ft[a][b]=d?{Qz:d,Ie:c}:c)};function OIa(a,b){if(null==b)return ca[UB](a.Ft);var c=[],d;for(d in a.Ft){var e=a.Ft[d];if(typeof e===Nh)e===b&&c[B](d);else if(e.Qz)0<=e.Ie[zd](b)&&c[B](d);else for(var f in e){var g=e[f];if(typeof g===Nh)g===b&&c[B](d);else if(g.Qz)0<=g.Ie[zd](b)&&c[B](d);else throw"Unknown type";}}return c}
ZS[K].aM=function(a,b,c){if(!(a in this.Ft))throw"Error: unknown iterator type "+a;a=this.Ft[a];if(typeof a===Nh)return a;if(a.Qz)return a.Qz(c);if(b in a){a=a[b];if(typeof a===Nh)return a;if(a.Qz)return a.Qz(c)}return null};function PIa(a){this.nua=a;this.$L={};this.dV=new ZS;this.Ct={};this.Fe=this.el=null;this.aM(OG,Nh,0);this.aM(OG,O,[1,2],U(function(a){return this.Fe[a-1]===pma?2:1},this));this.aM(bK,null,3)}R=PIa[K];R.adoptText=function(a){this.Fe=a;for(var b in this.$L)this.$L[b][pC](a)};function $S(a,b){var c=a.$L[b];c||(c=a.$L[b]=new ba.Intl.v8BreakIterator(a.nua,{type:b}),null!=a.Fe&&c[pC](a.Fe),null!=a.el&&c[fA]());return c}R.aM=function(a,b,c,d){this.dV.add(a,b,c,d)};
function QIa(a,b,c){c[yc]();if(c[CB]()>=a.Fe[J])return!0;if(c[CB]()>a.el){var d=c.breakType();c=c[CB]();var e=a.dV.aM(b,d,c);if(null==e)throw m("Break type "+d+" in "+b+" iterator was classified as null.");e in a.Ct||(a.Ct[e]=[]);a.Ct[e][B](c)}return!1}function RIa(a,b){for(var c=a.Ct[b];c&&0<c[J]&&c[0]<=a.el;)c[wb]();for(var c=OIa(a.dV,b),d={},e=!1;!(e||a.Ct[b]&&0!==a.Ct[b][J]);)for(var e=!0,f=0,g=c[J];f<g;f++){var k=c[f],l=$S(a,k);d[k]||(e=!1,QIa(a,k,l)&&(d[k]=!0))}}
R.first=function(){for(var a=OIa(this.dV,void 0),b=0,c=a[J];b<c;b++)$S(this,a[b])[fA]();this.Ct={};return this.el=0};R.current=function(){return this.el||0};Da(R,function(a){RIa(this,a);a=this.Ct[a];if(null!=a&&0<a[J]){a=this.el=a[wb]();for(var b in this.$L)for(var c=$S(this,b);c[CB]()<=a;)QIa(this,b,c);return this.el}return this.Fe[J]});R.Co=function(a){RIa(this,a);a=this.Ct[a];return null!=a&&0<a[J]?a[0]:this.Fe[J]};function SIa(){this.Tua=ba.Intl&&!!ba.Intl.v8BreakIterator}Ki(SIa);function TIa(){var a=[dh];return SIa.ac().Tua?new PIa(a):new NIa};function aT(){this.ra=this.N=this.pT=this.aj=this.qT=this.Ef=0}R=aT[K];$a(R,function(){return this.Ef});R.top=function(){return this.aj};Ua(R,function(){return this.qT});Ma(R,function(){return this.pT});R.Zs=function(a){this.Ef=a;this.N=this.Ef+this.qT;return this};R.qn=function(a){this.aj=a;this.ra=this.aj+this.pT;return this};function bT(a,b){a.qT=b;a.N=a.Ef+a.qT;return a}function cT(a,b){a.pT=b;a.ra=a.aj+a.pT;return a}na(R,function(){return this.N});Ta(R,function(){return this.ra});function UIa(a,b,c,d,e,f,g,k,l){this.n=a;this.HQ=b;this.qd=c;this.Ef=d;this.aj=e;this.N=f;this.ra=g;this.CC=k;this.Rs=l}R=UIa[K];vq(R,function(){return this.Rs});R.property=function(a){return this.Rs[a]};xz(R,function(){return this.n});R.mH=function(){return this.HQ};$y(R,function(){return this.qd});$a(R,function(){return this.Ef});R.top=function(){return this.aj};na(R,function(){return this.N});Ta(R,function(){return this.ra});R.Ub=function(){return this.CC};
mz(R,function(){return new xm(this.Ef,this.aj,this.N,this.ra)});R.ka=function(){return new um(this.aj,this.Ef+this.N,this.aj+this.ra,this.Ef)};function VIa(a,b,c,d){(null==a||!Wk(a)||a>d)&&b>d&&(a=d);(null==a||!Wk(a)||a<c)&&b<c&&(a=c);return a}function WIa(a,b,c,d){d=null==d?mf:d;for(var e in a)if(a[Hc](e))if(a[e]instanceof ca&&!(a[e]instanceof ga))WIa(a[e],b[Hb](e),c,d);else{var f=b[Hb](e)[Fe](d);c[Hc](f)||(c[f]=a[e])}}function dT(a){var b={};WIa(a,[],b,void 0);return b}function XIa(a,b,c,d,e,f){var g=null;f=f?2:3;for(var k=0;k<=f;k++){var l=c.Co(k);if(null==g||l<g[tc])g={position:l,ZN:k};if(a(b(d,l))<=e)return k}return g&&g.ZN||f}
function YIa(a){return function(b,c){var d=ej(a[qd](b,c));d[d[J]-1]===pma&&(d=d[qd](0,d[J]-1)+lf);return d}}function eT(a,b){var c=null==b?a[J]:b;return 0<=c?ej(a[qd](0,c))+mma:"..."[qd](0,c)}
function ZIa(a,b,c,d){if(a(eT(b))<=c)return eT(b);var e=TIa();e[pC](b);e[fA]();var f=e[yc](3),g=a(b[qd](0,f))<=c;if(d&&!g||!d&&a(eT(b,f))>c)for(d=0;-3<=d&&!(b=eT(b,d),a(b)<=c);d--);else{for(;a(eT(b,e.Co(3)))<=c;)f=e[yc](3);if(d&&a(eT(b,f))>c)for(e=b[qd](0,f),d=0;-3<=d&&!(b=e+eT(b,d),a(b)<=c);d--);else b=eT(b,f)}return b}
var $Ia=Ao(function(a,b,c,d,e,f){if(b===M)return{I:[],ys:!1};var g=null==f||null==f.truncate?!0:f.truncate,k=null==f||null==f.Dda?!1:f.Dda;f=null==f||null==f.Bda?!1:f.Bda;var l=a;a=function(a){return l(a,c)[r]};var n=TIa();n[pC](b);n[fA]();for(var p=!1,t=YIa(b),u=!1,x=[],A=0;;){var C=XIa(a,t,n,A,d,f),E=n[yc](C);if(0!==C)for(;E<b[J]&&a(t(A,n.Co(C)))<=d;)E=n[yc](C);x[B](t(A,E));var Q=a(x[x[J]-1])<=d;if(E>=b[J]||x[J]>=e||!Q){(E<b[J]||!Q)&&g?(0!==C&&(x[x[J]-1]=t(A,n.Co(C))),u=!0):x[J]<e&&E<b[J]&&(p=!0);
break}A=E}u&&(x[x[J]-1]=ZIa(a,x[x[J]-1],d,k&&1===x[J]),p=!0);1===x[J]&&x[0]===M&&(x=[]);return{I:x,ys:p}},function(a,b){for(var c=[a],d=1,e=b[J];d<e;d++)c[B](b[d]);return Gn(c)});function fT(a,b,c,d,e,f){function g(b){return a(b,c)}e=null!=e?h[Eb](e):1;if(0==e)return{I:[],re:!1,Hr:0};b=$Ia(g,b,c,d,e,{truncate:!0,Dda:null!=f?f:!1,Bda:!0});return{I:b.I,re:b.ys,Hr:0<b.I[J]?h.max[Zc](null,wj(wj(b.I,g),function(a){return a[r]})):0}}function aJa(a){var b={background:eta,padding:xM,border:cDa};null!=a[Gc]&&(Fa(b,a[Gc]+P),b.margin=a[Gc]+P);null!=a.$a&&Ry(b,a.$a);return b};function gT(){this.Xo=this.z5=null}function bJa(a){var b=new gT;b.z5=a;return b}function cJa(a){var b=new gT;b.Xo=a;return b}function hT(a){if(null!=a.z5)return a.z5;throw m("AbstractRenderer not set");}gT[K].Ax=function(){if(null!=this.Xo)return this.Xo;throw m("RaBl not set");};function iT(a,b){this.Ng=a;this.yb=null!=b&&mk(b)||{}}function jT(a){return kT(new iT(zL),yL,a)}function lT(a,b){var c=kT(new iT(RL),WBa,a);null!=b&&kT(c,vL,b);return c}function mT(a,b){return kT(kT(new iT(SL),yL,b),WBa,a)}function nT(a){a=Jn(a);return new iT(a.Ng,a.yb)}Ia(iT[K],function(){return nT(this.qg())});ab(iT[K],function(a){if(!a||this.Ng!=a.Ng)return!1;var b=fk(this.yb);return b[J]!==fk(a.yb)[J]?!1:zj(wj(b,U(function(b){return this.yb[b]===a.yb[b]},this)),Kk)});
function dJa(a){var b={},c;for(c in a.yb)b[c]=a.yb[c];return b}function kT(a,b,c){a.yb[b]=c;return a}db(iT[K],function(){return this.Ng});iT[K].qg=function(){return Kn(this)};function eJa(a){db(this,a);pa(this,null)}function oT(a,b){Si(a)&&(a=new eJa(a));this.Oq=a;this.Kq=[];b&&this.Kq[B](b)}function fJa(){this.$s=[];this.at=[];this.lT=!1};function pT(){fy(this,new rx);this.Ei=this.Rn=this.rf=null}Ia(pT[K],function(){var a=new pT;fy(a,this[$z][Jc]());a.rf=this.rf?this.rf[Jc]():null;a.Rn=this.Rn?this.Rn[Jc]():null;a.Ei=this.Ei?this.Ei[Jc]():null;return a});ab(pT[K],function(a){return this[$z][gs](a[$z])&&(this.rf?this.rf[gs](a.rf):!a.rf)&&(this.Rn?this.Rn[gs](a.Rn):!a.Rn)&&(this.Ei?this.Ei[gs](a.Ei):!a.Ei)});function gJa(a){this.o=null;this.Fv=[];this.Lv=a}R=gJa[K];R.NK=function(a){if(this.o[gs](a))return{lT:!1,$s:[],at:[]};var b=this.Fv;a=this.Xk(a);return this.bL(a,b)};R.Xk=function(a){if(null==this.Lv)return[];var b=xj(this.Lv,function(b,d){Mj(b,d.Xk(a));return b},[],this);this.Fv=b;this.o=a[Jc]();return b};R.bL=function(a,b){var c=this.mw(a),d=this.mw(b),e=c.qm(d),c=d.qm(c),d=new fJa;d.$s=this.nw(e);d.at=this.nw(c);return d};R.mw=function(a){a=wj(a,function(a){return Kn(a)});return new hl(a)};
R.nw=function(a){a=a.Qa();return wj(a,function(a){a=Jn(a);a.Kq=wj(a.Kq,function(a){return new iT(a.Ng,a.yb)});return a})};function qT(a,b){this.Eqa=new hl(a);this.Gqa=new hl(b)};function rT(a){qT[L](this,a,[wH,vH])}W(rT,qT);rT[K].XK=function(a,b,c){if(b==wH){if(!a[gs](c.rf))return c.rf=a,!0}else if(null!=c.rf)return c.rf=null,!0;return!1};rT[K].Xk=function(a){return null!=a.rf?[new oT(ih,a.rf)]:[]};function hJa(){};function sT(a,b,c,d,e){this.FD=a;this.J=b;this.je=bJa(b);this.bv=c;this.Ls=null;this.Sy=iJa;this.Hs=d;this.kT=e;this.Ro=null}W(sT,hJa);R=sT[K];br(R,function(a){this.Ls={};var b=this.J;b[bc]();this.Ro=this.FD.Sq(a,this.bv);a=this.Ro.Tb();a=b.xm(a[r],a[z]);for(var c=0;c<this.Sy[J];c++){var d=this.Sy[c],e=b.Ba();b[q](a,e);this.Ls[d]=e}this.Ro[As](this);this.S1(a)});R.mz=function(a){this.Sy=a};my(R,function(a){this.lM(a.at,!1);this.lM(a.$s,!0);this.Ro[As](this)});
R.lM=function(a,b){for(var c=0;c<a[J];c++)for(var d=a[c],e=d.Kq,f=0;f<e[J];f++)this.Ro.Fn(e[f],d.Oq,b)};R.S1=function(a){var b=this.J;b.fc(a,kJ,Nu);b.fc(a,Vt,this.kT(U(this[rr],this,wH)));b.fc(a,Ut,this.kT(U(this[rr],this,vH)));b.fc(a,vt,this.kT(U(this[rr],this,vt)))};Dq(R,function(a,b){b[Er]&&b[Er]();var c=this.J.sv(b[ys]);c!=Dg&&(c=nT(c),this.Hs(c,a))});R.Wa=function(){return this.je};R.Ce=function(a,b,c,d){null!=b?this.x5(a,b):this.to(a,c,d)};
R.to=function(a,b,c){this.J[q](this.Ls[c],a);this.J.qo(a,b.qg())};R.x5=function(a,b){gm(b)[rB](a,b);var c=this.J.sv(b);this.J.qo(a,c)};R.Wf=function(a){this.J.Wf(a)};var iJa=[MK,UE,VE,jL,kL];function tT(a){this.Dz=a;this.o=null}tT[K].ed=function(a){this.o=a[Jc]()};
tT[K].Fw=function(a){var b=this.o;a[$z][gs](b[$z])||this[ir](cu,null);null===a.Ei||a.Ei[gs](b.Ei)||this[ir](cu,null);var c=a.rf,d=b.rf,e=c;if(!c&&d||c&&!c[gs](d)){var b=OF,f={};if(!d)f.row=c.yb.ROW_INDEX,f.column=c.yb.COLUMN_INDEX;else if(!c)b=PF,f.row=d.yb.ROW_INDEX,f.column=d.yb.COLUMN_INDEX,e=d;else if(d[H]()!==c[H]()||d.yb.ROW_INDEX!==c.yb.ROW_INDEX||d.yb.COLUMN_INDEX!==c.yb.COLUMN_INDEX)f.row=c.yb.ROW_INDEX,f.column=c.yb.COLUMN_INDEX;e&&(c=e.yb.DATE,null!=c&&(f.date=c));this[ir](b,f)}this.o=
a[Jc]()};wq(tT[K],function(a,b){ew(this.Dz,a,b)});function uT(a,b){Ju[L](this);this.o=null;this.Lv=b;this.bb=new WS(a);Ku(this,this.bb)}W(uT,Ju);uT[K].ed=function(a){this.o=a};uT[K].MJ=function(){return U(this[rr],this)};Dq(uT[K],function(a,b){if(null!=this.Lv){var c=!1;X(this.Lv,function(d){d.Eqa[Yc](a[H]())&&d.Gqa[Yc](b)&&(d=d.XK(a,b,this.o),c=c||d)},this);c&&XS(this.bb,50)}});function vT(a,b,c,d,e,f){Ju[L](this);this.FD=a;Lq(this,null);this.gL=null;a=this.FD.Dt(e);this.nea=new gJa(a);e=f(U(this.ki,this,!0));this.Hs=new uT(e,a);Ku(this,this.Hs);this.mea=this.FD.it(b,c,this.Hs.MJ(),f);this.M3=new tT(d)}W(vT,Ju);br(vT[K],function(a,b){Lq(this,b[Jc]());this.Hs.ed(this[Lr]);this.M3.ed(this[Lr]);var c=this.nea.Xk(this[Lr]);this.mea[As](a,c);this.gL=this[Lr][Jc]();this.M3[ir](Yt,null)});
vT[K].ki=function(a){var b=this.nea.NK(this[Lr]);this.mea.refresh(b);this.gL=this[Lr][Jc]();a&&this.M3.Fw(this[Lr])};Eq(vT[K],function(a){this.ki(!0);this[Lr][$z][sr](a);this.ki(!1)});Zq(vT[K],function(){if(null==this.gL.Ei)return this.gL[$z][ss]();var a=this.gL.Ei,b={};null!=a.yb.DATE&&(b.date=a.yb.DATE);null!=a.yb.ROW_INDEX&&(b.row=a.yb.ROW_INDEX);return[b]});function wT(a){nw[L](this,a)}W(wT,nw);wT[K].Dt=function(){return null};wT[K].Ag=function(){Lu(this.Pd);this.Pd=null};Eq(wT[K],function(a){this.Pd&&this.Pd[sr](a)});Zq(wT[K],function(){return this.Pd?this.Pd[ss]():[]});function xT(a,b,c){var d=null!=c?wj(c,function(a){return[a,0]}):b?jJa:kJa,e=d[J];this.Oh=[];c=1+h[Eb]((a-1)/e);for(var f=h[Cb](a/c),g=[],k=0;k<e;k++)d[k][1]<f&&g[B](d[k][0]);for(k=0;k<a;k++){var d=g[b?k%f:h[Eb](k/c)],l=h.pow(b?.7:.85,b?h[Eb](k/f):k%c);this.Oh[k]=wj(d,function(a){return~~(l*a+255*(1-l))})}}
var kJa=[[[66,133,244],0],[[219,68,55],0],[[244,180,0],0],[[15,157,88],0],[[171,71,188],0],[[0,172,193],0],[[255,112,67],0],[[158,157,36],0],[[92,107,192],0],[[240,98,146],0],[[0,121,107],0],[[194,24,91],0]],jJa=[[[67,69,157],6],[[83,168,251],8],[[95,150,84],10],[[241,202,58],2],[[231,113,27],5],[[135,27,71],4],[[67,116,224],0],[[26,135,99],1],[[185,194,70],9],[[228,147,7],7],[[211,54,45],3]];xT[K].Tb=function(){return this.Oh[J]};xT[K].ge=function(a){return jpa+this.Oh[a]+ef};
function yT(a,b){function c(a){a=a[qc](16);1==a[J]&&(a=pf+a);return a}var d=a.Oh[b];return Oe+(c(d[0])+c(d[1])+c(d[2]))[De]()};function lJa(a){for(var b=Dk(sD,{},mJa(a,nJa)),c=[],d=a.O(),e=0;e<d;++e)c[B](mJa(a,function(a,b){var c=a.Ca(e,b);return Dk(xD,{},c)}));a=Dk(yD,{},Ek(c));return Dk(fu,{},Ek(b,a))}function mJa(a,b){for(var c=[],d=a.L(),e=0;e<d;++e)a.fu(e)===M&&c[B](b(a,e));c=Ek(c);return Dk(gD,{},c)}function nJa(a,b){var c=a.La(b)||a.Ee(b);return Dk(tD,{},c)};function zT(a){nw[L](this,a);this.vi=null}W(zT,wT);R=zT[K];R.it=function(a,b,c,d){if(null==b)throw m("Internal error: missing overlayArea");a=hT(a);return new sT(this,a,b,c,d)};R.hl=function(a,b,c){Hu.nc(this.ea);c=c||{};var d=this.mh()||{};c=new Do([c,d]);var d=qp(this.ea,c),e=rp(this.ea,c),d=new Cl(d,e),e=Lo(c,ZH);this.dU(d,a,e);this.vi.$n(U(this.mo,this,b,c,d,a),a)};R.dU=function(a,b,c){null!=this.vi?this.vi[xC](a,b):this.vi=new JO(this.ea,a,b,c)};
R.mo=function(a,b,c,d){var e=this.vi.Wa(),f=this.vi.Mw();c=this.Jn(a,b,U(e.bf,e),c).Sh();Lu(this.Pd);var g=e instanceof hO?bJa(e):cJa(e);this.Pd=new vT(this,g,f,this,b,d);b=new pT;this.Pd[As](c,b);e.pK&&(e=e.pK())&&a&&Xa(e,lJa(a))};R.Ag=function(){zT.e.Ag[L](this);Lu(this.vi);this.vi=null};function oJa(a){this.Oh=a;this.lw=new bl;this.zt=new bl}oJa[K].Ut=function(a,b){var c=yT(this.Oh,this.lw.get(a));if(2>this.zt.Vb()||null==b)return c;var c=xn(c),d=this.zt.get(b);return vn(Bn(c,[255,255,255],1-d/this.zt.Vb()))};function AT(a,b){this.tua=a;this.sua=b;this.lw=new bl;this.zt=new bl}AT[K].It=function(a,b){this.lw.$e(a)||this.lw.set(a,this.lw.Vb());null!=b&&!this.zt.$e(b)&&this.zt.set(b,this.zt.Vb())};
AT[K].$g=function(){var a=new xT(this.lw.Vb(),this.tua,this.sua),a=new oJa(a);a.lw=this.lw[Jc]();a.zt=this.zt[Jc]();return a};function BT(a,b,c){this.$m=a;this.featureId=b[Jc]();this.em=c};function CT(){this.lt=new bl;this.wT=null;this.Pca=!0}CT[K].Sea=function(){return[]};br(CT[K],function(a){if(null==this.wT){this.wT=new bl;var b=this.Sea(a);X(b,U(this.Tea,this,a,this.wT))}var b=this.LL(a),c=new hl(this.lt.Ok());X(b,function(b){var e=b[qC].qg();c[Tb](e);this.Tea(a,this.lt,b)},this);this.Pca&&$k(c,function(b){var c=this.lt.get(b);a.Wf(c.$m);this.lt[Tb](b)},this)});
CT[K].Tea=function(a,b,c){var d=c[qC].qg(),e=b.get(d,null);e&&e.d4&&a.Wf(e.d4);c.em[0]===lL?(Wm(e.$m,!1),e.d4=c.$m,e.mta=c.em,a.to(e.d4,e[qC],e.mta)):e!=c&&(null===e||e.em!==c.em?(null!=e&&a.Wf(e.$m),a.to(c.$m,c[qC],c.em)):a.Ce(c.$m,e.$m,c[qC],c.em),b.set(d,c))};function pJa(a,b){qJa(b);return 0==b[J]?null===a?0:a:xj(b,function(a,b){return a+b},0)}function rJa(a,b){qJa(b);if(0==b[J])return a;var c=vj(b,function(a){return null!=a});return 0==c[J]?null:pJa(a,c)/c[J]}function qJa(a){X(a,function(){})};function DT(a){this.Hh=Xj({},a);this.k5=Xj({},a)}function ET(a,b,c){var d=a.Hh[J];for(a.Hh[b]=c;b<d;++b)a.k5[b]=FT(a,0==b?{}:a.k5[b-1],a.Hh[b])}function sJa(a){var b=Li(a);return b!=Ph&&b!=Lg||b==Ph&&Vi(a[Jc])||Qi(a)}function FT(a,b,c){if(sJa(c)||sJa(b)||Li(c)==Lg)return c;if(Li(b)==Ph){var d=mk(b);Zj(c,function(a,c){d[c]=c in b&&null!=b[c]?FT(this,b[c],a):a},a)}else d=Lj(b),Zj(c,function(a,c){d[c]=FT(this,b[c],a)},a);return d}DT[K].compact=function(){return qj(this.k5)};function GT(a,b){Ju[L](this);this.hc=a;this.gi=b}W(GT,Ju);var tJa=[];R=GT[K];R.Xd=null;R.qd=null;R.ux=function(a){this.hc=a};rz(R,function(){return this.hc});Bq(R,function(){return this.gi});R.getParent=function(){return this.Xd};R.dH=function(){return!this.Uf()};R.Vf=function(){return this.qd||tJa};R.Qf=function(a){return this.Vf()[a]||null};R.Uf=function(){return this.Vf()[J]};cb(R,function(){var a=this.Vf();return xj(a,function(a,c){return h.max(a,c[JB]())},-1)+1});
Pa(R,function(a){do a=a[Fz]();while(a&&a!=this);return Boolean(a)});R.xL=function(a,b){function c(d,e){!1!==a[L](b,d,e)&&X(d.Vf(),function(a){c(a,e+1)})}c(this,0)};R.find=function(a,b){var c=[];this.xL(function(d){a[L](b,d)&&c[B](d)});return c};R.uU=function(a,b,c,d){for(var e=a[L](d,this),f=[],g=this.Vf(),k=0;k<g[J];k++){var l=g[k].uU(a,b,c,d);f[B](l)}a=b[L](d,e,f);c&&c[L](d,this,a);return a};R.va=function(a){a.Xd=this;this.qd=this.qd||[];this.qd[B](a);Ku(this,a)};function HT(a,b,c){GT[L](this,c,a);this.q=b}W(HT,GT);R=HT[K];R.Ta=function(){return this.q};function uJa(a){return a.Ca(0)||a[nr]()}R.$r=function(a){return this.L2(this.q.$r,a)};hb(R,function(a){return this.L2(this.q[I],a)});R.Ca=function(a){return this.L2(this.q.Ca,a)};R.L2=function(a,b){var c=this[kC]();return null!=c?(c=[c],Mj(c,Nj(arguments,1)),a[Zc](this.q,c)):null};function IT(){Ju[L](this);this.jq=[];this.ky={}}W(IT,Ju);R=IT[K];R.zD=function(a){var b=a[kC]();null!=b&&(this.ky[b]=a)};cb(R,function(){return xj(this.jq,function(a,b){return h.max(a,b[JB]())},-1)});R.xL=function(a,b){for(var c=this.jq,d=0;d<c[J];d++)c[d].xL(a,b)};R.find=function(a,b){for(var c=[],d=this.jq,e=0;e<d[J];e++)Mj(c,d[e].find(a,b));return c};R.uU=function(a,b,c,d){for(var e=this.jq,f=0;f<e[J];f++)e[f].uU(a,b,c,d)};function JT(a,b){IT[L](this);if(2>a.L())throw m("Data table should have at least 2 columns");if(a.G(0)!=ii)throw m("Column 0 must be of type string");if(a.G(1)!=ii)throw m("Column 1 must be of type string");for(var c=this.ur(b),d=c.q8,e=c.r8,f=c.s8,g={},k=[],l=0;l<a.O();l++)if(c=a[I](l,0)){var n=g[c];n?null==n[kC]()&&n.ux(l):(g[c]=n=new HT(c,a,l),k[B](n));var p=n[I](1);if(p)if(c=g[p],c||(g[p]=c=new HT(p,a,null),k[B](c)),n[Fz]()){if(e)throw m("More than one row with the same id ("+n[nr]()+").");}else if(n!=
c&&!n[Yc](c))c.va(n);else if(d){f=m;k=vJa;d=c;e=[];for(c=c[Fz]();c;)e[B](c),c=c[Fz]();throw f("Data contains a cycle: "+k(Kj(d,e))+mf);}}for(c=0;c<k[J];c++){n=k[c];if(f&&Mi(n[kC]()))throw m('Failed to find row with id "'+n[nr]()+'".');n[Fz]()?this.zD(n):(d=n,this.jq[B](d),Ku(this,d),this.zD(d))}}W(JT,IT);function vJa(a){return wj(a,function(a){return a[nr]()})[qc]()}JT[K].ur=function(a){var b=new DT(2);ET(b,0,{q8:!0,r8:!0,s8:!0});null!=a&&ET(b,1,a);return b[iB]()};function KT(a,b,c){IT[L](this);a=a.jq;for(var d=0;d<a[J];d++){var e=wJa(this,a[d],b,c);this.jq[B](e);Ku(this,e);this.zD(e)}}W(KT,IT);function wJa(a,b,c,d){var e=c[L](d,b);b=b.Vf();for(var f=0;f<b[J];f++){var g=wJa(a,b[f],c,d);a.zD(g);e.va(g)}return e};function LT(){this.gk=[];this.Rb=[];this.rm=[]}LT[K].br=null;LT[K].Xg=null;LT[K].xz=!0;var xJa=[2,2,6,6,0];R=LT[K];va(R,function(){mb(this.gk,0);mb(this.Rb,0);mb(this.rm,0);delete this.br;delete this.Xg;delete this.xz;return this});R.moveTo=function(a,b){0==qj(this.gk)?mb(this.rm,this.rm[J]-2):(this.gk[B](0),this.Rb[B](1));this.rm[B](a,b);this.Xg=this.br=[a,b];return this};
R.lineTo=function(a){var b=qj(this.gk);if(null==b)throw m("Path cannot start with lineTo");1!=b&&(this.gk[B](1),this.Rb[B](0));for(b=0;b<arguments[J];b+=2){var c=arguments[b],d=arguments[b+1];this.rm[B](c,d)}this.Rb[this.Rb[J]-1]+=b/2;this.Xg=[c,d];return this};
R.vga=function(a){var b=qj(this.gk);if(null==b)throw m("Path cannot start with curve");2!=b&&(this.gk[B](2),this.Rb[B](0));for(b=0;b<arguments[J];b+=6){var c=arguments[b+4],d=arguments[b+5];this.rm[B](arguments[b],arguments[b+1],arguments[b+2],arguments[b+3],c,d)}this.Rb[this.Rb[J]-1]+=b/6;this.Xg=[c,d];return this};By(R,function(){var a=qj(this.gk);if(null==a)throw m("Path cannot start with close");4!=a&&(this.gk[B](4),this.Rb[B](1),this.Xg=this.br);return this});
R.arc=function(a,b,c,d,e,f,g){a+=Pk(e,c);b+=Qk(e,d);g?this.Xg&&a==this.Xg[0]&&b==this.Xg[1]||this[pB](a,b):this[oA](a,b);return this.arcTo(c,d,e,f)};R.arcTo=function(a,b,c,d){var e=this.Xg[0]-Pk(c,a)+Pk(c+d,a),f=this.Xg[1]-Qk(c,b)+Qk(c+d,b);this.gk[B](3);this.Rb[B](1);this.rm[B](a,b,c,d,e,f);this.xz=!1;this.Xg=[e,f];return this};
R.fxa=function(a,b,c,d){var e=this.Xg[0]-Pk(c,a),f=this.Xg[1]-Qk(c,b),g=Ok(d);d=h[Cb](h.abs(g)/h.PI*2);g/=d;c=Ok(c);for(var k=0;k<d;k++){var l=h.cos(c),n=h.sin(c),p=4/3*h.sin(g/2)/(1+h.cos(g/2)),t=e+(l-p*n)*a,u=f+(n+p*l)*b;c+=g;l=h.cos(c);n=h.sin(c);this.vga(t,u,e+(l+p*n)*a,f+(n-p*l)*b,e+l*a,f+n*b)}return this};function MT(a,b){for(var c=a.rm,d=0,e=0,f=a.gk[J];e<f;e++){var g=a.gk[e],k=xJa[g]*a.Rb[e];b(g,c[qd](d,d+k));d+=k}}
Ia(R,function(){var a=new this[Bc];a.gk=this.gk[Hb]();a.Rb=this.Rb[Hb]();a.rm=this.rm[Hb]();a.br=this.br&&this.br[Hb]();a.Xg=this.Xg&&this.Xg[Hb]();a.xz=this.xz;return a});var NT={};NT[0]=LT[K][oA];NT[1]=LT[K][pB];NT[4]=LT[K][Hr];NT[2]=LT[K].vga;NT[3]=LT[K].fxa;function yJa(a){if(a.xz)return a[Jc]();var b=new LT;MT(a,function(a,d){NT[a][Zc](b,d)});return b}
zz(LT[K],function(a){if(!this.xz)throw m("Non-simple path");a[AC](this.rm,0,this.rm,0,this.rm[J]/2);this.br&&a[AC](this.br,0,this.br,0,1);this.Xg&&this.br!=this.Xg&&a[AC](this.Xg,0,this.Xg,0,1);return this});Va(LT[K],function(){return 0==this.gk[J]});function OT(a,b,c,d,e){jP[L](this,e);na(this,a);Ta(this,b);this.wo=c||null;this.ZH=d||null}W(OT,jP);R=OT[K];R.ag=null;R.Tu=0;R.Fx=0;function PT(a){return a.wo?new Cl(a.wo,a.ZH):a.Mk()}R.Tb=function(){return this.Mk()};R.Mk=function(){return this.Mb?Tm(this.a()):Ui(this[r])&&Ui(this[z])?new Cl(this[r],this[z]):null};function QT(a){var b=a.Mk();return b?b[r]/PT(a)[r]:0}R.Wf=function(a){am(a.a())};R.ce=function(a,b,c,d,e,f){return this.zj(a,b,c,c,d,e,f)};
R.Jd=function(a,b,c,d,e,f,g,k,l,n,p){var t=k[EA]/2;c=g==uK?c+e-t:g==dK?c+e/2:c+t;return this.Ji(a,b,c,b+d,c,f,k,l,n,p)};R.zc=function(){return new LT};function RT(a,b,c,d,e,f){if(6==arguments[J])this.setTransform(a,b,c,d,e,f);else{if(0!=arguments[J])throw m("Insufficient matrix parameters");this.zi=this.Bi=1;this.Yh=this.Ai=this.wi=this.xi=0}}R=RT[K];Ia(R,function(){return new RT(this.zi,this.Yh,this.Ai,this.Bi,this.wi,this.xi)});R.setTransform=function(a,b,c,d,e,f){if(!(Ui(a)&&Ui(b)&&Ui(c)&&Ui(d)&&Ui(e)&&Ui(f)))throw m("Invalid transform parameters");this.zi=a;this.Yh=b;this.Ai=c;this.Bi=d;this.wi=e;this.xi=f;return this};
R.DS=function(a){this.zi=a.zi;this.Yh=a.Yh;this.Ai=a.Ai;this.Bi=a.Bi;this.wi=a.wi;this.xi=a.xi;return this};Na(R,function(a,b){this.zi*=a;this.Yh*=a;this.Ai*=b;this.Bi*=b;return this});fb(R,function(a,b){this.wi+=a*this.zi+b*this.Ai;this.xi+=a*this.Yh+b*this.Bi;return this});
R.rotate=function(a,b,c){var d=new RT,e=h.cos(a);a=h.sin(a);b=d.setTransform(e,a,-a,e,b-b*e+c*a,c-b*a-c*e);c=this.zi;d=this.Ai;this.zi=b.zi*c+b.Yh*d;this.Ai=b.Ai*c+b.Bi*d;this.wi+=b.wi*c+b.xi*d;c=this.Yh;d=this.Bi;this.Yh=b.zi*c+b.Yh*d;this.Bi=b.Ai*c+b.Bi*d;this.xi+=b.wi*c+b.xi*d;return this};Aa(R,function(){return Nra+[this.zi,this.Yh,this.Ai,this.Bi,this.wi,this.xi][Fe]()+ef});
zz(R,function(a,b,c,d,e){var f=b;for(b+=2*e;f<b;){e=a[f++];var g=a[f++];c[d++]=e*this.zi+g*this.Ai+this.wi;c[d++]=e*this.Yh+g*this.Bi+this.xi}});ab(R,function(a){return this==a?!0:a?this.zi==a.zi&&this.Ai==a.Ai&&this.wi==a.wi&&this.Yh==a.Yh&&this.Bi==a.Bi&&this.xi==a.xi:!1});function ST(a,b){hv[L](this);this.n=a;this.pd=b;this[Su]=!1}W(ST,hv);R=ST[K];R.pd=null;R.n=null;R.gw=null;R.a=function(){return this.n};R.mha=function(){return this.pd};R.setTransform=function(a){this.gw=a[Jc]();this.pd.N4(this,a)};R.addEventListener=function(a,b,c,d){$u(this.n,a,b,c,d)};R.removeEventListener=function(a,b,c,d){dv(this.n,a,b,c,d)};R.D=function(){ST.e.D[L](this);fv(this.n)};function TT(a,b,c,d){ST[L](this,a,b);this.ld(c);this.Ne(d)}W(TT,ST);R=TT[K];za(R,null);R.pe=null;R.Ne=function(a){za(this,a);this.pd.X4(this,a)};R.fb=function(){return this[nc]};R.ld=function(a){this.pe=a;this.pd.B4(this,a)};R.bea=function(){return this.pe};function UT(a,b,c,d){TT[L](this,a,b,c,d)}W(UT,TT);function VT(a,b){ST[L](this,a,b)}W(VT,ST);function WT(a,b){ST[L](this,a,b)}W(WT,ST);function XT(a,b,c,d){TT[L](this,a,b,c,d)}W(XT,TT);function YT(a,b,c,d){TT[L](this,a,b,c,d)}W(YT,TT);function ZT(a,b,c,d){TT[L](this,a,b,c,d)}W(ZT,TT);function $T(a){ST[L](this,null,a);this.qd=[]}W($T,VT);va($T[K],function(){this.qd[J]&&(mb(this.qd,0),this.pd.Mg())});$T[K].We=function(){};$T[K].appendChild=function(a){this.qd[B](a)};br($T[K],function(){for(var a=0,b=this.qd[J];a<b;a++)this.pd.Ce(this.qd[a])});function aU(a,b,c,d,e,f,g,k){TT[L](this,a,b,g,k);this.dga=c;this.ega=d;this.O4=e;this.P4=f;this.cl=new LT;bU(this);this.Q4=new cU(null,b,this.cl,g,k)}W(aU,UT);
function bU(a){a.cl[bc]();a.cl[oA](a.dga+Pk(0,a.O4),a.ega+Qk(0,a.P4));a.cl.arcTo(a.O4,a.P4,0,360);a.cl[Hr]()}aU[K].setCenter=function(a,b){this.dga=a;this.ega=b;bU(this);this.Q4[jr](this.cl)};ky(aU[K],function(a,b){this.O4=a;this.P4=b;bU(this);this.Q4[jr](this.cl)});br(aU[K],function(a){this.Q4[As](a)});function dU(a,b,c,d,e,f,g,k){TT[L](this,a,b,g,k);this.iw=c;this.jw=d;this.Gz=e;this.Fz=f}W(dU,YT);wz(dU[K],function(a,b){this.iw=a;this.jw=b;this.$q&&this.pd.Mg()});dU[K].$q=!1;
dU[K].We=function(a,b){this.Gz=a;this.Fz=b;this.$q&&this.pd.Mg()};br(dU[K],function(a){this.$q=!0;a[IB]();a[oA](this.iw,this.jw);a[pB](this.iw,this.jw+this.Fz);a[pB](this.iw+this.Gz,this.jw+this.Fz);a[pB](this.iw+this.Gz,this.jw);a[kB]()});function cU(a,b,c,d,e){TT[L](this,a,b,d,e);this[jr](c)}W(cU,XT);cU[K].$q=!1;xq(cU[K],function(a){this.cl=a.xz?a:yJa(a);this.$q&&this.pd.Mg()});
br(cU[K],function(a){this.$q=!0;a[IB]();MT(this.cl,function(b,c){switch(b){case 0:a[oA](c[0],c[1]);break;case 1:for(var d=0;d<c[J];d+=2)a[pB](c[d],c[d+1]);break;case 2:for(d=0;d<c[J];d+=6)a.bezierCurveTo(c[d],c[d+1],c[d+2],c[d+3],c[d+4],c[d+5]);break;case 3:throw m("Canvas paths cannot contain arcs");case 4:a[kB]()}})});
function eU(a,b,c,d,e,f,g,k,l,n){var p=Ql(ML,{style:Mva});TT[L](this,p,a,l,n);this.Fe=b;this.naa=c;this.bna=d;this.oaa=e;this.cna=f;this.$ma=g||Ch;this.ana=k;this.WQ=Ql(ML,{style:Nva});c=this.naa;k=this.oaa;d=this.bna;e=this.cna;l=this.$ma;f=this.ana;b=this.a()[w];g=QT(this.pd);n=this.pd;var t=n.Mk();n=t?t[z]/PT(n)[z]:0;c==k?(b.lineHeight=NCa,this.WQ[w].verticalAlign=l==dK?nG:l==Ch?d<e?kD:uK:d<e?uK:kD,oz(b,dK),k=f[EA]*g,b.top=h[D](h.min(d,e)*n)+P,$a(b,h[D]((c-k/2)*g)+P),na(b,h[D](k)+P),Ta(b,h.abs(d-
e)*n+P),Fa(b,.6*f[EA]*n+qqa)):(b.lineHeight=AM,this.WQ[w].verticalAlign=kD,oz(b,l),b.top=h[D](((d+e)/2-2*f[EA]/3)*n)+P,$a(b,h[D](c*g)+P),na(b,h[D](h.abs(k-c)*g)+P),Ta(b,Mg),Fa(b,f[EA]*n+qqa));hz(b,f[Xd]?xK:WF);qz(b,f.Tc?hH:WF);Ry(b,f.family);c=this.fb();Ya(b,c.ge()||c.L$());zJa(this);a.a()[q](p);p[q](this.WQ)}W(eU,ZT);eU[K].ds=function(a){this.Fe=a;zJa(this)};eU[K].Ne=function(a){za(this,a);var b=this.a();b&&Ya(b[w],a.ge()||a.L$())};eU[K].ld=function(){};br(eU[K],function(){});
function zJa(a){Xa(a.WQ,a.naa==a.oaa?wj(a.Fe[zc](M),function(a){return fj(a)})[Fe](Bf):fj(a.Fe))}function fU(a,b,c,d,e,f,g){ST[L](this,a,b);this.iw=c;this.jw=d;this.Gz=e;this.Fz=f;this.Fua=g}W(fU,WT);R=fU[K];R.$q=!1;wz(R,function(a,b){this.iw=a;this.jw=b;this.$q&&this.pd.Mg()});R.We=function(a,b){this.Gz=a;this.Fz=b;this.$q&&this.pd.Mg()};br(R,function(a){this.Pea?(this.Gz&&this.Fz&&a.drawImage(this.Pea,this.iw,this.jw,this.Gz,this.Fz),this.$q=!0):(a=new Image,qq(a,U(this.Gua,this,a)),a.src=this.Fua)});
R.Gua=function(a){this.Pea=a;this.pd.Mg()};function AJa(){};function gU(a,b){this.Wk=a;this.vp=null==b?1:b}W(gU,AJa);gU[K].ge=function(){return this.Wk};gU[K].getOpacity=function(){return this.vp};function hU(a,b,c,d,e){OT[L](this,a,b,c,d,e)}W(hU,OT);R=hU[K];R.X4=function(){this.Mg()};R.B4=function(){this.Mg()};R.N4=function(){this.Mg()};function BJa(a,b){var c=a[NB]();c[KA]();var d=b.gw?b.gw[Jc]():new RT,e=d.wi,f=d.xi;(e||f)&&c[OB](e,f);(d=d.Yh)&&c[OA](h.asin(d))}R.m=function(){var a=this.U.m(ch,{style:yqa});this.n=a;this.qc=this.U.m(hK);a[q](this.qc);this.p0=this.ag=new $T(this);this.nna=0;iU(this)};
R.getContext=function(){this.a()||this.m();this.Cj||(this.Cj=this.qc[NB](vM),this.Cj[KA]());return this.Cj};R.We=function(a,b){na(this,a);Ta(this,b);iU(this);this.Mg()};R.Mk=function(){var a=this[r],b=this[z],c=Si(a)&&-1!=a[zd](Ve),d=Si(b)&&-1!=b[zd](Ve);if(!this.Mb&&(c||d))return null;var e,f;c&&(e=this.a()[Ce],f=Um(e),a=ka(a)*f[r]/100);d&&(e=e||this.a()[Ce],f=f||Um(e),b=ka(b)*f[z]/100);return new Cl(a,b)};
function iU(a){Rm(a.a(),a[r],a[z]);var b=a.Mk();b&&(Rm(a.qc,b[r],b[z]),na(a.qc,b[r]),Ta(a.qc,b[z]),a.Cj=null)}Jy(R,function(){var a=this[NB]();a[cB]();var b=this.Mk();b[r]&&b[z]&&a.clearRect(0,0,b[r],b[z]);a[KA]()});va(R,function(){this.reset();this.ag[bc]();for(var a=this.a();1<a[cc][J];)a[le](a[Lc])});
R.Mg=function(){if(!this.Vya&&this.Mb){this.reset();if(this.wo){var a=this.Mk();this[NB]()[bB](a[r]/this.wo,a[z]/this.ZH)}(this.Tu||this.Fx)&&this[NB]()[OB](-this.Tu,-this.Fx);BJa(this,this.ag);this.ag[As](this.Cj);this[NB]()[cB]()}};
R.Ce=function(a){if(!(a instanceof eU)){var b=this[NB]();BJa(this,a);if(a.fb&&a.bea){var c=a.fb();if(c)if(c instanceof gU)0!=c[zB]()&&(b.globalAlpha=c[zB](),ry(b,c.ge()),a[As](b),b[nc](),b.globalAlpha=1);else{var d=b.createLinearGradient(c.Lya(),c.Nya(),c.Mya(),c.Oya());d[sC](0,c.L$());d[sC](1,c.Kya());ry(b,d);a[As](b);b[nc]()}if(c=a.pe)a[As](b),Uy(b,c.ge()),a=c.lb(),Si(a)&&-1!=a[zd](P)&&(a=ka(a)/QT(this)),My(b,a),b[ec]()}else a[As](b);this[NB]()[cB]()}};R.Cn=function(a,b){this[zC](a,b)};
R.append=function(a,b){b=b||this.ag;b[q](a);!this.Mb||this.nna||b!=this.ag&&b!=this.p0||this.Ce(a)};R.zj=function(a,b,c,d,e,f,g){a=new aU(null,this,a,b,c,d,e,f);this[zC](a,g);return a};R.eb=function(a,b,c,d,e,f,g){a=new dU(null,this,a,b,c,d,e,f);this[zC](a,g);return a};R.drawImage=function(a,b,c,d,e,f){a=new fU(null,this,a,b,c,d,e);this[zC](a,f);return a};R.Ji=function(a,b,c,d,e,f,g,k,l,n){a=new eU(this,a,b,c,d,e,f,g,k,l);this[zC](a,n);return a};
R.ta=function(a,b,c,d){a=new cU(null,this,a,b,c);this[zC](a,d);return a};R.Ba=function(a){var b=new $T(this);a=a||this.ag;if(a==this.ag||a==this.p0)this.p0=b;this[zC](b,a);return b};R.D=function(){this.Cj=null;hU.e.D[L](this)};R.Nb=function(){var a=this.Mk();hU.e.Nb[L](this);a||(iU(this),this[ir](cF));this.Mg()};function jU(a,b,c){this.N=a;this.Wk=b;this.vp=null==c?1:c}jU[K].lb=function(){return this.N};jU[K].ge=function(){return this.Wk};jU[K].getOpacity=function(){return this.vp};function kU(a,b){ST[L](this,a,b)}W(kU,VT);va(kU[K],function(){Yl(this.a())});kU[K].We=function(a,b){lU(this.a(),{width:a,height:b})};function mU(a,b,c,d){TT[L](this,a,b,c,d)}W(mU,UT);mU[K].setCenter=function(a,b){lU(this.a(),{cx:a,cy:b})};ky(mU[K],function(a,b){lU(this.a(),{rx:a,ry:b})});function nU(a,b,c,d){TT[L](this,a,b,c,d)}W(nU,YT);wz(nU[K],function(a,b){lU(this.a(),{x:a,y:b})});nU[K].We=function(a,b){lU(this.a(),{width:a,height:b})};function oU(a,b,c,d){TT[L](this,a,b,c,d)}W(oU,XT);
xq(oU[K],function(a){lU(this.a(),{d:CJa(a)})});function pU(a,b,c,d){TT[L](this,a,b,c,d)}W(pU,ZT);pU[K].ds=function(a){pa(this.a()[Yb],a)};function qU(a,b){ST[L](this,a,b)}W(qU,WT);wz(qU[K],function(a,b){lU(this.a(),{x:a,y:b})});qU[K].We=function(a,b){lU(this.a(),{width:a,height:b})};function rU(a,b,c,d,e){OT[L](this,a,b,c,d,e);this.Rp={};this.IX=ql&&!ul(526);this.Bd=new Bx(this)}var sU;W(rU,OT);R=rU[K];R.Ya=function(a,b){var c=this.U.oc()[GA](uH,a);b&&lU(c,b);return c};function lU(a,b){for(var c in b)a[v](c,b[c])}R.Cn=function(a,b){(b||this.ag).a()[q](a.a())};R.X4=function(a,b){var c=a.a();if(b instanceof gU)c[v](nI,b.ge()),c[v](mI,b[zB]());else c[v](nI,O)};
R.B4=function(a,b){var c=a.a();if(b){c[v](ND,b.ge());c[v](MD,b[zB]());var d=b.lb();Si(d)&&-1!=d[zd](P)?c[v](LD,ka(d)/QT(this)):c[v](LD,d)}else c[v](ND,O)};R.N4=function(a,b){var c=[b.zi,b.Yh,b.Ai,b.Bi,b.wi,b.xi][Fe]();a.a()[v](fD,Nra+c+ef)};
R.m=function(){var a=this.Ya(CD,{width:this[r],height:this[z],overflow:sh}),b=this.Ya(lh);this.kY=this.Ya(OI);this.ag=new kU(b,this);a[q](this.kY);a[q](b);this.n=a;if(this.wo||this.Tu||this.Fx)this.a()[v](wqa,O),this.IX?this.oO():this.a()[v](RC,this.Tu+Ke+this.Fx+Ke+(this.wo?this.wo+Ke+this.ZH:M))};
R.oO=function(){if(this.Mb&&(this.wo||this.Tu||!this.Fx)){var a=this.Mk();if(0==a[r])kb(this.a()[w],sh);else{kb(this.a()[w],M);var b=-this.Tu,c=-this.Fx,d=a[r]/this.wo,a=a[z]/this.ZH;this.ag.a()[v](fD,cpa+d+Ke+a+zEa+b+Ke+c+ef)}}};R.We=function(a,b){Rm(this.a(),a,b)};
R.Mk=function(){if(!pl)return this.Mb?Tm(this.a()):rU.e.Mk[L](this);var a=this[r],b=this[z],c=Si(a)&&-1!=a[zd](Ve),d=Si(b)&&-1!=b[zd](Ve);if(!this.Mb&&(c||d))return null;var e,f;c&&(e=this.a()[Ce],f=Um(e),a=ka(a)*f[r]/100);d&&(e=e||this.a()[Ce],f=f||Um(e),b=ka(b)*f[z]/100);return new Cl(a,b)};va(R,function(){this.ag[bc]();Yl(this.kY);this.Rp={}});R.zj=function(a,b,c,d,e,f,g){a=this.Ya(CI,{cx:a,cy:b,rx:c,ry:d});e=new mU(a,this,e,f);this.Cn(e,g);return e};
R.eb=function(a,b,c,d,e,f,g){a=this.Ya(iF,{x:a,y:b,width:c,height:d});e=new nU(a,this,e,f);this.Cn(e,g);return e};R.drawImage=function(a,b,c,d,e,f){a=this.Ya(kta,{x:a,y:b,width:c,height:d,"image-rendering":lra,preserveAspectRatio:O});a.setAttributeNS(ota,uh,e);e=new qU(a,this);this.Cn(e,f);return e};
R.Ji=function(a,b,c,d,e,f,g,k,l,n){var p=h[D](Rk(b,c,d,e));d-=b;e-=c;e=h[D](h[Kd](d*d+e*e));var t=g[EA];d={"font-family":g.family,"font-size":t};var u=h[D](.85*t),t=h[D](c-t/2+u),u=b;f==dK?(u+=h[D](e/2),d[wD]=nG):f==au&&(u+=e,d[wD]=zI);d.x=u;d.y=t;g[Xd]&&(d[dI]=xK);g.Tc&&(d[eI]=hH);0!=p&&zz(d,WE+p+Ke+b+Ke+c+ef);b=this.Ya(hu,d);b[q](this.U.oc()[Jb](a));null==k&&pl&&rl&&(a=AK,l instanceof gU&&(a=l.ge()),k=new jU(1,a));l=new pU(b,this,k,l);this.Cn(l,n);return l};
R.ta=function(a,b,c,d){a=this.Ya(DF,{d:CJa(a)});b=new oU(a,this,b,c);this.Cn(b,d);return b};function CJa(a){var b=[];MT(a,function(a,d){switch(a){case 0:b[B](Xf);ga[K][B][Zc](b,d);break;case 1:b[B](Wf);ga[K][B][Zc](b,d);break;case 2:b[B](TL);ga[K][B][Zc](b,d);break;case 3:var e=d[3];b[B](Hf,d[0],d[1],0,180<h.abs(e)?1:0,0<e?1:0,d[4],d[5]);break;case 4:b[B](zg)}});return b[Fe](Ke)}R.Ba=function(a){var b=this.Ya(lh);(a||this.ag).a()[q](b);return new kU(b,this)};R.sl=function(){};
R.Nb=function(){var a=this.Mk();rU.e.Nb[L](this);a||this[ir](cF);if(this.IX){var a=this[r],b=this[z];typeof a==ii&&-1!=a[zd](Ve)&&typeof b==ii&&-1!=b[zd](Ve)&&this.Bd.k(DJa(),iu,this.oO);this.oO()}};R.Ff=function(){rU.e.Ff[L](this);this.IX&&this.Bd.hb(DJa(),iu,this.oO)};R.D=function(){delete this.Rp;delete this.kY;delete this.ag;this.Bd.$();delete this.Bd;rU.e.D[L](this)};function DJa(){sU||(sU=new rv(400),sU[y]());return sU};function tU(){return this.n=this.pd.U.a(this.hc)||this.n}function uU(a,b){this.hc=a.id;ST[L](this,a,b)}W(uU,VT);uU[K].a=tU;va(uU[K],function(){Yl(this.a())});uU[K].We=function(a,b){var c=this.a(),d=c[w];na(d,vU(a)+P);Ta(d,vU(b)+P);vz(c,vU(a)+Ke+vU(b));this.pd.ag!=this&&zy(c,DM)};function wU(a,b,c,d,e,f,g,k){this.hc=a.id;TT[L](this,a,b,g,k);this.HC=c;this.IC=d;this.Hi=e;this.Ii=f}W(wU,UT);wU[K].a=tU;wU[K].setCenter=function(a,b){this.HC=a;this.IC=b;xU(this.a(),a-this.Hi,b-this.Ii,2*this.Hi,2*this.Ii)};
ky(wU[K],function(a,b){this.Hi=a;this.Ii=b;xU(this.a(),this.HC-a,this.IC-b,2*a,2*b)});function yU(a,b,c,d){this.hc=a.id;TT[L](this,a,b,c,d)}W(yU,YT);yU[K].a=tU;wz(yU[K],function(a,b){var c=this.a()[w];$a(c,zU(a));c.top=zU(b)});yU[K].We=function(a,b){var c=this.a()[w];na(c,vU(a)+P);Ta(c,vU(b)+P)};function AU(a,b,c,d){this.hc=a.id;TT[L](this,a,b,c,d)}W(AU,XT);AU[K].a=tU;xq(AU[K],function(a){BU(this.a(),DF,EJa(a))});function CU(a,b,c,d){this.hc=a.id;TT[L](this,a,b,c,d)}W(CU,ZT);CU[K].a=tU;
CU[K].ds=function(a){BU(this.a()[cc][1],ii,a)};function DU(a,b){this.hc=a.id;ST[L](this,a,b)}W(DU,WT);DU[K].a=tU;wz(DU[K],function(a,b){var c=this.a()[w];$a(c,zU(a));c.top=zU(b)});DU[K].We=function(a,b){var c=this.a()[w];na(c,zU(a));Ta(c,zU(b))};function EU(a,b,c,d,e){OT[L](this,a,b,c,d,e);this.Bd=new Bx(this);Ku(this,this.Bd)}W(EU,OT);var FU=ea[ye]&&8<=ea[ye];function FJa(a){return Si(a)&&Dda(a)?a:ka(a[qc]())+P}function GU(a){return h[D](100*(ka(a[qc]())-.5))}function zU(a){return GU(a)+P}function vU(a){return h[D](100*ka(a[qc]()))}function BU(a,b,c){FU?a[b]=c:a[v](b,c)}function HU(a,b){var c=a.U[Vb](xua+b);c.id=uua+Rda++;return c}function IU(a){FU&&a.Mb&&Xa(a.a(),a.a()[vd])}EU[K].Cn=function(a,b){(b||this.ag).a()[q](a.a());IU(this)};
EU[K].X4=function(a,b){var c=a.a();GJa(c);if(b instanceof gU)if(b.ge()==oi)ay(c,!1);else if(1!=b[zB]()){ay(c,!0);var d=HU(this,nI);qb(d,h[D](100*b[zB]())+Ve);Ya(d,b.ge());c[q](d)}else ay(c,!0),hy(c,b.ge());else ay(c,!1);IU(this)};EU[K].B4=function(a,b){var c=a.a();if(b){gy(c,!0);var d=b.lb(),d=Si(d)&&-1==d[zd](P)?ka(d):d*QT(this),e=c[kc](ND)[0];e||(e=e||HU(this,ND),c[q](e));qb(e,b[zB]());by(e,d+P);Ya(e,b.ge())}else gy(c,!1);IU(this)};
EU[K].N4=function(a,b){var c=a.a();HJa(c);var d=HU(this,ooa);d.on=pi;Zx(d,-c[w].pixelLeft/c[w].pixelWidth-.5+jf+(-c[w].pixelTop/c[w].pixelHeight-.5));d.offset=b.wi[Bb](1)+nqa+b.xi[Bb](1)+P;d.matrix=[b.zi[Bb](6),b.Ai[Bb](6),b.Yh[Bb](6),b.Bi[Bb](6),0,0][Fe]();c[q](d);IU(this)};function HJa(a){X(a[cc],function(b){b[$c]==ooa&&a[le](b)})}function GJa(a){hy(a,M);X(a[cc],function(b){b[$c]==nI&&a[le](b)})}
function xU(a,b,c,d,e){var f=a[w];Ba(f,Fg);$a(f,zU(b));f.top=zU(c);na(f,vU(d)+P);Ta(f,vU(e)+P);a[$c]==fE&&vz(a,vU(d)+Ke+vU(e))}function JU(a,b){var c=HU(a,b),d=PT(a);xU(c,0,0,d[r],d[z]);return c}try{eval("document.namespaces")}catch(IJa){}R=EU[K];
R.m=function(){var a=this.U.oc();a.namespaces.g_vml_||(FU?a.namespaces.add(yua,aD,REa):a.namespaces.add(yua,aD),bb(a.createStyleSheet(),wua));var a=this[r],b=this[z],c=this.U.m(ch,{style:fra+FJa(a)+HCa+FJa(b)});this.n=c;var d=HU(this,JH),e=d[w];Ba(e,Fg);$a(e,e.top=0);na(e,this[r]);Ta(e,this[z]);vz(d,this.wo?vU(this.wo)+Ke+vU(this.ZH):vU(a)+Ke+vU(b));zy(d,Gi(this.Tu)?vU(this.Tu)+Ke+vU(this.Fx):DM);c[q](d);this.ag=new uU(d,this);$u(c,cF,U(this.eX,this))};
R.eX=function(){var a=Tm(this.a()),b=this.ag.a()[w];if(a[r])na(b,a[r]+P),Ta(b,a[z]+P);else{for(a=this.a();a&&a[ve]&&a[ve][cd]!=O;)a=a[Ce];a&&a[ve]&&this.Bd.k(a,rqa,this.eX)}this[ir](cF)};R.We=function(a,b){Rm(this.a(),a,b)};R.Mk=function(){var a=this.a();return new Cl(a[w].pixelWidth||a[Gb]||1,a[w].pixelHeight||a[fd]||1)};va(R,function(){this.ag[bc]()});R.zj=function(a,b,c,d,e,f,g){var k=HU(this,hra);xU(k,a-c,b-d,2*c,2*d);a=new wU(k,this,a,b,c,d,e,f);this.Cn(a,g);return a};
R.eb=function(a,b,c,d,e,f,g){var k=HU(this,iF);xU(k,a,b,c,d);a=new yU(k,this,e,f);this.Cn(a,g);return a};R.drawImage=function(a,b,c,d,e,f){var g=HU(this,kta);xU(g,a,b,c,d);BU(g,gi,e);a=new DU(g,this);this.Cn(a,f);return a};
R.Ji=function(a,b,c,d,e,f,g,k,l,n){var p=JU(this,fE),t=HU(this,DF);b=Xf+GU(b)+jf+GU(c)+Wf+GU(d)+jf+GU(e)+Pf;BU(t,si,b);BU(t,uD,pi);b=HU(this,Lna);b[v](Qh,pi);c=b[w];Fa(c,g[EA]*QT(this));Ry(c,g.family);null!=f&&(c[ZC]=f);g[Xd]&&hz(c,xK);g.Tc&&qz(c,hH);BU(b,ii,a);p[q](t);p[q](b);a=new CU(p,this,k,l);this.Cn(a,n);return a};R.ta=function(a,b,c,d){var e=JU(this,fE);BU(e,DF,EJa(a));a=new AU(e,this,b,c);this.Cn(a,d);return a};
function EJa(a){var b=[];MT(a,function(a,d){switch(a){case 0:b[B](Fh);ga[K][B][Zc](b,wj(d,vU));break;case 1:b[B](dH);ga[K][B][Zc](b,wj(d,vU));break;case 2:b[B](Tg);ga[K][B][Zc](b,wj(d,vU));break;case 4:b[B](JC);break;case 3:var e=d[2]+d[3],f=vU(d[4]-Pk(e,d[0])),e=vU(d[5]-Qk(e,d[1])),g=vU(d[0]),k=vU(d[1]),l=h[D](-65536*d[2]),n=h[D](-65536*d[3]);b[B](qza,f,e,g,k,l,n)}});return b[Fe](Ke)}R.Ba=function(a){var b=JU(this,JH);(a||this.ag).a()[q](b);return new uU(b,this)};R.sl=function(){return 0};
R.Nb=function(){EU.e.Nb[L](this);this.eX();IU(this)};R.D=function(){this.ag=null;EU.e.D[L](this)};function KU(a,b,c,d,e){jP[L](this,d);this.Ke=new zv(e||lDa);this.cJ=M;this.Nd=[];this.lB=[];this.FQ=[];this.Wu=[];this.Qma=[];this.Tma=[];this.vJ=[];this.O_={};this.Rma={};this.GQ={};this.Sma={};this.Pv(a);this.We(b,c);this.Ha=LU(this)?0:da}W(KU,jP);R=KU[K];R.x8=2048;R.ina=0;R.jna=0;R.tb=-da;R.Rf=null;R.GZ=null;R.m=function(){var a=this.Tb();this.n=this.pa().m(yh,{src:MU(this),"class":Hza,width:a[0],height:a[1]})};R.Hf=function(a){a.src=MU(this);this.n=a};
function MU(a){var b;a.cJ!=M?b=NU(a,a.cJ):(b=NU(a,DI))||(b=NU(a,ai));b||a[ir](new JJa(a.Ke[qc]()));return a.Ke}function KJa(a,b){var c=[];X(b,function(a){a.area=a.area||oya;a.Oq=a.Oq||ai;c[B]([a.area,a.Oq,a[F]][Fe]())});c=c[Fe](Eu);a.Xc(jxa,c)}R.Pv=function(a){this.Ke.Xc(OJ,a)};Pq(R,function(){return Iv(this.Ke,OJ)});R.We=function(a,b){var c=[a||300,b||150][Fe](JC);this.Ke.Xc(PJ,c)};R.Tb=function(){return Iv(this.Ke,PJ)[zc](JC)};R.PP=function(a){this.Ha=a};R.OP=function(a){this.tb=a};
function OU(a,b){a.Wu=b;a.Ke.Xc(ixa,a.Wu[Fe](Eu))}function PU(a){a=a[Tr]();return a==Sg||a==CK||a==BK||a==lK||a==kK}function LU(a){a=a[Tr]();return a==GF||a==cra||a==Tqa}function LJa(a){a=a[Tr]();return a==Sg||a==CK||a==BK}function MJa(a){a=a[Tr]();return a==Sg||a==BK||a==kK}R.Xc=function(a,b){this.Ke.Xc(a,b)};R.R4=function(a){this.Ke.R4(a)};R.setTitle=function(a){this.Rf=a;this.Ke.Xc(gxa,this.Rf[Ab](/\n/g,Eu))};function QU(a,b){a.vJ[B](b);a.Ke.Xc(exa,a.vJ[Fe](jf));return a.vJ[J]-1}
function RU(a,b,c){a.O_[b]=c;b=NJa(a,a.O_,KCa,Eu);a.Ke.Xc(fxa,b)}function SU(a,b,c,d){var e;e=da;for(var f=0,g=b[J];f<g;++f){var k=b[f];null!=k&&k<e&&(e=k)}e<a.Ha&&(a.Ha=e);e=-da;f=0;for(g=b[J];f<g;++f)k=b[f],null!=k&&k>e&&(e=k);e>a.tb&&(a.tb=e);if(Gi(d)){if(a.FQ[J]<a.Nd[J])throw m("Cannot start adding legends text after first element.");a.FQ[B](d);a.Ke.Xc(lxa,a.FQ[Fe](Eu))}a.Nd[B](b);a.lB[B](c);a.Ke.Xc(SJ,a.lB[Fe](jf))}R.getData=function(a){return Gi(a)?this.Nd[a]:this.Nd};
function NU(a,b){for(var c=[],d=0,e=a.Nd[J];d<e;++d){var f=c,g=d,k;k=a;for(var l=a.Nd[d],n=a.Ha,p=a.tb,t=b,u=[],x=0,A=l[J];x<A;++x)u[B](OJa(l[x],n,p,t));k=u[Fe](k.cJ==AD?jf:M);f[g]=k}c=c[Fe](b==AD?Eu:jf);c=null==a.GZ?Qda(b,xf,c):Qda(b,a.GZ,xf,c);a.Ke.Xc(mxa,c);return a.Ke[qc]()[J]<a.x8}function NJa(a,b,c,d){var e=[],f=0;for(a=a.vJ[J];f<a;++f)b[f]&&e[B](f+c+b[f][Fe](d));return e[Fe](Eu)}var PJa=h.pow(64,2)-1;
function OJa(a,b,c,d){var e=d==DI;if(null===a||!Gi(a)||fa(a)||a<b||a>c)return e?dAa:lL;if(d==AD)return String(a);d=.5;c>b&&(d=(a-b)/(c-b));if(e)return"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-."[Ib](h[Eb](d*PJa/64))+"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-."[Ib](h[Eb](d*PJa%64));a=h[D](61*d);return"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789"[Ib](a)}
KU[K].D=function(){KU.e.D[L](this);delete this.Wu;delete this.Qma;delete this.Tma;delete this.ina;delete this.jna;delete this.lB;delete this.FQ;delete this.Nd;this.Ke=null;delete this.Ha;delete this.tb;this.Rf=null;delete this.vJ;delete this.O_;delete this.Rma;delete this.GQ;delete this.Sma};function JJa(a){Mu[L](this,Sma);this.uri=a}W(JJa,Mu);function TU(a,b,c){this.Ng=a;this.hqa=b;this.Le={};this.rta=!1;this.fp=null;this.iqa=c;a===DF&&(za(this.Le,O),xa(this.Le,vN),this.fp=new PO.yc.Pw(this.Le))}R=TU[K];Jy(R,function(){this.rta&&(this.Le=ca.getPrototypeOf(this.Le))});R.$m=function(){if(null==this.fp){var a=QJa[this.Ng];if(!a)throw m("No draw routine for "+this.Ng+mf);this.fp=a[L](null,this.Le)}return this.fp};R.aw=function(){return this.Le};function UU(a,b){a.Le.x=b;return a}function VU(a,b){a.Le.y=b;return a}
R.xg=function(a){na(this.Le,a);return this};R.Yj=function(a){Ta(this.Le,a);return this};R.ds=function(a){Oy(this.Le,a);return this};ky(R,function(a){Yy(this.Le,a);return this});function WU(a,b,c,d){var e=d||{};Io(b,c,null,function(b){var c=Yo(b[nc]||e[nc])||O;a.Ne(c);c=To(b[Yd]);null!=c&&a.Eg(c);c=Yo(b[ec]||e[ec]);null!=c&&a.ld(c);b=Ro(b[Od]);null!=b&&a.mk(b);return null})}R.ld=function(a){xa(this.Le,a);this.fp&&this.fp[w](ND,a);return this};
R.mk=function(a){ib(this.Le,a);this.fp&&this.fp[w](GD,a);return this};R.Ne=function(a){za(this.Le,a);return this};R.Eg=function(a){this.Le.fillOpacity=a;return this};Ty(R,function(a,b){this.fp[yB](a,b);return this});R.ha=function(a,b){this.fp[nC](a,b);return this};R.zf=function(a,b,c,d,e,f,g){this.fp.arc(a,b,c,d,e,f,g);return this};function RJa(a,b){Ry(a.Le,b);return a}function XU(a,b){Fa(a.Le,b);return a}function SJa(a,b){var c=a.Le.corners={};c.rx=b;c.ry=b}
function TJa(a,b){a.Le.halign=b;return a}function UJa(a,b){a.Le.valign=b;return a}var QJa={circle:function(a){return new PO.yc[hC](a[HB],a.x,a.y,{fill:a[nc]})},line:function(a){return new PO.yc.Wp(a.x,a.y,a.Fb,a.Kb,a)},rect:function(a){return new PO.yc[xB](a.x,a.y,a[r],a[z],a)},text:function(a){return new PO.yc[lB](a.x,a.y,a[pd],a)}};function YU(a){this.Cf=[];this.ja=a;this.k4=0}YU[K].Tb=function(){return this.ja};YU[K].$G=function(){return this.Cf};YU[K].ha=function(a,b,c,d,e,f){a=VU(UU(new TU(OG,a||ZU(this),b||MK),c),d);a.Le.x2=e;a.Le.y2=f;this.Cf[B](a);return a};function $U(a,b,c,d,e,f,g){b=VU(UU(new TU(iF,b||ZU(a),c||MK),d),e).xg(f).Yj(g);a.Cf[B](b);return b}YU[K].wu=function(a,b,c,d,e,f){a=VU(UU((new TU(hu,a||ZU(this),b||MK)).ds(c),d),e).xg(f);this.Cf[B](a);return a};
function ZU(a){var b=new iT(VL);kT(b,vL,aAa+a.k4);a.k4+=1;return b};function aV(a,b){var c;c=Fi[Fc][Vc];c=cj(kj(c))||ln(1,c)!=Jt?wh:Jt;return FO(GEa,c,a,b)};function VJa(a,b){if(a){if(b[J]!=a[J])throw m("colorsScale and valuesScale must be of the same length");}else if(1!=b[J])throw m("colorsScale must contain exactly one element when no valueScale is provided");this.Yk=a;this.Gv=wj(b,function(a){return sn(a).sc})}var bV=[fN,sN],WJa=[gN,fN,sN];
function cV(a,b){if(!a.Yk)return a.Gv[0];if(b>=a.Yk[a.Yk[J]-1])return a.Gv[a.Gv[J]-1];if(b<=a.Yk[0])return a.Gv[0];var c=Oj(a.Yk,b);if(0<=c)return a.Gv[c];var d=-c-2,c=-c-1;return go(a.Gv[c],a.Gv[d],(b-a.Yk[d])/(a.Yk[c]-a.Yk[d]))}function XJa(a,b){b&&0!=b[J]?1==b[J]&&(b=[bV[0],b[0]]):b=a&&3==a[J]?WJa:bV;if(!a||2>a[J])return{values:null,b4:[qj(b)]};var c=a[0],d=a[a[J]-1],e=d-c;if(0==e)return{values:[d],b4:[qj(b)]};if(2==a[J])for(a=[],d=e/(b[J]-1),e=0;e<b[J];e++)a[B](c+d*e);return{values:a,b4:b}}
function YJa(a,b){var c=null,d=a.Q(Mwa);if(d&&0<d[J]){1==d[J]&&(d=[d[0],d[0]]);b&&(null==d[0]&&(d[0]=b[y]),null==d[d[J]-1]&&(d[d[J]-1]=b.end));if(null==d[0])throw m(Lwa);for(c=1;c<d[J];c++){if(null==d[c])throw m(Lwa);if(d[c]<d[c-1])throw m("colorAxis.values must be a monotonically increasing series");}c=d}else{var d=Qo(a,Pwa),e=Qo(a,Qwa);if(null!=d&&null!=e&&d>e)throw m("colorAxis.minValue ("+d+") must be at most colorAxis.maxValue ("+e+ef);(d=Ufa(b,d,e))&&(c=[d[y],d.end])}var d=a.Q(mJ),d=a.Q(Uwa,
d),e=a.Q(Owa,bV),f=a.Q(Nwa,WJa);d&&0!=d[J]?1==d[J]&&(d=[e[0],d[0]]):d=c&&3==c[J]?f:e;c=XJa(c,d);return new VJa(c[kA],c.b4)};function dV(a,b){var c=a[AA],c=Tfa(Fl(b),c);b[q](c);a.iga&&Xa(c,a[AA][Fb]);var d,e=a[lC],f=a.jga;d=a.hga;var g=a.JC,k=a[nB],l=new Cl(c[be],c[re]),n=d[kd]-e.x>=l[r]+k,p=e.x-d[G]>=l[r]+k,t=d[Uc]-e.y>=l[z]+k,u=e.y-d.top>=l[z]+k,x=Sk(e.x-f.x),f=Sk(e.y-f.y);0===x&&x===f&&(x=!p||n||t||u?1:-1,f=u||n?-1:1);n=e.y+(g+l[z]/2)*f;e=Lk(e.x+(g+l[r]/2)*x-l[r]/2,d[G]+k,d[kd]-k-l[r]);d=Lk(n-l[z]/2,d.top+k,d[Uc]-k-l[z]);d=new xl(e,d);na(c[w],c[be]+1+P);Ta(c[w],c[re]+P);$a(c[w],d.x+P);c[w].top=d.y+P;return c};function eV(a,b,c){var d=b.Ba(),e=a.outline,f=new bO,g=new um(e.ka.top+.5,e.ka[kd]+.5,e.ka[Uc]+.5,e.ka[G]+.5),k=e.dk;f[yB](g[G]+1,g[Uc]);f.zf(g[G]+1,g[Uc]-1,1,1,180,270,!0);f.ha(g[G],g.top+1);f.zf(g[G]+1,g.top+1,1,1,270,0,!0);if(null!=k&&k[0].y==e.ka.top)for(var l=0;3>l;++l)f.ha(k[l].x+.5,k[l].y+.5);f.ha(g[kd]-1,g.top);f.zf(g[kd]-1,g.top+1,1,1,0,90,!0);f.ha(g[kd],g[Uc]-1);f.zf(g[kd]-1,g[Uc]-1,1,1,90,180,!0);if(null!=k&&k[0].y==e.ka[Uc])for(l=0;3>l;++l)f.ha(k[l].x+.5,k[l].y+.5);f[Hr]();e=[new lo({fill:xi,
stroke:cN,strokeWidth:1}),new lo({fill:cN,strokeWidth:0,fillOpacity:.6}),new lo({fill:cN,strokeWidth:0,fillOpacity:.4})];for(g=e[J]-1;0<=g;--g)k=b.ta(f,e[g],d),b.Nm(k,g,g);a=a.PJ;for(f=0;f<a[jC][J];f++)switch(k=a[jC][f],g=k.Ah,e=b.Ba(),b[q](d,e),g[H]){case OG:g=g[Y];k=k[Y];k[iC]&&b.eb(k[iC].ka[G],k[iC].ka.top,k[iC].ka[kd]-k[iC].ka[G],k[iC].ka[Uc]-k[iC].ka.top,g[iC].brush,e);for(l=0;l<k[uA][J];l++){var n=g[uA][l],p=k[uA][l];switch(n[H]){case hu:b.Jd(n[Y][pd],a.Qaa?p.ka[kd]:p.ka[G],p.ka.top,1,TD,TD,
n[Y][w],e,a.Qaa);break;case WD:b.eb(p.ka[G],p.ka.top,p.ka[kd]-p.ka[G],p.ka[Uc]-p.ka.top,n[Y].brush,e)}}null!=g.id&&(g=RS([Gg,g.id]),b.qo(e,g));break;case IE:g=g[Y],k=k[Y],l=new bO,l[yB](k[nC].x0,k[nC].y0),l.ha(k[nC].x1,k[nC].y1),b.ta(l,g.brush,e)}b[q](c,d);return d};function fV(a,b){this.x=a||0;this.y=b||0}Ia(fV[K],function(){return new fV(this.x,this.y)});function gV(a){var b=wj(a.I,function(b){var d=a[lC]?a[lC]:{x:0,y:0},e=fO(b.x+d.x,b[J],a.Gc);b=fO(b.y+d.y,a.ba[Gc],a.Fc);return e[y]==e.end||b[y]==b.end?null:new um(b[y],e.end,b.end,e[y])}),b=vj(b,Ni);return io(b)};function ZJa(a,b){return h.abs(a-b)}function $Ja(a,b,c){if(!a||!b)return!0;var d=c||ZJa;return ck(a,function(a,c){var g=b[c];return!Gi(b[c])||.05>=d(a,g)})}function aKa(a,b,c){if(0==a.x||0==b.x)return{x:0,y:(0==a.x&&0==b.x?0:0==a.x?a.y:b.y)*c/6};c=c/3*h.min(h.abs(a.x),h.abs(b.x));b=(a.y/a.x+b.y/b.x)/2;return 0<a.x?{x:c,y:c*b}:{x:-c,y:-c*b}}function bKa(a,b,c){var d=a.pha(),e=b.pha();if(0==d||0==e)return new oO(0,0);d=h[Kd](d/e);a=pO(a[Jc]()[bB](1/d),b[Jc]()[bB](d));a[bB](c/6);return a}
function hV(a,b,c,d,e){c=c?aKa:bKa;for(var f=[],g=0;g<a[J];++g){var k,l;e?(k=cKa(a,g,1,d),l=cKa(a,g,-1,d)):(k=d?(g+1)%a[J]:g+1,l=d?(a[J]+g-1)%a[J]:g-1);null!=k&&null!=l&&null!=a[g]&&null!=a[l]&&null!=a[k]?(k=c(qO(a[g],a[l]),qO(a[k],a[g]),b),f[B]([qO(a[g],k),pO(a[g],k)])):null!=a[g]?f[B]([a[g][Jc](),a[g][Jc]()]):f[B](null)}return f}function cKa(a,b,c,d){var e=b+c;for(d&&(e=(e+a[J])%a[J]);e!=b&&0<=e&&e<a[J];){if(null!=a[e])return e;e+=c;d&&(e=(e+a[J])%a[J])}return null}
function iV(a,b,c){c=c||0;var d=Bj(b,function(b){return b[c]>a});return-1==d?b[J]-1:0==d?0:b[d][c]-a<a-b[d-1][c]?d:d-1}function dKa(a,b,c){var d;d=d||0;c=c||0;if(0<b[J]&&a<=qj(b))return c=iV(a,b,d),[c,b[c][d]];var e=b[J]-1-c,f=qj(b)[d],g=b[e][d],k=f-g,l=h[Eb]((a-f)/k);a=a-f-l*k;e=wj(Nj(b,e),function(a){return[a[d]-g]});a=iV(a,e,0);return[b[J]-1+l*c+a,f+l*k+e[a][0]]}function jV(a,b,c){for(var d=[],e=0;e<a;e++)d[e]=b[L](c,e);return d}function eKa(a){return null!=a.max?a.max:a.min}
function fKa(a,b,c,d){Gi(c)||(c=0);Gi(d)||(d=a[J]);c=b-c;for(var e=0,f=0<=c?0:null,g=0,k=0,l=null,n=null;e<a[J];){var p=a[e].min,t=eKa(a[e])-p,g=g+p;if(g<=c)var f=e+1,u=h.min(c-g,t),k=g+u,n=p+u;if(g>b)return e>=d?{ep:e,last:l,fM:b-(g-p)}:null===f?null:{ep:f,last:n,fM:c-k};u=h.min(b-g,t);g+=u;l=p+u;e++}return{ep:e,last:l,fM:b-g}}function gKa(a,b,c){a=wj(a,c||Kk);Qj(a);for(var d=c=0;d<a[J];d++){var e=a[J]-d,f=(a[d]-c)*e;if(f<=b)c=a[d],b-=f;else{c+=b/e;b=0;break}}return{Eua:c,fM:b}}
function kV(a,b,c,d){var e=fKa(a,b,c,d);if(!e)return null;b=e.fM;c=Nj(a,0,e.ep);d=xj(c,function(a,b){return h.max(a,b.Ub[J])},0);var f=wj(c,eKa);0<f[J]&&(f[f[J]-1]=e.last);for(var g=0;g<d;g++){e=gKa(c,b,function(a){return a.Ub[g]||0});b=e.fM;for(var k=0;k<f[J];k++)f[k]+=h.min(e.Eua,a[k].Ub[g]||0);if(0==b)break}return f}function lV(a,b){var c=kV(a,b,void 0,void 0),d={};X(a,function(a,b){var g=a.key;null!=d[g]||(d[g]=[]);b<c[J]&&d[g][B](c[b])});return d}
function hKa(a,b){for(var c=Nj(arguments,1),d=[],e=0;e<c[J];e+=2){var f=h.min(c[e],a[J]),g=h.min(c[e+1],a[J]),f=Nj(a,f,g);Mj(d,f)}return d}function mV(a){if(0==a)return 0;a=h.abs(a);for(var b=0;16>b;++b){if(h.abs(a-h[D](a))<1E-7*a)return b;a*=10}return 16}function nV(a){var b=Zp;if(0>=a)return b[mc](0,b[ne](mf));for(var b=b[mc](0,b[ne](mf)+1),c=0;c<a;c++)b+=Oe;return b}function oV(a,b){return Si(a)?[a+mf+b]:wj(a,function(a){return a+mf+b})}function pV(a,b,c){return 0>b||0>c?null:a[b][c]}
function iKa(a,b,c,d,e,f){var g=[],k=pV(c,d-1,e);k&&g[B]({gV:k,sm:k.sm+1,jM:d-1,hV:null,kM:null,iV:null});(k=pV(c,d,e-1))&&g[B]({gV:k,sm:k.sm+1,jM:null,hV:null,kM:e-1,iV:null});(c=pV(c,d-1,e-1))&&f(a[d-1],b[e-1])&&g[B]({gV:c,sm:c.sm,jM:d-1,hV:e-1,kM:e-1,iV:d-1});Qj(g,function(a,b){return a.sm-b.sm});return 0<g[J]?g[0]:{gV:null,sm:0,jM:null,hV:null,kM:null,iV:null}}
function jKa(a,b,c){var d=c||function(a,b){return a==b};c=[];for(var e=0,f=a[J];e<=f;e++){c[e]=c[e]||[];for(var g=0,k=b[J];g<=k;g++)c[e][g]=iKa(a,b,c,e,g,d)}a={};b={};k=c[f][k];for(c=k.sm;k;)null!=k.jM&&(a[k.jM]=k.hV),null!=k.kM&&(b[k.kM]=k.iV),k=k.gV;return{sm:c,p9:a,q9:b}}
function kKa(a,b,c){function d(a,b,c){if(null==c)return 0;if(c===b[J]-1||null==a)return c;var d=f(b[c]);if(null==d)return c+1;b=f(b[c+1]);return null==b?c:h.abs(a-d)<=h.abs(a-b)?c:c+1}if(!a||!b||0===a[J]||0===b[J])return null;for(var e=[],f=c||Kk,g=c=0,k,l;c<a[J]||g<b[J];)c<a[J]&&(k=f(a[c])),g<b[J]&&(l=f(b[g])),c<a[J]&&g<b[J]&&k==l?(e[B]({value:k,HE:c,JE:g}),c++,g++):c<a[J]&&(null==k||g==b[J]||k<l)?(e[B]({value:k,HE:c,JE:null}),c++):g<b[J]&&(null==l||c==a[J]||l<k)&&(e[B]({value:l,HE:null,JE:g}),g++);
var n=null,p=null;X(e,function(c){null==c.HE?c.HE=d(c[wd],a,n):n=c.HE;null==c.JE?c.JE=d(c[wd],b,p):p=c.JE});return e}function qV(a,b){for(var c in a)if(!Dj(b,c))return!1;return!0}function lKa(a,b,c,d){for(var e=1,f=0;1E3>f;f++){var g=mKa(a,b,c,e),k=mKa(a,b,c,0),l=$Ja(a,g,d),k=$Ja(a,k,d);if(l&&k)break;a=g;e*=.99}return a}function mKa(a,b,c,d){var e={};Zj(a,function(f,g){for(var k=f,l=0;l<b[J];l++)var n=(0,b[l])(a,g,d),k=c(k,n);e[g]=k});return e}
function rV(a,b,c){if(c)return sV(vj(a,Ni),b);var d=-1;for(c=0;c<a[J];c++)if(null===a[c]){d=Nj(a,d+1,c);d=sV(d,b);if(null!==d)return d;d=c}a=Nj(a,d+1);return sV(a,b)}function sV(a,b){var c=Oj(a,b,function(a,b){return Pj(a,b.x)});if(0<=c)return a[c].y;var d=-(c+1);if(0==d||d==a[J])return null;c=a[d-1];d=a[d];return nO(new mO(c.x,c.y,d.x,d.y),(b-c.x)/(d.x-c.x)).y};function tV(){return{transform:function(a){return a},inverse:function(a){return a}}}function nKa(a){var b=oKa(a);return{transform:function(a){var d=pKa(b,a,function(a){return a[tr]});return null===d?a:d[ys]+(a-d[tr])*d.mF},inverse:function(a){var d=pKa(b,a,function(a){return a[ys]});return null===d?a:0==d.mF?d[tr]:d[tr]+(a-d[ys])/d.mF}}}
function oKa(a){for(var b=[],c=0,d=null,e=0;e<a[J];e++){var f=a[e],g=f.soa,k=f[y],f=f.end,l=g/(f-k);null===d||d!=k?(d={source:k,target:k+c,mF:l},b[B](d)):(d=b[b[J]-1],d.mF=l);b[B]({source:f,target:k+c+g,mF:1});c+=g-(f-k);d=f}return b}function pKa(a,b,c){b=Oj(a,{source:b,target:b,mF:0},function(a,b){var f=c(a),g=c(b);return f<g?-1:f>g?1:0});0>b&&(b=-b-2);return 0>b?null:a[b]}function qKa(){return{transform:function(a){return h.log(a)/h[PB]},inverse:function(a){return h.pow(10,a)}}}
function rKa(a){return{transform:function(b){return b>a?h.log(b/a)/h[PB]:b<-a?-h.log(-b/a)/h[PB]:0},inverse:function(b){return 0<b?h.pow(10,b)*a:0>b?-h.pow(10,-b)*a:0}}}var sKa={XAa:xF,xAa:IG,MAa:iG};function uV(a,b,c){return(c=fp(a,c,sKa))?c:Lo(a,b)?IG:xF}function tKa(a,b,c){switch(a){case xF:return Ej(c)?tV():nKa(c);case IG:return qKa();case iG:return rKa(b);default:return tV()}};/*
 Portions of this code are from MochiKit, received by
 The Closure Authors under the MIT license. All other code is Copyright
 2005-2009 The Closure Authors. All Rights Reserved.
*/
function vV(a,b){this.af=[];this.Iea=a;this.Sda=b||null;this.qL=this.xE=!1;this.ht=void 0;this.f4=this.sra=this.x3=!1;this.nU=0;this.Xd=null;this.t3=0}R=vV[K];Rq(R,function(a){if(this.xE)this.ht instanceof vV&&this.ht[$r]();else{if(this.Xd){var b=this.Xd;delete this.Xd;if(a)b[$r](a);else b.t3--,0>=b.t3&&b[$r]()}this.Iea?this.Iea[L](this.Sda,this):this.f4=!0;this.xE||wV(this,new xV)}});R.gea=function(a,b){this.x3=!1;yV(this,a,b)};function yV(a,b,c){a.xE=!0;a.ht=c;a.qL=!b;uKa(a)}
R.Su=function(){if(this.xE){if(!this.f4)throw new zV;this.f4=!1}};R.kga=function(a){this.Su();yV(this,!0,a)};function wV(a,b){a.Su();yV(a,!1,b)}function vKa(a,b){AV(a,b,null,void 0)}function wKa(a,b){AV(a,null,b,void 0)}function AV(a,b,c,d){a.af[B]([b,c,d]);a.xE&&uKa(a)}R.then=function(a,b,c){var d,e,f=new ov(function(a,b){d=a;e=b});AV(this,d,function(a){a instanceof xV?f[$r]():e(a)});return f[vs](a,b,c)};Qja(vV);vV[K].kj=function(a){return a instanceof m};
function xKa(a){return yj(a.af,function(a){return Vi(a[1])})}
function uKa(a){if(a.nU&&a.xE&&xKa(a)){var b=a.nU,c=BV[b];c&&(Fi[fr](c.hc),delete BV[b]);a.nU=0}a.Xd&&(a.Xd.t3--,delete a.Xd);for(var b=a.ht,d=c=!1;a.af[J]&&!a.x3;){var e=a.af[wb](),f=e[0],g=e[1],e=e[2];if(f=a.qL?g:f)try{var k=f[L](e||a.Sda,b);Gi(k)&&(a.qL=a.qL&&(k==b||a.kj(k)),a.ht=b=k);Rja(b)&&(d=!0,a.x3=!0)}catch(l){b=l,a.qL=!0,xKa(a)||(c=!0)}}a.ht=b;if(d)if(k=U(a.gea,a,!0),d=U(a.gea,a,!1),b instanceof vV)AV(b,k,d),b.sra=!0;else b[vs](k,d);c&&(b=new yKa(b),BV[b.hc]=b,a.nU=b.hc)}
function zKa(a){var b=new vV;wV(b,a);return b}function zV(){aj[L](this)}W(zV,aj);Ga(zV[K],"Deferred has already fired");gb(zV[K],"AlreadyCalledError");function xV(){aj[L](this)}W(xV,aj);Ga(xV[K],"Deferred was canceled");gb(xV[K],"CanceledError");function yKa(a){this.hc=Fi[Dr](U(this.Kua,this),0);this.et=a}yKa[K].Kua=function(){delete BV[this.hc];throw this.et;};var BV={};function AKa(a,b){var c=b||{},d=c[ce]||ea,e=Sl(hg),f={mga:e,kf:void 0},g=new vV(BKa,f),k=null,l=null!=c.timeout?c.timeout:5E3;0<l&&(k=ba[Dr](function(){CV(e,!0);wV(g,new DV(1,tAa+a))},l),f.kf=k);qq(e,Qq(e,function(){e[fs]&&e[fs]!=dsa&&e[fs]!=wt||(CV(e,c.Oea||!1,k),g.kga(null))}));e.onerror=function(){CV(e,!0,k);wV(g,new DV(0,EBa+a))};Nl(e,{type:li,charset:oAa,src:a});CKa(d)[q](e);return g}
function EV(a,b){Fi.closure_verification||(Fi.closure_verification={});var c=Fi.closure_verification;if(Gi(c[b]))return zKa(new DV(3,kAa+b+PFa));var d=AKa(a,{Oea:!0}),e=new vV(U(d[$r],d));vKa(d,function(){var d=c[b];Gi(d)?(e.kga(d),delete c[b]):wV(e,new DV(2,KAa+a+NFa+b+LFa))});wKa(d,function(a){Gi(c[b])&&delete c[b];wV(e,a)});return e}function CKa(a){var b=a[kc](tBa);return!b||Ej(b)?a[lc]:b[0]}function BKa(){if(this&&this.mga){var a=this.mga;a&&a[$c]==hg&&CV(a,!0,this.kf)}}
function CV(a,b,c){null!=c&&Fi[fr](c);qq(a,Ji);a.onerror=Ji;Qq(a,Ji);b&&ba[Dr](function(){am(a)},0)}function DV(a,b){var c=jBa+a+ef;b&&(c+=kM+b);aj[L](this,c);this.code=a}W(DV,aj);var __flash_unloadHandler,__flash_savedUnloadHandler;/*
 SWFObject v1.5: Flash Player detection and embed -
 http://blog.deconcept.com/swfobject/

 SWFObject is (c) 2007 Geoff Stearns and is released under the MIT License:
 http://www.opensource.org/licenses/mit-license.php

*/
function FV(a,b,c,d,e,f,g,k,l,n){if(ea[ud]){this.lta=n?n:Yva;t:{n=this.lta;var p=ea[Fc][Kc]||ea[Fc].hash;if(null==n)n=p;else{if(p)for(var p=p[we](1)[zc](We),t=0;t<p[J];t++)if(p[t][we](0,p[t][zd](Df))==n){n=p[t][we](p[t][zd](Df)+1);break t}n=M}}this.ita=n;this.ca={};this.en={};this.attributes=[];a&&this[v](BD,a);b&&this[v](qH,b);c&&this[v](yi,c);d&&this[v](rh,d);e&&this[v](SC,new GV(e[qc]()[zc](mf)));t:if(a=new GV([0,0,0]),Yx.plugins&&Yx.mimeTypes[J])(b=Yx.plugins[GAa])&&b.description&&(a=new GV(b.description[Ab](/([a-zA-Z]|\s)+/,
M)[Ab](/(\s+r|\s+b[0-9]+)/,mf)[zc](mf)));else if(Yx[Cc]&&0<=Yx[Cc][zd](hAa))for(b=1,c=3;b;)try{c++,b=new ActiveXObject(EAa+c),a=new GV([c,0,0])}catch(u){b=null}else{b=null;try{b=new ActiveXObject(CAa)}catch(x){try{b=new ActiveXObject(DAa),a=new GV([6,0,21]),b.Wya=$K}catch(A){if(6==a.UE)break t}try{b=new ActiveXObject(FAa)}catch(C){}}null!=b&&(a=new GV(b.GetVariable(JEa)[zc](Ke)[1][zc](jf)))}this.DU=a;!ba.opera&&ea.all&&7<this.DU.UE&&(DKa=!0);f&&(this.ca.bgcolor=f);this.ca.quality=g?g:AH;this[v](Qma,
!1);this[v](HI,!1);this[v](uma,k?k:ba[Fc]);this[v](hF,M);l&&this[v](hF,l)}}var DKa;
ob(FV,{setAttribute:function(a,b){this[gB][a]=b},getAttribute:function(a){return this[gB][a]},getParams:function(){return this.ca},write:function(a){if(this[oe](Qma)&&HV(this.DU,new GV([6,0,65]))&&!HV(this.DU,this[oe](SC))){this[v](HI,!0);var b=Wx(this[oe](uma));this.en.MMredirectURL=b;Xq(ea,ea[bC][qd](0,47)+VFa);this.en.MMdoctitle=ea[bC]}if(this.ita||this[oe](HI)||HV(this.DU,this[oe](SC))){a=typeof a==ii?ea[ud](a):a;b=M;if(Yx.plugins&&Yx.mimeTypes&&Yx.mimeTypes[J]){this[oe](HI)&&(this.en.MMplayerType=
VAa,this[v](BD,this.rva));var b=rCa+this[oe](BD)+DFa+this[oe](yi)+HFa+this[oe](rh)+EFa+this[oe](ji)+Me,b=b+(BN+this[oe](qH)+GFa+this[oe](qH)+zN),c=this.getParams(),d;for(d in c)b+=[d]+Ef+c[d]+zN;d=EKa(this)[Fe](We);0<d[J]&&(b+=Pua+d+Me);b+=kDa}else{this[oe](HI)&&(this.en.MMplayerType=dCa,this[v](BD,this.rva));b=mCa+this[oe](qH)+IFa+this[oe](yi)+HFa+this[oe](rh)+EFa+this[oe](ji)+xN;b+=jCa+this[oe](BD)+Ne;c=this.getParams();for(d in c)b+=lCa+d+yN+c[d]+Ne;d=EKa(this)[Fe](We);0<d[J]&&(b+=kCa+d+Ne);b+=
ACa}Xa(a,b);return!0}this[oe](hF)!=M&&ea[Fc][Ab](this[oe](hF));return!1}});function EKa(a){var b=[],c;a=a.en;for(c in a)b[b[J]]=c+Df+a[c];return b}function GV(a){this.UE=null!=a[0]?ja(a[0],10):0;this.yV=null!=a[1]?ja(a[1],10):0;this.rev=null!=a[2]?ja(a[2],10):0}function HV(a,b){return a.UE<b.UE?!1:a.UE>b.UE?!0:a.yV<b.yV?!1:a.yV>b.yV?!0:a.rev<b.rev?!1:!0}function FKa(){for(var a=ea[kc](Zaa),b=a[J]-1;0<=b;b--){Qa(a[b][w],O);for(var c in a[b])typeof a[b][c]==kh&&(a[b][c]=function(){})}}
if(DKa&&!GKa){ba.attachEvent("onbeforeunload",function(){__flash_unloadHandler=function(){};__flash_savedUnloadHandler=function(){};ba.attachEvent(ora,FKa)});var GKa=!0}!ea[ud]&&ea.all&&(ea.getElementById=function(a){return ea.all[a]});var IV={},HKa=!1;
function IKa(a){if(!HKa){var b={colors:[{color:SEa,dark:pFa,light:MEa},{color:lFa,dark:oFa,light:PEa},{color:TEa,dark:qFa,light:LEa},{color:rFa,dark:wFa,light:UEa},{color:NEa,dark:VEa,light:QEa},{color:uFa,dark:xFa,light:mFa}],backgroundColor:{gradient:{color1:vFa,color2:AFa,x1:CM,y1:CM,x2:AM,y2:AM}},titleTextStyle:{color:xi},hAxis:{textStyle:{color:xi},titleTextStyle:{color:xi}},vAxis:{textStyle:{color:xi},titleTextStyle:{color:xi}},legend:{textStyle:{color:xi}},chartArea:{backgroundColor:{stroke:$M,fill:O}},
areaOpacity:.8};IV.classic=b;b={titlePosition:pH,axisTitlesPosition:pH,legend:{position:pH},chartArea:{width:AM,height:AM},vAxis:{textPosition:pH},hAxis:{textPosition:pH}};IV.maximized=b;b={enableInteractivity:!1,legend:{position:O},seriesType:Hg,lineWidth:1.6,chartArea:{width:AM,height:AM},vAxis:{textPosition:O,gridlines:{color:O},baselineColor:O},hAxis:{textPosition:O,gridlines:{color:O},baselineColor:O}};IV.sparkline=b;b={bar:{groupWidth:QCa},textStyle:{color:lN,fontName:xL},annotations:{textStyle:{color:lN,
fontName:xL}},bubble:{highContrast:!0,textStyle:{auraColor:O,color:yFa,fontName:xL}},tooltip:{textStyle:{color:lN,fontName:xL}},vAxis:{textStyle:{color:lN,fontName:xL,fontSize:12},gridlines:{color:$M},baselineColor:tFa},legend:{newLegend:!0,pagingTextStyle:{fontName:xL},textStyle:{auraColor:O,color:lN,fontName:xL,fontSize:12}},hAxis:{textStyle:{color:lN,fontName:xL,fontSize:12},gridlines:{color:$M},baselineColor:tFa},pieSliceTextStyle:{color:Se,fontName:xL,fontSize:14},pieResidueSliceColor:lN,titleTextStyle:{color:lN,
fontName:xL,fontSize:16,bold:fh},scatter:{dataOpacity:.6},colorAxis:{colors:[],"one-sided-colors":[Se,GS[sM]],"two-sided-colors":[GS[sM],Se,IS[qM]],legend:{textStyle:{color:lN,fontName:xL,fontSize:12}}},colors:[{color:GS[sM],dark:GS[mM],light:GS[BM]},{color:HS[sM],dark:HS[lM],light:HS[BM]},{color:IS[qM],dark:IS[mM],light:IS[BM]},{color:JS[sM],dark:JS[nM],light:JS[BM]},{color:KS[tM],dark:KS[mM],light:KS[BM]},{color:LS[qM],dark:LS[mM],light:LS[BM]},{color:MS[tM],dark:MS[nM],light:MS[BM]},{color:NS[mM],
dark:NS[lM],light:NS[BM]},{color:OS[tM],dark:OS[qM],light:OS[BM]},{color:PS[$Ca],dark:PS[sM],light:PS[BM]},{color:QS[nM],dark:QS[lM],light:QS[BM]},{color:PS[nM],dark:PS[lM],light:PS[bDa]}]};IV.material=b;HKa=!0}return IV[a]}function JV(a){var b={};Ya(b,a[F]||a);var c=co(b[F]);c==O?(b.wb=a.darker||c,b.jj=a.lighter||c):(c=xn(c),b.wb=a.darker||vn(Cn(c,.25)),b.jj=a.lighter||vn(Dn(c,.25)));return b};function JKa(a,b){this.hL=a||[];KKa(this,b)}var LKa=[WL,"Comic Sans MS","Courier New","Georgia","Impact","Times New Roman","Trebuchet MS","Verdana"];function MKa(){return function(a,b){return b===aI&&!Dj(LKa,a)}}function KKa(a,b){var c=Ii(iAa);0!==a.hL[J]&&c?c[td]({google:{families:a.hL},active:function(){b[zs]()},fontinactive:function(){b.reject($Aa)}}):b[zs](null)};function NKa(a){this.kxa=a}var OKa=aV("regioncoder",pf)+"geocodes",KV={};function PKa(a,b){a=ej(a[He]());a=aa(String(a));var c=KV[a];if(null==c){KV[a]=[b];var c=OKa+Gs+a+zDa,d=uga(),e=ea[Vb](bi);db(e,li);e.src=c;d[q](e);sv(Yi(QKa,a,null),5E3)}else Li(c)==Lg?Dj(c,b)||c[B](b):sv(Yi(b,c),0)}function QKa(a,b){if(b){var c=new NKa(b),d=KV[a];if(Li(d)==Lg){KV[a]=c;for(var e=0;e<d[J];e++)d[e](c)}}else if(d=KV[a],Li(d)==Lg)for(KV[a]=null,e=0;e<d[J];e++)d[e](null)}
function RKa(a,b){b=ej(b[He]());return a.kxa[b]}
var SKa=["AD","AE","AF","AG","AL","AM","AO","AR",YL,"AU","AZ","BA","BB","BD","BE","BF","BG","BH","BI","BJ","BN","BO",If,"BS","BT","BW","BY","BZ","CA","CD","CF","CG","CH","CI","CL","CM","CN","CO","CR","CS","CU","CV","CY","CZ","DE","DJ","DK","DM","DO","DZ","EC","EE","EG","ER","ES","ET","FI","FJ","FM","FR","GA","GB","GD","GE","GH","GM","GN","GQ","GR","GT","GW","GY","HN",Uf,"HT","HU","ID","IE","IL","IN","IQ","IR","IS","IT","JM","JO","JP","KE","KG","KH","KI","KM","KN","KP","KR","KW","KZ","LA","LB",HL,
"LK","LR","LS","LT","LU","LV","LY","MA","MD","ME","MG","MH","MK","ML","MM","MN","MR","MT","MU","MV","MW","MX","MY","MZ","NA","NE","NG","NI","NL","NO","NP","NR","NZ","OM","PA","PE","PG","PH","PK","PL","PT","PW","PY","QA","RO","RS","RU","RW","SA","SB","SC","SD","SE","SG","SH","SI","SK","SL","SM","SN","SO","SR","ST","SV","SY","SZ",og,"TG","TH","TJ",qg,"TM","TN","TO",tg,"TT","TV","TW","TZ","UA","UG","UM",pL,"UY","UZ","VC","VE","VN","VU","WS","YE","YU","ZA","ZM","ZW"];Hi("gviz.util.RegionCoder.dictionaryReady",QKa,void 0);var TKa={BV:th,DV:ui};
function LV(a,b,c,d){var e={},f={},g=b.W$||Zp;if(b[QB]==th){var f=b.ba,e=a.Yk[0],k=a.Yk[a.Yk[J]-1],g=new Yp({pattern:g}),e=g.Sc(e),k=g.Sc(k),f={Hg:{text:e,width:d?d(e,f)[r]:0,height:f[Gc]},bh:{text:k,width:d?d(k,f)[r]:0,height:f[Gc]}};d=f.Hg[z]/4;e=new xm(f.Hg[r]+d,0,b[r]-(f.Hg[r]+f.bh[r]+2*d),b[z])}else e=new xm(0,0,b[r],b[z]);d=.33*e[z];var k=2*(d/h[Kd](3)),g=new xm(e[G]+k/2,e.top+d+1,e[r]-k,e[z]-d-1),l=a.Gv,n=a.Yk,p=n[n[J]-1]-n[0],t;if(0==p)t=[{th:new xm(g[G],g.top,g[r],g[z]),brush:new lo({fill:l[0]})}];
else{t=[];for(var p=g[r]/p,u=g[G],x=0,A=0;A<n[J]-1;++A)x=u+(n[A+1]-n[A])*p,t[A]={th:new xm(u,g.top,x-u,g[z]),brush:new lo({gradient:{x1:u,y1:0,Fb:x,Kb:0,kg:l[A],Nf:l[A+1]}})},u=x}g=t;if(null!=g&&0<g[J]&&(0>g[0].th[r]||0>g[0].th[z]))return null;l=e;n=b.V$;e=[];for(t=0;t<c[J];++t)p=c[t][wd],u=a.Yk,p<u[0]?p=0:(x=l[r]-k,p>u[u[J]-1]?p=x:(A=u[u[J]-1]-u[0],p=0==A?.5*x:(p-u[0])/A*x)),p=l[G]+p+k/2,p=[p-k/2,l.top,p+k/2,l.top,p,l.top+d],u=new lo({fill:n,stroke:n}),e[t]={path:p,brush:u};a=[];b[QB]==th&&(a=f,
c=[],c[0]={x:0,y:b[z]-a.Hg[z],text:a.Hg[pd],style:b.ba},c[1]={x:b[r]-a.bh[r],y:b[z]-a.bh[z],text:a.bh[pd],style:b.ba},a=c);a={j_:g,k_:e,l_:a};f=a.j_;for(c=0;c<f[J];++c)d=f[c],b[QB]==ui&&(k=d.th[G],$a(d.th,d.th.top),d.th.top=k,k=d.th[r],na(d.th,d.th[z]),Ta(d.th,k)),$a(d.th,d.th[G]+b[G]),d.th.top+=b.top,k=d.brush[Jc](),d.brush=k,d=k.Jg,b[QB]==ui&&(d.y1=d.x1,d.x1=0,d.Kb=d.Fb,d.Fb=0),null!=d&&(d.x1+=b[G],d.y1+=b.top,d.Fb+=b[G],d.Kb+=b.top);f=a.k_;for(c=0;c<f[J];++c)for(d=0;3>d;++d)b[QB]==ui&&(k=f[c][LB][2*
d],f[c][LB][2*d]=f[c][LB][2*d+1],f[c][LB][2*d+1]=k),f[c][LB][2*d]+=b[G],f[c][LB][2*d+1]+=b.top;f=a.l_;for(c=0;c<f[J];++c)f[c].x+=b[G],f[c].y+=b.top;return a};var UKa={Sza:Gwa,vBa:Tna,Tza:$I,aBa:mF,IAa:pG};function MV(a){this.b=a||{}}MV[K].FY=function(){return 1.618};MV[K].set=function(a,b){this.b[a]=b};MV[K].Pc=function(){return nk(this.b)};function NV(a){var b=0,c=0;if(a.boundingBox)var d=a.boundingBox.lo,c=a.boundingBox.hi,b=(c[0]-d[0])/2+d[0],c=(c[1]-d[1])/2+d[1];d=[29.5,45.5];b={parallels:d,origin:{lat:b,lng:c}};c=b[dr];a[dr]&&pk(c,a[dr]);pk(b,a);Zx(b,c);b.jm&&0!==b.jm[J]?2>b.jm[J]&&(b.jm[1]=h.abs(b.jm[0]-d[0])>h.abs(b.jm[0]-d[1])?d[0]:d[1]):b.jm=d;this.b=a||{};this.W1=b[dr].lat/(180/h.PI);this.QS=b[dr].lng/(180/h.PI);this.Wo=wj(b.parallels,function(a){return a/(180/h.PI)})}W(NV,MV);
NV[K].kF=function(a){return wj(arguments,U(function(a){var c=a[0]/(180/h.PI),d=.5*(h.sin(this.Wo[0])+h.sin(this.Wo[1]));a=d*(a[1]/(180/h.PI)-this.QS);var e=h.cos(this.Wo[0]),e=e*e+2*d*h.sin(this.Wo[0]),c=h[Kd](e-2*d*h.sin(c))/d,d=h[Kd](e-2*d*h.sin(this.W1))/d;return{x:180/h.PI*h.sin(a)*c,y:180/h.PI*(d-c*h.cos(a))}},this))};function OV(a){this.b=a||{}}W(OV,MV);OV[K].FY=function(){return 2.2};OV[K].kF=function(a){return wj(arguments,function(a){var c=a[0]/(180/h.PI);a=a[1]/(180/h.PI)*3/(2*h.PI)*(180/h.PI);return{x:h[Kd](h.PI*h.PI/3-c*c)*a,y:c}})};function PV(a){var b=0,c=0;if(a.boundingBox)var d=a.boundingBox.lo,c=a.boundingBox.hi,b=(c[0]-d[0])/2+d[0],c=(c[1]-d[1])/2+d[1];d=[20,50];b={parallels:d,origin:{lat:b,lng:c}};c=b[dr];a[dr]&&pk(c,a[dr]);pk(b,a);Zx(b,c);b.jm&&0!==b.jm[J]?2>b.jm[J]&&(b.jm[1]=h.abs(b.jm[0]-d[0])>h.abs(b.jm[0]-d[1])?d[0]:d[1]):b.jm=d;this.b=a||{};this.W1=b[dr].lat/(180/h.PI);this.QS=b[dr].lng/(180/h.PI);this.Wo=wj(b.parallels,function(a){return a/(180/h.PI)})}W(PV,MV);
PV[K].kF=function(a){return wj(arguments,U(function(a){var c=a[0]/(180/h.PI);a=a[1]/(180/h.PI);var d=h.log(1/h.cos(this.Wo[1])*h.cos(this.Wo[0]))/h.log(h.tan(.25*h.PI+.5*this.Wo[1])*(1/h.tan(.25*h.PI+.5*this.Wo[0]))),e=h.cos(this.Wo[0])*h.pow(h.tan(.25*h.PI+.5*this.Wo[0]),d)/d,c=e*h.pow(1/h.tan(.25*h.PI+.5*c),d),e=e*h.pow(1/h.tan(.25*h.PI+.5*this.W1),d);return{x:180/h.PI*h.sin(d*(a-this.QS))*c,y:e-180/h.PI*h.cos(d*(a-this.QS))*c}},this))};function QV(a){return 180/h.PI*(h.atan(h.exp(a/(180/h.PI)))-h.PI/4)*2}function RV(){this.fr={}}RV[K].track=function(a){X(arguments,U(function(a){for(var c in a)if(a[Hc](c)){c in this.fr||(this.fr[c]={min:da,max:-da});if(!this.fr[c].min||a[c]<this.fr[c].min)this.fr[c].min=a[c];if(!this.fr[c].max||a[c]>this.fr[c].max)this.fr[c].max=a[c]}},this))};RV[K].getBounds=function(a){return{min:this.fr[a].min,max:this.fr[a].max}};function SV(a){this.b=a||{}}W(SV,MV);SV[K].kF=function(a){return wj(arguments,function(a){return{x:a[1],y:180/h.PI*h.log(h.tan(a[0]/180*.5*h.PI+h.PI/4))}})};var VKa={nza:"albers",rAa:Vsa,uAa:"lambert",HAa:qG},TV={};TV.mercator=SV;TV[Vsa]=OV;TV.albers=NV;TV.lambert=PV;var WKa={NONE:O,TOP_LEFT:iD,TOP_RIGHT:ina,BOTTOM_LEFT:rK,BOTTOM_RIGHT:"bottom_right"},XKa={NONE:O,cBa:fF,Cza:qK,qz:Rg};function YKa(a){return Io(a,sqa,{name:qG},function(a){Ri(a)||(a={name:a});var c=a[Nd];if(null!=c&&!gk(VKa,Vo(c)))throw m("The projection you specified is not valid.");return a})}
var ZKa={region:KC,resolution:$I,domain:QL,displayMode:Mg,showGeocodeWarnings:!1,backgroundColor:{fill:xi,stroke:nN,strokeWidth:0},datalessRegionColor:"F5F5F5",defaultColor:"267114",markerOpacity:1,selectionMode:ei,fontName:WL,geocodingContext:fF,tooltip:{isHtml:!1,textStyle:{fontName:WL,fontSize:13,color:AK},trigger:ih,showDisputedText:!1,showTitle:!0},colorAxis:{minValue:null,maxValue:null,values:null},sizeAxis:{minValue:null,maxValue:null,minSize:3,maxSize:12},legend:{position:rK,orientation:th,
textStyle:{color:AK,auraColor:xi}},marker:{style:{stroke:{color:cN,width:1}}},projection:qG,keepAspectRatio:!0,magnifyingGlass:{enable:!0,zoomFactor:5}};function UV(a){Ju[L](this);this.fd=a;this.sE=null;this.Ada=!0;this.vL=null;this.Jp=new uw;this.xua=/^([a-zA-Z][a-zA-Z]|[a-zA-Z][a-zA-Z]\-[a-zA-Z0-9](|[a-zA-Z0-9](|[a-zA-Z0-9]))|\d\d\d)$/;this.yua=/^\d\d\d$/}W(UV,Ju);R=UV[K];R.m4=function(a){this.sE=a;null!=this.Zva&&this.Zva(a)};function $Ka(a,b,c,d,e,f){a.Ada=e;if(0==b.O())sv(function(){f([],[],!0)});else switch(c.I_){case Nt:a.XY(b,c,f);break;case Zt:aLa(a,b,c,d,f);break;case ot:a.WY(b,c,d,f)}}
R.XY=function(a,b,c){for(var d=[],e=0;e<a.O();e++){var f=a[I](e,b.FC),g=a[I](e,b.GC);d[e]=null==f||null==g?null:{lat:kj(f),lng:kj(g)}}sv(function(){c([],d,!0)})};function aLa(a,b,c,d,e){for(var f=[],g=0;g<b.O();g++)f[B](b[I](g,c.$I));d[pA]==pG||d[pA]==Gwa||d[pA]==Tna?a.YY(d,f,e):a.ZY(d,f,e)}R.YY=function(a,b,c){a=bj(a[wB],pL)&&a[pA]==pG;for(var d=[],e=0;e<b[J];e++){var f=kj(b[e]);a&&this.yua[od](f)&&(f=oL+f);d[B](f[De]())}sv(function(){c(d,[],!0)})};
R.ZY=function(a,b,c){var d=a[wB],e;e=a[pA]==mF&&0<=Oj(SKa,d)?d:Ewa;if(a[pA]==mF&&d==pL)for(a=0;a<b[J];++a){var f=b[a];2==f[J]&&(b[a]=oL+f)}PKa(e,this.Xi(function(a){a=this.J0(b,a);for(var e=[],f=0;f<b[J];f++)if(null==a[f]){var n=b[f];e[B]({address:n,lea:f,kea:null});a[f]=n}Ej(e)?c(a,[],!0):(c(a,[],!1),bLa(this,e,d,c,a))}))};R.J0=function(a,b){for(var c=[],d=0;d<a[J];++d){var e=ej(kj(a[d]))[He](),f=b&&RKa(b,e),e=f?f:this.xua[od](e)?e[De]():null;c[B](e)}return c};
function VV(a,b){a.Ada&&a.fd&&lw(a.fd,b)}R.WY=function(a,b,c,d){var e=[];c=c[wB];2==c[J]&&(c=c[De](),c=c[Ab](/GB/,qAa),c=c[Ab](/RU/,MAa),c=c[Ab](/TP/,qg));for(var f=0;f<a.O();f++){var g=kj(a[I](f,b.aJ));cLa(this,c)&&(g+=Ke+c);e[B]({address:g,kea:f,lea:null})}bLa(this,e,c,d,[])};function cLa(a,b){return b==KC||dj(b)?!1:a.vL===fF||a.vL===Rg}
function dLa(a){var b=da,c=da,d=-da,e=-da;if(null!=a.sE&&0!==a.sE[BA][J])return X(a.sE[BA],function(a){a=a.ru;b=h.min(b,a.jh[0]);c=h.min(b,a.jh[1]);d=h.max(d,a.oi[0]);e=h.max(d,a.oi[1])}),{lo:{lat:b,lng:c},hi:{lat:d,lng:e}}}function bLa(a,b,c,d,e){for(var f=[],g=0;g<b[J];g++){var k={address:b[g].address};cLa(a,c)&&(k.region=c);a.vL!==qK&&a.vL!==Rg||(k.bounds=dLa(a));f[B](k)}b=Lj(b);d=U(a.K0,a,b,d,e,[]);a.Jp[xr](f,d,1)}
R.K0=function(a,b,c,d,e){for(var f=e[J],g=0;g<f;g++){var k=a[g],l=k.address,n=k.lea,p=k.kea;if(e[g]&&e[g][0]){k=e[g][0];if(null!=n){var t=n,u=k.address_components,x=null;1==u[J]&&0<=sj(u[0].types,Dwa)?x=u[0].short_name:2==u[J]&&u[1].short_name==pL&&(x=oL+u[0].short_name);c[t]=x;c[n]||(VV(this,BBa+l+Me),c[n]=l)}null!=p&&(l=p,n=k,n={lat:n[bA][Fc].lat(),lng:n[bA][Fc].lng()},d[l]=n)}else null!=n&&(c[n]=null),null!=p&&(d[p]=null),VV(this,BBa+l+Me)}Hj(a,0,f);(a=Ej(a))&&zj(c,Mi)&&zj(d,Mi)&&VV(this,xBa);
b(c,d,a)};R.Xi=function(a){return U(a,this)};R.D=function(){this.Jp[$r]();UV.e.D[L](this)};function eLa(a,b,c){for(var d=0;d<a[J];++d)b.eb(a[d].th[G],a[d].th.top,a[d].th[r],a[d].th[z],a[d].brush,c)}function fLa(a,b,c){for(var d=0;d<a[J];++d){var e=new bO;e[yB](a[d][LB][0],a[d][LB][1]);e.ha(a[d][LB][2],a[d][LB][3]);e.ha(a[d][LB][4],a[d][LB][5]);e[Hr]();b.ta(e,a[d].brush,c)}}function gLa(a,b,c){for(var d=0;d<a[J];++d)b.Jd(a[d][pd],a[d].x,a[d].y,1,TD,TD,a[d][w],c)};function WV(a){return a[Fe](mf)};function XV(a,b,c){Ju[L](this);this.j=b;this.bf=U(this.j.bf,this.j);this.uk=a;this.zx=[];this.nb=c;this.sd={};this.xc=new hv;this.w_=this.Zw=this.lx=this.nx=this.ex=this.Hu=this.IB=null}W(XV,Ju);XV[K].k=function(a,b){$u(this.xc,a,b)};
function hLa(a,b){var c=a.j;c[bc]();var d=c.xm(b[r],b[z]);a.sd={};var e=c.Ba();iLa(a,e,b,new xm(0,0,b[r],b[z]),!1);var f=c.Ba(),g=a.j,k=g.Ba();a.ex=g.Ba();for(var l=0;l<b[BA][J];++l)jLa(a,k,b,b[BA][l],!1),kLa(a,b,b[BA][l]);a.Hu=g.Ba();YV(a,a.Hu,b.hA,!1,b.kk);g[q](f,k);g[q](f,a.ex);g[q](f,a.Hu);g=b.Aia;f=c.cG(f,a.eD()?new xm(g[G],g.top,g[r]-1,g[z]-1):g);a.lx=c.Ba();lLa(a,b);a.Zw=c.Ba();mLa(a,b);a.nx=c.Ba();nLa(a,b);c[q](d,e);c[q](e,f);c[q](e,a.lx);c[q](e,a.Zw);c[q](e,a.nx);a.IB=b;oLa(a,d)}
function ZV(a,b,c){c=c||!1;a.j.Oc(a.nx);nLa(a,b);if(c||!Bo(a.IB.$A,b.$A))for(a.j.Oc(a.ex),c=0;c<b[BA][J];++c)kLa(a,b,b[BA][c]);pLa(a,b);a.j.Oc(a.lx);lLa(a,b);a.w_!=(b.VF?b.VF.Vn:null)&&(a.j.Oc(a.Zw),mLa(a,b));a.IB=b}function kLa(a,b,c){var d=a.j.Ba();c=vj(c.X,function(a){return Dj(b.$A,a.id)});for(var e=0;e<c[J];++e)qLa(a,d,b,c[e]);a.j[q](a.ex,d)}function rLa(a,b){var c=a.j;X(bm(a.Hu.a()),function(a){X(bm(a),function(a){c.Wf(a)},this)},a);YV(a,a.Hu,b.hA,!1,b.kk)}
var sLa=new lo({strokeWidth:vf,stroke:AK,strokeOpacity:"0.2"}),tLa=new lo({strokeWidth:tf,stroke:AK,strokeOpacity:"0.1"});function qLa(a,b,c,d){a.eD()||(c=c.OA[d.id].ne,$V(a,b,d,!1,!1,[sLa,tLa,c[nc]]),Ej(d.kn)||($V(a,b,d,!0,!1,[c.kn]),$V(a,b,d,!1,!1,[c.border])))}
function mLa(a,b){var c=b.VF;if(c){var d=a.Zw,e=a.j,f=c[xs].HA,g=f[G]+f[r]/2,k=f.top+f[z]/2,l=f[r]/2,n=f[z]/2,p=c.Z8.x,t=c.Z8.y,u=new lo({fill:PCa,fillOpacity:.25}),x=new bO;x[yB](p,t);x.ha(p,t+(k>t?n:-n));x.ha(p+(g>p?l:-l),t);x[Hr]();p=e.ta(x,u,d);aW(a,p,EG,!0);p=new lo({fill:xi});p=e.zj(g,k,l,n,p,d);aW(a,p,FG,!0);p=new lo({stroke:pya,strokeWidth:1.5});p=e.zj(g,k,l,n,p,d);aW(a,p,FG,!0);p=e.Ba();f=e.cG(p,new xm(f[G]+3.5,f.top+3.5,f[r]-7,f[z]-7),!0);e[q](d,f);f=new lo({stroke:Qxa,strokeWidth:1.5});
d=e.zj(g,k,l-3.5,n-3.5,f,d);aW(a,d,FG,!0);d=c[xs];iLa(a,p,b,d.HA,!0);jLa(a,p,b,d,!0);YV(a,p,c.hA,!0,b.kk);a.w_=c.Vn}else a.w_=null}function nLa(a,b){0<a.zx[J]&&(X(a.zx,function(a){this.j.Wf(a)},a),a.zx=[]);a.zx=0<b.Cr[J]?wj(b.Cr,function(a){return a[AA]?dV(a,this.uk[Sr]()):eV(a,this.j,this.nx).a()},a):[]}function uLa(a,b){Zj(b.OA,function(a,b){var e=a.ne;bW(this,b,sI,e[nc]);bW(this,b,Eva,e.kn);bW(this,b,wK,e.border)},a)}
function bW(a,b,c,d){b=WV([c,b]);b=a.sd[b];if(null!=b)for(c=0;c<b[J];++c)a.j.nj(b[c],d)}function oLa(a,b){var c=a.Xi(function(a){var b=vLa(this,a[ys]);if(b&&b.$Q){var c=wLa(a[H],b[H]),d=b[GB],b=mk(b[Y]);a[H]==Ut?b.co=!1:a[H]==Vt&&(b.co=!0);b.xb=kO(a);this.xc[ir]({type:c,elementType:d,data:b})}}),d=a.j;d.fc(b,dG,c);d.fc(b,Ut,c);d.fc(b,Vt,c);d.fc(b,vt,c)}
function wLa(a,b){switch(b){case sI:switch(a){case vt:return rI;case dG:return pI;case Ut:case Vt:return qI}case AG:switch(a){case vt:return zG;case dG:return Pra;case Ut:case Vt:return yG}}return null}function aW(a,b,c,d){cW(a,b,[Rf,c,tf,d?tf:pf,M,pf])}function cW(a,b,c){c=c[Fe](Oe);a.j.qo(b,c)}
function vLa(a,b){var c=a.j.sv(b);if(!c||c==Dg)return null;var c=c[zc](Oe),d=c[1],e=c[2]==tf?!0:!1,f=c[3]==tf?!0:!1;switch(c[0]){case Rf:return{type:sI,elementType:d,$Q:e,data:{bK:f,featureId:c[4]?c[4]:null,bI:c[5]==tf?!0:!1}};case Xf:return{type:AG,elementType:d,$Q:e,data:{bK:f,Vn:c[4],Pi:oj(c[5]),AA:c[6]==tf?!0:!1}};default:return null}}function iLa(a,b,c,d,e){b=a.j.eb(d[G],d.top,d[r],d[z],c.pF,b);aW(a,b,rra,e)}
function jLa(a,b,c,d,e){for(var f=a.j.Ba(),g=0;g<d.X[J];++g){var k=a,l=f,n=d.X[g],p=e,t=c.OA[n.id].ne;$V(k,l,n,!1,p,[t[nc]],sI);Ej(n.kn)||($V(k,l,n,!0,p,[t.kn],Eva),$V(k,l,n,!1,p,[t.border],wK))}a.j[q](b,f)}
function $V(a,b,c,d,e,f,g){var k=d?c.kn:c.wD,l=c.id;(g=null!=g?WV([g,l]):null)&&(a.sd[g]=a.sd[g]||[]);for(l=0;l<k[J];++l){var n;n=k[l];var p=new bO;xLa(p,n.tK,YF);for(var t=0;t<n.sK[J];t++)xLa(p,n.sK[t],lpa);n=p;if(0<n.md[J])for(p=0;p<f[J];++p)if(t=a.j.ta(n,f[p],b))cW(a,t,[Rf,sI,c.$Q?tf:pf,e?tf:pf,c.id,d?tf:pf]),g&&a.sd[g][B](t)}}
function xLa(a,b,c){b=b.l;var d=b[J];if(!(1>=d)){var e=c==YF?0:d-1,d=c==YF?d:-1;c=c==YF?1:-1;for(var f=e;f!=d;f+=c){var g=b[f][0],k=b[f][1];f==e?a[yB](g,k):a.ha(g,k)}a[Hr]()}}
function YV(a,b,c,d,e){var f=a.j;c=Lj(c);Qj(c,function(a,b){return b[EA]-a[EA]});for(var g=0;g<c[J];++g){var k=c[g],l=f.Ba();cW(a,l,[Xf,AG,tf,d?tf:pf,k.Vn,k.Pi,k.AA?tf:pf]);f[q](b,l);a.nb.f6===hu?f.Jd(k[dd],k.x,k.y,20,dK,dK,{$a:e,fontSize:k[EA],color:k.brush.fb(),opacity:k.brush.Oe,lc:M,bold:!1,Re:!1,Tc:!1},l):f.ce(k.x,k.y,k[EA],k.brush,l);k=WV([AG,k.Vn]);a.sd[k]=l.a()}}
function pLa(a,b){var c=a.j,d=a.IB.cB;X(d,function(a){if(!Dj(b.cB,a)){a=WV([AG,a]);a=bm(this.sd[a]);for(var d=1;d<a[J];++d)c.Wf(a[d])}},a);X(b.cB,function(a){if(!Dj(d,a)){a=WV([AG,a]);a=this.sd[a];var b=cm(a).cloneNode(!0);c.nj(b,sLa);a[q](b)}},a)}function lLa(a,b){if(b.Gi){var c=b.Gi,d=a.j,e=a.lx;eLa(c.j_,d,e);fLa(c.k_,d,e);gLa(c.l_,d,e)}}
XV[K].D=function(){fv(this.xc);0<this.zx[J]&&(X(this.zx,function(a){this.j.Wf(a)},this),this.zx=[]);this.j[bc]();Lu(this.IB);this.IB=null;this.Hu&&this.j.Wf(this.Hu.a());this.Hu=null;this.ex&&this.j.Wf(this.ex.a());this.ex=null;this.nx&&this.j.Wf(this.nx.a());this.nx=null;this.lx&&this.j.Wf(this.lx.a());this.lx=null;this.Zw&&this.j.Wf(this.Zw.a());this.Zw=null;XV.e.D[L](this)};XV[K].Xi=function(a){return U(a,this)};XV[K].eD=function(){return this.j.eD()};function dW(a){this.selection=new rx;this.cv=this.Xj=this.KI=this.rf=null;if(null!=a){this[Jz][sr](a[Jz]);var b=new Do([a]);this.rf=Xo(b,Oua);this.KI=Xo(b,Nua);if(null!=Io(b,kva)){a=Qo(b,gva);var c=Mo(b,jva),d=Qo(b,iva),b=Qo(b,hva);null!=a&&null!=d&&null!=b&&null!=c&&(this.Xj={Pi:a,bI:c,origin:{x:d,y:b}})}}}Ia(dW[K],function(){var a=new dW;a.selection=this[Jz][Jc]();a.rf=nk(this.rf);a.Xj=nk(this.Xj);a.cv=nk(this.cv);return a});ab(dW[K],function(a){return Gn(this)==Gn(a)});function yLa(a,b){var c=new um(-5,-5,-5,-5);this.Tm=b[Jc]()[Iz](c);c=2*El(a)/5;this.uaa=new Cl(c,c)}yLa[K].Vaa=function(a,b,c){var d=b.QW,e=b.HA.Tb();b=ka(a.lat);a=ka(a.lng);a<d.jh[1]?a+=360:a>d.oi[1]&&(a-=360);c=El(this.uaa)/2/c/(e[z]/(d.oi[0]-d.jh[0]));return{oi:[b+c,a+c],jh:[b-c,a-c]}};function zLa(a,b){var c=Aj(a.hA,function(a){return a.Pi==b});if(!c)return!1;var d=a[xs].HA,c=zl(new xl(c.x,c.y),new xl(d[G]+d[r]/2,d.top+d[z]/2)),d=El(d.Tb())/2;return c<.9*d};function eW(a,b,c,d){this.sg=!a.eD()&&Lo(b,$ra);this.o=c;this.bb=d;this.ZD=this.yK=null}Dq(eW[K],function(a,b){if(!this.sg)return!1;if(ALa(this,a)||this.OY(a,b))return!0;var c=a[GB]==sI;return a[Y].bK&&c?!0:!1});eW[K].OY=function(a,b){if(a[H]!=yG)return!1;if(a[Y].co){if(!a[Y].AA)return!1;if(b&&zLa(b,a[Y].Pi))return!0;BLa(this);this.yK=ba[Dr](this.Xi(function(){this.yK=null;this.o.cv={Vn:a[Y].Vn,Pi:a[Y].Pi};XS(this.bb,0)}),300);return!0}BLa(this);return!1};
function ALa(a,b){if(!a.o.cv)return!1;switch(b[H]){case zG:case rI:var c;b[Y].bK?c=!1:(fW(a),c=!0);return c;case yG:case qI:if(b[Y].co){c=b[GB]==AG;var d=b[GB]==EG;b[Y].bK&&!d?gW(a):c&&(b[Y].AA?gW(a):fW(a))}else null===a.ZD&&(c=b[GB]==AG,(b[Y].bK||c)&&CLa(a));return!1;case pI:return b[GB]==EG?(CLa(a),c=!0):c=!1,c;default:return!1}}function CLa(a){gW(a);a.ZD=ba[Dr](a.Xi(function(){this.ZD=null;fW(this)}),500)}function fW(a){a.o.cv=null;XS(a.bb,0)}
function BLa(a){null!==a.yK&&(Fi[fr](a.yK),a.yK=null)}function gW(a){null!==a.ZD&&(Fi[fr](a.ZD),a.ZD=null)}eW[K].Xi=function(a){return U(a,this)};function DLa(a,b,c,d){this.V4=h.pow(a,2);this.U4=h.pow(b,2);this.Xua=b;this.W4=(this.dr=c?new Yn(d[AC](c[y]),d[AC](c.end)):null)?this.dr.end-this.dr[y]:null;this.lga=d}function ELa(a,b){var c=null;null!=b&&null!=a.lga&&(b=a.lga[AC](b));if(null!=b&&null!=a.dr)0===a.W4&&b===a.dr[y]?c=(a.U4+a.V4)/2:b<=a.dr[y]?c=a.V4:b>=a.dr.end&&(c=a.U4);else if(!a.W4||null==b)return a.Xua;null==c&&(b=Lk(b,a.dr[y],a.dr.end),c=Nk(a.V4,a.U4,(b-a.dr[y])/a.W4));return h[D](h[Kd](c))}
function FLa(a,b){var c=So(a,roa),d=So(a,toa);if(c>d)throw m("sizeAxis.minSize ("+c+") must be at most sizeAxis.maxSize ("+d+ef);var e=Qo(a,qoa),f=Qo(a,soa);if(null!=e&&null!=f&&e>f)throw m("sizeAxis.minValue ("+e+") must be at most sizeAxis.maxValue ("+f+ef);e=Ufa(b,e,f);f=uV(a,uoa,poa);f=tKa(f,1,[]);return new DLa(c,d,e,f)};function hW(a){this.b=a||{}}W(hW,MV);hW[K].FY=function(){return 1};hW[K].kF=function(a){return wj(arguments,function(a){return{x:a[1],y:a[0]}})};function GLa(a,b,c,d,e,f){this.b=a;var g=YKa(a);this.EW=new TV[g[Nd]](g);this.N=b;this.ra=c;var k=no(hp(a,LK)),g=b-k,k=c-k,l=h[D]((b-g)/2),n=h[D]((c-k)/2);this.Lr=new xm(l,n,g,k);l=this.Lr;if(Mo(a,Usa))var p=l[r],n=l[z],t=this.EW.FY(),g=h.min(p,h[D](n*t)),k=h[D]((p-g)/2)+l[G],p=h.min(n,h[D](p/t)),l=h[D]((n-p)/2)+l.top,g=new xm(k,l,g,p);else g=l[Jc]();this.ou=g;this.Sd=d;this.q=e;this.nb=f;this.M6=So(a,$H,h[D](h.pow(2*(this.Lr[r]+this.Lr[z]),1/3)));this.bja=Zo(a,[Rra,Sra],cN);this.cja=So(a,Qra,1);
this.DW=Wo(a,aI);this.hr=HLa(this);this.qF=ILa(this);d=a.Q(XG);this.xja=Li(d)==Ph;this.KO=ep(a,VG,WKa,rK);this.U7=Uo(a,Ssa,1/3);this.IO=ep(a,Msa,TKa,th);this.V7=np(a,UG,{$a:this.DW,fontSize:this.M6});this.YW=Xo(a,Nsa);this.wja=Zo(a,hwa,M);this.eO=Zo(a,awa,M);this.K6=JLa(this);this.dja=KLa(this);d=np(a,rna);e=Sfa(d);this.fB=ep(a,lD,pp,ih);this.Jt=this.fB!=O;this.Pr={normal:d,bold:e};d=Lo(a,vna);this.fja=Lo(a,tna);this.eja=d?HEa:IEa;this.dY=Lo(a,zna);this.Tja=10;this.OW=this.Ip=this.iB=null;this.KA=
cN;this.dG=null;this.aja=Uo(a,Ora);this.gja=new yLa(this.ou.Tb(),new um(0,b,c,0))}function LLa(a,b){for(var c=0,d=a.iB[J];c<d;c++)for(var e=a.iB[c].eY.X,f=0,g=e[J];f<g;f++){var k=e[f];if(k.id==b)return k}return null}function MLa(a,b){var c=NLa(a,a.wja),d={};X(b[BA],function(a){X(a.X,function(a){d[a.id]={ne:c}},this)},a);return d}
function OLa(a,b){for(var c=new RV,d=1;10>d;d++){var e=(a.oi[1]-a.jh[1])/10*d+a.jh[1],f=(a.oi[0]-a.jh[0])/10*d+a.jh[0],e=b.kF([f,a.jh[1]],[f,a.oi[1]],[a.jh[0],e],[a.oi[0],e]);c.track[Zc](c,e)}d=c[rA](JC);c=c[rA](zi);return{oi:[c.max,d.max],jh:[c.min,d.min]}}R=GLa[K];
R.P7=function(a,b,c,d){for(var e=PLa(this,Gea(Zk(d.wD),Zk(d.kn)));e[1]>a.oi[1];)e[1]-=360;for(;e[1]<a.jh[1];)e[1]+=360;return{id:d.id,center:this.c0(a,b,c,e),wD:wj(d.wD,U(this.Efa,this,a,b,c)),kn:wj(d.kn,U(this.Efa,this,a,b,c)),$Q:d.id!=bAa}};function PLa(a,b){var c=0,d=0,e=0;$k(b,function(a){X(a.tK,function(a){c+=a[0];d+=Mk(a[1],360);e++},this)},a);return[c/e,d/e]}R.Efa=function(a,b,c,d){return{tK:this.Dga(a,b,c,d.tK),sK:wj(d.sK,U(this.Dga,this,a,b,c))}};
R.Dga=function(a,b,c,d){return{l:wj(d,U(this.c0,this,a,b,c))}};R.c0=function(a,b,c,d){var e=a.jh;a=a.oi;var f=b[r],g=b[z],k=b[G];b=b.top;c=c.kF(d)[0];return[k+f*(c.x-e[1])/(a[1]-e[1]),b+g*(1-(c.y-e[0])/(a[0]-e[0]))]};function QLa(a,b){var c=[];a.Ip=[];for(var d=wj(a.iB,function(a){return a.eY}),e=0;e<b[J];++e){var f=b[e],g={location:f,AY:{}};if(null!=f){f=RLa(a,e,f,d);Mj(c,f);for(var k=0;k<f[J];k++){var l=f[k];g.AY[l.Vn]=l}}a.Ip[B](g)}SLa(c);return c}
function SLa(a){for(var b=0;b<a[J];b++){for(var c=a[b],d=new xl(c.x,c.y),e=0,f=0;f<a[J];f++)if(b!=f){var g=a[f],k=zl(d,new xl(g.x,g.y));k<c[EA]+g[EA]&&(e+=c[EA]+g[EA]-k)}c.AA=e>c[EA]}}
function RLa(a,b,c,d){var e=a.dja(b),f=a.K6(b);if(null==f)return[];var f=new lo({stroke:a.bja,strokeWidth:a.cja,fill:f,fillOpacity:a.aja}),g=ka(c.lat),k=[];c=ka(c.lng);c=[c,c+360,c-360];for(var l=0;l<d[J];++l){var n=d[l],p=a.dG[l],t=n.QW;if(!(g<t.jh[0]||g>t.oi[0])){for(var u=0;u<c[J];++u){var x=c[u];if(!(x<t.jh[1]||x>t.oi[1])){var x=a.c0(n.ru,n.HA,p,[g,x]),A=String(b+lf+n.id+lf+u),C=AG;null!=a.nb.uJ&&0<=a.nb.uJ?C=a.q.Ca(b,a.nb.uJ):null!=a.nb.aJ&&0<=a.nb.aJ?C=a.q.Ca(b,a.nb.aJ):null!=a.nb.$I&&0<=a.nb.$I?
C=a.q.Ca(b,a.nb.$I):null!=a.nb.FC&&null!=a.nb.GC&&0<=a.nb.FC&&0<=a.nb.GC&&(C=TLa(a.q[I](b,a.nb.FC),a.q[I](b,a.nb.GC)));k[B]({Vn:A,label:C,Pi:b,x:x[0],y:x[1],size:e,brush:f,AA:!1})}}if(0<k[J])break}}return k}
function ULa(a,b,c){var d=a.Ip,e=d[c],f=e.AY[b];if(!f.AA)return null;var g=b[zc](lf)[1],k=a.iB[g],l=a.dG[g],n=Po(a.b,Zra),p=a.gja,e=p.Vaa(e[Fc],k.eY,n),f=new xl(f.x,f.y),n=p.Tm,p=p.uaa,t=f.x;t+p[r]>n[kd]&&(t=f.x-p[r]);var u=f.y-p[z];u<n.top&&(u=f.y);p=new xm(t,u,p[r],p[z]);l=OLa(e,l);c={id:g+lf+c+iEa,ru:l,QW:e,HA:p,X:wj(k.X,U(a.P7,a,e,p,new hW))};g=[];for(k=0;k<d[J];k++)l=d[k][Fc],null!=l&&Mj(g,RLa(a,k,l,[c]));return{Vn:b,Z8:f,view:c,hA:g}}
function VLa(a,b){if(!a.xja||null==a.hr||!a.hr.Yk)return null;var c=a.V7[Gc],d=a.Lr[r],e=a.Lr[z],f={top:0,left:0,width:a.IO==th?d*a.U7:e*a.U7,height:1.5*c,orientation:a.IO,ba:a.V7,V$:AK,W$:a.YW};f.top=a.KO==iD||a.KO==ina?3*c:a.IO==ui?e-c-f[r]:e-c-f[z];$a(f,a.KO==iD||a.KO==rK?.5*c:a.IO==ui?d-c-f[z]:d-c-f[r]);$a(f,f[G]+a.Lr[G]);f.top+=a.Lr.top;return LV(a.hr,f,b,a.Sd)}function WLa(a,b){for(var c=null,d=0;d<a.q.O();++d)var e=a.q[I](d,b),c=ho(c,e);return c}
function JLa(a){var b=a.nb.Lu;return null!=b?function(a){a=this.q[I](a,b);return null!=a?cV(this.hr,a):this.eO}:function(){return this.eO}}function KLa(a){var b=a.nb.BC;return null!=b?function(a){a=this.q[I](a,b);return ELa(this.qF,a)}:function(){return this.Tja}}function HLa(a){var b=a.nb.Lu;if(null==b)return null;b=WLa(a,b);return YJa(a.b,b)}function ILa(a){var b=a.nb.BC,b=null!=b?WLa(a,b):null;return FLa(a.b,b)}
function XLa(a,b){var c={$A:[],cB:[]};null!=b.rf&&(c.$A=[b.rf]);null!=b.KI&&(c.cB=[b.KI]);c.Cr=[];var d=a.Jt&&(a.fB===Rg||a.fB===ci);X(tx(b[Jz]),function(a){var b=YLa(this,a,!1),e=this.Sd,f=this.Pr.normal[Gc],g=new um(0,this.N-1,this.ra-1,0),u=this.Ip[a];a=(a=this.OW[a])&&LLa(this,a);var x=null,A=null;a?(c.$A[B](a.id),d&&(x=A=new xl(a[Gz][0],a[Gz][1]),c.Cr[B](VS(b,e,!1,A,g,x,void 0,this.dY)))):u&&Zj(u.AY,function(a,k){c.cB[B](k);d&&c.Cr[B](VS(b,e,!1,new xl(a.x-f,a.y-f),g,new xl(a.x,a.y),void 0,this.dY))},
this)},a);if(null!=b.Xj){if(a.Jt&&(a.fB===Rg||a.fB===ih)){var e=YLa(a,b.Xj.Pi,b.Xj.bI),f=a.Pr.normal[Gc],g=new xl(b.Xj[dr].x,b.Xj[dr].y);c.Cr[B](VS(e,a.Sd,!1,new xl(g.x-f,g.y-f),new um(0,a.N-1,a.ra-1,0),g,void 0,a.dY))}null!=a.nb.Lu&&(e={value:a.q[I](b.Xj.Pi,a.nb.Lu)},c.Gi=VLa(a,[e]))}null!=b.cv&&(c.VF=ULa(a,b.cv.Vn,b.cv.Pi));return c}function ZLa(a,b,c){b=0<=a?c:b;a=h.abs(a);c=h[Eb](a);var d=60*(a-c);a=h[Eb](d);d=h[D](60*(d-a));return c+oma+a+cf+d+Me+b}
function TLa(a,b){return ZLa(a,gg,bg)+Ke+ZLa(b,wg,Pf)}
function YLa(a,b,c){var d=a.nb,e=a.q,f={entries:[]},g;if(null!=d.uJ)g=e.Ca(b,d.uJ);else switch(d.I_){case Nt:c=e[I](b,d.FC);g=e[I](b,d.GC);g=TLa(c,g);break;case Zt:g=e.Ca(b,d.$I);c&&(g=FO(a.eja,g));break;case ot:g=e.Ca(b,d.aJ);break;default:g=M}a.fja&&(c=TS(g,a.Pr[Xd]),f[jC][B](c));if(null!=d.s0)if(c=e.Ca(b,d.s0),e.gj(d.s0,vh))f[jC][B](TS(c,a.Pr.normal,void 0,void 0,void 0,void 0,void 0,!0));else for(b=c[zc](Je),d=0;d<b[J];d++)c=TS(b[d],a.Pr.normal),f[jC][B](c);else null!=d.Lu&&(g=e.La(d.Lu),c=e.Ca(b,
d.Lu),c=TS(c,a.Pr[Xd],g,a.Pr.normal),f[jC][B](c)),null!=d.BC&&d.BC!=d.Lu&&(g=e.La(d.BC),c=e.Ca(b,d.BC),c=TS(c,a.Pr[Xd],g,a.Pr.normal),f[jC][B](c));return f}R.Xi=function(a){return U(a,this)};function NLa(a,b){var c=b===O?[255,255,255]:xn(b),c=vn(Cn(c,.1));return{fill:new lo({stroke:c,fill:b}),kn:new lo({stroke:O,pattern:new ko(nF,b,b==a.KA?Re:a.KA)}),border:new lo({stroke:c})}};function iW(a,b,c,d,e,f,g,k,l){Ju[L](this);this.Fl=a;this.b=b;this.N=c;this.ra=d;this.nb=f;this.o=g;this.Km=null;this.YX=!1;this.ila=k;this.fo=l;this.kW=!1;this.nW=null;this.H7=!1;this.bb=new WS(this.Xi(this.Br));this.kC=new DT(3);this.RP=[!1,!1,!1];this.uA=new GLa(this.b,this.N,this.ra,this.Fl.bf,e,this.nb);this.I7=new eW(a,b,g,this.bb);this.L8=Lo(b,eva,f.f6==$t);this.HY()}W(iW,Ju);R=iW[K];
R.m4=function(a,b){var c;c=this.uA;var d=c.b;c.iB=[];c.dG=[];for(var e=[],f=0,g=a[BA][J];f<g;f++){var k=a[BA][f],l=c.EW.Pc();l.boundingBox={lo:k.ru.jh,hi:k.ru.oi};l=new c.EW[Bc](l);c.dG[B](l);var l=c,n=k,p=f,t=new xm(n.Cja*l.ou[r]+l.ou[G],n.Dja*l.ou[z]+l.ou.top,n[bB]*l.ou[r],n[bB]*l.ou[z]),u=l.dG[p],x=OLa(n.ru,u),l={id:String(p),ru:x,QW:n.ru,HA:t,X:wj(n.X,U(l.P7,l,x,t,u))};e[B](l);c.iB[B]({X:k.X,eY:l})}c={width:c.N,height:c.ra,Aia:c.ou,jA:ep(d,JE,nga,ei),jya:c.fB,pF:hp(d,LK),Y5:ap(d,NH),title:{text:Wo(d,
qD),ba:np(d,oD,{$a:c.DW,fontSize:c.M6}),I:[],align:TD,rb:M},views:e,OA:MLa(c,a),$A:[],cB:[],hA:[],Gi:null,VF:null,kk:c.DW};this.jG(0,c);this.kW=!0;this.fo(Xra,b);null!=this.nW?this.nW():this.Br()};
function $La(a,b,c,d,e,f){a.YX=!1;var g=a.Xi(function(){this.H7=d;if(null!=e){this.Km=null;var a=this.uA;a.q=e;a.hr=HLa(a);a.qF=ILa(a)}null!=f&&(this.o=f,this.I7.o=f);a=this.uA;a.OW=[];for(var g={},n=0;n<a.q.O();++n){var p=b[n];a.OW[B](p);if(null!=p){var t=a.K6(n);null!=t&&(g[p]={Pi:n,ne:NLa(a,t)})}}a={OA:g,hA:QLa(a,c),Gi:VLa(a,[])};this.jG(1,a);this.Br()});a.kW?g():a.nW=g}Eq(R,function(a){this.o[Jz][sr](a);XS(this.bb,1)});Zq(R,function(){return this.o[Jz][ss]()});
R.Br=function(){if(this.kW){if(null==this.Km||!this.Km[gs](this.o)){var a=XLa(this.uA,this.o);this.jG(2,a)}a=this.kC[iB]();if(this.RP[0])hLa(this.Fl,a);else if(this.RP[1]){var b=this.Fl;uLa(b,a);rLa(b,a);ZV(b,a,!0)}else ZV(this.Fl,a);this.RP=[!1,!1,!1];this.Km=this.o[Jc]();!this.YX&&this.H7&&(this.ila(),this.YX=!0)}};
R.lqa=function(a){if(!jW(this,a)&&this.L8){var b=a[Y][qC];null!==b&&(a[Y].co?(this.o.rf=b,b=aMa(this,b),this.o.Xj=null!=b?{Pi:b,bI:a[Y].bI,origin:{x:a[Y].xb.x,y:a[Y].xb.y}}:null):(this.o.rf=null,this.o.Xj=null),XS(this.bb,50))}};R.oqa=function(a){jW(this,a)||(a[Y].co?(this.o.KI=a[Y].Vn,this.o.Xj={Pi:a[Y].Pi,bI:!1,origin:{x:a[Y].xb.x,y:a[Y].xb.y}}):(this.o.KI=null,this.o.Xj=null),XS(this.bb,50))};R.mqa=function(a){jW(this,a)||bMa(this,a)};R.pqa=function(a){bMa(this,a)};
function bMa(a,b){null!=a.o.Xj&&(Zx(a.o.Xj,{x:b[Y].xb.x,y:b[Y].xb.y}),XS(a.bb,3))}R.kqa=function(a){if(!jW(this,a)&&this.L8){var b=a[Y][qC];null===b||this.fo($pa,{region:b});b=aMa(this,b);this.Nw(a,b)}};R.nqa=function(a){jW(this,a)||this.Nw(a,a[Y].Pi)};R.Nw=function(a,b){var c=this.kC[iB]().jA==ei;if(null!=b)yx(this.o[Jz],b,c),this.fo(cu,{});else this.o[Jz][bc]();this.bb&&XS(this.bb,50)};function jW(a,b){var c=a.kC[iB]();return a.I7[rr](b,c?c.VF:null)}
R.HY=function(){this.Fl.k(rI,this.Xi(this.kqa));this.Fl.k(qI,this.Xi(this.lqa));this.Fl.k(pI,this.Xi(this.mqa));this.Fl.k(zG,this.Xi(this.nqa));this.Fl.k(yG,this.Xi(this.oqa));this.Fl.k(Pra,this.Xi(this.pqa))};function aMa(a,b){if(null===b)return null;var c=a.kC[iB]();return c.OA[b]?c.OA[b].Pi:null}R.jG=function(a,b){ET(this.kC,a,b);this.RP[a]=!0};R.D=function(){Lu(this.bb);this.bb=null;Lu(this.Fl);this.Fl=null;Lu(this.uA);this.uA=null;iW.e.D[L](this)};R.Xi=function(a){return U(a,this)};var cMa={COM:{COUNTRIES:["002","005","009","011","013","014","015","017","018","019","021","029","030","034","035","039","053","054","057","061","142","143","145","150","151","154","155","AD","AE","AF","AG","AI","AL","AM","AO","AR","AS",YL,"AU","AW","AX","AZ","BA","BB","BD","BE","BF","BG","BH","BI","BJ","BL","BM","BN","BO","BQ",If,"BS","BT","BV","BW","BY","BZ","CA","CC","CD","CF","CG","CH","CI","CK","CL","CM","CN","CO","CR","CU","CV","CW","CX","CY","CZ","DE","DJ","DK","DM","DO","DZ","EC","EE","EG",
"EH","ER","ES","ET","FI","FJ","FK","FM","FO","FR","GA","GB","GD","GE","GF","GG","GH","GI","GL","GM","GN","GP","GQ","GR","GS","GT","GU","GW","GY","HK","HM","HN",Uf,"HT","HU","ID","IE","IL","IM","IN","IO","IQ","IR","IS","IT","JE","JM","JO","JP","KE","KG","KH","KI","KM","KN","KP","KR","KW","KY","KZ","LA","LB","LC",HL,"LK","LR","LS","LT","LU","LV","LY","MA","MC","MD","ME","MF","MG","MH","MK","ML","MM","MN","MO","MP","MQ","MR","MS","MT","MU","MV","MW","MX","MY","MZ","NA","NC","NE","NF","NG","NI","NL",
"NO","NP","NR","NU","NZ","OM","PA","PE","PF","PG","PH","PK","PL","PM","PN","PR","PS","PT","PW","PY","QA","RE","RO","RS","RU","RW","SA","SB","SC","SD","SE","SG","SH","SI","SJ","SK","SL","SM","SN","SO","SR","SS","ST","SV","SX","SY","SZ","TC",og,"TF","TG","TH","TJ","TK",qg,"TM","TN","TO",tg,"TT","TV","TW","TZ","UA","UG","UM",pL,"UY","UZ","VA","VC","VE","VG","VI","VN","VU","WF","WS","XK","YE","YT","ZA","ZM","ZW",KC],METROS:[pL,"US-500","US-501","US-502","US-503","US-504","US-505","US-506","US-507","US-508",
"US-509","US-510","US-511","US-512","US-513","US-514","US-515","US-516","US-517","US-518","US-519","US-520","US-521","US-522","US-523","US-524","US-525","US-526","US-527","US-528","US-529","US-530","US-531","US-532","US-533","US-534","US-535","US-536","US-537","US-538","US-539","US-540","US-541","US-542","US-543","US-544","US-545","US-546","US-547","US-548","US-549","US-550","US-551","US-552","US-553","US-554","US-555","US-556","US-557","US-558","US-559","US-560","US-561","US-563","US-564","US-565",
"US-566","US-567","US-569","US-570","US-571","US-573","US-574","US-575","US-576","US-577","US-581","US-582","US-583","US-584","US-588","US-592","US-596","US-597","US-598","US-600","US-602","US-603","US-604","US-605","US-606","US-609","US-610","US-611","US-612","US-613","US-616","US-617","US-618","US-619","US-622","US-623","US-624","US-625","US-626","US-627","US-628","US-630","US-631","US-632","US-633","US-634","US-635","US-636","US-637","US-638","US-639","US-640","US-641","US-642","US-643","US-644",
"US-647","US-648","US-649","US-650","US-651","US-652","US-656","US-657","US-658","US-659","US-661","US-662","US-669","US-670","US-671","US-673","US-675","US-676","US-678","US-679","US-682","US-686","US-687","US-691","US-692","US-693","US-698","US-702","US-705","US-709","US-710","US-711","US-716","US-717","US-718","US-722","US-724","US-725","US-734","US-736","US-737","US-740","US-743","US-744","US-745","US-746","US-747","US-749","US-751","US-752","US-753","US-754","US-755","US-756","US-757","US-758",
"US-759","US-760","US-762","US-764","US-765","US-766","US-767","US-770","US-771","US-773","US-789","US-790","US-798","US-800","US-801","US-802","US-803","US-804","US-807","US-810","US-811","US-813","US-819","US-820","US-821","US-825","US-828","US-839","US-855","US-862","US-866","US-868","US-881","US-AK","US-AL","US-AR","US-AZ","US-CA","US-CO","US-CT","US-DC","US-DE","US-FL","US-GA","US-HI","US-IA","US-ID","US-IL","US-IN","US-KS","US-KY","US-LA","US-MA","US-MD","US-ME","US-MI","US-MN","US-MO","US-MS",
"US-MT","US-NC","US-ND","US-NE","US-NH","US-NJ","US-NM","US-NV","US-NY","US-OH","US-OK","US-OR","US-PA","US-RI","US-SC","US-SD","US-TN","US-TX","US-UT","US-VA","US-VT","US-WA","US-WI","US-WV","US-WY"],PROVINCES:["AD","AE","AF","AG","AL","AM","AO","AR",YL,"AU","AZ","BA","BB","BD","BE","BF","BG","BH","BI","BJ","BN","BO","BQ",If,"BS","BT","BW","BY","BZ","CA","CD","CF","CG","CH","CI","CL","CM","CN","CO","CR","CU","CV","CY","CZ","DE","DJ","DK","DM","DO","DZ","EC","EE","EG","EH","ER","ES","ET","FI","FJ",
"FM","FR","GA","GB","GD","GE","GH","GL","GM","GN","GQ","GR","GT","GW","GY","HN",Uf,"HT","HU","ID","IE","IL","IN","IQ","IR","IS","IT","JM","JO","JP","KE","KG","KH","KI","KM","KN","KP","KR","KW","KZ","LA","LB","LC",HL,"LK","LR","LS","LT","LU","LV","LY","MA","MD","ME","MG","MH","MK","ML","MM","MN","MR","MU","MV","MW","MX","MY","MZ","NA","NE","NG","NI","NL","NO","NP","NR","NZ","OM","PA","PE","PG","PH","PK","PL","PT","PW","PY","QA","RO","RS","RU","RW","SA","SB","SC","SD","SE","SH","SI","SK","SL","SM",
"SN","SO","SR","SS","ST","SV","SY","SZ",og,"TG","TH","TJ",qg,"TM","TN","TO",tg,"TT","TV","TZ","UA","UG",pL,"US-AK","US-AL","US-AR","US-AZ","US-CA","US-CO","US-CT","US-DC","US-DE","US-FL","US-GA","US-HI","US-IA","US-ID","US-IL","US-IN","US-KS","US-KY","US-LA","US-MA","US-MD","US-ME","US-MI","US-MN","US-MO","US-MS","US-MT","US-NC","US-ND","US-NE","US-NH","US-NJ","US-NM","US-NV","US-NY","US-OH","US-OK","US-OR","US-PA","US-RI","US-SC","US-SD","US-TN","US-TX","US-UT","US-VA","US-VT","US-WA","US-WI","US-WV",
"US-WY","UY","UZ","VC","VE","VN","VU","YE","ZA","ZM","ZW"],REGIONS:["002","009","019","142","150",KC],SUBREGIONS:["002","005","009","011","013","014","015","017","018","019","021","029","030","034","035","039","053","054","057","061","142","143","145","150","151","154","155",KC]},IN:{COUNTRIES:["002","009","019","030","034","035","142","143","145","151","AF","BD","BT","CN","IN","MM","NP","PK","RU","TJ","UZ",KC],PROVINCES:"AF BD BT CN IN MM NP PK RU TJ UZ".split(" "),REGIONS:["002","009","019","142",
KC],SUBREGIONS:["002","009","019","030","034","035","142","143","145","151",KC]}};var kW={},lW={},mW=null,dMa=aV(Ht,uf),nW=dMa;function eMa(a,b,c){nW=a?a+Gs:dMa;lW={};oW=null;a?AV(EV(nW+fta,$ta),function(a){pW=a;b()},function(){c()}):(pW=cMa,b())}
function fMa(a,b){if(null==b)throw m("Callback is null or undefined");var c=gMa(a);if(Gi(lW[c])){var d=U(b,null,lW[c]);Xx(d,0)}else if(Gi(kW[c]))kW[c][B](b);else kW[c]=[b],d=nW+FO(Wra,c),AV(EV(d,bua+c[Ab](lf,Te)),function(a){var b={views:wj(a[BA],hMa)};lW[c]=b;X(kW[c],function(a){a(b)});delete kW[c]},function(){X(kW[c],function(a){a(null)});delete kW[c]})}function gMa(a){var b=M;a[BB]!=QL&&(b=a[BB]+lL);return b+a[wB]+lL+iMa(a[pA])}
function iMa(a){null!=mW||(mW={continents:QAa,subcontinents:LAa,countries:PL,provinces:XAa,metros:fBa});return mW[a]}var pW=cMa;function jMa(a){var b=a[BB],c=a[wB];a=iMa(a[pA]);if(b=pW[b])if(b=b[a])return 0<=Oj(b,c);return!1}var oW=null;function kMa(a){null!=oW?a(oW):AV(EV(nW+gta,aua),function(b){oW=b=wj(b,lMa);a(b)},function(){a(null)})}
function hMa(a){for(var b=wj(a.features,mMa),c={},d=[],e=0;e<b[J];e++){var f=b[e],g=f.id;bj(g,cAa)?c[g]=f:d[B](f)}for(e=0;e<d[J];e++)f=d[e],b=c[cAa+f.id],f.kn=b?b.wD:[];if(c=c.__DISPUTED__All)c.kn=c.wD,d[B](c);return{X:d,ru:nMa(a.boundingBox),Cja:a.xoffset,Dja:a.yoffset,scale:a[bB]}}function mMa(a){return{id:a.id,wD:wj(a.polygons,oMa),kn:[]}}function oMa(a){return Pi(a)?{tK:qW(a),sK:[]}:{tK:qW(a.shell),sK:wj(a.holes,qW)}}function qW(a){return wj(a,function(a){return[QV(a[0]),ka(a[1])]})}
function nMa(a){return{oi:[QV(a.hi[0]),ka(a.hi[1])],jh:[QV(a.lo[0]),ka(a.lo[1])]}}function lMa(a){return{region:a[wB],resolution:a[pA],domain:a[BB],Bsa:wj(a.boundingBoxes,nMa)}};function rW(a,b,c,d){var e=Wo(c,fF);if(e!=Mg)d(sW(e,c));else if(b.I_!=Nt)d(sW(KC,c));else{for(var f=fp(c,bF,UKa),g=Xo(c,At),k=[],e=0;e<a.O();++e)k[B]({lat:a[I](e,b.FC),lng:a[I](e,b.GC)});kMa(function(a){if(a){t:{for(var b=0;b<a[J];++b){var e=a[b];if(null==f||e[pA]==f)if(null==g||e[BB]==g){for(var t=!0,u=0;u<k[J];++u){for(var x=k[u],A=!1,C=e.Bsa,E=0;E<C[J];++E)if(pMa(x,C[E])){A=!0;break}if(!A){t=!1;break}}if(t){a={region:e[wB],resolution:e[pA],domain:e[BB]};break t}}}a=null}null!=a?d(a):d(sW(KC,c))}else d(null)})}}
function sW(a,b){var c=ep(b,bF,UKa,$I),d=Wo(b,At),c={region:a,resolution:c,domain:d};return jMa(c)||c[BB]!=QL&&(Wy(c,QL),jMa(c))?c:null}function pMa(a,b){return a.lat>b.jh[0]&&a.lat<b.oi[0]&&yj([-360,0,360],function(c){return a.lng+c>b.jh[1]&&a.lng+c<b.oi[1]})};function tW(a){nw[L](this,a);this.im=this.Da=null;this.Ty=new UV(this.Iq);this.C1=M;this.Ua=this.Dj=null}W(tW,nw);R=tW[K];
R.hl=function(a,b,c,d){vp(EM);Hu.nc(this.ea);this.Dj=a;Lu(this.Ty);this.Ty=new UV(this.Iq);a=c||{};a=On(Ln(a));c=[a];var e=a.theme||[];Oi(e)||(e=[e]);for(var f=0;f<e[J];++f){var g;if(Si(e[f]))g=IKa(e[f]);else if(Ri(e[f]))g=e[f];else throw m(uAa);c[B](g)}c[B](ZKa);var k=MKa(),l=[];X(c,function(a){l[B][Zc](l,aga(a,k))});var n=new Do(c),p=new dW(d);this.Ua=this.Yu(this.ea,n);d=ep(n,Hva,mla,Mg);var t=(new Sw).hd(b,d,this.Iq);if(null!=t){var u=Gn({options:a,format:t,size:this.Ua}),x=this.Dj(function(a){if(null==
a)throw m(OAa);qMa(this,b,t,n,u,p,a)},this);l[J]&&this.Ek?(this.Ek.zG[vs](function(){rW(b,t,n,x)},null,this),ela(this,U(function(){rW(b,t,n,x)},this)),new JKa(l,this.Ek)):rW(b,t,n,x)}};R.jk=function(){var a=Fl(this.ea)[Vb](ch),b=LO(a,this.Ua),c=new EO(a),d=new rO(a,b),b=this.im,c=new XV(c,d,b.Fl.nb),b=b.kC[iB]();hLa(c,b);uLa(c,b);rLa(c,b);ZV(c,b,!0);ZV(c,b);return a[cc][0].toDataURL(jta)};
R.Yu=function(a,b){var c=qp(a,b,-1),d=rp(a,b,-1);-1==c&&-1==d?(c=556,d=347):-1==c?c=h[D](556*d/347):-1==d&&(d=h[D](347*c/556));return new Cl(c,d)};
function qMa(a,b,c,d,e,f,g){var k=Lo(d,Doa);if(a.C1==e)rMa(a,!1,d,b,c,g,k,f,e);else{if(null!=a.Da)a.Da[xC](a.Ua,a.Dj);else{var l=Lo(d,ZH);a.Da=new JO(a.ea,a.Ua,a.Dj,l)}a.Da.$n(U(function(){var a=this.Da.Wa(),l=this.Da.Mw(),a=new XV(l,a,c);null!=this.im&&Lu(this.im);l=this.Ua;Lu(this.im);this.im=new iW(a,d,l[r],l[z],b,c,f,U(this.Epa,this),U(this.vca,this));rMa(this,!0,d,b,c,g,k,f,e)},a),a.Dj)}}
function rMa(a,b,c,d,e,f,g,k,l){c=ep(c,vua,XKa,fF);var n=c===qK||c===Rg,p=a.Dj(function(a,b,c){$La(this.im,a,b,c,d,k)},a),t=U(function(){$Ka(this.Ty,d,e,f,g,p)},a);a.Ty.vL=c;b&&(a.Ty.sE=null,fMa(f,a.Dj(function(a){null!=a?(this.im.m4(a,f),n&&(this.Ty.m4(a),t()),this.C1=l):this.Iq.Kd(OAa)},a)));n||(a.Ty.sE=null,t())}Eq(R,function(a){null!=this.im?this.im[sr](a):this.Iq.Kd(vAa)});Zq(R,function(){if(null!=this.im)return this.im[ss]();this.Iq.Kd(vAa);return[]});R.Epa=function(){this.vca(Yt,{})};
R.vca=function(a,b){ew(this,a,b)};R.Ag=function(){this.C1=M;Lu(this.im);this.im=null;Lu(this.Da);this.Da=null};Hi("google.visualization.GeoChart",tW,void 0);br(tW[K],tW[K][As]);tW[K].getImageURI=tW[K].jk;Eq(tW[K],tW[K][sr]);Zq(tW[K],tW[K][ss]);tW[K].clearChart=tW[K].ic;Hi("google.visualization.GeoChart.mapExists",function(a){null!=a||(a={});a=new Do([a,ZKa]);var b=Wo(a,fF);return null!=sW(b,a)},void 0);Hi("google.visualization.GeoChart.setMapsSource",function(a,b,c){eMa(a,function(){b&&b()},function(){c&&c()})},void 0);function sMa(a){return h.pow(a,3)}function tMa(a){return 1-h.pow(1-a,3)}function uMa(a){return 3*a*a-2*a*a*a};function uW(a,b,c,d,e){this.FD=a;this.J=b.Ax();this.je=b;this.Ls=null;this.Sy=vMa;this.Hs=d;this.kT=e;this.Ro=null}W(uW,hJa);R=uW[K];br(R,function(a){this.Ls={};var b=this.J;b[bc]();this.Ro=this.FD.Sq(a,null);this.Ro.Tb();for(a=0;a<this.Sy[J];a++){var c=this.Ls[this.Sy[a]]=new PO.yc.IM;this.S1(c)}this.Ro[As](this);wMa(this);b.KM()});function wMa(a){var b=a.je.Ax();X(ek(a.Ls),function(a){b.Hk(a)},a)}R.mz=function(a){this.Sy=a};my(R,function(a){this.lM(a.at,!1);this.lM(a.$s,!0);this.Ro[As](this)});
R.lM=function(a,b){for(var c=0;c<a[J];c++)for(var d=a[c],e=d.Kq,f=0;f<e[J];f++)this.Ro.Fn(e[f],d.Oq,b)};R.S1=function(a){function b(a,b){return function(e){a[Zc](b,[this,e])}}a.k(vt,b(function(a,b){vW(this,vt,a,b)},this));a.k(dG,b(function(a,b){vW(this,wH,a,b)},this));a.k(eG,b(function(a,b){vW(this,vH,a,b)},this))};function vW(a,b,c,d){c=d[ys];(c=c[Y]()&&c[Y]().idStr)&&c!=Dg&&(c=nT(c),a.Hs(c,b))}R.Wa=function(){return this.je};R.to=function(a,b,c){var d=a[Y]()||{};d.idStr=b.qg();a[Y](d);this.Ls[c].add(a)};
R.Ce=function(a,b,c,d){b!==a&&(b&&this.Wf(b),this.to(a,c,d))};R.Wf=function(a){a&&this.J.YG(a)};var vMa=[MK,UE,VE,jL,kL];function wW(a){nw[L](this,a);this.Xo=null}W(wW,wT);R=wW[K];R.hl=function(a,b,c){Hu.nc(this.ea);c=c||{};var d=this.mh()||{};c=new Do([c,d]);var d=qp(this.ea,c),e=rp(this.ea,c),d=new Cl(d,e);this.Xo=new PO(d[r],d[z],CD,this.ea);this.Xo[vs](U(this.mo,this,b,c,d,a))};R.mo=function(a,b,c,d,e){this.Xo=e;a=this.Jn(a,b,Ao(PO.H6(this.Xo),function(a,b){var c=[a,b[0]];c[B](Kn(b[1]));return c[Fe](lL)}),c).Sh();c=cJa(this.Xo);this.Pd=new vT(this,c,null,this,b,d);b=new pT;this.Pd[As](a,b)};R.Ag=function(){wW.e.Ag[L](this)};
R.it=function(a,b,c,d){a=new uW(this,a,0,c,d);(b=this.Kga())&&a.mz(b);return a};R.Kga=function(){return[]};function xMa(){this.lt=new bl;this.Ib=this.ja=this.wT=null}R=xMa[K];R.Fn=function(){};R.kK=function(a){this.Ib=a;this.We(a.Tb())};R.We=function(a){this.ja=a};R.Tb=function(){return this.ja};br(R,function(a){var b=new bl;X(this.Ib.Cf,function(c){var d=c.hqa.qg();this.lt.$e(d)?c.$m=this.lt.get(d).$m:a.Ls[c.iqa].add(c.$m());b.set(d,c)},this);$k(this.lt.pt(!0),function(a){b.$e(a)},this);this.lt=b;wMa(a)});function xW(a){wW[L](this,a)}W(xW,wW);xW[K].Sq=function(a){var b=new xMa;b.kK(a);return b};function yW(){this.Rua=Ao(U(this.dwa,this));ta(this,U(this.ewa,this))}Ki(yW);yW[K].ewa=function(a,b){return this.Rua(a).Sc(b)};yW[K].dwa=function(a){return new Wp({pattern:a,valueType:mi})};function zW(a,b,c){Sa(this,a);this.ba=b;oz(this,c||null)}zW[K].lb=function(a){for(var b=this[dd][zc](Je),c=0,d=0,e=b[J];d<e;d++)c=h.max(c,a(b[d],this.ba));return c};function AW(a,b,c,d,e,f,g){this.N=a;this.Lc=b;this.te=c;this.Rw=e;this.Eoa=f;this.Ym=!0;this.Ug=[];this.m1=d;this.rl=null;this.IG=0;this.doa=g||null;a=U(this.Qpa,this);b=Dygraph.pickDateTickGranularity(this.Lc,this.te,this.N,a);this.Ao=Dygraph.getDateAxis(this.Lc,this.te,b,a);this.Ao[0].v[md]()>this.Lc&&(this.Ao[Ge]({v:this.Lc,label:M}),this.Ug[Ge](new zW(M,{})));this.Lc=h.min(this.Ao[0].v[md](),this.Lc);a=this.Ao[this.Ao[J]-1].v[md]();a>this.te[md]()&&(this.te=a);this.h_=this.N/(this.te-this.Lc);
this.sh=[];a=0;for(b=this.Ao[J];a<b;a++)this.sh[B](this[bB](this.Ao[a].v))}
br(AW[K],function(a,b,c){if(this.Ym){if(null==this.rl)throw"startY must be set before calling draw().";var d=this.Ao[J]-1;if(0!==d){var e=this.Ug[0],f=e.lb(a),g=[new Yn(this.sh[0]-f/2,this.sh[0]+f/2)],k=[];this.sh[0]-f/2<this.m1-this.Rw&&(oz(e,TD),Ja(g[0],this.sh[0]),g[0].end=this.sh[0]+f);var e=this.Ug[d],f=e.lb(a),l=new Yn(this.sh[d]-f/2,this.sh[d]+f/2);f/2+this.sh[d]-this.Eoa>this.N+this.m1&&(oz(e,zI),Ja(l,this.sh[d]-f),l.end=this.sh[d]);$n(l,g[0])?k[B](d):g[B](l);for(e=1;e<d;e++){var n=this.Ug[e];
switch(n[fC]){case TD:n=new Yn(this.sh[e],this.sh[e]+n.lb(a));break;case dK:case null:n=new Yn(this.sh[e]-n.lb(a)/2,this.sh[e]+n.lb(a)/2);break;case zI:n=new Yn(this.sh[e]-n.lb(a),this.sh[e]);break;default:throw m("unknown alignment in tick label.");}for(var p=!1,f=0,l=g[J];f<l;f++)if($n(g[f],n)){p=!0;break}p?k[B](e):g[B](n)}f=0;for(l=k[J];f<l;f++)n=this.Ug[k[f]],Sa(n,M)}a={};d=0;for(g=this.Ao[J];d<g;d++)if(p=this.Ug[d],!(this.Lc>this.Ao[d].v)&&p[dd]){for(var k=b,e=this.sh[d],f=this.rl+10,l=p[fC]||
dK,n=p.ba,p=p[dd][zc](Je),t=[],u=0,x=p[J];u<x;u++)t[B](k(p[u],e,f,15,l,TD,n)),f+=15;k=t;e=0;for(f=k[J];e<f;e++)c(k[e],null,a)}this.Ym=!1}});Na(AW[K],function(a){return(a-this.Lc)*this.h_+this.m1});
AW[K].Qpa=function(a){function b(a,b){return e(c.doa||a,b)}var c=this,d=!0,e=yW.ac()[Rb];switch(a){case wya:return function(a,e){var k,l;c.IG=e;if(e<=Dygraph.THIRTY_SECONDLY)return l=b(ai,a),c.Ug[B](new zW(l,{lc:M,bold:!1,color:AK,$a:WL,fontSize:13,Tc:!1,Re:!1})),c.Ug[J]-1+M;if(e<=Dygraph.THIRTY_MINUTELY)return l=jM,0===a[bd]()||d?(k=!0,l=Tf):k=!1,d=!1,l=b(l,a),c.Ug[B](new zW(l,{lc:M,bold:k,color:AK,$a:WL,fontSize:13,Tc:!1,Re:!1})),c.Ug[J]-1+M;if(e<=Dygraph.SIX_HOURLY)return l=mh,k=a[gc](),0!==a[bd]()&&
(l+=LCa),k=12===k||0===k||d,d=c.Lc>a[md]()?!0:!1,k&&(l+=$Fa),l=b(l,a),c.Ug[B](new zW(l,{lc:M,bold:k,color:AK,$a:WL,fontSize:13,Tc:!1,Re:!1})),c.Ug[J]-1+M;if(e<=Dygraph.DAILY)return l=Pf,0===a[vc]()||d?(l+=aGa,k=!0):k=!1,d=!1,l=b(l,a),c.Ug[B](new zW(l,{lc:M,bold:k,color:AK,$a:WL,fontSize:13,Tc:!1,Re:!1})),c.Ug[J]-1+M;if(e<=Dygraph.WEEKLY)return k=d,d=!1,l=b(Zf,a),c.Ug[B](new zW(l,{lc:M,bold:k,color:AK,$a:WL,fontSize:13,Tc:!1,Re:!1})),c.Ug[J]-1+M;if(e<=Dygraph.BIANNUAL)return l=EL,k=0===a[Vd]()||d,
d=c.Lc>a[md]()?!0:!1,k&&(l+=ZFa),l=b(l,a),c.Ug[B](new zW(l,{lc:M,bold:k,color:AK,$a:WL,fontSize:13,Tc:!1,Re:!1})),c.Ug[J]-1+M;if(e<=Dygraph.CENTENNIAL)return l=b(tma,a),c.Ug[B](new zW(l,{lc:M,bold:!1,color:AK,$a:WL,fontSize:13,Tc:!1,Re:!1})),c.Ug[J]-1+M;throw lAa;};case Mqa:return 50}};function BW(){};Ji[K].yn=function(){return this};Ji[K].ez=function(){return!1};Ji[K].Oca=function(){return!1};function CW(a,b){return 0>b?a/h.pow(10,-b):a*h.pow(10,b)}function DW(a){a=h.abs(.4342944819032518*h.log(a));return 1E-7>h.abs(a-h[D](a))}function EW(a){return h[Eb](.4342944819032518*h.log(a))}function FW(a){return h[Cb](.4342944819032518*h.log(a))};function GW(){}R=GW[K];La(R,function(a,b,c){this.iaa=!1;this.b=a;this.nG=b;this.Cq=null===c||0>c?this.taa():2<c?c-1:1;Cy(this,[]);this.ee=da;this.oe=-da;ta(this,Xo(a,this.Ja(YH)));a.Q(this.Ja(Gma),function(a,b){return b});this.gd=this.Lt=null});function HW(a,b){null!=b&&(a.ee=b)}function IW(a,b){null!=b&&(a.oe=b)}
R.zA=function(a,b){var c=uV(this.b,this.Ja(HG),this.Ja(PE));if(!Ej(b)&&c!=xF)throw m("Non-linear scale with gaps is not supported.");for(var d=[],e=0;e<b[J];e++){var f;t:{var g=b[e];f=this.g1(g.Gla);var k=this.hK(g.Lc),g=this.hK(g.te);if(0<f)if(k+f<g)k+=f;else{f=null;break t}f={soa:0,start:k,end:g}}f&&d[B](f)}this.Lt=tKa(c,CW(1,EW(a)),d)};R.Ja=function(a){return oV(this.nG,a)};R.taa=function(){return-1};
function yMa(a,b,c,d){a.iaa||(d&&(a.pc(JW(a,b)),a.pc(JW(a,c))),a.ee==da&&a.oe==-da&&(HW(a,0),IW(a,1)),a.ee==da&&HW(a,a.oe),a.oe==-da&&IW(a,a.ee),a.ee==a.oe&&(0==a.ee?(HW(a,-1),IW(a,1)):0<a.ee?(HW(a,a.ee/2),IW(a,2*a.oe)):(HW(a,2*a.ee),IW(a,a.oe/2))),a.hJ(d),a.Z3(d),a.wJ(),a.Cq=h.max(1,a[RA][J]-1),a.iaa=!0)}R.hJ=function(){};R.Hp=function(a){Cy(this,a)};function zMa(a){a.gd||a.wJ();return a.gd}function JW(a,b){var c=KW(a,b);if(null==c)return null;c=a.Lt[AC](c);return la(c)?c:null}
function KW(a,b){return null!=b?a.hK(b):null}R.pc=function(a){null!=a&&(HW(this,h.min(this.ee,a)),IW(this,h.max(this.oe,a)))};R.Bp=function(a){return this.pG(this.Lt[NA](a))};R.kba=function(a,b){return a<b?-1:a>b?1:0};function AMa(a){this.uq=a||String}var BMa={number:function(a,b){return b.uq(a[wd])},identifier:function(a){return a[Nd]},"+":function(){return WFa},"-":function(){return DN},"--":function(){return lf},"=":function(){return SFa},"*":function(){return XFa},"(":function(){return df},")":function(){return ef},",":function(){return kf},"^":function(){return mt}};AMa[K].C=function(a){return wj(a,function(a){return BMa[a.er()](a,this)},this)[Fe](M)};function CMa(){}W(CMa,BW);CMa[K].er=function(){return lf};function DMa(){}W(DMa,BW);DMa[K].er=function(){return hf};function LW(a){this.vh=a}W(LW,Ji);LW[K].join=function(a){var b=[];X(this.vh,function(c,d){0<d&&b[B](a);var e=!1;c instanceof LW&&1<c.vh[J]&&this.mM()>c.mM()&&(e=!0);e&&b[B](new EMa);Mj(b,c.Jm());e&&b[B](new FMa)},this);return b};LW[K].yn=function(){if(1===this.vh[J])return this.vh[0];var a=[];X(this.vh,function(b){a[B](b.yn())});this.vh=a;return this};function MW(a){this.vh=a}W(MW,LW);MW[K].mM=function(){return 1};MW[K].Jm=function(){var a=[];X(this.vh,function(b){var c=b.ez();0<a[J]&&c?(a[B](new CMa),b=(new NW(b)).yn()):0<a[J]&&a[B](new DMa);a=Kj(a,b.Jm())});return a};function FMa(){}W(FMa,BW);FMa[K].er=function(){return ef};function GMa(a){gb(this,a)}W(GMa,BW);GMa[K].er=function(){return mta};function EMa(){}W(EMa,BW);EMa[K].er=function(){return df};function HMa(){}W(HMa,BW);HMa[K].er=function(){return Df};function OW(a){this.vh=a}W(OW,LW);OW[K].mM=function(){return 0};OW[K].Jm=function(){return this[Fe](new HMa)};function IMa(){}W(IMa,BW);IMa[K].er=function(){return ff};function JMa(){}W(JMa,BW);JMa[K].er=function(){return xEa};function KMa(a){this.vh=[a]}W(KMa,LW);function NW(a){this.vh=[a]}W(NW,KMa);NW[K].yn=function(){var a=this.vh[0].yn();if(a.ez()){if(a instanceof NW)return a.vh[0];if(a instanceof PW)return new PW(-a[I]());throw m("Unknown type of negative.");}return new NW(a)};NW[K].Jm=function(){return Kj([new JMa],this.vh[0].Jm())};NW[K].ez=function(){return this.yn()instanceof NW};function LMa(a){Sy(this,a)}W(LMa,BW);LMa[K].er=function(){return Nh};function PW(a){Sy(this,a)}W(PW,Ji);PW[K].Jm=function(){return[new LMa(this[wd])]};PW[K].ez=function(){return 0>this[wd]};hb(PW[K],function(){return this[wd]});PW[K].Oca=function(){return!0};function QW(a,b){this.vh=a;this.Jca=null!=b?b:!1}W(QW,LW);QW[K].mM=function(){return 2};QW[K].yn=function(){QW.e.yn[L](this);var a=0,b=[],c=1;X(this.vh,function(d){d.ez()&&(d=(new NW(d)).yn(),a++);d.Oca()&&(c*=d[I](),d=null);d&&b[B](d)});1!==c&&Hj(b,0,0,new PW(c));var d=new QW(b,this.Jca);a%2&&(d=new NW(d));return d};QW[K].Jm=function(){return this.Jca?Kj[Zc](null,wj(this.vh,function(a){return a.Jm()})):this[Fe](new IMa)};
QW[K].ez=function(){var a=0;X(this.vh,function(b){b.ez()&&a++});return!!(a%2)};function MMa(){}W(MMa,BW);MMa[K].er=function(){return mt};function RW(a){this.vh=a}W(RW,LW);RW[K].mM=function(){return 3};RW[K].Jm=function(){return this[Fe](new MMa)};function NMa(a,b,c){this.wa=[];this.jfa=a;this.kfa=b;this.nt=c||tV()}function OMa(a,b){if(0<a.wa[J]){var c=a.nt[AC](b),d=a.nt[AC](a.wa[a.wa[J]-1][0]),e=c-d;if(e>a.jfa&&(e=h[D](e/a.jfa),1<e))for(var f=1;f<e;f++){var g=a.nt[NA](f/e*(c-d)+d);a.wa[B]([g,a.kfa(g)])}}a.wa[B]([b,a.kfa(b)])}NMa[K].$g=function(){return this.wa};function PMa(a,b,c,d){a=QMa(a,b,c,{range:d[WA],wda:d.wda,IA:1,oW:d.oW});return null===a||fa(a.Ep)?null:{data:a[Y],Ep:a.Ep,mu:{offset:a.jK[0],mL:a.jK[1]}}};function SW(a){gb(this,a)}W(SW,Ji);SW[K].Jm=function(){return[new GMa(this[Nd])]};Bq(SW[K],function(){return this[Nd]});function RMa(a){this.qU=a.IA+1;this.Oa=a[WA];this.yra=a.wda;this.w3=0;this.nt=a.oW||tV();this.h3=0;this.wa=[]}RMa[K].add=function(a,b){if(0<this.wa[J]){var c=this.nt[AC](a)-this.nt[AC](this.wa[this.wa[J]-1].x);0<c&&(this.w3+=c)}this.h3+=b;this.wa[B]({x:a,y:b})};function SMa(a){var b=a.yra;b||(b=null!=a.Oa&&null!=a.Oa.min&&Wk(a.Oa.min)&&null!=a.Oa.max&&Wk(a.Oa.max)?(a.nt[AC](a.Oa.max)-a.nt[AC](a.Oa.min))/100:void 0);null!=b&&Wk(b)||(b=a.w3/(a.wa[J]-1));return b}
function TMa(a,b){return xj(a.wa,function(a,d){return a+h.pow(d.x,b)},0)}function UMa(a,b){return xj(a.wa,function(a,d){return a+h.pow(d.x,b)*d.y},0)}function VMa(a){for(var b=[],c=a.qU,d=0;d<c;d++){for(var e=ga(c+1),f=0;f<=c;f++)e[f]=f<c?TMa(a,d+f):UMa(a,d);b[B](e)}return new mS(b)}function WMa(a){var b=uIa(VMa(a));return wj(Wj(a.qU),function(a){return pS(b,a,this.qU)},a)}function XMa(a,b){var c=a.qU;return function(a){for(var e=0,f=0;f<c;f++)e+=b[f]*h.pow(a,f);return e}}
function YMa(a,b){var c=XMa(a,b),d=SMa(a);if(null==d||fa(d)||!Wk(d)||0===d)return null;var d=new NMa(d,c,a.nt),e=a.wa;Qj(e,function(a,b){return a.x>b.x?1:a.x<b.x?-1:0});var f=a.h3/e[J],g=a.Oa;null!=a.Oa&&null!=a.Oa.min&&Wk(a.Oa.min)&&g.min<e[0].x&&OMa(d,g.min);for(var k=0,l=0,n=!0,p=0;p<e[J];p++){var t=e[p].x,u=e[p].y,x=c(t),n=n&&x===u;OMa(d,t);k+=h.pow(u-x,2);l+=h.pow(u-f,2)}c=n?1:1-k/l;null!=a.Oa&&null!=a.Oa.max&&Wk(a.Oa.max)&&g.max>e[e[J]-1].x&&OMa(d,g.max);return{data:d.$g(),Ep:c}}
function ZMa(a){var b=WMa(a),c;c=[];for(var d=b[J]-1;0<=d;d--){var e=b[d];if(null!=e&&0!==e){e=new PW(e);if(0<d){var f=new SW(JC);1<d&&(f=new RW([f,new PW(d)]));e=new QW([e,f],!0)}c[B](e)}}c=new OW([new SW(zi),new MW(c)]);a=YMa(a,b);return null!=a&&0!==a[Y][J]?{jK:b,data:a[Y],Ep:a.Ep,mu:c.yn()}:null};function QMa(a,b,c,d){var e=new RMa(d);$k(al(a),function(a){var d=b(a);a=c(a);null!=d&&Wk(d)&&null!=a&&Wk(a)&&e.add(d,a)});return ZMa(e)};var $Ma={LINEAR:LG,$za:"exponential",ZAa:Fqa},aNa={linear:function(a,b,c,d){a=PMa(a,b,c,d);if(null===a)return null;b=new OW([new SW(zi),new MW([new QW([new PW(a.mu.mL),new SW(JC)]),new PW(a.mu[tA])])]);return{data:a[Y],Ep:a.Ep,mu:b.yn()}},exponential:function(a,b,c,d){for(var e=da,f=0;f<a;f++){var g=b(f),k=c(f);null!=k&&k<e&&(e=k)}e=0<e?null:e-1;a=PMa(a,b,function(a){a=c(a);if(null==a)return null;null!=e&&(a-=e);return h.log(a)},d);if(null===a)return null;b=[];for(f=0;f<a[Y][J];f++)g=a[Y][f][0],k=
h.exp(a[Y][f][1]),null!=e&&(k+=e),b[B]([g,k]);f=new QW([new PW(h.exp(a.mu[tA])),new RW([new SW(DI),new QW([new PW(a.mu.mL),new SW(JC)],!0)])],!0);null===e||(f=new MW([f,new PW(e)]));f=(new OW([new SW(zi),f])).yn();return{data:b,Ep:a.Ep,mu:f}}};aNa.polynomial=QMa;var bNa={NONE:O,WAa:BF,Lwa:kh,Pwa:OE,Eza:oK,Mwa:yH},cNa={NONE:O,aha:OG,qwa:Hg,rBa:RD,swa:JK,Hza:iK,Pwa:OE,Fza:nK},dNa={swa:JK,tBa:Yna,Dza:dya,POINTS:rF,aha:OG,qwa:Hg,NONE:O},eNa={Uza:FE,wAa:Voa,Pza:GE},fNa={$ga:gK,eha:ti,Jza:fK},gNa={$Aa:oF,DAa:rG,A3:wI},hNa={NONE:O,RIGHT:au,LEFT:Ch,TOP:kD,BOTTOM:uK,INSIDE:pH,tAa:aH,Aza:sK},iNa={NONE:O,TOP:kD,BOTTOM:uK,INSIDE:pH},jNa={DV:ui,BV:th},kNa={Uwa:TD,CENTER:dK,Jwa:zI},lNa={NONE:O,INSIDE:pH,OUTSIDE:JF},mNa={Bza:gya,GBa:Xma},nNa={gAa:AH,zAa:asa},oNa={NONE:O,
sAa:cH,eha:ti,Owa:CF,KBa:Hma},pNa={qz:Rg,eha:ti,Owa:CF},qNa={DEFAULT:PI,Xza:II},rNa={Vza:RI,$ga:gK,Twa:HE},sNa={Zga:Mg,$ga:gK,Twa:HE,NONE:O},TW={NONE:O,Lwa:kh,VAa:Sqa,Oza:qJ},tNa={uza:Dya,tza:Eya},UW={vAa:QG,aha:OG},VW=[{color:"#3366CC",lighter:"#45AFE2"},{color:gN,lighter:"#FF3300"},{color:eN,lighter:"#FFCC00"},{color:sN,lighter:"#14C21D"},{color:"#990099",lighter:"#DF51FD"},{color:"#0099C6",lighter:"#15CBFF"},{color:"#DD4477",lighter:"#FF97D2"},{color:"#66AA00",lighter:"#97FB00"},{color:"#B82E2E",
lighter:"#DB6651"},{color:"#316395",lighter:"#518BC6"},{color:kN,lighter:"#BD6CBD"},{color:"#22AA99",lighter:"#35D7C2"},{color:"#AAAA11",lighter:"#E9E91F"},{color:"#6633CC",lighter:"#9877DD"},{color:"#E67300",lighter:"#FF8F20"},{color:"#8B0707",lighter:"#D20B0B"},{color:"#651067",lighter:"#B61DBA"},{color:"#329262",lighter:"#40BD7E"},{color:"#5574A6",lighter:"#6AA7C4"},{color:"#3B3EAC",lighter:"#6D70CD"},{color:"#B77322",lighter:"#DA9136"},{color:"#16D620",lighter:"#2DEA36"},{color:"#B91383",lighter:"#E81EA6"},
{color:"#F4359E",lighter:"#F558AE"},{color:"#9C5935",lighter:"#C07145"},{color:"#A9C413",lighter:"#D7EE53"},{color:"#2A778D",lighter:"#3EA7C6"},{color:"#668D1C",lighter:"#97D129"},{color:"#BEA413",lighter:"#E9CA1D"},{color:"#0C5922",lighter:"#149638"},{color:"#743411",lighter:"#C5571D"}],uNa={color:"#EEEEEE",lighter:"#FEFEFE"},vNa=[[5],[2,5],[2,5],[2,4,6,8],[2,4,6,8],[2,3,4,5,6,7],[2,3,4,5,6,7,8],[2,3,4,5,6,7,8,9]],wNa={titleTextStyle:{color:rN,italic:!0},gridlines:{baseline:Mg,minorTextOpacity:.7,
minorGridlineOpacity:.4,newTimeline:!1,allowMinor:!0,minStrongLineDistance:40,minWeakLineDistance:40,minStrongToWeakLineDistance:5,minNotchDistance:10,minMajorTextDistance:10,minMinorTextDistance:5,unitThreshold:1.5,units:{milliseconds:{format:["h:mm:ss.SSS a"],interval:[1,5,10,50,100,200,500]},seconds:{format:["h:mm:ss a"],interval:[1,5,10,15,30]},minutes:{format:[nh],interval:[1,2,5,15,30]},hours:{format:["h a"],interval:[1,2,6,12]},days:{format:[Zf,Vg],interval:[1,2,7]},months:{format:["MMM y",
"MMM yy",EL],interval:[1,3,6]},years:{format:[zi],interval:[1,2,5,10,20,50,100,200,500,1E3]}}},minorGridlines:{units:{milliseconds:{format:[of],interval:[50,100,200,500]},seconds:{format:[yf],interval:[1,5,10,15]},minutes:{format:[jM],interval:[1,2,5,15]},hours:{format:["h a"],interval:[1,2,6]},days:{format:[Vg],interval:[1,7]},months:{format:[EL,"MM","MMMMM"],interval:[1,3]},years:{format:[zi],interval:[1,2,5,10,20,50,100,200,500,1E3]}}}},xNa={histogram:{hAxis:{baselineColor:O,gridlines:{color:O}},
bar:{groupWidth:AM}}},yNa={vAxis:wNa,hAxis:wNa,sizeAxis:{minSize:5,maxSize:30},fontName:WL,titleTextStyle:{color:Pe,bold:!0},bubble:{textStyle:{color:Pe}},candlestick:{hollowIsRising:!1},annotations:{datum:{textStyle:{color:GE},stemColor:iN},domain:{textStyle:{color:rN},stemColor:iN}},majorAxisTextColor:rN,minorAxisTextColor:oN,backgroundColor:{fill:Re,stroke:mN,strokeWidth:0},chartArea:{backgroundColor:{fill:O}},tooltip:{textStyle:{color:Pe}},baselineColor:qN,gridlineColor:bN,pieSliceBorderColor:Se,
pieResidueSliceColor:bN,pieSliceTextStyle:{color:Se},areaOpacity:.3,intervals:{style:JK,color:FE,lineWidth:1,fillOpacity:.3,barWidth:.25,shortBarWidth:.1,boxWidth:.25,dataOpacity:1,pointSize:6},actionsMenu:{textStyle:{color:Pe},disabledTextStyle:{color:"#c0c0c0"}},legend:{newLegend:!1,textStyle:{color:rN},pagingTextStyle:{color:"#0011cc"},scrollArrows:{activeColor:"#0011cc",inactiveColor:bN}},aggregationTarget:Mg,colorAxis:{legend:{textStyle:{color:Pe}}},bar:{groupWidth:100/1.618+Ve},histogram:{lastBucketPercentile:0,
hideBucketItems:!1,bucketSize:-1,minNumBuckets:5,maxNumBuckets:50}};function zNa(a){a=vj(a[zc](Ci),function(a){return null!=a&&ej(a)!==M});for(var b={},c=0;c<a[J];c++){var d=a[c][zc](Bi),e=wj(d[0][zc](jf),ej),f=gn(ej(d[1]));0===e[J]?pk(b,f):X(e,function(a){b[a]=b[a]||{};pk(b[a],f)})}return b};var ANa={LINEAR:LG,lAa:pH,TAa:JF,qAa:oH};function BNa(a){switch(a){case LG:return Kk;case pH:return sMa;case JF:return tMa;case oH:return uMa;default:return Kk}}function CNa(a,b,c){var d=Lo(a,gza,!1);b=So(a,YK,b);if(!b)return null;var e=So(a,hza,30);a=ep(a,iza,ANa,c);a=BNa(a);return{nia:d,duration:b,I6:a,rW:e}};function DNa(a){a=a[ae];return Si(a)&&a[Pb](/\S+/g)||[]}function ENa(a,b){for(var c=DNa(a),d=Nj(arguments,1),e=c,f=0;f<d[J];f++)Dj(e,d[f])||e[B](d[f]);c=c[Fe](Ke);pb(a,c)}function FNa(a,b){var c=DNa(a),d=Nj(arguments,1),c=GNa(c,d)[Fe](Ke);pb(a,c)}function GNa(a,b){return vj(a,function(a){return!Dj(b,a)})};function WW(){}W(WW,jQ);Ki(WW);R=WW[K];R.m=function(a){var b={"class":hL+this.cm(a)[Fe](Ke)},b=a.pa().m(ch,b,a[SB]());this.Yi(b,a.fn());return b};R.$k=function(){return mK};R.Wh=function(a){return a[$c]==ML};R.Va=function(a,b){qP(b,iL);return WW.e.Va[L](this,a,b)};hb(R,function(){return M});R.fa=function(){return Rza};VP(Rza,function(){return new lQ(null,WW.ac())});function XW(){}W(XW,WW);Ki(XW);XW[K].fa=function(){return Qza};VP(Qza,function(){return new lQ(null,XW.ac())});function YW(a,b){return HNa(a,b,0)}function HNa(a,b,c){for(var d=new Date(a[jc]()),e=!1,f=b[J],g=[h[Eb],h[Cb]][c],k=0;k<f;++k){var l=a[DE+ZW[k]],n=a[SH+ZW[k]][Zc](a),p=b[k],t=INa[k];if(0==p)e=e||0!=n&&0!=c,l[Zc](d,[t]);else{e?l[Zc](d,[t+p*(1+h[Eb]((n-t)/p))]):l[Zc](d,[t+p*g((n-t)/p)]);break}}return d}function JNa(a,b){var c=h[D],d=Lj(a),e;for(e=0;e<d[J]&&0==b[e];++e)d[e]=0;if(0==e)return d[0]=c(a[0]/b[0])*b[0],d;var f=0;a[e-1]>=KNa[e-1]?f=.7:0<a[e-1]&&(f=.1);d[e]=c((a[e]+f)/b[e])*b[e];return d}
function LNa(a){a=YW(a,[0,0,0,0,1]);return a=MNa(a,[0,0,0,0,(7+a[vc]()-1)%7],-1)}function $W(a,b,c){var d=wj(b,function(a){return[h.log(aX(a))]});if(!c)return a=iV(h.log(a),d),b[a];c=dKa(h.log(a),d,c);a=c[0];return a<=d[J]-1?b[a]:JNa(NNa(h.exp(c[1])),qj(b))}function MNa(a,b,c){a=new Date(a[jc]());var d;t:{for(d=0;d<b[J];++d)if(0!=b[d]){d=!1;break t}d=!0}if(d)return a;for(d=0;d<b[J];++d)if(0!=b[d]){var e=ZW[d],f=a[DE+e],e=a[SH+e][Zc](a,[]);f[Zc](a,[e+c*b[d]])}return a}
function bX(a,b,c,d){this.oga=a[jc]();this.OB=b;this.ava=d;this.b5=a[SH+ZW[c]][Zc](a,[]);this.bva=a[DE+ZW[c]];this.Rx=new Date(this.oga)}Da(bX[K],function(){var a=this.Rx;this.Rx=new Date(this.oga);this.b5+=this.ava;this.bva[Zc](this.Rx,[this.b5]);return a});bX[K].Co=function(){return this.Rx<this.OB?this.Rx:null};function ONa(a){a=Bj(a,function(a){return 0!=a});return h.max(0,a)}function aX(a){if(null==a)return-1;for(var b=0,c=a[J],d=0;d<c;++d)b+=a[d]*cX[d];return b}
function NNa(a){for(var b=[],c=cX[J]-1;0<=c;c--)b[c]=h[Eb](a/cX[c]),a-=b[c]*cX[c];return b}function dX(a){a=PNa(a);return aX(a)}function eX(a){return NNa(a)[gr]()}function PNa(a){a=4>a[J]?Kj(a,Xj(0,4-a[J])):Lj(a);return a[gr]()}function QNa(a){a=PNa(a);var b=new Date(1970,0,1,0,0,0,0);b[Hd]((a[6]||0)+1970);b[Fd](a[5]||0);b[Td]((a[4]||0)+1);b.setHours(a[3]||0);b.setMinutes(a[2]||0);b.setSeconds(a[1]||0);b.setMilliseconds(a[0]||0);return b}function RNa(a,b){return wj(a,function(a){return a*b})}
var ZW="Milliseconds Seconds Minutes Hours Date Month FullYear".split(" "),SNa=["milliseconds","seconds","minutes","hours",dwa,"months","years"],TNa={};X(SNa,function(a,b){TNa[a]=b});var UNa=[[1],[0,1],[0,0,1],[0,0,0,1],[0,0,0,0,1],[0,0,0,0,0,1],[0,0,0,0,0,0,1]],INa=[0,0,0,0,1,0,0],KNa=[500,30,30,12,15,6,0],cX=[1,1E3,6E4,36E5,864E5,2629743830,31556926E3];function VNa(a){switch(a){case Xg:case $g:return{ck:WNa,Yy:XNa};case ni:return{ck:YNa,Yy:ZNa};case Nh:case ii:return{ck:$Na,Yy:aOa};default:return{ck:$Na,Yy:aOa}}}function $Na(a){return ha(a)}function aOa(a){return a}function WNa(a){return a[jc]()}function XNa(a){return new Date(a)}function YNa(a){return dX(a)}function ZNa(a){return eX(a)};function fX(a,b,c){this.N0=a;this.$R=b;this.Z1=c}W(fX,GW);R=fX[K];La(R,function(a,b,c){fX.e[Sc][L](this,a,b,c);a=Io(a,this.Ja(Fua));b=[];b[B](a.millisecond);b[B](a.second);b[B](a.minute);b[B](a.hour);b[B](a.day);b[B](a.month);b[B](a.year);this.Z1=bOa([b,Xj(this[Rb],b[J]),this.Z1])});function bOa(a){a=Yj[Zc](null,a);return wj(a,function(a){return Aj(a,function(a){return a})})}R.Q=function(a,b){return a.Q(b)};R.hK=function(a){return WNa(a)};R.pG=function(a){return XNa(a)};R.g1=function(a){return a};
R.b1=function(){var a=new Date(0);a[Hd](0);return a};R.hJ=function(a){var b=this.ee,c=this.oe,d=this.Cq;-1===d&&(d=6);var e=(c-b)/d,d=$W(e,this.N0,this.$R);a?(b=YW(new Date(b),d),c=HNa(new Date(c),d,1)):(b=HNa(new Date(b),d,1),c=YW(new Date(c),d));e=NNa(e);e=JNa(e,d);this.tea=e=0<aX(e)?e:d;this.xta=b;this.Wea=c;a&&(HW(this,b[jc]()),IW(this,c[jc]()))};
R.Z3=function(a){for(var b=[],c=this.xta;c<this.Wea;)b[B](c[jc]()),c=MNa(c,this.tea,1);if(a||c<=this.Wea)b[B](c[jc]()),IW(this,h.max(this.oe,c[jc]()));this.Hp(b)};R.wJ=function(){var a=ONa(this.tea),a=this.Z1[a];this.gd=typeof a===Ph?new Wp(a):new Wp({pattern:a})};
var cOa=[[0,0,0,0,1],[0,0,0,0,2],[0,0,0,0,7],[0,0,0,0,0,1],[0,0,0,0,0,3],[0,0,0,0,0,6],[0,0,0,0,0,12],[0,0,0,0,0,0,1],[0,0,0,0,0,0,5],[0,0,0,0,0,0,10],[0,0,0,0,0,0,25],[0,0,0,0,0,0,50],[0,0,0,0,0,0,100]],dOa=[Xp.MEDIUM_DATE,Xp.MEDIUM_DATE,Xp.MEDIUM_DATE,Xp.MEDIUM_DATE,Xp.MEDIUM_DATE,Sp.YEAR_MONTH_ABBR,zi],eOa=[[1],[2],[5],[10],[20],[50],[100],[200],[500],[0,1],[0,2],[0,5],[0,10],[0,15],[0,30],[0,0,1],[0,0,2],[0,0,5],[0,0,10],[0,0,15],[0,0,30],[0,0,0,1],[0,0,0,2],[0,0,0,3],[0,0,0,4],[0,0,0,6],[0,0,
0,12],[0,0,0,0,1],[0,0,0,0,2],[0,0,0,0,7],[0,0,0,0,0,1],[0,0,0,0,0,3],[0,0,0,0,0,6],[0,0,0,0,0,12],[0,0,0,0,0,0,1],[0,0,0,0,0,0,5],[0,0,0,0,0,0,10],[0,0,0,0,0,0,25],[0,0,0,0,0,0,50],[0,0,0,0,0,0,100]],fOa=[Xp.MEDIUM_TIME,Xp.MEDIUM_TIME,Xp.SHORT_TIME,{pattern:Xp.SHORT_TIME,clearMinutes:!0},Xp.MEDIUM_DATE,Sp.YEAR_MONTH_ABBR,zi];function gOa(a,b,c,d,e,f,g,k){var l=b-a;if(0>=l)return null;for(var n=h[Eb](h.log(l)/h.log(10)),l=jV(5,function(a){return{he:h.pow(10,n-a),ZU:5}}),p=[],t=!1,u=0;u<l[J];++u){var x=l[u],A=hOa(a/(x.he*x.ZU),b/(x.he*x.ZU),c,d,e,f,g),p=p[Hb](wj(A,function(a){return[x,a]}));if(t)break;t=!Ej(A)}return xj(p,function(a,b){for(var c=b[0],d=b[1],e=null,f=d.Sta;f<=d.Rta&&e!=f;e=f,f+=d.Tta){var e=h[D](c.ZU*f),l=h[D](c.ZU*(f+g*d.Uta)),n=k(e,l,c.he);n>a.sm&&(a={sm:n,efa:{cj:h[D](e)*c.he,Mr:h[D](l)*c.he}})}return a},
{sm:-da,efa:null}).efa}function hOa(a,b,c,d,e,f,g){for(var k=[],l=b-a,n=d+f,p=h[Cb](l/(1-(c+e))/g),l=h[Eb](l/(1-n)/g);p<da&&p<=l;++p){var n=p*g,t=h[Cb](h.max(a-d*n,b-(1-e)*n)),u=h[Eb](h.min(a-c*n,b-(1-f)*n)),x=1;0<b&&0>a?1<g&&(t=h[Cb](t/p)*p,u=h[Eb](u/p)*p,x=p):0<=a?t=h.max(0,t):u=h.min(-n,u);0<=u-t&&k[B]({Uta:p,Tta:x,Sta:t,Rta:u})}return k}function gX(a){if(0==a)return 0;0>a&&(a=-a);if(.5>a)return 0;for(;0==h[D](a%10);)a=h[D](a/10);return 1==a||5==a?.5:h[Eb](h.log(a)/h.log(10))+1};function hX(){this.baa=0}W(hX,GW);R=hX[K];R.taa=function(){return 4};La(R,function(a,b,c){hX.e[Sc][L](this,a,b,c);this.gd=null;this.RI=Po(a,this.Ja(WH),1);this.yR=a.Q(this.Ja(Jna),[10,2,5,1])});
R.Z3=function(a){var b,c,d,e,f;a?(b=U(iOa,null,this.yR,this.Cq,this.ee,this.oe),c=-1E-4,d=1/h.max(this.Cq,3),e=c,f=d):(c=-1/h.max(this.Cq,3),d=0,e=c,f=d,this.yR[0]*=-1,b=U(iOa,null,this.yR,this.Cq,this.ee,this.oe));a=this.ee;var g=this.oe,k=this.Cq;(b=gOa(a,g,c,d,e,f,k,b))||(0<=a||0>=g||1==k?b={cj:a,Mr:g}:(b=h.max(1,h.min(k-1,h[D](g/(g-a)*k))),k-=b,a=h.max(g/b,-a/k),b={cj:-k*a,Mr:b*a}));a=b;g=(a.Mr-a.cj)/this.Cq;k=[];for(b=0;b<=this.Cq;++b)k[B](a.cj+g*b);HW(this,h.min(k[0],this.ee));IW(this,h.max(k[k[J]-
1],this.oe));this.Hp(k)};R.Hp=function(a){hX.e.Hp[L](this,a);var b=0;X(this[RA],function(a){a=this.Bp(a);b=h.max(b,mV(a/this.RI))},this);this.baa=b};R.wJ=function(){var a={pattern:this[Rb],fractionDigits:this[Rb]?null:this.baa,scaleFactor:this.RI,prefix:Xo(this.b,this.Ja(XH)),suffix:Xo(this.b,this.Ja(VH))};this.gd=new Yp(a)};
function iOa(a,b,c,d,e,f,g){c=a[0]*(d-c)/(g*(f-e));d=(f-e)/b;for(g=1;g<b;++g)c-=a[1]*h.pow(gX(e+g*d),1.2);c-=a[2]*h.pow(gX(e),1.2);c-=a[2]*h.pow(gX(f),1.2);return c-=a[3]*h.pow(gX(d),1.2)}R.Q=function(a,b){return Qo(a,b)};R.hK=function(a){return ha(a)};R.pG=function(a){return a};R.g1=function(a){return a};R.b1=function(){return 0};function jOa(){this.vM={}}var kOa=null;function iX(){return kOa?kOa:kOa=new jOa}jOa[K].ph=function(a){return(a=this.vM[a])?a[Zc](null,[]):null};function jX(){this.H2=1}W(jX,GW);R=jX[K];R.Q=function(a,b){return a.Q(b)};R.kba=function(a,b){var c=dX(a),d=dX(b);return c<d?-1:c>d?1:0};R.hK=function(a){return dX(a)};R.pG=function(a){return eX(a)};R.g1=function(a){return a};R.b1=function(){return eX(0)};
R.hJ=function(a){var b=this.ee,c=this.oe;this.Ha=b;this.tb=c;var d=this.Cq;-1===d&&(d=6);var d=(c-b)/d,e=$W(d,lOa,0);this.H2=ONa(e);e=aX(e);this.tickSize=d=h.max(1,h[D](d/e))*e;a?(HW(this,h[Eb](b/d)*d),IW(this,h[Cb](c/d)*d)):(HW(this,h[Cb](b/d)*d),IW(this,h[Eb](c/d)*d))};R.Z3=function(){for(var a=[],b=this.ee,c=this.oe;b<c;)a[B](b),b+=this.tickSize;a[B](b);this.Hp(a)};R.wJ=function(){var a=new Wp({pattern:this[Rb]?this[Rb]:1<this.H2?Tf:1===this.H2?rBa:qBa});this.gd={Sc:function(b){b=QNa(b);return a.Sc(b)}}};
var lOa=[[0,1,0,0],[0,2,0,0],[0,5,0,0],[0,10,0,0],[0,20,0,0],[0,30,0,0],[0,0,1,0],[0,0,5,0],[0,0,10,0],[0,0,15,0],[0,0,30,0],[0,0,0,1],[0,0,0,2],[0,0,0,3],[0,0,0,4],[0,0,0,6],[0,0,0,12]];iX().vM.timeofday=function(){return new jX};iX().vM.date=function(){return new fX(cOa,3,dOa)};iX().vM.datetime=function(){return new fX(eOa,3,fOa)};iX().vM.number=function(){return new hX};function mOa(){}R=mOa[K];R.RQ=function(a){var b=a.ob;a=a.mb;var c=kX(this,b,a);return this.g[b].l[c].de.Aw||(this.Ga[c]?this.Ga[a].hu[0]:null)};function nOa(a,b){var c=b.ob,d=kX(a,c,b.mb);return a.g[c].l[d].de.Dm||a.g[c][bC]}R.n0=function(a){return a.mb};R.iZ=function(a){return{row:a.mb,Db:this.g[a.ob].Ht}};R.ZO=function(a){var b=this.kp[a.Db].$b;return null!=b?{ob:b,mb:this.lr[a.row]}:null};R.uH=function(a,b){return this.g[a].l[b].de};function lX(a,b){this.J=b;this.bv=a;this.mr=null;this.sd={};this.Lw={};this.uw=this.ir=this.HZ=this.Gb=null}R=lX[K];R.qp=function(a,b){this.sd={};this.Lw={};this.J[bc]();this.bv[bc]();oOa(this,a,b);var c=this.Gb,c=this.J.xm(c[r],c[z]);pOa(this,b,c)};function oOa(a,b,c){var d=new DT(2);ET(d,0,b);ET(d,1,c);a.Gb=d[iB]()}
function pOa(a,b,c){a[eA](c.a(),ut);var d=a.Gb,e=a.J,f=d.pF;!po(f)&&!oo(f)||e.eb(0,0,d[r],d[z],f,c);d.gA==JF&&(f=a.Xt(d[bC],c),a[eA](f,qD));a.ir=e.Ba(!0);f=d.Ea;a.oF(f);f&&f[tc]!=pH&&(e[q](c,a.ir),a[eA](a.ir.a(),XG));a.uw=e.Ba(!0);f=d.Gi;qOa(a,f);f&&f[tc]!=pH&&(e[q](c,a.uw),a.sd.colorbar=a.uw.a());a.HZ=e.Ba(!1);a.P9(d,c)||a.WW(d,c);e[q](c,a.HZ);a.mr=b;e.KM()}
R.WW=function(a,b){var c={color:AK,$a:a.kk,fontSize:a.wm,bold:!1,Tc:!1,Re:!1};this.Bj(CL,c,a.t[r]);var d=a.t.top+h[D](a.t[z]/2);this.J.Ji(CL,a.t[G],d,a.t[G]+a.t[r],d,dK,dK,c,b)};R.oF=function(a){if(a){var b=a.gu;if(b){var c;a.rI?c=a.area:(c=wj(b,function(a){return rOa(a)},this),c=io(c));c&&(c=zm(c),this.J.eb(c[G],c.top,c[r],c[z],ro,this.ir));for(c=0;c<b[J];c++)sOa(this,b[c]);tOa(this,a.rI)}}};function rOa(a){var b=[];if(a.za){var c=gV(a.za);c&&b[B](c)}a.gc&&b[B](ym(a.gc[$A]));return io(b)}
function mX(a,b,c,d,e,f,g){var k=a.J.vG(),l=f[H],n=ha(f.sides);null!=n&&Wk(n)||(n=5);var p=ha(f.rotation);null!=p&&Wk(p)||(p=0);p=p/180*h.PI-h.PI/2;l===$ma?(l=pF,n=3):l===WD?(l=pF,n=4,p+=h.PI/4):l===Xva&&(l=pF,n=4);var t=l===UD;500<n&&(l===pF||l===UD)&&(l=NJ);var u=null;if(l===pF||l===UD){f=ha(f.dent);null!=f&&Wk(f)||(5<=n?(f=h.cos(h.PI/n),f-=h.pow(h.sin(h.PI/n),2)/h.sin(h.PI/2-h.PI/n)):f=.3);f*=d;l===UD&&(n*=2);l=new bO;for(u=0;u<n;u++){var x=d;t&&u%2&&(x=f);var A=2*h.PI/n*u+p,C=h.cos(A)*x+b,x=h.sin(A)*
x+c;0<u?l.ha(C,x):l[yB](C,x)}l[Hr]();u=a.J.zc(l,e)}else u=a.J.kx(b,c,d,e);u&&g&&a.J[q](g,u);a.J.nB(k);return u}
R.uX=function(a,b){var c=this.Gb.g[a[xc]];if(this.Gb.WV&&c&&!c.zh&&c.EF){var d=a.gc[$A][G],e=a.gc[$A][r],f=a.gc[$A][z],g=d+e/2,k=a.gc[$A].top+f/2;c.rw&&this.J.eb(d,k,e,f/2,c.rw,b);var l=.5*f,n=c.Hc;n&&(n.Lb>l&&(n=n[Jc](),n.mk(l)),this.J.DF(d,k,d+e,k,n,b));c.Fg&&((d=c.EF)||(d={type:NJ}),c=c.Fg[Jc](),c.Eg(1),mX(this,g,k,f/2,c,d,b))}else this.J.eb(a.gc[$A][G],a.gc[$A].top,a.gc[$A][r],a.gc[$A][z],a.gc.brush,b)};
function sOa(a,b){if(b.W){var c=a.J.Ba(!1),d=RS([SG,b[xc]]);a[eA](c.a(),d,SG);if(d=rOa(b))d=zm(d),a.J.eb(d[G],d.top,d[r],d[z],ro,c);b.za&&a.Xt(b.za,c);b.gc&&a.uX(b,c);d=null;if(b.Ig&&b.Ig.W){var e=b.Ig[$A].x,f=b.Ig[$A].y,g=b.Ig.brush,d=a.J,k=d.Ba();d.eb(e,f,12,12,g,k);d[q](c,k);g=new bO;g[yB](e+2,f+2);g.ha(e+12-2,f+12-2);g[yB](e+12-2,f+2);g.ha(e+2,f+12-2);e=new lo;e.ld(Se);e.mk(2);d.ta(g,e,k);d=k.a();k=RS([Tpa,b[xc]]);a[eA](d,k)}a.J[q](a.ir,c)}}
function tOa(a,b){b&&(uOa(a,b.g_,-1),b.f_&&a.Xt(b.f_,a.ir),uOa(a,b.e_,1))}function uOa(a,b,c){if(b){var d=eO(b[LB]),d=a.J.ta(d,b.brush,a.ir);b.Zu&&(b=RS([RG,c]),a[eA](d,b))}}function qOa(a,b){if(b){var c=b[gA],d=a.J,e=a.uw;eLa(c.j_,d,e);fLa(c.k_,d,e);gLa(c.l_,d,e);c=a.J.eb(b.qI[G],b.qI.top,b.qI[r],b.qI[z],ro,a.uw);a[eA](c,Kwa)}}R.Bj=function(a,b,c){var d=b[Gc];a=this.J.sl(a,b);a>c&&(d=h.max(1,h[Eb](b[Gc]*c/a)));return d};function nX(a,b){var c=a.sd[b];c&&(a.J.Wf(c),delete a.sd[b])}
R.iG=function(a,b){var c=a[AA]?dV(a,this.bv[Sr]()):eV(a,this.J,this.HZ).a();this[eA](c,b)};R.Xt=function(a,b,c){(a=vOa(this,a,c))&&this.J[q](b,a);return a};
function vOa(a,b,c){var d=b.I;if(!d||0==d[J])return null;a=a.J;var e=b.ba,f=b.gr,g=null!=b.Eb?b.Eb:0,k=b[lC]?b[lC]:{x:0,y:0},l=b.rb,n=!!l||c||!1;c=a.Ba();if(0===g&&f){var p=gV(b);if(p){var t=h[Cb](p[G]-3)+.5,u=h[Eb](p.top-1)+.5;a.eb(t,u,h[Eb](p[kd]+3)+.5-t,h[Eb](p[Uc]+1)+.5-u,f,c)}}for(f=0;f<d[J];f++)p=d[f],0===g?a.Jd(p[pd],p.x+k.x,p.y+k.y,p[J],b.Gc,b.Fc,e,c):lGa(a,p[pd],p.x+k.x,p.y+k.y,p[J],g,b.Gc,b.Fc,e,c);if(n){n=null;if(0===g)(p=gV(b))&&(n=a.eb(p[G],p.top,p[kd]-p[G],p[Uc]-p.top,ro,c));else{var x=
Ok(g);b=nk(b);b.Eb=0;k=(new oO(k.x,k.y))[OA](-x);sz(b,new fV(k.x,k.y));for(f=0;f<d[J];f++)k=(new oO(d[f].x,d[f].y))[OA](-x),b.I[f].x=k.x,b.I[f].y=k.y;if(p=gV(b))d=[new oO(p[G],p.top),new oO(p[kd],p.top),new oO(p[kd],p[Uc]),new oO(p[G],p[Uc])],X(d,function(a){a[OA](x)}),d=eO(d,!1),n=a.ta(d,ro,c)}l&&n&&nGa(a,n,l,aJa(e))}return c.a()}R.Ce=function(a,b,c){var d=this.sd[b];null!=d?this.J[rB](a,c,d):this.J[q](a,c);this[eA](c,b)};
R.registerElement=function(a,b,c){a&&(this.J.qo(a,b),this.sd[b]=a,c&&(this.Lw[c]||(this.Lw[c]=[]),Dj(this.Lw[c],b)||this.Lw[c][B](b)))};function wOa(a,b){var c=a.sd[b];c&&(a.J.Wf(c),delete a.sd[b])}R.Al=function(a){var b=[];if(this.sd[a]){var c=this.J.Al(this.sd[a]);c&&b[B](c)}a=this.Lw[a]||[];for(var d=0;d<a[J];++d)(c=this.J.Al(this.sd[a[d]]))&&b[B](c);return io(b)};function oX(a,b){return a.V&&a.V.brush||a.brush||b.Fg}function xOa(a,b){return null===a.ms?null:a.ms||b.Hc}function pX(a){return a[H]==OG||a[H]==Hg||a[H]==OE}function qX(a,b){return null!=a[TB]?a[TB]:b.wM}function yOa(a,b){var c=a.l[b],d=a.l[b-1],e=a.l[b+1],d=!d||!d.V||d.df,e=!e||!e.V||e.df;return!(!c||!c.V||c.df)&&d&&e}function kX(a,b,c){b=a.g[b];return b.jg&&Gi(b.z6)?(a=a.g[b.z6].l[c],a=null!=a?a.yf.tl:a,null!=a?Oj(b.l,a,function(a,b){return a-b.yf.tl}):c):c}
function zOa(a,b){return a.V&&null!=a.V[HB]?a.V[HB]:null!=a[HB]?a[HB]:b.$c}function rX(a,b){return zOa(a,b)+no(oX(a,b))/2}function AOa(a){return a.Rd&&a.ab==kh&&a[QB]==th}
function sX(a,b){for(var c=new MO,d=!0,e=!0,f=null,g=null,k=0;k<a.l[J];k++){var l=a.l[k];if(l&&l.V&&null!=l.V.x&&null!=l.V.y){d&&(f=k,d=!1);var n=l.V,p=xOa(l,a);e||null===p?(c[yB](n.x,n.y),e=!1):a.NY?c.Qp(p,a.l[g].ps.x,a.l[g].ps.y,l.os.x,l.os.y,n.x,n.y):c.ha(p,n.x,n.y);g=k}else e=!b||d}!d&a.lka&&(d=b?g:a.l[J]-1,f=b?f:0,null!=d&&null!=f&&a.l[d]&&a.l[f]&&(p=xOa(a.l[f],a),a.NY?c.Qp(p,a.l[d].ps.x,a.l[d].ps.y,a.l[f].os.x,a.l[f].os.y,a.l[f].V.x,a.l[f].V.y):c[Hr](p)));return c}
function BOa(a){for(var b=new MO,c=!0,d=0;d<a.l[J];d++){var e=a.l[d].V;null!=e.x&&null!=e.y?(c||b.ha(xOa(a.l[d],a),e.nN,e.oN),(c||e.nN!=e.lN||e.oN!=e.mN)&&b[yB](e.lN,e.mN),c=!1):c=!0}return b}function COa(a,b,c){return(c=(a=a.rd)&&a[c||0])&&c[tc].Be(b)}function DOa(a,b,c){return(c=(a=a.Zc)&&a[c||0])&&c[tc].Be(b)}function EOa(a,b,c){return(c=(a=a.rd)&&a[c||0])&&c[tc].lk(b)}function FOa(a,b,c){return(c=(a=a.Zc)&&a[c||0])&&c[tc].lk(b)}
function GOa(a,b,c,d){for(var e=a.g,f=null,g=da,k,l=new xl(b,c),n=0,p=e[J];n<p;n++){var t=e[n];if(!t.jg)if(a.ab===BF){t:{var u=b,x=c;k=d;var A=t.oA.x-u,C=t.oA.y-x,E=0<-A*(t.oA.y-t.jf.y)+C*(t.oA.x-t.jf.x);if(0<-(t.Nt.x-t.Bh.x)*C+(t.Nt.y-t.Bh.y)*A&&E&&(A=h[Kd](h.pow(t.Nt.x-t.Bh.x,2)+h.pow(t.Nt.y-t.Bh.y,2)),h[Kd](h.pow(t.Nt.x-u,2)+h.pow(t.Nt.y-x,2))<A+k)){t=!0;break t}t=!1}if(t)return{row:n}}else{u=0;for(x=t.l[J];u<x;u++)if((k=t.l[u])&&null!=k.V)switch(k=k.V,t[H]){case OG:case nK:case OE:k=zl(l,k);k<
d&&k<g&&(f={EM:u,row:n},g=k);break;case iK:case JK:A=null;t[H]===JK?A=new xm(k[G],k.top,k[r],k[z]):t[H]===iK&&(A=k[nC],C=h.min(k[eC].top,A.top),A=new xm(k[eC][G],C,k[eC][r],h.max(k[eC].top+k[eC][z],A.top+A[z])-C));k=d;A=A.distance(l);(k=A>k?null:A)&&k<g&&(f={EM:u,row:n},g=k);break;default:throw"unknown chart type for getPointDatum.";}if(0===g)break}}return f};function HOa(a,b){lX[L](this,a,b);this.Af=null;this.u3=[]}W(HOa,lX);function tX(a,b,c){a.u3[B]({definition:b,id:c})}function IOa(a){var b=a.J.vG();X(a.u3,U(function(a){this.iG(a[gA],a.id)},a));a.J.nB(b);a.u3=[]}R=HOa[K];
R.P9=function(a,b){function c(b){b=a.g[b];return!a.kd||b[H]!==OE||b.wM}JOa(this,a);var d=this.J.Ba(!1);this.J[q](b,d);this[eA](d.a(),TJ);Zj(this.Af,function(a){a.Ue||(a.Ue=this.J.Ba(!(Gi(a.g7)&&!a.g7)))},this);this.J.eb(a.t[G],a.t.top,a.t[r],a.t[z],a.Z5,d);a.gA==pH&&this.Xt(a[bC],this.Af[bC].Ue);a.KF&&this.Xt(a.KF,this.Af.axistitle.Ue);X(a.Ga,function(a,b){a.Uc&&uX(this,a.Uc,null,b)},this);Zj(a.rd,function(b){KOa(this,a,b)},this);Zj(a.Zc,function(b){LOa(this,a,b)},this);var e=new xm(a.t[G],a.t.top,
a.t[r],a.t[z]);this.J.nB(e);for(var f=[],g=0;g<a.g[J];g++)c(g)&&f[B]({rF:a.g[g].rF,index:g});Rj(f,function(a,b){return Pj(a.rF,b.rF)});for(g=0;g<f[J];g++){var k=f[g][xc];MOa(this,a.g[k],k)}a.kd&&a.g[0][H]===OE&&NOa(this,a,b);for(g=0;g<a.Ga[J];g++)a.Ga[g].rb&&(f=RS([wu,g]),tX(this,a.Ga[g].rb,f));g=this.J.vG();Zj(a.rd,function(a){OOa(this,a)},this);Zj(a.Zc,function(a){OOa(this,a)},this);this.J.nB(g);IOa(this);var l=this.J.Ba(!1),e=this.J.cG(l,e);this.J[q](d,e);X(FIa,function(a){var c=this.Af[a].Ue;
if(c){var e;switch(this.Af[a][tc]){case sJ:e=l;break;case mH:e=d;break;case IF:e=b}this.J[q](e,c)}},this);return!0};
function JOa(a,b){a.Af={};var c=a.Af;Iy(c,{position:IF});c.annotation={position:sJ};c.annotationtext={position:mH};c.area={position:sJ};c.bar={position:sJ};c.baseline={position:sJ};c.bubble={position:sJ};c.categorysensitivityarea={position:sJ};c.candlestick={position:sJ};c.histogram={position:sJ};c.gridline={position:sJ};c.interval={position:sJ};tz(c,{position:sJ});c.minorgridline={position:sJ};c.overlaybox={position:sJ};c.pathinterval={position:sJ};c.point={position:mH,g7:!1};c.pointsensitivityarea=
{position:mH};c.steppedareabar={position:sJ};c.tooltip={position:IF};Xq(c,{position:b.gA==pH?mH:IF});c.axistick={position:mH};c.axistitle={position:b.uF==pH?mH:IF};var d=b.Ea&&b.Ea[tc]==pH,e=d?a.ir:null,d=d?mH:IF;c.legend={Ue:e,position:d};c.legendscrollbutton={Ue:e,position:d};c.legendentry={Ue:e,position:d};e=b.Gi&&b.Gi[tc]==pH;c.colorbar={Ue:e?a.uw:null,position:e?mH:IF}}
function MOa(a,b,c){if(b[H]==nK)POa(a,b,c);else if(b[H]==JK)QOa(a,b,c);else if(b[H]==RD)QOa(a,b,c);else if(b[H]==iK)for(var d=0;d<b.l[J];d++)ROa(a,c,b.l[d],d);else if(b[H]==Hg){var e=a.Gb.Rd,f=a.Gb.xj;if(0!=b.l[J]){for(var f=f&&!e,g=[],k={start:null,end:null,brush:null},d=0;d<=b.l[J];d++){var l=b.l[d];l&&!l.df?null===k[y]?Ja(k,d):(l=l.NF||b.rw,null===k.brush||Wfa(k.brush,l)?(k.end=d,k.brush=l):(g[B](k),k={start:d-1,end:d,brush:l})):f&&d!==b.l[J]||(null===k[y]||null===k.end||g[B](k),d<b.l[J]&&(k={start:null,
end:null,brush:null}))}l=a.J.Ba();for(d=0;d<g[J];d++){var k=g[d],n=k.brush,p=new bO,t=p,u=b,x=e,A=k[y],k=k.end,C=!0,E=null;t[yB](u.l[A].V.tW,u.l[A].V.uW);for(var Q=A;Q<=k;Q++){var N=u.l[Q],S=N.V;N.df||(t.ha(S.nN,S.oN),S.lN==S.nN&&S.mN==S.oN||t.ha(S.lN,S.mN),null!=S.x&&null!=S.y&&(C=!1,E=Q))}if(!C)if(x)for(Q=k;Q>=A;Q--)S=u.l[Q].V,t.ha(S.vW,S.wW),S.tW==S.vW&&S.uW==S.wW||t.ha(S.tW,S.uW);else S=u.l[E].V,t.ha(S.vW,S.wW),t[Hr]();a.J.ta(p,n,l)}d=RS([Hg,c]);a.Ce(a.Af.area.Ue,d,l.a());if(e){d=BOa(b);e=RS([OG,
c]);f=d.zc(a.J);g=SOa(a,b);if(f){l=b.Wn;n=b.Li;if(l||n){g=g||a.J.Ba();if(l)for(d=0;d<l.Ie[J];d++)a.J.ta(l.Ie[d][LB],l.Ie[d].brush,g);n&&a.J.ta(n[LB],n.brush,g)}g&&a.J[q](g,f)}d=g?g.a():f;null!=d&&a.Ce(a.Af[nC].Ue,e,d);TOa(a,b,c)}else UOa(a,b,c,f)}}else UOa(a,b,c,a.Gb.xj);if(b.wf&&b.wf[aB])for(b=b.wf[aB],d=0;e=b[d];++d)0!=e[nC][J]&&(f=new bO,dO(f,e[nC],e.NV),e[Uc]&&dO(f,e[Uc],e.Bia),g=a.J.Ba(),a.J.ta(f,e.brush,g),e=g.a(),f=RS([Vqa,c,d]),a.Ce(a.Af.pathinterval.Ue,f,e))}
function VOa(a,b,c,d,e){b[H]==JK||b[H]==RD?a.He(b,c,d,e):b[H]==iK?ROa(a,c,d,e):b[H]==nK?a.pI(b,c,d,e):WOa(a,b,c,d,e,a.Af.point.Ue)}function POa(a,b,c){var d=a.Af.bubble.Ue,e=jV(b.l[J],function(a){return a});b.eia&&Qj(e,function(a,c){var d=b.l[a],e=b.l[c];return(e?e.V[HB]:0)-(d?d.V[HB]:0)});for(var f=0;f<e[J];f++){var g=e[f],k=b.l[g];if(k){a.pI(b,c,k,g);var l=a.J.bf(k[pd],k.ba);if(l[r]<2*k.V[HB]||l[z]<2*k.V[HB])k=a.J.Jd(k[pd],k.V.x,k.V.y,k.vha,dK,dK,k.ba,d),g=RS([oK,c,g]),a.J.qo(k,g)}}}
function QOa(a,b,c){for(var d=0;d<b.l[J];d++)a.He(b,c,b.l[d],d)}
R.He=function(a,b,c,d){if(c&&c.V){var e=c.brush||oX(c,a),f=a[H]==JK?qt:QD,g=RS([f,b,d]),k=c.V.qr||c.V,e=this.J.nl(k[G],k.top,k[r],k[z],e),k=null,l=c.V.outline,n=c.Wn,p=c.Li;if(l||n||p){k=this.J.Ba();this.J[q](k,e);if(l){var t=c.Hc||a.Hc,l=eO(l,!0);this.J.ta(l,t,k)}if(n)for(t=0;t<n.Ie[J];t++)l=n.Ie[t][eC],this.J.eb(l[G],l.top,l[r],l[z],n.Ie[t].brush,k);p&&this.J.eb(p[eC][G],p[eC].top,p[eC][r],p[eC][z],p.brush,k)}e=k?k.a():e;this.Ce(this.Af[f].Ue,g,e);c.rb&&(f=RS([wu,b,d]),tX(this,c.rb,f));c.Uc&&uX(this,
c.Uc,b,d);c.V.zr&&XOa(this,a,b,d,c.V.zr)}};function SOa(a,b){var c=null,d=null;X(b.l,function(a,f){yOa(b,f)&&(c||(c=this.J.Ba()),d||(d=so(b.Hc.pe,b.Hc.pi)),qX(a,b)||this.J.ce(a.V.x,a.V.y,b[jB],d,c))},a);return c}
function UOa(a,b,c,d){var e=RS([OG,c]);if(0>=b[jB])wOa(a,e),TOa(a,b,c);else{var f=sX(b,d);if(!Ej(f.md)){d=(f=f.zc(a.J))&&d?null:SOa(a,b);if(f){var g=b.Wn,k=b.Li;if(g||k){d||(d=a.J.Ba());if(g)for(var l=0;l<g.Ie[J];l++)a.J.ta(g.Ie[l][LB],g.Ie[l].brush,d);k&&a.J.ta(k[LB],k.brush,d)}d&&a.J[q](d,f)}f=d?d.a():f;null!=f&&a.Ce(a.Af[nC].Ue,e,f);TOa(a,b,c)}}}
function NOa(a,b,c){for(var d=0,e=b.g[J];d<e;d+=2){var f=b.g[d],g=b.g[d+1],k=f.l[J];if(0!=k)for(var l=new lo({stroke:f.Fg.fb(),strokeOpacity:f.Fg.Oe,strokeWidth:1}),n=0;n<k;n++){var p=f.l[n],t=g.l[n];p&&p.V&&!p.df&&a.J.DF(p.V.x,p.V.y,t.V.x,t.V.y,l,c)}}}function TOa(a,b,c){for(var d=0;d<b.l[J];d++)WOa(a,b,c,b.l[d],d,a.Af.point.Ue)}R.pI=function(a,b,c,d){WOa(this,a,b,c,d,this.Af.bubble.Ue)};
function YOa(a,b,c,d){var e=null,f=b.Li,g=b.Wn,k=b.E8;if(f||g||k)e=a.J.Ba();k&&a.J.ta(k[LB],k.brush,e);(k=b[Dz])&&k[H]||(k={type:NJ});f&&mX(a,f.x,f.y,f[HB]+.5,f.brush,k,e);if(g)for(f=0;f<g.Ie[J];f++)mX(a,g.x,g.y,g.Ie[f][HB],g.Ie[f].brush,k,e);b=mX(a,b.V.x,b.V.y,c,d,k);e&&a.J[q](e,b);return e?e.a():b}
function WOa(a,b,c,d,e,f){var g;if(g=d&&d.V&&!d.df)t:{var k=d.V;g=rX(d,b);var l=a.Gb.t;if(k.x-g>=l[kd]||k.x+g<=l[G]||k.y-g>=l[Uc]||k.y+g<=l.top)g=!1;else{if((k.x>=l[kd]||k.x<=l[G])&&(k.y>=l[Uc]||k.y<=l.top)){g*=g;var n=k.x-l[kd],p=k.x-l[G],t=k.y-l[Uc],k=k.y-l.top,l=n*n,p=p*p,t=t*t,k=k*k;if(l+t>=g&&l+k>=g&&p+k>=g&&p+t>=g){g=!1;break t}}g=!0}}g&&(g=RS([b[H]==nK?oK:uF,c,e]),qX(d,b)?a.Ce(f,g,YOa(a,d,zOa(d,b),oX(d,b))):wOa(a,g),d.rb&&(f=RS([wu,c,e]),tX(a,d.rb,f)),d.Uc&&uX(a,d.Uc,c,e),d.V.zr&&XOa(a,b,c,
e,d.V.zr))}function ROa(a,b,c,d){if(c&&c.V){var e=a.J.nl(c.V[nC][G],c.V[nC].top,c.V[nC][r],c.V[nC][z],c.Hc),f=a.J.nl(c.V[eC][G],c.V[eC].top,c.V[eC][r],c.V[eC][z],c.rA),g=a.J.Ba();a.J[q](g,e);a.J[q](g,f);if(e=c.Wn)for(f=0;f<e.Ie[J];f++){var k=e.Ie[f][eC];a.J.eb(k[G],k.top,k[r],k[z],e.Ie[f].brush,g)}(e=c.Li)&&a.J.eb(e[eC][G],e[eC].top,e[eC][r],e[eC][z],e.brush,g);e=RS([jK,b,d]);a.Ce(a.Af.candlestick.Ue,e,g.a());c.rb&&(b=RS([wu,b,d]),tX(a,c.rb,b))}}
function uX(a,b,c,d){if(b){var e=b.J6,f=a.Gb.t;if(!(!e||e.x<f[G]||e.x>f[kd])&&(f=b[cC])&&!Ej(f)){var g=[XK,d];null!=c&&Gj(g,c,1);var g=RS(g),k=e.x,l=e.y,n=e[J],p=e[F],e=e[QB]==th?[n,1]:[1,n],e=a.J.nl(h.min(k,k+e[0]),h.min(l,l+e[1]),h.abs(e[0]),h.abs(e[1]),new lo({fill:p}));a.Ce(a.Af.annotation.Ue,g,e);e=a.J.Ba();g=[VK,d];null!=c&&Gj(g,c,1);k=null;b.bundle&&!b.bundle.OV&&(f=[b.bundle[dd]],k=-1);b=a.J.vG();for(l=0;l<f[J];l++)if(n=f[l],p=vOa(a,n,!0)){if(n.la){var t=RS([wu,c,d,l]);tX(a,n.la,t)}a.J[q](e,
p);n=Lj(g);n[B](k||l);n=RS(n);a[eA](p,n)}a.J.nB(b);c=RS(g);a.Ce(a.Af.annotationtext.Ue,c,e.a())}}}
function XOa(a,b,c,d,e){if(null!=b.wf){var f=a.J.Ba();b=b.wf.$F;for(var g=0;g<e[J];g++){var k=e[g][eC],l=b[e[g].yr];if(l&&l[w]!=Hg&&l[w]!=OG){var n=l.brush;if(0==k[r]&&0==k[z])l=l.$M/2,0<l&&(k=a.J.kx(k[G],k.top,l,n),a.J[q](f,k));else if(0==k[r]||0==k[z])l=new bO,l[yB](k[G],k.top),l.ha(k[G]+k[r],k.top+k[z]),a.J.ta(l,n,f);else a.J[q](f,a.J.nl(k[G],k.top,k[r],k[z],n))}}f.n&&(c=RS([kH,c,d]),f=f.a(),a.Ce(a.Af[Mb].Ue,c,f))}}
function KOa(a,b,c){var d=U(function(a,d){var e=h[Eb](a.Z),l=null!=a[J]?a[J]:b.t[z],n=c.Gj.Z,n=h.min(n,n+c.Gj[Cz]*l);return this.J.eb(e,n,1,l,a.brush,d)},a),e=U(function(a,d){var e=h[Eb](a.Z),l=null!=a[J]?a[J]:b.t[Uc],n=c.Gj.Z,n=h.min(n,n-c.Gj[Cz]*l);return this.J.eb(e,n,1,l,a.brush,d)},a);ZOa(a,c,d,e)}
function LOa(a,b,c){var d=U(function(a,d){var e=h[Eb](a.Z),l=null!=a[J]?a[J]:b.t[r],n=c.Gj.Z,n=h.min(n,n+c.Gj[Cz]*l);return this.J.eb(n,e,l,1,a.brush,d)},a),e=U(function(a,d){var e=h[Eb](a.Z),l=null!=a[J]?a[J]:b.t[G],n=c.Gj.Z,n=h.min(n,n-c.Gj[Cz]*l);return this.J.eb(n,e,l,1,a.brush,d)},a);ZOa(a,c,d,e)}
function ZOa(a,b,c,d){var e=U(function(a,c,d){if(a){var e=this.Af[c].Ue,n=RS([b[Nd],c]);X(a,function(a,f){var u=RS([b[Nd],c,f]);$Oa(this,a,d,e,u,n)},this)}},a);e(b.Ia,Xta,c);e(b.Lh,uya,d);d=a.Af.baseline.Ue;e=RS([b[Nd],IK]);$Oa(a,b.Cb,c,d,e)}function $Oa(a,b,c,d,e,f){var g;if(g=b&&b.W)g=b.brush,g=!(!po(g)&&!oo(g));g&&(b=c(b,d),a[eA](b,e,f))}
function OOa(a,b){var c=a.Af,d=a.Xt(b[bC],c.axistitle.Ue),e=RS([b[Nd],qD]);a[eA](d,e);if(b[pd]){var f=c.axistick.Ue,g=RS([b[Nd],cH]);X(b[pd],function(a,c){if(a.W){var d=this.Xt(a.za,f),e=RS([b[Nd],cH,c]);this[eA](d,e,g)}},a)}}R.l6=function(a,b){this.RM(a);this.j3(a,b)};
R.RM=function(a){var b=this.mr;if(b){for(var c in b.g){var d=a.g[c];if(qV(b.g[c],fk({l:null}))){var e=b.g[c].l,f;for(f in e){var g=e[f];if(g.rb){var k=RS([wu,ha(c),ha(f)]);nX(this,k)}if(g=g.Uc)for(var l in g[cC])g[cC][l].la&&(k=RS([wu,ha(c),ha(f),ha(l)]),nX(this,k));VOa(this,d,ha(c),d.l[f],ha(f))}}else{for(f in b.g[c].l)b.g[c].l[f].rb&&(k=RS([wu,ha(c),ha(f)]),nX(this,k));MOa(this,d,ha(c))}}for(var n in b.Ga)if(c=b.Ga[n],c.rb&&(k=RS([wu,ha(n)]),nX(this,k)),g=c.Uc){for(l in g[cC])g[cC][l].la&&(k=RS([wu,
null,ha(n),ha(l)]),nX(this,k));uX(this,a.Ga[n].Uc,null,ha(n))}IOa(this)}};R.j3=function(a,b){for(var c in b.g){var d=a.g[c];if(qV(b.g[c],fk({l:null})))for(var e in b.g[c].l){var f=new DT(2);ET(f,0,d.l[e]);ET(f,1,b.g[c].l[e]);f=f[iB]();VOa(this,d,ha(c),f,ha(e))}else f=new DT(2),ET(f,0,d),ET(f,1,b.g[c]),d=f[iB](),MOa(this,d,ha(c))}for(var g in b.Ga)b.Ga[g].rb&&(c=RS([wu,ha(g)]),tX(this,b.Ga[g].rb,c)),b.Ga[g].Uc&&(c=new DT(2),ET(c,0,a.Ga[g].Uc),ET(c,1,b.Ga[g].Uc),c=c[iB](),uX(this,c,null,ha(g)));IOa(this)};function aPa(a){this.x=a.x||0;this.y=a.y||0;this.pf=new fV(this.x,this.y);mb(this,a[J]);Oy(this,a[pd])};function bPa(a){Oy(this,a[pd]);this.ba=a.ba;this.I=a.I;this.Gc=a.Gc;this.Fc=a.Fc;this.rb=void 0!==a.rb?a.rb:M;this.de=a.de;this.Eb=null!=a.Eb?a.Eb:0;sz(this,void 0!==a[lC]?a[lC]:null);this.ys=!!a.ys}bPa[K].Vaa=function(){var a=this,b=wj(this.I,function(b){var d=a[lC]?a[lC]:{x:0,y:0},e=fO(b.x+d.x,b[J],a.Gc);b=fO(b.y+d.y,a.ba[Gc],a.Fc);return e[y]==e.end||b[y]==b.end?null:new um(b[y],e.end,b.end,e[y])}),b=vj(b,Ni);return io(b)};function vX(a,b,c,d){this.ah=a;this.b=b;this.il=d;this.Sd=c;this.Ma=np(this.b,$xa,{$a:d.kk,fontSize:d.wm,lc:d.qw});this.wha=Lo(this.b,cya,!1);this.pe=Zo(this.b,aya,cN);this.vp=Uo(this.b,bya,.8);this.ela=[[255,255,255],[97,97,97]];this.PV=0;this.sF=1;this.tF=2;this.jr=3;this.kr=4;this.op=this.h6=this.g6=this.j6=this.i6=M;this.TV=this.b.Q(mJ,VW);this.eO=JV(this.TV[0])[F];this.qF=this.hr=this.UV=this.RV=this.fA=this.eA=null;this.yj()}
vX[K].yj=function(){function a(a,b,d){if(c.L()<=a)return M;var e=c.G(a);if(b&&!Dj(d,e))throw m(Lf+a+" must be of type "+d[Fe](Gs));if(!b&&Dj(d,e))throw m(Lf+a+" cannot be of type "+d[Fe](Gs));return e}var b=this.il,c=this.ah,d=c.L();if(3>d)throw m("Data table should have at least 3 columns");a(this.PV,!0,[ii]);var e=a(this.sF,!1,[ii]),f=a(this.tF,!1,[ii]);this.i6=c.La(this.sF);this.j6=c.La(this.tF);Ui(this.jr)&&this.jr<d?(this.op=a(this.jr,!0,[Nh,ii]),this.op==ii&&(this.eA={},this.fA=[]),this.g6=
c.La(this.jr)):this.jr=null;var g=!1;Ui(this.kr)&&this.kr<d?(a(this.kr,!0,[Nh]),this.h6=c.La(this.kr),g=Lo(this.b,foa,!0)):this.kr=null;b.Ga=[];b.lr={};for(d=0;d<c.O();d++){var k=c.ym(d);b.lr[k]=d}b.g=[{type:nK,Zg:Lo(this.b,[Uoa,AI],!0),wM:!0,xM:!0,eia:g,l:[],hya:this.eA,iya:this.fA}];b.Vt=e;b.WF=[f];b.Pf={};b.Pf.bubbles=1;b.Tn=[]};function cPa(a,b,c){for(var d=a.ah,e=0;e<d.O();e++){var f=d[I](e,a.sF),g=d[I](e,a.tF),f=KW(b.ga,f),g=KW(c.ga,g);null!=f&&wX(b,f);null!=g&&wX(c,g)}}
vX[K].zha=function(a){var b=xn(dPa(this,a.yf)),c=mk(a.ba),b=vn(En(b,this.ela));Ya(c,b);a.ba=c};vX[K].XV=function(a,b){var c=this.ah,d=c.Ca(a,this.sF),e=c.Ca(a,this.tF),d=[{title:this.i6,value:d},{title:this.j6,value:e}];null!=this.jr&&(e=c.Ca(a,this.jr),d[B]({title:this.g6,value:e}));null!=this.kr&&(c=c.Ca(a,this.kr),d[B]({title:this.h6,value:c}));return{title:b,I:d}};function dPa(a,b){return a.op==Nh?cV(a.hr,b[F]):a.op==ii?a.eA[b[F]][F]:a.eO};function ePa(a,b,c){this.il=a;this.ya=c?ep(b,Swa,iNa,c):O;this.Ma=np(b,Rwa,{$a:a.kk,fontSize:a.wm,lc:this.ya==pH?a.qw:O});this.YW=Xo(b,Twa);this.le=this.ec=null}R=ePa[K];Dy(R,function(){return this.ya});cb(R,function(){return 1.5*this.Ma[Gc]});R.getArea=function(){return this.ec};R.lp=function(a){this.ec=a};R.e6=function(a){this.le=a};
R.Vw=function(){if(!this.ec||!this.le)return null;var a={top:this.ec.top,left:this.ec[G],width:this.ec[kd]-this.ec[G],height:this.ec[Uc]-this.ec.top,orientation:th,ba:this.Ma,V$:AK,W$:this.YW},b=LV(this.le,a,[],this.il.mc);return null!=b?{position:this.ya,scale:this.le,qI:a,definition:b}:null};function xX(a,b,c){this.Y3=a;this.ra=b;this.KU=a-b/2;this.Yka=c;Iq(this,0)}xX[K].Gu=function(){return this.KU};xX[K].qn=function(a){this.KU=a};xX[K].getCenter=function(){return this.KU+this.ra/2};cb(xX[K],function(){return this.ra});function fPa(a,b){this.dK=a;this.Rz=b;for(var c=0,d=b[J];c<d;c++)Iq(b[c],c)}function gPa(a){for(var b=0,c=0,d=a.Rz[J];c<d;c++)b+=a.Rz[c][JB]();if(b>a.dK)throw m("Not enough space for labels. Need: "+b+" got: "+a.dK);a.Rz[ue](function(a,b){var c=a.Y3,d=b.Y3;return c==d?a[xc]>b[xc]?1:0:c>d?1:-1});c=0;for(d=a.Rz[J];c<d;c++){var b=a.Rz[c],e=hPa(a,b.Gu(),b[JB]());b.qn(e)}c=[];b=0;for(d=a.Rz[J];b<d;b++)c[B]([a.Rz[b]]);for(;iPa(a,c););}
function iPa(a,b){for(var c=0;c<b[J]-1;c++){var d=b[c],e=b[c+1],f=d[d[J]-1];if(f.KU+f.ra>e[0].Gu()){for(var f=a,g=e,e=0;e<g[J];e++)d[B](g[e]);for(var k=0,e=g=0;e<d[J];e++)k+=d[e].Y3,g+=d[e][JB]();k=k/d[J]-g/2;k=hPa(f,k,g);for(e=0;e<d[J];e++)f=d[e],f.qn(k),k+=f[JB]();b[Ee](c+1,1);return!0}}return!1}function hPa(a,b,c){return Lk(b,0,a.dK-c)};function yX(a,b,c,d){this.il=a;this.ya=c?ep(b,VG,hNa,c):O;this.PO=ep(b,WG,kNa,this.ya==uK?dK:TD);c=th;if(this.ya==Ch||this.ya==au||this.ya==aH||this.ya==sK)c=ui;this.kb=c;this.Ma=np(b,UG,{$a:a.kk,fontSize:a.wm,lc:this.ya==pH?a.qw:O});this.Yr=!1;this.X8=np(b,Lsa,this.Ma);this.Sd=a.mc;this.JH=this.Ma[Gc];d=d?Lk(d,1,2):1;this.Lk=this.JH*d;this.Ju=h[D](this.Ma[Gc]/(1.618*1.618));this.qG=this.ec=null;this.fZ=Lo(b,Hsa,!0);this.Lka=ep(b,Isa,jNa,this.kb);this.Jka=hp(b,Ksa);this.Kka=hp(b,Jsa);this.eg=null;
this.yP=this.Ju;this.Nx=this.Ox=this.eZ=0;this.m7=this.ya==kD?So(b,Psa,1):1;this.rG=0}Dy(yX[K],function(){return this.ya});yX[K].getArea=function(){return this.ec};yX[K].lp=function(a){this.ec=a};function jPa(a){a.qG=vj(a.il.Tn,function(a){return a.W})}
yX[K].Vw=function(){if(!this.ec)return null;if(this.ya!=O)if(this.kb==ui)kPa(this);else{for(var a=[1,9,99,0],b=0;b<a[J];++b){var c;t:{c=a[b];var d=this.ec[kd]-this.ec[G],e=!1;1!=c&&(d-=2*(this.Lk+this.Ju),e=!0,0!=c&&(d-=lPa(this,c)+this.Ju));var f=zX(this,this.qG,d);if(0==f[J])this.Yr=!1;else{this.eg=[];for(var g=this.qG;0<g[J];){if(0<c&&this.eg[J]==c){c=!1;break t}for(var k=[mPa(this,f,g,e)],l=1;l<this.rG&&g[J]!=f[J];l++)g=Nj(g,f[J]),f=zX(this,g,d),k[B](mPa(this,f,g,e));k=nPa(this,k);this.eg[B](k);
g=Nj(g,f[J]);f=zX(this,g,d)}this.Yr=1<this.eg[J]}c=!0}if(c)break}this.Yr&&(this.eZ=h[D]((this.ec.top+this.ec[Uc]-this.Lk)/2),this.Nx=this.ec[kd]-this.Lk,this.Ox=this.Nx-this.yP-this.Lk,this.fZ&&(a=lPa(this,this.eg[J]),this.Ox-=a+this.yP))}a=this.eg&&0<this.eg[J]?this.eg[0]:null;if(this.Yr){b=1<this.eg[J];c=this.eZ;d=null;this.fZ&&(d=fDa+this.eg[J],e=this.Ox+this.Lk,f=this.Nx-e,d={text:d,ba:this.X8,gr:null,I:[{x:e+f/2,y:c,text:d,length:f}],Gc:dK,Fc:TD,rb:M,anchor:null,Eb:0});var g=this.Lka==ui,k=this.Lk,
l=h[D](k/2),n=this.Ox,p=this.Nx,f=e=null;g?(e=[{x:n+k,y:c+k},{x:n+l,y:c},{x:n,y:c+k}],f=[{x:p,y:c},{x:p+k,y:c},{x:p+l,y:c+k}]):(e=[{x:n+k,y:c+k},{x:n+k,y:c},{x:n,y:c+l}],f=[{x:p,y:c},{x:p+k,y:c+l},{x:p,y:c+k}]);c={Zu:this.Jka,lQ:this.Kka};b={g_:{path:e,Zu:!1,ne:c,brush:c.lQ},e_:{path:f,Zu:b,ne:c,brush:b?c.Zu:c.lQ},f_:d}}else b=null;return{position:this.ya,area:this.ec,eg:this.eg,gu:a,rI:b}};
function kPa(a){var b=h.max(a.ec[kd]-a.ec[G]-(a.Lk+a.Ju),0),c=a.ec[Uc]-a.ec.top,d=h.max(c-2*a.JH,0),e=a.qG,f=a.il;AOa(f)&&e[gr]();var g=wj(e,function(a){a=fT(this.Sd,a[pd],this.Ma,b,da);0==a.I[J]&&(a.I=[M]);return a},a);if(a.ya!=aH||f.eW!=OG&&f.eW!=Hg)if(c=oPa(a,g,c),a.Yr=pPa(e,c),a.Yr)if(c=oPa(a,g,d),Gi(c[0])&&0!=c[0][J]){for(a.eg=[];0<e[J];){f=qPa(a,c,e);a.eg[B](f);for(f=0;Gi(c[f])&&0!=c[f][J];)++f;g=Nj(g,f);c=oPa(a,g,d);e=Nj(e,f)}a.Yr&&(a.eZ=h[D](a.ec[Uc]-a.JH),a.Ox=a.ec[G],a.Nx=a.Ox+a.Lk+a.yP,
a.fZ&&(d=lPa(a,a.eg[J]),a.Nx+=d+a.yP))}else a.Yr=!1;else f=qPa(a,c,e),a.eg=[f];else f=rPa(a,g,c,e),a.eg=[f]}function oPa(a,b,c){var d=a.Ma[Gc],e=h[D](d/1.618),f=h[D](d/3.236);a=sPa(a,b,d+e,d+f);return lV(a,c)}function tPa(a,b){var c=dk(a.il.rd),d=a.il.g[b],e=wj(d.l,function(a){return!a||a.df?null:new xl(a.V.x,a.V.y)}),d=rV(e,c.cf,d.xj);return null===d?uPa(e,c.cf):d}
function uPa(a,b){a=vj(a,Ni);var c=-(Oj(a,b,function(a,b){return Pj(a,b.x)})+1),c=Nj(a,0,c);return(c=Cj(c,function(a){return null!==a.y}))?c.y:null}
function rPa(a,b,c,d){for(var e=a.ec[kd]-a.ec[G],f=h[D](a.ec[G]),g=[],k=[],l=a.il.bA==II,n=0;n<d[J];n++){var p=d[n],t=fT(a.Sd,p[pd],a.Ma,e,b[n].I[J]),u={};u.id=p.id;u.brush=p.brush[Jc]();var x=mk(a.Ma);Ya(x,u.brush.fb());u.za={text:p[pd],ba:x,gr:null,I:[],Gc:TD,Fc:TD,rb:t.re?p[pd]:M,anchor:null,Eb:0};x.lc&&u.brush.ld(x.lc,1);u.W=!0;for(var A=0;A<t.I[J];A++)u.za.I[B]({length:e,text:t.I[A]});l&&(A=a.Sd(u.za.I[0][pd],x)[r],u.Ig={},Hy(u.Ig,{x:f+A+5}),u.Ig.brush=u.brush,u.Ig.W=!1);Iq(u,p[xc]);A=tPa(a,
u[xc])||0;x=a.Sd(u.za.I[0],x)[z];p=new xX(A,u.za.I[J]*x,u);g[B](p);k[B](u)}gPa(new fPa(c,g));for(A=0;A<g[J];A++)for(p=g[A],a=p.Gu(),u=p.Yka,b=u.za.I,n=0;n<b[J];n++)b[n].y=h[D](n*x+a),b[n].x=f,l&&(u.Ig[$A].y=b[n].y);return k}
function qPa(a,b,c){for(var d=a.Lk+a.Ju,e=a.ec[kd]-a.ec[G]-d,f=a.Ma[Gc],g=h[D](f/1.618),k=h[D](f/3.236),l=f+g,n=f+k,f=[],k=0,p=h[D](a.ec[G]),t=0;t<c[J];t++){var u=c[t],x=b[t][J];if(0!=x){var A=fT(a.Sd,u[pd],a.Ma,e,x),x={};x.id=u.id;x.za={text:u[pd],ba:a.Ma,gr:null,I:[],anchor:new fV(p,0),Gc:TD,Fc:TD,rb:A.re?u[pd]:M,Eb:0};x.gc={};Hy(x.gc,new xm(p,k,a.Lk,a.JH));x.gc.brush=u.brush[Jc]();a.Ma.lc&&x.gc.brush.ld(a.Ma.lc,1);x.W=!0;for(var C=0;C<A.I[J];C++)0<C&&(k+=n),x.za.I[B]({x:d,y:k,length:e,text:A.I[C]});
Iq(x,u[xc]);k+=l;f[B](x)}}b=h[D](a.ec.top);a.Yr||(g=k-g,c=a.ec[Uc]-a.ec.top,a.PO==zI?b+=c-g:a.PO==dK&&(b+=h[Eb]((c-g)/2)));for(t=0;t<f[J];t++)x=f[t],x.gc[$A].top+=b,x.za[lC].y+=b;return f}function sPa(a,b,c,d){for(var e=xj(b,function(a,b){return h.max(a,b.I[J])},0),f=[],g=0;g<e;g++){var k=0==g?c:d;X(b,function(a,b){g<a.I[J]&&f[B]({key:b,min:0==g&&0==b?this.Ma[Gc]:k,Ub:[]})},a)}return f}function pPa(a,b){var c=a[J]-1;return 1<a[J]&&1>b[c][J]}
function nPa(a,b){var c=a.ec[Uc]-a.ec.top,d=a.Ma[Gc],e=c-a.rG*d,f=1<a.rG?e/(a.rG-1):0,g=(c-((d+f)*b[J]-f))/2,k=[];X(b,function(a){var b=h[D](g);X(a,function(a){a.za[lC].y+=b;a.gc[$A].top+=b});g+=d+f;Mj(k,a)});return k}function zX(a,b,c){var d=a.Lk+a.Ju,e=h.min(a.il[r]*(2-1.618)/2,c);if(e<d)return[];a=vPa(a,e,b);return kV(a,c)}
function mPa(a,b,c,d){for(var e=a.ec[kd]-a.ec[G],f=a.Lk+a.Ju,g=h[D](1.618*a.Ma[Gc]),k=[],l=0,n=h[D](a.ec.top),p=0;p<b[J];p++){var t=c[p],u=fT(a.Sd,t[pd],a.Ma,b[p]-f-(0<p?g:0),1),x=0<u.I[J]?u.I[0]:M,A=a.Sd(x,a.Ma)[r],C=[{x:l+f,y:0,length:A,text:x}],E={};E.id=t.id;E.za={text:t[pd],ba:a.Ma,gr:null,I:x?C:[],anchor:new fV(0,n),Gc:TD,Fc:TD,rb:u.re?t[pd]:M,Eb:0};E.W=!0;E.gc={};E.gc.brush=t.brush[Jc]();a.Ma.lc&&E.gc.brush.ld(a.Ma.lc,1);Hy(E.gc,new xm(l,n,a.Lk,a.JH));Iq(E,t[xc]);k[B](E);l+=A+f+g}b=a.ec[G];
d||(d=l-g,a.PO==zI?b+=e-d:a.PO==dK&&(b+=h[Eb]((e-d)/2)));for(p=0;p<k[J];p++)E=k[p],$a(E.gc[$A],E.gc[$A][G]+b),E.za[lC].x+=b;return k}function vPa(a,b,c){var d=a.Lk+a.Ju,e=h[D](1.618*a.Ma[Gc]);return wj(c,function(a,c){var k=this.Sd(a[pd],this.Ma)[r]+d,l=h.min(b,k),k=k-l;0<c&&(l+=e);return{min:l,Ub:[k]}},a)}function lPa(a,b){for(var c=pf;10<=b;)c+=pf,b/=10;return a.Sd(c+Gs+c,a.X8)[r]};function AX(a,b,c,d,e){this.ll=a;this.Sb=null;Mq(this,b);this.mc=c;this.Aj=this.xf=null;a=this.R=this.J8();a.mc=c;na(a,d);Ta(a,e);a.ab=ep(b,qi,bNa,O);a.kk=Wo(b,aI);a.wm=So(b,$H,h[D](h.pow(2*(a[r]+a[z]),1/3)));a.eW=ep(b,Toa,cNa,OG);a.Zg=Lo(b,AI,!0);a.Fr=Lo(b,zna);a.jA=ep(b,JE,nga,ei);a.WV=Lo(b,Osa);a.pF=hp(b,LK);a.Z5=hp(b,ZJ);c=a.Z5;d=a.pF;c=qo(c)?c.fb():qo(d)?po(c)?go(c.fb(),d.fb(),c.Oe):d.fb():null;a.yM=c;a.Fha=Zo(b,HK,M);a.Y5=Zo(b,NH,M);a.qw=a.yM||M;c=Wo(b,qD);a.gA=ep(b,Ena,lNa,JF);d=np(b,oD,{$a:a.kk,
fontSize:a.wm,lc:a.gA==pH?a.qw:O});Xq(a,{text:c,ba:d,gr:null,I:[],Gc:TD,Fc:zI,rb:M,anchor:null,Eb:0});a.uF=ep(b,vya,lNa,JF);a.Rc=Lo(b,jH);a.eu=Lo(b,$sa,!1);a.X5=Lo(b,Foa,!0);a.xj=Lo(b,lH);a.bA=ep(b,dta,qNa,PI);this.I8()}R=AX[K];R.J8=function(){return new mOa};R.jp=function(){return this.R};
La(R,function(a,b){var c=da;if(null!=b){var d=this[Nr].Q(PK,null);c=Ui(d)?d:(d=Lo(this[Nr],PK,!1))?100:da}var e=this.HI(),f=a(U(function(){for(var a=Zi(),d=0;0<e[J]&&d<=c;)(d=e[wb]()())&&(e=Kj(d,e)),d=Zi()-a;if(0===e[J]){if(this.R.bA==II&&(!this.R.Pf||this.R.Pf[nC]!=this.R.g[J]))throw m("DIVE interactivity model is only supported when all series are of type line.");b&&b(this)}else Xx(f,0)},this));f()});
R.HI=function(){var a;return[U(function(){a=this.jp()},this),U(this.Ska,this),U(function(){var b=this.f9(),c=this.e9(),d=null,e=a.ab;!a.kd||e!==BF&&e!==OE?a.WV&&e!==BF&&e!==oK&&(d=2):d=2;this.xf=new yX(a,this[Nr],b,d);this.Aj=new ePa(a,this[Nr],c)},this),U(this.d9,this),U(function(){jPa(this.xf);var b=this.R,c=b[bC].ba[Gc],d=this.xf.Ma[Gc],e=this.xf[UA](),f=this.Aj.Ma[Gc],g=this.Aj[UA](),k=b.gA==JF?b[bC][pd]:M,l=fT(this.mc,k,b[bC].ba,b.t[r],da),n=h.max(2,h[D](c/3.236)),p=h.max(2,h[D](d/1.618)),f=
h.max(2,h[D](f/1.618)),t=h.max(2,h[D](1.618*b.wm)),u=[];u[B]({key:tK,min:2,Ub:[t-2]});u[B]({key:jD,min:0,Ub:[da]});0<l.I[J]&&u[B]({key:qD,min:c+2,Ub:[]});if(e==kD){for(var e=this.xf,t=b.t[r],x=e.qG,A=zX(e,x,t),C=1;(0==e.m7||e.m7>C)&&A[J]<x[J];)++C,x=Nj(x,A[J]),A=zX(e,x,t);t=C;for(e=0;e<t;++e)u[B]({key:XG,min:d+2,Ub:[p-2]})}g==kD&&u[B]({key:nJ,min:this.Aj[JB]()+2,Ub:[f-2]});for(e=1;e<l.I[J];e++)u[B]({key:qD,min:c+2,Ub:[n-2]});g=lV(u,b.t.top);c=g[jD][0]||0;l=g[bC]||[];n=fT(this.mc,k,b[bC].ba,b.t[r],
l[J]);for(e=0;e<n.I[J];e++)c+=l[e],b[bC].I[B]({text:n.I[e],x:b.t[G],y:c,length:b.t[r]});b[bC].rb=n.re?k:M;k=g.legend||[];0<k[J]&&(this.xf.rG=k[J],d=c+k[0]-d,c+=Tk[Zc](null,k),this.xf.lp(new um(d,b.t[kd],c,b.t[G])));d=g.colorBar||[];0<d[J]&&(c+=d[0],b=new um(c-this.Aj[JB](),b.t[kd],c,b.t[G]),this.Aj.lp(b));a.Ea=this.xf.Vw();a.Gi=this.Aj.Vw()},this)]};
R.I8=function(){var a=this.ll,b=new hw(a);if(2>b.L())throw m("Not enough columns given to draw the requested chart.");if(Lo(this[Nr],aF)){for(var c=[],a=a.O()-1;0<=a;a--)c[B](a);b.bn(c)}this.Sb=b};function wPa(a,b,c,d){null!=b||(b=d());b=h[D](b);null!=a||(a=(c-b)/2);a=h[D](a);b=h.min(a+b,c);return{start:a,end:b}}
R.Ska=function(){var a=this.R,b=op(this[Nr],VJ,a[r]),c=op(this[Nr],YJ,a[z]),d=op(this[Nr],WJ,a[z]),e=op(this[Nr],XJ,a[r]),f=U(function(){var b=a[r]/1.618,c=a[r]-a[z]*(1.618-1);return h[D](b>c?b:(b+2*c)/3)},this),e=wPa(e,b,a[r],f),b=h.min(e[y],e.end),e=e.end,f=e-b,g=U(function(){var b=a[z]/1.618,c=a[z]-a[r]*(1.618-1);return h[D](b>c?b:(b+2*c)/3)},this),d=wPa(d,c,a[z],g),c=h.min(d[y],d.end),d=d.end;a.t={left:b,right:e,width:f,top:c,bottom:d,height:d-c}};function BX(a,b,c,d){return new xPa(a,b,c,d)}function xPa(a,b,c,d){this.ZP=b;this.gd=new Yp({pattern:a});this.jua=c;this.iua=d}ta(xPa[K],function(a){a/=this.ZP;return this.gd.Sc(a)+(Ke+(2>h.abs(a)?this.jua:this.iua))});function CX(){this.nfa=new Date;this.ml(Yf)}CX[K].ml=function(a){switch(a){case yg:a=Sp.YEAR_FULL;break;case fg:a=aba;break;case $f:a=Sp.YEAR_MONTH_ABBR;break;case Nf:a=Ep[Ld].SHORT_DATE;break;default:a=Ep[Ld].SHORT_DATETIME}this.gd=new Wp({pattern:a,timeZone:0})};ta(CX[K],function(a){this.nfa[Wc](a);return this.gd.Sc(this.nfa)});function DX(){this.Z4=null;this.eF=[];this.tY=this.Kz=this.ZL=null}function yPa(a,b){a.Z4=b;return a}function zPa(a,b){a.ZL=b;return a}DX[K].yp=function(a){this.Kz=a;return this};
function APa(a,b){var c;c=nV(Ui(b)?b:3);c=[BX(c,h.pow(10,15),RAa,RAa),BX(c,h.pow(10,12),rAa,rAa),BX(c,h.pow(10,9),XBa,XBa),BX(c,h.pow(10,6),eBa,eBa)];a.eF=c;return a}function BPa(a){var b;b=nV(Ui(5)?5:3);b=[BX(b,h.pow(10,15),eg,eg),BX(b,h.pow(10,12),mg,mg),BX(b,h.pow(10,9),ZBa,ZBa),BX(b,h.pow(10,6),Xf,Xf)];a.eF=b;return a}DX[K].$g=function(){var a;a=this.tY?new Yp(this.tY):new Yp({pattern:nV(Ui(this.Z4)?this.Z4:16)});return new CPa(a,this.eF,this.ZL,this.Kz)};
function CPa(a,b,c,d){this.uua=a;this.eF=b||[];this.ZL=c||null;this.Kz=d||null}ta(CPa[K],function(a){var b=0>a;a=h.abs(a);if(this.ZL){var c=this.ZL;if(0!=a){var d=h[Eb](h.log(h.abs(a))/EIa)+1;d>c?(c=h.pow(10,d-c),a=h[D](a/c)*c):(c=h.pow(10,c-d),a=h[D](a*c)/c)}}c=null;for(d=0;d<this.eF[J];d++){var e=this.eF[d];if(a>=e.ZP){c=e[Rb](a);break}}null==c&&(c=this.uua.Sc(a));this.Kz&&(a=this.Kz.symbol,d=this.Kz.usePadding?Ke:M,c=this.Kz[tc]==au?c+d+a:a+d+c);return b?lf+c:c});function EX(a,b,c,d,e,f){this.vd=a;this.ya=b;this.Qx=c;this.Uu=d;this.Hb=f}function DPa(a,b,c){return new EX(a,b,!0,!0,0,c)}function FX(a,b,c){return new EX(a,b,!1,!1,0,c)}Dy(EX[K],function(){return h[D](this.ya)});hb(EX[K],function(){return this.vd});EX[K].ad=function(){return this.Hb};EX[K].Em=function(a){this.Hb=a};function GX(a,b){this.WL=a;this.VL=b||0;var c;c=this.WL+this.VL;if(1<=c)c=1;else{var d=c[qc]();c=0;var e=d[zd](DI);-1!=e?c=ja(d[mc](e+1),10):e=d[J];d=d[zd](mf);-1!=d&&(c-=e-1-d);c=h.pow(10,-c)}this.lfa=c;this.ya=0}R=GX[K];Da(R,function(){this.ya++;return this[I]()});R.Tg=function(){this.ya--;return this[I]()};hb(R,function(){return h[D]((this.ya*this.WL+this.VL)*this.lfa)/this.lfa});ra(R,function(a){this.ya=h[Eb]((a-this.VL)/this.WL);return this[I]()});
qa(R,function(a){this.ya=h[Cb]((a-this.VL)/this.WL);return this[I]()});Wa(R,function(a){this.ya=h[D]((a-this.VL)/this.WL);return this[I]()});function EPa(a,b,c,d){this.ma=a;this.tg=b;this.kb=c;this.gd=d}function FPa(a,b){var c=b[J];if(0<c)for(;--c;)if(GPa(a,b[c-1],b[c]))return!1;return!0}function GPa(a,b,c){var d=HPa(a,b),e=HPa(a,c);return h.abs(a.ma.jb(b)-a.ma.jb(c))<(d+e)/2}function HPa(a,b){var c=a.gd[Rb](b);return a.tg.yv(c,a.kb)}function IPa(a,b,c){b=a.ma.tf(b);a=a.ma.tf(c);return h.abs(a-b)}function HX(a,b){for(var c=[],d=0;d<b[J];d++){var e=b[d];c[B](DPa(e,a.ma.jb(e),a.gd[Rb](e)))}return c}
function JPa(a,b,c,d){if(b==c)return[b];if(!Wk(b))return[c];var e=[];for(b=a[Cb](b);b<=c;)e[B](b),b=a[yc]();1==e[J]&&(b=(new GX(d/10))[Eb](c),b!=e[0]&&e[B](b));return e};function IX(a,b,c,d,e){this.sL=a;this.mU=b;this.lV=c;this.I4=d;this.jF=e;a=KPa(this,a);b=KPa(this,b)-a;this.Nz=(d-c)/b;this.hM=this.Nz*a-c}IX[K].jb=function(a){return KPa(this,a)*this.Nz-this.hM};IX[K].tf=function(a){t:switch(a=(a+this.hM)/this.Nz,this.jF){case 0:a=h.pow(h.E,a);break t;case 1:break t;default:a=h.pow(a*this.jF+1,1/this.jF)}return a};function KPa(a,b){switch(a.jF){case 0:return h.log(b);case 1:return b;default:return(h.pow(b,a.jF)-1)/a.jF}};function LPa(a,b,c,d,e,f){this.qt=a;this.iL=b;this.vB=c;this.uB=d;this.ew=e;this.dea=f;this.qt==this.iL?e=this.qt/2:fa(this.dea)?e=CW(1,EW(this.iL-this.qt))/1E3:(e=this.dea/2,0<this.qt&&(e=h.min(this.qt,e)));this.pm=e;a>=this.pm?(this.hg=new IX(a,b,c,d,this.ew),this.Fi=h[D](this.hg.jb(this.pm))):b<=-this.pm?(this.hg=new IX(-b,-a,d,c,this.ew),this.Fi=h[D](this.hg.jb(this.pm)),f=2*this.Fi-d,e=2*this.Fi-c,this.hg=new IX(-b,-a,f,e,this.ew)):a>=-this.pm?(this.Fi=h[D](c),this.hg=new IX(this.pm,b,this.Fi,
d,this.ew)):b<=this.pm?(this.Fi=h[D](d),e=2*this.Fi-c,this.hg=new IX(this.pm,-a,this.Fi,e,this.ew)):(this.hg=new IX(this.pm,b,0,1,this.ew),e=this.hg.jb(-a),this.Fi=h[D](c+e/(e+1)*(d-c)),b>=-a?this.hg=new IX(this.pm,b,this.Fi,d,this.ew):(e=2*this.Fi-c,this.hg=new IX(this.pm,-a,this.Fi,e,this.ew)));this.ug=d<c}R=LPa[K];R.Yb=function(){return this.qt};R.dc=function(){return this.iL};R.Mo=function(){return this.vB};R.mn=function(){return this.uB};
R.tf=function(a){if(this.qt==this.iL)return this.qt;var b=this.ug?-1:1;return a*b>this.Fi*b?this.hg.tf(a):a*b<this.Fi*b?-this.hg.tf(2*this.Fi-a):0};R.jb=function(a){return this.qt==this.iL?h.abs(this.vB-this.uB)/2:a>this.pm?this.hg.jb(a):a<-this.pm?2*this.Fi-this.hg.jb(-a):this.Fi};function JX(a){this.lua=a[Hb]();this.OL=a[J];this.ya=0}R=JX[K];Da(R,function(){this.ya++;return this[I]()});R.Tg=function(){this.ya--;return this[I]()};hb(R,function(){var a=h[Eb](this.ya/this.OL);return CW(this.lua[this.ya-a*this.OL],a)});ra(R,function(a){this.ya=this.OL*FW(a);if(this[I]()!=a)for(;this.Tg()>a;);return this[I]()});qa(R,function(a){this.ya=this.OL*EW(a);if(this[I]()!=a)for(;this[yc]()<a;);return this[I]()});
Wa(R,function(a){this.ya=this.OL*FW(a);if(this[I]()!=a){for(;this.Tg()>a;);if(a-this[I]()<this[yc]()-a)return this.Tg()}return this[I]()});function MPa(a,b,c,d,e){this.hg=a;this.L3=e;this.Qq=new EPa(a,c,d,b);this.Ts=new JX([1,2,5])}MPa[K].kI=function(){var a=this.J2(),b;this.Ts[Eb](a);do b=new GX(a),b=JPa(b,this.hg.Yb(),this.hg.dc(),a),a=this.Ts[yc]();while(!FPa(this.Qq,b));return HX(this.Qq,b)};MPa[K].J2=function(){var a=this.hg.Mo(),b=this.hg.mn(),c=IPa(this.Qq,b-this.L3,b),d=IPa(this.Qq,a,a+this.L3),c=h.max(d,c),d=this.hg.jb(0);d>=a&&d<=b&&(a=this.hg.tf(this.hg.jb(0)+this.L3),c=h.max(c,a));return this.Ts[Cb](c)};function KX(a,b,c,d){this.sL=a;this.mU=b;this.a5=c;this.nga=d;this.Nz=(this.nga-this.a5)/(this.mU-this.sL);this.hM=this.Nz*this.sL-this.a5}R=KX[K];R.tf=function(a){return(a+this.hM)/this.Nz};R.jb=function(a){return a*this.Nz-this.hM};R.Mo=function(){return this.a5};R.mn=function(){return this.nga};R.Yb=function(){return this.sL};R.dc=function(){return this.mU};function NPa(a,b){this.lU=a;this.rL=h[Eb](a/10);this.vt=a-this.rL;this.kc=0;this.oU=EW(h.abs(b));this.Cz=this.vt*this.oU;this.ya=0}function OPa(a){var b=h[Eb](a.ya/a.vt);a=10*(a.ya+a.rL-b*a.vt)/a.lU;0==a&&(a=1);return CW(a,b)}R=NPa[K];hb(R,function(){this.ya=h.abs(this.kc)+this.Cz;return 0<this.kc?OPa(this):0>this.kc?-OPa(this):0});Da(R,function(){this.kc++;return this[I]()});R.Tg=function(){this.kc--;return this[I]()};
ra(R,function(a){var b=this.rL,c=EW(h.abs(a));if(h.abs(a)<=h.pow(10,this.oU))return this.kc=0>a?-1:0,this[I]();0<a?this.kc=this.vt*c-this.Cz:0>a&&(this.kc=this.Cz-this.vt*c,b=-b);this[I]()!=a&&(c=this.lU*a/CW(1,FW(h.abs(a))),this.kc+=h[Eb](c)-b);return this[I]()});
qa(R,function(a){var b=this.rL,c=EW(h.abs(a));if(h.abs(a)<=h.pow(10,this.oU))return this.kc=0<a?1:0,this[I]();0<a?this.kc=this.vt*c-this.Cz:0>a&&(this.kc=this.Cz-this.vt*c,b=-b);this[I]()!=a&&(c=this.lU*a/CW(1,FW(h.abs(a))),this.kc+=h[Cb](c)-b);return this[I]()});
Wa(R,function(a){var b=EW(h.abs(a));if(h.abs(a)<=h.pow(10,this.oU))return this.kc=0;if(0<a){this.kc=this.vt*b-this.Cz;if(this[yc]()>a)return a-this[I]()>=this.Tg()-a?this[yc]():this[I]();this.Tg()}else if(0>a){this.kc=this.Cz-this.vt*b;if(this.Tg()<a)return a-this[I]()<this[yc]()-a?this.Tg():this[I]();this[yc]()}this[I]()!=a&&(b=this.lU*a/CW(1,FW(h.abs(a))),this.kc+=h[D](b)-this.rL);return this[I]()});function PPa(a,b,c,d,e,f){this.ma=a;this.gd=b;this.tg=c;this.kb=d;this.bk=f;this.Ppa=e;this.Qq=new EPa(a,c,d,b);this.Ts=new JX([1,2,5])}
PPa[K].kI=function(){var a=this.bk/10,b=this.J2(),c=new NPa(b,a),c=JPa(c,this.ma.Yb(),this.ma.dc(),b);if(2>c[J])return HX(this.Qq,c);var b=c[0],d=c[1];if(0==b){if(3>c[J])return HX(this.Qq,c);b=d;d=c[2]}c=CW(1,FW(h.abs(b)));c==b&&(c*=10);this.Ts[Cb](c/h.abs(d-b));do if(b=this.Ts.Tg(),c=new NPa(b,a),c=JPa(c,this.ma.Yb(),this.ma.dc(),b),b=this.Qq,d=[],!(1>=c[J]||0!=c[0])){d[B](c[0]);for(var e=1,f=c[J];e<f;e++)GPa(b,c[0],c[e])||d[B](c[e]);c=d}while(!FPa(this.Qq,c));return HX(this.Qq,c)};
PPa[K].J2=function(){var a=this.ma.jb(10*this.bk),b;this.Ts[Eb](1);do b=this.Ts[yc](),b=this.ma.jb(10*this.bk*(b-1)/b);while(h.abs(a-b)>=this.Ppa);return this.Ts.Tg()};function QPa(a,b){this.Vz=null!=a?a:1;12<this.Vz&&(this.iva=new GX(h[Eb](this.Vz/12)));this.hva=b||0;this.vm=new Date;this[Eb](0)}R=QPa[K];hb(R,function(){return this.vm[jc]()});Da(R,function(){var a=this.vm[Mc](),a=a+this.Vz;this.vm[qe](a);return this[I]()});R.Tg=function(){this.vm[qe](this.vm[Mc]()-this.Vz);return this[I]()};
ra(R,function(a){this.vm[Wc](a);1<this.Vz&&(this.vm[qe](this.vm[Mc]()-(this.vm[Mc]()+12-this.hva)%this.Vz%12),12<this.Vz&&(a=this.iva[Eb](this.vm[Qb]()),this.vm.setUTCFullYear(a)));this.vm.setUTCDate(1);this.vm.setUTCHours(0,0,0,0);return this[I]()});qa(R,function(a){return this[Eb](a)<a?this[yc]():this[I]()});Wa(R,function(a){return this[Eb](a)!=a&&a-this[I]()<this[yc]()-a?this.Tg():this[I]()});function RPa(){this.ya=0}R=RPa[K];Da(R,function(){this.ya++;return this[I]()});R.Tg=function(){this.ya--;return this[I]()};hb(R,function(){return CW(1,this.ya)});ra(R,function(a){this.ya=EW(a);return this[I]()});qa(R,function(a){this.ya=FW(a);return this[I]()});Wa(R,function(a){var b=CW(1,FW(a)),c=b/10;this.ya=h[D](.4342944819032518*h.log(a-c<b-a?c:b));return this[I]()});function SPa(a){a?(this.fk=[1E3,5E3,1E4,15E3,3E4,6E4,3E5,6E5,9E5,18E5,36E5,108E5,216E5,432E5,864E5,6048E5,2629746E3,7889238E3,31556952E3],this.af=new JX([1,2,5])):(this.fk=[1E3,6E4,36E5,864E5,6048E5,2629746E3,7889238E3,31556952E3],this.af=new RPa);this.gU=this.af[D](this.fk[0]);this.y3=this.af.Tg();this.zra=this.y3+(this.gU-this.y3)/2;this.wE=this.fk[this.fk[J]-1];this.af[D](1);this.cea=this.wE*this.af[yc]();this.Ara=this.wE+(this.cea-this.wE)/2;LX(this,2)}
function LX(a,b){a.z3=1==b||4==b;2==b?a.ya=0:3==b?a.ya=a.fk[J]-1:1==b?a.rj=1:4==b&&(a.rj=a.wE)}R=SPa[K];hb(R,function(){return this.z3?this.rj*this.af[I]():this.fk[this.ya]});ra(R,function(a){if(a<this.gU)return LX(this,1),this.af[Eb](a);if(a>=this.cea)return LX(this,4),this.rj*this.af[Eb](a/this.rj);for(LX(this,2);a>=this.fk[this.ya];)this.ya++;return this.fk[--this.ya]});
qa(R,function(a){if(a<=this.y3)return LX(this,1),this.af[Cb](a);if(a>this.wE)return LX(this,4),this.rj*this.af[Cb](a/this.rj);for(LX(this,3);a<=this.fk[this.ya];)this.ya--;return this.fk[++this.ya]});Wa(R,function(a){if(a<this.zra)return LX(this,1),this.af[D](a);if(a>=this.Ara)return LX(this,4),this.rj*this.af[D](a/this.rj);for(LX(this,3);0<this.ya&&a<this.fk[this.ya];)this.ya--;this.fk[this.ya+1]-a<=a-this.fk[this.ya]&&this.ya++;return this.fk[this.ya]});
Da(R,function(){this.z3?(this.af[yc](),1==this.rj&&this.af[I]()==this.gU&&LX(this,2)):(this.ya++,this.ya==this.fk[J]&&(LX(this,4),this.af[D](1),this.af[yc]()));return this[I]()});R.Tg=function(){this.z3?(this.af.Tg(),this.rj==this.wE&&1==this.af[I]()&&LX(this,3)):(this.ya--,-1==this.ya&&(LX(this,1),this.af[D](this.gU),this.af.Tg()));return this[I]()};function MX(a){a=(new SPa(!0))[D](a);return 2629746E3>a?6048E5==a?new GX(a,3456E5):new GX(a):new QPa(h[D](a/2629746E3))}
function TPa(a){if(!la(a))return tra;var b=new Date;b[Wc](a);a=M+NX(b[Qb]()[qc](),4);var c=b[Mc](),d=b[ee](),e=1!=d,f=b[Be](),g=b[Ae](),k=b.getUTCSeconds(),b=b.getUTCMilliseconds(),l=0!=f||0!=g||0!=k||0!=b;if(0!=c||e||l)a=a+lf+NX((c+1)[qc](),2);if(e||l)a+=lf,a+=NX(d[qc](),2);l&&(a+=mg,a+=NX(f[qc](),2),a+=xf,a+=NX(g[qc](),2),a+=xf,a+=NX(k[qc](),2),a+=mf,a+=NX(b[qc](),3));return a}
function OX(a,b){var c=M,d=new Date;d[Wc](a);var e=d[Mc](),f=d[ee](),g=d[Be](),k=d[Ae](),l=d.getUTCSeconds(),n=d.getUTCMilliseconds(),c=c+NX(d[Qb]()[qc](),4);if(b==yg)return c;c=c+lf+NX((e+1)[qc](),2);if(b==$f)return c;c+=lf;c+=NX(f[qc](),2);if(b==Nf)return c;c+=mg;c+=NX(g[qc](),2);c+=xf;c+=NX(k[qc](),2);c+=xf;c+=NX(l[qc](),2);c+=mf;return c+=NX(n[qc](),3)}function NX(a,b){for(var c=a[J];c<b;c++)a=pf+a;return a}
function PX(a){if(a==tra||null==a||a==M)return ia;var b=0,c=0,d=1,e=0,f=0,g=0,k=0,b=ja(a[mc](0,4),10);4<a[J]&&(c=ja(a[mc](5,2),10)-1,7<a[J]&&(d=ja(a[mc](8,2),10),10<a[J]&&(e=ja(a[mc](11,2),10),f=ja(a[mc](14,2),10),g=ja(a[mc](17,2),10),k=ja(a[mc](20,3),10))));return Date.UTC(b,c,d,e,f,g,k)}function QX(a,b){if(a[y]==a.end||0==b)return a;var c=(a.end-a[y])*b,d;d=a[y];d=0>d?-UPa(-d,c):VPa(d,c);var e=a.end,c=0>e?-VPa(-e,c):UPa(e,c);return new Yn(d,c)}
function VPa(a,b){if(0==a)return 0;for(var c=a,d=0,e=ia;0<c;){var f=EW(c),g=CW(1,f),k=WPa(c);if(5<k&&(e=5*g+d,e=RX(e,f),e<=a&&e>a-b))break;e=k*g+d;e=RX(e,f);if(e<=a&&e>a-b)break;f=k*g;d+=f;c-=f}return e}function UPa(a,b){if(0==a)return 0;for(var c=a,d=0,e=ia;0<c;){var f=EW(c),g=CW(1,f),k=WPa(c);if(5>k&&(e=5*g+d,e=RX(e,f),e<=a+b&&e>=a))break;e=k*g+d;e=RX(e,f);if(e<=a+b&&e>=a)break;e=(k+1)*g+d;e=RX(e,f);if(e<=a+b&&e>=a)break;f=k*g;d+=f;c-=f}return e}
function RX(a,b){var c=CW(1,h.abs(b));return h[D](a*c)/c}function WPa(a){var b=EW(a),b=CW(1,b);a/=b;b=h.abs(h[D](a)-a);0!=b&&1E-10>b&&(a=h[D](a));return h[Eb](a)};function XPa(a,b,c,d,e,f,g,k,l){this.Ina=a;this.Oaa=b;this.Paa=c;this.tg=d;this.cg=e;this.ma=f;this.NR=g;this.kb=k;this.B0=l;this.Hna=Bp(a);this.VR=Bp(b);this.cg.ml(this.Oaa)}function YPa(a,b,c){var d=a.ma.jb(b);c=a.ma.jb(c);d=(d+c)/2;return FX(a.ma.tf(d),d,a.cg[Rb](b))};function ZPa(a,b,c,d,e,f,g){this.ma=a;this.nk=b;this.tg=c;this.cg=d;this.NR=e;this.kb=f;this.B0=g;this.Saa=[SX(this,Nf,1),SX(this,Nf,7),SX(this,$f,1),SX(this,$f,2),SX(this,$f,3),SX(this,fg,1),SX(this,$f,6),SX(this,yg,1),SX(this,yg,2),SX(this,yg,5),SX(this,yg,10),SX(this,yg,20),SX(this,yg,50),SX(this,yg,100),SX(this,yg,1E3),SX(this,yg,1E4),SX(this,yg,1E7)]}function SX(a,b,c){return new XPa(a.nk,b,c,a.tg,a.cg,a.ma,a.NR,a.kb,a.B0)}
ZPa[K].kI=function(){for(var a=Bp(this.nk),b=0;b<this.Saa[J];b++){var c=this.Saa[b];if(a<=c.VR){t:{var d=c,e=d.ma.Yb(),f=d.ma.dc();d.cg.ml(d.Ina);if(e==f)c=[FX(e,h.abs(d.ma.Mo()-d.ma.mn())/2,d.cg[Rb](e))];else{var g,c=d.cg[Rb](f);g=new EX(f,d.ma.mn(),!0,!0,0,c);d.cg.ml(d.Oaa);for(var k=1==d.Paa&&d.VR>d.Hna,l=MX(d.VR*d.Paa),n=MX(d.VR),c=[],p=ia,t=l[Cb](e),e=n[Cb](e);e<=f;e=n[yc]()){var u=d.ma.jb(e);if(e==t){var t=l[yc](),x=d,A=p,C=e,E=x.tg.yv(x.cg[Rb](A),x.kb),Q=x.tg.yv(x.cg[Rb](C),x.kb);if(h.abs(x.ma.jb(A)-
x.ma.jb(C))-(E+Q)/2<x.NR){c=null;break t}k?(fa(p)||c[B](YPa(d,p,e)),c[B](new EX(e,u,!0,!0,0,null))):(p=DPa(e,u,d.cg[Rb](e)),c[B](p));p=e}else c[B](new EX(e,u,!1,!0,0,null))}k&&f<e&&(l=d,k=c,e=n,n=l.cg[Rb](f),t=l.tg.yv(n,l.kb),p=e[I](),e=e.Tg(),e=l.ma.jb(e),p=l.ma.jb(p),l=l.ma.jb(f),p=(e+p)/2,l-p>t/2&&k[B](FX(f,p,n)));if(d.B0){f=d;n=g;l=c;k=void 0;i:{for(k=l[J]-1;0<=k;k--)if(null!=l[k].ad()){k=l[k];break i}k=null}null!=k&&(l=f.tg.yv(k.ad(),f.kb),t=f.tg.yv(n.ad(),f.kb),h.abs(k[UA]()-n[UA]())-(l+t)/
2<f.NR&&k.Em(null));c[B](g)}g=c;for(n=f=0;n<g[J];n++)null!=g[n].ad()&&f++;if(2>f)c=d,d=c.cg[Rb](c.ma.Yb()),g=c.cg[Rb](c.ma.dc()),d=d+lf+g,g=[],f=h.abs(c.ma.Mo()-c.ma.mn()),c.tg.lb(d)>f+40||g[B](FX(ia,c.ma.Mo()+c.ma.mn()/2,d)),c=g;else{i:{d=c;if(!(2>d[J]))for(g=d[0],f=1;f<d[J];f++){n=d[f];if(5>h.abs(n[UA]()-g[UA]())&&g[I]()!=n[I]()){d=!0;break i}g=n}d=!1}if(d){d=[];for(g=0;g<c[J];g++)f=c[g],f.Uu&&!f.Qx||d[B](f);c=d}}}}if(null!=c)return c}}return[]};function TX(a,b,c,d,e,f,g,k,l,n,p){e&&(e=c,c=d,d=e);if(a==b)return g=(d-c)/2+c,p=p[Rb](a),[FX(a,g,p)];a=1==f?new KX(a,b,c,d):new LPa(a,b,c,d,f,g);if(a.Yb()==a.dc())b=1;else{c=h.min(a.Mo(),a.mn());d=h.max(a.Mo(),a.mn());f=h.abs(a.tf(c));e=h.abs(a.tf(d));b=h.max(f,e);var t=0,u=a.jb(0);if(c>u||u>d)t=h.min(f,e);c=a.jb(t);b=a.jb(b);b=$Pa(c,a)/$Pa(b,a)}return(.65<b?new MPa(a,p,n,k,l):new PPa(a,p,n,k,l,g)).kI()}function $Pa(a,b){var c=b.tf(a),d=b.tf(a+10);return h.abs(d-c)};function UX(a,b){this.lwa=a;this.kwa=b}UX[K].lb=function(a){return a[J]*this.lwa};cb(UX[K],function(){return this.kwa});UX[K].yv=function(a,b){return b==th?this.lb(a):this[JB](a)};function VX(a,b){this.xy=a;this.Ma=b}VX[K].lb=function(a){return this.xy(a,this.Ma)[r]};cb(VX[K],function(a){return this.xy(a,this.Ma)[z]});VX[K].yv=function(a,b){return b==th?this.lb(a):this[JB](a)};function aQa(a,b,c,d,e,f){this.N0=a;this.$R=b;this.b=c;this.T9=d;this.qla=So(c,d(Sta));this.sla=So(c,d(Qta));this.rla=So(c,d(Rta));this.pla=So(c,d(Tta));this.ola=So(c,d(Vta));this.N7=So(c,d(Uta));this.Hoa=So(c,d(Mta));this.S9=Lo(c,d(Wta));this.Bf=e;this.yI=f}function bQa(a,b,c,d){return new aQa(cQa,dQa,a,b,c,d)}
aQa[K].nja=function(a,b,c,d,e,f){b=eQa(this,a,b,c);a=kga(this.b,this.T9(Lta+b.yp));c=TNa[b.yp];a=fQa(this,{Hg:b.Hg,bh:b.bh,x9:b.yp,w9:c,u9:UNa[c],v9:a[Rb],FZ:a[Mb],s9:this.qla,Pt:e.Pt,Vc:e.Vc,t9:this.ola,EZ:[],r9:0},d,f);if(!a||0===a.Ia[J])return{Ia:[],Mi:[]};if(!(this.S9&&1==a[YA]&&0<c)){f=WX(this,e.Vc,1!=a[YA]?0:1,a.Ia,a.IP);if(this.S9&&1<a[YA]){if(a.hla/a[YA]<this.pla)d=[];else{e=e.Pt;c=[];b=new bX(a.Ia[0].sa,new Date(b.bh+this.yI),TNa[b.yp],1);for(var g=0;b.Rx<b.OB;){if(0!=g%a[YA]){var k=b[yc](),
l=d(k[jc]());c[B]({sa:k,Z:l,W:!0,brush:e,length:5})}g++}d=c}a=Kj(a.Ia,d)}else a=a.Ia;return{Ia:a,Mi:f}}--c;g=SNa[c];k=kga(this.b,this.T9(yra+g));f=fQa(this,{Hg:b.Hg,bh:b.bh,x9:g,w9:c,u9:UNa[c],v9:k[Rb],FZ:k[Mb],s9:this.sla,Pt:e.NM,Vc:e.OF,t9:this.N7,EZ:a.Ia,r9:this.rla},d,f);if(null==f)return d=WX(this,e.Vc,2,a.Ia,a.IP),{Ia:a.Ia,Mi:d};d=WX(this,e.Vc,1,a.Ia,a.IP);e=WX(this,e.OF,1,f.Ia,f.IP,d);a=Kj(f.Ia,a.Ia);f=Kj(d,e);return{Ia:a,Mi:f}};
function eQa(a,b,c,d){var e=h[D](.15*(c-b));b-=e;c+=e;$W(d,gQa,a.$R);a=$W((c-b)/a.Hoa/2,a.N0,a.$R);var f=hQa(a);a=Bj(UNa,function(a){return Sj(a,f)});return{Hg:b,bh:c,yp:SNa[a]}}
function fQa(a,b,c,d){for(var e=wj(b.v9,function(a){return new Wp({pattern:a})}),f=0;f<b.FZ[J];++f){var g=b.FZ[f],k=0,l=RNa(b.u9,g),l=YW(new Date(b.Hg+a.yI),l);b.x9===dwa&&(l=LNa(l));for(var n=new bX(l,new Date(b.bh+a.yI),b.w9,g),l=[],p=!0,t=c(b.Hg),u=-1;n.Rx<n.OB;){var x=n[yc](),A=c(x[jc]()-a.yI);-1==u&&A>=t&&(u=l[J]);var C=n.Co();if(null!=C){C=c(C[jc]()-a.yI);if(C<A+1)break;if(C-A<b.s9){p=!1;break}}for(C=!1;k<b.EZ[J];){var E=b.EZ[k];if(h.abs(E.Z-A)<b.r9){C=!0;break}if(E.Z>A){k=h.max(0,k-1);break}k++}C||
l[B]({sa:x,Z:A,W:!0,brush:b.Pt,length:null})}if(p){1<u&&(l=Nj(l,u-1));k=p=null;for(t=0;t<e[J];++t){u=e[t];x=!0;A=[];for(n=0;n<l[J];++n){var C=l[n],E=u.Sc(C.sa),Q=d(E,b.Vc),Q=a.Bf?Q[z]:Q[r];if(n+1<l[J]&&l[n+1].Z-C.Z<b.t9+Q){x=!1;break}A[B]({text:E,size:Q})}if(x&&0<A[J]){p=t;k=A;break}}if(null!=p){a=da;for(n=0;n<l[J]-1;++n)a=h.min(a,l[n+1].Z-l[n].Z);return{Ia:l,IP:k,multiple:g,hla:a}}}}return null}
function WX(a,b,c,d,e,f){var g=[];if(null!=f)for(var k=0;k<f[J];++k){var l=f[k].za,n=l.I[0];g[B](iQa(n.x,n[J],l.Gc,a.N7))}a=1==c?TD:dK;f=0;k=[];l=2==c?d[J]-1:d[J];for(n=0;n<l;++n){var p=d[n];if(p.W&&e[n]){for(var t=h[D](2==c?(d[n+1].Z+p.Z)/2:p.Z),u=e[n][EA],x=iQa(t,u,a),A=!0;f<g[J];){var C=g[f];if($n(x,C)){A=!1;break}if(C[y]>x.end){f=h.max(0,f-1);break}f++}A&&k[B]({sa:p.sa,W:!0,Z:t,za:{text:e[n][pd],ba:b,I:[{x:t,y:0,text:e[n][pd],length:u}],Gc:a,Fc:zI,tya:e[n][pd],anchor:null,Eb:0}})}}return k}
function hQa(a){return wj(a,function(a){return 0<a?1:0})}function iQa(a,b,c,d){d=Gi(d)?d:0;c==TD?(c=a,a=c+b):(c=h[D](a-b/2),a=h[D](a+b/2));return new Yn(c-d,a+d)}
var gQa=[[1],[50],[500],[0,1],[0,15],[0,30],[0,0,1],[0,0,15],[0,0,30],[0,0,0,1],[0,0,0,6],[0,0,0,12],[0,0,0,0,1],[0,0,0,0,7],[0,0,0,0,0,1],[0,0,0,0,0,3],[0,0,0,0,0,6],[0,0,0,0,0,0,1]],cQa=[[1],[2],[5],[10],[20],[50],[100],[200],[500],[0,1],[0,2],[0,5],[0,10],[0,15],[0,30],[0,0,1],[0,0,2],[0,0,5],[0,0,10],[0,0,15],[0,0,30],[0,0,0,1],[0,0,0,2],[0,0,0,3],[0,0,0,4],[0,0,0,6],[0,0,0,12],[0,0,0,0,1],[0,0,0,0,2],[0,0,0,0,7],[0,0,0,0,0,1],[0,0,0,0,0,3],[0,0,0,0,0,0,1],[0,0,0,0,0,0,10],[0,0,0,0,0,0,50],[0,
0,0,0,0,0,100]],dQa=3;function XX(a,b,c,d,e,f,g){this.nG=c;this.b=b;Iq(this,d);db(this,ep(b,this.Ja(qi),fNa,e));this.bh=this.Hg=null;this.SF=[];this.Ar=null;this.Jha=0<a.Pf.bars;c=Wo(b,this.Ja(qD));d=a.uF===pH?a.qw:O;d={$a:a.kk,fontSize:a.wm,lc:d};d=np(b,this.Ja(oD),d);Xq(this,{text:c,ba:d,gr:null,I:[],Gc:dK,Fc:TD,rb:M,anchor:null,Eb:0});this.VV=!1;this.Mi=null;this.Bm=ep(b,this.Ja(Mna),lNa,JF);c=this[H]!=ti||a.ab==OE?Zo(b,Yra,M):Zo(b,Ara,M);d=this.Bm===pH?a.qw:O;c={color:c,$a:a.kk,fontSize:a.wm,lc:d};this.Vc=np(b,this.Ja(vD),
c);d=So(b,this.Ja(Ota));d=go(this.Vc[F],a.yM||Re,d);this.OF=np(b,this.Ja(vD),c);Ya(this.OF,d);this.fia=ep(b,this.Ja(ira),mNa,Xma);this.c6=ep(b,this.Ja(hta),nNa,asa);c=Zo(b,this.Ja(HK),a.Fha);this.gia=new lo({fill:c});c=Zo(b,this.Ja(LH),a.Y5);this.Pt=new lo({fill:c});this.Lp=So(b,this.Ja(zra),0);d=So(b,this.Ja(Pta));a=go(c,a.yM||Re,d);a=Zo(b,this.Ja(jG),a);this.NM=new lo({fill:a});this.tp=2;this.a6=h.max(this.tp,h[D](this[bC].ba[Gc]/3.236));Cy(this,[]);if(this.Ti=g||b.Q(this.Ja(rD)))this.Ti=wj(this.Ti,
function(a){var b={};b.v=Gi(a.v)?a.v:a;Si(a.f)&&(b.f=a.f);return b});this.MF=0;this.zm=Po(b,this.Ja(ah),1);$x(this,this.zm);this.cf=this.Se=null;this.WA=this.Ew=0;this.ib={min:-da,max:da};this.RF=this.yia=f;f=uV(this.b,this.Ja(HG),this.Ja(PE));this.zia=f===iG;this.qA=f===IG||this.zia;this[H]==ti?(this.bW=this.Cb=this.ga=null,this.nk=ep(b,this.Ja(Gna),zga,Yf),this.QM=da):this.Ti=null}R=XX[K];R.Ja=function(a){return oV(this.nG,a)};function wX(a,b){Ui(b)&&0!==b&&!fa(b)&&(a.QM=h.min(h.abs(b),a.QM))}
R.zA=function(a){this.ga.zA(this.QM/10,a||[])};function YX(a,b,c){var d=iX().ph(b);a.by=Qo(c,a.Ja(KH));var e=a.bj(),e=!a.qA&&gp(c,vI)&&(!gp(c,bva)||Xo(c,a.Ja(ava+e)));!a.Ti&&(e||0>a.by||null===a.by&&a.qA)&&(a.bW=!0,a.by=-1);d[Sc](c,a.nG,a.by);a.ga=d;a.dataType=b;a.Hg=d.Q(c,a.Ja(Lh));a.bh=d.Q(c,a.Ja(Hh));a.Ar=c.Q(a.Ja(IK),yNa.vAxis.gridlines.baseline)}
function ZX(a,b){a.RF=ep(b,a.Ja(OC),gNa,a.RF);if(a[H]==ti){var c=a.ga,d=c.Q(b,a.Ja(xma));Ui(d)||(d=JW(c,c.Q(b,a.Ja(PC))));var e=c.Q(b,a.Ja(yma));Ui(e)||(e=JW(c,c.Q(b,a.Ja(QC))));null!=d&&(a.ib.min=d);null!=e&&(a.ib.max=e)}else a.ib.min=Po(b,a.Ja(PC),a.ib.min),a.ib.max=Po(b,a.Ja(QC),a.ib.max),a.ib.max=h.max(a.ib.min+1,a.ib.max);a.ib.min>a.ib.max&&(c=a.ib.min,a.ib.min=a.ib.max,a.ib.max=c);a[H]==ti&&(a.ib.min!=-da&&HW(a.ga,a.ib.min),a.ib.max!=da&&IW(a.ga,a.ib.max))}
function jQa(a){if(a[H]==ti&&!a.ga)throw m("Axis type/data type mismatch for "+a.nG);}
function kQa(a,b,c,d,e,f){a.Se=d+(1==a[Cz]?.5:-.5);a.MF=c-1;a.cf=d+c*a[Cz];c=a.J9(b);a.gG(b);lQa(a)&&(a.bW||Lo(a.b,a.Ja(Nta)))&&(a.VV=!0);b=a.VV?mQa(a,b,e,f):nQa(a,b,e,f);return{title:a[bC],name:a.K9(),type:a[H],mp:a.qA,dataType:a[TA],zm:a.zm,Se:a.Se,cf:a.cf,Vd:{Be:U(a.o9,a),lk:U(a.Bp,a)},position:{Be:U(a.aI,a),lk:U(a.T7,a)},Gj:c,Cb:b.Cb,Ia:b.Ia,Lh:b.Lh,text:a.Mi,wA:a.ga?{min:a.ga.ee,max:a.ga.oe}:{min:a.ib.min,max:a.ib.max}}}
function nQa(a,b,c,d){a[H]==ti?(oQa(a),a.Ti?pQa(a):a.bW?lQa(a)?qQa(a,b):rQa(a,b):sQa(a)):tQa(a,b,a.MF+1);var e=uQa(a),f=null;if(a[H]==ti){var f=wj(a[RA],function(a){return{tick:a,sa:a.sa,Z:a.Z,W:!0,length:null,brush:this.Pt}},a),g;if(g=a.qA?vQa(a,f):wQa(a,f))g=wj(g,function(a){return{sa:this.T7(a),Z:a,W:!0,length:null,brush:this.NM}},a),Mj(f,g);uj(f,function(a){if(a.Z*this[Cz]<this.Se*this[Cz]||$X(this,a.Z))a.W=!1,Ij(this[RA],a.tick);delete a.tick},a)}g=null;Lo(a.b,a.Ja(Ina))&&(f&&(g=Lj(f)),e&&Mj(g||
[],[e]));a.QX(b,c,d,null);a.PX(b);return{Ia:f,Lh:g,Cb:e}}
function mQa(a,b,c,d){aY(a);if(a.ga.ee>=a.ga.oe)return{Ia:null,Lh:null,Cb:null};var e=uQa(a);Qj(a.SF);for(var f=da,g=1;g<a.SF[J];++g){var k=a.SF[g]-a.SF[g-1];k&&(f=h.min(f,k))}f===da&&(f=0);var l=a.gG(b)[QB]===ui,g=0;a.ga instanceof jX&&(g=(new Date(1970,0,1))[jc]());var g=bQa(a.b,U(a.Ja,a),l,g),k={Vc:a.Vc,Pt:a.Pt,OF:a.OF,NM:a.NM},n=a[Cz];$x(a,1);var p=g.nja(a.ga.ee,a.ga.oe,f,U(a.De,a),k,b.mc);$x(a,n);-1===n&&(uj(p.Ia,function(a){a.Z=xQa(this,a.Z)},a),uj(p.Mi,function(a){a.Z=xQa(this,a.Z);a.za.I[0].x=
xQa(this,a.za.I[0].x)},a));uj(p.Mi,function(a){a.sa=this.ga.Bp(a.sa[jc]());if(l){var b=a.za.I[0].x;a.za.I[0].x=a.za.I[0].y;a.za.I[0].y=b}},a);uj(p.Ia,function(a){a.sa=this.ga.Bp(a.sa[jc]());if(a.Z*this[Cz]<this.Se*this[Cz]||$X(this,a.Z))a.W=!1,Ij(p.Ia,a)},a);var t=Cy(a,[]);uj(p.Mi,function(a){a.Z*this[Cz]<this.Se*this[Cz]||$X(this,a.Z)?Ij(p.Mi,a):t[B]({sa:a.sa,Z:a.Z,text:a.za[pd],W:a.W})},a);a.QX(b,c,d,p.Mi);a.PX(b);return{Ia:p.Ia,Lh:null,Cb:e}}
function tQa(a,b,c){var d;a.ib.min==-da&&(a.ib.min=h.min(0,a.ib.max-1));a.ib.max==da&&(a.ib.max=h.max(b.Ga[J],a.ib.min+1));a.ib.max=h.max(a.ib.min+1,a.ib.max);d=a.ib.max-a.ib.min;a.Jha&&(d=h.min(d,h[Eb]((c+1)/2)));a[H]==fK&&(d=h.max(1,d-1));a.WA=yQa(a);a.Ew=a.MF/d;Cy(a,jV(b.Ga[J],function(a){var c=a-this.WA;return{sa:b.Ga[a][Y],Z:this.De(a),text:b.Ga[a].hu[0],W:0<=c&&c<=d}},a))}
function pQa(a){var b=a.ga;Qj(a.Ti,function(a,c){return b.kba(a.v,c.v)});0<a.Ti[J]&&(a.pc(JW(b,a.Ti[0].v)),a.pc(JW(b,a.Ti[a.Ti[J]-1].v)));aY(a);b.hJ(!1);-1===a.zm&&(a.Ti=Lj(a.Ti),a.Ti[gr]());var c=wj(a.Ti,function(a){return JW(this.ga,a.v)},a);b.Hp(c);var d=zMa(a.ga);Cy(a,wj(a.Ti,function(a){var c=a.v,g=JW(b,c),g=this.De(g);a=a.f;Si(a)||(a=d.Sc(c));return{sa:c,Z:g,text:a,W:!0}},a))}
function sQa(a){yMa(a.ga,a.Hg,a.bh,a.RF==oF||a.RF==wI&&(a.ib.min==-da||a.ib.max==da));aY(a);a.qA&&zQa(a);var b=a.ga[RA],b=vj(b,function(a){return a>=this.ib.min&&a<=this.ib.max},a);Ui(a.by)&&2>a.by&&(b=Nj(b,0,a.by));a.ga.Hp(b);a.ga.wJ();var c=zMa(a.ga);aY(a);Cy(a,wj(a.ga[RA],function(a){var b=this.ga.Bp(a),f=c.Sc(b);return{sa:b,Z:this.De(a),text:f,W:!0}},a))}
function zQa(a){var b=da,c=null,d,e=a.ga[RA],e=wj(e,function(a){d=0<a-c?1:-1;a=d*h[Eb](d*a);c&&0!==a*c&&0<a-c&&(b=h.min(b,h.abs(a-c)));return c=a});b!==da&&(c=null,uj(e,function(a,g){null!==c&&(c===a&&rj[Ee][L](e,g,1),h.abs(a-c)>b&&(d=0<a-c?1:-1,Gj(e,c+d*b,g+1)));c=a}));a.ga.Hp(e)}
function qQa(a,b){aY(a);var c=a.ga,d=a.gG(b);c.hJ(!1);var e=zMa(c);e.ml(a.nk);var f=d.vB,g=d.uB-1,k=new VX(b.mc,a.Vc);if(d.ug)var l=f,f=g,g=l;d=(new ZPa(new KX(c.ee,c.oe,f,g),a.nk,k,e,10,d[QB],!1)).kI();Cy(a,[]);for(e=0;e<d[J];e++)f=d[e],f.ad()&&a[RA][B]({sa:c.Bp(f[I]()),Z:f[UA](),text:f.ad(),W:!0})}
function wQa(a,b){if(!b||1>=b[J]||0==a.Lp)return null;var c=(b[1].Z-b[0].Z)/(a.Lp+1),d=[],e,f,g=b[0].Z;for(e=f=h[Eb]((g-a.Se)/c);0<e;e--){var k=h[Eb](g-c*e);1<h.abs(k-a.Se)&&d[B](k)}for(e=0;e<b[J]-1;e++)for(g=b[e].Z,f=0;f<a.Lp;f++)g+=c,d[B](h[Eb](g));g=qj(b).Z;f=h[Eb]((a.cf-g)/c);for(e=1;e<=f;e++)k=h[Eb](g+c*e),1<h.abs(k-a.cf)&&d[B](k);return d}
function vQa(a,b){if(!b||1>=b[J]||0==a.Lp)return null;for(var c=b[0],d=c.sa,e=d,f=[c],g=1;g<b[J]-1;g++)c=b[g],e=d,d=c.sa,0!==d&&(DW(d)||e&&DW(e/d))&&f[B](c);f[B](b[b[J]-1]);b=f;if(1>=b[J])return null;var k=b[1].Z-b[0].Z,c=[],d=[],l;a.Lp=h.min(vNa[J],a.Lp);e=vNa[a.Lp-1];a.Lp=e[J];for(g=0;g<a.Lp;g++)f=h.log(e[g])/h.log(10),d[B](f);for(g=0;g<b[J]-1;g++)if(e=b[g].Z,f=1,k=b[g+1].sa/b[g].sa,!(0>k)&&DW(k))for(1>k&&(f=-1,e=b[g+1].Z),k=b[g+1].Z-b[g].Z,l=0;l<a.Lp;l++)c[B](e+f*k*d[l]);return c}
function uQa(a){var b=null;a[H]==ti&&a.Cb&&(b={sa:a.Cb.sa,Z:a.Cb.Z,W:!0,length:null,brush:a.gia});return b}function oQa(a){null!=a.Ar&&a.Ar!==Mg&&a.pc(JW(a.ga,a.Ar));null!=a.Hg&&a.pc(JW(a.ga,a.Hg));null!=a.bh&&a.pc(JW(a.ga,a.bh))}
function aY(a){var b=Wk(a.ib.min)?a.ib.min:a.ga.ee,c=Wk(a.ib.max)?a.ib.max:a.ga.oe;b===c&&(--b,c+=1);HW(a.ga,b);IW(a.ga,c);a.ib.min=b;a.ib.max=c;a.Ew=a.MF/(c-b);b!==da&&(a.WA=b);if(Gi(a.Ar)&&a.Ar!==Mg)b=JW(a.ga,a.Ar);else{var d=JW(a.ga,a.ga.b1()),b=Lk(d,b,c);Wk(b)||(b=0)}a.Cb=null;Wk(b)&&(c=a.De(b),fa(c)||(a.Cb={sa:a.ga.Bp(b),Z:c}))}
function rQa(a,b){if(a.RF==oF&&la(a.ga.ee)&&la(a.ga.oe)){var c=QX(new Yn(a.ga.ee,a.ga.oe),.1);a.pc(c[y]);a.pc(c.end)}aY(a);var c=a.gG(b),d=a.ga.Lt[NA](a.ga.ee),e=a.ga.Lt[NA](a.ga.oe);wX(a,d);wX(a,e);var f=a.qA?0:1,g=new VX(b.mc,a.Vc),k,l=a.b;k=new DX;var n=Xo(l,a.Ja(YH));gp(l,a.Ja(Fua));var p=Qo(l,a.Ja(WH)),t=Xo(l,a.Ja(XH)),u=Xo(a.b,a.Ja(VH));n||p||t||u?k.tY={pattern:n,scaleFactor:p,prefix:t,suffix:u}:(n=Qo(l,a.Ja(Eua)),Ui(n)&&yPa(k,n),n=Qo(l,a.Ja(Dua)),Ui(n)&&zPa(k,n),(n=l.Q(a.Ja(Cua)))&&k.yp({symbol:n.symbol,
position:n[tc],usePadding:n.usePadding}),Lo(l,a.Ja(Bua))&&BPa(k));k=k.$g();l=[];Wk(d)&&(l=TX(d,e,c.vB,c.uB-1,c.ug,f,a.QM,c[QB],40,g,k));Cy(a,[]);for(c=0;c<l[J];c++)d=l[c],e=d[I](),f=a.ga.Lt[AC](e),a[RA][B]({sa:e,Z:a.De(f),text:d.ad(),W:!0})}R.pc=function(a){this[H]==ti&&null!=a&&bY(this,a)&&(this.ga.pc(a),this.SF[B](a))};function AQa(a){if(a[H]==ti){var b=a.ga,c=b.ee,d=b.oe,e=.01*(d-c);0<c&&a.ib.min==-da&&HW(b,h.max(c-e,0));0>d&&a.ib.max==da&&IW(b,h.min(d+e,0))}}
R.De=function(a){return null!=a?this.Se+(a-this.WA)*this[Cz]*this.Ew:null};function xQa(a,b){if(null==b)return null;$x(a,1);var c=null!=b?(b-a.Se)*a[Cz]/a.Ew+a.WA:null;$x(a,-1);return a.De(c)}R.o9=function(a){return this[H]==ti?JW(this.ga,a):a};R.Bp=function(a){return null!=a?this[H]==ti?this.ga.Bp(a):a:null};R.T7=function(a){a=null!=a?(a-this.Se)*this[Cz]/this.Ew+this.WA:null;return null!=a?this.Bp(a):null};R.aI=function(a){return this.De(this.o9(a))};
function yQa(a){switch(a[H]){case gK:return a.ib.min-.5}return a.ib.min}function bY(a,b){return a[H]==ti?b>=a.ib.min&&b<=a.ib.max:b>=h[Eb](a.ib.min)&&b<h[Cb](a.ib.max)}function $X(a,b){return b*a[Cz]>a.cf*a[Cz]}function lQa(a){return null!=a.ga&&(a.ga instanceof fX||a.ga instanceof jX)};function BQa(a,b,c,d,e,f,g,k,l,n){this.eca=a;this.Vh=b;this.Asa=c;this.Rqa=d;this.Kea=e;this.IU=f;this.fpa=g;this.epa=k;this.dpa=l;this.dca=n}function CQa(a,b,c,d){switch(d){case Eya:return(b-1-a)%c;default:return a}}function cY(a,b,c){b=h[Cb]((a.Vh[J]-0)/(b*c));return 2>a.Vh[J]||2>b}
function DQa(a,b,c,d,e){b=CQa(b,a.Vh[J],d,a.fpa);for(var f=1>=a.Vh[J]?a.eca:h.abs(a.Vh[1].Z-a.Vh[0].Z)*d-a.epa,g=[];b<a.Vh[J];b+=d){var k=a.Vh[b],l=k.W&&!a.dpa?h.min(f,2*k.Z,2*(a.eca-k.Z)):f,n=a.dca(k[pd],l,e),p=n.re;l<f&&(p=a.dca(k[pd],f,e).re);g[B]({sa:k.sa,W:k.W,Z:k.Z,Q7:c,text:k[pd],width:n.Hr,layout:n,re:p})}return g}function EQa(a,b,c,d){var e=b*c;d=1<b?1:d;for(var f=[],g=0;g<b;g++){var k=DQa(a,a.Asa+g*c,g*d,e,d);Mj(f,k)}Qj(f,function(a,b){return a.Z-b.Z});return f}
function FQa(a,b,c){a=EQa(a,b,c,a.Rqa);return xj(a,function(a,b){return{Qu:h.max(a.Qu,b[Mz].I[J]),re:a.re||b.re}},{Qu:0,re:!1})}function GQa(a){for(var b=1,c=a.IU||1,d=FQa(a,b,c),e=b;d.re&&b<a.Kea;){b++;if(cY(a,b,c))break;e=b;d=FQa(a,e,c)}b=c;if(!a.IU)for(;d.re;){c++;if(cY(a,e,c))break;b=c;d=FQa(a,e,b)}return{mY:e,Bx:b,Qu:d.Qu*e}}function HQa(a,b,c,d,e){a=EQa(a,b,c,d);e=xj(a,function(a,b){var c=b.re?1:0;delete b.re;return a+c},0)<=a[J]*e;return{LO:a,Ofa:e}}
function IQa(a,b,c,d,e){var f=h.min(a.Kea,d);b=h.min(b,f);c=a.IU||c;for(var g=HQa(a,b,c,d,e),k=b;!g.Ofa&&b<f;){b++;if(cY(a,b,c))break;k=b;g=HQa(a,k,c,d,e)}f=c;if(!a.IU)for(;!g.Ofa;){c++;if(cY(a,k,c))break;f=c;g=HQa(a,k,f,d,e)}return{mY:k,Bx:f,LO:g.LO}};function dY(a,b,c,d,e,f,g){XX[L](this,a,b,Kj([Jta+d,IH],c),d,e,f,g);this.gY=Mo(b,this.Ja(noa));a=So(b,this.Ja(moa),30);this.V9=a=Mk(a,360);this.WP=Ok(a);this.tla=So(b,this.Ja(CG),.5*this.Vc[Gc]);this.K7=So(b,this.Ja(Rua));this.L7=So(b,this.Ja(Jra),da);this.ZX=So(b,this.Ja(Lra),2);this.sO=So(b,this.Ja(yoa),0);this.WX=ep(b,this.Ja(xoa),tNa,Dya);this.M7=So(b,this.Ja(Bra),this.Vc[Gc]);this.J7=Lo(b,this.Ja(mza),!1)}W(dY,XX);R=dY[K];R.K9=function(){return Ita+this[xc]};
R.cW=function(a,b,c){return kQa(this,a,a.t[r],1==this[Cz]?a.t[G]:a.t[kd],b,c)};
R.QX=function(a,b,c,d){if(0==this[xc]){var e=a.mc,f=this.Vc[Gc],g=this[bC].ba[Gc],k=b.Ma[Gc],l=a.uF==JF?this[bC][pd]:M,n=this,p=new BQa(a[r],this[RA],this.K7,this.L7,this.ZX,this.sO,this.WX,this.M7,this.J7,function(a,b,c){return fT(e,a,n.Vc,b,c)}),t=this.sO||1,u,x;if(this.Bm==JF&&!d)if(null!=this.gY)this.gY?x=eY(this,e):u=GQa(p);else if(this[RA][J]*f/(this.ZX*t)<=a[r]){if(u=GQa(p),u.Bx>t||0==u.Qu)x=eY(this,e),u=null}else x=eY(this,e);var A=fT(e,l,this[bC].ba,a.t[r],da),C=this.tp,E=h.max(C,h[D](f/
1.618)),Q=h.max(C,h[D](f/3.236)),N=function(){return{key:rD,min:x.minHeight+C,max:x.maxHeight+C,Ub:[E-C]}},S=[];S[B]({key:tK,min:C,Ub:[da]});0<A.I[J]&&S[B]({key:qD,min:g+C,Ub:[da]});b[UA]()==uK&&S[B]({key:XG,min:k+C,Ub:[da]});c[UA]()==uK&&S[B]({key:nJ,min:c[JB]()+C,Ub:[da]});var T=S[J];d||u&&0<u.Qu?S[B]({key:rD,min:f+C,Ub:[E-C]}):x&&S[B](N());var V=S[J];if(u)for(var sa=1;sa<u.Qu;sa++)S[B]({key:rD,min:f+C,Ub:[Q-C]});f=S[J];for(sa=1;sa<A.I[J];sa++)S[B]({key:qD,min:g+C,Ub:[this.a6-C]});var g=lV(S,a[z]-
a.t[Uc]),Ha=g[RA]||[],Ka;u&&(Ka=IQa(p,u.mY,u.Bx,Ha[J],0),null==this.gY&&Ka.Bx>t&&(Ka=u=null,x=eY(this,e),S[T]=N(),S=hKa(S,0,V,f,void 0),g=lV(S,a[z]-a.t[Uc])));var Ra=a.t[Uc],Ha=g[RA]||[];if(0<Ha[J]){for(sa=1;sa<Ha[J];sa++)Ha[sa]+=Ha[sa-1];if(d){p=Ra+Ha[0];for(sa=0;sa<d[J];sa++)t=d[sa].za,sz(t,t[lC]||new fV(0,0)),t[lC].y=p;this.Mi=d}else u?this.Mi=wj(Ka.LO,function(a){var b=wj(a[Mz].I,function(b,c){return{x:0,y:Ha[a.Q7+c],length:a[r],text:b}},this);return{sa:a.sa,W:a.W,za:{text:a[pd],ba:this.Vc,I:b,
Gc:dK,Fc:zI,rb:a[Mz].re?a[pd]:M,anchor:new fV(a.Z,Ra),Eb:0}}},this):x&&(sa=Ha[0],d=h.min(sa-C,x.maxHeight),this.Mi=JQa(this,e,Ra+sa-d,d,x.Bx));Ra+=qj(Ha)}d=g[bC]||[];if(0<d[J])for(p=fT(e,l,this[bC].ba,a.t[r],d[J]),this[bC].rb=p.re?l:M,sa=0;sa<d[J];sa++)Ra+=d[sa],this[bC].Fc=zI,this[bC].I[B]({x:a.t[G]+a.t[r]/2,y:Ra,length:a.t[r],text:p.I[sa]});l=g.legend||[];0<l[J]&&(Ra+=l[0],b.lp(new um(Ra-k,a.t[kd],Ra,a.t[G])));b=g.colorBar||[];0<b[J]&&(Ra+=b[0],a=new um(Ra-c[JB](),a.t[kd],Ra,a.t[G]),c.lp(a))}};
function eY(a,b){function c(a){a=b(a[pd],d)[r]*f+e*g;return h[Cb](a)}var d=a.Vc,e=d[Gc],f=h.sin(a.WP%h.PI),g=h.cos(a.WP%h.PI),k=a.sO;k||(k=2>a[RA][J]?1:h[Cb]((e+a.tp)/f/h.abs(a[RA][1].Z-a[RA][0].Z)));for(var l=0,n=0;n<a[RA][J];n+=k)l=h.max(c(a[RA][n]),l);n=c({text:nf});return{minHeight:h.min(l,n),maxHeight:l,Bx:k}}R.NQ=function(a){var b=a.mc;return xj(this[RA],function(a,d){return h.max(a,b(d[pd],this.Vc)[r])},0,this)};R.$$=function(a){var b=a.mc;a=this.NQ(a);b=b(nf,this.Vc)[r];return h.min(b,a)};
function JQa(a,b,c,d,e){var f=CQa(0,a[RA][J],e,a.WX);d=(d-a.Vc[Gc]*h.cos(a.WP%h.PI))/h.sin(a.WP%h.PI);d=h[Eb](d);var g=[];for(c+=a.tla;f<a[RA][J];f+=e){var k=a[RA][f],l=fT(b,k[pd],a.Vc,d,1),n={text:k[pd],ba:a.Vc,I:[],Eb:-a.V9,Gc:180<a.V9?TD:zI,Fc:dK,rb:l.re?k[pd]:M,anchor:new fV(k.Z,c)};0<l.I[J]&&n.I[B]({x:0,y:0,length:d,text:l.I[0]});g[B]({sa:k.sa,W:k.W,za:n})}return g}
R.PX=function(a){if(0==this[xc]){var b=a.mc,c=this.Vc[Gc],d=new BQa(a[r],this[RA],this.K7,this.L7,this.ZX,this.sO,this.WX,this.M7,this.J7,U(function(a,c,d){return fT(b,a,this.Vc,c,d)},this)),e,f=this.c6;this.Bm==pH&&(e=GQa(d),this.VV&&(f=AH));var g=this.tp,k=h.max(this.tp,h[D](c/3.236)),l=h.max(this.tp,h[D](c/1.618)),l=this[H]==ti?k:l,n=h.max(g,h[D](c/3.236)),p,t;this[H]==ti?f===AH?(p=TD,t=k):(p=zI,t=-k):(p=dK,t=0);f=[];f[B]({key:jD,min:g,Ub:[da]});if(e)for(k=0;k<e.Qu;k++)f[B]({key:rD,min:c+g,Ub:[(0==
k?l:n)-g]});var u=lV(f,h[Eb](a.t[z]/2))[RA]||[];if(0<u[J]){for(k=1;k<u[J];k++)u[k]+=u[k-1];c=IQa(d,e.mY,e.Bx,u[J],.5);this.Mi=wj(c.LO,function(b){var c=b[Mz].I;c[gr]();c=wj(c,function(a,c){return{x:0,y:-u[b.Q7+c],length:b[r],text:a}},this);return{sa:b.sa,W:b.W,za:{text:b[pd],ba:this.Vc,I:c,Gc:p,Fc:TD,rb:b[Mz].re?b[pd]:M,anchor:new fV(t+b.Z,a.t[Uc]),Eb:0}}},this)}}};R.gG=function(a){var b={};b.ug=-1==this[Cz];b.vB=a.t[G];b.uB=a.t[kd];dz(b,this.bj());return b};R.bj=function(){return th};
R.J9=function(a){return 0==this[xc]?{Z:a.t[Uc],direction:-1}:{Z:a.t.top,direction:1}};function KQa(a){return new oO(h[D](a.x),h[D](a.y))}function LQa(a){return xj(arguments,pO,new oO(0,0))}function MQa(a){return xj(arguments,function(a,c){return new Cl(a[r]+c[r],a[z]+c[z])},new Cl(0,0))}function fY(a,b,c){return new oO(h.cos(a)*b,h.sin(a)*c)}function NQa(a){return new oO(a[0],a[1])}function OQa(a,b){return wj([[a.x-b[r]/2,a.y-b[z]/2],[a.x+b[r]/2,a.y-b[z]/2],[a.x+b[r]/2,a.y+b[z]/2],[a.x-b[r]/2,a.y+b[z]/2]],NQa)}
function PQa(a,b,c,d){return new xm(h.min(a,c),h.min(b,d),h.abs(c-a),h.abs(d-b))};function gY(a,b,c,d,e,f,g){XX[L](this,a,b,Kj([Jma+d,Au],c),d,e,f,g);this[H]==ti&&$x(this,-this[Cz])}W(gY,XX);R=gY[K];R.K9=function(){return Ima+this[xc]};R.cW=function(a,b,c){return kQa(this,a,a.t[z],1==this[Cz]?a.t.top:a.t[Uc],b,c)};R.NQ=function(a){var b=a.mc;return xj(this[RA],function(a,d){return h.max(a,b(d[pd],this.Vc)[r])},0,this)};R.$$=function(a){var b=a.mc;a=this.NQ(a);b=b(nf,this.Vc)[r];return h.min(b,a)};
R.QX=function(a){var b=a.mc,c=this.Vc[Gc],d=this[bC].ba[Gc],e=a.uF==JF?this[bC][pd]:M,f=fT(b,e,this[bC].ba,a.t[z],da),g=this.tp,k=this.NQ(a),l=this.$$(a),n=[];this.Bm==JF?n[B]({key:ZE,min:g,Ub:[c-g]}):n[B]({key:ZE,min:0,Ub:[da]});0<f.I[J]&&n[B]({key:qD,min:d+g,Ub:[da]});this.Bm==JF&&n[B]({key:rD,min:l+g,max:k+g,Ub:[da]});for(c=1;c<f.I[J];c++)n[B]({key:qD,min:d+g,Ub:[this.a6-g]});var d=lV(n,0==this[xc]?a.t[G]:a[r]-a.t[kd]),p=0==this[xc]?0:a[r],f=d[bC]||[];if(0<f[J])for(b=fT(b,e,this[bC].ba,a.t[z],
f[J]),1===this[xc]&&b.I[gr](),this[bC].rb=b.re?e:M,c=0;c<f[J];c++)p+=f[c]*(0==this[xc]?1:-1),this[bC].Eb=-90,this[bC].Fc=0==this[xc]?zI:TD,this[bC].I[B]({x:p,y:a.t.top+a.t[z]/2,length:a.t[z],text:b.I[c]});if(this.Bm==JF){var e=d[RA][0]||0,p=p+e*(0==this[xc]?1:-1),t=h.min(k,e-g);this.Mi=t<l?[]:wj(this[RA],function(b,c){var d=0==this[xc]?zI:TD,e=dK;this.fia==gya&&(0==c&&(e=1==this[Cz]?TD:zI),c==this[RA][J]-1&&(e=1==this[Cz]?zI:TD));return QQa(this,a,b,p,t,d,e,0)},this)}};
R.PX=function(a){var b=a.mc,c=this.Vc[Gc],d=this.tp,e=h.max(this.tp,h[D](c/3.236)),c=h.max(this.tp,h[D](c/1.618)),c=this[H]==ti?e:c,f,g;this[H]==ti?this.c6==AH?(f=zI,g=e):(f=TD,g=-e):(f=dK,g=0);var e=xj(this[RA],function(a,c){return h.max(a,b(c[pd],this.Vc)[r])},0,this),k=b(nf,this.Vc)[r],k=h.min(k,e),l=[];l[B]({key:ZE,min:d,Ub:[da]});this.Bm==pH&&l[B]({key:rD,min:k+d,max:e+c,Ub:[]});var c=lV(l,a.t[r]),n=0==this[xc]?a.t[G]:a.t[kd];if(this.Bm==pH){var c=c[RA][0]||0,p=h.min(e,c-d),n=n+(c-p)*(0==this[xc]?
1:-1);this.Mi=wj(this[RA],function(b){return QQa(this,a,b,n,p,0==this[xc]?TD:zI,f,g)},this)}};function QQa(a,b,c,d,e,f,g,k){b=fT(b.mc,c[pd],a.Vc,e,1);var l=wj(b.I,function(a){return{x:0,y:0,length:e,text:a}},a);return{sa:c.sa,W:c.W,za:{text:c[pd],ba:a.Vc,gr:null,I:l,Gc:f,Fc:g,rb:b.re?c[pd]:M,anchor:new fV(d,c.Z-k),Eb:0}}}R.gG=function(a){var b={};b.ug=-1==this[Cz];b.vB=a.t.top;b.uB=a.t[Uc];dz(b,this.bj());return b};R.bj=function(){return ui};
R.J9=function(a){return 0==this[xc]?{Z:a.t[G],direction:1}:{Z:a.t[kd],direction:-1}};function hY(a,b,c,d,e){this.sr=this.eP=this.OX=this.gf=this.td=this.Pe=this.lg=this.sb=null;this.fx=1;this.iP=null;AX[L](this,a,b,c,d,e)}W(hY,AX);R=hY[K];
R.HI=function(){return[U(function(){var a=this[Nr];this.Jt=fp(a,lD,pp)!=O;this.R.ai=ep(a,fI,rNa,RI);if(this.R.ai==gK&&this.R.ab!=kh)throw m("Focus target "+this.R.ai+" is not supported for the chosen chart type.");this.R.kd=Lo(this[Nr],ata);this.R.ab==oK?this.sr=new vX(this.Sb,this[Nr],this.mc,this.R):(this.sb=a.Q(mJ,VW),RQa(this));a=0<this.R.Pf.bars||0<this.R.Pf.area||0<this.R.Pf.steppedArea;this.R.Rd=Lo(this[Nr],iH)&&a;this.R.o6=Lo(this[Nr],Boa,!1)},this),U(this.Gna,this),U(AX[K].HI,this)]};
function RQa(a){var b=a.R,c=a.Sb,d=b.ab==OE?function(){return OE}:b.ab===yH?function(){return JK}:U(function(a){return ep(this[Nr],EE+a+nDa,cNa,b.eW)},a),d=b.kd?SQa(c,d,b.ab):TQa(c,d);b.Ga=[];b.lr={};for(var e=d.rk,f=0;f<c.O();f++){var g=c.ym(f),k=c[I](f,0),l=wj(e,function(a){return c.Ca(f,a.ia[BB][0])||M}),k={data:k,hu:l,Ht:g};if(l=e[0].ia.tooltip)k.de=iY(a,l[0],f);b.Ga[B](k);b.lr[g]=f}b.g=[];for(f=0;f<d.JX[J];f++)e=UQa(a,f,d.JX[f]),b.g[B](e),hk(c.Ur(f))||vq(b.g[f],c.Ur(f));b.kp=d.C7;b.rk=d.rk;b.Vt=
d.Vt;b.WF={};b.Pf={};a.OX=new hl;a.eP=[];for(f=0;f<b.g[J];++f){d=b.g[f];a.OX.add(d.Td);e=b.WF[d.Td];if(null==e)b.WF[d.Td]=d[TA];else if(e!=d[TA])throw m("All series on a given axis must be of the same data type");b.Pf[d[H]]=(b.Pf[d[H]]||0)+1;e=a.eP[d.Td]||{};a.eP[d.Td]=e;e[d[H]]=(e[d[H]]||0)+1}}
function VQa(a){var b={},c=a.R;c.Tn=[];var d=U(function(a){var d=c.g[a];if(c.kd&&d[H]===OE){var g=[this[Nr].Q(LI,.5),this[Nr].Q(MI,1)],k=d[F][F];c.Tn[B]({id:d.id,text:d.$z,brush:new lo({gradient:{kg:k,Nf:k,or:g[0],pr:g[1],x1:AM,y1:CM,Fb:CM,Kb:CM,nr:!0,vF:!0}}),index:a,W:d.aA})}else g=new lo({fill:d[F][F]}),d.JF&&g.Eg(d.JF),c.Tn[B]({id:d.id,text:d.$z,brush:g,index:a,W:d.aA});b[a]=!0},a);X(c.g,function(a,c){b[c]||(d(c),null!=a.xF&&d(a.xF))},a);c.kd&&c.g[0][H]===JK&&c.Tn[B]({id:-1,text:UAa,brush:new lo({fill:uNa[F]}),
index:-1,W:!0})}
function WQa(a,b){function c(a){return a=864E5*a+e}function d(a){a-=e;return a/864E5}for(var e=(new Date(1900,0,1,0,0,0))[jc](),f=new Lp(hDa),g=new Lp(BFa),k=new AMa(function(a){return 0!==a&&(1E5<h.abs(a)||.01>h.abs(a))?f[Rb](a):g[Rb](a)}),l=a.R,n=l.ab==OE?OE:OG,p=0,t=l[QB]===ui,u=l.g[J],x=0;x<u;x++){var A=l.g[x],C=ana+x+mf;if(null!=gp(a[Nr],ana+x)){p++;var E=ep(a[Nr],C+qi,$Ma,LG),Q=a[Nr].Q(C+oJ,uCa),N=Q===uCa;N&&(Q=A.Fg.fb());var N=Uo(a[Nr],[C+Rh,Rh],N?.5:1),S=So(a[Nr],[C+tF,tF],0),T=0<S;0>=S&&
(S=6);S/=2;0<S&&(S+=1);var V={};null!=A.ia[Y]&&pa(V,A.ia[Y]);var sa=So(a[Nr],[C+MG,MG],2);ep(a[Nr],C+YI,TW,O);Lo(a[Nr],C+NC,!1);var Q=JV(Q),E=aNa[E],Ha=(t?a.Pe:a.lg)[0],Ka=(t?a.lg:a.Pe)[A.Td];if(Ha[H]===ti){var Ra=Ha.ga,Sd=Ka.ga,Db=A.ia[Y][0],Ec=Kk,Zd=Kk;0<b.O()&&Qi(b[I](0,0))&&(Ec=d,Zd=c);var Ha={min:Ec(Ra.ee),max:Ec(Ra.oe)},Xb=E(b.O(),function(a){a=b[I](a,0);a=KW(Ra,a);return Ec(a)},function(a){return KW(Sd,b[I](a,Db))},{range:Ha,IA:Po(a[Nr],C+$va,3),oW:{transform:function(a){a=Zd(a);return Ra.Lt[AC](a)},
inverse:function(a){return Ec(Ra.Lt[NA](a))}}});if(null!==Xb){E=Wo(a[Nr],C+qD,k.C(Xb.mu.Jm())||sAa+p);Ha=wj(Xb[Y],function(a){var b=Zd(a[0]),b=null!=b?Ra.pG(b):null;a=a[1];a=null!=a?Sd.pG(a):null;return[b,a]});A.xF=l.g[J];Ka=to(Q[F],sa);mo(Ka,N);var sd=so(Q[F]);sd.Eg(N);var gf=Wo(a[Nr],C+bH,E);Lo(a[Nr],C+Coa,!1)&&(gf+=Je+k.C((new OW([new RW([new SW(Wh),new PW(2)]),new PW(Xb.Ep)])).Jm()));Xb=!1!==a[Nr].Q(C+wu);l.g[B]({id:A.id+Xza,title:E,jg:!0,data:Ha,dataType:A[TA],Zg:Lo(a[Nr],[C+AI,AI],!0),xM:Xb,
W:!0,Ht:0,ia:V,z6:x,Ve:A.Ve,wf:null,color:Q,JF:N,Fg:sd,Hc:Ka,rw:null,HF:null,type:n,rF:Po(a[Nr],C+sma,0),lineWidth:sa,$c:S,b6:12,ww:ep(a[Nr],C+YI,TW,O),zM:So(a[Nr],[C+YD,YD],1),wM:T,l:[],NV:[],Td:A.Td,aA:Lo(a[Nr],C+NC,!1),$z:gf})}}}}}
function TQa(a,b){for(var c=[],d=[],e=null,f=null,g=0,k=[],l=0;l<a.L();++l){var n=a.G(l),p=a.gj(l,Zh)||(0==l?At:Wg);if(0==l&&p!==At)throw m(ABa);if(p==At){if(0<g)throw m(mAa+l+ef);e={ia:{},dataType:n};f={$b:null,Ve:d[J]};d[B](e)}0==g&&p===Wg&&(f=c[J],g=b(f),e={type:g,dataType:n,ia:{}},f={$b:f,Ve:null},c[B](e),g=g===iK?4:1);if(p===Wg&&(g--,n!==e[TA]))throw m(bCa);if(p===wu&&e.ia[p])throw m(ZAa);e.ia[p]=e.ia[p]||[];k[B]({$b:f.$b,Ve:f.Ve,kl:p,EA:e.ia[p][J]});e.ia[p][B](l)}if(0<g)throw m(gBa+g+ef);e=
0;n=d[0][TA];for(l=0;l<c[J];++l){if(d[J]<=e)throw m("Series #"+l+OFa);p=d[e+1];f=c[l].ia[Y];if(p&&p.ia[BB][0]<=f[0]&&(++e,n!==d[e][TA]))throw m(aCa);c[l].Ve=e}return{JX:c,rk:d,Vt:n,C7:k}}function XQa(a,b){if(a!==b)throw m("Column types must be consistent: equal for domain columns and for columns in the same serie.");}
function SQa(a,b,c){var d=[],e=[],f=null,g=[];if(c===OE){for(var k=a.L()-2,l=function(a){if(a!==Wg&&a!==RF)throw m("All columns must be either data or old-data columns");},n={data:null,"old-data":null},f=a.G(0),p=0;2>p;++p){var t=a.G(p);c=a.gj(p,Zh);l(c);XQa(f,t);t={ia:{},dataType:t};Wy(t.ia,[p]);e[B](t);n[c]=p;g[B]({Ve:p,kl:At,EA:0,$b:null})}for(p=0;p<k;++p){var u=2+p,t=a.G(p);c=a.gj(p,Zh);l(c);p%2&&XQa(d[p-1][TA],t);var x=n[c],t={type:b(p),dataType:t,Ve:x,ia:{}};t.ia[c]=[u];d[B](t);g[B]({Ve:x,kl:c,
EA:0,$b:p})}}else if(c===kh){k=f=null;for(p=l=0;p<a.L();++p){t=a.G(p);c=a.gj(p,Zh)||(0===p?At:Wg);if(0===p&&c!==At)throw m(ABa);if(c===At){if(0<l)throw m(mAa+p+ef);f={ia:{},dataType:t};k={$b:null,Ve:e[J]};e[B](f)}0!==l||c!==Wg&&c!==RF||(k=d[J],l=b(k),f={type:l,dataType:t,ia:{}},k={$b:k,Ve:null},d[B](f),l=l===iK?4:c===RF?2:1);if(c===Wg||c===RF)if(l--,t!==f[TA])throw m(bCa);if(c===wu&&f.ia[c])throw m(ZAa);f.ia[c]=f.ia[c]||[];g[B]({$b:k.$b,Ve:k.Ve,kl:c,EA:f.ia[c][J]});f.ia[c][B](p)}if(0<l)throw m(gBa+
l+ef);a=0;f=e[0][TA];for(p=0;p<d[J];++p){if(e[J]<=a)throw m("Series #"+p+OFa);b=e[a+1];c=d[p].ia[RF]||d[p].ia[Y];if(b&&b.ia[BB][0]<=c[0]&&(++a,f!==e[a][TA]))throw m(aCa);d[p].Ve=a}}return{JX:d,rk:e,Vt:f,C7:g}}R.WG=function(a){a=a.ia[RF];return null!=a&&0<a[J]};
function UQa(a,b,c){var d=c[H],e=c.ia,f=c.Ve,g=a[Nr],k=EE+b+mf,l=d+mf,n=e[Y]||e[RF],p=a.Sb.pH(n[0]),t=a.Sb.La(n[0])||M,u=d==OE?0:2,x=So(g,[k+tF,tF],d==OE?7:0),A=d==OG||d==Hg||d==OE?0<x:!0;0==x&&(x=d==OE?7:6);x/=2;0<x&&(x+=1);b=g.Q(k+oJ,a.sb[(a.R.kd&&d==OE?h[Eb](b/2):b)%a.sb[J]]);b=JV(b);var C=null;if(d==Hg||d==RD)C=Uo(g,[k+TK,TK]),C=so(b[F],C);var E=null;if(d==iK)var E=new lo({stroke:b[F],strokeWidth:2,fill:b[F]}),Q=new lo({stroke:b[F],strokeWidth:2,fill:Re}),N=Lo(g,Vxa),S=N?E:Q,E={O6:hp(g,[k+Uxa,
Uxa],N?Q:E),N6:hp(g,[k+Wxa,Wxa],S)};u=So(g,[k+MG,MG],u);Q=to(b[F],u);if(N=g.Q([k+jsa,jsa],null,Oo))Q.wl=N;l=So(g,[k+TI,l+TI,TI],1);N=null;if(d===OE||d===OG||d===Hg)N=gp(g,[k+Gqa,Gqa],{type:NJ}),Si(N)&&(N={type:N});S=null;if(a.R.kd&&d===OE){var T=a.WG(c),l=T?a[Nr].Q(LI,.5):a[Nr].Q(MI,1);T&&(S=!1)}T=d==RD?C:so(b[F],l);if(a.R.kd)if(d===JK)var V=g.Q(Sva,uNa),V=JV(V),V={background:{Fg:so(V[F],l)}};else d===OE&&a.WG(c)&&(A=!1);var sa=YQa(a,e,g,k,b),Ha=!1!==a[Nr].Q(k+wu);return{id:a.Sb.Ee(n[0]),title:t,
dataType:c[TA],W:!0,xM:Ha,Ht:p,ia:e,Ve:f,Zg:Lo(g,[k+AI,AI],!0),wf:sa,color:b,JF:l,Fg:T,Hc:Q,EF:N,zh:V,rw:C,HF:E,type:d,rF:Po(g,k+sma,0),lineWidth:u,$c:x,b6:12,ww:ep(g,[k+YI,YI],TW,O),zM:So(g,[k+YD,YD],1),wM:A,l:[],NV:[],Td:So(g,[k+zD,zD],0),aA:null!=S?S:Lo(g,k+NC,!0),$z:Wo(g,k+bH,t)}}
function YQa(a,b,c,d,e){function f(a,b){return g(a,b)[Hb]([d+b,b])}function g(a,b){return[d+cta+a+mf+b,d+bta+b,cta+a+mf+b,bta+b]}var k=b[Mb];if(!k)return null;b={Bb:[],hy:[],sQ:[],l:[],areas:[],I:[],$F:{}};for(var l={},n=0;n<k[J];n++){var p=k[n],t=a.Sb.Ee(p)||a.Sb.La(p)||PI,u=fp(c,g(t,ji),dNa);switch(u){case JK:b.Bb[B](p);break;case Yna:b.hy[B](p);break;case dya:b.sQ[B](p);break;case rF:b.l[B](p);break;case Hg:b[yC][B](p);break;case OG:b.I[B](p);break;case O:break;default:throw m("Invalid interval style: "+
u);}t in l?l[t][B](p):l[t]=[p]}1<b.Bb[J]&&0==b.hy[J]&&(b.hy=[b.Bb[0],b.Bb[b.Bb[J]-1]]);if(0!=b.hy[J]%2)throw m("Stick-intervals must be defined by an even number of columns");if(0!=b[yC][J]%2)throw m("Area-intervals must be defined by an even number of columns");for(t in l){u=So(c,g(t,MG));n=Uo(c,g(t,iI));p=$o(c,g(t,oJ),ek(eNa),M);p=ZQa(p,e);n=new lo({stroke:p,fill:p,fillOpacity:n,strokeWidth:u});p=So(c,g(t,rya));a=So(c,g(t,Ioa));var k=So(c,g(t,eya)),x=So(c,g(t,tF)),u=fp(c,g(t,ji),dNa),A=Lo(c,f(t,
lH)),C=ep(c,f(t,YI),TW,O),E=So(c,f(t,YD),1),u={style:u,brush:n,Wla:p,Yla:a,Xla:k,$M:x,xj:A,ww:C,zM:E};a=l[t];for(n=0;n<a[J];++n)p=a[n],b.$F[p]=u}return b}
R.Gna=function(){var a=this.R;switch(a.ab){case kh:case yH:dz(a,ep(this[Nr],KF,jNa,M));if(!a[QB])throw m("Unspecified orientation.");this.gf={};this.lg={};this.Pe={};var b,c,d,e;switch(a[QB]){case th:d=dY;e=this.lg;b=gY;c=this.Pe;break;case ui:d=gY,e=this.Pe,b=dY,c=this.lg}for(var f=this.OX.Qa(),g=0;g<f[J];++g){var k=f[g],l=new b(a,this[Nr],[Qna+k,gu],k,ti,oF);if(l[H]!=ti)throw m("Target-axis must be of type value");this.gf[k]=l;c[k]=l}var n;a.ab===yH&&(n=a.g[0][tb].histogramBuckets);b=d;c=this[Nr];
if(this.Sb.G(0)==ii)i:{switch($Qa(this)){case Hg:d=1<this.R.Ga[J]?fK:gK;break i;case OG:case JK:case RD:case iK:d=gK;break i}d=null}else d=ti;this.td=new b(a,c,[Bt],0,d,rG,n);e[0]=this.td;break;case OE:case oK:this.lg={0:new dY(a,this[Nr],[],0,ti,oF)},this.Pe={0:new gY(a,this[Nr],[],0,ti,oF)}}aRa(this)};function $Qa(a){var b=[OG,Hg,RD,JK,iK],c={};X(b,function(a,b){c[a]=b});a=xj(a.R.g,function(a,b){return h.max(a,c[b[H]])},0);return b[a]}
function aRa(a){var b=a.R;switch(b.ab){case OE:case oK:if(b.Vt==ii)throw m("X values column cannot be of type string");var c=b.WF[0];if(c==ii)throw m("Data column(s) cannot be of type string");var d=a.lg[0],e=a.Pe[0];if(d[H]!=ti)throw m("The x-axis must be of type value");YX(d,b.Vt,a[Nr]);if(e[H]!=ti)throw m("The y-axis must be of type value");YX(e,c,a[Nr]);break;case kh:case yH:c=a.td;if(c[H]==ti){if(b.Vt==ii)throw m("Domain column cannot be of type string, it should be the X values on a continuous domain axis");
YX(c,b.Vt,a[Nr])}Zj(a.gf,function(a,c){var d=b.WF[c];if(d==ii)throw m("Data column(s) for axis #"+c+" cannot be of type string");YX(a,d,this[Nr]);d=this.eP[c];null===a.Ar&&(0<d.bars||0<d.area||0<d.steppedArea)&&(a.Ar=0)},a)}Zj(a.lg,function(a){jQa(a)});Zj(a.Pe,function(a){jQa(a)})}
function bRa(a){if(null===cRa(a))return[];for(var b=(a.R.rk[0].ia[BB]||[])[0],c=[],d=null,e=a.Sb,f=0;f<e.O();f++){var g=e[I](f,b),k=jY(a,f);if(null!==d&&null!=k){if(0>k)throw m("Invalid gap value ("+k+") in data row #"+f+". Gap value must be non-negative.");c[B]({Lc:d,te:g,Gla:k})}d=g}return c}R.f9=function(){return this.sr&&this.sr.op==Nh?null:null!=this.Pe[0]&&null!=this.Pe[1]?kD:null!=this.Pe[1]?Ch:au};R.e9=function(){return this.sr&&this.sr.op==Nh?kD:null};
function kY(a){var b=a.ia[Y];return b?b[0]:a.ia[RF][0]}function dRa(a){for(var b=a.R,c=a.Sb,d=a.td,e=0;e<b.Ga[J];e++){for(var f=0;f<b.g[J];f++){var g=b.g[f],k=a.gf[g.Td],g=c[I](e,kY(g)),g=KW(k.ga,g);null!=g&&wX(k,g)}d[H]==ti&&(f=c[I](e,0),f=KW(d.ga,f),wX(d,f))}}function eRa(a){var b=a.R,c=a.Sb,d=a.lg[0];a=a.Pe[0];for(var e=0;e<c.O();e++)for(var f=0;f<b.g[J];f++){var g=b.g[f],k=kY(g),g=c[I](e,b.rk[g.Ve].ia[BB][0]),k=c[I](e,k),g=KW(d.ga,g),k=KW(a.ga,k);null!=g&&wX(d,g);null!=k&&wX(a,k)}}
R.d9=function(){var a;return[U(function(){a=this.jp()},this),U(this.Cha,this),U(function(){(a.Rd||a.kd||a.ab===yH)&&Zj(this.gf,function(a){a.pc(0)})},this),U(function(){if(a.ab===kh||a.ab===yH)dRa(this),this.td[H]==ti&&this.td.zA(bRa(this)),ZX(this.td,this[Nr]),Zj(this.gf,function(a){a.zA();ZX(a,this[Nr])},this);else{var b=this.lg[0],c=this.Pe[0];a.ab==oK?cPa(this.sr,b,c):a.ab==OE&&eRa(this);b.zA();ZX(b,this[Nr]);c.zA();ZX(c,this[Nr])}},this),U(function(){a.Pf.bars&&fRa(this,JK);if(a.Pf.steppedArea){if(this.td[H]==
ti)throw m("Stepped area series with value domain axis is not supported.");fRa(this,RD)}a.Pf.candlesticks&&gRa(this);if(a.Pf[nC]){for(var b=this.R,c=0;c<b.g[J];c++)hRa(this,c);iRa(this);jRa(this);kRa(this)}a.Pf.area&&lRa(this);if(a.Pf.scatter){b=this.R;for(c=0;c<b.g[J];c++)mRa(this,c);jRa(this);kRa(this)}if(a.Pf.bubbles){for(var b=this.sr,d=this.lg[0],e=this.Pe[0],f=this.Aj,c=0;c<b.ah.O();c++){var g;t:{g=b;var k=d,l=e,n=c,p=g.ah,t=p[I](n,g.PV),u=p.Ca(n,g.PV),x=p[I](n,g.sF),A=p[I](n,g.tF),C=null;if(null!=
g.jr&&(C=p[I](n,g.jr),null==C)){g=null;break t}var E=null;if(null!=g.kr&&(E=p[I](n,g.kr),null==E)){g=null;break t}p=g.Sd(u,g.Ma)[r];if(g.op==Nh)g.RV=ho(g.RV,C);else if(g.op==ii){var Q=C,N=g.eA[Q];if(!N){var N=EE+Q+mf,S=Zo(g.b,N+oJ,g.TV[g.fA[J]%g.TV[J]]),S=JV(S),T=Lo(g.b,N+NC,!0),N=Wo(g.b,N+bH,Q),N={color:S[F],aA:T,$z:N};g.eA[Q]=N;g.fA[B](Q)}}g.UV=ho(g.UV,E);x=JW(k.ga,x);A=JW(l.ga,A);null===x||null===A?g=null:(bY(k,x)&&bY(l,A)&&(k.pc(x),l.pc(A)),k=g.XV(n,u),g={id:t,text:u,vha:p,ba:g.Ma,de:k,yf:{x:x,
y:A,color:C,size:E}})}b.il.g[0].l[B](g)}if(b.op==Nh)b.hr=YJa(b.b,b.RV),f.e6(b.hr);else if(b.op==ii)for(c=0;c<b.fA[J];c++)d=b.fA[c],e=b.eA[d],e.aA&&b.il.Tn[B]({index:c,id:d,text:e.$z,brush:new lo({fill:e[F]}),W:!0});b.qF=FLa(b.b,b.UV);b.wha&&X(b.il.g[0].l,b.zha,b)}},this),U(function(){(a.Pf.bars||a.Pf.candlesticks)&&a.ab!==yH&&this.td&&this.td[H]==ti&&nRa(this)},this),U(function(){a.rd=ak(this.lg,function(a){return a.cW(this.R,this.xf,this.Aj)},this);a.Zc=ak(this.Pe,function(a){return a.cW(this.R,
this.xf,this.Aj)},this)},this),U(this.Bha,this),U(this.Aha,this),U(this.Dha,this),U(function(){(a.ab===kh&&a[QB]===th||a.Pf.bars)&&oRa(this)},this),U(function(){var b=this.xf[UA](),c=this.xf.Ma[Gc],d=null;b!=au&&b!=aH||null!=this.Pe[1]||(d=new um(a.t.top,a[r]-c,a.t[Uc],a.t[kd]+c));b!=Ch||null!=this.Pe[0]||(d=new um(a.t.top,a.t[G]-c,a.t[Uc],c));d&&d[kd]>=d[G]&&this.xf.lp(d)},this),U(this.Eha,this),U(function(){this.sr||(WQa(this,this.Sb),VQa(this),pRa(this))},this)]};
R.Cha=function(){var a=this.R,b=this.mc,c=dk(this.lg)[bC].ba,d=h.max(a[bC].ba[Gc],c[Gc]),e=this.xf.Ma[Gc],f=this.xf[UA](),g=this.Aj.Ma[Gc],k=this.Aj[UA](),l=a.gA==pH?a[bC][pd]:M,n=M,p=M;if(a.uF==pH){var t=function(a){var b=fk(a);Qj(b);b=wj(b,function(b){return a[b][bC][pd]});return vj(b,function(a){return a!=M})[Fe](kf)};switch(a.ab){case OE:case oK:n=t(this.lg);p=t(this.Pe);break;case kh:n=t({0:this.td}),p=t(this.gf)}}var n=n&&p?n+UFa+p:n?n:p?p:M,p=h.max(2,h[D](d/1.618)),u=h.max(2,h[D](e/1.618)),
x=h.max(2,h[D](g/1.618)),A=a.t[r]-2*p,g=fT(b,l,a[bC].ba,A,1),t=0<g.I[J]?g.I[0]:M,C=b(t,a[bC].ba)[r],E=h[D](h.max(2,1.618*d)),A=h.max(A-C-E,0),b=fT(b,n,c,A,1),E=0<b.I[J]?b.I[0]:M,Q=[];Q[B]({key:tK,min:2,Ub:[da]});(t||E)&&Q[B]({key:qD,min:d+2,Ub:[p-2]});f==pH&&Q[B]({key:XG,min:e+2,Ub:[u-2]});k==pH&&Q[B]({key:nJ,min:this.Aj[JB]()+2,Ub:[x-2]});f=lV(Q,h[Eb](a.t[z]/2));d=a.t.top;k=f[bC]||[];0<k[J]&&(d+=k[0],t&&(a[bC].I[B]({text:t,x:a.t[G]+p,y:d,length:C}),a[bC].rb=g.re?l:M),E&&(a.KF={text:n,ba:c,gr:null,
I:[],Gc:zI,Fc:zI,rb:b.re?n:M,anchor:null,Eb:0},a.KF.I[B]({text:E,x:a.t[kd]-p,y:d,length:A})));c=f.legend||[];0<c[J]&&(d+=c[0],this.xf.lp(new um(d-e,a.t[kd],d,a.t[G])));e=f.colorBar||[];0<e[J]&&(d+=e[0],a=new um(d-this.Aj[JB](),a.t[kd],d,a.t[G]),this.Aj.lp(a))};function fRa(a,b){var c=a.R;c.kd?qRa(a,b):rRa(a,b,c.Rd)}
function nRa(a){var b=a.td,c=vj(a.R.Ga,function(a,b){return 0!=jY(this,b)},a),d=da,e;X(c,function(a){a=JW(b.ga,a[Y]);Gi(e)&&(d=h.min(d,h.abs(a-e)));e=a},a);Wk(d)&&(a=d/2,b.pc(b.ga.ee-a),b.pc(b.ga.oe+a))}
function rRa(a,b,c){var d=a.R,e=a.Sb,f=a.td,g=a.R.ab===yH,k=(d.t[z]-1)/sRa(c,d,e);a.R.Iw=g&&tRa(k,Lo(a[Nr],xH));for(var l=0;l<d.Ga[J];l++)for(var k=0==jY(a,l),n=ak(a.gf,function(){return[0,0]}),p=-1,t=0;t<d.g[J];t++){var u=d.g[t];if(u[H]==b){p++;0==c&&(n[u.Td]=[0,0]);var x=u.l;if(k)x[B](null);else{var A=u.Td,C=a.gf[A],E=e[I](l,u.ia[Y][0]),E=JW(C.ga,E),Q=lY(a,l);f.pc(Q);var N=0<E?0:1,S=n[A];bY(f,Q)&&(c?C.pc(E+S[N]):C.pc(E));c||(a.fx=h.max(a.fx,p+1));var A=function(a,b,c,d){b={yf:{au:l,hB:b,from:c,
pl:a+(d||g?S[N]:0),tl:Q,sG:mY(this,u,l,S[N],!0)}};null==a&&(b.df=!0);u[H]==RD&&(c=x[J],b.yf.e7=0!=c&&x[c-1]?x[c-1].yf.pl:null);nY(this,b,u,t,l);x[B](b);S[N]+=a},C=c?0:p,T=c||g?S[N]:null;if(g&&!a.R.Iw)for(var V=0;V<E;V++)T=c||g?S[N]:null,A[L](a,1,C,T,c);else A[L](a,E,C,T,c)}}}c||Zj(a.gf,function(a){AQa(a)})}
function qRa(a,b){for(var c=a.R,d=a.Sb,e=a.td,f=vj(c.g,function(a){return a[H]==b}),g=0;g<c.Ga[J];++g){var k=0==jY(a,g),l=lY(a,g);e.pc(l);for(var n=bY(e,l),p=[RF,Wg],t=0;t<f[J];++t){var u=f[t];if(k){u.l[B](null);return}for(var x=a.gf[u.Td],A=x.ga,C=0;C<p[J];++C){var E=p[C],Q=d[I](g,u.ia[E][0]),Q=JW(A,Q);if(null===Q){u.l[B](null);return}n&&x.pc(Q);a.fx=h.max(a.fx,t+1);E={brush:E==RF?u.zh[iC].Fg:null,yf:{au:g,hB:t,from:null,pl:Q,tl:l,vja:E==Wg,sG:mY(a,u,g,0,!0)}};nY(a,E,u,t,g);u.l[B](E)}}}Zj(a.gf,function(a){AQa(a)})}
function gRa(a){var b=a.R,c=a.Sb,d=a.td,e=vj(b.g,function(a){return a[H]==iK});X(b.Ga,function(a,b){var k=0==jY(this,b);X(e,function(a,e){if(k)a.l[B](null);else{var f=a.ia[Y],t=this.gf[a.Td];this.fx=h.max(this.fx,e+1);var u=c[I](b,f[0]),x=c[I](b,f[1]),A=c[I](b,f[2]),f=c[I](b,f[3]),u=JW(t.ga,u),x=JW(t.ga,x),A=JW(t.ga,A),f=JW(t.ga,f);if(null===u||null===f||null===x||null===A)a.l[B](null);else{var C=lY(this,b);d.pc(C);var E=A<x;bY(d,C)&&(t.pc(u),t.pc(f));t={rA:E?a.HF.N6:a.HF.O6,Hc:so(a[F][F]),yf:{au:b,
hB:e,ika:u,lineTo:f,jka:E?A:x,kka:E?x:A,hka:E,tl:C}};nY(this,t,a,e,b);a.l[B](t)}}},this)},a)}function hRa(a,b){var c=a.R,d=a.Sb,e=a.td,f=c.g[b];if(f[H]==OG)for(var c=f.jg?f[Y]:c.Ga,g=0;g<c[J];g++){var k=a.gf[f.Td],l=f.ia[Y][0],l=f.jg?f[Y][g][1]:d[I](g,l),l=JW(k.ga,l),n;if(null!=l){var p=lY(a,g,f);e.pc(p);(n=bY(e,p)&&!f.jg)&&k.pc(l);k=f.jg?null:mY(a,f,g,0,n)}else n=!1,k=null;k={yf:{au:g,hB:0,tl:p,ax:l,sG:k},shape:f.EF,o7:n};null==l&&(k.df=!0);nY(a,k,f,b,g);f.l[B](k)}}
function iRa(a){for(var b=a.td,c=a.R.g,d=0;d<c[J];d++){var e=c[d];if((e[H]==OG||e[H]==Hg)&&0!=e[jB]){var f=a.gf[e.Td],g=wj(e.l,function(a){return!a||a.df?null:new xl(a.yf.tl,a.yf.ax)}),k=a.R.xj,e=rV(g,yQa(b),k),l;t:{switch(b[H]){case fK:l=b.ib.max-1;break t;case gK:l=b.ib.max-.5;break t}l=b.ib.max}k=rV(g,l,k);f.pc(e);f.pc(k)}}}
function lRa(a){for(var b=a.R,c=a.Sb,d=a.td,e=b.xj,f=0;f<b.Ga[J];f++)for(var g=ak(a.gf,function(){return 0}),k=mk(g),l=mk(g),n=0;n<b.g[J];n++){var p=b.g[n];if(p[H]==Hg){var t=p.Td,u=a.gf[t],x=null,A=null,C=p.ia[Y][0],E=c[I](f,C),E=JW(u.ga,E),Q=lY(a,f),N;if(null==E||fa(E))b.Rd&&(x=k[t],A=g[t]),t={r7:Q,s7:x,p7:Q,q7:A,v7:Q,w7:A,t7:Q,u7:x},N=!1;else{var S,T;N=0<f?c[I](f-1,C):null;var V=f<c.O()-1?c[I](f+1,C):null;b.Rd?(C=E+l[t],x=k[t],A=g[t],S=k[t]+E,T=g[t]+E,f==c.O()-1||null!==V&&!fa(V)?k[t]+=E:S=k[t],
0==f||null!==N&&!fa(N)?g[t]+=E:T=g[t]):(S=T=C=E,f==c.O()-1||null!==V&&!fa(V)?S=C:e||(S=null),0==f||null!==N&&!fa(N)?T=C:e||(T=null));d.pc(Q);(N=bY(d,Q))&&u.pc(C);u=mY(a,p,f,l[t],N);b.Rd&&(l[t]=C);t={tl:Q,ax:C,au:f,hB:0,v7:Q,w7:T,t7:Q,u7:S,r7:Q,s7:x,p7:Q,q7:A,sG:u}}t={yf:t,shape:p.EF,o7:N};nY(a,t,p,n,f);if(null==E||fa(E))t.df=!0;p.l[B](t)}}iRa(a);jRa(a)}function pRa(a){X(a.R.g,function(a,c){a.jg&&(a[H]===OE?mRa(this,c):a[H]===OG&&hRa(this,c),uRa(this,c))},a)}
function mRa(a,b){var c=a.R,d=a.Sb,e=a.lg[0],f=a.Pe[0],g=c.g[b],k=g.Ve;if(g[H]===OE)for(var l=g.jg?g[Y][J]:d.O(),n=0;n<l;n++){var p=c.rk[k].ia[BB][0],t=kY(g),p=g.jg?g[Y][n][0]:d[I](n,p),u=g.jg?g[Y][n][1]:d[I](n,t),t=JW(e.ga,p),p=JW(f.ga,u);if(null===t||null===p)g.l[B](null);else(u=bY(e,t)&&bY(f,p))&&!g.jg&&(e.pc(t),f.pc(p)),t={yf:{x:t,y:p},shape:g.EF,pja:u},nY(a,t,g,b,n),g.l[B](t)}}
function jRa(a){function b(a){return!(!a||a.df)}for(var c=U(function(a){var b=null!=a.yf?a.yf.au:null;return{px:null!=a.px?a.px:1,Kx:null!=a.Kx?a.Kx:1,scope:null!=a[us]?a[us]:!0,fma:null!=b?jY(this,b):null}},a),d=null===cRa(a),e=0;e<a.R.g[J];e++){var f=a.R.g[e],g=f.rw,k=f.ia.emphasis||[],l=f.ia[us]||[];if(0!=(f.ia.certainty||[])[J]||0!=k[J]||0!=l[J]||!d)for(var k=Cj(f.l,b),n=c(k||{}),l=0;l<f.l[J];l++){var p=f.l[l];if(p&&!p.df){var t=c(p),u=f.Hc;t[us]||n[us]||(f.E$=f.E$||u.VH(),u=f.E$,p.ms=u,g&&(f.D$=
f.D$||g.VH(),p.NF=f.D$));if(1>t.px||1>n.px)u=vRa(u,!1),p.ms=u;1!=t.Kx&&1!=n.Kx&&(n=h.min(n.Kx,t.Kx),u=wRa(u,n),p.ms=u);0==t.fma&&k&&!k.df&&(p.ms=null);n=t}k=p}}}
function xRa(a){var b={fill:{},stroke:{},shape:{}};null!=a&&(null!=a[TB]&&gz(b,a[TB]),null!=a[EA]&&xy(b,a[EA]),null!=a[F]&&Ya(b[nc],Ya(b[ec],a[F])),null!=a[fe]&&qb(b[nc],qb(b[ec],a[fe])),null!=a[Ez]&&Ya(b[nc],a[Ez]),null!=a[Yd]&&qb(b[nc],a[Yd]),null!=a[dA]&&Ya(b[ec],a[dA]),null!=a[pc]&&qb(b[ec],a[pc]),null!=a[Od]&&na(b[ec],a[Od]),null!=a.shapeType&&db(b[Dz],a.shapeType),null!=a.shapeSides&&(b[Dz].sides=a.shapeSides),null!=a.shapeRotation&&(b[Dz].rotation=a.shapeRotation),null!=a.shapeDent&&(b[Dz].dent=
a.shapeDent));return b}function yRa(a,b,c){var d=void 0;b=null!=b.ia[w]?b.ia[w][0]:void 0;if(null!=b&&a.Sb.G(b)===ii&&(a=a.Sb[I](c,b),null!=a)){var e,d=ej(a);if(wn(d))e={fill:{color:d},stroke:{color:d}};else if(d[Ib](0)===Bi){try{var f=Jn(d)}catch(g){}null!=f&&(e=f)}null==e&&(gj(d,Bi)?(e=ak(zNa(d),xRa),M in e&&(pk(e,e[M]),ik(e,M)),ff in e&&(pk(e,e[ff]),ik(e,ff))):e=xRa(gn(d)));d=e}if(null!=d)return new Do([d])}
function nY(a,b,c,d,e){a.Jt&&(b.de=zRa(a,c,d,e));var f=yRa(a,c,e);d=ARa(a,c,e);var g=BRa(a,c,e);a=CRa(a,c,e);e=rX(b,c);var k=c.Fg;if(null!=f){var k=k[Jc](),l=function(a,b,c){b=b||M;c!==ND&&(a.Ne(Zo(f,[b+lI,b+nI],a.fb())),a.Eg(Uo(f,b+kI,a.Oe)));c!==nI&&(a.ld(Zo(f,[b+KD,b+ND],a.pe)),mo(a,Uo(f,b+JD,a.pi)),a.mk(Po(f,b+ID,a.Lb)))};Yy(b,e=So(f,Iqa,e));var n=gp(f,Jqa);null!=n&&(b.shape=n);n=Mo(f,Hqa);null!=n&&gz(b,n);l(k);switch(c[H]){case OG:case OE:case Hg:l(k,Kqa);null!=c.Hc&&(b.ms=(b.ms||b.Hc||c.Hc)[Jc](),
l(b.ms,null,ND),l(b.ms,NG,ND));null!=c.rw&&(b.NF=(b.NF||b.Hc||c.rw)[Jc](),l(b.NF,null,nI),l(b.NF,Gya,nI));break;case RD:l(k,Gya,nI),null!=c.Hc&&(b.Hc=(b.Hc||c.Hc)[Jc](),l(b.Hc,null,ND),l(b.Hc,NG,ND));case JK:l(k,sya);break;case iK:b.rA=b.rA[Jc](),l(b.rA),l(b.Hc),l(b.rA,sya),l(b.Hc,NG)}b.brush=k}a||(b.scope=a,c.Rba=c.Rba||k.VH(),k=c.Rba,b.brush=k);1!=g&&(b.Kx=g,c[H]==OG||c[H]==Hg||c[H]==OE)&&(e=h[D](e*h[Kd](g)*10)/10,Yy(b,e));if(1>d)switch(b.px=d,c[H]){case OG:case Hg:case OE:b.brush=vRa(k,!0);Yy(b,
h.max(e-no(b.brush)/2,0));break;case JK:case RD:b.brush=vRa(k,!1)}}function zRa(a,b,c,d){c=a.XV(b,c,d);var e=b.ia.tooltip;e&&!b.jg&&(a=iY(a,e[0],d))&&pk(c,a);c.ul=!!c.ul;return c}function iY(a,b,c){var d=a.Sb;a=a.R.Fr&&(d[Bd](c,b,vh)||d.gj(b,vh));b=d.Ca(c,b);return{ul:!!a,ii:b?!0:!1,content:b}}
R.XV=function(a,b,c){if(this.R.ab===OE||a.jg){var d=this.Sb,e=this.R,f,g,k,l;if(a.jg)f=a[Y][c][0],g=a[Y][c][1],null!=f&&(f=gq(f,d.G(a.Ve))),null!=g&&(g=gq(g,a[TA])),k=e.ai===gK?g:f+kf+g,l=f;else if(this.R.kd){var n=this.lg[0][bC][pd]||mL,p=this.Pe[0][bC][pd]||gAa;k=b%2?b-1:b;b=e.g[k];k=e.g[k+1];f=e.rk[k.Ve].ia[BB][0];g=kY(k);f=d.Ca(c,f);g=d.Ca(c,g);k=n+kM+f+kf+p+kM+g;f=e.rk[b.Ve].ia[BB][0];g=kY(b);f=d.Ca(c,f);g=d.Ca(c,g);k+=Je+n+kM+f+kf+p+kM+g}else f=e.rk[a.Ve].ia[BB][0],g=kY(a),f=d.Ca(c,f),g=d.Ca(c,
g),k=f+kf+g;a={ii:!1,content:k,Dm:a[bC],Aw:l}}else a=DRa(this,a,c);return a};
function DRa(a,b,c){var d=a.Sb,e=a.R.Ga[c],e=b.jg?b[Y][c][0][qc]():e.hu[b.Ve];if(b[H]==iK){var f=b.ia[Y];a=d.Ca(c,f[0])+DN+d.Ca(c,f[3])+kf+d.Ca(c,f[1])+DN+d.Ca(c,f[2])}else if(a.R.kd){var g=b.ia[RF],f=b.ia[Y],k=a.Sb[I](c,g[0]);a=a.Sb[I](c,f[0]);g=d.Ca(c,g[0]);f=d.Ca(c,f[0]);if(null===k&&cj(g)&&null===a&&cj(f))return{ii:!1,content:null};a=f+Je+g}else{f=b.ia[Y];k=b.jg?b[Y][c][1]:a.Sb[I](c,f[0]);a=b.jg?b[Y][c][1][qc]():a.Sb.Ca(c,f[0]);if(null===k&&cj(a))return{ii:!1,content:null};k=b.ia[Mb]||[];k[J]&&
(k=wj(k,function(a){return d.Ca(c,a)}),a+=oha+k[Fe](kf)+Cg)}return{ii:!1,content:a,Aw:e,Dm:b[bC],ul:!1}}
function kRa(a){function b(a){return{tl:a.x,ax:a.y}}function c(a){return new oO(a.tl,a.ax)}function d(a){return{x:a.x,y:a.y}}function e(a){return new oO(a.x,a.y)}var f=a.R,g=a.td,k=U(function(a,b,c){b.pja&&(this.lg[0].pc(c.x),this.Pe[0].pc(c.y))},a);a=U(function(a,b,c){g.pc(c.tl);b.o7&&this.gf[a.Td].pc(c.ax)},a);var l,n,p;switch(f.ab){case OE:l=e;n=d;p=k;break;case kh:l=c,n=b,p=a}for(k=0;k<f.g[J];k++)if(a=f.g[k],a[H]==OE||a[H]==OG)if(Dj([kh,Sqa,qJ],a.ww)){var t=a[H]==OE&&a.ww==qJ,u=a.ww==kh;a.NY=
!0;a.lka=t;t=hV(wj(a.l,function(a){return!a||a.df?null:l(a.yf)}),a.zM,u,t,f.xj);for(u=0;u<a.l[J];++u){var x=a.l[u];if(t[u]){var A=n(t[u][0]),C=n(t[u][1]);x.o8=A;x.p8=C;p(a,x,A);p(a,x,C)}}}else a.NY=!1}
R.Aha=function(){if(this.R.ai==gK){var a=this.R.Ga,b=wj(a,function(a,b){return oY(this,b)},this),c=this.td,a=Wj(a[J]);Rj(a,U(function(a,c){return Pj(b[a],b[c])},this));var d=c.Se,e=c.cf;if(d>e)var f=d,d=e,e=f;for(var g,k,f=0;f<a[J];f++){var l=a[f];k=oY(this,l);if(null!=k){if($X(c,k))return;if(!(k*c[Cz]<c.Se*c[Cz])){g=f;break}}}if(Gi(g))for(var n=d,p,d=null,f=g;f<a[J];f++){null!=d&&f<d&&(f=d,d=null);l=a[f];g=n;if(f==a[J]-1){pY(this,l,g,e);break}p=oY(this,a[f+1]);if(null==p){for(n=f+2;n<a[J];n++)if(p=
oY(this,a[n]),null!=p){d=n;break}if(null==p){pY(this,l,g,e);break}}if($X(c,p)){pY(this,l,g,e);break}n=Uk(k,p);pY(this,l,g,n);k=p}}};function oY(a,b){var c=a.R.Ga,d=a.td;return d[H]==ti?null!=c[b][Y]?d.aI(c[b][Y]):null:d.De(b)}function pY(a,b,c,d){function e(){var a=c;c=d;d=a}var f=a.R.t.top,g=a.R.t[Uc],k=a.R.t[G],l=a.R.t[kd],n=a.td[Cz];b=a.R.Ga[b];a.R[QB]==th?1==n?(d<c&&e(),b.DR=new um(f,d,g,c)):(d>c&&e(),b.DR=new um(f,c,g,d)):1==n?(d<c&&e(),b.DR=new um(c,l,d,k)):(d>c&&e(),b.DR=new um(d,l,c,k))}
R.Eha=function(){ERa(this);FRa(this)};function ERa(a){var b=a.R;Zj(b.Zc,function(a,d){GRa(this,this.Pe[d],b.Zc[d],this.Lqa)},a);Zj(b.rd,function(a,d){GRa(this,this.lg[d],b.rd[d],this.Kqa)},a)}function FRa(a){var b=a.R;Zj(b.rd,function(a,d){GRa(this,this.lg[d],b.rd[d],this.nsa)},a)}function GRa(a,b,c,d){c[pd]&&Oy(c,vj(c[pd],U(d,a,b)))}R.Kqa=function(a,b){var c=this.R,d=b.za;return d.Eb?!0:(d=gV(d))?a.Bm!=pH||(new um(c.t.top,c.t[kd],c.t[Uc],c.t[G]))[Yc](d)?!0:!1:!0};
R.nsa=function(a,b){var c=this.R;if(a.Bm!=pH)return!0;var d=b.za;if(d.Eb)return!0;var e=gV(d);if(!e)return!0;var d=d.ba[Gc]/2,f=new um(e.top,e[kd]+d,e[Uc],e[G]-d),g;for(g in c.Zc){var k=ha(g);if(this.Pe[k].Bm==pH&&!(1>(c.Zc[k][pd]?c.Zc[k][pd][J]:0))){var l=gV(c.Zc[k][pd][0].za),n=gV(qj(c.Zc[k][pd]).za);if(l||n){if(l&&wm(f,l)||n&&wm(f,n))return!1;l?n?(k=h.min(l[G],n[G]),l=h.max(l[kd],n[kd])):(k=l[G],l=l[kd]):(k=n[G],l=n[kd]);if(h.abs(e[G]-k)<d||h.abs(e[kd]-l)<d)return!1}}}return!0};
R.Lqa=function(a,b){var c=this.R,d=new um(c.t.top,c.t[kd],c.t[Uc],c.t[G]),e=b.za,f=e.ba[Gc]/2,e=gV(e);if(!e)return!0;if(a.Bm==pH&&!d[Yc](e))return!1;d=new um(e.top,e[kd]+f,e[Uc],e[G]-f);return(f=gV(c[bC]))&&wm(d,f)||(c=c.KF?gV(c.KF):null)&&wm(d,c)?!1:(c=this.xf.getArea())&&wm(d,c)?!1:!0};
function oRa(a){var b=a.R,c=a.td,d=a[Nr],e={$a:b.kk,fontSize:b.wm,lc:b.qw},f=np(d,[Mya,WK],e),g=hp(d,[Qya,Yya]),k=Zo(d,[Pya,Kya],M),l=Po(d,[Oya,Jya],5),n=ep(d,[Nya,Iya],UW,QG);X(a.R.Ga,function(a,d){var e=[],p=[];X(b.rk,function(a){a=this.aN(d,a.ia,n);Mj(e,a.jO);Mj(p,a[nC])},this);if(e[J]||p[J]){var t=lY(this,d),t=c.De(t),u=b.t.top+b.t[z];e[J]&&(u={x:t,y:u},a.Uc=HRa(this,u,O,M,!1,this.R[QB],e,f,g,l,k));p[J]&&(u={x:t,y:null},a.Uc=IRa(this,u,p,f,k))}},a);var p=ek(eNa),t=Lo(d,[Vya,Lya],!0),u=Lo(d,[Xya,
Zya],!1),x=jga(d,[Rya,WK],p,e),A=hp(d,[Wya,Yya]),C=$o(d,[Uya,Kya],p,M),E=Po(d,[Tya,Jya],12),Q=ep(d,[Sya,Iya],UW,QG);X(a.R.g,function(a,b){if(a[H]==Hg||a[H]==JK||a[H]==OG||a[H]==OE){var c=EE+b+ODa,e=Lo(d,c+Dta,t),f=Lo(d,c+lza,u),g=jga(d,c+vD,p,x);Ya(g,ZQa(g[F],a[F]));var k=hp(d,[c+fya],A),l=$o(d,c+$na,p,C),n=Po(d,c+Zna,E),l=ZQa(l,a[F]);ep(d,c+ji,UW,Q);for(c=0;c<a.l[J];++c)if(null!=a.l[c]&&null!=a.l[c].V){var Db=a.l[c],Ec=this.aN(c,a.ia,Q),Zd=Db.V,Xb=po(a.Fg)?a.Fg.fb():e?Re:vN,Db=Db.brush&&po(Db.brush)?
Db.brush.fb():Xb;if(Db!==Xb&&e){var Xb=mk(g),sd=[.1,.2,.3],gf=xn(Db),tj=xn(this.R.pF.fb()),Ih=wj(sd,Yi(Cn,gf)),sd=wj(sd,Yi(Dn,gf)),gf=vn(En(tj,Kj([gf],Ih,sd)));Ya(Xb,gf)}else Xb=g;Ec.jO[J]&&(a.l[c].Uc=HRa(this,Zd,a[H],Db,this.R.Rd,this.R[QB],Ec.jO,Xb,k,n,l,e,f));Ec[nC][J]&&(a.l[c].Uc=IRa(this,Zd,Ec[nC],g,l))}}},a)}
R.aN=function(a,b,c){var d=this.Sb,e=b.annotation,f={line:[],jO:[]};if(null==e)return f;b=b.annotationText||[];for(var g=0;g<e[J];++g){var k=e[g],l=k+1,n=0<=sj(b,l);d[I](a,k)&&(l={text:d.Ca(a,k),Y8:n?l:null,rowIndex:a},ep(this[Nr],cza+k+sDa,UW,c)==OG?f[nC][B](l):f.jO[B](l))}return f};
function HRa(a,b,c,d,e,f,g,k,l,n,p,t,u){var x=[[64,64,64],[128,128,128],[255,255,255]],A=null==t?!0:t;t=c===JK;var C,E;if(t)var Q=new xm(b[G],b.top,b[r],b[z]),N=E=b.top,S=C=h[Eb](b[G]+b[r]/2);else var S=C=b.x,N=E=b.y;var T=N-n,V=T,sa=-n,Ha=g[J],Ka=n+k[Gc]*Ha;N-Ka<a.R.t.top&&N+Ka<a.R.t[Uc]&&(T=N+Ka,V=N+n+k[Gc],sa=n);N=null;1<Ha&&(n=S,N=V,V=null,V=g[0][pd]+RFa,Ka=a.mc(V,k),c===JK&&Ka[r]>b[r]?(c=b[G],n=TD):(c=n,n=dK),V={OV:!1,label:{text:V,ba:k,I:[{x:0,y:0,length:Ka[r],text:V}],Gc:n,Fc:zI,anchor:new fV(c,
N),Eb:0}},a.Jt&&(V[dd].rb=RBa),N=V);c=[];for(n=0;n<Ha;n++){var V=g[n],Ra=a.mc(V[pd],k),Ka={},Sd=new fV(C,T),Db=null;Ka.ba=Mn(k,Nn);if(t){if(Q&&!u){var Db=xn(d),Ec=vn(En(Db,x)),Db=f===th?kD:au,Zd=Mn(k,Nn);A&&(Zd.lc=O,Ya(Zd,Ec));t:{var Xb=V[pd],sd=Zd,gf=Db,Db=Q,tj=a.mc,Zd=a.Jt,Ih=Ui(2)?2:0,Qf=Ui(2)?2:0,Ec=tj(Xb,sd),Mr,rg=Db.Tb();Mr=Ec[r]<=rg[r]&&Ec[z]<=rg[z];var rg={},Jj=[];Oy(rg,Xb);rg.ba=sd;if(gf===kD)gf=h[Eb](Db[tB]().x),Qf=Db.top+Qf,rg.Gc=dK,rg.Fc=TD;else if(gf===au)gf=Db[G]+(Db[r]-Ih),Qf=h[Eb](Db[tB]().y),
rg.Gc=zI,rg.Fc=dK;else throw m("Invalid text block position.");if(!Mr||Ec[r]>Db[r]-Ih)if(Ec[z]<Db[z]){if(sd=fT(tj,Xb,sd,Db[r]-Ih,Db[z]/(Ec[z]+2)),Jj=sd.I,sd.re){var wk=Xb;rg.ys=!0}}else if(Db[z]>sd[Gc]/3)wk=Xb,Jj=[nf],Qf=h[Eb](Db[tB]().y),rg.Fc=dK,rg.ys=!0;else{Db=null;break t}rg.I=[];if(Jj[J])for(sd=Xb=0,tj=Jj[J];sd<tj;sd++)rg.I[B](new aPa({x:0,y:Xb,length:Db[r],text:Jj[sd]})),Xb+=Ec[z];else rg.I[B](new aPa({x:0,y:0,length:Ec[r],text:Xb}));rg.Eb=0;sz(rg,new fV(gf,Qf));Zd&&wk&&(rg.de={ul:!1,ii:!1,
content:wk});Db=new bPa(rg)}}if(u||!e&&(!Db||1<Db.I[J]||Db.ys))switch(f){case th:Ka.Fc=zI;b[r]>Ra[r]?(Sd.x=C,Ka.Gc=dK):(Sd.x=Q[G],Ka.Gc=TD);break;case ui:Sd.x=Q[G]+Q[r]+2,Ka.Gc=TD,Ka.Fc=dK,Sd.y=Q[tB]().y}}else Sd.x=S,Ka.Gc=dK,Ka.Fc=zI;if(Db&&(e||!e&&!Db.ys)){c[B](Db);var sg=!0}else{switch(f){case th:Ka.Gc=dK;Ka.Fc=zI;break;case ui:Ka.Gc=TD,Ka.Fc=dK}Oy(Ka,V[pd]);Ka.ba=k;Ka.gr=l;sz(Ka,Sd);Ka.ys=!1;Ka.I=[{x:0,y:0,length:Ra[r],text:V[pd]}];Ka.Eb=0;Ra=V.Y8;a.Jt&&null!=Ra&&(Ka.de=iY(a,Ra,V[EB]));c[B](Ka);
T-=k[Gc]}}n=sg?0:sa;a=ui;t&&f===ui&&(n=0,a=th,C=b[G]+b[r],E=h[Eb](b.top+b[z]/2));return{J6:{x:C,y:E,length:n,orientation:a,color:p},labels:c,bundle:N?N:null}}
function IRa(a,b,c,d,e){var f=b.x,g=b.y,k=d[Gc];b=[];for(var l=0;l<c[J];l++){var n=c[l],p=fT(a.R.mc,n[pd],d,a.R.t[z]-k);b[B](p)}if(null!=g){for(l=n=0;l<b[J];l++)p=b[l],n=h.max(n,p.Hr);l=n+k;g=h[D](g-l/2);g<a.R.t.top&&(g=a.R.t.top);k=g+l;k>a.R.t[Uc]&&(k=a.R.t[Uc],g=k-l)}else g=a.R.t.top,k=a.R.t[Uc];for(var t=h[D]((g+k)/2),u=f+2,x=[],l=0;l<c[J];l++){var n=c[l],p=b[l],p={text:n,ba:d,I:[{x:u,y:t,length:p.Hr,text:p.I[0]}],Gc:dK,Fc:TD,anchor:null,Eb:270},A=n.Y8;a.Jt&&null!=A&&(p.de=iY(a,A,n[EB]));x[B](p);
u+=d[Gc]}return{J6:{x:f,y:g,length:k-g,orientation:ui,color:e},labels:x,bundle:null}}function uRa(a,b){var c=a.R.g[b],d=JRa(a,c);c.l&&X(c.l,function(a){null!=a&&(a.V=d(a.yf),null!=a.o8&&(a.os=d(a.o8)),null!=a.p8&&(a.ps=d(a.p8)))});c.wf&&(0<c.wf.I[J]||0<c.wf[yC][J])&&KRa(c)}R.Dha=function(){X(this.R.g,function(a,b){uRa(this,b)},this)};
function KRa(a){function b(b){var c=e[b];delete e[b];if(c&&1<c[nC][J]){c[Uc]&&c[Uc][gr]();if(f[b].ww!=O){var d=f[b].ww==kh;b=f[b].zM;c.NV=hV(c[nC],b,d,!1,!1);c[Uc]&&(c.Bia=hV(c[Uc],b,d,!1,!1))}a.wf[aB][B](c)}}function c(a,b){if(!e[a]){var c=f[a].brush[Jc](),d=f[a][w],g={};g.yr=a;tz(g,[]);d==Hg?(c.mk(0),Ma(g,[])):c.Eg(0);g.brush=c;e[a]=g}e[a][nC][B](new oO(b[G],b.top));e[a][Uc]&&e[a][Uc][B](new oO(b[G]+b[r],b.top+b[z]))}function d(a){a=f[a][w];return a==Hg||a==OG}var e={},f=a.wf.$F;a.wf.paths=[];for(var g=
0;g<a.l[J];g++){var k={},l=a.l[g];if(l&&l.V&&l.V.zr)for(var l=l.V.zr,n=0;n<l[J];++n){var p=l[n].yr;d(p)&&(k[p]=!0,c(p,l[n][eC]))}for(p in e)k[p]||f[p].xj||b(p)}for(p in e)b(p)}function JRa(a,b){switch(b[H]){case OE:return U(a.Iva,a,b);case nK:return U(a.Fva,a,b);case OG:return U(a.Hva,a,b);case JK:return U(a.Eva,a,b);case RD:return U(a.Jva,a,b);case iK:return U(a.Gva,a,b);case Hg:return U(a.Dva,a,b)}return null}R.Iva=function(a,b){return{x:this.lg[0].De(b.x),y:this.Pe[0].De(b.y)}};
R.Fva=function(a,b){var c=this.sr,d=this.lg[0].De(b.x),e=this.Pe[0].De(b.y),f=dPa(c,b),f=new lo({fill:f,fillOpacity:c.vp,stroke:c.pe}),c=ELa(c.qF,b[EA]);return{x:d,y:e,brush:f,radius:c,XP:c}};R.Hva=function(a,b){var c=qY(this,a.Td,b.tl,b.ax);c.zr=rY(this,a,b);return c};R.Eva=function(a,b){var c=LRa(this,a,b,b[JA],b.pl);if(!c)throw m("There MUST always be a scaled bar.");return{top:c.top,left:c[G],width:h.max(.5,c[r]),height:h.max(.5,c[z]),zr:rY(this,a,b)}};
R.Gva=function(a,b){var c=LRa(this,a,b,b.jka,b.kka),d=LRa(this,a,b,b.ika,b[pB]);if(!c||!d)return null;var e=MRa(this,d[G],d.top),f=MRa(this,c[r],c[z]),g=MRa(this,d[r],d[z]);Wy(g,2);Wy(e,e[BB]+(f[BB]-(f[BB]%2?3:2))/2);e=sY(this,e[BB],e[ys]);g=sY(this,g[BB],g[ys]);na(d,g.x);Ta(d,g.y);$a(d,e.x);d.top=e.y;g=b.hka?a.HF.N6:a.HF.O6;oo(g)&&(g=g.Lb/2,Ta(c,c[z]-2*g),na(c,c[r]-2*g),$a(c,c[G]+g),c.top+=g);Ta(c,h.max(c[z],2));na(c,h.max(c[r],1));return{rect:c,line:d}};
R.Jva=function(a,b){var c=this.gf[a.Td];null==b[JA]&&(b.from=JW(c.ga,c.Cb.sa));var d=this.td,e=d[RA][b.au].Z,f=d.Ew,g=h[Eb](e-d[Cz]*f/2),f=h[Eb](e+d[Cz]*f/2),k=c.De(b.pl),d=sY(this,g,c.De(b[JA])),e=sY(this,g,k),f=sY(this,f,k),k=[];Lo(this[Nr],Iwa,!0)&&null!=b.e7&&(c=sY(this,g,c.De(b.e7)),k[B](c));k[B](e);k[B](f);return{qr:PQa(d.x,d.y,f.x,f.y),outline:k,zr:rY(this,a,b)}};
function LRa(a,b,c,d,e){var f=a.gf[b.Td],g=a.iP;null!=d||(d=JW(f.ga,f.Cb.sa));b=h.min(f.De(d),f.De(e));d=h.max(f.De(d),f.De(e));f=(e=a.R.ab===yH)?tRa(f.Ew,Lo(a[Nr],xH))?0:1:h.min(1,.2*(d-b));0===f||h[Eb](b+f)<h[Eb](d)&&h[Eb](b+f)>h[Eb](b)?(b=h[Eb](b+f),d=h[Eb](d)):b+=f;var k=Po(a[Nr],Tva,.3),f=NRa(a,c);c=(c.vja?k:1)*g.EP/2;g=(e?h[Cb]:h[Eb])(f-c);c=h[Eb](f+c);b=sY(a,g,b);a=sY(a,c,d);return PQa(b.x,b.y,a.x,a.y)}
R.Dva=function(a,b){function c(a){return null!=a?a:e}var d=this.gf[a.Td],e=JW(d.ga,d.Cb.sa),d=qY(this,a.Td,b.tl,b.ax),f=qY(this,a.Td,b.p7,c(b.q7)),g=qY(this,a.Td,b.r7,c(b.s7)),k=qY(this,a.Td,b.t7,c(b.u7)),l=qY(this,a.Td,b.v7,c(b.w7)),n=rY(this,a,b);return{x:d.x,y:d.y,tW:f.x,uW:f.y,vW:g.x,wW:g.y,lN:k.x,mN:k.y,nN:l.x,oN:l.y,zr:n}};
function rY(a,b,c){if(!c.sG)return[];var d=a.td;b=a.gf[b.Td];var e=a.iP;if(c.hB>=e.dma||c.au>=d[RA][J]&&d[H]!=ti)return[];for(var f=NRa(a,c),g=[],k=0,l;l=c.sG[k];k++){var n=b.De(l.Ala),p=b.De(l.Bla),t=(d[H]==ti?d[RA]&&1<d[RA][J]?d[RA][1].Z-d[RA][0].Z:0:e.EP)*l.Cla,u=h.abs(n-p),p=sY(a,f-t/2,h.min(p,n)),n=p.x,p=p.y,t=sY(a,t,u);g[B]({rect:new xm(n,p,t.x,t.y),yr:l.yr})}return g}function NRa(a,b){var c=a.td,d=a.iP;return(c[H]==ti?c.De(b.tl):c[RA][b.au].Z)-d.Dma+(d.EP+1)*b.hB+d.EP/2}
function ZQa(a,b){switch(a){case FE:return b.wb;case Voa:return b.jj;case GE:return b[F];default:return a}}function MRa(a,b,c){switch(a.R[QB]){case th:return{domain:b,target:c};case ui:return{domain:c,target:b}}throw m(mBa);}function sY(a,b,c){switch(a.R[QB]){case th:return{x:b,y:c};case ui:return{x:c,y:b}}throw m(mBa);}function qY(a,b,c,d){return sY(a,a.td.De(c),a.gf[b].De(d))}
function vRa(a,b){var c=a[Jc]();if(po(c)&&c.fb()!=Se){var d=new ko(nF,c.fb());c.ud=d;!oo(c)&&b&&(c.ld(c.fb()),c.mk(1))}else oo(c)&&(c.wl=VI);return c}function wRa(a,b){var c=a[Jc]();c.mk(c.Lb*b);return c}function ARa(a,b,c){a=a.Sb;b=b.ia.certainty||[];return b[J]&&(c=a[I](c,b[0]),null!=c)?a.G(b[0])==Qg?c?1:0:c:1}function CRa(a,b,c){a=a.Sb;b=b.ia[us]||[];return b[J]&&(c=a[I](c,b[0]),null!=c)?!!c:!0}
function BRa(a,b,c){a=a.Sb;b=b.ia.emphasis||[];return b[J]&&(c=a[I](c,b[0]),null!=c)?a.G(b[0])==Qg?c?2:1:c:1}function jY(a,b){var c=cRa(a);return null===c?null:a.Sb[I](b,c)}function cRa(a){if(null===a.td||a.td[H]!=ti)return null;a=a.R.rk[0].ia.gap||[];return Ej(a)?null:a[0]}
function mY(a,b,c,d,e){function f(a,b,f){var g=JW(k.ga,l[I](c,a));b=JW(k.ga,l[I](c,b));null!=g&&null!=b&&(g+=d,b+=d,e&&(k.pc(g),k.pc(b)),n[B]({Bla:g,Ala:b,Cla:f,yr:a}))}var g=b.wf;if(!g)return null;var k=a.gf[b.Td],l=a.Sb,n=[];for(a=0;a<g.hy[J];a+=2)f(g.hy[a],g.hy[a+1],0);for(var p=0,t=g.sQ[J]-1;p<=t;p++,t--)a=g.sQ[p],b=g.sQ[t],f(a,b,g.$F[a].Xla);for(b=0;b<g.l[J];b++)a=g.l[b],f(a,a,0);for(b=0;b<g.Bb[J];b++)a=g.Bb[b],p=g.$F[a],f(a,a,0==b||b==g.Bb[J]-1?p.Wla:p.Yla);p=0;for(t=g[yC][J]-1;p<=t;p++,t--)a=
g[yC][p],b=g[yC][t],f(a,b,0);for(b=0;b<g.I[J];b++)a=g.I[b],f(a,a,0);return n[J]?n:null}R.Bha=function(){var a=this.R;if(a.Pf.bars||a.Pf.candlesticks||!Mi(Aj(a.g,function(a){return null!=a.wf}))){var b=vj(a.Ga,function(a,b){return 0!=jY(this,b)},this),b=ORa(this.td,b),b=h.max(b,1),c=mga(this[Nr],b),c=h.max(c,1),d=h.min(this.fx,h[Eb]((c+1)/2)),e=(c-d+1)/d;b>c&&(e=h[Eb](e));this.iP={dma:d,EP:e,Dma:a.ab===yH?0:((e+1)*d-1)/2}}};
function ORa(a,b){if(Ej(b))return 0;if(a[H]==ti){for(var c=a.MF,d=null,e=0;e<b[J];e++){var f=a.aI(b[e][Y]);null!=d&&(c=h.min(c,h.abs(f-d)));d=f}return c}return h.abs(a.aI(1)-a.aI(0))}function lY(a,b,c){var d=a.Sb;a=a.td;a[H]==ti&&(b=c&&c.jg?c[Y][b][0]:d[I](b,0),b=JW(a.ga,b));return b};function PRa(a){this.Yn=a;this.p2=[];this.fT=!1;this.$h={ye:null,dv:0,rl:0,IK:0,JK:0}}PRa[K].Ye=function(a,b,c){this.p2[c]=!0;0===c&&(this.$h.ye=b,this.$h.dv=a.x,this.$h.rl=a.y,this.$h.IK=a.x,this.$h.JK=a.y)};wq(PRa[K],function(a,b){this.Yn[ir]({type:a,data:b})});function tY(a,b,c,d){Ju[L](this);this.Yn=a;this.J=b;this.bv=c;this.dh=d;this.Wy=null;this.P1=new PRa(a);this.dR=null}W(tY,Ju);R=tY[K];R.D=function(){Lu(this.dR);tY.e.D[L](this)};function QRa(a){var b=a.J.Kt;RRa(a,U(function(a,d){this.J.fc(b,a,d)},a));Lu(a.dR);a.dR=new PQ(a.J[Sr]());$u(a.dR,bG,U(a.lra,a))}function SRa(a){var b=a.bv[Sr]();RRa(a,U(function(a,d){this.bv.fc(b,a,d)},a))}function TRa(a){var b=ea;URa(a,U(function(a,d){this.bv.fc(b,a,d)},a))}
function URa(a,b){b(dG,U(a.mwa,a));b(cG,U(a.nwa,a))}function RRa(a,b){b(Vt,U(a.zga,a));b(Ut,U(a.Ava,a));b(dG,U(a.zga,a));b(cG,U(a.zva,a));b(Tt,U(a.yva,a));b(vt,U(a.wva,a));b(kJ,U(a.Bva,a));b(QI,U(a.xva,a))}R.mwa=function(a){var b=Qm(this.J[Sr]());a=Qm(a);a.x-=b.x;a.y-=b.y;b=this.P1;b.p2[0]&&(b.$h.IK=a.x,b.$h.JK=a.y,b.fT||b[ir](yxa,{ye:b.$h.ye,xb:{x:b.$h.dv,y:b.$h.rl}}),b.fT=!0,b[ir](Axa,{ye:b.$h.ye,xb:{x:b.$h.IK,y:b.$h.JK}}))};
R.nwa=function(a){var b=Qm(this.J[Sr]()),c=Qm(a);c.x-=b.x;c.y-=b.y;b=this.P1;a=a[bs];b.p2[a]=!1;0===a&&b.fT&&(b.fT=!1,b.$h.IK=c.x,b.$h.JK=c.y,b[ir](zxa,{ye:b.$h.ye,xb:{x:b.$h.IK,y:b.$h.JK}}))};R.zga=function(a){var b=kO(a);try{kO(a)}catch(c){return}var d=this.yt(a);a[H]==dG&&this[ir](uxa,{xb:b,ye:d});d!=this.Wy&&(null!=this.Wy&&VRa(this,this.Wy),this[ir](xxa,{xb:b}),uY(this,oBa,d),this.Wy=d)};R.Ava=function(a){a=this.yt(a);a==this.Wy&&(VRa(this,a),this.Wy=null)};
function VRa(a,b){a[ir](wxa,null);uY(a,nBa,b)}R.zva=function(a){var b=kO(a);a=this.yt(a);this[ir](txa,{xb:b,ye:a});uY(this,cBa,a)};R.yva=function(a){var b=kO(a),c=this.yt(a);this[ir](vxa,{xb:b,ye:c,preventDefault:U(a[hr],a)});uY(this,dBa,c);this.P1.Ye(b,c,a[bs])};R.wva=function(a){var b=kO(a);a=this.yt(a);this[ir](Cxa,{xb:b,ye:a});uY(this,SBa,a)};R.Bva=function(a){var b=kO(a),c=this.yt(a);this[ir](oxa,{xb:b,ye:c});uY(this,NAa,c);Nu(a)};
R.xva=function(a){var b=kO(a);a=this.yt(a);this[ir](Bxa,{xb:b,ye:a});uY(this,JBa,a)};R.lra=function(a){var b=kO(a),c=this.yt(a);this[ir](nxa,{xb:b,ye:c,wheelDelta:a.detail,preventDefault:U(a[hr],a)});uY(this,JAa,c)};
function uY(a,b,c){var d=c[zc](Oe);switch(d[0]){case wu:var e=c=null,f=null;a.dh==BF?c=ha(d[1]):4==d[J]?(c=d[1]?ha(d[1]):null,e=ha(d[2]),f=ha(d[3])):3==d[J]?(c=ha(d[1]),e=ha(d[2])):e=ha(d[1]);d={$b:c,ej:e,Zx:f};a[ir](wu+b,d);break;case Gg:d={qx:d[1]};a[ir](Bza+b,d);break;case SG:d=ha(d[1]);if(0>d)break;d={UR:d};a[ir](tsa+b,d);break;case RG:d={Tpa:ha(d[1])};a[ir](osa+b,d);break;case Tpa:d=ha(d[1]);d={UR:d};a[ir](Zpa+b,d);break;default:a.Vea(b,c)}}wq(R,function(a,b){this.Yn[ir]({type:a,data:b})});function vY(a,b,c,d){tY[L](this,a,b,c,d.ab);this.S=d;this.f1=WRa(this)}W(vY,tY);vY[K].m6=function(a){this.S=a;this.f1=WRa(this)};function WRa(a){var b=a.S;if(b.ab!=kh&&b.ab!=OE)return{};a={};for(var b=b.g,c=0;c<b[J];c++){var d=b[c];if(pX(d))for(var e=d.l,f=0;f<e[J];f++){var g=e[f];if(g&&g.V&&!g.df){var k=RS([uF,c,f]);a[k]={center:g.V,radius:g.V&&null!=g.V.XP?g.V.XP:null!=g.XP?g.XP:d.b6,$b:c,ej:f}}}}return a}
vY[K].yt=function(a){var b=this.J.sv(a[ys]),c=kO(a),c=XRa(this,c);if(a[H]==Ut){a=this.Wy;if(null==a)return b;c=c==a?null:a}if(null!=c){a=YRa(b);var d=YRa(c),b=a>d?b:c}this.S.ai==gK?(c=b[zc](Oe)[0],c=c!=qt&&c!=oK&&c!=jK&&c!=uF&&c!=qF&&c!=QD):c=!0;return c?b:ut};
function XRa(a,b){if(!(new xm(a.S.t[G]+1,a.S.t.top+1,a.S.t[r]-2,a.S.t[z]-2))[Yc](b))return null;switch(a.S.ai){case RI:var c=b.x,d=b.y,e=null,f=da,g;for(g in a.f1){var k=a.f1[g],l=k[Gz].x,n=k[Gz].y,p=k[HB];l-c<=p&&l-c>=-p&&n-d<=p&&n-d>=-p&&(l=(l-c)*(l-c)+(n-d)*(n-d),l<=p*p&&l<=f&&(e=RS([qF,k.$b,k.ej]),f=l))}return e;case gK:t:{c=a.S.Ga;for(d=0;d<c[J];d++)if((e=c[d].DR)&&e[Yc](b)){c=RS([eK,d]);break t}c=null}return c}return null}function YRa(a){a=a[zc](Oe);return sj(FIa,a[0])}
vY[K].Vea=function(a,b){var c=b[zc](Oe);switch(c[0]){case qt:case oK:case jK:case uF:case qF:case QD:var d=ha(c[1]),c={$b:d,ej:ha(c[2])};this[ir](RI+a,c);break;case eK:c=ha(c[1]);c={$b:null,ej:c};this[ir](gK+a,c);break;case VK:d=ha(qj(c));this[ir](XK+a,3==c[J]?{$b:null,ej:ha(c[1]),Zx:d}:{$b:ha(c[1]),ej:ha(c[2]),Zx:d});break;case OG:case Hg:d=ha(c[1]),c={$b:d,ej:null},this[ir](Zoa+a,c)}};function wY(a,b){this.Qv={};this.kw={};this.XE=[];this[DB](a,b)}function ZRa(a){X(a.XE,function(a){$Ra(this,this.kw[a])},a)}wY[K].updateOptions=function(a,b){this.Ma=np(a,Cza,b);this.Wta=np(a,Dza,b);ZRa(this)};wY[K].getEntries=function(){for(var a=[],b=0,c=this.XE[J];b<c;b++){var d=this.XE[b],e=this.kw[d];if(!e[TB]||e[TB]()){var f=null,f=e[Pr]&&!e[Pr]()?TS(e[pd]||M,this.Wta,null,null,null,null,null,!1,null):nk(this.Qv[d]);a[B](f)}}return a};
function $Ra(a,b){if(!b.id)throw m("Missing mandatory ID for action.");var c=null;a.kw[b.id]?c=a.kw[b.id]:(c=a.kw[b.id]={id:b.id,text:void 0,visible:void 0,enabled:void 0,action:void 0},a.XE[B](b.id));pk(c,b);a.Qv[b.id]=TS(c[pd]||M,a.Ma,null,null,null,null,null,!1,c.id)}wY[K].oh=function(a){(a=this.kw[a])&&(a=nk(a));return a};function aSa(a,b){a.PJ=a.PJ||{};var c=a.PJ;c.entries=c[jC]||{};c=c[jC];c[b]=c[b]||{};c=c[b];c.Ah=c.Ah||{};return c.Ah}
wY[K].Ks=function(a,b,c){if(!a[AA]){var d=b.Sa.qx;null!=d&&(a=Bj(a.PJ[jC],function(a){return a.Ah[Y].id==d}),-1!==a&&(c=aSa(c,a),pa(c,c[Y]||{}),pz(c[Y],c[Y][iC]||{}),c[Y][iC].brush=so(sFa)))}};function bSa(a){this.Gb=a}function cSa(a,b){var c={index:{},order:[],hu:{}};X(b,function(a){var b=this.getKey(a);if(null!=b){if(!c.hu[Hc](b)){var f=this.getTitle(a);f&&(c.hu[b]=f)}c[xc][Hc](b)||(c[xc][b]=[],c[Bz][B](b));c[xc][b][B](a)}},a);return c};function xY(a){this.Gb=a}W(xY,bSa);xY[K].getKey=function(a){return this.Gb.n0(a)};xY[K].getTitle=function(a){return this.Gb.RQ(a)};fz(xY[K],function(a,b,c){var d=nOa(this.Gb,c);return dSa(a,d,b[Fb]||M,!0,a.foa,this.Gb.g[c.ob])});function yY(a){this.Gb=a}W(yY,bSa);yY[K].getKey=function(a){return a.ob};yY[K].getTitle=function(a){return nOa(this.Gb,a)};fz(yY[K],function(a,b,c){c=this.Gb.RQ(c)||M;return[c?TS(b[Fb]||M,a.dJ,c,a.Ma):null]});function zY(a,b,c,d){b=np(a,rna,{$a:b.$a,fontSize:b[Gc]});this.bs=Lo(a,wna,c==gK);this.foa=Lo(a,wna,!0);this.Kla=Lo(a,una,!0);this.Ma=b;this.dJ=Sfa(b);this.qe=d||null;this.f$=Wo(a,Uva,NBa);this.g$=Wo(a,Qva,TAa)}zY[K].Mu=function(){};function AY(a,b,c,d){zY[L](this,a,b,c,d)}W(AY,zY);
AY[K].q$=function(a,b,c){var d=a.Gb,e=d.g[b];c=d.uH(b,c);var f=!1,g=null,k=null,l=null!=d.kd&&d.kd;if(d.kd)if(f=!0,k=[this.f$,this.g$],d=e[H],d===JK)g=[{color:e.Fg.fb(),alpha:e.Fg.Oe},{color:e.zh[iC].Fg.fb(),alpha:e.zh[iC].Fg.Oe}];else if(d===OE)d=b%2?b-1:b,b=a.Gb.g[d],d=a.Gb.g[d+1],g=[{color:d.Fg.fb(),alpha:d.Fg.Oe},{color:b.Fg.fb(),alpha:b.Fg.Oe}];else throw m("Diff chart not supported for the chosen chart type.");b={entries:[]};if(c.I)for(c[bC]&&BY(this,b,c[bC]),e=0;e<c.I[J];e++)k=c.I[e],f=b,k=
(l=k[bC])?TS(k[wd],this.dJ,l,this.Ma):null,null!=k&&f[jC][B](k);else c.Aw&&!c.ii?(BY(this,b,c.Aw),CY(this,b,c.Dm,c[Fb],!0,this.bs,e,f,g,k,l)):c.Dm&&!c.ii?CY(this,b,c.Dm,c[Fb],!0,this.bs,e,!0,g,k,l):null!=c[Fb]&&CY(this,b,null,c[Fb],!1,this.bs,e);this.Mu(b,a.sk);return b};
function eSa(a,b,c,d){var e=b.Gb,f=new xY(e),g=new yY(e),k=null;d==gK?k=f:d==HE&&(k=g);var l;if(k)l=cSa(k,c);else{d=cSa(f,c);var n=cSa(g,c),k=g;l=n;1==d[Bz][J]&&1<n[Bz][J]&&(k=f,l=d)}var p={entries:[]};X(l[Bz],function(a){BY(this,p,l.hu[a][qc]());X(l[xc][a],function(a){var b=e.uH(a.ob,a.mb);b.ii?CY(this,p,null,b[Fb],!1,this.bs,e.g[a.ob]):p[jC][B][Zc](p[jC],k[SB](this,b,a))},this)},a);a.Mu(p,b.sk,0<c[J]);return p}
AY[K].r$=function(a,b){var c=a.Gb,d=c.g[b],e=d.de,f=null,g=null,k=null!=c.kd&&c.kd;c.kd&&(f=c.g[J],f=(b+f/c.pie.bi[J])%f,g=c.g[f],c={color:d.brush.fb(),alpha:d.brush.Oe},g={color:g.brush.fb(),alpha:g.brush.Oe},f=b>f?[c,g]:[g,c],g=[this.f$,this.g$]);c={entries:[]};e.Dm?CY(this,c,e.Dm,e[Fb],!0,this.bs,d,!0,f,g,k):CY(this,c,null,e[Fb],!1,this.bs,d);this.Mu(c,a.sk);return c};
function fSa(a,b,c){var d=b.Gb,e={entries:[]};X(c,U(function(a){a=d.g[a];var b=a.de;b.Dm?CY(this,e,b.Dm,b[Fb],!0,this.bs,a,!0):CY(this,e,null,b[Fb],!1,this.bs,a)},a));a.Mu(e,b.sk);return e}
AY[K].p$=function(a,b){var c=a.Gb,d=c.Ga[b].de,e=!1,f={entries:[]};if(d&&d[Fb])CY(this,f,null,d[Fb],!1,!1);else{var g=0,k=1,l=c.g[J];AOa(c)&&(g=c.g[J]-1,l=k=-1);for(var n=null;g!=l;g+=k){var p=c.g[g];if(p.xM){d=kX(c,g,b);if(n!=p.Ve){var n=p.Ve,t=c.Ga[b].hu[n];cj(kj(t))||BY(this,f,t)}p.l[d]&&p.l[d].de&&p.l[d].de[Fb]&&(d=p.l[d].de,CY(this,f,d.Dm,d[Fb],!0,this.bs,p,void 0,void 0,void 0,void 0,d.ii&&d.ul),e=!0)}}}null!=a.sk&&0<a.sk[J]&&(e=!0);this.Mu(f,a.sk);return e||this.Kla?f:null};
function BY(a,b,c){a=TS(c,a.dJ);b[jC][B](a)}function dSa(a,b,c,d,e,f,g,k,l,n,p){g=null!=g?g:!1;d=d?a.dJ:a.Ma;c=c[zc](Je);var t=e?f[F][F]:null;b=g&&null!=b?TS(b,a.Ma,null,null,t,f&&f.JF):TS(c[0],d,b,a.Ma,t,f&&f.JF,null,p);a=[b];for(g=g?0:1;g<c[J];g++)t=null!=k?k[g][F]:e?O:null,b=TS(c[g],d,null,null,t,null!=k?k[g][gC]:null,null!=l?l[g]:null,p),b.UK=n,a[B](b);return a}function CY(a,b,c,d,e,f,g,k,l,n,p,t){b[jC][B][Zc](b[jC],dSa(a,c,d,e,f,g,k,l,n,p,t))}
AY[K].Mu=function(a,b,c){b&&0!==b[J]&&((void 0==c||c)&&a[jC][B](KIa()),Mj(a[jC],b))};function DY(a,b,c){zY[L](this,a,b,c);this.zaa=this.dJ;this.uR=mk(this.Ma);Ya(this.uR,mN);Fa(this.uR,this.uR[Gc]-2)}W(DY,zY);DY[K].q$=function(a,b,c){b=a.Gb.g[b];a=b.l[c].de;c=[];b.aA||(b=TS(b[bC]||M,this.zaa),c[B](b));b=TS(a[Fb],this.zaa);c[B](b);a=TS(a.Aw,this.uR);c[B](a);return{entries:c}};DY[K].r$=function(){return{entries:[]}};DY[K].p$=function(){return{entries:[]}};function gSa(a,b,c){this.ss=b;this.Tm=Lo(a,Ana,!1)?new um(-da,da,da,-da):new um(0,c[r],c[z],0);this.Tx=null;c=Qo(a,yna);var d=Qo(a,xna);null!=c&&Ui(c)&&Wk(c)&&null!=d&&Ui(d)&&Wk(d)&&(this.Tx=new xl(c,d));b=null!=b.qe&&0<b.qe.getEntries()[J]?Rg:ih;this.iW=ep(a,lD,pp,b)}function EY(a){if(a.ab==BF){var b=a.pie[Gz];return new xl(b.x,b.y)}b=dk(a.rd);b=null!=b.Cb?b.Cb.Z:h.min(b.Se,b.cf);a=dk(a.Zc);a=null!=a.Cb?a.Cb.Z:h.max(a.Se,a.cf);return new xl(b,a)}function hSa(a,b){a.Tm=b}
function iSa(a,b,c){var d=b.V;b=rX(b,c);a=EY(a);b=1+h[Cb](b/h[Kd](2));return new xl(d.x+(d.x>=a.x?b:-b),d.y+(d.y<=a.y?-b:b))}function jSa(a,b){var c=pO(a.pie[Gz],fY(((b.wr?45:(b.Ud+b.od)/2)/180-.5)*h.PI,a.pie.bd,a.pie.cd)),c=new xl(c.x+b[tA].x,c.y+b[tA].y);c.x=Lk(c.x,0,a[r]);c.y=Lk(c.y,0,a[z]);return c}function kSa(a){var b=a[lC]?a[lC]:new xl(0,0),c=a.I[0],d=a.ba[Gc];return 270==a.Eb?new xl(b.x+c.x+d,b.y+c.y-c[J]/2):new xl(b.x+c.x+c[J]/2,b.y+c.y-d)}
function lSa(a,b,c){var d=a.g[b],e=d[H];c=kX(a,b,c);switch(a.ab){case kh:case yH:switch(e){case JK:case RD:return d=d.l[c],d=d.V.qr||d.V,b=EY(a),d=new xl(d[G]+(d[G]<b.x?0:d[r]),d.top+(d.top<b.y?0:d[z])),mSa(a,d),d;case OG:case Hg:return iSa(a,d.l[c],d);case iK:return d=d.l[c].V[eC],b=EY(a),d=new xl(d[G]+d[r]>b.x?d[G]+d[r]:d[G],d.top<b.y?d.top:d.top+d[z]),mSa(a,d),d}case OE:return iSa(a,d.l[c],d);case oK:c=d.l[c];b=c.V;d=iSa(a,c,d);if(d.x<a.t[G]||d.x>a.t[kd])d.x+=2*(b.x-d.x);if(d.y<a.t.top||d.y>a.t[Uc])d.y+=
2*(b.y-d.y);return d}return new xl(0,0)}function mSa(a,b){var c=a.t;b.x=Lk(b.x,c[G],c[kd]);b.y=Lk(b.y,c.top,c[Uc])}function nSa(a,b,c,d){var e=null,f=null,g=dk(b.rd),k=dk(b.Zc),l=g.zm,n=k.zm,p=d;b[QB]&&b[QB]!==th?(n=-n,k[H]===ti&&(p=b.Ga[d][Y]),f=k[tc].Be(p)):(g[H]===ti&&(p=b.Ga[d][Y]),e=g[tc].Be(p));a=a.ss.Ma[Gc];c.x=null===e?c.x:e;c.y=null===f?c.y:f;e=c.x-l*a;f=c.y+n*a;return new xl(e,f)}
function oSa(a,b){var c=pO(a.pie[Gz],fY(((b.wr?45:(b.Ud+b.od)/2)/180-.5)*h.PI,a.pie.bd-.1,a.pie.cd-.1));return new xl(c.x+b[tA].x,c.y+b[tA].y)}function pSa(a){var b=a[lC]?a[lC]:new xl(0,0),c=a.I[0],d=a.ba[Gc];return 270==a.Eb?new xl(b.x+c.x+d/2,b.y+c.y):new xl(b.x+c.x,b.y+c.y-d/2)}
function qSa(a,b,c){c=kX(a,b,c);var d=a.g[b];b=d[H];c=d.l[c].V;if(b==JK||b==RD||b==iK){var e=c.qr||c[eC]||c;c=e[G];b=e[r];var d=c+b,f=e.top,e=e[z],g=f+e,k=EY(a);a=a[QB]==th?g>k.y?new xl(c+b/2,g-.1):new xl(c+b/2,f+.1):c<k.x?new xl(c+.1,f+e/2):new xl(d-.1,f+e/2)}else a=new xl(c.x,c.y);return a}
function FY(a,b,c,d,e,f){if(null===c||null===d||null===e)if(null===c||null===d)if(null!==c&&null===d){d=b.Gb;f=d.g[c];e=jSa(d,f);f=oSa(d,f);var g=d.g[c].de;g.ul&&g.ii?a=GY(a,g[Fb],f):(b=a.ss.r$(b,c),a=VS(b,d.mc,!0,e,a.Tm,f,void 0,d.Fr,d.eu))}else if(null!==c||null===d||null===e)null===c&&null!==d?(c=b.Gb,e=f[Jc](),f=nSa(a,c,e,d),e=a.Tx?Bl(f,a.Tx):e,(g=c.Ga[d].de)&&g.ul&&g.ii?a=GY(a,g[Fb],e):(b=a.ss.p$(b,d),a=null===b?null:VS(b,c.mc,!1,f,a.Tm,e,void 0,c.Fr,c.eu))):a=null;else{c=b.Gb;var g=c.Ga[d].Uc[cC][e],
k=g.de;k?(f=kSa(g),g=pSa(g),k.ul&&k.ii?a=GY(a,k[Fb],g):(k=a.ss,d={entries:[TS(b.Gb.Ga[d].Uc[cC][e].de[Fb],k.Ma)]},0<b.sk[J]&&k.Mu(d,b.sk),a=VS(d,c.mc,!1,f,a.Tm,g,void 0,c.Fr,c.eu))):a=null}else e=b.Gb,e.g[c].xM?(f=lSa(e,c,d),g=a.Tx?Bl(f,a.Tx):qSa(e,c,d),k=e.g[c].l[d].de,k.ul&&k.ii?a=GY(a,k[Fb],g):(b=a.ss.q$(b,c,d),a=VS(b,e.mc,!0,f,a.Tm,g,void 0,e.Fr,e.eu))):a=null;else{f=b.Gb;var k=f.g[c].l[d].Uc[cC][e],l=k.de;l?(g=kSa(k),k=pSa(k),l.ul&&l.ii?a=GY(a,l[Fb],k):(l=a.ss,d={entries:[TS(b.Gb.g[c].l[d].Uc[cC][e].de[Fb],
l.Ma)]},l.Mu(d,b.sk),a=VS(d,f.mc,!1,g,a.Tm,k,void 0,f.Fr,f.eu))):a=null}return a}function rSa(a,b,c,d){var e=b.Gb,f=b.Gb.g[d];d=jSa(e,f);var f=oSa(e,f),g=wj(c,function(a){return e.g[a].de});yj(g,function(a){return a.ul&&a.ii});b=fSa(a.ss,b,c);return VS(b,e.mc,!0,d,a.Tm,f,void 0,e.Fr,e.eu)}
function sSa(a,b,c,d,e){var f=b.Gb,g=lSa(f,d.ob,d.mb);d=qSa(f,d.ob,d.mb);var k=wj(c,function(a){var b=kX(f,a.ob,a.mb);return f.g[a.ob].l[b].de});yj(k,function(a){return a.ul&&a.ii});b=eSa(a.ss,b,c,e);return VS(b,f.mc,!0,g,a.Tm,d,void 0,f.Fr,f.eu)}
function tSa(a,b,c,d,e){var f=b.Gb;d=d[Jc]();var g=nSa(a,f,d,c[c[J]-1]);d=a.Tx?Bl(g,a.Tx):d;var k=wj(c,function(a){return f.Ga[a].de});yj(k,function(a){return a&&a.ul&&a.ii});var l=[];X(c,function(a){X(f.g,function(b,c){l[B]({ob:c,mb:a})})});b=eSa(a.ss,b,l,e);return null===b?null:VS(b,f.mc,!1,g,a.Tm,d,void 0,f.Fr,f.eu)}function GY(a,b,c){return{html:{name:ch,content:b,properties:{className:QH}},iga:!0,jga:c,anchor:c,hga:a.Tm,JC:20,margin:5}};function HY(a,b,c,d,e,f){this.qe=f;d==II||this.qe?null!=this.qe&&this.qe[DB](a,c):this.qe=new wY(a,c);c=d==II?new DY(a,c,e):new AY(a,c,e,this.qe);this.eo=new gSa(a,c,b)}function IY(a,b,c){var d={};if(null!=c.Ea.jD){d.Ea=d.Ea||{};var e=b.Ea,f=c.Ea.jD;d.Ea.gu=e.eg[f];var g=f+1+Gs+e.eg[J],k=e.rI.g_,l=0<f,e=e.rI.e_,f=f<b.Ea.eg[J]-1;d.Ea.rI={g_:{brush:l?k.ne.Zu:k.ne.lQ,Zu:l},e_:{brush:f?e.ne.Zu:e.ne.lQ,Zu:f},f_:{text:g,I:{0:{text:g}}}}}a.Ks(b,c,d);return d}HY[K].vj=function(a){this.qe&&$Ra(this.qe,a)};
HY[K].oh=function(a){if(this.qe)return this.qe.oh(a)};HY[K].uj=function(a){if(this.qe){var b=this.qe;a in b.Qv&&delete b.Qv[a];a in b.kw&&delete b.kw[a];a=sj(b.XE,a);0<=a&&b.XE[Ee](a,1)}};function JY(a){fy(this,new rx);this.Sa={ob:null,datum:null,mb:null};Py(this,{Sa:null,UM:null});this.Ea={Sa:{Ah:null},jD:null};this.Ph={Sa:{qx:null}};uy(this,{position:null,qY:null});this.ci=this.ao=null;a&&(this[$z][sr](a[$z]),a.Sa&&(this.Sa=KY(this.Sa,a.Sa)),a[sB]&&Py(this,KY(this[sB],a[sB])),a.Ea&&(this.Ea=KY(this.Ea,a.Ea)),a.Ph&&(this.Ph=KY(this.Ph,a.Ph)),a.ao&&(this.ao=KY(this.ao,a.ao)),a.ci&&KY(this.ci,a.ci))}
Ia(JY[K],function(){var a=new JY;fy(a,this[$z][Jc]());a.Sa=Co(this.Sa);Py(a,Co(this[sB]));a.Ea=Co(this.Ea);a.Ph=Co(this.Ph);uy(a,Co(this[zA]));a.ao=Co(this.ao);a.ci=Co(this.ci);return a});ab(JY[K],function(a,b){var c=Gi(b)?b:!1;return this[$z][gs](a[$z])&&Bo(this.Sa,a.Sa)&&Bo(this[sB],a[sB])&&Bo(this.Ea,a.Ea)&&Bo(this.Ph,a.Ph)&&(c||Bo(this[zA],a[zA]))&&Bo(this.ao,a.ao)&&Bo(this.ci,a.ci)});function KY(a,b){var c=new DT(2);ET(c,0,a);ET(c,1,b);return c[iB]()};function uSa(){this.dn=0;this.qZ=this.wq=-1;this.vs=0;this.vI=-1}
uSa[K].create=function(a,b,c,d,e){if(0!=a[J]&&(a=vj(a,function(a){return null!=a}),Qj(a),0!=a[J]))if(a[0]==a[a[J]-1])this.dn=1,this.wq=a[0],this.qZ=a[0],this.vI=0;else{var f=h[Cb](.5*a[J])-1,g=h.min(a[J]-1,h[Cb]((100-b)/100*a[J])-1),k=h.max(0,h[Cb](b/100*a[J])-1);b=vSa(a);var l=a[f]-h.min(a[f]-a[0],1.5*(a[f]-a[k]));l!=a[0]&&(this.vs=1,b&&(l=h[Eb](l)));var n=a[f]+h.min(a[a[J]-1]-a[f],1.5*(a[g]-a[f])),f=vj(a,function(a){return a<n&&a>l});this.dn=Ui(c)&&0<c?c:wSa(l,n,f[J],b,d,e);this.wq=this.dn*(1==
this.vs?h[D](l/this.dn):h[Eb](l/this.dn));1==this.vs&&this.wq<a[0]&&(this.vs=0);a=h[Eb]((n-this.wq)/this.dn);this.qZ=this.dn*a+this.wq;this.vI=a+this.vs}};function vSa(a){for(var b=0;b<a[J];b++)if(!Vk(a[b]))return!1;return!0}function xSa(a){var b=[];1==a.vs&&b[B](BCa+(a.wq.toPrecision(10)-0));for(var c=a.vI-a.vs,d=0;d<c+1;d++)b[B]((d*a.dn+a.wq).toPrecision(10)-0+hf);return b}function ySa(a){for(var b=[],c=0;c<=a.vI+1;c++)b[B]((c-a.vs)*a.dn+a.wq);return b}
function wSa(a,b,c,d,e,f){if(a==b)return 1;if(0==c)return b-a;c=h[Kd](c);var g=null!=e&&0<e,k=null!=f&&0<f;e=g&&k?f>e?Lk(c,e,f):c:g?h.max(c,e):k?h.min(c,f):c;a=(b-a)/e;b=.8*a;e=1.2*a;f=h[D];if(!(a>e||a<b||b>=e)){c=1;g=a;do{var g=a,l=c,k=f;0==g||!Wk(g)||0>=l||(l=(0==g?1:h.pow(10,h[Cb](-h.log(h.abs(g))/h[PB])-1))*h.pow(10,h.max(0,l)),l*=0<g?1:-1,g=h.max(5*k(l*g/5),1)/l);c++}while(!(g>=b&&g<=e)&&5>c);a=5>c?g:a}return d?.5<a?h[D](a):1:a};function LY(){}W(LY,mOa);R=LY[K];R.RQ=function(a){var b=a.ob,c=a.mb;return this.Iw?LY.e.RQ[L](this,a):this.g[b][tb].histogramBucketItems[c][dd].Aw};R.n0=function(a){return this.Iw?LY.e.n0[L](this,a):this.g[a.ob][tb].histogramBucketItems[a.mb].row};R.iZ=function(a){if(this.Iw)return LY.e.iZ[L](this,a);a=this.g[a.ob][tb].histogramBucketItems[a.mb];return{row:a.row,Db:a.Db}};
R.ZO=function(a){var b=this.kp[a.Db].$b;return null!=b?this.Iw?LY.e.ZO[L](this,a):{ob:b,mb:this.g[b][tb].histogramElementIndexes[a.row]}:null};R.uH=function(a,b){var c=this.g[a],d=c.l[b];return this.Iw?{I:[{title:lBa,value:d.yf.pl-d.yf[JA]}]}:c[tb].histogramBucketItems[b][dd]};function MY(a,b,c,d,e){hY[L](this,a,b,c,d,e)}W(MY,hY);MY[K].J8=function(){return new LY};
MY[K].I8=function(){for(var a=this.ll,b=a.G(0)===ii,c=b?1:0,d=[],e=a.O(),f=a.L(),g=da,k=-da,l=0;l<e;l++)for(var n=c;n<f;n++){var p=a[I](l,n);Ui(p)&&!la(p)||null===p&&!this.R.xj||(p=p||0,d[B](p),g=h.min(g,p),k=h.max(k,p))}var l=Po(this[Nr],Cta),n=Po(this[Nr],Bta),p=Po(this[Nr],zta),t=Po(this[Nr],Ata),u=Lo(this[Nr],yta);0<t&&(p=h.min(p,t-1));0<l&&(g=k-g,t=h.max(p,h.min(t,this.R[r]/5)),g/=t,l=h.max(l,(g+g/2).toPrecision(1)));g=new uSa;g[xr](d,n,l,p,t);l=l||g.dn;k=[];p=xSa(g);d=new aq;d.Tf(Nh,cH);for(l=
c;l<f;l++)for(n=a.La(l)+YFa,d.Tf(Nh,n),k[l-c]=[],n=0;n<p[J];n++)k[l-c][B]([]);a=ySa(g);for(l=0;l<p[J];l++)d.Vr(),d.Fa(l,0,a[l]);for(l=0;l<e;l++)for(a=b?this.ll[I](l,0):M,n=c;n<f;n++)if(p=this.ll[I](l,n),!(Ui(p)&&!la(p)||null===p&&!this.R.xj)){var t=0==g.dn||p<g.wq?0:p>=g.qZ?g.vI:h[Eb]((p-g.wq)/g.dn)+g.vs,x=n+1-c;d.Fa(t,x,(d[I](t,x)||0)+1);x=this.ll.La(n)||nL;k[n-c][t][B]({row:l,Db:n,label:{title:a,Aw:a,Dm:x,content:p[qc](),I:[{title:x,value:p||0}]}})}for(var A=[],n=c;n<f;n++)A[n]=[];for(n=c;n<f;n++)b=
bea(k[n-c]),u&&b[ue](function(a,b){var c=a[dd].I[0][wd],d=b[dd].I[0][wd];return c<d?-1:c>d?1:0}),d.bx(n-c,xta,b),X(b,function(a,b){A[a.Db][a.row]=b});for(n=c;n<f;n++)d.bx(n-c,vta,A[n]);c=ySa(g);d.bx(0,wta,c);this.Sb=new hw(d)};function tRa(a,b){return 4>a||b}function sRa(a,b,c){for(var d=[],e=0;e<b.Ga[J];e++){d[e]=[];for(var f=0;f<b.g[J];f++){var g=b.g[f];if(g[H]==JK){var k=a?0:f;d[e][k]=(d[e][k]||0)+c[I](e,g.ia[Y][0])}}}for(e=a=0;e<d[J];e++)for(f=0;f<d[e][J];f++)a=h.max(d[e][f],a);return a};function NY(a,b,c,d,e,f,g){HY[L](this,a,b,c,d,e,g);this.dQ=fp(a,mwa,oga);this.Vla=ep(a,[nwa,qwa],pga,Rg);this.yma=ep(a,[swa,qwa],pga,Rg);this.Tla=ap(a,[pwa,vwa]);this.wma=ap(a,[uwa,vwa]);this.Ula=Uo(a,[owa,rwa],1);this.xma=Uo(a,[twa,rwa],1);this.hZ=ep(a,nza,sNa,O);this.kN=!0}W(NY,HY);NY[K].Ks=function(a,b,c){this.kN=!0;switch(a.bA){case PI:this.v5(a,b,c);break;case II:zSa(this,a,b,c)}};NY[K].k6=function(a,b){return a[gs](b,this.kN)};function ASa(a){return yj(a.g,function(a){return a.Zg})}
function OY(a,b,c){a.g=a.g||{};a=a.g;a[b]=a[b]||{};b=a[b];b.l=b.l||{};b=b.l;b[c]=b[c]||{};return b[c]}function PY(a,b,c){if(null!=b)return a=OY(a,b,c),a.Uc=a.Uc||{},a.Uc;a=BSa(a,c);a.Uc=a.Uc||{};return a.Uc}function QY(a,b){a.g=a.g||{};var c=a.g;c[b]=c[b]||{};return c[b]}function BSa(a,b){a.Ga=a.Ga||{};var c=a.Ga;c[b]=c[b]||{};return c[b]}function RY(a,b){a.Ea=a.Ea||{};var c=a.Ea;c.gu=c.gu||{};c=c.gu;c[b]=c[b]||{};return c[b]}
NY[K].v5=function(a,b,c){var d={Gb:a,sk:this.qe.getEntries(),Yt:c,xk:b.Ph},e=b.Ph.Sa.qx;null!=e&&Iy(b.Ph.Sa,this.qe.oh(e)[dB]);for(var e=this.eo.iW,f=e==ci||e==Rg,e=e==ih||e==Rg,g=this.hZ!=O,k=this.qe&&0<d.sk[J],l=ux(b[$z]),n=1<l[J]&&(g||k),p=0;p<l[J];++p){var t=l[p],u=t.column,x=t.row,A=a.kp[u],t=A.$b;if(x=a.ZO({Db:u,row:x}))switch(A.kl){case Wg:SY(this,a,x.ob,x.mb,c);f&&!n&&TY(this,d,x.ob,x.mb);break;case XK:if(null!=t?!a.g[t].Zg:!a.Zg)break;t=A.EA;CSa(x.ob,x.mb,t,c);f&&DSa(this,d,x.ob,x.mb,t)}}f&&
n&&!a.Iw&&(p=vj(wj(l,function(b){return a.ZO({Db:b.column,row:b.row})}),Ni),0<p[J]&&ESa(this,d,g?p:[],p[p[J]-1]));l=sx(b[$z],Ug);for(p=0;p<l[J];++p)u=l[p],A=a.kp[u],null!=A&&(t=A.$b,null!=t&&FSa(this,a,t,c));l=a.ab===oK;n=tx(b[$z]);g=1<n[J]&&(g||k);for(p=0;p<n[J];++p)x=n[p],k=a.lr[x],l?(t=0,SY(this,a,t,k,c),f&&!g&&TY(this,d,t,k)):(GSa(this,a,k,c),f&&!g&&HSa(this,d,b[zA].qY,k));g&&(l?TY(this,d,0,a.lr[n[n[J]-1]]):f&&(f=wj(n,function(b){return a.lr[b]}),0<f[J]&&ISa(this,d,b[zA].qY,f)));f=b.Sa.ob;p=b.Sa[sA];
null!=p?a.g[f].Zg&&(JSa(this,a,f,p,c),e&&TY(this,d,f,p),KSa(a,f,p,c)):null!=f&&a.g[f].Zg&&LSa(this,a,f,c);f=b.Ea.Sa.Ah;null!=f&&a.g[f].Zg&&LSa(this,a,f,c);f=b.Sa.mb;null!=f&&a.Ga[f]&&(MSa(this,a,f,c),e&&ASa(d.Gb)&&(HSa(this,d,b[zA][tc],f),this.kN=!1));if(f=b[sB].UM)f=PY(c,f.$b,f.hW),f.bundle=f.bundle||{},f.bundle.OV=!0;(f=b[sB].Sa)&&e&&(p=a.kp[f.Db],e=p.$b,f=a.lr[f.row],p=p.EA,(null!=e?a.g[e].Zg:a.Zg)&&DSa(this,d,e,f,p));if(b=b.ci)c.ci=b};var NSa=[.25,.1,.05],OSa=[.3,.1,.05],PSa=[.3,.15,.05];
function JSa(a,b,c,d,e){var f=b.g[c],g=f.l[d];if(g&&!g.df&&g.V&&(!pX(f)||0!=f[jB]||qX(g,f))){var k=f[H]==JK?PSa:NSa;e=OY(e,c,d);e.Wn={};c=e.Wn;c.Ie=[];for(d=0;d<k[J];d++){var l=new lo({fill:O,stroke:AK,strokeOpacity:k[d],strokeWidth:1});c.Ie[B]({brush:l})}switch(f[H]){case JK:case RD:case iK:a=g.V.qr||g.V[eC]||g.V;b=new xm(a[G],a.top,a[r],a[z]);for(d=0;d<k[J];d++)a=c.Ie[d].brush.Lb,mz(c.Ie[d],new xm(b[G]-a/2,b.top-a/2,b[r]+a,b[z]+a)),$a(b,b[G]-a),b.top-=a,na(b,b[r]+2*a),Ta(b,b[z]+2*a);break;case OG:case Hg:case OE:case nK:gz(e,
!0);c.x=g.V.x;c.y=g.V.y;if(a.dQ===Rg||a.dQ===ih)d=oX(g,f),d=to(a.wma||d.fb(),1,!1,a.xma),QSa(b,g,e,d,a.yma);e.Li?(a=e.Li,b=a[HB]+a.brush.Lb/2):b=rX(g,f);for(d=0;d<k[J];d++)a=c.Ie[d].brush.Lb,Yy(c.Ie[d],b+a/2),b+=a}}}
function LSa(a,b,c,d){var e=b.g[c],f;if(pX(e)&&0<e[jB]){f=QY(d,c);f.Wn={};f=f.Wn;f.Ie=[];var g;g=e[H]==Hg?b.Rd?BOa(e):sX(e,!1):sX(e,b.xj);g=wGa(g);for(var k=e.Hc.Lb/2,l=0;l<OSa[J];l++){var n=new lo({fill:O,stroke:AK,strokeOpacity:OSa[l],strokeWidth:1}),p=xGa(g,k+n.Lb/2);f.Ie[B]({brush:n,path:p});k+=n.Lb}}f=(f=(f=d.g)&&f[c])&&f.l;for(g=0;g<e.l[J];++g)k=e.l[g],!k||k.df||(qX(k,e)||f&&f[g]&&f[g][TB])&&JSa(a,b,c,g,d);b.kd&&e[H]===OE&&!a.WG(e.ia)&&LSa(a,b,c-1,d)}
NY[K].WG=function(a){a=a[RF];return null!=a&&0<a[J]};function MSa(a,b,c,d){for(var e=b.g,f=0;f<e[J];++f){var g=kX(b,f,c);b.g[f].Zg&&null!=g&&JSa(a,b,f,g,d)}}
function SY(a,b,c,d,e){var f=b.g[c],g=f.l[d];if(g&&!g.df&&g.V&&(!pX(f)||0!=f[jB]||qX(g,f))){var k=oX(g,f);c=OY(e,c,d);c.Li={};d=c.Li;var l=b.yM;e=1;null==l&&(l=xi,e=0);switch(f[H]){case JK:case RD:case iK:e=1;d.brush=ro[Jc]();d.brush.ld(l);f[H]==iK&&(a=xn(sn(k.fb()).sc),b=xn(sn(l).sc),f=xn(sn(g.rA.fb()).sc),d.brush.ld(vn(En(f,[a,b]))));mo(d.brush,e);d.brush.mk(1);g=g.V.qr||g.V[eC]||g.V;k=k.Lb;a=d.brush.Lb;mz(d,new xm(g[G]+k/2+1.5+a/2,g.top+k/2+1.5+a/2,g[r]-(k+3+a),g[z]-(k+3+a)));(0>=d[eC][r]||0>=
d[eC][z])&&delete c.Li;break;case OG:case Hg:case OE:case nK:gz(c,!0);d.x=g.V.x;d.y=g.V.y;if(a.dQ===Rg||a.dQ===ci){var n=to(a.Tla||k.fb(),1,!1,a.Ula);QSa(b,g,c,n,a.Vla)}d.brush=new lo({fill:l,fillOpacity:e,stroke:k.fb(),strokeWidth:1});Yy(d,rX(g,f)+1.5+d.brush.Lb/2)}}}
function QSa(a,b,c,d,e){c=c.E8||(c.E8={});c.x=b.V.x;c.y=b.V.y;c.brush=d;b=new xl(a.t[G],c.y);d=new xl(a.t[kd],c.y);var f=new xl(c.x,a.t.top);a=new xl(c.x,a.t[Uc]);c.path=c[LB]||new bO;if(e===Rg||e===ui)for(f=eO([f,a]),a=0;a<f.md[J]-1;a++)c[LB].Vj(f.md[a]);if(e===Rg||e===th)for(e=eO([b,d]),a=0;a<e.md[J]-1;a++)c[LB].Vj(e.md[a]);c[LB][Hr]()}
function FSa(a,b,c,d){var e=b.g[c];if((e[H]==OG||e[H]==Hg||e[H]==OE)&&0<e[jB]){var f=QY(d,c);f.Li={};var f=f.Li,g;g=e[H]==Hg?b.Rd?BOa(e):sX(e,!1):sX(e,b.xj);g=wGa(g);f.brush=new lo({stroke:e.Hc.pe,strokeWidth:h.min(1,e.Hc.Lb/2)});f.path=xGa(g,-(e.Hc.Lb/2+2+f.brush.Lb/2))}for(f=0;f<e.l[J];++f)g=e.l[f],!g||g.df||(qX(g,e)||yOa(e,f)&&!b.xj)&&SY(a,b,c,f,d);b.kd&&e[H]===OE&&!a.WG(e.ia)&&FSa(a,b,c-1,d)}function GSa(a,b,c,d){for(var e=b.g,f=0;f<e[J];++f){var g=kX(b,f,c);null!=g&&SY(a,b,f,g,d)}}
function RSa(a,b,c,d){c=OY(b.Yt,c.ob,c.mb);var e=null!=b.xk;c.rb=d;e&&a.qe.Ks(d,b.xk,c.rb)}function TY(a,b,c,d){var e=FY(a.eo,b,c,d,null);null!=e&&RSa(a,b,{ob:c,mb:d},e)}function ESa(a,b,c,d){c=sSa(a.eo,b,c,d,a.hZ);RSa(a,b,d,c)}function ISa(a,b,c,d){if(c){c=tSa(a.eo,b,d,c,a.hZ);d=BSa(b.Yt,d[d[J]-1]);var e=null!=b.xk;d.rb=c;e&&a.qe.Ks(c,b.xk,d.rb)}}function HSa(a,b,c,d){if(c){var e=BSa(b.Yt,d),f=null!=b.xk;c=FY(a.eo,b,null,d,null,c);null!==c&&(e.rb=c,f&&a.qe.Ks(c,b.xk,e.rb))}}
function DSa(a,b,c,d,e){var f=PY(b.Yt,c,d);lz(f,f[cC]||{});f=f[cC];f[e]=f[e]||{};var f=f[e],g=null!=b.xk;c=FY(a.eo,b,c,d,e);f.la=c;g&&c&&a.qe.Ks(c,b.xk,f.la)}function KSa(a,b,c,d){if(a.Gi){var e=a.Gi;a=LV(e[bB],e.qI,[{value:a.g[b].l[c].yf[F]}],a.mc);d.Gi={definition:a}}}function CSa(a,b,c,d){a=PY(d,a,b);lz(a,a[cC]||{});a=a[cC];a[c]=a[c]||{};c=a[c];c.ba=c.ba||{};lb(c.ba,!0)}
function zSa(a,b,c,d){var e={Gb:b,sk:[],Yt:d,xk:null},f=c.Sa.ob,g=c.Sa[sA];b.Ea&&hSa(a.eo,new um(0,b.Ea.area[G],b[z],0));var k=a.eo.iW;if(null!=f&&null==g){for(var l=c[zA][tc].x,n=b.g[f].l,g=vj(n,function(a){return null!=a}),p=0;p<g[J]&&g[p].V.x<l;)p++;0==p?g=0:p==g[J]?g=g[J]-1:(l=l<Uk(g[p-1].V.x,g[p].V.x)?p-1:p,g=sj(n,g[l]));a.kN=!1}n=null;if(null!=g)for(n=OY(d,f,g),gz(n,!0),k==ih&&TY(a,e,f,g),b.Ea&&(n=RY(d,f),n.Ig={W:b.o6}),n=0;n<b.g[J];n++)n!=f&&(b.Ea&&(g=RY(d,n),g.za={ba:{color:hN}}),g=QY(d,n),
l=b.g[n],g.Hc=l.Hc[Jc](),mo(g.Hc,.3));if(f=c[sB].UM)f=PY(d,f.$b,f.hW),f.bundle=f.bundle||{},f.bundle.OV=!0;if(g=c[sB].Sa)n=b.kp[g.Db],f=n.$b,g=b.lr[g.row],n=n.EA,(null!=f?b.g[f].Zg:b.Zg)&&DSa(a,e,f,g,n);if(b.Ea&&b.Ea[tc]==aH&&null!=c.Ea.Sa.Ah){c=c.Ea.Sa.Ah;n=RY(d,c);n.Ig={W:b.o6};for(var f=b.g[c].l,t,n=f[J]-1;0<=n;n--)if((g=f[n])&&!g.df&&g.V&&(new um(b.t.top,b.t[kd],b.t[Uc],b.t[G]))[Yc](new xl(g.V.x,g.V.y))){t=n;break}null!=t&&(n=OY(d,c,t),gz(n,!0),k==ih&&TY(a,e,c,t));for(n=0;n<b.g[J];n++)n!=c&&(g=
RY(d,n),g.za={ba:{color:hN}},g=QY(d,n),l=b.g[n],g.Hc=l.Hc[Jc](),mo(g.Hc,.3))}};function SSa(a,b){this.Rr=a;this.mx=b;this.Pj=mk(a);var c=a[r]!=b[r]||a[z]!=b[z];!c&&a.t&&b.t&&(c=a.t[r]!=b.t[r]||a.t[z]!=b.t[z]||a.t[G]!=b.t[G]||a.t.top!=b.t.top);this.Pj[bC]&&c&&qb(this.Pj[bC].ba,0);this.Pj.rd&&(this.Pj.rd=ak(this.Pj.rd,mk),this.Qja=ak(a.rd,function(d,e){return TSa(a.rd[e],b.rd[e],this.Pj.rd[e],!0,!1,c)},this));this.Pj.Zc&&(this.Pj.Zc=ak(this.Pj.Zc,mk),this.Rja=ak(a.Zc,function(d,e){return TSa(a.Zc[e],b.Zc[e],this.Pj.Zc[e],!1,!0,c)},this));this.Um=this.fj=null;USa(this);this.m8=
this.l8=null;VSa(this)}
function TSa(a,b,c,d,e,f){if(!a||!b)return null;var g=mk(a),k=mk(a);k.Gj=b.Gj;k.Se=b.Se;k.cf=b.cf;c[bC]&&f&&qb(c[bC].ba,0);if(a[H]==ti&&b[H]==ti&&a[TA]===b[TA]){a.Cb&&b.Cb&&(k.Cb=b.Cb,c.Cb=mk(c.Cb));k.Vd=mk(k.Vd);Ba(k,mk(k[tc]));c.Vd=mk(c.Vd);Ba(c,mk(c[tc]));k[tc].Be=b[tc].Be;if(a.Ia&&b.Ia){k.Ia=Lj(k.Ia);c.Ia=Lj(c.Ia);var l=k.Ia,n=c.Ia;for(f=0;f<l[J];f++){l[f]=mk(l[f]);n[f]=mk(n[f]);var p=l[f],t=a.Vd.Be(p.sa),t=b.Vd.lk(t);p.Z=b[tc].Be(t)}}if(a.Lh&&b.Lh)for(k.Lh=Lj(k.Lh),c.Lh=Lj(c.Lh),l=k.Lh,n=c.Lh,
f=0;f<l[J];f++)l[f]=mk(l[f]),n[f]=mk(n[f]),p=l[f],t=a.Vd.Be(p.sa),t=b.Vd.lk(t),p.Z=b[tc].Be(t);if(a[pd]&&b[pd])for(Oy(k,Lj(k[pd])),Oy(c,Lj(c[pd])),t=k[pd],c=c[pd],UY(t),UY(c),f=0;f<t[J];f++)WSa(a,b,a[pd][f],b[pd][f],t[f],d,e)}else if(a[pd]&&b[pd]){var u=jKa(a[pd],b[pd],function(a,b){return a.sa==b.sa});Oy(g,vj(a[pd],function(a,b){return null!=u.p9[b]}));Oy(k,vj(b[pd],function(a,b){return null!=u.q9[b]}));Oy(c,Lj(g[pd]));UY(g[pd]);UY(k[pd]);UY(c[pd])}return[g,k]}
function WSa(a,b,c,d,e,f,g){var k=e.za,l=a.Vd.Be(e.sa),l=b.Vd.lk(l);a=a[tc].Be(e.sa);b=b[tc].Be(l);f&&(f=c.za[lC].x-a,k[lC].x=b+f,d&&(k[lC].y=d.za[lC].y));g&&(f=c.za[lC].y-a,k[lC].y=b+f,d&&(k[lC].x=d.za[lC].x))}function UY(a){X(a,function(b,c){a[c]=mk(a[c]);b=a[c];b.za=mk(b.za);var d=b.za;if(d[lC]){var e=d[lC];sz(d,new fV(e.x,e.y))}})}
function USa(a){var b=a.Rr,c=a.mx;if(b.g&&c.g){var d=jKa(b.g,c.g,function(a,b){return a.id==b.id});a.fj=vj(b.g,function(a,b){return null!=d.p9[b]});a.Um=vj(c.g,function(a,b){return null!=d.q9[b]});b.ab==kh||b.ab==OE?(b=null==b[QB]||b[QB]==th?b.rd[0]:b.Zc[0],c=null==c[QB]||c[QB]==th?c.rd[0]:c.Zc[0],b[H]==ti&&c[H]==ti&&b[TA]===c[TA]?XSa(a,b.Vd.Be,b.Vd.lk):YSa(a)):b.ab==oK&&ZSa(a)}}
function YSa(a){var b=a.Rr.Ga,c=a.mx.Ga;if(b&&c){var d={},e={},f={},g={};X(b,function(a,b){null!=a[Y]&&(f[a[Y]]=b)});X(c,function(a,b){null!=a[Y]&&(g[a[Y]]=b)});X(b,function(a,b){null!=a[Y]&&(d[b]=g[a[Y]])});X(c,function(a,b){if(null!=a[Y]){var c=f[a[Y]];d[c]!==b&&(c=null);e[b]=c}});X(b,function(a,b){null!=a[Y]&&e[g[a[Y]]]!==b&&(d[b]=null)});for(var k=0,l=0,n=[],p=[];k<b[J]||l<c[J];)k<b[J]&&null==d[k]?(p[B]({Ay:{Uh:k,Ez:!0},By:{Uh:l,Ez:!1}}),n[B]({data:b[k][Y]}),k++):(l<c[J]&&null==e[l]?(p[B]({Ay:{Uh:k,
Ez:!1},By:{Uh:l,Ez:!0}}),n[B]({data:c[l][Y]})):(p[B]({Ay:{Uh:k,Ez:!0},By:{Uh:l,Ez:!0}}),n[B]({data:b[k][Y]}),k++),l++);a.Pj.Ga=n;var t=function(a,b){return 0==b?a[0]:b>=a[J]?qj(a):$Sa(a[b-1],a[b],.5)};a.Rr.kd?aTa(a,p,function(a,b,c,d){return b.Ez?a[b.Uh*c+d]:t(a,b.Uh*c+d)}):VY(a,p,function(a,b){return b.Ez?a[b.Uh]:t(a,b.Uh)})}}
function XSa(a,b,c){var d=a.Rr.Ga,e=a.mx.Ga;if(d&&e)if(0==d[J]||0==e[J])a.Pj.Ga=[],VY(a,[],function(){return null});else{var f=function(a){return b(a[Y])},g=[],k=[];if(d[J]===e[J])for(var l=0;l<d[J];l++)k[B]({Ay:l,By:l}),g[B]({data:c(Uk(f(d[l]),f(e[l])))});else l=kKa(d,e,f),X(l,function(a){var b=a.HE;a=a.JE;var l;null!=d[b]&&null!=e[a]&&(l=c(Uk(f(d[b]),f(e[a]))));null!=l&&(k[B]({Ay:b,By:a}),g[B]({data:l}))});a.Pj.Ga=g;a.Rr.kd?aTa(a,k,function(a,b,c,d){return a[b*c+d]}):VY(a,k,function(a,b){return a[b]})}}
function ZSa(a){function b(a){a=mk(a);a.V=mk(a.V);a.V.brush=a.V.brush[Jc]();a.V.brush.Eg(0);mo(a.V.brush,0);a.ba=mk(a.ba);qb(a.ba,0);return a}var c=a.fj[0].l,d=a.Um[0].l,e=[],f=[],g=[],k={};X(d,function(a,b){null!=a&&(Gi(k[a.id])||(k[a.id]=[]),k[a.id][B](b))});Zj(c,function(a,b){if(null!=a){var c=a.id&&k[a.id],c=c&&c[wb]();Gi(c)?g[B]({Ay:b,By:c}):e[B](a)}});Zj(k,function(a){X(a,function(a){f[B](d[a])})});VY(a,g,function(a,b){return a[b]});var c=wj(e,b),l=wj(f,b);a.fj[0].WB=Kj(e,l);a.Um[0].WB=Kj(c,
f)}function VY(a,b,c){for(var d=0;d<a.fj[J];d++){var e=a.fj[d].l,f=a.Um[d].l,g=[],k=[];if(a.fj[d].jg)g=Lj(a.fj[d].l),k=Lj(a.Um[d].l);else for(var l=0;l<b[J];l++){var n=b[l],p=c(e,n.Ay),n=c(f,n.By);p&&n&&(g[B](p),k[B](n))}a.fj[d]=WY(a.fj[d],g);a.Um[d]=WY(a.Um[d],k)}}
function aTa(a,b,c){for(var d=0;d<a.fj[J];d++){var e=a.fj[d].l,f=a.Um[d].l,g=[],k=[];if(0<b[J])for(var l=h[Cb](e[J]/b[J]),n=h[Cb](f[J]/b[J]),p=0;p<b[J];p++){for(var t=b[p],u=0;u<l;u++){var x=c(e,t.Ay,l,u);x&&g[B](x)}for(u=0;u<n;u++)(x=c(f,t.By,n,u))&&k[B](x)}a.fj[d]=WY(a.fj[d],g);a.Um[d]=WY(a.Um[d],k)}}function WY(a,b){var c=mk(a);c.l=b;return c}function VSa(a){var b=a.Rr,c=a.mx;b.Ea&&b.Ea.eg&&c.Ea&&c.Ea.eg&&(a.Pj.Ea=null)}
function XY(a,b,c){if(a!==b)if(a&&a[Bc]==lo&&b&&b[Bc]==lo)a=new lo({fill:go(a.fb(),b.fb(),1-c),fillOpacity:XY(a.Oe,b.Oe,c),stroke:go(a.pe,b.pe,1-c),strokeWidth:XY(a.Lb,b.Lb,c),strokeOpacity:XY(a.pi,b.pi,c),wR:a.wl,gradient:a.Jg,pattern:a.ud});else if(Oi(a)&&Oi(b))if(a){if(b){for(var d=[],e=h.min(a[J],b[J]),f=0;f<e;f++)d[B](XY(a[f],b[f],c));a=d}}else a=b;else a=Ri(a)||Ri(b)?bTa(a,b,c):Si(a)||Si(b)?a:Ui(a)&&Ui(b)?a*(1-c)+b*c:null;return a}
function bTa(a,b,c){if(!a)return b;if(!b)return a;var d={};Zj(a,function(e,f){Gi(b[f])&&(d[f]=XY(a[f],b[f],c))});return d}function cTa(a,b,c,d,e){b=!e||(c?b>=c.top&&b<=c[Uc]:!1);return(!d||(c?a>=c[G]&&a<=c[kd]:!1))&&b}
function dTa(a,b,c,d,e){a[tc]&&a[tc].Be&&b[tc]&&b[tc].Be&&(c[tc].Be=function(c){var d=a[tc].Be(c);c=b[tc].Be(c);return XY(d,c,e)});a[bC]&&b[bC]&&X(c[bC].I,function(c,d){c.x=XY(a[bC].I[d].x,b[bC].I[d].x,e);c.y=XY(a[bC].I[d].y,b[bC].I[d].y,e)});a.Cb&&b.Cb&&(c.Cb.Z=XY(a.Cb.Z,b.Cb.Z,e));a.Ia&&b.Ia&&X(c.Ia,function(c,g){c.Z=XY(a.Ia[g].Z,b.Ia[g].Z,e);c.W=d(c.Z,c.Z)});a.Lh&&b.Lh&&X(c.Lh,function(c,g){c.Z=XY(a.Lh[g].Z,b.Lh[g].Z,e);c.W=d(c.Z,c.Z)});a.Gj&&b.Gj&&(c.Gj=bTa(a.Gj,b.Gj,e));null!=a.Se&&null!=b.Se&&
(c.Se=XY(a.Se,b.Se,e));null!=a.cf&&null!=b.cf&&(c.cf=XY(a.cf,b.cf,e));a[pd]&&b[pd]&&X(c[pd],function(c,g){if(c){var k=a[pd][g].za,l=b[pd][g].za,n=c.za;n&&n[lC]&&(n[lC].x=XY(k[lC].x,l[lC].x,e),n[lC].y=XY(k[lC].y,l[lC].y,e));c.za&&(k=0<c.za.I[J],c.W=d((k?c.za.I[0].x:0)+c.za[lC].x,(k?c.za.I[0].y:0)+c.za[lC].y))}})}
function $Sa(a,b,c){if(!a||!b)return null;var d=mk(a);if(a.df||b.df)d.df=!0;if(Gi(a.V)||Gi(b.V))d.V=XY(a.V||{},b.V||{},c),d.yf=XY(a.yf||{},b.yf||{},c);Gi(a.os)&&Gi(b.os)&&(d.os=XY(a.os,b.os,c));Gi(a.ps)&&Gi(b.ps)&&(d.ps=XY(a.ps,b.ps,c));Gi(a.ba)&&Gi(b.ba)&&a.ba!==b.ba&&(d.ba=mk(a.ba),Ya(d.ba,go(a.ba[F],b.ba[F],1-c)),qb(d.ba,XY(Gi(a.ba[fe])?a.ba[fe]:1,Gi(b.ba[fe])?b.ba[fe]:1,c)));null!=a.Uc&&null!=b.Uc&&a.Uc[cC][0][pd]===b.Uc[cC][0][pd]?d.Uc=XY(a.Uc,b.Uc,c):delete d.Uc;return d}
SSa[K].interpolate=function(a){var b=this.Pj;if(b.rd){var c=function(a,c){return cTa(a,c,b.t,!0,!1)};Zj(b.rd,function(b,d){var e=this.Qja[d];e&&dTa(e[0],e[1],b,c,a)},this)}if(b.Zc){var d=function(a,c){return cTa(a,c,b.t,!1,!0)};Zj(b.Zc,function(b,c){var e=this.Rja[c];e&&dTa(e[0],e[1],b,d,a)},this)}if(this.fj&&this.Um){b.g=[];for(var e=0;e<this.fj[J];++e){var f=this.fj[e],g=this.Um[e],k=mk(g);if(f&&g&&f[H]==g[H]){if(f.l&&g.l){k.l=[];for(var l=0;l<f.l[J];l++)k.l[l]=$Sa(f.l[l],g.l[l],a);if(f.WB&&g.WB)for(l=
0;l<f.WB[J];l++)k.l[B]($Sa(f.WB[l],g.WB[l],a))}f.wf&&f.wf[aB]&&g.wf&&g.wf[aB]&&(k.wf=mk(k.wf),k.wf.paths=XY(f.wf[aB],g.wf[aB],a))}b.g[e]=k}}b[z]&&Ta(b,XY(this.Rr[z],this.mx[z],a));b[r]&&na(b,XY(this.Rr[r],this.mx[r],a));b.t&&(b.t=XY(this.Rr.t,this.mx.t,a));if(this.l8&&this.m8&&b.Ea&&b.Ea.gu)for(e=0;e<b.Ea.gu[J];e++){f=b.Ea.gu[e];g=this.l8[e];k=this.m8[e];if(f.za&&f.za.I&&g.za&&g.za.I&&!Ej(g.za.I)&&k.za&&k.za.I)for(var n=f.za.I,p=g.za.I,t=k.za.I,u=p[J],l=0;l<n[J];l++){var x=l<u?p[l]:p[u-1];n[l].x=
XY(x.x,t[l].x,a);n[l].y=XY(x.y,t[l].y,a)}f.gc&&f.gc[$A]&&g.gc&&g.gc[$A]&&k.gc&&k.gc[$A]&&(l=XY(g.gc[$A],k.gc[$A],a),Hy(f.gc,new xm(l[G],l.top,l[r],l[z])));f.Ig&&f.Ig[$A]&&g.Ig&&g.Ig[$A]&&k.Ig&&k.Ig[$A]&&Hy(f.Ig,XY(g.Ig[$A],k.Ig[$A],a))}return b};function YY(a){this.Dz=a}
YY[K].Fw=function(a,b,c,d){var e=[],f=b.Sa,g=a.Sa;if(f.ob!=g.ob||f[sA]!=g[sA])null!=g.ob&&e[B](ZY(PF,g.ob,g[sA],c,d)),null!=f.ob&&e[B](ZY(OF,f.ob,f[sA],c,d));f.mb!=g.mb&&(null!=g.mb&&(g=g.mb,e[B]({type:PF,data:{row:g,column:null}})),null!=f.mb&&(g=f.mb,e[B]({type:OF,data:{row:g,column:null}})));f=b[sB].Sa;g=a[sB].Sa;!g||f&&f.row==g.row&&f.Db==g.Db||e[B]({type:PF,data:{row:g.row,column:g.Db}});!f||g&&f.row==g.row&&f.Db==g.Db||e[B]({type:OF,data:{row:f.row,column:f.Db}});f=b.Ea.Sa;g=a.Ea.Sa;f.Ah!=g.Ah&&
(null!=g.Ah&&e[B](ZY(PF,g.Ah,null,c,d)),null!=f.Ah&&e[B](ZY(OF,f.Ah,null,c,d)));b[$z][gs](a[$z])||e[B]({type:cu});X(e,U(function(a){this[ir](a[H],a[Y])},this))};wq(YY[K],function(a,b){ew(this.Dz,a,b||null)});function ZY(a,b,c,d,e){b=e[b];d==BF?(c=b.Ht,d=null):d=b.Ht;return{type:a,data:{row:c,column:d}}};function $Y(a,b){return Lk(a.x,b[G],b[G]+b[r])===a.x&&Lk(a.y,b.top,b.top+b[z])===a.y?!0:!1};function eTa(a,b){this.mv=a;this.nv=b};function fTa(a,b,c,d,e,f){var g=a.rd[0]?0:1,k=a.Zc[0]?0:1,l=a.rd[g];a=a.Zc[k];var n=l[TA]&&VNa(l[TA]).ck,p=a[TA]&&VNa(a[TA]).ck;this.Wj=b;this.Py=U(function(a){return n?n(this.Wj.getHAxisValue(a,g)):a},this);this.Qy=U(function(a){return p?p(this.Wj.getVAxisValue(a,k)):a},this);b=this.Wj.getChartAreaBoundingBox();this.rn=this.Py(b[G]);this.sn=this.Qy(b.top+b[z]);this.Oo=this.Py(b[G]+b[r]);this.Po=this.Qy(b.top);this.rS=this.rn;this.sS=this.sn;this.pS=this.Oo-this.rn;this.oS=this.Po-this.sn;Na(this,
1);this.eqa=c;this.q2=d;this.Wca=e;this.wS=f};function aZ(a,b,c){this.ls=c;this.Pa=a;this.Oj=b;this.Rg=null}R=aZ[K];Nq(R,function(){return this.Pa});R.Xw=function(a){this.Rg=a};R.Az=function(){};R.yz=function(){};R.zz=function(){};R.$E=function(){};R.yE=function(){};R.zE=function(){};R.uE=function(){};R.tE=function(){};R.Ye=function(){};
R.updateOptions=function(){var a={hAxis:{viewWindowMode:wI,viewWindow:{}},vAxis:{viewWindowMode:wI,viewWindow:{}}};this.Pa.ao=a;this.ls.mv&&(fa(this.Rg.rn)||(a.hAxis.viewWindow.numericMin=this.Rg.rn),fa(this.Rg.Oo)||(a.hAxis.viewWindow.numericMax=this.Rg.Oo));this.ls.nv&&(fa(this.Rg.sn)||(a.vAxis.viewWindow.numericMin=this.Rg.sn),fa(this.Rg.Po)||(a.vAxis.viewWindow.numericMax=this.Rg.Po))};function gTa(a,b,c){aZ[L](this,a,b,c);this.Aa=null}W(gTa,aZ);R=gTa[K];R.Az=function(a){var b=this.Oj().getChartAreaBoundingBox();$Y(a,b)&&(this.Aa={x:a.x,y:a.y,Cd:0,ke:0})};R.yz=function(a){if(this.Aa){var b=a.x;a=a.y;this.Aa={Cd:b-this.Aa.x,ke:a-this.Aa.y,x:b,y:a};this.LE()}};R.zz=function(){this.Aa=null};R.Ye=function(a,b){var c=this.Oj().getChartAreaBoundingBox();$Y(a,c)&&b()};
R.LE=function(){var a=this.Rg;if(a){var b=this.Oj();a.Wj=b;var c=this.ls;if(c.mv){var b=this.Aa.x-this.Aa.Cd,d=a.Py(this.Aa.x)-a.Py(b),e=a.rn-d,f=a.Oo-d,b=h.max(e,a.rS),g=h.min(f,a.rS+a.pS);if(a.wS&&(b===e||0>d)&&(g===f||0<d)||!a.wS)a.rn=e,a.Oo=f}c.nv&&(b=this.Aa.y-this.Aa.ke,c=a.Qy(this.Aa.y)-a.Qy(b),d=a.sn-c,e=a.Po-c,b=h.max(d,a.sS),g=h.min(e,a.sS+a.oS),a.wS&&(b===d||0>c)&&(g===e||0<c)||!a.wS)&&(a.sn=d,a.Po=e);this[DB]()}};function hTa(a,b,c){aZ[L](this,a,b,c);this.Aa=null}W(hTa,aZ);R=hTa[K];R.Az=function(a){var b=this.Oj().getChartAreaBoundingBox();$Y(a,b)&&(this.Aa={dv:a.x,rl:a.y,B3:0,C3:0})};
R.yz=function(a){if(this.Aa){var b=this.Oj().getChartAreaBoundingBox(),c=this.ls;this.v3(a,b);this.Aa.B3=a.x;this.Aa.C3=a.y;if(c.mv){a=h.min(this.Aa.dv,this.Aa.B3);var d=h.abs(this.Aa.dv-this.Aa.B3)}else a=b[G],d=b[r];c.nv?(c=h.min(this.Aa.rl,this.Aa.C3),b=h.abs(this.Aa.rl-this.Aa.C3)):(c=b.top,b=b[z]);this[Qr]().ci={left:a,top:c,width:d,height:b,color:zK,opacity:.2}}};R.zz=function(){this.Aa&&(this.LE(),this.Aa=null)};
R.LE=function(){var a=this.ls,b=this.Rg,c=this.Oj();b.Wj=c;var d=this[Qr]().ci,e=b.Py(d[G]),f=b.Py(d[G]+d[r]),c=b.Qy(d.top),d=b.Qy(d.top+d[z]);if(e!==f&&c!==d){var g=b.pS*b.q2;if(a.mv){var k=h.min(e,f),e=h.max(e,f);e-k<g&&(e=(k+e)/2,k=e-g/2,e+=g/2);b.rn=k;b.Oo=e}g=b.oS*b.q2;a.nv&&(a=h.min(c,d),c=h.max(c,d),c-a<g&&(e=(a+c)/2,a=e-g/2,c=e+g/2),b.sn=a,b.Po=c);this[DB]()}};R.v3=function(a,b){a.x=Lk(a.x,b[G],b[G]+b[r]);a.y=Lk(a.y,b.top,b.top+b[z])};function iTa(a,b,c){aZ[L](this,a,b,c);this.Aa=null}W(iTa,aZ);R=iTa[K];R.$E=function(a){var b=this.Oj().getChartAreaBoundingBox();$Y(a,b)&&(this.Aa={x:a.x,y:a.y,scale:a.gesture[bB],xda:1})};R.yE=function(a){if(this.Aa){var b=this.Oj().getChartAreaBoundingBox();this.v3(a,b);this.Aa.xda=this.Aa[bB];Na(this.Aa,a.gesture[bB]);this.LE()}};R.zE=function(){this.Aa&&(this.LE(),this.Aa=null)};
R.LE=function(){var a=this.Rg,b=this.Oj();a.Wj=b;if(a){var b=1-(this.Aa.xda-this.Aa[bB]),c=a.Py(this.Aa.x),d=a.Oo-c;a.rn=c-(c-a.rn)/b;a.Oo=c+d/b;c=a.Qy(this.Aa.y);d=a.Po-c;a.sn=c-(c-a.sn)/b;a.Po=c+d/b;this[DB]()}};R.v3=function(a,b){a.x=Lk(a.x,b[G],b[G]+b[r]);a.y=Lk(a.y,b.top,b.top+b[z])};function jTa(a,b,c){aZ[L](this,a,b,c)}W(jTa,aZ);jTa[K].tE=function(){var a=this.Rg;Na(a,1);a.rn=a.rS;a.Oo=a.rS+a.pS;a.sn=a.sS;a.Po=a.sS+a.oS;this[DB]()};function kTa(a,b,c){aZ[L](this,a,b,c)}W(kTa,aZ);kTa[K].uE=function(a,b){var c=this.ls,d=this.Oj().getChartAreaBoundingBox();if($Y(a,d)){b();d=this.Rg;if(0>a.wheelDelta){if(d[bB]>=d.eqa)return;Na(d,d[bB]*d.Wca)}else{if(d[bB]<=d.q2)return;Na(d,d[bB]/d.Wca)}if(c.mv){var e=(d.Oo+d.rn)/2,f=d.pS*d[bB]/2;d.rn=e-f;d.Oo=e+f}c.nv&&(c=(d.Po+d.sn)/2,e=d.oS*d[bB]/2,d.sn=c-e,d.Po=c+e);this[DB]()}};var lTa=[{isEnabled:function(a){a=a.Q(uI);return null==a||Oi(a)&&Dj(a,zva)?!0:!1},constructor:gTa},{isEnabled:function(a){a=a.Q(uI);return Oi(a)&&Dj(a,yva)?!0:!1},constructor:hTa},{isEnabled:function(a){a=a.Q(uI);return null==a||Oi(a)&&Dj(a,hpa)?!0:!1},constructor:jTa},{isEnabled:function(a){a=a.Q(uI);return Oi(a)&&Dj(a,Nqa),!1},constructor:iTa},{isEnabled:function(a){a=a.Q(uI);return null==a||Oi(a)&&Dj(a,bpa)?!0:!1},constructor:kTa}];function mTa(a,b,c,d){if(c.Q(qi)===BF)throw m("Cannot use explorer with a pie chart");this.b=c;this.Pa=a;this.ls=null;this.Oj=b;this.S=d;this.Rg=null;this.Fo=[];nTa(this)}R=mTa[K];R.Xw=function(){var a=Po(this.b,Yua,4);1>a&&(a=1/a);var b=Po(this.b,Zua,.25);1<b&&(b=1/b);var c=Po(this.b,Xua,1.5),d=Lo(this.b,$ua,!1);this.Rg=new fTa(this.S,this.Oj(),a,b,c,d);X(this.Fo,function(a){a.Xw(this.Rg)},this)};
function nTa(a){var b=a.S.rd[0]?0:1,c=a.S.Zc[0]?0:1,d=a.S.rd[b],e=a.S.Zc[c],b=!a.S.rd[1-b]&&d[H]===ti&&!d.mp,c=!a.S.Zc[1-c]&&e[H]===ti&&!e.mp,e=a.b.Q(vI)[wC];e===th?c=!1:e===ui&&(b=!1);a.ls=new eTa(b,c);X(lTa,function(a){a[VA](this.b)&&this.Fo[B](new a[Bc](this.Pa,this.Oj,this.ls))},a)}R.Az=function(a){X(this.Fo,function(b){b.Az(a)},this)};R.yz=function(a){X(this.Fo,function(b){b.yz(a)},this)};R.zz=function(a){X(this.Fo,function(b){b.zz(a)},this)};R.tE=function(a){X(this.Fo,function(b){b.tE(a)},this)};
R.uE=function(a,b){X(this.Fo,function(c){c.uE(a,b)},this)};R.Ye=function(a,b){X(this.Fo,function(c){c.Ye(a,b)},this)};R.$E=function(a,b){X(this.Fo,function(c){c.$E(a,b)},this)};R.yE=function(a,b){X(this.Fo,function(c){c.yE(a,b)},this)};R.zE=function(a,b){X(this.Fo,function(c){c.zE(a,b)},this)};var oTa=[{isEnabled:function(a){return a.Q(vI)?!0:!1},constructor:mTa}];function pTa(a,b,c,d){this.b=a;this.o=b;this.Oj=c;this.S=d;this.Go=[];this.bb=null;qTa(this)}function qTa(a){a.b&&X(oTa,function(a){a[VA]&&a[VA](this.b)&&this.Go[B](new a[Bc](this.o,this.Oj,this.b,this.S))},a)}R=pTa[K];R.zz=function(a){X(this.Go,function(b){b.zz(a)});XS(this.bb,15)};R.yz=function(a){X(this.Go,function(b){b.yz(a)});XS(this.bb,5)};R.Az=function(a){X(this.Go,function(b){b.Az(a)});XS(this.bb,5)};R.uE=function(a,b){X(this.Go,function(c){c.uE(a,b)});XS(this.bb,5)};
R.tE=function(a){X(this.Go,function(b){b.tE(a)});XS(this.bb,5)};R.Ye=function(a,b){X(this.Go,function(c){c.Ye(a,b)})};R.$E=function(a,b){X(this.Go,function(c){c.$E(a,b)})};R.yE=function(a,b){X(this.Go,function(c){c.yE(a,b)});XS(this.bb,5)};R.zE=function(a,b){X(this.Go,function(c){c.zE(a,b)});XS(this.bb,15)};R.Xw=function(){X(this.Go,function(a){a.Xw()})};function bZ(a,b,c,d,e,f){Ju[L](this);this.S=a;this.Pa=b;this.Yn=c;this.hf=d;this.bb=new WS(e);Ku(this,this.bb);this.To=f;this.To.bb=this.bb;this.HY()}W(bZ,Ju);R=bZ[K];R.D=function(){fv(this.Yn);bZ.e.D[L](this)};R.Psa=function(a){Ba(this.Pa[zA],a[Y].xb);XS(this.bb,5)};R.Qsa=function(){};R.Ssa=function(a){Ba(this.Pa[zA],a[Y].xb);this.hf[ir](QF,{targetID:a[Y].ye,x:a[Y].xb.x,y:a[Y].xb.y})};R.Tsa=function(a){this.hf[ir](pra,{targetID:a[Y].ye,x:a[Y].xb.x,y:a[Y].xb.y})};
R.Rsa=function(a){var b={targetID:a[Y].ye,x:a[Y].xb.x,y:a[Y].xb.y};this.hf[ir](qra,b);this.To.Ye(b,a[Y][hr])};R.Ksa=function(a){this.hf[ir](vt,{targetID:a[Y].ye,x:a[Y].xb.x,y:a[Y].xb.y})};R.Xsa=function(a){a={targetID:a[Y].ye,x:a[Y].xb.x,y:a[Y].xb.y};this.hf[ir](YE,a);this.To.tE(a)};R.Lsa=function(a){this.hf[ir](QI,{targetID:a[Y].ye,x:a[Y].xb.x,y:a[Y].xb.y})};R.Ysa=function(a){var b={targetID:a[Y].ye,x:a[Y].xb.x,y:a[Y].xb.y,wheelDelta:a[Y].wheelDelta};this.hf[ir](ME,b);this.To.uE(b,a[Y][hr])};
R.Nsa=function(a){a={targetID:a[Y].ye,x:a[Y].xb.x,y:a[Y].xb.y};this.hf[ir](wva,a);this.To.Az(a)};R.Osa=function(a){a={targetID:a[Y].ye,x:a[Y].xb.x,y:a[Y].xb.y};this.hf[ir](GI,a);this.To.yz(a)};R.Msa=function(a){a={targetID:a[Y].ye,x:a[Y].xb.x,y:a[Y].xb.y};this.hf[ir](xva,a);this.To.zz(a)};R.Vsa=function(a){this.To.$E({targetID:a[Y].ye,x:a[Y].xb.x,y:a[Y].xb.y,gesture:a[Y].Dea},a[Y][hr])};R.Wsa=function(a){this.To.yE({targetID:a[Y].ye,x:a[Y].xb.x,y:a[Y].xb.y,gesture:a[Y].Dea},a[Y][hr])};
R.Usa=function(a){this.To.zE({targetID:a[Y].ye,x:a[Y].xb.x,y:a[Y].xb.y,gesture:a[Y].Dea},a[Y][hr])};R.Isa=function(a){this.Pa.Sa.mb=a[Y].ej;XS(this.bb,50)};R.Jsa=function(){Ba(this.Pa[zA],null);this.Pa.Sa.mb=null;XS(this.bb,50)};R.Hsa=function(a){var b=this.S;this.Pa[zA].qY=this.Pa[zA][tc][Jc]();a=a[Y].ej;yj(b.g,function(a){return a.Zg})&&(yx(this.Pa[$z],b.Ga[a].Ht,b.jA==ei),XS(this.bb,0))};R.xea=function(a){this.S.ab!=oK&&(this.Pa.Ea.Sa.Ah=a[Y].UR,XS(this.bb,50))};
R.yea=function(){this.S.ab!=oK&&(this.Pa.Ea.Sa.Ah=null,XS(this.bb,250))};R.bta=function(a){this.S.ab!=oK&&(rTa(this,a[Y].UR),XS(this.bb,0))};R.cta=function(a){null==this.Pa.Ea.jD&&(this.Pa.Ea.jD=0);this.Pa.Ea.jD+=a[Y].Tpa;XS(this.bb,0)};R.Xaa=function(a){if(this.S.ab!=oK){var b=this.S.bA;if(this.S.ai==HE||b==II)this.Pa.Sa.ob=a[Y].$b,XS(this.bb,50)}};R.Ica=function(){if(this.S.ab!=oK){var a=this.S.bA;if(this.S.ai==HE||a==II)this.Pa.Sa.ob=null,XS(this.bb,250)}};
R.U9=function(a){this.S.ab!=oK&&this.S.ai==HE&&(rTa(this,a[Y].$b),XS(this.bb,0))};R.eta=function(a){this.xea(a)};R.fta=function(){this.yea()};R.dta=function(a){this.hf[ir](Upa,{index:a[Y].UR})};R.$sa=function(a){this.S.ai==HE?this.Xaa(a):(this.Pa.Sa.ob=a[Y].$b,this.Pa.Sa.datum=a[Y].ej,XS(this.bb,50))};R.ata=function(){this.S.ai==HE?this.Ica():(sTa(this),XS(this.bb,250))};
R.Zsa=function(a){var b=this.S;if(b.ai==HE)this.U9(a);else{var c=b.jA==ei;a={mb:a[Y].ej,ob:a[Y].$b};var d=b.g[a.ob];d.Zg&&(b.ab==oK?yx(this.Pa[$z],a.mb,c):d.jg||(b=b.iZ(a),this.S.ai==HE?zx(this.Pa[$z],b.Db,c):Ax(this.Pa[$z],b.row,b.Db,c)));XS(this.bb,0)}};R.yaa=function(a){var b=a[Y].Zx;-1!=b&&(this.Pa[sB].Sa={row:a[Y].ej,Db:tTa(this,a[Y].$b,b)},sTa(this),XS(this.bb,50))};R.Waa=function(a){-1!=a[Y].Zx&&(this.Pa[sB].Sa=null,XS(this.bb,250))};
R.Gsa=function(a){var b=this.S,c=b.jA==ei,d=a[Y].ej,e=a[Y].$b;a=a[Y].Zx;if(null==e||b.g[e].Zg)-1==a?this.Pa[sB].UM={$b:e,hW:d}:Ax(this.Pa[$z],d,tTa(this,e,a),c);XS(this.bb,0)};R.gta=function(a){if(null===a[Y].Zx){switch(this.S.ai){case RI:this.Pa.Sa.datum=a[Y].ej;this.Pa.Sa.ob=a[Y].$b;break;case HE:this.Pa.Sa.ob=a[Y].$b;break;case gK:this.Pa.Sa.mb=a[Y].ej}XS(this.bb,50)}else this.yaa(a)};
R.hta=function(a){if(null===a[Y].Zx){switch(this.S.ai){case RI:sTa(this);break;case HE:this.Pa.Sa.ob=null;break;case gK:Ba(this.Pa[zA],null),this.Pa.Sa.mb=null}XS(this.bb,750)}else this.Waa(a)};R.Esa=function(a){this.Pa.Ph.Sa.qx=a[Y].qx;XS(this.bb,50)};R.Fsa=function(){this.Pa.Ph.Sa.qx=null;XS(this.bb,250)};R.Dsa=function(){this.Pa.Ph.Sa[dB]&&this.Pa.Ph.Sa[dB]();XS(this.bb,250)};R.Xw=function(){this.To.Xw()};function sTa(a){a.Pa.Sa.ob=null;a.Pa.Sa.datum=null}
function tTa(a,b,c){a=a.S;var d=null;if(null!=b)d=a.g[b].ia.annotation;else for(b=0;b<a.rk[J];++b)d=a.rk[b].ia.annotation;return d[c]}
R.HY=function(){var a=U(function(a,c){$u(this.Yn,a,U(c,this))},this);a(xxa,this.Psa);a(wxa,this.Qsa);a(uxa,this.Ssa);a(txa,this.Tsa);a(vxa,this.Rsa);a(Cxa,this.Ksa);a(oxa,this.Xsa);a(Bxa,this.Lsa);a(nxa,this.Ysa);a(yxa,this.Nsa);a(Axa,this.Osa);a(zxa,this.Msa);a(pxa,this.Vsa);a(rxa,this.Wsa);a(qxa,this.Usa);a(Sxa,this.Isa);a(Rxa,this.Jsa);a(Txa,this.Hsa);a(rsa,this.xea);a(qsa,this.yea);a(ssa,this.bta);a(nsa,this.cta);a(Xoa,this.Xaa);a(Woa,this.Ica);a(Yoa,this.U9);a(Xpa,this.eta);a(Wpa,this.fta);a(Ypa,
this.dta);a(fwa,this.$sa);a(ewa,this.ata);a(gwa,this.Zsa);a(aza,this.yaa);a($ya,this.Waa);a(bza,this.Gsa);a(pna,this.gta);a(ona,this.hta);a(zza,this.Esa);a(yza,this.Fsa);a(Aza,this.Dsa)};function rTa(a,b){var c=a.S;if(c.g[b].Zg){var d=c.jA==ei,e=c.g[b].Ht;c.ab==BF?yx(a.Pa[$z],e,d):zx(a.Pa[$z],e,d)}};function cZ(a,b){lX[L](this,a,b);this.qO=this.Of=null}W(cZ,lX);R=cZ[K];R.P9=function(a,b){var c=this.J;if(1>a.g[J])return!1;this.Of=b;for(var d=a.pie.bi,e=a.g[J]/d[J],f=0;f<d[J];++f){for(var g=d[f].bd,k=d[f].cd,l=d[f].FN,n=f*e,p=n+e;n<p&&180>a.g[n].od;)dZ(this,a.g[n],g,k),n+=1;l&&dZ(this,l,g,k);for(l=p-1;l>=n;--l)dZ(this,a.g[l],g,k)}a.np&&(this.qO=c.Ba(),uTa(this,a.np),c[q](this.Of,this.qO));return!0};
R.uX=function(a,b){if(this.Gb.WV){var c=a.gc[$A][z],d=a.gc[$A][G]+a.gc[$A][r]/2,e=a.gc[$A].top+c/2,f=a.gc.brush[Jc]();f.Eg(1);mX(this,d,e,c/2,f,{type:NJ},b)}else cZ.e.uX[L](this,a,b)};
function dZ(a,b,c,d){if(b.W){var e=a.J.Ba(),f=a.Gb,g=f.pie[Gz],k=b[tA];if(b.Wb){var l=f.pie.cA,n=b.Wb,p=new bO;p[yB](k.x+n.jf.x,k.y+n.jf.y);p.ha(k.x+n.jf.x,k.y+n.jf.y+l);p.zf(k.x+g.x,k.y+g.y+l,c,d,n.Ud,n.od,!0);p.ha(k.x+n.Bh.x,k.y+n.Bh.y);p.zf(k.x+g.x,k.y+g.y,c,d,n.od,n.Ud,!1);a.J.ta(p,n.brush,e)}if(b.St||b.Hw)l=f.pie.cA,n=new bO,n[yB](k.x+g.x,k.y+g.y),n.ha(k.x+g.x,k.y+g.y+l),b.Hw&&(n.ha(k.x+b.Bh.x,k.y+b.Bh.y+l),n.ha(k.x+b.Bh.x,k.y+b.Bh.y)),b.St&&(n.ha(k.x+b.jf.x,k.y+b.jf.y+l),n.ha(k.x+b.jf.x,k.y+
b.jf.y)),a.J.ta(n,b.PM,e);n=b.xw?b.xw.brush:b.brush;b.wr?0==b.QF&&0==b.yA?a.J.zj(g.x,g.y,c,d,n,e):(p=new bO,p[yB](g.x,g.y-d),p.zf(g.x,g.y,c,d,0,180,!0),p.zf(g.x,g.y,c,d,180,360,!0),p[yB](g.x,g.y-b.yA),p.zf(g.x,g.y,b.QF,b.yA,360,180,!1),p.zf(g.x,g.y,b.QF,b.yA,180,0,!1),p[Hr](),a.J.ta(p,n,e)):(p=new bO,p[yB](k.x+b.oA.x,k.y+b.oA.y),p.ha(k.x+b.jf.x,k.y+b.jf.y),p.zf(k.x+g.x,k.y+g.y,c,d,b.Ud,b.od,!0),p.ha(k.x+b.Nt.x,k.y+b.Nt.y),p.zf(k.x+g.x,k.y+g.y,b.QF,b.yA,b.od,b.Ud,!1),a.J.ta(p,n,e));b.Li&&f.X5&&vTa(a,
b.Li,e);if(c=b.Wn){c.Wb&&(d=new bO,d[yB](c.Wb.jf.x,c.Wb.jf.y),d.ha(c.Wb.jf.x,c.Wb.jf.y+l),d.zf(c.Wb.Kh.x,c.Wb.Kh.y+l,c.Wb.bd,c.Wb.cd,c.Wb.Ud,c.Wb.od,!0),d.ha(c.Wb.Bh.x,c.Wb.Bh.y),d.zf(c.Wb.Kh.x,c.Wb.Kh.y,c.Wb.bd,c.Wb.cd,c.Wb.od,c.Wb.Ud,!1),a.J.ta(d,c.Wb.brush,e));if(c.St||c.Hw)d=new bO,d[yB](c.dB.x,c.dB.y),d.ha(c.cN.x,c.cN.y),d.ha(c.cN.x,c.cN.y+l),d.ha(c.dB.x,c.dB.y+l),d.ha(c.dB.x,c.dB.y),a.J.ta(d,c.PM,e);vTa(a,c,e)}b.lW&&a.J.Jd(b[pd],b.mW.x+k.x,b.mW.y+k.y,b.YM[r],TD,TD,b.ba,e);k=RS([$D,b[xc]]);e=
e.a();a.Ce(a.Of,k,e);b.rb&&(e=RS([wu,b[xc]]),a.iG(b.rb,e))}}function vTa(a,b,c){if(b.wr)a.J.zj(b.Kh.x,b.Kh.y,b.bd,b.cd,b.brush,c);else{var d=new bO;d[yB](b.jf.x,b.jf.y);d.zf(b.Kh.x,b.Kh.y,b.bd,b.cd,b.Ud,b.od,!0);a.J.ta(d,b.brush,c)}}
function uTa(a,b){for(var c=U(a.Xt,a),d=U(a[eA],a),e=a.J,f=a.qO,g=0;g<b[J];++g){var k=b[g],l=e.Ba(),n=e.Ba(),p=new bO;p[yB](k.cj.x+.5,k.cj.y+.5);p.ha(k.A7+.5,k.cj.y+.5);p.ha(k.A7+.5,k.Mr.y+.5);p.ha(k.Mr.x+.5,k.Mr.y+.5);e.ta(p,k.Hc,n);e.ce(k.cj.x+.5,k.cj.y+.5,k.z7,k.Via,n);c(k.RA,l);c(k.TA,l);e[q](f,l);e[q](f,n);k=RS([SG,k[xc]]);d(l.a(),k)}}R.l6=function(a,b){if(!Bo(b.np,this.mr.np)){this.J.Oc(this.qO);var c=new DT(2);ET(c,0,a.np||{});ET(c,1,b.np||{});c=c[iB]();uTa(this,c)}this.RM(a);this.j3(a,b)};
R.RM=function(a){var b=this.mr;if(b)for(var c in b.g){if(b.g[c].rb){var d=RS([wu,ha(c)]);nX(this,d)}d=a.pie.bi[c<a.g[J]/a.pie.bi[J]?0:1];dZ(this,a.g[c],d.bd,d.cd)}};R.j3=function(a,b){for(var c in b.g){var d=new DT(2);ET(d,0,a.g[c]);ET(d,1,b.g[c]);var e=a.pie.bi[c<a.g[J]/a.pie.bi[J]?0:1],f=e.bd,e=e.cd;dZ(this,d[iB](),f,e)}};function wTa(a,b,c,d,e){var f=a[kd]-a[G],g=mk(d),k=mk(d);Ya(k,MCa);d=d[Gc]/3.236;var l=g[Gc]+d,n=k[Gc]+d,p=xTa(a,f,b,g,k,d,e),t=[],u;2==c?(c=a[kd],a=a[G],u=zI):(c=a[G],a=a[kd],u=TD);for(var x=0;x<e[J];++x){var A=e[x],C=p[x];if(null!=C){var E=fT(b,A.RA,g,f,C.QJ),Q=fT(b,A.TA,k,f,C.RJ),N=KQa(new oO(c,C.y));t[B]({z7:2,cj:KQa(A.g8(Lk(C.y,A.OO[y],A.OO.end))),A7:a,Mr:N,Via:new lo({fill:pM,fillOpacity:.7}),Hc:new lo({stroke:pM,strokeWidth:1,strokeOpacity:.7}),zya:d,RA:{text:A.RA,ba:g,anchor:new fV(N.x,N.y),
I:wj(E.I,function(a,b){return{x:0,y:(b-E.I[J])*l,length:E.Hr,text:a}}),Gc:u,Fc:TD,rb:E.re?A.RA:M,Eb:0},wya:g,TA:{text:A.TA,ba:k,anchor:new fV(N.x,N.y),I:wj(Q.I,function(a,b){return{x:0,y:(b+1)*n,length:Q.Hr,text:a}}),Gc:u,Fc:zI,rb:Q.re?A.TA:M,Eb:0},yya:k,xya:u,index:A[xc]})}}return t}
function xTa(a,b,c,d,e,f,g){var k=d[Gc]+f,l=e[Gc]+f,n=wj(g,function(a,g){var k=fT(c,a.RA,d,b,da),l=fT(c,a.TA,e,b,da);return{eL:g,X2:a.Y9,vz:a.Y9,QJ:k.I[J],RJ:l.I[J],CT:f,DT:f}});Qj(n,function(a,b){return a.vz-b.vz});n=Lj(n);Qj(n,function(a,b){return g[a.eL].X9-g[b.eL].X9});var p=[];0<n[J]&&p[B](n.pop());for(var t=null,u=0,x;x=yTa(a,k,l,g,p,!1),!(0===n[J]||x.fL&&15<u);)x.fL?(u++,t&&Ij(p,t)):u=0,t=n.pop(),p[B](t),Qj(p,function(a,b){return a.vz-b.vz});x.fL&&t&&(Ij(p,t),x=yTa(a,k,l,g,p,!1));a=yTa(a,k,
l,g,p,!0);a.fL||(x=a);return x[Mz]}function yTa(a,b,c,d,e,f){0<e[J]&&(e[0].CT=0,qj(e).DT=0);for(var g=0;g<e[J];g++){var k=e[g],l=e[g-1],n=e[g+1],n=n?d[n.eL].OO.end-5:a[Uc];k.Lfa=new Yn(h.min(k.X2,l?d[l.eL].OO[y]+5:a.top),h.max(k.X2,n))}a=zTa(a,b,c,e,f);d=!1;f={};for(g=0;g<e[J];g++){var k=e[g],l=a[g],n=(l[lC]-l.top-k.CT)/b,p=(l[Uc]-l[lC]-k.DT)/c,n=h[Eb](n+.1),p=h[Eb](p+.1),t=n<k.QJ||p<k.RJ;d=d||t;f[k.eL]={y:l[lC],QJ:n,RJ:p,fL:t}}return{layout:f,fL:d}}
function zTa(a,b,c,d,e){var f=ak(d,function(a){return{anchor:a.vz,top:a.vz-(a.QJ*b+a.CT),bottom:a.vz+(a.RJ*c+a.DT)}}),g=[];g[B](function(b,c){var d=b[c].top;return 0==c?{top:h.max(a.top-d,0)}:{top:h.max(b[oj(c)-1][Uc]-d,0)/2}});g[B](function(b,c){var e=b[c][Uc];return c==d[J]-1?{bottom:h.min(a[Uc]-e,0)}:{bottom:h.min(b[oj(c)+1].top-e,0)/2}});g[B](function(a,c,f){var g=a[c][lC]-a[c].top;a=h.max(-g,0);c=d[c];c=h.max(c.QJ*b+c.CT-h.max(g,0),0);f=(a+c*(e?1:f))/2;return{anchor:f,top:-f}});g[B](function(a,
b,f){var g=a[b][Uc]-a[b][lC];a=h.max(-g,0);b=d[b];b=h.max(b.RJ*c+b.DT-h.max(g,0),0);f=(a+b*(e?1:f))/2;return{anchor:-f,bottom:f}});g[B](function(a,b){var c=a[b][lC],e=d[b];return{anchor:Lk(c,e.Lfa[y],e.Lfa.end)-c}});e&&g[B](function(a,b,c){return{anchor:(d[b].X2-a[b][lC])*c}});var k=lKa(f,g,function(a,b){return{anchor:a[lC]+(b[lC]||0),top:a.top+(b.top||0),bottom:a[Uc]+(b[Uc]||0)}},function(a,b){return h.max(h.abs(a[lC]-b[lC]),h.abs(a.top-b.top),h.abs(a[Uc]-b[Uc]))});return wj(d,function(a,b){var c=
k[String(b)];return{anchor:c[lC],top:c.top,bottom:c[Uc]}})}function ATa(a,b){var c=Bj(a,function(a){return a[xc]==b});if(0>c)return{};var d={};d[c]={z7:4,Hc:new lo({stroke:pM,strokeWidth:2,strokeOpacity:.7})};return d};function eZ(a,b,c,d,e){this.sb=b.Q(mJ,VW);this.n9=Po(b,Oqa,0);this.fla=0>Po(b,ah,1);AX[L](this,a,b,c,d,e)}W(eZ,AX);eZ[K].HI=function(){return[U(function(){this.R.ai=HE;this.R.kd=Lo(this[Nr],ata);this.R.Rc&=!this.R.kd;this.R.kd&&(this.R.zh=this.R.zh||{},this.R.zh.pie=this.R.zh.pie||{},this.R.zh.pie.E6=this[Nr].Q(Rva,!0),this.R.zh.pie.sW=this[Nr].Q(Vva,.6));for(var a=0;a<this.Sb.O();a++)if(0>this.Sb[I](a,1))throw m("Negative values are invalid for a pie chart.");},this),U(AX[K].HI,this)]};
eZ[K].f9=function(){return au};eZ[K].e9=function(){return null};
eZ[K].d9=function(){return[U(function(){var a=this.jp();if(this.Sb.G(0)!=ii)throw m("Pie chart should have a first column of type string");var b;b=this.R;var c=b.t,d=this.xf[UA](),e=null,f=null,g=h[D](1.618*b.wm),e=h[D](c[r]*(1-1/1.618)-g);d==Ch?(f=new um(c.top,c[G]+e,c[Uc],c[G]),e=new um(c.top,c[kd],c[Uc],f[kd]+g)):d==au?(f=new um(c.top,c[kd],c[Uc],c[kd]-e),e=new um(c.top,f[G]-g,c[Uc],c[G])):d==sK?(e=new um(c.top,c[kd],c.top+1/1.618*(c[Uc]-c.top-g),c[G]),f=new um(e[Uc]+g,c[kd],c[Uc],c[G])):e=new um(c.top,
c[kd],c[Uc],c[G]);var c=0,d=h.min(e[kd]-e[G],e[Uc]-e.top),k=g=h[Eb](d/2),d=h[D]((e[kd]+e[G])/2),e=h[D]((e[Uc]+e.top)/2);b.Rc&&(k*=.8,c=g/5,e-=c/2);if(b.kd){var l={bd:g*b.zh.pie.sW,cd:k*b.zh.pie.sW},g={bd:g,cd:k};b={pie:{center:new oO(d,e),bd:g.bd,cd:g.cd,cA:c,bi:b.zh.pie.E6?[l,g]:[g,l]},Ea:f}}else b={pie:{center:new oO(d,e),bd:g,cd:k,cA:c,bi:[{bd:g,cd:k}]},Ea:f};BTa(this,b);f=this.xf[UA]();b.Ea?this.xf.lp(b.Ea):f==uK?this.xf.lp(CTa(this)):f==aH&&DTa(this,a.t,b,this.xf.Ma)},this)]};
function ETa(a,b,c){var d=a.R,e={},f=Zo(a[Nr],zF,M);a=b[F];var g=b.wb;b=b.jj;var k;d.Rc?(d=a,k=g,f=b):k=d=f;e.normal=new lo({stroke:d,strokeWidth:1,fill:a,fillOpacity:null!=c?c:1});e.wb=new lo({stroke:k,strokeWidth:1,fill:g,fillOpacity:null!=c?c:1});e.jj=new lo({stroke:f,strokeWidth:1,fill:b,fillOpacity:null!=c?c:1});return e}
function CTa(a){var b=a.R,c=b[z]-b.t[Uc];a=a.xf.Ma[Gc];var d=[];d[B]({min:2,Ub:[da]});var e=d[J];d[B]({min:a+2,Ub:[da]});c=kV(d,c);return c[J]>e?(c=b.t[Uc]+c[e],new um(c-a,b.t[kd],c,b.t[G])):null}
function BTa(a,b){var c=a.R,d=a.Sb,e=b.pie[Gz],f=b.pie.cA,g=d.O(),k=JV(Zo(a[Nr],Rqa,M)),l=ETa(a,k,1),n=np(a[Nr],Pqa,{$a:c.kk,fontSize:c.wm}),p=ep(a[Nr],yF,oNa,c.kd?O:CF),t=ep(a[Nr],sna,pNa,Rg),u=Uo(a[Nr],loa,1/720),x=Lo(a[Nr],Gva),A=Wo(a[Nr],Qqa,YAa),C=Uo(a[Nr],AF,0);a[Nr][Rsa]=2;c.g=[];c.Tn=[];var E,Q,N;c.kd?(E=a[Nr].Q(Wva,.01),E=c.zh.pie.sW*(1+E),E=c.zh.pie.E6?[0,E]:[E,0],Q=[!1,!0],N=[a[Nr].Q(LI,.5),a[Nr].Q(MI,1)]):(E=[0],Q=[!0],N=[1]);c.pie={center:e,cA:f,bd:b.pie.bd,cd:b.pie.cd,bi:[]};for(var f=
U(function(a,b){var d=c.g[a];if(1==b)fZ(d,t,d);else{var e=c.g[a-g];fZ(d,t,d,e);fZ(e,t,d,e)}},a),S=U(function(a){var b=c.pie.bi[a-1].FN,d=c.pie.bi[0].FN;1==a&&b?fZ(b,t,b):1<a&&(b&&d?(fZ(b,t,b,d),fZ(d,t,b,d)):b?(d={kB:pf,ef:pf},fZ(b,t,b,d)):d&&(b={kB:pf,ef:pf},fZ(d,t,b,d)))},a),T=U(function(a,b,d,e,f){c.kd?c.Tn[B]({id:a,text:b,brush:new lo({gradient:{kg:d,Nf:d,or:N[0],pr:N[1],x1:AM,y1:CM,Fb:CM,Kb:CM,nr:!0,vF:!0}}),index:e,W:f}):c.Tn[B]({id:a,text:b,brush:new lo({fill:d}),index:e,W:f})},a),V=c.pie.bi,
sa=b.pie.bi,Ha=sa[J],Ka=0,Ra=0;Ra<Ha;++Ra){for(var Sd=sa[Ra],Db=null,Ec=Sd.bd,Sd=Sd.cd,Zd=E[Ra],Xb=Q[Ra],sd=0,gf=0,tj=0,Ih=0;Ih<g;Ih++)tj+=d[I](Ih,Ra+1)||0;for(Ih=0;Ih<g;++Ih){var Qf=d[I](Ih,Ra+1)||0,Mr=d.Ca(Ih,Ra+1),rg=d[I](Ih,0),Jj=d.Ca(Ih,0),wk=0===tj?0:gf/tj,sg=0===tj?0:wk+Qf/tj,ph=sg-wk>=u;ph?gf+=Qf:sd+=Qf;var Yr=koa+Ka,mq=a[Nr].Q(Yr+LDa,a.sb[Ih%a.sb[J]]),mq=JV(mq),bz=ETa(a,mq,N[Ra]),FD=Po(a[Nr],Yr+wDa,0),Zr=Uo(a[Nr],Yr+BDa,C)+Zd,qh=np(a[Nr],Yr+qDa,n),cp=Lo(a[Nr],[Yr+JDa,AI],!0),Qf=FTa(a,Ka,
Ih,wk,sg,Qf,Mr,Jj,ph,e,Ec,Sd,Zr,FD,p,qh,mq,bz,cp);c.g[B](Qf);ph=Lo(a[Nr],Yr+mDa,Xb&&(ph||x));T(rg,Jj,mq[F],Ka,ph);Ra==Ha-1&&f(Ka,Ha);Ka+=1}0<sd&&(wk=1-(0===tj?0:sd/tj),sg=1,Qf=sd,Mr=String(sd),Jj=A,Db=FTa(a,-1,-1,wk,sg,Qf,Mr,Jj,!0,e,Ec,Sd,C+Zd,0,p,n,k,l,!1),Xb&&!x&&T(M,Jj,k[F],-1,!0));V[B]({bd:Ec,cd:Sd,FN:Db});Ra==Ha-1&&S(Ha)}}function GTa(a,b){switch(b){case CF:return a.kB;case ti:return a.ef;case Rg:return a.ef+EN+a.kB+ef}return M}
function FTa(a,b,c,d,e,f,g,k,l,n,p,t,u,x,A,C,E,Q,N){var S=a.R;if(S.Rc||1<=u)u=0;var T={},V=e-d;Sy(T,f);T.ef=g;Ya(T,E);T.ne=Q;T.brush=T.ne.normal;Xq(T,k);Iq(T,b);T.Zg=N;T.Ht=0<=c?a.Sb.ym(c):null;T.W=l;b=p*u;u*=t;T.QF=b;T.yA=u;T.Ud=360*d+a.n9;T.od=360*e+a.n9;a.fla&&(c=360-T.Ud,T.Ud=360-T.od,T.od=c);c=h.PI*(T.Ud-90)/180;f=h.PI*(T.od-90)/180;T.kB=h[D](1E3*V)/10+Ve;k=M;switch(A){case CF:k=T.kB;break;case cH:k=T[bC];break;case ti:k=g;break;case Hma:k=g+EN+T.kB+ef}Oy(T,k);if(!l)return T;T.ba=C;a=a.mc(T[pd],
C)[r];C=C[Gc];T.YM=new Cl(a,C);T.wr=1==V;if(T[pd])if(T.wr)T.mW=qO(n,new oO(a/2,C/2)),T.lW=!0;else{V=p-C;C=t-C;a=T.YM;a=new Cl(a[r]/V,a[z]/C);g=new Cl(2/V,2/C);l=fY((c+f)/2+h.PI,1,1);i:{A=OQa(new oO(0,0),a);k=1;E=h.min;for(Q=0;Q<A[J];++Q){var sa=A[Q];N=l.x*sa.x+l.y*sa.y;sa=N*N+1-(sa.x*sa.x+sa.y*sa.y);0>sa?N=null:(sa=h[Kd](sa),N=[N-sa,N+sa]);if(null===N||0>N[1]){A=null;break i}k=E(k,N[1])}A=k}if(.4>A)a=null;else{l=l[Jc]();l[bB](-A);a=MQa(a,g,g);i:{a=OQa(l,a);g=Mk(f-c,2*h.PI);A=0;k=g;for(E=0;E<a[J];++E){Q=
Mk(h[Id](a[E].y,a[E].x)-c,2*h.PI);if(Q>=g||0==Q){a=!1;break i}k=h.min(Q,k);A=h.max(Q,A)}a=A-k<h.PI}a=a?l:null}V=a&&new oO(a.x*V,a.y*C);null!==V&&(T.lW=!0,T.mW=LQa(n,V,new oO(-T.YM[r]/2,-T.YM[z]/2)))}else T.lW=!1;T.offset=fY((c+f)/2,p,t)[bB](x);x=fY(f,p,t);T.jf=pO(n,fY(c,p,t));T.Bh=pO(n,x);t=fY(f,b,u);T.oA=pO(n,fY(c,b,u));T.Nt=pO(n,t);S.Rc&&270>=T.Ud&&90<=T.od&&(t={},90>T.Ud?(t.Ud=90,t.jf=new oO(n.x+p,n.y)):(t.Ud=T.Ud,t.jf=T.jf),270<T.od?(t.od=270,t.Bh=new oO(n.x-p,n.y)):(t.od=T.od,t.Bh=T.Bh),t.brush=
T.ne.wb,T.Wb=t);T.St=S.Rc&&.5<d;T.Hw=S.Rc&&.5>e;if(T.St||T.Hw)T.PM=T.ne.wb;return T}function fZ(a,b,c,d){c=GTa(c,b);d&&(c+=Je+GTa(d,b));a.de={Dm:a[bC],content:c}}
function DTa(a,b,c,d){var e=a.R,f=e.pie.bd,g=e.pie.cd,k=c.pie[Gz],l=ep(a[Nr],Qsa,pNa,CF),n=h.PI*(3*(f+g)-h[Kd]((3*f+g)*(f+3*g))),p=[];c=[];for(var t=0;t<e.Tn[J];++t){var u=e.Tn[t];if(u.W){var x;if(0<=u[xc])x=e.g[u[xc]];else{var A=e.pie.bi;x=A[A[J]-1].FN}var C=h.max((f+x.QF)/2,.75*f),E=h.max((g+x.yA)/2,.75*g),Q=(x.od+x.Ud)/2,A=Mk(Q,360),N=Uk(f-C,g-E)/n*360,S,T;2*N<x.od-x.Ud?(S=x.Ud+N,T=x.od-N,180>A?T=h.min(T,180):S=h.max(S,180)):T=S=Q;var V=function(a){return pO(k,fY(a,C,E))},N=function(a){return V(h.asin(Lk((a-
k.y)/E,-1,1)))},sa=function(a){return V(h.PI-h.asin(Lk((a-k.y)/E,-1,1)))},u={Y9:V(Ok(Q-90)).y,OO:new Yn(V(Ok(S-90)).y,V(Ok(T-90)).y),RA:u[pd],TA:GTa(x,l),X9:x[wd],index:x[xc]};180>A?(u.g8=N,p[B](u)):(u.g8=sa,c[B](u))}}f=b[r]/2-f-d[Gc];e=wTa(new um(b.top,b[kd],b[Uc],b[kd]-f),a.mc,2,d,p);b=wTa(new um(b.top,b[G]+f,b[Uc],b[G]),a.mc,1,d,c);d=[];Mj(d,e,b);a.R.np=d};function gZ(a,b,c){tY[L](this,a,b,c,BF)}W(gZ,tY);gZ[K].yt=function(a){return this.J.sv(a[ys])};gZ[K].Vea=function(a,b){var c=b[zc](Oe);switch(c[0]){case $D:c=ha(c[1]);if(0>c)break;this[ir](Zoa+a,{$b:c,ej:null})}};function hZ(a,b,c,d,e,f,g){HY[L](this,a,b,c,d,e,g);var k=Lo(a,AI,!0);this.Rla=jV(f,function(b){return Lo(a,koa+b+JDa,k)});this.Sla=Lo(a,Goa,!0)}W(hZ,HY);hZ[K].Ks=function(a,b,c){this.v5(a,b,c)};hZ[K].k6=function(a,b){return a[gs](b,!0)};function iZ(a,b){a.g=a.g||{};var c=a.g;c[b]=c[b]||{};return c[b]}
hZ[K].v5=function(a,b,c){var d={Gb:a,sk:this.qe.getEntries(),Yt:c,xk:b.Ph},e=b.Ph.Sa.qx;null!=e&&Iy(b.Ph.Sa,this.qe.oh(e)[dB]);for(var f=this.eo.iW,e=f==ci||f==Rg,g=f==ih||f==Rg,k=this.qe&&0<d.sk[J],f=tx(b[$z]),k=1<f[J]&&k,l=0;l<f[J];++l){var n=f[l],p=a.pie.bi[J],n=n+a.g[J]/p*(p-1);HTa(a,n,c);e&&!k&&ITa(this,d,n)}e&&k&&JTa(this,d,f,f[f[J]-1]);var t=U(function(b){if(a.kd){var c=a.g[J];return[b,(b+c/a.pie.bi[J])%c]}return[b]},this),e=U(function(b,e){if(null!=b){for(var f=t(b),k=!1,l=0;l<f[J];++l){var n=
f[l];if(null!=n&&this.Rla[n]){k=k||!0;if(a.kd){if(this.oya){var p=n,S=c,T=a.g[p];if(null!=T[tA]){var V=T.brush[Jc]();V.ld(go(T.brush.fb(),Pe,.7));V.Eg(T.brush.Oe+.1);iZ(S,p).xw={brush:V}}}}else this.Sla&&KTa(a,n,c);a.np&&(c.np=ATa(a.np,n))}}e&&g&&k&&ITa(this,d,b)}},this);if(f=b.ci)c.ci=f;e(b.Sa.ob,!0);e(b.Ea.Sa.Ah,!1)};
function KTa(a,b,c){var d=a.pie,e=a.g[b];if(null!=e[tA]){c=iZ(c,b);c.Wn={};b=c.Wn;b.brush=new lo({stroke:e.brush.fb(),strokeWidth:6.5,strokeOpacity:.3});b.Kh=new xl(d[Gz].x+e[tA].x,d[Gz].y+e[tA].y);b.Ud=e.Ud;b.od=e.od;b.wr=e.wr;(c=c.Li)&&a.X5?(a=c.bd+c.brush.Lb/2,c=c.cd+c.brush.Lb/2):(c=e.brush.Lb/2,a=d.bd+c,c=d.cd+c);d=b.brush.Lb/2;b.bd=a+d;b.cd=c+d;a=Ok(b.Ud-90);c=Ok(b.od-90);b.jf=Bl(b.Kh,fY(a,b.bd,b.cd));b.Bh=Bl(b.Kh,fY(c,b.bd,b.cd));var f=e.Wb;f&&(b.Wb=b.Wb||{},b.Wb.brush=so(f.brush.fb(),.3),
b.Wb.Kh=b.Kh[Jc](),b.Wb.Ud=f.Ud,b.Wb.od=f.od,b.Wb.bd=b.bd+d,b.Wb.cd=b.cd+d,a=Ok(b.Wb.Ud-90),c=Ok(b.Wb.od-90),b.Wb.jf=Bl(b.Wb.Kh,fY(a,b.Wb.bd,b.Wb.cd)),b.Wb.Bh=Bl(b.Wb.Kh,fY(c,b.Wb.bd,b.Wb.cd)));b.St=e.St;b.Hw=e.Hw;if(b.St||b.Hw)b.PM=so(e.PM.fb(),.3),b.lna=b.St?a:c,e=function(a,b){return Bl(a.Kh,fY(a.lna,a.bd+b*a.brush.Lb/2,a.cd+b*a.brush.Lb/2))},b.dB=e(b,-1),b.cN=e(b,1)}}
function HTa(a,b,c){var d=a.pie;0<d.cA||(a=a.g[b],null!=a[tA]&&(b=iZ(c,b),b.Li={},b=b.Li,b.brush=to(a.brush.fb(),2),b.Kh=new xl(d[Gz].x+a[tA].x,d[Gz].y+a[tA].y),b.Ud=a.Ud,b.od=a.od,b.wr=a.wr,a=a.brush.Lb/2+2.5+b.brush.Lb/2,b.bd=d.bd+a,b.cd=d.cd+a,d=Ok(b.od-90),b.jf=Bl(b.Kh,fY(Ok(b.Ud-90),b.bd,b.cd)),b.Bh=Bl(b.Kh,fY(d,b.bd,b.cd))))}function ITa(a,b,c){var d=iZ(b.Yt,c);c=FY(a.eo,b,c,null,null);d.rb=c;b.xk&&a.qe.Ks(c,b.xk,d.rb)}
function JTa(a,b,c,d){var e=iZ(b.Yt,d);c=rSa(a.eo,b,c,d);e.rb=c;b.xk&&a.qe.Ks(c,b.xk,e.rb)};function jZ(a){nw[L](this,a);this.dh=null;this.kb=th;this.Sf=this.Qc=this.b=this.S=this.v6=null;this.QP=[];this.Kg=this.Da=this.Wt=this.Pa=null;this.LM=!1;this.Yn=new hv;this.H=null;this.hf=new YY(this);this.vA=this.Un=null}W(jZ,nw);R=jZ[K];R.D=function(){this.Ag();Lu(this.Yn);jZ.e.D[L](this)};R.Je=null;R.wF=function(a,b,c,d,e,f){var g;if(this.dh===BF)return kZ[K].wF[Zc](this,arguments);g=this.dh===yH?new MY(a,b,c,d,e):new hY(a,b,c,d,e);g[Sc](this.Dj,f);return g};
R.UW=function(a,b,c,d,e,f,g){return this.dh===BF?kZ[K].UW[Zc](this,arguments):new NY(a,b,c,d,e,0,g)};R.v2=function(a,b,c,d){return this.dh===BF?kZ[K].v2[Zc](this,arguments):new vY(a,b,c,d)};R.pN=function(a,b){return this.dh===BF?kZ[K].pN[Zc](this,arguments):new HOa(a,b)};R.Ld=function(a,b,c,d){this.dh=a;null!=b&&(this.mua=b);null!=c&&(this.kb=c);null!=d&&(this.v6=d)};R.qha=function(a){a&&this[Bc]!==kZ&&(this.__proto__?(this.__proto__=kZ[K],Ea(this,kZ),this[Bc][L](this,this.ea)):this.Ld(BF))};
br(R,function(a,b,c){this.qha(Ri(b)&&b[H]===BF);nw[K][As][L](this,a,b,c)});
R.hl=function(a,b,c,d){this.Dj=a;vp(EM);c=c||{};c=On(Ln(c));LTa(this,c);MTa(this,c);dz(c,c[QB]||this.kb);c.theme=c.theme||this.v6;this.dh!=O&&NTa(c);if(this.dh!=BF&&Ko(c.reverseCategories)){var e=c[QB]===ui?Au:IH;c[e]=c[e]||{};$x(c[e],-1);delete c.reverseCategories}OTa(c);Hu.nc(this.ea);if(!b)throw m(KL);yj(Wj(b.L()),function(a){return b.fu(a)==RF})&&(c.isDiff=!0);this.Gw=b.G(0)!=Nh?1:0;this.fi=b.O();PTa(this);if(c.isStacked&&c.vAxis&&c.vAxis.baseline)throw m("Cannot set a non-zero base-line for a stacked chart");
var f=c.theme||[];Oi(f)||(f=[f]);for(var e=[c],g=0;g<f[J];++g){var k;if(Si(f[g]))k=IKa(f[g]);else if(Ri(f[g]))k=f[g];else throw m(uAa);e[B](k)}c=c[H][He]();xNa[c]&&e[B](xNa[c]);e[B](yNa);var l=MKa(),n=[];X(e,function(a){n[B][Zc](n,aga(a,l))});this.b=new Do(e);this.dh=ep(this.b,qi,bNa,O);this.N=qp(this.ea,this.b);this.ra=rp(this.ea,this.b);c=new Cl(this.N,this.ra);e=Lo(this.b,ZH);if(!this.Da||this.Da.yh)try{this.Da=new JO(this.ea,c,a,e)}catch(p){throw m(fAa);}else this.Da[xC](c,a);this.Pa=new JY(d);
this.q=b;n[J]&&this.Ek?(this.Ek.zG[vs](function(){this.Da.$n(U(this.mo,this),a)},null,this),ela(this,U(function(){this.Da.$n(U(this.mo,this),a)},this)),new JKa(n,this.Ek)):this.Da.$n(U(this.mo,this),a)};
R.mo=function(){var a=this.Da.Wa(),b=this.Da.Mw(),c=this.b,d=U(function(d){QTa(this);d=d.jp();var f=new pTa(c,this.Pa,U(this.Dp,this),d);Lu(this.H);this.H=new bZ(d,this.Pa,this.Yn,this.hf,U(this.ki,this,!0),f);this.Sf=this.UW(this.b,new Cl(this.N,this.ra),{$a:d.kk,fontSize:d.wm},d.bA,d.ai,d.g[J],this.Sf?this.Sf.qe:void 0);RTa(this);this.Qc=this.pN(b,a);STa(this,d)||(this.S=d,TTa(this),UTa(this),this.LM=!0);VTa(this);this.hf[ir](Yt);this.H.Xw()},this);this.wF(this.q,c,U(a.bf,a),this.N,this.ra,d)};
function VTa(a){var b=a.Da.Wa();ba[Dr](U(function(){if(b&&b.pK){var a=b.pK();if(a&&this.q){var d=lJa(this.q);wl(a,d)}}},a),0)}R.pw=function(a,b){if(this.dh===BF)return lZ(a,b);throw m("Cannot compute diff for this chart type.");};
function lZ(a,b){var c=new aq,d=b.O(),e=b.L(),f=a.G(0)!=Nh;f&&c.Tf(a.G(0),a.La(0));for(var g=f?1:0,k=g;k<e;++k)c.Tf({type:a.G(k),label:a.La(k),role:RF}),c.Tf({type:b.G(k),label:b.La(k),role:Wg});c.$t(d);for(var l=0;l<d;++l){k=null;f&&(k=b[I](l,0),c.cc(l,0,k));for(var n=g,k=g;k<e;++k){var p=a[I](l,k);c.cc(l,n,p);n+=1;p=b[I](l,k);c.cc(l,n,p);n+=1}}return c}
function LTa(a,b){switch(b[H]){case OG:a.Ld(kh,OG,th);db(b,null);break;case Hg:a.Ld(kh,Hg,th);db(b,null);break;case Jwa:a.Ld(kh,JK,th);db(b,null);break;case JK:a.Ld(kh,JK,ui);db(b,null);break;case OE:a.Ld(OE);db(b,null);break;case BF:a.Ld(BF),db(b,null)}var c=a.dh;c==O&&(c=null);var d=b[H]||O;d==O&&(d=null);if(!c&&!d)throw m("Unspecified chart type.");if(c&&d&&c!=d)throw m("Incompatible chart types.");db(b,c||d)}
function MTa(a,b){if(b[H]==kh){var c=a.mua;c==O&&(c=null);var d=b.seriesType||O;d==O&&(d=null);if(c&&d&&c!=d)throw m("Incompatible default series types.");b.seriesType=c||d}}
function NTa(a){a.hAxis=a.hAxis||{};a.vAxis=a.vAxis||{};var b=a.hAxis,c=a.vAxis,d=null;switch(a[H]){case OE:d=c;break;case kh:a.targetAxis=a.targetAxis||{},d=a.targetAxis}d&&(mZ(a,mG,d,Lh),mZ(a,wG,d,Hh),mZ(a,HG,d,HG));b&&(mZ(a,csa,b,HG),mZ(a,Dna,b,qD));c&&mZ(a,nD,c,qD);a.smoothLine&&!Gi(a.curveType)&&(a.curveType=kh);mZ(a,isa,a,MG);mZ(a,kpa,a,aF);a.chartArea=a.chartArea||{};mZ(a,xya,a.chartArea,LK)}
function OTa(a){nZ(a,Fna,pD,oD);nZ(a,msa,psa,TG);oZ(a.hAxis);for(var b in a.hAxes)oZ(a.hAxes[b]);oZ(a.vAxis);for(b in a.vAxes)oZ(a.vAxes[b]);b