/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authz.aop;

import org.apache.shiro.aop.AnnotationMethodInterceptor;
import org.apache.shiro.aop.AnnotationResolver;
import org.apache.shiro.aop.MethodInvocation;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.aop.AuthorizingAnnotationHandler;

public abstract class AuthorizingAnnotationMethodInterceptor
extends AnnotationMethodInterceptor {
    public AuthorizingAnnotationMethodInterceptor(AuthorizingAnnotationHandler handler) {
        super(handler);
    }

    public AuthorizingAnnotationMethodInterceptor(AuthorizingAnnotationHandler handler, AnnotationResolver resolver) {
        super(handler, resolver);
    }

    @Override
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        this.assertAuthorized(methodInvocation);
        return methodInvocation.proceed();
    }

    public void assertAuthorized(MethodInvocation mi) throws AuthorizationException {
        try {
            ((AuthorizingAnnotationHandler)this.getHandler()).assertAuthorized(this.getAnnotation(mi));
        }
        catch (AuthorizationException ae) {
            if (ae.getCause() == null) {
                ae.initCause((Throwable)((Object)new AuthorizationException("Not authorized to invoke method: " + String.valueOf(mi.getMethod()))));
            }
            throw ae;
        }
    }
}

