/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Traceable;
import org.apache.camel.processor.BaseProcessorSupport;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;

public class TransformProcessor
extends BaseProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private String id;
    private String routeId;
    private final Expression expression;

    public TransformProcessor(Expression expression) {
        ObjectHelper.notNull((Object)expression, (String)"expression", (Object)((Object)this));
        this.expression = expression;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            boolean copyNeeded;
            Object newBody = this.expression.evaluate(exchange, Object.class);
            if (exchange.getException() != null) {
                callback.done(true);
                return true;
            }
            Message old = exchange.getMessage();
            boolean bl = copyNeeded = !old.getClass().equals(DefaultMessage.class);
            if (copyNeeded) {
                DefaultMessage msg = new DefaultMessage(exchange.getContext());
                msg.copyFromWithNewBody(old, newBody);
                ExchangeHelper.replaceMessage((Exchange)exchange, (Message)msg, (boolean)true);
            } else {
                old.setBody(newBody);
                if (!exchange.hasOut()) {
                    exchange.setOut(exchange.getIn());
                }
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return this.id;
    }

    public String getTraceLabel() {
        return "transform[" + String.valueOf(this.expression) + "]";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public Expression getExpression() {
        return this.expression;
    }
}

