/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter.support;

import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.cbor.KotlinSerializationCborHttpMessageConverter;
import org.springframework.http.converter.cbor.MappingJackson2CborHttpMessageConverter;
import org.springframework.http.converter.json.GsonHttpMessageConverter;
import org.springframework.http.converter.json.JsonbHttpMessageConverter;
import org.springframework.http.converter.json.KotlinSerializationJsonHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.protobuf.KotlinSerializationProtobufHttpMessageConverter;
import org.springframework.http.converter.smile.MappingJackson2SmileHttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.http.converter.yaml.MappingJackson2YamlHttpMessageConverter;
import org.springframework.util.ClassUtils;

public class AllEncompassingFormHttpMessageConverter
extends FormHttpMessageConverter {
    private static final boolean jaxb2Present;
    private static final boolean jackson2Present;
    private static final boolean jackson2XmlPresent;
    private static final boolean jackson2SmilePresent;
    private static final boolean jackson2CborPresent;
    private static final boolean jackson2YamlPresent;
    private static final boolean gsonPresent;
    private static final boolean jsonbPresent;
    private static final boolean kotlinSerializationCborPresent;
    private static final boolean kotlinSerializationJsonPresent;
    private static final boolean kotlinSerializationProtobufPresent;

    public AllEncompassingFormHttpMessageConverter() {
        if (jaxb2Present && !jackson2XmlPresent) {
            this.addPartConverter(new Jaxb2RootElementHttpMessageConverter());
        }
        if (kotlinSerializationJsonPresent) {
            this.addPartConverter(new KotlinSerializationJsonHttpMessageConverter());
        }
        if (jackson2Present) {
            this.addPartConverter(new MappingJackson2HttpMessageConverter());
        } else if (gsonPresent) {
            this.addPartConverter(new GsonHttpMessageConverter());
        } else if (jsonbPresent) {
            this.addPartConverter(new JsonbHttpMessageConverter());
        }
        if (jackson2XmlPresent) {
            this.addPartConverter(new MappingJackson2XmlHttpMessageConverter());
        }
        if (jackson2SmilePresent) {
            this.addPartConverter(new MappingJackson2SmileHttpMessageConverter());
        }
        if (jackson2CborPresent) {
            this.addPartConverter(new MappingJackson2CborHttpMessageConverter());
        }
        if (jackson2YamlPresent) {
            this.addPartConverter(new MappingJackson2YamlHttpMessageConverter());
        }
        if (kotlinSerializationCborPresent) {
            this.addPartConverter(new KotlinSerializationCborHttpMessageConverter());
        }
        if (kotlinSerializationProtobufPresent) {
            this.addPartConverter(new KotlinSerializationProtobufHttpMessageConverter());
        }
    }

    static {
        ClassLoader classLoader = AllEncompassingFormHttpMessageConverter.class.getClassLoader();
        jaxb2Present = ClassUtils.isPresent((String)"jakarta.xml.bind.Binder", (ClassLoader)classLoader);
        jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)classLoader) && ClassUtils.isPresent((String)"com.fasterxml.jackson.core.JsonGenerator", (ClassLoader)classLoader);
        jackson2XmlPresent = ClassUtils.isPresent((String)"com.fasterxml.jackson.dataformat.xml.XmlMapper", (ClassLoader)classLoader);
        jackson2SmilePresent = ClassUtils.isPresent((String)"com.fasterxml.jackson.dataformat.smile.SmileFactory", (ClassLoader)classLoader);
        jackson2CborPresent = ClassUtils.isPresent((String)"com.fasterxml.jackson.dataformat.cbor.CBORFactory", (ClassLoader)classLoader);
        jackson2YamlPresent = ClassUtils.isPresent((String)"com.fasterxml.jackson.dataformat.yaml.YAMLFactory", (ClassLoader)classLoader);
        gsonPresent = ClassUtils.isPresent((String)"com.google.gson.Gson", (ClassLoader)classLoader);
        jsonbPresent = ClassUtils.isPresent((String)"jakarta.json.bind.Jsonb", (ClassLoader)classLoader);
        kotlinSerializationCborPresent = ClassUtils.isPresent((String)"kotlinx.serialization.cbor.Cbor", (ClassLoader)classLoader);
        kotlinSerializationJsonPresent = ClassUtils.isPresent((String)"kotlinx.serialization.json.Json", (ClassLoader)classLoader);
        kotlinSerializationProtobufPresent = ClassUtils.isPresent((String)"kotlinx.serialization.protobuf.ProtoBuf", (ClassLoader)classLoader);
    }
}

