/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.dispatchers;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MustUnderstandUtils {
    private static final Log log = LogFactory.getLog(MustUnderstandUtils.class);
    static ArrayList EMPTY_LIST = new ArrayList();

    public static void markUnderstoodHeaderParameters(MessageContext msgContext) {
        if (msgContext == null) {
            return;
        }
        SOAPEnvelope envelope = msgContext.getEnvelope();
        if (envelope.getHeader() == null) {
            return;
        }
        ArrayList understoodHeaderQNames = MustUnderstandUtils.getHeaderParamaterList(msgContext);
        if (understoodHeaderQNames == null || understoodHeaderQNames.isEmpty()) {
            return;
        }
        Iterator headerBlocks = envelope.getHeader().getHeadersToProcess(null);
        while (headerBlocks.hasNext()) {
            SOAPHeaderBlock headerBlock = (SOAPHeaderBlock)headerBlocks.next();
            QName headerQN = headerBlock.getQName();
            if (!understoodHeaderQNames.contains(headerQN)) continue;
            headerBlock.setProcessed();
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Header marked as processed by JAXWS MustUnderstandChecker: " + headerQN));
        }
    }

    public static ArrayList getHeaderParamaterList(MessageContext msgContext) {
        ArrayList headers = null;
        AxisService axisService = msgContext.getAxisService();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Building list of understood headers for all operations under " + axisService));
        }
        if (axisService == null) {
            headers = EMPTY_LIST;
        } else {
            ArrayList seiMethodHeaders;
            block14: {
                seiMethodHeaders = (ArrayList)axisService.getParameterValue("seiMethodHeaderParameter");
                if (seiMethodHeaders == null) {
                    seiMethodHeaders = new ArrayList();
                    Iterator<AxisOperation> operationIterator = axisService.getOperations();
                    if (operationIterator != null) {
                        while (operationIterator.hasNext()) {
                            AxisOperation operation = operationIterator.next();
                            ArrayList list = MustUnderstandUtils.getSEIMethodHeaderParameterList(operation);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Adding headers from operation " + operation + "; headers = " + list));
                            }
                            if (list == null || list.isEmpty()) continue;
                            seiMethodHeaders.addAll(list);
                        }
                    }
                    try {
                        axisService.addParameter("seiMethodHeaderParameter", seiMethodHeaders);
                    }
                    catch (AxisFault e) {
                        if (!log.isDebugEnabled()) break block14;
                        log.debug((Object)"Problem caching seiMethodHeaderParameter.  Processing continues without cached value");
                    }
                }
            }
            ArrayList handlerHeaders = MustUnderstandUtils.getHandlersHeaderParameterList(axisService);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding headers from SOAP handlers; headers = " + handlerHeaders));
            }
            if (seiMethodHeaders == null || seiMethodHeaders.isEmpty()) {
                headers = handlerHeaders == null ? EMPTY_LIST : handlerHeaders;
            } else if (handlerHeaders == null || handlerHeaders.isEmpty()) {
                headers = seiMethodHeaders == null ? EMPTY_LIST : seiMethodHeaders;
            } else {
                headers = new ArrayList();
                headers.addAll(seiMethodHeaders);
                headers.addAll(handlerHeaders);
            }
        }
        return headers;
    }

    public static ArrayList getSEIMethodHeaderParameterList(AxisOperation axisOperation) {
        return MustUnderstandUtils.getHeaderParameterList(axisOperation, "org.apache.axis2.jaxws.description.OperationDescription.headerParameterQNames");
    }

    public static ArrayList getHandlersHeaderParameterList(AxisService axisService) {
        return MustUnderstandUtils.getHeaderParameterList(axisService, "org.apache.axis2.jaxws.description.EndpointDescription.handlerParameterQNames");
    }

    private static ArrayList getHeaderParameterList(AxisDescription axisDescription, String paramName) {
        Parameter headerQNamesParameter = axisDescription.getParameter(paramName);
        if (headerQNamesParameter == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parameter not on " + axisDescription + "; " + paramName));
            }
            return null;
        }
        ArrayList understoodHeaderQNames = (ArrayList)headerQNamesParameter.getValue();
        if (understoodHeaderQNames == null || understoodHeaderQNames.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parameter value is empty: " + axisDescription + "; " + paramName));
            }
            return null;
        }
        return understoodHeaderQNames;
    }
}

