/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.common.utils;

import org.apache.airavata.model.task.DataStagingTaskModel;
import org.apache.airavata.model.task.EnvironmentSetupTaskModel;
import org.apache.airavata.model.task.JobSubmissionTaskModel;
import org.apache.airavata.model.task.MonitorTaskModel;
import org.apache.airavata.model.task.TaskModel;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;

public class ThriftUtils {
    public static byte[] serializeThriftObject(TBase object) throws TException {
        return new TSerializer().serialize(object);
    }

    public static void createThriftFromBytes(byte[] bytes, TBase object) throws TException {
        new TDeserializer().deserialize(object, bytes);
    }

    public static Object getSubTaskModel(TaskModel taskModel) throws TException {
        switch (taskModel.getTaskType()) {
            case DATA_STAGING: {
                DataStagingTaskModel dataStagingTaskModel = new DataStagingTaskModel();
                ThriftUtils.createThriftFromBytes(taskModel.getSubTaskModel(), (TBase)dataStagingTaskModel);
                return dataStagingTaskModel;
            }
            case ENV_SETUP: {
                EnvironmentSetupTaskModel environmentSetupTaskModel = new EnvironmentSetupTaskModel();
                ThriftUtils.createThriftFromBytes(taskModel.getSubTaskModel(), (TBase)environmentSetupTaskModel);
                return environmentSetupTaskModel;
            }
            case JOB_SUBMISSION: {
                JobSubmissionTaskModel jobSubmissionTaskModel = new JobSubmissionTaskModel();
                ThriftUtils.createThriftFromBytes(taskModel.getSubTaskModel(), (TBase)jobSubmissionTaskModel);
                return jobSubmissionTaskModel;
            }
            case MONITORING: {
                MonitorTaskModel monitorTaskModel = new MonitorTaskModel();
                ThriftUtils.createThriftFromBytes(taskModel.getSubTaskModel(), (TBase)monitorTaskModel);
                return monitorTaskModel;
            }
        }
        return null;
    }
}

