/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.client.samples;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.airavata.api.Airavata;
import org.apache.airavata.api.client.AiravataClientFactory;
import org.apache.airavata.client.samples.CreateLaunchExperiment;
import org.apache.airavata.client.tools.RegisterSampleApplications;
import org.apache.airavata.client.tools.RegisterSampleApplicationsUtils;
import org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionInterface;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionProtocol;
import org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission;
import org.apache.airavata.model.application.io.InputDataObjectType;
import org.apache.airavata.model.application.io.OutputDataObjectType;
import org.apache.airavata.model.commons.ErrorModel;
import org.apache.airavata.model.data.movement.SecurityProtocol;
import org.apache.airavata.model.error.AiravataClientException;
import org.apache.airavata.model.error.AiravataErrorType;
import org.apache.airavata.model.error.AiravataSystemException;
import org.apache.airavata.model.error.ExperimentNotFoundException;
import org.apache.airavata.model.error.InvalidRequestException;
import org.apache.airavata.model.experiment.ExperimentModel;
import org.apache.airavata.model.experiment.UserConfigurationDataModel;
import org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel;
import org.apache.airavata.model.security.AuthzToken;
import org.apache.airavata.model.status.ExperimentStatus;
import org.apache.airavata.model.util.ExperimentModelUtil;
import org.apache.airavata.model.workspace.Gateway;
import org.apache.airavata.model.workspace.Project;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateLaunchBES {
    public static final String THRIFT_SERVER_HOST = "localhost";
    public static final int THRIFT_SERVER_PORT = 8930;
    private static final Logger logger = LoggerFactory.getLogger(CreateLaunchExperiment.class);
    private static final String DEFAULT_USER = "default.registry.user";
    private static final String DEFAULT_GATEWAY = "php_reference_gateway";
    private static Airavata.Client airavataClient;
    private static String echoAppId;
    private static String mpiAppId;
    private static String unicoreHostName;
    private static String gatewayId;
    private static final String unicoreEndPointURL = "https://deisa-unic.fz-juelich.de:9111/FZJ_JUROPA/services/BESFactory?res=default_bes_factory";
    private static String fsdResourceId;

    public static void main(String[] args) throws Exception {
        airavataClient = AiravataClientFactory.createAiravataClient((String)THRIFT_SERVER_HOST, (int)8930);
        System.out.println("API version is " + airavataClient.getAPIVersion(null));
        CreateLaunchBES.createAndLaunchExp();
    }

    public static void getAvailableAppInterfaceComputeResources(String appInterfaceId) {
        try {
            Map availableAppInterfaceComputeResources = airavataClient.getAvailableAppInterfaceComputeResources(new AuthzToken(""), appInterfaceId);
            for (String key : availableAppInterfaceComputeResources.keySet()) {
                System.out.println("id : " + key);
                System.out.println("name : " + (String)availableAppInterfaceComputeResources.get(key));
            }
        }
        catch (AiravataSystemException e) {
            e.printStackTrace();
        }
        catch (InvalidRequestException e) {
            e.printStackTrace();
        }
        catch (AiravataClientException e) {
            e.printStackTrace();
        }
        catch (TException e) {
            e.printStackTrace();
        }
    }

    public static void createGateway() {
        try {
            Gateway gateway = new Gateway();
            gateway.setGatewayId("testGatewayId2");
            gateway.setGatewayName("testGateway2");
            gatewayId = airavataClient.addGateway(new AuthzToken(""), gateway);
            System.out.println(gatewayId);
        }
        catch (AiravataSystemException e) {
            e.printStackTrace();
        }
        catch (InvalidRequestException e) {
            e.printStackTrace();
        }
        catch (AiravataClientException e) {
            e.printStackTrace();
        }
        catch (TException e) {
            e.printStackTrace();
        }
    }

    public static void getGateway(String gatewayId) {
        try {
            Gateway gateway = airavataClient.getGateway(new AuthzToken(""), gatewayId);
            gateway.setDomain("testDomain");
            airavataClient.updateGateway(new AuthzToken(""), gatewayId, gateway);
            List allGateways = airavataClient.getAllGateways(new AuthzToken(""));
            System.out.println(allGateways.size());
            if (airavataClient.isGatewayExist(new AuthzToken(""), gatewayId)) {
                Gateway gateway1 = airavataClient.getGateway(new AuthzToken(""), gatewayId);
                System.out.println(gateway1.getGatewayName());
            }
            boolean b = airavataClient.deleteGateway(new AuthzToken(""), "testGatewayId2");
            System.out.println(b);
        }
        catch (AiravataSystemException e) {
            e.printStackTrace();
        }
        catch (InvalidRequestException e) {
            e.printStackTrace();
        }
        catch (AiravataClientException e) {
            e.printStackTrace();
        }
        catch (TException e) {
            e.printStackTrace();
        }
    }

    public static void createAndLaunchExp() throws TException {
        ArrayList<String> experimentIds = new ArrayList<String>();
        try {
            for (int i = 0; i < 1; ++i) {
                String expId = CreateLaunchBES.createMPIExperimentForFSD(airavataClient);
                experimentIds.add(expId);
                System.out.println("Experiment ID : " + expId);
                CreateLaunchBES.launchExperiment(airavataClient, expId);
            }
            Thread.sleep(10000L);
            for (String exId : experimentIds) {
                ExperimentModel experiment = airavataClient.getExperiment(new AuthzToken(""), exId);
                System.out.println(experiment.getExperimentId() + " " + ((ExperimentStatus)experiment.getExperimentStatus().get(0)).getState().name());
            }
        }
        catch (Exception e) {
            logger.error("Error while connecting with server", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public static void launchExperiment(Airavata.Client client, String expId) throws TException {
        try {
            client.launchExperiment(new AuthzToken(""), expId, DEFAULT_GATEWAY);
        }
        catch (ExperimentNotFoundException e) {
            logger.error("Error occured while launching the experiment...", (Object)e.getMessage());
            throw new ExperimentNotFoundException(e);
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while launching the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while launching the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while launching the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while launching the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
    }

    public static void registerApplications() {
        RegisterSampleApplications registerSampleApplications = new RegisterSampleApplications(airavataClient);
        registerSampleApplications.registerXSEDEHosts();
        registerSampleApplications.registerGatewayResourceProfile();
        registerSampleApplications.registerAppModules();
        registerSampleApplications.registerAppDeployments();
        registerSampleApplications.registerAppInterfaces();
    }

    public static String registerUnicoreEndpoint(String hostName, String hostDesc, JobSubmissionProtocol protocol, SecurityProtocol securityProtocol) throws TException {
        ComputeResourceDescription computeResourceDescription = RegisterSampleApplicationsUtils.createComputeResourceDescription(hostName, hostDesc, null, null);
        fsdResourceId = airavataClient.registerComputeResource(new AuthzToken(""), computeResourceDescription);
        if (fsdResourceId.isEmpty()) {
            throw new AiravataClientException();
        }
        System.out.println("FSD Compute ResourceID: " + fsdResourceId);
        JobSubmissionInterface jobSubmission = RegisterSampleApplicationsUtils.createJobSubmissionInterface(fsdResourceId, protocol, 2);
        UnicoreJobSubmission ucrJobSubmission = new UnicoreJobSubmission();
        ucrJobSubmission.setSecurityProtocol(securityProtocol);
        ucrJobSubmission.setUnicoreEndPointURL(unicoreEndPointURL);
        return jobSubmission.getJobSubmissionInterfaceId();
    }

    public static String createEchoExperimentForFSD(Airavata.Client client) throws TException {
        try {
            List exInputs = client.getApplicationInputs(new AuthzToken(""), echoAppId);
            for (InputDataObjectType inputDataObjectType : exInputs) {
                if (inputDataObjectType.getName().equalsIgnoreCase("Input_to_Echo")) {
                    inputDataObjectType.setValue("Hello World");
                    continue;
                }
                if (inputDataObjectType.getName().equalsIgnoreCase("Input_to_Echo2")) {
                    inputDataObjectType.setValue("http://www.textfiles.com/100/ad.txt");
                    continue;
                }
                if (!inputDataObjectType.getName().equalsIgnoreCase("Input_to_Echo3")) continue;
                inputDataObjectType.setValue("file:///tmp/test.txt");
            }
            List exOut = client.getApplicationOutputs(new AuthzToken(""), echoAppId);
            ExperimentModel simpleExperiment = ExperimentModelUtil.createSimpleExperiment((String)DEFAULT_GATEWAY, (String)"default", (String)"admin", (String)"echoExperiment", (String)"SimpleEcho2", (String)echoAppId, (List)exInputs);
            simpleExperiment.setExperimentOutputs(exOut);
            Map computeResources = airavataClient.getAvailableAppInterfaceComputeResources(new AuthzToken(""), echoAppId);
            if (computeResources != null && computeResources.size() != 0) {
                for (String id : computeResources.keySet()) {
                    String resourceName = (String)computeResources.get(id);
                    if (!resourceName.equals(unicoreHostName)) continue;
                    ComputationalResourceSchedulingModel scheduling = ExperimentModelUtil.createComputationResourceScheduling((String)id, (int)1, (int)1, (int)1, (String)"normal", (int)30, (int)0x100000);
                    UserConfigurationDataModel userConfigurationData = new UserConfigurationDataModel();
                    userConfigurationData.setAiravataAutoSchedule(false);
                    userConfigurationData.setOverrideManualScheduledParams(false);
                    userConfigurationData.setComputationalResourceScheduling(scheduling);
                    userConfigurationData.setGenerateCert(false);
                    userConfigurationData.setUserDN("");
                    return client.createExperiment(new AuthzToken(""), DEFAULT_GATEWAY, simpleExperiment);
                }
            }
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
        return null;
    }

    public static String createMPIExperimentForFSD(Airavata.Client client) throws TException {
        try {
            List exInputs = client.getApplicationInputs(new AuthzToken(""), mpiAppId);
            for (Object inputDataObjectType : exInputs) {
                if (inputDataObjectType.getName().equalsIgnoreCase("NumberOfProcesses")) {
                    inputDataObjectType.setValue("32");
                }
                if (inputDataObjectType.getName().equalsIgnoreCase("US3INPUT")) {
                    inputDataObjectType.setValue("file://home/m.memon/us3input/smallerdata/hpcinput-uslims3.uthscsa.edu-uslims3_cauma3-01594.tar");
                }
                if (!inputDataObjectType.getName().equalsIgnoreCase("US3INPUTARG")) continue;
                inputDataObjectType.setValue("hpcinput-uslims3.uthscsa.edu-uslims3_cauma3-01594.tar");
            }
            List exOut = client.getApplicationOutputs(new AuthzToken(""), mpiAppId);
            for (OutputDataObjectType outputDataObjectType : exOut) {
                if (!outputDataObjectType.getName().equals("US3OUT")) continue;
                outputDataObjectType.setValue("output/analysis-results.tar");
            }
            ExperimentModel simpleExperiment = ExperimentModelUtil.createSimpleExperiment((String)DEFAULT_GATEWAY, (String)"default", (String)"admin", (String)"mpiExperiment", (String)"HelloMPI", (String)mpiAppId, (List)exInputs);
            simpleExperiment.setExperimentOutputs(exOut);
            Map computeResources = airavataClient.getAvailableAppInterfaceComputeResources(new AuthzToken(""), mpiAppId);
            if (computeResources != null && computeResources.size() != 0) {
                for (String id : computeResources.keySet()) {
                    String resourceName = (String)computeResources.get(id);
                    if (!resourceName.equals(unicoreHostName)) continue;
                    ComputationalResourceSchedulingModel scheduling = ExperimentModelUtil.createComputationResourceScheduling((String)id, (int)0, (int)4, (int)0, null, (int)10, (int)0);
                    UserConfigurationDataModel userConfigurationData = new UserConfigurationDataModel();
                    userConfigurationData.setAiravataAutoSchedule(false);
                    userConfigurationData.setOverrideManualScheduledParams(false);
                    userConfigurationData.setComputationalResourceScheduling(scheduling);
                    userConfigurationData.setGenerateCert(true);
                    userConfigurationData.setUserDN("CN=m.memon, O=Ultrascan Gateway, C=DE");
                    simpleExperiment.setUserConfigurationData(userConfigurationData);
                    return client.createExperiment(new AuthzToken(""), DEFAULT_GATEWAY, simpleExperiment);
                }
            }
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
        return null;
    }

    public static List<ExperimentModel> getExperimentsForUser(Airavata.Client client, String user) {
        try {
            return client.getUserExperiments(new AuthzToken(""), DEFAULT_GATEWAY, user, -1, 0);
        }
        catch (AiravataSystemException e) {
            e.printStackTrace();
        }
        catch (InvalidRequestException e) {
            e.printStackTrace();
        }
        catch (AiravataClientException e) {
            e.printStackTrace();
        }
        catch (TException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static List<Project> getAllUserProject(Airavata.Client client, String user) {
        try {
            return client.getUserProjects(new AuthzToken(""), DEFAULT_GATEWAY, user, -1, 0);
        }
        catch (AiravataSystemException e) {
            e.printStackTrace();
        }
        catch (InvalidRequestException e) {
            e.printStackTrace();
        }
        catch (AiravataClientException e) {
            e.printStackTrace();
        }
        catch (TException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void getExperiment(Airavata.Client client, String expId) throws Exception {
        try {
            ExperimentModel experiment = client.getExperiment(new AuthzToken(""), expId);
            List errors = experiment.getErrors();
            if (errors != null && !errors.isEmpty()) {
                for (ErrorModel error : errors) {
                    System.out.println("ERROR MESSAGE : " + error.getActualErrorMessage());
                }
            }
        }
        catch (ExperimentNotFoundException e) {
            logger.error("Experiment does not exist", (Throwable)e);
            throw new ExperimentNotFoundException("Experiment does not exist");
        }
        catch (AiravataSystemException e) {
            logger.error("Error while retrieving experiment", (Throwable)e);
            throw new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
        }
        catch (InvalidRequestException e) {
            logger.error("Error while retrieving experiment", (Throwable)e);
            throw new InvalidRequestException("Error while retrieving experiment");
        }
        catch (AiravataClientException e) {
            logger.error("Error while retrieving experiment", (Throwable)e);
            throw new AiravataClientException(AiravataErrorType.INTERNAL_ERROR);
        }
    }

    static {
        echoAppId = "Echo_5dd52cd4-f9a0-459f-9baf-f8e715e44548";
        mpiAppId = "HelloMPI_f0bb3b56-914e-4752-bb7b-dd18ef9dce00";
        unicoreHostName = "fsd-cloud15.zam.kfa-juelich.de";
    }
}

