/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.client.samples;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.airavata.api.Airavata;
import org.apache.airavata.api.client.AiravataClientFactory;
import org.apache.airavata.client.tools.RegisterSampleApplications;
import org.apache.airavata.client.tools.RegisterSampleApplicationsUtils;
import org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionInterface;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionProtocol;
import org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission;
import org.apache.airavata.model.application.io.DataType;
import org.apache.airavata.model.application.io.InputDataObjectType;
import org.apache.airavata.model.commons.ErrorModel;
import org.apache.airavata.model.data.movement.SecurityProtocol;
import org.apache.airavata.model.error.AiravataClientException;
import org.apache.airavata.model.error.AiravataErrorType;
import org.apache.airavata.model.error.AiravataSystemException;
import org.apache.airavata.model.error.ExperimentNotFoundException;
import org.apache.airavata.model.error.InvalidRequestException;
import org.apache.airavata.model.experiment.ExperimentModel;
import org.apache.airavata.model.experiment.UserConfigurationDataModel;
import org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel;
import org.apache.airavata.model.security.AuthzToken;
import org.apache.airavata.model.status.ExperimentState;
import org.apache.airavata.model.status.ExperimentStatus;
import org.apache.airavata.model.status.JobStatus;
import org.apache.airavata.model.util.ExperimentModelUtil;
import org.apache.airavata.model.util.ProjectModelUtil;
import org.apache.airavata.model.workspace.Gateway;
import org.apache.airavata.model.workspace.Project;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateLaunchExperiment {
    public static final String THRIFT_SERVER_HOST = "gw77.iu.xsede.org";
    public static final int THRIFT_SERVER_PORT = 8930;
    private static final Logger logger = LoggerFactory.getLogger(CreateLaunchExperiment.class);
    public static final String DEFAULT_USER = "default.registry.user";
    public static final String DEFAULT_GATEWAY = "default";
    private static Airavata.Client airavataClient;
    private static String echoAppId;
    private static String mpiAppId;
    private static String wrfAppId;
    private static String amberAppId;
    private static String gromacsAppId;
    private static String espressoAppId;
    private static String lammpsAppId;
    private static String nwchemAppId;
    private static String trinityAppId;
    private static String autodockAppId;
    private static String localHost;
    private static String trestlesHostName;
    private static String unicoreHostName;
    private static String stampedeHostName;
    private static String br2HostName;
    private static String umassrcHostName;
    private static String gatewayId;
    private static final String unicoreEndPointURL = "https://fsd-cloud15.zam.kfa-juelich.de:7000/INTEROP1/services/BESFactory?res=default_bes_factory";
    private static String fsdResourceId;

    public static void main(String[] args) throws Exception {
        airavataClient = AiravataClientFactory.createAiravataClient((String)THRIFT_SERVER_HOST, (int)8930);
        AuthzToken token = new AuthzToken("empty_token");
        System.out.println("API version is " + airavataClient.getAPIVersion(token));
        Map jobStatuses = airavataClient.getJobStatuses(token, "SLM3-QEspresso-Stampede_dc2af008-a832-4fba-ab0a-4b61fa79f5b9");
        for (String jobId : jobStatuses.keySet()) {
            JobStatus jobStatus = (JobStatus)jobStatuses.get(jobId);
            System.out.println(jobId);
            System.out.println(jobStatus.getJobState().toString());
        }
    }

    public static void getAvailableAppInterfaceComputeResources(String appInterfaceId) {
        try {
            Map availableAppInterfaceComputeResources = airavataClient.getAvailableAppInterfaceComputeResources(new AuthzToken(""), appInterfaceId);
            for (String key : availableAppInterfaceComputeResources.keySet()) {
                System.out.println("id : " + key);
                System.out.println("name : " + (String)availableAppInterfaceComputeResources.get(key));
            }
        }
        catch (AiravataSystemException e) {
            e.printStackTrace();
        }
        catch (InvalidRequestException e) {
            e.printStackTrace();
        }
        catch (AiravataClientException e) {
            e.printStackTrace();
        }
        catch (TException e) {
            e.printStackTrace();
        }
    }

    public static void createGateway() {
        try {
            Gateway gateway = new Gateway();
            gateway.setGatewayId("testGatewayId2");
            gateway.setGatewayName("testGateway2");
            gatewayId = airavataClient.addGateway(new AuthzToken(""), gateway);
            System.out.println(gatewayId);
        }
        catch (AiravataSystemException e) {
            e.printStackTrace();
        }
        catch (InvalidRequestException e) {
            e.printStackTrace();
        }
        catch (AiravataClientException e) {
            e.printStackTrace();
        }
        catch (TException e) {
            e.printStackTrace();
        }
    }

    public static void getGateway(String gatewayId) {
        try {
            Gateway gateway = airavataClient.getGateway(new AuthzToken(""), gatewayId);
            gateway.setDomain("testDomain");
            airavataClient.updateGateway(new AuthzToken(""), gatewayId, gateway);
            List allGateways = airavataClient.getAllGateways(new AuthzToken(""));
            System.out.println(allGateways.size());
            if (airavataClient.isGatewayExist(new AuthzToken(""), gatewayId)) {
                Gateway gateway1 = airavataClient.getGateway(new AuthzToken(""), gatewayId);
                System.out.println(gateway1.getGatewayName());
            }
            boolean b = airavataClient.deleteGateway(new AuthzToken(""), "testGatewayId2");
            System.out.println(b);
        }
        catch (AiravataSystemException e) {
            e.printStackTrace();
        }
        catch (InvalidRequestException e) {
            e.printStackTrace();
        }
        catch (AiravataClientException e) {
            e.printStackTrace();
        }
        catch (TException e) {
            e.printStackTrace();
        }
    }

    public static void createAndLaunchExp() throws TException {
        ArrayList<String> experimentIds = new ArrayList<String>();
        try {
            for (int i = 0; i < 1; ++i) {
                String expId = CreateLaunchExperiment.createExperimentForStampedeAmber(airavataClient);
                experimentIds.add(expId);
                System.out.println("Experiment ID : " + expId);
                CreateLaunchExperiment.launchExperiment(airavataClient, expId);
            }
            boolean allNotFinished = true;
            while (allNotFinished) {
                allNotFinished = false;
                for (String exId : experimentIds) {
                    ExperimentModel experiment = airavataClient.getExperiment(new AuthzToken(""), exId);
                    if (!(((ExperimentStatus)experiment.getExperimentStatus().get(0)).getState().equals((Object)ExperimentState.COMPLETED) || ((ExperimentStatus)experiment.getExperimentStatus().get(0)).getState().equals((Object)ExperimentState.FAILED) || ((ExperimentStatus)experiment.getExperimentStatus().get(0)).getState().equals((Object)ExperimentState.CANCELED))) {
                        allNotFinished = true;
                    }
                    System.out.println(experiment.getExperimentId() + " " + ((ExperimentStatus)experiment.getExperimentStatus().get(0)).getState().name());
                }
                System.out.println("----------------------------------------------------");
                Thread.sleep(10000L);
            }
        }
        catch (Exception e) {
            logger.error("Error while connecting with server", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public static void registerApplications() {
        RegisterSampleApplications registerSampleApplications = new RegisterSampleApplications(airavataClient);
        registerSampleApplications.registerLocalHost();
        registerSampleApplications.registerXSEDEHosts();
        registerSampleApplications.registerNonXSEDEHosts();
        registerSampleApplications.registerGatewayResourceProfile();
        registerSampleApplications.registerAppModules();
        registerSampleApplications.registerAppDeployments();
        registerSampleApplications.registerAppInterfaces();
    }

    public static String registerUnicoreEndpoint(String hostName, String hostDesc, JobSubmissionProtocol protocol, SecurityProtocol securityProtocol) throws TException {
        ComputeResourceDescription computeResourceDescription = RegisterSampleApplicationsUtils.createComputeResourceDescription(hostName, hostDesc, null, null);
        fsdResourceId = airavataClient.registerComputeResource(new AuthzToken(""), computeResourceDescription);
        if (fsdResourceId.isEmpty()) {
            throw new AiravataClientException();
        }
        System.out.println("FSD Compute ResourceID: " + fsdResourceId);
        JobSubmissionInterface jobSubmission = RegisterSampleApplicationsUtils.createJobSubmissionInterface(fsdResourceId, protocol, 2);
        UnicoreJobSubmission ucrJobSubmission = new UnicoreJobSubmission();
        ucrJobSubmission.setSecurityProtocol(securityProtocol);
        ucrJobSubmission.setUnicoreEndPointURL(unicoreEndPointURL);
        return jobSubmission.getJobSubmissionInterfaceId();
    }

    public static String createEchoExperimentForTrestles(Airavata.Client client) throws TException {
        try {
            List exInputs = client.getApplicationInputs(new AuthzToken(""), echoAppId);
            for (InputDataObjectType inputDataObjectType : exInputs) {
                if (!inputDataObjectType.getName().equalsIgnoreCase("Input_to_Echo")) continue;
                inputDataObjectType.setValue("Hello World");
            }
            List exOut = client.getApplicationOutputs(new AuthzToken(""), echoAppId);
            Project project = ProjectModelUtil.createProject((String)DEFAULT_GATEWAY, (String)"admin", (String)"test project");
            String projectId = client.createProject(new AuthzToken(""), DEFAULT_GATEWAY, project);
            ExperimentModel simpleExperiment = ExperimentModelUtil.createSimpleExperiment((String)DEFAULT_GATEWAY, (String)projectId, (String)"admin", (String)"echoExperiment", (String)"SimpleEcho3", (String)echoAppId, (List)exInputs);
            simpleExperiment.setExperimentOutputs(exOut);
            Map computeResources = airavataClient.getAvailableAppInterfaceComputeResources(new AuthzToken(""), echoAppId);
            if (computeResources != null && computeResources.size() != 0) {
                for (String id : computeResources.keySet()) {
                    String resourceName = (String)computeResources.get(id);
                    if (!resourceName.equals(trestlesHostName)) continue;
                    ComputationalResourceSchedulingModel scheduling = ExperimentModelUtil.createComputationResourceScheduling((String)id, (int)1, (int)1, (int)1, (String)"normal", (int)30, (int)1);
                    UserConfigurationDataModel userConfigurationData = new UserConfigurationDataModel();
                    userConfigurationData.setAiravataAutoSchedule(false);
                    userConfigurationData.setOverrideManualScheduledParams(false);
                    userConfigurationData.setComputationalResourceScheduling(scheduling);
                    simpleExperiment.setUserConfigurationData(userConfigurationData);
                    return client.createExperiment(new AuthzToken(""), DEFAULT_GATEWAY, simpleExperiment);
                }
            }
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
        return null;
    }

    public static String createEchoExperimentForFSD(Airavata.Client client) throws TException {
        try {
            List exInputs = client.getApplicationInputs(new AuthzToken(""), echoAppId);
            for (InputDataObjectType inputDataObjectType : exInputs) {
                if (inputDataObjectType.getName().equalsIgnoreCase("Input_to_Echo")) {
                    inputDataObjectType.setValue("Hello World");
                    continue;
                }
                if (inputDataObjectType.getName().equalsIgnoreCase("Input_to_Echo2")) {
                    inputDataObjectType.setValue("http://www.textfiles.com/100/ad.txt");
                    continue;
                }
                if (!inputDataObjectType.getName().equalsIgnoreCase("Input_to_Echo3")) continue;
                inputDataObjectType.setValue("file:///tmp/test.txt");
            }
            List exOut = client.getApplicationOutputs(new AuthzToken(""), echoAppId);
            ExperimentModel simpleExperiment = ExperimentModelUtil.createSimpleExperiment((String)DEFAULT_GATEWAY, (String)DEFAULT_GATEWAY, (String)"admin", (String)"echoExperiment", (String)"SimpleEcho2", (String)echoAppId, (List)exInputs);
            simpleExperiment.setExperimentOutputs(exOut);
            Map computeResources = airavataClient.getAvailableAppInterfaceComputeResources(new AuthzToken(""), echoAppId);
            if (computeResources != null && computeResources.size() != 0) {
                for (String id : computeResources.keySet()) {
                    String resourceName = (String)computeResources.get(id);
                    if (!resourceName.equals(unicoreHostName)) continue;
                    ComputationalResourceSchedulingModel scheduling = ExperimentModelUtil.createComputationResourceScheduling((String)id, (int)1, (int)1, (int)1, (String)"normal", (int)30, (int)0x100000);
                    UserConfigurationDataModel userConfigurationData = new UserConfigurationDataModel();
                    userConfigurationData.setAiravataAutoSchedule(false);
                    userConfigurationData.setOverrideManualScheduledParams(false);
                    userConfigurationData.setComputationalResourceScheduling(scheduling);
                    userConfigurationData.setGenerateCert(false);
                    userConfigurationData.setUserDN("");
                    simpleExperiment.setUserConfigurationData(userConfigurationData);
                    return client.createExperiment(new AuthzToken(""), DEFAULT_GATEWAY, simpleExperiment);
                }
            }
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
        return null;
    }

    public static String createMPIExperimentForFSD(Airavata.Client client) throws TException {
        try {
            List exInputs = client.getApplicationInputs(new AuthzToken(""), mpiAppId);
            for (InputDataObjectType inputDataObjectType : exInputs) {
                if (!inputDataObjectType.getName().equalsIgnoreCase("Sample_Input")) continue;
                inputDataObjectType.setValue("");
            }
            List exOut = client.getApplicationOutputs(new AuthzToken(""), mpiAppId);
            ExperimentModel simpleExperiment = ExperimentModelUtil.createSimpleExperiment((String)DEFAULT_GATEWAY, (String)DEFAULT_GATEWAY, (String)"admin", (String)"mpiExperiment", (String)"HelloMPI", (String)mpiAppId, null);
            simpleExperiment.setExperimentOutputs(exOut);
            Map computeResources = airavataClient.getAvailableAppInterfaceComputeResources(new AuthzToken(""), mpiAppId);
            if (computeResources != null && computeResources.size() != 0) {
                for (String id : computeResources.keySet()) {
                    String resourceName = (String)computeResources.get(id);
                    if (!resourceName.equals(unicoreHostName)) continue;
                    ComputationalResourceSchedulingModel scheduling = ExperimentModelUtil.createComputationResourceScheduling((String)id, (int)2, (int)1, (int)2, (String)"normal", (int)30, (int)0x100000);
                    UserConfigurationDataModel userConfigurationData = new UserConfigurationDataModel();
                    userConfigurationData.setAiravataAutoSchedule(false);
                    userConfigurationData.setOverrideManualScheduledParams(false);
                    userConfigurationData.setComputationalResourceScheduling(scheduling);
                    userConfigurationData.setGenerateCert(false);
                    userConfigurationData.setUserDN("");
                    simpleExperiment.setUserConfigurationData(userConfigurationData);
                    return client.createExperiment(new AuthzToken(""), DEFAULT_GATEWAY, simpleExperiment);
                }
            }
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
        return null;
    }

    public static String createExperimentWRFStampede(Airavata.Client client) throws TException {
        try {
            List exInputs = client.getApplicationInputs(new AuthzToken(""), wrfAppId);
            CreateLaunchExperiment.setWRFInputs(exInputs);
            List exOut = client.getApplicationOutputs(new AuthzToken(""), wrfAppId);
            ExperimentModel simpleExperiment = ExperimentModelUtil.createSimpleExperiment((String)DEFAULT_GATEWAY, (String)DEFAULT_GATEWAY, (String)"admin", (String)"WRFExperiment", (String)"Testing", (String)wrfAppId, (List)exInputs);
            simpleExperiment.setExperimentOutputs(exOut);
            Map computeResources = airavataClient.getAvailableAppInterfaceComputeResources(new AuthzToken(""), wrfAppId);
            if (computeResources != null && computeResources.size() != 0) {
                for (String id : computeResources.keySet()) {
                    String resourceName = (String)computeResources.get(id);
                    if (!resourceName.equals(stampedeHostName)) continue;
                    ComputationalResourceSchedulingModel scheduling = ExperimentModelUtil.createComputationResourceScheduling((String)id, (int)2, (int)32, (int)1, (String)"development", (int)90, (int)1);
                    UserConfigurationDataModel userConfigurationData = new UserConfigurationDataModel();
                    userConfigurationData.setAiravataAutoSchedule(false);
                    userConfigurationData.setOverrideManualScheduledParams(false);
                    userConfigurationData.setComputationalResourceScheduling(scheduling);
                    simpleExperiment.setUserConfigurationData(userConfigurationData);
                    return client.createExperiment(new AuthzToken(""), DEFAULT_GATEWAY, simpleExperiment);
                }
            }
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
        return null;
    }

    private static void setWRFInputs(List<InputDataObjectType> exInputs) {
        for (InputDataObjectType inputDataObjectType : exInputs) {
            if (inputDataObjectType.getName().equalsIgnoreCase("Config_Namelist_File")) {
                inputDataObjectType.setValue("/Users/shameera/Downloads/PHP-Gateway-Scripts/appScripts/WRF_FILES/namelist.input");
                continue;
            }
            if (inputDataObjectType.getName().equalsIgnoreCase("WRF_Initial_Conditions")) {
                inputDataObjectType.setValue("/Users/shameera/Downloads/PHP-Gateway-Scripts/appScripts/WRF_FILES/wrfinput_d01");
                continue;
            }
            if (!inputDataObjectType.getName().equalsIgnoreCase("WRF_Boundary_File")) continue;
            inputDataObjectType.setValue("/Users/shameera/Downloads/PHP-Gateway-Scripts/appScripts/WRF_FILES/wrfbdy_d01");
        }
    }

    public static String createExperimentGROMACSStampede(Airavata.Client client) throws TException {
        try {
            List exInputs = client.getApplicationInputs(new AuthzToken(""), gromacsAppId);
            CreateLaunchExperiment.setGROMACSInputs(exInputs);
            List exOut = client.getApplicationOutputs(new AuthzToken(""), gromacsAppId);
            ExperimentModel simpleExperiment = ExperimentModelUtil.createSimpleExperiment((String)DEFAULT_GATEWAY, (String)DEFAULT_GATEWAY, (String)"admin", (String)"GromacsExperiment", (String)"Testing", (String)gromacsAppId, (List)exInputs);
            simpleExperiment.setExperimentOutputs(exOut);
            Map computeResources = airavataClient.getAvailableAppInterfaceComputeResources(new AuthzToken(""), gromacsAppId);
            if (computeResources != null && computeResources.size() != 0) {
                for (String id : computeResources.keySet()) {
                    String resourceName = (String)computeResources.get(id);
                    if (!resourceName.equals(stampedeHostName)) continue;
                    ComputationalResourceSchedulingModel scheduling = ExperimentModelUtil.createComputationResourceScheduling((String)id, (int)1, (int)16, (int)1, (String)"development", (int)30, (int)1);
                    UserConfigurationDataModel userConfigurationData = new UserConfigurationDataModel();
                    userConfigurationData.setAiravataAutoSchedule(false);
                    userConfigurationData.setOverrideManualScheduledParams(false);
                    userConfigurationData.setComputationalResourceScheduling(scheduling);
                    simpleExperiment.setUserConfigurationData(userConfigurationData);
                    return client.createExperiment(new AuthzToken(""), DEFAULT_GATEWAY, simpleExperiment);
                }
            }
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
        return null;
    }

    private static void setGROMACSInputs(List<InputDataObjectType> exInputs) {
        for (InputDataObjectType inputDataObjectType : exInputs) {
            if (inputDataObjectType.getName().equalsIgnoreCase("GROMOS_Coordinate_File")) {
                inputDataObjectType.setValue("/Users/shameera/Downloads/PHP-Gateway-Scripts/appScripts/GROMMACS_FILES/pdb1y6l-EM-vacuum.gro");
                continue;
            }
            if (!inputDataObjectType.getName().equalsIgnoreCase("Portable_Input_Binary_File")) continue;
            inputDataObjectType.setValue("/Users/shameera/Downloads/PHP-Gateway-Scripts/appScripts/GROMMACS_FILES/pdb1y6l-EM-vacuum.tpr");
        }
    }

    public static String createExperimentESPRESSOStampede(Airavata.Client client) throws TException {
        try {
            List exInputs = client.getApplicationInputs(new AuthzToken(""), espressoAppId);
            CreateLaunchExperiment.setESPRESSOInputs(exInputs);
            List exOut = client.getApplicationOutputs(new AuthzToken(""), espressoAppId);
            ExperimentModel simpleExperiment = ExperimentModelUtil.createSimpleExperiment((String)DEFAULT_GATEWAY, (String)DEFAULT_GATEWAY, (String)"admin", (String)"EspressoExperiment", (String)"Testing", (String)espressoAppId, (List)exInputs);
            simpleExperiment.setExperimentOutputs(exOut);
            Map computeResources = airavataClient.getAvailableAppInterfaceComputeResources(new AuthzToken(""), espressoAppId);
            if (computeResources != null && computeResources.size() != 0) {
                for (String id : computeResources.keySet()) {
                    String resourceName = (String)computeResources.get(id);
                    if (!resourceName.equals(stampedeHostName)) continue;
                    ComputationalResourceSchedulingModel scheduling = ExperimentModelUtil.createComputationResourceScheduling((String)id, (int)1, (int)16, (int)1, (String)"development", (int)30, (int)1);
                    UserConfigurationDataModel userConfigurationData = new UserConfigurationDataModel();
                    userConfigurationData.setAiravataAutoSchedule(false);
                    userConfigurationData.setOverrideManualScheduledParams(false);
                    userConfigurationData.setComputationalResourceScheduling(scheduling);
                    simpleExperiment.setUserConfigurationData(userConfigurationData);
                    return client.createExperiment(new AuthzToken(""), DEFAULT_GATEWAY, simpleExperiment);
                }
            }
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
        return null;
    }

    private static void setESPRESSOInputs(List<InputDataObjectType> exInputs) {
        for (InputDataObjectType inputDataObjectType : exInputs) {
            if (inputDataObjectType.getName().equalsIgnoreCase("AI_Pseudopotential_File")) {
                inputDataObjectType.setValue("/Users/shameera/Downloads/PHP-Gateway-Scripts/appScripts/ESPRESSO_FILES/Al.sample.in");
                continue;
            }
            if (!inputDataObjectType.getName().equalsIgnoreCase("AI_Primitive_Cell")) continue;
            inputDataObjectType.setValue("/Users/shameera/Downloads/PHP-Gateway-Scripts/appScripts/ESPRESSO_FILES/Al.pz-vbc.UPF");
        }
    }

    public static String createExperimentTRINITYStampede(Airavata.Client client) throws TException {
        try {
            List exInputs = client.getApplicationInputs(new AuthzToken(""), trinityAppId);
            CreateLaunchExperiment.setTRINITYInputs(exInputs);
            List exOut = client.getApplicationOutputs(new AuthzToken(""), trinityAppId);
            ExperimentModel simpleExperiment = ExperimentModelUtil.createSimpleExperiment((String)DEFAULT_GATEWAY, (String)DEFAULT_GATEWAY, (String)"admin", (String)"TrinityExperiment", (String)"Testing", (String)trinityAppId, (List)exInputs);
            simpleExperiment.setExperimentOutputs(exOut);
            Map computeResources = airavataClient.getAvailableAppInterfaceComputeResources(new AuthzToken(""), trinityAppId);
            if (computeResources != null && computeResources.size() != 0) {
                for (String id : computeResources.keySet()) {
                    String resourceName = (String)computeResources.get(id);
                    if (!resourceName.equals(stampedeHostName)) continue;
                    ComputationalResourceSchedulingModel scheduling = ExperimentModelUtil.createComputationResourceScheduling((String)id, (int)1, (int)16, (int)1, (String)"development", (int)30, (int)1);
                    UserConfigurationDataModel userConfigurationData = new UserConfigurationDataModel();
                    userConfigurationData.setAiravataAutoSchedule(false);
                    userConfigurationData.setOverrideManualScheduledParams(false);
                    userConfigurationData.setComputationalResourceScheduling(scheduling);
                    simpleExperiment.setUserConfigurationData(userConfigurationData);
                    return client.createExperiment(new AuthzToken(""), DEFAULT_GATEWAY, simpleExperiment);
                }
            }
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
        return null;
    }

    private static void setTRINITYInputs(List<InputDataObjectType> exInputs) {
        for (InputDataObjectType inputDataObjectType : exInputs) {
            if (inputDataObjectType.getName().equalsIgnoreCase("RNA_Seq_Left_Input")) {
                inputDataObjectType.setValue("/Users/shameera/Downloads/PHP-Gateway-Scripts/appScripts/TRINITY_FILES/reads.left.fq");
                continue;
            }
            if (!inputDataObjectType.getName().equalsIgnoreCase("RNA_Seq_Right_Input")) continue;
            inputDataObjectType.setValue("/Users/shameera/Downloads/PHP-Gateway-Scripts/appScripts/TRINITY_FILES/reads.right.fq");
        }
    }

    public static String createExperimentLAMMPSStampede(Airavata.Client client) throws TException {
        try {
            List exInputs = client.getApplicationInputs(new AuthzToken(""), lammpsAppId);
            CreateLaunchExperiment.setLAMMPSInputs(exInputs);
            List exOut = client.getApplicationOutputs(new AuthzToken(""), lammpsAppId);
            ExperimentModel simpleExperiment = ExperimentModelUtil.createSimpleExperiment((String)DEFAULT_GATEWAY, (String)DEFAULT_GATEWAY, (String)"admin", (String)"LAMMPSExperiment", (String)"Testing", (String)lammpsAppId, (List)exInputs);
            simpleExperiment.setExperimentOutputs(exOut);
            Map computeResources = airavataClient.getAvailableAppInterfaceComputeResources(new AuthzToken(""), lammpsAppId);
            if (computeResources != null && computeResources.size() != 0) {
                for (String id : computeResources.keySet()) {
                    String resourceName = (String)computeResources.get(id);
                    if (!resourceName.equals(stampedeHostName)) continue;
                    ComputationalResourceSchedulingModel scheduling = ExperimentModelUtil.createComputationResourceScheduling((String)id, (int)1, (int)16, (int)1, (String)"development", (int)30, (int)1);
                    UserConfigurationDataModel userConfigurationData = new UserConfigurationDataModel();
                    userConfigurationData.setAiravataAutoSchedule(false);
                    userConfigurationData.setOverrideManualScheduledParams(false);
                    userConfigurationData.setComputationalResourceScheduling(scheduling);
                    simpleExperiment.setUserConfigurationData(userConfigurationData);
                    return client.createExperiment(new AuthzToken(""), DEFAULT_GATEWAY, simpleExperiment);
                }
            }
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
        return null;
    }

    private static void setLAMMPSInputs(List<InputDataObjectType> exInputs) {
        for (InputDataObjectType inputDataObjectType : exInputs) {
            if (!inputDataObjectType.getName().equalsIgnoreCase("Friction_Simulation_Input")) continue;
            inputDataObjectType.setValue("/Users/shameera/Downloads/PHP-Gateway-Scripts/appScripts/LAMMPS_FILES/in.friction");
        }
    }

    public static String createExperimentNWCHEMStampede(Airavata.Client client) throws TException {
        try {
            List exInputs = client.getApplicationInputs(new AuthzToken(""), nwchemAppId);
            CreateLaunchExperiment.setNWCHEMInputs(exInputs);
            List exOut = client.getApplicationOutputs(new AuthzToken(""), nwchemAppId);
            ExperimentModel simpleExperiment = ExperimentModelUtil.createSimpleExperiment((String)DEFAULT_GATEWAY, (String)DEFAULT_GATEWAY, (String)"admin", (String)"NWchemExperiment", (String)"Testing", (String)nwchemAppId, (List)exInputs);
            simpleExperiment.setExperimentOutputs(exOut);
            Map computeResources = airavataClient.getAvailableAppInterfaceComputeResources(new AuthzToken(""), nwchemAppId);
            if (computeResources != null && computeResources.size() != 0) {
                for (String id : computeResources.keySet()) {
                    String resourceName = (String)computeResources.get(id);
                    if (!resourceName.equals(stampedeHostName)) continue;
                    ComputationalResourceSchedulingModel scheduling = ExperimentModelUtil.createComputationResourceScheduling((String)id, (int)1, (int)16, (int)1, (String)"development", (int)30, (int)1);
                    UserConfigurationDataModel userConfigurationData = new UserConfigurationDataModel();
                    userConfigurationData.setAiravataAutoSchedule(false);
                    userConfigurationData.setOverrideManualScheduledParams(false);
                    userConfigurationData.setComputationalResourceScheduling(scheduling);
                    simpleExperiment.setUserConfigurationData(userConfigurationData);
                    return client.createExperiment(new AuthzToken(""), DEFAULT_GATEWAY, simpleExperiment);
                }
            }
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
        return null;
    }

    private static void setNWCHEMInputs(List<InputDataObjectType> exInputs) {
        for (InputDataObjectType inputDataObjectType : exInputs) {
            if (!inputDataObjectType.getName().equalsIgnoreCase("Water_Molecule_Input")) continue;
            inputDataObjectType.setValue("/Users/shameera/Downloads/PHP-Gateway-Scripts/appScripts/NWCHEM_FILES/water.nw");
        }
    }

    public static String createExperimentAUTODOCKStampede(Airavata.Client client) throws TException {
        try {
            List exInputs = client.getApplicationInputs(new AuthzToken(""), nwchemAppId);
            CreateLaunchExperiment.setAUTODOCKInputs(exInputs);
            List exOut = client.getApplicationOutputs(new AuthzToken(""), nwchemAppId);
            ExperimentModel simpleExperiment = ExperimentModelUtil.createSimpleExperiment((String)DEFAULT_GATEWAY, (String)DEFAULT_GATEWAY, (String)"admin", (String)"AutoDockExperiment", (String)"Testing", (String)autodockAppId, (List)exInputs);
            simpleExperiment.setExperimentOutputs(exOut);
            Map computeResources = airavataClient.getAvailableAppInterfaceComputeResources(new AuthzToken(""), autodockAppId);
            if (computeResources != null && computeResources.size() != 0) {
                for (String id : computeResources.keySet()) {
                    String resourceName = (String)computeResources.get(id);
                    if (!resourceName.equals(stampedeHostName)) continue;
                    ComputationalResourceSchedulingModel scheduling = ExperimentModelUtil.createComputationResourceScheduling((String)id, (int)1, (int)16, (int)1, (String)"development", (int)30, (int)1);
                    UserConfigurationDataModel userConfigurationData = new UserConfigurationDataModel();
                    userConfigurationData.setAiravataAutoSchedule(false);
                    userConfigurationData.setOverrideManualScheduledParams(false);
                    userConfigurationData.setComputationalResourceScheduling(scheduling);
                    simpleExperiment.setUserConfigurationData(userConfigurationData);
                    return client.createExperiment(new AuthzToken(""), DEFAULT_GATEWAY, simpleExperiment);
                }
            }
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
        return null;
    }

    private static void setAUTODOCKInputs(List<InputDataObjectType> exInputs) {
        for (InputDataObjectType inputDataObjectType : exInputs) {
            if (inputDataObjectType.getName().equalsIgnoreCase("AD4_parameters.dat")) {
                inputDataObjectType.setValue("/Users/shameera/Downloads/PHP-Gateway-Scripts/appScripts/AUTODOCK_FILES/AD4_parameters.dat");
                continue;
            }
            if (inputDataObjectType.getName().equalsIgnoreCase("hsg1.A.map")) {
                inputDataObjectType.setValue("/Users/shameera/Downloads/PHP-Gateway-Scripts/appScripts/AUTODOCK_FILES/hsg1.A.map");
                continue;
            }
            if (inputDataObjectType.getName().equalsIgnoreCase("hsg1.C.map")) {
                inputDataObjectType.setValue("/Users/shameera/Downloads/PHP-Gateway-Scripts/appScripts/AUTODOCK_FILES/hsg1.C.map");
                continue;
            }
            if (inputDataObjectType.getName().equalsIgnoreCase("hsg1.d.map")) {
                inputDataObjectType.setValue("/Users/shameera/Downloads/PHP-Gateway-Scripts/appScripts/AUTODOCK_FILES/hsg1.d.map");
                continue;
            }
            if (inputDataObjectType.getName().equalsIgnoreCase("hsg1.e.map")) {
                inputDataObjectType.setValue("/Users/shameera/Downloads/PHP-Gateway-Scripts/appScripts/AUTODOCK_FILES/hsg1.e.map");
                continue;
            }
            if (inputDataObjectType.getName().equalsIgnoreCase("hsg1.HD.map")) {
                inputDataObjectType.setValue("/Users/shameera/Downloads/PHP-Gateway-Scripts/appScripts/AUTODOCK_FILES/hsg1.HD.map");
                continue;
            }
            if (inputDataObjectType.getName().equalsIgnoreCase("hsg1.maps.fld")) {
                inputDataObjectType.setValue("/Users/shameera/Downloads/PHP-Gateway-Scripts/appScripts/AUTODOCK_FILES/hsg1.maps.fld");
                continue;
            }
            if (inputDataObjectType.getName().equalsIgnoreCase("hsg1.NA.map")) {
                inputDataObjectType.setValue("/Users/shameera/Downloads/PHP-Gateway-Scripts/appScripts/AUTODOCK_FILES/hsg1.NA.map");
                continue;
            }
            if (inputDataObjectType.getName().equalsIgnoreCase("hsg1.N.map")) {
                inputDataObjectType.setValue("/Users/shameera/Downloads/PHP-Gateway-Scripts/appScripts/AUTODOCK_FILES/hsg1.N.map");
                continue;
            }
            if (inputDataObjectType.getName().equalsIgnoreCase("hsg1.OA.map")) {
                inputDataObjectType.setValue("/Users/shameera/Downloads/PHP-Gateway-Scripts/appScripts/AUTODOCK_FILES/hsg1.OA.map");
                continue;
            }
            if (inputDataObjectType.getName().equalsIgnoreCase("ind.dpf")) {
                inputDataObjectType.setValue("/Users/shameera/Downloads/PHP-Gateway-Scripts/appScripts/AUTODOCK_FILES/ind.dpf");
                continue;
            }
            if (!inputDataObjectType.getName().equalsIgnoreCase("ind.pdbqt")) continue;
            inputDataObjectType.setValue("/Users/shameera/Downloads/PHP-Gateway-Scripts/appScripts/AUTODOCK_FILES/ind.pdbqt");
        }
    }

    public static String createExperimentWRFTrestles(Airavata.Client client) throws TException {
        try {
            List exInputs = client.getApplicationInputs(new AuthzToken(""), wrfAppId);
            CreateLaunchExperiment.setWRFInputs(exInputs);
            List exOut = client.getApplicationOutputs(new AuthzToken(""), wrfAppId);
            ExperimentModel simpleExperiment = ExperimentModelUtil.createSimpleExperiment((String)DEFAULT_GATEWAY, (String)DEFAULT_GATEWAY, (String)"admin", (String)"WRFExperiment", (String)"Testing", (String)wrfAppId, (List)exInputs);
            simpleExperiment.setExperimentOutputs(exOut);
            Map computeResources = airavataClient.getAvailableAppInterfaceComputeResources(new AuthzToken(""), wrfAppId);
            if (computeResources != null && computeResources.size() != 0) {
                for (String id : computeResources.keySet()) {
                    String resourceName = (String)computeResources.get(id);
                    if (!resourceName.equals(trestlesHostName)) continue;
                    ComputationalResourceSchedulingModel scheduling = ExperimentModelUtil.createComputationResourceScheduling((String)id, (int)1, (int)1, (int)1, (String)"normal", (int)30, (int)1);
                    UserConfigurationDataModel userConfigurationData = new UserConfigurationDataModel();
                    userConfigurationData.setAiravataAutoSchedule(false);
                    userConfigurationData.setOverrideManualScheduledParams(false);
                    userConfigurationData.setComputationalResourceScheduling(scheduling);
                    simpleExperiment.setUserConfigurationData(userConfigurationData);
                    return client.createExperiment(new AuthzToken(""), DEFAULT_GATEWAY, simpleExperiment);
                }
            }
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
        return null;
    }

    public static String cloneExperiment(Airavata.Client client, String expId) throws TException {
        try {
            return client.cloneExperiment(new AuthzToken(""), expId, "cloneExperiment1", null);
        }
        catch (TException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
    }

    public static void updateExperiment(Airavata.Client client, String expId) throws TException {
        try {
            ExperimentModel experiment = client.getExperiment(new AuthzToken(""), expId);
            experiment.setDescription("updatedDescription");
            client.updateExperiment(new AuthzToken(""), expId, experiment);
        }
        catch (TException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
    }

    public static String createExperimentEchoForLocalHost(Airavata.Client client) throws TException {
        try {
            List exInputs = client.getApplicationInputs(new AuthzToken(""), echoAppId);
            for (InputDataObjectType inputDataObjectType : exInputs) {
                if (!inputDataObjectType.getName().equalsIgnoreCase("Input_to_Echo")) continue;
                inputDataObjectType.setValue("Hello World");
            }
            List exOut = client.getApplicationOutputs(new AuthzToken(""), echoAppId);
            Project project = ProjectModelUtil.createProject((String)"project1", (String)"admin", (String)"test project");
            String projectId = client.createProject(new AuthzToken(""), DEFAULT_GATEWAY, project);
            ExperimentModel simpleExperiment = ExperimentModelUtil.createSimpleExperiment((String)DEFAULT_GATEWAY, (String)projectId, (String)"admin", (String)"echoExperiment", (String)"Echo Test", (String)echoAppId, (List)exInputs);
            simpleExperiment.setExperimentOutputs(exOut);
            Map computeResources = airavataClient.getAvailableAppInterfaceComputeResources(new AuthzToken(""), echoAppId);
            if (computeResources != null && computeResources.size() != 0) {
                for (String id : computeResources.keySet()) {
                    String resourceName = (String)computeResources.get(id);
                    if (!resourceName.equals(localHost)) continue;
                    ComputationalResourceSchedulingModel scheduling = ExperimentModelUtil.createComputationResourceScheduling((String)id, (int)1, (int)1, (int)1, (String)"normal", (int)30, (int)1);
                    UserConfigurationDataModel userConfigurationData = new UserConfigurationDataModel();
                    userConfigurationData.setAiravataAutoSchedule(false);
                    userConfigurationData.setOverrideManualScheduledParams(false);
                    userConfigurationData.setComputationalResourceScheduling(scheduling);
                    simpleExperiment.setUserConfigurationData(userConfigurationData);
                    return client.createExperiment(new AuthzToken(""), DEFAULT_GATEWAY, simpleExperiment);
                }
            }
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
        return null;
    }

    public static String createEchoExperimentForStampede(Airavata.Client client) throws TException {
        try {
            List exInputs = client.getApplicationInputs(new AuthzToken(""), echoAppId);
            Project project = ProjectModelUtil.createProject((String)DEFAULT_GATEWAY, (String)"admin", (String)"test project");
            String projectId = client.createProject(new AuthzToken(""), DEFAULT_GATEWAY, project);
            ExperimentModel simpleExperiment = ExperimentModelUtil.createSimpleExperiment((String)DEFAULT_GATEWAY, (String)projectId, (String)"admin", (String)"echoExperiment", (String)"SimpleEcho3", (String)echoAppId, (List)exInputs);
            Map computeResources = airavataClient.getAvailableAppInterfaceComputeResources(new AuthzToken(""), echoAppId);
            if (computeResources != null && computeResources.size() != 0) {
                for (String id : computeResources.keySet()) {
                    String resourceName = (String)computeResources.get(id);
                    if (!resourceName.equals(stampedeHostName)) continue;
                    ComputationalResourceSchedulingModel scheduling = ExperimentModelUtil.createComputationResourceScheduling((String)id, (int)1, (int)1, (int)1, (String)"normal", (int)30, (int)1);
                    UserConfigurationDataModel userConfigurationData = new UserConfigurationDataModel();
                    userConfigurationData.setAiravataAutoSchedule(false);
                    userConfigurationData.setOverrideManualScheduledParams(false);
                    userConfigurationData.setComputationalResourceScheduling(scheduling);
                    simpleExperiment.setUserConfigurationData(userConfigurationData);
                    return client.createExperiment(new AuthzToken(""), DEFAULT_GATEWAY, simpleExperiment);
                }
            }
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
        return null;
    }

    public static String createExperimentForBR2(Airavata.Client client) throws TException {
        try {
            List exInputs = client.getApplicationInputs(new AuthzToken(""), echoAppId);
            for (InputDataObjectType inputDataObjectType : exInputs) {
                if (!inputDataObjectType.getName().equalsIgnoreCase("Input_to_Echo")) continue;
                inputDataObjectType.setValue("Hello World");
            }
            List exOut = client.getApplicationOutputs(new AuthzToken(""), echoAppId);
            Project project = ProjectModelUtil.createProject((String)DEFAULT_GATEWAY, (String)"lahiru", (String)"test project");
            String projectId = client.createProject(new AuthzToken(""), DEFAULT_GATEWAY, project);
            ExperimentModel simpleExperiment = ExperimentModelUtil.createSimpleExperiment((String)DEFAULT_GATEWAY, (String)projectId, (String)"lahiru", (String)"sshEchoExperiment", (String)"SimpleEchoBR", (String)echoAppId, (List)exInputs);
            simpleExperiment.setExperimentOutputs(exOut);
            Map computeResources = airavataClient.getAvailableAppInterfaceComputeResources(new AuthzToken(""), echoAppId);
            if (computeResources != null && computeResources.size() != 0) {
                for (String id : computeResources.keySet()) {
                    String resourceName = (String)computeResources.get(id);
                    if (!resourceName.equals(br2HostName)) continue;
                    ComputationalResourceSchedulingModel scheduling = ExperimentModelUtil.createComputationResourceScheduling((String)id, (int)1, (int)1, (int)1, (String)"normal", (int)30, (int)1);
                    UserConfigurationDataModel userConfigurationData = new UserConfigurationDataModel();
                    userConfigurationData.setAiravataAutoSchedule(false);
                    userConfigurationData.setOverrideManualScheduledParams(false);
                    userConfigurationData.setComputationalResourceScheduling(scheduling);
                    simpleExperiment.setUserConfigurationData(userConfigurationData);
                    return client.createExperiment(new AuthzToken(""), DEFAULT_GATEWAY, simpleExperiment);
                }
            }
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
        return null;
    }

    public static String createExperimentForLSF(Airavata.Client client) throws TException {
        try {
            List exInputs = client.getApplicationInputs(new AuthzToken(""), echoAppId);
            for (InputDataObjectType inputDataObjectType : exInputs) {
                inputDataObjectType.setValue("Hello World");
            }
            List exOut = client.getApplicationOutputs(new AuthzToken(""), echoAppId);
            Project project = ProjectModelUtil.createProject((String)DEFAULT_GATEWAY, (String)"lg11w", (String)"test project");
            String projectId = client.createProject(new AuthzToken(""), DEFAULT_GATEWAY, project);
            ExperimentModel simpleExperiment = ExperimentModelUtil.createSimpleExperiment((String)DEFAULT_GATEWAY, (String)projectId, (String)"lg11w", (String)"sshEchoExperiment", (String)"StressMem", (String)echoAppId, (List)exInputs);
            simpleExperiment.setExperimentOutputs(exOut);
            simpleExperiment.setExperimentInputs(exInputs);
            Map computeResources = airavataClient.getAvailableAppInterfaceComputeResources(new AuthzToken(""), echoAppId);
            if (computeResources != null && computeResources.size() != 0) {
                for (String id : computeResources.keySet()) {
                    String resourceName = (String)computeResources.get(id);
                    if (!resourceName.equals(umassrcHostName)) continue;
                    ComputationalResourceSchedulingModel scheduling = ExperimentModelUtil.createComputationResourceScheduling((String)id, (int)10, (int)1, (int)1, (String)"long", (int)60, (int)1000);
                    UserConfigurationDataModel userConfigurationData = new UserConfigurationDataModel();
                    userConfigurationData.setAiravataAutoSchedule(false);
                    userConfigurationData.setOverrideManualScheduledParams(false);
                    userConfigurationData.setComputationalResourceScheduling(scheduling);
                    simpleExperiment.setUserConfigurationData(userConfigurationData);
                    simpleExperiment.setEmailAddresses(Arrays.asList("test@umassmed.edu"));
                    return client.createExperiment(new AuthzToken(""), DEFAULT_GATEWAY, simpleExperiment);
                }
            }
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
        return null;
    }

    public static String createExperimentLAMMPSForLSF(Airavata.Client client) throws TException {
        try {
            List exInputs = client.getApplicationInputs(new AuthzToken(""), lammpsAppId);
            for (InputDataObjectType inputDataObjectType : exInputs) {
                inputDataObjectType.setName("Friction_Simulation_Input");
                inputDataObjectType.setValue("/Users/lginnali/Downloads/data/in.friction");
                inputDataObjectType.setType(DataType.URI);
            }
            List exOut = client.getApplicationOutputs(new AuthzToken(""), echoAppId);
            ExperimentModel simpleExperiment = ExperimentModelUtil.createSimpleExperiment((String)DEFAULT_GATEWAY, (String)DEFAULT_GATEWAY, (String)"lg11w", (String)"LAMMPSExperiment", (String)"Testing", (String)lammpsAppId, (List)exInputs);
            simpleExperiment.setExperimentOutputs(exOut);
            Map computeResources = airavataClient.getAvailableAppInterfaceComputeResources(new AuthzToken(""), lammpsAppId);
            if (computeResources != null && computeResources.size() != 0) {
                for (String id : computeResources.keySet()) {
                    String resourceName = (String)computeResources.get(id);
                    if (!resourceName.equals(umassrcHostName)) continue;
                    ComputationalResourceSchedulingModel scheduling = ExperimentModelUtil.createComputationResourceScheduling((String)id, (int)10, (int)16, (int)1, (String)"long", (int)60, (int)1000);
                    UserConfigurationDataModel userConfigurationData = new UserConfigurationDataModel();
                    userConfigurationData.setAiravataAutoSchedule(false);
                    userConfigurationData.setOverrideManualScheduledParams(false);
                    userConfigurationData.setComputationalResourceScheduling(scheduling);
                    simpleExperiment.setUserConfigurationData(userConfigurationData);
                    return client.createExperiment(new AuthzToken(""), DEFAULT_GATEWAY, simpleExperiment);
                }
            }
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
        return null;
    }

    public static String createExperimentForBR2Amber(Airavata.Client client) throws TException {
        try {
            List exInputs = client.getApplicationInputs(new AuthzToken(""), amberAppId);
            for (InputDataObjectType inputDataObjectType : exInputs) {
                if (inputDataObjectType.getName().equalsIgnoreCase("Heat_Restart_File")) {
                    inputDataObjectType.setValue("file://root@test-drive.airavata.org:/var/www/experimentData/admin101a290e6330f15a91349159553ae8b6bb1/02_Heat.rst");
                    continue;
                }
                if (inputDataObjectType.getName().equalsIgnoreCase("Production_Control_File")) {
                    inputDataObjectType.setValue("file://root@test-drive.airavata.org:/var/www/experimentData/admin101a290e6330f15a91349159553ae8b6bb1/03_Prod.in");
                    continue;
                }
                if (!inputDataObjectType.getName().equalsIgnoreCase("Parameter_Topology_File")) continue;
                inputDataObjectType.setValue("file://root@test-drive.airavata.org:/var/www/experimentData/admin101a290e6330f15a91349159553ae8b6bb1/prmtop");
            }
            List exOut = client.getApplicationOutputs(new AuthzToken(""), amberAppId);
            Project project = ProjectModelUtil.createProject((String)DEFAULT_GATEWAY, (String)"admin", (String)"test project");
            String projectId = client.createProject(new AuthzToken(""), DEFAULT_GATEWAY, project);
            ExperimentModel simpleExperiment = ExperimentModelUtil.createSimpleExperiment((String)DEFAULT_GATEWAY, (String)projectId, (String)"admin", (String)"sshEchoExperiment", (String)"SimpleEchoBR", (String)amberAppId, (List)exInputs);
            simpleExperiment.setExperimentOutputs(exOut);
            Map computeResources = airavataClient.getAvailableAppInterfaceComputeResources(new AuthzToken(""), amberAppId);
            if (computeResources != null && computeResources.size() != 0) {
                for (String id : computeResources.keySet()) {
                    String resourceName = (String)computeResources.get(id);
                    if (!resourceName.equals(br2HostName)) continue;
                    ComputationalResourceSchedulingModel scheduling = ExperimentModelUtil.createComputationResourceScheduling((String)id, (int)4, (int)1, (int)1, (String)"cpu", (int)20, (int)1);
                    UserConfigurationDataModel userConfigurationData = new UserConfigurationDataModel();
                    userConfigurationData.setAiravataAutoSchedule(false);
                    userConfigurationData.setOverrideManualScheduledParams(false);
                    userConfigurationData.setComputationalResourceScheduling(scheduling);
                    simpleExperiment.setUserConfigurationData(userConfigurationData);
                    return client.createExperiment(new AuthzToken(""), DEFAULT_GATEWAY, simpleExperiment);
                }
            }
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
        return null;
    }

    public static String createExperimentForStampedeAmber(Airavata.Client client) throws TException {
        try {
            List exInputs = client.getApplicationInputs(new AuthzToken(""), amberAppId);
            for (InputDataObjectType inputDataObjectType : exInputs) {
                if (inputDataObjectType.getName().equalsIgnoreCase("Heat_Restart_File")) {
                    inputDataObjectType.setValue("file://ogce@stampede.xsede.org:/scratch/01437/ogce/gta-work-dirs/PROCESS_e0610a6c-5778-4a69-a004-f440e29194af/02_Heat.rst");
                    continue;
                }
                if (inputDataObjectType.getName().equalsIgnoreCase("Production_Control_File")) {
                    inputDataObjectType.setValue("file://ogce@stampede.xsede.org:/scratch/01437/ogce/gta-work-dirs/PROCESS_e0610a6c-5778-4a69-a004-f440e29194af/03_Prod.in");
                    continue;
                }
                if (!inputDataObjectType.getName().equalsIgnoreCase("Parameter_Topology_File")) continue;
                inputDataObjectType.setValue("file://ogce@stampede.xsede.org:/scratch/01437/ogce/gta-work-dirs/PROCESS_e0610a6c-5778-4a69-a004-f440e29194af/prmtop");
            }
            List exOut = client.getApplicationOutputs(new AuthzToken(""), amberAppId);
            Project project = ProjectModelUtil.createProject((String)DEFAULT_GATEWAY, (String)"admin", (String)"test project");
            String projectId = client.createProject(new AuthzToken(""), DEFAULT_GATEWAY, project);
            ExperimentModel simpleExperiment = ExperimentModelUtil.createSimpleExperiment((String)DEFAULT_GATEWAY, (String)projectId, (String)"admin", (String)"sshEchoExperiment", (String)"SimpleEchoBR", (String)amberAppId, (List)exInputs);
            simpleExperiment.setExperimentOutputs(exOut);
            Map computeResources = airavataClient.getAvailableAppInterfaceComputeResources(new AuthzToken(""), amberAppId);
            if (computeResources != null && computeResources.size() != 0) {
                for (String id : computeResources.keySet()) {
                    String resourceName = (String)computeResources.get(id);
                    if (!resourceName.equals(stampedeHostName)) continue;
                    ComputationalResourceSchedulingModel scheduling = ExperimentModelUtil.createComputationResourceScheduling((String)id, (int)4, (int)1, (int)1, (String)"normal", (int)20, (int)1);
                    UserConfigurationDataModel userConfigurationData = new UserConfigurationDataModel();
                    userConfigurationData.setAiravataAutoSchedule(false);
                    userConfigurationData.setOverrideManualScheduledParams(false);
                    userConfigurationData.setComputationalResourceScheduling(scheduling);
                    simpleExperiment.setUserConfigurationData(userConfigurationData);
                    return client.createExperiment(new AuthzToken(""), DEFAULT_GATEWAY, simpleExperiment);
                }
            }
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
        return null;
    }

    public static String createExperimentForTrestlesAmber(Airavata.Client client) throws TException {
        try {
            List exInputs = client.getApplicationInputs(new AuthzToken(""), amberAppId);
            for (InputDataObjectType inputDataObjectType : exInputs) {
                if (inputDataObjectType.getName().equalsIgnoreCase("Heat_Restart_File")) {
                    inputDataObjectType.setValue("/Users/chathuri/dev/airavata/source/php/inputs/AMBER_FILES/02_Heat.rst");
                    continue;
                }
                if (inputDataObjectType.getName().equalsIgnoreCase("Production_Control_File")) {
                    inputDataObjectType.setValue("/Users/chathuri/dev/airavata/source/php/inputs/AMBER_FILES/03_Prod.in");
                    continue;
                }
                if (!inputDataObjectType.getName().equalsIgnoreCase("Parameter_Topology_File")) continue;
                inputDataObjectType.setValue("/Users/chathuri/dev/airavata/source/php/inputs/AMBER_FILES/prmtop");
            }
            List exOut = client.getApplicationOutputs(new AuthzToken(""), amberAppId);
            Project project = ProjectModelUtil.createProject((String)DEFAULT_GATEWAY, (String)"admin", (String)"test project");
            String projectId = client.createProject(new AuthzToken(""), DEFAULT_GATEWAY, project);
            ExperimentModel simpleExperiment = ExperimentModelUtil.createSimpleExperiment((String)DEFAULT_GATEWAY, (String)projectId, (String)"admin", (String)"sshEchoExperiment", (String)"SimpleEchoBR", (String)amberAppId, (List)exInputs);
            simpleExperiment.setExperimentOutputs(exOut);
            simpleExperiment.setEnableEmailNotification(true);
            Map computeResources = airavataClient.getAvailableAppInterfaceComputeResources(new AuthzToken(""), amberAppId);
            if (computeResources != null && computeResources.size() != 0) {
                for (String id : computeResources.keySet()) {
                    String resourceName = (String)computeResources.get(id);
                    if (!resourceName.equals(trestlesHostName)) continue;
                    ComputationalResourceSchedulingModel scheduling = ExperimentModelUtil.createComputationResourceScheduling((String)id, (int)4, (int)1, (int)1, (String)"normal", (int)20, (int)1);
                    UserConfigurationDataModel userConfigurationData = new UserConfigurationDataModel();
                    userConfigurationData.setAiravataAutoSchedule(false);
                    userConfigurationData.setOverrideManualScheduledParams(false);
                    userConfigurationData.setComputationalResourceScheduling(scheduling);
                    simpleExperiment.setUserConfigurationData(userConfigurationData);
                    return client.createExperiment(new AuthzToken(""), DEFAULT_GATEWAY, simpleExperiment);
                }
            }
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while creating the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
        return null;
    }

    public static void launchExperiment(Airavata.Client client, String expId) throws TException {
        try {
            client.launchExperiment(new AuthzToken(""), expId, DEFAULT_GATEWAY);
        }
        catch (ExperimentNotFoundException e) {
            logger.error("Error occured while launching the experiment...", (Object)e.getMessage());
            throw new ExperimentNotFoundException(e);
        }
        catch (AiravataSystemException e) {
            logger.error("Error occured while launching the experiment...", (Object)e.getMessage());
            throw new AiravataSystemException(e);
        }
        catch (InvalidRequestException e) {
            logger.error("Error occured while launching the experiment...", (Object)e.getMessage());
            throw new InvalidRequestException(e);
        }
        catch (AiravataClientException e) {
            logger.error("Error occured while launching the experiment...", (Object)e.getMessage());
            throw new AiravataClientException(e);
        }
        catch (TException e) {
            logger.error("Error occured while launching the experiment...", (Object)e.getMessage());
            throw new TException((Throwable)e);
        }
    }

    public static List<ExperimentModel> getExperimentsForUser(Airavata.Client client, String user) {
        try {
            return client.getUserExperiments(new AuthzToken(""), DEFAULT_GATEWAY, user, -1, 0);
        }
        catch (AiravataSystemException e) {
            e.printStackTrace();
        }
        catch (InvalidRequestException e) {
            e.printStackTrace();
        }
        catch (AiravataClientException e) {
            e.printStackTrace();
        }
        catch (TException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static List<Project> getAllUserProject(Airavata.Client client, String user) {
        try {
            return client.getUserProjects(new AuthzToken(""), DEFAULT_GATEWAY, user, -1, 0);
        }
        catch (AiravataSystemException e) {
            e.printStackTrace();
        }
        catch (InvalidRequestException e) {
            e.printStackTrace();
        }
        catch (AiravataClientException e) {
            e.printStackTrace();
        }
        catch (TException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void getExperiment(Airavata.Client client, String expId) throws Exception {
        try {
            ExperimentModel experiment = client.getExperiment(new AuthzToken(""), expId);
            List errors = experiment.getErrors();
            if (errors != null && !errors.isEmpty()) {
                for (ErrorModel error : errors) {
                    System.out.println("ERROR MESSAGE : " + error.getActualErrorMessage());
                }
            }
        }
        catch (ExperimentNotFoundException e) {
            logger.error("Experiment does not exist", (Throwable)e);
            throw new ExperimentNotFoundException("Experiment does not exist");
        }
        catch (AiravataSystemException e) {
            logger.error("Error while retrieving experiment", (Throwable)e);
            throw new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
        }
        catch (InvalidRequestException e) {
            logger.error("Error while retrieving experiment", (Throwable)e);
            throw new InvalidRequestException("Error while retrieving experiment");
        }
        catch (AiravataClientException e) {
            logger.error("Error while retrieving experiment", (Throwable)e);
            throw new AiravataClientException(AiravataErrorType.INTERNAL_ERROR);
        }
    }

    static {
        echoAppId = "Python_Echo_069ea651-4937-4b89-9684-fb0682ac52f5";
        mpiAppId = "HelloMPI_71b6f45e-40c2-46e9-a417-160b2640fcb9";
        wrfAppId = "WRF_7ad5da38-c08b-417c-a9ea-da9298839762";
        amberAppId = "Amber_74ad818e-7633-476a-b861-952de9b0a529";
        gromacsAppId = "GROMACS_05622038-9edd-4cb1-824e-0b7cb993364b";
        espressoAppId = "ESPRESSO_10cc2820-5d0b-4c63-9546-8a8b595593c1";
        lammpsAppId = "LAMMPS_2472685b-8acf-497e-aafe-cc66fe5f4cb6";
        nwchemAppId = "NWChem_2c8fee64-acf9-4a89-b6d3-91eb53c7640c";
        trinityAppId = "Trinity_e894acf5-9bca-46e8-a1bd-7e2d5155191a";
        autodockAppId = "AutoDock_43d9fdd0-c404-49f4-b913-3abf9080a8c9";
        localHost = "localhost";
        trestlesHostName = "trestles.sdsc.xsede.org";
        unicoreHostName = "fsd-cloud15.zam.kfa-juelich.de";
        stampedeHostName = "stampede.tacc.xsede.org";
        br2HostName = "bigred2.uits.iu.edu";
        umassrcHostName = "ghpcc06.umassrc.org";
    }
}

