/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.credential.store.util;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.KeyPair;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.airavata.credential.store.credential.impl.ssh.SSHCredential;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utility {
    protected static Logger log = LoggerFactory.getLogger(Utility.class);
    private static final String DATE_FORMAT = "MM/dd/yyyy HH:mm:ss";

    public static String convertDateToString(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        return df.format(date);
    }

    public static Date convertStringToDate(String date) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        return df.parse(date);
    }

    public static String encrypt(String stringToEncrypt) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadKeyStore(String keyStoreFile) throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        char[] password = Utility.getPassword();
        try (FileInputStream fis = null;){
            fis = new FileInputStream(keyStoreFile);
            ks.load(fis, password);
            KeyStore keyStore = ks;
            return keyStore;
        }
    }

    public static char[] getPassword() {
        return new char[0];
    }

    public static SSHCredential generateKeyPair(SSHCredential credential) throws Exception {
        JSch jsch = new JSch();
        try {
            KeyPair kpair = KeyPair.genKeyPair((JSch)jsch, (int)2, (int)2048);
            File file = File.createTempFile("id_rsa", "");
            String fileName = file.getAbsolutePath();
            kpair.writePrivateKey(fileName, credential.getPassphrase().getBytes());
            kpair.writePublicKey(fileName + ".pub", "");
            kpair.dispose();
            byte[] priKey = FileUtils.readFileToByteArray((File)new File(fileName));
            byte[] pubKey = FileUtils.readFileToByteArray((File)new File(fileName + ".pub"));
            credential.setPrivateKey(priKey);
            credential.setPublicKey(pubKey);
            return credential;
        }
        catch (Exception e) {
            log.error("Error while creating key pair", (Throwable)e);
            throw new Exception("Error while creating key pair", e);
        }
    }
}

