/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.model.data.replica;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.airavata.model.data.replica.DataProductType;
import org.apache.airavata.model.data.replica.DataReplicaLocationModel;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class DataProductModel
implements TBase<DataProductModel, _Fields>,
Serializable,
Cloneable,
Comparable<DataProductModel> {
    private static final TStruct STRUCT_DESC = new TStruct("DataProductModel");
    private static final TField PRODUCT_URI_FIELD_DESC = new TField("productUri", 11, 1);
    private static final TField GATEWAY_ID_FIELD_DESC = new TField("gatewayId", 11, 2);
    private static final TField PARENT_PRODUCT_URI_FIELD_DESC = new TField("parentProductUri", 11, 3);
    private static final TField PRODUCT_NAME_FIELD_DESC = new TField("productName", 11, 4);
    private static final TField PRODUCT_DESCRIPTION_FIELD_DESC = new TField("productDescription", 11, 5);
    private static final TField OWNER_NAME_FIELD_DESC = new TField("ownerName", 11, 6);
    private static final TField DATA_PRODUCT_TYPE_FIELD_DESC = new TField("dataProductType", 8, 7);
    private static final TField PRODUCT_SIZE_FIELD_DESC = new TField("productSize", 8, 8);
    private static final TField CREATION_TIME_FIELD_DESC = new TField("creationTime", 10, 9);
    private static final TField LAST_MODIFIED_TIME_FIELD_DESC = new TField("lastModifiedTime", 10, 10);
    private static final TField PRODUCT_METADATA_FIELD_DESC = new TField("productMetadata", 13, 11);
    private static final TField REPLICA_LOCATIONS_FIELD_DESC = new TField("replicaLocations", 15, 12);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    private String productUri;
    private String gatewayId;
    private String parentProductUri;
    private String productName;
    private String productDescription;
    private String ownerName;
    private DataProductType dataProductType;
    private int productSize;
    private long creationTime;
    private long lastModifiedTime;
    private Map<String, String> productMetadata;
    private List<DataReplicaLocationModel> replicaLocations;
    private static final int __PRODUCTSIZE_ISSET_ID = 0;
    private static final int __CREATIONTIME_ISSET_ID = 1;
    private static final int __LASTMODIFIEDTIME_ISSET_ID = 2;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public DataProductModel() {
    }

    public DataProductModel(DataProductModel other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetProductUri()) {
            this.productUri = other.productUri;
        }
        if (other.isSetGatewayId()) {
            this.gatewayId = other.gatewayId;
        }
        if (other.isSetParentProductUri()) {
            this.parentProductUri = other.parentProductUri;
        }
        if (other.isSetProductName()) {
            this.productName = other.productName;
        }
        if (other.isSetProductDescription()) {
            this.productDescription = other.productDescription;
        }
        if (other.isSetOwnerName()) {
            this.ownerName = other.ownerName;
        }
        if (other.isSetDataProductType()) {
            this.dataProductType = other.dataProductType;
        }
        this.productSize = other.productSize;
        this.creationTime = other.creationTime;
        this.lastModifiedTime = other.lastModifiedTime;
        if (other.isSetProductMetadata()) {
            HashMap<String, String> __this__productMetadata = new HashMap<String, String>(other.productMetadata);
            this.productMetadata = __this__productMetadata;
        }
        if (other.isSetReplicaLocations()) {
            ArrayList<DataReplicaLocationModel> __this__replicaLocations = new ArrayList<DataReplicaLocationModel>(other.replicaLocations.size());
            for (DataReplicaLocationModel other_element : other.replicaLocations) {
                __this__replicaLocations.add(new DataReplicaLocationModel(other_element));
            }
            this.replicaLocations = __this__replicaLocations;
        }
    }

    public DataProductModel deepCopy() {
        return new DataProductModel(this);
    }

    public void clear() {
        this.productUri = null;
        this.gatewayId = null;
        this.parentProductUri = null;
        this.productName = null;
        this.productDescription = null;
        this.ownerName = null;
        this.dataProductType = null;
        this.setProductSizeIsSet(false);
        this.productSize = 0;
        this.setCreationTimeIsSet(false);
        this.creationTime = 0L;
        this.setLastModifiedTimeIsSet(false);
        this.lastModifiedTime = 0L;
        this.productMetadata = null;
        this.replicaLocations = null;
    }

    public String getProductUri() {
        return this.productUri;
    }

    public void setProductUri(String productUri) {
        this.productUri = productUri;
    }

    public void unsetProductUri() {
        this.productUri = null;
    }

    public boolean isSetProductUri() {
        return this.productUri != null;
    }

    public void setProductUriIsSet(boolean value) {
        if (!value) {
            this.productUri = null;
        }
    }

    public String getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    public void unsetGatewayId() {
        this.gatewayId = null;
    }

    public boolean isSetGatewayId() {
        return this.gatewayId != null;
    }

    public void setGatewayIdIsSet(boolean value) {
        if (!value) {
            this.gatewayId = null;
        }
    }

    public String getParentProductUri() {
        return this.parentProductUri;
    }

    public void setParentProductUri(String parentProductUri) {
        this.parentProductUri = parentProductUri;
    }

    public void unsetParentProductUri() {
        this.parentProductUri = null;
    }

    public boolean isSetParentProductUri() {
        return this.parentProductUri != null;
    }

    public void setParentProductUriIsSet(boolean value) {
        if (!value) {
            this.parentProductUri = null;
        }
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public void unsetProductName() {
        this.productName = null;
    }

    public boolean isSetProductName() {
        return this.productName != null;
    }

    public void setProductNameIsSet(boolean value) {
        if (!value) {
            this.productName = null;
        }
    }

    public String getProductDescription() {
        return this.productDescription;
    }

    public void setProductDescription(String productDescription) {
        this.productDescription = productDescription;
    }

    public void unsetProductDescription() {
        this.productDescription = null;
    }

    public boolean isSetProductDescription() {
        return this.productDescription != null;
    }

    public void setProductDescriptionIsSet(boolean value) {
        if (!value) {
            this.productDescription = null;
        }
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public void unsetOwnerName() {
        this.ownerName = null;
    }

    public boolean isSetOwnerName() {
        return this.ownerName != null;
    }

    public void setOwnerNameIsSet(boolean value) {
        if (!value) {
            this.ownerName = null;
        }
    }

    public DataProductType getDataProductType() {
        return this.dataProductType;
    }

    public void setDataProductType(DataProductType dataProductType) {
        this.dataProductType = dataProductType;
    }

    public void unsetDataProductType() {
        this.dataProductType = null;
    }

    public boolean isSetDataProductType() {
        return this.dataProductType != null;
    }

    public void setDataProductTypeIsSet(boolean value) {
        if (!value) {
            this.dataProductType = null;
        }
    }

    public int getProductSize() {
        return this.productSize;
    }

    public void setProductSize(int productSize) {
        this.productSize = productSize;
        this.setProductSizeIsSet(true);
    }

    public void unsetProductSize() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetProductSize() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setProductSizeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
        this.setCreationTimeIsSet(true);
    }

    public void unsetCreationTime() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetCreationTime() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setCreationTimeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
        this.setLastModifiedTimeIsSet(true);
    }

    public void unsetLastModifiedTime() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetLastModifiedTime() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setLastModifiedTimeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public int getProductMetadataSize() {
        return this.productMetadata == null ? 0 : this.productMetadata.size();
    }

    public void putToProductMetadata(String key, String val) {
        if (this.productMetadata == null) {
            this.productMetadata = new HashMap<String, String>();
        }
        this.productMetadata.put(key, val);
    }

    public Map<String, String> getProductMetadata() {
        return this.productMetadata;
    }

    public void setProductMetadata(Map<String, String> productMetadata) {
        this.productMetadata = productMetadata;
    }

    public void unsetProductMetadata() {
        this.productMetadata = null;
    }

    public boolean isSetProductMetadata() {
        return this.productMetadata != null;
    }

    public void setProductMetadataIsSet(boolean value) {
        if (!value) {
            this.productMetadata = null;
        }
    }

    public int getReplicaLocationsSize() {
        return this.replicaLocations == null ? 0 : this.replicaLocations.size();
    }

    public Iterator<DataReplicaLocationModel> getReplicaLocationsIterator() {
        return this.replicaLocations == null ? null : this.replicaLocations.iterator();
    }

    public void addToReplicaLocations(DataReplicaLocationModel elem) {
        if (this.replicaLocations == null) {
            this.replicaLocations = new ArrayList<DataReplicaLocationModel>();
        }
        this.replicaLocations.add(elem);
    }

    public List<DataReplicaLocationModel> getReplicaLocations() {
        return this.replicaLocations;
    }

    public void setReplicaLocations(List<DataReplicaLocationModel> replicaLocations) {
        this.replicaLocations = replicaLocations;
    }

    public void unsetReplicaLocations() {
        this.replicaLocations = null;
    }

    public boolean isSetReplicaLocations() {
        return this.replicaLocations != null;
    }

    public void setReplicaLocationsIsSet(boolean value) {
        if (!value) {
            this.replicaLocations = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case PRODUCT_URI: {
                if (value == null) {
                    this.unsetProductUri();
                    break;
                }
                this.setProductUri((String)value);
                break;
            }
            case GATEWAY_ID: {
                if (value == null) {
                    this.unsetGatewayId();
                    break;
                }
                this.setGatewayId((String)value);
                break;
            }
            case PARENT_PRODUCT_URI: {
                if (value == null) {
                    this.unsetParentProductUri();
                    break;
                }
                this.setParentProductUri((String)value);
                break;
            }
            case PRODUCT_NAME: {
                if (value == null) {
                    this.unsetProductName();
                    break;
                }
                this.setProductName((String)value);
                break;
            }
            case PRODUCT_DESCRIPTION: {
                if (value == null) {
                    this.unsetProductDescription();
                    break;
                }
                this.setProductDescription((String)value);
                break;
            }
            case OWNER_NAME: {
                if (value == null) {
                    this.unsetOwnerName();
                    break;
                }
                this.setOwnerName((String)value);
                break;
            }
            case DATA_PRODUCT_TYPE: {
                if (value == null) {
                    this.unsetDataProductType();
                    break;
                }
                this.setDataProductType((DataProductType)((Object)value));
                break;
            }
            case PRODUCT_SIZE: {
                if (value == null) {
                    this.unsetProductSize();
                    break;
                }
                this.setProductSize((Integer)value);
                break;
            }
            case CREATION_TIME: {
                if (value == null) {
                    this.unsetCreationTime();
                    break;
                }
                this.setCreationTime((Long)value);
                break;
            }
            case LAST_MODIFIED_TIME: {
                if (value == null) {
                    this.unsetLastModifiedTime();
                    break;
                }
                this.setLastModifiedTime((Long)value);
                break;
            }
            case PRODUCT_METADATA: {
                if (value == null) {
                    this.unsetProductMetadata();
                    break;
                }
                this.setProductMetadata((Map)value);
                break;
            }
            case REPLICA_LOCATIONS: {
                if (value == null) {
                    this.unsetReplicaLocations();
                    break;
                }
                this.setReplicaLocations((List)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case PRODUCT_URI: {
                return this.getProductUri();
            }
            case GATEWAY_ID: {
                return this.getGatewayId();
            }
            case PARENT_PRODUCT_URI: {
                return this.getParentProductUri();
            }
            case PRODUCT_NAME: {
                return this.getProductName();
            }
            case PRODUCT_DESCRIPTION: {
                return this.getProductDescription();
            }
            case OWNER_NAME: {
                return this.getOwnerName();
            }
            case DATA_PRODUCT_TYPE: {
                return this.getDataProductType();
            }
            case PRODUCT_SIZE: {
                return this.getProductSize();
            }
            case CREATION_TIME: {
                return this.getCreationTime();
            }
            case LAST_MODIFIED_TIME: {
                return this.getLastModifiedTime();
            }
            case PRODUCT_METADATA: {
                return this.getProductMetadata();
            }
            case REPLICA_LOCATIONS: {
                return this.getReplicaLocations();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case PRODUCT_URI: {
                return this.isSetProductUri();
            }
            case GATEWAY_ID: {
                return this.isSetGatewayId();
            }
            case PARENT_PRODUCT_URI: {
                return this.isSetParentProductUri();
            }
            case PRODUCT_NAME: {
                return this.isSetProductName();
            }
            case PRODUCT_DESCRIPTION: {
                return this.isSetProductDescription();
            }
            case OWNER_NAME: {
                return this.isSetOwnerName();
            }
            case DATA_PRODUCT_TYPE: {
                return this.isSetDataProductType();
            }
            case PRODUCT_SIZE: {
                return this.isSetProductSize();
            }
            case CREATION_TIME: {
                return this.isSetCreationTime();
            }
            case LAST_MODIFIED_TIME: {
                return this.isSetLastModifiedTime();
            }
            case PRODUCT_METADATA: {
                return this.isSetProductMetadata();
            }
            case REPLICA_LOCATIONS: {
                return this.isSetReplicaLocations();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof DataProductModel) {
            return this.equals((DataProductModel)that);
        }
        return false;
    }

    public boolean equals(DataProductModel that) {
        if (that == null) {
            return false;
        }
        boolean this_present_productUri = this.isSetProductUri();
        boolean that_present_productUri = that.isSetProductUri();
        if (this_present_productUri || that_present_productUri) {
            if (!this_present_productUri || !that_present_productUri) {
                return false;
            }
            if (!this.productUri.equals(that.productUri)) {
                return false;
            }
        }
        boolean this_present_gatewayId = this.isSetGatewayId();
        boolean that_present_gatewayId = that.isSetGatewayId();
        if (this_present_gatewayId || that_present_gatewayId) {
            if (!this_present_gatewayId || !that_present_gatewayId) {
                return false;
            }
            if (!this.gatewayId.equals(that.gatewayId)) {
                return false;
            }
        }
        boolean this_present_parentProductUri = this.isSetParentProductUri();
        boolean that_present_parentProductUri = that.isSetParentProductUri();
        if (this_present_parentProductUri || that_present_parentProductUri) {
            if (!this_present_parentProductUri || !that_present_parentProductUri) {
                return false;
            }
            if (!this.parentProductUri.equals(that.parentProductUri)) {
                return false;
            }
        }
        boolean this_present_productName = this.isSetProductName();
        boolean that_present_productName = that.isSetProductName();
        if (this_present_productName || that_present_productName) {
            if (!this_present_productName || !that_present_productName) {
                return false;
            }
            if (!this.productName.equals(that.productName)) {
                return false;
            }
        }
        boolean this_present_productDescription = this.isSetProductDescription();
        boolean that_present_productDescription = that.isSetProductDescription();
        if (this_present_productDescription || that_present_productDescription) {
            if (!this_present_productDescription || !that_present_productDescription) {
                return false;
            }
            if (!this.productDescription.equals(that.productDescription)) {
                return false;
            }
        }
        boolean this_present_ownerName = this.isSetOwnerName();
        boolean that_present_ownerName = that.isSetOwnerName();
        if (this_present_ownerName || that_present_ownerName) {
            if (!this_present_ownerName || !that_present_ownerName) {
                return false;
            }
            if (!this.ownerName.equals(that.ownerName)) {
                return false;
            }
        }
        boolean this_present_dataProductType = this.isSetDataProductType();
        boolean that_present_dataProductType = that.isSetDataProductType();
        if (this_present_dataProductType || that_present_dataProductType) {
            if (!this_present_dataProductType || !that_present_dataProductType) {
                return false;
            }
            if (!this.dataProductType.equals((Object)that.dataProductType)) {
                return false;
            }
        }
        boolean this_present_productSize = this.isSetProductSize();
        boolean that_present_productSize = that.isSetProductSize();
        if (this_present_productSize || that_present_productSize) {
            if (!this_present_productSize || !that_present_productSize) {
                return false;
            }
            if (this.productSize != that.productSize) {
                return false;
            }
        }
        boolean this_present_creationTime = this.isSetCreationTime();
        boolean that_present_creationTime = that.isSetCreationTime();
        if (this_present_creationTime || that_present_creationTime) {
            if (!this_present_creationTime || !that_present_creationTime) {
                return false;
            }
            if (this.creationTime != that.creationTime) {
                return false;
            }
        }
        boolean this_present_lastModifiedTime = this.isSetLastModifiedTime();
        boolean that_present_lastModifiedTime = that.isSetLastModifiedTime();
        if (this_present_lastModifiedTime || that_present_lastModifiedTime) {
            if (!this_present_lastModifiedTime || !that_present_lastModifiedTime) {
                return false;
            }
            if (this.lastModifiedTime != that.lastModifiedTime) {
                return false;
            }
        }
        boolean this_present_productMetadata = this.isSetProductMetadata();
        boolean that_present_productMetadata = that.isSetProductMetadata();
        if (this_present_productMetadata || that_present_productMetadata) {
            if (!this_present_productMetadata || !that_present_productMetadata) {
                return false;
            }
            if (!this.productMetadata.equals(that.productMetadata)) {
                return false;
            }
        }
        boolean this_present_replicaLocations = this.isSetReplicaLocations();
        boolean that_present_replicaLocations = that.isSetReplicaLocations();
        if (this_present_replicaLocations || that_present_replicaLocations) {
            if (!this_present_replicaLocations || !that_present_replicaLocations) {
                return false;
            }
            if (!this.replicaLocations.equals(that.replicaLocations)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_productUri = this.isSetProductUri();
        list.add(present_productUri);
        if (present_productUri) {
            list.add(this.productUri);
        }
        boolean present_gatewayId = this.isSetGatewayId();
        list.add(present_gatewayId);
        if (present_gatewayId) {
            list.add(this.gatewayId);
        }
        boolean present_parentProductUri = this.isSetParentProductUri();
        list.add(present_parentProductUri);
        if (present_parentProductUri) {
            list.add(this.parentProductUri);
        }
        boolean present_productName = this.isSetProductName();
        list.add(present_productName);
        if (present_productName) {
            list.add(this.productName);
        }
        boolean present_productDescription = this.isSetProductDescription();
        list.add(present_productDescription);
        if (present_productDescription) {
            list.add(this.productDescription);
        }
        boolean present_ownerName = this.isSetOwnerName();
        list.add(present_ownerName);
        if (present_ownerName) {
            list.add(this.ownerName);
        }
        boolean present_dataProductType = this.isSetDataProductType();
        list.add(present_dataProductType);
        if (present_dataProductType) {
            list.add(this.dataProductType.getValue());
        }
        boolean present_productSize = this.isSetProductSize();
        list.add(present_productSize);
        if (present_productSize) {
            list.add(this.productSize);
        }
        boolean present_creationTime = this.isSetCreationTime();
        list.add(present_creationTime);
        if (present_creationTime) {
            list.add(this.creationTime);
        }
        boolean present_lastModifiedTime = this.isSetLastModifiedTime();
        list.add(present_lastModifiedTime);
        if (present_lastModifiedTime) {
            list.add(this.lastModifiedTime);
        }
        boolean present_productMetadata = this.isSetProductMetadata();
        list.add(present_productMetadata);
        if (present_productMetadata) {
            list.add(this.productMetadata);
        }
        boolean present_replicaLocations = this.isSetReplicaLocations();
        list.add(present_replicaLocations);
        if (present_replicaLocations) {
            list.add(this.replicaLocations);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(DataProductModel other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetProductUri()).compareTo(other.isSetProductUri());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProductUri() && (lastComparison = TBaseHelper.compareTo((String)this.productUri, (String)other.productUri)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetGatewayId()).compareTo(other.isSetGatewayId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetGatewayId() && (lastComparison = TBaseHelper.compareTo((String)this.gatewayId, (String)other.gatewayId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetParentProductUri()).compareTo(other.isSetParentProductUri());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetParentProductUri() && (lastComparison = TBaseHelper.compareTo((String)this.parentProductUri, (String)other.parentProductUri)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetProductName()).compareTo(other.isSetProductName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProductName() && (lastComparison = TBaseHelper.compareTo((String)this.productName, (String)other.productName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetProductDescription()).compareTo(other.isSetProductDescription());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProductDescription() && (lastComparison = TBaseHelper.compareTo((String)this.productDescription, (String)other.productDescription)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetOwnerName()).compareTo(other.isSetOwnerName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOwnerName() && (lastComparison = TBaseHelper.compareTo((String)this.ownerName, (String)other.ownerName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDataProductType()).compareTo(other.isSetDataProductType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDataProductType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.dataProductType), (Comparable)((Object)other.dataProductType))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetProductSize()).compareTo(other.isSetProductSize());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProductSize() && (lastComparison = TBaseHelper.compareTo((int)this.productSize, (int)other.productSize)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCreationTime()).compareTo(other.isSetCreationTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCreationTime() && (lastComparison = TBaseHelper.compareTo((long)this.creationTime, (long)other.creationTime)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLastModifiedTime()).compareTo(other.isSetLastModifiedTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLastModifiedTime() && (lastComparison = TBaseHelper.compareTo((long)this.lastModifiedTime, (long)other.lastModifiedTime)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetProductMetadata()).compareTo(other.isSetProductMetadata());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProductMetadata() && (lastComparison = TBaseHelper.compareTo(this.productMetadata, other.productMetadata)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetReplicaLocations()).compareTo(other.isSetReplicaLocations());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetReplicaLocations() && (lastComparison = TBaseHelper.compareTo(this.replicaLocations, other.replicaLocations)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DataProductModel(");
        boolean first = true;
        if (this.isSetProductUri()) {
            sb.append("productUri:");
            if (this.productUri == null) {
                sb.append("null");
            } else {
                sb.append(this.productUri);
            }
            first = false;
        }
        if (this.isSetGatewayId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("gatewayId:");
            if (this.gatewayId == null) {
                sb.append("null");
            } else {
                sb.append(this.gatewayId);
            }
            first = false;
        }
        if (this.isSetParentProductUri()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("parentProductUri:");
            if (this.parentProductUri == null) {
                sb.append("null");
            } else {
                sb.append(this.parentProductUri);
            }
            first = false;
        }
        if (this.isSetProductName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("productName:");
            if (this.productName == null) {
                sb.append("null");
            } else {
                sb.append(this.productName);
            }
            first = false;
        }
        if (this.isSetProductDescription()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("productDescription:");
            if (this.productDescription == null) {
                sb.append("null");
            } else {
                sb.append(this.productDescription);
            }
            first = false;
        }
        if (this.isSetOwnerName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("ownerName:");
            if (this.ownerName == null) {
                sb.append("null");
            } else {
                sb.append(this.ownerName);
            }
            first = false;
        }
        if (this.isSetDataProductType()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("dataProductType:");
            if (this.dataProductType == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.dataProductType);
            }
            first = false;
        }
        if (this.isSetProductSize()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("productSize:");
            sb.append(this.productSize);
            first = false;
        }
        if (this.isSetCreationTime()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("creationTime:");
            sb.append(this.creationTime);
            first = false;
        }
        if (this.isSetLastModifiedTime()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("lastModifiedTime:");
            sb.append(this.lastModifiedTime);
            first = false;
        }
        if (this.isSetProductMetadata()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("productMetadata:");
            if (this.productMetadata == null) {
                sb.append("null");
            } else {
                sb.append(this.productMetadata);
            }
            first = false;
        }
        if (this.isSetReplicaLocations()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("replicaLocations:");
            if (this.replicaLocations == null) {
                sb.append("null");
            } else {
                sb.append(this.replicaLocations);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new DataProductModelStandardSchemeFactory());
        schemes.put(TupleScheme.class, new DataProductModelTupleSchemeFactory());
        optionals = new _Fields[]{_Fields.PRODUCT_URI, _Fields.GATEWAY_ID, _Fields.PARENT_PRODUCT_URI, _Fields.PRODUCT_NAME, _Fields.PRODUCT_DESCRIPTION, _Fields.OWNER_NAME, _Fields.DATA_PRODUCT_TYPE, _Fields.PRODUCT_SIZE, _Fields.CREATION_TIME, _Fields.LAST_MODIFIED_TIME, _Fields.PRODUCT_METADATA, _Fields.REPLICA_LOCATIONS};
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.PRODUCT_URI, new FieldMetaData("productUri", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.GATEWAY_ID, new FieldMetaData("gatewayId", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PARENT_PRODUCT_URI, new FieldMetaData("parentProductUri", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PRODUCT_NAME, new FieldMetaData("productName", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PRODUCT_DESCRIPTION, new FieldMetaData("productDescription", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.OWNER_NAME, new FieldMetaData("ownerName", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.DATA_PRODUCT_TYPE, new FieldMetaData("dataProductType", 2, (FieldValueMetaData)new EnumMetaData(16, DataProductType.class)));
        tmpMap.put(_Fields.PRODUCT_SIZE, new FieldMetaData("productSize", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.CREATION_TIME, new FieldMetaData("creationTime", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.LAST_MODIFIED_TIME, new FieldMetaData("lastModifiedTime", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.PRODUCT_METADATA, new FieldMetaData("productMetadata", 2, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        tmpMap.put(_Fields.REPLICA_LOCATIONS, new FieldMetaData("replicaLocations", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, DataReplicaLocationModel.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(DataProductModel.class, metaDataMap);
    }

    private static class DataProductModelTupleScheme
    extends TupleScheme<DataProductModel> {
        private DataProductModelTupleScheme() {
        }

        public void write(TProtocol prot, DataProductModel struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetProductUri()) {
                optionals.set(0);
            }
            if (struct.isSetGatewayId()) {
                optionals.set(1);
            }
            if (struct.isSetParentProductUri()) {
                optionals.set(2);
            }
            if (struct.isSetProductName()) {
                optionals.set(3);
            }
            if (struct.isSetProductDescription()) {
                optionals.set(4);
            }
            if (struct.isSetOwnerName()) {
                optionals.set(5);
            }
            if (struct.isSetDataProductType()) {
                optionals.set(6);
            }
            if (struct.isSetProductSize()) {
                optionals.set(7);
            }
            if (struct.isSetCreationTime()) {
                optionals.set(8);
            }
            if (struct.isSetLastModifiedTime()) {
                optionals.set(9);
            }
            if (struct.isSetProductMetadata()) {
                optionals.set(10);
            }
            if (struct.isSetReplicaLocations()) {
                optionals.set(11);
            }
            oprot.writeBitSet(optionals, 12);
            if (struct.isSetProductUri()) {
                oprot.writeString(struct.productUri);
            }
            if (struct.isSetGatewayId()) {
                oprot.writeString(struct.gatewayId);
            }
            if (struct.isSetParentProductUri()) {
                oprot.writeString(struct.parentProductUri);
            }
            if (struct.isSetProductName()) {
                oprot.writeString(struct.productName);
            }
            if (struct.isSetProductDescription()) {
                oprot.writeString(struct.productDescription);
            }
            if (struct.isSetOwnerName()) {
                oprot.writeString(struct.ownerName);
            }
            if (struct.isSetDataProductType()) {
                oprot.writeI32(struct.dataProductType.getValue());
            }
            if (struct.isSetProductSize()) {
                oprot.writeI32(struct.productSize);
            }
            if (struct.isSetCreationTime()) {
                oprot.writeI64(struct.creationTime);
            }
            if (struct.isSetLastModifiedTime()) {
                oprot.writeI64(struct.lastModifiedTime);
            }
            if (struct.isSetProductMetadata()) {
                oprot.writeI32(struct.productMetadata.size());
                for (Map.Entry _iter19 : struct.productMetadata.entrySet()) {
                    oprot.writeString((String)_iter19.getKey());
                    oprot.writeString((String)_iter19.getValue());
                }
            }
            if (struct.isSetReplicaLocations()) {
                oprot.writeI32(struct.replicaLocations.size());
                for (DataReplicaLocationModel _iter20 : struct.replicaLocations) {
                    _iter20.write((TProtocol)oprot);
                }
            }
        }

        public void read(TProtocol prot, DataProductModel struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(12);
            if (incoming.get(0)) {
                struct.productUri = iprot.readString();
                struct.setProductUriIsSet(true);
            }
            if (incoming.get(1)) {
                struct.gatewayId = iprot.readString();
                struct.setGatewayIdIsSet(true);
            }
            if (incoming.get(2)) {
                struct.parentProductUri = iprot.readString();
                struct.setParentProductUriIsSet(true);
            }
            if (incoming.get(3)) {
                struct.productName = iprot.readString();
                struct.setProductNameIsSet(true);
            }
            if (incoming.get(4)) {
                struct.productDescription = iprot.readString();
                struct.setProductDescriptionIsSet(true);
            }
            if (incoming.get(5)) {
                struct.ownerName = iprot.readString();
                struct.setOwnerNameIsSet(true);
            }
            if (incoming.get(6)) {
                struct.dataProductType = DataProductType.findByValue(iprot.readI32());
                struct.setDataProductTypeIsSet(true);
            }
            if (incoming.get(7)) {
                struct.productSize = iprot.readI32();
                struct.setProductSizeIsSet(true);
            }
            if (incoming.get(8)) {
                struct.creationTime = iprot.readI64();
                struct.setCreationTimeIsSet(true);
            }
            if (incoming.get(9)) {
                struct.lastModifiedTime = iprot.readI64();
                struct.setLastModifiedTimeIsSet(true);
            }
            if (incoming.get(10)) {
                TMap _map21 = new TMap(11, 11, iprot.readI32());
                struct.productMetadata = new HashMap(2 * _map21.size);
                for (int _i24 = 0; _i24 < _map21.size; ++_i24) {
                    String _key22 = iprot.readString();
                    String _val23 = iprot.readString();
                    struct.productMetadata.put(_key22, _val23);
                }
                struct.setProductMetadataIsSet(true);
            }
            if (incoming.get(11)) {
                TList _list25 = new TList(12, iprot.readI32());
                struct.replicaLocations = new ArrayList(_list25.size);
                for (int _i27 = 0; _i27 < _list25.size; ++_i27) {
                    DataReplicaLocationModel _elem26 = new DataReplicaLocationModel();
                    _elem26.read((TProtocol)iprot);
                    struct.replicaLocations.add(_elem26);
                }
                struct.setReplicaLocationsIsSet(true);
            }
        }
    }

    private static class DataProductModelTupleSchemeFactory
    implements SchemeFactory {
        private DataProductModelTupleSchemeFactory() {
        }

        public DataProductModelTupleScheme getScheme() {
            return new DataProductModelTupleScheme();
        }
    }

    private static class DataProductModelStandardScheme
    extends StandardScheme<DataProductModel> {
        private DataProductModelStandardScheme() {
        }

        public void read(TProtocol iprot, DataProductModel struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.productUri = iprot.readString();
                            struct.setProductUriIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.gatewayId = iprot.readString();
                            struct.setGatewayIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.parentProductUri = iprot.readString();
                            struct.setParentProductUriIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 11) {
                            struct.productName = iprot.readString();
                            struct.setProductNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 11) {
                            struct.productDescription = iprot.readString();
                            struct.setProductDescriptionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 11) {
                            struct.ownerName = iprot.readString();
                            struct.setOwnerNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 8) {
                            struct.dataProductType = DataProductType.findByValue(iprot.readI32());
                            struct.setDataProductTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 8) {
                            struct.productSize = iprot.readI32();
                            struct.setProductSizeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 10) {
                            struct.creationTime = iprot.readI64();
                            struct.setCreationTimeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 10) {
                            struct.lastModifiedTime = iprot.readI64();
                            struct.setLastModifiedTimeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 13) {
                            TMap _map10 = iprot.readMapBegin();
                            struct.productMetadata = new HashMap(2 * _map10.size);
                            for (int _i13 = 0; _i13 < _map10.size; ++_i13) {
                                String _key11 = iprot.readString();
                                String _val12 = iprot.readString();
                                struct.productMetadata.put(_key11, _val12);
                            }
                            iprot.readMapEnd();
                            struct.setProductMetadataIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 15) {
                            TList _list14 = iprot.readListBegin();
                            struct.replicaLocations = new ArrayList(_list14.size);
                            for (int _i16 = 0; _i16 < _list14.size; ++_i16) {
                                DataReplicaLocationModel _elem15 = new DataReplicaLocationModel();
                                _elem15.read(iprot);
                                struct.replicaLocations.add(_elem15);
                            }
                            iprot.readListEnd();
                            struct.setReplicaLocationsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, DataProductModel struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.productUri != null && struct.isSetProductUri()) {
                oprot.writeFieldBegin(PRODUCT_URI_FIELD_DESC);
                oprot.writeString(struct.productUri);
                oprot.writeFieldEnd();
            }
            if (struct.gatewayId != null && struct.isSetGatewayId()) {
                oprot.writeFieldBegin(GATEWAY_ID_FIELD_DESC);
                oprot.writeString(struct.gatewayId);
                oprot.writeFieldEnd();
            }
            if (struct.parentProductUri != null && struct.isSetParentProductUri()) {
                oprot.writeFieldBegin(PARENT_PRODUCT_URI_FIELD_DESC);
                oprot.writeString(struct.parentProductUri);
                oprot.writeFieldEnd();
            }
            if (struct.productName != null && struct.isSetProductName()) {
                oprot.writeFieldBegin(PRODUCT_NAME_FIELD_DESC);
                oprot.writeString(struct.productName);
                oprot.writeFieldEnd();
            }
            if (struct.productDescription != null && struct.isSetProductDescription()) {
                oprot.writeFieldBegin(PRODUCT_DESCRIPTION_FIELD_DESC);
                oprot.writeString(struct.productDescription);
                oprot.writeFieldEnd();
            }
            if (struct.ownerName != null && struct.isSetOwnerName()) {
                oprot.writeFieldBegin(OWNER_NAME_FIELD_DESC);
                oprot.writeString(struct.ownerName);
                oprot.writeFieldEnd();
            }
            if (struct.dataProductType != null && struct.isSetDataProductType()) {
                oprot.writeFieldBegin(DATA_PRODUCT_TYPE_FIELD_DESC);
                oprot.writeI32(struct.dataProductType.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.isSetProductSize()) {
                oprot.writeFieldBegin(PRODUCT_SIZE_FIELD_DESC);
                oprot.writeI32(struct.productSize);
                oprot.writeFieldEnd();
            }
            if (struct.isSetCreationTime()) {
                oprot.writeFieldBegin(CREATION_TIME_FIELD_DESC);
                oprot.writeI64(struct.creationTime);
                oprot.writeFieldEnd();
            }
            if (struct.isSetLastModifiedTime()) {
                oprot.writeFieldBegin(LAST_MODIFIED_TIME_FIELD_DESC);
                oprot.writeI64(struct.lastModifiedTime);
                oprot.writeFieldEnd();
            }
            if (struct.productMetadata != null && struct.isSetProductMetadata()) {
                oprot.writeFieldBegin(PRODUCT_METADATA_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 11, struct.productMetadata.size()));
                for (Map.Entry _iter17 : struct.productMetadata.entrySet()) {
                    oprot.writeString((String)_iter17.getKey());
                    oprot.writeString((String)_iter17.getValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.replicaLocations != null && struct.isSetReplicaLocations()) {
                oprot.writeFieldBegin(REPLICA_LOCATIONS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.replicaLocations.size()));
                for (DataReplicaLocationModel _iter18 : struct.replicaLocations) {
                    _iter18.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class DataProductModelStandardSchemeFactory
    implements SchemeFactory {
        private DataProductModelStandardSchemeFactory() {
        }

        public DataProductModelStandardScheme getScheme() {
            return new DataProductModelStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        PRODUCT_URI(1, "productUri"),
        GATEWAY_ID(2, "gatewayId"),
        PARENT_PRODUCT_URI(3, "parentProductUri"),
        PRODUCT_NAME(4, "productName"),
        PRODUCT_DESCRIPTION(5, "productDescription"),
        OWNER_NAME(6, "ownerName"),
        DATA_PRODUCT_TYPE(7, "dataProductType"),
        PRODUCT_SIZE(8, "productSize"),
        CREATION_TIME(9, "creationTime"),
        LAST_MODIFIED_TIME(10, "lastModifiedTime"),
        PRODUCT_METADATA(11, "productMetadata"),
        REPLICA_LOCATIONS(12, "replicaLocations");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return PRODUCT_URI;
                }
                case 2: {
                    return GATEWAY_ID;
                }
                case 3: {
                    return PARENT_PRODUCT_URI;
                }
                case 4: {
                    return PRODUCT_NAME;
                }
                case 5: {
                    return PRODUCT_DESCRIPTION;
                }
                case 6: {
                    return OWNER_NAME;
                }
                case 7: {
                    return DATA_PRODUCT_TYPE;
                }
                case 8: {
                    return PRODUCT_SIZE;
                }
                case 9: {
                    return CREATION_TIME;
                }
                case 10: {
                    return LAST_MODIFIED_TIME;
                }
                case 11: {
                    return PRODUCT_METADATA;
                }
                case 12: {
                    return REPLICA_LOCATIONS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

