/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.model.data.replica;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.airavata.model.data.replica.ReplicaLocationCategory;
import org.apache.airavata.model.data.replica.ReplicaPersistentType;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class DataReplicaLocationModel
implements TBase<DataReplicaLocationModel, _Fields>,
Serializable,
Cloneable,
Comparable<DataReplicaLocationModel> {
    private static final TStruct STRUCT_DESC = new TStruct("DataReplicaLocationModel");
    private static final TField REPLICA_ID_FIELD_DESC = new TField("replicaId", 11, 1);
    private static final TField PRODUCT_URI_FIELD_DESC = new TField("productUri", 11, 2);
    private static final TField REPLICA_NAME_FIELD_DESC = new TField("replicaName", 11, 3);
    private static final TField REPLICA_DESCRIPTION_FIELD_DESC = new TField("replicaDescription", 11, 4);
    private static final TField CREATION_TIME_FIELD_DESC = new TField("creationTime", 10, 5);
    private static final TField LAST_MODIFIED_TIME_FIELD_DESC = new TField("lastModifiedTime", 10, 6);
    private static final TField VALID_UNTIL_TIME_FIELD_DESC = new TField("validUntilTime", 10, 7);
    private static final TField REPLICA_LOCATION_CATEGORY_FIELD_DESC = new TField("replicaLocationCategory", 8, 8);
    private static final TField REPLICA_PERSISTENT_TYPE_FIELD_DESC = new TField("replicaPersistentType", 8, 9);
    private static final TField STORAGE_RESOURCE_ID_FIELD_DESC = new TField("storageResourceId", 11, 10);
    private static final TField FILE_PATH_FIELD_DESC = new TField("filePath", 11, 11);
    private static final TField REPLICA_METADATA_FIELD_DESC = new TField("replicaMetadata", 13, 12);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    private String replicaId;
    private String productUri;
    private String replicaName;
    private String replicaDescription;
    private long creationTime;
    private long lastModifiedTime;
    private long validUntilTime;
    private ReplicaLocationCategory replicaLocationCategory;
    private ReplicaPersistentType replicaPersistentType;
    private String storageResourceId;
    private String filePath;
    private Map<String, String> replicaMetadata;
    private static final int __CREATIONTIME_ISSET_ID = 0;
    private static final int __LASTMODIFIEDTIME_ISSET_ID = 1;
    private static final int __VALIDUNTILTIME_ISSET_ID = 2;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public DataReplicaLocationModel() {
    }

    public DataReplicaLocationModel(DataReplicaLocationModel other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetReplicaId()) {
            this.replicaId = other.replicaId;
        }
        if (other.isSetProductUri()) {
            this.productUri = other.productUri;
        }
        if (other.isSetReplicaName()) {
            this.replicaName = other.replicaName;
        }
        if (other.isSetReplicaDescription()) {
            this.replicaDescription = other.replicaDescription;
        }
        this.creationTime = other.creationTime;
        this.lastModifiedTime = other.lastModifiedTime;
        this.validUntilTime = other.validUntilTime;
        if (other.isSetReplicaLocationCategory()) {
            this.replicaLocationCategory = other.replicaLocationCategory;
        }
        if (other.isSetReplicaPersistentType()) {
            this.replicaPersistentType = other.replicaPersistentType;
        }
        if (other.isSetStorageResourceId()) {
            this.storageResourceId = other.storageResourceId;
        }
        if (other.isSetFilePath()) {
            this.filePath = other.filePath;
        }
        if (other.isSetReplicaMetadata()) {
            HashMap<String, String> __this__replicaMetadata = new HashMap<String, String>(other.replicaMetadata);
            this.replicaMetadata = __this__replicaMetadata;
        }
    }

    public DataReplicaLocationModel deepCopy() {
        return new DataReplicaLocationModel(this);
    }

    public void clear() {
        this.replicaId = null;
        this.productUri = null;
        this.replicaName = null;
        this.replicaDescription = null;
        this.setCreationTimeIsSet(false);
        this.creationTime = 0L;
        this.setLastModifiedTimeIsSet(false);
        this.lastModifiedTime = 0L;
        this.setValidUntilTimeIsSet(false);
        this.validUntilTime = 0L;
        this.replicaLocationCategory = null;
        this.replicaPersistentType = null;
        this.storageResourceId = null;
        this.filePath = null;
        this.replicaMetadata = null;
    }

    public String getReplicaId() {
        return this.replicaId;
    }

    public void setReplicaId(String replicaId) {
        this.replicaId = replicaId;
    }

    public void unsetReplicaId() {
        this.replicaId = null;
    }

    public boolean isSetReplicaId() {
        return this.replicaId != null;
    }

    public void setReplicaIdIsSet(boolean value) {
        if (!value) {
            this.replicaId = null;
        }
    }

    public String getProductUri() {
        return this.productUri;
    }

    public void setProductUri(String productUri) {
        this.productUri = productUri;
    }

    public void unsetProductUri() {
        this.productUri = null;
    }

    public boolean isSetProductUri() {
        return this.productUri != null;
    }

    public void setProductUriIsSet(boolean value) {
        if (!value) {
            this.productUri = null;
        }
    }

    public String getReplicaName() {
        return this.replicaName;
    }

    public void setReplicaName(String replicaName) {
        this.replicaName = replicaName;
    }

    public void unsetReplicaName() {
        this.replicaName = null;
    }

    public boolean isSetReplicaName() {
        return this.replicaName != null;
    }

    public void setReplicaNameIsSet(boolean value) {
        if (!value) {
            this.replicaName = null;
        }
    }

    public String getReplicaDescription() {
        return this.replicaDescription;
    }

    public void setReplicaDescription(String replicaDescription) {
        this.replicaDescription = replicaDescription;
    }

    public void unsetReplicaDescription() {
        this.replicaDescription = null;
    }

    public boolean isSetReplicaDescription() {
        return this.replicaDescription != null;
    }

    public void setReplicaDescriptionIsSet(boolean value) {
        if (!value) {
            this.replicaDescription = null;
        }
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
        this.setCreationTimeIsSet(true);
    }

    public void unsetCreationTime() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetCreationTime() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setCreationTimeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
        this.setLastModifiedTimeIsSet(true);
    }

    public void unsetLastModifiedTime() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetLastModifiedTime() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setLastModifiedTimeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public long getValidUntilTime() {
        return this.validUntilTime;
    }

    public void setValidUntilTime(long validUntilTime) {
        this.validUntilTime = validUntilTime;
        this.setValidUntilTimeIsSet(true);
    }

    public void unsetValidUntilTime() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetValidUntilTime() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setValidUntilTimeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public ReplicaLocationCategory getReplicaLocationCategory() {
        return this.replicaLocationCategory;
    }

    public void setReplicaLocationCategory(ReplicaLocationCategory replicaLocationCategory) {
        this.replicaLocationCategory = replicaLocationCategory;
    }

    public void unsetReplicaLocationCategory() {
        this.replicaLocationCategory = null;
    }

    public boolean isSetReplicaLocationCategory() {
        return this.replicaLocationCategory != null;
    }

    public void setReplicaLocationCategoryIsSet(boolean value) {
        if (!value) {
            this.replicaLocationCategory = null;
        }
    }

    public ReplicaPersistentType getReplicaPersistentType() {
        return this.replicaPersistentType;
    }

    public void setReplicaPersistentType(ReplicaPersistentType replicaPersistentType) {
        this.replicaPersistentType = replicaPersistentType;
    }

    public void unsetReplicaPersistentType() {
        this.replicaPersistentType = null;
    }

    public boolean isSetReplicaPersistentType() {
        return this.replicaPersistentType != null;
    }

    public void setReplicaPersistentTypeIsSet(boolean value) {
        if (!value) {
            this.replicaPersistentType = null;
        }
    }

    public String getStorageResourceId() {
        return this.storageResourceId;
    }

    public void setStorageResourceId(String storageResourceId) {
        this.storageResourceId = storageResourceId;
    }

    public void unsetStorageResourceId() {
        this.storageResourceId = null;
    }

    public boolean isSetStorageResourceId() {
        return this.storageResourceId != null;
    }

    public void setStorageResourceIdIsSet(boolean value) {
        if (!value) {
            this.storageResourceId = null;
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void unsetFilePath() {
        this.filePath = null;
    }

    public boolean isSetFilePath() {
        return this.filePath != null;
    }

    public void setFilePathIsSet(boolean value) {
        if (!value) {
            this.filePath = null;
        }
    }

    public int getReplicaMetadataSize() {
        return this.replicaMetadata == null ? 0 : this.replicaMetadata.size();
    }

    public void putToReplicaMetadata(String key, String val) {
        if (this.replicaMetadata == null) {
            this.replicaMetadata = new HashMap<String, String>();
        }
        this.replicaMetadata.put(key, val);
    }

    public Map<String, String> getReplicaMetadata() {
        return this.replicaMetadata;
    }

    public void setReplicaMetadata(Map<String, String> replicaMetadata) {
        this.replicaMetadata = replicaMetadata;
    }

    public void unsetReplicaMetadata() {
        this.replicaMetadata = null;
    }

    public boolean isSetReplicaMetadata() {
        return this.replicaMetadata != null;
    }

    public void setReplicaMetadataIsSet(boolean value) {
        if (!value) {
            this.replicaMetadata = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case REPLICA_ID: {
                if (value == null) {
                    this.unsetReplicaId();
                    break;
                }
                this.setReplicaId((String)value);
                break;
            }
            case PRODUCT_URI: {
                if (value == null) {
                    this.unsetProductUri();
                    break;
                }
                this.setProductUri((String)value);
                break;
            }
            case REPLICA_NAME: {
                if (value == null) {
                    this.unsetReplicaName();
                    break;
                }
                this.setReplicaName((String)value);
                break;
            }
            case REPLICA_DESCRIPTION: {
                if (value == null) {
                    this.unsetReplicaDescription();
                    break;
                }
                this.setReplicaDescription((String)value);
                break;
            }
            case CREATION_TIME: {
                if (value == null) {
                    this.unsetCreationTime();
                    break;
                }
                this.setCreationTime((Long)value);
                break;
            }
            case LAST_MODIFIED_TIME: {
                if (value == null) {
                    this.unsetLastModifiedTime();
                    break;
                }
                this.setLastModifiedTime((Long)value);
                break;
            }
            case VALID_UNTIL_TIME: {
                if (value == null) {
                    this.unsetValidUntilTime();
                    break;
                }
                this.setValidUntilTime((Long)value);
                break;
            }
            case REPLICA_LOCATION_CATEGORY: {
                if (value == null) {
                    this.unsetReplicaLocationCategory();
                    break;
                }
                this.setReplicaLocationCategory((ReplicaLocationCategory)((Object)value));
                break;
            }
            case REPLICA_PERSISTENT_TYPE: {
                if (value == null) {
                    this.unsetReplicaPersistentType();
                    break;
                }
                this.setReplicaPersistentType((ReplicaPersistentType)((Object)value));
                break;
            }
            case STORAGE_RESOURCE_ID: {
                if (value == null) {
                    this.unsetStorageResourceId();
                    break;
                }
                this.setStorageResourceId((String)value);
                break;
            }
            case FILE_PATH: {
                if (value == null) {
                    this.unsetFilePath();
                    break;
                }
                this.setFilePath((String)value);
                break;
            }
            case REPLICA_METADATA: {
                if (value == null) {
                    this.unsetReplicaMetadata();
                    break;
                }
                this.setReplicaMetadata((Map)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case REPLICA_ID: {
                return this.getReplicaId();
            }
            case PRODUCT_URI: {
                return this.getProductUri();
            }
            case REPLICA_NAME: {
                return this.getReplicaName();
            }
            case REPLICA_DESCRIPTION: {
                return this.getReplicaDescription();
            }
            case CREATION_TIME: {
                return this.getCreationTime();
            }
            case LAST_MODIFIED_TIME: {
                return this.getLastModifiedTime();
            }
            case VALID_UNTIL_TIME: {
                return this.getValidUntilTime();
            }
            case REPLICA_LOCATION_CATEGORY: {
                return this.getReplicaLocationCategory();
            }
            case REPLICA_PERSISTENT_TYPE: {
                return this.getReplicaPersistentType();
            }
            case STORAGE_RESOURCE_ID: {
                return this.getStorageResourceId();
            }
            case FILE_PATH: {
                return this.getFilePath();
            }
            case REPLICA_METADATA: {
                return this.getReplicaMetadata();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case REPLICA_ID: {
                return this.isSetReplicaId();
            }
            case PRODUCT_URI: {
                return this.isSetProductUri();
            }
            case REPLICA_NAME: {
                return this.isSetReplicaName();
            }
            case REPLICA_DESCRIPTION: {
                return this.isSetReplicaDescription();
            }
            case CREATION_TIME: {
                return this.isSetCreationTime();
            }
            case LAST_MODIFIED_TIME: {
                return this.isSetLastModifiedTime();
            }
            case VALID_UNTIL_TIME: {
                return this.isSetValidUntilTime();
            }
            case REPLICA_LOCATION_CATEGORY: {
                return this.isSetReplicaLocationCategory();
            }
            case REPLICA_PERSISTENT_TYPE: {
                return this.isSetReplicaPersistentType();
            }
            case STORAGE_RESOURCE_ID: {
                return this.isSetStorageResourceId();
            }
            case FILE_PATH: {
                return this.isSetFilePath();
            }
            case REPLICA_METADATA: {
                return this.isSetReplicaMetadata();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof DataReplicaLocationModel) {
            return this.equals((DataReplicaLocationModel)that);
        }
        return false;
    }

    public boolean equals(DataReplicaLocationModel that) {
        if (that == null) {
            return false;
        }
        boolean this_present_replicaId = this.isSetReplicaId();
        boolean that_present_replicaId = that.isSetReplicaId();
        if (this_present_replicaId || that_present_replicaId) {
            if (!this_present_replicaId || !that_present_replicaId) {
                return false;
            }
            if (!this.replicaId.equals(that.replicaId)) {
                return false;
            }
        }
        boolean this_present_productUri = this.isSetProductUri();
        boolean that_present_productUri = that.isSetProductUri();
        if (this_present_productUri || that_present_productUri) {
            if (!this_present_productUri || !that_present_productUri) {
                return false;
            }
            if (!this.productUri.equals(that.productUri)) {
                return false;
            }
        }
        boolean this_present_replicaName = this.isSetReplicaName();
        boolean that_present_replicaName = that.isSetReplicaName();
        if (this_present_replicaName || that_present_replicaName) {
            if (!this_present_replicaName || !that_present_replicaName) {
                return false;
            }
            if (!this.replicaName.equals(that.replicaName)) {
                return false;
            }
        }
        boolean this_present_replicaDescription = this.isSetReplicaDescription();
        boolean that_present_replicaDescription = that.isSetReplicaDescription();
        if (this_present_replicaDescription || that_present_replicaDescription) {
            if (!this_present_replicaDescription || !that_present_replicaDescription) {
                return false;
            }
            if (!this.replicaDescription.equals(that.replicaDescription)) {
                return false;
            }
        }
        boolean this_present_creationTime = this.isSetCreationTime();
        boolean that_present_creationTime = that.isSetCreationTime();
        if (this_present_creationTime || that_present_creationTime) {
            if (!this_present_creationTime || !that_present_creationTime) {
                return false;
            }
            if (this.creationTime != that.creationTime) {
                return false;
            }
        }
        boolean this_present_lastModifiedTime = this.isSetLastModifiedTime();
        boolean that_present_lastModifiedTime = that.isSetLastModifiedTime();
        if (this_present_lastModifiedTime || that_present_lastModifiedTime) {
            if (!this_present_lastModifiedTime || !that_present_lastModifiedTime) {
                return false;
            }
            if (this.lastModifiedTime != that.lastModifiedTime) {
                return false;
            }
        }
        boolean this_present_validUntilTime = this.isSetValidUntilTime();
        boolean that_present_validUntilTime = that.isSetValidUntilTime();
        if (this_present_validUntilTime || that_present_validUntilTime) {
            if (!this_present_validUntilTime || !that_present_validUntilTime) {
                return false;
            }
            if (this.validUntilTime != that.validUntilTime) {
                return false;
            }
        }
        boolean this_present_replicaLocationCategory = this.isSetReplicaLocationCategory();
        boolean that_present_replicaLocationCategory = that.isSetReplicaLocationCategory();
        if (this_present_replicaLocationCategory || that_present_replicaLocationCategory) {
            if (!this_present_replicaLocationCategory || !that_present_replicaLocationCategory) {
                return false;
            }
            if (!this.replicaLocationCategory.equals((Object)that.replicaLocationCategory)) {
                return false;
            }
        }
        boolean this_present_replicaPersistentType = this.isSetReplicaPersistentType();
        boolean that_present_replicaPersistentType = that.isSetReplicaPersistentType();
        if (this_present_replicaPersistentType || that_present_replicaPersistentType) {
            if (!this_present_replicaPersistentType || !that_present_replicaPersistentType) {
                return false;
            }
            if (!this.replicaPersistentType.equals((Object)that.replicaPersistentType)) {
                return false;
            }
        }
        boolean this_present_storageResourceId = this.isSetStorageResourceId();
        boolean that_present_storageResourceId = that.isSetStorageResourceId();
        if (this_present_storageResourceId || that_present_storageResourceId) {
            if (!this_present_storageResourceId || !that_present_storageResourceId) {
                return false;
            }
            if (!this.storageResourceId.equals(that.storageResourceId)) {
                return false;
            }
        }
        boolean this_present_filePath = this.isSetFilePath();
        boolean that_present_filePath = that.isSetFilePath();
        if (this_present_filePath || that_present_filePath) {
            if (!this_present_filePath || !that_present_filePath) {
                return false;
            }
            if (!this.filePath.equals(that.filePath)) {
                return false;
            }
        }
        boolean this_present_replicaMetadata = this.isSetReplicaMetadata();
        boolean that_present_replicaMetadata = that.isSetReplicaMetadata();
        if (this_present_replicaMetadata || that_present_replicaMetadata) {
            if (!this_present_replicaMetadata || !that_present_replicaMetadata) {
                return false;
            }
            if (!this.replicaMetadata.equals(that.replicaMetadata)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_replicaId = this.isSetReplicaId();
        list.add(present_replicaId);
        if (present_replicaId) {
            list.add(this.replicaId);
        }
        boolean present_productUri = this.isSetProductUri();
        list.add(present_productUri);
        if (present_productUri) {
            list.add(this.productUri);
        }
        boolean present_replicaName = this.isSetReplicaName();
        list.add(present_replicaName);
        if (present_replicaName) {
            list.add(this.replicaName);
        }
        boolean present_replicaDescription = this.isSetReplicaDescription();
        list.add(present_replicaDescription);
        if (present_replicaDescription) {
            list.add(this.replicaDescription);
        }
        boolean present_creationTime = this.isSetCreationTime();
        list.add(present_creationTime);
        if (present_creationTime) {
            list.add(this.creationTime);
        }
        boolean present_lastModifiedTime = this.isSetLastModifiedTime();
        list.add(present_lastModifiedTime);
        if (present_lastModifiedTime) {
            list.add(this.lastModifiedTime);
        }
        boolean present_validUntilTime = this.isSetValidUntilTime();
        list.add(present_validUntilTime);
        if (present_validUntilTime) {
            list.add(this.validUntilTime);
        }
        boolean present_replicaLocationCategory = this.isSetReplicaLocationCategory();
        list.add(present_replicaLocationCategory);
        if (present_replicaLocationCategory) {
            list.add(this.replicaLocationCategory.getValue());
        }
        boolean present_replicaPersistentType = this.isSetReplicaPersistentType();
        list.add(present_replicaPersistentType);
        if (present_replicaPersistentType) {
            list.add(this.replicaPersistentType.getValue());
        }
        boolean present_storageResourceId = this.isSetStorageResourceId();
        list.add(present_storageResourceId);
        if (present_storageResourceId) {
            list.add(this.storageResourceId);
        }
        boolean present_filePath = this.isSetFilePath();
        list.add(present_filePath);
        if (present_filePath) {
            list.add(this.filePath);
        }
        boolean present_replicaMetadata = this.isSetReplicaMetadata();
        list.add(present_replicaMetadata);
        if (present_replicaMetadata) {
            list.add(this.replicaMetadata);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(DataReplicaLocationModel other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetReplicaId()).compareTo(other.isSetReplicaId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetReplicaId() && (lastComparison = TBaseHelper.compareTo((String)this.replicaId, (String)other.replicaId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetProductUri()).compareTo(other.isSetProductUri());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProductUri() && (lastComparison = TBaseHelper.compareTo((String)this.productUri, (String)other.productUri)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetReplicaName()).compareTo(other.isSetReplicaName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetReplicaName() && (lastComparison = TBaseHelper.compareTo((String)this.replicaName, (String)other.replicaName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetReplicaDescription()).compareTo(other.isSetReplicaDescription());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetReplicaDescription() && (lastComparison = TBaseHelper.compareTo((String)this.replicaDescription, (String)other.replicaDescription)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCreationTime()).compareTo(other.isSetCreationTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCreationTime() && (lastComparison = TBaseHelper.compareTo((long)this.creationTime, (long)other.creationTime)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLastModifiedTime()).compareTo(other.isSetLastModifiedTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLastModifiedTime() && (lastComparison = TBaseHelper.compareTo((long)this.lastModifiedTime, (long)other.lastModifiedTime)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetValidUntilTime()).compareTo(other.isSetValidUntilTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetValidUntilTime() && (lastComparison = TBaseHelper.compareTo((long)this.validUntilTime, (long)other.validUntilTime)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetReplicaLocationCategory()).compareTo(other.isSetReplicaLocationCategory());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetReplicaLocationCategory() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.replicaLocationCategory), (Comparable)((Object)other.replicaLocationCategory))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetReplicaPersistentType()).compareTo(other.isSetReplicaPersistentType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetReplicaPersistentType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.replicaPersistentType), (Comparable)((Object)other.replicaPersistentType))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetStorageResourceId()).compareTo(other.isSetStorageResourceId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetStorageResourceId() && (lastComparison = TBaseHelper.compareTo((String)this.storageResourceId, (String)other.storageResourceId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetFilePath()).compareTo(other.isSetFilePath());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFilePath() && (lastComparison = TBaseHelper.compareTo((String)this.filePath, (String)other.filePath)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetReplicaMetadata()).compareTo(other.isSetReplicaMetadata());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetReplicaMetadata() && (lastComparison = TBaseHelper.compareTo(this.replicaMetadata, other.replicaMetadata)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DataReplicaLocationModel(");
        boolean first = true;
        if (this.isSetReplicaId()) {
            sb.append("replicaId:");
            if (this.replicaId == null) {
                sb.append("null");
            } else {
                sb.append(this.replicaId);
            }
            first = false;
        }
        if (this.isSetProductUri()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("productUri:");
            if (this.productUri == null) {
                sb.append("null");
            } else {
                sb.append(this.productUri);
            }
            first = false;
        }
        if (this.isSetReplicaName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("replicaName:");
            if (this.replicaName == null) {
                sb.append("null");
            } else {
                sb.append(this.replicaName);
            }
            first = false;
        }
        if (this.isSetReplicaDescription()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("replicaDescription:");
            if (this.replicaDescription == null) {
                sb.append("null");
            } else {
                sb.append(this.replicaDescription);
            }
            first = false;
        }
        if (this.isSetCreationTime()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("creationTime:");
            sb.append(this.creationTime);
            first = false;
        }
        if (this.isSetLastModifiedTime()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("lastModifiedTime:");
            sb.append(this.lastModifiedTime);
            first = false;
        }
        if (this.isSetValidUntilTime()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("validUntilTime:");
            sb.append(this.validUntilTime);
            first = false;
        }
        if (this.isSetReplicaLocationCategory()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("replicaLocationCategory:");
            if (this.replicaLocationCategory == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.replicaLocationCategory);
            }
            first = false;
        }
        if (this.isSetReplicaPersistentType()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("replicaPersistentType:");
            if (this.replicaPersistentType == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.replicaPersistentType);
            }
            first = false;
        }
        if (this.isSetStorageResourceId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("storageResourceId:");
            if (this.storageResourceId == null) {
                sb.append("null");
            } else {
                sb.append(this.storageResourceId);
            }
            first = false;
        }
        if (this.isSetFilePath()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("filePath:");
            if (this.filePath == null) {
                sb.append("null");
            } else {
                sb.append(this.filePath);
            }
            first = false;
        }
        if (this.isSetReplicaMetadata()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("replicaMetadata:");
            if (this.replicaMetadata == null) {
                sb.append("null");
            } else {
                sb.append(this.replicaMetadata);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new DataReplicaLocationModelStandardSchemeFactory());
        schemes.put(TupleScheme.class, new DataReplicaLocationModelTupleSchemeFactory());
        optionals = new _Fields[]{_Fields.REPLICA_ID, _Fields.PRODUCT_URI, _Fields.REPLICA_NAME, _Fields.REPLICA_DESCRIPTION, _Fields.CREATION_TIME, _Fields.LAST_MODIFIED_TIME, _Fields.VALID_UNTIL_TIME, _Fields.REPLICA_LOCATION_CATEGORY, _Fields.REPLICA_PERSISTENT_TYPE, _Fields.STORAGE_RESOURCE_ID, _Fields.FILE_PATH, _Fields.REPLICA_METADATA};
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.REPLICA_ID, new FieldMetaData("replicaId", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PRODUCT_URI, new FieldMetaData("productUri", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.REPLICA_NAME, new FieldMetaData("replicaName", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.REPLICA_DESCRIPTION, new FieldMetaData("replicaDescription", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.CREATION_TIME, new FieldMetaData("creationTime", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.LAST_MODIFIED_TIME, new FieldMetaData("lastModifiedTime", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.VALID_UNTIL_TIME, new FieldMetaData("validUntilTime", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.REPLICA_LOCATION_CATEGORY, new FieldMetaData("replicaLocationCategory", 2, (FieldValueMetaData)new EnumMetaData(16, ReplicaLocationCategory.class)));
        tmpMap.put(_Fields.REPLICA_PERSISTENT_TYPE, new FieldMetaData("replicaPersistentType", 2, (FieldValueMetaData)new EnumMetaData(16, ReplicaPersistentType.class)));
        tmpMap.put(_Fields.STORAGE_RESOURCE_ID, new FieldMetaData("storageResourceId", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.FILE_PATH, new FieldMetaData("filePath", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.REPLICA_METADATA, new FieldMetaData("replicaMetadata", 2, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(DataReplicaLocationModel.class, metaDataMap);
    }

    private static class DataReplicaLocationModelTupleScheme
    extends TupleScheme<DataReplicaLocationModel> {
        private DataReplicaLocationModelTupleScheme() {
        }

        public void write(TProtocol prot, DataReplicaLocationModel struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetReplicaId()) {
                optionals.set(0);
            }
            if (struct.isSetProductUri()) {
                optionals.set(1);
            }
            if (struct.isSetReplicaName()) {
                optionals.set(2);
            }
            if (struct.isSetReplicaDescription()) {
                optionals.set(3);
            }
            if (struct.isSetCreationTime()) {
                optionals.set(4);
            }
            if (struct.isSetLastModifiedTime()) {
                optionals.set(5);
            }
            if (struct.isSetValidUntilTime()) {
                optionals.set(6);
            }
            if (struct.isSetReplicaLocationCategory()) {
                optionals.set(7);
            }
            if (struct.isSetReplicaPersistentType()) {
                optionals.set(8);
            }
            if (struct.isSetStorageResourceId()) {
                optionals.set(9);
            }
            if (struct.isSetFilePath()) {
                optionals.set(10);
            }
            if (struct.isSetReplicaMetadata()) {
                optionals.set(11);
            }
            oprot.writeBitSet(optionals, 12);
            if (struct.isSetReplicaId()) {
                oprot.writeString(struct.replicaId);
            }
            if (struct.isSetProductUri()) {
                oprot.writeString(struct.productUri);
            }
            if (struct.isSetReplicaName()) {
                oprot.writeString(struct.replicaName);
            }
            if (struct.isSetReplicaDescription()) {
                oprot.writeString(struct.replicaDescription);
            }
            if (struct.isSetCreationTime()) {
                oprot.writeI64(struct.creationTime);
            }
            if (struct.isSetLastModifiedTime()) {
                oprot.writeI64(struct.lastModifiedTime);
            }
            if (struct.isSetValidUntilTime()) {
                oprot.writeI64(struct.validUntilTime);
            }
            if (struct.isSetReplicaLocationCategory()) {
                oprot.writeI32(struct.replicaLocationCategory.getValue());
            }
            if (struct.isSetReplicaPersistentType()) {
                oprot.writeI32(struct.replicaPersistentType.getValue());
            }
            if (struct.isSetStorageResourceId()) {
                oprot.writeString(struct.storageResourceId);
            }
            if (struct.isSetFilePath()) {
                oprot.writeString(struct.filePath);
            }
            if (struct.isSetReplicaMetadata()) {
                oprot.writeI32(struct.replicaMetadata.size());
                for (Map.Entry _iter5 : struct.replicaMetadata.entrySet()) {
                    oprot.writeString((String)_iter5.getKey());
                    oprot.writeString((String)_iter5.getValue());
                }
            }
        }

        public void read(TProtocol prot, DataReplicaLocationModel struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(12);
            if (incoming.get(0)) {
                struct.replicaId = iprot.readString();
                struct.setReplicaIdIsSet(true);
            }
            if (incoming.get(1)) {
                struct.productUri = iprot.readString();
                struct.setProductUriIsSet(true);
            }
            if (incoming.get(2)) {
                struct.replicaName = iprot.readString();
                struct.setReplicaNameIsSet(true);
            }
            if (incoming.get(3)) {
                struct.replicaDescription = iprot.readString();
                struct.setReplicaDescriptionIsSet(true);
            }
            if (incoming.get(4)) {
                struct.creationTime = iprot.readI64();
                struct.setCreationTimeIsSet(true);
            }
            if (incoming.get(5)) {
                struct.lastModifiedTime = iprot.readI64();
                struct.setLastModifiedTimeIsSet(true);
            }
            if (incoming.get(6)) {
                struct.validUntilTime = iprot.readI64();
                struct.setValidUntilTimeIsSet(true);
            }
            if (incoming.get(7)) {
                struct.replicaLocationCategory = ReplicaLocationCategory.findByValue(iprot.readI32());
                struct.setReplicaLocationCategoryIsSet(true);
            }
            if (incoming.get(8)) {
                struct.replicaPersistentType = ReplicaPersistentType.findByValue(iprot.readI32());
                struct.setReplicaPersistentTypeIsSet(true);
            }
            if (incoming.get(9)) {
                struct.storageResourceId = iprot.readString();
                struct.setStorageResourceIdIsSet(true);
            }
            if (incoming.get(10)) {
                struct.filePath = iprot.readString();
                struct.setFilePathIsSet(true);
            }
            if (incoming.get(11)) {
                TMap _map6 = new TMap(11, 11, iprot.readI32());
                struct.replicaMetadata = new HashMap(2 * _map6.size);
                for (int _i9 = 0; _i9 < _map6.size; ++_i9) {
                    String _key7 = iprot.readString();
                    String _val8 = iprot.readString();
                    struct.replicaMetadata.put(_key7, _val8);
                }
                struct.setReplicaMetadataIsSet(true);
            }
        }
    }

    private static class DataReplicaLocationModelTupleSchemeFactory
    implements SchemeFactory {
        private DataReplicaLocationModelTupleSchemeFactory() {
        }

        public DataReplicaLocationModelTupleScheme getScheme() {
            return new DataReplicaLocationModelTupleScheme();
        }
    }

    private static class DataReplicaLocationModelStandardScheme
    extends StandardScheme<DataReplicaLocationModel> {
        private DataReplicaLocationModelStandardScheme() {
        }

        public void read(TProtocol iprot, DataReplicaLocationModel struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.replicaId = iprot.readString();
                            struct.setReplicaIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.productUri = iprot.readString();
                            struct.setProductUriIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.replicaName = iprot.readString();
                            struct.setReplicaNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 11) {
                            struct.replicaDescription = iprot.readString();
                            struct.setReplicaDescriptionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 10) {
                            struct.creationTime = iprot.readI64();
                            struct.setCreationTimeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 10) {
                            struct.lastModifiedTime = iprot.readI64();
                            struct.setLastModifiedTimeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 10) {
                            struct.validUntilTime = iprot.readI64();
                            struct.setValidUntilTimeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 8) {
                            struct.replicaLocationCategory = ReplicaLocationCategory.findByValue(iprot.readI32());
                            struct.setReplicaLocationCategoryIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 8) {
                            struct.replicaPersistentType = ReplicaPersistentType.findByValue(iprot.readI32());
                            struct.setReplicaPersistentTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 11) {
                            struct.storageResourceId = iprot.readString();
                            struct.setStorageResourceIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 11) {
                            struct.filePath = iprot.readString();
                            struct.setFilePathIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 13) {
                            TMap _map0 = iprot.readMapBegin();
                            struct.replicaMetadata = new HashMap(2 * _map0.size);
                            for (int _i3 = 0; _i3 < _map0.size; ++_i3) {
                                String _key1 = iprot.readString();
                                String _val2 = iprot.readString();
                                struct.replicaMetadata.put(_key1, _val2);
                            }
                            iprot.readMapEnd();
                            struct.setReplicaMetadataIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, DataReplicaLocationModel struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.replicaId != null && struct.isSetReplicaId()) {
                oprot.writeFieldBegin(REPLICA_ID_FIELD_DESC);
                oprot.writeString(struct.replicaId);
                oprot.writeFieldEnd();
            }
            if (struct.productUri != null && struct.isSetProductUri()) {
                oprot.writeFieldBegin(PRODUCT_URI_FIELD_DESC);
                oprot.writeString(struct.productUri);
                oprot.writeFieldEnd();
            }
            if (struct.replicaName != null && struct.isSetReplicaName()) {
                oprot.writeFieldBegin(REPLICA_NAME_FIELD_DESC);
                oprot.writeString(struct.replicaName);
                oprot.writeFieldEnd();
            }
            if (struct.replicaDescription != null && struct.isSetReplicaDescription()) {
                oprot.writeFieldBegin(REPLICA_DESCRIPTION_FIELD_DESC);
                oprot.writeString(struct.replicaDescription);
                oprot.writeFieldEnd();
            }
            if (struct.isSetCreationTime()) {
                oprot.writeFieldBegin(CREATION_TIME_FIELD_DESC);
                oprot.writeI64(struct.creationTime);
                oprot.writeFieldEnd();
            }
            if (struct.isSetLastModifiedTime()) {
                oprot.writeFieldBegin(LAST_MODIFIED_TIME_FIELD_DESC);
                oprot.writeI64(struct.lastModifiedTime);
                oprot.writeFieldEnd();
            }
            if (struct.isSetValidUntilTime()) {
                oprot.writeFieldBegin(VALID_UNTIL_TIME_FIELD_DESC);
                oprot.writeI64(struct.validUntilTime);
                oprot.writeFieldEnd();
            }
            if (struct.replicaLocationCategory != null && struct.isSetReplicaLocationCategory()) {
                oprot.writeFieldBegin(REPLICA_LOCATION_CATEGORY_FIELD_DESC);
                oprot.writeI32(struct.replicaLocationCategory.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.replicaPersistentType != null && struct.isSetReplicaPersistentType()) {
                oprot.writeFieldBegin(REPLICA_PERSISTENT_TYPE_FIELD_DESC);
                oprot.writeI32(struct.replicaPersistentType.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.storageResourceId != null && struct.isSetStorageResourceId()) {
                oprot.writeFieldBegin(STORAGE_RESOURCE_ID_FIELD_DESC);
                oprot.writeString(struct.storageResourceId);
                oprot.writeFieldEnd();
            }
            if (struct.filePath != null && struct.isSetFilePath()) {
                oprot.writeFieldBegin(FILE_PATH_FIELD_DESC);
                oprot.writeString(struct.filePath);
                oprot.writeFieldEnd();
            }
            if (struct.replicaMetadata != null && struct.isSetReplicaMetadata()) {
                oprot.writeFieldBegin(REPLICA_METADATA_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 11, struct.replicaMetadata.size()));
                for (Map.Entry _iter4 : struct.replicaMetadata.entrySet()) {
                    oprot.writeString((String)_iter4.getKey());
                    oprot.writeString((String)_iter4.getValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class DataReplicaLocationModelStandardSchemeFactory
    implements SchemeFactory {
        private DataReplicaLocationModelStandardSchemeFactory() {
        }

        public DataReplicaLocationModelStandardScheme getScheme() {
            return new DataReplicaLocationModelStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        REPLICA_ID(1, "replicaId"),
        PRODUCT_URI(2, "productUri"),
        REPLICA_NAME(3, "replicaName"),
        REPLICA_DESCRIPTION(4, "replicaDescription"),
        CREATION_TIME(5, "creationTime"),
        LAST_MODIFIED_TIME(6, "lastModifiedTime"),
        VALID_UNTIL_TIME(7, "validUntilTime"),
        REPLICA_LOCATION_CATEGORY(8, "replicaLocationCategory"),
        REPLICA_PERSISTENT_TYPE(9, "replicaPersistentType"),
        STORAGE_RESOURCE_ID(10, "storageResourceId"),
        FILE_PATH(11, "filePath"),
        REPLICA_METADATA(12, "replicaMetadata");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return REPLICA_ID;
                }
                case 2: {
                    return PRODUCT_URI;
                }
                case 3: {
                    return REPLICA_NAME;
                }
                case 4: {
                    return REPLICA_DESCRIPTION;
                }
                case 5: {
                    return CREATION_TIME;
                }
                case 6: {
                    return LAST_MODIFIED_TIME;
                }
                case 7: {
                    return VALID_UNTIL_TIME;
                }
                case 8: {
                    return REPLICA_LOCATION_CATEGORY;
                }
                case 9: {
                    return REPLICA_PERSISTENT_TYPE;
                }
                case 10: {
                    return STORAGE_RESOURCE_ID;
                }
                case 11: {
                    return FILE_PATH;
                }
                case 12: {
                    return REPLICA_METADATA;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

