/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.messaging.core.impl;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.MessageProperties;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.function.Function;
import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.common.utils.ThriftUtils;
import org.apache.airavata.messaging.core.MessageContext;
import org.apache.airavata.messaging.core.Publisher;
import org.apache.airavata.messaging.core.RabbitMQProperties;
import org.apache.airavata.model.messaging.event.Message;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQPublisher
implements Publisher {
    private static final Logger log = LoggerFactory.getLogger(RabbitMQPublisher.class);
    private final RabbitMQProperties properties;
    private final Function<MessageContext, String> routingKeySupplier;
    private Connection connection;
    private Channel channel;

    public RabbitMQPublisher(RabbitMQProperties properties, Function<MessageContext, String> routingKeySupplier) throws AiravataException {
        this.properties = properties;
        this.routingKeySupplier = routingKeySupplier;
        this.connect();
    }

    public RabbitMQPublisher(RabbitMQProperties properties) throws AiravataException {
        this.properties = properties;
        this.routingKeySupplier = null;
        this.connect();
    }

    private void connect() throws AiravataException {
        try {
            ConnectionFactory connectionFactory = new ConnectionFactory();
            connectionFactory.setUri(this.properties.getBrokerUrl());
            connectionFactory.setAutomaticRecoveryEnabled(this.properties.isAutoRecoveryEnable());
            this.connection = connectionFactory.newConnection();
            this.connection.addShutdownListener(new ShutdownListener(){

                public void shutdownCompleted(ShutdownSignalException cause) {
                }
            });
            log.info("connected to rabbitmq: " + this.connection + " for " + this.properties.getExchangeName());
            this.channel = this.connection.createChannel();
            if (this.properties.getPrefetchCount() > 0) {
                this.channel.basicQos(this.properties.getPrefetchCount());
            }
            if (this.properties.getExchangeName() != null) {
                this.channel.exchangeDeclare(this.properties.getExchangeName(), this.properties.getExchangeType(), true);
            }
        }
        catch (Exception e) {
            String msg = "RabbitMQ connection issue for exchange : " + this.properties.getExchangeName();
            log.error(msg);
            throw new AiravataException(msg, (Throwable)e);
        }
    }

    @Override
    public void publish(MessageContext messageContext) throws AiravataException {
        try {
            byte[] body = ThriftUtils.serializeThriftObject((TBase)messageContext.getEvent());
            Message message = new Message();
            message.setEvent(body);
            message.setMessageId(messageContext.getMessageId());
            message.setMessageType(messageContext.getType());
            message.setUpdatedTime(messageContext.getUpdatedTime().getTime());
            String routingKey = this.routingKeySupplier.apply(messageContext);
            byte[] messageBody = ThriftUtils.serializeThriftObject((TBase)message);
            this.send(messageBody, routingKey);
        }
        catch (TException e) {
            String msg = "Error while deserializing the object";
            log.error(msg, (Throwable)e);
            throw new AiravataException(msg, (Throwable)e);
        }
        catch (Exception e) {
            String msg = "Error while sending to rabbitmq";
            log.error(msg, (Throwable)e);
            throw new AiravataException(msg, (Throwable)e);
        }
    }

    @Override
    public void publish(MessageContext messageContext, String routingKey) throws AiravataException {
        try {
            byte[] body = ThriftUtils.serializeThriftObject((TBase)messageContext.getEvent());
            Message message = new Message();
            message.setEvent(body);
            message.setMessageId(messageContext.getMessageId());
            message.setMessageType(messageContext.getType());
            if (messageContext.getUpdatedTime() != null) {
                message.setUpdatedTime(messageContext.getUpdatedTime().getTime());
            }
            byte[] messageBody = ThriftUtils.serializeThriftObject((TBase)message);
            this.send(messageBody, routingKey);
        }
        catch (TException e) {
            String msg = "Error while deserializing the object";
            log.error(msg, (Throwable)e);
            throw new AiravataException(msg, (Throwable)e);
        }
        catch (Exception e) {
            String msg = "Error while sending to rabbitmq";
            log.error(msg, (Throwable)e);
            throw new AiravataException(msg, (Throwable)e);
        }
    }

    public void send(byte[] message, String routingKey) throws Exception {
        try {
            this.channel.basicPublish(this.properties.getExchangeName(), routingKey, MessageProperties.PERSISTENT_TEXT_PLAIN, message);
        }
        catch (IOException e) {
            String msg = "Failed to publish message to exchange: " + this.properties.getExchangeName();
            log.error(msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }
}

