/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.client;

import de.fzj.unicore.uas.StorageFactory;
import de.fzj.unicore.uas.client.BaseUASClient;
import de.fzj.unicore.uas.client.EnumerationClient;
import de.fzj.unicore.uas.client.StorageClient;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.oasisOpen.docs.wsrf.rl2.TerminationTimeDocument;
import org.unigrids.x2006.x04.services.smf.AccessibleStorageEnumerationDocument;
import org.unigrids.x2006.x04.services.smf.AccessibleStorageReferenceDocument;
import org.unigrids.x2006.x04.services.smf.CreateSMSDocument;
import org.unigrids.x2006.x04.services.smf.CreateSMSResponseDocument;
import org.unigrids.x2006.x04.services.smf.StorageDescriptionType;
import org.unigrids.x2006.x04.services.smf.StorageEnumerationDocument;
import org.unigrids.x2006.x04.services.smf.StorageFactoryPropertiesDocument;
import org.unigrids.x2006.x04.services.smf.StorageReferenceDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class StorageFactoryClient
extends BaseUASClient {
    private static final Logger logger = Log.getLogger("unicore.client", StorageFactoryClient.class);
    private final StorageFactory smf = this.makeProxy(StorageFactory.class);
    private EnumerationClient<StorageReferenceDocument> storageEnumeration;
    private EnumerationClient<AccessibleStorageReferenceDocument> accessibleStorageEnumeration;

    public StorageFactoryClient(String endpointUrl, EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        super(endpointUrl, epr, sec);
    }

    public StorageFactoryClient(EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        this(epr.getAddress().getStringValue(), epr, sec);
    }

    public StorageClient createSMS(CreateSMSDocument in) throws Exception {
        logger.info("Calling storage factory service at: " + this.getEPR().getAddress().getStringValue());
        CreateSMSResponseDocument res = this.smf.CreateSMS(in);
        EndpointReferenceType epr = res.getCreateSMSResponse().getSmsReference();
        return new StorageClient(epr.getAddress().getStringValue(), epr, this.getSecurityConfiguration());
    }

    public StorageClient createSMS(String type, String name, Calendar initialTerminationTime) throws Exception {
        CreateSMSDocument in = CreateSMSDocument.Factory.newInstance();
        in.addNewCreateSMS();
        if (initialTerminationTime != null) {
            TerminationTimeDocument.TerminationTime tt = TerminationTimeDocument.TerminationTime.Factory.newInstance();
            tt.setCalendarValue(initialTerminationTime);
            in.getCreateSMS().setTerminationTime(tt);
        }
        StorageDescriptionType sd = in.getCreateSMS().addNewStorageDescription();
        if (type != null) {
            sd.setStorageBackendType(type);
        }
        if (name != null) {
            sd.addNewFileSystem().setName(name);
        }
        return this.createSMS(in);
    }

    public StorageClient createSMS(Calendar initialTerminationTime) throws Exception {
        CreateSMSDocument in = CreateSMSDocument.Factory.newInstance();
        TerminationTimeDocument.TerminationTime tt = TerminationTimeDocument.TerminationTime.Factory.newInstance();
        tt.setCalendarValue(initialTerminationTime);
        in.addNewCreateSMS().setTerminationTime(tt);
        return this.createSMS(in);
    }

    public StorageClient createSMS() throws Exception {
        CreateSMSDocument in = CreateSMSDocument.Factory.newInstance();
        in.addNewCreateSMS();
        return this.createSMS(in);
    }

    public StorageFactoryPropertiesDocument getResourcePropertiesDocument() throws Exception {
        return StorageFactoryPropertiesDocument.Factory.parse(this.GetResourcePropertyDocument().getGetResourcePropertyDocumentResponse().newInputStream());
    }

    public List<EndpointReferenceType> getStorages() throws Exception {
        EnumerationClient<StorageReferenceDocument> c = this.getSMSEnumeration();
        if (c == null) {
            return this.getSMSWithoutEnumeration();
        }
        ArrayList<EndpointReferenceType> res = new ArrayList<EndpointReferenceType>();
        Iterator<StorageReferenceDocument> iter = c.iterator();
        while (iter.hasNext()) {
            res.add(iter.next().getStorageReference());
        }
        return res;
    }

    public List<EndpointReferenceType> getAccessibleStorages() throws Exception {
        EnumerationClient<AccessibleStorageReferenceDocument> c = this.getAccessibleSMSEnumeration();
        if (c == null) {
            return this.getAccessibleSMSWithoutEnumeration();
        }
        ArrayList<EndpointReferenceType> res = new ArrayList<EndpointReferenceType>();
        Iterator<AccessibleStorageReferenceDocument> iter = c.iterator();
        while (iter.hasNext()) {
            res.add(iter.next().getAccessibleStorageReference());
        }
        return res;
    }

    private synchronized EnumerationClient<StorageReferenceDocument> getSMSEnumeration() throws Exception {
        StorageEnumerationDocument enumRef;
        if (this.storageEnumeration == null && (enumRef = this.getSingleResourceProperty(StorageEnumerationDocument.class)) != null) {
            EndpointReferenceType epr = enumRef.getStorageEnumeration();
            this.storageEnumeration = new EnumerationClient(epr, this.getSecurityConfiguration(), StorageReferenceDocument.type.getDocumentElementName());
        }
        return this.storageEnumeration;
    }

    private List<EndpointReferenceType> getSMSWithoutEnumeration() {
        try {
            EndpointReferenceType[] eprs = this.getResourcePropertiesDocument().getStorageFactoryProperties().getStorageReferenceArray();
            return Arrays.asList(eprs);
        }
        catch (Exception e) {
            logger.error("Can't get accessible storage list.", e);
            return null;
        }
    }

    private synchronized EnumerationClient<AccessibleStorageReferenceDocument> getAccessibleSMSEnumeration() throws Exception {
        AccessibleStorageEnumerationDocument enumRef;
        if (this.accessibleStorageEnumeration == null && (enumRef = this.getSingleResourceProperty(AccessibleStorageEnumerationDocument.class)) != null) {
            EndpointReferenceType epr = enumRef.getAccessibleStorageEnumeration();
            this.accessibleStorageEnumeration = new EnumerationClient(epr, this.getSecurityConfiguration(), AccessibleStorageReferenceDocument.type.getDocumentElementName());
        }
        return this.accessibleStorageEnumeration;
    }

    private List<EndpointReferenceType> getAccessibleSMSWithoutEnumeration() {
        try {
            EndpointReferenceType[] eprs = this.getResourcePropertiesDocument().getStorageFactoryProperties().getAccessibleStorageReferenceArray();
            return Arrays.asList(eprs);
        }
        catch (Exception e) {
            logger.error("Can't get accessible storage list.", e);
            return null;
        }
    }

    public StorageDescriptionType[] getBackendStorageDescription() throws Exception {
        return this.getResourcePropertiesDocument().getStorageFactoryProperties().getStorageDescriptionArray();
    }
}

