/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.elements;

import eu.unicore.samly2.SAMLConstants;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;
import xmlbeans.org.oasis.saml2.assertion.AttributeType;
import xmlbeans.pl.edu.icm.samlvo.attrext.ScopedStringAttributeValueType;

public class SAMLAttribute {
    private AttributeType xml;

    public SAMLAttribute(AttributeType xml) {
        this.xml = xml;
    }

    public SAMLAttribute(String name, String nameFormat) {
        this(name, nameFormat, null);
    }

    public SAMLAttribute(String name, String nameFormat, String friendlyName) {
        this.xml = AttributeType.Factory.newInstance();
        this.xml.setName(name);
        this.xml.setNameFormat(nameFormat);
        if (friendlyName != null) {
            this.xml.setFriendlyName(friendlyName);
        }
    }

    @Deprecated
    public SAMLAttribute(String name, String nameFormat, String xacmlType, String scopingType, String friendlyName) {
        this(name, nameFormat, friendlyName);
        if (scopingType != null) {
            this.setScopingType(scopingType);
        }
        if (xacmlType != null) {
            this.setXACMLDataType(xacmlType);
        }
    }

    public void setFriendlyName(String friendlyName) {
        this.xml.setFriendlyName(friendlyName);
    }

    public String getFriendlyName() {
        return this.xml.getFriendlyName();
    }

    @Deprecated
    public void setScopingType(String type) {
        this.insertAttribute(SAMLConstants.SCOPE_TYPE_XMLATTRIBUTE.getLocalPart(), SAMLConstants.SCOPE_TYPE_XMLATTRIBUTE.getNamespaceURI(), type);
    }

    @Deprecated
    public String getScopingType() {
        return this.readAttribute(SAMLConstants.SCOPE_TYPE_XMLATTRIBUTE.getLocalPart(), SAMLConstants.SCOPE_TYPE_XMLATTRIBUTE.getNamespaceURI());
    }

    @Deprecated
    public void setAttributeWideScope(String scope) {
        this.insertAttribute(SAMLConstants.ATTRIBUTE_SCOPE_XMLATTRIBUTE.getLocalPart(), SAMLConstants.ATTRIBUTE_SCOPE_XMLATTRIBUTE.getNamespaceURI(), scope);
    }

    @Deprecated
    public String getAttributeWideScope() {
        return this.readAttribute(SAMLConstants.ATTRIBUTE_SCOPE_XMLATTRIBUTE.getLocalPart(), SAMLConstants.ATTRIBUTE_SCOPE_XMLATTRIBUTE.getNamespaceURI());
    }

    @Deprecated
    public void setXACMLDataType(String type) {
        this.insertAttribute(SAMLConstants.XACMLDT.getLocalPart(), SAMLConstants.XACMLDT.getNamespaceURI(), type);
    }

    @Deprecated
    public String getXACMLDataType() {
        return this.readAttribute(SAMLConstants.XACMLDT.getLocalPart(), SAMLConstants.XACMLDT.getNamespaceURI());
    }

    public void addStringAttributeValue(String value) {
        XmlObject o = this.xml.addNewAttributeValue();
        XmlString s = XmlString.Factory.newInstance();
        s.setStringValue(value);
        o.set((XmlObject)s);
    }

    @Deprecated
    public void addScopedStringAttributeValue(String value, String scope) {
        XmlObject o = this.xml.addNewAttributeValue();
        ScopedStringAttributeValueType valXml = ScopedStringAttributeValueType.Factory.newInstance();
        if (value != null) {
            valXml.setStringValue(value);
        } else {
            valXml.setNil();
        }
        valXml.setScope(scope == null ? "/" : scope);
        o.set((XmlObject)valXml);
    }

    public void addXMLAttribute(QName name, String value) {
        XmlCursor cur = this.xml.newCursor();
        cur.toLastAttribute();
        cur.insertAttributeWithValue(name, value);
        cur.dispose();
    }

    public AttributeType getXBean() {
        return this.xml;
    }

    private void insertAttribute(String name, String ns, String value) {
        XmlCursor cur = this.xml.newCursor();
        cur.toFirstChild();
        int i = 0;
        String prefix = "urnx";
        while (cur.namespaceForPrefix(prefix + i) != null) {
            ++i;
        }
        prefix = prefix + i;
        cur.toLastAttribute();
        cur.insertNamespace(prefix, ns);
        QName dtQN = new QName(ns, name, prefix);
        cur.insertAttributeWithValue(dtQN, value);
        cur.dispose();
    }

    private String readAttribute(String name, String ns) {
        XmlCursor cur = this.xml.newCursor();
        return cur.getAttributeText(new QName(ns, name));
    }

    public int hashCode() {
        String nf1 = this.xml.getNameFormat();
        if (nf1 == null) {
            nf1 = "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified";
        }
        return (this.xml.getName() + "-----!!!----" + nf1).hashCode();
    }

    public boolean equals(Object obj) {
        String nf2;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SAMLAttribute other = (SAMLAttribute)obj;
        if (this.xml == null) {
            return other.xml == null;
        }
        if (other.xml == null) {
            return false;
        }
        String nf1 = this.xml.getNameFormat();
        if (nf1 == null) {
            nf1 = "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified";
        }
        if ((nf2 = other.xml.getNameFormat()) == null) {
            nf2 = "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified";
        }
        return other.xml.getName().equals(this.xml.getName()) && nf2.equals(nf1);
    }
}

