/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil.client;

import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.samly2.elements.SAMLAttribute;
import eu.unicore.security.UnicoreSecurityFactory;
import eu.unicore.security.dsig.DSigException;
import eu.unicore.security.etd.DelegationRestrictions;
import eu.unicore.security.etd.ETDApi;
import eu.unicore.security.etd.InconsistentTDChainException;
import eu.unicore.security.etd.TrustDelegation;
import eu.unicore.security.user.UserAssertion;
import eu.unicore.security.wsutil.client.TDOutHandler;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.ETDClientSettings;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;

public class ExtendedTDOutHandler
extends TDOutHandler {
    private static final Logger logger = Log.getLogger("unicore.security", ExtendedTDOutHandler.class);
    private List<TrustDelegation> assertionList = null;
    private UserAssertion userAssertion = null;

    public ExtendedTDOutHandler(IClientConfiguration config) {
        ETDClientSettings sec = config.getETDSettings();
        X509Certificate[] issuer = sec.getIssuerCertificateChain();
        if ((issuer == null || issuer.length == 0) && sec.getRequestedUser() == null) {
            logger.debug("Neither issuer was set, nor requestedUser. Won't add any ETD/User assertion");
            return;
        }
        String issuerDN = issuer != null && issuer.length > 0 ? issuer[0].getSubjectX500Principal().getName() : sec.getRequestedUser();
        List<TrustDelegation> list = this.assertionList = sec.getTrustDelegationTokens() != null ? sec.getTrustDelegationTokens() : new ArrayList<TrustDelegation>();
        if (sec.isExtendTrustDelegation()) {
            try {
                this.setupExtendedAssertionList(config);
            }
            catch (Exception dse) {
                throw new RuntimeException("Error setting up (extended) TD chain", dse);
            }
        }
        logger.debug("Initialised TD Outhandler, TD chain length = " + this.assertionList.size());
        String requestedUser = sec.getRequestedUser();
        if (requestedUser == null) {
            requestedUser = this.assertionList.size() > 0 ? this.assertionList.get(0).getCustodianDN() : issuerDN;
        }
        if (this.needCustomUserAssertion(sec)) {
            this.userAssertion = super.createUserAssertion(null, requestedUser, issuerDN);
            for (Map.Entry<String, String[]> e : sec.getRequestedUserAttributes2().entrySet()) {
                SAMLAttribute at = new SAMLAttribute(e.getKey(), "urn:unicore:subject-requested-attribute");
                for (String val : e.getValue()) {
                    at.addStringAttributeValue(val);
                }
                this.userAssertion.addAttribute(at);
            }
            super.init(this.assertionList, this.userAssertion);
        } else {
            super.init(this.assertionList, null, requestedUser, issuerDN);
        }
    }

    private void setupExtendedAssertionList(IClientConfiguration config) throws DSigException, InconsistentTDChainException {
        ETDClientSettings sec = config.getETDSettings();
        X509Certificate[] issuer = sec.getIssuerCertificateChain();
        PrivateKey pk = config.getCredential().getKey();
        X500Principal receiver = sec.getReceiver();
        if (receiver == null) {
            logger.debug("No receiver set, not creating TD assertion.");
        } else {
            String receiverName = receiver.getName();
            DelegationRestrictions restrictions = sec.getDelegationRestrictions();
            if (sec.getRelativeDelegationValidityDays() != null) {
                Calendar start = Calendar.getInstance();
                start.add(10, -1);
                Calendar end = Calendar.getInstance();
                end.add(6, sec.getRelativeDelegationValidityDays());
                restrictions.setNotBefore(start.getTime());
                restrictions.setNotOnOrAfter(end.getTime());
            }
            if (this.assertionList.size() == 0) {
                this.assertionList.add(this.createAssertion(issuer, pk, receiverName, restrictions));
            } else {
                this.assertionList = this.extendAssertion(this.assertionList, issuer, pk, receiverName, restrictions);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Initialised trust delegation to receiver <" + X500NameUtils.getReadableForm((String)receiverName) + ">");
            }
        }
    }

    private boolean needCustomUserAssertion(ETDClientSettings sec) {
        return sec != null && sec.getRequestedUserAttributes2().size() > 0;
    }

    protected synchronized TrustDelegation createAssertion(X509Certificate[] issuer, PrivateKey pk, String receiver, DelegationRestrictions restrictions) throws DSigException {
        ETDApi engine = UnicoreSecurityFactory.getETDEngine();
        return engine.generateTD(issuer[0].getSubjectX500Principal().getName(), issuer, pk, receiver, restrictions);
    }

    protected synchronized List<TrustDelegation> extendAssertion(List<TrustDelegation> tdList, X509Certificate[] issuer, PrivateKey pk, String receiver, DelegationRestrictions restrictions) throws DSigException, InconsistentTDChainException {
        int l = tdList.size();
        String lastReceiver = tdList.get(l - 1).getSubjectName();
        if (receiver.equals(lastReceiver)) {
            logger.debug("TD chain already includes receiver <" + receiver + ">");
            return tdList;
        }
        logger.debug("Extending TD chain to receiver <" + receiver + ">");
        ETDApi engine = UnicoreSecurityFactory.getETDEngine();
        return engine.issueChainedTD(tdList, issuer, pk, receiver, restrictions);
    }

    public List<TrustDelegation> getAssertionList() {
        return this.assertionList;
    }

    public UserAssertion getUserAssertion() {
        return this.userAssertion;
    }
}

