/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.util.httpclient;

import eu.emi.security.authn.x509.impl.HostnameMismatchCallback;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.ServerHostnameCheckingMode;
import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;

public class HostnameMismatchCallbackImpl
implements HostnameMismatchCallback {
    private static final Logger log = Log.getLogger("unicore.security", HostnameMismatchCallbackImpl.class);
    private ServerHostnameCheckingMode mode;

    public HostnameMismatchCallbackImpl(ServerHostnameCheckingMode mode) {
        this.mode = mode;
    }

    public void nameMismatch(SSLSocket socket, X509Certificate peerCertificate, String hostName) throws SSLException {
        if (this.mode == ServerHostnameCheckingMode.NONE) {
            return;
        }
        String message = "The server hostname is not matching its certificate subject. This might mean that somebody is trying to perform a man-in-the-middle attack by pretending to be the server you are trying to connect to. However it is also possible that the server uses a certificate which was not associated with its address. The server DNS name is: '" + hostName + "' and its certificate subject is: '" + X500NameUtils.getReadableForm((X500Principal)peerCertificate.getSubjectX500Principal()) + "'.";
        if (this.mode == ServerHostnameCheckingMode.WARN) {
            log.warn(message);
            return;
        }
        log.error(message);
        log.error("Closing the connection.");
        try {
            socket.close();
        }
        catch (IOException e) {
            log.error("Problem closing socket: " + e.toString(), e);
            throw new RuntimeException(e);
        }
    }
}

