/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.service.profile.commons.repositories;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import org.apache.airavata.service.profile.commons.utils.JPAUtils;
import org.apache.airavata.service.profile.commons.utils.ObjectMapperSingleton;
import org.dozer.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRepository<T, E, Id> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRepository.class);
    private Class<T> thriftGenericClass;
    private Class<E> dbEntityGenericClass;

    public AbstractRepository(Class<T> thriftGenericClass, Class<E> dbEntityGenericClass) {
        this.thriftGenericClass = thriftGenericClass;
        this.dbEntityGenericClass = dbEntityGenericClass;
    }

    public T create(T t) {
        return this.update(t);
    }

    public T update(T t) {
        ObjectMapperSingleton mapper = ObjectMapperSingleton.getInstance();
        Object entity = mapper.map(t, this.dbEntityGenericClass);
        Object persistedCopy = JPAUtils.execute(entityManager -> entityManager.merge(entity));
        return (T)mapper.map(persistedCopy, this.thriftGenericClass);
    }

    public boolean delete(Id id) {
        JPAUtils.execute(entityManager -> {
            Object entity = entityManager.find(this.dbEntityGenericClass, id);
            entityManager.remove(entity);
            return entity;
        });
        return true;
    }

    public T get(Id id) {
        Object entity = JPAUtils.execute(entityManager -> entityManager.find(this.dbEntityGenericClass, id));
        ObjectMapperSingleton mapper = ObjectMapperSingleton.getInstance();
        return (T)mapper.map(entity, this.thriftGenericClass);
    }

    public List<T> select(String query) {
        List resultSet = JPAUtils.execute(entityManager -> entityManager.createQuery(query).getResultList());
        ObjectMapperSingleton mapper = ObjectMapperSingleton.getInstance();
        ArrayList resultList = new ArrayList();
        resultSet.stream().forEach(arg_0 -> this.lambda$select$4(resultList, (Mapper)mapper, arg_0));
        return resultList;
    }

    public List<T> select(String query, int limit, int offset) {
        List resultSet = JPAUtils.execute(entityManager -> entityManager.createQuery(query).setFirstResult(offset).setMaxResults(limit).getResultList());
        ObjectMapperSingleton mapper = ObjectMapperSingleton.getInstance();
        ArrayList resultList = new ArrayList();
        resultSet.stream().forEach(arg_0 -> this.lambda$select$6(resultList, (Mapper)mapper, arg_0));
        return resultList;
    }

    public List<T> select(String query, int limit, int offset, Map<String, Object> queryParams) {
        List resultSet = JPAUtils.execute(entityManager -> {
            Query jpaQuery = entityManager.createQuery(query);
            for (Map.Entry entry : queryParams.entrySet()) {
                jpaQuery.setParameter((String)entry.getKey(), entry.getValue());
            }
            return jpaQuery.setFirstResult(offset).setMaxResults(limit).getResultList();
        });
        ObjectMapperSingleton mapper = ObjectMapperSingleton.getInstance();
        ArrayList resultList = new ArrayList();
        resultSet.stream().forEach(arg_0 -> this.lambda$select$8(resultList, (Mapper)mapper, arg_0));
        return resultList;
    }

    public List<T> select(String query, Map<String, Object> queryParams) {
        List resultSet = JPAUtils.execute(entityManager -> {
            Query jpaQuery = entityManager.createQuery(query);
            for (Map.Entry entry : queryParams.entrySet()) {
                jpaQuery.setParameter((String)entry.getKey(), entry.getValue());
            }
            return jpaQuery.getResultList();
        });
        ObjectMapperSingleton mapper = ObjectMapperSingleton.getInstance();
        ArrayList resultList = new ArrayList();
        resultSet.stream().forEach(arg_0 -> this.lambda$select$10(resultList, (Mapper)mapper, arg_0));
        return resultList;
    }

    private /* synthetic */ void lambda$select$10(List resultList, Mapper mapper, Object rs) {
        resultList.add(mapper.map(rs, this.thriftGenericClass));
    }

    private /* synthetic */ void lambda$select$8(List resultList, Mapper mapper, Object rs) {
        resultList.add(mapper.map(rs, this.thriftGenericClass));
    }

    private /* synthetic */ void lambda$select$6(List resultList, Mapper mapper, Object rs) {
        resultList.add(mapper.map(rs, this.thriftGenericClass));
    }

    private /* synthetic */ void lambda$select$4(List resultList, Mapper mapper, Object rs) {
        resultList.add(mapper.map(rs, this.thriftGenericClass));
    }
}

