/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule;
import org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription;
import org.apache.airavata.model.application.io.InputDataObjectType;
import org.apache.airavata.model.application.io.OutputDataObjectType;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppInterfaceResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppModuleMappingAppCatalogResourceAppCat;
import org.apache.airavata.registry.core.app.catalog.resources.AppModuleResource;
import org.apache.airavata.registry.core.app.catalog.resources.ApplicationInputResource;
import org.apache.airavata.registry.core.app.catalog.resources.ApplicationOutputResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogThriftConversion;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogUtils;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.apache.airavata.registry.cpi.ApplicationInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationInterfaceImpl
implements ApplicationInterface {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationInterfaceImpl.class);

    public String addApplicationModule(ApplicationModule applicationModule, String gatewayId) throws AppCatalogException {
        try {
            AppModuleResource moduleResource = new AppModuleResource();
            moduleResource.setModuleName(applicationModule.getAppModuleName());
            moduleResource.setGatewayId(gatewayId);
            if (!applicationModule.getAppModuleId().equals("") && !applicationModule.getAppModuleId().equals("DO_NOT_SET_AT_CLIENTS")) {
                moduleResource.setModuleId(applicationModule.getAppModuleId());
            } else {
                moduleResource.setModuleId(AppCatalogUtils.getID(applicationModule.getAppModuleName()));
            }
            moduleResource.setModuleDesc(applicationModule.getAppModuleDescription());
            moduleResource.setModuleVersion(applicationModule.getAppModuleVersion());
            moduleResource.save();
            applicationModule.setAppModuleId(moduleResource.getModuleId());
            return moduleResource.getModuleId();
        }
        catch (Exception e) {
            logger.error("Error while adding application module " + applicationModule.getAppModuleName() + " [" + applicationModule.getAppModuleVersion() + "]", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public String addApplicationInterface(ApplicationInterfaceDescription applicationInterfaceDescription, String gatewayId) throws AppCatalogException {
        try {
            List applicationOutputs;
            List applicationInputs;
            AppInterfaceResource resource = new AppInterfaceResource();
            resource.setAppName(applicationInterfaceDescription.getApplicationName());
            if (!applicationInterfaceDescription.getApplicationInterfaceId().equals("") && !applicationInterfaceDescription.getApplicationInterfaceId().equals("DO_NOT_SET_AT_CLIENTS")) {
                resource.setInterfaceId(applicationInterfaceDescription.getApplicationInterfaceId());
            } else {
                resource.setInterfaceId(AppCatalogUtils.getID(applicationInterfaceDescription.getApplicationName()));
            }
            resource.setAppDescription(applicationInterfaceDescription.getApplicationDescription());
            resource.setGatewayId(gatewayId);
            resource.setArchiveWorkingDirectory(applicationInterfaceDescription.isArchiveWorkingDirectory());
            resource.setHasOptionalFileInputs(applicationInterfaceDescription.isHasOptionalFileInputs());
            resource.save();
            applicationInterfaceDescription.setApplicationInterfaceId(resource.getInterfaceId());
            List applicationModules = applicationInterfaceDescription.getApplicationModules();
            if (applicationModules != null && !applicationModules.isEmpty()) {
                for (Object moduleId : applicationModules) {
                    AppModuleResource appModuleResource = new AppModuleResource();
                    AppModuleMappingAppCatalogResourceAppCat moduleMappingResource = new AppModuleMappingAppCatalogResourceAppCat();
                    moduleMappingResource.setInterfaceId(resource.getInterfaceId());
                    moduleMappingResource.setModuleId((String)moduleId);
                    moduleMappingResource.setModuleResource((AppModuleResource)appModuleResource.get(moduleId));
                    moduleMappingResource.setAppInterfaceResource(resource);
                    moduleMappingResource.save();
                }
            }
            if ((applicationInputs = applicationInterfaceDescription.getApplicationInputs()) != null && !applicationInputs.isEmpty()) {
                for (InputDataObjectType input : applicationInputs) {
                    ApplicationInputResource inputResource = new ApplicationInputResource();
                    inputResource.setAppInterfaceResource(resource);
                    inputResource.setInterfaceID(resource.getInterfaceId());
                    inputResource.setUserFriendlyDesc(input.getUserFriendlyDescription());
                    inputResource.setInputKey(input.getName());
                    inputResource.setInputVal(input.getValue());
                    inputResource.setDataType(input.getType().toString());
                    inputResource.setMetadata(input.getMetaData());
                    inputResource.setStandardInput(input.isStandardInput());
                    inputResource.setAppArgument(input.getApplicationArgument());
                    inputResource.setInputOrder(input.getInputOrder());
                    inputResource.setRequired(input.isIsRequired());
                    inputResource.setRequiredToCMD(input.isRequiredToAddedToCommandLine());
                    inputResource.save();
                }
            }
            if ((applicationOutputs = applicationInterfaceDescription.getApplicationOutputs()) != null && !applicationOutputs.isEmpty()) {
                for (OutputDataObjectType output : applicationOutputs) {
                    ApplicationOutputResource outputResource = new ApplicationOutputResource();
                    outputResource.setInterfaceID(resource.getInterfaceId());
                    outputResource.setAppInterfaceResource(resource);
                    outputResource.setOutputKey(output.getName());
                    outputResource.setOutputVal(output.getValue());
                    outputResource.setDataType(output.getType().toString());
                    outputResource.setRequired(output.isIsRequired());
                    outputResource.setRequiredToCMD(output.isRequiredToAddedToCommandLine());
                    outputResource.setDataMovement(output.isDataMovement());
                    outputResource.setDataNameLocation(output.getLocation());
                    outputResource.setAppArgument(output.getApplicationArgument());
                    outputResource.setSearchQuery(output.getSearchQuery());
                    outputResource.setOutputStreaming(output.isOutputStreaming());
                    outputResource.save();
                }
            }
            return resource.getInterfaceId();
        }
        catch (Exception e) {
            logger.error("Error while adding application interface " + applicationInterfaceDescription.getApplicationName(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public void addApplicationModuleMapping(String moduleId, String interfaceId) throws AppCatalogException {
        try {
            AppModuleResource appModuleResource = new AppModuleResource();
            AppInterfaceResource interfaceResource = new AppInterfaceResource();
            AppModuleMappingAppCatalogResourceAppCat moduleMappingResource = new AppModuleMappingAppCatalogResourceAppCat();
            moduleMappingResource.setInterfaceId(interfaceId);
            moduleMappingResource.setModuleId(moduleId);
            moduleMappingResource.setModuleResource((AppModuleResource)appModuleResource.get(moduleId));
            moduleMappingResource.setAppInterfaceResource((AppInterfaceResource)interfaceResource.get(interfaceId));
            moduleMappingResource.save();
        }
        catch (Exception e) {
            logger.error("Error while saving application module mapping " + moduleId, (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public void updateApplicationModule(String moduleId, ApplicationModule updatedModule) throws AppCatalogException {
        try {
            AppModuleResource moduleResource = new AppModuleResource();
            AppModuleResource existingModule = (AppModuleResource)moduleResource.get(moduleId);
            existingModule.setModuleName(updatedModule.getAppModuleName());
            existingModule.setModuleDesc(updatedModule.getAppModuleDescription());
            existingModule.setModuleVersion(updatedModule.getAppModuleVersion());
            existingModule.save();
        }
        catch (Exception e) {
            logger.error("Error while updating application module " + moduleId, (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public void updateApplicationInterface(String interfaceId, ApplicationInterfaceDescription updatedInterface) throws AppCatalogException {
        try {
            AppInterfaceResource resource = new AppInterfaceResource();
            AppInterfaceResource existingInterface = (AppInterfaceResource)resource.get(interfaceId);
            existingInterface.setAppName(updatedInterface.getApplicationName());
            existingInterface.setAppDescription(updatedInterface.getApplicationDescription());
            existingInterface.setHasOptionalFileInputs(updatedInterface.isHasOptionalFileInputs());
            existingInterface.setArchiveWorkingDirectory(updatedInterface.isArchiveWorkingDirectory());
            existingInterface.save();
            HashMap<String, String> ids = new HashMap<String, String>();
            ids.put("interfaceID", interfaceId);
            AppModuleMappingAppCatalogResourceAppCat moduleMappingResource = new AppModuleMappingAppCatalogResourceAppCat();
            moduleMappingResource.remove(ids);
            List applicationModules = updatedInterface.getApplicationModules();
            if (applicationModules != null && !applicationModules.isEmpty()) {
                for (String moduleId : applicationModules) {
                    AppModuleResource appModuleResource = new AppModuleResource();
                    moduleMappingResource = new AppModuleMappingAppCatalogResourceAppCat();
                    ids = new HashMap();
                    ids.put("moduleID", moduleId);
                    ids.put("interfaceID", interfaceId);
                    AppModuleMappingAppCatalogResourceAppCat existingMapping = !moduleMappingResource.isExists(ids) ? new AppModuleMappingAppCatalogResourceAppCat() : (AppModuleMappingAppCatalogResourceAppCat)moduleMappingResource.get(ids);
                    existingMapping.setInterfaceId(interfaceId);
                    existingMapping.setModuleId(moduleId);
                    existingMapping.setModuleResource((AppModuleResource)appModuleResource.get(moduleId));
                    existingMapping.setAppInterfaceResource(existingInterface);
                    existingMapping.save();
                }
            }
            ApplicationInputResource inputResource = new ApplicationInputResource();
            ids = new HashMap();
            ids.put("interfaceID", interfaceId);
            inputResource.remove(ids);
            List applicationInputs = updatedInterface.getApplicationInputs();
            if (applicationInputs != null && !applicationInputs.isEmpty()) {
                for (InputDataObjectType input : applicationInputs) {
                    inputResource = new ApplicationInputResource();
                    ids = new HashMap();
                    ids.put("interfaceID", interfaceId);
                    ids.put("inputKey", input.getName());
                    if (inputResource.isExists(ids)) {
                        inputResource = (ApplicationInputResource)inputResource.get(ids);
                    }
                    inputResource.setAppInterfaceResource(existingInterface);
                    inputResource.setInterfaceID(interfaceId);
                    inputResource.setUserFriendlyDesc(input.getUserFriendlyDescription());
                    inputResource.setInputKey(input.getName());
                    inputResource.setInputVal(input.getValue());
                    inputResource.setDataType(input.getType().toString());
                    inputResource.setMetadata(input.getMetaData());
                    inputResource.setStandardInput(input.isStandardInput());
                    inputResource.setAppArgument(input.getApplicationArgument());
                    inputResource.setInputOrder(input.getInputOrder());
                    inputResource.setRequired(input.isIsRequired());
                    inputResource.setRequiredToCMD(input.isRequiredToAddedToCommandLine());
                    inputResource.setDataStaged(input.isDataStaged());
                    inputResource.setIsReadOnly(input.isIsReadOnly());
                    inputResource.save();
                }
            }
            ApplicationOutputResource outputResource = new ApplicationOutputResource();
            ids = new HashMap();
            ids.put("interfaceID", interfaceId);
            outputResource.remove(ids);
            List applicationOutputs = updatedInterface.getApplicationOutputs();
            if (applicationOutputs != null && !applicationOutputs.isEmpty()) {
                for (OutputDataObjectType output : applicationOutputs) {
                    outputResource = new ApplicationOutputResource();
                    ids = new HashMap();
                    ids.put("interfaceID", interfaceId);
                    ids.put("outputKey", output.getName());
                    if (outputResource.isExists(ids)) {
                        outputResource = (ApplicationOutputResource)outputResource.get(ids);
                    }
                    outputResource.setInterfaceID(interfaceId);
                    outputResource.setAppInterfaceResource(existingInterface);
                    outputResource.setOutputKey(output.getName());
                    outputResource.setOutputVal(output.getValue());
                    outputResource.setDataType(output.getType().toString());
                    outputResource.setRequired(output.isIsRequired());
                    outputResource.setRequiredToCMD(output.isRequiredToAddedToCommandLine());
                    outputResource.setDataMovement(output.isDataMovement());
                    outputResource.setDataNameLocation(output.getLocation());
                    outputResource.setAppArgument(output.getApplicationArgument());
                    outputResource.setSearchQuery(output.getSearchQuery());
                    outputResource.setOutputStreaming(output.isOutputStreaming());
                    outputResource.save();
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while updating application interface " + interfaceId, (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public ApplicationModule getApplicationModule(String moduleId) throws AppCatalogException {
        try {
            AppModuleResource appModuleResource = new AppModuleResource();
            return AppCatalogThriftConversion.getApplicationModuleDesc((AppModuleResource)appModuleResource.get(moduleId));
        }
        catch (Exception e) {
            logger.error("Error while retrieving application module " + moduleId, (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public ApplicationInterfaceDescription getApplicationInterface(String interfaceId) throws AppCatalogException {
        try {
            AppInterfaceResource interfaceResource = new AppInterfaceResource();
            return AppCatalogThriftConversion.getApplicationInterfaceDescription((AppInterfaceResource)interfaceResource.get(interfaceId));
        }
        catch (Exception e) {
            logger.error("Error while retrieving application interface '" + interfaceId, (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public List<ApplicationModule> getApplicationModules(Map<String, String> filters) throws AppCatalogException {
        List<ApplicationModule> modules = new ArrayList<ApplicationModule>();
        try {
            AppModuleResource resource = new AppModuleResource();
            for (String fieldName : filters.keySet()) {
                if (fieldName.equals("moduleName")) {
                    List<AppCatalogResource> resources = resource.get("moduleName", filters.get(fieldName));
                    if (resources == null || resources.isEmpty()) continue;
                    modules = AppCatalogThriftConversion.getAppModules(resources);
                    continue;
                }
                logger.error("Unsupported field name for app module.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for app module.");
            }
        }
        catch (Exception e) {
            logger.error("Error while retrieving app module list...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        return modules;
    }

    public List<ApplicationModule> getAllApplicationModules(String gatewayId) throws AppCatalogException {
        List<ApplicationModule> applicationModules = new ArrayList<ApplicationModule>();
        try {
            AppModuleResource resource = new AppModuleResource();
            resource.setGatewayId(gatewayId);
            List<AppCatalogResource> resources = resource.getAll();
            if (resources != null && !resources.isEmpty()) {
                applicationModules = AppCatalogThriftConversion.getAppModules(resources);
            }
        }
        catch (Exception e) {
            logger.error("Error while retrieving compute resource list...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        return applicationModules;
    }

    public List<ApplicationInterfaceDescription> getApplicationInterfaces(Map<String, String> filters) throws AppCatalogException {
        List<ApplicationInterfaceDescription> appInterfaces = new ArrayList<ApplicationInterfaceDescription>();
        try {
            AppInterfaceResource resource = new AppInterfaceResource();
            for (String fieldName : filters.keySet()) {
                if (fieldName.equals("appName")) {
                    List<AppCatalogResource> resources = resource.get("appName", filters.get(fieldName));
                    appInterfaces = AppCatalogThriftConversion.getAppInterfaceDescList(resources);
                    continue;
                }
                logger.error("Unsupported field name for app interface.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name '" + fieldName + "' for app interface.");
            }
        }
        catch (Exception e) {
            logger.error("Error while retrieving app interface list...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        return appInterfaces;
    }

    public List<ApplicationInterfaceDescription> getAllApplicationInterfaces(String gatewayId) throws AppCatalogException {
        try {
            AppInterfaceResource resource = new AppInterfaceResource();
            resource.setGatewayId(gatewayId);
            List<AppCatalogResource> resources = resource.getAll();
            return AppCatalogThriftConversion.getAppInterfaceDescList(resources);
        }
        catch (Exception e) {
            logger.error("Error while retrieving app interface list...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public List<String> getAllApplicationInterfaceIds() throws AppCatalogException {
        try {
            AppInterfaceResource resource = new AppInterfaceResource();
            return resource.getAllIds();
        }
        catch (Exception e) {
            logger.error("Error while retrieving app interface list...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public boolean removeApplicationInterface(String interfaceId) throws AppCatalogException {
        try {
            AppInterfaceResource resource = new AppInterfaceResource();
            resource.remove(interfaceId);
            return true;
        }
        catch (Exception e) {
            logger.error("Error while removing app interface " + interfaceId, (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public boolean removeApplicationModule(String moduleId) throws AppCatalogException {
        try {
            AppModuleResource resource = new AppModuleResource();
            resource.remove(moduleId);
            return true;
        }
        catch (Exception e) {
            logger.error("Error while removing app module " + moduleId, (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public boolean isApplicationInterfaceExists(String interfaceId) throws AppCatalogException {
        try {
            AppInterfaceResource resource = new AppInterfaceResource();
            return resource.isExists(interfaceId);
        }
        catch (Exception e) {
            logger.error("Error while checking app interface existence " + interfaceId, (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public boolean isApplicationModuleExists(String moduleId) throws AppCatalogException {
        try {
            AppModuleResource resource = new AppModuleResource();
            return resource.isExists(moduleId);
        }
        catch (Exception e) {
            logger.error("Error while checking app module existence " + moduleId, (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public List<InputDataObjectType> getApplicationInputs(String interfaceId) throws AppCatalogException {
        try {
            ApplicationInputResource resource = new ApplicationInputResource();
            List<AppCatalogResource> resources = resource.get("interfaceID", interfaceId);
            return AppCatalogThriftConversion.getAppInputs(resources);
        }
        catch (Exception e) {
            logger.error("Error while retrieving app inputs for application " + interfaceId, (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public List<OutputDataObjectType> getApplicationOutputs(String interfaceId) throws AppCatalogException {
        try {
            ApplicationOutputResource resource = new ApplicationOutputResource();
            List<AppCatalogResource> resources = resource.get("interfaceID", interfaceId);
            return AppCatalogThriftConversion.getAppOutputs(resources);
        }
        catch (Exception e) {
            logger.error("Error while retrieving app outputs for application " + interfaceId, (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }
}

