/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.experiment.catalog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceUnit;
import javax.persistence.Query;
import org.apache.airavata.registry.core.experiment.catalog.ExperimentCatResource;
import org.apache.airavata.registry.core.experiment.catalog.ResourceType;
import org.apache.airavata.registry.core.experiment.catalog.model.Gateway;
import org.apache.airavata.registry.core.experiment.catalog.model.GatewayWorker;
import org.apache.airavata.registry.core.experiment.catalog.model.GatewayWorkerPK;
import org.apache.airavata.registry.core.experiment.catalog.model.UserPK;
import org.apache.airavata.registry.core.experiment.catalog.model.Users;
import org.apache.airavata.registry.core.experiment.catalog.resources.GatewayResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.UserResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.Utils;
import org.apache.airavata.registry.core.experiment.catalog.resources.WorkerResource;
import org.apache.airavata.registry.core.experiment.catalog.utils.QueryGenerator;
import org.apache.airavata.registry.cpi.ExperimentCatalogException;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpCatResourceUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExpCatResourceUtils.class);
    private static final String PERSISTENCE_UNIT_NAME = "experiment_data";
    @PersistenceUnit(unitName="experiment_data")
    protected static EntityManagerFactory expCatFactory;

    public static EntityManager getEntityManager() throws ExperimentCatalogException {
        if (expCatFactory == null) {
            String connectionProperties = "DriverClassName=" + Utils.getJDBCDriver() + ",Url=" + Utils.getJDBCURL() + "?autoReconnect=true,Username=" + Utils.getJDBCUser() + ",Password=" + Utils.getJDBCPassword() + ",validationQuery=" + Utils.getValidationQuery();
            System.out.println(connectionProperties);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("openjpa.ConnectionDriverName", "org.apache.commons.dbcp.BasicDataSource");
            properties.put("openjpa.ConnectionProperties", connectionProperties);
            properties.put("openjpa.DynamicEnhancementAgent", "true");
            properties.put("openjpa.RuntimeUnenhancedClasses", "unsupported");
            properties.put("openjpa.RemoteCommitProvider", "sjvm");
            properties.put("openjpa.Log", "DefaultLevel=INFO, Runtime=INFO, Tool=INFO, SQL=INFO");
            properties.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true)");
            properties.put("openjpa.ConnectionFactoryProperties", "PrettyPrint=true, PrettyPrintLineLength=72, PrintParameters=true, MaxActive=10, MaxIdle=5, MinIdle=2, MaxWait=31536000,  autoReconnect=true");
            if (expCatFactory == null) {
                expCatFactory = Persistence.createEntityManagerFactory((String)PERSISTENCE_UNIT_NAME, properties);
            }
        }
        EntityManager expCatEntityManager = expCatFactory.createEntityManager();
        return expCatEntityManager;
    }

    public static ExperimentCatResource createGateway(String gatewayId) throws RegistryException {
        if (!ExpCatResourceUtils.isGatewayExist(gatewayId)) {
            GatewayResource gatewayResource = new GatewayResource();
            gatewayResource.setGatewayId(gatewayId);
            return gatewayResource;
        }
        return ExpCatResourceUtils.getGateway(gatewayId);
    }

    public static UserResource createUser(String username, String password, String gatewayId) throws RegistryException {
        if (!ExpCatResourceUtils.isUserExist(username, gatewayId)) {
            UserResource userResource = new UserResource();
            userResource.setUserName(username);
            userResource.setPassword(password);
            userResource.setGatewayId(gatewayId);
            return userResource;
        }
        return (UserResource)ExpCatResourceUtils.getUser(username, gatewayId);
    }

    public static ExperimentCatResource getGateway(String gatewayId) throws RegistryException {
        EntityManager em = null;
        try {
            if (ExpCatResourceUtils.isGatewayExist(gatewayId)) {
                em = ExpCatResourceUtils.getEntityManager();
                Gateway gateway = (Gateway)em.find(Gateway.class, (Object)gatewayId);
                GatewayResource gatewayResource = (GatewayResource)Utils.getResource(ResourceType.GATEWAY, gateway);
                em.close();
                GatewayResource gatewayResource2 = gatewayResource;
                return gatewayResource2;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return null;
    }

    public static void addUser(String userName, String password, String gatewayId) throws RegistryException {
        UserResource resource = new UserResource();
        resource.setUserName(userName);
        resource.setPassword(password);
        resource.setGatewayId(gatewayId);
        resource.save();
    }

    public static boolean isUserExist(String username, String gatewayId) throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            QueryGenerator generator = new QueryGenerator("Users", new Object[0][]);
            generator.setParameter("userName", username);
            generator.setParameter("gatewayId", gatewayId);
            Query q = generator.selectQuery(em);
            int size = q.getResultList().size();
            em.getTransaction().commit();
            em.close();
            boolean bl = size > 0;
            return bl;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public static ExperimentCatResource getUser(String userName, String gatewayId) throws RegistryException {
        EntityManager em = null;
        try {
            if (ExpCatResourceUtils.isUserExist(userName, gatewayId)) {
                em = ExpCatResourceUtils.getEntityManager();
                UserPK userPK = new UserPK();
                userPK.setUserName(userName);
                userPK.setGatewayId(gatewayId);
                Users user = (Users)em.find(Users.class, (Object)userPK);
                UserResource userResource = (UserResource)Utils.getResource(ResourceType.USER, user);
                em.close();
                UserResource userResource2 = userResource;
                return userResource2;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return null;
    }

    public static ExperimentCatResource getWorker(String gatewayId, String userName) throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            GatewayWorkerPK gatewayWorkerPK = new GatewayWorkerPK();
            gatewayWorkerPK.setGatewayId(gatewayId);
            gatewayWorkerPK.setUserName(userName);
            GatewayWorker gatewayWorker = (GatewayWorker)em.find(GatewayWorker.class, (Object)gatewayWorkerPK);
            WorkerResource workerResource = (WorkerResource)Utils.getResource(ResourceType.GATEWAY_WORKER, gatewayWorker);
            em.close();
            WorkerResource workerResource2 = workerResource;
            return workerResource2;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public static boolean isGatewayExist(String gatewayId) throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            QueryGenerator generator = new QueryGenerator("Gateway", new Object[0][]);
            generator.setParameter("gatewayId", gatewayId);
            Query q = generator.selectQuery(em);
            int size = q.getResultList().size();
            em.getTransaction().commit();
            em.close();
            boolean bl = size > 0;
            return bl;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public static List<ExperimentCatResource> getAllGateways() throws RegistryException {
        ArrayList<ExperimentCatResource> resourceList = new ArrayList<ExperimentCatResource>();
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            QueryGenerator generator = new QueryGenerator("Gateway", new Object[0][]);
            Query q = generator.selectQuery(em);
            List results = q.getResultList();
            if (results.size() != 0) {
                for (Object result : results) {
                    Gateway gateway = (Gateway)result;
                    GatewayResource gatewayResource = (GatewayResource)Utils.getResource(ResourceType.GATEWAY, gateway);
                    resourceList.add(gatewayResource);
                }
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return resourceList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeGateway(String gatewayId) {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            QueryGenerator generator = new QueryGenerator("Gateway", new Object[0][]);
            generator.setParameter("gatewayId", gatewayId);
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            em.close();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public static WorkerResource addGatewayWorker(GatewayResource gatewayResource, UserResource userResource) throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            if (!ExpCatResourceUtils.isGatewayExist(gatewayResource.getGatewayName())) {
                gatewayResource.save();
            }
            if (!ExpCatResourceUtils.isUserExist(userResource.getUserName(), gatewayResource.getGatewayId())) {
                userResource.save();
            }
            Gateway gateway = (Gateway)em.find(Gateway.class, (Object)gatewayResource.getGatewayId());
            GatewayWorker gatewayWorker = new GatewayWorker();
            gatewayWorker.setGateway(gateway);
            gatewayWorker.setUserName(userResource.getUserName());
            em.persist((Object)gatewayWorker);
            em.getTransaction().commit();
            em.close();
            WorkerResource workerResource = (WorkerResource)Utils.getResource(ResourceType.GATEWAY_WORKER, gatewayWorker);
            return workerResource;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeGatewayWorker(GatewayResource gatewayResource, UserResource userResource) {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            QueryGenerator generator = new QueryGenerator("GatewayWorker", new Object[0][]);
            generator.setParameter("gatewayId", gatewayResource.getGatewayName());
            generator.setParameter("userName", userResource.getUserName());
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            em.close();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public static List<String> getAllUsersInGateway(String gatewayId) throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            QueryGenerator generator = new QueryGenerator("Users", new Object[0][]);
            generator.setParameter("gatewayId", gatewayId);
            Query q = generator.selectQuery(em);
            List users = q.getResultList();
            em.getTransaction().commit();
            em.close();
            ArrayList<String> usernameList = new ArrayList<String>();
            if (users != null) {
                for (int i = 0; i < users.size(); ++i) {
                    usernameList.add(((Users)users.get(i)).getUserName());
                }
            }
            ArrayList<String> arrayList = usernameList;
            return arrayList;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

