/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.experiment.catalog.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.model.commons.ErrorModel;
import org.apache.airavata.model.experiment.ExperimentModel;
import org.apache.airavata.model.experiment.ExperimentSummaryModel;
import org.apache.airavata.model.experiment.UserConfigurationDataModel;
import org.apache.airavata.model.job.JobModel;
import org.apache.airavata.model.process.ProcessModel;
import org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel;
import org.apache.airavata.model.status.ExperimentStatus;
import org.apache.airavata.model.status.JobStatus;
import org.apache.airavata.model.status.ProcessStatus;
import org.apache.airavata.model.status.QueueStatusModel;
import org.apache.airavata.model.status.TaskStatus;
import org.apache.airavata.model.task.TaskModel;
import org.apache.airavata.model.workspace.Gateway;
import org.apache.airavata.model.workspace.Notification;
import org.apache.airavata.model.workspace.Project;
import org.apache.airavata.registry.core.experiment.catalog.ExpCatResourceUtils;
import org.apache.airavata.registry.core.experiment.catalog.impl.ExperimentRegistry;
import org.apache.airavata.registry.core.experiment.catalog.impl.GatewayRegistry;
import org.apache.airavata.registry.core.experiment.catalog.impl.NotificationRegistry;
import org.apache.airavata.registry.core.experiment.catalog.impl.ProjectRegistry;
import org.apache.airavata.registry.core.experiment.catalog.resources.GatewayResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.UserResource;
import org.apache.airavata.registry.cpi.CompositeIdentifier;
import org.apache.airavata.registry.cpi.ExpCatChildDataType;
import org.apache.airavata.registry.cpi.ExpCatParentDataType;
import org.apache.airavata.registry.cpi.ExperimentCatalog;
import org.apache.airavata.registry.cpi.ExperimentCatalogModelType;
import org.apache.airavata.registry.cpi.RegistryException;
import org.apache.airavata.registry.cpi.ResultOrderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentCatalogImpl
implements ExperimentCatalog {
    private GatewayResource gatewayResource;
    private UserResource user;
    private static final Logger logger = LoggerFactory.getLogger(ExperimentCatalogImpl.class);
    private ExperimentRegistry experimentRegistry = null;
    private ProjectRegistry projectRegistry = null;
    private GatewayRegistry gatewayRegistry = null;
    private NotificationRegistry notificationRegistry = null;

    public ExperimentCatalogImpl() throws RegistryException {
        try {
            if (!ExpCatResourceUtils.isGatewayExist(ServerSettings.getDefaultUserGateway())) {
                this.gatewayResource = (GatewayResource)ExpCatResourceUtils.createGateway(ServerSettings.getDefaultUserGateway());
                this.gatewayResource.setGatewayName(ServerSettings.getDefaultUserGateway());
                this.gatewayResource.save();
            } else {
                this.gatewayResource = (GatewayResource)ExpCatResourceUtils.getGateway(ServerSettings.getDefaultUserGateway());
            }
            if (!ExpCatResourceUtils.isUserExist(ServerSettings.getDefaultUser(), ServerSettings.getDefaultUserGateway())) {
                this.user = ExpCatResourceUtils.createUser(ServerSettings.getDefaultUser(), ServerSettings.getDefaultUserPassword(), ServerSettings.getDefaultUserGateway());
                this.user.save();
            } else {
                this.user = (UserResource)ExpCatResourceUtils.getUser(ServerSettings.getDefaultUser(), ServerSettings.getDefaultUserGateway());
            }
            this.experimentRegistry = new ExperimentRegistry(this.gatewayResource, this.user);
            this.projectRegistry = new ProjectRegistry(this.gatewayResource, this.user);
            this.gatewayRegistry = new GatewayRegistry();
            this.notificationRegistry = new NotificationRegistry();
        }
        catch (ApplicationSettingsException e) {
            logger.error("Unable to read airavata server properties..", (Throwable)e);
            throw new RegistryException("Unable to read airavata server properties..", (Throwable)e);
        }
    }

    public ExperimentCatalogImpl(String gateway, String username, String password) throws RegistryException {
        if (!ExpCatResourceUtils.isGatewayExist(gateway)) {
            this.gatewayResource = (GatewayResource)ExpCatResourceUtils.createGateway(gateway);
            this.gatewayResource.setGatewayName(gateway);
            this.gatewayResource.save();
        } else {
            this.gatewayResource = (GatewayResource)ExpCatResourceUtils.getGateway(gateway);
        }
        if (!ExpCatResourceUtils.isUserExist(username, this.gatewayResource.getGatewayId())) {
            this.user = ExpCatResourceUtils.createUser(username, password, gateway);
            this.user.save();
        } else {
            this.user = (UserResource)ExpCatResourceUtils.getUser(username, gateway);
        }
        this.experimentRegistry = new ExperimentRegistry(this.gatewayResource, this.user);
        this.projectRegistry = new ProjectRegistry(this.gatewayResource, this.user);
        this.gatewayRegistry = new GatewayRegistry();
        this.notificationRegistry = new NotificationRegistry();
    }

    public Object add(ExpCatParentDataType dataType, Object newObjectToAdd, String gatewayId) throws RegistryException {
        try {
            switch (dataType) {
                case PROJECT: {
                    return this.projectRegistry.addProject((Project)newObjectToAdd, gatewayId);
                }
                case EXPERIMENT: {
                    return this.experimentRegistry.addExperiment((ExperimentModel)newObjectToAdd);
                }
                case GATEWAY: {
                    return this.gatewayRegistry.addGateway((Gateway)newObjectToAdd);
                }
                case NOTIFICATION: {
                    return this.notificationRegistry.createNotification((Notification)newObjectToAdd);
                }
                case QUEUE_STATUS: {
                    return this.experimentRegistry.createQueueStatuses((List)newObjectToAdd);
                }
            }
            logger.error("Unsupported top level type..", (Throwable)new UnsupportedOperationException());
            throw new UnsupportedOperationException();
        }
        catch (Exception e) {
            logger.error("Error while adding the resource " + dataType.toString(), (Throwable)new RegistryException((Throwable)e));
            throw new RegistryException("Error while adding the resource " + dataType.toString(), (Throwable)e);
        }
    }

    public Object add(ExpCatChildDataType dataType, Object newObjectToAdd, Object dependentIdentifier) throws RegistryException {
        try {
            switch (dataType) {
                case USER_CONFIGURATION_DATA: {
                    return this.experimentRegistry.addUserConfigData((UserConfigurationDataModel)newObjectToAdd, (String)dependentIdentifier);
                }
                case EXPERIMENT_INPUT: {
                    return this.experimentRegistry.addExpInputs((List)newObjectToAdd, (String)dependentIdentifier);
                }
                case EXPERIMENT_OUTPUT: {
                    return this.experimentRegistry.addExpOutputs((List)newObjectToAdd, (String)dependentIdentifier);
                }
                case EXPERIMENT_STATUS: {
                    return this.experimentRegistry.addExperimentStatus((ExperimentStatus)newObjectToAdd, (String)dependentIdentifier);
                }
                case EXPERIMENT_ERROR: {
                    return this.experimentRegistry.addExperimentError((ErrorModel)newObjectToAdd, (String)dependentIdentifier);
                }
                case PROCESS: {
                    return this.experimentRegistry.addProcess((ProcessModel)newObjectToAdd, (String)dependentIdentifier);
                }
                case PROCESS_RESOURCE_SCHEDULE: {
                    return this.experimentRegistry.addProcessResourceSchedule((ComputationalResourceSchedulingModel)newObjectToAdd, (String)dependentIdentifier);
                }
                case PROCESS_INPUT: {
                    return this.experimentRegistry.addProcessInputs((List)newObjectToAdd, (String)dependentIdentifier);
                }
                case PROCESS_OUTPUT: {
                    return this.experimentRegistry.addProcessOutputs((List)newObjectToAdd, (String)dependentIdentifier);
                }
                case PROCESS_STATUS: {
                    return this.experimentRegistry.addProcessStatus((ProcessStatus)newObjectToAdd, (String)dependentIdentifier);
                }
                case PROCESS_ERROR: {
                    return this.experimentRegistry.addProcessError((ErrorModel)newObjectToAdd, (String)dependentIdentifier);
                }
                case TASK: {
                    return this.experimentRegistry.addTask((TaskModel)newObjectToAdd, (String)dependentIdentifier);
                }
                case TASK_STATUS: {
                    return this.experimentRegistry.addTaskStatus((TaskStatus)newObjectToAdd, (String)dependentIdentifier);
                }
                case TASK_ERROR: {
                    return this.experimentRegistry.addTaskError((ErrorModel)newObjectToAdd, (String)dependentIdentifier);
                }
                case JOB: {
                    return this.experimentRegistry.addJob((JobModel)newObjectToAdd, (String)dependentIdentifier);
                }
                case JOB_STATUS: {
                    return this.experimentRegistry.addJobStatus((JobStatus)newObjectToAdd, (CompositeIdentifier)dependentIdentifier);
                }
            }
            logger.error("Unsupported dependent data type...", (Throwable)new UnsupportedOperationException());
            throw new UnsupportedOperationException();
        }
        catch (Exception e) {
            logger.error("Error while adding " + dataType.toString(), (Throwable)new RegistryException((Throwable)e));
            throw new RegistryException("Error while adding " + dataType.toString(), (Throwable)e);
        }
    }

    public void update(ExperimentCatalogModelType dataType, Object newObjectToUpdate, Object identifier) throws RegistryException {
        try {
            switch (dataType) {
                case PROJECT: {
                    this.projectRegistry.updateProject((Project)newObjectToUpdate, (String)identifier);
                    break;
                }
                case GATEWAY: {
                    this.gatewayRegistry.updateGateway((String)identifier, (Gateway)newObjectToUpdate);
                    break;
                }
                case NOTIFICATION: {
                    this.notificationRegistry.updateNotification((Notification)newObjectToUpdate);
                    break;
                }
                case EXPERIMENT: {
                    this.experimentRegistry.updateExperiment((ExperimentModel)newObjectToUpdate, (String)identifier);
                    break;
                }
                case USER_CONFIGURATION_DATA: {
                    this.experimentRegistry.updateUserConfigData((UserConfigurationDataModel)newObjectToUpdate, (String)identifier);
                    break;
                }
                case EXPERIMENT_INPUT: {
                    this.experimentRegistry.updateExpInputs((List)newObjectToUpdate, (String)identifier);
                    break;
                }
                case EXPERIMENT_OUTPUT: {
                    this.experimentRegistry.updateExpOutputs((List)newObjectToUpdate, (String)identifier);
                    break;
                }
                case EXPERIMENT_STATUS: {
                    this.experimentRegistry.updateExperimentStatus((ExperimentStatus)newObjectToUpdate, (String)identifier);
                    break;
                }
                case EXPERIMENT_ERROR: {
                    this.experimentRegistry.updateExperimentError((ErrorModel)newObjectToUpdate, (String)identifier);
                    break;
                }
                case PROCESS: {
                    this.experimentRegistry.updateProcess((ProcessModel)newObjectToUpdate, (String)identifier);
                    break;
                }
                case PROCESS_RESOURCE_SCHEDULE: {
                    this.experimentRegistry.updateProcessResourceSchedule((ComputationalResourceSchedulingModel)newObjectToUpdate, (String)identifier);
                    break;
                }
                case PROCESS_STATUS: {
                    this.experimentRegistry.updateProcessStatus((ProcessStatus)newObjectToUpdate, (String)identifier);
                    break;
                }
                case PROCESS_ERROR: {
                    this.experimentRegistry.updateProcessError((ErrorModel)newObjectToUpdate, (String)identifier);
                    break;
                }
                case TASK: {
                    this.experimentRegistry.updateTask((TaskModel)newObjectToUpdate, (String)identifier);
                    break;
                }
                case TASK_STATUS: {
                    this.experimentRegistry.updateTaskStatus((TaskStatus)newObjectToUpdate, (String)identifier);
                    break;
                }
                case TASK_ERROR: {
                    this.experimentRegistry.updateTaskError((ErrorModel)newObjectToUpdate, (String)identifier);
                    break;
                }
                case JOB: {
                    this.experimentRegistry.updateJob((JobModel)newObjectToUpdate, (CompositeIdentifier)identifier);
                    break;
                }
                case JOB_STATUS: {
                    this.experimentRegistry.updateJobStatus((JobStatus)newObjectToUpdate, (CompositeIdentifier)identifier);
                    break;
                }
                default: {
                    logger.error("Unsupported data type...", (Throwable)new UnsupportedOperationException());
                    throw new UnsupportedOperationException();
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while updating the resource " + dataType.toString(), (Throwable)new RegistryException((Throwable)e));
            throw new RegistryException("Error while updating the resource.." + dataType.toString(), (Throwable)e);
        }
    }

    public void update(ExperimentCatalogModelType dataType, Object identifier, String fieldName, Object value) throws RegistryException {
        try {
            switch (dataType) {
                case EXPERIMENT: {
                    this.experimentRegistry.updateExperimentField((String)identifier, fieldName, value);
                    break;
                }
                case USER_CONFIGURATION_DATA: {
                    this.experimentRegistry.updateUserConfigDataField((String)identifier, fieldName, value);
                    break;
                }
                default: {
                    logger.error("Unsupported data type...", (Throwable)new UnsupportedOperationException());
                    throw new UnsupportedOperationException();
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while updating the resource " + dataType.toString(), (Throwable)new RegistryException((Throwable)e));
            throw new RegistryException("Error while updating the resource " + dataType.toString(), (Throwable)e);
        }
    }

    public Object get(ExperimentCatalogModelType dataType, Object identifier) throws RegistryException {
        try {
            switch (dataType) {
                case PROJECT: {
                    return this.projectRegistry.getProject((String)identifier);
                }
                case GATEWAY: {
                    return this.gatewayRegistry.getGateway((String)identifier);
                }
                case NOTIFICATION: {
                    return this.notificationRegistry.getNotification((String)identifier);
                }
                case EXPERIMENT: {
                    return this.experimentRegistry.getExperiment((String)identifier, null);
                }
                case USER_CONFIGURATION_DATA: {
                    return this.experimentRegistry.getUserConfigData((String)identifier, null);
                }
                case EXPERIMENT_INPUT: {
                    return this.experimentRegistry.getExperimentInputs((String)identifier);
                }
                case EXPERIMENT_OUTPUT: {
                    return this.experimentRegistry.getExperimentOutputs((String)identifier);
                }
                case EXPERIMENT_STATUS: {
                    return this.experimentRegistry.getExperimentStatus((String)identifier);
                }
                case EXPERIMENT_ERROR: {
                    return this.experimentRegistry.getExperimentErrors((String)identifier);
                }
                case PROCESS: {
                    return this.experimentRegistry.getProcess((String)identifier, null);
                }
                case PROCESS_RESOURCE_SCHEDULE: {
                    return this.experimentRegistry.getProcessResourceSchedule((String)identifier);
                }
                case PROCESS_INPUT: {
                    return this.experimentRegistry.getProcessInputs((String)identifier);
                }
                case PROCESS_OUTPUT: {
                    return this.experimentRegistry.getProcessOutputs((String)identifier);
                }
                case PROCESS_STATUS: {
                    return this.experimentRegistry.getProcessStatus((String)identifier);
                }
                case PROCESS_ERROR: {
                    return this.experimentRegistry.getProcessError((String)identifier);
                }
                case TASK: {
                    return this.experimentRegistry.getTask((String)identifier, null);
                }
                case TASK_STATUS: {
                    return this.experimentRegistry.getTaskStatus((String)identifier);
                }
                case TASK_ERROR: {
                    return this.experimentRegistry.getTaskError((String)identifier);
                }
                case JOB: {
                    return this.experimentRegistry.getJob((CompositeIdentifier)identifier, null);
                }
                case JOB_STATUS: {
                    return this.experimentRegistry.getJobStatus((CompositeIdentifier)identifier);
                }
            }
            logger.error("Unsupported data type...", (Throwable)new UnsupportedOperationException());
            throw new UnsupportedOperationException();
        }
        catch (Exception e) {
            logger.error("Error while retrieving the resource " + dataType.toString(), (Throwable)new RegistryException((Throwable)e));
            throw new RegistryException("Error while retrieving the resource " + dataType.toString(), (Throwable)e);
        }
    }

    public List<Object> get(ExperimentCatalogModelType dataType, String fieldName, Object value) throws RegistryException {
        try {
            ArrayList<Object> result = new ArrayList<Object>();
            switch (dataType) {
                case PROJECT: {
                    List<Project> projectList = this.projectRegistry.getProjectList(fieldName, value);
                    for (Project project : projectList) {
                        result.add(project);
                    }
                    return result;
                }
                case GATEWAY: {
                    List<Gateway> allGateways = this.gatewayRegistry.getAllGateways();
                    for (Gateway gateway : allGateways) {
                        result.add(gateway);
                    }
                    return result;
                }
                case NOTIFICATION: {
                    List<Notification> notifications = this.notificationRegistry.getAllGatewayNotifications((String)value);
                    for (Notification n : notifications) {
                        result.add(n);
                    }
                    return result;
                }
                case EXPERIMENT: {
                    List<ExperimentModel> experimentList = this.experimentRegistry.getExperimentList(fieldName, value);
                    for (ExperimentModel experiment : experimentList) {
                        result.add(experiment);
                    }
                    return result;
                }
                case PROCESS: {
                    List<ProcessModel> processList = this.experimentRegistry.getProcessList(fieldName, value);
                    for (ProcessModel process : processList) {
                        result.add(process);
                    }
                    return result;
                }
                case TASK: {
                    List<TaskModel> taskList = this.experimentRegistry.getTaskList(fieldName, value);
                    for (TaskModel task : taskList) {
                        result.add(task);
                    }
                    return result;
                }
                case JOB: {
                    List<JobModel> jobList = this.experimentRegistry.getJobList(fieldName, value);
                    for (JobModel task : jobList) {
                        result.add(task);
                    }
                    return result;
                }
            }
            logger.error("Unsupported data type...", (Throwable)new UnsupportedOperationException());
            throw new UnsupportedOperationException();
        }
        catch (Exception e) {
            logger.error("Error while retrieving the resource " + dataType.toString(), (Throwable)new RegistryException((Throwable)e));
            throw new RegistryException("Error while retrieving the resource " + dataType.toString(), (Throwable)e);
        }
    }

    public List<Object> get(ExperimentCatalogModelType dataType, String fieldName, Object value, int limit, int offset, Object orderByIdentifier, ResultOrderType resultOrderType) throws RegistryException {
        try {
            ArrayList<Object> result = new ArrayList<Object>();
            switch (dataType) {
                case PROJECT: {
                    List<Project> projectList = this.projectRegistry.getProjectList(fieldName, value, limit, offset, orderByIdentifier, resultOrderType);
                    result.addAll(projectList.stream().collect(Collectors.toList()));
                    return result;
                }
                case EXPERIMENT: {
                    List<ExperimentModel> experimentList = this.experimentRegistry.getExperimentList(fieldName, value, limit, offset, orderByIdentifier, resultOrderType);
                    result.addAll(experimentList.stream().collect(Collectors.toList()));
                    return result;
                }
                case QUEUE_STATUS: {
                    List<QueueStatusModel> queueStatusModelsList = this.experimentRegistry.getLatestQueueStatuses();
                    result.addAll(queueStatusModelsList.stream().collect(Collectors.toList()));
                    return result;
                }
            }
            logger.error("Unsupported data type...", (Throwable)new UnsupportedOperationException());
            throw new UnsupportedOperationException();
        }
        catch (Exception e) {
            logger.error("Error while retrieving the resource " + dataType.toString(), (Throwable)new RegistryException((Throwable)e));
            throw new RegistryException("Error while retrieving the resource " + dataType.toString(), (Throwable)e);
        }
    }

    public List<Object> search(ExperimentCatalogModelType dataType, Map<String, String> filters) throws RegistryException {
        return this.search(dataType, filters, -1, -1, null, null);
    }

    public List<Object> search(ExperimentCatalogModelType dataType, Map<String, String> filters, int limit, int offset, Object orderByIdentifier, ResultOrderType resultOrderType) throws RegistryException {
        try {
            ArrayList<Object> result = new ArrayList<Object>();
            switch (dataType) {
                case PROJECT: {
                    List<Project> projectList = this.projectRegistry.searchProjects(filters, limit, offset, orderByIdentifier, resultOrderType);
                    for (Project project : projectList) {
                        result.add(project);
                    }
                    return result;
                }
                case EXPERIMENT: {
                    List<ExperimentSummaryModel> experimentSummaries = this.experimentRegistry.searchExperiments(filters, limit, offset, orderByIdentifier, resultOrderType);
                    for (ExperimentSummaryModel ex : experimentSummaries) {
                        result.add(ex);
                    }
                    return result;
                }
                case EXPERIMENT_STATISTICS: {
                    result.add(this.experimentRegistry.getExperimentStatistics(filters));
                    return result;
                }
            }
            logger.error("Unsupported data type...", (Throwable)new UnsupportedOperationException());
            throw new UnsupportedOperationException();
        }
        catch (Exception e) {
            logger.error("Error while retrieving the resource " + dataType.toString(), (Throwable)new RegistryException((Throwable)e));
            throw new RegistryException("Error while retrieving the resource " + dataType.toString(), (Throwable)e);
        }
    }

    public List<Object> searchAllAccessible(ExperimentCatalogModelType dataType, List<String> accessibleIds, Map<String, String> filters, int limit, int offset, Object orderByIdentifier, ResultOrderType resultOrderType) throws RegistryException {
        try {
            ArrayList<Object> result = new ArrayList<Object>();
            switch (dataType) {
                case PROJECT: {
                    List<Project> projectList = this.projectRegistry.searchAllAccessibleProjects(accessibleIds, filters, limit, offset, orderByIdentifier, resultOrderType);
                    for (Project project : projectList) {
                        result.add(project);
                    }
                    return result;
                }
                case EXPERIMENT: {
                    List<ExperimentSummaryModel> experimentSummaries = this.experimentRegistry.searchAllAccessibleExperiments(accessibleIds, filters, limit, offset, orderByIdentifier, resultOrderType);
                    for (ExperimentSummaryModel ex : experimentSummaries) {
                        result.add(ex);
                    }
                    return result;
                }
            }
            logger.error("Unsupported data type...", (Throwable)new UnsupportedOperationException());
            throw new UnsupportedOperationException();
        }
        catch (Exception e) {
            logger.error("Error while retrieving the resource " + dataType.toString(), (Throwable)new RegistryException((Throwable)e));
            throw new RegistryException("Error while retrieving the resource " + dataType.toString(), (Throwable)e);
        }
    }

    public Object getValue(ExperimentCatalogModelType dataType, Object identifier, String field) throws RegistryException {
        try {
            switch (dataType) {
                case EXPERIMENT: {
                    return this.experimentRegistry.getExperiment((String)identifier, field);
                }
                case USER_CONFIGURATION_DATA: {
                    return this.experimentRegistry.getUserConfigData((String)identifier, field);
                }
            }
            logger.error("Unsupported data type...", (Throwable)new UnsupportedOperationException());
            throw new UnsupportedOperationException();
        }
        catch (Exception e) {
            logger.error("Error while retrieving the resource " + dataType.toString(), (Throwable)new RegistryException((Throwable)e));
            throw new RegistryException("Error while retrieving the resource " + dataType.toString(), (Throwable)e);
        }
    }

    public List<String> getIds(ExperimentCatalogModelType dataType, String fieldName, Object value) throws RegistryException {
        try {
            switch (dataType) {
                case PROJECT: {
                    return this.projectRegistry.getProjectIDs(fieldName, value);
                }
                case EXPERIMENT: {
                    return this.experimentRegistry.getExperimentIDs(fieldName, value);
                }
                case PROCESS: {
                    return this.experimentRegistry.getProcessIds(fieldName, value);
                }
                case TASK: {
                    return this.experimentRegistry.getTaskIds(fieldName, value);
                }
                case JOB: {
                    return this.experimentRegistry.getJobIds(fieldName, value);
                }
            }
            logger.error("Unsupported data type...", (Throwable)new UnsupportedOperationException());
            throw new UnsupportedOperationException();
        }
        catch (Exception e) {
            logger.error("Error while retrieving the ids for" + dataType.toString(), (Throwable)new RegistryException((Throwable)e));
            throw new RegistryException("Error while retrieving the ids for " + dataType.toString(), (Throwable)e);
        }
    }

    public void remove(ExperimentCatalogModelType dataType, Object identifier) throws RegistryException {
        try {
            switch (dataType) {
                case PROJECT: {
                    this.projectRegistry.removeProject((String)identifier);
                    break;
                }
                case GATEWAY: {
                    this.gatewayRegistry.removeGateway((String)identifier);
                    break;
                }
                case NOTIFICATION: {
                    this.notificationRegistry.deleteNotification((String)identifier);
                    break;
                }
                case EXPERIMENT: {
                    this.experimentRegistry.removeExperiment((String)identifier);
                    break;
                }
                case USER_CONFIGURATION_DATA: {
                    this.experimentRegistry.removeUserConfigData((String)identifier);
                    break;
                }
                case PROCESS: {
                    this.experimentRegistry.removeProcess((String)identifier);
                    break;
                }
                case PROCESS_RESOURCE_SCHEDULE: {
                    this.experimentRegistry.removeProcessResourceSchedule((String)identifier);
                    break;
                }
                case TASK: {
                    this.experimentRegistry.removeTask((String)identifier);
                    break;
                }
                case JOB: {
                    this.experimentRegistry.removeJob((CompositeIdentifier)identifier);
                    break;
                }
                default: {
                    logger.error("Unsupported data type...", (Throwable)new UnsupportedOperationException());
                    throw new UnsupportedOperationException();
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while removing the resource " + dataType.toString(), (Throwable)new RegistryException((Throwable)e));
            throw new RegistryException("Error while removing the resource " + dataType.toString(), (Throwable)e);
        }
    }

    public boolean isExist(ExperimentCatalogModelType dataType, Object identifier) throws RegistryException {
        try {
            switch (dataType) {
                case PROJECT: {
                    return this.projectRegistry.isProjectExist((String)identifier);
                }
                case GATEWAY: {
                    return this.gatewayRegistry.isGatewayExist((String)identifier);
                }
                case EXPERIMENT: {
                    return this.experimentRegistry.isExperimentExist((String)identifier);
                }
                case USER_CONFIGURATION_DATA: {
                    return this.experimentRegistry.isUserConfigDataExist((String)identifier);
                }
                case PROCESS: {
                    return this.experimentRegistry.isProcessExist((String)identifier);
                }
                case PROCESS_RESOURCE_SCHEDULE: {
                    return this.experimentRegistry.isProcessResourceScheduleExist((String)identifier);
                }
                case TASK: {
                    return this.experimentRegistry.isTaskExist((String)identifier);
                }
                case JOB: {
                    return this.experimentRegistry.isJobExist((CompositeIdentifier)identifier);
                }
            }
            logger.error("Unsupported data type...", (Throwable)new UnsupportedOperationException());
            throw new UnsupportedOperationException();
        }
        catch (Exception e) {
            logger.error("Error while checking existence of the resource " + dataType.toString(), (Throwable)new RegistryException((Throwable)e));
            throw new RegistryException("Error while checking existence of the resource " + dataType.toString(), (Throwable)e);
        }
    }
}

