/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.experiment.catalog.model;

import java.sql.Timestamp;
import java.util.Collection;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.apache.airavata.registry.core.experiment.catalog.model.Experiment;
import org.apache.airavata.registry.core.experiment.catalog.model.ProcessError;
import org.apache.airavata.registry.core.experiment.catalog.model.ProcessInput;
import org.apache.airavata.registry.core.experiment.catalog.model.ProcessOutput;
import org.apache.airavata.registry.core.experiment.catalog.model.ProcessResourceSchedule;
import org.apache.airavata.registry.core.experiment.catalog.model.ProcessStatus;
import org.apache.airavata.registry.core.experiment.catalog.model.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="PROCESS")
public class Process {
    private static final Logger logger = LoggerFactory.getLogger(Process.class);
    private String processId;
    private String experimentId;
    private Timestamp creationTime;
    private Timestamp lastUpdateTime;
    private String processDetail;
    private String applicationInterfaceId;
    private String taskDag;
    private String applicationDeploymentId;
    private String computeResourceId;
    private String gatewayExecutionId;
    private boolean enableEmailNotification;
    private String emailAddresses;
    private String storageId;
    private String experimentDataDir;
    private String userName;
    private Experiment experiment;
    private Collection<ProcessError> processErrors;
    private Collection<ProcessInput> processInputs;
    private Collection<ProcessOutput> processOutputs;
    private ProcessResourceSchedule processResourceSchedule;
    private Collection<ProcessStatus> processStatuses;
    private Collection<Task> tasks;
    private String userDn;
    private boolean generateCert;
    private boolean useUserCRPref;

    @Id
    @Column(name="PROCESS_ID")
    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    @Column(name="EXPERIMENT_ID")
    public String getExperimentId() {
        return this.experimentId;
    }

    public void setExperimentId(String experimentId) {
        this.experimentId = experimentId;
    }

    @Column(name="CREATION_TIME")
    public Timestamp getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Timestamp creationTime) {
        this.creationTime = creationTime;
    }

    @Column(name="LAST_UPDATE_TIME")
    public Timestamp getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Timestamp lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    @Lob
    @Column(name="PROCESS_DETAIL")
    public String getProcessDetail() {
        return this.processDetail;
    }

    public void setProcessDetail(String processDetail) {
        this.processDetail = processDetail;
    }

    @Column(name="APPLICATION_INTERFACE_ID")
    public String getApplicationInterfaceId() {
        return this.applicationInterfaceId;
    }

    public void setApplicationInterfaceId(String applicationInterfaceId) {
        this.applicationInterfaceId = applicationInterfaceId;
    }

    @Column(name="USERNAME")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Column(name="STORAGE_RESOURCE_ID")
    public String getStorageId() {
        return this.storageId;
    }

    public void setStorageId(String storageId) {
        this.storageId = storageId;
    }

    @Lob
    @Column(name="TASK_DAG")
    public String getTaskDag() {
        return this.taskDag;
    }

    public void setTaskDag(String taskDag) {
        this.taskDag = taskDag;
    }

    @Column(name="APPLICATION_DEPLOYMENT_ID")
    public String getApplicationDeploymentId() {
        return this.applicationDeploymentId;
    }

    public void setApplicationDeploymentId(String applicationDeploymentId) {
        this.applicationDeploymentId = applicationDeploymentId;
    }

    @Column(name="COMPUTE_RESOURCE_ID")
    public String getComputeResourceId() {
        return this.computeResourceId;
    }

    public void setComputeResourceId(String computeResourceId) {
        this.computeResourceId = computeResourceId;
    }

    @Column(name="GATEWAY_EXECUTION_ID")
    public String getGatewayExecutionId() {
        return this.gatewayExecutionId;
    }

    public void setGatewayExecutionId(String gatewayExecutionId) {
        this.gatewayExecutionId = gatewayExecutionId;
    }

    @Column(name="ENABLE_EMAIL_NOTIFICATION")
    public boolean getEnableEmailNotification() {
        return this.enableEmailNotification;
    }

    public void setEnableEmailNotification(boolean enableEmailNotification) {
        this.enableEmailNotification = enableEmailNotification;
    }

    @Lob
    @Column(name="EMAIL_ADDRESSES")
    public String getEmailAddresses() {
        return this.emailAddresses;
    }

    public void setEmailAddresses(String emailAddresses) {
        this.emailAddresses = emailAddresses;
    }

    @Column(name="USER_DN")
    public String getUserDn() {
        return this.userDn;
    }

    public void setUserDn(String userDn) {
        this.userDn = userDn;
    }

    @Column(name="GENERATE_CERT")
    public boolean getGenerateCert() {
        return this.generateCert;
    }

    public void setGenerateCert(boolean generateCert) {
        this.generateCert = generateCert;
    }

    @Column(name="EXPERIMENT_DATA_DIR")
    public String getExperimentDataDir() {
        return this.experimentDataDir;
    }

    public void setExperimentDataDir(String experimentDataDir) {
        this.experimentDataDir = experimentDataDir;
    }

    @ManyToOne
    @JoinColumn(name="EXPERIMENT_ID", referencedColumnName="EXPERIMENT_ID")
    public Experiment getExperiment() {
        return this.experiment;
    }

    public void setExperiment(Experiment experimentByExperimentId) {
        this.experiment = experimentByExperimentId;
    }

    @OneToMany(mappedBy="process")
    public Collection<ProcessError> getProcessErrors() {
        return this.processErrors;
    }

    public void setProcessErrors(Collection<ProcessError> processErrorsByProcessId) {
        this.processErrors = processErrorsByProcessId;
    }

    @OneToMany(mappedBy="process")
    public Collection<ProcessInput> getProcessInputs() {
        return this.processInputs;
    }

    public void setProcessInputs(Collection<ProcessInput> processInputsByProcessId) {
        this.processInputs = processInputsByProcessId;
    }

    @OneToMany(mappedBy="process")
    public Collection<ProcessOutput> getProcessOutputs() {
        return this.processOutputs;
    }

    public void setProcessOutputs(Collection<ProcessOutput> processOutputsByProcessId) {
        this.processOutputs = processOutputsByProcessId;
    }

    @OneToOne(mappedBy="process")
    public ProcessResourceSchedule getProcessResourceSchedule() {
        return this.processResourceSchedule;
    }

    public void setProcessResourceSchedule(ProcessResourceSchedule processResourceSchedulesByProcessId) {
        this.processResourceSchedule = processResourceSchedulesByProcessId;
    }

    @OneToMany(mappedBy="process")
    public Collection<ProcessStatus> getProcessStatuses() {
        return this.processStatuses;
    }

    public void setProcessStatuses(Collection<ProcessStatus> processStatusesByProcessId) {
        this.processStatuses = processStatusesByProcessId;
    }

    @OneToMany(mappedBy="process")
    public Collection<Task> getTasks() {
        return this.tasks;
    }

    public void setTasks(Collection<Task> taskByProcessId) {
        this.tasks = taskByProcessId;
    }

    @Column(name="USE_USER_CR_PREF")
    public boolean isUseUserCRPref() {
        return this.useUserCRPref;
    }

    public void setUseUserCRPref(boolean useUserCRPref) {
        this.useUserCRPref = useUserCRPref;
    }
}

