/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ascii.memcache;

import com.hazelcast.ascii.AbstractTextCommand;
import com.hazelcast.ascii.TextCommandConstants;
import com.hazelcast.ascii.memcache.Stats;
import com.hazelcast.nio.IOUtil;
import java.nio.ByteBuffer;

public class StatsCommand
extends AbstractTextCommand {
    ByteBuffer response;
    static final byte[] STAT = "STAT ".getBytes();
    static final byte[] UPTIME = "uptime ".getBytes();
    static final byte[] BYTES = "bytes ".getBytes();
    static final byte[] CMD_SET = "cmd_set ".getBytes();
    static final byte[] CMD_GET = "cmd_get ".getBytes();
    static final byte[] CMD_TOUCH = "cmd_touch ".getBytes();
    static final byte[] THREADS = "threads ".getBytes();
    static final byte[] WAITING_REQUESTS = "waiting_requests ".getBytes();
    static final byte[] GET_HITS = "get_hits ".getBytes();
    static final byte[] GET_MISSES = "get_misses ".getBytes();
    static final byte[] DELETE_HITS = "delete_hits ".getBytes();
    static final byte[] DELETE_MISSES = "delete_misses ".getBytes();
    static final byte[] INCR_HITS = "incr_hits ".getBytes();
    static final byte[] INCR_MISSES = "incr_misses ".getBytes();
    static final byte[] DECR_HITS = "decr_hits ".getBytes();
    static final byte[] DECR_MISSES = "decr_misses ".getBytes();
    static final byte[] CURR_CONNECTIONS = "curr_connections ".getBytes();
    static final byte[] TOTAL_CONNECTIONS = "total_connections ".getBytes();

    public StatsCommand() {
        super(TextCommandConstants.TextCommandType.STATS);
    }

    @Override
    public boolean readFrom(ByteBuffer cb) {
        return true;
    }

    public void setResponse(Stats stats) {
        this.response = ByteBuffer.allocate(1000);
        this.putInt(UPTIME, stats.uptime);
        this.putInt(THREADS, stats.threads);
        this.putInt(WAITING_REQUESTS, stats.waiting_requests);
        this.putInt(CURR_CONNECTIONS, stats.curr_connections);
        this.putInt(TOTAL_CONNECTIONS, stats.total_connections);
        this.putLong(BYTES, stats.bytes);
        this.putLong(CMD_GET, stats.cmd_get);
        this.putLong(CMD_SET, stats.cmd_set);
        this.putLong(CMD_TOUCH, stats.cmd_touch);
        this.putLong(GET_HITS, stats.get_hits);
        this.putLong(GET_MISSES, stats.get_misses);
        this.putLong(DELETE_HITS, stats.delete_hits);
        this.putLong(DELETE_MISSES, stats.delete_misses);
        this.putLong(INCR_HITS, stats.incr_hits);
        this.putLong(INCR_MISSES, stats.incr_misses);
        this.putLong(DECR_HITS, stats.decr_hits);
        this.putLong(DECR_MISSES, stats.decr_misses);
        this.response.put(END);
        this.response.flip();
    }

    private void putInt(byte[] name, int value) {
        this.response.put(STAT);
        this.response.put(name);
        this.response.put(String.valueOf(value).getBytes());
        this.response.put(RETURN);
    }

    private void putLong(byte[] name, long value) {
        this.response.put(STAT);
        this.response.put(name);
        this.response.put(String.valueOf(value).getBytes());
        this.response.put(RETURN);
    }

    @Override
    public boolean writeTo(ByteBuffer bb) {
        if (this.response == null) {
            this.response = ByteBuffer.allocate(0);
        }
        IOUtil.copyToHeapBuffer(this.response, bb);
        return !this.response.hasRemaining();
    }

    @Override
    public String toString() {
        return "StatsCommand{}" + super.toString();
    }
}

