/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.bc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.TrustedCertificates;
import org.globus.gsi.TrustedCertificatesUtil;
import org.globus.gsi.bc.X509NameHelper;
import org.globus.gsi.proxy.ext.ProxyCertInfo;
import org.globus.gsi.proxy.ext.ProxyPolicy;
import org.globus.gsi.util.ProxyCertificateUtil;
import org.globus.util.I18n;

public class BouncyCastleUtil {
    private static I18n i18n;

    public static byte[] toByteArray(ASN1Primitive obj) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DEROutputStream der = new DEROutputStream((OutputStream)bout);
        der.writeObject((ASN1Encodable)obj);
        return bout.toByteArray();
    }

    public static ASN1Primitive toASN1Primitive(byte[] data) throws IOException {
        ByteArrayInputStream inStream = new ByteArrayInputStream(data);
        ASN1InputStream derInputStream = new ASN1InputStream((InputStream)inStream);
        return derInputStream.readObject();
    }

    public static ASN1Primitive duplicate(ASN1Primitive obj) throws IOException {
        return BouncyCastleUtil.toASN1Primitive(BouncyCastleUtil.toByteArray(obj));
    }

    public static TBSCertificateStructure getTBSCertificateStructure(X509Certificate cert) throws CertificateEncodingException, IOException {
        ASN1Primitive obj = BouncyCastleUtil.toASN1Primitive(cert.getTBSCertificate());
        return TBSCertificateStructure.getInstance((Object)obj);
    }

    public static ASN1Primitive getExtensionObject(X509Extension ext) throws IOException {
        return BouncyCastleUtil.toASN1Primitive(ext.getValue().getOctets());
    }

    public static GSIConstants.CertificateType getCertificateType(X509Certificate cert, TrustedCertificates trustedCerts) throws CertificateException {
        try {
            return BouncyCastleUtil.getCertificateType(cert, TrustedCertificatesUtil.createCertStore(trustedCerts));
        }
        catch (Exception e) {
            throw new CertificateException("", e);
        }
    }

    public static GSIConstants.CertificateType getCertificateType(X509Certificate cert, CertStore trustedCerts) throws CertificateException {
        try {
            TBSCertificateStructure crt = BouncyCastleUtil.getTBSCertificateStructure(cert);
            GSIConstants.CertificateType type = BouncyCastleUtil.getCertificateType(crt);
            if (type == GSIConstants.CertificateType.EEC) {
                X509CertSelector selector = new X509CertSelector();
                selector.setSubject(cert.getSubjectX500Principal());
                Collection<? extends Certificate> c = trustedCerts.getCertificates(selector);
                if (c != null && c.size() > 0) {
                    type = GSIConstants.CertificateType.CA;
                }
            }
            return type;
        }
        catch (Exception e) {
            throw new CertificateException("", e);
        }
    }

    public static GSIConstants.CertificateType getCertificateType(X509Certificate cert) throws CertificateException {
        try {
            TBSCertificateStructure crt = BouncyCastleUtil.getTBSCertificateStructure(cert);
            return BouncyCastleUtil.getCertificateType(crt);
        }
        catch (IOException e) {
            throw new CertificateException("", e);
        }
    }

    public static GSIConstants.CertificateType getCertificateType(TBSCertificateStructure crt, TrustedCertificates trustedCerts) throws CertificateException, IOException {
        GSIConstants.CertificateType type = BouncyCastleUtil.getCertificateType(crt);
        if (type == GSIConstants.CertificateType.EEC) {
            if (trustedCerts == null) {
                trustedCerts = TrustedCertificates.getDefaultTrustedCertificates();
            }
            if (trustedCerts != null && trustedCerts.getCertificate(crt.getSubject().toString()) != null) {
                type = GSIConstants.CertificateType.CA;
            }
        }
        return type;
    }

    private static GSIConstants.CertificateType getCertificateType(TBSCertificateStructure crt) throws CertificateException, IOException {
        BasicConstraints basicExt;
        X509Extensions extensions = crt.getExtensions();
        X509Extension ext = null;
        if (extensions != null && (ext = extensions.getExtension(X509Extension.basicConstraints)) != null && (basicExt = BasicConstraints.getInstance((Object)ext)).isCA()) {
            return GSIConstants.CertificateType.CA;
        }
        GSIConstants.CertificateType type = GSIConstants.CertificateType.EEC;
        X500Name subject = crt.getSubject();
        ASN1Set entry = X509NameHelper.getLastNameEntry(subject);
        ASN1Sequence ava = (ASN1Sequence)entry.getObjectAt(0);
        if (BCStyle.CN.equals((Object)ava.getObjectAt(0))) {
            String value = ((ASN1String)ava.getObjectAt(1)).getString();
            if (value.equalsIgnoreCase("proxy")) {
                type = GSIConstants.CertificateType.GSI_2_PROXY;
            } else if (value.equalsIgnoreCase("limited proxy")) {
                type = GSIConstants.CertificateType.GSI_2_LIMITED_PROXY;
            } else if (extensions != null) {
                boolean gsi4 = true;
                ext = extensions.getExtension(ProxyCertInfo.OID);
                if (ext == null) {
                    ext = extensions.getExtension(ProxyCertInfo.OLD_OID);
                    gsi4 = false;
                }
                if (ext != null) {
                    if (ext.isCritical()) {
                        ProxyCertInfo proxyCertExt = BouncyCastleUtil.getProxyCertInfo(ext);
                        ProxyPolicy proxyPolicy = proxyCertExt.getProxyPolicy();
                        DERObjectIdentifier oid = proxyPolicy.getPolicyLanguage();
                        type = ProxyPolicy.IMPERSONATION.equals((Object)oid) ? (gsi4 ? GSIConstants.CertificateType.GSI_4_IMPERSONATION_PROXY : GSIConstants.CertificateType.GSI_3_IMPERSONATION_PROXY) : (ProxyPolicy.INDEPENDENT.equals((Object)oid) ? (gsi4 ? GSIConstants.CertificateType.GSI_4_INDEPENDENT_PROXY : GSIConstants.CertificateType.GSI_3_INDEPENDENT_PROXY) : (ProxyPolicy.LIMITED.equals((Object)oid) ? (gsi4 ? GSIConstants.CertificateType.GSI_4_LIMITED_PROXY : GSIConstants.CertificateType.GSI_3_LIMITED_PROXY) : (gsi4 ? GSIConstants.CertificateType.GSI_4_RESTRICTED_PROXY : GSIConstants.CertificateType.GSI_3_RESTRICTED_PROXY)));
                    } else {
                        String err = i18n.getMessage("proxyCertCritical");
                        throw new CertificateException(err);
                    }
                }
            }
            if (ProxyCertificateUtil.isProxy(type)) {
                X509NameHelper iss = new X509NameHelper(crt.getIssuer());
                iss.add((ASN1Set)BouncyCastleUtil.duplicate((ASN1Primitive)entry));
                X509Name issuer = iss.getAsName();
                if (!issuer.equals((Object)X509Name.getInstance((Object)subject))) {
                    String err = i18n.getMessage("proxyDNErr");
                    throw new CertificateException(err);
                }
            }
        }
        return type;
    }

    public static boolean[] getKeyUsage(X509Extension ext) throws IOException {
        DERBitString bits = (DERBitString)BouncyCastleUtil.getExtensionObject(ext);
        byte[] bytes = bits.getBytes();
        int length = bytes.length * 8 - bits.getPadBits();
        boolean[] keyUsage = new boolean[length < 9 ? 9 : length];
        for (int i = 0; i != length; ++i) {
            keyUsage[i] = (bytes[i / 8] & 128 >>> i % 8) != 0;
        }
        return keyUsage;
    }

    public static ProxyCertInfo getProxyCertInfo(X509Extension ext) throws IOException {
        return ProxyCertInfo.getInstance(BouncyCastleUtil.getExtensionObject(ext));
    }

    public static String getIdentity(X509Certificate cert) {
        if (cert == null) {
            return null;
        }
        String subjectDN = cert.getSubjectX500Principal().getName("RFC2253");
        X509Name name = new X509Name(true, subjectDN);
        return X509NameHelper.toString(name);
    }

    public static String getIdentityPrefix(X509Certificate cert) {
        if (cert == null) {
            return null;
        }
        String subjectDN = cert.getSubjectX500Principal().getName("RFC2253");
        LdapName ldapname = null;
        try {
            ldapname = new LdapName(subjectDN);
            ldapname.remove(ldapname.size() - 1);
        }
        catch (InvalidNameException e) {
            return null;
        }
        X509Name name = new X509Name(true, ldapname.toString());
        return X509NameHelper.toString(name);
    }

    public static String getIdentity(X509Certificate[] chain) throws CertificateException {
        return BouncyCastleUtil.getIdentity(BouncyCastleUtil.getIdentityCertificate(chain));
    }

    public static X509Certificate getIdentityCertificate(X509Certificate[] chain) throws CertificateException {
        if (chain == null) {
            throw new IllegalArgumentException(i18n.getMessage("certChainNull"));
        }
        for (int i = 0; i < chain.length; ++i) {
            GSIConstants.CertificateType certType = BouncyCastleUtil.getCertificateType(chain[i]);
            if (ProxyCertificateUtil.isImpersonationProxy(certType)) continue;
            return chain[i];
        }
        return null;
    }

    public static byte[] getExtensionValue(byte[] certExtValue) throws IOException {
        ByteArrayInputStream inStream = new ByteArrayInputStream(certExtValue);
        ASN1InputStream derInputStream = new ASN1InputStream((InputStream)inStream);
        ASN1Primitive object = derInputStream.readObject();
        if (object instanceof ASN1OctetString) {
            return ((ASN1OctetString)object).getOctets();
        }
        throw new IOException(i18n.getMessage("octectExp"));
    }

    public static byte[] getExtensionValue(X509Certificate cert, String oid) throws IOException {
        if (cert == null) {
            throw new IllegalArgumentException(i18n.getMessage("certNull"));
        }
        if (oid == null) {
            throw new IllegalArgumentException(i18n.getMessage("oidNull"));
        }
        byte[] value = cert.getExtensionValue(oid);
        if (value == null) {
            return null;
        }
        return BouncyCastleUtil.getExtensionValue(value);
    }

    public static int getProxyPathConstraint(X509Certificate cert) throws IOException, CertificateEncodingException {
        TBSCertificateStructure crt = BouncyCastleUtil.getTBSCertificateStructure(cert);
        return BouncyCastleUtil.getProxyPathConstraint(crt);
    }

    public static int getProxyPathConstraint(TBSCertificateStructure crt) throws IOException {
        ProxyCertInfo proxyCertExt = BouncyCastleUtil.getProxyCertInfo(crt);
        return proxyCertExt != null ? proxyCertExt.getPathLenConstraint() : -1;
    }

    public static ProxyCertInfo getProxyCertInfo(TBSCertificateStructure crt) throws IOException {
        X509Extensions extensions = crt.getExtensions();
        if (extensions == null) {
            return null;
        }
        X509Extension ext = extensions.getExtension(ProxyCertInfo.OID);
        if (ext == null) {
            ext = extensions.getExtension(ProxyCertInfo.OLD_OID);
        }
        return ext != null ? BouncyCastleUtil.getProxyCertInfo(ext) : null;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        i18n = I18n.getI18n("org.globus.gsi.errors", BouncyCastleUtil.class.getClassLoader());
    }
}

