/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.db.event.manager.utils;

import java.util.List;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbEventManagerZkUtils {
    private static final Logger logger = LoggerFactory.getLogger(DbEventManagerZkUtils.class);
    private static CuratorFramework curatorClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CuratorFramework getCuratorClient() throws ApplicationSettingsException {
        if (curatorClient != null) return curatorClient;
        Class<DbEventManagerZkUtils> clazz = DbEventManagerZkUtils.class;
        synchronized (DbEventManagerZkUtils.class) {
            if (curatorClient != null) return curatorClient;
            String connectionSting = ServerSettings.getZookeeperConnection();
            ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 5);
            curatorClient = CuratorFrameworkFactory.newClient((String)connectionSting, (RetryPolicy)retryPolicy);
            // ** MonitorExit[var0] (shouldn't be in output)
            return curatorClient;
        }
    }

    public static void createDBEventMgrZkNode(CuratorFramework curatorClient, String publisherNode, String subscriberNode) throws Exception {
        String publisherZkPath = ZKPaths.makePath((String)"db-event-mgr", (String)publisherNode);
        String subscriberZkPath = ZKPaths.makePath((String)publisherZkPath, (String)subscriberNode);
        byte[] publisherZkData = publisherNode.getBytes();
        byte[] subscriberZkData = subscriberNode.getBytes();
        logger.debug("Creating Zk node for db-event-mgr: " + subscriberZkPath);
        ZKPaths.mkdirs((ZooKeeper)curatorClient.getZookeeperClient().getZooKeeper(), (String)subscriberZkPath);
        ((BackgroundPathAndBytesable)curatorClient.setData().withVersion(-1)).forPath(publisherZkPath, publisherZkData);
        ((BackgroundPathAndBytesable)curatorClient.setData().withVersion(-1)).forPath(subscriberZkPath, subscriberZkData);
    }

    public static List<String> getSubscribersForPublisher(CuratorFramework curatorClient, String publisherNode) throws Exception {
        String publisherZkPath = ZKPaths.makePath((String)"db-event-mgr", (String)publisherNode);
        List subscriberList = (List)curatorClient.getChildren().forPath(publisherZkPath);
        return subscriberList;
    }
}

