/*
 * Decompiled with CFR 0.152.
 */
package org.databene.stat;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.databene.stat.LatencyCounter;

public class CounterRepository {
    private Map<String, LatencyCounter> counters = new HashMap<String, LatencyCounter>();
    private static final CounterRepository INSTANCE = new CounterRepository();

    private CounterRepository() {
    }

    public static CounterRepository getInstance() {
        return INSTANCE;
    }

    public void addSample(String name, int latency) {
        LatencyCounter counter = this.getOrCreateCounter(name);
        counter.addSample(latency);
    }

    public LatencyCounter getCounter(String name) {
        return this.counters.get(name);
    }

    public Set<Map.Entry<String, LatencyCounter>> getCounters() {
        return this.counters.entrySet();
    }

    public void clear() {
        this.counters.clear();
    }

    public void printSummary() {
        DecimalFormat df = new DecimalFormat("0.0", DecimalFormatSymbols.getInstance(Locale.US));
        ArrayList<String[]> list = new ArrayList<String[]>(this.counters.size());
        ArrayList<LatencyCounter> sortedCounters = new ArrayList<LatencyCounter>(this.counters.values());
        Collections.sort(sortedCounters, new Comparator<LatencyCounter>(){

            @Override
            public int compare(LatencyCounter c1, LatencyCounter c2) {
                return -new Long(c1.totalLatency()).compareTo(c2.totalLatency());
            }
        });
        for (LatencyCounter counter : sortedCounters) {
            list.add(new String[]{counter.getName() + ":", counter.totalLatency() + " ms total,", counter.sampleCount() + " inv,", df.format(counter.averageLatency()) + " ms/inv (avg.)"});
        }
        CounterRepository.printSummaryTable(list);
    }

    private LatencyCounter getOrCreateCounter(String name) {
        LatencyCounter counter = this.getCounter(name);
        if (counter == null) {
            counter = this.createCounter(name);
        }
        return counter;
    }

    private synchronized LatencyCounter createCounter(String name) {
        LatencyCounter counter = this.getCounter(name);
        if (counter == null) {
            counter = new LatencyCounter(name);
            this.counters.put(name, counter);
        }
        return counter;
    }

    private static void printSummaryTable(List<String[]> list) {
        int[] widths = new int[4];
        for (int col = 0; col < 4; ++col) {
            int width = 0;
            for (int row = 0; row < list.size(); ++row) {
                width = Math.max(width, list.get(row)[col].length());
            }
            widths[col] = width;
        }
        for (int row = 0; row < list.size(); ++row) {
            for (int col = 0; col < 4; ++col) {
                String text = list.get(row)[col];
                if (col > 0) {
                    CounterRepository.pad(widths[col] - text.length());
                    System.out.print(text);
                } else {
                    System.out.print(text);
                    CounterRepository.pad(widths[col] - text.length());
                }
                if (col >= 3) continue;
                System.out.print(' ');
            }
            System.out.println();
        }
    }

    private static void pad(int count) {
        for (int i = 0; i < count; ++i) {
            System.out.print(' ');
        }
    }
}

