/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl.task.utils.bes;

import eu.emi.security.authn.x509.helpers.CertificateHelpers;
import eu.emi.security.authn.x509.helpers.proxy.X509v3CertificateBuilder;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.KeyAndCertCredential;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Random;
import javax.security.auth.x500.X500Principal;
import org.apache.airavata.credential.store.store.CredentialReader;
import org.apache.airavata.gfac.core.GFacException;
import org.apache.airavata.gfac.core.GFacUtils;
import org.apache.airavata.gfac.core.RequestData;
import org.apache.airavata.gfac.core.context.ProcessContext;
import org.apache.airavata.gfac.impl.task.utils.bes.UNICORESecurityContext;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionProtocol;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtils {
    private static final Logger logger = LoggerFactory.getLogger(SecurityUtils.class);

    public static UNICORESecurityContext getSecurityContext(ProcessContext processContext) throws GFacException {
        if (processContext.getJobSubmissionProtocol().equals((Object)JobSubmissionProtocol.UNICORE)) {
            String credentialStoreToken = processContext.getTokenId();
            RequestData requestData = new RequestData(processContext.getProcessModel().getUserDn());
            requestData.setTokenId(credentialStoreToken);
            CredentialReader credentialReader = null;
            try {
                credentialReader = GFacUtils.getCredentialReader();
                if (credentialReader == null) {
                    throw new GFacException("Credential reader returns null");
                }
            }
            catch (Exception e) {
                throw new GFacException("Error while initializing credential reader");
            }
            return new UNICORESecurityContext(credentialReader, requestData);
        }
        throw new GFacException("Only support UNICORE job submissions, invalid job submission protocol " + processContext.getJobSubmissionProtocol().name());
    }

    public static final KeyAndCertCredential generateShortLivedCertificate(String userDN, String caCertPath, String caKeyPath, String caPwd) throws Exception {
        SubjectPublicKeyInfo publicKeyInfo;
        long CredentialGoodFromOffset = 900000L;
        long startTime = System.currentTimeMillis() - 900000L;
        long endTime = startTime + 108000000L;
        String keyLengthProp = "1024";
        int keyLength = Integer.parseInt("1024");
        String signatureAlgorithm = "SHA1withRSA";
        KeyAndCertCredential caCred = SecurityUtils.getCACredential(caCertPath, caKeyPath, caPwd);
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(caCred.getKey().getAlgorithm());
        kpg.initialize(keyLength);
        KeyPair pair = kpg.generateKeyPair();
        X500Principal subjectDN = new X500Principal(userDN);
        Random rand = new Random();
        try {
            publicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)new ASN1InputStream(pair.getPublic().getEncoded()).readObject());
        }
        catch (IOException e) {
            throw new InvalidKeyException("Can not parse the public keybeing included in the short lived certificate", e);
        }
        X500Name issuerX500Name = CertificateHelpers.toX500Name((X500Principal)caCred.getCertificate().getSubjectX500Principal());
        X500Name subjectX500Name = CertificateHelpers.toX500Name((X500Principal)subjectDN);
        X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(issuerX500Name, new BigInteger(20, rand), new Date(startTime), new Date(endTime), subjectX500Name, publicKeyInfo);
        AlgorithmIdentifier sigAlgId = X509v3CertificateBuilder.extractAlgorithmId((X509Certificate)caCred.getCertificate());
        X509Certificate certificate = certBuilder.build(caCred.getKey(), sigAlgId, "SHA1withRSA", null, null);
        certificate.checkValidity(new Date());
        certificate.verify(caCred.getCertificate().getPublicKey());
        KeyAndCertCredential result = new KeyAndCertCredential(pair.getPrivate(), new X509Certificate[]{certificate, caCred.getCertificate()});
        return result;
    }

    public static KeyAndCertCredential getCACredential(String caCertPath, String caKeyPath, String password) throws Exception {
        FileInputStream isKey = new FileInputStream(caKeyPath);
        PrivateKey pk = CertificateUtils.loadPrivateKey((InputStream)isKey, (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM, (char[])password.toCharArray());
        FileInputStream isCert = new FileInputStream(caCertPath);
        X509Certificate caCert = CertificateUtils.loadCertificate((InputStream)isCert, (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM);
        if (isKey != null) {
            ((InputStream)isKey).close();
        }
        if (isCert != null) {
            ((InputStream)isCert).close();
        }
        return new KeyAndCertCredential(pk, new X509Certificate[]{caCert});
    }
}

