/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.proxy;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.V3TBSCertificateGenerator;

public class X509v3CertificateBuilder {
    private V3TBSCertificateGenerator tbsGen = new V3TBSCertificateGenerator();
    private ExtensionsGenerator extGenerator;

    public X509v3CertificateBuilder(X500Name issuer, BigInteger serial, Date notBefore, Date notAfter, X500Name subject, SubjectPublicKeyInfo publicKeyInfo) {
        this.tbsGen.setSubject(subject);
        this.tbsGen.setSerialNumber(new ASN1Integer(serial));
        this.tbsGen.setIssuer(issuer);
        this.tbsGen.setStartDate(new Time(notBefore));
        this.tbsGen.setEndDate(new Time(notAfter));
        this.tbsGen.setSubject(subject);
        this.tbsGen.setSubjectPublicKeyInfo(publicKeyInfo);
        this.extGenerator = new ExtensionsGenerator();
    }

    public X509v3CertificateBuilder addExtension(ASN1ObjectIdentifier oid, boolean isCritical, ASN1Object value) throws IOException {
        this.extGenerator.addExtension(oid, isCritical, (ASN1Encodable)value);
        return this;
    }

    public X509Certificate build(PrivateKey key, AlgorithmIdentifier sigAlg, String sigAlgName, String provider, SecureRandom random) throws InvalidKeyException, CertificateParsingException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, IOException {
        if (sigAlg == null || sigAlgName == null) {
            throw new IllegalStateException("no signature algorithm specified");
        }
        if (key == null) {
            throw new IllegalStateException("no private key specified");
        }
        this.tbsGen.setSignature(sigAlg);
        if (!this.extGenerator.isEmpty()) {
            this.tbsGen.setExtensions(this.extGenerator.generate());
        }
        TBSCertificate toSign = this.tbsGen.generateTBSCertificate();
        return this.sign(toSign, sigAlg, sigAlgName, key, provider, random);
    }

    private X509Certificate sign(TBSCertificate toSign, AlgorithmIdentifier sigAlg, String sigAlgName, PrivateKey key, String provider, SecureRandom random) throws InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, IOException, CertificateParsingException {
        byte[] signature = this.calculateSignature(sigAlgName, provider, key, random, (ASN1Object)toSign);
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)toSign);
        v.add((ASN1Encodable)sigAlg.toASN1Primitive());
        v.add((ASN1Encodable)new DERBitString(signature));
        DERSequence derCertificate = new DERSequence(v);
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(derCertificate.getEncoded("DER"));
            return (X509Certificate)factory.generateCertificate(bais);
        }
        catch (CertificateException e) {
            throw new RuntimeException("The generated proxy certificate was not parsed by the JDK", e);
        }
    }

    private byte[] calculateSignature(String sigName, String provider, PrivateKey key, SecureRandom random, ASN1Object object) throws IOException, NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature sig = provider != null ? Signature.getInstance(sigName, provider) : Signature.getInstance(sigName);
        if (random != null) {
            sig.initSign(key, random);
        } else {
            sig.initSign(key);
        }
        sig.update(object.getEncoded("DER"));
        return sig.sign();
    }

    public static AlgorithmIdentifier extractAlgorithmId(X509Certificate cert) throws IOException {
        String oid = cert.getSigAlgOID();
        byte[] params = cert.getSigAlgParams();
        if (params != null) {
            ASN1Primitive derParams = ASN1Primitive.fromByteArray((byte[])params);
            return new AlgorithmIdentifier(new ASN1ObjectIdentifier(oid), (ASN1Encodable)derParams);
        }
        return new AlgorithmIdentifier(new ASN1ObjectIdentifier(oid));
    }
}

