/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.core.model.user;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import java.util.Set;
import org.apache.custos.core.model.user.AttributeUpdateMetadata;
import org.apache.custos.core.model.user.StatusUpdateMetadata;
import org.apache.custos.core.model.user.UserAttribute;
import org.apache.custos.core.model.user.UserGroupMembership;
import org.apache.custos.core.model.user.UserRole;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="user_profile")
@EntityListeners(value={AuditingEntityListener.class})
public class UserProfile {
    @Id
    private String id;
    @Column(nullable=false)
    private Long tenantId;
    @Column(nullable=false)
    private String username;
    @Column
    private String emailAddress;
    @Column
    private String firstName;
    @Column
    private String lastName;
    @Column(nullable=false)
    private String status;
    @Column(nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @CreatedDate
    private Date createdAt;
    @Temporal(value=TemporalType.TIMESTAMP)
    @LastModifiedDate
    private Date lastModifiedAt;
    @Column
    private String type;
    @OneToMany(fetch=FetchType.EAGER, mappedBy="userProfile", orphanRemoval=true, cascade={CascadeType.ALL})
    private Set<UserRole> userRole;
    @OneToMany(fetch=FetchType.EAGER, mappedBy="userProfile", orphanRemoval=true, cascade={CascadeType.ALL})
    private Set<UserAttribute> userAttribute;
    @OneToMany(mappedBy="userProfile", cascade={CascadeType.ALL})
    private Set<AttributeUpdateMetadata> attributeUpdateMetadata;
    @OneToMany(mappedBy="userProfile", cascade={CascadeType.ALL})
    private Set<StatusUpdateMetadata> statusUpdateMetadata;
    @OneToMany(mappedBy="userProfile", cascade={CascadeType.ALL})
    private Set<UserGroupMembership> userGroupMemberships;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Long getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Set<AttributeUpdateMetadata> getAttributeUpdateMetadata() {
        return this.attributeUpdateMetadata;
    }

    public void setAttributeUpdateMetadata(Set<AttributeUpdateMetadata> attributeUpdateMetadata) {
        this.attributeUpdateMetadata = attributeUpdateMetadata;
    }

    public Set<StatusUpdateMetadata> getStatusUpdateMetadata() {
        return this.statusUpdateMetadata;
    }

    public void setStatusUpdateMetadata(Set<StatusUpdateMetadata> statusUpdateMetadata) {
        this.statusUpdateMetadata = statusUpdateMetadata;
    }

    public Set<UserAttribute> getUserAttribute() {
        return this.userAttribute;
    }

    public void setUserAttribute(Set<UserAttribute> userAttribute) {
        this.userAttribute = userAttribute;
    }

    public Set<UserRole> getUserRole() {
        return this.userRole;
    }

    public void setUserRole(Set<UserRole> userRole) {
        this.userRole = userRole;
    }

    public Set<UserGroupMembership> getUserGroupMemberships() {
        return this.userGroupMemberships;
    }

    public void setUserGroupMemberships(Set<UserGroupMembership> userGroupMemberships) {
        this.userGroupMemberships = userGroupMemberships;
    }

    public Date getLastModifiedAt() {
        return this.lastModifiedAt;
    }

    public void setLastModifiedAt(Date lastModifiedAt) {
        this.lastModifiedAt = lastModifiedAt;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

