/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.core.repo.user;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.custos.core.model.user.Group;
import org.apache.custos.core.repo.user.SearchGroupsRepository;
import org.springframework.stereotype.Repository;

@Repository
public class SearchGroupsRepositoryImpl
implements SearchGroupsRepository {
    @PersistenceContext
    EntityManager entityManager;

    @Override
    public List<Group> searchEntities(long tenantId, org.apache.custos.core.user.profile.api.Group group, int offset, int limit) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        String query = this.createSQLQuery(tenantId, group, valueMap, offset, limit);
        Query q = this.entityManager.createNativeQuery(query, Group.class);
        valueMap.forEach((arg_0, arg_1) -> ((Query)q).setParameter(arg_0, arg_1));
        return q.getResultList();
    }

    private String createSQLQuery(long tenantId, org.apache.custos.core.user.profile.api.Group group, Map<String, Object> valueMap, int offset, int limit) {
        Date date;
        Object query = "SELECT * FROM group_entity E WHERE ";
        if (!group.getName().isBlank()) {
            query = (String)query + "E.name LIKE :name AND ";
            valueMap.put("name", group.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)group.getDescription())) {
            query = (String)query + "E.description LIKE :description AND ";
            valueMap.put("description", group.getDescription());
        }
        if (StringUtils.isNotBlank((CharSequence)group.getId())) {
            query = (String)query + "E.external_id = :external_id AND ";
            valueMap.put("external_id", group.getId());
        }
        if (group.getCreatedTime() != 0L) {
            date = new Date(group.getCreatedTime());
            query = (String)query + "E.created_at >= :created_at AND ";
            valueMap.put("created_at", date);
        }
        if (group.getLastModifiedTime() != 0L) {
            date = new Date(group.getLastModifiedTime());
            query = (String)query + "E.last_modified_at >= :last_modified_at AND ";
            valueMap.put("last_modified_at", date);
        }
        if (tenantId != 0L) {
            query = (String)query + "E.tenant_id = :tenant_id AND ";
            valueMap.put("tenant_id", tenantId);
        }
        query = ((String)query).substring(0, ((String)query).length() - 5);
        query = (String)query + " ORDER BY E.created_at DESC";
        if (limit > 0) {
            query = (String)query + " LIMIT :limit OFFSET :offset";
            valueMap.put("limit", limit);
            valueMap.put("offset", offset);
        }
        return query;
    }
}

