/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.ant.compress.util.CompressorWithConcatenatedStreamsFactory;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorInputStream;
import org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorOutputStream;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorInputStream;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorOutputStream;

public class LZ4StreamFactory
implements CompressorWithConcatenatedStreamsFactory {
    private boolean framed = true;

    public void setFramed(boolean framed) {
        this.framed = framed;
    }

    protected boolean isFramed() {
        return this.framed;
    }

    @Override
    public CompressorInputStream getCompressorStream(InputStream stream) throws IOException {
        return this.framed ? new FramedLZ4CompressorInputStream(stream) : new BlockLZ4CompressorInputStream(stream);
    }

    @Override
    public CompressorInputStream getCompressorStream(InputStream stream, boolean decompressConcatenated) throws IOException {
        if (!this.framed && decompressConcatenated) {
            throw new UnsupportedOperationException("only the frame format supports concatenated streams");
        }
        return this.framed ? new FramedLZ4CompressorInputStream(stream, decompressConcatenated) : new BlockLZ4CompressorInputStream(stream);
    }

    @Override
    public CompressorOutputStream getCompressorStream(OutputStream stream) throws IOException {
        return this.framed ? new FramedLZ4CompressorOutputStream(stream) : new BlockLZ4CompressorOutputStream(stream);
    }
}

