/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.dataflow;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ITuplePartitioner;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionerFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.PermutingFrameTupleReference;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.am.common.api.ITupleFilter;
import org.apache.hyracks.storage.am.common.api.ITupleFilterFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.util.ResourceReleaseUtils;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.buffercache.IPageWriteCallback;
import org.apache.hyracks.storage.common.buffercache.NoOpPageWriteCallback;

public class IndexBulkLoadOperatorNodePushable
extends AbstractUnaryInputUnaryOutputOperatorNodePushable {
    protected final IHyracksTaskContext ctx;
    protected final float fillFactor;
    protected final boolean verifyInput;
    protected final long numElementsHint;
    protected final boolean checkIfEmptyIndex;
    protected final IIndexDataflowHelper[] indexHelpers;
    protected final boolean[] indexHelpersOpen;
    protected final RecordDescriptor recDesc;
    protected final PermutingFrameTupleReference tuple = new PermutingFrameTupleReference();
    protected final ITupleFilterFactory tupleFilterFactory;
    protected final ITuplePartitioner tuplePartitioner;
    protected final int[] partitions;
    protected final Int2IntMap storagePartitionId2Index;
    protected FrameTupleAccessor accessor;
    protected final IIndex[] indexes;
    protected final IIndexBulkLoader[] bulkLoaders;
    protected ITupleFilter tupleFilter;
    protected FrameTupleReference frameTuple;

    public IndexBulkLoadOperatorNodePushable(IIndexDataflowHelperFactory indexHelperFactory, IHyracksTaskContext ctx, int partition, int[] fieldPermutation, float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex, RecordDescriptor recDesc, ITupleFilterFactory tupleFilterFactory, ITuplePartitionerFactory partitionerFactory, int[][] partitionsMap) throws HyracksDataException {
        this.ctx = ctx;
        this.partitions = partitionsMap[partition];
        this.tuplePartitioner = partitionerFactory.createPartitioner(ctx);
        this.storagePartitionId2Index = new Int2IntOpenHashMap();
        this.indexes = new IIndex[this.partitions.length];
        this.indexHelpers = new IIndexDataflowHelper[this.partitions.length];
        this.indexHelpersOpen = new boolean[this.partitions.length];
        this.bulkLoaders = new IIndexBulkLoader[this.partitions.length];
        for (int i = 0; i < this.partitions.length; ++i) {
            this.storagePartitionId2Index.put(this.partitions[i], i);
            this.indexHelpers[i] = indexHelperFactory.create(ctx.getJobletContext().getServiceContext(), this.partitions[i]);
        }
        this.fillFactor = fillFactor;
        this.verifyInput = verifyInput;
        this.numElementsHint = numElementsHint;
        this.checkIfEmptyIndex = checkIfEmptyIndex;
        this.recDesc = recDesc;
        this.tupleFilterFactory = tupleFilterFactory;
        this.tuple.setFieldPermutation(fieldPermutation);
    }

    public void open() throws HyracksDataException {
        this.accessor = new FrameTupleAccessor(this.recDesc);
        for (int i = 0; i < this.indexHelpers.length; ++i) {
            this.indexHelpersOpen[i] = true;
            this.indexHelpers[i].open();
            this.indexes[i] = this.indexHelpers[i].getIndexInstance();
            this.initializeBulkLoader(this.indexes[i], i);
        }
        try {
            this.writer.open();
            if (this.tupleFilterFactory != null) {
                this.tupleFilter = this.tupleFilterFactory.createTupleFilter(this.ctx);
                this.frameTuple = new FrameTupleReference();
            }
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.accessor.reset(buffer);
        int tupleCount = this.accessor.getTupleCount();
        for (int i = 0; i < tupleCount; ++i) {
            if (this.tupleFilter != null) {
                this.frameTuple.reset((IFrameTupleAccessor)this.accessor, i);
                if (!this.tupleFilter.accept((IFrameTupleReference)this.frameTuple)) continue;
            }
            int storagePartition = this.tuplePartitioner.partition((IFrameTupleAccessor)this.accessor, i);
            int storageIdx = this.storagePartitionId2Index.get(storagePartition);
            this.tuple.reset((IFrameTupleAccessor)this.accessor, i);
            this.bulkLoaders[storageIdx].add((ITupleReference)this.tuple);
        }
        FrameUtils.flushFrame((ByteBuffer)buffer, (IFrameWriter)this.writer);
    }

    public void close() throws HyracksDataException {
        try {
            this.closeBulkLoaders();
        }
        catch (Throwable th) {
            throw HyracksDataException.create((Throwable)th);
        }
        finally {
            try {
                IndexBulkLoadOperatorNodePushable.closeIndexes(this.indexes, this.indexHelpers, this.indexHelpersOpen);
            }
            finally {
                this.writer.close();
            }
        }
    }

    public void flush() throws HyracksDataException {
        this.writer.flush();
    }

    public void fail() throws HyracksDataException {
        this.writer.fail();
    }

    protected void initializeBulkLoader(IIndex index, int indexId) throws HyracksDataException {
        this.bulkLoaders[indexId] = index.createBulkLoader(this.fillFactor, this.verifyInput, this.numElementsHint, this.checkIfEmptyIndex, (IPageWriteCallback)NoOpPageWriteCallback.INSTANCE);
    }

    private void closeBulkLoaders() throws HyracksDataException {
        for (IIndexBulkLoader bulkLoader : this.bulkLoaders) {
            if (bulkLoader == null) continue;
            bulkLoader.end();
        }
    }

    protected static void closeIndexes(IIndex[] indexes, IIndexDataflowHelper[] indexHelpers, boolean[] indexHelpersOpen) throws HyracksDataException {
        Throwable failure = null;
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] == null && !indexHelpersOpen[i]) continue;
            failure = ResourceReleaseUtils.close(indexHelpers[i], failure);
        }
        if (failure != null) {
            throw HyracksDataException.create(failure);
        }
    }
}

