/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.assembler;

import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.builders.ListBuilderFactory;
import org.apache.asterix.column.assembler.AbstractNestedValueAssembler;
import org.apache.asterix.column.assembler.AbstractValueAssembler;
import org.apache.asterix.column.assembler.AssemblerInfo;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;

public class ArrayValueAssembler
extends AbstractNestedValueAssembler {
    private final IAsterixListBuilder listBuilder;
    private final AbstractCollectionType collectionType;
    private final int firstValueIndex;
    private boolean missing;

    ArrayValueAssembler(int level, AssemblerInfo info, int firstValueIndex) {
        super(level, info);
        this.firstValueIndex = firstValueIndex;
        this.collectionType = (AbstractCollectionType)info.getDeclaredType();
        this.listBuilder = new ListBuilderFactory().create(this.collectionType.getTypeTag());
        this.missing = false;
    }

    final int getFirstValueIndex() {
        return this.firstValueIndex;
    }

    @Override
    void reset() {
        this.missing = false;
        this.listBuilder.reset(this.collectionType);
        this.storage.reset();
    }

    @Override
    void addValue(AbstractValueAssembler value) throws HyracksDataException {
        this.writePreviousMissing();
        this.listBuilder.addItem(value.getValue());
    }

    @Override
    void addNull(AbstractValueAssembler value) throws HyracksDataException {
        this.writePreviousMissing();
        this.listBuilder.addItem((IValueReference)NULL);
    }

    @Override
    void addMissing() throws HyracksDataException {
        this.writePreviousMissing();
        this.missing = true;
    }

    @Override
    void addValueToParent() throws HyracksDataException {
        this.storage.reset();
        this.listBuilder.write(this.storage.getDataOutput(), true);
        this.getParent().addValue(this);
    }

    @Override
    public IValueReference getValue() {
        return this.storage;
    }

    private void writePreviousMissing() throws HyracksDataException {
        if (this.missing) {
            this.listBuilder.addItem((IValueReference)MISSING);
            this.missing = false;
        }
    }
}

