/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.compiler.specific;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Protocol;
import org.apache.avro.compiler.specific.SpecificCompiler;
import org.apache.avro.generic.GenericData;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class ProtocolTask
extends Task {
    private File src;
    private File dest = new File(".");
    private GenericData.StringType stringType = GenericData.StringType.CharSequence;
    private final ArrayList<FileSet> filesets = new ArrayList();

    public void setFile(File file) {
        this.src = file;
    }

    public void setDestdir(File dir) {
        this.dest = dir;
    }

    public void setStringType(GenericData.StringType type) {
        this.stringType = type;
    }

    public GenericData.StringType getStringType() {
        return this.stringType;
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void execute() {
        if (this.src == null && this.filesets.size() == 0) {
            throw new BuildException("No file or fileset specified.");
        }
        if (this.src != null) {
            this.compile(this.src);
        }
        Project myProject = this.getProject();
        for (FileSet fs : this.filesets) {
            String[] srcs;
            DirectoryScanner ds = fs.getDirectoryScanner(myProject);
            File dir = fs.getDir(myProject);
            for (String src1 : srcs = ds.getIncludedFiles()) {
                this.compile(new File(dir, src1));
            }
        }
    }

    protected void doCompile(File src, File dir) throws IOException {
        Protocol protocol = Protocol.parse((File)src);
        SpecificCompiler compiler = new SpecificCompiler(protocol);
        compiler.setStringType(this.getStringType());
        compiler.compileToDestination(src, this.dest);
    }

    private void compile(File file) {
        try {
            this.doCompile(file, this.dest);
        }
        catch (IOException | AvroRuntimeException e) {
            throw new BuildException(e);
        }
    }
}

