/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import java.util.ArrayList;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.def.BaseMappingWrapper;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.ComponentProperty;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.IContextObj;
import org.jibx.binding.def.IMapping;
import org.jibx.binding.def.ITypeBinding;
import org.jibx.binding.def.MappingDefinition;
import org.jibx.binding.def.NameDefinition;
import org.jibx.binding.def.NamespaceDefinition;
import org.jibx.binding.def.PrecompiledBinding;
import org.jibx.binding.def.PropertyDefinition;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.JiBXException;

public class PrecompiledAbstractMapping
implements IMapping {
    private final boolean m_translated;
    private final ClassFile m_class;
    private final String m_typeName;
    private final PrecompiledBinding m_binding;
    private final String m_referenceType;
    private final ArrayList m_namespaces;
    private final IContainer m_parent;
    private final String m_mappingName;

    public PrecompiledAbstractMapping(String type, String tname, String mapname, int index, IBindingFactory factory, int[] nsxlate, IContainer parent) throws JiBXException {
        this.m_translated = nsxlate != null;
        this.m_class = ClassCache.requireClassFile(type);
        this.m_typeName = tname;
        parent.getBindingRoot().addMappingName(tname == null ? type : tname);
        this.m_binding = new PrecompiledBinding(index, factory.getAbstractMappings(), this.m_translated, factory.getClass().getName());
        this.m_referenceType = type;
        this.m_namespaces = new ArrayList();
        this.m_parent = parent;
        this.m_mappingName = mapname;
        String[] uris = factory.getNamespaces();
        int[] nss = factory.getAbstractMappingNamespaces(index);
        for (int i = 0; i < nss.length; ++i) {
            int nsi = nss[i];
            String uri = uris[nsi];
            NamespaceDefinition def = new NamespaceDefinition(uri, null, 0);
            if (nsxlate != null) {
                nsi = nsxlate[nsi];
            }
            def.setIndex(nsi);
            this.m_namespaces.add(def);
        }
    }

    public void linkMappings() throws JiBXException {
    }

    @Override
    public String getBoundType() {
        return this.m_class.getName();
    }

    @Override
    public String getReferenceType() {
        return this.m_referenceType;
    }

    @Override
    public IComponent getImplComponent() {
        return this.m_binding;
    }

    @Override
    public ClassFile getMarshaller() {
        return null;
    }

    @Override
    public ClassFile getUnmarshaller() {
        return null;
    }

    @Override
    public NameDefinition getName() {
        return null;
    }

    @Override
    public void addNamespace(NamespaceDefinition ns) throws JiBXException {
        throw new IllegalArgumentException("Internal error - namespace cannot be added to precompiled mapping");
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    @Override
    public boolean isBase() {
        return false;
    }

    @Override
    public void addExtension(MappingDefinition mdef) throws JiBXException {
        throw new IllegalArgumentException("Internal error - extension cannot be added to precompiled mapping");
    }

    @Override
    public IComponent buildRef(IContainer parent, IContextObj objc, String type, PropertyDefinition prop) throws JiBXException {
        if (prop.isThis()) {
            return new BaseMappingWrapper(this.m_binding);
        }
        ComponentProperty comp = new ComponentProperty(prop, this.m_binding, false);
        if (this.m_binding.getAttributeUnmarshalMethod() == null && this.m_binding.getContentUnmarshalMethod() == null) {
            comp.setForceUnmarshal(true);
        }
        return comp;
    }

    @Override
    public ArrayList getNamespaces() {
        return this.m_namespaces;
    }

    @Override
    public void generateCode(boolean force) throws JiBXException {
    }

    public NameDefinition getWrapperName() {
        return null;
    }

    @Override
    public ITypeBinding getBinding() {
        return this.m_binding;
    }

    @Override
    public String getMappingName() {
        return this.m_mappingName;
    }

    @Override
    public String getTypeName() {
        return this.m_typeName;
    }

    @Override
    public void setLinkages() throws JiBXException {
        BindingDefinition binding = this.m_parent.getBindingRoot();
        for (int i = 0; i < this.m_namespaces.size(); ++i) {
            NamespaceDefinition def = (NamespaceDefinition)this.m_namespaces.get(i);
            def.setPrefix(binding.getPrefix(def.getUri()));
        }
    }

    public void print(int depth) {
        BindingDefinition.indent(depth);
        System.out.print("precompiled abstract mapping " + this.m_typeName + " for class " + this.m_class.getName());
    }
}

