/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.core.util;

import org.apache.axis2.AxisFault;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageContextUtils {
    private static Log log = LogFactory.getLog(MessageContextUtils.class);

    public static MessageContext createResponseMessageContext(MessageContext mc) {
        try {
            org.apache.axis2.context.MessageContext sourceAxisMC = mc.getAxisMessageContext();
            org.apache.axis2.context.MessageContext newAxisMC = MessageContextBuilder.createOutMessageContext((org.apache.axis2.context.MessageContext)sourceAxisMC);
            MessageContext newMC = new MessageContext(newAxisMC);
            newMC.setOutbound(true);
            newMC.setServer(true);
            newMC.setMEPContext(mc.getMEPContext());
            newMC.setEndpointDescription(mc.getEndpointDescription());
            newMC.setOperationDescription(mc.getOperationDescription());
            return newMC;
        }
        catch (AxisFault e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    public static MessageContext createMinimalResponseMessageContext(MessageContext mc) {
        org.apache.axis2.context.MessageContext sourceAxisMC = mc.getAxisMessageContext();
        MessageContext newMC = new MessageContext(sourceAxisMC);
        newMC.setMEPContext(mc.getMEPContext());
        newMC.setEndpointDescription(mc.getEndpointDescription());
        newMC.setOperationDescription(mc.getOperationDescription());
        return newMC;
    }

    public static MessageContext createFaultMessageContext(MessageContext mc) {
        try {
            org.apache.axis2.context.MessageContext faultMC = MessageContextBuilder.createFaultMessageContext((org.apache.axis2.context.MessageContext)mc.getAxisMessageContext(), null);
            MessageContext jaxwsFaultMC = new MessageContext(faultMC);
            jaxwsFaultMC.setOutbound(true);
            jaxwsFaultMC.setServer(true);
            jaxwsFaultMC.setMEPContext(mc.getMEPContext());
            jaxwsFaultMC.setEndpointDescription(mc.getEndpointDescription());
            jaxwsFaultMC.setOperationDescription(mc.getOperationDescription());
            return jaxwsFaultMC;
        }
        catch (AxisFault e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    public static boolean getJaxwsProviderInterpretNullOneway(MessageContext mc) {
        boolean retval = true;
        org.apache.axis2.context.MessageContext ac = mc.getAxisMessageContext();
        if (ac == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"getJaxwsProviderInterpretNullOneway returns true due to missing MessageContext");
            }
            return retval;
        }
        Boolean providerNullOneway = (Boolean)ac.getProperty("jaxws.provider.interpretNullAsOneway");
        if (providerNullOneway != null) {
            retval = providerNullOneway;
            if (log.isDebugEnabled()) {
                log.debug((Object)("getJaxwsProviderInterpretNullOneway returns " + retval + " per Context property " + "jaxws.provider.interpretNullAsOneway"));
            }
            return retval;
        }
        Parameter p = ac.getParameter("jaxws.provider.interpretNullAsOneway");
        if (p != null) {
            retval = JavaUtils.isTrue((Object)p.getValue());
            if (log.isDebugEnabled()) {
                log.debug((Object)("getJaxwsProviderInterpretNullOneway returns " + retval + " per inspection of Configuration property " + "jaxws.provider.interpretNullAsOneway"));
            }
            return retval;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getJaxwsProviderInterpretNullOneway returns the default value: " + retval));
        }
        return retval;
    }
}

