/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.messaging.qpid;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.entity.java.JavaSoftwareProcessSshDriver;
import org.apache.brooklyn.entity.messaging.qpid.QpidBroker;
import org.apache.brooklyn.entity.messaging.qpid.QpidBrokerImpl;
import org.apache.brooklyn.entity.messaging.qpid.QpidDriver;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QpidSshDriver
extends JavaSoftwareProcessSshDriver
implements QpidDriver {
    private static final Logger log = LoggerFactory.getLogger(QpidSshDriver.class);

    public QpidSshDriver(QpidBrokerImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    protected String getLogFileLocation() {
        return Os.mergePaths((String[])new String[]{this.getRunDir(), "log", "qpid.log"});
    }

    @Override
    public Integer getAmqpPort() {
        return (Integer)this.entity.getAttribute((AttributeSensor)QpidBroker.AMQP_PORT);
    }

    @Override
    public String getAmqpVersion() {
        return (String)this.entity.getAttribute(QpidBroker.AMQP_VERSION);
    }

    public Integer getHttpManagementPort() {
        return (Integer)this.entity.getAttribute((AttributeSensor)QpidBroker.HTTP_MANAGEMENT_PORT);
    }

    public void install() {
        List urls = this.resolver.getTargets();
        String saveAs = this.resolver.getFilename();
        LinkedList<String> commands = new LinkedList<String>();
        commands.addAll(BashCommands.commandsToDownloadUrlsAs((List)urls, (String)saveAs));
        commands.add(BashCommands.INSTALL_TAR);
        commands.add("tar xzfv " + saveAs);
        this.newScript((String)"installing").body.append(commands).execute();
    }

    public void customize() {
        Networking.checkPortsValid((Map)MutableMap.of((Object)"jmxPort", (Object)this.getJmxPort(), (Object)"amqpPort", (Object)this.getAmqpPort()));
        this.newScript((String)"customizing").body.append(new CharSequence[]{String.format("cp -R %s/{bin,etc,lib} .", this.getExpandedInstallDir()), "mkdir lib/opt"}).execute();
    }

    public void launch() {
        this.newScript((Map)ImmutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"launching").body.append((CharSequence)"nohup ./bin/qpid-server -b '*' > qpid-server-launch.log 2>&1 &").execute();
    }

    public String getPidFile() {
        return "qpid-server.pid";
    }

    public boolean isRunning() {
        return this.newScript((Map)ImmutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), "check-running").execute() == 0;
    }

    public void stop() {
        this.newScript((Map)ImmutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), "stopping").execute();
    }

    public void kill() {
        this.newScript((Map)ImmutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), "killing").execute();
    }

    public Map<String, Object> getCustomJavaSystemProperties() {
        return MutableMap.builder().putAll(super.getCustomJavaSystemProperties()).put((Object)"connector.port", (Object)this.getAmqpPort()).put((Object)"management.enabled", (Object)"true").put((Object)"management.jmxport.registryServer", (Object)this.getRmiRegistryPort()).put((Object)"management.jmxport.connectorServer", (Object)this.getJmxPort()).put((Object)"management.http.enabled", (Object)Boolean.toString(this.getHttpManagementPort() != null)).putIfNotNull((Object)"management.http.port", (Object)this.getHttpManagementPort()).build();
    }

    public Map<String, String> getShellEnvironment() {
        return MutableMap.builder().putAll(super.getShellEnvironment()).put((Object)"QPID_HOME", (Object)this.getRunDir()).put((Object)"QPID_WORK", (Object)this.getRunDir()).renameKey((Object)"JAVA_OPTS", (Object)"QPID_OPTS").build();
    }
}

