/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.Job;
import io.fabric8.kubernetes.api.model.extensions.JobFluent;
import io.fabric8.kubernetes.api.model.extensions.JobSpec;
import io.fabric8.kubernetes.api.model.extensions.JobSpecBuilder;
import io.fabric8.kubernetes.api.model.extensions.JobSpecFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.JobStatus;
import io.fabric8.kubernetes.api.model.extensions.JobStatusBuilder;
import io.fabric8.kubernetes.api.model.extensions.JobStatusFluentImpl;

public class JobFluentImpl<A extends JobFluent<A>>
extends BaseFluent<A>
implements JobFluent<A> {
    private String apiVersion;
    private String kind;
    private VisitableBuilder<? extends ObjectMeta, ?> metadata;
    private VisitableBuilder<? extends JobSpec, ?> spec;
    private VisitableBuilder<? extends JobStatus, ?> status;

    public JobFluentImpl() {
    }

    public JobFluentImpl(Job instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public JobFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public JobFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public JobFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public JobFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public JobFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public JobSpec getSpec() {
        return this.spec != null ? (JobSpec)this.spec.build() : null;
    }

    @Override
    public A withSpec(JobSpec spec) {
        this._visitables.remove(this.spec);
        if (spec != null) {
            this.spec = new JobSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (A)this;
    }

    @Override
    public JobFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public JobFluent.SpecNested<A> withNewSpecLike(JobSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public JobFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public JobFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new JobSpecBuilder().build());
    }

    @Override
    public JobFluent.SpecNested<A> editOrNewSpecLike(JobSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    public JobStatus getStatus() {
        return this.status != null ? (JobStatus)this.status.build() : null;
    }

    @Override
    public A withStatus(JobStatus status) {
        this._visitables.remove(this.status);
        if (status != null) {
            this.status = new JobStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (A)this;
    }

    @Override
    public JobFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public JobFluent.StatusNested<A> withNewStatusLike(JobStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public JobFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public JobFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new JobStatusBuilder().build());
    }

    @Override
    public JobFluent.StatusNested<A> editOrNewStatusLike(JobStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JobFluentImpl that = (JobFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public class StatusNestedImpl<N>
    extends JobStatusFluentImpl<JobFluent.StatusNested<N>>
    implements JobFluent.StatusNested<N>,
    Nested<N> {
        private final JobStatusBuilder builder;

        StatusNestedImpl(JobStatus item) {
            this.builder = new JobStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new JobStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)JobFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends JobSpecFluentImpl<JobFluent.SpecNested<N>>
    implements JobFluent.SpecNested<N>,
    Nested<N> {
        private final JobSpecBuilder builder;

        SpecNestedImpl(JobSpec item) {
            this.builder = new JobSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new JobSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)JobFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<JobFluent.MetadataNested<N>>
    implements JobFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)JobFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

