/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sts.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public final class User {
    private final String id;
    private final String arn;

    public static User fromIdAndArn(String id, String arn) {
        return new User(id, arn);
    }

    private User(String id, String arn) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.arn = (String)Preconditions.checkNotNull((Object)arn, (String)"arn for %s", (Object[])new Object[]{id});
    }

    public String getId() {
        return this.id;
    }

    public String getArn() {
        return this.arn;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.arn});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return Objects.equal((Object)this.id, (Object)other.id) && Objects.equal((Object)this.arn, (Object)other.arn);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("arn", (Object)this.arn).toString();
    }
}

