/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.binder.loadbalancer;

import org.jclouds.profitbricks.binder.BaseProfitBricksRequestBinder;
import org.jclouds.profitbricks.domain.LoadBalancer;

public class CreateLoadBalancerRequestBinder
extends BaseProfitBricksRequestBinder<LoadBalancer.Request.CreatePayload> {
    protected final StringBuilder requestBuilder = new StringBuilder(512);

    CreateLoadBalancerRequestBinder() {
        super("loadbalancer");
    }

    @Override
    protected String createPayload(LoadBalancer.Request.CreatePayload payload) {
        this.requestBuilder.append("<ws:createLoadBalancer>").append("<request>").append(String.format("<dataCenterId>%s</dataCenterId>", payload.dataCenterId())).append(String.format("<loadBalancerName>%s</loadBalancerName>", payload.name())).append(String.format("<loadBalancerAlgorithm>%s</loadBalancerAlgorithm>", new Object[]{payload.algorithm()})).append(String.format("<ip>%s</ip>", payload.ip())).append(String.format("<lanId>%s</lanId>", payload.lanId()));
        for (String serverId : payload.serverIds()) {
            this.requestBuilder.append(String.format("<serverIds>%s</serverIds>", serverId));
        }
        this.requestBuilder.append("</request>").append("</ws:createLoadBalancer>");
        return this.requestBuilder.toString();
    }
}

