/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.softlayer.domain.VirtualDiskImage;
import org.jclouds.softlayer.domain.VirtualGuest;

public class VirtualGuestBlockDevice {
    private final int id;
    private final String uuid;
    private final int statusId;
    private final String mountType;
    private final String mountMode;
    private final int bootableFlag;
    private final String device;
    private final VirtualDiskImage diskImage;
    private final VirtualGuest guest;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return VirtualGuestBlockDevice.builder().fromVirtualGuestBlockDevice(this);
    }

    @ConstructorProperties(value={"id", "uuid", "statusId", "mountType", "mountMode", "bootableFlag", "device", "diskImage", "guest"})
    protected VirtualGuestBlockDevice(int id, @Nullable String uuid, int statusId, @Nullable String mountType, @Nullable String mountMode, int bootableFlag, String device, @Nullable VirtualDiskImage diskImage, @Nullable VirtualGuest guest) {
        this.id = id;
        this.uuid = uuid;
        this.statusId = statusId;
        this.mountType = mountType;
        this.mountMode = mountMode;
        this.bootableFlag = bootableFlag;
        this.device = (String)Preconditions.checkNotNull((Object)device, (Object)"device");
        this.diskImage = diskImage;
        this.guest = guest;
    }

    public int getId() {
        return this.id;
    }

    public String getUuid() {
        return this.uuid;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public String getMountType() {
        return this.mountType;
    }

    public String getMountMode() {
        return this.mountMode;
    }

    public int getBootableFlag() {
        return this.bootableFlag;
    }

    public String getDevice() {
        return this.device;
    }

    public VirtualDiskImage getVirtualDiskImage() {
        return this.diskImage;
    }

    public VirtualGuest getVirtualGuest() {
        return this.guest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualGuestBlockDevice that = (VirtualGuestBlockDevice)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.uuid, (Object)that.uuid) && Objects.equal((Object)this.statusId, (Object)that.statusId) && Objects.equal((Object)this.mountType, (Object)that.mountType) && Objects.equal((Object)this.mountMode, (Object)that.mountMode) && Objects.equal((Object)this.bootableFlag, (Object)that.bootableFlag) && Objects.equal((Object)this.device, (Object)that.device) && Objects.equal((Object)this.diskImage, (Object)that.diskImage) && Objects.equal((Object)this.guest, (Object)that.guest);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.uuid, this.statusId, this.mountType, this.mountMode, this.bootableFlag, this.device, this.diskImage, this.guest});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("uuid", (Object)this.uuid).add("statusId", this.statusId).add("mountType", (Object)this.mountType).add("mountMode", (Object)this.mountMode).add("bootableFlag", this.bootableFlag).add("device", (Object)this.device).add("diskImage", (Object)this.diskImage).add("guest", (Object)this.guest).toString();
    }

    public static class Builder {
        protected int id;
        protected String uuid;
        protected int statusId;
        protected String mountType;
        protected String mountMode;
        protected int bootableFlag;
        protected String device;
        protected VirtualDiskImage diskImage;
        protected VirtualGuest guest;

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder statusId(int statusId) {
            this.statusId = statusId;
            return this;
        }

        public Builder mountType(String mountType) {
            this.mountType = mountType;
            return this;
        }

        public Builder mountMode(String mountMode) {
            this.mountMode = mountMode;
            return this;
        }

        public Builder bootableFlag(int bootableFlag) {
            this.bootableFlag = bootableFlag;
            return this;
        }

        public Builder device(String device) {
            this.device = device;
            return this;
        }

        public Builder diskImage(VirtualDiskImage diskImage) {
            this.diskImage = diskImage;
            return this;
        }

        public Builder guest(VirtualGuest guest) {
            this.guest = guest;
            return this;
        }

        public VirtualGuestBlockDevice build() {
            return new VirtualGuestBlockDevice(this.id, this.uuid, this.statusId, this.mountType, this.mountMode, this.bootableFlag, this.device, this.diskImage, this.guest);
        }

        public Builder fromVirtualGuestBlockDevice(VirtualGuestBlockDevice in) {
            return this.id(in.getId()).uuid(in.getUuid()).statusId(in.getStatusId()).mountMode(in.getMountMode()).mountType(in.getMountType()).bootableFlag(in.getBootableFlag()).device(in.getDevice()).diskImage(in.getVirtualDiskImage()).guest(in.getVirtualGuest());
        }
    }
}

