/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Location;

public class TemplateImpl
implements Template {
    private final Image image;
    private final Hardware hardware;
    private final Location location;
    private final TemplateOptions options;

    public TemplateImpl(Image image, Hardware hardware, Location location, TemplateOptions options) {
        this.image = (Image)Preconditions.checkNotNull((Object)image, (Object)"image");
        this.hardware = (Hardware)Preconditions.checkNotNull((Object)hardware, (Object)"hardware");
        this.location = (Location)Preconditions.checkNotNull((Object)location, (Object)"location");
        this.options = (TemplateOptions)Preconditions.checkNotNull((Object)options, (Object)"options");
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    @Override
    public Hardware getHardware() {
        return this.hardware;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public TemplateOptions getOptions() {
        return this.options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateImpl that = (TemplateImpl)TemplateImpl.class.cast(o);
        return Objects.equal((Object)this.image, (Object)that.image) && Objects.equal((Object)this.hardware, (Object)that.hardware) && Objects.equal((Object)this.location, (Object)that.location) && Objects.equal((Object)this.options, (Object)that.options);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.image, this.hardware, this.location, this.options});
    }

    public String toString() {
        return this.string().toString();
    }

    protected MoreObjects.ToStringHelper string() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"").omitNullValues().add("image", (Object)this.image).add("hardware", (Object)this.hardware).add("location", (Object)this.location);
        if (!this.options.equals(this.defaultOptions())) {
            helper.add("options", (Object)this.options);
        }
        return helper;
    }

    protected TemplateOptions defaultOptions() {
        return TemplateOptions.NONE;
    }

    @Override
    public Template clone() {
        return new TemplateImpl(this.image, this.hardware, this.location, this.options.clone());
    }
}

